/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.printer;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.PageSetting;

public class PrintERDiagramOperation
extends PrintGraphicalViewerOperation {
    public PrintERDiagramOperation(Printer p, GraphicalViewer g) {
        super(p, g);
    }

    protected ERDiagram getDiagram() {
        EditPart editPart = this.getViewer().getContents();
        ERDiagram diagram = (ERDiagram)editPart.getModel();
        return diagram;
    }

    public org.eclipse.draw2d.geometry.Rectangle getPrintRegion() {
        ERDiagram diagram = this.getDiagram();
        PageSetting pageSetting = diagram.getPageSetting();
        Rectangle trim = this.getPrinter().computeTrim(0, 0, 0, 0);
        Point printerDPI = this.getPrinter().getDPI();
        Insets notAvailable = new Insets(-trim.y, -trim.x, trim.height + trim.y, trim.width + trim.x);
        Insets userPreferred = new Insets(pageSetting.getTopMargin() * printerDPI.x / 72, pageSetting.getLeftMargin() * printerDPI.x / 72, pageSetting.getBottomMargin() * printerDPI.x / 72, pageSetting.getRightMargin() * printerDPI.x / 72);
        org.eclipse.draw2d.geometry.Rectangle paperBounds = new org.eclipse.draw2d.geometry.Rectangle(this.getPrinter().getBounds());
        org.eclipse.draw2d.geometry.Rectangle printRegion = this.shrink(paperBounds, notAvailable);
        printRegion.intersect(this.shrink(paperBounds, userPreferred));
        printRegion.translate(trim.x, trim.y);
        return printRegion;
    }

    private org.eclipse.draw2d.geometry.Rectangle shrink(org.eclipse.draw2d.geometry.Rectangle bounds, Insets insets) {
        org.eclipse.draw2d.geometry.Rectangle shrinked = bounds.getCopy();
        shrinked.x += insets.left;
        shrinked.y += insets.top;
        shrinked.width -= insets.getWidth();
        shrinked.height -= insets.getHeight();
        return shrinked;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        ERDiagram diagram = this.getDiagram();
        PageSetting pageSetting = diagram.getPageSetting();
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x * (double)pageSetting.getScale() / 100.0;
        org.eclipse.draw2d.geometry.Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        org.eclipse.draw2d.geometry.Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        switch (this.getPrintMode()) {
            case 2: {
                graphics.scale(Math.min(xScale, yScale) * dpiScale);
                break;
            }
            case 3: {
                graphics.scale(xScale * dpiScale);
                break;
            }
            case 4: {
                graphics.scale(yScale * dpiScale);
                break;
            }
            default: {
                graphics.scale(dpiScale);
            }
        }
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }

    /*
     * Unable to fully structure code
     */
    protected void printPages() {
        graphics = this.getFreshPrinterGraphics();
        figure = this.getPrintSource();
        this.setupPrinterGraphicsFor((Graphics)graphics, figure);
        bounds = figure.getBounds();
        x = bounds.x;
        y = bounds.y;
        clipRect = new org.eclipse.draw2d.geometry.Rectangle();
        ** GOTO lbl26
        {
            graphics.pushState();
            this.getPrinter().startPage();
            graphics.translate(-x, -y);
            graphics.getClip(clipRect);
            clipRect.setLocation(x, y);
            graphics.clipRect(clipRect);
            figure.paint((Graphics)graphics);
            this.getPrinter().endPage();
            graphics.popState();
            x += clipRect.width;
            do {
                if (x < bounds.x + bounds.width) continue block0;
                x = bounds.x;
                y += clipRect.height;
lbl26:
                // 2 sources

            } while (y < bounds.y + bounds.height);
        }
    }
}

