/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.contributor;

import java.util.LinkedHashSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.insightech.er.editor.controller.command.common.ChangeFontCommand;
import org.insightech.er.editor.model.ViewableModel;
import org.insightech.er.editor.view.contributor.ComboContributionItem;

public class FontNameContributionItem
extends ComboContributionItem {
    public static final String ID = FontNameContributionItem.class.getName();

    public FontNameContributionItem(IWorkbenchPage workbenchPage) {
        super(ID, workbenchPage);
    }

    protected Command createCommand(ViewableModel viewableModel) {
        return new ChangeFontCommand(viewableModel, this.getText(), viewableModel.getFontSize());
    }

    protected void setData(Combo combo) {
        FontData[] fontDatas = Display.getCurrent().getFontList(null, true);
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        int i = 0;
        while (i < fontDatas.length) {
            if (!fontDatas[i].getName().startsWith("@")) {
                nameSet.add(fontDatas[i].getName());
            }
            ++i;
        }
        for (String name : nameSet) {
            combo.add(name);
        }
    }
}

