/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.dbexport;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.DirectoryText;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.testdata.TestDataCreator;
import org.insightech.er.editor.model.dbexport.testdata.impl.DBUnitFlatXmlTestDataCreator;
import org.insightech.er.editor.model.dbexport.testdata.impl.DBUnitTestDataCreator;
import org.insightech.er.editor.model.dbexport.testdata.impl.DBUnitXLSTestDataCreator;
import org.insightech.er.editor.model.dbexport.testdata.impl.SQLTestDataCreator;
import org.insightech.er.editor.model.settings.export.ExportTestDataSetting;
import org.insightech.er.editor.model.testdata.TestData;
import org.insightech.er.util.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToTestDataDialog
extends AbstractDialog {
    private Table testDataTable;
    private Button formatSqlRadio;
    private Button formatDBUnitRadio;
    private Button formatDBUnitFlatXmlRadio;
    private Button formatDBUnitXlsRadio;
    private DirectoryText outputDirectoryText;
    private Combo fileEncodingCombo;
    private ERDiagram diagram;
    private IEditorPart editorPart;
    private List<TestData> testDataList;
    private int targetIndex;
    private ExportTestDataSetting exportTestDataSetting;

    public ExportToTestDataDialog(Shell parentShell, IEditorPart editorPart, ERDiagram diagram, List<TestData> testDataList, int targetIndex) {
        super(parentShell, 3);
        this.testDataList = testDataList;
        this.targetIndex = targetIndex;
        this.editorPart = editorPart;
        this.diagram = diagram;
        this.exportTestDataSetting = diagram.getDiagramContents().getSettings().getExportSetting().getExportTestDataSetting().clone();
    }

    @Override
    protected void initialize(Composite parent) {
        this.createTestDataTableGroup(parent);
        this.createFormatGroup(parent);
        this.createFileGroup(parent);
    }

    private void createTestDataTableGroup(Composite parent) {
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalSpan = 3;
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 5;
        groupLayout.marginHeight = 5;
        Group group = new Group(parent, 0);
        group.setText(ResourceString.getResourceString("label.testdata.list"));
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)groupLayout);
        this.testDataTable = new Table((Composite)group, 2080);
        GridData tableGridData = new GridData();
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.horizontalSpan = 3;
        tableGridData.heightHint = 80;
        this.testDataTable.setLayoutData((Object)tableGridData);
    }

    private void createFormatGroup(Composite parent) {
        GridData formatGroupGridData = new GridData();
        formatGroupGridData.horizontalAlignment = 4;
        formatGroupGridData.grabExcessHorizontalSpace = true;
        formatGroupGridData.horizontalSpan = 3;
        GridLayout formatGroupLayout = new GridLayout();
        formatGroupLayout.marginWidth = 15;
        formatGroupLayout.marginHeight = 15;
        Group formatGroup = new Group(parent, 0);
        formatGroup.setText(ResourceString.getResourceString("label.format"));
        formatGroup.setLayoutData((Object)formatGroupGridData);
        formatGroup.setLayout((Layout)formatGroupLayout);
        this.formatSqlRadio = CompositeFactory.createRadio(this, (Composite)formatGroup, "label.sql");
        this.formatDBUnitRadio = CompositeFactory.createRadio(this, (Composite)formatGroup, "label.dbunit");
        this.formatDBUnitFlatXmlRadio = CompositeFactory.createRadio(this, (Composite)formatGroup, "label.dbunit.flat.xml");
        this.formatDBUnitXlsRadio = CompositeFactory.createRadio(this, (Composite)formatGroup, "label.dbunit.xls");
    }

    private void createFileGroup(Composite parent) {
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalSpan = 3;
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 5;
        groupLayout.marginHeight = 5;
        groupLayout.numColumns = 3;
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)groupLayout);
        CompositeFactory.createLabel((Composite)group, "label.output.dir");
        this.outputDirectoryText = new DirectoryText((Composite)group, 2048);
        GridData layoutData = new GridData();
        layoutData.widthHint = 200;
        this.outputDirectoryText.setLayoutData(layoutData);
        this.fileEncodingCombo = CompositeFactory.createFileEncodingCombo(this.editorPart, this, (Composite)group, "label.output.file.encoding", 1);
        CompositeFactory.filler((Composite)group, 1);
    }

    @Override
    protected String getErrorMessage() {
        boolean itemChecked = false;
        TableItem[] tableItemArray = this.testDataTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                itemChecked = true;
                break;
            }
            ++n2;
        }
        if (!itemChecked) {
            return "error.testdata.not.selected";
        }
        if (this.outputDirectoryText.isBlank()) {
            return "error.output.dir.is.empty";
        }
        return null;
    }

    @Override
    protected void perfomeOK() throws InputException {
        if (this.formatSqlRadio.getSelection()) {
            this.exportTestDataSetting.setExportFormat(0);
        } else if (this.formatDBUnitRadio.getSelection()) {
            this.exportTestDataSetting.setExportFormat(1);
        } else if (this.formatDBUnitFlatXmlRadio.getSelection()) {
            this.exportTestDataSetting.setExportFormat(2);
        } else if (this.formatDBUnitXlsRadio.getSelection()) {
            this.exportTestDataSetting.setExportFormat(3);
        }
        this.exportTestDataSetting.setExportFilePath(this.outputDirectoryText.getFilePath());
        this.exportTestDataSetting.setExportFileEncoding(this.fileEncodingCombo.getText());
        try {
            int i = 0;
            while (i < this.testDataTable.getItemCount()) {
                TableItem item = this.testDataTable.getItem(i);
                if (item.getChecked()) {
                    ExportToTestDataDialog.exportTestData(this.diagram, this.exportTestDataSetting, this.testDataList.get(i));
                }
                ++i;
            }
            Activator.showMessageDialog("dialog.message.export.finish");
        }
        catch (IOException e) {
            Activator.showExceptionDialog(e);
        }
        this.refreshProject();
    }

    public static void exportTestData(ERDiagram diagram, ExportTestDataSetting exportTestDataSetting, TestData testData) throws IOException, InputException {
        TestDataCreator testDataCreator = null;
        int format = exportTestDataSetting.getExportFormat();
        if (format == 1) {
            testDataCreator = new DBUnitTestDataCreator(exportTestDataSetting.getExportFileEncoding());
        } else if (format == 2) {
            testDataCreator = new DBUnitFlatXmlTestDataCreator(exportTestDataSetting.getExportFileEncoding());
        } else if (format == 0) {
            testDataCreator = new SQLTestDataCreator();
        } else if (format == 3) {
            testDataCreator = new DBUnitXLSTestDataCreator();
        }
        testDataCreator.init(testData);
        File dir = new File(String.valueOf(exportTestDataSetting.getExportFilePath()) + File.separator);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new InputException("error.output.dir.can.not.be.made");
        }
        testDataCreator.write(exportTestDataSetting, diagram);
    }

    @Override
    protected void setData() {
        for (TestData testData : this.testDataList) {
            TableItem tableItem = new TableItem(this.testDataTable, 0);
            tableItem.setText(0, testData.getName());
        }
        if (this.targetIndex >= 0) {
            this.testDataTable.getItem(this.targetIndex).setChecked(true);
        }
        if (this.exportTestDataSetting.getExportFormat() == 1) {
            this.formatDBUnitRadio.setSelection(true);
        } else if (this.exportTestDataSetting.getExportFormat() == 2) {
            this.formatDBUnitFlatXmlRadio.setSelection(true);
        } else if (this.exportTestDataSetting.getExportFormat() == 3) {
            this.formatDBUnitXlsRadio.setSelection(true);
        } else {
            this.formatSqlRadio.setSelection(true);
        }
        String outputDirectoryPath = this.exportTestDataSetting.getExportFilePath();
        if (Check.isEmpty(outputDirectoryPath)) {
            IFile file = ((IFileEditorInput)this.editorPart.getEditorInput()).getFile();
            outputDirectoryPath = file.getLocation().toOSString();
            outputDirectoryPath = String.valueOf(outputDirectoryPath.substring(0, outputDirectoryPath.lastIndexOf(File.separator))) + File.separator + "testdata";
        }
        this.outputDirectoryText.setText(outputDirectoryPath);
        String outputFileEncoding = this.exportTestDataSetting.getExportFileEncoding();
        if (Check.isEmpty(outputFileEncoding)) {
            outputFileEncoding = "UTF-8";
        }
        this.fileEncodingCombo.setText(outputFileEncoding);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ResourceString.getResourceString("label.button.export"), true);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    @Override
    protected String getTitle() {
        return "dialog.title.export.testdata";
    }

    private void refreshProject() {
        IFile file = ((IFileEditorInput)this.editorPart.getEditorInput()).getFile();
        IProject project = file.getProject();
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.showExceptionDialog(e);
        }
    }

    @Override
    protected void addListener() {
        super.addListener();
        this.testDataTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportToTestDataDialog.this.validate();
            }
        });
    }

    public ExportTestDataSetting getExportTestDataSetting() {
        return this.exportTestDataSetting;
    }
}

