/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.dbimport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.StringObjectModel;
import org.insightech.er.editor.view.dialog.dbimport.ViewLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectImportedSchemaDialog
extends AbstractDialog {
    private ContainerCheckedTreeViewer viewer;
    private List<String> schemaList;
    private List<String> selectedSchemaList;
    private List<String> resultSelectedSchemas;
    private String importDB;

    public SelectImportedSchemaDialog(Shell parentShell, ERDiagram diagram, String importDB, List<String> schemaList, List<String> selectedSchemaList) {
        super(parentShell);
        this.schemaList = schemaList;
        this.selectedSchemaList = selectedSchemaList;
        this.resultSelectedSchemas = new ArrayList<String>();
        this.importDB = importDB;
    }

    @Override
    protected void initialize(Composite composite) {
        this.createObjectListComposite(composite);
        this.setListener();
    }

    private void createObjectListComposite(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 20;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.createAllSchemaGroup(composite);
    }

    private void createAllSchemaGroup(Composite composite) {
        GridData gridData = new GridData();
        gridData.heightHint = 300;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.viewer = new ContainerCheckedTreeViewer(composite, 2818);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    private void setListener() {
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectImportedSchemaDialog.this.validate();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.NEXT_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected void perfomeOK() throws InputException {
        Object[] selectedNodes = this.viewer.getCheckedElements();
        this.resultSelectedSchemas.clear();
        int i = 0;
        while (i < selectedNodes.length) {
            Object value = ((TreeNode)selectedNodes[i]).getValue();
            if (value instanceof String) {
                this.resultSelectedSchemas.add((String)value);
            }
            ++i;
        }
    }

    @Override
    protected String getErrorMessage() {
        if (this.viewer.getCheckedElements().length == 0) {
            return "error.import.schema.empty";
        }
        return null;
    }

    @Override
    protected String getTitle() {
        return "dialog.title.select.import.schema";
    }

    @Override
    protected void setData() {
        List<TreeNode> treeNodeList = this.createTreeNodeList();
        TreeNode[] treeNodes = treeNodeList.toArray(new TreeNode[treeNodeList.size()]);
        this.viewer.setInput((Object)treeNodes);
        ArrayList<TreeNode> checkedList = new ArrayList<TreeNode>();
        TreeNode[] schemaNodes = treeNodes[0].getChildren();
        if (this.selectedSchemaList.isEmpty()) {
            TreeNode[] treeNodeArray = schemaNodes;
            int n = schemaNodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode schemaNode = treeNodeArray[n2];
                if (!DBManagerFactory.getDBManager(this.importDB).getSystemSchemaList().contains(String.valueOf(schemaNode.getValue()).toLowerCase())) {
                    checkedList.add(schemaNode);
                }
                ++n2;
            }
        } else {
            TreeNode[] treeNodeArray = schemaNodes;
            int n = schemaNodes.length;
            int n3 = 0;
            while (n3 < n) {
                TreeNode schemaNode = treeNodeArray[n3];
                if (this.selectedSchemaList.contains(schemaNode.getValue())) {
                    checkedList.add(schemaNode);
                }
                ++n3;
            }
        }
        this.viewer.setCheckedElements((Object[])checkedList.toArray(new TreeNode[checkedList.size()]));
        this.viewer.expandAll();
    }

    protected List<TreeNode> createTreeNodeList() {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        TreeNode topNode = new TreeNode((Object)new StringObjectModel(ResourceString.getResourceString("label.schema")));
        treeNodeList.add(topNode);
        ArrayList<TreeNode> schemaNodeList = new ArrayList<TreeNode>();
        for (String schemaName : this.schemaList) {
            TreeNode schemaNode = new TreeNode((Object)schemaName);
            schemaNode.setParent(topNode);
            schemaNodeList.add(schemaNode);
        }
        topNode.setChildren(schemaNodeList.toArray(new TreeNode[schemaNodeList.size()]));
        return treeNodeList;
    }

    public List<String> getSelectedSchemas() {
        return this.resultSelectedSchemas;
    }
}

