/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.editor.view.dialog.element.relation.RelationDialog;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationByExistingColumnsDialog
extends AbstractDialog {
    private static final int COLUMN_WIDTH = 200;
    private Combo columnCombo;
    private Table comparisonTable;
    private ERTable source;
    private RelationDialog.ColumnComboInfo columnComboInfo;
    private List<NormalColumn> candidateForeignKeyColumns;
    private List<NormalColumn> referencedColumnList;
    private List<NormalColumn> foreignKeyColumnList;
    private Map<NormalColumn, List<NormalColumn>> referencedMap;
    private boolean referenceForPK;
    private ComplexUniqueKey referencedComplexUniqueKey;
    private NormalColumn referencedColumn;
    private List<TableEditor> tableEditorList;
    private Map<TableEditor, List<NormalColumn>> editorReferencedMap;
    private Map<Relation, Set<NormalColumn>> foreignKeySetMap;

    public RelationByExistingColumnsDialog(Shell parentShell, ERTable source, List<NormalColumn> candidateForeignKeyColumns, Map<NormalColumn, List<NormalColumn>> referencedMap, Map<Relation, Set<NormalColumn>> foreignKeySetMap) {
        super(parentShell, 2);
        this.source = source;
        this.referencedColumnList = new ArrayList<NormalColumn>();
        this.foreignKeyColumnList = new ArrayList<NormalColumn>();
        this.candidateForeignKeyColumns = candidateForeignKeyColumns;
        this.referencedMap = referencedMap;
        this.foreignKeySetMap = foreignKeySetMap;
        this.tableEditorList = new ArrayList<TableEditor>();
        this.editorReferencedMap = new HashMap<TableEditor, List<NormalColumn>>();
    }

    @Override
    protected void initLayout(GridLayout layout) {
        super.initLayout(layout);
        layout.verticalSpacing = 20;
    }

    @Override
    protected void initialize(Composite composite) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(ResourceString.getResourceString("dialog.message.create.relation.by.existing.columns"));
        this.createColumnCombo(composite);
        this.createComparisonTable(composite);
    }

    private void createColumnCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(ResourceString.getResourceString("label.reference.column"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo = new Combo(composite, 8);
        this.columnCombo.setLayoutData((Object)gridData);
        this.columnCombo.setVisibleItemCount(20);
    }

    private void createComparisonTable(Composite composite) {
        GridData tableGridData = new GridData();
        tableGridData.horizontalSpan = 2;
        tableGridData.heightHint = 100;
        tableGridData.horizontalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        this.comparisonTable = new Table(composite, 67588);
        this.comparisonTable.setLayoutData((Object)tableGridData);
        this.comparisonTable.setHeaderVisible(true);
        this.comparisonTable.setLinesVisible(true);
        TableColumn referencedColumn = new TableColumn(this.comparisonTable, 0);
        referencedColumn.setWidth(200);
        referencedColumn.setText(ResourceString.getResourceString("label.reference.column"));
        TableColumn foreignKeyColumn = new TableColumn(this.comparisonTable, 0);
        foreignKeyColumn.setWidth(200);
        foreignKeyColumn.setText(ResourceString.getResourceString("label.foreign.key"));
    }

    @Override
    protected void setData() {
        this.columnComboInfo = RelationDialog.setReferencedColumnComboData(this.columnCombo, this.source);
        this.columnCombo.select(0);
        this.createComparisonTableRows();
    }

    @Override
    protected void perfomeOK() {
        int index = this.columnCombo.getSelectionIndex();
        if (index < this.columnComboInfo.complexUniqueKeyStartIndex) {
            this.referenceForPK = true;
        } else if (index < this.columnComboInfo.columnStartIndex) {
            ComplexUniqueKey complexUniqueKey;
            this.referencedComplexUniqueKey = complexUniqueKey = this.source.getComplexUniqueKeyList().get(index - this.columnComboInfo.complexUniqueKeyStartIndex);
        } else {
            this.referencedColumn = this.columnComboInfo.candidateColumns.get(index - this.columnComboInfo.columnStartIndex);
        }
        for (TableEditor tableEditor : this.tableEditorList) {
            NormalColumn foreignKeyColumn = this.getSelectedColumn(tableEditor);
            this.foreignKeyColumnList.add(foreignKeyColumn);
        }
    }

    private NormalColumn getSelectedColumn(TableEditor tableEditor) {
        Combo foreignKeyCombo = (Combo)tableEditor.getEditor();
        int foreignKeyComboIndex = foreignKeyCombo.getSelectionIndex();
        int startIndex = 1;
        NormalColumn foreignKeyColumn = null;
        List<NormalColumn> foreignKeyList = this.editorReferencedMap.get(tableEditor);
        if (foreignKeyList != null) {
            if (foreignKeyComboIndex <= foreignKeyList.size()) {
                foreignKeyColumn = foreignKeyList.get(foreignKeyComboIndex - startIndex);
            } else {
                startIndex += foreignKeyList.size();
            }
        }
        if (foreignKeyColumn == null) {
            foreignKeyColumn = this.candidateForeignKeyColumns.get(foreignKeyComboIndex - startIndex);
        }
        return foreignKeyColumn;
    }

    @Override
    protected String getErrorMessage() {
        HashSet<NormalColumn> selectedColumns = new HashSet<NormalColumn>();
        for (TableEditor tableEditor : this.tableEditorList) {
            Combo foreignKeyCombo = (Combo)tableEditor.getEditor();
            int index = foreignKeyCombo.getSelectionIndex();
            if (index == 0) {
                return "error.foreign.key.not.selected";
            }
            NormalColumn selectedColumn = this.getSelectedColumn(tableEditor);
            if (selectedColumns.contains(selectedColumn)) {
                return "error.foreign.key.must.be.different";
            }
            selectedColumns.add(selectedColumn);
        }
        if (this.existForeignKeySet(selectedColumns)) {
            return "error.foreign.key.already.exist";
        }
        return null;
    }

    private boolean existForeignKeySet(Set<NormalColumn> columnSet) {
        boolean exist = false;
        for (Set<NormalColumn> foreignKeySet : this.foreignKeySetMap.values()) {
            if (foreignKeySet.size() != columnSet.size()) continue;
            exist = true;
            for (NormalColumn normalColumn : columnSet) {
                if (foreignKeySet.contains(normalColumn)) continue;
                exist = false;
            }
        }
        return exist;
    }

    @Override
    protected void addListener() {
        super.addListener();
        this.columnCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationByExistingColumnsDialog.this.comparisonTable.removeAll();
                RelationByExistingColumnsDialog.this.disposeTableEditor();
                RelationByExistingColumnsDialog.this.createComparisonTableRows();
                RelationByExistingColumnsDialog.this.validate();
            }
        });
        this.comparisonTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = ((RelationByExistingColumnsDialog)RelationByExistingColumnsDialog.this).columnCombo.getSize().y;
            }
        });
    }

    private void createComparisonTableRows() {
        try {
            int index = this.columnCombo.getSelectionIndex();
            if (index < this.columnComboInfo.complexUniqueKeyStartIndex) {
                this.referencedColumnList = this.source.getPrimaryKeys();
            } else if (index < this.columnComboInfo.columnStartIndex) {
                ComplexUniqueKey complexUniqueKey = this.source.getComplexUniqueKeyList().get(index - this.columnComboInfo.complexUniqueKeyStartIndex);
                this.referencedColumnList = complexUniqueKey.getColumnList();
            } else {
                NormalColumn referencedColumn = this.columnComboInfo.candidateColumns.get(index - this.columnComboInfo.columnStartIndex);
                this.referencedColumnList = new ArrayList<NormalColumn>();
                this.referencedColumnList.add(referencedColumn);
            }
            for (NormalColumn referencedColumn : this.referencedColumnList) {
                this.column2TableItem(referencedColumn);
            }
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }

    private void column2TableItem(NormalColumn referencedColumn) {
        TableItem tableItem = new TableItem(this.comparisonTable, 0);
        tableItem.setText(0, Format.null2blank(referencedColumn.getLogicalName()));
        List<NormalColumn> foreignKeyList = this.referencedMap.get(referencedColumn.getRootReferencedColumn());
        TableEditor tableEditor = new TableEditor(this.comparisonTable);
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)this.createForeignKeyCombo(foreignKeyList), tableItem, 1);
        this.tableEditorList.add(tableEditor);
        this.editorReferencedMap.put(tableEditor, foreignKeyList);
    }

    protected Combo createForeignKeyCombo(List<NormalColumn> foreignKeyList) {
        Combo foreignKeyCombo = CompositeFactory.createReadOnlyCombo(this, (Composite)this.comparisonTable, null);
        foreignKeyCombo.add("");
        if (foreignKeyList != null) {
            for (NormalColumn normalColumn : foreignKeyList) {
                foreignKeyCombo.add(Format.toString(normalColumn.getName()));
            }
        }
        for (NormalColumn normalColumn : this.candidateForeignKeyColumns) {
            foreignKeyCombo.add(Format.toString(normalColumn.getName()));
        }
        if (foreignKeyCombo.getItemCount() > 0) {
            foreignKeyCombo.select(0);
        }
        return foreignKeyCombo;
    }

    public boolean close() {
        this.disposeTableEditor();
        return super.close();
    }

    private void disposeTableEditor() {
        for (TableEditor tableEditor : this.tableEditorList) {
            tableEditor.getEditor().dispose();
            tableEditor.dispose();
        }
        this.tableEditorList.clear();
        this.editorReferencedMap.clear();
    }

    public List<NormalColumn> getReferencedColumnList() {
        return this.referencedColumnList;
    }

    public List<NormalColumn> getForeignKeyColumnList() {
        return this.foreignKeyColumnList;
    }

    public boolean isReferenceForPK() {
        return this.referenceForPK;
    }

    public ComplexUniqueKey getReferencedComplexUniqueKey() {
        return this.referencedComplexUniqueKey;
    }

    public NormalColumn getReferencedColumn() {
        return this.referencedColumn;
    }

    @Override
    protected String getTitle() {
        return "dialog.title.relation";
    }
}

