/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.table.sub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.db.DBManager;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.index.Index;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

public class IndexDialog
extends AbstractDialog {
    private Text nameText;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private org.eclipse.swt.widgets.List allColumnList;
    private Table indexColumnList;
    private List<NormalColumn> selectedColumns;
    private List<NormalColumn> allColumns;
    private ERTable table;
    private Combo typeCombo;
    private Text tableText;
    private Text descriptionText;
    private Button uniqueCheckBox;
    private Button fullTextCheckBox;
    private boolean add;
    private Index targetIndex;
    private Index resultIndex;
    private Map<Column, Button> descCheckBoxMap = new HashMap<Column, Button>();
    private Map<Column, TableEditor> columnCheckMap = new HashMap<Column, TableEditor>();

    public IndexDialog(Shell parentShell, Index targetIndex, ERTable table) {
        super(parentShell);
        this.targetIndex = targetIndex;
        this.table = table;
        this.allColumns = table.getExpandedColumns();
        this.selectedColumns = new ArrayList<NormalColumn>();
    }

    protected void initialize(Composite composite) {
        this.createComposite(composite);
        this.createComposite1(composite);
        this.initializeAllList();
        this.setListener();
        this.nameText.setFocus();
    }

    private void createComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        this.createCheckComposite(composite);
        this.tableText = CompositeFactory.createText(this, composite, "label.table.name", 1, -1, 2056, false);
        this.nameText = CompositeFactory.createText(this, composite, "label.index.name", false);
        this.typeCombo = CompositeFactory.createReadOnlyCombo(this, composite, "label.index.type");
        this.initTypeCombo();
        this.descriptionText = CompositeFactory.createTextArea(this, composite, "label.description", -1, 100, 1, true);
    }

    private void initTypeCombo() {
        List<String> indexTypeList = DBManagerFactory.getDBManager(this.table.getDiagram()).getIndexTypeList(this.table);
        this.typeCombo.add("");
        for (String indexType : indexTypeList) {
            this.typeCombo.add(indexType);
        }
    }

    private void createCheckComposite(Composite composite) {
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.heightHint = 30;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        Composite checkComposite = new Composite(composite, 0);
        checkComposite.setLayoutData((Object)gridData2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        checkComposite.setLayout((Layout)gridLayout);
        this.uniqueCheckBox = new Button(checkComposite, 32);
        this.uniqueCheckBox.setText(ResourceString.getResourceString("label.index.unique"));
        DBManager dbManager = DBManagerFactory.getDBManager(this.table.getDiagram());
        if (dbManager.isSupported(3)) {
            this.fullTextCheckBox = new Button(checkComposite, 32);
            this.fullTextCheckBox.setText(ResourceString.getResourceString("label.index.fulltext"));
        }
    }

    private void createComposite1(Composite parent) {
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        gridLayout2.verticalSpacing = 20;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Composite composite = new Composite(parent, 0);
        this.createGroup(composite);
        composite.setLayout((Layout)gridLayout2);
        composite.setLayoutData((Object)gridData);
        this.addButton = CompositeFactory.createAddButton(composite);
        this.createGroup1(composite);
        this.removeButton = CompositeFactory.createRemoveButton(composite);
    }

    private void createGroup(Composite composite) {
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.verticalSpacing = 5;
        gridLayout4.marginHeight = 10;
        GridData gridData6 = new GridData();
        gridData6.widthHint = 150;
        gridData6.heightHint = 150;
        GridData gridData3 = new GridData();
        gridData3.verticalSpan = 2;
        gridData3.horizontalAlignment = 1;
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)gridData3);
        group.setLayout((Layout)gridLayout4);
        group.setText(ResourceString.getResourceString("label.all.column.list"));
        this.allColumnList = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        this.allColumnList.setLayoutData((Object)gridData6);
    }

    private void createGroup1(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 20;
        gridLayout.marginHeight = 10;
        GridData upButtonGridData = new GridData();
        upButtonGridData.grabExcessHorizontalSpace = false;
        upButtonGridData.verticalAlignment = 3;
        upButtonGridData.grabExcessVerticalSpace = true;
        upButtonGridData.widthHint = 60;
        GridData downButtonGridData = new GridData();
        downButtonGridData.grabExcessVerticalSpace = true;
        downButtonGridData.verticalAlignment = 1;
        downButtonGridData.widthHint = 60;
        GridData gridData4 = new GridData();
        gridData4.verticalSpan = 2;
        Group group = new Group(composite, 0);
        group.setText(ResourceString.getResourceString("label.index.column.list"));
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData4);
        this.initializeIndexColumnList((Composite)group);
        this.upButton = new Button((Composite)group, 0);
        this.upButton.setText(ResourceString.getResourceString("label.up.arrow"));
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button((Composite)group, 0);
        this.downButton.setText(ResourceString.getResourceString("label.down.arrow"));
        this.downButton.setLayoutData((Object)downButtonGridData);
    }

    private void initializeAllList() {
        for (NormalColumn column : this.allColumns) {
            this.allColumnList.add(column.getPhysicalName());
        }
    }

    private void initializeIndexColumnList(Composite parent) {
        GridData gridData = new GridData();
        gridData.heightHint = 150;
        gridData.verticalSpan = 2;
        this.indexColumnList = new Table(parent, 67584);
        this.indexColumnList.setHeaderVisible(true);
        this.indexColumnList.setLayoutData((Object)gridData);
        this.indexColumnList.setLinesVisible(false);
        TableColumn tableColumn = new TableColumn(this.indexColumnList, 0x1000000);
        tableColumn.setWidth(150);
        tableColumn.setText(ResourceString.getResourceString("label.column.name"));
        if (DBManagerFactory.getDBManager(this.table.getDiagram()).isSupported(2)) {
            TableColumn tableColumn1 = new TableColumn(this.indexColumnList, 0x1000000);
            tableColumn1.setWidth(50);
            tableColumn1.setText(ResourceString.getResourceString("label.order.desc"));
        }
    }

    protected void setData() {
        if (this.targetIndex != null && !this.add) {
            int i;
            this.tableText.setText(Format.null2blank(this.targetIndex.getTable().getPhysicalName()));
            this.nameText.setText(this.targetIndex.getName());
            this.descriptionText.setText(Format.null2blank(this.targetIndex.getDescription()));
            if (!Check.isEmpty(this.targetIndex.getType())) {
                boolean selected = false;
                i = 0;
                while (i < this.typeCombo.getItemCount()) {
                    if (this.typeCombo.getItem(i).equals(this.targetIndex.getType())) {
                        this.typeCombo.select(i);
                        selected = true;
                        break;
                    }
                    ++i;
                }
                if (!selected) {
                    this.typeCombo.setText(this.targetIndex.getType());
                }
            }
            List<Boolean> descs = this.targetIndex.getDescs();
            i = 0;
            for (NormalColumn column : this.targetIndex.getColumns()) {
                Boolean desc = Boolean.FALSE;
                if (descs.size() > i && descs.get(i) != null) {
                    desc = descs.get(i);
                }
                this.addIndexColumn(column, desc);
                ++i;
            }
            this.uniqueCheckBox.setSelection(!this.targetIndex.isNonUnique());
            DBManager dbManager = DBManagerFactory.getDBManager(this.table.getDiagram());
            if (dbManager.isSupported(3)) {
                this.fullTextCheckBox.setSelection(this.targetIndex.isFullText());
            }
        }
    }

    private void addIndexColumn(NormalColumn column, Boolean desc) {
        TableItem tableItem = new TableItem(this.indexColumnList, 0);
        tableItem.setText(0, column.getPhysicalName());
        this.setTableEditor(column, tableItem, desc);
        this.selectedColumns.add(column);
    }

    private void setTableEditor(NormalColumn normalColumn, TableItem tableItem, Boolean desc) {
        Button descCheckButton = new Button((Composite)this.indexColumnList, 32);
        descCheckButton.pack();
        if (DBManagerFactory.getDBManager(this.table.getDiagram()).isSupported(2)) {
            TableEditor editor = new TableEditor(this.indexColumnList);
            editor.minimumWidth = descCheckButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)descCheckButton, tableItem, 1);
            this.columnCheckMap.put(normalColumn, editor);
        }
        this.descCheckBoxMap.put(normalColumn, descCheckButton);
        descCheckButton.setSelection(desc.booleanValue());
    }

    private void setListener() {
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = IndexDialog.this.indexColumnList.getSelectionIndex();
                if (index == -1 || index == 0) {
                    return;
                }
                IndexDialog.this.changeColumn(index - 1, index);
                IndexDialog.this.indexColumnList.setSelection(index - 1);
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = IndexDialog.this.indexColumnList.getSelectionIndex();
                if (index == -1 || index == IndexDialog.this.indexColumnList.getItemCount() - 1) {
                    return;
                }
                IndexDialog.this.changeColumn(index, index + 1);
                IndexDialog.this.indexColumnList.setSelection(index + 1);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = IndexDialog.this.allColumnList.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                NormalColumn column = (NormalColumn)IndexDialog.this.allColumns.get(index);
                if (IndexDialog.this.selectedColumns.contains(column)) {
                    return;
                }
                IndexDialog.this.addIndexColumn(column, Boolean.FALSE);
                IndexDialog.this.validate();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = IndexDialog.this.indexColumnList.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                IndexDialog.this.indexColumnList.remove(index);
                NormalColumn column = (NormalColumn)IndexDialog.this.selectedColumns.remove(index);
                IndexDialog.this.descCheckBoxMap.remove(column);
                IndexDialog.this.disposeCheckBox(column);
                int i = index;
                while (i < IndexDialog.this.indexColumnList.getItemCount()) {
                    column = (NormalColumn)IndexDialog.this.selectedColumns.get(i);
                    Button descCheckBox = (Button)IndexDialog.this.descCheckBoxMap.get(column);
                    boolean desc = descCheckBox.getSelection();
                    IndexDialog.this.disposeCheckBox(column);
                    TableItem tableItem = IndexDialog.this.indexColumnList.getItem(i);
                    IndexDialog.this.setTableEditor(column, tableItem, desc);
                    ++i;
                }
                IndexDialog.this.validate();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IndexDialog.this.validate();
            }
        });
    }

    public void changeColumn(int index1, int index2) {
        NormalColumn column1 = this.selectedColumns.remove(index1);
        NormalColumn column2 = null;
        if (index1 < index2) {
            column2 = this.selectedColumns.remove(index2 - 1);
            this.selectedColumns.add(index1, column2);
            this.selectedColumns.add(index2, column1);
        } else if (index1 > index2) {
            column2 = this.selectedColumns.remove(index2);
            this.selectedColumns.add(index1 - 1, column2);
            this.selectedColumns.add(index2, column1);
        }
        boolean desc1 = this.descCheckBoxMap.get(column1).getSelection();
        boolean desc2 = this.descCheckBoxMap.get(column2).getSelection();
        TableItem[] tableItems = this.indexColumnList.getItems();
        this.column2TableItem(column1, desc1, tableItems[index2]);
        this.column2TableItem(column2, desc2, tableItems[index1]);
    }

    private void column2TableItem(NormalColumn column, boolean desc, TableItem tableItem) {
        this.disposeCheckBox(column);
        tableItem.setText(0, column.getPhysicalName());
        this.setTableEditor(column, tableItem, new Boolean(desc));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void perfomeOK() {
        String text = this.nameText.getText();
        this.resultIndex = new Index(this.table, text, !this.uniqueCheckBox.getSelection(), this.typeCombo.getText(), null);
        this.resultIndex.setDescription(this.descriptionText.getText().trim());
        for (NormalColumn selectedColumn : this.selectedColumns) {
            Boolean desc = this.descCheckBoxMap.get(selectedColumn).getSelection();
            this.resultIndex.addColumn(selectedColumn, desc);
        }
        DBManager dbManager = DBManagerFactory.getDBManager(this.table.getDiagram());
        if (dbManager.isSupported(3)) {
            this.resultIndex.setFullText(this.fullTextCheckBox.getSelection());
        }
    }

    public Index getResultIndex() {
        return this.resultIndex;
    }

    protected String getErrorMessage() {
        String text = this.nameText.getText().trim();
        if (text.equals("")) {
            return "error.index.name.empty";
        }
        if (!Check.isAlphabet(text)) {
            return "error.index.name.not.alphabet";
        }
        if (this.indexColumnList.getItemCount() == 0) {
            return "error.index.column.empty";
        }
        DBManager dbManager = DBManagerFactory.getDBManager(this.table.getDiagram());
        if (dbManager.isSupported(3) && this.fullTextCheckBox.getSelection()) {
            for (NormalColumn indexColumn : this.selectedColumns) {
                if (indexColumn.isFullTextIndexable()) continue;
                return "error.index.fulltext.impossible";
            }
        }
        return null;
    }

    protected String getTitle() {
        return "dialog.title.index";
    }

    private void disposeCheckBox(Column column) {
        TableEditor oldEditor = this.columnCheckMap.get(column);
        if (oldEditor != null) {
            if (oldEditor.getEditor() != null) {
                oldEditor.getEditor().dispose();
            }
            oldEditor.dispose();
        }
        this.columnCheckMap.remove(column);
    }
}

