/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.table.tab;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.ResourceString;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.controller.command.diagram_contents.not_element.group.ChangeGroupCommand;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.CopyGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;
import org.insightech.er.editor.view.dialog.common.ERTableComposite;
import org.insightech.er.editor.view.dialog.common.ERTableCompositeHolder;
import org.insightech.er.editor.view.dialog.element.table.TableDialog;
import org.insightech.er.editor.view.dialog.group.GroupManageDialog;
import org.insightech.er.editor.view.dialog.word.column.real.ColumnDialog;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

public class AttributeTabWrapper
extends ValidatableTabWrapper
implements ERTableCompositeHolder {
    private static final int GROUP_TABLE_HEIGHT = 75;
    private ERTable copyData;
    private Text physicalNameText;
    private Text logicalNameText;
    private String oldPhysicalName;
    private Combo groupCombo;
    private Button groupAddButton;
    private Button groupManageButton;
    private TableDialog tableDialog;
    private ERTableComposite tableComposite;
    private ERTableComposite groupTableComposite;

    public AttributeTabWrapper(TableDialog tableDialog, TabFolder parent, int style, ERTable copyData) {
        super(tableDialog, parent, style, "label.table.attribute");
        this.copyData = copyData;
        this.tableDialog = tableDialog;
        this.init();
    }

    public void initComposite() {
        this.setLayout((Layout)new GridLayout());
        this.createHeader(this);
        this.createBody(this);
        this.createFooter(this);
    }

    private void createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 20;
        header.setLayout((Layout)gridLayout);
        this.physicalNameText = CompositeFactory.createText(this.tableDialog, header, "label.physical.name", 1, 200, false);
        this.logicalNameText = CompositeFactory.createText(this.tableDialog, header, "label.logical.name", 1, 200, true);
        this.physicalNameText.setText(Format.null2blank(this.copyData.getPhysicalName()));
        this.logicalNameText.setText(Format.null2blank(this.copyData.getLogicalName()));
        this.oldPhysicalName = this.physicalNameText.getText();
    }

    private void createBody(Composite parent) {
        Composite content = new Composite(parent, 2048);
        GridData contentGridData = new GridData();
        contentGridData.horizontalAlignment = 4;
        contentGridData.grabExcessHorizontalSpace = true;
        content.setLayoutData((Object)contentGridData);
        content.setLayout((Layout)new GridLayout(6, false));
        this.initTable(content);
    }

    private void initTable(Composite parent) {
        ColumnDialog columnDialog = new ColumnDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.copyData);
        this.tableComposite = new ERTableComposite(this, parent, this.copyData.getDiagram(), this.copyData, this.copyData.getColumns(), columnDialog, this.tableDialog, 2, true, true);
    }

    public void validatePage() throws InputException {
        String text = this.logicalNameText.getText().trim();
        this.copyData.setLogicalName(text);
        if (text.equals("")) {
            throw new InputException("error.table.logical.name.empty");
        }
        text = this.physicalNameText.getText().trim();
        if (!Check.isAlphabet(text) && this.copyData.getDiagram().getDiagramContents().getSettings().isValidatePhysicalName()) {
            throw new InputException("error.table.physical.name.not.alphabet");
        }
        this.copyData.setPhysicalName(text);
        boolean needPrimaryKey = false;
        for (Relation relation : this.copyData.getOutgoingRelations()) {
            if (!relation.isReferenceForPK()) continue;
            needPrimaryKey = true;
            break;
        }
        if (needPrimaryKey && this.copyData.getPrimaryKeySize() == 0) {
            throw new InputException("error.primary.key.is.referenced");
        }
    }

    private void createFooter(Composite parent) {
        Composite footer = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        footer.setLayout((Layout)gridLayout);
        this.createGroupCombo(footer);
        this.groupAddButton = new Button(footer, 0);
        this.groupAddButton.setText(ResourceString.getResourceString("label.button.add.group.to.table"));
        this.groupAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = AttributeTabWrapper.this.groupCombo.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                ColumnGroup columnGroup = AttributeTabWrapper.this.getColumnGroups().get(targetIndex);
                AttributeTabWrapper.this.tableComposite.addTableData(columnGroup);
                AttributeTabWrapper.this.groupAddButton.setEnabled(false);
            }
        });
        this.groupAddButton.setEnabled(false);
        this.createGroup(footer);
        this.initGroupCombo();
    }

    private void createGroupCombo(Composite parent) {
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.groupCombo = new Combo(parent, 8);
        this.groupCombo.setLayoutData((Object)gridData);
        this.groupCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = AttributeTabWrapper.this.groupCombo.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                AttributeTabWrapper.this.selectGroup(targetIndex);
            }
        });
    }

    private void initGroupCombo() {
        this.groupCombo.removeAll();
        for (ColumnGroup columnGroup : this.getColumnGroups()) {
            this.groupCombo.add(columnGroup.getGroupName());
        }
        this.groupTableComposite.setColumnList(null);
    }

    private void restructGroup() {
        this.initGroupCombo();
        int index = 0;
        for (Column column : this.copyData.getColumns()) {
            if (column instanceof ColumnGroup && !this.getColumnGroups().contains((ColumnGroup)column)) {
                this.tableComposite.removeColumn(index);
                continue;
            }
            ++index;
        }
        this.tableDialog.validate();
    }

    private void createGroup(Composite parent) {
        GridData gridData1 = new GridData();
        gridData1.heightHint = 100;
        gridData1.widthHint = -1;
        GridData gridData = new GridData();
        gridData.heightHint = -1;
        gridData.horizontalSpan = 4;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)gridData);
        this.groupTableComposite = new ERTableComposite(this, (Composite)group, this.copyData.getDiagram(), null, null, null, null, 2, false, false, 75);
        this.groupManageButton = new Button((Composite)group, 0);
        this.groupManageButton.setText(ResourceString.getResourceString("label.button.group.manage"));
        this.groupManageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupSet groupSet = AttributeTabWrapper.this.getColumnGroups();
                GroupManageDialog dialog = new GroupManageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), groupSet, AttributeTabWrapper.this.copyData.getDiagram(), false, -1);
                if (dialog.open() == 0) {
                    List<CopyGroup> newColumnGroups = dialog.getCopyColumnGroups();
                    ChangeGroupCommand command = new ChangeGroupCommand(AttributeTabWrapper.this.tableDialog.getDiagram(), groupSet, newColumnGroups);
                    AttributeTabWrapper.this.tableDialog.getViewer().getEditDomain().getCommandStack().execute((Command)command);
                    AttributeTabWrapper.this.restructGroup();
                    AttributeTabWrapper.this.groupAddButton.setEnabled(false);
                }
            }
        });
    }

    private GroupSet getColumnGroups() {
        return this.copyData.getDiagram().getDiagramContents().getGroups();
    }

    public void setInitFocus() {
        this.physicalNameText.setFocus();
    }

    public void selectGroup(ColumnGroup selectedColumn) {
        int targetIndex = this.getColumnGroups().indexOf(selectedColumn);
        this.groupCombo.select(targetIndex);
        this.selectGroup(targetIndex);
        this.groupAddButton.setEnabled(false);
    }

    private void selectGroup(int targetIndex) {
        ColumnGroup columnGroup = this.getColumnGroups().get(targetIndex);
        if (this.copyData.getColumns().contains(columnGroup)) {
            this.groupAddButton.setEnabled(false);
        } else {
            this.groupAddButton.setEnabled(true);
        }
        this.groupTableComposite.setColumnList(columnGroup.getColumns());
    }

    public void perfomeOK() {
    }

    protected void addListener() {
        super.addListener();
        this.physicalNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String logicalName = AttributeTabWrapper.this.logicalNameText.getText();
                String physicalName = AttributeTabWrapper.this.physicalNameText.getText();
                if (AttributeTabWrapper.this.oldPhysicalName.equals(logicalName) || logicalName.equals("")) {
                    AttributeTabWrapper.this.logicalNameText.setText(physicalName);
                    AttributeTabWrapper.this.oldPhysicalName = physicalName;
                }
            }
        });
    }
}

