/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.table.tab;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.Activator;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.CopyComplexUniqueKey;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexUniqueKeyTabWrapper
extends ValidatableTabWrapper {
    private ERTable copyData;
    private Text nameText;
    private Combo complexUniqueKeyCombo;
    private Table columnTable;
    private Button addButton;
    private Button updateButton;
    private Button deleteButton;
    private List<TableEditor> tableEditorList;
    private Map<TableEditor, NormalColumn> editorColumnMap;

    public ComplexUniqueKeyTabWrapper(AbstractDialog dialog, TabFolder parent, int style, ERTable copyData) {
        super(dialog, parent, style, "label.complex.unique.key");
        this.copyData = copyData;
        this.tableEditorList = new ArrayList<TableEditor>();
        this.editorColumnMap = new HashMap<TableEditor, NormalColumn>();
        this.init();
    }

    @Override
    public void initComposite() {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.complexUniqueKeyCombo = CompositeFactory.createReadOnlyCombo(null, this, "label.complex.unique.key");
        this.nameText = CompositeFactory.createText(null, this, "label.unique.key.name", false);
        CompositeFactory.filler(this, 1);
        this.columnTable = CompositeFactory.createTable(this, 200, 1);
        CompositeFactory.createTableColumn(this.columnTable, "label.logical.name", 150, 0);
        CompositeFactory.createTableColumn(this.columnTable, "label.unique.key", 70, 0);
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.numColumns = 3;
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayout((Layout)buttonGridLayout);
        this.addButton = CompositeFactory.createButton(buttonComposite, "label.button.add");
        this.updateButton = CompositeFactory.createButton(buttonComposite, "label.button.update");
        this.deleteButton = CompositeFactory.createButton(buttonComposite, "label.button.delete");
    }

    @Override
    public void validatePage() throws InputException {
    }

    @Override
    public void setInitFocus() {
        this.complexUniqueKeyCombo.setFocus();
    }

    public void restruct() {
        this.columnTable.removeAll();
        this.disposeTableEditor();
        for (NormalColumn normalColumn : this.copyData.getNormalColumns()) {
            TableItem tableItem = new TableItem(this.columnTable, 0);
            tableItem.setText(0, Format.null2blank(normalColumn.getName()));
            TableEditor tableEditor = CompositeFactory.createCheckBoxTableEditor(tableItem, false, 1);
            this.tableEditorList.add(tableEditor);
            this.editorColumnMap.put(tableEditor, normalColumn);
        }
        this.setComboData();
        this.setButtonStatus(false);
    }

    public void dispose() {
        this.disposeTableEditor();
        super.dispose();
    }

    private void disposeTableEditor() {
        for (TableEditor tableEditor : this.tableEditorList) {
            tableEditor.getEditor().dispose();
            tableEditor.dispose();
        }
        this.tableEditorList.clear();
        this.editorColumnMap.clear();
    }

    @Override
    protected void addListener() {
        super.addListener();
        this.complexUniqueKeyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComplexUniqueKeyTabWrapper.this.checkSelectedKey();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = ComplexUniqueKeyTabWrapper.this.nameText.getText().trim();
                if (!"".equals(name) && !Check.isAlphabet(name)) {
                    Activator.showErrorDialog("error.unique.key.name.not.alphabet");
                    return;
                }
                ArrayList<NormalColumn> columnList = new ArrayList<NormalColumn>();
                for (TableEditor tableEditor : ComplexUniqueKeyTabWrapper.this.tableEditorList) {
                    Button checkBox = (Button)tableEditor.getEditor();
                    if (!checkBox.getSelection()) continue;
                    columnList.add((NormalColumn)ComplexUniqueKeyTabWrapper.this.editorColumnMap.get(tableEditor));
                }
                if (columnList.isEmpty()) {
                    Activator.showErrorDialog("error.not.checked.complex.unique.key.columns");
                    return;
                }
                if (ComplexUniqueKeyTabWrapper.this.contains(columnList) != null) {
                    Activator.showErrorDialog("error.already.exist.complex.unique.key");
                    return;
                }
                CopyComplexUniqueKey complexUniqueKey = new CopyComplexUniqueKey(new ComplexUniqueKey(name), null);
                complexUniqueKey.setColumnList(columnList);
                ComplexUniqueKeyTabWrapper.this.copyData.getComplexUniqueKeyList().add(complexUniqueKey);
                ComplexUniqueKeyTabWrapper.this.addComboData(complexUniqueKey);
                ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.select(ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.getItemCount() - 1);
                ComplexUniqueKeyTabWrapper.this.setButtonStatus(true);
            }
        });
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                String name = ComplexUniqueKeyTabWrapper.this.nameText.getText().trim();
                if (!Check.isAlphabet(name)) {
                    Activator.showErrorDialog("error.unique.key.name.not.alphabet");
                    return;
                }
                ComplexUniqueKey complexUniqueKey = ComplexUniqueKeyTabWrapper.this.copyData.getComplexUniqueKeyList().get(index);
                ArrayList<NormalColumn> columnList = new ArrayList<NormalColumn>();
                for (TableEditor tableEditor : ComplexUniqueKeyTabWrapper.this.tableEditorList) {
                    Button checkBox = (Button)tableEditor.getEditor();
                    if (!checkBox.getSelection()) continue;
                    columnList.add((NormalColumn)ComplexUniqueKeyTabWrapper.this.editorColumnMap.get(tableEditor));
                }
                if (columnList.isEmpty()) {
                    Activator.showErrorDialog("error.not.checked.complex.unique.key.columns");
                    return;
                }
                ComplexUniqueKey sameKey = ComplexUniqueKeyTabWrapper.this.contains(columnList);
                if (sameKey != null && sameKey != complexUniqueKey) {
                    Activator.showErrorDialog("error.already.exist.complex.unique.key");
                    return;
                }
                complexUniqueKey.setUniqueKeyName(name);
                complexUniqueKey.setColumnList(columnList);
                ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.remove(index);
                ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.add(complexUniqueKey.getLabel(), index);
                ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.select(index);
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.remove(index);
                ComplexUniqueKeyTabWrapper.this.copyData.getComplexUniqueKeyList().remove(index);
                if (index < ComplexUniqueKeyTabWrapper.this.copyData.getComplexUniqueKeyList().size()) {
                    ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.select(index);
                } else {
                    ComplexUniqueKeyTabWrapper.this.complexUniqueKeyCombo.select(index - 1);
                }
                ComplexUniqueKeyTabWrapper.this.checkSelectedKey();
            }
        });
    }

    private void checkSelectedKey() {
        int index = this.complexUniqueKeyCombo.getSelectionIndex();
        ComplexUniqueKey complexUniqueKey = null;
        String name = null;
        if (index != -1) {
            complexUniqueKey = this.copyData.getComplexUniqueKeyList().get(index);
            name = complexUniqueKey.getUniqueKeyName();
            this.setButtonStatus(true);
        } else {
            this.setButtonStatus(false);
        }
        this.nameText.setText(Format.null2blank(name));
        for (TableEditor tableEditor : this.tableEditorList) {
            Button checkbox = (Button)tableEditor.getEditor();
            NormalColumn column = this.editorColumnMap.get(tableEditor);
            if (complexUniqueKey != null && complexUniqueKey.getColumnList().contains(column)) {
                checkbox.setSelection(true);
                continue;
            }
            checkbox.setSelection(false);
        }
    }

    public ComplexUniqueKey contains(List<NormalColumn> columnList) {
        for (ComplexUniqueKey complexUniqueKey : this.copyData.getComplexUniqueKeyList()) {
            if (columnList.size() != complexUniqueKey.getColumnList().size()) continue;
            boolean exist = true;
            for (NormalColumn column : columnList) {
                if (complexUniqueKey.getColumnList().contains(column)) continue;
                exist = false;
                break;
            }
            if (!exist) continue;
            return complexUniqueKey;
        }
        return null;
    }

    private void setComboData() {
        this.complexUniqueKeyCombo.removeAll();
        Iterator<ComplexUniqueKey> iter = this.copyData.getComplexUniqueKeyList().iterator();
        while (iter.hasNext()) {
            ComplexUniqueKey complexUniqueKey = iter.next();
            if (complexUniqueKey.isRemoved(this.copyData.getNormalColumns())) {
                iter.remove();
                continue;
            }
            this.addComboData(complexUniqueKey);
        }
    }

    private void addComboData(ComplexUniqueKey complexUniqueKey) {
        this.complexUniqueKeyCombo.add(complexUniqueKey.getLabel());
    }

    private void setButtonStatus(boolean enabled) {
        if (enabled && this.copyData.getComplexUniqueKeyList().get(this.complexUniqueKeyCombo.getSelectionIndex()).isReferenced(this.copyData)) {
            enabled = false;
        }
        this.updateButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
    }

    @Override
    public void perfomeOK() {
    }
}

