/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.view.View;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;
import org.insightech.er.editor.view.dialog.element.view.tab.AdvancedTabWrapper;
import org.insightech.er.editor.view.dialog.element.view.tab.AttributeTabWrapper;
import org.insightech.er.editor.view.dialog.element.view.tab.DescriptionTabWrapper;
import org.insightech.er.editor.view.dialog.element.view.tab.SqlTabWrapper;

public class ViewDialog
extends AbstractDialog {
    private View copyData;
    private TabFolder tabFolder;
    private EditPartViewer viewer;
    private List<ValidatableTabWrapper> tabWrapperList;

    public ViewDialog(Shell parentShell, EditPartViewer viewer, View copyData, GroupSet columnGroups) {
        super(parentShell);
        this.viewer = viewer;
        this.copyData = copyData;
        this.tabWrapperList = new ArrayList<ValidatableTabWrapper>();
    }

    protected void initialize(Composite composite) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)gridData);
        AttributeTabWrapper attributeTabWrapper = new AttributeTabWrapper(this, this.tabFolder, 0, this.copyData);
        this.tabWrapperList.add(attributeTabWrapper);
        this.tabWrapperList.add(new SqlTabWrapper(this, this.tabFolder, 0, this.copyData));
        this.tabWrapperList.add(new DescriptionTabWrapper((AbstractDialog)this, this.tabFolder, 0, this.copyData));
        this.tabWrapperList.add(new AdvancedTabWrapper((AbstractDialog)this, this.tabFolder, 0, this.copyData));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = ViewDialog.this.tabFolder.getSelectionIndex();
                ValidatableTabWrapper selectedTabWrapper = (ValidatableTabWrapper)((Object)ViewDialog.this.tabWrapperList.get(index));
                selectedTabWrapper.setInitFocus();
            }
        });
        attributeTabWrapper.setInitFocus();
    }

    protected String getErrorMessage() {
        try {
            for (ValidatableTabWrapper tabWrapper : this.tabWrapperList) {
                tabWrapper.validatePage();
            }
        }
        catch (InputException e) {
            return e.getMessage();
        }
        return null;
    }

    protected String getTitle() {
        return "dialog.title.view";
    }

    protected void perfomeOK() throws InputException {
    }

    protected void setData() {
    }

    public EditPartViewer getViewer() {
        return this.viewer;
    }

    public ERDiagram getDiagram() {
        return (ERDiagram)this.viewer.getContents().getModel();
    }
}

