/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.CopyGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;
import org.insightech.er.editor.view.dialog.common.ERTableComposite;
import org.insightech.er.editor.view.dialog.common.ERTableCompositeHolder;
import org.insightech.er.editor.view.dialog.word.column.real.GroupColumnDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDialog
extends AbstractDialog
implements ERTableCompositeHolder {
    private Text groupNameText;
    private List<CopyGroup> copyColumnGroups = new ArrayList<CopyGroup>();
    private int editTargetIndex = -1;
    private CopyGroup copyData;
    private ERDiagram diagram;

    public GroupDialog(Shell parentShell, GroupSet columnGroups, ERDiagram diagram, int editTargetIndex) {
        super(parentShell, 2);
        for (ColumnGroup columnGroup : columnGroups) {
            this.copyColumnGroups.add(new CopyGroup(columnGroup));
        }
        this.diagram = diagram;
        this.editTargetIndex = editTargetIndex;
        if (this.editTargetIndex != -1) {
            this.copyData = this.copyColumnGroups.get(editTargetIndex);
        }
    }

    @Override
    protected void initialize(Composite composite) {
        this.groupNameText = CompositeFactory.createText(this, composite, "label.group.name", 1, 200, true);
        GroupColumnDialog columnDialog = new GroupColumnDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.diagram);
        new ERTableComposite(this, composite, this.diagram, null, this.copyData.getColumns(), columnDialog, this, 2, true, true);
        this.groupNameText.setFocus();
    }

    @Override
    protected String getErrorMessage() {
        String text;
        if (this.groupNameText.getEnabled() && (text = this.groupNameText.getText().trim()).equals("")) {
            return "error.group.name.empty";
        }
        return null;
    }

    @Override
    protected void perfomeOK() {
    }

    @Override
    protected String getTitle() {
        return "dialog.title.group";
    }

    @Override
    protected void setData() {
        if (this.editTargetIndex != -1) {
            String text = this.copyData.getGroupName();
            if (text == null) {
                text = "";
            }
            this.groupNameText.setText(text);
        }
    }

    public List<CopyGroup> getCopyColumnGroups() {
        return this.copyColumnGroups;
    }

    @Override
    public void selectGroup(ColumnGroup selectedColumn) {
    }
}

