/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.CopyGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GlobalGroupSet;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;
import org.insightech.er.editor.view.dialog.common.ERTableComposite;
import org.insightech.er.editor.view.dialog.common.ERTableCompositeHolder;
import org.insightech.er.editor.view.dialog.word.column.real.GroupColumnDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupManageDialog
extends AbstractDialog
implements ERTableCompositeHolder {
    private Text groupNameText;
    private org.eclipse.swt.widgets.List groupList;
    private Button groupUpdateButton;
    private Button groupCancelButton;
    private Button groupAddButton;
    private Button groupEditButton;
    private Button groupDeleteButton;
    private Button addToGlobalGroupButton;
    private List<CopyGroup> copyGroups = new ArrayList<CopyGroup>();
    private int editTargetIndex = -1;
    private CopyGroup copyData;
    private ERDiagram diagram;
    private boolean globalGroup;
    private ERTableComposite tableComposite;
    private static final int HEIGHT = 360;
    private static final int GROUP_LIST_HEIGHT = 230;

    public GroupManageDialog(Shell parentShell, GroupSet columnGroups, ERDiagram diagram, boolean globalGroup, int editTargetIndex) {
        super(parentShell, 2);
        for (ColumnGroup columnGroup : columnGroups) {
            this.copyGroups.add(new CopyGroup(columnGroup));
        }
        this.diagram = diagram;
        this.globalGroup = globalGroup;
        this.editTargetIndex = editTargetIndex;
    }

    @Override
    protected void initialize(Composite composite) {
        this.createGroupListComposite(composite);
        this.createGroupDetailComposite(composite);
        this.setGroupEditEnabled(false);
    }

    private void createGroupListComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        GridData gridData = new GridData();
        gridData.heightHint = 360;
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        this.createGroup(composite);
        this.groupAddButton = new Button(composite, 0);
        this.groupAddButton.setText(ResourceString.getResourceString("label.button.group.add"));
        this.groupEditButton = new Button(composite, 0);
        this.groupEditButton.setText(ResourceString.getResourceString("label.button.group.edit"));
        this.groupDeleteButton = new Button(composite, 0);
        this.groupDeleteButton.setText(ResourceString.getResourceString("label.button.group.delete"));
        this.addToGlobalGroupButton = new Button(composite, 0);
        this.addToGlobalGroupButton.setText(ResourceString.getResourceString("label.button.add.to.global.group"));
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 3;
        this.addToGlobalGroupButton.setLayoutData((Object)gridData3);
        if (this.globalGroup) {
            this.addToGlobalGroupButton.setVisible(false);
        }
        this.setButtonEnabled(false);
    }

    private void createGroupDetailComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.heightHint = 360;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.groupNameText = CompositeFactory.createText(this, composite, "label.group.name", 1, 200, true);
        GroupColumnDialog columnDialog = new GroupColumnDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.diagram);
        this.tableComposite = new ERTableComposite(this, composite, this.diagram, null, null, columnDialog, this, 2, true, true);
        this.createComposite3(composite);
    }

    private void createGroup(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 3;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 200;
        gridData2.horizontalSpan = 3;
        gridData2.heightHint = 230;
        Group group = new Group(parent, 0);
        group.setText(ResourceString.getResourceString("label.group.list"));
        group.setLayoutData((Object)gridData1);
        group.setLayout((Layout)gridLayout);
        this.groupList = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        this.groupList.setLayoutData((Object)gridData2);
        this.initGroupList();
    }

    private void initGroupList() {
        Collections.sort(this.copyGroups);
        this.groupList.removeAll();
        for (ColumnGroup columnGroup : this.copyGroups) {
            this.groupList.add(columnGroup.getGroupName());
        }
    }

    private void initColumnGroup() {
        String text = this.copyData.getGroupName();
        if (text == null) {
            text = "";
        }
        this.groupNameText.setText(text);
        this.tableComposite.setColumnList(this.copyData.getColumns());
    }

    private void setGroupEditEnabled(boolean enabled) {
        this.tableComposite.setEnabled(enabled);
        this.groupUpdateButton.setEnabled(enabled);
        this.groupCancelButton.setEnabled(enabled);
        this.groupNameText.setEnabled(enabled);
        this.groupList.setEnabled(!enabled);
        this.groupAddButton.setEnabled(!enabled);
        if (this.groupList.getSelectionIndex() != -1 && !enabled) {
            this.setButtonEnabled(true);
        } else {
            this.setButtonEnabled(false);
        }
        if (enabled) {
            this.groupNameText.setFocus();
        } else {
            this.groupList.setFocus();
        }
        this.enabledButton(!enabled);
    }

    private void createComposite3(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        GridData gridData1 = new GridData();
        gridData1.widthHint = 80;
        this.groupUpdateButton = new Button(composite, 0);
        this.groupUpdateButton.setText(ResourceString.getResourceString("label.button.update"));
        this.groupUpdateButton.setLayoutData((Object)gridData1);
        this.groupCancelButton = new Button(composite, 0);
        this.groupCancelButton.setText(ResourceString.getResourceString("label.button.cancel"));
        this.groupCancelButton.setLayoutData((Object)gridData1);
    }

    @Override
    protected String getErrorMessage() {
        String text;
        if (this.groupNameText.getEnabled() && (text = this.groupNameText.getText().trim()).equals("")) {
            return "error.group.name.empty";
        }
        return null;
    }

    @Override
    protected void perfomeOK() {
    }

    @Override
    protected String getTitle() {
        if (this.globalGroup) {
            return "dialog.title.manage.global.group";
        }
        return "dialog.title.manage.group";
    }

    @Override
    protected void setData() {
        if (this.editTargetIndex != -1) {
            this.groupList.setSelection(this.editTargetIndex);
            this.copyData = new CopyGroup(this.copyGroups.get(this.editTargetIndex));
            this.initColumnGroup();
            this.setGroupEditEnabled(true);
        }
    }

    public List<CopyGroup> getCopyColumnGroups() {
        return this.copyGroups;
    }

    private void setButtonEnabled(boolean enabled) {
        this.groupEditButton.setEnabled(enabled);
        this.groupDeleteButton.setEnabled(enabled);
        this.addToGlobalGroupButton.setEnabled(enabled);
    }

    @Override
    public void selectGroup(ColumnGroup selectedColumn) {
    }

    @Override
    protected void addListener() {
        super.addListener();
        this.groupAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupManageDialog.this.editTargetIndex = -1;
                GroupManageDialog.this.copyData = new CopyGroup(new ColumnGroup());
                GroupManageDialog.this.initColumnGroup();
                GroupManageDialog.this.setGroupEditEnabled(true);
            }
        });
        this.groupEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.groupList.getSelectionIndex();
                if (GroupManageDialog.this.editTargetIndex == -1) {
                    return;
                }
                GroupManageDialog.this.setGroupEditEnabled(true);
            }
        });
        this.groupDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.groupList.getSelectionIndex();
                if (GroupManageDialog.this.editTargetIndex == -1) {
                    return;
                }
                GroupManageDialog.this.copyGroups.remove(GroupManageDialog.this.editTargetIndex);
                GroupManageDialog.this.initGroupList();
                if (GroupManageDialog.this.copyGroups.size() == 0) {
                    GroupManageDialog.this.editTargetIndex = -1;
                } else if (GroupManageDialog.this.editTargetIndex >= GroupManageDialog.this.copyGroups.size()) {
                    GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.copyGroups.size() - 1;
                }
                if (GroupManageDialog.this.editTargetIndex != -1) {
                    GroupManageDialog.this.groupList.setSelection(GroupManageDialog.this.editTargetIndex);
                    GroupManageDialog.this.copyData = new CopyGroup((ColumnGroup)GroupManageDialog.this.copyGroups.get(GroupManageDialog.this.editTargetIndex));
                    GroupManageDialog.this.initColumnGroup();
                } else {
                    GroupManageDialog.this.copyData = new CopyGroup(new ColumnGroup());
                    GroupManageDialog.this.initColumnGroup();
                    GroupManageDialog.this.setButtonEnabled(false);
                }
            }
        });
        this.addToGlobalGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.groupList.getSelectionIndex();
                if (GroupManageDialog.this.editTargetIndex == -1) {
                    return;
                }
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 292);
                messageBox.setText(ResourceString.getResourceString("label.button.add.to.global.group"));
                messageBox.setMessage(ResourceString.getResourceString("dialog.message.add.to.global.group"));
                if (messageBox.open() == 32) {
                    CopyGroup columnGroup = (CopyGroup)GroupManageDialog.this.copyGroups.get(GroupManageDialog.this.editTargetIndex);
                    GroupSet columnGroups = GlobalGroupSet.load();
                    columnGroups.add(columnGroup);
                    GlobalGroupSet.save(columnGroups);
                }
            }
        });
        this.groupList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.groupList.getSelectionIndex();
                if (GroupManageDialog.this.editTargetIndex == -1) {
                    return;
                }
                GroupManageDialog.this.setGroupEditEnabled(true);
            }
        });
        this.groupList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GroupManageDialog.this.editTargetIndex = GroupManageDialog.this.groupList.getSelectionIndex();
                    if (GroupManageDialog.this.editTargetIndex == -1) {
                        return;
                    }
                    GroupManageDialog.this.copyData = new CopyGroup((ColumnGroup)GroupManageDialog.this.copyGroups.get(GroupManageDialog.this.editTargetIndex));
                    GroupManageDialog.this.initColumnGroup();
                    GroupManageDialog.this.setButtonEnabled(true);
                }
                catch (Exception ex) {
                    Activator.showExceptionDialog(ex);
                }
            }
        });
        this.groupUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block6: {
                    try {
                        if (!GroupManageDialog.this.validate()) break block6;
                        String text = GroupManageDialog.this.groupNameText.getText().trim();
                        GroupManageDialog.this.copyData.setGroupName(text);
                        if (GroupManageDialog.this.editTargetIndex == -1) {
                            GroupManageDialog.this.copyGroups.add(GroupManageDialog.this.copyData);
                        } else {
                            GroupManageDialog.this.copyGroups.remove(GroupManageDialog.this.editTargetIndex);
                            GroupManageDialog.this.copyData = (CopyGroup)GroupManageDialog.this.copyData.restructure(null);
                            GroupManageDialog.this.copyGroups.add(GroupManageDialog.this.editTargetIndex, GroupManageDialog.this.copyData);
                        }
                        GroupManageDialog.this.setGroupEditEnabled(false);
                        GroupManageDialog.this.initGroupList();
                        int i = 0;
                        while (i < GroupManageDialog.this.copyGroups.size()) {
                            ColumnGroup columnGroup = (ColumnGroup)GroupManageDialog.this.copyGroups.get(i);
                            if (columnGroup == GroupManageDialog.this.copyData) {
                                GroupManageDialog.this.groupList.setSelection(i);
                                GroupManageDialog.this.copyData = new CopyGroup((ColumnGroup)GroupManageDialog.this.copyGroups.get(i));
                                GroupManageDialog.this.initColumnGroup();
                                GroupManageDialog.this.setButtonEnabled(true);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        Activator.showExceptionDialog(ex);
                    }
                }
            }
        });
        this.groupCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupManageDialog.this.setGroupEditEnabled(false);
                if (GroupManageDialog.this.editTargetIndex != -1) {
                    GroupManageDialog.this.copyData = new CopyGroup((ColumnGroup)GroupManageDialog.this.copyGroups.get(GroupManageDialog.this.editTargetIndex));
                    GroupManageDialog.this.initColumnGroup();
                }
            }
        });
    }
}

