/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.option;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.ListenerAppender;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.view.dialog.option.tab.AdvancedTabWrapper;
import org.insightech.er.editor.view.dialog.option.tab.DBSelectTabWrapper;
import org.insightech.er.editor.view.dialog.option.tab.EnvironmentTabWrapper;
import org.insightech.er.editor.view.dialog.option.tab.OptionTabWrapper;

public class OptionSettingDialog
extends AbstractDialog {
    private TabFolder tabFolder;
    private List<ValidatableTabWrapper> tabWrapperList;
    private Settings settings;
    private ERDiagram diagram;

    public OptionSettingDialog(Shell parentShell, Settings settings, ERDiagram diagram) {
        super(parentShell);
        this.diagram = diagram;
        this.settings = settings;
        this.tabWrapperList = new ArrayList<ValidatableTabWrapper>();
    }

    protected void initialize(Composite composite) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)gridData);
        this.tabWrapperList.add(new DBSelectTabWrapper(this, this.tabFolder, 0, this.settings));
        this.tabWrapperList.add(new EnvironmentTabWrapper(this, this.tabFolder, 0, this.settings));
        this.tabWrapperList.add(new AdvancedTabWrapper(this, this.tabFolder, 0, this.settings, this.diagram));
        this.tabWrapperList.add(new OptionTabWrapper(this, this.tabFolder, 0, this.settings));
        ListenerAppender.addTabListener(this.tabFolder, this.tabWrapperList);
        this.tabWrapperList.get(0).setInitFocus();
    }

    protected String getErrorMessage() {
        try {
            for (ValidatableTabWrapper tabWrapper : this.tabWrapperList) {
                tabWrapper.validatePage();
            }
        }
        catch (InputException e) {
            return e.getMessage();
        }
        return null;
    }

    protected String getTitle() {
        return "dialog.title.option";
    }

    protected void perfomeOK() throws InputException {
    }

    protected void setData() {
    }

    public void initTab() {
        for (ValidatableTabWrapper tabWrapper : this.tabWrapperList) {
            tabWrapper.reset();
        }
    }
}

