/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.option.tab;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.settings.Environment;
import org.insightech.er.editor.model.settings.Settings;
import org.insightech.er.editor.view.dialog.option.OptionSettingDialog;
import org.insightech.er.util.Check;

public class EnvironmentTabWrapper
extends ValidatableTabWrapper {
    private List environmentList;
    private Text nameText;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Settings settings;
    private static final int LIST_HEIGHT = 230;

    public EnvironmentTabWrapper(OptionSettingDialog dialog, TabFolder parent, int style, Settings settings) {
        super(dialog, parent, style, "label.tablespace.environment");
        this.settings = settings;
        this.init();
    }

    public void initComposite() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.createEnvironmentGroup(this);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)gridData);
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 60;
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setLayoutData((Object)buttonGridData);
        this.addButton.setText(ResourceString.getResourceString("label.button.add"));
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setLayoutData((Object)buttonGridData);
        this.editButton.setText(ResourceString.getResourceString("label.button.edit"));
        this.deleteButton = new Button((Composite)this, 0);
        this.deleteButton.setLayoutData((Object)buttonGridData);
        this.deleteButton.setText(ResourceString.getResourceString("label.button.delete"));
        this.buttonEnabled(false);
        this.addButton.setEnabled(false);
    }

    private void createEnvironmentGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        gridData.heightHint = 230;
        this.environmentList = new List(parent, 2560);
        this.environmentList.setLayoutData((Object)gridData);
    }

    protected void addListener() {
        this.environmentList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = EnvironmentTabWrapper.this.environmentList.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                Environment environment = EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().get(targetIndex);
                EnvironmentTabWrapper.this.nameText.setText(environment.getName());
                EnvironmentTabWrapper.this.buttonEnabled(true);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = EnvironmentTabWrapper.this.nameText.getText().trim();
                if (!Check.isEmpty(name)) {
                    EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().add(new Environment(name));
                    EnvironmentTabWrapper.this.setData();
                    EnvironmentTabWrapper.this.environmentList.select(EnvironmentTabWrapper.this.environmentList.getItemCount() - 1);
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = EnvironmentTabWrapper.this.environmentList.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                String name = EnvironmentTabWrapper.this.nameText.getText().trim();
                if (!Check.isEmpty(name)) {
                    Environment environment = EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().get(targetIndex);
                    environment.setName(name);
                    EnvironmentTabWrapper.this.setData();
                    EnvironmentTabWrapper.this.environmentList.select(targetIndex);
                }
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = EnvironmentTabWrapper.this.environmentList.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().remove(targetIndex);
                EnvironmentTabWrapper.this.setData();
                if (EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().size() > targetIndex) {
                    EnvironmentTabWrapper.this.environmentList.select(targetIndex);
                    Environment environment = EnvironmentTabWrapper.this.settings.getEnvironmentSetting().getEnvironments().get(targetIndex);
                    EnvironmentTabWrapper.this.nameText.setText(environment.getName());
                } else {
                    EnvironmentTabWrapper.this.nameText.setText("");
                    EnvironmentTabWrapper.this.buttonEnabled(false);
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = EnvironmentTabWrapper.this.nameText.getText().trim();
                if (name.length() == 0) {
                    EnvironmentTabWrapper.this.addButton.setEnabled(false);
                    EnvironmentTabWrapper.this.editButton.setEnabled(false);
                } else {
                    EnvironmentTabWrapper.this.addButton.setEnabled(true);
                    if (EnvironmentTabWrapper.this.environmentList.getSelectionIndex() != -1) {
                        EnvironmentTabWrapper.this.editButton.setEnabled(true);
                    } else {
                        EnvironmentTabWrapper.this.editButton.setEnabled(false);
                    }
                }
            }
        });
    }

    private void buttonEnabled(boolean enabled) {
        this.editButton.setEnabled(enabled);
        if (this.environmentList.getItemCount() <= 1) {
            enabled = false;
        }
        this.deleteButton.setEnabled(enabled);
    }

    public void validatePage() throws InputException {
    }

    public void setInitFocus() {
        this.environmentList.setFocus();
    }

    protected void setData() {
        super.setData();
        this.environmentList.removeAll();
        for (Environment environment : this.settings.getEnvironmentSetting().getEnvironments()) {
            this.environmentList.add(environment.getName());
        }
    }

    public void perfomeOK() {
    }
}

