/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.controller.command.common.ReplaceCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.search.ReplaceManager;
import org.insightech.er.editor.model.search.SearchManager;
import org.insightech.er.editor.model.search.SearchResult;
import org.insightech.er.editor.model.search.SearchResultRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDialog
extends Dialog {
    public static final int REPLACE_ID = 100;
    public static final int SEARCH_ALL_ID = 101;
    public static final int SEARCH_NEXT_ID = 102;
    private Button allCheckBox;
    private Button wordCheckBox;
    private Button physicalWordNameCheckBox;
    private Button logicalWordNameCheckBox;
    private Button wordTypeCheckBox;
    private Button wordLengthCheckBox;
    private Button wordDecimalCheckBox;
    private Button wordDescriptionCheckBox;
    private Button tableCheckBox;
    private Button physicalTableNameCheckBox;
    private Button logicalTableNameCheckBox;
    private Button physicalColumnNameCheckBox;
    private Button logicalColumnNameCheckBox;
    private Button columnTypeCheckBox;
    private Button columnLengthCheckBox;
    private Button columnDecimalCheckBox;
    private Button columnDefaultValueCheckBox;
    private Button columnDescriptionCheckBox;
    private Button columnGroupNameCheckBox;
    private Button groupCheckBox;
    private Button groupNameCheckBox;
    private Button physicalGroupColumnNameCheckBox;
    private Button logicalGroupColumnNameCheckBox;
    private Button groupColumnTypeCheckBox;
    private Button groupColumnLengthCheckBox;
    private Button groupColumnDecimalCheckBox;
    private Button groupColumnDefaultValueCheckBox;
    private Button groupColumnDescriptionCheckBox;
    private Button modelPropertiesCheckBox;
    private Button indexCheckBox;
    private Button relationCheckBox;
    private Button noteCheckBox;
    private Combo keywordCombo;
    private Combo replaceCombo;
    private Table resultTable;
    private GraphicalViewer viewer;
    private ERDiagram diagram;
    private SearchManager searchManager;
    private SearchResult searchResult;
    private boolean all;
    private TabFolder tabFolder;

    public SearchDialog(Shell parentShell, GraphicalViewer viewer, ERDiagram diagram) {
        super(parentShell);
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
        this.viewer = viewer;
        this.diagram = diagram;
        this.searchManager = new SearchManager(this.diagram);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(ResourceString.getResourceString("dialog.title.search"));
        Composite composite = null;
        composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        this.initialize(composite);
        return composite;
    }

    private void initialize(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 15;
        this.createKeywordCombo(parent);
        this.createReplaceCombo(parent);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)gridData);
        this.createRegionGroup(this.tabFolder);
        this.createResultGroup(this.tabFolder);
        parent.setLayout((Layout)gridLayout);
        this.selectAllCheckBox(true);
    }

    private void createRegionGroup(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ResourceString.getResourceString("label.search.range"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        Composite group = new Composite((Composite)tabFolder, 0);
        group.setLayout((Layout)gridLayout);
        this.allCheckBox = new Button(group, 32);
        this.allCheckBox.setText(ResourceString.getResourceString("label.search.range.all"));
        GridData allCheckBoxGridData = new GridData();
        allCheckBoxGridData.horizontalAlignment = 4;
        allCheckBoxGridData.horizontalSpan = 3;
        allCheckBoxGridData.grabExcessHorizontalSpace = true;
        this.allCheckBox.setLayoutData((Object)allCheckBoxGridData);
        this.allCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.selectAllCheckBox(SearchDialog.this.allCheckBox.getSelection());
            }
        });
        this.wordCheckBox = new Button(group, 32);
        this.wordCheckBox.setText(ResourceString.getResourceString("label.search.range.word"));
        this.wordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.selectWordCheckBox(SearchDialog.this.wordCheckBox.getSelection());
            }
        });
        this.createWordCheckboxGroup(group);
        this.tableCheckBox = new Button(group, 32);
        this.tableCheckBox.setText(ResourceString.getResourceString("label.search.range.table"));
        this.tableCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.selectTableCheckBox(SearchDialog.this.tableCheckBox.getSelection());
            }
        });
        this.createTableCheckboxGroup(group);
        this.groupCheckBox = new Button(group, 32);
        this.groupCheckBox.setText(ResourceString.getResourceString("label.search.range.group"));
        this.groupCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.selectGroupCheckBox(SearchDialog.this.groupCheckBox.getSelection());
            }
        });
        this.createGroupCheckboxGroup(group);
        this.modelPropertiesCheckBox = new Button(group, 32);
        this.modelPropertiesCheckBox.setText(ResourceString.getResourceString("label.search.range.model.property"));
        this.indexCheckBox = new Button(group, 32);
        this.indexCheckBox.setText(ResourceString.getResourceString("label.search.range.index"));
        this.relationCheckBox = new Button(group, 32);
        this.relationCheckBox.setText(ResourceString.getResourceString("label.search.range.relation"));
        this.noteCheckBox = new Button(group, 32);
        this.noteCheckBox.setText(ResourceString.getResourceString("label.search.range.note"));
        tabItem.setControl((Control)group);
    }

    private void createWordCheckboxGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.physicalWordNameCheckBox = new Button((Composite)group, 32);
        this.physicalWordNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.28"));
        this.logicalWordNameCheckBox = new Button((Composite)group, 32);
        this.logicalWordNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.29"));
        this.wordTypeCheckBox = new Button((Composite)group, 32);
        this.wordTypeCheckBox.setText(ResourceString.getResourceString("search.result.row.name.30"));
        this.wordLengthCheckBox = new Button((Composite)group, 32);
        this.wordLengthCheckBox.setText(ResourceString.getResourceString("search.result.row.name.31"));
        this.wordDecimalCheckBox = new Button((Composite)group, 32);
        this.wordDecimalCheckBox.setText(ResourceString.getResourceString("search.result.row.name.32"));
        this.wordDescriptionCheckBox = new Button((Composite)group, 32);
        this.wordDescriptionCheckBox.setText(ResourceString.getResourceString("search.result.row.name.33"));
    }

    private void createTableCheckboxGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.physicalTableNameCheckBox = new Button((Composite)group, 32);
        this.physicalTableNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.11"));
        this.logicalTableNameCheckBox = new Button((Composite)group, 32);
        this.logicalTableNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.12"));
        this.columnGroupNameCheckBox = new Button((Composite)group, 32);
        this.columnGroupNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.20"));
        new Label((Composite)group, 0);
        this.physicalColumnNameCheckBox = new Button((Composite)group, 32);
        this.physicalColumnNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.13"));
        this.logicalColumnNameCheckBox = new Button((Composite)group, 32);
        this.logicalColumnNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.14"));
        this.columnTypeCheckBox = new Button((Composite)group, 32);
        this.columnTypeCheckBox.setText(ResourceString.getResourceString("search.result.row.name.15"));
        this.columnLengthCheckBox = new Button((Composite)group, 32);
        this.columnLengthCheckBox.setText(ResourceString.getResourceString("search.result.row.name.16"));
        this.columnDecimalCheckBox = new Button((Composite)group, 32);
        this.columnDecimalCheckBox.setText(ResourceString.getResourceString("search.result.row.name.17"));
        this.columnDefaultValueCheckBox = new Button((Composite)group, 32);
        this.columnDefaultValueCheckBox.setText(ResourceString.getResourceString("search.result.row.name.18"));
        this.columnDescriptionCheckBox = new Button((Composite)group, 32);
        this.columnDescriptionCheckBox.setText(ResourceString.getResourceString("search.result.row.name.19"));
    }

    private void createGroupCheckboxGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        this.groupNameCheckBox = new Button((Composite)group, 32);
        this.groupNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.20"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        this.physicalGroupColumnNameCheckBox = new Button((Composite)group, 32);
        this.physicalGroupColumnNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.13"));
        this.logicalGroupColumnNameCheckBox = new Button((Composite)group, 32);
        this.logicalGroupColumnNameCheckBox.setText(ResourceString.getResourceString("search.result.row.name.14"));
        this.groupColumnTypeCheckBox = new Button((Composite)group, 32);
        this.groupColumnTypeCheckBox.setText(ResourceString.getResourceString("search.result.row.name.15"));
        this.groupColumnLengthCheckBox = new Button((Composite)group, 32);
        this.groupColumnLengthCheckBox.setText(ResourceString.getResourceString("search.result.row.name.16"));
        this.groupColumnDecimalCheckBox = new Button((Composite)group, 32);
        this.groupColumnDecimalCheckBox.setText(ResourceString.getResourceString("search.result.row.name.17"));
        this.groupColumnDefaultValueCheckBox = new Button((Composite)group, 32);
        this.groupColumnDefaultValueCheckBox.setText(ResourceString.getResourceString("search.result.row.name.18"));
        this.groupColumnDescriptionCheckBox = new Button((Composite)group, 32);
        this.groupColumnDescriptionCheckBox.setText(ResourceString.getResourceString("search.result.row.name.19"));
    }

    private void selectAllCheckBox(boolean checked) {
        this.allCheckBox.setSelection(checked);
        this.selectWordCheckBox(checked);
        this.wordCheckBox.setEnabled(!checked);
        this.selectTableCheckBox(checked);
        this.tableCheckBox.setEnabled(!checked);
        this.modelPropertiesCheckBox.setSelection(checked);
        this.modelPropertiesCheckBox.setEnabled(!checked);
        this.indexCheckBox.setSelection(checked);
        this.indexCheckBox.setEnabled(!checked);
        this.relationCheckBox.setSelection(checked);
        this.relationCheckBox.setEnabled(!checked);
        this.noteCheckBox.setSelection(checked);
        this.noteCheckBox.setEnabled(!checked);
        this.selectGroupCheckBox(checked);
        this.groupCheckBox.setEnabled(!checked);
    }

    private void selectWordCheckBox(boolean checked) {
        this.wordCheckBox.setSelection(checked);
        this.physicalWordNameCheckBox.setSelection(checked);
        this.logicalWordNameCheckBox.setSelection(checked);
        this.wordTypeCheckBox.setSelection(checked);
        this.wordLengthCheckBox.setSelection(checked);
        this.wordDecimalCheckBox.setSelection(checked);
        this.wordDescriptionCheckBox.setSelection(checked);
        this.physicalWordNameCheckBox.setEnabled(!checked);
        this.logicalWordNameCheckBox.setEnabled(!checked);
        this.wordTypeCheckBox.setEnabled(!checked);
        this.wordLengthCheckBox.setEnabled(!checked);
        this.wordDecimalCheckBox.setEnabled(!checked);
        this.wordDescriptionCheckBox.setEnabled(!checked);
    }

    private void selectTableCheckBox(boolean checked) {
        this.tableCheckBox.setSelection(checked);
        this.physicalTableNameCheckBox.setSelection(checked);
        this.logicalTableNameCheckBox.setSelection(checked);
        this.physicalColumnNameCheckBox.setSelection(checked);
        this.logicalColumnNameCheckBox.setSelection(checked);
        this.columnTypeCheckBox.setSelection(checked);
        this.columnLengthCheckBox.setSelection(checked);
        this.columnDecimalCheckBox.setSelection(checked);
        this.columnDefaultValueCheckBox.setSelection(checked);
        this.columnDescriptionCheckBox.setSelection(checked);
        this.columnGroupNameCheckBox.setSelection(checked);
        this.physicalTableNameCheckBox.setEnabled(!checked);
        this.logicalTableNameCheckBox.setEnabled(!checked);
        this.physicalColumnNameCheckBox.setEnabled(!checked);
        this.logicalColumnNameCheckBox.setEnabled(!checked);
        this.columnTypeCheckBox.setEnabled(!checked);
        this.columnLengthCheckBox.setEnabled(!checked);
        this.columnDecimalCheckBox.setEnabled(!checked);
        this.columnDefaultValueCheckBox.setEnabled(!checked);
        this.columnDescriptionCheckBox.setEnabled(!checked);
        this.columnGroupNameCheckBox.setEnabled(!checked);
    }

    private void selectGroupCheckBox(boolean checked) {
        this.groupCheckBox.setSelection(checked);
        this.groupNameCheckBox.setSelection(checked);
        this.physicalGroupColumnNameCheckBox.setSelection(checked);
        this.logicalGroupColumnNameCheckBox.setSelection(checked);
        this.groupColumnTypeCheckBox.setSelection(checked);
        this.groupColumnLengthCheckBox.setSelection(checked);
        this.groupColumnDecimalCheckBox.setSelection(checked);
        this.groupColumnDefaultValueCheckBox.setSelection(checked);
        this.groupColumnDescriptionCheckBox.setSelection(checked);
        this.groupNameCheckBox.setEnabled(!checked);
        this.physicalGroupColumnNameCheckBox.setEnabled(!checked);
        this.logicalGroupColumnNameCheckBox.setEnabled(!checked);
        this.groupColumnTypeCheckBox.setEnabled(!checked);
        this.groupColumnLengthCheckBox.setEnabled(!checked);
        this.groupColumnDecimalCheckBox.setEnabled(!checked);
        this.groupColumnDefaultValueCheckBox.setEnabled(!checked);
        this.groupColumnDescriptionCheckBox.setEnabled(!checked);
    }

    private void createKeywordCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(ResourceString.getResourceString("label.search.keyword"));
        GridData fillerGridData = new GridData();
        fillerGridData.widthHint = 10;
        label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)fillerGridData);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.keywordCombo = new Combo(parent, 0);
        this.keywordCombo.setLayoutData((Object)gridData);
        this.keywordCombo.setVisibleItemCount(20);
        this.initKeywordCombo();
    }

    private void createReplaceCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(ResourceString.getResourceString("label.search.replace.word"));
        GridData fillerGridData = new GridData();
        fillerGridData.widthHint = 10;
        label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)fillerGridData);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.replaceCombo = new Combo(parent, 0);
        this.replaceCombo.setLayoutData((Object)gridData);
        this.replaceCombo.setVisibleItemCount(20);
        this.initReplaceWordCombo();
    }

    private void initKeywordCombo() {
        this.keywordCombo.removeAll();
        for (String str : SearchManager.getKeywordList()) {
            this.keywordCombo.add(str);
        }
    }

    private void initReplaceWordCombo() {
        this.replaceCombo.removeAll();
        for (String str : ReplaceManager.getReplaceWordList()) {
            this.replaceCombo.add(str);
        }
    }

    private void createResultGroup(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(ResourceString.getResourceString("label.search.result"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        Composite resultGroup = new Composite((Composite)tabFolder, 0);
        resultGroup.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.widthHint = -1;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        this.resultTable = new Table(resultGroup, 67586);
        this.resultTable.setHeaderVisible(true);
        this.resultTable.setLayoutData((Object)gridData);
        this.resultTable.setLinesVisible(true);
        this.resultTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SearchDialog.this.resultTable.getSelectionIndex();
                SearchResultRow searchResultRow = SearchDialog.this.searchResult.getRows().get(index);
                Object object = searchResultRow.getTargetNode();
                if (object != null) {
                    SearchDialog.this.focus(object);
                }
            }
        });
        TableColumn tableColumn0 = new TableColumn(this.resultTable, 16384);
        tableColumn0.setWidth(250);
        tableColumn0.setText(ResourceString.getResourceString("label.search.result.table.path"));
        tableColumn0.addSelectionListener((SelectionListener)new SearchResultSortListener(1));
        TableColumn tableColumn1 = new TableColumn(this.resultTable, 16384);
        tableColumn1.setWidth(100);
        tableColumn1.setText(ResourceString.getResourceString("label.search.result.table.type"));
        tableColumn1.addSelectionListener((SelectionListener)new SearchResultSortListener(2));
        TableColumn tableColumn2 = new TableColumn(this.resultTable, 16384);
        tableColumn2.setWidth(100);
        tableColumn2.setText(ResourceString.getResourceString("label.search.result.table.name"));
        tableColumn2.addSelectionListener((SelectionListener)new SearchResultSortListener(3));
        TableColumn tableColumn3 = new TableColumn(this.resultTable, 16384);
        tableColumn3.setWidth(200);
        tableColumn3.setText(ResourceString.getResourceString("label.search.result.table.value"));
        tableColumn3.addSelectionListener((SelectionListener)new SearchResultSortListener(4));
        tabItem.setControl((Control)resultGroup);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, ResourceString.getResourceString("label.search.replace.button"), false);
        this.createButton(parent, 101, ResourceString.getResourceString("label.search.all.button"), false);
        this.createButton(parent, 102, ResourceString.getResourceString("label.search.next.button"), true);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(buttonId);
            this.close();
        } else {
            if (buttonId == 102 || buttonId == 101) {
                this.tabFolder.setSelection(1);
                this.all = false;
                if (buttonId == 101) {
                    this.all = true;
                }
                String keyword = this.keywordCombo.getText();
                this.searchResult = this.searchManager.search(keyword, this.all, this.physicalWordNameCheckBox.getSelection(), this.logicalWordNameCheckBox.getSelection(), this.wordTypeCheckBox.getSelection(), this.wordLengthCheckBox.getSelection(), this.wordDecimalCheckBox.getSelection(), this.wordDescriptionCheckBox.getSelection(), this.physicalTableNameCheckBox.getSelection(), this.logicalTableNameCheckBox.getSelection(), this.physicalColumnNameCheckBox.getSelection(), this.logicalColumnNameCheckBox.getSelection(), this.columnTypeCheckBox.getSelection(), this.columnLengthCheckBox.getSelection(), this.columnDecimalCheckBox.getSelection(), this.columnDefaultValueCheckBox.getSelection(), this.columnDescriptionCheckBox.getSelection(), this.columnGroupNameCheckBox.getSelection(), this.indexCheckBox.getSelection(), this.noteCheckBox.getSelection(), this.modelPropertiesCheckBox.getSelection(), this.relationCheckBox.getSelection(), this.groupNameCheckBox.getSelection(), this.physicalGroupColumnNameCheckBox.getSelection(), this.logicalGroupColumnNameCheckBox.getSelection(), this.groupColumnTypeCheckBox.getSelection(), this.groupColumnLengthCheckBox.getSelection(), this.groupColumnDecimalCheckBox.getSelection(), this.groupColumnDefaultValueCheckBox.getSelection(), this.groupColumnDescriptionCheckBox.getSelection());
                this.showSearchResult();
                this.initKeywordCombo();
                this.keywordCombo.setText(keyword);
                return;
            }
            if (buttonId == 100) {
                this.tabFolder.setSelection(1);
                List<SearchResultRow> replaceRows = this.getReplaceRows();
                if (replaceRows.isEmpty()) {
                    return;
                }
                CompoundCommand command = new CompoundCommand();
                String keyword = this.keywordCombo.getText();
                String replaceWord = this.replaceCombo.getText();
                for (SearchResultRow row : replaceRows) {
                    ReplaceCommand replaceCommand = new ReplaceCommand(this.diagram, row.getType(), row.getTarget(), keyword, replaceWord);
                    command.add((Command)replaceCommand);
                }
                this.viewer.getEditDomain().getCommandStack().execute(command.unwrap());
                this.searchResult = this.searchManager.research();
                this.showSearchResult();
                this.initKeywordCombo();
                this.keywordCombo.setText(keyword);
                this.initReplaceWordCombo();
                this.replaceCombo.setText(replaceWord);
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    private void showSearchResult() {
        if (this.searchResult != null) {
            this.setResultRowData(this.searchResult.getRows());
            Object object = this.searchResult.getResultObject();
            if (object != null) {
                this.focus(object);
            }
        } else {
            this.resultTable.removeAll();
        }
    }

    private void focus(Object object) {
        EditPart editPart = (EditPart)this.viewer.getEditPartRegistry().get(object);
        if (editPart != null) {
            this.viewer.select(editPart);
            this.viewer.reveal(editPart);
        }
    }

    private void setResultRowData(List<SearchResultRow> rows) {
        this.resultTable.removeAll();
        for (SearchResultRow row : rows) {
            String type = ResourceString.getResourceString("search.result.row.type." + row.getType());
            String name = ResourceString.getResourceString("search.result.row.name." + row.getType());
            TableItem tableItem = new TableItem(this.resultTable, 0);
            String path = row.getPath();
            if (path == null) {
                path = type;
            }
            if (row.getPath() != null) {
                tableItem.setText(0, path);
            }
            tableItem.setText(1, type);
            tableItem.setText(2, name);
            tableItem.setText(3, row.getText());
        }
    }

    private List<SearchResultRow> getReplaceRows() {
        ArrayList<SearchResultRow> replaceRows = new ArrayList<SearchResultRow>();
        if (this.searchResult == null) {
            return replaceRows;
        }
        List<SearchResultRow> rows = this.searchResult.getRows();
        if (rows == null) {
            return replaceRows;
        }
        int[] indexes = this.resultTable.getSelectionIndices();
        if (indexes != null) {
            int i = 0;
            while (i < indexes.length) {
                replaceRows.add(rows.get(indexes[i]));
                ++i;
            }
        }
        return replaceRows;
    }

    private class SearchResultSortListener
    extends SelectionAdapter {
        private int sortType;

        private SearchResultSortListener(int sortType) {
            this.sortType = sortType;
        }

        public void widgetSelected(SelectionEvent e) {
            if (SearchDialog.this.searchResult == null) {
                return;
            }
            SearchDialog.this.searchResult.sort(this.sortType);
            SearchDialog.this.showSearchResult();
        }
    }
}

