/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.testdata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.testdata.TableTestData;
import org.insightech.er.editor.model.testdata.TestData;
import org.insightech.er.editor.view.dialog.dbexport.ExportToTestDataDialog;
import org.insightech.er.editor.view.dialog.testdata.detail.TestDataDialog;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataManageDialog
extends AbstractDialog {
    private static final int GROUP_LIST_HEIGHT = 230;
    private ERDiagram diagram;
    private org.eclipse.swt.widgets.List testDataListWidget;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button copyButton;
    private Button exportButton;
    private Table testDataTable;
    private List<TestData> testDataList;
    private IEditorPart editorPart;

    public TestDataManageDialog(Shell parentShell, IEditorPart editorPart, ERDiagram diagram, List<TestData> testDataList) {
        super(parentShell, 2);
        this.editorPart = editorPart;
        this.diagram = diagram;
        this.testDataList = testDataList;
    }

    @Override
    protected void initialize(Composite composite) {
        this.createLeftComposite(composite);
        this.createRightComposite(composite);
    }

    private void createLeftComposite(Composite parent) {
        GridData gridData = new GridData();
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 3;
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        GridData listCompGridData = new GridData();
        listCompGridData.horizontalSpan = 4;
        this.createTestDataList(composite, listCompGridData);
        this.addButton = CompositeFactory.createButton(composite, "label.button.add");
        this.editButton = CompositeFactory.createButton(composite, "label.button.edit");
        this.editButton.setEnabled(false);
        this.deleteButton = CompositeFactory.createButton(composite, "label.button.delete");
        this.deleteButton.setEnabled(false);
        this.copyButton = CompositeFactory.createButton(composite, "label.button.copy");
    }

    private void createTestDataList(Composite parent, GridData gridData) {
        GridLayout gridLayout = new GridLayout();
        Group group = new Group(parent, 0);
        group.setText(ResourceString.getResourceString("label.testdata.list"));
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        GridData listGridData = new GridData();
        listGridData.widthHint = 200;
        listGridData.heightHint = 230;
        this.testDataListWidget = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        this.testDataListWidget.setLayoutData((Object)listGridData);
        this.initTestDataList();
    }

    private void createRightComposite(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 8;
        composite.setLayout((Layout)gridLayout);
        GridData tableGridData = new GridData();
        tableGridData.heightHint = 230;
        tableGridData.verticalIndent = 15;
        this.testDataTable = new Table(composite, 67584);
        this.testDataTable.setHeaderVisible(true);
        this.testDataTable.setLayoutData((Object)tableGridData);
        this.testDataTable.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(this.testDataTable, 0);
        nameColumn.setWidth(300);
        nameColumn.setResizable(false);
        nameColumn.setText(ResourceString.getResourceString("label.testdata.table.name"));
        TableColumn dataNumColumn = new TableColumn(this.testDataTable, 0);
        dataNumColumn.setWidth(80);
        dataNumColumn.setResizable(false);
        dataNumColumn.setText(ResourceString.getResourceString("label.testdata.table.test.num"));
        this.exportButton = CompositeFactory.createButton(composite, "label.button.testdata.export", 1);
        this.exportButton.setEnabled(false);
    }

    private void initTestDataList() {
        Collections.sort(this.testDataList);
        this.testDataListWidget.removeAll();
        for (TestData testData : this.testDataList) {
            this.testDataListWidget.add(Format.null2blank(testData.getName()));
        }
    }

    private void initTableData() {
        this.testDataTable.removeAll();
        int targetIndex = this.testDataListWidget.getSelectionIndex();
        if (targetIndex == -1) {
            return;
        }
        TestData testData = this.testDataList.get(targetIndex);
        for (Map.Entry<ERTable, TableTestData> entry : testData.getTableTestDataMap().entrySet()) {
            ERTable table = entry.getKey();
            TableTestData tableTestData = entry.getValue();
            TableItem tableItem = new TableItem(this.testDataTable, 0);
            tableItem.setText(0, table.getName());
            tableItem.setText(1, String.valueOf(tableTestData.getTestDataNum()));
        }
    }

    @Override
    protected String getErrorMessage() {
        return null;
    }

    @Override
    protected void perfomeOK() {
    }

    @Override
    protected String getTitle() {
        return "dialog.title.testdata";
    }

    @Override
    protected void setData() {
    }

    private void addTestData() {
        TestData oldTestData = new TestData();
        TestDataDialog testDataDialog = new TestDataDialog(this.getShell(), this.diagram, oldTestData);
        if (testDataDialog.open() == 0) {
            TestData newTestData = testDataDialog.getTestData();
            this.testDataList.add(newTestData);
            this.initTestDataList();
            int i = 0;
            while (i < this.testDataList.size()) {
                TestData testData = this.testDataList.get(i);
                if (testData == newTestData) {
                    this.testDataListWidget.setSelection(i);
                    break;
                }
                ++i;
            }
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.exportButton.setEnabled(true);
            this.initTableData();
        }
    }

    private void exportTestData() {
        int targetIndex = this.testDataListWidget.getSelectionIndex();
        ExportToTestDataDialog exportTestDataDialog = new ExportToTestDataDialog(this.getShell(), this.editorPart, this.diagram, this.testDataList, targetIndex);
        exportTestDataDialog.open();
    }

    private void editTestData(int selectedTableIndex) {
        int targetIndex = this.testDataListWidget.getSelectionIndex();
        if (targetIndex == -1) {
            return;
        }
        TestData oldTestData = this.testDataList.get(targetIndex);
        TestDataDialog testDataDialog = new TestDataDialog(this.getShell(), this.diagram, oldTestData);
        if (selectedTableIndex != -1) {
            testDataDialog.setSelectedTable(selectedTableIndex);
        }
        if (testDataDialog.open() == 0) {
            TestData newTestData = testDataDialog.getTestData();
            this.testDataList.remove(targetIndex);
            this.testDataList.add(targetIndex, newTestData);
            this.initTestDataList();
            int i = 0;
            while (i < this.testDataList.size()) {
                TestData testData = this.testDataList.get(i);
                if (testData == newTestData) {
                    this.testDataListWidget.setSelection(i);
                    break;
                }
                ++i;
            }
            this.initTableData();
        }
    }

    private void copyTestData() {
        int targetIndex = this.testDataListWidget.getSelectionIndex();
        if (targetIndex == -1) {
            return;
        }
        TestData oldTestData = this.testDataList.get(targetIndex);
        TestData copyTestData = oldTestData.clone();
        this.testDataList.add(copyTestData);
        this.initTestDataList();
        int i = 0;
        while (i < this.testDataList.size()) {
            TestData testData = this.testDataList.get(i);
            if (testData == copyTestData) {
                this.testDataListWidget.setSelection(i);
                break;
            }
            ++i;
        }
        this.initTableData();
    }

    @Override
    protected void addListener() {
        super.addListener();
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestDataManageDialog.this.addTestData();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestDataManageDialog.this.editTestData(TestDataManageDialog.this.testDataTable.getSelectionIndex());
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int targetIndex = TestDataManageDialog.this.testDataListWidget.getSelectionIndex();
                if (targetIndex == -1) {
                    return;
                }
                TestDataManageDialog.this.testDataList.remove(targetIndex);
                TestDataManageDialog.this.initTestDataList();
                if (targetIndex >= TestDataManageDialog.this.testDataList.size()) {
                    targetIndex = TestDataManageDialog.this.testDataList.size() - 1;
                }
                TestDataManageDialog.this.testDataListWidget.setSelection(targetIndex);
                if (targetIndex == -1) {
                    TestDataManageDialog.this.editButton.setEnabled(false);
                    TestDataManageDialog.this.deleteButton.setEnabled(false);
                    TestDataManageDialog.this.exportButton.setEnabled(false);
                }
                TestDataManageDialog.this.initTableData();
            }
        });
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestDataManageDialog.this.copyTestData();
            }
        });
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestDataManageDialog.this.exportTestData();
            }
        });
        this.testDataListWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TestDataManageDialog.this.testDataListWidget.getSelectionIndex() != -1) {
                    TestDataManageDialog.this.initTableData();
                    TestDataManageDialog.this.editButton.setEnabled(true);
                    TestDataManageDialog.this.deleteButton.setEnabled(true);
                    TestDataManageDialog.this.exportButton.setEnabled(true);
                }
            }
        });
        this.testDataListWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TestDataManageDialog.this.editTestData(TestDataManageDialog.this.testDataTable.getSelectionIndex());
            }
        });
        this.testDataTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TestDataManageDialog.this.editTestData(TestDataManageDialog.this.testDataTable.getSelectionIndex());
            }
        });
    }
}

