/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.testdata.detail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.testdata.RepeatTestDataDef;
import org.insightech.er.editor.view.dialog.testdata.detail.tab.RepeatTestDataTabWrapper;
import org.insightech.er.util.Format;

public class RepeatTestDataSettingDialog
extends AbstractDialog {
    private static final int LABEL_WIDTH = 90;
    private static final int NUM_WIDTH = 50;
    private StackLayout stackLayout;
    private Composite cardPanel;
    private Composite nonePanel;
    private Composite templatePanel;
    private Composite foreignKeyPanel;
    private Composite enumPanel;
    private Combo columnCombo;
    private Combo typeCombo;
    private Label repeatNumLabel;
    private Text repeatNum;
    private Text template;
    private Text from;
    private Text to;
    private Text increment;
    private Text selects;
    private RepeatTestDataDef dataDef;
    private RepeatTestDataTabWrapper repeatTestDataTabWrapper;
    private int columnIndex;
    private NormalColumn normalColumn;
    private ERTable table;
    private boolean createContents = false;

    public RepeatTestDataSettingDialog(Shell parentShell, int columnIndex, RepeatTestDataTabWrapper repeatTestDataTabWrapper, ERTable table) {
        super(parentShell, 2);
        this.repeatTestDataTabWrapper = repeatTestDataTabWrapper;
        this.table = table;
        this.columnIndex = columnIndex;
    }

    protected void initialize(Composite composite) {
        CompositeFactory.createLabel(composite, "label.column", 1, 90);
        this.columnCombo = CompositeFactory.createReadOnlyCombo(this, composite, null);
        CompositeFactory.createLabel(composite, "label.testdata.repeat.type", 1, 90);
        this.typeCombo = CompositeFactory.createReadOnlyCombo(this, composite, null);
        this.repeatNumLabel = CompositeFactory.createLabel(composite, "label.testdata.repeat.num", 1, 90);
        this.repeatNum = CompositeFactory.createNumText(this, composite, null);
        this.initCardPanel(composite);
        this.initTypeCombo();
        this.initColumnCombo();
    }

    private void initColumnCombo() {
        for (NormalColumn normalColumn : this.table.getExpandedColumns()) {
            this.columnCombo.add(normalColumn.getName());
        }
    }

    private void initTypeCombo() {
        this.typeCombo.add(RepeatTestDataDef.TYPE_NULL);
        this.typeCombo.add(RepeatTestDataDef.TYPE_FORMAT);
        this.normalColumn = this.table.getExpandedColumns().get(this.columnIndex);
        if (this.normalColumn.isForeignKey()) {
            this.typeCombo.add(RepeatTestDataDef.TYPE_FOREIGNKEY);
        }
        this.typeCombo.add(RepeatTestDataDef.TYPE_ENUM);
    }

    private void initCardPanel(Composite composite) {
        this.cardPanel = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.cardPanel.setLayout((Layout)this.stackLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        this.cardPanel.setLayoutData((Object)gridData);
        this.initNonePanel();
        this.initTemplatePanel();
        this.initForeignKeyPanel();
        this.initEnumPanel();
    }

    private void initNonePanel() {
        this.nonePanel = new Composite(this.cardPanel, 0);
    }

    private void initTemplatePanel() {
        this.templatePanel = new Composite(this.cardPanel, 0);
        GridLayout templatePanelLayout = new GridLayout(7, false);
        templatePanelLayout.marginHeight = 0;
        templatePanelLayout.marginWidth = 0;
        this.templatePanel.setLayout((Layout)templatePanelLayout);
        CompositeFactory.createLabel(this.templatePanel, "label.testdata.repeat.format", 1, 90);
        this.template = CompositeFactory.createText(this, this.templatePanel, null, 6, false);
        CompositeFactory.filler(this.templatePanel, 1);
        CompositeFactory.createExampleLabel(this.templatePanel, "label.testdata.repeat.comment", 6);
        CompositeFactory.filler(this.templatePanel, 1);
        CompositeFactory.createLabel(this.templatePanel, "label.testdata.repeat.start");
        this.from = CompositeFactory.createNumText(this, this.templatePanel, null, 50);
        CompositeFactory.createLabel(this.templatePanel, "label.testdata.repeat.end");
        this.to = CompositeFactory.createNumText(this, this.templatePanel, null, 50);
        CompositeFactory.createLabel(this.templatePanel, "label.testdata.repeat.increment");
        this.increment = CompositeFactory.createNumText(this, this.templatePanel, null, 50);
    }

    private void initForeignKeyPanel() {
        this.foreignKeyPanel = new Composite(this.cardPanel, 0);
        this.foreignKeyPanel.setLayout((Layout)new GridLayout(2, false));
    }

    private void initEnumPanel() {
        this.enumPanel = new Composite(this.cardPanel, 0);
        GridLayout enumPanelLayout = new GridLayout(2, false);
        enumPanelLayout.marginHeight = 0;
        enumPanelLayout.marginWidth = 0;
        this.enumPanel.setLayout((Layout)enumPanelLayout);
        CompositeFactory.createLabel(this.enumPanel, "label.testdata.repeat.enum.values", 1, 90);
        this.selects = CompositeFactory.createTextArea(this, this.enumPanel, null, -1, 100, 1, false);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point location = super.getInitialLocation(initialSize);
        location.y = 70;
        return location;
    }

    protected void setData() {
        this.initialized = false;
        this.normalColumn = this.table.getExpandedColumns().get(this.columnIndex);
        this.dataDef = this.repeatTestDataTabWrapper.getRepeatTestData().getDataDef(this.normalColumn);
        this.columnCombo.select(this.columnIndex);
        if (this.dataDef != null) {
            this.typeCombo.setText(this.dataDef.getType());
            this.repeatNum.setText(Format.toString(this.dataDef.getRepeatNum()));
            this.template.setText(Format.toString(this.dataDef.getTemplate()));
            this.from.setText(Format.toString(this.dataDef.getFrom()));
            this.to.setText(Format.toString(this.dataDef.getTo()));
            this.increment.setText(Format.toString(this.dataDef.getIncrement()));
            StringBuilder sb = new StringBuilder();
            String[] stringArray = this.dataDef.getSelects();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                sb.append(str);
                sb.append("\r\n");
                ++n2;
            }
            this.selects.setText(sb.toString());
            this.setCardPanel(this.typeCombo.getText());
        } else {
            this.repeatNum.setText("1");
            this.template.setText("value_%");
            this.from.setText("1");
            this.to.setText("5");
            this.increment.setText("1");
            this.selects.setText("value_1\r\nvalue_2\r\nvalue_3\r\nvalue_4\r\n");
        }
        this.initialized = true;
    }

    protected String getTitle() {
        return "dialog.title.testdata.repetition.condition.setting";
    }

    protected String getErrorMessage() {
        if (this.createContents) {
            this.dataDef = this.getRepeatTestDataDef();
            this.repeatTestDataTabWrapper.setRepeatTestDataDef(this.normalColumn, this.dataDef);
            this.repeatTestDataTabWrapper.initTableData();
        }
        return null;
    }

    protected void perfomeOK() throws InputException {
    }

    private RepeatTestDataDef getRepeatTestDataDef() {
        RepeatTestDataDef dataDef = new RepeatTestDataDef();
        dataDef.setType(this.typeCombo.getText());
        dataDef.setRepeatNum(this.getIntValue(this.repeatNum));
        dataDef.setTemplate(this.template.getText());
        dataDef.setFrom(this.from.getText());
        dataDef.setTo(this.to.getText());
        dataDef.setIncrement(this.increment.getText());
        String str = this.selects.getText();
        BufferedReader reader = new BufferedReader(new StringReader(str));
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException iOException) {}
        dataDef.setSelects(lines.toArray(new String[lines.size()]));
        return dataDef;
    }

    private int getIntValue(Text textField) {
        try {
            return Integer.parseInt(textField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected void addListener() {
        super.addListener();
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                RepeatTestDataSettingDialog.this.setCardPanel(RepeatTestDataSettingDialog.this.typeCombo.getText());
            }
        });
        this.columnCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                RepeatTestDataSettingDialog.this.columnIndex = RepeatTestDataSettingDialog.this.columnCombo.getSelectionIndex();
                RepeatTestDataSettingDialog.this.setData();
            }
        });
    }

    private void setCardPanel(String selectedType) {
        if (RepeatTestDataDef.TYPE_FORMAT.equals(selectedType)) {
            this.stackLayout.topControl = this.templatePanel;
            this.repeatNumLabel.setVisible(true);
            this.repeatNum.setVisible(true);
            this.cardPanel.layout();
        } else if (RepeatTestDataDef.TYPE_FOREIGNKEY.equals(selectedType)) {
            this.stackLayout.topControl = this.foreignKeyPanel;
            this.repeatNumLabel.setVisible(true);
            this.repeatNum.setVisible(true);
            this.cardPanel.layout();
        } else if (RepeatTestDataDef.TYPE_ENUM.equals(selectedType)) {
            this.stackLayout.topControl = this.enumPanel;
            this.repeatNumLabel.setVisible(true);
            this.repeatNum.setVisible(true);
            this.cardPanel.layout();
        } else {
            this.stackLayout.topControl = this.nonePanel;
            this.repeatNumLabel.setVisible(false);
            this.repeatNum.setVisible(false);
            this.cardPanel.layout();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.addListener();
        this.validate();
        this.createContents = true;
        return control;
    }
}

