/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.testdata.detail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.common.widgets.ValidatableTabWrapper;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.testdata.TableTestData;
import org.insightech.er.editor.model.testdata.TestData;
import org.insightech.er.editor.view.dialog.testdata.detail.tab.DirectTestDataTabWrapper;
import org.insightech.er.editor.view.dialog.testdata.detail.tab.RepeatTestDataTabWrapper;
import org.insightech.er.util.Format;

public class TestDataDialog
extends AbstractDialog {
    public static final int WIDTH = 750;
    public static final int TABLE_HEIGHT = 300;
    private Button addButton;
    private Button removeButton;
    private org.eclipse.swt.widgets.List allTableListWidget;
    private Table selectedTableTable;
    private Button repeatToDirectRadio;
    private Button directToRepeatRadio;
    private TabFolder tabFolder;
    private List<ValidatableTabWrapper> tabWrapperList;
    private DirectTestDataTabWrapper directTestDataTabWrapper;
    private RepeatTestDataTabWrapper repeatTestDataTabWrapper;
    private ERDiagram diagram;
    private TestData testData;
    private List<ERTable> allTableList;
    private Text nameText;
    private int selectedTableIndex = -1;

    public ERDiagram getDiagram() {
        return this.diagram;
    }

    public TestDataDialog(Shell parentShell, ERDiagram diagram, TestData testData) {
        super(parentShell);
        this.diagram = diagram;
        this.testData = testData.clone();
        this.allTableList = diagram.getDiagramContents().getContents().getTableSet().getList();
        this.tabWrapperList = new ArrayList<ValidatableTabWrapper>();
    }

    protected void initialize(Composite composite) {
        this.createNameComposite(composite);
        this.createTopComposite(composite);
        this.createBottomComposite(composite);
    }

    private void createNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        nameComposite.setLayout((Layout)mainLayout);
        this.nameText = CompositeFactory.createText(this, nameComposite, "label.testdata.name", 1, 200, true);
    }

    private void createTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        topComposite.setLayout((Layout)mainLayout);
        GridData topGridData = new GridData();
        topGridData.grabExcessHorizontalSpace = true;
        topGridData.horizontalAlignment = 4;
        topGridData.heightHint = 100;
        topComposite.setLayoutData((Object)topGridData);
        this.createAllTableList(topComposite);
        this.addButton = CompositeFactory.createAddButton(topComposite);
        this.addButton.setEnabled(false);
        this.createSelectedTableTable(topComposite);
        this.removeButton = CompositeFactory.createRemoveButton(topComposite);
        this.removeButton.setEnabled(false);
    }

    private void createAllTableList(Composite composite) {
        Group group = new Group(composite, 0);
        GridData gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 1;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        group.setLayoutData((Object)gridData);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setText(ResourceString.getResourceString("label.all.table"));
        GridData comboGridData = new GridData();
        comboGridData.widthHint = 300;
        comboGridData.grabExcessVerticalSpace = true;
        comboGridData.verticalAlignment = 4;
        this.allTableListWidget = new org.eclipse.swt.widgets.List((Composite)group, 2562);
        this.allTableListWidget.setLayoutData((Object)comboGridData);
    }

    private void createSelectedTableTable(Composite composite) {
        GridData gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Group group = new Group(composite, 0);
        group.setText(ResourceString.getResourceString("label.testdata.table.list"));
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        GridData tableGridData = new GridData();
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.widthHint = 300;
        tableGridData.verticalSpan = 2;
        this.selectedTableTable = new Table((Composite)group, 67586);
        this.selectedTableTable.setHeaderVisible(false);
        this.selectedTableTable.setLayoutData((Object)tableGridData);
        this.selectedTableTable.setLinesVisible(false);
        TableColumn tableColumn = new TableColumn(this.selectedTableTable, 0x1000000);
        tableColumn.setWidth(200);
        tableColumn.setText(ResourceString.getResourceString("label.testdata.table.name"));
        TableColumn numColumn = new TableColumn(this.selectedTableTable, 0x1000000);
        numColumn.setWidth(80);
        numColumn.setText(ResourceString.getResourceString("label.testdata.table.test.num"));
    }

    private void createBottomComposite(Composite composite) {
        GridData bottomGridData = new GridData();
        bottomGridData.grabExcessHorizontalSpace = true;
        bottomGridData.horizontalAlignment = 4;
        bottomGridData.widthHint = 750;
        this.createOutputOrderGroup(composite);
        this.tabFolder = new TabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)bottomGridData);
        this.directTestDataTabWrapper = new DirectTestDataTabWrapper(this, this.tabFolder, 0);
        this.tabWrapperList.add(this.directTestDataTabWrapper);
        this.repeatTestDataTabWrapper = new RepeatTestDataTabWrapper(this, this.tabFolder, 0);
        this.tabWrapperList.add(this.repeatTestDataTabWrapper);
    }

    private void createOutputOrderGroup(Composite parent) {
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 15;
        groupLayout.marginHeight = 15;
        groupLayout.numColumns = 4;
        Group group = new Group(parent, 0);
        group.setText(ResourceString.getResourceString("label.output.order"));
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)groupLayout);
        this.directToRepeatRadio = CompositeFactory.createRadio(this, (Composite)group, "label.output.order.direct.to.repeat");
        this.repeatToDirectRadio = CompositeFactory.createRadio(this, (Composite)group, "label.output.order.repeat.to.direct");
    }

    private void initSelectedTableTable() {
        this.selectedTableTable.removeAll();
        for (Map.Entry<ERTable, TableTestData> entry : this.testData.getTableTestDataMap().entrySet()) {
            ERTable table = entry.getKey();
            TableTestData tableTestData = entry.getValue();
            TableItem tableItem = new TableItem(this.selectedTableTable, 0);
            tableItem.setText(0, table.getName());
            tableItem.setText(1, String.valueOf(tableTestData.getTestDataNum()));
        }
    }

    public void resetTestDataNum() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int targetIndex = TestDataDialog.this.selectedTableTable.getSelectionIndex();
                if (targetIndex != -1) {
                    int num = TestDataDialog.this.directTestDataTabWrapper.getTestDataNum() + TestDataDialog.this.repeatTestDataTabWrapper.getTestDataNum();
                    TableItem tableItem = TestDataDialog.this.selectedTableTable.getItem(targetIndex);
                    tableItem.setText(1, String.valueOf(num));
                }
            }
        });
    }

    protected void setData() {
        this.nameText.setText(Format.null2blank(this.testData.getName()));
        for (ERTable table : this.allTableList) {
            this.allTableListWidget.add(Format.null2blank(table.getName()));
        }
        this.initSelectedTableTable();
        if (this.selectedTableIndex != -1) {
            this.selectedTableTable.select(this.selectedTableIndex);
            this.removeButton.setEnabled(true);
            this.resetTabs();
            this.selectedTableIndex = -1;
        }
        if (this.testData.getExportOrder() == 0) {
            this.directToRepeatRadio.setSelection(true);
        } else {
            this.repeatToDirectRadio.setSelection(true);
        }
    }

    protected String getTitle() {
        return "dialog.title.testdata.edit";
    }

    protected String getErrorMessage() {
        String text = this.nameText.getText().trim();
        if (text.equals("")) {
            return "error.testdata.name.empty";
        }
        if (this.selectedTableTable.getItemCount() == 0) {
            return "error.testdata.table.empty";
        }
        try {
            for (ValidatableTabWrapper tabWrapper : this.tabWrapperList) {
                tabWrapper.validatePage();
            }
        }
        catch (InputException e) {
            return e.getMessage();
        }
        return null;
    }

    protected void perfomeOK() throws InputException {
        String text = this.nameText.getText().trim();
        this.testData.setName(text);
        if (this.repeatToDirectRadio.getSelection()) {
            this.testData.setExportOrder(1);
        } else if (this.directToRepeatRadio.getSelection()) {
            this.testData.setExportOrder(0);
        }
        for (ValidatableTabWrapper tab : this.tabWrapperList) {
            tab.perfomeOK();
        }
    }

    protected void addListener() {
        super.addListener();
        this.allTableListWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = TestDataDialog.this.allTableListWidget.getSelectionIndex();
                if (index == -1) {
                    TestDataDialog.this.addButton.setEnabled(false);
                } else {
                    TestDataDialog.this.addButton.setEnabled(true);
                }
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = TestDataDialog.this.allTableListWidget.getSelectionIndices();
                if (indexes.length < 1) {
                    return;
                }
                int[] nArray = indexes;
                int n = indexes.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ERTable table = (ERTable)TestDataDialog.this.allTableList.get(index);
                    if (!TestDataDialog.this.testData.contains(table)) {
                        TableTestData tableTestData = new TableTestData();
                        TestDataDialog.this.testData.putTableTestData(table, tableTestData);
                    }
                    ++n2;
                }
                TestDataDialog.this.initSelectedTableTable();
                TestDataDialog.this.validate();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TestDataDialog.this.selectedTableTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                TestDataDialog.this.testData.removeTableTestData(index);
                TestDataDialog.this.initSelectedTableTable();
                TestDataDialog.this.validate();
                if (TestDataDialog.this.selectedTableTable.getItemCount() <= index) {
                    --index;
                }
                TestDataDialog.this.selectedTableTable.setSelection(index);
                if (index == -1) {
                    TestDataDialog.this.removeButton.setEnabled(false);
                }
            }
        });
        this.selectedTableTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int index = TestDataDialog.this.selectedTableTable.getSelectionIndex();
                if (index == -1) {
                    TestDataDialog.this.removeButton.setEnabled(false);
                    return;
                }
                TestDataDialog.this.removeButton.setEnabled(true);
                TestDataDialog.this.resetTabs();
            }
        });
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = TestDataDialog.this.tabFolder.getSelectionIndex();
                ValidatableTabWrapper selectedTabWrapper = (ValidatableTabWrapper)((Object)TestDataDialog.this.tabWrapperList.get(index));
                selectedTabWrapper.setInitFocus();
            }
        });
    }

    private void resetTabs() {
        for (ValidatableTabWrapper tab : this.tabWrapperList) {
            tab.reset();
        }
    }

    public ERTable getTargetTable() {
        int targetIndex = this.selectedTableTable.getSelectionIndex();
        return this.testData.get(targetIndex);
    }

    public TestData getTestData() {
        return this.testData;
    }

    public void setSelectedTable(int selectedTableIndex) {
        this.selectedTableIndex = selectedTableIndex;
    }
}

