/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.tracking;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.ResourceString;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.controller.command.tracking.AddChangeTrackingCommand;
import org.insightech.er.editor.controller.command.tracking.CalculateChangeTrackingCommand;
import org.insightech.er.editor.controller.command.tracking.ChangeTrackingCommand;
import org.insightech.er.editor.controller.command.tracking.DeleteChangeTrackingCommand;
import org.insightech.er.editor.controller.command.tracking.ResetChangeTrackingCommand;
import org.insightech.er.editor.controller.command.tracking.UpdateChangeTrackingCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeSet;
import org.insightech.er.editor.model.tracking.ChangeTracking;
import org.insightech.er.util.Check;

public class ChangeTrackingDialog
extends Dialog {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private Table changeTrackingTable;
    private Text textArea = null;
    private Button registerButton;
    private Button updateButton;
    private Button deleteButton;
    private Button replaceButton;
    private Button comparisonDisplayButton;
    private Button comparisonResetButton;
    private GraphicalViewer viewer;
    private ERDiagram diagram;

    public ChangeTrackingDialog(Shell parentShell, GraphicalViewer viewer, ERDiagram diagram) {
        super(parentShell);
        this.viewer = viewer;
        this.diagram = diagram;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(ResourceString.getResourceString("dialog.title.change.tracking"));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout((Layout)gridLayout);
        this.initialize(composite);
        this.setData();
        return composite;
    }

    private void initialize(Composite composite) {
        GridData tableGridData = new GridData();
        tableGridData.widthHint = 520;
        tableGridData.horizontalSpan = 6;
        tableGridData.heightHint = 150;
        this.changeTrackingTable = new Table(composite, 67588);
        this.changeTrackingTable.setHeaderVisible(true);
        this.changeTrackingTable.setLayoutData((Object)tableGridData);
        this.changeTrackingTable.setLinesVisible(true);
        CompositeFactory.createLabel(composite, "label.contents.of.change", 6);
        this.textArea = CompositeFactory.createTextArea(null, composite, null, -1, 100, 6, true);
        this.registerButton = new Button(composite, 0);
        this.registerButton.setText(ResourceString.getResourceString("label.button.register"));
        this.updateButton = new Button(composite, 0);
        this.updateButton.setText(ResourceString.getResourceString("label.button.update"));
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.setText(ResourceString.getResourceString("label.button.delete"));
        this.replaceButton = new Button(composite, 0);
        this.replaceButton.setText(ResourceString.getResourceString("label.button.change.tracking"));
        this.comparisonDisplayButton = new Button(composite, 0);
        this.comparisonDisplayButton.setText(ResourceString.getResourceString("label.button.comparison.display"));
        this.comparisonResetButton = new Button(composite, 0);
        this.comparisonResetButton.setText(ResourceString.getResourceString("label.button.comparison.reset"));
        TableColumn tableColumn0 = new TableColumn(this.changeTrackingTable, 16384);
        tableColumn0.setWidth(150);
        tableColumn0.setText(ResourceString.getResourceString("label.date"));
        TableColumn tableColumn1 = new TableColumn(this.changeTrackingTable, 16384);
        tableColumn1.setWidth(400);
        tableColumn1.setText(ResourceString.getResourceString("label.contents.of.change"));
        this.changeTrackingTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeTrackingDialog.this.changeTrackingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                ChangeTrackingDialog.this.selectChangeTracking(index);
            }
        });
        this.registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeTracking changeTracking = new ChangeTracking(ChangeTrackingDialog.this.diagram.getDiagramContents());
                changeTracking.setComment(ChangeTrackingDialog.this.textArea.getText());
                AddChangeTrackingCommand command = new AddChangeTrackingCommand(ChangeTrackingDialog.this.diagram, changeTracking);
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
                int index = ChangeTrackingDialog.this.changeTrackingTable.getItemCount();
                ChangeTrackingDialog.this.setData();
                ChangeTrackingDialog.this.selectChangeTracking(index);
            }
        });
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeTrackingDialog.this.changeTrackingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                ChangeTracking changeTracking = ChangeTrackingDialog.this.diagram.getChangeTrackingList().get(index);
                UpdateChangeTrackingCommand command = new UpdateChangeTrackingCommand(changeTracking, ChangeTrackingDialog.this.textArea.getText());
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
                ChangeTrackingDialog.this.setData();
                ChangeTrackingDialog.this.selectChangeTracking(index);
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeTrackingDialog.this.changeTrackingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                DeleteChangeTrackingCommand command = new DeleteChangeTrackingCommand(ChangeTrackingDialog.this.diagram, index);
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
                ChangeTrackingDialog.this.setData();
                if (index >= ChangeTrackingDialog.this.changeTrackingTable.getItemCount()) {
                    index = ChangeTrackingDialog.this.changeTrackingTable.getItemCount() - 1;
                }
                ChangeTrackingDialog.this.selectChangeTracking(index);
            }
        });
        this.replaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeTracking changeTracking;
                int index = ChangeTrackingDialog.this.changeTrackingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 196);
                messageBox.setText(ResourceString.getResourceString("dialog.title.change.tracking"));
                messageBox.setMessage(ResourceString.getResourceString("dialog.message.change.tracking"));
                if (messageBox.open() == 64) {
                    changeTracking = new ChangeTracking(ChangeTrackingDialog.this.diagram.getDiagramContents());
                    changeTracking.setComment("");
                    ChangeTrackingDialog.this.diagram.getChangeTrackingList().addChangeTracking(changeTracking);
                    ChangeTrackingDialog.this.setData();
                    ChangeTrackingDialog.this.changeTrackingTable.select(index);
                }
                changeTracking = ChangeTrackingDialog.this.diagram.getChangeTrackingList().get(index);
                ChangeTracking copy = new ChangeTracking(changeTracking.getDiagramContents());
                ChangeTrackingCommand command = new ChangeTrackingCommand(ChangeTrackingDialog.this.diagram, copy.getDiagramContents());
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
            }
        });
        this.comparisonDisplayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ChangeTrackingDialog.this.changeTrackingTable.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                ChangeTracking changeTracking = ChangeTrackingDialog.this.diagram.getChangeTrackingList().get(index);
                NodeSet nodeElementList = changeTracking.getDiagramContents().getContents();
                CalculateChangeTrackingCommand command = new CalculateChangeTrackingCommand(ChangeTrackingDialog.this.diagram, nodeElementList);
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
                ChangeTrackingDialog.this.comparisonResetButton.setEnabled(true);
            }
        });
        this.comparisonResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResetChangeTrackingCommand command = new ResetChangeTrackingCommand(ChangeTrackingDialog.this.diagram);
                ChangeTrackingDialog.this.viewer.getEditDomain().getCommandStack().execute((Command)command);
                ChangeTrackingDialog.this.comparisonResetButton.setEnabled(false);
            }
        });
        this.textArea.setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(buttonId);
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    private void setData() {
        this.changeTrackingTable.removeAll();
        this.setButtonEnabled(false);
        this.comparisonDisplayButton.setEnabled(false);
        for (ChangeTracking changeTracking : this.diagram.getChangeTrackingList().getList()) {
            TableItem tableItem = new TableItem(this.changeTrackingTable, 0);
            String date = DATE_FORMAT.format(changeTracking.getUpdatedDate());
            tableItem.setText(0, date);
            if (!Check.isEmpty(changeTracking.getComment())) {
                tableItem.setText(1, changeTracking.getComment());
                continue;
            }
            tableItem.setText(1, "*** empty log message ***");
        }
        this.comparisonResetButton.setEnabled(this.diagram.getChangeTrackingList().isCalculated());
    }

    private void setButtonEnabled(boolean enabled) {
        this.updateButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled);
        this.replaceButton.setEnabled(enabled);
        this.comparisonDisplayButton.setEnabled(enabled);
    }

    private void selectChangeTracking(int index) {
        this.changeTrackingTable.select(index);
        ChangeTracking changeTracking = this.diagram.getChangeTrackingList().get(index);
        if (changeTracking.getComment() != null) {
            this.textArea.setText(changeTracking.getComment());
        } else {
            this.textArea.setText("");
        }
        if (index >= 0) {
            this.setButtonEnabled(true);
        } else {
            this.setButtonEnabled(false);
        }
    }
}

