/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.word.column.real;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.view.dialog.word.column.AbstractColumnDialog;

public abstract class AbstractRealColumnDialog
extends AbstractColumnDialog {
    protected Button notNullCheck;
    protected Button uniqueKeyCheck;
    protected Combo defaultText;
    protected Text constraintText;
    private TabFolder tabFolder;
    protected TabItem tabItem;

    public AbstractRealColumnDialog(Shell parentShell, ERDiagram diagram) {
        super(parentShell, diagram);
    }

    protected Composite createRootComposite(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabItem = new TabItem(this.tabFolder, 0);
        this.tabItem.setText(ResourceString.getResourceString("label.basic"));
        Composite composite = super.createRootComposite((Composite)this.tabFolder);
        this.tabItem.setControl((Control)composite);
        this.tabItem = new TabItem(this.tabFolder, 0);
        this.tabItem.setText(ResourceString.getResourceString("label.detail"));
        Composite detailComposite = this.createDetailTab(this.tabFolder);
        this.initializeDetailTab(detailComposite);
        this.tabItem.setControl((Control)detailComposite);
        return composite;
    }

    protected void initializeComposite(Composite composite) {
        int numColumns = this.getCompositeNumColumns();
        Composite checkBoxComposite = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns;
        gridData.heightHint = 40;
        checkBoxComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.getCheckBoxCompositeNumColumns();
        checkBoxComposite.setLayout((Layout)gridLayout);
        this.initializeCheckBoxComposite(checkBoxComposite);
        super.initializeComposite(composite);
        this.defaultText = CompositeFactory.createCombo(this, composite, "label.column.default.value", numColumns - 1);
    }

    protected int getCheckBoxCompositeNumColumns() {
        return 2;
    }

    private Composite createDetailTab(TabFolder tabFolder) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected void initializeDetailTab(Composite composite) {
        this.constraintText = CompositeFactory.createText(this, composite, "label.column.constraint", false);
    }

    protected void initializeCheckBoxComposite(Composite composite) {
        this.notNullCheck = CompositeFactory.createCheckbox(this, composite, "label.not.null");
        this.uniqueKeyCheck = CompositeFactory.createCheckbox(this, composite, "label.unique.key");
    }

    protected void setWordData() {
        this.notNullCheck.setSelection(this.targetColumn.isNotNull());
        this.uniqueKeyCheck.setSelection(this.targetColumn.isUniqueKey());
        if (this.targetColumn.getConstraint() != null) {
            this.constraintText.setText(this.targetColumn.getConstraint());
        }
        if (this.targetColumn.getDefaultValue() != null) {
            this.defaultText.setText(this.targetColumn.getDefaultValue());
        }
        super.setWordData();
    }

    protected void perfomeOK() {
        super.perfomeOK();
        this.returnColumn = new NormalColumn(this.returnWord, this.notNullCheck.getSelection(), false, this.uniqueKeyCheck.getSelection(), false, this.defaultText.getText(), this.constraintText.getText(), null, null, null);
    }

    protected void setEnabledBySqlType() {
        super.setEnabledBySqlType();
        SqlType selectedType = SqlType.valueOf(this.diagram.getDatabase(), this.typeCombo.getText());
        if (selectedType != null) {
            String defaultValue = this.defaultText.getText();
            this.defaultText.removeAll();
            if (selectedType.isTimestamp()) {
                this.defaultText.add(ResourceString.getResourceString("label.current.date.time"));
                this.defaultText.setText(defaultValue);
            } else if (!ResourceString.getResourceString("label.current.date.time").equals(defaultValue)) {
                this.defaultText.setText(defaultValue);
            }
        }
    }
}

