/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.figure.table.style.funny;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Font;
import org.insightech.er.Activator;
import org.insightech.er.Resources;
import org.insightech.er.editor.view.figure.table.TableFigure;
import org.insightech.er.editor.view.figure.table.column.GroupColumnFigure;
import org.insightech.er.editor.view.figure.table.column.NormalColumnFigure;
import org.insightech.er.editor.view.figure.table.style.AbstractStyleSupport;

public class FunnyStyleSupport
extends AbstractStyleSupport {
    private Label nameLabel;

    public FunnyStyleSupport(TableFigure tableFigure) {
        super(tableFigure);
    }

    public void init(TableFigure tableFigure) {
        tableFigure.setCornerDimensions(new Dimension(20, 20));
        tableFigure.setForegroundColor(ColorConstants.black);
        tableFigure.setBorder(null);
    }

    public void initTitleBar(Figure top) {
        top.setLayoutManager((LayoutManager)new BorderLayout());
        Figure title = new Figure();
        top.add((IFigure)title, (Object)BorderLayout.TOP);
        title.setLayoutManager((LayoutManager)new FlowLayout());
        ImageFigure image = new ImageFigure();
        image.setBorder((Border)new MarginBorder(new Insets(5, 10, 5, 2)));
        image.setImage(Activator.getImage(this.getTableFigure().getImageKey()));
        title.add((IFigure)image);
        this.nameLabel = new Label();
        this.nameLabel.setBorder((Border)new MarginBorder(new Insets(5, 0, 5, 20)));
        title.add((IFigure)this.nameLabel);
        Figure separater = new Figure();
        separater.setSize(-1, 1);
        separater.setBackgroundColor(ColorConstants.black);
        separater.setOpaque(true);
        top.add((IFigure)separater, (Object)BorderLayout.BOTTOM);
    }

    public void createColumnArea(IFigure columns) {
        this.initColumnArea(columns);
        columns.setBorder((Border)new MarginBorder(0, 0, 0, 0));
        columns.setBackgroundColor(ColorConstants.white);
        columns.setOpaque(true);
        Figure centerFigure = new Figure();
        centerFigure.setLayoutManager((LayoutManager)new BorderLayout());
        centerFigure.setBorder((Border)new MarginBorder(new Insets(0, 2, 0, 2)));
        centerFigure.add(columns, (Object)BorderLayout.CENTER);
        this.getTableFigure().add((IFigure)centerFigure, BorderLayout.CENTER);
    }

    public void createFooter() {
        Figure footer = new Figure();
        BorderLayout footerLayout = new BorderLayout();
        footer.setLayoutManager((LayoutManager)footerLayout);
        footer.setBorder((Border)new MarginBorder(new Insets(0, 2, 0, 2)));
        Figure footer1 = new Figure();
        footer1.setSize(-1, 10);
        footer1.setBackgroundColor(Resources.VERY_LIGHT_GRAY);
        footer1.setOpaque(true);
        footer.add((IFigure)footer1, (Object)BorderLayout.TOP);
        Figure footer2 = new Figure();
        footer2.setSize(-1, 7);
        footer.add((IFigure)footer2, (Object)BorderLayout.BOTTOM);
        this.getTableFigure().add((IFigure)footer, BorderLayout.BOTTOM);
    }

    public void setName(String name) {
        this.nameLabel.setForegroundColor(this.getTextColor());
        this.nameLabel.setText(name);
    }

    public void setFont(Font font, Font titleFont) {
        this.nameLabel.setFont(titleFont);
    }

    public void addColumn(NormalColumnFigure columnFigure, int viewMode, String physicalName, String logicalName, String type, boolean primaryKey, boolean foreignKey, boolean isNotNull, boolean uniqueKey, boolean displayKey, boolean displayDetail, boolean displayType, boolean isSelectedReferenced, boolean isSelectedForeignKey, boolean isAdded, boolean isUpdated, boolean isRemoved) {
        Label label = this.createColumnLabel();
        label.setForegroundColor(ColorConstants.black);
        StringBuilder text = new StringBuilder();
        text.append(this.getColumnText(viewMode, physicalName, logicalName, type, isNotNull, uniqueKey, displayDetail, displayType));
        if (displayKey) {
            Label filler;
            ImageFigure image;
            if (primaryKey) {
                image = new ImageFigure();
                image.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 0)));
                image.setImage(Activator.getImage("PRIMARY_KEY"));
                columnFigure.add((IFigure)image);
            } else {
                filler = new Label();
                filler.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 16)));
                columnFigure.add((IFigure)filler);
            }
            if (foreignKey) {
                image = new ImageFigure();
                image.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 0)));
                image.setImage(Activator.getImage("FOREIGN_KEY"));
                columnFigure.add((IFigure)image);
            } else {
                filler = new Label();
                filler.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 16)));
                columnFigure.add((IFigure)filler);
            }
            if (primaryKey && foreignKey) {
                label.setForegroundColor(ColorConstants.blue);
            } else if (primaryKey) {
                label.setForegroundColor(ColorConstants.red);
            } else if (foreignKey) {
                label.setForegroundColor(ColorConstants.darkGreen);
            }
        }
        label.setText(text.toString());
        this.setColumnFigureColor((IFigure)columnFigure, isSelectedReferenced, isSelectedForeignKey, isAdded, isUpdated, isRemoved);
        columnFigure.add((IFigure)label);
    }

    public void addColumnGroup(GroupColumnFigure columnFigure, int viewMode, String name, boolean isAdded, boolean isUpdated, boolean isRemoved) {
        Label filler = new Label();
        filler.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 16)));
        columnFigure.add((IFigure)filler);
        filler = new Label();
        filler.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 16)));
        columnFigure.add((IFigure)filler);
        StringBuilder text = new StringBuilder();
        text.append(name);
        text.append(" (GROUP)");
        this.setColumnFigureColor((IFigure)columnFigure, false, false, isAdded, isUpdated, isRemoved);
        Label label = this.createColumnLabel();
        label.setForegroundColor(ColorConstants.black);
        label.setText(text.toString());
        columnFigure.add((IFigure)label);
    }
}

