/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.outline;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.insightech.er.editor.controller.editpart.outline.ERDiagramOutlineEditPartFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.view.action.outline.index.CreateIndexAction;
import org.insightech.er.editor.view.action.outline.notation.type.ChangeOutlineViewToBothAction;
import org.insightech.er.editor.view.action.outline.notation.type.ChangeOutlineViewToLogicalAction;
import org.insightech.er.editor.view.action.outline.notation.type.ChangeOutlineViewToPhysicalAction;
import org.insightech.er.editor.view.action.outline.orderby.ChangeOutlineViewOrderByLogicalNameAction;
import org.insightech.er.editor.view.action.outline.orderby.ChangeOutlineViewOrderByPhysicalNameAction;
import org.insightech.er.editor.view.action.outline.sequence.CreateSequenceAction;
import org.insightech.er.editor.view.action.outline.tablespace.CreateTablespaceAction;
import org.insightech.er.editor.view.action.outline.trigger.CreateTriggerAction;
import org.insightech.er.editor.view.drag_drop.ERDiagramOutlineTransferDropTargetListener;
import org.insightech.er.editor.view.drag_drop.ERDiagramTransferDragSourceListener;

public class ERDiagramOutlinePage
extends ContentOutlinePage {
    private SashForm sash;
    private TreeViewer viewer = (TreeViewer)this.getViewer();
    private ERDiagram diagram;
    private LightweightSystem lws;
    private ScrollableThumbnail thumbnail;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry outlineActionRegistory;
    private ActionRegistry registry;

    public ERDiagramOutlinePage(ERDiagram diagram) {
        super((EditPartViewer)new TreeViewer());
        this.diagram = diagram;
        this.outlineActionRegistory = new ActionRegistry();
        this.registerAction(this.viewer, this.outlineActionRegistory);
    }

    public void createControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.viewer.createControl((Composite)this.sash);
        ERDiagramOutlineEditPartFactory editPartFactory = new ERDiagramOutlineEditPartFactory();
        this.viewer.setEditPartFactory((EditPartFactory)editPartFactory);
        this.viewer.setContents((Object)this.diagram);
        Canvas canvas = new Canvas((Composite)this.sash, 2048);
        this.lws = new LightweightSystem(canvas);
        this.resetView(this.registry);
        ERDiagramTransferDragSourceListener dragSourceListener = new ERDiagramTransferDragSourceListener((EditPartViewer)this.viewer, (Transfer)TemplateTransfer.getInstance());
        this.viewer.addDragSourceListener((TransferDragSourceListener)dragSourceListener);
    }

    public Control getControl() {
        return this.sash;
    }

    private void showThumbnail() {
        ScalableFreeformRootEditPart editPart = (ScalableFreeformRootEditPart)this.graphicalViewer.getRootEditPart();
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        this.thumbnail = new ScrollableThumbnail((Viewport)editPart.getFigure());
        this.thumbnail.setSource(editPart.getLayer((Object)"Printable Layers"));
        this.lws.setContents((IFigure)this.thumbnail);
    }

    private void initDropTarget() {
        ERDiagramOutlineTransferDropTargetListener dropTargetListener = new ERDiagramOutlineTransferDropTargetListener((EditPartViewer)this.graphicalViewer, (Transfer)TemplateTransfer.getInstance());
        this.graphicalViewer.addDropTargetListener((TransferDropTargetListener)dropTargetListener);
    }

    public void setCategory(EditDomain editDomain, GraphicalViewer graphicalViewer, MenuManager outlineMenuMgr, ActionRegistry registry) {
        this.graphicalViewer = graphicalViewer;
        this.viewer.setContextMenu(outlineMenuMgr);
        this.viewer.setEditDomain(editDomain);
        this.registry = registry;
        if (this.getSite() != null) {
            this.resetView(registry);
        }
    }

    private void resetAction(ActionRegistry registry) {
        IActionBars bars = this.getSite().getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    private void resetView(ActionRegistry registry) {
        this.showThumbnail();
        this.initDropTarget();
        this.resetAction(registry);
    }

    private void registerAction(TreeViewer treeViewer, ActionRegistry actionRegistry) {
        IAction[] actions;
        IAction[] iActionArray = actions = new IAction[]{new CreateIndexAction(treeViewer), new CreateSequenceAction(treeViewer), new CreateTriggerAction(treeViewer), new CreateTablespaceAction(treeViewer), new ChangeOutlineViewToPhysicalAction(treeViewer), new ChangeOutlineViewToLogicalAction(treeViewer), new ChangeOutlineViewToBothAction(treeViewer), new ChangeOutlineViewOrderByPhysicalNameAction(treeViewer), new ChangeOutlineViewOrderByLogicalNameAction(treeViewer)};
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            actionRegistry.registerAction(action);
            ++n2;
        }
    }

    public ActionRegistry getOutlineActionRegistory() {
        return this.outlineActionRegistory;
    }

    public EditPartViewer getViewer() {
        return super.getViewer();
    }
}

