/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.preference;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.util.io.FileUtils;

public abstract class FileListEditor
extends ListEditor {
    public static final String VALUE_SEPARATOR = "/";
    private String lastPath;
    private Composite parent;
    private Map<String, String> namePathMap;
    private String extention;

    public FileListEditor(String name, String labelText, Composite parent, String extention) {
        super(name, labelText, parent);
        this.parent = parent;
        this.namePathMap = new HashMap<String, String>();
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.extention = extention;
    }

    protected String getNewInputObject() {
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        String[] filterExtensions = new String[]{this.extention};
        dialog.setFilterExtensions(filterExtensions);
        String filePath = dialog.open();
        if (filePath != null) {
            File file = new File(filePath);
            String fileName = file.getName();
            if (this.contains(fileName)) {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 296);
                messageBox.setText(ResourceString.getResourceString("dialog.title.warning"));
                messageBox.setMessage(ResourceString.getResourceString("dialog.message.update.file"));
                if (messageBox.open() == 256) {
                    return null;
                }
                this.namePathMap.put(fileName, filePath);
                return null;
            }
            this.namePathMap.put(fileName, filePath);
            try {
                this.lastPath = file.getParentFile().getCanonicalPath();
            }
            catch (IOException iOException) {}
            return fileName;
        }
        return null;
    }

    protected String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, VALUE_SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected String createList(String[] items) {
        StringBuilder path = new StringBuilder("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            path.append(VALUE_SEPARATOR);
            ++i;
        }
        return path.toString();
    }

    protected abstract String getStorePath(String var1);

    protected void doStore() {
        try {
            File dir = new File(this.getStorePath(""));
            dir.mkdirs();
            for (String name : this.namePathMap.keySet()) {
                File from = new File(this.namePathMap.get(name));
                File to = new File(this.getStorePath(name));
                FileUtils.copyFile(from, to);
            }
        }
        catch (IOException iOException) {
            Activator.showErrorDialog(ResourceString.getResourceString("error.read.file"));
        }
        super.doStore();
    }

    private boolean contains(String name) {
        String[] items;
        List list = this.getListControl(this.parent);
        String[] stringArray = items = list.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (name.equals(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void doLoad() {
        List list = this.getListControl(this.parent);
        String s = this.getPreferenceStore().getString(this.getPreferenceName());
        String[] array = this.parseString(s);
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < array.length) {
            File file = new File(this.getStorePath(array[i]));
            if (file.exists() && !names.contains(array[i])) {
                list.add(array[i]);
                names.add(array[i]);
            }
            ++i;
        }
    }
}

