/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.preference;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.insightech.er.Activator;
import org.insightech.er.db.DBManager;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.settings.DBSetting;
import org.insightech.er.editor.model.settings.JDBCDriverSetting;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String TEMPLATE_FILE_LIST = "template_file_list";
    public static final String TRANSLATION_FILE_LIST = "translation_file_list";
    private static final String TEMPLATE_DIR = "template";
    private static final String TRANSLATION_DIR = "translation";
    private static final String JDBC_DRIVER_DB_NAME_PREFIX = "jdbc.driver.db.name.";
    private static final String JDBC_DRIVER_PATH_PREFIX = "jdbc.driver.path.";
    private static final String JDBC_DRIVER_CLASS_NAME_PREFIX = "jdbc.driver.class.name.";
    private static final String JDBC_DRIVER_CLASS_NAME_LIST_NUM = "jdbc.driver.class.name.list.num";
    private static final String DB_SETTING_LIST_NUM = "db.setting.list.num";
    private static final String DB_SETTING_DBSYSTEM = "db.setting.dbsystem.";
    private static final String DB_SETTING_SERVER = "db.setting.server.";
    private static final String DB_SETTING_PORT = "db.setting.port.";
    private static final String DB_SETTING_DATABASE = "db.setting.database.";
    private static final String DB_SETTING_USER = "db.setting.user.";
    private static final String DB_SETTING_USE_DEFAULT_DRIVER = "db.setting.use.default.driver.";
    private static final String DB_SETTING_URL = "db.setting.url.";
    private static final String DB_SETTING_DRIVER_CLASS_NAME = "db.setting.driver.class.name.";
    private static final String DB_SETTING_PASSWORD = "setting.password.";

    public void initializeDefaultPreferences() {
    }

    public static String getTemplatePath(String fileName) {
        IPath dataLocation = Activator.getDefault().getStateLocation();
        String path = dataLocation.append(TEMPLATE_DIR).append(fileName).toOSString();
        return path;
    }

    public static String getTranslationPath(String fileName) {
        IPath dataLocation = Activator.getDefault().getStateLocation();
        String path = dataLocation.append(TRANSLATION_DIR).append(fileName).toOSString();
        return path;
    }

    public static void saveJDBCDriverSettingList(List<JDBCDriverSetting> driverSettingList) {
        PreferenceInitializer.clearJDBCDriverInfo();
        for (JDBCDriverSetting driverSetting : driverSettingList) {
            PreferenceInitializer.addJDBCDriver(driverSetting.getDb(), driverSetting.getClassName(), driverSetting.getPath());
        }
    }

    public static void addJDBCDriver(String db, String className, String path) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int listSize = store.getInt(JDBC_DRIVER_CLASS_NAME_LIST_NUM);
        store.setValue(JDBC_DRIVER_DB_NAME_PREFIX + listSize, Format.null2blank(db));
        store.setValue(JDBC_DRIVER_CLASS_NAME_PREFIX + listSize, Format.null2blank(className));
        store.setValue(JDBC_DRIVER_PATH_PREFIX + listSize, Format.null2blank(path));
        store.setValue(JDBC_DRIVER_CLASS_NAME_LIST_NUM, listSize + 1);
    }

    public static List<JDBCDriverSetting> getJDBCDriverSettingList() {
        ArrayList<JDBCDriverSetting> list = new ArrayList<JDBCDriverSetting>();
        ArrayList<JDBCDriverSetting> defaultDriverList = new ArrayList<JDBCDriverSetting>();
        for (String db : DBManagerFactory.getAllDBList()) {
            if ("StandardSQL".equals(db)) continue;
            DBManager dbManager = DBManagerFactory.getDBManager(db);
            JDBCDriverSetting driverSetting = new JDBCDriverSetting(db, dbManager.getDriverClassName(), null);
            defaultDriverList.add(driverSetting);
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int listSize = store.getInt(JDBC_DRIVER_CLASS_NAME_LIST_NUM);
        int i = 0;
        while (i < listSize) {
            String db = store.getString(JDBC_DRIVER_DB_NAME_PREFIX + i);
            String className = store.getString(JDBC_DRIVER_CLASS_NAME_PREFIX + i);
            String path = store.getString(JDBC_DRIVER_PATH_PREFIX + i);
            JDBCDriverSetting setting = new JDBCDriverSetting(db, className, path);
            list.add(setting);
            defaultDriverList.remove(setting);
            ++i;
        }
        for (JDBCDriverSetting defaultDriverSetting : defaultDriverList) {
            list.add(defaultDriverSetting);
        }
        Collections.sort(list);
        return list;
    }

    public static void clearJDBCDriverInfo() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int num = store.getInt(JDBC_DRIVER_CLASS_NAME_LIST_NUM);
        int i = 0;
        while (i < num) {
            store.setValue(JDBC_DRIVER_CLASS_NAME_PREFIX + i, "");
            store.setValue(JDBC_DRIVER_PATH_PREFIX + i, "");
            ++i;
        }
        store.setValue(JDBC_DRIVER_CLASS_NAME_LIST_NUM, 0);
    }

    public static String getJDBCDriverPath(String db, String driverClassName) {
        String path = null;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int listSize = store.getInt(JDBC_DRIVER_CLASS_NAME_LIST_NUM);
        int i = 0;
        while (i < listSize) {
            if (driverClassName.equals(store.getString(JDBC_DRIVER_CLASS_NAME_PREFIX + i))) {
                path = store.getString(JDBC_DRIVER_PATH_PREFIX + i);
                break;
            }
            ++i;
        }
        return path;
    }

    public static DBSetting getDBSetting(int no) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String dbsystem = store.getString(DB_SETTING_DBSYSTEM + no);
        String server = store.getString(DB_SETTING_SERVER + no);
        int portNo = store.getInt(DB_SETTING_PORT + no);
        String database = store.getString(DB_SETTING_DATABASE + no);
        String user = store.getString(DB_SETTING_USER + no);
        String password = store.getString(DB_SETTING_PASSWORD + no);
        String useDefaultDriverString = store.getString(DB_SETTING_USE_DEFAULT_DRIVER + no);
        String url = store.getString(DB_SETTING_URL + no);
        String driverClassName = store.getString(DB_SETTING_DRIVER_CLASS_NAME + no);
        boolean useDefaultDriver = true;
        if ("false".equals(useDefaultDriverString) || "StandardSQL".equals(dbsystem)) {
            useDefaultDriver = false;
        }
        return new DBSetting(dbsystem, server, portNo, database, user, password, useDefaultDriver, url, driverClassName);
    }

    public static void saveSetting(int no, DBSetting dbSetting) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(DB_SETTING_DBSYSTEM + no, Format.null2blank(dbSetting.getDbsystem()));
        store.setValue(DB_SETTING_SERVER + no, Format.null2blank(dbSetting.getServer()));
        store.setValue(DB_SETTING_PORT + no, dbSetting.getPort());
        store.setValue(DB_SETTING_DATABASE + no, Format.null2blank(dbSetting.getDatabase()));
        store.setValue(DB_SETTING_USER + no, Format.null2blank(dbSetting.getUser()));
        store.setValue(DB_SETTING_PASSWORD + no, Format.null2blank(dbSetting.getPassword()));
        store.setValue(DB_SETTING_USE_DEFAULT_DRIVER + no, dbSetting.isUseDefaultDriver());
        store.setValue(DB_SETTING_URL + no, Format.null2blank(dbSetting.getUrl()));
        store.setValue(DB_SETTING_DRIVER_CLASS_NAME + no, Format.null2blank(dbSetting.getDriverClassName()));
    }

    public static void saveSetting(List<DBSetting> dbSettingList) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(DB_SETTING_LIST_NUM, dbSettingList.size());
        int i = 0;
        while (i < dbSettingList.size()) {
            DBSetting dbSetting = dbSettingList.get(i);
            PreferenceInitializer.saveSetting(i + 1, dbSetting);
            ++i;
        }
    }

    public static List<DBSetting> getDBSettingList(String database) {
        ArrayList<DBSetting> dbSettingList = new ArrayList<DBSetting>();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int num = store.getInt(DB_SETTING_LIST_NUM);
        int i = 1;
        while (i <= num) {
            DBSetting dbSetting = PreferenceInitializer.getDBSetting(i);
            if (database == null || dbSetting.getDbsystem().equals(database)) {
                dbSettingList.add(dbSetting);
            }
            ++i;
        }
        Collections.sort(dbSettingList);
        return dbSettingList;
    }

    public static void addDBSetting(DBSetting dbSetting) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int num = store.getInt(DB_SETTING_LIST_NUM);
        store.setValue(DB_SETTING_LIST_NUM, ++num);
        PreferenceInitializer.saveSetting(num, dbSetting);
    }

    public static List<String> getAllUserTranslations() {
        String str = Activator.getDefault().getPreferenceStore().getString(TRANSLATION_FILE_LIST);
        StringTokenizer st = new StringTokenizer(str, "/");
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> names = new HashSet<String>();
        while (st.hasMoreElements()) {
            String fileName = st.nextToken();
            File file = new File(PreferenceInitializer.getTranslationPath(fileName));
            if (!file.exists() || names.contains(fileName)) continue;
            list.add(fileName);
            names.add(fileName);
        }
        return list;
    }

    public static void addPreferenceValue(String value) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String values = preferenceStore.getString(TRANSLATION_FILE_LIST);
        values = Check.isEmpty(values) ? value : String.valueOf(values) + "/" + value;
        preferenceStore.setValue(TRANSLATION_FILE_LIST, values);
    }
}

