/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.preference.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.db.DBManager;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.editor.model.settings.JDBCDriverSetting;
import org.insightech.er.preference.PreferenceInitializer;
import org.insightech.er.preference.jdbc.JDBCPathDialog;
import org.insightech.er.util.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.initTable(composite);
        this.createButton(composite);
        this.addListener();
        return composite;
    }

    private void initTable(Composite parent) {
        this.table = new Table(parent, 67588);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 200;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText(ResourceString.getResourceString("label.database"));
        nameColumn.setWidth(200);
        TableColumn driverClassNameColumn = new TableColumn(this.table, 0);
        driverClassNameColumn.setText(ResourceString.getResourceString("label.driver.class.name"));
        driverClassNameColumn.setWidth(200);
        TableColumn pathColumn = new TableColumn(this.table, 0);
        pathColumn.setText(ResourceString.getResourceString("label.path"));
        pathColumn.setWidth(200);
        this.setData();
    }

    private void createButton(Composite parent) {
        GridData buttonGridData = new GridData();
        buttonGridData.widthHint = 60;
        this.addButton = new Button(parent, 0);
        this.addButton.setLayoutData((Object)buttonGridData);
        this.addButton.setText(ResourceString.getResourceString("label.button.add"));
        this.editButton = new Button(parent, 0);
        this.editButton.setLayoutData((Object)buttonGridData);
        this.editButton.setText(ResourceString.getResourceString("label.button.edit"));
        this.deleteButton = new Button(parent, 0);
        this.deleteButton.setLayoutData((Object)buttonGridData);
        this.deleteButton.setText(ResourceString.getResourceString("label.button.delete"));
        this.deleteButton.setEnabled(false);
    }

    private void setData() {
        this.table.removeAll();
        for (JDBCDriverSetting setting : PreferenceInitializer.getJDBCDriverSettingList()) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setBackground(ColorConstants.white);
            tableItem.setText(0, Format.null2blank(setting.getDb()));
            tableItem.setText(1, Format.null2blank(setting.getClassName()));
            tableItem.setText(2, Format.null2blank(setting.getPath()));
        }
    }

    protected void performDefaults() {
        PreferenceInitializer.clearJDBCDriverInfo();
        this.setData();
        super.performDefaults();
    }

    public boolean performOk() {
        PreferenceInitializer.clearJDBCDriverInfo();
        int i = 0;
        while (i < this.table.getItemCount()) {
            TableItem tableItem = this.table.getItem(i);
            String db = tableItem.getText(0);
            String driverClassName = tableItem.getText(1);
            String path = tableItem.getText(2);
            PreferenceInitializer.addJDBCDriver(db, driverClassName, path);
            ++i;
        }
        return super.performOk();
    }

    private void addListener() {
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionevent) {
                int index = JDBCPreferencePage.this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                TableItem item = JDBCPreferencePage.this.table.getItem(index);
                String db = item.getText(0);
                String driverClassName = item.getText(1);
                DBManager dbManager = DBManagerFactory.getDBManager(db);
                if (!dbManager.getDriverClassName().equals(driverClassName)) {
                    JDBCPreferencePage.this.deleteButton.setEnabled(true);
                } else {
                    JDBCPreferencePage.this.deleteButton.setEnabled(false);
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                JDBCPreferencePage.this.edit();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List otherDriverSettingList = JDBCPreferencePage.this.getOtherDriverSettingList(-1);
                JDBCPathDialog dialog = new JDBCPathDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, null, otherDriverSettingList, true);
                if (dialog.open() == 0) {
                    PreferenceInitializer.addJDBCDriver(dialog.getDatabase(), Format.null2blank(dialog.getDriverClassName()), Format.null2blank(dialog.getPath()));
                    JDBCPreferencePage.this.setData();
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JDBCPreferencePage.this.edit();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = JDBCPreferencePage.this.table.getSelectionIndex();
                    if (index == -1) {
                        return;
                    }
                    TableItem item = JDBCPreferencePage.this.table.getItem(index);
                    String db = item.getText(0);
                    String driverClassName = item.getText(1);
                    DBManager dbManager = DBManagerFactory.getDBManager(db);
                    if (!dbManager.getDriverClassName().equals(driverClassName)) {
                        JDBCPreferencePage.this.table.remove(index);
                    }
                }
                catch (Exception e) {
                    Activator.showExceptionDialog(e);
                }
            }
        });
    }

    private List<JDBCDriverSetting> getOtherDriverSettingList(int index) {
        ArrayList<JDBCDriverSetting> list = new ArrayList<JDBCDriverSetting>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (i != index) {
                TableItem tableItem = this.table.getItem(i);
                String db = tableItem.getText(0);
                String driverClassName = tableItem.getText(1);
                String path = tableItem.getText(2);
                JDBCDriverSetting driverSetting = new JDBCDriverSetting(db, driverClassName, path);
                list.add(driverSetting);
            }
            ++i;
        }
        return list;
    }

    private void edit() {
        try {
            int index = this.table.getSelectionIndex();
            if (index == -1) {
                return;
            }
            TableItem item = this.table.getItem(index);
            List<JDBCDriverSetting> otherDriverSettingList = this.getOtherDriverSettingList(index);
            JDBCPathDialog dialog = new JDBCPathDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), item.getText(0), item.getText(1), item.getText(2), otherDriverSettingList, true);
            if (dialog.open() == 0) {
                item.setText(1, dialog.getDriverClassName());
                item.setText(2, dialog.getPath());
            }
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }
}

