/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.preference.template;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.preference.template.TemplateFileListEditor;
import org.insightech.er.util.io.IOUtils;

public class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_TEMPLATE_FILE_EN = "template_en.xls";
    private static final String DEFAULT_TEMPLATE_FILE_JA = "template_ja.xls";
    private TemplateFileListEditor fileListEditor;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Composite buttonComposite = new Composite(composite, 0);
        this.createButtonComposite(buttonComposite);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        this.fileListEditor = new TemplateFileListEditor("template_file_list", ResourceString.getResourceString("label.custom.tempplate"), composite);
        this.fileListEditor.load();
        new Label(composite, 0);
        new Label(composite, 0);
        Label label = new Label(composite, 0);
        label.setText(ResourceString.getResourceString("dialog.message.template.file.store"));
        return composite;
    }

    private void createButtonComposite(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Button buttonEn = new Button(composite, 0);
        buttonEn.setText(ResourceString.getResourceString("label.button.download.template.en"));
        buttonEn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.download(TemplatePreferencePage.DEFAULT_TEMPLATE_FILE_EN);
            }
        });
        Button buttonJa = new Button(composite, 0);
        buttonJa.setText(ResourceString.getResourceString("label.button.download.template.ja"));
        buttonJa.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencePage.this.download(TemplatePreferencePage.DEFAULT_TEMPLATE_FILE_JA);
            }
        });
    }

    protected void performDefaults() {
        this.fileListEditor.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.fileListEditor.store();
        return super.performOk();
    }

    private void download(String fileName) {
        block21: {
            String filePath = Activator.showSaveDialog(fileName, new String[]{".xls"});
            if (filePath != null) {
                InputStream in = null;
                OutputStream out = null;
                try {
                    try {
                        in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + fileName);
                        out = new FileOutputStream(filePath);
                        IOUtils.copy(in, out);
                    }
                    catch (IOException ioe) {
                        Activator.showExceptionDialog(ioe);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e1) {
                                Activator.showExceptionDialog(e1);
                            }
                        }
                        if (out == null) break block21;
                        try {
                            out.close();
                        }
                        catch (IOException e1) {
                            Activator.showExceptionDialog(e1);
                        }
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e1) {
                            Activator.showExceptionDialog(e1);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e1) {
                            Activator.showExceptionDialog(e1);
                        }
                    }
                }
            }
        }
    }

    public static InputStream getDefaultExcelTemplateEn() {
        return TemplatePreferencePage.class.getResourceAsStream("/template_en.xls");
    }

    public static InputStream getDefaultExcelTemplateJa() {
        return TemplatePreferencePage.class.getResourceAsStream("/template_ja.xls");
    }
}

