/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.util;

import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.diagram_contents.not_element.dictionary.TypeData;

public class Format {
    public static String formatType(SqlType sqlType, TypeData typeData, String database) {
        String type = null;
        if (sqlType != null) {
            type = sqlType.getAlias(database);
            if (type != null) {
                if (typeData.getLength() != null && typeData.getDecimal() != null) {
                    type = type.replaceAll("\\(.,.\\)", "(" + typeData.getLength() + "," + typeData.getDecimal() + ")");
                    type = type.replaceFirst("\\([a-z]\\)", "(" + typeData.getLength() + ")").replaceFirst("\\([a-z]\\)", "(" + typeData.getDecimal() + ")");
                } else if (typeData.getLength() != null) {
                    String len = null;
                    len = "BLOB".equalsIgnoreCase(type) ? Format.getFileSizeStr(typeData.getLength().longValue()) : String.valueOf(typeData.getLength());
                    type = type.replaceAll("\\(.\\)", "(" + len + ")");
                }
                if (typeData.isArray() && "PostgreSQL".equals(database)) {
                    int i = 0;
                    while (i < typeData.getArrayDimension()) {
                        type = String.valueOf(type) + "[]";
                        ++i;
                    }
                }
                if (sqlType.isNumber() && typeData.isUnsigned() && "MySQL".equals(database)) {
                    type = String.valueOf(type) + " unsigned";
                }
                if (sqlType.doesNeedArgs()) {
                    type = String.valueOf(type) + "(" + typeData.getArgs() + ")";
                }
            } else {
                type = "";
            }
        } else {
            type = "";
        }
        return type;
    }

    public static String getFileSizeStr(long fileSize) {
        long size = fileSize;
        String unit = "";
        if (size > 1024L) {
            unit = "K";
            if ((size /= 1024L) > 1024L) {
                unit = "M";
                if ((size /= 1024L) > 1024L) {
                    size /= 1024L;
                    unit = "G";
                }
            }
        }
        return String.valueOf(size) + unit;
    }

    public static String null2blank(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String escapeSQL(String str) {
        str = str.replaceAll("'", "''");
        str = str.replaceAll("\\\\", "\\\\\\\\");
        return str;
    }

    public static String toString(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }
}

