// Copyright 2006 Google Inc.

//   http://www.apache.org/licenses/LICENSE-2.0

/*!
 * ZRender, a lightweight canvas library with a MVC architecture, data-driven 
 * and provides an event model like DOM.
 *  
 * Copyright (c) 2013, Baidu Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or 
 * without modification, are permitted provided that the following conditions 
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Baidu Inc. nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific 
 * prior written permission of Baidu Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * echarts坐标处理方法
 * Copyright 2013 Baidu Inc. All rights reserved.
 *
 * @author Neil (杨骥, linzhifeng@baidu.com)
 */

/**
 * echarts组件类：极坐标
 * Copyright 2013 Baidu Inc. All rights reserved.
 *
 * @desc echarts基于Canvas，纯Javascript图表库，提供直观，生动，可交互，可个性化定制的数据统计图表。
 * @author Neil (杨骥, yangji01@baidu.com)
 *
 */

/*!
 * ECharts, a javascript interactive chart library.
 *  
 * Copyright (c) 2013, Baidu Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or 
 * without modification, are permitted provided that the following conditions 
 * are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this 
 * list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice, 
 * this list of conditions and the following disclaimer in the documentation 
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Baidu Inc. nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific 
 * prior written permission of Baidu Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * echarts图表类：雷达图
 * Copyright 2013 Baidu Inc. All rights reserved.
 *
 * @desc echarts基于Canvas，纯Javascript图表库，提供直观，生动，可交互，可个性化定制的数据统计图表。
 * @author Neil (杨骥, yangji01@baidu.com)
 *
 */

define("echarts/config",[],function(){var e={CHART_TYPE_LINE:"line",CHART_TYPE_BAR:"bar",CHART_TYPE_SCATTER:"scatter",CHART_TYPE_PIE:"pie",CHART_TYPE_RADAR:"radar",CHART_TYPE_MAP:"map",CHART_TYPE_K:"k",CHART_TYPE_ISLAND:"island",CHART_TYPE_FORCE:"force",CHART_TYPE_CHORD:"chord",COMPONENT_TYPE_TITLE:"title",COMPONENT_TYPE_LEGEND:"legend",COMPONENT_TYPE_DATARANGE:"dataRange",COMPONENT_TYPE_DATAVIEW:"dataView",COMPONENT_TYPE_DATAZOOM:"dataZoom",COMPONENT_TYPE_TOOLBOX:"toolbox",COMPONENT_TYPE_TOOLTIP:"tooltip",COMPONENT_TYPE_GRID:"grid",COMPONENT_TYPE_AXIS:"axis",COMPONENT_TYPE_POLAR:"polar",COMPONENT_TYPE_X_AXIS:"xAxis",COMPONENT_TYPE_Y_AXIS:"yAxis",COMPONENT_TYPE_AXIS_CATEGORY:"categoryAxis",COMPONENT_TYPE_AXIS_VALUE:"valueAxis",color:["#ff7f50","#87cefa","#da70d6","#32cd32","#6495ed","#ff69b4","#ba55d3","#cd5c5c","#ffa500","#40e0d0","#1e90ff","#ff6347","#7b68ee","#00fa9a","#ffd700","#6699FF","#ff6666","#3cb371","#b8860b","#30e0e0"],title:{text:"",subtext:"",x:"left",y:"top",backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,textStyle:{fontSize:18,fontWeight:"bolder",color:"#333"},subtextStyle:{color:"#aaa"}},legend:{orient:"horizontal",x:"center",y:"top",backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemWidth:20,itemHeight:14,textStyle:{color:"#333"},selectedMode:!0},dataRange:{orient:"vertical",x:"left",y:"bottom",backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemWidth:20,itemHeight:14,precision:0,splitNumber:5,calculable:!1,realtime:!0,color:["#1e90ff","#f0ffff"],textStyle:{color:"#333"}},toolbox:{show:!1,orient:"horizontal",x:"right",y:"top",color:["#1e90ff","#22bb22","#4b0082","#d2691e"],backgroundColor:"rgba(0,0,0,0)",borderColor:"#ccc",borderWidth:0,padding:5,itemGap:10,itemSize:16,feature:{}},tooltip:{show:!0,showContent:!0,trigger:"item",islandFormatter:"{a} <br/>{b} : {c}",showDelay:20,hideDelay:100,transitionDuration:.4,backgroundColor:"rgba(0,0,0,0.7)",borderColor:"#333",borderRadius:4,borderWidth:0,padding:5,axisPointer:{type:"line",lineStyle:{color:"#48b",width:2,type:"solid"},areaStyle:{size:"auto",color:"rgba(150,150,150,0.3)"}},textStyle:{color:"#fff"}},dataZoom:{show:!1,orient:"horizontal",backgroundColor:"#eee",dataBackgroundColor:"#ccc",fillerColor:"rgba(50,205,50,0.4)",handleColor:"rgba(70,130,180,0.8)",realtime:!1},grid:{x:80,y:60,x2:80,y2:60,backgroundColor:"#fff",borderWidth:1,borderColor:"#ccc"},categoryAxis:{position:"bottom",name:"",nameLocation:"end",boundaryGap:!0,axisLine:{show:!0,lineStyle:{color:"#48b",width:2,type:"solid"}},axisTick:{show:!1,length:4,lineStyle:{color:"#ccc",width:1}},axisLabel:{show:!0,interval:"auto",rotate:0,margin:8,textStyle:{color:"#333"}},splitLine:{show:!0,lineStyle:{color:["#ccc"],width:1,type:"solid"}},splitArea:{show:!1,areaStyle:{color:["rgba(250,250,250,0.3)","rgba(200,200,200,0.3)"],type:"default"}}},valueAxis:{position:"left",name:"",nameLocation:"end",boundaryGap:[0,0],precision:0,power:100,splitNumber:5,axisLine:{show:!0,lineStyle:{color:"#48b",width:2,type:"solid"}},axisTick:{show:!1,length:4,lineStyle:{color:"#ccc",width:1}},axisLabel:{show:!0,rotate:0,margin:8,textStyle:{color:"#333"}},splitLine:{show:!0,lineStyle:{color:["#ccc"],width:1,type:"solid"}},splitArea:{show:!1,areaStyle:{color:["rgba(250,250,250,0.3)","rgba(200,200,200,0.3)"],type:"default"}}},polar:{center:["50%","50%"],startAngle:90,splitNumber:5,name:{show:!0,textStyle:{color:"#333"}},axisLine:{show:!0,lineStyle:{color:"#ccc",width:1,type:"solid"}},axisLabel:{show:!1,textStyle:{color:"#333"}},splitArea:{show:!0,areaStyle:{color:["rgba(250,250,250,0.3)","rgba(200,200,200,0.3)"]}},splitLine:{show:!0,lineStyle:{width:1,color:"#ccc"}}},bar:{xAxisIndex:0,yAxisIndex:0,barMinHeight:20,itemStyle:{normal:{label:{show:!1}},emphasis:{label:{show:!1}}}},line:{xAxisIndex:0,yAxisIndex:0,itemStyle:{normal:{label:{show:!1},lineStyle:{width:2,type:"solid",shadowColor:"rgba(0,0,0,0)",shadowBlur:5,shadowOffsetX:3,shadowOffsetY:3}},emphasis:{label:{show:!1}}},symbolSize:2,showAllSymbol:!1},k:{xAxisIndex:0,yAxisIndex:0,itemStyle:{normal:{color:"#fff",color0:"#00aa11",lineStyle:{width:1,color:"#ff3200",color0:"#00aa11"}},emphasis:{}}},scatter:{xAxisIndex:0,yAxisIndex:0,symbolSize:4,large:!1,largeThreshold:2e3,itemStyle:{normal:{label:{show:!1,formatter:function(e,t,n){return typeof n[2]!="undefined"?n[2]:n[0]+" , "+n[1]}}},emphasis:{label:{show:!1,formatter:function(e,t,n){return typeof n[2]!="undefined"?n[2]:n[0]+" , "+n[1]}}}}},radar:{polarIndex:0,itemStyle:{normal:{lineStyle:{width:2,type:"solid"}},emphasis:{}},symbolSize:2},pie:{center:["50%","50%"],startAngle:90,minAngle:5,selectedOffset:10,itemStyle:{normal:{label:{show:!0,position:"outer"},labelLine:{show:!0,length:30,lineStyle:{width:1,type:"solid"}}},emphasis:{label:{show:!1,position:"outer"},labelLine:{show:!1,length:40,lineStyle:{width:1,type:"solid"}}}}},map:{mapType:"china",mapLocation:{x:"center",y:"center"},itemStyle:{normal:{lineStyle:{width:2,color:"#fff"},areaStyle:{color:"#ccc"},label:{show:!1,textStyle:{color:"rgba(139,69,19,1)"}}},emphasis:{lineStyle:{width:2,color:"#fff"},areaStyle:{color:"rgba(255,215,0,0.8)"},label:{show:!1,textStyle:{color:"rgba(139,69,19,1)"}}}}},force:{minRadius:10,maxRadius:20,density:1,attractiveness:1,initSize:300,centripetal:1,coolDown:.99,categories:[],itemStyle:{normal:{label:{show:!1},nodeStyle:{brushType:"both",color:"#f08c2e",strokeColor:"#5182ab"},linkStyle:{strokeColor:"#5182ab"}},emphasis:{label:{show:!1},nodeStyle:{},linkStyle:{}}}},chord:{radius:["65%","75%"],center:["50%","50%"],padding:2,sort:"none",sortSub:"none",startAngle:90,clockWise:!1,showScale:!1,showScaleText:!1,itemStyle:{normal:{label:{show:!0},lineStyle:{width:0,color:"#000"},chordStyle:{lineStyle:{width:1,color:"#666"}}},emphasis:{lineStyle:{width:0,color:"#000"},chordStyle:{lineStyle:{width:2,color:"#333"}}}},matrix:[]},island:{r:15,calculateStep:.1},textStyle:{decoration:"none",fontFamily:"Arial, Verdana, sans-serif",fontSize:12,fontStyle:"normal",fontWeight:"normal"},EVENT:{REFRESH:"refresh",RESTORE:"restore",CLICK:"click",HOVER:"hover",MOUSEWHEEL:"mousewheel",DATA_CHANGED:"dataChanged",DATA_ZOOM:"dataZoom",DATA_RANGE:"dataRange",LEGEND_SELECTED:"legendSelected",MAP_SELECTED:"mapSelected",PIE_SELECTED:"pieSelected",MAGIC_TYPE_CHANGED:"magicTypeChanged",DATA_VIEW_CHANGED:"dataViewChanged",TOOLTIP_HOVER:"tooltipHover"},calculable:!1,calculableColor:"rgba(255,165,0,0.6)",calculableHolderColor:"#ccc",nameConnector:" & ",valueConnector:" : ",animation:!0,addDataAnimation:!0,animationDuration:2e3,animationEasing:"ExponentialOut"};return e}),define("zrender/lib/excanvas",["require"],function(e){return document.createElement("canvas").getContext?G_vmlCanvasManager=!1:function(){function f(){return this.context_||(this.context_=new I(this))}function c(e,t,n){var r=l.call(arguments,2);return function(){return e.apply(t,r.concat(l.call(arguments)))}}function h(e){return String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;")}function p(e,t,n){e.namespaces[t]||e.namespaces.add(t,n,"#default#VML")}function d(e){p(e,"g_vml_","urn:schemas-microsoft-com:vml"),p(e,"g_o_","urn:schemas-microsoft-com:office:office");if(!e.styleSheets.ex_canvas_){var t=e.createStyleSheet();t.owningElement.id="ex_canvas_",t.cssText="canvas{display:inline-block;overflow:hidden;text-align:left;width:300px;height:150px}"}}function m(e){var t=e.srcElement;switch(e.propertyName){case"width":t.getContext().clearRect(),t.style.width=t.attributes.width.nodeValue+"px",t.firstChild.style.width=t.clientWidth+"px";break;case"height":t.getContext().clearRect(),t.style.height=t.attributes.height.nodeValue+"px",t.firstChild.style.height=t.clientHeight+"px"}}function g(e){var t=e.srcElement;t.firstChild&&(t.firstChild.style.width=t.clientWidth+"px",t.firstChild.style.height=t.clientHeight+"px")}function E(){return[[1,0,0],[0,1,0],[0,0,1]]}function S(e,t){var n=E();for(var r=0;r<3;r++)for(var i=0;i<3;i++){var s=0;for(var o=0;o<3;o++)s+=e[r][o]*t[o][i];n[r][i]=s}return n}function x(e,t){t.fillStyle=e.fillStyle,t.lineCap=e.lineCap,t.lineJoin=e.lineJoin,t.lineWidth=e.lineWidth,t.miterLimit=e.miterLimit,t.shadowBlur=e.shadowBlur,t.shadowColor=e.shadowColor,t.shadowOffsetX=e.shadowOffsetX,t.shadowOffsetY=e.shadowOffsetY,t.strokeStyle=e.strokeStyle,t.globalAlpha=e.globalAlpha,t.font=e.font,t.textAlign=e.textAlign,t.textBaseline=e.textBaseline,t.arcScaleX_=e.arcScaleX_,t.arcScaleY_=e.arcScaleY_,t.lineScale_=e.lineScale_}function N(e){var t=e.indexOf("(",3),n=e.indexOf(")",t+1),r=e.substring(t+1,n).split(",");if(r.length!=4||e.charAt(3)!="a")r[3]=1;return r}function C(e){return parseFloat(e)/100}function k(e,t,n){return Math.min(n,Math.max(t,e))}function L(e){var t,n,r,i,s,o;i=parseFloat(e[0])/360%360,i<0&&i++,s=k(C(e[1]),0,1),o=k(C(e[2]),0,1);if(s==0)t=n=r=o;else{var u=o<.5?o*(1+s):o+s-o*s,a=2*o-u;t=A(a,u,i+1/3),n=A(a,u,i),r=A(a,u,i-1/3)}return"#"+y[Math.floor(t*255)]+y[Math.floor(n*255)]+y[Math.floor(r*255)]}function A(e,t,n){return n<0&&n++,n>1&&n--,6*n<1?e+(t-e)*6*n:2*n<1?t:3*n<2?e+(t-e)*(2/3-n)*6:e}function M(e){if(e in O)return O[e];var t,n=1;e=String(e);if(e.charAt(0)=="#")t=e;else if(/^rgb/.test(e)){var r=N(e),t="#",i;for(var s=0;s<3;s++)r[s].indexOf("%")!=-1?i=Math.floor(C(r[s])*255):i=+r[s],t+=y[k(i,0,255)];n=+r[3]}else if(/^hsl/.test(e)){var r=N(e);t=L(r),n=r[3]}else t=T[e]||e;return O[e]={color:t,alpha:n}}function P(e){if(D[e])return D[e];var t=document.createElement("div"),n=t.style;try{n.font=e}catch(r){}return D[e]={style:n.fontStyle||_.style,variant:n.fontVariant||_.variant,weight:n.fontWeight||_.weight,size:n.fontSize||_.size,family:n.fontFamily||_.family}}function H(e,t){var n={};for(var r in e)n[r]=e[r];var i=parseFloat(t.currentStyle.fontSize),s=parseFloat(e.size);return typeof e.size=="number"?n.size=e.size:e.size.indexOf("px")!=-1?n.size=s:e.size.indexOf("em")!=-1?n.size=i*s:e.size.indexOf("%")!=-1?n.size=i/100*s:e.size.indexOf("pt")!=-1?n.size=s/.75:n.size=i,n.size*=.981,n}function B(e){return e.style+" "+e.variant+" "+e.weight+" "+e.size+"px "+e.family}function F(e){return j[e]||"square"}function I(e){this.m_=E(),this.mStack_=[],this.aStack_=[],this.currentPath_=[],this.strokeStyle="#000",this.fillStyle="#000",this.lineWidth=1,this.lineJoin="miter",this.lineCap="butt",this.miterLimit=o*1,this.globalAlpha=1,this.font="10px sans-serif",this.textAlign="left",this.textBaseline="alphabetic",this.canvas=e;var t="width:"+e.clientWidth+"px;height:"+e.clientHeight+"px;overflow:hidden;position:absolute",n=e.ownerDocument.createElement("div");n.style.cssText=t,e.appendChild(n);var r=n.cloneNode(!1);r.style.backgroundColor="red",r.style.filter="alpha(opacity=0)",e.appendChild(r),this.element_=n,this.arcScaleX_=1,this.arcScaleY_=1,this.lineScale_=1}function R(e,t,n,r){e.currentPath_.push({type:"bezierCurveTo",cp1x:t.x,cp1y:t.y,cp2x:n.x,cp2y:n.y,x:r.x,y:r.y}),e.currentX_=r.x,e.currentY_=r.y}function U(e,t){var n=M(e.strokeStyle),r=n.color,i=n.alpha*e.globalAlpha,s=e.lineScale_*e.lineWidth;s<1&&(i*=s),t.push("<g_vml_:stroke",' opacity="',i,'"',' joinstyle="',e.lineJoin,'"',' miterlimit="',e.miterLimit,'"',' endcap="',F(e.lineCap),'"',' weight="',s,'px"',' color="',r,'" />')}function z(t,n,r,i){var s=t.fillStyle,u=t.arcScaleX_,a=t.arcScaleY_,f=i.x-r.x,l=i.y-r.y;if(s instanceof $){var c=0,h={x:0,y:0},p=0,d=1;if(s.type_=="gradient"){var v=s.x0_/u,m=s.y0_/a,g=s.x1_/u,y=s.y1_/a,b=W(t,v,m),w=W(t,g,y),E=w.x-b.x,S=w.y-b.y;c=Math.atan2(E,S)*180/Math.PI,c<0&&(c+=360),c<1e-6&&(c=0)}else{var b=W(t,s.x0_,s.y0_);h={x:(b.x-r.x)/f,y:(b.y-r.y)/l},f/=u*o,l/=a*o;var x=e.max(f,l);p=2*s.r0_/x,d=2*s.r1_/x-p}var T=s.colors_;T.sort(function(e,t){return e.offset-t.offset});var N=T.length,C=T[0].color,k=T[N-1].color,L=T[0].alpha*t.globalAlpha,A=T[N-1].alpha*t.globalAlpha,O=[];for(var _=0;_<N;_++){var D=T[_];O.push(D.offset*d+p+" "+D.color)}n.push('<g_vml_:fill type="',s.type_,'"',' method="none" focus="100%"',' color="',C,'"',' color2="',k,'"',' colors="',O.join(","),'"',' opacity="',A,'"',' g_o_:opacity2="',L,'"',' angle="',c,'"',' focusposition="',h.x,",",h.y,'" />')}else if(s instanceof J){if(f&&l){var P=-r.x,H=-r.y;n.push("<g_vml_:fill",' position="',P/f*u*u,",",H/l*a*a,'"',' type="tile"',' src="',s.src_,'" />')}}else{var B=M(t.fillStyle),j=B.color,F=B.alpha*t.globalAlpha;n.push('<g_vml_:fill color="',j,'" opacity="',F,'" />')}}function W(e,t,n){var r=e.m_;return{x:o*(t*r[0][0]+n*r[1][0]+r[2][0])-u,y:o*(t*r[0][1]+n*r[1][1]+r[2][1])-u}}function X(e){return isFinite(e[0][0])&&isFinite(e[0][1])&&isFinite(e[1][0])&&isFinite(e[1][1])&&isFinite(e[2][0])&&isFinite(e[2][1])}function V(e,t,n){if(!X(t))return;e.m_=t;if(n){var r=t[0][0]*t[1][1]-t[0][1]*t[1][0];e.lineScale_=s(i(r))}}function $(e){this.type_=e,this.x0_=0,this.y0_=0,this.r0_=0,this.x1_=0,this.y1_=0,this.r1_=0,this.colors_=[]}function J(e,t){Q(e);switch(t){case"repeat":case null:case"":this.repetition_="repeat";break;case"repeat-x":case"repeat-y":case"no-repeat":this.repetition_=t;break;default:K("SYNTAX_ERR")}this.src_=e.src,this.width_=e.width,this.height_=e.height}function K(e){throw new G(e)}function Q(e){(!e||e.nodeType!=1||e.tagName!="IMG")&&K("TYPE_MISMATCH_ERR"),e.readyState!="complete"&&K("INVALID_STATE_ERR")}function G(e){this.code=this[e],this.message=e+": DOM Exception "+this.code}var e=Math,t=e.round,n=e.sin,r=e.cos,i=e.abs,s=e.sqrt,o=10,u=o/2,a=+navigator.userAgent.match(/MSIE ([\d.]+)?/)[1],l=Array.prototype.slice;d(document);var v={init:function(e){var t=e||document;t.createElement("canvas"),t.attachEvent("onreadystatechange",c(this.init_,this,t))},init_:function(e){var t=e.getElementsByTagName("canvas");for(var n=0;n<t.length;n++)this.initElement(t[n])},initElement:function(e){if(!e.getContext){e.getContext=f,d(e.ownerDocument),e.innerHTML="",e.attachEvent("onpropertychange",m),e.attachEvent("onresize",g);var t=e.attributes;t.width&&t.width.specified?e.style.width=t.width.nodeValue+"px":e.width=e.clientWidth,t.height&&t.height.specified?e.style.height=t.height.nodeValue+"px":e.height=e.clientHeight}return e}};v.init();var y=[];for(var b=0;b<16;b++)for(var w=0;w<16;w++)y[b*16+w]=b.toString(16)+w.toString(16);var T={aliceblue:"#F0F8FF",antiquewhite:"#FAEBD7",aquamarine:"#7FFFD4",azure:"#F0FFFF",beige:"#F5F5DC",bisque:"#FFE4C4",black:"#000000",blanchedalmond:"#FFEBCD",blueviolet:"#8A2BE2",brown:"#A52A2A",burlywood:"#DEB887",cadetblue:"#5F9EA0",chartreuse:"#7FFF00",chocolate:"#D2691E",coral:"#FF7F50",cornflowerblue:"#6495ED",cornsilk:"#FFF8DC",crimson:"#DC143C",cyan:"#00FFFF",darkblue:"#00008B",darkcyan:"#008B8B",darkgoldenrod:"#B8860B",darkgray:"#A9A9A9",darkgreen:"#006400",darkgrey:"#A9A9A9",darkkhaki:"#BDB76B",darkmagenta:"#8B008B",darkolivegreen:"#556B2F",darkorange:"#FF8C00",darkorchid:"#9932CC",darkred:"#8B0000",darksalmon:"#E9967A",darkseagreen:"#8FBC8F",darkslateblue:"#483D8B",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",darkturquoise:"#00CED1",darkviolet:"#9400D3",deeppink:"#FF1493",deepskyblue:"#00BFFF",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1E90FF",firebrick:"#B22222",floralwhite:"#FFFAF0",forestgreen:"#228B22",gainsboro:"#DCDCDC",ghostwhite:"#F8F8FF",gold:"#FFD700",goldenrod:"#DAA520",grey:"#808080",greenyellow:"#ADFF2F",honeydew:"#F0FFF0",hotpink:"#FF69B4",indianred:"#CD5C5C",indigo:"#4B0082",ivory:"#FFFFF0",khaki:"#F0E68C",lavender:"#E6E6FA",lavenderblush:"#FFF0F5",lawngreen:"#7CFC00",lemonchiffon:"#FFFACD",lightblue:"#ADD8E6",lightcoral:"#F08080",lightcyan:"#E0FFFF",lightgoldenrodyellow:"#FAFAD2",lightgreen:"#90EE90",lightgrey:"#D3D3D3",lightpink:"#FFB6C1",lightsalmon:"#FFA07A",lightseagreen:"#20B2AA",lightskyblue:"#87CEFA",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#B0C4DE",lightyellow:"#FFFFE0",limegreen:"#32CD32",linen:"#FAF0E6",magenta:"#FF00FF",mediumaquamarine:"#66CDAA",mediumblue:"#0000CD",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",mediumseagreen:"#3CB371",mediumslateblue:"#7B68EE",mediumspringgreen:"#00FA9A",mediumturquoise:"#48D1CC",mediumvioletred:"#C71585",midnightblue:"#191970",mintcream:"#F5FFFA",mistyrose:"#FFE4E1",moccasin:"#FFE4B5",navajowhite:"#FFDEAD",oldlace:"#FDF5E6",olivedrab:"#6B8E23",orange:"#FFA500",orangered:"#FF4500",orchid:"#DA70D6",palegoldenrod:"#EEE8AA",palegreen:"#98FB98",paleturquoise:"#AFEEEE",palevioletred:"#DB7093",papayawhip:"#FFEFD5",peachpuff:"#FFDAB9",peru:"#CD853F",pink:"#FFC0CB",plum:"#DDA0DD",powderblue:"#B0E0E6",rosybrown:"#BC8F8F",royalblue:"#4169E1",saddlebrown:"#8B4513",salmon:"#FA8072",sandybrown:"#F4A460",seagreen:"#2E8B57",seashell:"#FFF5EE",sienna:"#A0522D",skyblue:"#87CEEB",slateblue:"#6A5ACD",slategray:"#708090",slategrey:"#708090",snow:"#FFFAFA",springgreen:"#00FF7F",steelblue:"#4682B4",tan:"#D2B48C",thistle:"#D8BFD8",tomato:"#FF6347",turquoise:"#40E0D0",violet:"#EE82EE",wheat:"#F5DEB3",whitesmoke:"#F5F5F5",yellowgreen:"#9ACD32"},O={},_={style:"normal",variant:"normal",weight:"normal",size:10,family:"sans-serif"},D={},j={butt:"flat",round:"round"},q=I.prototype;q.clearRect=function(){this.textMeasureEl_&&(this.textMeasureEl_.removeNode(!0),this.textMeasureEl_=null),this.element_.innerHTML=""},q.beginPath=function(){this.currentPath_=[]},q.moveTo=function(e,t){var n=W(this,e,t);this.currentPath_.push({type:"moveTo",x:n.x,y:n.y}),this.currentX_=n.x,this.currentY_=n.y},q.lineTo=function(e,t){var n=W(this,e,t);this.currentPath_.push({type:"lineTo",x:n.x,y:n.y}),this.currentX_=n.x,this.currentY_=n.y},q.bezierCurveTo=function(e,t,n,r,i,s){var o=W(this,i,s),u=W(this,e,t),a=W(this,n,r);R(this,u,a,o)},q.quadraticCurveTo=function(e,t,n,r){var i=W(this,e,t),s=W(this,n,r),o={x:this.currentX_+2/3*(i.x-this.currentX_),y:this.currentY_+2/3*(i.y-this.currentY_)},u={x:o.x+(s.x-this.currentX_)/3,y:o.y+(s.y-this.currentY_)/3};R(this,o,u,s)},q.arc=function(e,t,i,s,a,f){i*=o;var l=f?"at":"wa",c=e+r(s)*i-u,h=t+n(s)*i-u,p=e+r(a)*i-u,d=t+n(a)*i-u;c==p&&!f&&(c+=.125);var v=W(this,e,t),m=W(this,c,h),g=W(this,p,d);this.currentPath_.push({type:l,x:v.x,y:v.y,radius:i,xStart:m.x,yStart:m.y,xEnd:g.x,yEnd:g.y})},q.rect=function(e,t,n,r){this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath()},q.strokeRect=function(e,t,n,r){var i=this.currentPath_;this.beginPath(),this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath(),this.stroke(),this.currentPath_=i},q.fillRect=function(e,t,n,r){var i=this.currentPath_;this.beginPath(),this.moveTo(e,t),this.lineTo(e+n,t),this.lineTo(e+n,t+r),this.lineTo(e,t+r),this.closePath(),this.fill(),this.currentPath_=i},q.createLinearGradient=function(e,t,n,r){var i=new $("gradient");return i.x0_=e,i.y0_=t,i.x1_=n,i.y1_=r,i},q.createRadialGradient=function(e,t,n,r,i,s){var o=new $("gradientradial");return o.x0_=e,o.y0_=t,o.r0_=n,o.x1_=r,o.y1_=i,o.r1_=s,o},q.drawImage=function(n,r){var i,s,u,a,f,l,c,h,p=n.runtimeStyle.width,d=n.runtimeStyle.height;n.runtimeStyle.width="auto",n.runtimeStyle.height="auto";var v=n.width,m=n.height;n.runtimeStyle.width=p,n.runtimeStyle.height=d;if(arguments.length==3)i=arguments[1],s=arguments[2],f=l=0,c=u=v,h=a=m;else if(arguments.length==5)i=arguments[1],s=arguments[2],u=arguments[3],a=arguments[4],f=l=0,c=v,h=m;else{if(arguments.length!=9)throw Error("Invalid number of arguments");f=arguments[1],l=arguments[2],c=arguments[3],h=arguments[4],i=arguments[5],s=arguments[6],u=arguments[7],a=arguments[8]}var g=W(this,i,s),y=c/2,b=h/2,w=[],E=10,S=10;w.push(" <g_vml_:group",' coordsize="',o*E,",",o*S,'"',' coordorigin="0,0"',' style="width:',E,"px;height:",S,"px;position:absolute;");if(this.m_[0][0]!=1||this.m_[0][1]||this.m_[1][1]!=1||this.m_[1][0]){var x=[];x.push("M11=",this.m_[0][0],",","M12=",this.m_[1][0],",","M21=",this.m_[0][1],",","M22=",this.m_[1][1],",","Dx=",t(g.x/o),",","Dy=",t(g.y/o),"");var T=g,N=W(this,i+u,s),C=W(this,i,s+a),k=W(this,i+u,s+a);T.x=e.max(T.x,N.x,C.x,k.x),T.y=e.max(T.y,N.y,C.y,k.y),w.push("padding:0 ",t(T.x/o),"px ",t(T.y/o),"px 0;filter:progid:DXImageTransform.Microsoft.Matrix(",x.join(""),", sizingmethod='clip');")}else w.push("top:",t(g.y/o),"px;left:",t(g.x/o),"px;");w.push(' ">','<g_vml_:image src="',n.src,'"',' style="width:',o*u,"px;"," height:",o*a,'px"',' cropleft="',f/v,'"',' croptop="',l/m,'"',' cropright="',(v-f-c)/v,'"',' cropbottom="',(m-l-h)/m,'"'," />","</g_vml_:group>"),this.element_.insertAdjacentHTML("BeforeEnd",w.join(""))},q.stroke=function(e){var n=[],r=!1,i=10,s=10;n.push("<g_vml_:shape",' filled="',!!e,'"',' style="position:absolute;width:',i,"px;height:",s,'px;"',' coordorigin="0,0"',' coordsize="',o*i,",",o*s,'"',' stroked="',!e,'"',' path="');var u=!1,a={x:null,y:null},f={x:null,y:null};for(var l=0;l<this.currentPath_.length;l++){var c=this.currentPath_[l],h;switch(c.type){case"moveTo":h=c,n.push(" m ",t(c.x),",",t(c.y));break;case"lineTo":n.push(" l ",t(c.x),",",t(c.y));break;case"close":n.push(" x "),c=null;break;case"bezierCurveTo":n.push(" c ",t(c.cp1x),",",t(c.cp1y),",",t(c.cp2x),",",t(c.cp2y),",",t(c.x),",",t(c.y));break;case"at":case"wa":n.push(" ",c.type," ",t(c.x-this.arcScaleX_*c.radius),",",t(c.y-this.arcScaleY_*c.radius)," ",t(c.x+this.arcScaleX_*c.radius),",",t(c.y+this.arcScaleY_*c.radius)," ",t(c.xStart),",",t(c.yStart)," ",t(c.xEnd),",",t(c.yEnd))}if(c){if(a.x==null||c.x<a.x)a.x=c.x;if(f.x==null||c.x>f.x)f.x=c.x;if(a.y==null||c.y<a.y)a.y=c.y;if(f.y==null||c.y>f.y)f.y=c.y}}n.push(' ">'),e?z(this,n,a,f):U(this,n),n.push("</g_vml_:shape>"),this.element_.insertAdjacentHTML("beforeEnd",n.join(""))},q.fill=function(){this.stroke(!0)},q.closePath=function(){this.currentPath_.push({type:"close"})},q.save=function(){var e={};x(this,e),this.aStack_.push(e),this.mStack_.push(this.m_),this.m_=S(E(),this.m_)},q.restore=function(){this.aStack_.length&&(x(this.aStack_.pop(),this),this.m_=this.mStack_.pop())},q.translate=function(e,t){var n=[[1,0,0],[0,1,0],[e,t,1]];V(this,S(n,this.m_),!1)},q.rotate=function(e){var t=r(e),i=n(e),s=[[t,i,0],[-i,t,0],[0,0,1]];V(this,S(s,this.m_),!1)},q.scale=function(e,t){this.arcScaleX_*=e,this.arcScaleY_*=t;var n=[[e,0,0],[0,t,0],[0,0,1]];V(this,S(n,this.m_),!0)},q.transform=function(e,t,n,r,i,s){var o=[[e,t,0],[n,r,0],[i,s,1]];V(this,S(o,this.m_),!0)},q.setTransform=function(e,t,n,r,i,s){var o=[[e,t,0],[n,r,0],[i,s,1]];V(this,o,!0)},q.drawText_=function(e,n,r,i,s){var u=this.m_,a=1e3,f=0,l=a,c={x:0,y:0},p=[],d=H(P(this.font),this.element_),v=B(d),m=this.element_.currentStyle,g=this.textAlign.toLowerCase();switch(g){case"left":case"center":case"right":break;case"end":g=m.direction=="ltr"?"right":"left";break;case"start":g=m.direction=="rtl"?"right":"left";break;default:g="left"}switch(this.textBaseline){case"hanging":case"top":c.y=d.size/1.75;break;case"middle":break;default:case null:case"alphabetic":case"ideographic":case"bottom":c.y=-d.size/2.25}switch(g){case"right":f=a,l=.05;break;case"center":f=l=a/2}var y=W(this,n+c.x,r+c.y);p.push('<g_vml_:line from="',-f,' 0" to="',l,' 0.05" ',' coordsize="100 100" coordorigin="0 0"',' filled="',!s,'" stroked="',!!s,'" style="position:absolute;width:1px;height:1px;">'),s?U(this,p):z(this,p,{x:-f,y:0},{x:l,y:d.size});var b=u[0][0].toFixed(3)+","+u[1][0].toFixed(3)+","+u[0][1].toFixed(3)+","+u[1][1].toFixed(3)+",0,0",w=t(y.x/o)+","+t(y.y/o);p.push('<g_vml_:skew on="t" matrix="',b,'" ',' offset="',w,'" origin="',f,' 0" />','<g_vml_:path textpathok="true" />','<g_vml_:textpath on="true" string="',h(e),'" style="v-text-align:',g,";font:",h(v),'" /></g_vml_:line>'),this.element_.insertAdjacentHTML("beforeEnd",p.join(""))},q.fillText=function(e,t,n,r){this.drawText_(e,t,n,r,!1)},q.strokeText=function(e,t,n,r){this.drawText_(e,t,n,r,!0)},q.measureText=function(e){if(!this.textMeasureEl_){var t='<span style="position:absolute;top:-20000px;left:0;padding:0;margin:0;border:none;white-space:pre;"></span>';this.element_.insertAdjacentHTML("beforeEnd",t),this.textMeasureEl_=this.element_.lastChild}var n=this.element_.ownerDocument;return this.textMeasureEl_.innerHTML="",this.textMeasureEl_.style.font=this.font,this.textMeasureEl_.appendChild(n.createTextNode(e)),{width:this.textMeasureEl_.offsetWidth}},q.clip=function(){},q.arcTo=function(){},q.createPattern=function(e,t){return new J(e,t)},$.prototype.addColorStop=function(e,t){t=M(t),this.colors_.push({offset:e,color:t.color,alpha:t.alpha})};var Y=G.prototype=new Error;Y.INDEX_SIZE_ERR=1,Y.DOMSTRING_SIZE_ERR=2,Y.HIERARCHY_REQUEST_ERR=3,Y.WRONG_DOCUMENT_ERR=4,Y.INVALID_CHARACTER_ERR=5,Y.NO_DATA_ALLOWED_ERR=6,Y.NO_MODIFICATION_ALLOWED_ERR=7,Y.NOT_FOUND_ERR=8,Y.NOT_SUPPORTED_ERR=9,Y.INUSE_ATTRIBUTE_ERR=10,Y.INVALID_STATE_ERR=11,Y.SYNTAX_ERR=12,Y.INVALID_MODIFICATION_ERR=13,Y.NAMESPACE_ERR=14,Y.INVALID_ACCESS_ERR=15,Y.VALIDATION_ERR=16,Y.TYPE_MISMATCH_ERR=17,G_vmlCanvasManager=v,CanvasRenderingContext2D=I,CanvasGradient=$,CanvasPattern=J,DOMException=G}(),G_vmlCanvasManager}),define("zrender/shape",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("zrender/tool/vector",[],function(){var e={add:function(e,t,n){return e[0]=t[0]+n[0],e[1]=t[1]+n[1],e},sub:function(e,t,n){return e[0]=t[0]-n[0],e[1]=t[1]-n[1],e},length:function(e){return Math.sqrt(this.lengthSquare(e))},lengthSquare:function(e){return e[0]*e[0]+e[1]*e[1]},mul:function(e,t,n){return e[0]=t[0]*n[0],e[1]=t[1]*n[1],e},dot:function(e,t){return e[0]*t[0]+e[1]*t[1]},scale:function(e,t,n){return e[0]=t[0]*n,e[1]=t[1]*n,e},normalize:function(t,n){var r=e.length(n);return r===0?(t[0]=0,t[1]=0):(t[0]=n[0]/r,t[1]=n[1]/r),t},distance:function(e,t){return Math.sqrt((e[0]-t[0])*(e[0]-t[0])+(e[1]-t[1])*(e[1]-t[1]))},negate:function(e,t){e[0]=-t[0],e[1]=-t[1]},middle:function(e,t,n){return e[0]=(t[0]+n[0])/2,e[1]=(t[1]+n[1])/2,e}};return e}),define("zrender/tool/util",["require","./vector","../lib/excanvas"],function(e){function n(e){var t={"[object Function]":1,"[object RegExp]":1,"[object Date]":1,"[object Error]":1,"[object CanvasGradient]":1},n=e,r,i;if(!e||e instanceof Number||e instanceof String||e instanceof Boolean)return n;if(e instanceof Array){n=[];var s=0;for(r=0,i=e.length;r<i;r++)n[s++]=this.clone(e[r])}else if("object"==typeof e){if(t[Object.prototype.toString.call(e)]||e.__nonRecursion)return n;n={};for(r in e)e.hasOwnProperty(r)&&(n[r]=this.clone(e[r]))}return n}function s(){if(!i){e("../lib/excanvas");if(G_vmlCanvasManager){var t=document.createElement("div");t.style.position="absolute",t.style.top="-1000px",document.body.appendChild(t),i=G_vmlCanvasManager.initElement(t).getContext("2d")}else i=document.createElement("canvas").getContext("2d")}return i}function h(){return u||(o=document.createElement("canvas"),a=o.width,f=o.height,u=o.getContext("2d")),u}function p(e,t){var n=100,r=!1;e+l>a&&(a=e+l+n,o.width=a,r=!0),t+c>f&&(f=t+c+n,o.height=f,r=!0),e<-l&&(l=Math.ceil(-e/n)*n,a+=l,o.width=a,r=!0),t<-c&&(c=Math.ceil(-t/n)*n,f+=c,o.height=f,r=!0),r&&u.translate(l,c)}function d(){return{x:l,y:c}}function v(e,t){if(e.indexOf)return e.indexOf(t);for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}function m(e,t,n){if(e.length===0)return;var r=e[0][0],i=e[0][0],s=e[0][1],o=e[0][1];for(var u=1;u<e.length;u++){var a=e[u];a[0]<r&&(r=a[0]),a[0]>i&&(i=a[0]),a[1]<s&&(s=a[1]),a[1]>o&&(o=a[1])}t[0]=r,t[1]=s,n[0]=i,n[1]=o}function g(e,t,n,r,i,s){var o=y(e[0],t[0],n[0],r[0]),u=y(e[1],t[1],n[1],r[1]);o.push(e[0],r[0]),u.push(e[1],r[1]);var a=Math.min.apply(null,o),f=Math.max.apply(null,o),l=Math.min.apply(null,u),c=Math.max.apply(null,u);i[0]=a,i[1]=l,s[0]=f,s[1]=c}function y(e,t,n,r){var i=[],s=6*n-12*t+6*e,o=9*t+3*r-3*e-9*n,u=3*t-3*e,a=s*s-4*o*u;if(a>0){var f=Math.sqrt(a),l=(-s+f)/(2*o),c=(-s-f)/(2*o);i.push(l,c)}else a===0&&i.push(-s/(2*o));var h=[];for(var p=0;p<i.length;p++){var d=i[p];if(Math.abs(2*o*d+s)>1e-4&&d<1&&d>0){var v=1-d,m=v*v*v*e+3*v*v*d*t+3*v*d*d*n+d*d*d*r;h.push(m)}}return h}function b(e,t,n,r,i){var s=e[0]+n[0]-2*t[0],o;s===0?o=.5:o=(e[0]-t[0])/s,s=e[1]+n[1]-2*t[1];var u;s===0?u=.5:u=(e[1]-t[1])/s,o=Math.max(Math.min(o,1),0),u=Math.max(Math.min(u,1),0);var a=1-o,f=1-u,l=a*a*e[0]+2*a*o*t[0]+o*o*n[0],c=a*a*e[1]+2*a*o*t[1]+o*o*n[1],h=f*f*e[0]+2*f*u*t[0]+u*u*n[0],p=f*f*e[1]+2*f*u*t[1]+u*u*n[1];return m([e.slice(),n.slice(),[l,c],[h,p]],r,i)}var t=e("./vector"),r=function(){function t(t,n,i,s,o){if(n.hasOwnProperty(i))if(o&&typeof t[i]=="object"&&e[Object.prototype.toString.call(t[i])]!=1)r(t[i],n[i],{overwrite:s,recursive:o});else if(s||!(i in t))t[i]=n[i]}var e={"[object Function]":1,"[object RegExp]":1,"[object Date]":1,"[object Error]":1,"[object CanvasGradient]":1};return function(e,n,r){var i=0,s=r||{},o=s.overwrite,u=s.whiteList,a=s.recursive,f;if(u&&u.length){f=u.length;for(;i<f;++i)t(e,n,u[i],o,a)}else for(i in n)t(e,n,i,o,a);return e}}(),i,o,u,a,f,l=0,c=0,w=function(){var e=[],n=[],r=[[],[],[],[]];return function(i,s,o,u,a,f,l){a=a?1:-1,e[0]=Math.cos(o),e[1]=Math.sin(o)*a,t.scale(e,e,s),t.add(e,e,i),n[0]=Math.cos(u),n[1]=Math.sin(u)*a,t.scale(n,n,s),t.add(n,n,i),o%=Math.PI*2,o<0&&(o+=Math.PI*2),u%=Math.PI*2,u<0&&(u+=Math.PI*2),o>u&&(u+=Math.PI*2);var c=0;for(var h=0;h<u;h+=Math.PI/2)if(h>o){var p=r[c++];p[0]=Math.cos(h),p[1]=Math.sin(h)*a,t.scale(p,p,s),t.add(p,p,i)}var d=r.slice(0,c);d.push(e,n),m(d,f,l)}}();return{clone:n,merge:r,getContext:s,getPixelContext:h,getPixelOffset:d,adjustCanvasSize:p,computeBoundingBox:m,computeCubeBezierBoundingBox:g,computeQuadraticBezierBoundingBox:b,computeArcBoundingBox:w,indexOf:v}}),define("zrender/tool/area",["require","../tool/util"],function(e){function r(e,r,u,a){if(!r||!e)return!1;var f=e.type;n||(n=t.getContext());if(!h(r.__rect||e.getRect(r),u,a))return!1;var l=i(f,r,u,a);if(typeof l!="undefined")return l;if(f!="beziercurve"&&e.buildPath&&n.isPointInPath)return s(e,n,r,u,a);if(n.getImageData)return o(e,r,u,a);switch(f){case"heart":return!0;case"droplet":return!0;case"ellipse":return!0;case"trochoid":var c=r.location=="out"?r.r1+r.r2+r.d:r.r1-r.r2+r.d;return p(r,u,a,c);case"rose":return p(r,u,a,r.maxr);default:return!1}}function i(e,t,n,r){switch(e){case"line":return f(t,n,r);case"brokenLine":return l(t,n,r);case"text":return!0;case"ring":return c(t,n,r);case"rectangle":return!0;case"circle":return p(t,n,r,t.r);case"sector":return d(t,n,r);case"path":return m(t,n,r);case"polygon":case"star":case"isogon":return v(t,n,r);case"image":return!0}}function s(e,t,n,r,i){return t.beginPath(),e.buildPath(t,n),t.closePath(),t.isPointInPath(r,i)}function o(e,n,r,i){var s=n.__rect||e.getRect(n),o=t.getPixelContext(),a=t.getPixelOffset();return t.adjustCanvasSize(r,i),o.clearRect(s.x,s.y,s.width,s.height),o.beginPath(),e.brush(o,{style:n}),o.closePath(),u(o,r+a.x,i+a.y)}function u(e,t,n,r){var i;typeof r!="undefined"?(r=Math.floor((r||1)/2),i=e.getImageData(t-r,n-r,r+r,r+r).data):i=e.getImageData(t,n,1,1).data;var s=i.length;while(s--)if(i[s]!==0)return!0;return!1}function a(e,t,n,i){return!r(e,t,n,i)}function f(e,t,n){var r=e.xStart,i=e.yStart,s=e.xEnd,o=e.yEnd,u=e.lineWidth,a=0,f=r;if(r===s)return Math.abs(t-r)<=u/2;a=(i-o)/(r-s),f=(r*o-s*i)/(r-s);var l=(a*t-n+f)*(a*t-n+f)/(a*a+1);return l<=u/2*u/2}function l(e,t,n){var r=e.pointList,i,s=!1;for(var o=0,u=r.length-1;o<u;o++){i={xStart:r[o][0],yStart:r[o][1],xEnd:r[o+1][0],yEnd:r[o+1][1],lineWidth:e.lineWidth};if(!h({x:Math.min(i.xStart,i.xEnd)-i.lineWidth,y:Math.min(i.yStart,i.yEnd)-i.lineWidth,width:Math.abs(i.xStart-i.xEnd)+i.lineWidth,height:Math.abs(i.yStart-i.yEnd)+i.lineWidth},t,n))continue;s=f(i,t,n);if(s)break}return s}function c(e,t,n){return p(e,t,n,e.r)&&!p({x:e.x,y:e.y},t,n,e.r0||0)?!0:!1}function h(e,t,n){return t>=e.x&&t<=e.x+e.width&&n>=e.y&&n<=e.y+e.height?!0:!1}function p(e,t,n,r){return(t-e.x)*(t-e.x)+(n-e.y)*(n-e.y)<r*r}function d(e,t,n){if(!p(e,t,n,e.r)||e.r0>0&&p({x:e.x,y:e.y},t,n,e.r0))return!1;var r=(360-Math.atan2(n-e.y,t-e.x)/Math.PI*180)%360,i=(360+e.endAngle)%360,s=(360+e.startAngle)%360;return i>s?r>=s&&r<=i:!(r>=i&&r<=s)}function v(e,t,n){var r,i,s=e.pointList,o=s.length,u=!1,a=!0,f;for(r=0;r<o;++r)if(s[r][0]==t&&s[r][1]==n){a=!1,u=!0;break}if(a){a=!1,u=!1;for(r=0,i=o-1;r<o;i=r++)if(s[r][1]<n&&n<s[i][1]||s[i][1]<n&&n<s[r][1]){if(t<=s[r][0]||t<=s[i][0]){f=(n-s[r][1])*(s[i][0]-s[r][0])/(s[i][1]-s[r][1])+s[r][0];if(t<f)u=!u;else if(t==f){u=!0;break}}}else if(n==s[r][1]){if(t<s[r][0]){s[r][1]>s[i][1]?--n:++n;break}}else if(s[r][1]==s[i][1]&&n==s[r][1]&&(s[r][0]<t&&t<s[i][0]||s[i][0]<t&&t<s[r][0])){u=!0;break}}return u}function m(e,t,n){var r=e.pointList,i=!1;for(var s=0,o=r.length;s<o;s++){i=v({pointList:r[s]},t,n);if(i)break}return i}function g(e,r){n||(n=t.getContext()),n.save(),r&&(n.font=r);var i=n.measureText(e).width;return n.restore(),i}var t=e("../tool/util"),n;return{isInside:r,isOutside:a,getTextWidth:g}}),define("zrender/tool/matrix",[],function(){var e={create:function(){return[1,0,0,1,0,0]},identity:function(e){e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0},mul:function(e,t,n){return e[0]=t[0]*n[0]+t[2]*n[1],e[1]=t[1]*n[0]+t[3]*n[1],e[2]=t[0]*n[2]+t[2]*n[3],e[3]=t[1]*n[2]+t[3]*n[3],e[4]=t[0]*n[4]+t[2]*n[5]+t[4],e[5]=t[1]*n[4]+t[3]*n[5]+t[5],e},translate:function(e,t,n){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4]+n[0],e[5]=t[5]+n[1],e},rotate:function(e,t,n){var r=t[0],i=t[2],s=t[4],o=t[1],u=t[3],a=t[5],f=Math.sin(n),l=Math.cos(n);return e[0]=r*l+o*f,e[1]=-r*f+o*l,e[2]=i*l+u*f,e[3]=-i*f+l*u,e[4]=l*s+f*a,e[5]=l*a-f*s,e},scale:function(e,t,n){var r=n[0],i=n[1];return e[0]=t[0]*r,e[1]=t[1]*i,e[2]=t[2]*r,e[3]=t[3]*i,e[4]=t[4]*r,e[5]=t[5]*i,e},invert:function(e,t){var n=t[0],r=t[2],i=t[4],s=t[1],o=t[3],u=t[5],a=n*o-s*r;return a?(a=1/a,e[0]=o*a,e[1]=-s*a,e[2]=-r*a,e[3]=n*a,e[4]=(r*u-o*i)*a,e[5]=(s*i-n*u)*a,e):null},mulVector:function(e,t,n){var r=t[0],i=t[2],s=t[4],o=t[1],u=t[3],a=t[5];return e[0]=n[0]*r+n[1]*i+s,e[1]=n[0]*o+n[1]*u+a,e}};return e}),define("zrender/tool/color",["require","../tool/util"],function(e){function f(e){r=e}function l(){r=i}function c(e,t){return e=+e||0,t=t||r,t[e%t.length]}function h(e){s=e}function p(){o=s}function d(){return s}function v(e,r,i,s,o,u,a){n||(n=t.getContext());var f=n.createRadialGradient(e,r,i,s,o,u);for(var l=0,c=a.length;l<c;l++)f.addColorStop(a[l][0],a[l][1]);return f.__nonRecursion=!0,f}function m(e,r,i,s,o){n||(n=t.getContext());var u=n.createLinearGradient(e,r,i,s);for(var a=0,f=o.length;a<f;a++)u.addColorStop(o[a][0],o[a][1]);return u.__nonRecursion=!0,u}function g(e,t,n){e=S(e),t=S(t),e=F(e),t=F(t);var r=[],i=(t[0]-e[0])/n,s=(t[1]-e[1])/n,o=(t[2]-e[2])/n;for(var u=0,a=e[0],f=e[1],l=e[2];u<n;u++)r[u]=b([R(Math.floor(a),[0,255]),R(Math.floor(f),[0,255]),R(Math.floor(l),[0,255])]),a+=i,f+=s,l+=o;return a=t[0],f=t[1],l=t[2],r[u]=b([a,f,l]),r}function y(e,t){var n=[],r=e.length;t===undefined&&(t=20);if(r===1)n=g(e[0],e[0],t);else if(r>1)for(var i=0,s=r-1;i<s;i++){var o=g(e[i],e[i+1],t);i<s-1&&o.pop(),n=n.concat(o)}return n}function b(e,t){t=t||"rgb";if(e&&(e.length===3||e.length===4)){e=q(e,function(e){return e>1?Math.ceil(e):e});if(t.indexOf("hex")>-1)return e=q(e.slice(0,3),function(e){return e=Number(e).toString(16),e.length===1?"0"+e:e}),"#"+e.join("");if(t.indexOf("hs")>-1){var n=q(e.slice(1,3),function(e){return e+"%"});e[1]=n[0],e[2]=n[1]}return t.indexOf("a")>-1?(e.length===3&&e.push(1),e[3]=R(e[3],[0,1]),t+"("+e.slice(0,4).join(",")+")"):t+"("+e.slice(0,3).join(",")+")"}}function w(e){e=_(e),e.indexOf("#")>-1&&(e=x(e));var t=e.replace(/[rgbahsvl%\(\)]/ig,"").split(",");return t=q(t,function(e){return Number(e)}),t}function E(e,t){var n=F(e),r=n[3];return typeof r=="undefined"&&(r=1),e.indexOf("hsb")>-1?n=U(n):e.indexOf("hsl")>-1&&(n=z(n)),t.indexOf("hsb")>-1||t.indexOf("hsv")>-1?n=X(n):t.indexOf("hsl")>-1&&(n=V(n)),n[3]=r,b(n,t)}function S(e){return E(e,"rgba")}function x(e){return E(e,"rgb")}function T(e){return E(e,"hex")}function N(e){return E(e,"hsva")}function C(e){return E(e,"hsv")}function k(e){return E(e,"hsba")}function L(e){return E(e,"hsb")}function A(e){return E(e,"hsla")}function O(e){return E(e,"hsl")}function M(e){for(var t in a)if(T(a[t])===T(e))return t;return null}function _(e){return e=String(e),e=e.replace(/(^\s*)|(\s*$)/g,""),/^[^#]*?$/i.test(e)&&(e=e.replace(/\s/g,"")),e}function D(e){a[e]&&(e=a[e]),e=_(e),e=e.replace(/hsv/i,"hsb");if(/^#[0-9a-f]{3}$/i.test(e)){var t=e.replace("#","").split("");e="#"+t[0]+t[0]+t[1]+t[1]+t[2]+t[2]}return e}function P(e,t){var n=t>0?1:-1;typeof t=="undefined"&&(t=0),t=Math.abs(t)>1?1:Math.abs(t),e=x(e);var r=F(e);for(var i=0;i<3;i++)n===1?r[i]=Math.floor(r[i]*(1-t)):r[i]=Math.floor((255-r[i])*t+r[i]);return"rgb("+r.join(",")+")"}function H(e){var t=F(S(e));return t=q(t,function(e){return 255-e}),b(t,"rgb")}function B(e,t,n){typeof n=="undefined"&&(n=.5),n=1-R(n,[0,1]);var r=n*2-1,i=F(S(e)),s=F(S(t)),o=i[3]-s[3],u=((r*o===-1?r:(r+o)/(1+r*o))+1)/2,a=1-u,f=[];for(var l=0;l<3;l++)f[l]=i[l]*u+s[l]*a;var c=i[3]*n+s[3]*(1-n);return c=Math.max(0,Math.min(1,c)),i[3]===1&&s[3]===1?b(f,"rgb"):(f[3]=c,b(f,"rgba"))}function j(){return T("rgb("+Math.round(Math.random()*256)+","+Math.round(Math.random()*256)+","+Math.round(Math.random()*256)+")")}function F(e){e=D(e);var t=e.match(u);if(t===null)throw new Error("The color format error");var n,r,i=[],s;if(t[2])n=t[2].replace("#","").split(""),s=[n[0]+n[1],n[2]+n[3],n[4]+n[5]],i=q(s,function(e){return R(parseInt(e,16),[0,255])});else if(t[4]){var o=t[4].split(",");r=o[3],s=o.slice(0,3),i=q(s,function(e){return e=Math.floor(e.indexOf("%")>0?parseInt(e,0)*2.55:e),R(e,[0,255])}),typeof r!="undefined"&&i.push(R(parseFloat(r),[0,1]))}else if(t[5]||t[6]){var a=(t[5]||t[6]).split(","),f=parseInt(a[0],0)/360,l=a[1],c=a[2];r=a[3],i=q([l,c],function(e){return R(parseFloat(e)/100,[0,1])}),i.unshift(f),typeof r!="undefined"&&i.push(R(parseFloat(r),[0,1]))}return i}function I(e,t){t===null&&(t=1);var n=F(S(e));return n[3]=R(Number(t).toFixed(4),[0,1]),b(n,"rgba")}function q(e,t){if(typeof t!="function")throw new TypeError;var n=e?e.length:0;for(var r=0;r<n;r++)e[r]=t(e[r]);return e}function R(e,t){return e<=t[0]?e=t[0]:e>=t[1]&&(e=t[1]),e}function U(e){var t=e[0],n=e[1],r=e[2],i,s,o;if(n===0)i=r*255,s=r*255,o=r*255;else{var u=t*6;u===6&&(u=0);var a=Math.floor(u),f=r*(1-n),l=r*(1-n*(u-a)),c=r*(1-n*(1-(u-a))),h=0,p=0,d=0;a===0?(h=r,p=c,d=f):a===1?(h=l,p=r,d=f):a===2?(h=f,p=r,d=c):a===3?(h=f,p=l,d=r):a===4?(h=c,p=f,d=r):(h=r,p=f,d=l),i=h*255,s=p*255,o=d*255}return[i,s,o]}function z(e){var t=e[0],n=e[1],r=e[2],i,s,o;if(n===0)i=r*255,s=r*255,o=r*255;else{var u;r<.5?u=r*(1+n):u=r+n-n*r;var a=2*r-u;i=255*W(a,u,t+1/3),s=255*W(a,u,t),o=255*W(a,u,t-1/3)}return[i,s,o]}function W(e,t,n){return n<0&&(n+=1),n>1&&(n-=1),6*n<1?e+(t-e)*6*n:2*n<1?t:3*n<2?e+(t-e)*(2/3-n)*6:e}function X(e){var t=e[0]/255,n=e[1]/255,r=e[2]/255,i=Math.min(t,n,r),s=Math.max(t,n,r),o=s-i,u=s,a,f;if(o===0)a=0,f=0;else{f=o/s;var l=((s-t)/6+o/2)/o,c=((s-n)/6+o/2)/o,h=((s-r)/6+o/2)/o;t===s?a=h-c:n===s?a=1/3+l-h:r===s&&(a=2/3+c-l),a<0&&(a+=1),a>1&&(a-=1)}return a*=360,f*=100,u*=100,[a,f,u]}function V(e){var t=e[0]/255,n=e[1]/255,r=e[2]/255,i=Math.min(t,n,r),s=Math.max(t,n,r),o=s-i,u=(s+i)/2,a,f;if(o===0)a=0,f=0;else{u<.5?f=o/(s+i):f=o/(2-s-i);var l=((s-t)/6+o/2)/o,c=((s-n)/6+o/2)/o,h=((s-r)/6+o/2)/o;t===s?a=h-c:n===s?a=1/3+l-h:r===s&&(a=2/3+c-l),a<0&&(a+=1),a>1&&(a-=1)}return a*=360,f*=100,u*=100,[a,f,u]}var t=e("../tool/util"),n,r=["#ff9277"," #dddd00"," #ffc877"," #bbe3ff"," #d5ffbb","#bbbbff"," #ddb000"," #b0dd00"," #e2bbff"," #ffbbe3","#ff7777"," #ff9900"," #83dd00"," #77e3ff"," #778fff","#c877ff"," #ff77ab"," #ff6600"," #aa8800"," #77c7ff","#ad77ff"," #ff77ff"," #dd0083"," #777700"," #00aa00","#0088aa"," #8400dd"," #aa0088"," #dd0000"," #772e00"],i=r,s="rgba(255,255,0,0.5)",o=s,u=/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i,a={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#0ff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000",blanchedalmond:"#ffebcd",blue:"#00f",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#0ff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#f0f",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#789",lightslategrey:"#789",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#0f0",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#f0f",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#f00",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#fff",whitesmoke:"#f5f5f5",yellow:"#ff0",yellowgreen:"#9acd32"};return{customPalette:f,resetPalette:l,getColor:c,getHighlightColor:d,customHighlight:h,resetHighlight:p,getRadialGradient:v,getLinearGradient:m,getGradientColors:y,getStepColors:g,reverse:H,mix:B,lift:P,trim:_,random:j,toRGB:x,toRGBA:S,toHex:T,toHSL:O,toHSLA:A,toHSB:L,toHSBA:k,toHSV:C,toHSVA:N,toName:M,toColor:b,toArray:w,alpha:I,getData:F}}),define("zrender/shape/base",["require","../tool/area","../tool/matrix","../tool/vector","../tool/color"],function(e){function s(e){var n=["brush","setContext","dashedLineTo","smoothBezier","smoothSpline","drawText","getHighlightStyle","getHighlightZoom","drift","isCover","updateTransform"],r=n.length,i=e.prototype,s=0,o;for(;s<r;s++)o=n[s],i[o]||(i[o]=t[o])}function o(e,t,n){var r=t.style||{};this.brushTypeOnly&&(r.brushType=this.brushTypeOnly),n&&(r=this.getHighlightStyle(r,t.highlightStyle||{},this.brushTypeOnly)),this.brushTypeOnly=="stroke"&&(r.strokeColor=r.strokeColor||r.color),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),e.beginPath(),this.buildPath(e,r),this.brushTypeOnly!="stroke"&&e.closePath();switch(r.brushType){case"fill":e.fill();break;case"stroke":e.stroke();break;case"both":e.stroke(),e.fill();break;default:e.fill()}typeof r.text!="undefined"&&this.drawText(e,r,t.style),e.restore();return}function u(e,t){t.color&&(e.fillStyle=t.color),t.strokeColor&&(e.strokeStyle=t.strokeColor),typeof t.opacity!="undefined"&&(e.globalAlpha=t.opacity),t.lineCap&&(e.lineCap=t.lineCap),t.lineJoin&&(e.lineJoin=t.lineJoin),t.miterLimit&&(e.miterLimit=t.miterLimit),typeof t.lineWidth!="undefined"&&(e.lineWidth=t.lineWidth),typeof t.shadowBlur!="undefined"&&(e.shadowBlur=t.shadowBlur),t.shadowColor&&(e.shadowColor=t.shadowColor),typeof t.shadowOffsetX!="undefined"&&(e.shadowOffsetX=t.shadowOffsetX),typeof t.shadowOffsetY!="undefined"&&(e.shadowOffsetY=t.shadowOffsetY)}function a(e,t,n,r,i,s){s=typeof s=="undefined"?5:s;var o=r-t,u=i-n,a=Math.floor(Math.sqrt(o*o+u*u)/s);for(var f=0;f<a;++f)e[f%2===0?"moveTo":"lineTo"](t+o/a*f,n+u/a*f)}function f(e,t,n){var r=e.length,s=[],o=[],u=[],a=[],f,l;for(var c=0;c<r;c++){var h=e[c],f,l;if(n)f=e[c===0?r-1:c-1],l=e[(c+1)%r];else{if(c===0||c===r-1){s.push(e[c]);continue}f=e[c-1],l=e[c+1]}i.sub(o,l,f),i.scale(o,o,t);var p=i.distance(h,f),d=i.distance(h,l),v=p+d;p/=v,d/=v,i.scale(u,o,-p),i.scale(a,o,d),s.push(i.add([],h,u)),s.push(i.add([],h,a))}return n&&s.push(s.shift()),s}function l(e,t){var n=e.length,r=[],s=0;for(var o=1;o<n;o++)s+=i.distance(e[o-1],e[o]);var u=s/5;for(var o=0;o<u;o++){var a;t?a=o/(u-1)*n:a=o/(u-1)*(n-1);var f=Math.floor(a),l=a-f,h,p=e[f%n],d,v;t?(h=e[(f-1+n)%n],d=e[(f+1)%n],v=e[(f+2)%n]):(h=e[f===0?f:f-1],d=e[f>n-2?n-1:f+1],v=e[f>n-3?n-1:f+2]);var m=l*l,g=l*m;r.push([c(h[0],p[0],d[0],v[0],l,m,g),c(h[1],p[1],d[1],v[1],l,m,g)])}return r}function c(e,t,n,r,i,s,o){var u=(n-e)*.5,a=(r-t)*.5;return(2*(t-n)+u+a)*o+(-3*(t-n)-2*u-a)*s+u*i+t}function h(e,t,n){t.textColor=t.textColor||t.color||t.strokeColor,e.fillStyle=t.textColor,t.textPosition=="inside"&&(e.shadowColor="rgba(0,0,0,0)");var r=10,i,s,o,u,a=t.textPosition||this.textPosition||"top";if(a!="inside"&&a!="top"&&a!="bottom"&&a!="left"&&a!="right"||!this.getRect)if(a=="start"||a=="end"){var l,c,h,p;if(typeof t.pointList!="undefined"){var d=t.pointList;if(d.length<2)return;var v=d.length;switch(a){case"start":l=d[0][0],c=d[1][0],h=d[0][1],p=d[1][1];break;case"end":l=d[v-2][0],c=d[v-1][0],h=d[v-2][1],p=d[v-1][1]}}else l=t.xStart||0,c=t.xEnd||0,h=t.yStart||0,p=t.yEnd||0;switch(a){case"start":i=l<c?"end":"start",s=h<p?"bottom":"top",o=l,u=h;break;case"end":i=l<c?"start":"end",s=h<p?"top":"bottom",o=c,u=p}r-=4,l!=c?o-=i=="end"?r:-r:i="center",h!=p?u-=s=="bottom"?r:-r:s="middle"}else a=="specific"&&(o=t.textX||0,u=t.textY||0,i="start",s="middle");else{var f=(n||t).__rect||this.getRect(n||t);switch(a){case"inside":o=f.x+f.width/2,u=f.y+f.height/2,i="center",s="middle",t.brushType!="stroke"&&t.textColor==t.color&&(e.fillStyle="#fff");break;case"left":o=f.x-r,u=f.y+f.height/2,i="end",s="middle";break;case"right":o=f.x+f.width+r,u=f.y+f.height/2,i="start",s="middle";break;case"top":o=f.x+f.width/2,u=f.y-r,i="center",s="bottom";break;case"bottom":o=f.x+f.width/2,u=f.y+f.height+r,i="center",s="top"}}typeof o!="undefined"&&typeof u!="undefined"&&(t.textFont&&(e.font=t.textFont),e.textAlign=t.textAlign||i,e.textBaseline=t.textBaseLine||s,e.fillText(t.text,o,u))}function p(t,n,r){var i={};for(var s in t)i[s]=t[s];var o=e("../tool/color"),u=o.getHighlightColor();t.brushType!="stroke"?(i.strokeColor=u,i.lineWidth=(t.lineWidth||1)+this.getHighlightZoom(),i.brushType="both"):r!="stroke"?(i.strokeColor=u,i.lineWidth=(t.lineWidth||1)+this.getHighlightZoom()):i.strokeColor=n.strokeColor||o.mix(t.strokeColor,o.toRGB(u));for(var s in n)i[s]=n[s];return i}function d(){return this.type!="text"?6:2}function v(e,t,n){e.position[0]+=t,e.position[1]+=n}function m(e,t,i){if(e.__needTransform&&e._transform){var s=[];r.invert(s,e._transform);var o=[t,i];r.mulVector(o,s,[t,i,1]),t==o[0]&&i==o[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),t=o[0],i=o[1]}var u;return e.style.__rect?u=e.style.__rect:(u=this.getRect(e.style),e.style.__rect=u),t>=u.x&&t<=u.x+u.width&&i>=u.y&&i<=u.y+u.height?n.isInside(this,e.style,t,i):!1}function g(e){var t=e._transform||r.create();r.identity(t);if(e.scale&&(e.scale[0]!==1||e.scale[1]!==1)){var n=e.scale[2]||0,i=e.scale[3]||0;(n||i)&&r.translate(t,t,[-n,-i]),r.scale(t,t,e.scale),(n||i)&&r.translate(t,t,[n,i])}if(e.rotation)if(e.rotation instanceof Array){if(e.rotation[0]!==0){var n=e.rotation[1]||0,i=e.rotation[2]||0;(n||i)&&r.translate(t,t,[-n,-i]),r.rotate(t,t,e.rotation[0]),(n||i)&&r.translate(t,t,[n,i])}}else e.rotation!==0&&r.rotate(t,t,e.rotation);return e.position&&(e.position[0]!==0||e.position[1]!==0)&&r.translate(t,t,e.position),e._transform=t,t}var t,n=e("../tool/area"),r=e("../tool/matrix"),i=e("../tool/vector");return t={derive:s,brush:o,setContext:u,dashedLineTo:a,smoothBezier:f,smoothSpline:l,drawText:h,getHighlightStyle:p,getHighlightZoom:d,drift:v,isCover:m,updateTransform:g},t}),define("zrender/shape/circle",["require","./base","../shape"],function(e){function t(){this.type="circle"}t.prototype={buildPath:function(e,t){e.arc(t.x,t.y,t.r,0,Math.PI*2,!0);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("circle",new t),t}),define("zrender/shape/ellipse",["require","./base","../shape"],function(e){function t(){this.type="ellipse"}t.prototype={buildPath:function(e,t){var n=.5522848,r=t.x,i=t.y,s=t.a,o=t.b,u=s*n,a=o*n;e.moveTo(r-s,i),e.bezierCurveTo(r-s,i-a,r-u,i-o,r,i-o),e.bezierCurveTo(r+u,i-o,r+s,i-a,r+s,i),e.bezierCurveTo(r+s,i+a,r+u,i+o,r,i+o),e.bezierCurveTo(r-u,i+o,r-s,i+a,r-s,i);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b-t/2),width:e.a*2+t,height:e.b*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("ellipse",new t),t}),define("zrender/shape/line",["require","./base","../shape"],function(e){function t(){this.type="line",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){if(!t.lineType||t.lineType=="solid")e.moveTo(t.xStart,t.yStart),e.lineTo(t.xEnd,t.yEnd);else if(t.lineType=="dashed"||t.lineType=="dotted"){var n=(t.lineWidth||1)*(t.lineType=="dashed"?5:1);this.dashedLineTo(e,t.xStart,t.yStart,t.xEnd,t.yEnd,n)}},getRect:function(e){var t=e.lineWidth||1;return{x:Math.min(e.xStart,e.xEnd)-t,y:Math.min(e.yStart,e.yEnd)-t,width:Math.abs(e.xStart-e.xEnd)+t,height:Math.abs(e.yStart-e.yEnd)+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("line",new t),t}),define("zrender/shape/polygon",["require","./base","../shape"],function(e){function t(){this.type="polygon"}t.prototype={brush:function(e,t,n){var r=t.style||{};n&&(r=this.getHighlightStyle(r,t.highlightStyle||{})),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),e.beginPath(),this.buildPath(e,r),e.closePath(),(r.brushType=="stroke"||r.brushType=="both")&&e.stroke();if(r.brushType=="fill"||r.brushType=="both"||typeof r.brushType=="undefined"){if(r.lineType=="dashed"||r.lineType=="dotted")e.beginPath(),this.buildPath(e,{lineType:"solid",lineWidth:r.lineWidth,pointList:r.pointList}),e.closePath();e.fill()}r.text&&this.drawText(e,r,t.style),e.restore();return},buildPath:function(e,t){var n=t.pointList,r=n[0],i=n[n.length-1];r&&i&&r[0]==i[0]&&r[1]==i[1]&&n.pop();if(n.length<2)return;if(t.smooth&&t.smooth!=="spline"){var s=this.smoothBezier(n,t.smooth,!0);e.moveTo(n[0][0],n[0][1]);var o,u,a,f=n.length;for(var l=0;l<f;l++)o=s[l*2],u=s[l*2+1],a=n[(l+1)%f],e.bezierCurveTo(o[0],o[1],u[0],u[1],a[0],a[1])}else{t.smooth==="spline"&&(n=this.smoothSpline(n,!0));if(!t.lineType||t.lineType=="solid"){e.moveTo(n[0][0],n[0][1]);for(var l=1,c=n.length;l<c;l++)e.lineTo(n[l][0],n[l][1]);e.lineTo(n[0][0],n[0][1])}else if(t.lineType=="dashed"||t.lineType=="dotted"){var h=t._dashLength||(t.lineWidth||1)*(t.lineType=="dashed"?5:1);t._dashLength=h,e.moveTo(n[0][0],n[0][1]);for(var l=1,c=n.length;l<c;l++)this.dashedLineTo(e,n[l-1][0],n[l-1][1],n[l][0],n[l][1],h);this.dashedLineTo(e,n[n.length-1][0],n[n.length-1][1],n[0][0],n[0][1],h)}}return},getRect:function(e){var t=Number.MAX_VALUE,n=Number.MIN_VALUE,r=Number.MAX_VALUE,i=Number.MIN_VALUE,s=e.pointList;for(var o=0,u=s.length;o<u;o++)s[o][0]<t&&(t=s[o][0]),s[o][0]>n&&(n=s[o][0]),s[o][1]<r&&(r=s[o][1]),s[o][1]>i&&(i=s[o][1]);var a;return e.brushType=="stroke"||e.brushType=="fill"?a=e.lineWidth||1:a=0,{x:Math.round(t-a/2),y:Math.round(r-a/2),width:n-t+a,height:i-r+a}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("polygon",new t),t}),define("zrender/shape/brokenLine",["require","../shape","./base","../shape"],function(e){function t(){this.type="brokenLine",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){var n=t.pointList;if(n.length<2)return;if(t.smooth&&t.smooth!=="spline"){var r=this.smoothBezier(n,t.smooth,!1);e.moveTo(n[0][0],n[0][1]);var i,s,o;for(var u=0,a=n.length;u<a-1;u++)i=r[u*2],s=r[u*2+1],o=n[u+1],e.bezierCurveTo(i[0],i[1],s[0],s[1],o[0],o[1])}else{t.smooth==="spline"&&(n=this.smoothSpline(n,!1));if(!t.lineType||t.lineType=="solid"){e.moveTo(n[0][0],n[0][1]);for(var u=1,a=n.length;u<a;u++)e.lineTo(n[u][0],n[u][1])}else if(t.lineType=="dashed"||t.lineType=="dotted"){var f=(t.lineWidth||1)*(t.lineType=="dashed"?5:1);e.moveTo(n[0][0],n[0][1]);for(var u=1,a=n.length;u<a;u++)this.dashedLineTo(e,n[u-1][0],n[u-1][1],n[u][0],n[u][1],f)}}return},getRect:function(t){var n=e("../shape");return n.get("polygon").getRect(t)}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("brokenLine",new t),t}),define("zrender/shape/rectangle",["require","./base","../shape"],function(e){function t(){this.type="rectangle"}t.prototype={_buildRadiusPath:function(e,t){var n=t.x,r=t.y,i=t.width,s=t.height,o=t.radius,u,a,f,l;typeof o=="number"?u=a=f=l=o:o instanceof Array?o.length===1?u=a=f=l=o[0]:o.length===2?(u=f=o[0],a=l=o[1]):o.length===3?(u=o[0],a=l=o[1],f=o[2]):(u=o[0],a=o[1],f=o[2],l=o[3]):u=a=f=l=0,e.moveTo(n+u,r),e.lineTo(n+i-a,r),a!==0&&e.quadraticCurveTo(n+i,r,n+i,r+a),e.lineTo(n+i,r+s-f),f!==0&&e.quadraticCurveTo(n+i,r+s,n+i-f,r+s),e.lineTo(n+l,r+s),l!==0&&e.quadraticCurveTo(n,r+s,n,r+s-l),e.lineTo(n,r+u),u!==0&&e.quadraticCurveTo(n,r,n+u,r)},buildPath:function(e,t){t.radius?this._buildRadiusPath(e,t):(e.moveTo(t.x,t.y),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x,t.y));return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-t/2),y:Math.round(e.y-t/2),width:e.width+t,height:e.height+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("rectangle",new t),t}),define("zrender/shape/ring",["require","./base","../shape"],function(e){function t(){this.type="ring"}t.prototype={buildPath:function(e,t){e.arc(t.x,t.y,t.r,0,Math.PI*2,!1),e.moveTo(t.x+t.r0,t.y),e.arc(t.x,t.y,t.r0,0,Math.PI*2,!0);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("ring",new t),t}),define("zrender/tool/math",[],function(){function t(t,n){return Math.sin(n?t*e:t)}function n(t,n){return Math.cos(n?t*e:t)}function r(t){return t*e}function i(t){return t/e}var e=Math.PI/180;return{sin:t,cos:n,degreeToRadian:r,radianToDegree:i}}),define("zrender/shape/sector",["require","../tool/math","../shape","./base","../shape"],function(e){function n(){this.type="sector"}var t=e("../tool/math");n.prototype={buildPath:function(e,n){var r=n.x,i=n.y,s=typeof n.r0=="undefined"?0:n.r0,o=n.r,u=n.startAngle,a=n.endAngle,f=Math.PI*2;u=t.degreeToRadian(u),a=t.degreeToRadian(a),e.moveTo(t.cos(u)*s+r,i-t.sin(u)*s),e.lineTo(t.cos(u)*o+r,i-t.sin(u)*o),e.arc(r,i,o,f-u,f-a,!0),e.lineTo(t.cos(a)*s+r,i-t.sin(a)*s),s!==0&&e.arc(r,i,s,f-a,f-u,!1);return},getRect:function(n){var r=n.x,i=n.y,s=typeof n.r0=="undefined"?0:n.r0,o=n.r,u=n.startAngle,a=n.endAngle,f=[];u<90&&a>90&&f.push([r,i-o]),u<180&&a>180&&f.push([r-o,i]),u<270&&a>270&&f.push([r,i+o]),u<360&&a>360&&f.push([r+o,i]),u=t.degreeToRadian(u),a=t.degreeToRadian(a),f.push([t.cos(u)*s+r,i-t.sin(u)*s]),f.push([t.cos(u)*o+r,i-t.sin(u)*o]),f.push([t.cos(a)*o+r,i-t.sin(a)*o]),f.push([t.cos(a)*s+r,i-t.sin(a)*s]);var l=e("../shape");return l.get("polygon").getRect({brushType:n.brushType,lineWidth:n.lineWidth,pointList:f})}};var r=e("./base");r.derive(n);var i=e("../shape");return i.define("sector",new n),n}),define("zrender/shape/text",["require","../tool/area","./base","../shape"],function(e){function t(){this.type="text"}t.prototype={brush:function(e,t,n){var r=t.style||{};n&&(r=this.getHighlightStyle(r,t.highlightStyle||{})),e.save(),this.setContext(e,r),t.__needTransform&&e.transform.apply(e,this.updateTransform(t)),r.textFont&&(e.font=r.textFont),e.textAlign=r.textAlign||"start",e.textBaseline=r.textBaseline||"middle";if(r.maxWidth)switch(r.brushType){case"fill":e.fillText(r.text,r.x,r.y,r.maxWidth);break;case"stroke":e.strokeText(r.text,r.x,r.y,r.maxWidth);break;case"both":e.strokeText(r.text,r.x,r.y,r.maxWidth),e.fillText(r.text,r.x,r.y,r.maxWidth);break;default:e.fillText(r.text,r.x,r.y,r.maxWidth)}else switch(r.brushType){case"fill":e.fillText(r.text,r.x,r.y);break;case"stroke":e.strokeText(r.text,r.x,r.y);break;case"both":e.strokeText(r.text,r.x,r.y),e.fillText(r.text,r.x,r.y);break;default:e.fillText(r.text,r.x,r.y)}e.restore();return},getRect:function(t){var n=e("../tool/area"),r=n.getTextWidth(t.text,t.textFont),i=n.getTextWidth("国",t.textFont),s=t.x;t.textAlign=="end"||t.textAlign=="right"?s-=r:t.textAlign=="center"&&(s-=r/2);var o=t.y-i/2;return t.textBaseline=="top"?o+=i/2:t.textBaseline=="bottom"&&(s-=i/2),{x:s,y:o,width:r,height:i}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("text",new t),t}),define("zrender/shape/heart",["require","./base","../shape"],function(e){function t(){this.type="heart"}t.prototype={buildPath:function(e,t){e.moveTo(t.x,t.y),e.bezierCurveTo(t.x+t.a/2,t.y-t.b*2/3,t.x+t.a*2,t.y+t.b/3,t.x,t.y+t.b),e.bezierCurveTo(t.x-t.a*2,t.y+t.b/3,t.x-t.a/2,t.y-t.b*2/3,t.x,t.y);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b/4-t/2),width:e.a*2+t,height:e.b*5/4+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("heart",new t),t}),define("zrender/shape/droplet",["require","./base","../shape"],function(e){function t(){this.type="droplet"}t.prototype={buildPath:function(e,t){e.moveTo(t.x,t.y+t.a),e.bezierCurveTo(t.x+t.a,t.y+t.a,t.x+t.a*3/2,t.y-t.a/3,t.x,t.y-t.b),e.bezierCurveTo(t.x-t.a*3/2,t.y-t.a/3,t.x-t.a,t.y+t.a,t.x,t.y+t.a);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.a-t/2),y:Math.round(e.y-e.b-t/2),width:e.a*2+t,height:e.a+e.b+t}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("droplet",new t),t}),define("zrender/shape/path",["require","./base","../shape"],function(e){function t(){this.type="path"}t.prototype={_parsePathData:function(e){if(!e)return[];var t=e,n=["m","M","l","L","v","V","h","H","z","Z","c","C","q","Q","t","T","s","S","a","A"];t=t.replace(/  /g," "),t=t.replace(/ /g,","),t=t.replace(/,,/g,",");var r;for(r=0;r<n.length;r++)t=t.replace(new RegExp(n[r],"g"),"|"+n[r]);var i=t.split("|"),s=[],o=0,u=0;for(r=1;r<i.length;r++){var a=i[r],f=a.charAt(0);a=a.slice(1),a=a.replace(new RegExp("e,-","g"),"e-");var l=a.split(",");l.length>0&&l[0]===""&&l.shift();for(var c=0;c<l.length;c++)l[c]=parseFloat(l[c]);while(l.length>0){if(isNaN(l[0]))break;var h=null,p=[],d,v,m,g,y,b,w,E,S=o,x=u;switch(f){case"l":o+=l.shift(),u+=l.shift(),h="L",p.push(o,u);break;case"L":o=l.shift(),u=l.shift(),p.push(o,u);break;case"m":o+=l.shift(),u+=l.shift(),h="M",p.push(o,u),f="l";break;case"M":o=l.shift(),u=l.shift(),h="M",p.push(o,u),f="L";break;case"h":o+=l.shift(),h="L",p.push(o,u);break;case"H":o=l.shift(),h="L",p.push(o,u);break;case"v":u+=l.shift(),h="L",p.push(o,u);break;case"V":u=l.shift(),h="L",p.push(o,u);break;case"C":p.push(l.shift(),l.shift(),l.shift(),l.shift()),o=l.shift(),u=l.shift(),p.push(o,u);break;case"c":p.push(o+l.shift(),u+l.shift(),o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="C",p.push(o,u);break;case"S":d=o,v=u,m=s[s.length-1],m.command==="C"&&(d=o+(o-m.points[2]),v=u+(u-m.points[3])),p.push(d,v,l.shift(),l.shift()),o=l.shift(),u=l.shift(),h="C",p.push(o,u);break;case"s":d=o,v=u,m=s[s.length-1],m.command==="C"&&(d=o+(o-m.points[2]),v=u+(u-m.points[3])),p.push(d,v,o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="C",p.push(o,u);break;case"Q":p.push(l.shift(),l.shift()),o=l.shift(),u=l.shift(),p.push(o,u);break;case"q":p.push(o+l.shift(),u+l.shift()),o+=l.shift(),u+=l.shift(),h="Q",p.push(o,u);break;case"T":d=o,v=u,m=s[s.length-1],m.command==="Q"&&(d=o+(o-m.points[0]),v=u+(u-m.points[1])),o=l.shift(),u=l.shift(),h="Q",p.push(d,v,o,u);break;case"t":d=o,v=u,m=s[s.length-1],m.command==="Q"&&(d=o+(o-m.points[0]),v=u+(u-m.points[1])),o+=l.shift(),u+=l.shift(),h="Q",p.push(d,v,o,u);break;case"A":g=l.shift(),y=l.shift(),b=l.shift(),w=l.shift(),E=l.shift(),S=o,x=u,o=l.shift(),u=l.shift(),h="A",p=this._convertPoint(S,x,o,u,w,E,g,y,b);break;case"a":g=l.shift(),y=l.shift(),b=l.shift(),w=l.shift(),E=l.shift(),S=o,x=u,o+=l.shift(),u+=l.shift(),h="A",p=this._convertPoint(S,x,o,u,w,E,g,y,b)}s.push({command:h||f,points:p})}(f==="z"||f==="Z")&&s.push({command:"z",points:[]})}return s},_convertPoint:function(e,t,n,r,i,s,o,u,a){var f=a*(Math.PI/180),l=Math.cos(f)*(e-n)/2+Math.sin(f)*(t-r)/2,c=-1*Math.sin(f)*(e-n)/2+Math.cos(f)*(t-r)/2,h=l*l/(o*o)+c*c/(u*u);h>1&&(o*=Math.sqrt(h),u*=Math.sqrt(h));var p=Math.sqrt((o*o*u*u-o*o*c*c-u*u*l*l)/(o*o*c*c+u*u*l*l));i===s&&(p*=-1),isNaN(p)&&(p=0);var d=p*o*c/u,v=p*-u*l/o,m=(e+n)/2+Math.cos(f)*d-Math.sin(f)*v,g=(t+r)/2+Math.sin(f)*d+Math.cos(f)*v,y=function(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])},b=function(e,t){return(e[0]*t[0]+e[1]*t[1])/(y(e)*y(t))},w=function(e,t){return(e[0]*t[1]<e[1]*t[0]?-1:1)*Math.acos(b(e,t))},E=w([1,0],[(l-d)/o,(c-v)/u]),S=[(l-d)/o,(c-v)/u],x=[(-1*l-d)/o,(-1*c-v)/u],T=w(S,x);return b(S,x)<=-1&&(T=Math.PI),b(S,x)>=1&&(T=0),s===0&&T>0&&(T-=2*Math.PI),s===1&&T<0&&(T+=2*Math.PI),[m,g,o,u,E,T,f,s]},buildPath:function(e,t){var n=t.path,r=this._parsePathData(n),i=t.x||0,s=t.y||0,o,u=t.pointList=[],a=[];for(var f=0,l=r.length;f<l;f++){r[f].command.toUpperCase()=="M"&&(a.length>0&&u.push(a),a=[]),o=r[f].points;for(var c=0,h=o.length;c<h;c+=2)a.push([o[c]+i,o[c+1]+s])}a.length>0&&u.push(a);var p;for(var f=0,l=r.length;f<l;f++){p=r[f].command,o=r[f].points;for(var c=0,h=o.length;c<h;c++)c%2===0?o[c]+=i:o[c]+=s;switch(p){case"L":e.lineTo(o[0],o[1]);break;case"M":e.moveTo(o[0],o[1]);break;case"C":e.bezierCurveTo(o[0],o[1],o[2],o[3],o[4],o[5]);break;case"Q":e.quadraticCurveTo(o[0],o[1],o[2],o[3]);break;case"A":var d=o[0],v=o[1],m=o[2],g=o[3],y=o[4],b=o[5],w=o[6],E=o[7],S=m>g?m:g,x=m>g?1:m/g,T=m>g?g/m:1;e.translate(d,v),e.rotate(w),e.scale(x,T),e.arc(0,0,S,y,y+b,1-E),e.scale(1/x,1/T),e.rotate(-w),e.translate(-d,-v);break;case"z":e.closePath()}}return},getRect:function(e){var t;e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0;var n=Number.MAX_VALUE,r=Number.MIN_VALUE,i=Number.MAX_VALUE,s=Number.MIN_VALUE,o=e.x||0,u=e.y||0,a=this._parsePathData(e.path);for(var f=0;f<a.length;f++){var l=a[f].points;for(var c=0;c<l.length;c++)c%2===0?(l[c]+o<n&&(n=l[c]+o),l[c]+o>r&&(r=l[c]+o)):(l[c]+u<i&&(i=l[c]+u),l[c]+u>s&&(s=l[c]+u))}var h;return n===Number.MAX_VALUE||r===Number.MIN_VALUE||i===Number.MAX_VALUE||s===Number.MIN_VALUE?h={x:0,y:0,width:0,height:0}:h={x:Math.round(n-t/2),y:Math.round(i-t/2),width:r-n+t,height:s-i+t},h}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("path",new t),t}),define("zrender/shape/image",["require","./base","../shape"],function(e){function i(){this.type="image"}var t={},n=[],r;i.prototype={brush:function(e,i,s,o){var u=i.style||{};s&&(u=this.getHighlightStyle(u,i.highlightStyle||{}));var a=u.image;if(typeof a=="string"){var f=a;t[f]?a=t[f]:(a=document.createElement("image"),a.onload=function(){a.onload=null,clearTimeout(r),n.push(i),r=setTimeout(function(){o(n),n=[]},10)},t[f]=a,a.src=f)}if(a){if(window.ActiveXObject){if(a.readyState!="complete")return}else if(!a.complete)return;e.save(),this.setContext(e,u),i.__needTransform&&e.transform.apply(e,this.updateTransform(i));var l=u.width||a.width,c=u.height||a.height,h=u.x,p=u.y;if(u.sWidth&&u.sHeight){var d=u.sx||0,v=u.sy||0;e.drawImage(a,d,v,u.sWidth,u.sHeight,h,p,l,c)}else if(u.sx&&u.sy){var d=u.sx,v=u.sy,m=l-d,g=c-v;e.drawImage(a,d,v,m,g,h,p,l,c)}else e.drawImage(a,h,p,l,c);u.width=l,u.height=c,i.style.width=l,i.style.height=c,u.text&&this.drawText(e,u,i.style),e.restore()}return},buildPath:function(e,t){e.rect(t.x,t.y,t.width,t.height);return},getRect:function(e){return{x:e.x,y:e.y,width:e.width,height:e.height}}};var s=e("./base");s.derive(i);var o=e("../shape");return o.define("image",new i),i}),define("zrender/shape/beziercurve",["require","./base","../shape"],function(e){function t(){this.type="beziercurve",this.brushTypeOnly="stroke",this.textPosition="end"}t.prototype={buildPath:function(e,t){e.moveTo(t.xStart,t.yStart),typeof t.cpX2!="undefined"&&typeof t.cpY2!="undefined"?e.bezierCurveTo(t.cpX1,t.cpY1,t.cpX2,t.cpY2,t.xEnd,t.yEnd):e.quadraticCurveTo(t.cpX1,t.cpY1,t.xEnd,t.yEnd)},getRect:function(e){var t=Math.min(e.xStart,e.xEnd,e.cpX1),n=Math.min(e.yStart,e.yEnd,e.cpY1),r=Math.max(e.xStart,e.xEnd,e.cpX1),i=Math.max(e.yStart,e.yEnd,e.cpY1),s=e.cpX2,o=e.cpY2;typeof s!="undefined"&&typeof o!="undefined"&&(t=Math.min(t,s),n=Math.min(n,o),r=Math.max(r,s),i=Math.max(i,o));var u=e.lineWidth||1;return{x:t-u,y:n-u,width:r-t+u,height:i-n+u}}};var n=e("./base");n.derive(t);var r=e("../shape");return r.define("beziercurve",new t),t}),define("zrender/shape/star",["require","../tool/math","./base","../shape"],function(e){function s(){this.type="heart"}var t=e("../tool/math"),n=t.sin,r=t.cos,i=Math.PI;s.prototype={buildPath:function(e,t){var s=t.n;if(!s||s<2)return;var o=t.x,u=t.y,a=t.r,f=t.r0;f==null&&(f=s>4?a*r(2*i/s)/r(i/s):a/3);var l=i/s,c=-i/2,h=o+a*r(c),p=u+a*n(c);c+=l;var d=t.pointList=[];d.push([h,p]);for(var v=0,m=s*2-1,g;v<m;v++)g=v%2===0?f:a,d.push([o+g*r(c),u+g*n(c)]),c+=l;d.push([h,p]),e.moveTo(d[0][0],d[0][1]);for(var v=0;v<d.length;v++)e.lineTo(d[v][0],d[v][1]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var o=e("./base");o.derive(s);var u=e("../shape");return u.define("star",new s),s}),define("zrender/shape/isogon",["require","../tool/math","./base","../shape"],function(e){function s(){this.type="isogon"}var t=e("../tool/math"),n=t.sin,r=t.cos,i=Math.PI;s.prototype={buildPath:function(e,t){var s=t.n;if(!s||s<2)return;var o=t.x,u=t.y,a=t.r,f=2*i/s,l=-i/2,c=o+a*r(l),h=u+a*n(l);l+=f;var p=t.pointList=[];p.push([c,h]);for(var d=0,v=s-1;d<v;d++)p.push([o+a*r(l),u+a*n(l)]),l+=f;p.push([c,h]),e.moveTo(p[0][0],p[0][1]);for(var d=0;d<p.length;d++)e.lineTo(p[d][0],p[d][1]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.r-t/2),y:Math.round(e.y-e.r-t/2),width:e.r*2+t,height:e.r*2+t}}};var o=e("./base");o.derive(s);var u=e("../shape");return u.define("isogon",new s),s}),define("zrender/animation/easing",[],function(){var e={Linear:function(e){return e},QuadraticIn:function(e){return e*e},QuadraticOut:function(e){return e*(2-e)},QuadraticInOut:function(e){return(e*=2)<1?.5*e*e:-0.5*(--e*(e-2)-1)},CubicIn:function(e){return e*e*e},CubicOut:function(e){return--e*e*e+1},CubicInOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)},QuarticIn:function(e){return e*e*e*e},QuarticOut:function(e){return 1- --e*e*e*e},QuarticInOut:function(e){return(e*=2)<1?.5*e*e*e*e:-0.5*((e-=2)*e*e*e-2)},QuinticIn:function(e){return e*e*e*e*e},QuinticOut:function(e){return--e*e*e*e*e+1},QuinticInOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)},SinusoidalIn:function(e){return 1-Math.cos(e*Math.PI/2)},SinusoidalOut:function(e){return Math.sin(e*Math.PI/2)},SinusoidalInOut:function(e){return.5*(1-Math.cos(Math.PI*e))},ExponentialIn:function(e){return e===0?0:Math.pow(1024,e-1)},ExponentialOut:function(e){return e===1?1:1-Math.pow(2,-10*e)},ExponentialInOut:function(e){return e===0?0:e===1?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)},CircularIn:function(e){return 1-Math.sqrt(1-e*e)},CircularOut:function(e){return Math.sqrt(1- --e*e)},CircularInOut:function(e){return(e*=2)<1?-0.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)},ElasticIn:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),-(n*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/r)))},ElasticOut:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),n*Math.pow(2,-10*e)*Math.sin((e-t)*2*Math.PI/r)+1)},ElasticInOut:function(e){var t,n=.1,r=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,t=r/4):t=r*Math.asin(1/n)/(2*Math.PI),(e*=2)<1?-0.5*n*Math.pow(2,10*(e-=1))*Math.sin((e-t)*2*Math.PI/r):n*Math.pow(2,-10*(e-=1))*Math.sin((e-t)*2*Math.PI/r)*.5+1)},BackIn:function(e){var t=1.70158;return e*e*((t+1)*e-t)},BackOut:function(e){var t=1.70158;return--e*e*((t+1)*e+t)+1},BackInOut:function(e){var t=2.5949095;return(e*=2)<1?.5*e*e*((t+1)*e-t):.5*((e-=2)*e*((t+1)*e+t)+2)},BounceIn:function(t){return 1-e.BounceOut(1-t)},BounceOut:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},BounceInOut:function(t){return t<.5?e.BounceIn(t*2)*.5:e.BounceOut(t*2-1)*.5+.5}};return e}),define("zrender/animation/clip",["require","./easing"],function(e){var t=e("./easing"),n=function(e){this._targetPool=e.target||{},this._targetPool.constructor!=Array&&(this._targetPool=[this._targetPool]),this._life=e.life||1e3,this._delay=e.delay||0,this._startTime=(new Date).getTime()+this._delay,this._endTime=this._startTime+this._life*1e3,this.loop=typeof e.loop=="undefined"?!1:e.loop,this.gap=e.gap||0,this.easing=e.easing||"Linear",this.onframe=e.onframe||null,this.ondestroy=e.ondestroy||null,this.onrestart=e.onrestart||null};return n.prototype={step:function(e){var n=(e-this._startTime)/this._life;if(n<0)return;n=Math.min(n,1);var r=typeof this.easing=="string"?t[this.easing]:this.easing,i;return typeof r=="function"?i=r(n):i=n,this.fire("frame",i),n==1?this.loop?(this.restart(),"restart"):(this._needsRemove=!0,"destroy"):null},restart:function(){this._startTime=(new Date).getTime()+this.gap},fire:function(e,t){for(var n=0,r=this._targetPool.length;n<r;n++)this["on"+e]&&this["on"+e](this._targetPool[n],t)}},n.prototype.constructor=n,n}),define("zrender/animation/animation",["require","./clip"],function(e){function s(e,t){return e[t]}function o(e,t,n){e[t]=n}function u(e,t,n){return(t-e)*n+e}function a(e,t,n,r,i){var s=e.length;if(i==1)for(var o=0;o<s;o++)r[o]=u(e[o],t[o],n);else{var a=e[0].length;for(var o=0;o<s;o++)for(var f=0;f<a;f++)r[o][f]=u(e[o][f],t[o][f],n)}}function f(e){return e===undefined?!1:typeof e=="string"?!1:e.length!==undefined}function l(e,t,n,r,i,s,o,u,a){var f=e.length;if(a==1)for(var l=0;l<f;l++)u[l]=c(e[l],t[l],n[l],r[l],i,s,o);else{var h=e[0].length;for(var l=0;l<f;l++)for(var p=0;p<h;p++)u[l][p]=c(e[l][p],t[l][p],n[l][p],r[l][p],i,s,o)}}function c(e,t,n,r,i,s,o){var u=(n-e)*.5,a=(r-t)*.5;return(2*(t-n)+u+a)*o+(-3*(t-n)-2*u-a)*s+u*i+t}function h(e,t,n,r){this._tracks={},this._target=e,this._loop=t||!1,this._getter=n||s,this._setter=r||o,this._clipCount=0,this._delay=0,this._doneList=[],this._onframeList=[],this._clipList=[]}var t=e("./clip"),n=window.requrestAnimationFrame||window.msRequestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||function(e){setTimeout(e,16)},r=Array.prototype.slice,i=function(e){e=e||{},this.stage=e.stage||{},this.onframe=e.onframe||function(){},this._clips=[],this._running=!1};return i.prototype={add:function(e){this._clips.push(e)},remove:function(e){var t=this._clips.indexOf(e);t>=0&&this._clips.splice(t,1)},update:function(){var e=(new Date).getTime(),t=this._clips,n=t.length,r=[],i=[];for(var s=0;s<n;s++){var o=t[s],u=o.step(e);u&&(r.push(u),i.push(o))}this.stage&&this.stage.update&&this._clips.length&&this.stage.update();var a=[];for(var s=0;s<n;s++)t[s]._needsRemove||(a.push(t[s]),t[s]._needsRemove=!1);this._clips=a,n=r.length;for(var s=0;s<n;s++)i[s].fire(r[s]);this.onframe()},start:function(){function t(){e._running&&(e.update(),n(t))}var e=this;this._running=!0,n(t)},stop:function(){this._running=!1},clear:function(){this._clips=[]},animate:function(e,t){t=t||{};var n=new h(e,t.loop,t.getter,t.setter);return n.animation=this,n}},i.prototype.constructor=i,h.prototype={when:function(e,t){for(var n in t)this._tracks[n]||(this._tracks[n]=[],this._tracks[n].push({time:0,value:this._getter(this._target,n)})),this._tracks[n].push({time:parseInt(e,10),value:t[n]});return this},during:function(e){return this._onframeList.push(e),this},start:function(e){var n=this,i=this._setter,s=this._getter,o=n._onframeList.length,h=e==="spline",p=function(){n._clipCount--;if(n._clipCount===0){n._tracks={};var e=n._doneList.length;for(var t=0;t<e;t++)n._doneList[t].call(n)}},d=function(d,v){var m=d.length;if(!m)return;var g=d[0].value,y=f(g),b=y&&f(g[0])?2:1;d.sort(function(e,t){return e.time-t.time});var w;if(!m)return;w=d[m-1].time;var E=[],S=[];for(var x=0;x<m;x++){E.push(d[x].time/w);if(y)if(b==2){S[x]=[];for(var T=0;T<g.length;T++)S[x].push(r.call(d[x].value[T]))}else S.push(r.call(d[x].value));else S.push(d[x].value)}var N=0,C=0,k,x,L,A,O,M,_,D=function(e,t){if(t<C){k=Math.min(N+1,m-1);for(x=k;x>=0;x--)if(E[x]<=t)break;x=Math.min(x,m-2)}else{for(x=N;x<m;x++)if(E[x]>t)break;x=Math.min(x-1,m-2)}N=x,C=t;var r=E[x+1]-E[x];if(r===0)return;L=(t-E[x])/r,L<0&&console.log(L),h?(O=S[x],A=S[x===0?x:x-1],M=S[x>m-2?m-1:x+1],_=S[x>m-3?m-1:x+2],y?l(A,O,M,_,L,L*L,L*L*L,s(e,v),b):i(e,v,c(A,O,M,_,L,L*L,L*L*L))):y?a(S[x],S[x+1],L,s(e,v),b):i(e,v,u(S[x],S[x+1],L));for(x=0;x<o;x++)n._onframeList[x](e,t)},P=new t({target:n._target,life:w,loop:n._loop,delay:n._delay,onframe:D,ondestroy:p});e&&e!=="spline"&&(P.easing=e),n._clipList.push(P),n._clipCount++,n.animation.add(P)};for(var v in this._tracks)d(this._tracks[v],v);return this},stop:function(){for(var e=0;e<this._clipList.length;e++){var t=this._clipList[e];this.animation.remove(t)}this._clipList=[]},delay:function(e){return this._delay=e,this},done:function(e){return this._doneList.push(e),this}},i}),define("zrender/config",{loadingEffect:"spin",EVENT:{RESIZE:"resize",CLICK:"click",MOUSEWHEEL:"mousewheel",MOUSEMOVE:"mousemove",MOUSEOVER:"mouseover",MOUSEOUT:"mouseout",MOUSEDOWN:"mousedown",MOUSEUP:"mouseup",GLOBALOUT:"globalout",DRAGSTART:"dragstart",DRAGEND:"dragend",DRAGENTER:"dragenter",DRAGOVER:"dragover",DRAGLEAVE:"dragleave",DROP:"drop",touchClickDelay:300}}),define("zrender/tool/loadingEffect",["require","./util","./color","./color","./color","./color","./color","./math"],function(e){function u(e,t){n[e]=t}function a(e){return{shape:"text",highlightStyle:t.merge({x:s/2,y:o/2,text:r,textAlign:"center",textBaseline:"middle",textFont:i,color:"#333",brushType:"fill"},e,{overwrite:!0,recursive:!0})}}function f(e){return{shape:"rectangle",highlightStyle:{x:0,y:0,width:s,height:o,brushType:"fill",color:e}}}function l(e,t){return e<=t[0]?e=t[0]:e>=t[1]&&(e=t[1]),e}function c(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#888"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{x:0,y:o/2-30,width:s,height:5,brushType:"fill",timeInterval:100}},{overwrite:!1,recursive:!0});var c=a(n.textStyle),h=f(n.backgroundColor),p=n.effectOption,d={shape:"rectangle",highlightStyle:t.clone(p)};d.highlightStyle.color=p.color||u.getLinearGradient(p.x,p.y,p.x+p.width,p.y+p.height,[[0,"#ff6400"],[.5,"#ffe100"],[1,"#b1ff00"]]);if(typeof n.progress!="undefined"){r(h),d.highlightStyle.width=l(n.progress,[0,1])*n.effectOption.width,r(d),r(c),i();return}return d.highlightStyle.width=0,setInterval(function(){r(h),d.highlightStyle.width<n.effectOption.width?d.highlightStyle.width+=8:d.highlightStyle.width=0,r(d),r(c),i()},p.timeInterval)}function h(e,n,r){e.effectOption=t.merge(e.effectOption||{},{x:s/2-80,y:o/2,r:18,colorIn:"#fff",colorOut:"#555",colorWhirl:"#6cf",timeInterval:50});var i=e.effectOption;e=t.merge(e,{textStyle:{color:"#888",x:i.x+i.r+10,y:i.y,textAlign:"start"},backgroundColor:"rgba(250, 250, 250, 0.8)"},{overwrite:!1,recursive:!0});var u=a(e.textStyle),l=f(e.backgroundColor),c={shape:"droplet",highlightStyle:{a:Math.round(i.r/2),b:Math.round(i.r-i.r/6),brushType:"fill",color:i.colorWhirl}},h={shape:"circle",highlightStyle:{r:Math.round(i.r/6),brushType:"fill",color:i.colorIn}},p={shape:"ring",highlightStyle:{r0:Math.round(i.r-i.r/3),r:i.r,brushType:"fill",color:i.colorOut}},d=[0,i.x,i.y];return c.highlightStyle.x=h.highlightStyle.x=p.highlightStyle.x=d[1],c.highlightStyle.y=h.highlightStyle.y=p.highlightStyle.y=d[2],setInterval(function(){n(l),n(p),d[0]-=.3,c.rotation=d,n(c),n(h),n(u),r()},i.timeInterval)}function p(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#fff"},backgroundColor:"rgba(0, 0, 0, 0.8)",effectOption:{n:30,lineWidth:1,color:"random",timeInterval:100}},{overwrite:!1,recursive:!0});var l=a(n.textStyle),c=f(n.backgroundColor),h=n.effectOption,p=h.n,d=h.lineWidth,v=[],m,g,y,b;for(var w=0;w<p;w++)y=-Math.ceil(Math.random()*1e3),g=Math.ceil(Math.random()*400),m=Math.ceil(Math.random()*o),h.color=="random"?b=u.random():b=h.color,v[w]={shape:"line",highlightStyle:{xStart:y,yStart:m,xEnd:y+g,yEnd:m,strokeColor:b,lineWidth:d},animationX:Math.ceil(Math.random()*100),len:g};return setInterval(function(){r(c);var e;for(var t=0;t<p;t++)e=v[t].highlightStyle,e.xStart>=s&&(v[t].len=Math.ceil(Math.random()*400),v[t].highlightStyle.xStart=-400,v[t].highlightStyle.xEnd=-400+v[t].len,v[t].highlightStyle.yStart=Math.ceil(Math.random()*o),v[t].highlightStyle.yEnd=v[t].highlightStyle.yStart),v[t].highlightStyle.xStart+=v[t].animationX,v[t].highlightStyle.xEnd+=v[t].animationX,r(v[t]);r(l),i()},h.timeInterval)}function d(n,r,i){var u=e("./color");n=t.merge(n,{textStyle:{color:"#888"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{n:50,lineWidth:2,brushType:"stroke",color:"random",timeInterval:100}},{overwrite:!1,recursive:!0});var l=a(n.textStyle),c=f(n.backgroundColor),h=n.effectOption,p=h.n,d=h.brushType,v=h.lineWidth,m=[],g;for(var y=0;y<p;y++)h.color=="random"?g=u.alpha(u.random(),.3):g=h.color,m[y]={shape:"circle",highlightStyle:{x:Math.ceil(Math.random()*s),y:Math.ceil(Math.random()*o),r:Math.ceil(Math.random()*40),brushType:d,color:g,strokeColor:g,lineWidth:v},animationY:Math.ceil(Math.random()*20)};return setInterval(function(){r(c);var e;for(var t=0;t<p;t++)e=m[t].highlightStyle,e.y-m[t].animationY+e.r<=0&&(m[t].highlightStyle.y=o+e.r,m[t].highlightStyle.x=Math.ceil(Math.random()*s)),m[t].highlightStyle.y-=m[t].animationY,r(m[t]);r(l),i()},h.timeInterval)}function v(n,r,i){var u=e("./color");n.effectOption=t.merge(n.effectOption||{},{x:s/2-80,y:o/2,r0:9,r:15,n:18,color:"#fff",timeInterval:100});var l=n.effectOption;n=t.merge(n,{textStyle:{color:"#fff",x:l.x+l.r+10,y:l.y,textAlign:"start"},backgroundColor:"rgba(0, 0, 0, 0.8)"},{overwrite:!1,recursive:!0});var c=a(n.textStyle),h=f(n.backgroundColor),p=l.n,d=l.x,v=l.y,m=l.r0,g=l.r,y=l.color,b=[],w=Math.round(180/p);for(var E=0;E<p;E++)b[E]={shape:"sector",highlightStyle:{x:d,y:v,r0:m,r:g,startAngle:w*E*2,endAngle:w*E*2+w,color:u.alpha(y,(E+1)/p),brushType:"fill"}};var S=[0,d,v];return setInterval(function(){r(h),S[0]-=.3;for(var e=0;e<p;e++)b[e].rotation=S,r(b[e]);r(c),i()},l.timeInterval)}function m(n,r,i){var u=e("./color"),c=e("./math");n=t.merge(n,{textStyle:{color:"#07a"},backgroundColor:"rgba(250, 250, 250, 0.8)",effectOption:{x:s/2,y:o/2,r0:60,r:100,color:"#bbdcff",brushType:"fill",textPosition:"inside",textFont:"normal 30px verdana",textColor:"rgba(30, 144, 255, 0.6)",timeInterval:100}},{overwrite:!1,recursive:!0});var h=n.effectOption,p=n.textStyle;p.x=typeof p.x!="undefined"?p.x:h.x,p.y=typeof p.y!="undefined"?p.y:h.y+(h.r0+h.r)/2-5;var d=a(n.textStyle),v=f(n.backgroundColor),m=h.x,g=h.y,y=h.r0+6,b=h.r-6,w=h.color,E=u.lift(w,.1),S={shape:"ring",highlightStyle:t.clone(h)},x=[],T=u.getGradientColors(["#ff6400","#ffe100","#97ff00"],25),N=15,C=240;for(var k=0;k<16;k++)x.push({shape:"sector",highlightStyle:{x:m,y:g,r0:y,r:b,startAngle:C-N,endAngle:C,brushType:"fill",color:E},_color:u.getLinearGradient(m+y*c.cos(C,!0),g-y*c.sin(C,!0),m+y*c.cos(C-N,!0),g-y*c.sin(C-N,!0),[[0,T[k*2]],[1,T[k*2+1]]])}),C-=N;C=360;for(var k=0;k<4;k++)x.push({shape:"sector",highlightStyle:{x:m,y:g,r0:y,r:b,startAngle:C-N,endAngle:C,brushType:"fill",color:E},_color:u.getLinearGradient(m+y*c.cos(C,!0),g-y*c.sin(C,!0),m+y*c.cos(C-N,!0),g-y*c.sin(C-N,!0),[[0,T[k*2+32]],[1,T[k*2+33]]])}),C-=N;var L=0;if(typeof n.progress!="undefined"){r(v),L=l(n.progress,[0,1]).toFixed(2)*100/5,S.highlightStyle.text=L*5+"%",r(S);for(var k=0;k<20;k++)x[k].highlightStyle.color=k<L?x[k]._color:E,r(x[k]);r(d),i();return}return setInterval(function(){r(v),L+=L>=20?-20:1,r(S);for(var e=0;e<20;e++)x[e].highlightStyle.color=e<L?x[e]._color:E,r(x[e]);r(d),i()},h.timeInterval)}function g(e,t,r){var i=n.ring;return typeof e.effect=="function"?i=e.effect:typeof n[e.effect]=="function"&&(i=n[e.effect]),s=e.canvasSize.width,o=e.canvasSize.height,i(e,t,r)}function y(e){clearInterval(e)}var t=e("./util"),n,r="Loading...",i="normal 16px Arial",s,o;return n={getBackgroundShape:f,getTextShape:a,define:u,bar:c,whirling:h,dynamicLine:p,bubble:d,spin:v,ring:m,start:g,stop:y},n}),define("zrender/tool/event",[],function(){function e(e){return typeof e.zrenderX!="undefined"&&e.zrenderX||typeof e.offsetX!="undefined"&&e.offsetX||typeof e.layerX!="undefined"&&e.layerX||typeof e.clientX!="undefined"&&e.clientX}function t(e){return typeof e.zrenderY!="undefined"&&e.zrenderY||typeof e.offsetY!="undefined"&&e.offsetY||typeof e.layerY!="undefined"&&e.layerY||typeof e.clientY!="undefined"&&e.clientY}function n(e){return typeof e.wheelDelta!="undefined"&&e.wheelDelta||typeof e.detail!="undefined"&&-e.detail}function r(e){e.preventDefault?(e.preventDefault(),e.stopPropagation()):(e.returnValue=!1,e.cancelBubble=!0)}function i(){function n(n,r){return!r||!n?e:(t[n]||(t[n]=[]),t[n].push({h:r,one:!0}),e)}function r(n,r){return!r||!n?e:(t[n]||(t[n]=[]),t[n].push({h:r,one:!1}),e)}function i(n,r){if(!n)return t={},e;if(r){if(t[n]){var i=[];for(var s=0,o=t[n].length;s<o;s++)t[n][s]["h"]!=r&&i.push(t[n][s]);t[n]=i}t[n]&&t[n].length===0&&delete t[n]}else delete t[n];return e}function s(n,r,i){if(t[n]){var s=[],o=i||{};o.type=n,o.event=r;for(var u=0,a=t[n].length;u<a;u++)t[n][u].h(o),t[n][u].one||s.push(t[n][u]);s.length!=t[n].length&&(t[n]=s)}return e}var e=this,t={};e.one=n,e.bind=r,e.unbind=i,e.dispatch=s}return{getX:e,getY:t,getDelta:n,stop:r,Dispatcher:i}}),define("zrender/zrender",["require","./lib/excanvas","./shape","./shape/circle","./shape/ellipse","./shape/line","./shape/polygon","./shape/brokenLine","./shape/rectangle","./shape/ring","./shape/sector","./shape/text","./shape/heart","./shape/droplet","./shape/path","./shape/image","./shape/beziercurve","./shape/star","./shape/isogon","./animation/animation","./tool/util","./tool/util","./config","./tool/loadingEffect","./tool/loadingEffect","./config","./tool/event"],function(e){function s(t,r,i){var s=this,f=e("./shape");e("./shape/circle"),e("./shape/ellipse"),e("./shape/line"),e("./shape/polygon"),e("./shape/brokenLine"),e("./shape/rectangle"),e("./shape/ring"),e("./shape/sector"),e("./shape/text"),e("./shape/heart"),e("./shape/droplet"),e("./shape/path"),e("./shape/image"),e("./shape/beziercurve"),e("./shape/star"),e("./shape/isogon");var l;if(typeof i.shape=="undefined")l=f;else{l={};for(var c in i.shape)l[c]=i.shape[c];l.get=function(e){return l[e]||f.get(e)}}var h=new o(l),p=new u(r,h,l),d=new a(r,h,p,l),v=e("./animation/animation"),m=[],g=new v({stage:{update:function(){s.update(m)}}});g.start(),s.getId=function(){return t},s.addShape=function(e){return h.add(e),s},s.delShape=function(e){return h.del(e),s},s.modShape=function(e,t){return h.mod(e,t),s},s.addHoverShape=function(e){return h.addHover(e),s},s.render=function(e){return p.render(e),s},s.refresh=function(e){return p.refresh(e),s},s.refreshHover=function(e){return p.refreshHover(e),s},s.update=function(e,t){return p.update(e,t),s},s.resize=function(){return p.resize(),s},s.animate=function(t,r,i){var s=e("./tool/util"),o=h.get(t);if(o){var u;if(r){var a=r.split("."),f=o;for(var l=0,c=a.length;l<c;l++){if(!f)continue;f=f[a[l]]}f&&(u=f)}else u=o;if(!u){n.log('Property "'+r+'" is not existed in shape '+t);return}return typeof o.__aniCount=="undefined"&&(o.__aniCount=0),o.__aniCount===0&&m.push(o),o.__aniCount++,g.animate(u,{loop:i}).done(function(){o.__aniCount--;if(o.__aniCount===0){var e=s.indexOf(m,o);m.splice(e,1)}})}n.log('Shape "'+t+'" not existed')},s.clearAnimation=function(){g.clear()},s.showLoading=function(e){return p.showLoading(e),s},s.hideLoading=function(){return p.hideLoading(),s},s.newShapeId=function(e){return h.newShapeId(e)},s.getWidth=function(){return p.getWidth()},s.getHeight=function(){return p.getHeight()},s.toDataURL=function(e,t){return p.toDataURL(e,t)},s.on=function(e,t){return d.on(e,t),s},s.un=function(e,t){return d.un(e,t),s},s.clear=function(){return h.del(),p.clear(),s},s.dispose=function(){g.stop(),g=null,m=null,s.clear(),s=null,h.dispose(),h=null,p.dispose(),p=null,d.dispose(),d=null,n.delInstance(t);return}}function o(t){function c(e){e.hoverable||e.onclick||e.draggable||e.onmousemove||e.onmouseover||e.onmouseout||e.onmousedown||e.onmouseup||e.ondragenter||e.ondragover||e.ondragleave||e.ondrop?e.__silent=!1:e.__silent=!0,Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1,e.style=e.style||{},e.style.__rect=null}function h(e){return(e||"")+ ++s}function p(e){var t={shape:"circle",id:e.id||i.newShapeId(),zlevel:0,draggable:!1,clickable:!1,hoverable:!0,position:[0,0],rotation:[0,0,0],scale:[1,1,0,0]};return r.merge(t,e,{overwrite:!0,recursive:!0}),c(t),o[t.id]=t,u[t.zlevel]=u[t.zlevel]||[],u[t.zlevel].push(t),f=Math.max(f,t.zlevel),l[t.zlevel]=!0,i}function d(e){return o[e]}function v(e){if(typeof e!="undefined"){var t={};if(e instanceof Array)for(var n=0,r=e.length;n<r;n++)t[e[n].id]=!0;else t[e]=!0;var s,c,h,p={};for(var d in t)if(o[d]){h=o[d].zlevel,l[h]=!0;if(!p[h]){c=u[h],s=[];for(var n=0,r=c.length;n<r;n++)t[c[n].id]||s.push(c[n]);u[h]=s,p[h]=!0}delete o[d]}}else o={},u=[],a=[],f=0,l={all:!0};return i}function m(e,t){var n=o[e];return n&&(l[n.zlevel]=!0,r.merge(n,t,{overwrite:!0,recursive:!0}),c(n),l[n.zlevel]=!0,f=Math.max(f,n.zlevel)),i}function g(e,r,s){var u=o[e];if(!u)return;u.__needTransform=!0;if(!u.ondrift||u.ondrift&&!u.ondrift(u,r,s))if(n.catchBrushException)try{t.get(u.shape).drift(u,r,s)}catch(a){n.log(a,"drift error of "+u.shape,u)}else t.get(u.shape).drift(u,r,s);return l[u.zlevel]=!0,i}function y(e){return e.rotation&&Math.abs(e.rotation[0])>1e-4||e.position&&(Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4)||e.scale&&(Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4)?e.__needTransform=!0:e.__needTransform=!1,a.push(e),i}function b(){return a=[],i}function w(){return a.length>0}function E(e,t){t||(t={hover:!1,normal:"down"});if(t.hover)for(var n=0,r=a.length;n<r;n++)if(e(a[n]))return i;var s,f;if(typeof t.normal!="undefined")switch(t.normal){case"down":for(var r=u.length-1;r>=0;r--){s=u[r];if(s){f=s.length;while(f--)if(e(s[f]))return i}}break;case"up":for(var n=0,r=u.length;n<r;n++){s=u[n];if(s){f=s.length;for(var l=0;l<f;l++)if(e(s[l]))return i}}break;default:for(var n in o)if(e(o[n]))return i}return i}function S(){return f}function x(){return l}function T(){return l={},i}function N(e){return l[e]=!0,i}function C(){o=null,u=null,a=null,i=null;return}var r=e("./tool/util"),i=this,s=0,o={},u=[],a=[],f=0,l={};i.newShapeId=h,i.add=p,i.get=d,i.del=v,i.addHover=y,i.delHover=b,i.hasHoverShape=w,i.mod=m,i.drift=g,i.iterShape=E,i.getMaxZlevel=S,i.getChangedZlevel=x,i.clearChangedZlevel=T,i.setChangedZlevle=N,i.dispose=C}function u(t,r,i){function v(){var e=t.currentStyle||document.defaultView.getComputedStyle(t);return t.clientWidth-e.paddingLeft.replace(/\D/g,"")-e.paddingRight.replace(/\D/g,"")}function m(){var e=t.currentStyle||document.defaultView.getComputedStyle(t);return t.clientHeight-e.paddingTop.replace(/\D/g,"")-e.paddingBottom.replace(/\D/g,"")}function g(){c.innerHTML="",t.innerHTML="",h=v(),p=m(),c.style.position="relative",c.style.overflow="hidden",c.style.width=h+"px",c.style.height=p+"px",t.appendChild(c),u={},a={},f=r.getMaxZlevel(),u.bg=b("bg","div"),c.appendChild(u.bg);for(var e=0;e<=f;e++)u[e]=b(e,"canvas"),c.appendChild(u[e]),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u[e]),a[e]=u[e].getContext("2d"),d!=1&&a[e].scale(d,d);u.hover=b("hover","canvas"),u.hover.id="_zrender_hover_",c.appendChild(u.hover),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u.hover),a.hover=u.hover.getContext("2d"),d!=1&&a.hover.scale(d,d)}function y(){var e=r.getMaxZlevel();if(f<e){for(var t=f+1;t<=e;t++)u[t]=b(t,"canvas"),c.insertBefore(u[t],u.hover),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(u[t]),a[t]=u[t].getContext("2d"),d!=1&&a[t].scale(d,d);f=e}}function b(e,t){var n=document.createElement(t);return n.style.position="absolute",n.style.left=0,n.style.top=0,n.style.width=h+"px",n.style.height=p+"px",n.setAttribute("width",h*d),n.setAttribute("height",p*d),n.setAttribute("data-id",e),n}function w(e){return function(t){if((e.all||e[t.zlevel])&&!t.invisible){var r=a[t.zlevel];if(r){if(!t.onbrush||t.onbrush&&!t.onbrush(r,t,!1))if(n.catchBrushException)try{i.get(t.shape).brush(r,t,!1,T)}catch(s){n.log(s,"brush error of "+t.shape,t)}else i.get(t.shape).brush(r,t,!1,T)}else n.log("can not find the specific zlevel canvas!")}}}function E(e){var t=a.hover;if(!e.onbrush||e.onbrush&&!e.onbrush(t,e,!0))if(n.catchBrushException)try{i.get(e.shape).brush(t,e,!0,T)}catch(r){n.log(r,"hoverBrush error of "+e.shape,e)}else i.get(e.shape).brush(t,e,!0,T)}function S(e){return O()&&A(),y(),r.iterShape(w({all:!0}),{normal:"up"}),r.clearChangedZlevel(),typeof e=="function"&&e(),o}function x(e){y();var t=r.getChangedZlevel();if(t.all)N();else for(var n in t)a[n]&&a[n].clearRect(0,0,h*d,p*d);return r.iterShape(w(t),{normal:"up"}),r.clearChangedZlevel(),typeof e=="function"&&e(),o}function T(e,t){var n;for(var i=0,s=e.length;i<s;i++)n=e[i],r.mod(n.id,n);return x(t),o}function N(){for(var e in a){if(e=="hover")continue;a[e].clearRect(0,0,h*d,p*d)}return o}function C(){return k(),r.iterShape(E,{hover:!0}),r.delHover(),o}function k(){return a&&a.hover&&a.hover.clearRect(0,0,h*d,p*d),o}function L(t){var n=e("./tool/loadingEffect");return n.stop(l),t=t||{},t.effect=t.effect||s.loadingEffect,t.canvasSize={width:h,height:p},l=n.start(t,r.addHover,C),o.loading=!0,o}function A(){var t=e("./tool/loadingEffect");return t.stop(l),k(),o.loading=!1,o}function O(){return o.loading}function M(){return h}function _(){return p}function D(){var e,t,n;c.style.display="none",e=v(),t=m(),c.style.display="";if(h!=e||t!=p){h=e,p=t,c.style.width=h+"px",c.style.height=p+"px";for(var i in u)n=u[i],n.setAttribute("width",h),n.setAttribute("height",p),n.style.width=h+"px",n.style.height=p+"px";r.setChangedZlevle("all"),x()}return o}function P(){O()&&A(),t.innerHTML="",t=null,r=null,i=null,c=null,u=null,a=null,o=null;return}function H(){return u.hover}function B(e,t){if(G_vmlCanvasManager)return null;var s=b("image","canvas");u.bg.appendChild(s);var o=s.getContext("2d");d!=1&&o.scale(d,d),o.fillStyle="#fff",o.rect(0,0,h*d,p*d),o.fill(),r.iterShape(function(e){if(!e.invisible)if(!e.onbrush||e.onbrush&&!e.onbrush(o,e,!1))if(n.catchBrushException)try{i.get(e.shape).brush(o,e,!1,T)}catch(t){n.log(t,"brush error of "+e.shape,e)}else i.get(e.shape).brush(o,e,!1,T)},{normal:"up"});var a=s.toDataURL(e,t);return o=null,u.bg.removeChild(s),a}var s=e("./config"),o=this,u={},a={},f=0,l,c=document.createElement("div");c.onselectstart=function(){return!1};var h,p,d=window.devicePixelRatio||1;o.render=S,o.refresh=x,o.update=T,o.clear=N,o.refreshHover=C,o.clearHover=k,o.showLoading=L,o.hideLoading=A,o.isLoading=O,o.getWidth=M,o.getHeight=_,o.resize=D,o.dispose=P,o.getDomHover=H,o.toDataURL=B,g()}function a(t,n,r,i){function x(){window.addEventListener?(window.addEventListener("resize",T),t.addEventListener("click",N),t.addEventListener("mousewheel",C),t.addEventListener("DOMMouseScroll",C),t.addEventListener("mousemove",k),t.addEventListener("mouseout",L),t.addEventListener("mousedown",M),t.addEventListener("mouseup",_),t.addEventListener("touchstart",D),t.addEventListener("touchmove",P),t.addEventListener("touchend",H)):(window.attachEvent("onresize",T),t.attachEvent("onclick",N),t.attachEvent("onmousewheel",C),t.attachEvent("onmousemove",k),t.attachEvent("onmouseout",L),t.attachEvent("onmousedown",M),t.attachEvent("onmouseup",_))}function T(e){l=e||window.event,h=null,v=!1,u.dispatch(s.EVENT.RESIZE,l)}function N(e){l=W(e),h?h&&h.clickable&&U(h,s.EVENT.CLICK):U(h,s.EVENT.CLICK),k(l)}function C(e){l=W(e),U(h,s.EVENT.MOUSEWHEEL),k(l)}function k(e){if(r.isLoading())return;l=W(e),y=w,b=E,w=a(l),E=f(l),B(),c=!1,n.iterShape(z,{normal:"down"});if(!c){if(!d||h&&h.id!=d.id)O(),I();h=null,n.delHover(),r.clearHover()}d&&(n.drift(d.id,w-y,E-b),n.addHover(d)),d||c&&h.draggable?t.style.cursor="move":c&&h.clickable?t.style.cursor="pointer":t.style.cursor="default",U(h,s.EVENT.MOUSEMOVE),(d||c||n.hasHoverShape())&&r.refreshHover()}function L(e){l=W(e);var n=l.toElement||l.relatedTarget;if(n!=t)while(n&&n.nodeType!=9){if(n==t){k(e);return}n=n.parentNode}l.zrenderX=y,l.zrenderY=b,t.style.cursor="default",v=!1,O(),q(),R(),r.isLoading()||r.refreshHover(),u.dispatch(s.EVENT.GLOBALOUT,l)}function A(){U(h,s.EVENT.MOUSEOVER)}function O(){U(h,s.EVENT.MOUSEOUT)}function M(e){l=W(e),v=!0,p=h,U(h,s.EVENT.MOUSEDOWN)}function _(e){l=W(e),t.style.cursor="default",v=!1,p=null,U(h,s.EVENT.MOUSEUP),q(),R()}function D(e){l=W(e,!0),g=new Date,M(l)}function P(e){l=W(e,!0),k(l),m&&o.stop(e)}function H(e){l=W(e,!0),_(l),r.clearHover(),new Date-g<s.EVENT.touchClickDelay&&(h=null,w=l.zrenderX,E=l.zrenderY,n.iterShape(z,{normal:"down"}),h||(w+=10,n.iterShape(z,{normal:"down"})),h||(w-=20,n.iterShape(z,{normal:"down"})),h||(w+=10,E+=10,n.iterShape(z,{normal:"down"})),h||(E-=20,n.iterShape(z,{normal:"down"})),h&&(l.zrenderX=w,l.zrenderY=E),N(l))}function B(){v&&h&&h.draggable&&!d&&p==h&&(d=h,m=!0,d.invisible=!0,n.mod(d.id,d),U(d,s.EVENT.DRAGSTART),r.refresh())}function j(){d&&U(h,s.EVENT.DRAGENTER,d)}function F(){d&&U(h,s.EVENT.DRAGOVER,d)}function I(){d&&U(h,s.EVENT.DRAGLEAVE,d)}function q(){d&&(d.invisible=!1,n.mod(d.id,d),r.refresh(),U(h,s.EVENT.DROP,d))}function R(){d&&(U(d,s.EVENT.DRAGEND),h=null),m=!1,d=null}function U(e,t,n){var r="on"+t,i={type:t,event:l,target:e};n&&(i.dragged=n),e?(!e[r]||!e[r](i))&&u.dispatch(t,l,i):n||u.dispatch(t,l)}function z(e){if(d&&d.id==e.id)return!1;if(e.__silent)return!1;var t=i.get(e.shape);return t.isCover(e,w,E)?(e.hoverable&&n.addHover(e),h!=e&&(O(),I(),h=e,j()),A(),F(),c=!0,!0):!1}function W(e,n){if(!n){l=e||window.event;var r=l.toElement||l.relatedTarget||l.srcElement||l.target;r&&r!=S&&(l.zrenderX=(typeof l.offsetX!="undefined"?l.offsetX:l.layerX)+r.offsetLeft,l.zrenderY=(typeof l.offsetY!="undefined"?l.offsetY:l.layerY)+r.offsetTop)}else{l=e;var i=l.type!="touchend"?l.targetTouches[0]:l.changedTouches[0];i&&(l.zrenderX=i.clientX-t.offsetLeft+document.body.scrollLeft,l.zrenderY=i.clientY-t.offsetTop+document.body.scrollTop)}return l}function X(e,t){return u.bind(e,t),u}function V(e,t){return u.unbind(e,t),u}function $(){window.removeEventListener?(window.removeEventListener("resize",T),t.removeEventListener("click",N),t.removeEventListener("mousewheel",C),t.removeEventListener("DOMMouseScroll",C),t.removeEventListener("mousemove",k),t.removeEventListener("mouseout",L),t.removeEventListener("mousedown",M),t.removeEventListener("mouseup",_),t.removeEventListener("touchstart",D),t.removeEventListener("touchmove",P),t.removeEventListener("touchend",H)):(window.detachEvent("onresize",T),t.detachEvent("onclick",N),t.detachEvent("onmousewheel",C),t.detachEvent("onmousemove",k),t.detachEvent("onmouseout",L),t.detachEvent("onmousedown",M),t.detachEvent("onmouseup",_)),t=null,S=null,n=null,r=null,i=null,V(),u=null;return}var s=e("./config"),o=e("./tool/event");o.Dispatcher.call(this);var u=this,a=o.getX,f=o.getY,l,c=!1,h=null,p=null,d=null,v=!1,m=!1,g,y=0,b=0,w=0,E=0,S=r.getDomHover();u.on=X,u.un=V,u.dispose=$,x()}e("./lib/excanvas");var t={},n=t,r=0,i={};return t.version="1.0.5",t.init=function(e,t){var n=new s(++r+"",e,t||{});return i[r]=n,n},t.dispose=function(e){if(e)e.dispose();else{for(var n in i)i[n].dispose();i={}}return t},t.getInstance=function(e){return i[e]},t.delInstance=function(e){return i[e]&&(i[e]=null,delete i[e]),t},t.catchBrushException=!1,t.debugMode=0,t.log=function(){if(t.debugMode===0)return;if(t.debugMode==1)for(var e in arguments)throw new Error(arguments[e]);else if(t.debugMode>1)for(var e in arguments)console.log(arguments[e]);return t},t}),define("zrender",["zrender/zrender"],function(e){return e}),define("echarts/util/shape/icon",["require","zrender/tool/matrix","zrender/shape","zrender/shape/base","zrender/shape"],function(e){function n(){this.type="icon",this._iconLibrary={mark:r,markUndo:i,markClear:s,dataZoom:o,dataZoomReset:u,restore:a,lineChart:f,barChart:l,dataView:c,saveAsImage:h,cross:p,circle:d,rectangle:v,triangle:m,diamond:g,arrow:y,star:b}}function r(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+t.height),e.lineTo(t.x+5*n,t.y+14*r),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+13*n,t.y),e.lineTo(t.x+2*n,t.y+11*r),e.lineTo(t.x,t.y+t.height),e.moveTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+2*r),e.moveTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+t.width,t.y+13*r),e.moveTo(t.x+13*n,t.y+10*r),e.lineTo(t.x+13*n,t.y+t.height)}function i(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+t.height),e.lineTo(t.x+5*n,t.y+14*r),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+13*n,t.y),e.lineTo(t.x+2*n,t.y+11*r),e.lineTo(t.x,t.y+t.height),e.moveTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+2*r),e.moveTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+t.width,t.y+13*r)}function s(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x+4*n,t.y+15*r),e.lineTo(t.x+9*n,t.y+13*r),e.lineTo(t.x+14*n,t.y+8*r),e.lineTo(t.x+11*n,t.y+5*r),e.lineTo(t.x+6*n,t.y+10*r),e.lineTo(t.x+4*n,t.y+15*r),e.moveTo(t.x+5*n,t.y),e.lineTo(t.x+11*n,t.y),e.moveTo(t.x+5*n,t.y+r),e.lineTo(t.x+11*n,t.y+r),e.moveTo(t.x,t.y+2*r),e.lineTo(t.x+t.width,t.y+2*r),e.moveTo(t.x,t.y+5*r),e.lineTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+13*n,t.y+t.height),e.lineTo(t.x+t.width,t.y+5*r)}function o(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y+3*r),e.lineTo(t.x+6*n,t.y+3*r),e.moveTo(t.x+3*n,t.y),e.lineTo(t.x+3*n,t.y+6*r),e.moveTo(t.x+3*n,t.y+8*r),e.lineTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x+t.width,t.y+3*r),e.lineTo(t.x+8*n,t.y+3*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function u(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x+6*n,t.y),e.lineTo(t.x+2*n,t.y+3*r),e.lineTo(t.x+6*n,t.y+6*r),e.moveTo(t.x+2*n,t.y+3*r),e.lineTo(t.x+14*n,t.y+3*r),e.lineTo(t.x+14*n,t.y+11*r),e.moveTo(t.x+2*n,t.y+5*r),e.lineTo(t.x+2*n,t.y+13*r),e.lineTo(t.x+14*n,t.y+13*r),e.moveTo(t.x+10*n,t.y+10*r),e.lineTo(t.x+14*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+t.height),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function a(e,t){var n=t.width/16,r=t.height/16,i=t.width/2;e.lineWidth=1.5,e.arc(t.x+i,t.y+i,i-n,0,Math.PI*2/3),e.moveTo(t.x+3*n,t.y+t.height),e.lineTo(t.x+0*n,t.y+12*r),e.lineTo(t.x+5*n,t.y+11*r),e.moveTo(t.x,t.y+8*r),e.arc(t.x+i,t.y+i,i-n,Math.PI,Math.PI*5/3),e.moveTo(t.x+13*n,t.y),e.lineTo(t.x+t.width,t.y+4*r),e.lineTo(t.x+11*n,t.y+5*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function f(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.moveTo(t.x+2*n,t.y+14*r),e.lineTo(t.x+7*n,t.y+6*r),e.lineTo(t.x+11*n,t.y+11*r),e.lineTo(t.x+15*n,t.y+2*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function l(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.moveTo(t.x+3*n,t.y+14*r),e.lineTo(t.x+3*n,t.y+6*r),e.lineTo(t.x+4*n,t.y+6*r),e.lineTo(t.x+4*n,t.y+14*r),e.moveTo(t.x+7*n,t.y+14*r),e.lineTo(t.x+7*n,t.y+2*r),e.lineTo(t.x+8*n,t.y+2*r),e.lineTo(t.x+8*n,t.y+14*r),e.moveTo(t.x+11*n,t.y+14*r),e.lineTo(t.x+11*n,t.y+9*r),e.lineTo(t.x+12*n,t.y+9*r),e.lineTo(t.x+12*n,t.y+14*r)}function c(e,t){var n=t.width/16;e.moveTo(t.x+n,t.y),e.lineTo(t.x+n,t.y+t.height),e.lineTo(t.x+15*n,t.y+t.height),e.lineTo(t.x+15*n,t.y),e.lineTo(t.x+n,t.y),e.moveTo(t.x+3*n,t.y+3*n),e.lineTo(t.x+13*n,t.y+3*n),e.moveTo(t.x+3*n,t.y+6*n),e.lineTo(t.x+13*n,t.y+6*n),e.moveTo(t.x+3*n,t.y+9*n),e.lineTo(t.x+13*n,t.y+9*n),e.moveTo(t.x+3*n,t.y+12*n),e.lineTo(t.x+9*n,t.y+12*n)}function h(e,t){var n=t.width/16,r=t.height/16;e.moveTo(t.x,t.y),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x,t.y),e.moveTo(t.x+4*n,t.y),e.lineTo(t.x+4*n,t.y+8*r),e.lineTo(t.x+12*n,t.y+8*r),e.lineTo(t.x+12*n,t.y),e.moveTo(t.x+6*n,t.y+11*r),e.lineTo(t.x+6*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+13*r),e.lineTo(t.x+10*n,t.y+11*r),e.lineTo(t.x+6*n,t.y+11*r),e.moveTo(t.x,t.y),e.lineTo(t.x,t.y)}function p(e,t){var n=t.x,r=t.y,i=t.width,s=t.height;e.moveTo(n,r+s/2),e.lineTo(n+i,r+s/2),e.moveTo(n+i/2,r),e.lineTo(n+i/2,r+s)}function d(e,t){var n=t.width/2,r=t.height/2;e.arc(t.x+n,t.y+r,Math.min(n,r),0,Math.PI*2)}function v(e,t){e.rect(t.x,t.y,t.width,t.height)}function m(e,t){var n=t.width/2,r=t.height/2,i=t.x+n,s=t.y+r,o=Math.min(n,r);e.moveTo(i,s-o),e.lineTo(i+o,s+o),e.lineTo(i-o,s+o),e.lineTo(i,s-o)}function g(e,t){var n=t.width/2,r=t.height/2,i=t.x+n,s=t.y+r,o=Math.min(n,r);e.moveTo(i,s-o),e.lineTo(i+o,s),e.lineTo(i,s+o),e.lineTo(i-o,s),e.lineTo(i,s-o)}function y(e,t){var n=t.x,r=t.y,i=t.width/16;e.moveTo(n+8*i,r),e.lineTo(n+i,r+t.height),e.lineTo(n+8*i,r+t.height/4*3),e.lineTo(n+15*i,r+t.height),e.lineTo(n+8*i,r)}function b(t,n){var r=n.width/2,i=n.height/2,s=e("zrender/shape").get("star");s.buildPath(t,{x:n.x+r,y:n.y+i,r:Math.min(r,i),n:n.n||5})}var t=e("zrender/tool/matrix");return n.prototype={buildPath:function(e,t){this._iconLibrary[t.iconType]?this._iconLibrary[t.iconType](e,t):(e.moveTo(t.x,t.y),e.lineTo(t.x+t.width,t.y),e.lineTo(t.x+t.width,t.y+t.height),e.lineTo(t.x,t.y+t.height),e.lineTo(t.x,t.y));return},getRect:function(e){return{x:Math.round(e.x),y:Math.round(e.y),width:e.width,height:e.height}},isCover:function(e,n,r){if(e.__needTransform&&e._transform){var i=[];t.invert(i,e._transform);var s=[n,r];t.mulVector(s,i,[n,r,1]),n==s[0]&&r==s[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),n=s[0],r=s[1]}var o;e.style.__rect?o=e.style.__rect:(o=this.getRect(e.style),e.style.__rect=o);var u=5;return n>=o.x-u&&n<=o.x+o.width+2*u&&r>=o.y-u&&r<=o.y+o.height+2*u?!0:!1},define:function(e,t){this._iconLibrary[e]=t},get:function(e){return this._iconLibrary[e]}},e("zrender/shape/base").derive(n),e("zrender/shape").define("icon",new n),n}),define("echarts/chart",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("echarts/component/base",["require","../config","zrender/tool/util"],function(e){function t(t){function s(e){e=e||i.type+"";switch(e){case n.COMPONENT_TYPE_GRID:case n.COMPONENT_TYPE_AXIS_CATEGORY:case n.COMPONENT_TYPE_AXIS_VALUE:return 0;case n.CHART_TYPE_LINE:case n.CHART_TYPE_BAR:case n.CHART_TYPE_SCATTER:case n.CHART_TYPE_PIE:case n.CHART_TYPE_RADAR:case n.CHART_TYPE_MAP:case n.CHART_TYPE_K:case n.CHART_TYPE_CHORD:return 2;case n.COMPONENT_TYPE_LEGEND:case n.COMPONENT_TYPE_DATARANGE:case n.COMPONENT_TYPE_DATAZOOM:return 4;case n.CHART_TYPE_ISLAND:return 5;case n.COMPONENT_TYPE_TOOLBOX:case n.COMPONENT_TYPE_TITLE:return 6;case n.COMPONENT_TYPE_TOOLTIP:return 7;default:return 0}}function o(e){return r.merge(e||{},n[i.type]||{},{overwrite:!1,recursive:!0})}function u(e){if(!(e instanceof Array))return[e,e,e,e];switch(e.length+""){case"4":return e;case"3":return[e[0],e[1],e[2],e[1]];case"2":return[e[0],e[1],e[0],e[1]];case"1":return[e[0],e[0],e[0],e[0]];case"0":return[0,0,0,0]}}function f(e){var t=r.merge(r.clone(e)||{},n.textStyle,{overwrite:!1});return t.fontStyle+" "+t.fontWeight+" "+t.fontSize+"px "+t.fontFamily}function l(e,t,n,s,o){var u=r.merge(r.clone(i.deepQuery([t],"itemStyle.normal.label")),i.deepQuery([n],"itemStyle.normal.label"),{overwrite:!0,recursive:!0}),a=r.merge(r.clone(i.deepQuery([t],"itemStyle.emphasis.label")),i.deepQuery([n],"itemStyle.emphasis.label"),{overwrite:!0,recursive:!0}),f=u.textStyle||{},l=a.textStyle||{};return u.show&&(e.style.text=c(t,n,s,"normal"),e.style.textPosition=typeof u.position=="undefined"?o=="horizontal"?"right":"top":u.position,e.style.textColor=f.color,e.style.textFont=i.getFont(f)),a.show&&(e.highlightStyle.text=c(t,n,s,"emphasis"),e.highlightStyle.textPosition=typeof a.position=="undefined"?o=="horizontal"?"right":"top":a.position,e.highlightStyle.textColor=l.color,e.highlightStyle.textFont=i.getFont(l)),e}function c(e,t,n,r){var s=i.deepQuery([t,e],"itemStyle."+r+".label.formatter"),o=typeof t!="undefined"?typeof t.value!="undefined"?t.value:t:"-";if(!s)return o;if(typeof s=="function")return s(e.name,n,o);if(typeof s=="string")return s=s.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}"),s=s.replace("{a0}",e.name).replace("{b0}",n).replace("{c0}",o),s}function h(e,t){return typeof e=="string"?d(e).match(/%$/)?parseFloat(e)/100*t:parseFloat(e):e}function p(e){return[h(e[0],i.zr.getWidth()),h(e[1],i.zr.getHeight())]}function d(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function v(e,t,n){for(var s=0,o=e.length;s<o;s++)if(n||e[s].type==i.type)for(var u=0,a=t.length;u<a;u++)e[s]["__"+t[s]]=r.clone(e[s][t[s]])}function m(e,t,n){for(var s=0,o=e.length;s<o;s++)if(n||e[s].type==i.type)for(var u=0,a=t.length;u<a;u++)e[s][t[s]]=r.clone(e[s]["__"+t[s]])}function g(){i.refresh&&i.refresh()}function y(){i.zr&&(i.zr.delShape(i.shapeList),i.zr.clearAnimation&&i.zr.clearAnimation()),i.shapeList=[]}function b(){i.clear(),i.shapeList=null,i=null}var n=e("../config"),r=e("zrender/tool/util"),i=this;i.zr=t,i.shapeList=[];var a=function(){function e(e,t){if(typeof e=="undefined")return undefined;if(!t)return e;t=t.split(".");var n=t.length,r=0;while(r<n){e=e[t[r]];if(typeof e=="undefined")return undefined;r++}return e}return function(t,n){var r;for(var i=0,s=t.length;i<s;i++){r=e(t[i],n);if(typeof r!="undefined")return r}return undefined}}();i.getZlevelBase=s,i.reformOption=o,i.reformCssArray=u,i.deepQuery=a,i.getFont=f,i.addLabel=l,i.parsePercent=h,i.parseCenter=p,i.clear=y,i.dispose=b,i.backupAdaptiveParams=v,i.restoreAdaptiveParams=m,i.resize=g}return t}),define("echarts/util/ecData",[],function(){function e(e,t,n,r,i,s,o,u){var a;return typeof r!="undefined"&&(typeof r.value!="undefined"?a=r.value:a=r),e._echartsData={_series:t,_seriesIndex:n,_data:r,_dataIndex:i,_name:s,_value:a,_special:o,_special2:u},e._echartsData}function t(e,t){var n=e._echartsData;if(!t)return n;switch(t){case"series":return n&&n._series;case"seriesIndex":return n&&n._seriesIndex;case"data":return n&&n._data;case"dataIndex":return n&&n._dataIndex;case"name":return n&&n._name;case"value":return n&&n._value;case"special":return n&&n._special;case"special2":return n&&n._special2}return null}function n(e,t,n){e._echartsData=e._echartsData||{};switch(t){case"series":e._echartsData._series=n;break;case"seriesIndex":e._echartsData._seriesIndex=n;break;case"data":e._echartsData._data=n;break;case"dataIndex":e._echartsData._dataIndex=n;break;case"name":e._echartsData._name=n;break;case"value":e._echartsData._value=n;break;case"special":e._echartsData._special=n;break;case"special2":e._echartsData._special2=n}}return{pack:e,set:n,get:t}}),define("echarts/chart/calculableBase",["require","../util/ecData","zrender/tool/util"],function(e){function t(t,n){function o(e){return e.ondragover=s.shapeHandler.ondragover,e.ondragend=s.shapeHandler.ondragend,e.ondrop=s.shapeHandler.ondrop,e}function u(e,t){if(!s.isDrop||!e.target)return;var i=e.target,o=e.dragged,u=r.get(i,"seriesIndex"),a=r.get(i,"dataIndex"),f=n.series[u].data[a]||"-";f.value?f.value!="-"?n.series[u].data[a].value+=r.get(o,"value"):n.series[u].data[a].value=r.get(o,"value"):f!="-"?n.series[u].data[a]+=r.get(o,"value"):n.series[u].data[a]=r.get(o,"value"),t.dragIn=t.dragIn||!0,s.isDrop=!1;return}function a(e,t){if(!s.isDragend||!e.target)return;var i=e.target,o=r.get(i,"seriesIndex"),u=r.get(i,"dataIndex");n.series[o].data[u]="-",t.dragOut=!0,t.needRefresh=!0,s.isDragend=!1;return}function f(e,t){var n=e.selected;for(var r in s.selectedMap)if(s.selectedMap[r]!=n[r]){t.needRefresh=!0;return}}var r=e("../util/ecData"),i=e("zrender/tool/util"),s=this;s.selectedMap={},s.shapeHandler={onclick:function(){s.isClick=!0},ondragover:function(e){var t=i.clone(e.target);t.highlightStyle={text:"",r:t.style.r+5,brushType:"stroke",strokeColor:s.zr.getCalculableColor(),lineWidth:(t.style.lineWidth||1)+12},s.zr.addHoverShape(t)},ondrop:function(e){typeof r.get(e.dragged,"data")!="undefined"&&(s.isDrop=!0)},ondragend:function(){s.isDragend=!0}},s.setCalculable=o,s.ondrop=u,s.ondragend=a,s.onlegendSelected=f}return t}),define("echarts/chart/island",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/event","zrender/tool/color","../chart"],function(e){function t(t,n){function v(t,n){var r=e("zrender/tool/color"),i=o.get(t,"value")+o.get(n,"value"),s=o.get(t,"name")+c+o.get(n,"name");t.style.text=s+h+i,o.set(t,"value",i),o.set(t,"name",s),t.style.r=f.island.r,t.style.color=r.mix(t.style.color,n.style.color)}function m(e){e&&(e.island=a.reformOption(e.island),f=e,c=f.nameConnector,h=f.valueConnector)}function g(e){m(e);for(var t=0,r=a.shapeList.length;t<r;t++)n.addShape(a.shapeList[t])}function y(){return f}function b(){var e=n.getWidth(),t=n.getHeight(),r=e/(d||e),i=t/(p||t);if(r==1&&i==1)return;d=e,p=t;for(var s=0,o=a.shapeList.length;s<o;s++)n.modShape(a.shapeList[s].id,{style:{x:Math.round(a.shapeList[s].style.x*r),y:Math.round(a.shapeList[s].style.y*i)}})}function w(e){var t=o.get(e,"name"),r=o.get(e,"value"),i=typeof o.get(e,"series")!="undefined"?o.get(e,"series").name:"",s=a.getFont(f.island.textStyle),u={shape:"circle",id:n.newShapeId(a.type),zlevel:l,style:{x:e.style.x,y:e.style.y,r:f.island.r,color:e.style.color||e.style.strokeColor,text:t+h+r,textFont:s},draggable:!0,hoverable:!0,onmousewheel:a.shapeHandler.onmousewheel,_type:"island"};u.style.color=="#fff"&&(u.style.color=e.style.strokeColor),a.setCalculable(u),o.pack(u,{name:i},-1,r,-1,t),a.shapeList.push(u),n.addShape(u)}function E(e){n.delShape(e.id);var t=[];for(var r=0,i=a.shapeList.length;r<i;r++)a.shapeList[r].id!=e.id&&t.push(a.shapeList[r]);a.shapeList=t}function S(e,t){if(!a.isDrop||!e.target)return;var r=e.target,i=e.dragged;v(r,i),n.modShape(r.id,r),t.dragIn=!0,a.isDrop=!1;return}function x(e,t){var n=e.target;a.isDragend?t.dragIn&&(E(n),t.needRefresh=!0):t.dragIn||(n.style.x=u.getX(e.event),n.style.y=u.getY(e.event),w(n),t.needRefresh=!0),a.isDragend=!1;return}var r=e("../component/base");r.call(this,n);var i=e("./calculableBase");i.call(this,n);var s=e("../config"),o=e("../util/ecData"),u=e("zrender/tool/event"),a=this;a.type=s.CHART_TYPE_ISLAND;var f,l=a.getZlevelBase(),c,h,p=n.getHeight(),d=n.getWidth();a.shapeHandler.onmousewheel=function(e){var t=e.target,r=e.event,i=u.getDelta(r);i=i>0?-1:1,t.style.r-=i,t.style.r=t.style.r<5?5:t.style.r;var s=o.get(t,"value"),a=s*f.island.calculateStep;a>1?s=Math.round(s-a*i):s=(s-a*i).toFixed(2)-0;var l=o.get(t,"name");t.style.text=l+":"+s,o.set(t,"value",s),o.set(t,"name",l),n.modShape(t.id,t),n.refresh(),u.stop(r)},a.refresh=m,a.render=g,a.resize=b,a.getOption=y,a.add=w,a.del=E,a.ondrop=S,a.ondragend=x}return e("../chart").define("island",t),t}),define("echarts/component",[],function(){var e={},t={};return e.define=function(n,r){return t[n]=r,e},e.get=function(e){return t[e]},e}),define("echarts/component/title",["require","./base","../config","zrender/tool/area","zrender/tool/util","../component"],function(e){function t(t,n,r){function h(){c=v(),d(),p();for(var e=0,t=a.shapeList.length;e<t;e++)a.shapeList[e].id=n.newShapeId(a.type),n.addShape(a.shapeList[e])}function p(){var e=f.text,t=f.link,n=f.subtext,r=f.sublink,i=a.getFont(f.textStyle),s=a.getFont(f.subtextStyle),o=c.x,u=c.y,h=c.width,p=c.height,d={shape:"text",zlevel:l,style:{y:u,color:f.textStyle.color,text:e,textFont:i,textBaseline:"top"},hoverable:!1};t&&(d.hoverable=!0,d.clickable=!0,d.onclick=function(){window.open(t)});var v={shape:"text",zlevel:l,style:{y:u+p,color:f.subtextStyle.color,text:n,textFont:s,textBaseline:"bottom"},hoverable:!1};r&&(v.hoverable=!0,v.clickable=!0,v.onclick=function(){window.open(r)});switch(f.x){case"center":d.style.x=v.style.x=o+h/2,d.style.textAlign=v.style.textAlign="center";break;case"left":d.style.x=v.style.x=o,d.style.textAlign=v.style.textAlign="left";break;case"right":d.style.x=v.style.x=o+h,d.style.textAlign=v.style.textAlign="right";break;default:o=f.x-0,o=isNaN(o)?0:o,d.style.x=v.style.x=o}f.textAlign&&(d.style.textAlign=v.style.textAlign=f.textAlign),a.shapeList.push(d),n!==""&&a.shapeList.push(v)}function d(){var e=f.padding[0],t=f.padding[1],n=f.padding[2],r=f.padding[3];a.shapeList.push({shape:"rectangle",zlevel:l,hoverable:!1,style:{x:c.x-r,y:c.y-e,width:c.width+r+t,height:c.height+e+n,brushType:f.borderWidth===0?"fill":"both",color:f.backgroundColor,strokeColor:f.borderColor,lineWidth:f.borderWidth}})}function v(){var e=f.text,t=f.subtext,r=a.getFont(f.textStyle),i=a.getFont(f.subtextStyle),s=Math.max(o.getTextWidth(e,r),o.getTextWidth(t,i)),u=o.getTextWidth("国",r)+(t===""?0:f.itemGap+o.getTextWidth("国",i)),l,c=n.getWidth();switch(f.x){case"center":l=Math.floor((c-s)/2);break;case"left":l=f.padding[3]+f.borderWidth;break;case"right":l=c-s-f.padding[1]-f.borderWidth;break;default:l=f.x-0,l=isNaN(l)?0:l}var h,p=n.getHeight();switch(f.y){case"top":h=f.padding[0]+f.borderWidth;break;case"bottom":h=p-u-f.padding[2]-f.borderWidth;break;case"center":h=Math.floor((p-u)/2);break;default:h=f.y-0,h=isNaN(h)?0:h}return{x:l,y:h,width:s,height:u}}function m(e){g(e)}function g(e){e&&(r=e,r.title=a.reformOption(r.title),r.title.padding=a.reformCssArray(r.title.padding),f=r.title,f.textStyle=u.merge(f.textStyle,s.textStyle,{overwrite:!1,recursive:!1}),f.subtextStyle=u.merge(f.subtextStyle,s.textStyle,{overwrite:!1,recursive:!1}),a.clear(),h())}function y(){a.clear(),h()}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/tool/area"),u=e("zrender/tool/util"),a=this;a.type=s.COMPONENT_TYPE_TITLE;var f,l=a.getZlevelBase(),c={};a.init=m,a.refresh=g,a.resize=y,m(r)}return e("../component").define("title",t),t}),define("echarts/component/categoryAxis",["require","./base","../config","zrender/tool/util","zrender/tool/area","../component"],function(e){function t(t,n,r,i){function d(){var e=u.clone(r.data),t=r.axisLabel.formatter,n;for(var i=0,s=e.length;i<s;i++)n=e[i].formatter||t,n&&(typeof n=="function"?typeof e[i].value!="undefined"?e[i].value=n(e[i].value):e[i]=n(e[i]):typeof n=="string"&&(typeof e[i].value!="undefined"?e[i].value=n.replace("{value}",e[i].value):e[i]=n.replace("{value}",e[i])));return e}function v(){var e=r.axisLabel.interval;if(e=="auto"){var t=r.axisLabel.textStyle.fontSize,n=f.getFont(r.axisLabel.textStyle),i=r.data,s=r.data.length;if(r.position=="bottom"||r.position=="top")if(s>3){var o=T(),l=!1,c,h;e=0;while(!l&&e<s){e++,l=!0,c=o*e-10;for(var d=0;d<s;d+=e){r.axisLabel.rotate!==0?h=t:i[d].textStyle?h=a.getTextWidth(p[d].value||p[d],f.getFont(u.merge(i[d].textStyle,r.axisLabel.textStyle,{overwrite:!1,recursive:!0}))):h=a.getTextWidth(p[d].value||p[d],n);if(c<h){l=!1;break}}}}else e=1;else if(s>3){var o=T();e=1;while(o*e-6<t&&e<s)e++}else e=1}else e+=1;return e}function m(){p=d(),h=v(),r.splitArea.show&&E(),r.splitLine.show&&w(),r.axisLine.show&&g(),r.axisTick.show&&y(),r.axisLabel.show&&b();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=n.newShapeId(f.type),n.addShape(f.shapeList[e])}function g(){var e={shape:"line",zlevel:c+1,hoverable:!1};switch(r.position){case"left":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getX(),yEnd:l.getYend()};break;case"right":e.style={xStart:l.getXend(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"bottom":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"top":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getY()}}e.style.strokeColor=r.axisLine.lineStyle.color,e.style.lineWidth=r.axisLine.lineStyle.width,e.style.lineType=r.axisLine.lineStyle.type,f.shapeList.push(e)}function y(){var e,t=r.data,n=r.data.length,i=r.axisTick.length,s=r.axisTick.lineStyle.color,o=r.axisTick.lineStyle.width;if(r.position=="bottom"||r.position=="top"){var u=r.position=="bottom"?l.getYend():l.getY()-i;for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:N(t[a].value||t[a]),yStart:u,xEnd:N(t[a].value||t[a]),yEnd:u+i,strokeColor:s,lineWidth:o}},f.shapeList.push(e)}else{var h=r.position=="left"?l.getX()-i:l.getXend();for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:h,yStart:N(t[a].value||t[a]),xEnd:h+i,yEnd:N(t[a].value||t[a]),strokeColor:s,lineWidth:o}},f.shapeList.push(e)}}function b(){var e,t=r.data,n=r.data.length,i=r.axisLabel.rotate,s=r.axisLabel.margin,o=r.axisLabel.textStyle,a;if(r.position=="bottom"||r.position=="top"){var d,v;r.position=="bottom"?(d=l.getYend()+s,v="top"):(d=l.getY()-s,v="bottom");for(var m=0;m<n;m+=h)a=u.merge(t[m].textStyle||{},o,{overwrite:!1}),e={shape:"text",zlevel:c,hoverable:!1,style:{x:N(t[m].value||t[m]),y:d,color:a.color,text:p[m].value||p[m],textFont:f.getFont(a),textAlign:"center",textBaseline:v}},i&&(e.style.textAlign=i>0?r.position=="bottom"?"right":"left":r.position=="bottom"?"left":"right",e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}else{var g,y;r.position=="left"?(g=l.getX()-s,y="right"):(g=l.getXend()+s,y="left");for(var m=0;m<n;m+=h)a=u.merge(t[m].textStyle||{},o,{overwrite:!1}),e={shape:"text",zlevel:c,hoverable:!1,style:{x:g,y:N(t[m].value||t[m]),color:a.color,text:p[m].value||p[m],textFont:f.getFont(a),textAlign:y,textBaseline:"middle"}},i&&(e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}}function w(){var e,t=r.data,n=r.data.length,i=r.splitLine.lineStyle.color;i=i instanceof Array?i:[i];var s=i.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getYend(),a;for(var p=0;p<n;p+=h)a=N(t[p].value||t[p]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:a,yStart:o,xEnd:a,yEnd:u,strokeColor:i[p/h%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}else{var d=l.getX(),v=l.getXend(),m;for(var p=0;p<n;p+=h)m=N(t[p].value||t[p]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:d,yStart:m,xEnd:v,yEnd:m,strokeColor:i[p/h%s],linetype:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}}function E(){var e,t=r.splitArea.areaStyle.color;t=t instanceof Array?t:[t];var n=t.length,i=r.data,s=r.data.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getHeight(),a=l.getX(),p;for(var d=0;d<=s;d+=h)p=d<s?N(i[d].value||i[d]):l.getXend(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:a,y:o,width:p-a,height:u,color:t[d/h%n]}},f.shapeList.push(e),a=p}else{var v=l.getX(),m=l.getWidth(),g=l.getYend(),y;for(var d=0;d<=s;d+=h)y=d<s?N(i[d].value||i[d]):l.getY(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:v,y:y,width:m,height:g-y,color:t[d/h%n]}},f.shapeList.push(e),g=y}}function S(e,t){if(e.data.length<1)return;l=t,x(e)}function x(e){e&&(r=f.reformOption(e),r.axisLabel.textStyle=u.merge(r.axisLabel.textStyle||{},o.textStyle,{overwrite:!1,recursive:!0}),r.axisLabel.textStyle=u.merge(r.axisLabel.textStyle||{},o.textStyle,{overwrite:!1,recursive:!0})),f.clear(),m()}function T(){var e=r.data.length,t=r.position=="bottom"||r.position=="top"?l.getWidth():l.getHeight();return r.boundaryGap?t/(e+1):t/(e>1?e-1:1)}function N(e){var t=r.data,n=t.length,i=T(),s=r.boundaryGap?i:0;for(var o=0;o<n;o++){if(t[o]==e||typeof t[o].value!="undefined"&&t[o].value==e)return r.position=="bottom"||r.position=="top"?s=l.getX()+s:s=l.getYend()-s,o===0||o==n-1?s:Math.floor(s);s+=i}}function C(e){if(e<0)return r.position=="bottom"||r.position=="top"?l.getX():l.getYend();if(e>=r.data.length)return r.position=="bottom"||r.position=="top"?l.getXend():l.getY();var t=T(),n=r.boundaryGap?t:0;return n+=e*t,r.position=="bottom"||r.position=="top"?n=l.getX()+n:n=l.getYend()-n,e===0||e==r.data.length-1?n:Math.floor(n)}function k(e){return r.data[e]}function L(e){return e%h===0}function A(){return r.position}var s=e("./base");s.call(this,n);var o=e("../config"),u=e("zrender/tool/util"),a=e("zrender/tool/area"),f=this;f.type=o.COMPONENT_TYPE_AXIS_CATEGORY;var l=i.grid,c=f.getZlevelBase(),h,p;f.init=S,f.refresh=x,f.getGap=T,f.getCoord=N,f.getCoordByIndex=C,f.getNameByIndex=k,f.isMainAxis=L,f.getPosition=A,S(r,l)}return e("../component").define("categoryAxis",t),t}),define("echarts/component/valueAxis",["require","./base","../config","zrender/tool/util","../component"],function(e){function t(t,n,r,i,s){function g(){d=!1,x();if(!d)return;r.splitArea.show&&S(),r.splitLine.show&&E(),r.axisLine.show&&y(),r.axisTick.show&&b(),r.axisLabel.show&&w();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=n.newShapeId(f.type),n.addShape(f.shapeList[e])}function y(){var e={shape:"line",zlevel:c+1,hoverable:!1};switch(r.position){case"left":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getX(),yEnd:l.getY()};break;case"right":e.style={xStart:l.getXend(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getY()};break;case"bottom":e.style={xStart:l.getX(),yStart:l.getYend(),xEnd:l.getXend(),yEnd:l.getYend()};break;case"top":e.style={xStart:l.getX(),yStart:l.getY(),xEnd:l.getXend(),yEnd:l.getY()}}r.name!==""&&(e.style.text=r.name,e.style.textPosition=r.nameLocation),e.style.strokeColor=r.axisLine.lineStyle.color,e.style.lineWidth=r.axisLine.lineStyle.width,e.style.lineType=r.axisLine.lineStyle.type,f.shapeList.push(e)}function b(){var e,t=v,n=v.length,i=r.axisTick.length,s=r.axisTick.lineStyle.color,o=r.axisTick.lineStyle.width;if(r.position=="bottom"||r.position=="top"){var u=r.position=="bottom"?l.getYend():l.getY()-i;for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:A(t[a]),yStart:u,xEnd:A(t[a]),yEnd:u+i,strokeColor:s,lineWidth:o}},f.shapeList.push(e)}else{var h=r.position=="left"?l.getX()-i:l.getXend();for(var a=0;a<n;a++)e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:h,yStart:A(t[a]),xEnd:h+i,yEnd:A(t[a]),strokeColor:s,lineWidth:o}},f.shapeList.push(e)}}function w(){var e,t=v,n=v.length,i=r.axisLabel.rotate,s=r.axisLabel.margin,o=r.axisLabel.textStyle;if(r.position=="bottom"||r.position=="top"){var u,a;r.position=="bottom"?(u=l.getYend()+s,a="top"):(u=l.getY()-s,a="bottom");for(var h=0;h<n;h++)e={shape:"text",zlevel:c,hoverable:!1,style:{x:A(t[h]),y:u,color:o.color,text:m[h],textFont:f.getFont(o),textAlign:h===0&&r.name!==""?"left":h==n-1&&r.name!==""?"right":"center",textBaseline:a}},i&&(e.style.textAlign=i>0?r.position=="bottom"?"right":"left":r.position=="bottom"?"left":"right",e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}else{var p,d;r.position=="left"?(p=l.getX()-s,d="right"):(p=l.getXend()+s,d="left");for(var h=0;h<n;h++)e={shape:"text",zlevel:c,hoverable:!1,style:{x:p,y:A(t[h]),color:o.color,text:m[h],textFont:f.getFont(o),textAlign:d,textBaseline:h===0&&r.name!==""?"bottom":h==n-1&&r.name!==""?"top":"middle"}},i&&(e.rotation=[i*Math.PI/180,e.style.x,e.style.y]),f.shapeList.push(e)}}function E(){var e,t=v,n=v.length,i=r.splitLine.lineStyle.color;i=i instanceof Array?i:[i];var s=i.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getYend(),a;for(var h=0;h<n;h++)a=A(t[h]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:a,yStart:o,xEnd:a,yEnd:u,strokeColor:i[h%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}else{var p=l.getX(),d=l.getXend(),m;for(var h=0;h<n;h++)m=A(t[h]),e={shape:"line",zlevel:c,hoverable:!1,style:{xStart:p,yStart:m,xEnd:d,yEnd:m,strokeColor:i[h%s],lineType:r.splitLine.lineStyle.type,lineWidth:r.splitLine.lineStyle.width}},f.shapeList.push(e)}}function S(){var e,t=r.splitArea.areaStyle.color;if(t instanceof Array){var n=t.length,i=v,s=v.length;if(r.position=="bottom"||r.position=="top"){var o=l.getY(),u=l.getHeight(),a=l.getX(),h;for(var p=0;p<=s;p++)h=p<s?A(i[p]):l.getXend(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:a,y:o,width:h-a,height:u,color:t[p%n]}},f.shapeList.push(e),a=h}else{var d=l.getX(),m=l.getWidth(),g=l.getYend(),y;for(var p=0;p<=s;p++)y=p<s?A(i[p]):l.getY(),e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:d,y:y,width:m,height:g-y,color:t[p%n]}},f.shapeList.push(e),g=y}}else e={shape:"rectangle",zlevel:c,hoverable:!1,style:{x:l.getX(),y:l.getY(),width:l.getWidth(),height:l.getHeight(),color:t}},f.shapeList.push(e)}function x(){if(isNaN(r.min)||isNaN(r.max)){var e,t={},n,o,a,f=i.legend;for(var l=0,c=s.length;l<c;l++){if(s[l].type!=u.CHART_TYPE_LINE&&s[l].type!=u.CHART_TYPE_BAR&&s[l].type!=u.CHART_TYPE_SCATTER&&s[l].type!=u.CHART_TYPE_K)continue;if(f&&!f.isSelected(s[l].name))continue;o=s[l].xAxisIndex||0,a=s[l].yAxisIndex||0;if(r.xAxisIndex!=o&&r.yAxisIndex!=a)continue;if(!s[l].stack){var v=s[l].name||"";t[v]=[],e=s[l].data;for(var m=0,g=e.length;m<g;m++)n=typeof e[m].value!="undefined"?e[m].value:e[m],s[l].type==u.CHART_TYPE_SCATTER?(r.xAxisIndex!=-1&&t[v].push(n[0]),r.yAxisIndex!=-1&&t[v].push(n[1])):s[l].type==u.CHART_TYPE_K?(t[v].push(n[0]),t[v].push(n[1]),t[v].push(n[2]),t[v].push(n[3])):t[v].push(n)}else{var y="__Magic_Key_Positive__"+s[l].stack,b="__Magic_Key_Negative__"+s[l].stack;t[y]=t[y]||[],t[b]=t[b]||[],e=s[l].data;for(var m=0,g=e.length;m<g;m++){n=typeof e[m].value!="undefined"?e[m].value:e[m];if(n=="-")continue;n-=0,n>=0?typeof t[y][m]!="undefined"?t[y][m]+=n:t[y][m]=n:typeof t[b][m]!="undefined"?t[b][m]+=n:t[b][m]=n}}}for(var l in t){e=t[l];for(var m=0,g=e.length;m<g;m++)if(!isNaN(e[m])){d=!0,h=e[m],p=e[m];break}if(d)break}for(var l in t){e=t[l];for(var m=0,g=e.length;m<g;m++)isNaN(e[m])||(h=Math.min(h,e[m]),p=Math.max(p,e[m]))}}else d=!0;h=isNaN(r.min)?h-Math.abs(h*r.boundaryGap[0]):r.min,p=isNaN(r.max)?p+Math.abs(p*r.boundaryGap[1]):r.max,h==p&&(p+=1),T(r.scale)}function T(e){var t=r.splitNumber,n=r.precision,i,s;n===0?s=r.power:(s=Math.pow(10,n),h*=s,p*=s,s=r.power);var o;if(h>=0&&p>=0){e||(h=0);while(p/s<t&&s!=1)s/=10;o=p-h,i=Math.ceil(o/t/s)*s,e&&(n===0&&(h=Math.floor(h/i)*i),h+i*t<p&&(i=Math.ceil((p-h)/t/s)*s)),p=h+i*t}else if(h<=0&&p<=0){e||(p=0),s=-s;while(h/s<t&&s!=-1)s/=10;o=h-p,i=-Math.ceil(o/t/s)*s,e&&(n===0&&(p=Math.ceil(p/i)*i),p-i*t>h&&(i=Math.ceil((h-p)/t/s)*s)),h=-i*t+p}else{o=p-h;while(o/s<t&&s!=1)s/=10;var u=Math.round(p/o*t);u-=u==t?1:0,u+=u===0?1:0,i=Math.ceil(Math.max(p/u,h/(u-t))/s)*s,p=i*u,h=i*(u-t)}v=[];for(var a=0;a<=t;a++)v.push(h+i*a);if(n!==0){s=Math.pow(10,n),h=(h/s).toFixed(n)-0,p=(p/s).toFixed(n)-0;for(var a=0;a<=t;a++)v[a]=(v[a]/s).toFixed(n)}N()}function N(){m=[];var e=r.axisLabel.formatter;if(e)for(var t=0,n=v.length;t<n;t++)typeof e=="function"?m.push(e(v[t])):typeof e=="string"&&m.push(e.replace("{value}",v[t]));else m=v}function C(){return x(),{min:h,max:p}}function k(e,t,n){if(!n||n.length===0)return;l=t,L(e,n)}function L(e,t){e&&(r=f.reformOption(e),r.axisLabel.textStyle=a.merge(r.axisLabel.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),r.axisLabel.textStyle=a.merge(r.axisLabel.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),s=t),n&&(f.clear(),g())}function A(e){e=e<h?h:e,e=e>p?p:e;var t=p-h,n,i;return r.position=="left"||r.position=="right"?(n=l.getHeight(),i=l.getYend()-(e-h)/t*n):(n=l.getWidth(),i=(e-h)/t*n+l.getX()),e==h||e==p?i:Math.floor(i)}function O(){return r.position}var o=e("./base");o.call(this,n);var u=e("../config"),a=e("zrender/tool/util"),f=this;f.type=u.COMPONENT_TYPE_AXIS_VALUE;var l=i.grid,c=f.getZlevelBase(),h,p,d,v,m;f.init=k,f.refresh=L,f.getExtremum=C,f.getCoord=A,f.getPosition=O,k(r,l,s)}return e("../component").define("valueAxis",t),t}),define("echarts/component/axis",["require","./base","../config","./categoryAxis","./valueAxis","../component"],function(e){function t(t,n,r,i,s){function l(e){!e||e instanceof Array&&e.length===0?e=[{type:u.COMPONENT_TYPE_AXIS_VALUE}]:e instanceof Array||(e=[e]),e.length>2&&(e=[e[0],e[1]]);if(s=="xAxis"){if(!e[0].position||e[0].position!="bottom"&&e[0].position!="top")e[0].position="bottom";e.length>1&&(e[1].position=e[0].position=="bottom"?"top":"bottom");for(var t=0,n=e.length;t<n;t++)e[t].type=e[t].type||"category",e[t].xAxisIndex=t,e[t].yAxisIndex=-1}else{if(!e[0].position||e[0].position!="left"&&e[0].position!="right")e[0].position="left";e.length>1&&(e[1].position=e[0].position=="left"?"right":"left");for(var t=0,n=e.length;t<n;t++)e[t].type=e[t].type||"value",e[t].xAxisIndex=-1,e[t].yAxisIndex=t}return e}function c(o,u,c){i=u,s=c,a.clear();var h;s=="xAxis"?(r.xAxis=a.reformOption(o.xAxis),h=r.xAxis):(r.yAxis=l(o.yAxis),h=r.yAxis);var p=e("./categoryAxis"),d=e("./valueAxis");for(var v=0,m=h.length;v<m;v++)f.push(h[v].type=="category"?new p(t,n,h[v],i):new d(t,n,h[v],i,r.series))}function h(e){var t,n;e&&(s=="xAxis"?(r.xAxis=a.reformOption(e.xAxis),t=r.xAxis):(r.yAxis=l(e.yAxis),t=r.yAxis),n=e.series);for(var i=0,o=f.length;i<o;i++)f[i].refresh&&f[i].refresh(t?t[i]:!1,n)}function p(e){return f[e]}function d(){for(var e=0,t=f.length;e<t;e++)f[e].dispose&&f[e].dispose();f=[]}var o=e("./base");o.call(this,n);var u=e("../config"),a=this;a.type=u.COMPONENT_TYPE_AXIS;var f=[];a.clear=d,a.reformOption=l,a.init=c,a.refresh=h,a.getAxis=p,c(r,i,s)}return e("../component").define("axis",t),t}),define("echarts/component/grid",["require","./base","../config","../component"],function(e){function t(t,n,r){function d(e){r=e,r.grid=o.reformOption(r.grid);var t=r.grid;a=t.x,f=t.y;var i=t.x2,s=t.y2;h=n.getWidth(),p=n.getHeight(),typeof t.width=="undefined"?l=h-a-i:l=t.width,typeof t.height=="undefined"?c=p-f-s:c=t.height,o.shapeList.push({shape:"rectangle",id:n.newShapeId("grid"),zlevel:u,hoverable:!1,style:{x:a,y:f,width:l,height:c,brushType:"both",color:t.backgroundColor,strokeColor:t.borderColor,lineWidth:t.borderWidth}}),n.addShape(o.shapeList[0])}function v(){return a}function m(){return f}function g(){return l}function y(){return c}function b(){return a+l}function w(){return f+c}function E(){return{x:a,y:f,width:l,height:c}}function S(e){if(h!=n.getWidth()||p!=n.getHeight()||e)o.clear(),d(e||r)}var i=e("./base");i.call(this,n);var s=e("../config"),o=this;o.type=s.COMPONENT_TYPE_GRID;var u=o.getZlevelBase(),a,f,l,c,h,p;o.init=d,o.getX=v,o.getY=m,o.getWidth=g,o.getHeight=y,o.getXend=b,o.getYend=w,o.getArea=E,o.refresh=S,d(r)}return e("../component").define("grid",t),t}),define("echarts/component/dataZoom",["require","./base","../config","../component","zrender/tool/util","../component"],function(e){function t(t,n,r,i){function w(){N(),C(),k(),L();for(var e=0,t=u.shapeList.length;e<t;e++)u.shapeList[e].id=n.newShapeId(u.type),n.addShape(u.shapeList[e]);D()}function E(){var e,t,r,s,o=i.grid;return f.orient=="horizontal"?(r=f.width||o.getWidth(),s=f.height||l,e=typeof f.x!="undefined"?f.x:o.getX(),t=typeof f.y!="undefined"?f.y:n.getHeight()-s):(r=f.width||l,s=f.height||o.getHeight(),e=typeof f.x!="undefined"?f.x:0,t=typeof f.y!="undefined"?f.y:o.getY()),{x:e,y:t,width:r,height:s}}function S(){var e=r.series,t=r.xAxis;t&&!(t instanceof Array)&&(t=[t],r.xAxis=t);var n=r.yAxis;n&&!(n instanceof Array)&&(n=[n],r.yAxis=n);var i=[],s,u,a=f.xAxisIndex;if(t&&typeof a=="undefined"){s=[];for(var l=0,c=t.length;l<c;l++)(t[l].type=="category"||typeof t[l].type=="undefined")&&s.push(l)}else a instanceof Array?s=a:typeof a!="undefined"?s=[a]:s=[];a=f.yAxisIndex;if(n&&typeof a=="undefined"){u=[];for(var l=0,c=n.length;l<c;l++)n[l].type=="category"&&u.push(l)}else a instanceof Array?u=a:typeof a!="undefined"?u=[a]:u=[];for(var l=0,c=e.length;l<c;l++){if(e[l].type!=o.CHART_TYPE_LINE&&e[l].type!=o.CHART_TYPE_BAR&&e[l].type!=o.CHART_TYPE_SCATTER&&e[l].type!=o.CHART_TYPE_K)continue;for(var p=0,d=s.length;p<d;p++)if(s[p]==(e[l].xAxisIndex||0)){i.push(l);break}for(var p=0,d=u.length;p<d;p++)if(u[p]==(e[l].yAxisIndex||0)){i.push(l);break}e[l].type==o.CHART_TYPE_SCATTER&&typeof f.xAxisIndex=="undefined"&&typeof f.yAxisIndex=="undefined"&&i.push(l)}var v=typeof f.start!="undefined"&&f.start>=0&&f.start<=100?f.start:0,m=typeof f.end!="undefined"&&f.end>=0&&f.end<=100?f.end:100;v>m&&(v+=m,m=v-m,v-=m);var g=Math.round((m-v)/100*(f.orient=="horizontal"?h.width:h.height));return{start:v,end:m,start2:0,end2:100,size:g,xAxisIndex:s,yAxisIndex:u,seriesIndex:i}}function x(){b={xAxis:{},yAxis:{},series:{}};var e=r.xAxis,t=p.xAxisIndex;for(var n=0,i=t.length;n<i;n++)b.xAxis[t[n]]=e[t[n]].data;var s=r.yAxis,u=p.yAxisIndex;for(var n=0,i=u.length;n<i;n++)b.yAxis[u[n]]=s[u[n]].data;var a=r.series,f=p.seriesIndex,l;for(var n=0,i=f.length;n<i;n++)l=a[f[n]],b.series[f[n]]=l.data,l.type==o.CHART_TYPE_SCATTER&&T(f[n])}function T(t){p.scatterMap=p.scatterMap||{},p.scatterMap[t]=p.scatterMap[t]||{};var n=e("../component"),s=e("zrender/tool/util"),o=n.get("axis"),u=s.clone(r.xAxis);u instanceof Array?(u[0].type="value",u[1]&&(u[1].type="value")):u.type="value";var a=new o(null,!1,{xAxis:u,series:r.series},i,"xAxis"),f=r.series[t].xAxisIndex||0;p.scatterMap[t].x=a.getAxis(f).getExtremum(),a.dispose(),u=s.clone(r.yAxis),u instanceof Array?(u[0].type="value",u[1]&&(u[1].type="value")):u.type="value",a=new o(null,!1,{yAxis:u,series:r.series},i,"yAxis"),f=r.series[t].yAxisIndex||0,p.scatterMap[t].y=a.getAxis(f).getExtremum(),a.dispose()}function N(){u.shapeList.push({shape:"rectangle",zlevel:a,hoverable:!1,style:{x:h.x,y:h.y,width:h.width,height:h.height,color:f.backgroundColor}})}function C(){u.shapeList.push({shape:"rectangle",zlevel:a,hoverable:!1,style:{x:h.x,y:h.y,width:h.width,height:h.height,color:f.backgroundColor}});var e=0,t=r.xAxis,n=p.xAxisIndex;for(var i=0,s=n.length;i<s;i++)e=Math.max(e,t[n[i]].data.length);var l=r.yAxis,c=p.yAxisIndex;for(var i=0,s=c.length;i<s;i++)e=Math.max(e,l[c[i]].data.length);var d=r.series[p.seriesIndex[0]].data,v=Number.MIN_VALUE,m=Number.MAX_VALUE,g;for(var i=0,s=d.length;i<s;i++)g=typeof d[i]!="undefined"?typeof d[i].value!="undefined"?d[i].value:d[i]:0,r.series[p.seriesIndex[0]].type==o.CHART_TYPE_K&&(g=g[1]),isNaN(g)&&(g=0),v=Math.max(v,g),m=Math.min(m,g);var y=[],b=h.width/e,w=h.height/e;for(var i=0,s=e;i<s;i++)g=typeof d[i]!="undefined"?typeof d[i].value!="undefined"?d[i].value:d[i]:0,r.series[p.seriesIndex[0]].type==o.CHART_TYPE_K&&(g=g[1]),isNaN(g)&&(g=0),f.orient=="horizontal"?y.push([h.x+b*i,h.y+h.height-5-Math.round((g-m)/(v-m)*(h.height-10))]):y.push([h.x+5+Math.round((g-m)/(v-m)*(h.width-10)),h.y+w*i]);f.orient=="horizontal"?(y.push([h.x+h.width,h.y+h.height]),y.push([h.x,h.y+h.height])):(y.push([h.x,h.y+h.height]),y.push([h.x,h.y])),u.shapeList.push({shape:"polygon",zlevel:a,style:{pointList:y,color:f.dataBackgroundColor},hoverable:!1})}function k(){d={shape:"rectangle",zlevel:a,draggable:!0,ondrift:A,ondragend:H,_type:"filler"},f.orient=="horizontal"?d.style={x:h.x+Math.round(p.start/100*h.width)+c,y:h.y+3,width:p.size-c*2,height:h.height-6,color:f.fillerColor,text:":::",textPosition:"inside"}:d.style={x:h.x+3,y:h.y+Math.round(p.start/100*h.height)+c,width:h.width-6,height:p.size-c*2,color:f.fillerColor,text:"=",textPosition:"inside"},u.shapeList.push(d)}function L(){v={shape:"rectangle",zlevel:a},m={shape:"rectangle",zlevel:a},v.draggable=!0,v.ondrift=A,v.ondragend=H,m.draggable=!0,m.ondrift=A,m.ondragend=H,f.orient=="horizontal"?(v.style={x:d.style.x-c,y:h.y,width:c,height:h.height,color:f.handleColor,text:"|",textPosition:"inside"},m.style={x:d.style.x+d.style.width,y:h.y,width:c,height:h.height,color:f.handleColor,text:"|",textPosition:"inside"}):(v.style={x:h.x,y:d.style.y-c,width:h.width,height:c,color:f.handleColor,text:"—",textPosition:"inside"},m.style={x:h.x,y:d.style.y+d.style.height,width:h.width,height:c,color:f.handleColor,text:"—",textPosition:"inside"}),u.shapeList.push(v),u.shapeList.push(m)}function A(e,t,n){f.zoomLock&&(e=d);var r=e._type=="filler"?c:0;return f.orient=="horizontal"?e.style.x+t-r<=h.x?e.style.x=h.x+r:e.style.x+t+e.style.width+r>=h.x+h.width?e.style.x=h.x+h.width-e.style.width-r:e.style.x+=t:e.style.y+n-r<=h.y?e.style.y=h.y+r:e.style.y+n+e.style.height+r>=h.y+h.height?e.style.y=h.y+h.height-e.style.height-r:e.style.y+=n,e._type=="filler"?O():M(),f.realtime?D():(clearTimeout(g),g=setTimeout(D,200)),!0}function O(){f.orient=="horizontal"?(v.style.x=d.style.x-c,m.style.x=d.style.x+d.style.width,p.start=Math.floor((v.style.x-h.x)/h.width*100),p.end=Math.ceil((m.style.x+c-h.x)/h.width*100)):(v.style.y=d.style.y-c,m.style.y=d.style.y+d.style.height,p.start=Math.floor((v.style.y-h.y)/h.height*100),p.end=Math.ceil((m.style.y+c-h.y)/h.height*100)),n.modShape(v.id,v),n.modShape(m.id,m),n.refresh()}function M(){var e,t;f.orient=="horizontal"?(e=v.style.x,t=m.style.x,d.style.x=Math.min(e,t)+c,d.style.width=Math.abs(e-t)-c,p.start=Math.floor((Math.min(e,t)-h.x)/h.width*100),p.end=Math.ceil((Math.max(e,t)+c-h.x)/h.width*100)):(e=v.style.y,t=m.style.y,d.style.y=Math.min(e,t)+c,d.style.height=Math.abs(e-t)-c,p.start=Math.floor((Math.min(e,t)-h.y)/h.height*100),p.end=Math.ceil((Math.max(e,t)+c-h.y)/h.height*100)),n.modShape(d.id,d),n.refresh()}function _(){if(!f.show)return;f.orient=="horizontal"?(v.style.x=h.x+p.start/100*h.width,m.style.x=h.x+p.end/100*h.width-c,d.style.x=v.style.x+c,d.style.width=m.style.x-v.style.x-c):(v.style.y=h.y+p.start/100*h.height,m.style.y=h.y+p.end/100*h.height-c,d.style.y=v.style.y+c,d.style.height=m.style.y-v.style.y-c),n.modShape(v.id,v),n.modShape(m.id,m),n.modShape(d.id,d),n.refresh()}function D(e){var n,i,s,u,a;for(var l in b){n=b[l];for(var c in n)a=n[c],u=a.length,i=Math.floor(p.start/100*u),s=Math.ceil(p.end/100*u),r[l][c].type!=o.CHART_TYPE_SCATTER?r[l][c].data=a.slice(i,s):r[l][c].data=P(c,a)}!y&&(f.realtime||e)&&t.dispatch(o.EVENT.DATA_ZOOM,null,{zoom:p}),f.start=p.start,f.end=p.end}function P(e,t){var n=[],r=p.scatterMap[e],i,s,o,u,a;f.orient=="horizontal"?(i=r.x.max-r.x.min,s=p.start/100*i+r.x.min,o=p.end/100*i+r.x.min,i=r.y.max-r.y.min,u=p.start2/100*i+r.y.min,a=p.end2/100*i+r.y.min):(i=r.x.max-r.x.min,s=p.start2/100*i+r.x.min,o=p.end2/100*i+r.x.min,i=r.y.max-r.y.min,u=p.start/100*i+r.y.min,a=p.end/100*i+r.y.min);for(var l=0,c=t.length;l<c;l++)t[l][0]>=s&&t[l][0]<=o&&t[l][1]>=u&&t[l][1]<=a&&n.push(t[l]);return n}function H(){u.isDragend=!0}function B(e,n){if(!u.isDragend||!e.target)return;D(),n.dragOut=!0,n.dragIn=!0,!y&&!f.realtime&&t.dispatch(o.EVENT.DATA_ZOOM,null,{zoom:p}),n.needRefresh=!1,u.isDragend=!1;return}function j(e,t){t.needRefresh=!0;return}function F(e){f.start=p.start=e.start,f.end=p.end=e.end,f.start2=p.start2=e.start2,f.end2=p.end2=e.end2,_(),D(!0);return}function I(e){if(!e)return f.start=f.start2=p.start=p.start2=0,f.end=f.end2=p.end=p.end2=100,_(),D(!0),p;var t=i.grid.getArea(),n={x:e.x,y:e.y,width:e.width,height:e.height};n.width<0&&(n.x+=n.width,n.width=-n.width),n.height<0&&(n.y+=n.height,n.height=-n.height);if(n.x>t.x+t.width||n.y>t.y+t.height)return!1;n.x<t.x&&(n.x=t.x),n.x+n.width>t.x+t.width&&(n.width=t.x+t.width-n.x),n.y+n.height>t.y+t.height&&(n.height=t.y+t.height-n.y);var r,s=(n.x-t.x)/t.width,o=1-(n.x+n.width-t.x)/t.width,u=1-(n.y+n.height-t.y)/t.height,a=(n.y-t.y)/t.height;return f.orient=="horizontal"?(r=p.end-p.start,p.start+=r*s,p.end-=r*o,r=p.end2-p.start2,p.start2+=r*u,p.end2-=r*a):(r=p.end-p.start,p.start+=r*u,p.end-=r*a,r=p.end2-p.start2,p.start2+=r*s,p.end2-=r*o),f.start=p.start,f.end=p.end,f.start2=p.start2,f.end2=p.end2,_(),D(!0),p}function q(e,t){var n,r=b.series,i=e.series,s;for(var o=0,u=i.length;o<u;o++){s=i[o].data,r[o]?n=Math.floor(p.start/100*r[o].length):n=0;for(var a=0,f=s.length;a<f;a++)t.series[o].data[a+n]=s[a],r[o]&&(r[o][a+n]=s[a])}}function R(e){y=e}function U(e){r=e,r.dataZoom=u.reformOption(r.dataZoom),f=r.dataZoom,u.clear();if(r.dataZoom.show||u.deepQuery([r],"toolbox.show")&&u.deepQuery([r],"toolbox.feature.dataZoom"))h=E(),p=S(),x();r.dataZoom.show&&w()}function z(){u.clear();if(r.dataZoom.show||u.deepQuery([r],"toolbox.show")&&u.deepQuery([r],"toolbox.feature.dataZoom"))h=E(),p=S();if(r.dataZoom.show){N(),C(),k(),L();for(var e=0,t=u.shapeList.length;e<t;e++)u.shapeList[e].id=n.newShapeId(u.type),n.addShape(u.shapeList[e])}}var s=e("./base");s.call(this,n);var o=e("../config"),u=this;u.type=o.COMPONENT_TYPE_DATAZOOM;var a=u.getZlevelBase(),f,l=30,c=10,h,p,d,v,m,g,y=!1,b;u.init=U,u.resize=z,u.syncBackupData=q,u.absoluteZoom=F,u.rectZoom=I,u.ondragend=B,u.ondataZoom=j,u.silence=R,U(r)}return e("../component").define("dataZoom",t),t}),define("echarts/component/legend",["require","./base","../config","zrender/tool/area","zrender/shape","zrender/shape","zrender/shape","zrender/shape","zrender/shape","../component"],function(e){function t(t,r,i,s){function y(){h=E(),w(),b();for(var e=0,t=f.shapeList.length;e<t;e++)f.shapeList[e].id=r.newShapeId(f.type),r.addShape(f.shapeList[e])}function b(){var e=l.data,t=e.length,n,i,s,o,u=f.getFont(l.textStyle),p=r.getWidth(),d=r.getHeight(),m=h.x,g=h.y,y=l.itemWidth,b=l.itemHeight,w=l.itemGap,E;l.orient=="vertical"&&l.x=="right"&&(m=h.x+h.width-y);for(var N=0;N<t;N++){n=e[N];if(n===""){l.orient=="horizontal"?(m=h.x,g+=b+w):(l.x=="right"?m-=h.maxWidth+w:m+=h.maxWidth+w,g=h.y);continue}i=S(n),i?i=i.type:i="bar",E=L(n),l.orient=="horizontal"?p-m<200&&y+5+a.getTextWidth(n,u)+(N==t-1||e[N+1]===""?0:w)>=p-m&&(m=h.x,g+=b+w):d-g<200&&b+(N==t-1||e[N+1]===""?0:w)>=d-g&&(l.x=="right"?m-=h.maxWidth+w:m+=h.maxWidth+w,g=h.y),s=x(m,g,y,b,v[n]?E:"#ccc",i),s._name=n,l.selectedMode&&(s.onclick=T),f.shapeList.push(s),o={shape:"text",zlevel:c,style:{x:m+y+5,y:g,color:v[n]?l.textStyle.color:"#ccc",text:n,textFont:u,textBaseline:"top"},hoverable:l.selectedMode,clickable:l.selectedMode},l.orient=="vertical"&&l.x=="right"&&(o.style.x-=y+10,o.style.textAlign="right"),o._name=n,l.selectedMode&&(o.onclick=T),f.shapeList.push(o),l.orient=="horizontal"?m+=y+5+a.getTextWidth(n,u)+w:g+=b+w}}function w(){var e=l.padding[0],t=l.padding[1],n=l.padding[2],r=l.padding[3];f.shapeList.push({shape:"rectangle",zlevel:c,hoverable:!1,style:{x:h.x-r,y:h.y-e,width:h.width+r+t,height:h.height+e+n,brushType:l.borderWidth===0?"fill":"both",color:l.backgroundColor,strokeColor:l.borderColor,lineWidth:l.borderWidth}})}function E(){var e=l.data,t=e.length,n=l.itemGap,i=l.itemWidth+5,s=l.itemHeight,o=f.getFont(l.textStyle),u=0,c=0,h=l.padding,p=r.getWidth()-h[1]-h[3],d=r.getHeight()-h[0]-h[2],v=0,m=0;if(l.orient=="horizontal"){c=s;for(var g=0;g<t;g++){if(e[g]===""){v-=n,v>p?(u=p,c+=s+n):u=Math.max(u,v),c+=s+n,v=0;continue}v+=i+a.getTextWidth(e[g],o)+n}c=Math.max(c,s),v-=n,v>p?(u=p,c+=s+n):u=Math.max(u,v)}else{for(var g=0;g<t;g++)m=Math.max(m,a.getTextWidth(e[g],o));m+=i,u=m;for(var g=0;g<t;g++){if(e[g]===""){v-=n,v>d?(c=d,u+=m+n):c=Math.max(c,v),u+=m+n,v=0;continue}v+=s+n}u=Math.max(u,m),v-=n,v>d?(c=d,u+=m+n):c=Math.max(c,v)}p=r.getWidth(),d=r.getHeight();var y;switch(l.x){case"center":y=Math.floor((p-u)/2);break;case"left":y=l.padding[3]+l.borderWidth;break;case"right":y=p-u-l.padding[1]-l.padding[3]-l.borderWidth*2;break;default:y=l.x-0,y=isNaN(y)?0:y}var b;switch(l.y){case"top":b=l.padding[0]+l.borderWidth;break;case"bottom":b=d-c-l.padding[0]-l.padding[2]-l.borderWidth*2;break;case"center":b=Math.floor((d-c)/2);break;default:b=l.y-0,b=isNaN(b)?0:b}return{x:y,y:b,width:u,height:c,maxWidth:m}}function S(e){var t=i.series,n,r;for(var s=0,o=t.length;s<o;s++){if(t[s].name==e)return t[s];if(t[s].type==u.CHART_TYPE_PIE||t[s].type==u.CHART_TYPE_RADAR||t[s].type==u.CHART_TYPE_CHORD){n=!1,r=t[s].data;for(var a=0,f=r.length;a<f;a++)if(r[a].name==e){r=r[a],r.type=t[s].type==u.CHART_TYPE_CHORD?u.CHART_TYPE_PIE:t[s].type,n=!0;break}if(n)return r}else if(t[s].type==u.CHART_TYPE_FORCE){n=!1,r=t[s].categories;for(var a=0,f=r.length;a<f;a++)if(r[a].name==e){r=r[a],r.type=u.CHART_TYPE_FORCE,n=!0;break}if(n)return r}}return}function x(e,t,n,r,i,s){var o={shape:"icon",zlevel:c,style:{iconType:"legendicon"+s,x:e,y:t,width:n,height:r,color:i,strokeColor:i,lineWidth:3},hoverable:l.selectedMode,clickable:l.selectedMode};switch(s){case"line":o.style.brushType="stroke";break;case"k":o.style.brushType="both",o.style.color=f.deepQuery([u],"k.itemStyle.normal.color")||"#fff",o.style.strokeColor=i!="#ccc"?f.deepQuery([u],"k.itemStyle.normal.lineStyle.color")||"#ff3200":i}return o}function T(e){var n=e.target._name;v[n]=!v[n],t.dispatch(u.EVENT.LEGEND_SELECTED,e.event,{selected:v})}function N(e){if(!f.deepQuery([e],"legend.data"))return;i=e,i.legend=f.reformOption(i.legend),i.legend.padding=f.reformCssArray(i.legend.padding),l=i.legend,f.clear(),v={};var t=l.data||[],n,r,o;for(var a=0,c=t.length;a<c;a++){n=t[a];if(n==="")continue;r=S(n),r?(o=f.deepQuery([r],"itemStyle.normal.color"),o&&r.type!=u.CHART_TYPE_K&&k(n,o),v[n]=!0):v[n]=!1}if(s)for(var h in s)v[h]=s[h];y()}function C(e){if(e){i=e,i.legend=f.reformOption(i.legend),i.legend.padding=f.reformCssArray(i.legend.padding);if(i.legend.selected)for(var t in i.legend.selected)v[t]=i.legend.selected[t]}l=i.legend,f.clear(),y()}function k(e,t){d[e]=t}function L(e){return d[e]||(d[e]=r.getColor(p++)),d[e]}function A(e){return d[e]?d[e]:!1}function O(e,t){l.data.push(e),k(e,t),v[e]=!0}function M(e){var t=l.data,n=[],r=!1;for(var i=0,s=t.length;i<s;i++){if(!r&&t[i]==e){r=!0;continue}n.push(t[i])}l.data=n}function _(e){if(typeof e=="undefined")return;var t;for(var n=0,r=f.shapeList.length;n<r;n++){t=f.shapeList[n];if(t._name==e&&t.shape!="text")return t}}function D(e,t){var n;for(var i=0,s=f.shapeList.length;i<s;i++)n=f.shapeList[i],n._name==e&&n.shape!="text"&&(v[e]||(t.style.color="#ccc",t.style.strokeColor="#ccc"),r.modShape(n.id,t))}function P(e){return typeof v[e]!="undefined"?v[e]:!0}var o=e("./base");o.call(this,r);var u=e("../config"),a=e("zrender/tool/area"),f=this;f.type=u.COMPONENT_TYPE_LEGEND;var l,c=f.getZlevelBase(),h={},p=0,d={},v={},m=e("zrender/shape").get("icon");for(var g in n)m.define("legendicon"+g,n[g]);f.init=N,f.refresh=C,f.setColor=k,f.getColor=L,f.hasColor=A,f.add=O,f.del=M,f.getItemShape=_,f.setItemShape=D,f.isSelected=P,N(i)}var n={line:function(e,t){var n=t.height/2;e.moveTo(t.x,t.y+n),e.lineTo(t.x+t.width,t.y+n)},pie:function(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=e("zrender/shape").get("sector");u.buildPath(t,{x:r+s/2,y:i+o+2,r:o+2,r0:6,startAngle:45,endAngle:135})},chord:function(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=e("zrender/shape").get("beziercurve");t.moveTo(r,i+o),u.buildPath(t,{xStart:r,yStart:i+o,cpX1:r+s,cpY1:i+o,cpX2:r,cpY2:i+4,xEnd:r+s,yEnd:i+4}),t.lineTo(r+s,i),u.buildPath(t,{xStart:r+s,yStart:i,cpX1:r,cpY1:i,cpX2:r+s,cpY2:i+o-4,xEnd:r,yEnd:i+o-4}),t.lineTo(r,i+o)},k:function(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=e("zrender/shape").get("candle");u.buildPath(t,{x:r+s/2,y:[i+1,i+1,i+o-6,i+o],width:s-6})},bar:function(e,t){e.rect(t.x,t.y+1,t.width,t.height-2)},force:function(t,n){e("zrender/shape").get("icon").get("circle")(t,n)},radar:function(e,t){var n=6,r=t.x+t.width/2,i=t.y+t.height/2,s=t.height/2,o=2*Math.PI/n,u=-Math.PI/2,a=r+s*Math.cos(u),f=i+s*Math.sin(u);e.moveTo(a,f),u+=o;for(var l=0,c=n-1;l<c;l++)e.lineTo(r+s*Math.cos(u),i+s*Math.sin(u)),u+=o;e.lineTo(a,f)}};return e("../component").define("legend",t),t}),define("echarts/component/dataRange",["require","./base","../config","zrender/tool/area","zrender/tool/color","zrender/tool/color","../component"],function(e){function t(t,n,r){function T(){l=M(),O(),a.splitNumber<=0||a.calculable?C():N();for(var e=0,t=u.shapeList.length;e<t;e++)u.shapeList[e].id=n.newShapeId(u.type),n.addShape(u.shapeList[e])}function N(){var e=S,t=e.length,n,r,i,s=u.getFont(a.textStyle),c=l.x,h=l.y,p=a.itemWidth,d=a.itemHeight,v=a.itemGap,m=o.getTextWidth("国",s),g;a.orient=="vertical"&&a.x=="right"&&(c=l.x+l.width-p);var y=!0;a.text&&(y=!1,a.text[0]&&(i=_(c,h,a.text[0]),a.orient=="horizontal"?c+=o.getTextWidth(a.text[0],s)+b:h+=m+b,u.shapeList.push(i)));for(var E=0;E<t;E++)n=e[E],g=W((t-E)*w+a.min),r=D(c,h,p,d,x[E]?g:"#ccc"),r._idx=E,r.onclick=R,u.shapeList.push(r),y&&(i={shape:"text",zlevel:f,style:{x:c+p+5,y:h,color:x[E]?a.textStyle.color:"#ccc",text:e[E],textFont:s,textBaseline:"top"},clickable:!0},a.orient=="vertical"&&a.x=="right"&&(i.style.x-=p+10,i.style.textAlign="right"),i._idx=E,i.onclick=R,u.shapeList.push(i)),a.orient=="horizontal"?c+=p+(y?5:0)+(y?o.getTextWidth(n,s):0)+v:h+=d+v;!y&&a.text[1]&&(a.orient=="horizontal"?c=c-v+b:h=h-v+b,i=_(c,h,a.text[1]),u.shapeList.push(i))}function C(){var t,n,r=u.getFont(a.textStyle),i=l.x,s=l.y,h=a.itemWidth,p=a.itemHeight,d=o.getTextWidth("国",r),v=!0;a.text&&(v=!1,a.text[0]&&(n=_(i,s,a.text[0]),a.orient=="horizontal"?i+=o.getTextWidth(a.text[0],r)+b:s+=d+b,u.shapeList.push(n)));var m=e("zrender/tool/color"),g=1/(a.color.length-1),y=[];for(var w=0,E=a.color.length;w<E;w++)y.push([w*g,a.color[w]]);a.orient=="horizontal"?(t={shape:"rectangle",zlevel:f,style:{x:i,y:s,width:h*10,height:p,color:m.getLinearGradient(i,s,i+h*10,s,y)},hoverable:!1},i+=h*10+b):(t={shape:"rectangle",zlevel:f,style:{x:i,y:s,width:h,height:p*10,color:m.getLinearGradient(i,s,i,s+p*10,y)},hoverable:!1},s+=p*10+b),u.shapeList.push(t),a.calculable&&(c=t.style,k(),A(),L()),!v&&a.text[1]&&(n=_(i,s,a.text[1]),u.shapeList.push(n))}function k(){m={shape:"rectangle",zlevel:f+1,style:{x:c.x,y:c.y,width:c.width,height:c.height,color:"rgba(255,255,255,0.2)"},draggable:!0,ondrift:P,ondragend:H,_type:"filler"},u.shapeList.push(m)}function L(){var e=c.x,t=c.y,n=c.width,r=c.height,i=u.getFont(a.textStyle),s=o.getTextWidth("国",i)+2,l=Math.max(o.getTextWidth(a.precision===0?a.max:a.max.toFixed(a.precision),i),o.getTextWidth(a.precision===0?a.min:a.min.toFixed(a.precision),i))+2,p,v,m,g,y,b;a.orient=="horizontal"?a.y!="bottom"?(p=[[e,t],[e,t+r+s/2*3],[e-l,t+r+s/2*3],[e-l,t+r+s/2],[e-s/2,t+r+s/2],[e-1,t+r],[e-1,t]],v=e-l/2,m=t+r+s,g=[[e+n,t],[e+n,t+r+s/2*3],[e+n+l,t+r+s/2*3],[e+n+l,t+r+s/2],[e+n+s/2,t+r+s/2],[e+n+1,t+r],[e+n+1,t]],y=e+n+l/2,b=m):(p=[[e,t+r],[e,t-s/2*3],[e-l,t-s/2*3],[e-l,t-s/2],[e-s/2,t-s/2],[e-1,t],[e-1,t+r]],v=e-l/2,m=t-s,g=[[e+n,t+r],[e+n,t-s/2*3],[e+n+l,t-s/2*3],[e+n+l,t-s/2],[e+n+s/2,t-s/2],[e+n+1,t],[e+n+1,t+r]],y=e+n+l/2,b=m):(l+=s,a.x!="right"?(p=[[e,t],[e+n+l,t],[e+n+l,t-s],[e+n+s,t-s],[e+n,t-1],[e,t-1]],v=e+n+l/2+s/2,m=t-s/2,g=[[e,t+r],[e+n+l,t+r],[e+n+l,t+s+r],[e+n+s,t+s+r],[e+n,t+1+r],[e,t+r+1]],y=v,b=t+r+s/2):(p=[[e+n,t],[e-l,t],[e-l,t-s],[e-s,t-s],[e,t-1],[e+n,t-1]],v=e-l/2-s/2,m=t-s/2,g=[[e+n,t+r],[e-l,t+r],[e-l,t+s+r],[e-s,t+s+r],[e,t+1+r],[e+n,t+r+1]],y=v,b=t+r+s/2)),h={shape:"polygon",zlevel:f+1,style:{pointList:p,text:a.max+"",textX:v,textY:m,textPosition:"specific",textAlign:"center",textBaseline:"middle ",textColor:a.textStyle.color,color:W(a.max),width:0,height:0,x:p[0][0],y:p[0][1],_x:p[0][0],_y:p[0][1]},draggable:!0,ondrift:P,ondragend:H},d={shape:"polygon",zlevel:f+1,style:{pointList:g,text:a.min+"",textX:y,textY:b,textPosition:"specific",textAlign:"center",textBaseline:"middle ",textColor:a.textStyle.color,color:W(a.min),width:0,height:0,x:g[0][0],y:g[0][1],_x:g[0][0],_y:g[0][1]},draggable:!0,ondrift:P,ondragend:H},u.shapeList.push(h),u.shapeList.push(d)}function A(){var e=c.x,t=c.y,n=c.width,r=c.height;p={shape:"rectangle",zlevel:f+1,style:{x:e,y:t,width:a.orient=="horizontal"?0:n,height:a.orient=="horizontal"?r:0,color:"#ccc"},hoverable:!1},v={shape:"rectangle",zlevel:f+1,style:{x:a.orient=="horizontal"?e+n:e,y:a.orient=="horizontal"?t:t+r,width:a.orient=="horizontal"?0:n,height:a.orient=="horizontal"?r:0,color:"#ccc"},hoverable:!1},u.shapeList.push(p),u.shapeList.push(v)}function O(){var e=a.padding[0],t=a.padding[1],n=a.padding[2],r=a.padding[3];u.shapeList.push({shape:"rectangle",zlevel:f,hoverable:!1,style:{x:l.x-r,y:l.y-e,width:l.width+r+t,height:l.height+e+n,brushType:a.borderWidth===0?"fill":"both",color:a.backgroundColor,strokeColor:a.borderColor,lineWidth:a.borderWidth}})}function M(){var e=S,t=e.length,r=a.itemGap,i=a.itemWidth,s=a.itemHeight,f=0,l=0,c=u.getFont(a.textStyle),h=o.getTextWidth("国",c);if(a.orient=="horizontal"){if(a.text||a.splitNumber<=0||a.calculable)f=(a.splitNumber<=0||a.calculable?i*10+r:t*(i+r))+(a.text&&typeof a.text[0]!="undefined"?o.getTextWidth(a.text[0],c)+b:0)+(a.text&&typeof a.text[1]!="undefined"?o.getTextWidth(a.text[1],c)+b:0);else{i+=5;for(var p=0;p<t;p++)f+=i+o.getTextWidth(e[p],c)+r}f-=r,l=Math.max(h,s)}else{var d;if(a.text||a.splitNumber<=0||a.calculable)l=(a.splitNumber<=0||a.calculable?s*10+r:t*(s+r))+(a.text&&typeof a.text[0]!="undefined"?b+h:0)+(a.text&&typeof a.text[1]!="undefined"?b+h:0),d=Math.max(o.getTextWidth(a.text&&a.text[0]||"",c),o.getTextWidth(a.text&&a.text[1]||"",c)),f=Math.max(i,d);else{l=(s+r)*t,i+=5,d=0;for(var p=0;p<t;p++)d=Math.max(d,o.getTextWidth(e[p],c));f=i+d}l-=r}var v,m=n.getWidth();switch(a.x){case"center":v=Math.floor((m-f)/2);break;case"left":v=a.padding[3]+a.borderWidth;break;case"right":v=m-f-a.padding[1]-a.borderWidth;break;default:v=a.x-0,v=isNaN(v)?0:v}var g,y=n.getHeight();switch(a.y){case"top":g=a.padding[0]+a.borderWidth;break;case"bottom":g=y-l-a.padding[2]-a.borderWidth;break;case"center":g=Math.floor((y-l)/2);break;default:g=a.y-0,g=isNaN(g)?0:g}if(a.calculable){var w=Math.max(o.getTextWidth(a.max,c),o.getTextWidth(a.min,c));a.orient=="horizontal"?(v<w&&(v=w+5),v+f+w>m&&(v-=w+5)):(g<h&&(g=h+5),g+l+h>y&&(g-=h+5))}return{x:v,y:g,width:f,height:l}}function _(e,t,n){return{shape:"text",zlevel:f,style:{x:a.orient=="horizontal"?e:l.x+l.width/2,y:a.orient=="horizontal"?l.y+l.height/2:t,color:a.textStyle.color,text:n,textFont:u.getFont(a.textStyle),textBaseline:a.orient=="horizontal"?"middle":"top",textAlign:a.orient=="horizontal"?"left":"center"}}}function D(e,t,n,r,i){return{shape:"rectangle",zlevel:f,style:{x:e,y:t+1,width:n,height:r-2,color:i},clickable:!0}}function P(e,t,n){var r=c.x,i=c.y,s=c.width,o=c.height;return a.orient=="horizontal"?e.style.x+t<=r?e.style.x=r:e.style.x+t+e.style.width>=r+s?e.style.x=r+s-e.style.width:e.style.x+=t:e.style.y+n<=i?e.style.y=i:e.style.y+n+e.style.height>=i+o?e.style.y=i+o-e.style.height:e.style.y+=n,e._type=="filler"?j():F(e),a.realtime?q():(clearTimeout(y),y=setTimeout(q,200)),!0}function H(){u.isDragend=!0}function B(e,n){if(!u.isDragend||!e.target)return;q(),n.dragOut=!0,n.dragIn=!0,a.realtime||t.dispatch(s.EVENT.DATA_RANGE),n.needRefresh=!1,u.isDragend=!1;return}function j(){var e=c.x,t=c.y,n=c.width,r=c.height;a.orient=="horizontal"?(h.style.x=m.style.x,p.style.width=h.style.x-e,d.style.x=m.style.x+m.style.width,v.style.x=d.style.x,v.style.width=e+n-d.style.x,g.start=Math.ceil(100-(h.style.x-e)/n*100),g.end=Math.floor(100-(d.style.x-e)/n*100)):(h.style.y=m.style.y,p.style.height=h.style.y-t,d.style.y=m.style.y+m.style.height,v.style.y=d.style.y,v.style.height=t+r-d.style.y,g.start=Math.ceil(100-(h.style.y-t)/r*100),g.end=Math.floor(100-(d.style.y-t)/r*100)),I(!1)}function F(e){var t=c.x,n=c.y,r=c.width,i=c.height,s,o;a.orient=="horizontal"?(s=h.style.x,o=d.style.x,e.id==h.id&&s>=o?(o=s,d.style.x=s):e.id==d.id&&s>=o&&(s=o,h.style.x=s),m.style.x=s,m.style.width=o-s,p.style.width=s-t,v.style.x=o,v.style.width=t+r-o,g.start=Math.ceil(100-(s-t)/r*100),g.end=Math.floor(100-(o-t)/r*100)):(s=h.style.y,o=d.style.y,e.id==h.id&&s>=o?(o=s,d.style.y=s):e.id==d.id&&s>=o&&(s=o,h.style.y=s),m.style.y=s,m.style.height=o-s,p.style.height=s-n,v.style.y=o,v.style.height=n+i-o,g.start=Math.ceil(100-(s-n)/i*100),g.end=Math.floor(100-(o-n)/i*100)),I(!0)}function I(e){h.position=[h.style.x-h.style._x,h.style.y-h.style._y],a.precision===0?h.style.text=Math.round(w*g.start+a.min)+"":h.style.text=(w*g.start+a.min).toFixed(a.precision),h.style.color=W(w*g.start+a.min),n.modShape(h.id,h),d.position=[d.style.x-d.style._x,d.style.y-d.style._y],a.precision===0?d.style.text=Math.round(w*g.end+a.min)+"":d.style.text=(w*g.end+a.min).toFixed(a.precision),d.style.color=W(w*g.end+a.min),n.modShape(d.id,d),n.modShape(p.id,p),n.modShape(v.id,v),e&&n.modShape(m.id,m),n.refresh()}function q(){a.realtime&&t.dispatch(s.EVENT.DATA_RANGE)}function R(e){var n=e.target._idx;x[n]=!x[n],t.dispatch(s.EVENT.REFRESH)}function U(t){if(typeof u.deepQuery([t],"dataRange.min")=="undefined"||typeof u.deepQuery([t],"dataRange.max")=="undefined")return;r=t,r.dataRange=u.reformOption(r.dataRange),r.dataRange.padding=u.reformCssArray(r.dataRange.padding),a=r.dataRange,u.clear(),x={};var n=e("zrender/tool/color"),i=a.splitNumber<=0||a.calculable?100:a.splitNumber;E=n.getGradientColors(a.color,(i-a.color.length)/(a.color.length-1)+1),E=E.slice(0,i),a.precision===0?w=Math.round((a.max-a.min)/i)||1:(w=(a.max-a.min)/i,w=w.toFixed(a.precision)-0),S=[];for(var s=0;s<i;s++)x[s]=!0,S.unshift((s*w+a.min).toFixed(a.precision)+" - "+((s+1)*w+a.min).toFixed(a.precision));g={start:100,end:0},T()}function z(e){e&&(r=e,r.dataRange=u.reformOption(r.dataRange),r.dataRange.padding=u.reformCssArray(r.dataRange.padding)),a=r.dataRange,g={start:100,end:0},u.clear(),T()}function W(e){if(isNaN(e))return null;e<a.min?e=a.min:e>a.max&&(e=a.max);if(a.calculable)if(e>w*g.start+a.min||e<w*g.end+a.min)return null;var t=E.length-Math.ceil((e-a.min)/(a.max-a.min)*E.length);return t==E.length&&t--,x[t]?E[t]:null}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/tool/area"),u=this;u.type=s.COMPONENT_TYPE_DATARANGE;var a,f=u.getZlevelBase(),l={},c,h,p,d,v,m,g,y,b=10,w,E,S,x={};u.init=U,u.refresh=z,u.getColor=W,u.ondragend=B,U(r)}return e("../component").define("dataRange",t),t}),define("echarts/component/tooltip",["require","./base","../config","../util/ecData","zrender/config","zrender/shape","zrender/tool/event","zrender/tool/area","zrender/tool/color","zrender/tool/util","zrender/shape/base","../component"],function(e){function t(t,n,r,i){function I(e){if(!e)return"";cssText=[];if(e.transitionDuration){var t="left "+e.transitionDuration+"s,"+"top "+e.transitionDuration+"s";cssText.push("transition:"+t),cssText.push("-moz-transition:"+t),cssText.push("-webkit-transition:"+t),cssText.push("-o-transition:"+t)}e.backgroundColor&&(cssText.push("background-Color:"+h.toHex(e.backgroundColor)),cssText.push("filter:alpha(opacity=70)"),cssText.push("background-Color:"+e.backgroundColor)),typeof e.borderWidth!="undefined"&&cssText.push("border-width:"+e.borderWidth+"px"),typeof e.borderColor!="undefined"&&cssText.push("border-color:"+e.borderColor),typeof e.borderRadius!="undefined"&&(cssText.push("border-radius:"+e.borderRadius+"px"),cssText.push("-moz-border-radius:"+e.borderRadius+"px"),cssText.push("-webkit-border-radius:"+e.borderRadius+"px"),cssText.push("-o-border-radius:"+e.borderRadius+"px"));var n=e.textStyle;n&&(n.color&&cssText.push("color:"+n.color),n.decoration&&cssText.push("text-decoration:"+n.decoration),n.align&&cssText.push("text-align:"+n.align),n.fontFamily&&cssText.push("font-family:"+n.fontFamily),n.fontSize&&cssText.push("font-size:"+n.fontSize+"px"),n.fontSize&&cssText.push("line-height:"+Math.round(n.fontSize*3/2)+"px"),n.fontStyle&&cssText.push("font-style:"+n.fontStyle),n.fontWeight&&cssText.push("font-weight:"+n.fontWeight));var r=e.padding;return typeof r!="undefined"&&(r=m.reformCssArray(r),cssText.push("padding:"+r[0]+"px "+r[1]+"px "+r[2]+"px "+r[3]+"px")),cssText=cssText.join(";")+";",cssText}function q(){x&&(x.style.display="none");var e=!1;j.invisible||(j.invisible=!0,n.modShape(j.id,j),e=!0),F.invisible||(F.invisible=!0,n.modShape(F.id,F),e=!0),B&&B.tipShape.length>0&&(n.delShape(B.tipShape),B=!1),e&&n.refresh()}function R(e,t,n){var r=x.offsetHeight,i=x.offsetWidth;e+i>H&&(e=H-i),t+r>P&&(t=P-r),t<20&&(t=0),x.style.cssText=T+N+(n?n:"")+"left:"+e+"px;top:"+t+"px;",(H-e<100||P-t<100)&&setTimeout(U,20)}function U(){if(x){var e="",t=x.offsetHeight,n=x.offsetWidth;x.offsetLeft+n>H&&(e+="left:"+(H-n)+"px;"),x.offsetTop+t>P&&(e+="top:"+(P-t)+"px;"),e!==""&&(x.style.cssText+=e)}}function z(){var e,t;if(!M)X()||W();else{if(M._type=="island"&&r.tooltip.show){K();return}var n=u.get(M,"series"),i=u.get(M,"data");e=m.deepQuery([i,n,r],"tooltip.show"),typeof n=="undefined"||typeof i=="undefined"||e===!1?(clearTimeout(k),clearTimeout(A),k=setTimeout(q,L)):(t=m.deepQuery([i,n,r],"tooltip.trigger"),t=="axis"?$(n.xAxisIndex,n.yAxisIndex,u.get(M,"dataIndex")):K())}}function W(){if(!w||!E){k=setTimeout(q,L);return}var e=r.series,t,n;for(var i=0,s=e.length;i<s;i++)if(m.deepQuery([e[i],r],"tooltip.trigger")=="axis"){t=e[i].xAxisIndex||0,n=e[i].yAxisIndex||0;if(w.getAxis(t)&&w.getAxis(t).type==o.COMPONENT_TYPE_AXIS_CATEGORY){$(t,n,V("x",w.getAxis(t)));return}if(E.getAxis(n)&&E.getAxis(n).type==o.COMPONENT_TYPE_AXIS_CATEGORY){$(t,n,V("y",E.getAxis(n)));return}}}function X(){if(!S)return!1;var e=l.getX(_),t=l.getY(_),n=S.getNearestIndex([e,t]),r;return n?(r=n.valueIndex,n=n.polarIndex):n=-1,n!=-1?J(n,r):!1}function V(e,t){var n=-1,r=l.getX(_),i=l.getY(_);if(e=="x"){var s,o,u=b.getXend(),a=t.getCoordByIndex(n);while(a<u){a<=r&&(s=a);if(a>=r)break;a=t.getCoordByIndex(++n),o=a}return r-s<o-r?n-=1:typeof t.getNameByIndex(n)=="undefined"&&(n=-1),n}var f,c,h=b.getY(),a=t.getCoordByIndex(n);while(a>h){a>=i&&(c=a);if(a<=i)break;a=t.getCoordByIndex(++n),f=a}return i-f>c-i?n-=1:typeof t.getNameByIndex(n)=="undefined"&&(n=-1),n}function $(e,n,s){if(typeof w=="undefined"||typeof E=="undefined"||typeof e=="undefined"||typeof n=="undefined"||s<0){clearTimeout(k),clearTimeout(A),k=setTimeout(q,L);return}var u=r.series,a=[],f=[],c,h,p,d,v,g="";if(r.tooltip.trigger=="axis"){if(r.tooltip.show===!1)return;d=r.tooltip.formatter}if(e!=-1&&w.getAxis(e).type==o.COMPONENT_TYPE_AXIS_CATEGORY){c=w.getAxis(e);for(var y=0,S=u.length;y<S;y++)u[y].xAxisIndex==e&&m.deepQuery([u[y],r],"tooltip.trigger")=="axis"&&(v=m.deepQuery([u[y]],"tooltip.showContent")||v,d=m.deepQuery([u[y]],"tooltip.formatter")||d,g+=I(m.deepQuery([u[y]],"tooltip")),a.push(u[y]),f.push(y));t.dispatch(o.EVENT.TOOLTIP_HOVER,_,{seriesIndex:f,dataIndex:s}),p=l.getY(_)+10,h=c.getCoordByIndex(s),Q(a,h,b.getY(),h,b.getYend(),c.getGap()),h+=10}else if(n!=-1&&E.getAxis(n).type==o.COMPONENT_TYPE_AXIS_CATEGORY){c=E.getAxis(n);for(var y=0,S=u.length;y<S;y++)u[y].yAxisIndex==n&&m.deepQuery([u[y],r],"tooltip.trigger")=="axis"&&(v=m.deepQuery([u[y]],"tooltip.showContent")||v,d=m.deepQuery([u[y]],"tooltip.formatter")||d,g+=I(m.deepQuery([u[y]],"tooltip")),a.push(u[y]),f.push(y));t.dispatch(o.EVENT.TOOLTIP_HOVER,_,{seriesIndex:f,dataIndex:s}),h=l.getX(_)+10,p=c.getCoordByIndex(s),Q(a,b.getX(),p,b.getXend(),p,c.getGap()),p+=10}if(a.length>0){var T;if(typeof d=="function"){var N=[];for(var y=0,S=a.length;y<S;y++)T=a[y].data[s],T=typeof T!="undefined"?typeof T.value!="undefined"?T.value:T:"-",N.push([a[y].name||"",c.getNameByIndex(s),T]);D="axis:"+s,x.innerHTML=d(N,D,Z)}else if(typeof d=="string"){D=NaN,d=d.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}");for(var y=0,S=a.length;y<S;y++)d=d.replace("{a"+y+"}",_encodeHTML(a[y].name||"")),d=d.replace("{b"+y+"}",_encodeHTML(c.getNameByIndex(s))),T=a[y].data[s],T=typeof T!="undefined"?typeof T.value!="undefined"?T.value:T:"-",d=d.replace("{c"+y+"}",T);x.innerHTML=d}else{D=NaN,d=_encodeHTML(c.getNameByIndex(s));for(var y=0,S=a.length;y<S;y++)d+="<br/>"+_encodeHTML(a[y].name||"")+" : ",T=a[y].data[s],T=typeof T!="undefined"?typeof T.value!="undefined"?T.value:T:"-",d+=T;x.innerHTML=d}if(v===!1||!r.tooltip.showContent)return;m.hasAppend||(x.style.left=H/2+"px",x.style.top=P/2+"px",i.firstChild.appendChild(x),m.hasAppend=!0),R(h,p,g)}}function J(e,t){if(typeof S=="undefined"||typeof e=="undefined"||typeof t=="undefined"||t<0)return!1;var n=r.series,s=[],o,u,a="";if(r.tooltip.trigger=="axis"){if(r.tooltip.show===!1)return!1;o=r.tooltip.formatter}for(var f=0,c=n.length;f<c;f++)n[f].polarIndex==e&&m.deepQuery([n[f],r],"tooltip.trigger")=="axis"&&(u=m.deepQuery([n[f]],"tooltip.showContent")||u,o=m.deepQuery([n[f]],"tooltip.formatter")||o,a+=I(m.deepQuery([n[f]],"tooltip")),s.push(n[f]));if(s.length>0){var h,p,d=[],v=r.polar[e].indicator[t].text;for(var f=0,c=s.length;f<c;f++){h=s[f].data;for(var g=0,y=h.length;g<y;g++)p=h[g],p=typeof p!="undefined"?p:{name:"",value:{dataIndex:"-"}},d.push([s[f].name||"",p.name,p.value[t],v])}if(d.length<=0)return;if(typeof o=="function")D="axis:"+t,x.innerHTML=o(d,D,Z);else if(typeof o=="string"){o=o.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}").replace("{d}","{d0}");for(var f=0,c=d.length;f<c;f++)o=o.replace("{a"+f+"}",_encodeHTML(d[f][0])),o=o.replace("{b"+f+"}",_encodeHTML(d[f][1])),o=o.replace("{c"+f+"}",d[f][2]),o=o.replace("{d"+f+"}",_encodeHTML(d[f][3]));x.innerHTML=o}else{o=_encodeHTML(d[0][1])+"<br/>"+_encodeHTML(d[0][3])+" : "+d[0][2];for(var f=1,c=d.length;f<c;f++)o+="<br/>"+_encodeHTML(d[f][1])+"<br/>",o+=_encodeHTML(d[f][3])+" : "+d[f][2];x.innerHTML=o}if(u===!1||!r.tooltip.showContent)return;return m.hasAppend||(x.style.left=H/2+"px",x.style.top=P/2+"px",i.firstChild.appendChild(x),m.hasAppend=!0),R(l.getX(_),l.getY(_),a),!0}}function K(){var e=u.get(M,"series"),t=u.get(M,"data"),s=u.get(M,"name"),a=u.get(M,"value"),f=u.get(M,"special"),c=u.get(M,"special2"),h,p,d="",v,g="";M._type!="island"?(r.tooltip.trigger=="item"&&(h=r.tooltip.formatter),m.deepQuery([e],"tooltip.trigger")=="item"&&(p=m.deepQuery([e],"tooltip.showContent")||p,h=m.deepQuery([e],"tooltip.formatter")||h,d+=I(m.deepQuery([e],"tooltip"))),p=m.deepQuery([t],"tooltip.showContent")||p,h=m.deepQuery([t],"tooltip.formatter")||h,d+=I(m.deepQuery([t],"tooltip"))):(p=m.deepQuery([t,e,r],"tooltip.showContent"),h=m.deepQuery([t,e,r],"tooltip.islandFormatter"));if(typeof h=="function")D=(e.name||"")+":"+u.get(M,"dataIndex"),x.innerHTML=h([e.name||"",s,a,f,c],D,Z);else if(typeof h=="string")D=NaN,h=h.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}"),h=h.replace("{a0}",_encodeHTML(e.name||"")).replace("{b0}",_encodeHTML(s)).replace("{c0}",a),h=h.replace("{d}","{d0}").replace("{d0}",f||""),h=h.replace("{e}","{e0}").replace("{e0}",u.get(M,"special2")||""),x.innerHTML=h;else{D=NaN;if(e.type==o.CHART_TYPE_SCATTER)x.innerHTML=(typeof e.name!="undefined"?_encodeHTML(e.name)+"<br/>":"")+(s===""?"":_encodeHTML(s)+" : ")+a+(typeof f=="undefined"?"":" ("+f+")");else if(e.type==o.CHART_TYPE_RADAR){v=f,g+=_encodeHTML(s===""?e.name||"":s),g+=g===""?"":"<br />";for(var y=0;y<v.length;y++)g+=_encodeHTML(v[y].text)+" : "+a[y]+"<br />";x.innerHTML=g}else if(e.type==o.CHART_TYPE_CHORD)if(typeof c=="undefined")x.innerHTML=_encodeHTML(s)+" ("+a+")";else{var b=_encodeHTML(s),w=_encodeHTML(f);x.innerHTML=(typeof e.name!="undefined"?_encodeHTML(e.name)+"<br/>":"")+b+" -> "+w+" ("+a+")"+"<br />"+w+" -> "+b+" ("+c+")"}else x.innerHTML=(typeof e.name!="undefined"?_encodeHTML(e.name)+"<br/>":"")+_encodeHTML(s)+" : "+a+(typeof f=="undefined"?"":" ("+f+")")}j.invisible||(j.invisible=!0,n.modShape(j.id,j),n.refresh());if(p===!1||!r.tooltip.showContent)return;m.hasAppend||(x.style.left=H/2+"px",x.style.top=P/2+"px",i.firstChild.appendChild(x),m.hasAppend=!0),R(l.getX(_)+20,l.getY(_)-20,d)}function Q(e,t,i,s,o,u){if(e.length>0){var a,f,l=r.tooltip.axisPointer,c=l.type,h=l.lineStyle.color,p=l.lineStyle.width,d=l.lineStyle.type,v=l.areaStyle.size,g=l.areaStyle.color;for(var y=0,w=e.length;y<w;y++)m.deepQuery([e[y],r],"tooltip.trigger")=="axis"&&(a=[e[y]],f=m.deepQuery(a,"tooltip.axisPointer.type"),c=f||c,f=="line"?(h=m.deepQuery(a,"tooltip.axisPointer.lineStyle.color")||h,p=m.deepQuery(a,"tooltip.axisPointer.lineStyle.width")||p,d=m.deepQuery(a,"tooltip.axisPointer.lineStyle.type")||d):f=="shadow"&&(v=m.deepQuery(a,"tooltip.axisPointer.areaStyle.size")||v,g=m.deepQuery(a,"tooltip.axisPointer.areaStyle.color")||g));c=="line"?(j.style={xStart:t,yStart:i,xEnd:s,yEnd:o,strokeColor:h,lineWidth:p,lineType:d},j.invisible=!1,n.modShape(j.id,j)):c=="shadow"&&(typeof v=="undefined"||v=="auto"||isNaN(v)?p=u:p=v,t==s?Math.abs(b.getX()-t)<2?(p/=2,t=s+=p/2):Math.abs(b.getXend()-t)<2&&(p/=2,t=s-=p/2):i==o&&(Math.abs(b.getY()-i)<2?(p/=2,i=o+=p/2):Math.abs(b.getYend()-i)<2&&(p/=2,i=o-=p/2)),F.style={xStart:t,yStart:i,xEnd:s,yEnd:o,strokeColor:g,lineWidth:p},F.invisible=!1,n.modShape(F.id,F)),n.refresh()}}function G(e){clearTimeout(k),clearTimeout(A);var t=e.target,n=l.getX(e.event),i=l.getY(e.event);if(!t)M=!1,_=e.event,_._target=_.target||_.toElement,_.zrenderX=n,_.zrenderY=i,C&&b&&c.isInside(v,b.getArea(),n,i)?A=setTimeout(z,O):C&&S&&S.isInside([n,i])!=-1?A=setTimeout(z,O):k=setTimeout(q,L);else{M=t,_=e.event,_._target=_.target||_.toElement,_.zrenderX=n,_.zrenderY=i;var s;if(C&&S&&(s=S.isInside([n,i]))!=-1){var o=r.series;for(var u=0,a=o.length;u<a;u++)if(o[u].polarIndex==s&&m.deepQuery([o[u],r],"tooltip.trigger")=="axis"){M=null;break}}A=setTimeout(z,O)}}function Y(){clearTimeout(k),clearTimeout(A),k=setTimeout(q,L)}function Z(e,t){e==D&&(x.innerHTML=t);var n="",r=x.offsetHeight,i=x.offsetWidth;x.offsetLeft+i>H&&(n+="left:"+(H-i)+"px;"),x.offsetTop+r>P&&(n+="top:"+(P-r)+"px;"),n!==""&&(x.style.cssText+=n),(H-x.offsetLeft<100||P-x.offsetTop<100)&&setTimeout(U,20)}function et(e){y=e,b=y.grid,w=y.xAxis,E=y.yAxis,S=y.polar}function tt(e,t){if(!B||B&&B.dataIndex!=e.dataIndex){B&&B.tipShape.length>0&&n.delShape(B.tipShape);for(var r=0,i=t.length;r<i;r++)t[r].id=n.newShapeId("tooltip"),t[r].zlevel=g,t[r].style=d.getHighlightStyle(t[r].style,t[r].highlightStyle),t[r].draggable=!1,t[r].hoverable=!1,t[r].clickable=!1,t[r].ondragend=null,t[r].ondragover=null,t[r].ondrop=null,n.addShape(t[r]);B={dataIndex:e.dataIndex,tipShape:t}}}function nt(){q()}function rt(e,t){r=e,i=t,r.tooltip=m.reformOption(r.tooltip),r.tooltip.textStyle=p.merge(r.tooltip.textStyle,o.textStyle,{overwrite:!1,recursive:!0}),r.tooltip.padding=m.reformCssArray(r.tooltip.padding),C=!1,r.tooltip.trigger=="axis"&&(C=!0);var n=r.series;for(var s=0,u=n.length;s<u;s++)if(m.deepQuery([n[s]],"tooltip.trigger")=="axis"){C=!0;break}O=r.tooltip.showDelay,L=r.tooltip.hideDelay,N=I(r.tooltip),x.style.position="absolute",m.hasAppend=!1}function it(e){e&&(r=e,r.tooltip=m.reformOption(r.tooltip),r.tooltip.textStyle=p.merge(r.tooltip.textStyle,o.textStyle,{overwrite:!1,recursive:!0}),r.tooltip.padding=m.reformCssArray(r.tooltip.padding))}function st(){P=n.getHeight(),H=n.getWidth()}function ot(){clearTimeout(k),clearTimeout(A),n.un(a.EVENT.MOUSEMOVE,G),n.un(a.EVENT.GLOBALOUT,Y),m.hasAppend&&i.firstChild.removeChild(x),x=null,m.shapeList=null,m=null}var s=e("./base");s.call(this,n);var o=e("../config"),u=e("../util/ecData"),a=e("zrender/config"),f=e("zrender/shape"),l=e("zrender/tool/event"),c=e("zrender/tool/area"),h=e("zrender/tool/color"),p=e("zrender/tool/util"),d=e("zrender/shape/base"),v=f.get("rectangle"),m=this;m.type=o.COMPONENT_TYPE_TOOLTIP;var g=m.getZlevelBase(),y={},b,w,E,S,x=document.createElement("div"),T="position:absolute;display:block;border-style:solid;white-space:nowrap;",N,C,k,L,A,O,M,_,D,P=n.getHeight(),H=n.getWidth(),B=!1,j={shape:"line",id:n.newShapeId("tooltip"),zlevel:g,invisible:!0,hoverable:!1,style:{}},F={shape:"line",id:n.newShapeId("tooltip"),zlevel:1,invisible:!0,hoverable:!1,style:{}};n.addShape(j),n.addShape(F),_encodeHTML=function(e){return String(e).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")},n.on(a.EVENT.MOUSEMOVE,G),n.on(a.EVENT.GLOBALOUT,Y),m.dispose=ot,m.init=rt,m.refresh=it,m.resize=st,m.setComponent=et,m.ontooltipHover=tt,m.ondragend=nt,rt(r,i)}return e("../component").define("tooltip",t),t}),define("echarts/component/toolbox",["require","./base","../config","zrender/config","zrender/tool/event","../component","../component"],function(e){function t(t,n,r){function L(){d=[];var e=a.toolbox.feature;for(var t in e)if(e[t])switch(t){case"mark":d.push("mark"),d.push("markUndo"),d.push("markClear");break;case"magicType":for(var r=0,i=e[t].length;r<i;r++)d.push(e[t][r]+"Chart");break;case"dataZoom":d.push("dataZoom"),d.push("dataZoomReset");break;case"saveAsImage":G_vmlCanvasManager||d.push("saveAsImage");break;default:d.push(t)}if(d.length>0){m=M(),O(),A();for(var r=0,i=l.shapeList.length;r<i;r++)l.shapeList[r].id=n.newShapeId(l.type),n.addShape(l.shapeList[r]);v.mark&&(z(v.markUndo),z(v.markClear)),v.dataZoomReset&&C.length===0&&z(v.dataZoomReset)}}function A(){var i=a.toolbox,s=d.length,o=m.x,u=m.y,f=i.itemSize,p=i.itemGap,y,w=i.color instanceof Array?i.color:[i.color];v={};for(var E=0;E<s;E++){y={shape:"icon",zlevel:c,style:{x:o,y:u,width:f,height:f,iconType:d[E],strokeColor:w[E%w.length],shadowColor:"#ccc",shadowBlur:2,shadowOffsetX:2,shadowOffsetY:2,brushType:"stroke"},highlightStyle:{lineWidth:2,shadowBlur:5,strokeColor:w[E%w.length]},hoverable:!0,clickable:!0};switch(d[E]){case"mark":y.onclick=_,b=y.style.strokeColor;break;case"markUndo":y.onclick=F;break;case"markClear":y.onclick=I;break;case"dataZoom":y.onclick=D;break;case"dataZoomReset":y.onclick=q;break;case"dataView":if(!k){var S=e("../component"),x=S.get("dataView");k=new x(t,n,a,r)}y.onclick=X;break;case"restore":y.onclick=V;break;case"saveAsImage":y.onclick=$;break;default:d[E].match("Chart")&&(y._name=d[E].replace("Chart",""),y._name==h&&(y.style.strokeColor=g),y.onclick=J)}l.shapeList.push(y),v[d[E]]=y,i.orient=="horizontal"?o+=f+p:u+=f+p}}function O(){var e=a.toolbox,t=e.padding[0],n=e.padding[1],r=e.padding[2],i=e.padding[3];l.shapeList.push({shape:"rectangle",zlevel:c,hoverable:!1,style:{x:m.x-i,y:m.y-t,width:m.width+i+n,height:m.height+t+r,brushType:e.borderWidth===0?"fill":"both",color:e.backgroundColor,strokeColor:e.borderColor,lineWidth:e.borderWidth}})}function M(){var e=a.toolbox,t=d.length,r=e.itemGap,i=e.itemSize,s=0,o=0;e.orient=="horizontal"?(s=(i+r)*t-r,o=i):(o=(i+r)*t-r,s=i);var u,f=n.getWidth();switch(e.x){case"center":u=Math.floor((f-s)/2);break;case"left":u=e.padding[3]+e.borderWidth;break;case"right":u=f-s-e.padding[1]-e.borderWidth;break;default:u=e.x-0,u=isNaN(u)?0:u}var l,c=n.getHeight();switch(e.y){case"top":l=e.padding[0]+e.borderWidth;break;case"bottom":l=c-o-e.padding[2]-e.borderWidth;break;case"center":l=Math.floor((c-o)/2);break;default:l=e.y-0,l=isNaN(l)?0:l}return{x:u,y:l,width:s,height:o}}function _(e){var t=e.target;return E||w?(R(),n.refresh()):(U(),n.modShape(t.id,{style:{strokeColor:g}}),n.refresh(),w=!0,setTimeout(function(){n&&n.on(o.EVENT.CLICK,j)&&n.on(o.EVENT.MOUSEMOVE,P)},10)),!0}function D(e){var t=e.target;return T||x?(U(),n.refresh(),r.style.cursor="default"):(R(),n.modShape(t.id,{style:{strokeColor:g}}),n.refresh(),x=!0,setTimeout(function(){n&&n.on(o.EVENT.MOUSEDOWN,H)&&n.on(o.EVENT.MOUSEUP,B)&&n.on(o.EVENT.MOUSEMOVE,P)},10),r.style.cursor="crosshair"),!0}function P(e){E&&(S.style.xEnd=u.getX(e.event),S.style.yEnd=u.getY(e.event),n.addHoverShape(S)),T&&(N.style.width=u.getX(e.event)-N.style.x,N.style.height=u.getY(e.event)-N.style.y,n.addHoverShape(N),r.style.cursor="crosshair"),x&&r.style.cursor!="pointer"&&r.style.cursor!="move"&&(r.style.cursor="crosshair")}function H(e){if(e.target)return;T=!0;var t=u.getX(e.event),r=u.getY(e.event),i=a.dataZoom||{};return N={shape:"rectangle",id:n.newShapeId("zoom"),zlevel:c,style:{x:t,y:r,width:1,height:1,brushType:"both"},highlightStyle:{lineWidth:2,color:i.fillerColor||s.dataZoom.fillerColor,strokeColor:i.handleColor||s.dataZoom.handleColor,brushType:"both"}},n.addHoverShape(N),!0}function B(){if(!N||Math.abs(N.style.width)<10||Math.abs(N.style.height)<10)return T=!1,!0;if(T&&f.dataZoom){T=!1;var e=f.dataZoom.rectZoom(N.style);e&&(C.push({start:e.start,end:e.end,start2:e.start2,end2:e.end2}),W(v.dataZoomReset),n.refresh())}return!0}function j(e){if(E)E=!1,l.shapeList.push(S),W(v.markUndo),W(v.markClear),n.addShape(S),n.refresh();else if(w){E=!0;var t=u.getX(e.event),r=u.getY(e.event);S={shape:"line",id:n.newShapeId("mark"),zlevel:c,style:{xStart:t,yStart:r,xEnd:t,yEnd:r,lineWidth:l.deepQuery([a],"toolbox.feature.mark.lineStyle.width")||2,strokeColor:l.deepQuery([a],"toolbox.feature.mark.lineStyle.color")||b,lineType:l.deepQuery([a],"toolbox.feature.mark.lineStyle.type")||"dashed"}},n.addHoverShape(S)}}function F(){if(E)E=!1;else{var e=l.shapeList.length-1;d.length==e-1&&(z(v.markUndo),z(v.markClear));if(d.length<e){var t=l.shapeList[l.shapeList.length-1];n.delShape(t.id),n.refresh(),l.shapeList.pop()}}return!0}function I(){E&&(E=!1);var e=l.shapeList.length-d.length-1,t=!1;while(e--)n.delShape(l.shapeList.pop().id),t=!0;return t&&(z(v.markUndo),z(v.markClear),n.refresh()),!0}function q(){return T&&(T=!1),C.pop(),C.length>0?f.dataZoom.absoluteZoom(C[C.length-1]):(f.dataZoom.rectZoom(),z(v.dataZoomReset),n.refresh()),!0}function R(){E=!1,w&&(w=!1,v.mark&&n.modShape(v.mark.id,{style:{strokeColor:v.mark.highlightStyle.strokeColor}}),n.un(o.EVENT.CLICK,j),n.un(o.EVENT.MOUSEMOVE,P))}function U(){T=!1,x&&(x=!1,v.dataZoom&&n.modShape(v.dataZoom.id,{style:{strokeColor:v.dataZoom.highlightStyle.strokeColor}}),n.un(o.EVENT.MOUSEDOWN,H),n.un(o.EVENT.MOUSEUP,B),n.un(o.EVENT.MOUSEMOVE,P))}function z(e){n.modShape(e.id,{hoverable:!1,clickable:!1,style:{strokeColor:y}})}function W(e){n.modShape(e.id,{hoverable:!0,clickable:!0,style:{strokeColor:e.highlightStyle.strokeColor}})}function X(){return k.show(a),!0}function V(){return R(),U(),t.dispatch(s.EVENT.RESTORE),!0}function $(){function o(){var e=document.getElementById("__echarts_download_wrap__");e.onclick=null,e.innerHTML="",document.body.removeChild(e),e=null}var e=a.toolbox.feature.saveAsImage,t=e.type||"png";t!="png"&&t!="jpeg"&&(t="png");var r=n.toDataURL("image/"+t),i=document.createElement("div");i.id="__echarts_download_wrap__",i.style.cssText="position:fixed;z-index:99999;display:block;top:0;left:0;background-color:rgba(33,33,33,0.5);text-align:center;width:100%;height:100%;line-height:"+document.documentElement.clientHeight+"px;",i.onclick=o;var s=document.createElement("a");s.href=r,s.setAttribute("download",(e.name?e.name:a.title&&(a.title.text||a.title.subtext)?a.title.text||a.title.subtext:"ECharts")+"."+t),s.innerHTML='<img src="'+r+'" title="'+(!window.attachEvent||navigator.userAgent.indexOf("Opera")!==-1?e.lang?e.lang:"点击保存":"右键->图片另存为")+'"/>',i.appendChild(s),document.body.appendChild(i),s=null,i=null;return}function J(e){R();var n=e.target._name;return n==h?h=!1:h=n,t.dispatch(s.EVENT.MAGIC_TYPE_CHANGED,e.event,{magicType:h}),!0}function K(e){if(e.toolbox&&e.toolbox.show&&e.toolbox.feature.magicType&&e.toolbox.feature.magicType.length>0){var t=e.toolbox.feature.magicType,n=t.length;p={};while(n--)p[t[n]]=!0;n=e.series.length;var r,i;while(n--)r=e.series[n].type,p[r]&&(i=e.xAxis instanceof Array?e.xAxis[e.series[n].xAxisIndex||0]:e.xAxis,i&&i.type=="category"&&(i.__boundaryGap=typeof i.boundaryGap!="undefined"?i.boundaryGap:!0),i=e.yAxis instanceof Array?e.yAxis[e.series[n].yAxisIndex||0]:e.yAxis,i&&i.type=="category"&&(i.__boundaryGap=typeof i.boundaryGap!="undefined"?i.boundaryGap:!0),e.series[n].__type=r)}h=!1;var s=e.dataZoom;if(s&&s.show){var o=typeof s.start!="undefined"&&s.start>=0&&s.start<=100?s.start:0,u=typeof s.end!="undefined"&&s.end>=0&&s.end<=100?s.end:100;o>u&&(o+=u,u=o-u,o-=u),C=[{start:o,end:u,start2:0,end2:100}]}else C=[]}function Q(){if(h){for(var e=0,t=a.series.length;e<t;e++)p[a.series[e].type]&&(a.series[e].type=h);var n=h==s.CHART_TYPE_LINE?!1:!0,r;if(a.xAxis instanceof Array){r=a.xAxis.length;while(r--)(a.xAxis[r].type||"category")=="category"&&(a.xAxis[r].boundaryGap=n)}else a.xAxis&&(a.xAxis.type||"category")=="category"&&(a.xAxis.boundaryGap=n);if(a.yAxis instanceof Array){r=a.yAxis.length;while(r--)a.yAxis[r].type=="category"&&(a.yAxis[r].boundaryGap=n)}else a.yAxis&&a.yAxis.type=="category"&&(a.yAxis.boundaryGap=n)}else{var i;for(var e=0,t=a.series.length;e<t;e++)p[a.series[e].type]&&(a.series[e].type=a.series[e].__type,a.xAxis instanceof Array?(i=a.xAxis[a.series[e].xAxisIndex||0],i.type=="category"&&(i.boundaryGap=i.__boundaryGap)):(i=a.xAxis,i&&i.type=="category"&&(i.boundaryGap=i.__boundaryGap)),a.yAxis instanceof Array?(i=a.yAxis[a.series[e].yAxisIndex||0],i.type=="category"&&(i.boundaryGap=i.__boundaryGap)):(i=a.yAxis,i&&i.type=="category"&&(i.boundaryGap=i.__boundaryGap)))}return a}function G(e,t){R(),U(),e.toolbox=l.reformOption(e.toolbox),e.toolbox.padding=l.reformCssArray(e.toolbox.padding),a=e,f=t,l.shapeList=[],e.toolbox.show&&L(),Z()}function Y(){R(),l.clear(),a.toolbox.show&&L(),k&&k.resize()}function Z(){k&&k.hide()}function et(){k&&k.dispose(),l.clear(),l.shapeList=null,l=null}function tt(e){e&&(e.toolbox=l.reformOption(e.toolbox),e.toolbox.padding=l.reformCssArray(e.toolbox.padding),a=e)}var i=e("./base");i.call(this,n);var s=e("../config"),o=e("zrender/config"),u=e("zrender/tool/event"),a,f,l=this;l.type=s.COMPONENT_TYPE_TOOLBOX;var c=l.getZlevelBase(),h,p,d,v={},m,g="red",y="#ccc",b,w,E,S,x,T,N,C,k;l.dispose=et,l.render=G,l.resize=Y,l.hideDataView=Z,l.getMagicOption=Q,l.reset=K,l.refresh=tt}return e("../component").define("toolbox",t),t}),define("echarts/component/dataView",["require","./base","../config","../component"],function(e){function t(t,n,r,i){function b(){v="width:"+y+"px;"+"height:"+0+"px;"+"background-color:#f0ffff;",f.style.cssText=d+v,i.onselectstart=function(){return!1}}function w(e){p=!0;var t=u.deepQuery([r],"toolbox.feature.dataView.lang")||a;r=e,f.innerHTML='<p style="padding:8px 0;margin:0 0 10px 0;border-bottom:1px solid #eee">'+(t[0]||a[0])+"</p>",l.style.cssText="display:block;margin:0 0 8px 0;padding:4px 6px;overflow:auto;width:"+(y-15)+"px;"+"height:"+(g-100)+"px;";var n=u.deepQuery([r],"toolbox.feature.dataView.optionToContent");typeof n!="function"?l.value=E():l.value=n(r),f.appendChild(l),h.style.cssText="float:right;padding:1px 6px;",h.innerHTML=t[1]||a[1],h.onclick=b,f.appendChild(h),u.deepQuery([r],"toolbox.feature.dataView.readOnly")===!1?(c.style.cssText="float:right;margin-right:10px;padding:1px 6px;",c.innerHTML=t[2]||a[2],c.onclick=S,f.appendChild(c),l.readOnly=!1,l.style.cursor="default"):(l.readOnly=!0,l.style.cursor="text"),v="width:"+y+"px;"+"height:"+g+"px;"+"background-color:#fff;",f.style.cssText=d+v,i.onselectstart=function(){return!0}}function E(){var e,t,n,i,s,u,a=[],f="";if(r.xAxis){r.xAxis instanceof Array?a=r.xAxis:a=[r.xAxis];for(e=0,i=a.length;e<i;e++)if((a[e].type||"category")=="category"){u=[];for(t=0,n=a[e].data.length;t<n;t++)s=a[e].data[t],u.push(typeof s.value!="undefined"?s.value:s);f+=u.join(", ")+"\n\n"}}if(r.yAxis){r.yAxis instanceof Array?a=r.yAxis:a=[r.yAxis];for(e=0,i=a.length;e<i;e++)if(a[e].type=="category"){u=[];for(t=0,n=a[e].data.length;t<n;t++)s=a[e].data[t],u.push(typeof s.value!="undefined"?s.value:s);f+=u.join(", ")+"\n\n"}}var l=r.series,c;for(e=0,i=l.length;e<i;e++){u=[];for(t=0,n=l[e].data.length;t<n;t++)s=l[e].data[t],l[e].type==o.CHART_TYPE_PIE||l[e].type==o.CHART_TYPE_MAP?c=(s.name||"-")+":":c="",l[e].type==o.CHART_TYPE_SCATTER&&(s=typeof s.value!="undefined"?s.value:s,s=s.join(", ")),u.push(c+(typeof s.value!="undefined"?s.value:s));f+=(l[e].name||"-")+" : \n",f+=u.join(l[e].type==o.CHART_TYPE_SCATTER?"\n":", "),f+="\n\n"}return f}function S(){var e=l.value,n=u.deepQuery([r],"toolbox.feature.dataView.contentToOption");if(typeof n!="function"){e=e.split("\n");var i=[];for(var s=0,a=e.length;s<a;s++)e[s]=T(e[s]),e[s]!==""&&i.push(e[s]);x(i)}else n(e,r);b(),setTimeout(function(){t&&t.dispatch(o.EVENT.DATA_VIEW_CHANGED,null,{option:r})},G_vmlCanvasManager?100:800)}function x(e){var t,n,i,s,u,a=[],f=0,l,c;if(r.xAxis){r.xAxis instanceof Array?a=r.xAxis:a=[r.xAxis];for(t=0,s=a.length;t<s;t++)if((a[t].type||"category")=="category"){l=e[f].split(",");for(n=0,i=a[t].data.length;n<i;n++)c=T(l[n]||""),u=a[t].data[n],typeof a[t].data[n].value!="undefined"?a[t].data[n].value=c:a[t].data[n]=c;f++}}if(r.yAxis){r.yAxis instanceof Array?a=r.yAxis:a=[r.yAxis];for(t=0,s=a.length;t<s;t++)if(a[t].type=="category"){l=e[f].split(",");for(n=0,i=a[t].data.length;n<i;n++)c=T(l[n]||""),u=a[t].data[n],typeof a[t].data[n].value!="undefined"?a[t].data[n].value=c:a[t].data[n]=c;f++}}var h=r.series;for(t=0,s=h.length;t<s;t++){f++;if(h[t].type==o.CHART_TYPE_SCATTER)for(var n=0,i=h[t].data.length;n<i;n++)l=e[f],c=l.replace(" ","").split(","),typeof h[t].data[n].value!="undefined"?h[t].data[n].value=c:h[t].data[n]=c,f++;else{l=e[f].split(",");for(var n=0,i=h[t].data.length;n<i;n++)c=(l[n]||"").replace(/.*:/,""),c=T(c),c=c!="-"&&c!==""?c-0:"-",typeof h[t].data[n].value!="undefined"?h[t].data[n].value=c:h[t].data[n]=c;f++}}}function T(e){var t=new RegExp("(^[\\s\\t\\xa0\\u3000]+)|([\\u3000\\xa0\\s\\t]+$)","g");return e.replace(t,"")}function N(e){e=e||window.event,e.stopPropagation?e.stopPropagation():e.cancelBubble=!0}function C(){f.className=m,b(),i.firstChild.appendChild(f),window.addEventListener?(f.addEventListener("click",N),f.addEventListener("mousewheel",N),f.addEventListener("mousemove",N),f.addEventListener("mousedown",N),f.addEventListener("mouseup",N),f.addEventListener("touchstart",N),f.addEventListener("touchmove",N),f.addEventListener("touchend",N)):(f.attachEvent("onclick",N),f.attachEvent("onmousewheel",N),f.attachEvent("onmousemove",N),f.attachEvent("onmousedown",N),f.attachEvent("onmouseup",N))}function k(){g=n.getHeight(),y=n.getWidth(),f.offsetHeight>10&&(v="width:"+y+"px;"+"height:"+g+"px;"+"background-color:#fff;",f.style.cssText=d+v,l.style.cssText="display:block;margin:0 0 8px 0;padding:4px 6px;overflow:auto;width:"+(y-15)+"px;"+"height:"+(g-100)+"px;")}function L(){window.removeEventListener?(f.removeEventListener("click",N),f.removeEventListener("mousewheel",N),f.removeEventListener("mousemove",N),f.removeEventListener("mousedown",N),f.removeEventListener("mouseup",N),f.removeEventListener("touchstart",N),f.removeEventListener("touchmove",N),f.removeEventListener("touchend",N)):(f.detachEvent("onclick",N),f.detachEvent("onmousewheel",N),f.detachEvent("onmousemove",N),f.detachEvent("onmousedown",N),f.detachEvent("onmouseup",N)),c.onclick=null,h.onclick=null,p&&(f.removeChild(l),f.removeChild(c),f.removeChild(h)),l=null,c=null,h=null,i.firstChild.removeChild(f),f=null,u=null}var s=e("./base");s.call(this,n);var o=e("../config"),u=this;u.type=o.COMPONENT_TYPE_DATAVIEW;var a=["Data View","close","refresh"],f=document.createElement("div"),l=document.createElement("textArea"),c=document.createElement("button"),h=document.createElement("button"),p=!1,d="position:absolute;display:block;overflow:hidden;transition:height 0.8s,background-color 1s;-moz-transition:height 0.8s,background-color 1s;-webkit-transition:height 0.8s,background-color 1s;-o-transition:height 0.8s,background-color 1s;z-index:1;left:0;top:0;",v,m="echarts-dataview",g=n.getHeight(),y=n.getWidth();u.dispose=L,u.resize=k,u.show=w,u.hide=b,C()}return e("../component").define("dataView",t),t}),define("echarts/util/coordinates",["require","zrender/tool/math"],function(e){function n(e,n){return[e*t.sin(n),e*t.cos(n)]}function r(e,t){return[Math.sqrt(e*e+t*t),Math.atan(t/e)]}var t=e("zrender/tool/math");return{polar2cartesian:n,cartesian2polar:r}}),define("echarts/component/polar",["require","./base","../config","../util/coordinates","zrender/tool/util","../component"],function(e){function t(t,n,r,i){function v(e,t){i=t,I(e)}function m(){for(var e=0;e<l.length;e++)f.reformOption(l[e]),d=[l[e],r],g(e),y(e),w(e),O(e),b(e);for(var e=0;e<f.shapeList.length;e++)f.shapeList[e].id=n.newShapeId(f.type),n.addShape(f.shapeList[e])}function g(e){var t=l[e],n=f.deepQuery(d,"indicator"),r=n.length,i=t.startAngle,s=2*Math.PI/r,o=t.radius,a=t.__ecIndicator=[],p;typeof o!="number"&&(o=Math.floor(Math.min(c,h)/2-50));for(var v=0;v<r;v++)p=u.polar2cartesian(o,i*Math.PI/180+s*v),a.push({vector:[p[1],-p[0]]})}function y(e){var t=l[e],n=t.__ecIndicator,r=t.splitArea,i=t.splitLine,s=t.center,o=t.splitNumber,u=i.lineStyle.color,a=i.lineStyle.width,c=i.show,h=f.deepQuery(d,"axisLine");S(n,o,s,r,u,a,c),L(n,s,h)}function b(e){var t=l[e],n=f.deepQuery(d,"indicator"),i=t.__ecIndicator,s,o,u,c,h=f.deepQuery(d,"splitNumber"),p=t.center,o,v,m,g,y,b=f.deepQuery(d,"precision");for(var w=0;w<n.length;w++){s=f.deepQuery([n[w],t,r],"axisLabel");if(s.show){u={},u.styleFont=f.getFont(),u=a.merge(u,s),u.lineWidth=u.width,o=i[w].vector,v=i[w].value,g=w/n.length*2*Math.PI,y=s.offset||10;for(var E=1;E<=h;E++)c=a.merge({},u),m=E*(v.max-v.min)/h+v.min,b&&(m=m.toFixed(b)),c.text=m,c.x=E*o[0]/h+Math.cos(g)*y+p[0],c.y=E*o[1]/h+Math.sin(g)*y+p[1],f.shapeList.push({shape:"text",style:c,draggable:!1,hoverable:!1})}}}function w(e){var t=l[e],n=t.__ecIndicator,i,s=f.deepQuery(d,"indicator"),o=t.center,u,a,c,h,p=0,v=0,m,g;for(var y=0;y<s.length;y++){c=f.deepQuery([s[y],t,r],"name");if(!c.show)continue;g=f.deepQuery([c,t,r],"textStyle"),u={},u.styleFont=f.getFont(g),typeof c.formatter=="function"?u.text=c.formatter(s[y].text,y):typeof c.formatter=="string"?u.text=c.formatter.replace("{value}",s[y].text):u.text=s[y].text,i=n[y].vector,Math.round(i[0])>0?a="left":Math.round(i[0])<0?a="right":a="center",c.margin?(m=c.margin,p=i[0]>0?m:-m,v=i[1]>0?m:-m,p=i[0]===0?0:p,v=i[1]===0?0:v,i=C(i,o,1)):i=C(i,o,1.2),u.textAlign=a,u.x=i[0]+p,u.y=i[1]+v,c.rotate&&(h=[c.rotate/180*Math.PI,i[0],i[1]]),f.shapeList.push({shape:"text",style:u,draggable:!1,hoverable:!1,rotation:h})}}function E(e){var e=e||0,t=l[e],n=t.center,r=t.__ecIndicator,i=r.length,s=[],o,u;for(var a=0;a<i;a++)o=r[a].vector,s.push(C(o,n,1.2));return u=T(s,"fill","rgba(0,0,0,0)","",1),u}function S(e,t,n,r,i,s,o){var u,a,l,c;for(var h=0;h<t;h++)a=(t-h)/t,c=x(e,a,n),o&&(u=T(c,"stroke","",i,s),f.shapeList.push(u)),r.show&&(l=(t-h-1)/t,N(e,r,a,l,n,h))}function x(e,t,n){var r=[],i=e.length,s;for(var o=0;o<i;o++)s=e[o].vector,r.push(C(s,n,t));return r}function T(e,t,n,r,i,s,o){return{shape:"polygon",style:{pointList:e,brushType:t,color:n,strokeColor:r,lineWidth:i},hoverable:s||!1,draggable:o||!1}}function N(e,t,n,r,i,s){var o=e.length,u,a=t.areaStyle.color,l,c,h,p=[],o=e.length,d;typeof a=="string"&&(a=[a]),l=a.length,u=a[s%l];for(var v=0;v<o;v++)p=[],c=e[v].vector,h=e[(v+1)%o].vector,p.push(C(c,i,n)),p.push(C(c,i,r)),p.push(C(h,i,r)),p.push(C(h,i,n)),d=T(p,"fill",u,"",1),f.shapeList.push(d)}function C(e,t,n){return[e[0]*n+t[0],e[1]*n+t[1]]}function k(e){var e=e||0;return l[e].center}function L(e,t,n){var r=e.length,i,s,o=n.lineStyle,u=o.color,a=o.width,l=o.type;for(var c=0;c<r;c++)s=e[c].vector,i=A(t[0],t[1],s[0]+t[0],s[1]+t[1],u,a,l),f.shapeList.push(i)}function A(e,t,n,r,i,s,o){return{shape:"line",style:{xStart:e,yStart:t,xEnd:n,yEnd:r,strokeColor:i,lineWidth:s,lineType:o},hoverable:!1}}function O(e){var t=l[e],n=f.deepQuery(d,"indicator"),r=n.length,i=t.__ecIndicator,s,o,u,a=M(e),c=t.splitNumber,h=f.deepQuery(d,"boundaryGap"),p=f.deepQuery(d,"precision"),v=f.deepQuery(d,"power"),m=f.deepQuery(d,"scale");for(var g=0;g<r;g++)typeof n[g].max=="number"?(o=n[g].max,u=n[g].min||0,s={max:o,min:u}):s=_(a,g,c,h,p,v,m),i[g].value=s}function M(e){var t=[],n,s,o=i.legend;for(var u=0;u<p.length;u++){n=p[u],s=n.data||[];for(var a=0;a<s.length;a++)polarIndex=f.deepQuery([s[a],n,r],"polarIndex")||0,polarIndex==e&&(!o||o.isSelected(s[a].name))&&t.push(s[a])}return t}function _(e,t,n,r,i,s,o){function m(e){(e>u||u===undefined)&&(u=e),(e<a||a===undefined)&&(a=e)}var u,a,f,l,c,h=0,p,d,v;if(!e||e.length===0)return;e.length==1&&(a=0);if(e.length!=1)for(var g=0;g<e.length;g++)f=e[g].value[t],m(f);else{v=e[0];for(var g=0;g<v.value.length;g++)m(v.value[g])}if(e.length!=1)if(o){l=D(u,a,n,i,s);if(l>=1)a=Math.floor(a/l)*l-l;else{if(l===0)return u>0?(d=0,p=2*u):u===0?(d=0,p=100):(p=0,d=2*a),{max:p,min:d};c=(l+"").split(".")[1],h=c.length,a=Math.floor(a*Math.pow(10,h))/Math.pow(10,h)-l}Math.abs(a)<=l&&(a=0),u=a+Math.floor(l*Math.pow(10,h)*(n+1))/Math.pow(10,h)}else a=a>0?0:a;return r&&(u=u>0?u*1.2:u*.8,a=a>0?a*.8:a*1.2),{max:u,min:a}}function D(e,t,n,r,i){var s=(e-t)/n,o,u;if(s>1)return i?(s=Math.ceil(s),s%i>0?(Math.ceil(s/i)+1)*i:s):(o=(s+"").split(".")[0],u=o.length,o[0]>=5?Math.pow(10,u):(o[0]-0+1)*Math.pow(10,u-1));if(s==1)return 1;if(s===0)return 0;if(!r){o=(s+"").split(".")[1],u=0;while(o[u]=="0")u++;return o[u]>=5?"0."+o.substring(0,u+1)-0+1/Math.pow(10,u):"0."+o.substring(0,u+1)-0+1/Math.pow(10,u+1)}return Math.ceil(s*Math.pow(10,r))/Math.pow(10,r)}function P(e){var t=a.merge;return e=t(e||{},o.polar,{overwrite:!1,recursive:!0}),e.center=f.parseCenter(e.center),e.radius||(e.radius=Math.floor(Math.min(c,h)/2-50)),e}function H(e,t,n){e=e||0,t=t||0;var r=l[e].__ecIndicator;if(t>=r.length)return;var i=l[e].__ecIndicator[t],s=l[e].center,o=i.vector,u=i.value.max,a=i.value.min,f;return typeof n!="number"?s:(u!=a?f=(n-a)/(u-a):f=.5,C(o,s,f))}function B(e){var t=j(e);return t?t.polarIndex:-1}function j(e){var t,n,i,s,o,a,c,h,p;for(var d=0;d<l.length;d++){t=l[d],n=k(d);if(e[0]==n[0]&&e[1]==n[1])return{polarIndex:d,valueIndex:0};i=f.deepQuery([t,r],"radius"),o=t.startAngle,a=t.indicator,c=a.length,h=2*Math.PI/c,s=u.cartesian2polar(e[0]-n[0],n[1]-e[1]),e[0]-n[0]<0&&(s[1]+=Math.PI),s[1]<0&&(s[1]+=2*Math.PI),p=s[1]-o/180*Math.PI+Math.PI*2;if(Math.abs(Math.cos(p%(h/2)))*i>s[0])return{polarIndex:d,valueIndex:Math.floor((p+h/2)/h)%c}}}function F(e){var e=e||0;return l[e].indicator}function I(e){e&&(r=e,l=r.polar,p=r.series,f.backupAdaptiveParams(l,["center","radius"],!0)),f.clear(),m()}function q(){f.restoreAdaptiveParams(l,["center","radius"],!0),I()}var s=e("./base");s.call(this,n);var o=e("../config"),u=e("../util/coordinates"),a=e("zrender/tool/util"),f=this;f.type=o.COMPONENT_TYPE_POLAR;var l,c=n.getWidth(),h=n.getHeight(),p,d;f.refresh=I,f.resize=q,f.reformOption=P,f.getVector=H,f.getDropBox=E,f.getCenter=k,f.getIndicator=F,f.isInside=B,f.getNearestIndex=j,v(r,i)}return e("../component").define("polar",t),t}),define("echarts/echarts",["require","./config","zrender","zrender/tool/util","zrender/tool/event","zrender/config","./util/shape/icon","./chart","./chart/island","./component","./component/title","./component/axis","./component/categoryAxis","./component/valueAxis","./component/grid","./component/dataZoom","./component/legend","./component/dataRange","./component/tooltip","./component/toolbox","./component/dataView","./component/polar","./util/ecData","./chart","./component","zrender/tool/util","zrender/tool/util","zrender/tool/util","zrender/tool/color","zrender/tool/util","zrender/tool/util"],function(e){function r(t,r){function g(){var s=e("zrender");(s.version||"1.0.3").replace(".","")-0<n.dependencies.zrender.replace(".","")-0&&console.error("ZRender "+(s.version||"1.0.3-")+" is too old for ECharts "+n.version+". Current version need ZRender "+n.dependencies.zrender+"+"),o=s.init(t);var a=e("zrender/tool/util");u=a.clone(r||{}),l=[],c={};var f=e("zrender/tool/event");f.Dispatcher.call(c),c.bind(i.EVENT.LEGEND_SELECTED,k),c.bind(i.EVENT.DATA_ZOOM,L),c.bind(i.EVENT.DATA_RANGE,A),c.bind(i.EVENT.MAGIC_TYPE_CHANGED,O),c.bind(i.EVENT.DATA_VIEW_CHANGED,M),c.bind(i.EVENT.TOOLTIP_HOVER,_),c.bind(i.EVENT.RESTORE,D),c.bind(i.EVENT.REFRESH,P);var h=e("zrender/config");o.on(h.EVENT.CLICK,y),o.on(h.EVENT.MOUSEOVER,b),o.on(h.EVENT.MOUSEWHEEL,w),o.on(h.EVENT.DRAGSTART,E),o.on(h.EVENT.DRAGEND,C),o.on(h.EVENT.DRAGENTER,S),o.on(h.EVENT.DRAGOVER,x),o.on(h.EVENT.DRAGLEAVE,T),o.on(h.EVENT.DROP,N),e("./util/shape/icon");var p=e("./chart");e("./chart/island");var m=p.get("island");d=new m(c,o);var g=e("./component");e("./component/title"),e("./component/axis"),e("./component/categoryAxis"),e("./component/valueAxis"),e("./component/grid"),e("./component/dataZoom"),e("./component/legend"),e("./component/dataRange"),e("./component/tooltip"),e("./component/toolbox"),e("./component/dataView"),e("./component/polar");var H=g.get("toolbox");v=new H(c,o,t)}function y(e){var t=l.length;while(t--)l[t]&&l[t].onclick&&l[t].onclick(e);if(e.target){var n=j(e.target);n&&typeof n.seriesIndex!="undefined"&&c.dispatch(i.EVENT.CLICK,e.event,n)}}function b(e){if(e.target){var t=j(e.target);t&&typeof t.seriesIndex!="undefined"&&c.dispatch(i.EVENT.HOVER,e.event,t)}}function w(e){c.dispatch(i.EVENT.MOUSEWHEEL,e.event,j(e.target))}function E(e){h={dragIn:!1,dragOut:!1,needRefresh:!1};var t=l.length;while(t--)l[t]&&l[t].ondragstart&&l[t].ondragstart(e)}function S(e){var t=l.length;while(t--)l[t]&&l[t].ondragenter&&l[t].ondragenter(e)}function x(e){var t=l.length;while(t--)l[t]&&l[t].ondragover&&l[t].ondragover(e)}function T(e){var t=l.length;while(t--)l[t]&&l[t].ondragleave&&l[t].ondragleave(e)}function N(e){var t=l.length;while(t--)l[t]&&l[t].ondrop&&l[t].ondrop(e,h);d.ondrop(e,h)}function C(e){var t=l.length;while(t--)l[t]&&l[t].ondragend&&l[t].ondragend(e,h);d.ondragend(e,h),h.needRefresh&&(B(d.getOption()),c.dispatch(i.EVENT.DATA_CHANGED,e.event,j(e.target)),c.dispatch(i.EVENT.REFRESH))}function k(e){h.needRefresh=!1;var t=l.length;while(t--)l[t]&&l[t].onlegendSelected&&l[t].onlegendSelected(e,h);p=e.selected,h.needRefresh&&c.dispatch(i.EVENT.REFRESH)}function L(e){h.needRefresh=!1;var t=l.length;while(t--)l[t]&&l[t].ondataZoom&&l[t].ondataZoom(e,h);h.needRefresh&&c.dispatch(i.EVENT.REFRESH)}function A(e){h.needRefresh=!1;var t=l.length;while(t--)l[t]&&l[t].ondataRange&&l[t].ondataRange(e,h);h.needRefresh&&o.refresh()}function O(){F(H())}function M(e){B(e.option),c.dispatch(i.EVENT.DATA_CHANGED,null,e),c.dispatch(i.EVENT.REFRESH)}function _(e){var t=l.length,n=[];while(t--)l[t]&&l[t].ontooltipHover&&l[t].ontooltipHover(e,n)}function D(){s.restore()}function P(e){m=!0,s.refresh(e),m=!1}function H(e){var t=e||v.getMagicOption(),n;if(a.xAxis)if(a.xAxis instanceof Array){n=a.xAxis.length;while(n--)t.xAxis[n].data=a.xAxis[n].data}else t.xAxis.data=a.xAxis.data;if(a.yAxis)if(a.yAxis instanceof Array){n=a.yAxis.length;while(n--)t.yAxis[n].data=a.yAxis[n].data}else t.yAxis.data=a.yAxis.data;n=t.series.length;while(n--)t.series[n].data=a.series[n].data;return t}function B(e){if(e.dataZoom&&e.dataZoom.show||e.toolbox&&e.toolbox.show&&e.toolbox.feature&&e.toolbox.feature.dataZoom)for(var t=0,n=l.length;t<n;t++)if(l[t].type==i.COMPONENT_TYPE_DATAZOOM){l[t].syncBackupData(e,a);return}var r=e.series,s;for(var t=0,n=r.length;t<n;t++){s=r[t].data;for(var o=0,u=s.length;o<u;o++)a.series[t].data[o]=s[o]}}function j(t){if(t){var n=e("./util/ecData");return{seriesIndex:n.get(t,"seriesIndex"),dataIndex:n.get(t,"dataIndex")}}return}function F(n){R(),o.clear();var r=e("./chart"),i=e("./component"),s;if(n.title){var u=new i.get("title");s=new u(c,o,n),l.push(s)}var a;if(n.tooltip){var f=i.get("tooltip");a=new f(c,o,n,t),l.push(a)}var h;if(n.legend){var m=new i.get("legend");h=new m(c,o,n,p),l.push(h)}var g;if(n.dataRange){var y=new i.get("dataRange");g=new y(c,o,n),l.push(g)}var b,w,E,S;if(n.grid||n.xAxis||n.yAxis){var x=i.get("grid");b=new x(c,o,n),l.push(b);var T=i.get("dataZoom");w=new T(c,o,n,{legend:h,grid:b}),l.push(w);var N=i.get("axis");E=new N(c,o,n,{legend:h,grid:b},"xAxis"),l.push(E),S=new N(c,o,n,{legend:h,grid:b},"yAxis"),l.push(S)}var C;if(n.polar){var k=i.get("polar");C=new k(c,o,n,{legend:h}),l.push(C)}a&&a.setComponent({grid:b,xAxis:E,yAxis:S,polar:C});var L,A,O,M={};for(var _=0,D=n.series.length;_<D;_++){A=n.series[_].type;if(!A)continue;M[A]||(M[A]=!0,L=r.get(A),L&&(O=new L(c,o,n,{tooltip:a,legend:h,dataRange:g,grid:b,xAxis:E,yAxis:S,polar:C}),l.push(O)))}d.render(n),v.render(n,{dataZoom:w});if(n.animation){var P=l.length;while(P--)l[P]&&l[P].animation&&l[P].animation()}o.render()}function I(){var t=e("zrender/tool/util");f.legend&&f.legend.selected?p=f.legend.selected:p={},a=t.clone(f),u=t.clone(f),d.clear(),v.reset(u),F(u)}function q(t){t=t||{};var n=t.option;if(!m&&t.option){var r=e("zrender/tool/util");a.toolbox&&a.toolbox.show&&a.toolbox.feature.magicType&&a.toolbox.feature.magicType.length>0?n=H():n=H(d.getOption()),r.merge(n,t.option,{overwrite:!0,recursive:!0}),r.merge(a,t.option,{overwrite:!0,recursive:!0}),r.merge(f,t.option,{overwrite:!0,recursive:!0}),d.refresh(n),v.refresh(n)}for(var i=0,s=l.length;i<s;i++)l[i].refresh&&l[i].refresh(n);o.refresh()}function R(){var e=l.length;while(e--)l[e]&&l[e].dispose&&l[e].dispose();l=[]}function U(t,n){var r=e("zrender/tool/util");n?u=r.clone(t):r.merge(u,r.clone(t),{overwrite:!0,recursive:!0});if(!t.series||t.series.length===0)return;typeof u.calculable=="undefined"&&(u.calculable=i.calculable),typeof u.nameConnector=="undefined"&&(u.nameConnector=i.nameConnector),typeof u.valueConnector=="undefined"&&(u.valueConnector=i.valueConnector),typeof u.animation=="undefined"&&(u.animation=i.animation),typeof u.animationDuration=="undefined"&&(u.animationDuration=i.animationDuration),typeof u.animationEasing=="undefined"&&(u.animationEasing=i.animationEasing),typeof u.addDataAnimation=="undefined"&&(u.addDataAnimation=i.addDataAnimation);var l=e("zrender/tool/color");return u.color&&u.color.length>0?o.getColor=function(e){return l.getColor(e,u.color)}:o.getColor=function(e){return l.getColor(e,i.color)},o.getCalculableColor=function(){return u.calculableColor||i.calculableColor},a=r.clone(u),f=r.clone(u),u.legend&&u.legend.selected?p=u.legend.selected:p={},d.clear(),v.reset(u),F(u),s}function z(e,t){return t?(u.series=e,s.setOption(u,t)):s.setOption({series:e}),s}function W(t,n,r,o,u){var h=e("zrender/tool/util"),m=t instanceof Array?t:[[t,n,r,o,u]],g,y,b;a.toolbox&&a.toolbox.show&&a.toolbox.feature.magicType&&a.toolbox.feature.magicType.length>0?b=H():b=H(d.getOption());for(var w=0,E=m.length;w<E;w++){t=m[w][0],n=m[w][1],r=m[w][2],o=m[w][3],u=m[w][4];if(f.series[t]){r?(f.series[t].data.unshift(n),a.series[t].data.unshift(n),o||(f.series[t].data.pop(),n=a.series[t].data.pop())):(f.series[t].data.push(n),a.series[t].data.push(n),o||(f.series[t].data.shift(),n=a.series[t].data.shift()));if(typeof u!="undefined"&&f.series[t].type==i.CHART_TYPE_PIE&&a.legend&&a.legend.data)b.legend.data=a.legend.data,r?(f.legend.data.unshift(u),a.legend.data.unshift(u)):(f.legend.data.push(u),a.legend.data.push(u)),o||(y=h.indexOf(a.legend.data,n.name),y!=-1&&(f.legend.data.splice(y,1),a.legend.data.splice(y,1))),p[u]=!0;else if(typeof u!="undefined"&&typeof f.xAxis!="undefined"&&typeof f.yAxis!="undefined"){g=f.series[t].xAxisIndex||0;if(typeof f.xAxis[g].type=="undefined"||f.xAxis[g].type=="category")r?(f.xAxis[g].data.unshift(u),a.xAxis[g].data.unshift(u),o||(f.xAxis[g].data.pop(),a.xAxis[g].data.pop())):(f.xAxis[g].data.push(u),a.xAxis[g].data.push(u),o||(f.xAxis[g].data.shift(),a.xAxis[g].data.shift()));g=f.series[t].yAxisIndex||0,f.yAxis[g].type=="category"&&(r?(f.yAxis[g].data.unshift(u),a.yAxis[g].data.unshift(u),o||(f.yAxis[g].data.pop(),a.yAxis[g].data.pop())):(f.yAxis[g].data.push(u),a.yAxis[g].data.push(u),o||(f.yAxis[g].data.shift(),a.yAxis[g].data.shift())))}}}b.legend&&(b.legend.selected=p);for(var w=0,E=l.length;w<E;w++)b.addDataAnimation&&l[w].addDataAnimation&&l[w].addDataAnimation(m),l[w].type==i.COMPONENT_TYPE_DATAZOOM&&(l[w].silence(!0),l[w].init(b),l[w].silence(!1));return d.refresh(b),v.refresh(b),setTimeout(function(){c.dispatch(i.EVENT.REFRESH,"",{option:b})},b.addDataAnimation?500:0),s}function X(){return o}function V(e,t){return c.bind(e,t),s}function $(e,t){return c.unbind(e,t),s}function J(t){v.hideDataView();var n=e("zrender/tool/util");t=t||{},t.textStyle=t.textStyle||{};var r=n.merge(n.clone(t.textStyle),i.textStyle,{overwrite:!1});return t.textStyle.textFont=r.fontStyle+" "+r.fontWeight+" "+r.fontSize+"px "+r.fontFamily,t.textStyle.text=t.text||"Loading...",typeof t.x!="undefined"&&(t.textStyle.x=t.x),typeof t.y!="undefined"&&(t.textStyle.y=t.y),o.showLoading(t),s}function K(){return o.hideLoading(),s}function Q(){o.resize();for(var e=0,t=l.length;e<t;e++)l[e].resize&&l[e].resize();return d.resize(),v.resize(),o.refresh(),s}function G(){return o.clear(),s}function Y(){d.dispose(),v.dispose(),R(),c.unbind(),o.dispose(),s=null;return}var i=e("./config"),s=this,o,u,a,f,l,c,h={dragIn:!1,dragOut:!1,needRefresh:!1},p,d,v,m;g(),s.setOption=U,s.setSeries=z,s.addData=W,s.getZrender=X,s.on=V,s.un=$,s.showLoading=J,s.hideLoading=K,s.resize=Q,s.refresh=q,s.restore=I,s.clear=G,s.dispose=Y}var t={},n=t;return t.version="1.3.0",t.dependencies={zrender:"1.0.5"},t.init=function(e,t){t=t||{type:"canvas"};if(t.type=="canvas")return new r(e);t.type=="flash"&&alert("未配置")},t}),define("echarts",["echarts/echarts"],function(e){return e}),define("echarts/util/shape/symbol",["require","zrender/tool/color","zrender/shape","zrender/shape/base","zrender/shape"],function(e){function t(){this.type="symbol"}return t.prototype={_buildSinglePoint:function(e,t){switch(t[3]){case"circle":case"emptyCircle":e.arc(t[0],t[1],t[2],0,Math.PI*2,!0);break;case"rectangle":case"emptyRectangle":e.rect(t[0]-t[2],t[1]-t[2],t[2]*2,t[2]*2);break;case"triangle":case"emptyTriangle":itemShape={shape:"polygon",style:{pointList:[[x,y-symbolSize],[x+symbolSize,y+symbolSize],[x-symbolSize,y+symbolSize]],brushType:symbolType=="triangle"?"fill":"stroke"}};break;case"diamond":case"emptyDiamond":itemShape={shape:"polygon",style:{pointList:[[x,y-symbolSize],[x+symbolSize,y],[x,y+symbolSize],[x-symbolSize,y]],brushType:symbolType=="diamond"?"fill":"stroke"}};break;default:itemShape={shape:"circle",style:{x:x,y:y,r:symbolSize,brushType:"fill"}}}},buildPath:function(t,n){var r=n.pointList,i=this.getRect(n),s=window.devicePixelRatio||1,o=t.getImageData(i.x*s,i.y*s,i.width*s,i.height*s),u=o.data,a,f=e("zrender/tool/color"),l=f.toArray(n.color),c=l[0],h=l[1],p=l[2],d=i.width;for(var v=1,m=r.length;v<m;v++)a=((r[v][0]-i.x)*s+(r[v][1]-i.y)*d*s*s)*4,u[a]=c,u[a+1]=h,u[a+2]=p,u[a+3]=255;t.putImageData(o,i.x*s,i.y*s);return},getRect:function(t){var n=e("zrender/shape");return n.get("polygon").getRect(t)},isCover:function(){return!1}},e("zrender/shape/base").derive(t),e("zrender/shape").define("symbol",new t),t}),define("echarts/chart/scatter",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","../util/shape/symbol","../chart"],function(e){function t(t,n,r,i){function m(){l.selectedMap={};var e=i.legend,t=[],r,s,o,a;for(var h=0,m=c.length;h<m;h++){r=c[h],s=r.name;if(r.type==u.CHART_TYPE_SCATTER){c[h]=l.reformOption(c[h]),v[h]=l.deepQuery([r],"symbol")||d[h%d.length];if(e){l.selectedMap[s]=e.isSelected(s),p[h]=f.alpha(e.getColor(s),.5),o=e.getItemShape(s);if(o){o.shape="icon";var a=v[h];o.style.brushType=a.match("empty")?"stroke":"both",a=a.replace("empty","").toLowerCase(),a.match("star")&&(o.style.n=a.replace("star","")-0||5,a="star"),o.style.iconType=a,e.setItemShape(s,o)}}else l.selectedMap[s]=!0,p[h]=n.getColor(h);l.selectedMap[s]&&t.push(h)}}if(t.length===0)return;g(t);for(var h=0,m=l.shapeList.length;h<m;h++)l.shapeList[h].id=n.newShapeId(l.type),n.addShape(l.shapeList[h])}function g(e){var t,n,r,s,o,u,a={},f,h,p;for(var d=0,m=e.length;d<m;d++){t=e[d],n=c[t];if(n.data.length===0)continue;o=i.xAxis.getAxis(n.xAxisIndex||0),u=i.yAxis.getAxis(n.yAxisIndex||0),p=l.deepQuery([n],"symbolSize"),a[t]=[];for(var g=0,b=n.data.length;g<b;g++){r=n.data[g],s=typeof r!="undefined"?typeof r.value!="undefined"?r.value:r:"-";if(s=="-"||s.length<2)continue;f=o.getCoord(s[0]),h=u.getCoord(s[1]),a[t].push([f,h,typeof p=="function"?p(s):p,v[t],g,r.name||""])}}y(a)}function y(e){var t=i.dataRange,n,r,s,o,u,a,f,h,d,v,m;for(var g in e){a=c[g],d=e[g],f=[a],r=l.deepQuery(f,"itemStyle.normal.color")||p[g],s=l.deepQuery(f,"itemStyle.normal.lineStyle.width"),o=l.deepQuery(f,"itemStyle.emphasis.color"),u=l.deepQuery(f,"itemStyle.emphasis.lineStyle.width"),m=l.deepQuery(f,"symbolRotate");if(a.large&&a.data.length>a.largeThreshold){l.shapeList.push(w(d,r,o));continue}for(var y=0,E=d.length;y<E;y++){v=d[y],h=a.data[v[4]];if(t){if(isNaN(h[2]))continue;n=t.getColor(h[2]);if(!n)continue}else n=r;f=[h],l.shapeList.push(b(g,v[4],v[5],v[0],v[1],l.deepQuery(f,"symbolSize")||v[2],l.deepQuery(f,"symbolRotate")||m,l.deepQuery(f,"symbol")||v[3],l.deepQuery(f,"itemStyle.normal.color")||n,l.deepQuery(f,"itemStyle.normal.lineStyle.width")||s,l.deepQuery(f,"itemStyle.emphasis.color")||o||r,l.deepQuery(f,"itemStyle.emphasis.lineStyle.width")||u||s))}}}function b(e,t,n,r,i,s,o,u,f,p,d,v){var m={shape:"icon",zlevel:h,style:{iconType:u.replace("empty","").toLowerCase(),x:r-s,y:i-s,width:s*2,height:s*2,brushType:u.match("empty")?"stroke":"fill",color:f,strokeColor:f,lineWidth:p},highlightStyle:{color:d,strokeColor:d,lineWidth:v},clickable:!0};return typeof o!="undefined"&&(m.rotation=[o*Math.PI/180,r,i]),u.match("star")&&(m.style.iconType="star",m.style.n=u.replace("empty","").replace("star","")-0||5),u=="none"&&(m.invisible=!0,m.hoverable=!1),m=l.addLabel(m,c[e],c[e].data[t],n,"vertical"),a.pack(m,c[e],e,c[e].data[t],t,n),m._x=r,m._y=i,m}function w(e,t,n){return{shape:"symbol",zlevel:h,hoverable:!1,style:{pointList:e,color:t,strokeColor:t},highlightStyle:{color:n,strokeColor:n}}}function E(e,t){i=t,S(e)}function S(e){e&&(r=e,c=r.series),l.clear(),m()}function x(e,t){i.dataRange&&(S(),t.needRefresh=!0);return}function T(){var e=l.deepQuery([r],"animationDuration"),t=l.deepQuery([r],"animationEasing"),i,s,o;for(var u=0,a=l.shapeList.length;u<a;u++)i=l.shapeList[u]._x||0,s=l.shapeList[u]._y||0,n.modShape(l.shapeList[u].id,{scale:[0,0,i,s]}),n.animate(l.shapeList[u].id,"").when(l.deepQuery([o],"animationDuration")||e,{scale:[1,1,i,s]}).start(l.deepQuery([o],"animationEasing")||t)}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/color"),l=this;l.type=u.CHART_TYPE_SCATTER;var c,h=l.getZlevelBase(),p={},d=["circle","rectangle","triangle","diamond","emptyCircle","emptyRectangle","emptyTriangle","emptyDiamond"],v={};l.init=E,l.refresh=S,l.ondataRange=x,l.animation=T,E(r,i)}return e("../util/shape/symbol"),e("../chart").define("scatter",t),t}),define("echarts/util/shape/candle",["require","zrender/tool/matrix","zrender/shape/base","zrender/shape"],function(e){function n(){this.type="candle"}var t=e("zrender/tool/matrix");return n.prototype={_numberOrder:function(e,t){return t-e},buildPath:function(e,t){t.y.sort(this._numberOrder),e.moveTo(t.x,t.y[3]),e.lineTo(t.x,t.y[2]),e.moveTo(t.x-t.width/2,t.y[2]),e.rect(t.x-t.width/2,t.y[2],t.width,t.y[1]-t.y[2]),e.moveTo(t.x,t.y[1]),e.lineTo(t.x,t.y[0]);return},getRect:function(e){var t;return e.brushType=="stroke"||e.brushType=="fill"?t=e.lineWidth||1:t=0,{x:Math.round(e.x-e.width/2-t/2),y:Math.round(e.y[3]-t/2),width:e.width+t,height:e.y[0]-e.y[3]+t}},isCover:function(e,n,r){if(e.__needTransform&&e._transform){var i=[];t.invert(i,e._transform);var s=[n,r];t.mulVector(s,i,[n,r,1]),n==s[0]&&r==s[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),n=s[0],r=s[1]}var o;return e.style.__rect?o=e.style.__rect:(o=this.getRect(e.style),o=[o.x,o.x+o.width,o.y,o.y+o.height],e.style.__rect=o),n>=o[0]&&n<=o[1]&&r>=o[2]&&r<=o[3]?!0:!1}},e("zrender/shape/base").derive(n),e("zrender/shape").define("candle",new n),n}),define("echarts/chart/k",["require","../component/base","./calculableBase","../config","../util/ecData","../util/shape/candle","../chart"],function(e){function t(t,n,r,i){function h(){f.selectedMap={};var e={top:[],bottom:[]},t;for(var r=0,s=l.length;r<s;r++)l[r].type==u.CHART_TYPE_K&&(l[r]=f.reformOption(l[r]),t=i.xAxis.getAxis(l[r].xAxisIndex),t.type==u.COMPONENT_TYPE_AXIS_CATEGORY&&e[t.getPosition()].push(r));for(var o in e)e[o].length>0&&p(o,e[o]);for(var r=0,s=f.shapeList.length;r<s;r++)f.shapeList[r].id=n.newShapeId(f.type),n.addShape(f.shapeList[r])}function p(e,t){var n=d(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;v(i,r)}function d(e){var t,n,r=i.legend,s=[],o=0;for(var u=0,a=e.length;u<a;u++)t=l[e[u]],n=t.name,r?f.selectedMap[n]=r.isSelected(n):f.selectedMap[n]=!0,f.selectedMap[n]&&s.push(e[u]),o=Math.max(o,t.data.length);return{locationMap:s,maxDataLength:o}}function v(e,t){var n,r,s,o,u,a,f={},c,h,p,d;for(var v=0,g=t.length;v<g;v++){n=t[v],r=l[n],s=r.xAxisIndex||0,o=i.xAxis.getAxis(s),c=r.barWidth||Math.floor(o.getGap()/2),d=r.barMaxWidth,d&&d<c&&(c=d),u=r.yAxisIndex||0,a=i.yAxis.getAxis(u),f[n]=[];for(var y=0,b=e;y<b;y++){if(typeof o.getNameByIndex(y)=="undefined")break;h=r.data[y],p=typeof h!="undefined"?typeof h.value!="undefined"?h.value:h:"-";if(p=="-"||p.length!=4)continue;f[n].push([o.getCoordByIndex(y),c,a.getCoord(p[0]),a.getCoord(p[1]),a.getCoord(p[2]),a.getCoord(p[3]),y,o.getNameByIndex(y)])}}m(f)}function m(e){var t,n,r,i,s,o,a,c,h,p,d,v,m,y,b,w;for(var E=0,S=l.length;E<S;E++){d=l[E],y=e[E];if(d.type==u.CHART_TYPE_K&&typeof y!="undefined"){v=[d],t=f.deepQuery(v,"itemStyle.normal.lineStyle.width"),n=f.deepQuery(v,"itemStyle.normal.lineStyle.color"),r=f.deepQuery(v,"itemStyle.normal.lineStyle.color0"),i=f.deepQuery(v,"itemStyle.normal.color"),s=f.deepQuery(v,"itemStyle.normal.color0"),o=f.deepQuery(v,"itemStyle.emphasis.lineStyle.width"),a=f.deepQuery(v,"itemStyle.emphasis.lineStyle.color"),c=f.deepQuery(v,"itemStyle.emphasis.lineStyle.color0"),h=f.deepQuery(v,"itemStyle.emphasis.color"),p=f.deepQuery(v,"itemStyle.emphasis.color0");for(var x=0,T=y.length;x<T;x++)b=y[x],m=d.data[b[6]],v=[m],w=b[3]<b[2],f.shapeList.push(g(E,b[6],b[7],b[0],b[1],b[2],b[3],b[4],b[5],w?f.deepQuery(v,"itemStyle.normal.color")||i:f.deepQuery(v,"itemStyle.normal.color0")||s,f.deepQuery(v,"itemStyle.normal.lineStyle.width")||t,w?f.deepQuery(v,"itemStyle.normal.lineStyle.color")||n:f.deepQuery(v,"itemStyle.normal.lineStyle.color0")||r,w?f.deepQuery(v,"itemStyle.emphasis.color")||h||i:f.deepQuery(v,"itemStyle.emphasis.color0")||p||s,f.deepQuery(v,"itemStyle.emphasis.lineStyle.width")||o||t,w?f.deepQuery(v,"itemStyle.emphasis.lineStyle.color")||a||n:f.deepQuery(v,"itemStyle.emphasis.lineStyle.color0")||c||r))}}}function g(e,t,n,r,i,s,o,u,f,h,p,d,v,m,g){var y={shape:"candle",zlevel:c,clickable:!0,style:{x:r,y:[s,o,u,f],width:i,color:h,strokeColor:d,lineWidth:p,brushType:"both"},highlightStyle:{color:v,strokeColor:g,lineWidth:m},_seriesIndex:e};return a.pack(y,l[e],e,l[e].data[t],t,n),y}function y(e,t){i=t,b(e)}function b(e){e&&(r=e,l=r.series),f.clear(),h()}function w(e){var t={};for(var r=0,s=e.length;r<s;r++)t[e[r][0]]=e[r];var o,u,c,h,p,d;for(var r=0,s=f.shapeList.length;r<s;r++){p=f.shapeList[r]._seriesIndex;if(t[p]&&!t[p][3]&&f.shapeList[r].shape=="candle"){d=a.get(f.shapeList[r],"dataIndex"),h=l[p];if(t[p][2]&&d==h.data.length-1){n.delShape(f.shapeList[r].id);continue}if(!t[p][2]&&d===0){n.delShape(f.shapeList[r].id);continue}u=i.xAxis.getAxis(h.xAxisIndex||0).getGap(),o=t[p][2]?u:-u,c=0,n.animate(f.shapeList[r].id,"").when(500,{position:[o,c]}).start()}}}function E(){var e=f.deepQuery([r],"animationDuration"),t=f.deepQuery([r],"animationEasing"),i,s,o;for(var u=0,a=f.shapeList.length;u<a;u++)f.shapeList[u].shape=="candle"&&(o=l[f.shapeList[u]._seriesIndex],i=f.shapeList[u].style.x,s=f.shapeList[u].style.y[0],n.modShape(f.shapeList[u].id,{scale:[1,0,i,s]}),n.animate(f.shapeList[u].id,"").when(f.deepQuery([o],"animationDuration")||e,{scale:[1,1,i,s]}).start(f.deepQuery([o],"animationEasing")||t))}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=this;f.type=u.CHART_TYPE_K;var l,c=f.getZlevelBase();f.init=y,f.refresh=b,f.addDataAnimation=w,f.animation=E,y(r,i)}return e("../util/shape/candle"),e("../chart").define("k",t),t}),define("echarts/chart/radar",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","../chart"],function(e){function t(t,n,r,i){function y(){l.selectedMap={},v=[],g=0;for(var e=0,t=c.length;e<t;e++)c[e].type==u.CHART_TYPE_RADAR&&(h=l.reformOption(c[e]),d=[h,r],l.deepQuery(d,"calculable")&&T(e),b(e));for(var e=0,t=l.shapeList.length;e<t;e++)l.shapeList[e].id=n.newShapeId(l.type),n.addShape(l.shapeList[e])}function b(e){var t=i.legend,r,s=h.data,o,u,a,f=l.deepQuery(d,"calculable");for(var c=0;c<s.length;c++){u=s[c].name||"",l.selectedMap[u]=t?t.isSelected(u):!0;if(!l.selectedMap[u])continue;t?(o=t.getColor(u),r=t.getItemShape(u),r&&(r.style.brushType=l.deepQuery([s[c],h],"itemStyle.normal.areaStyle")?"both":"stroke",t.setItemShape(u,r))):o=n.getColor(c),a=w(h.polarIndex,s[c]),S(a,o,s[c],e),x(a,o,s[c],e,c,f),g++}}function w(e,t){var n=[],r,s=i.polar;for(var o=0,u=t.value.length;o<u;o++)r=s.getVector(e,o,t.value[o]),r&&n.push(r);return n}function E(e,t,n,r,i,s,o){var u={shape:"icon",zlevel:p+1,style:{iconType:n.replace("empty","").toLowerCase(),x:e-r,y:t-r,width:r*2,height:r*2,brushType:"both",color:n.match("empty")?"#fff":i,strokeColor:i,lineWidth:o*2},hoverable:!1};return n.match("star")&&(u.style.iconType="star",u.style.n=n.replace("empty","").replace("star","")-0||5),u._x=e,u._y=t,u}function S(e,t,n){var r=[n,h],i=l.deepQuery(r,"symbol")||m[g%m.length]||"cricle";if(i!="none"){var s=l.deepQuery(r,"symbolSize"),o=l.deepQuery(r,"itemStyle.normal.color"),u=l.deepQuery(r,"itemStyle.emphasis.color"),a=l.deepQuery(r,"itemStyle.normal.lineStyle.width");for(var f=0,c=e.length;f<c;f++)l.shapeList.push(E(e[f][0],e[f][1],i,s,o||t,u||o||t,a))}}function x(e,t,n,r,s,o){var u=[n,h],d=l.deepQuery(u,"itemStyle.normal.color"),v=l.deepQuery(u,"itemStyle.normal.lineStyle.width"),m=l.deepQuery(u,"itemStyle.normal.lineStyle.type"),g=l.deepQuery(u,"itemStyle.normal.areaStyle.color"),y=l.deepQuery(u,"itemStyle.normal.areaStyle"),b={shape:"polygon",zlevel:p,style:{pointList:e,brushType:y?"both":"stroke",color:g||d||f.alpha(t,.5),strokeColor:d||t,lineWidth:v,lineType:m},highlightStyle:{brushType:l.deepQuery(u,"itemStyle.emphasis.areaStyle")||y?"both":"stroke",color:l.deepQuery(u,"itemStyle.emphasis.areaStyle.color")||g||d||f.alpha(t,.5),strokeColor:l.deepQuery(u,"itemStyle.emphasis.color")||d||t,lineWidth:l.deepQuery(u,"itemStyle.emphasis.lineStyle.width")||v,lineType:l.deepQuery(u,"itemStyle.emphasis.lineStyle.type")||m}};a.pack(b,c[r],r,n,s,n.name,i.polar.getIndicator(c[r].polarIndex)),o&&(b.draggable=!0,l.setCalculable(b)),l.shapeList.push(b)}function T(e){var t=l.deepQuery(d,"polarIndex");if(!v[t]){var n=i.polar.getDropBox(t);n.zlevel=p,l.setCalculable(n),a.pack(n,c,e,undefined,-1),l.shapeList.push(n),v[t]=!0}}function N(e,t){if(!l.isDragend||!e.target)return;var n=e.target,r=a.get(n,"seriesIndex"),s=a.get(n,"dataIndex");i.legend&&i.legend.del(c[r].data[s].name),c[r].data.splice(s,1),t.dragOut=!0,t.needRefresh=!0,l.isDragend=!1;return}function C(e,t){if(!l.isDrop||!e.target)return;var n=e.target,s=e.dragged,o=a.get(n,"seriesIndex"),u=a.get(n,"dataIndex"),f,h=i.legend,p;if(u==-1)f={value:a.get(s,"value"),name:a.get(s,"name")},c[o].data.push(f),h&&h.add(f.name,s.style.color||s.style.strokeColor);else{f=c[o].data[u],h&&h.del(f.name),f.name+=r.nameConnector+a.get(s,"name"),p=a.get(s,"value");for(var d=0;d<p.length;d++)f.value[d]+=p[d];h&&h.add(f.name,s.style.color||s.style.strokeColor)}t.dragIn=t.dragIn||!0,l.isDrop=!1;return}function k(e,t){i=t,L(e)}function L(e){e&&(r=e,c=r.series),l.clear(),y()}function A(){var e=l.deepQuery([r],"animationDuration"),t=l.deepQuery([r],"animationEasing"),s,o,u,f,h,p=i.polar,d,v,m,g;for(var y=0,b=l.shapeList.length;y<b;y++)l.shapeList[y].shape=="polygon"?(v=l.shapeList[y],o=a.get(v,"seriesIndex"),s=a.get(v,"dataIndex"),f=c[o],u=f.data[s],h=l.deepQuery([u,f,r],"polarIndex"),d=p.getCenter(h),m=d[0],g=d[1],n.modShape(l.shapeList[y].id,{scale:[.1,.1,m,g]}),n.animate(v.id,"").when((l.deepQuery([f],"animationDuration")||e)+s*100,{scale:[1,1,m,g]}).start(l.deepQuery([f],"animationEasing")||t)):(m=l.shapeList[y]._x||0,g=l.shapeList[y]._y||0,n.modShape(l.shapeList[y].id,{scale:[0,0,m,g]}),n.animate(l.shapeList[y].id,"").when(e,{scale:[1,1,m,g]}).start("QuinticOut"))}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/color"),l=this;l.type=u.CHART_TYPE_RADAR;var c,h,p=l.getZlevelBase(),d,v,m=["circle","rectangle","triangle","diamond","emptyCircle","emptyRectangle","emptyTriangle","emptyDiamond"],g;l.init=k,l.refresh=L,l.animation=A,l.ondrop=C,l.ondragend=N,k(r,i)}return e("../chart").define("radar",t),t}),define("echarts/util/shape/chord",["require","zrender/tool/util","zrender/shape/base","zrender/shape"],function(e){function n(){this.type="chord"}var t=e("zrender/tool/util"),r=t.getContext();return n.prototype={buildPath:function(e,t){var n=Math.PI*2,r=t.center[0],i=t.center[1],s=t.r,o=t.source0/180*Math.PI,u=t.source1/180*Math.PI,a=t.target0/180*Math.PI,f=t.target1/180*Math.PI,l=r+Math.cos(n-o)*s,c=i-Math.sin(n-o)*s,h=r+Math.cos(n-u)*s,p=i-Math.sin(n-u)*s,d=r+Math.cos(n-a)*s,v=i-Math.sin(n-a)*s,m=r+Math.cos(n-f)*s,g=i-Math.sin(n-f)*s;e.moveTo(l,c),e.arc(r,i,t.r,o,u,!1),e.bezierCurveTo((r-h)*.7+h,(i-p)*.7+p,(r-d)*.7+d,(i-v)*.7+v,d,v);if(t.source0===t.target0&&t.source1===t.target1)return;e.arc(r,i,t.r,a,f,!1),e.bezierCurveTo((r-m)*.7+m,(i-g)*.7+g,(r-l)*.7+l,(i-c)*.7+c,l,c)},getRect:function(){return{x:0,y:0,width:0,height:0}},isCover:function(e,t,i){if(!r.isPointInPath)return!1;if(e.__needTransform&&e._transform){var s=[];matrix.invert(s,e._transform);var o=[t,i];matrix.mulVector(o,s,[t,i,1]),t==o[0]&&i==o[1]&&(Math.abs(e.rotation[0])>1e-4||Math.abs(e.position[0])>1e-4||Math.abs(e.position[1])>1e-4||Math.abs(e.scale[0]-1)>1e-4||Math.abs(e.scale[1]-1)>1e-4?e.__needTransform=!0:e.__needTransform=!1),t=o[0],i=o[1]}return r.beginPath(),n.prototype.buildPath.call(null,r,e.style),r.closePath(),r.isPointInPath(t,i)}},e("zrender/shape/base").derive(n),e("zrender/shape").define("chord",new n),n}),define("echarts/util/kwargs",[],function(){function e(e){var t=this,n=new RegExp("(\\/\\*[\\w\\'\\,\\(\\)\\s\\r\\n\\*]*\\*\\/)|(\\/\\/[\\w\\s\\'][^\\n\\r]*$)|(<![\\-\\-\\s\\w\\>\\/]*>)","gim"),r=new RegExp("\\s+","gim"),i=new RegExp("function.*?\\((.*?)\\)","i"),s=t.toString().replace(n,"").replace(r,"").match(i)[1].split(",");return e!==Object(e)&&(e={}),function(){var n=Array.prototype.slice.call(arguments),r=n[n.length-1];r&&r.constructor===Object?n.pop():r={};for(var i=0;i<s.length;i++){var o=s[i];o in r?n[i]=r[o]:o in e&&n[i]===undefined&&(n[i]=e[o])}return t.apply(this,n)}}Function.prototype.kwargs=e}),define("echarts/util/ndarray",["require","./kwargs"],function(e){function d(e){if(typeof e=="undefined")return"number";switch(Object.prototype.toString.call(e)){case"[object Int32Array]":return"int32";case"[object Int16Array]":return"int16";case"[object Int8Array]":return"int8";case"[object Uint32Array]":return"uint32";case"[object Uint16Array]":return"uint16";case"[object Uint8Array]":return"uint8";case"[object Uint8ClampedArray]":return"uint8c";case"[object Float32Array]":return"float32";case"[object Float64Array]":return"float64";default:return"number"}}function m(e,t){if(e.indexOf(":")>=0){var n=e.split(/\s*:\s*/),r=parseInt(n[2]||1,10),i,s;if(r===0)throw new Error("Slice step cannot be zero");return r>0?(i=parseInt(n[0]||0,10),s=parseInt(n[1]||t,10)):(i=parseInt(n[0]||t-1,10),s=parseInt(n[1]||-1,10)),i<0&&(i=t+i),s<0&&n[1]&&(s=t+s),r>0?(i=Math.max(Math.min(t,i),0),s=Math.max(Math.min(t,s),0)):(i=Math.max(Math.min(t-1,i),-1),s=Math.max(Math.min(t-1,s),-1)),[i,s,r]}var i=parseInt(e,10);i<0&&(i=t+i);if(i<0||i>t)throw new Error(N(e));return i=Math.max(Math.min(t-1,i),0),[i,i+1,1]}function g(e){var t=e[0];for(var n=1;n<e.length;n++)t*=e[n];return t}function y(e){var t=1,n=e[0];while(n instanceof Array)n=n[0],t++;return t}function b(e){var t=[e.length],n=e[0];while(n instanceof Array)t.push(n.length),n=n[0];return t}function w(e,t){if(t==e.length-1)return 1;var n=e[t+1];for(var r=t+2;r<e.length;r++)n*=e[r];return n}function E(e){var t=[],n=1,r=g(e);for(var i=0;i<e.length;i++)n*=e[i],t.push(r/n);return t}function S(e,t){if(e.length!==t.length)return!1;for(var n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function x(e,t){return"Shape ("+e.toString()+") ("+t.toString()+") could not be broadcast together"}function T(e){return"Axis "+e+" out of bounds"}function N(e){return"Index "+e+" out of bounds"}e("./kwargs");var t=Array.prototype.slice,n=window;n.Int32Array=n.Int32Array||Array,n.Int16Array=n.Int16Array||Array,n.Int8Array=n.Int8Array||Array,n.Uint32Array=n.Uint32Array||Array,n.Uint16Array=n.Uint16Array||Array,n.Uint8Array=n.Uint8Array||Array,n.Float32Array=n.Float32Array||Array,n.Float64Array=n.Float64Array||Array;var r={int32:n.Int32Array,int16:n.Int16Array,int8:n.Int8Array,uint32:n.Uint32Array,uint16:n.Uint16Array,uint8:n.Uint8Array,uint8c:n.Uint8ClampedArray,float32:n.Float32Array,float64:n.Float64Array,number:Array},i={int32:4,int16:2,int8:1,uint32:4,uint16:2,uint8:1,uint8c:1,float32:4,float64:8,number:1},s=0,o=1,u=2,a=3,f=4,l=5,c=6,h=7,p=8,v=function(e){var t=arguments[arguments.length-1];typeof t=="string"?this._dtype=t:this._dtype=d(e);if(e&&typeof e!="string"){if(e instanceof v)return e._dtype=this._dtype,e;e.length?this.initFromArray(e):typeof e=="number"&&this.initFromShape.apply(this,arguments)}else this._array=new r[this._dtype],this._shape=[0],this._size=0};return v.prototype={initFromArray:function(e){function i(e,r,s){var o=s.length;for(var u=0;u<o;u++)e<t-1?i(e+1,r,s[u]):r[n++]=s[u]}var t=y(e),n=0,s=b(e),o=g(s);return this._array=new r[this._dtype](o),i(0,this._array,e),this._shape=s,this._size=o,this},initFromShape:function(e){typeof e=="number"&&(e=Array.prototype.slice.call(arguments));if(e){var t=g(e);if(this._dtype==="number"){this._array=[];var n=this._array;for(var i=0;i<t;i++)n[i]=0}else this._array=new r[this._dtype](t)}return this._shape=e,this._size=g(e),this},fill:function(e){var t=this._array;for(var n=0;n<t.length;n++)t[n]=e;return this},shape:function(){return this._shape.slice()},size:function(){return this._size},dtype:function(){return this._dtype},dimension:function(){return this._shape.length},strides:function(){var e=E(this._shape),t=i[this._dtype];for(var n=0;n<e.length;n++)e[n]*=t;return e},reshape:function(e){typeof e=="number"&&(e=Array.prototype.slice.call(arguments));if(!this._isShapeValid(e))throw new Error("Total size of new array must be unchanged");return this._shape=e,this},_isShapeValid:function(e){return g(e)===this._size},resize:function(e){typeof e=="number"&&(e=Array.prototype.slice.call(arguments));var t=g(e);if(t<this._size)this._dtype==="number"&&(this._array.length=t);else if(this._dtype==="number")for(var n=this._array.length;n<t;n++)this._array[n]=0;else{var i=new r[this._dtype](t),s=this._array;for(var n=0;n<s.length;n++)i[n]=s[n];this._array=i}return this._shape=e,this._size=t,this},transpose:function(e,t){var n=[];for(var r=0;r<this._shape.length;r++)n.push(r);typeof e=="undefined"&&(e=n.slice());for(var r=0;r<e.length;r++)if(e[r]>=this._shape.length)throw new Error(T(e[r]));if(e.length<=1)return this;var i=n.slice();for(var r=0;r<Math.floor(e.length/2);r++)for(var s=e.length-1;s>=Math.ceil(e.length/2);s--)i[e[r]]=e[s],i[e[s]]=e[r];return this._transposelike(i,t)}.kwargs(),swapaxes:function(e,t,n){return this.transpose([e,t],n)}.kwargs(),rollaxis:function(e,t,n){if(e>=this._shape.length)throw new Error(T(e));var r=[];for(var i=0;i<this._shape.length;i++)r.push(i);return r.splice(e,1),r.splice(t,0,e),this._transposelike(r,n)}.kwargs({start:0}),_transposelike:function(e,t){function p(e,t,r){var u=i[e],a=s[e],f=c[e];if(e<o-1)for(var l=0;l<u;l++)p(e+1,t+a*l,r+f*l);else for(var l=0;l<u;l++)h[r+l]=n[t+a*l]}var n=this._array,i=this._shape.slice(),s=E(this._shape),o=i.length,u=[],a=[];for(var f=0;f<e.length;f++){var l=e[f];a[f]=i[l],u[f]=s[l]}s=u,i=a,this._shape=i;var c=E(this._shape);t||(t=new v,t._shape=this._shape.slice(),t._dtype=this._dtype,t._size=this._size);var h=new r[this._dtype](this._size);return t._array=h,p(0,0,0),t},repeat:function(e,t,n){var r;typeof t=="undefined"?(r=[this._size],t=0):r=this._shape.slice();var i=r.slice();r[t]*=e;if(!n)n=new v(this._dtype),n.initFromShape(r);else if(!S(r,n._shape))throw new Error(x(r,n._shape));var s=n._array,o=w(i,t),u=i[t],a=this._array,f=o*u;for(var l=0;l<this._size;l+=f)for(var c=0;c<o;c++){var h=l+c,p=l*e+c;for(var d=0;d<u;d++){for(var m=0;m<e;m++)s[p]=a[h],p+=o;h+=o}}return n}.kwargs(),choose:function(){console.warn("TODO")},take:function(){console.warn("TODO")},tile:function(){console.warn("TODO")},_withPreprocess1:function(e,t,n,r){var i=this._array;if(!this._size)return;if(typeof e!="undefined"){e<0&&(e=this._shape.length+e);if(e>=this._shape.length||e<0)throw new Error(T(e));var s=this._shape.slice();s.splice(e,1);if(t&&!S(s,t._shape))throw new Error(x(s,t._shape));t||(t=new v(this._dtype),t.initFromShape(s));var o=t._array,u=w(this._shape,e),a=this._shape[e],f=u*a;return n.call(this,o,i,f,a,u),t}return r.call(this,i)},_withPreprocess2:function(e,t,n,r){var i=this._array;if(!this._size)return;if(t&&!S(this._shape,t._shape))throw new Error(x(this._shape,t._shape));t||(t=new v(this._dtype),t.initFromShape(this._shape));var s=t._array;if(typeof e!="undefined"){e<0&&(e=this._shape.length+e);if(e>=this._shape.length||e<0)throw new Error(T(e));if(e>=this._shape.length)throw new Error(T(e));var o=w(this._shape,e),u=this._shape[e],a=o*u;n.call(this,s,i,a,u,o)}else t.reshape([this._size]),r.call(this,s,i);return t},max:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=u+o,f=t[a];for(var l=0;l<r;l++){var c=t[a];c>f&&(f=c),a+=i}e[s++]=f}}function t(e){var t=e[0];for(var n=1;n<this._size;n++)e[n]>t&&(t=e[n]);return t}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),min:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=u+o,f=t[a];for(var l=0;l<r;l++){var c=t[a];c<f&&(f=c),a+=i}e[s++]=f}}function t(e){var t=e[0];for(var n=1;n<this._size;n++)e[n]<t&&(t=e[n]);return t}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),argmax:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o,l=t[f];for(var c=0;c<r;c++){var h=t[f];h>l&&(l=h,a=c),f+=i}e[s++]=a}}function t(e){var t=e[0],n=0;for(var r=1;r<this._size;r++)e[r]>t&&(n=r,t=e[r]);return n}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),argmin:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o,l=t[f];for(var c=0;c<r;c++){var h=t[f];h<l&&(l=h,a=c),f+=i}e[s++]=a}}function t(e){var t=e[0],n=0;for(var r=1;r<this._size;r++)e[r]<t&&(n=r,t=e[r]);return n}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),sum:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o;for(var l=0;l<r;l++)a+=t[f],f+=i;e[s++]=a}}function t(e){var t=0;for(var n=0;n<this._size;n++)t+=e[n];return t}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),prod:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=1,f=u+o;for(var l=0;l<r;l++)a*=t[f],f+=i;e[s++]=a}}function t(e){var t=1;for(var n=0;n<this._size;n++)t*=e[n];return t}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),mean:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o;for(var l=0;l<r;l++)a+=t[f],f+=i;var c=a/r;e[s++]=c}}function t(e){var t=0,n=e.length;for(var r=0;r<n;r++)t+=e[r];var i=t/n;return i}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),"var":function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o;for(var l=0;l<r;l++)a+=t[f],f+=i;var c=a/r,h=0;f=u+o;for(var l=0;l<r;l++){var p=t[f]-c;h+=p*p,f+=i}e[s++]=h/r}}function t(e){var t=0,n=e.length;for(var r=0;r<n;r++)t+=e[r];var i=t/n,s=0;for(var r=0;r<n;r++){var o=e[r]-i;s+=o*o}return s/n}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),std:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=0,f=u+o;for(var l=0;l<r;l++)a+=t[f],f+=i;var c=a/r,h=0;f=u+o;for(var l=0;l<r;l++){var p=t[f]-c;h+=p*p,f+=i}e[s++]=Math.sqrt(h/r)}}function t(e){var t=0,n=e.length;for(var r=0;r<n;r++)t+=e[r];var i=t/n,s=0;for(var r=0;r<n;r++){var o=e[r]-i;s+=o*o}return Math.sqrt(s/n)}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),ptp:function(){function e(e,t,n,r,i){var s=0;for(var o=0;o<this._size;o+=n)for(var u=0;u<i;u++){var a=o+u,f=t[a],l=t[a];for(var c=0;c<r;c++){var h=t[a];h<f&&(f=h),h>l&&(l=h),a+=i}e[s++]=l-f}}function t(e){var t=e[0],n=e[0];for(var r=1;r<this._size;r++)e[r]<t&&(t=e[r]),e[r]>n&&(n=e[r]);return n-t}return function(n,r){return this._withPreprocess1(n,r,e,t)}}().kwargs(),sort:function(e,t){e<0&&(e=this._shape.length+e);var n;t==="ascending"?n=function(e,t){return e-t}:t==="descending"&&(n=function(e,t){return t-e});var r=this._array,i=w(this._shape,e),s=this._shape[e],o=i*s,u=new Array(s);for(var a=0;a<this._size;a+=o)for(var f=0;f<i;f++){var l=a+f;for(var c=0;c<s;c++)u[c]=r[l],l+=i;u.sort(n);var l=a+f;for(var c=0;c<s;c++)r[l]=u[c],l+=i}return this}.kwargs({axis:-1,order:"ascending"}),argsort:function(e,t,n){e<0&&(e=this._shape.length+e);if(!this._size)return;if(n&&!S(this._shape,n._shape))throw new Error(x(this._shape,n._shape));n||(n=new v(this._dtype),n.initFromShape(this._shape));var r=n._array,i;t==="ascending"?i=function(e,t){return f[e]-f[t]}:t==="descending"&&(i=function(e,t){return f[t]-f[e]});var s=this._array,o=w(this._shape,e),u=this._shape[e],a=o*u,f=new Array(u),l=new Array(u);for(var c=0;c<this._size;c+=a)for(var h=0;h<o;h++){var p=c+h;for(var d=0;d<u;d++)f[d]=s[p],l[d]=d,p+=o;l.sort(i);var p=c+h;for(var d=0;d<u;d++)r[p]=l[d],p+=o}return n}.kwargs({axis:-1,order:"ascending"}),cumsum:function(){function e(e,t,n,r,i){for(var s=0;s<this._size;s+=n)for(var o=0;o<i;o++){var u=s+o,a=u;e[u]=t[u];for(var f=1;f<r;f++)a=u,u+=i,e[u]=e[a]+t[u]}}function t(e,t){e[0]=t[0];for(var n=1;n<e.length;n++)e[n]=e[n-1]+t[n]}return function(n,r){return this._withPreprocess2(n,r,e,t)}}().kwargs(),cumprod:function(){function e(e,t,n,r,i){for(var s=0;s<this._size;s+=n)for(var o=0;o<i;o++){var u=s+o,a=u;e[u]=t[u];for(var f=1;f<r;f++)a=u,u+=i,e[u]=e[a]*t[u]}}function t(e,t){e[0]=t[0];for(var n=1;n<e.length;n++)e[n]=e[n-1]*t[n]}return function(n,r){return this._withPreprocess2(n,r,e,t)}}().kwargs(),dot:function(){console.warn("TODO")},map:function(e,t){var n=this._array,r=this._array,i=n[0],s=n[0],o=this._size;for(var u=1;u<o;u++){var a=n[u];a<i&&(i=a),a>s&&(s=a)}var f=s-i,l=t-e;for(var u=0;u<o;u++)if(f===0)r[u]=e;else{var a=n[u],c=(a-i)/f;r[u]=l*c+e}return this},add:function(e,t){return this.binaryOperation(this,e,s,t)},sub:function(e,t){return this.binaryOperation(this,e,o,t)},mul:function(e,t){return this.binaryOperation(this,e,u,t)},div:function(e,t){return this.binaryOperation(this,e,a,t)},mod:function(e,t){return this.binaryOperation(this,e,f,t)},and:function(e,t){return this.binaryOperation(this,e,l,t)},or:function(e,t){return this.binaryOperation(this,e,c,t)},xor:function(e,t){return this.binaryOperation(this,e,h,t)},equal:function(e){return this.binaryOperation(this,e,p,out)},binaryOperation:function(e,t,n,r){var i=[],d=typeof e=="number",m=typeof t=="number";if(d)i=t._shape.slice();else if(m)i=e._shape.slice();else{var g=e._shape.length-1,y=t._shape.length-1,b=e,E=t;while(g>=0&&y>=0){if(e._shape[g]==1)i.unshift(t._shape[y]),b=e.repeat(t._shape[y],g);else if(t._shape[y]==1)i.unshift(e._shape[g]),E=t.repeat(e._shape[g],y);else{if(t._shape[y]!=e._shape[g])throw new Error(x(e._shape,t._shape));i.unshift(e._shape[g])}g--,y--}for(var T=g;T>=0;T--)i.unshift(e._shape[T]);for(var T=y;T>=0;T--)i.unshift(t._shape[T]);e=b,t=E}if(!r)r=new v(this._dtype),r.initFromShape(i);else if(!S(i,r._shape))throw new Error(x(i,r._shape));var N=r._array,C,k,L,A;d?(C=t._shape.length-1,k=!1,L=e,A=t._array):m?(C=e._shape.length-1,k=!0,A=t,L=e._array):(C=Math.abs(e._shape.length-t._shape.length),k=e._shape.length>=t._shape.length,L=e._array,A=t._array);var O=w(i,C),M=i[C],_=O*M,D=r._size/_,P,H,B,j=0;if(k)if(m)for(var F=0;F<D;F++)for(var T=0;T<_;T++){P=L[j],H=A;switch(n){case s:B=P+H;break;case o:B=P-H;break;case u:B=P*H;break;case a:B=P/H;break;case f:B=P%H;break;case l:B=P&H;break;case c:B=P|H;break;case h:B=P^H;break;case p:B=P==H;break;default:throw new Error("Unkown operation "+n)}N[j]=B,j++}else for(var F=0;F<D;F++)for(var T=0;T<_;T++){P=L[j],H=A[T];switch(n){case s:B=P+H;break;case o:B=P-H;break;case u:B=P*H;break;case a:B=P/H;break;case f:B=P%H;break;case l:B=P&H;break;case c:B=P|H;break;case h:B=P^H;break;case p:B=P==H;break;default:throw new Error("Unkown operation "+n)}N[j]=B,j++}else if(d)for(var F=0;F<D;F++)for(var T=0;T<_;T++){P=L,H=A[j];switch(n){case s:B=P+H;break;case o:B=P-H;break;case u:B=P*H;break;case a:B=P/H;break;case f:B=P%H;break;case l:B=P&H;break;case c:B=P|H;break;case h:B=P^H;break;case p:B=P==H;break;default:throw new Error("Unkown operation "+n)}N[j]=B,j++}else for(var F=0;F<D;F++)for(var T=0;T<_;T++){P=L[j],H=A[T];switch(n){case s:B=P+H;break;case o:B=P-H;break;case u:B=P*H;break;case a:B=P/H;break;case f:B=P%H;break;case l:B=P&H;break;case c:B=P|H;break;case h:B=P^H;break;case p:B=P==H;break;default:throw new Error("Unkown operation "+n)}N[j]=B,j++}return r},neg:function(){var e=this._array;for(var t=0;t<this._size;t++)e[t]=-e[t];return this},sin:function(){return this._mathAdapter(Math.sin)},cos:function(){return this._mathAdapter(Math.cos)},tan:function(){return this._mathAdapter(Math.tan)},abs:function(){return this._mathAdapter(Math.abs)},log:function(){return this._mathAdapter(Math.log)},sqrt:function(){return this._mathAdapter(Math.sqrt)},ceil:function(){return this._mathAdapter(Math.ceil)},floor:function(){return this._mathAdapter(Math.floor)},pow:function(e){var t=this._array;for(var n=0;n<this._size;n++)t[n]=Math.pow(t[n],e);return this},_mathAdapter:function(e){var t=this._array;for(var n=0;n<this._size;n++)t[n]=e(t[n]);return this},round:function(e){e=Math.floor(e||0);var t=Math.pow(10,e),n=this._array;if(e===0)for(var r=0;r<this._size;r++)n[r]=Math.round(n[r]);else for(var r=0;r<this._size;r++)n[r]=Math.round(n[r]*t)/t;return this},clip:function(e,t){var n=this._array;for(var r=0;r<this._size;r++)n[r]=Math.max(Math.min(n[r],t),e);return this},get:function(e,t){function l(e,t){var r=i[e],s=n[e];if(e<o-1)if(r[2]>0)for(var c=r[0];c<r[1];c+=r[2])l(e+1,t+s*c);else for(var c=r[0];c>r[1];c+=r[2])l(e+1,t+s*c);else if(r[2]>0)for(var c=r[0];c<r[1];c+=r[2])for(var h=0;h<s;h++)u[f++]=a[c*s+h+t];else for(var c=r[0];c>r[1];c+=r[2])for(var h=0;h<s;h++)u[f++]=a[c*s+h+t]}typeof e=="number"&&(e=e.toString());var n=E(this._shape),r=this._parseRanges(e),i=r[0],s=r[1];if(i.length>this._shape.length)throw new Error("Too many indices");var o=i.length,u;s.length?(t=new v(this._dtype),t.initFromShape(s),u=t._array):u=[];var a=this._array,f=0;return l(0,0),s.length?t:u[0]},set:function(e,t){typeof e=="number"&&(e=e.toString());var n=E(this._shape),r=this._parseRanges(e),i=r[0],s=r[1];if(i.length>this._shape.length)throw new Error("Too many indices");var o=typeof t=="number",u=i.length,a=this._array;if(o)var f=t;else{if(!S(s,t.shape()))throw new Error(x(s,t.shape()));var f=t._array}var l=0,c=function(e,t){var r=i[e],s=n[e];if(e<u-1)if(r[2]>0)for(var h=r[0];h<r[1];h+=r[2])c(e+1,t+s*h);else for(var h=r[0];h>r[1];h+=r[2])c(e+1,t+s*h);else if(r[2]>0)for(var h=r[0];h<r[1];h+=r[2])for(var p=0;p<s;p++)o?a[h*s+p+t]=f:a[h*s+p+t]=f[l++];else for(var h=r[0];h>r[1];h+=r[2])for(var p=0;p<s;p++)o?a[h*s+p+t]=f:a[h*s+p+t]=f[l++]};return c(0,0),this},insert:function(e,t,n){var i=this._array,s=!1;typeof e=="number"&&(e=[e],s=!0),typeof t=="number"?t=new v([t]):t instanceof Array&&(t=new v(t)),typeof n=="undefined"&&(this._shape=[this._size],n=0);var o=e[0],u=this._shape[n];for(var a=0;a<e.length;a++){e[a]<0&&(e[a]=u+e[a]);if(e[a]>u)throw new Error(N(e[a]));if(e[a]<o)throw new Error("Index must be in ascending order");o=e[a]}var f=this._shape.slice();s?f.splice(n,1):f[n]=e.length;var l=t._shape,c=l.length-1,h=f.length-1,p=t;while(c>=0&&h>=0){if(l[c]===1)p=t.repeat(f[h],c);else if(l[c]!==f[h])throw new Error(x(l,f));c--,h--}t=p;var d=w(this._shape,n),u=this._shape[n],m=u*d,y=this._size/m,b=e.length,E=new Uint32Array(y*b),S=0;for(var T=0;T<this._size;T+=m)for(var a=0;a<b;a++){var C=e[a];E[S++]=T+C*d}var k=this._shape.slice();k[n]+=e.length;var L=g(k);if(this._array.length<L)var i=new r[this._dtype](L);else var i=this._array;var A=this._array,O=t._array,M=E.length-1,_=this._size,D=E[M],P=L-1,H=t._size-1;while(M>=0){for(var a=_-1;a>=D;a--)i[P--]=A[a];_=D,D=E[--M];for(var a=0;a<d;a++)H<0&&(H=t._size-1),i[P--]=O[H--]}for(var a=_-1;a>=0;a--)i[P--]=A[a];return this._array=i,this._shape=k,this._size=L,this}.kwargs(),append:function(){console.warn("TODO")}.kwargs(),"delete":function(e,t){var n=this._array;typeof e=="number"&&(e=[e]);var r=this._size;typeof t=="undefined"&&(this._shape=[r],t=0);var i=w(this._shape,t),s=this._shape[t],o=i*s,u=0;for(var a=0;a<r;a+=o){var f=0,l=e[0],c=0;while(c<e.length){l<0&&(l+=s);if(l>s)throw new Error(N(l));if(l<f)throw new Error("Index must be in ascending order");for(var h=f;h<l;h++)for(var p=0;p<i;p++)n[u++]=n[h*i+p+a];f=l+1,l=e[++c]}for(var h=f;h<s;h++)for(var p=0;p<i;p++)n[u++]=n[h*i+p+a]}return this._shape[t]-=e.length,this._size=g(this._shape),this}.kwargs(),_parseRanges:function(e){var t=e.split(/\s*,\s*/),n=[],r=[],i=0;for(var s=0;s<t.length;s++)if(t[s]==="..."){var o=this._shape.length-(t.length-s);while(i<=o)n.push([0,this._shape[i],1]),r.push(this._shape[i]),i++}else{var u=m(t[s],this._shape[i]);n.push(u);if(t[s].indexOf(":")>=0){var a=Math.floor((u[1]-u[0])/u[2]);a=a<0?0:a,r.push(a)}i++}for(;i<this._shape.length;i++)r.push(this._shape[i]);return[n,r]},toArray:function(){function i(s,o){var u=n[s];for(var a=0;a<u;a++)s<r-1?i(s+1,o[a]=[]):o[a]=e[t++]}var e=this._array,t=0,n=this._shape,r=n.length,s=[];return i(0,s),s},copy:function(){var e=new v;return e._array=t.call(this._array),e._shape=this._shape.slice(),e._dtype=this._dtype,e._size=this._size,e},constructor:v},v.range=function(e,n,i,s){var o=t.call(arguments),u=o[o.length-1];if(typeof u=="string"){var s=u;o.pop()}o.length===1?(n=o[0],i=1,e=0):o.length==2&&(i=1),s=s||"number";var a=new r[s](Math.ceil((n-e)/i)),f=0;for(var l=e;l<n;l+=i)a[f++]=l;var c=new v;return c._array=a,c._shape=[a.length],c._dtype=s,c._size=a.length,c}.kwargs(),v.zeros=function(e,t){var n=new v(t);return n.initFromShape(e),n}.kwargs(),v}),define("echarts/chart/chord",["require","../util/shape/chord","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/util","zrender/tool/vector","../util/ndarray","../chart"],function(e){function n(n,r,i,s){function F(){o.selectedMap={},w=[],b=null;var e=[],n=0;for(var i=0,s=g.length;i<s;i++)if(g[i].type===o.type){b||(b=g[i],o.reformOption(b));var u=m(g[i].name);o.selectedMap[g[i].name]=u;if(!u)continue;w.push(g[i]),e.push(g[i].matrix),n++}if(!b)return;if(!w.length)return;var a=r.getWidth(),f=r.getHeight(),l=Math.min(a,f);E=b.data,S=b.startAngle,S%=360,S<0&&(S+=360),x=b.clockWise,T=o.parsePercent(b.radius[0],l/2),N=o.parsePercent(b.radius[1],l/2),C=b.padding,k=b.sort,L=b.sortSub,O=b.showScale,M=b.showScaleText,A=[o.parsePercent(b.center[0],a),o.parsePercent(b.center[1],f)];var c=b.itemStyle.normal.chordStyle.lineStyle.width-b.itemStyle.normal.lineStyle.width;_=c/t/T/Math.PI*180,D=new p(e),D=D._transposelike([1,2,0]);var h=I(D,E);D=h[0],E=h[1];var d=D.shape();if(d[0]!==d[1]||d[0]!==E.length)throw new Error("Data not valid");if(d[0]===0||d[2]===0)return;D.reshape(d[0],d[1]*d[2]);var v=D.sum(1),y=v.mul(1/v.sum()),B=d[0],j=d[1]*d[2],F=y.mul(360-C*B),W=D.div(D.sum(1).reshape(B,1));W=W.mul(F.sub(_*2).reshape(B,1));switch(k){case"ascending":case"descending":var X=F.argsort(0,k);F.sort(0,k),v.sort(0,k);break;default:var X=p.range(d[0])}switch(L){case"ascending":case"descending":var V=W.argsort(1,L);W.sort(1,L);break;default:var V=p.range(j).reshape(1,j).repeat(B,0)}var $=X.toArray(),J=F.toArray(),K=V.toArray(),Q=W.toArray(),G=v.toArray(),Y=[],Z=(new p(B,j)).toArray(),et=[],tt=0,nt=0;for(var i=0;i<B;i++){var rt=$[i];et[rt]=G[i],nt=tt+J[i],Y[rt]=[tt,nt];var it=tt+_,st=it;for(var ot=0;ot<j;ot++){st=it+Q[rt][ot];var ut=K[rt][ot];Z[rt][ut]=[it,st],it=st}tt=nt+C}H=(new p(B,B,n)).toArray(),P=[],q(Y,et),Z=(new p(Z)).reshape(B,B,n,2).toArray(),R(Z,D.reshape(d).toArray());var h=z(et);O&&U(h[0],h[1],Y,(new p(h[0])).sum()/(360-C*B))}function I(e,t){var n=[],r=[];for(var i=0;i<t.length;i++){var s=t[i].name;o.selectedMap[s]=m(s),o.selectedMap[s]?r.push(t[i]):n.push(i)}n.length&&(e=e["delete"](n,0),e=e["delete"](n,1));if(!e.size())return[e,r];n=[];var u=[],a=e.shape();e.reshape(a[0],a[1]*a[2]);var f=e.sum(1).toArray();e.reshape(a);for(var i=0;i<r.length;i++)f[i]===0?n.push(i):u.push(r[i]);return n.length&&(e=e["delete"](n,0),e=e["delete"](n,1)),[e,u]}function q(e,t){function f(e){return function(){s&&clearTimeout(s),s=setTimeout(function(){for(var t=0;t<n;t++){P[t].style.opacity=t===e?1:.1,r.modShape(P[t].id,P[t]);for(var s=0;s<n;s++)for(var o=0;o<i;o++){var u=H[t][s][o];u&&(u.style.opacity=t===e||s===e?.5:.03,r.modShape(u.id,u))}}r.refresh()},50)}}function c(){return function(){s&&clearTimeout(s),s=setTimeout(function(){for(var e=0;e<n;e++){P[e].style.opacity=1,r.modShape(P[e].id,P[e]);for(var t=0;t<n;t++)for(var s=0;s<i;s++){var o=H[e][t][s];o&&(o.style.opacity=.5,r.modShape(o.id,o))}}r.refresh()},50)}}var n=E.length,i=w.length,s,u=o.deepQuery([b],"itemStyle.normal.label.show"),a=o.deepQuery([b],"itemStyle.normal.label.color");for(var p=0;p<n;p++){var d=E[p],m=e[p],g=(x?360-m[1]:m[0])+S,C=(x?360-m[0]:m[1])+S,k={id:r.newShapeId(o.type),shape:"sector",zlevel:y,style:{x:A[0],y:A[1],r0:T,r:N,startAngle:g,endAngle:C,brushType:"fill",opacity:1,color:v(d.name)},highlightStyle:{brushType:"fill"}};k.style.lineWidth=o.deepQuery([d,b],"itemStyle.normal.lineStyle.width"),k.highlightStyle.lineWidth=o.deepQuery([d,b],"itemStyle.emphasis.lineStyle.width"),k.style.strokeColor=o.deepQuery([d,b],"itemStyle.normal.lineStyle.color"),k.highlightStyle.strokeColor=o.deepQuery([d,b],"itemStyle.emphasis.lineStyle.color"),k.style.lineWidth>0&&(k.style.brushType="both"),k.highlightStyle.lineWidth>0&&(k.highlightStyle.brushType="both"),l.pack(k,w[0],0,t[p],0,d.name);if(u){var L=[g+C]/2;L%=360;var O=L<=90||L>=270;L=L*Math.PI/180;var _=[Math.cos(L),-Math.sin(L)],D=M?45:20,B=h.scale([],_,N+D);h.add(B,B,A);var j={shape:"text",id:r.newShapeId(o.type),zlevel:y-1,hoverable:!1,style:{x:B[0],y:B[1],text:d.name,textAlign:O?"left":"right",color:a,hoverable:!1}};j.style.textColor=o.deepQuery([d,b],"itemStyle.normal.label.textStyle.color")||"#fff",k.style.textFont=o.getFont(o.deepQuery([d,b],"itemStyle.normal.label.textStyle")),r.addShape(j),o.shapeList.push(j)}k.onmouseover=f(p),k.onmouseout=c(),o.shapeList.push(k),P.push(k),r.addShape(k)}}function R(e,t){var n=e.length;if(!n)return;var i=e[0][0].length,s=b.itemStyle.normal.chordStyle.lineStyle,u=b.itemStyle.emphasis.chordStyle.lineStyle;for(var a=0;a<n;a++)for(var f=0;f<n;f++)for(var c=0;c<i;c++){if(H[f][a][c])continue;var h=e[a][f][c][0],p=e[f][a][c][0],d=e[a][f][c][1],m=e[f][a][c][1];if(h-m===0||p-m===0){H[a][f][c]=null;continue}var g;i===1?d-h<=m-p?g=v(E[a].name):g=v(E[f].name):g=v(w[c].name);var N=x?h:360-d,C=x?d:360-h,k=x?p:360-m,L=x?m:360-p,O={id:r.newShapeId(o.type),shape:"chord",zlevel:y,style:{center:A,r:T,source0:N-S,source1:C-S,target0:k-S,target1:L-S,brushType:"both",opacity:.5,color:g,lineWidth:s.width,strokeColor:s.color},highlightStyle:{brushType:"both",lineWidth:u.width,strokeColor:u.color}};l.pack(O,w[c],c,t[a][f][c],0,E[a].name,E[f].name,t[f][a][c]),H[a][f][c]=O,o.shapeList.push(O),r.addShape(O)}}function U(e,t,n,i){for(var s=0;s<n.length;s++){var u=n[s][0],a=n[s][1],f=u;while(f<a){var l=((x?360-f:f)+S)/180*Math.PI,c=[Math.cos(l),-Math.sin(l)],d=h.scale([],c,N+1);h.add(d,d,A);var v=h.scale([],c,N+B);h.add(v,v,A);var m={shape:"line",id:r.newShapeId(o.type),zlevel:y-1,hoverable:!1,style:{xStart:d[0],yStart:d[1],xEnd:v[0],yEnd:v[1],lineCap:"round",brushType:"stroke",strokeColor:"#666"}};o.shapeList.push(m),r.addShape(m),f+=j}if(!M)continue;var g=u,b=i*5*j,w=p.range(0,e[s],b).toArray();while(g<a){var l=x?360-g:g;l=(l+S)%360;var E=l<=90||l>=270,T={shape:"text",id:r.newShapeId(o.type),zlevel:y-1,hoverable:!1,style:{x:E?N+B+4:-N-B-4,y:0,text:Math.round(w.shift()*10)/10+t,textAlign:E?"left":"right"},position:A.slice(),rotation:E?[l/180*Math.PI,0,0]:[(l+180)/180*Math.PI,0,0]};o.shapeList.push(T),r.addShape(T),g+=j*5}}}function z(e){var t=[],n=(new p(e)).max(),r,i;n>1e4?(r="k",i=.001):n>1e7?(r="m",i=1e-6):n>1e10?(r="b",i=1e-9):(r="",i=1);for(var s=0;s<e.length;s++)t[s]=e[s]*i;return[t,r]}function W(e,t){s=t,X(e)}function X(e){e&&(i=e,g=i.series),o.clear(),d=s.legend;if(d)v=d.getColor,m=d.isSelected;else{var t={},n={},u=0;v=function(e){if(n[e])return n[e];t[e]===undefined&&(t[e]=u++);for(var i=0;i<w.length;i++)if(w[i].name===e){n[e]=o.deepQuery([w[i]],"itemStyle.normal.color");break}if(!n[e]){var s=E.length;for(var i=0;i<s;i++)if(E[i].name===e){n[e]=o.deepQuery([E[i]],"itemStyle.normal.color");break}}return n[e]||(n[e]=r.getColor(t[e])),n[e]},m=function(){return!0}}F()}function V(e){var t=c.merge;e=t(e||{},f.chord,{overwrite:!1,recursive:!0}),e.itemStyle.normal.label.textStyle=t(e.itemStyle.normal.label.textStyle||{},f.textStyle,{overwrite:!1,recursive:!0})}var o=this,u=e("../component/base");u.call(this,r);var a=e("./calculableBase");a.call(this,r,i);var f=e("../config"),l=e("../util/ecData"),c=e("zrender/tool/util"),h=e("zrender/tool/vector"),p=e("../util/ndarray"),d,v,m,g;this.type=f.CHART_TYPE_CHORD;var y=o.getZlevelBase(),b,w=[],E,S,x,T,N,C,k,L,A,O,M,_=0,D,P=[],H=[],B=4,j=4;o.init=W,o.refresh=X,o.reformOption=V,W(i,s)}e("../util/shape/chord");var t=window.devicePixelRatio||1;return e("../chart").define("chord",n),n}),define("echarts/chart/force",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/config","zrender/tool/event","zrender/tool/util","zrender/tool/vector","../util/ndarray","../chart"],function(e){function t(t,i,s,o){function J(){var e=o.legend;H=1,z=i.getWidth(),W=i.getHeight(),X=[z/2,W/2];for(var t=0,n=g.length;t<n;t++){var r=g[t];if(r.type===f.CHART_TYPE_FORCE){g[t]=m.reformOption(g[t]),y=r;var s=m.deepQuery([r],"minRadius"),u=m.deepQuery([r],"maxRadius");R=m.deepQuery([r],"attractiveness"),j=m.deepQuery([r],"density"),F=m.deepQuery([r],"initSize"),q=m.deepQuery([r],"centripetal"),I=m.deepQuery([r],"coolDown"),E=m.deepQuery([r],"categories");for(var a=0,l=E.length;a<l;a++)E[a].name&&(e?m.selectedMap[a]=e.isSelected(E[a].name):m.selectedMap[a]=!0);T=m.deepQuery([r],"itemStyle.normal.linkStyle"),N=m.deepQuery([r],"itemStyle.emphasis.linkStyle"),S=m.deepQuery([r],"itemStyle.normal.nodeStyle"),x=m.deepQuery([r],"itemStyle.emphasis.nodeStyle"),K(p.clone(m.deepQuery([r],"nodes")),p.clone(m.deepQuery([r],"links"))),_=[],D=[],P=[],L=[],A=[],P=[],b=[],w=[];var c=z*W;B=.5/R*Math.sqrt(c/C.length),G(C,k),Q(C,s,u)}}}function K(e,t){var n=[],i=0;C=r(e,function(e,t){if(!e)return;if(m.selectedMap[e.category])return n[t]=i++,!0;n[t]=-1});var s,o,u;k=r(t,function(e){return s=e.source,o=e.target,u=!0,n[s]>=0?e.source=n[s]:u=!1,n[o]>=0?e.target=n[o]:u=!1,u})}function Q(e,t,r){var s=[],o=e.length;for(var u=0;u<o;u++){var a=e[u];s.push(a.value)}var f=new v(s);s=f.map(t,r).toArray();var c=f.max();c!==0&&(L=f.mul(1/c,f).toArray());for(var u=0;u<o;u++){var a=e[u],h,d,g=s[u],w=n(z/2,W/2,F);h=typeof a.initial=="undefined"?w.x:a.initial.x,d=typeof a.initial=="undefined"?w.y:a.initial.y,_[u]=[h,d],D[u]=[h,d],O[u]=[0,0],M[u]=[0,0],P[u]=g*g*j*.035;var T={id:i.newShapeId(m.type),shape:"circle",style:{r:g,x:0,y:0},highlightStyle:{},position:[h,d],__forceIndex:u},N;m.deepQuery([y],"itemStyle.normal.label.show")&&(T.style.text=a.name,T.style.textPosition="inside",N=m.deepQuery([y],"itemStyle.normal.label.textStyle")||{},T.style.textColor=N.color||"#fff",T.style.textAlign=N.align||"center",T.style.textBaseLine=N.baseline||"middle",T.style.textFont=m.getFont(N)),m.deepQuery([y],"itemStyle.emphasis.label.show")&&(T.highlightStyle.text=a.name,T.highlightStyle.textPosition="inside",N=m.deepQuery([y],"itemStyle.emphasis.label.textStyle")||{},T.highlightStyle.textColor=N.color||"#fff",T.highlightStyle.textAlign=N.align||"center",T.highlightStyle.textBaseLine=N.baseline||"middle",T.highlightStyle.textFont=m.getFont(N)),p.merge(T.style,S),p.merge(T.highlightStyle,x);if(typeof a.category!="undefined"){var C=E[a.category];if(C){var k=C.itemStyle;k&&(k.normal&&p.merge(T.style,k.normal,{overwrite:!0}),k.emphasis&&p.merge(T.highlightStyle,k.emphasis,{overwrite:!0}))}}if(typeof a.itemStyle!="undefined"){var k=a.itemStyle;k.normal&&p.merge(T.style,k.normal,{overwrite:!0}),k.normal&&p.merge(T.highlightStyle,k.emphasis,{overwrite:!0})}m.setCalculable(T),T.ondragstart=m.shapeHandler.ondragstart,T.draggable=!0,b.push(T),m.shapeList.push(T),i.addShape(T);var A="";if(typeof a.category!="undefined"){var C=E[a.category];A=C&&C.name||""}l.pack(T,{name:A},0,a,0,a.name||"")}}function G(e,t){var n=t.length;for(var r=0;r<n;r++){var s=t[r],o=s.weight||1;A.push(o);var u={id:i.newShapeId(m.type),shape:"line",style:{xStart:0,yStart:0,xEnd:0,yEnd:0},highlightStyle:{}};p.merge(u.style,T),p.merge(u.highlightStyle,N),typeof s.itemStyle!="undefined"&&(s.itemStyle.normal&&p.merge(u.style,s.itemStyle.normal,{overwrite:!0}),s.itemStyle.emphasis&&p.merge(u.highlightStyle,s.itemStyle.emphasis,{overwrite:!0})),w.push(u),m.shapeList.push(u),i.addShape(u)}var a=new v(A),f=a.max();f!==0&&(A=a.mul(1/f,a).toArray())}function Y(){for(var e=0,t=k.length;e<t;e++){var n=k[e],r=w[e],i=b[n.source],s=b[n.target];r.style.xStart=i.position[0],r.style.yStart=i.position[1],r.style.xEnd=s.position[0],r.style.yEnd=s.position[1]}}function Z(e){var t=_.length,n=[],r=B*B;for(var i=0;i<t;i++)O[i][0]=0,O[i][1]=0;for(var i=0;i<t;i++)for(var s=i+1;s<t;s++){var o=L[i],u=L[s],a=_[i],f=_[s];d.sub(n,f,a);var l=d.length(n);if(l>500)continue;l<5&&(l=5),d.scale(n,n,1/l);var c=1*(o+u)*r/l;d.scale(n,n,c),d.sub(O[i],O[i],n),d.add(O[s],O[s],n)}for(var i=0,h=k.length;i<h;i++){var p=k[i],v=A[i],m=p.source,g=p.target,a=_[m],f=_[g];d.sub(n,f,a);var y=d.lengthSquare(n);d.normalize(n,n);var c=v*y/B;d.scale(n,n,c),d.add(O[m],O[m],n),d.sub(O[g],O[g],n)}for(var i=0,h=C.length;i<h;i++){var w=_[i];d.sub(n,X,w);var y=d.lengthSquare(n);d.normalize(n,n);var c=y/100*q;d.scale(n,n,c),d.add(O[i],O[i],n)}for(var i=0,h=M.length;i<h;i++)d.scale(M[i],O[i],1/P[i]);var E=[],S=[];for(var i=0,h=_.length;i<h;i++){if(C[i].fixed){_[i][0]=V,_[i][1]=$,D[i][0]=V,D[i][1]=$,b[i].position[0]=V,b[i].position[1]=$;continue}var w=_[i],x=D[i];d.sub(E,w,x),x[0]=w[0],x[1]=w[1],d.add(E,E,d.scale(S,M[i],e)),d.scale(E,E,H),E[0]=Math.max(Math.min(E[0],100),-100),E[1]=Math.max(Math.min(E[1],100),-100),d.add(w,w,E),b[i].position[0]=w[0],b[i].position[1]=w[1];if(isNaN(w[0])||isNaN(w[1]))throw new Error("NaN")}}function et(){if(H<.01)return;Z(U),Y();for(var e=0;e<b.length;e++){var t=b[e];i.modShape(t.id,t)}for(var e=0;e<w.length;e++){var t=w[e];i.modShape(t.id,t)}i.refresh(),H*=I}function nt(e,t){function n(){tt&&(et(),setTimeout(n,U*1e3))}s=e,o=t,g=s.series,m.clear(),J(),tt=!0,setTimeout(n,U*1e3)}function rt(e){e&&(s=e,g=s.series),m.clear(),J(),H=1}function it(){tt=!1}function st(e){if(!m.isDragstart||!e.target)return;var t=e.target,n=t.__forceIndex,r=C[n];r.fixed=!0,m.isDragstart=!1,i.on(c.EVENT.MOUSEMOVE,ut)}function ot(e,t){if(!m.isDragend||!e.target)return;var n=e.target,r=n.__forceIndex,s=C[r];s.fixed=!1,t.dragIn=!0,t.needRefresh=!1,m.isDragend=!1,i.un(c.EVENT.MOUSEMOVE,ut)}function ut(e){H=.8,V=h.getX(e.event),$=h.getY(e.event)}var u=e("../component/base");u.call(this,i);var a=e("./calculableBase");a.call(this,i,s);var f=e("../config"),l=e("../util/ecData"),c=e("zrender/config"),h=e("zrender/tool/event"),p=e("zrender/tool/util"),d=e("zrender/tool/vector"),v=e("../util/ndarray"),m=this;m.type=f.CHART_TYPE_FORCE;var g,y,b=[],w=[],E=[],S,x,T,N,C=[],k=[],L=[],A=[],O=[],M=[],_=[],D=[],P=[],H,B,j,F,I,q,R,U=1/60,z,W,X=[],V,$,tt;m.shapeHandler.ondragstart=function(){m.isDragstart=!0},m.init=nt,m.refresh=rt,m.ondragstart=st,m.ondragend=ot,m.dispose=it,nt(s,o)}function n(e,t,n){return{x:(Math.random()-.5)*n+e,y:(Math.random()-.5)*n+t}}function r(e,t){var n=e.length,r=[];for(var i=0;i<n;i++)t(e[i],i)&&r.push(e[i]);return r}return e("../chart").define("force",t),t}),define("echarts/util/mapData/params",["require"],function(e){function t(e){if(!e.UTF8Encoding)return e;var t=e.features;for(var r=0;r<t.length;r++){var i=t[r],s=i.geometry.coordinates,o=i.geometry.encodeOffsets;for(var u=0;u<s.length;u++){var a=s[u];if(i.geometry.type==="Polygon")s[u]=n(a,o[u]);else if(i.geometry.type==="MultiPolygon")for(var f=0;f<a.length;f++){var l=a[f];a[f]=n(l,o[u][f])}}}return e.UTF8Encoding=!1,e}function n(e,t){var n=[],r=t[0],i=t[1];for(var s=0;s<e.length;s+=2){var o=e.charCodeAt(s)-64,u=e.charCodeAt(s+1)-64;o=o>>1^-(o&1),u=u>>1^-(u&1),o+=r,u+=i,r=o,i=u,n.push([o/1024,u/1024])}return n}return{china:{loc:[102,36.7],box:[-1174.6445229087194,-1437.3577680805693,3039.3970214233723,2531.19589698184],getData:function(n){e(["./china/0"],function(e){n(t(e))})}},"新疆":{loc:[84.9023,41.748],box:[-1174.9404317915883,-1136.0130934711678,1216.4169237052663,939.4360818385251],getData:function(n){e(["./china/65"],function(e){n(t(e))})}},"西藏":{loc:[88.7695,31.6846],box:[-1061.2905098655508,-273.40253896102865,1182.4138890465167,728.4762434212385],getData:function(n){e(["./china/54"],function(e){n(t(e))})}},"内蒙古":{loc:[110.5977,45.3408],box:[81.92106433333947,-1404.5655158641246,1337.913665139638,1168.7030286278964],getData:function(n){e(["./china/15"],function(e){n(t(e))})}},"青海":{loc:[96.2402,35.4199],box:[-398.0407413665446,-404.86540158240564,770.5429460357634,553.4881569694239],getData:function(n){e(["./china/63"],function(e){n(t(e))})}},"四川":{loc:[102.9199,30.1904],box:[34.77351011413543,-24.727858097581816,654.265749584143,581.5837904142871],getData:function(n){e(["./china/51"],function(e){n(t(e))})}},"黑龙江":{loc:[128.1445,48.5156],box:[1185.0861642873883,-1435.9087566254907,680.9449423479143,618.3772597960831],getData:function(n){e(["./china/23"],function(e){n(t(e))})}},"甘肃":{loc:[99.7129,37.866],box:[-197.5222870378875,-631.2015222269291,884.6861134736321,734.2542202456989],getData:function(n){e(["./china/62"],function(e){n(t(e))})}},"云南":{loc:[101.8652,25.1807],box:[-4.030270169151834,326.89754492870105,561.4971786143803,565.9079094851168],getData:function(n){e(["./china/53"],function(e){n(t(e))})}},"广西":{loc:[108.2813,23.6426],box:[444.4355364538484,524.7911424174906,490.6548359068431,384.1667316158848],getData:function(n){e(["./china/45"],function(e){n(t(e))})}},"湖南":{loc:[111.5332,27.3779],box:[716.7125751678784,265.3988842488122,346.1702652872375,377.50144051998274],getData:function(n){e(["./china/43"],function(e){n(t(e))})}},"陕西":{loc:[108.5996,35.6396],box:[508.5948583446903,-399.56997062473215,321.038690321553,559.1002147021181],getData:function(n){e(["./china/61"],function(e){n(t(e))})}},"广东":{loc:[113.4668,22.8076],box:[790.2032875493967,572.9640361040085,494.8279567104971,388.7112686526252],getData:function(n){e(["./china/44"],function(e){n(t(e))})}},"吉林":{loc:[126.4746,43.5938],box:[1287.5729431804648,-950.943295028444,504.33243011403374,354.162667814153],getData:function(n){e(["./china/22"],function(e){n(t(e))})}},"河北":{loc:[115.4004,39.3688],box:[940.0156020671719,-646.4007207319194,325.33903805510784,477.4542727272415],getData:function(n){e(["./china/13"],function(e){n(t(e))})}},"湖北":{loc:[112.2363,31.1572],box:[683.8325394595918,45.82949601748078,468.66717545627034,295.2142095820616],getData:function(n){e(["./china/42"],function(e){n(t(e))})}},"贵州":{loc:[106.6113,26.9385],box:[392.5021834497175,337.4483828727408,375.50579966539516,320.9420464446699],getData:function(n){e(["./china/52"],function(e){n(t(e))})}},"山东":{loc:[118.7402,36.4307],box:[1035.7855473594757,-382.19242168799906,412.5747391303373,313.152767793266],getData:function(n){e(["./china/37"],function(e){n(t(e))})}},"江西":{loc:[116.0156,27.29],box:[1012.6841751377355,236.50140310944056,295.599802392515,400.86430917822287],getData:function(n){e(["./china/36"],function(e){n(t(e))})}},"河南":{loc:[113.4668,33.8818],box:[785.5419798731749,-185.2911232263814,362.6977821251186,340.3902676066224],getData:function(n){e(["./china/41"],function(e){n(t(e))})}},"辽宁":{loc:[122.3438,41.0889],box:[1203.0641741691293,-757.0946871553339,352.71788824534656,357.71276541155214],getData:function(n){e(["./china/21"],function(e){n(t(e))})}},"山西":{loc:[112.4121,37.6611],box:[776.5185040689469,-493.6204506126494,212.68572802329425,448.08485211774945],getData:function(n){e(["./china/14"],function(e){n(t(e))})}},"安徽":{loc:[117.2461,32.0361],box:[1054.014965660052,-80.43770626104327,295.73127466484925,352.03731065611606],getData:function(n){e(["./china/34"],function(e){n(t(e))})}},"福建":{loc:[118.3008,25.9277],box:[1172.0955040211252,341.81292779438445,288.99462739279807,339.42845011348845],getData:function(n){e(["./china/35"],function(e){n(t(e))})}},"浙江":{loc:[120.498,29.0918],box:[1272.1789620983063,123.46272678646208,286.17816622252326,286.73860446060394],getData:function(n){e(["./china/33"],function(e){n(t(e))})}},"江苏":{loc:[119.0586,32.915],box:[1125.161343490302,-134.97368204682834,356.1806346879009,291.4961628010442],getData:function(n){e(["./china/32"],function(e){n(t(e))})}},"重庆":{loc:[107.7539,30.1904],box:[497.78832088614774,127.0051229616378,291.91221530072164,280.8880182020781],getData:function(n){e(["./china/50"],function(e){n(t(e))})}},"宁夏":{loc:[105.9961,37.3096],box:[441.193675072408,-376.31946967355213,183.76989823787306,293.0024551112753],getData:function(n){e(["./china/64"],function(e){n(t(e))})}},"海南":{loc:[109.9512,19.2041],box:[723.8031601361929,946.050886515855,183.33374783084207,147.66048518654895],getData:function(n){e(["./china/46"],function(e){n(t(e))})}},"台湾":{loc:[120.7254,23.5986],box:[1459.925544038912,519.7445429876257,103.06085087505835,237.80851484008463],getData:function(n){e(["./china/71"],function(e){n(t(e))})}},"北京":{loc:[116.4551,40.2539],box:[1031.6052083127613,-530.1928574952913,103.23943439987329,114.66079087790081],getData:function(n){e(["./china/11"],function(e){n(t(e))})}},"天津":{loc:[117.2219,39.4189],box:[1106.9649995752443,-479.16508616378724,71.21176554916747,120.01987096046025],getData:function(n){e(["./china/12"],function(e){n(t(e))})}},"上海":{loc:[121.4648,31.2891],box:[1420.334836525578,71.79837578328207,70.41721601016525,81.99461244072737],getData:function(n){e(["./china/31"],function(e){n(t(e))})}},"香港":{loc:[114.2578,22.3242],box:[1061.983645387268,769.0837862603122,50.65584483626753,32.17422147262721],getData:function(n){e(["./china/81"],function(e){n(t(e))})}},"澳门":{loc:[113.5547,22.1604],box:[1043.1350056914507,798.0786255550063,5.387452843479423,7.564113979470676],getData:function(n){e(["./china/82"],function(e){n(t(e))})}}}}),define("echarts/util/mapData/textFixed",[],function(){return{"香港":[5,15,732],"澳门":[-15,15,732],"北京":[-10,0,732],"天津":[0,5,732],"上海":[0,5,732],"山西":[-10,0,732],"河南":[-10,0,732],"河北":[-10,-5,732],"山东":[-10,0,732],"安徽":[-10,0,732],"江西":[-15,-5,732],"浙江":[-10,0,732],"福建":[-10,0,732],"江苏":[-10,0,732],"湖南":[-10,0,732],"陕西":[-15,20,732],"黑龙江":[0,15,732],"深圳市":[-40,0,4772],"红河哈尼族彝族自治州":[0,20,3277],"楚雄彝族自治州":[-5,15,3277],"巴彦淖尔市":[-10,0,1587],"彭水苗族土家族自治县":[0,15,6604],"荣昌县":[0,15,6604],"渝北区":[0,10,6604],"石河子市":[-5,5,1974],"五家渠市":[10,5,1974],"图木舒克市":[15,10,1974]}}),define("echarts/chart/map",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/util","../util/mapData/params","../util/mapData/textFixed","../chart"],function(e){function t(t,n,r,i){function b(){l.selectedMap={};var e=i.legend,t,n={},r,s,o,a={};p={};var f={};for(var h=0,d=c.length;h<d;h++)if(c[h].type==u.CHART_TYPE_MAP){c[h]=l.reformOption(c[h]),r=c[h].mapType,a[r]=a[r]||{},a[r][h]=!0,p[r]=p[r]||c[h].selectedMode,f[r]=f[r]||c[h].mapValueCalculation,t=c[h].name,l.selectedMap[t]=e?e.isSelected(t):!0;if(l.selectedMap[t]){n[r]=n[r]||{},s=c[h].data;for(var v=0,y=s.length;v<y;v++){o=s[v].name,n[r][o]=n[r][o]||{seriesIndex:[]};for(var b in s[v])b!="value"?n[r][o][b]=s[v][b]:isNaN(s[v].value)||(typeof n[r][o].value=="undefined"&&(n[r][o].value=0),n[r][o].value+=s[v].value);n[r][o].seriesIndex.push(h)}}}m=0;for(var E in n){if(f[E]&&f[E]=="average")for(var y in n[E])n[E][y].value=n[E][y].value/n[E][y].seriesIndex.length,n[E][y].value>10?n[E][y].value=Math.round(n[E][y].value):n[E][y].value=n[E][y].value.toFixed(2)-0;g[E].getData&&g[E].getData(w(E,n[E],a[E]))}}function w(e,t,r){return m++,function(i){N(e,E(g[e].box,g[e].loc,i,r),t,r);if(--m<=0){for(var s=0,o=l.shapeList.length;s<o;s++)l.shapeList[s].id=n.newShapeId(l.type),n.addShape(l.shapeList[s]);n.refresh()}}}function E(e,t,n,r){var i=n.features,s=[],o,u,a,f=S(e[2],e[3],3500,r),l=x().origin(t).scale(f.scale).translate(f.translate),c=T().projection(l);for(var h=0,p=i.length;h<p;h++)u=l(i[h].properties.cp),a=y[i[h].properties.name],typeof a!="undefined"&&(u[0]+=a[0]*f.scale/a[2],u[1]+=a[1]*f.scale/a[2]),o={text:i[h].properties.name,path:c(i[h]),textX:u[0],textY:u[1]},s.push(o);return s}function S(e,t,r,i){var s,o,u,a,f,l,h,p=n.getWidth(),d=n.getHeight();for(var v in i)s=c[v].mapLocation,u=s.x||u,f=s.y||f,l=s.width||l,h=s.height||h;o=isNaN(u)?0:u,a=isNaN(f)?0:f,typeof l=="undefined"&&(l=p,o+l>p&&(l=p-o)),typeof h=="undefined"&&(h=d,a+h>d&&(h=d-a));var m=Math.min(l/e,h/t);l=e*m,h=t*m;if(isNaN(u))switch(u+""){case"center":o=Math.floor((p-l)/2);break;case"right":o=p-l;break;default:o=0}if(isNaN(f))switch(f+""){case"center":a=Math.floor((d-h)/2);break;case"bottom":a=d-h;break;default:a=0}return{scale:m*r,translate:[o+l/2,a+h/2]}}function x(){function f(t){var n=o*(e*t[0]-s),f=Math.sqrt(u-2*o*Math.sin(e*t[1]))/o;return[r*f*Math.sin(n)+i[0],r*(f*Math.cos(n)-a)+i[1]]}function l(){var r=e*n[0],i=e*n[1],l=e*t[1],c=Math.sin(r),h=Math.cos(r);return s=e*t[0],o=.5*(c+Math.sin(i)),u=h*h+2*o*c,a=Math.sqrt(u-2*o*Math.sin(l))/o,f}var e=Math.PI/180,t=[0,0],n=[29.5,45.5],r=1e3,i=[0,0],s,o,u,a;return f.invert=function(t){var n=(t[0]-i[0])/r,f=(t[1]-i[1])/r,l=a+f,c=Math.atan2(n,l),h=Math.sqrt(n*n+l*l);return[(s+c/o)/e,Math.asin((u-h*h*o*o)/(2*o))/e]},f.origin=function(e){return arguments.length?(t=[+e[0],+e[1]],l()):t},f.parallels=function(e){return arguments.length?(n=[+e[0],+e[1]],l()):n},f.scale=function(e){return arguments.length?(r=+e,f):r},f.translate=function(e){return arguments.length?(i=[+e[0],+e[1]],f):i},l()}function T(){function r(e){return"m0,"+e+"a"+e+","+e+" 0 1,1 0,"+ -2*e+"a"+e+","+e+" 0 1,1 0,"+2*e+"z"}function i(e,t){return function(n){return n&&n.type in e?e[n.type](n):t}}function s(n){return typeof e=="function"&&(t=r(e.apply(this,arguments))),u(n)||null}function o(e){return n(e).join(",")}var e=4.5,t=r(e),n,u=i({FeatureCollection:function(e){var t=[],n=e.features,r=-1,i=n.length;while(++r<i)t.push(u(n[r].geometry));return t.join("")},Feature:function(e){return u(e.geometry)},Point:function(e){return"M"+o(e.coordinates)+t},MultiPoint:function(e){var n=[],r=e.coordinates,i=-1,s=r.length;while(++i<s)n.push("M",o(r[i]),t);return n.join("")},LineString:function(e){var t=["M"],n=e.coordinates,r=-1,i=n.length;while(++r<i)t.push(o(n[r]),"L");return t.pop(),t.join("")},MultiLineString:function(e){var t=[],n=e.coordinates,r=-1,i=n.length,s,u,a;while(++r<i){s=n[r],u=-1,a=s.length,t.push("M");while(++u<a)t.push(o(s[u]),"L");t.pop()}return t.join("")},Polygon:function(e){var t=[],n=e.coordinates,r=-1,i=n.length,s,u,a;while(++r<i){s=n[r],u=-1;if((a=s.length-1)>0){t.push("M");while(++u<a)t.push(o(s[u]),"L");t[t.length-1]="Z"}}return t.join("")},MultiPolygon:function(e){var t=[],n=e.coordinates,r=-1,i=n.length,s,u,a,f,l,c;while(++r<i){s=n[r],u=-1,a=s.length;while(++u<a){f=s[u],l=-1;if((c=f.length-1)>0){t.push("M");while(++l<c)t.push(o(f[l]),"L");t[t.length-1]="Z"}}}return t.join("")},GeometryCollection:function(e){var t=[],n=e.geometries,r=-1,i=n.length;while(++r<i)t.push(u(n[r]));return t.join("")}});return s.projection=function(e){return n=e,s},s.pointRadius=function(n){return typeof n=="function"?e=n:(e=+n,t=r(e)),s},s}function N(e,t,n,r){var s=i.legend,o=i.dataRange,m,g,y,b,w,E=u.map,S,x,T,N,C,k;for(var L=0,A=t.length;L<A;L++){T=f.clone(t[L]),N=f.clone(T),g=T.text,y=n[g];if(y){w=[y],m="";for(var O=0,M=y.seriesIndex.length;O<M;O++)w.push(c[y.seriesIndex[O]]),m+=c[y.seriesIndex[O]].name+" ",s&&s.hasColor(c[y.seriesIndex[O]].name)&&l.shapeList.push({shape:"circle",zlevel:h+1,style:{x:T.textX+3+O*7,y:T.textY-10,r:3,color:s.getColor(c[y.seriesIndex[O]].name)},hoverable:!1});w.push(E),b=y.value}else{y="-",m="",w=[];for(var _ in r)w.push(c[_]);w.push(E),b="-"}T.text=="香港"||T.text=="澳门"?k=!0:k=!1,S=o&&!isNaN(b)?o.getColor(b):null;var D;T.brushType="both",T.color=S||l.deepQuery(w,"itemStyle.normal.areaStyle.color"),T.strokeColor=l.deepQuery(w,"itemStyle.normal.lineStyle.color"),T.lineWidth=l.deepQuery(w,"itemStyle.normal.lineStyle.width"),l.deepQuery(w,"itemStyle.normal.label.show")&&(T.text=g,T.textColor=l.deepQuery(w,"itemStyle.normal.label.textStyle.color"),x=l.deepQuery(w,"itemStyle.normal.label.textStyle"),T.textFont=l.getFont(x),T.textPosition="specific",D={shape:"text",zlevel:h+1,hoverable:k,clickable:k,style:{brushType:"both",x:T.textX,y:T.textY,text:T.text,color:T.textColor,strokeColor:"rgba(0,0,0,0)",textFont:T.textFont}},D._style=f.clone(D.style)),T.textColor="rgba(0,0,0,0)",N.brushType="both",N.color=l.deepQuery(w,"itemStyle.emphasis.areaStyle.color")||T.color,N.strokeColor=l.deepQuery(w,"itemStyle.emphasis.lineStyle.color")||T.strokeColor,N.lineWidth=l.deepQuery(w,"itemStyle.emphasis.lineStyle.width")||T.lineWidth,l.deepQuery(w,"itemStyle.emphasis.label.show")?(N.text=g,N.textColor=l.deepQuery(w,"itemStyle.emphasis.label.textStyle.color")||T.textColor,x=l.deepQuery(w,"itemStyle.emphasis.label.textStyle")||x,N.textFont=l.getFont(x),N.textPosition="specific",D&&(D.highlightStyle={brushType:"both",x:T.textX,y:T.textY,text:T.text,color:N.textColor,strokeColor:"yellow",textFont:N.textFont})):N.textColor="rgba(0,0,0,0)";if(D){if(p[e]&&d[g]||y&&y.selected&&d[g]!==!1)D.style=f.clone(D.highlightStyle);p[e]&&D.clickable&&(D.onclick=l.shapeHandler.onclick),D._mapType=e,a.pack(D,{name:m,tooltip:l.deepQuery(w,"tooltip")},0,y,0,g),l.shapeList.push(D)}C={shape:"path",zlevel:h,clickable:!0,style:T,highlightStyle:N,_style:f.clone(T),_mapType:e};if(p[e]&&d[g]||y&&y.selected&&d[g]!==!1)C.style=f.clone(C.highlightStyle);p[e]&&(d[g]=typeof d[g]!="undefined"?d[g]:y&&y.selected,v[g]=e,C.onclick=l.shapeHandler.onclick),a.pack(C,{name:m,tooltip:l.deepQuery(w,"tooltip")},0,y,0,g),l.shapeList.push(C)}}function C(e){if(!l.isClick||!e.target)return;var r=e.target,i=r.style.text,s=l.shapeList.length,o=r._mapType||"";if(p[o]=="single")for(var a in d)if(d[a]&&v[a]==o){for(var c=0;c<s;c++)l.shapeList[c].style.text==a&&(l.shapeList[c].style=l.shapeList[c]._style,n.modShape(l.shapeList[c].id,l.shapeList[c]));a!=i&&(d[a]=!1)}d[i]=!d[i];for(var c=0;c<s;c++)l.shapeList[c].style.text==i&&(d[i]?l.shapeList[c].style=f.clone(l.shapeList[c].highlightStyle):l.shapeList[c].style=l.shapeList[c]._style,n.modShape(l.shapeList[c].id,l.shapeList[c]));t.dispatch(u.EVENT.MAP_SELECTED,e.event,{selected:d}),n.refresh()}function k(e,t){i=t,d={},v={},L(e)}function L(e){e&&(r=e,c=r.series),l.clear(),b()}function A(e,t){i.dataRange&&(L(),t.needRefresh=!0);return}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/util"),l=this;l.type=u.CHART_TYPE_MAP;var c,h=l.getZlevelBase(),p,d={},v={},m,g=e("../util/mapData/params"),y=e("../util/mapData/textFixed");l.init=k,l.refresh=L,l.ondataRange=A,l.onclick=C,k(r,i)}return e("../chart").define("map",t),t}),define("echarts/util/mapData/china/0",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"65",properties:{name:"新疆",cp:[84.9023,41.748],childNum:18},geometry:{type:"Polygon",coordinates:["@@@ρȁôƧƦóəʵסʵóƪԫʵѵͩƧͩړυࡓɛʵ@ȃ@óᇑѵƨɝɚôóНѺͩɜ̏ԭʵôƧɞñ@υƩ݇ȂóƩƧ@ѵȂυƥŌਗ॥ɛóʵѵƧѹ݇̍ࢯəɞυρͩ̏óਙƨƧŋôōó̍ͩóʵןóŋړͪƧѶ@ɜԭԫƦɛȄ̍ɝȄöςƩȂ̏ñȀ̏ƩóóŎə@Ő̎@ɞȀɝŎôƨóנѵȄƧ@óŏɝóɜôŎ̍ͨςŎ@ƨóôƨɞ݈ʶóƨφó̎Ȁƨ̍ԮòѸԮמ@ѺȀ@ƪၬֆòȂñ̐òȂɜóƨ̒Ŏ̑߼@φρȀ@Ő๐ς̎Ƨφ@ɝφڔ೦Ԯǿࢰ@ƦŏԮƨƨȄƧ۬ɜʶڔŐɚɚóŐôƨ߼ôƧƧó̐ƥóŏѺǿƦȁφƧςƨƧ̒@ɜƥƦυ̐ɛƪͩƩəƪʷ̑ə@ȃƨʵנŋྸōਚԭԪ@ɝƨŋ̒օςʵôƧ"],encodeOffsets:[[98730,43786]]}},{type:"Feature",id:"54",properties:{name:"西藏",cp:[88.7695,31.6846],childNum:7},geometry:{type:"Polygon",coordinates:["@@ôŌנôʶ̎ͪôóŎƨŌਚƧ̐ôςͪφɚɝࢰ݈̎ѺѶƨôʶ०ɜਘƦŋφѶȁ̍ôŏɚŋ@̑ə@ŏò̍ɜóƥôʷƧ̍φѹԪ̍ע@Ѹʷɜ@ôñנ@Ѷɛɞô̐ŏѶƨѸƧƥōƦôŏô@ƧôƩ̒ŋƨŌƦǿô̎ɜȁ̒óʶѶôôО̒ςƥɜНφσɛȁ̎υƨఱƧŏ@ʵƥ@ŌóóóͩƨƧóŋ̑õóɞóɝԩͪɝρôƧ̍ƧѹͨڑŎ̑ōóƧࢭͩ̏ѵɝóఱóóԪυô@̒ƥŌ̏Ƨ̑Ȅ݇ŎƧѵӏ@ɛõŏɛȄôӒƧŌѵǿɝƧŋԫ@̏ʴƥ@óǿ̑Ȁóǿ̍ςóóυô@ʶɛñρƦƩŐó̎óѵó̑ͪࢯОóɜןƧ̏ƥȄ߻̎̏̐ןŎɝɜöɞƩȀôöɛȀóͪ̐ƨƪ̍̎ȂƥԪυО@φɞôƪ"],encodeOffsets:[[80911,35146]]}},{type:"Feature",id:"15",properties:{name:"内蒙古",cp:[117.5977,44.3408],childNum:12},geometry:{type:"Polygon",coordinates:["@@ኊȁ૊ö߼ƩɜɛנñԮɛѶóԮô@ȁѸóמ̎ගѺၬ@߼ʶԮӒ߼̎@ŐѹӒ̒Ԫƨöග̑ѶȄ̒ς।ѶɚöɞɜʴڔôôȂ̎ѺȀςƨƪóԪɜôɛОਕڔԭѵ̍ѹȂԫɛƥ̍Ȃóɜ̎ô@ʶ݊ੲࢮʵږͪנƨôȂƧ̐ͪ@ŐƦƨφԬѶɜôƦ@ŐƧôôƦəŐ̏@ŐڒѶԬô̐ʳԩНςōôŏɞ@ƨȂѶəóƧ̒ػ̎ó̐Őנóƨô̒@ƨɚɚ@עԫɛɛ@ȁυͩƥʳòևρ̑ࡗƧͪ༃ॣԮփ̎Ʀ@ôô@ôō@@ȁѵóƨ̍υȃóʵɛƨƥóυȂóəƪ̐ρƧͩɜԭڔȄ̎عƧȁ̐ŏó̍ɛƥƧ̑óρŐ@Ƨ̏ɝəɛ߻ͩ̍ͩɝО̍ƪƧóóӓƨóƧʳ݇@ɝςƪ@ʴƩƧƦôƨɛȄəƧŋυóͩѵ@ɝǿóŌן̍ɛóО̍̑̏ôȁ̍ŏòȁñóƦͩ@ǿə@ɛƧ̑ρȁυô̍օѹóȃə@ȂσʵѷƪòƩ̍ôó߻ۯôʳƧóõʵѵóѹɜ̍ȂѹôɛŌφֈƩͨρóυӑóޟఱ̑݇ͪóƪƨŌóȄڔԬƩςםñ̑ȃѵŐԭŏƨȁɛǿρôõɚɛóƧОə@ѹ̐ѵöԪͨôͪɛ̒ןŏƧƥóôƥƧɛŌôóɝó@̒݇Ӓ̒Ō@Ŏԭࢰ"],encodeOffsets:[[99540,43830]]}},{type:"Feature",id:"63",properties:{name:"青海",cp:[96.2402,35.4199],childNum:8},geometry:{type:"Polygon",coordinates:["@@ƨ@ôƪ݈ȁƪ@φɝòóƨԮʶɛ̐ѹͪôОəóƧɞᇒѶ@ôږô@ǿѶƪȁςɜͩφςŋɞôѶɛƨŌɞ@ɚςŐñԪॢͩƨȂɞóƨŐ̎ŏעӏ̎óƧƦô̒ȁɜςͩ̒ɚɛƨôƨɝφɛóȁƨŋóóɚͩƨóóƩ@ƧəŋƦƩ̍@ƧƧôǿυ̑@ȁɞǿõŏρƥסɚƧóτԫɞôƧƦ@ñȃòñƥóυôôѹѵ@ŏ̏Ȅɝó@ȂəŌóəѹƦ@Ő̍Ōυ݈ԩŐƧóôƧ̑ôʵɞƧ̑ѵôƩɞƧ̑óНѵóôʵ̑ɛȂó̍ƥȀƧŋ̑Ōóƪ@ƨóóŐƥƦŎѷƨѵƧ̏Őɝóѵɜן@óòɛ@ѷʸס@ԩ̎υѺƨ̎óʸôƦɛñ̎@Őɚ@̒əŌóŐ̎"],encodeOffsets:[[91890,36945]]}},{type:"Feature",id:"51",properties:{name:"四川",cp:[102.9199,30.1904],childNum:21},geometry:{type:"Polygon",coordinates:["@@ôôŋó̑Ԯ̒ɛОמͪƨōöͫ߼ƥôȃƨóóñôƧóƧôōڔŏƨŐ@ŎôòƥѺŎ@ōɜóנôǿôƦôԮ̍ɜôɚƧñɛɚȁ̍Ƨɛևυ@óóôŋρԭɝ@Ƨʸ̍ŏυɜƧƧóƧƨȁρ̍ƨȃɚôʵφóô̑̏Ȃ̑ʵɜʵɞ@ƨʳסƩóŎəóɜƧôƩƧρóôôô@ŎƧƨƨƪѹó̍̍Ʃ@̏ѹНôޟ̍ƩóƪυɝɛəƨôŎɛȀ@Ȃ@ñɝʶ@Ōρנ̏õóɛͨƨȂѵОɛʵ@̏ƩŐó߼Ƨల̍φɜȂυτɛОρƦɝƨóƪ̒Ѷɝƨóʶ̒óƨƨôԪŏφ݇̎ŋ@ŏѺƥôɚɚŋ@ȁɞô̐ȃ@ŐѶóѺφóƦôñòòȄ"],encodeOffsets:[[104220,34336]]}},{type:"Feature",id:"23",properties:{name:"黑龙江",cp:[128.1445,48.5156],childNum:13},geometry:{type:"Polygon",coordinates:["@@ᇔȂਚНƨŐѶŏöƥςŏñƧƦóƨȁ@óƨóȁφӑóóƨóǿ̎̑ôНɞó̑ɜə߼̎ǿ̒ôڒӑφ@Ƨȁ̎̏ƥƩ̎ρశôȂςƨφ@נɞ݈̑ƥƧɛƨʵƧȃƥ@Ƨƥ@ŏ̑ԩôɝρρóɛƧƩͩƧó߻ʸ̍ʷѹƥɞڕõ̍öɝυ̍ȂƧ̐̑ŏóƨñŋѹóóȁ̍̏Ԭõʸ̏ŏ@ǿ̍@ƧОυ@ñƨòȀƥŎ̑ŐѵóɛŌóȂԫōƧŎѹñ̍ʶóОן@Ƨ̎Ѷô@Ȃ@óŎó@@ó̍ƥԭք༄।ƨͩ̒ࡘςñֈƦʴφͪ@ȂɜɜסԬə@Ƨə̑@Ƨóןô̏ŏ̍ô̑ؼôƨѵɚƧȁɝ@óŐρŎԪО̏ʴ"],encodeOffsets:[[124380,54630]]}},{type:"Feature",id:"62",properties:{name:"甘肃",cp:[95.7129,40.166],childNum:14},geometry:{type:"Polygon",coordinates:["@@ڔôԮࢯ@ō̑ŋ݈ӑ@̑ɞôóôɜŋƦƨôóƨƦנŐɜ̑óͩԩͧѶõѺ̏ɚ@ƨНɜôöəςóɜȀƧȂԮŐѶŏ̒ȄמòƪρړԫôȃƧŋôƩ݈ͩɚ@@ǿɜ@φͩóŏɜӑƧōôǿ̎ôƥƪóõö@ôƨôƧƦôó̒ɜ@ɞŌõʶ̏Ő@ȀóôƨȂ@ʶע@@ƥ୾ӑó̑óŋôʵóɛړ@@ƩöóƩóρɛƨ̑@óʷƥƥ̎ɛƧôōƧǿôͩѵôɝȃɞȁõƧρóó@ōƧŏړŐóŎôƨóƨôòƧôóȄ߻ƦõͬƧŎםͩɜНԭ̑ô̒óŌóƥ@óƨɝσԬƨôעəςƦöŐɝȀ@Ȃφ̒óȀƨƨ̎@ƥƪɚŌ@ƨôƪƧôəͪôôƧŌôȂυɜƧɞƧóəɜ̑ρͪɛ̑Ȃóƨƥ̍ôסӐ̍ŐƧŏɝôƧȁॡͪòԩρŏ@əɝƧŋѵɜɝóρŌυɛͪρƩȂѵ@Ȁڕó@ȄɜʶφࡔڔƨͪѶͪԬʶôƩעʶɚʶƥôóƨςȂ"],encodeOffsets:[[98730,43740]]}},{type:"Feature",id:"53",properties:{name:"云南",cp:[101.8652,25.1807],childNum:16},geometry:{type:"Polygon",coordinates:["@@ôɞôɝ̒öôŌƧƨôͪôô@ŋƦ@ʶƨŐô߻ƪŏ@̐ɜʶѶНƧȁɜͧöô̐ςן@ŋɞʵ@ò@ȁɜǿóōɚƧɜφɞôƩ̎ƪóޠѺО@̐̎ƪô̎ѺƧƩƨƧ@ōóóôóςƪƨƨóôɛó̑ԭƥŌɛǿɝƨɛͩô@ǿƨȁѺŌɚɛ̍ןѶНɛƧôóƥȁƦͩôŎɞƨ̑ɜòôφ@ƨʵ@ɛѹōóȃəƨυǿóʵρƧƧŌƩɛ̏ȄñƧƧȀɝ̍ԩʶƧ̑υóŌƥʳɚӑóНƥô̑óӒѵʵѹƧӐןôƪφõŌƪ̒ԫŌƧؼƨƨסρȁƧƨȂóʶó@@ʴƨôôφ̎Ŏ@ȀƨƪɚƨóƨôôôςóޤƧŌƩŋƧԪ"],encodeOffsets:[[100530,28800]]}},{type:"Feature",id:"45",properties:{name:"广西",cp:[108.2813,23.6426],childNum:14},geometry:{type:"Polygon",coordinates:["@@ƦŋѺ̎ڔʵƨŐ@ƦמȄƪôóȂɜŌɚͩɜ@öóɜôôȂƦôɜȁ@ɞφóȄ̎ƨʶɞŋƨʴɚǿ̐̎Ԭ@ôñ@̏ƨρ۫ôɚƨƨНƪŐ̎ƥóƦʵƥŋ@ȃóƥƧ@@ŏɝǿôυƧȁѵɛ@əóŏ̑@@ə̍óƧó@ȁƩρóòНƥô@Ӓ̑@óŎ̍ƥσŎυ@̍ƨ@Ō̑ôóͪƨ̒óŌړ̏Ŏ@ŌôȄѺŎ@ɜƧʶυ@ñóɛƧ̒ɝóōƥͪ"],encodeOffsets:[[107011,25335]]}},{type:"Feature",id:"43",properties:{name:"湖南",cp:[111.5332,27.3779],childNum:14},geometry:{type:"Polygon",coordinates:["@@@քɜОƨ@öŐמóƪôƩɚ̒Ő߼ȁςͩɜòƪɜȀòñɝòѺͪ@ŏƨŋóɝôǿƨɚȃóəƨȃѵͩó̍@ȃƨóóƥƨƧ@ʵƦóͩɜɛóñԭɛōυȂ̍ƧƦō@ɛƥɛȀ̑óʷóō̍ƩŏƧОəƧóς۬Ƨ@̐óòԫ@̏̍əȀƧʳɝŌóɞƧƨɜóŐƨò@ȄƧŌρŋóôԪОóʶ@̎óȄ"],encodeOffsets:[[111870,29161]]}},{type:"Feature",id:"61",properties:{name:"陕西",cp:[109.5996,35.6396],childNum:10},geometry:{type:"Polygon",coordinates:["@@ςôöƨɝȂɞȄѶóóͪƨȀóŎƨ̍ɜƦƦôʸ̒@ɜƧςƪôõô@ƪڔ@ôɜóʶôŌô̒୽Ӓ@Ʀ@Ѻ̎ɜѺɛѶôöʶôƨóʴ߼۰óô̎ñƪѸƩτʶ@ȁòŋəѹóǿ̑ʵ@ȁ̒ʷυփô݉ôН̏ط@ȁƨóô̏ƪõ@ʳ̐ʵ@ɝɛŋƩŌɛóןôƧŋ̒ó@ŏ̐ƥ@ŏυ@ƧƧôן̏@ƥȂѹɜəɛóԭ̎ƥóóóȀןɛô@ŎѹōñƦ"],encodeOffsets:[[108001,33705]]}},{type:"Feature",id:"44",properties:{name:"广东",cp:[113.4668,22.8076],childNum:21},geometry:{type:"Polygon",coordinates:["@@@Ȃôôƨ̎@ɚ̒@ôŐ@ɚѶɜƨȂóφɞȀ@Őƨ@ôƦ@ȄƦŌƥʶƦôôŎôʸ̒ɜǿƦ@ɜƥŎ̎ƨφȁɜŎòƥԮŎƨōóŏɛƧɝəɞƧ߼ɜςȃñȄƦŎ̒ōôòƨəƨɚН@əƨ̏ƪʵυŌəɛóəԭŏəóŏѹρʵɝƦ̏ƥʳѶöō̑óóŋρȀυƧƥɛѹōƧôןɛŏѵ@óŋôʵɝƪԩõ@Ƨō̍@Ƨ@@ƦɝԮƪО@@","@@X¯aWĀ@l"],encodeOffsets:[[112411,21916],[116325,22697]]}},{type:"Feature",id:"22",properties:{name:"吉林",cp:[126.4746,43.5938],childNum:9},geometry:{type:"Polygon",coordinates:["@@נ@ôН̎ʵѺòƨōԬŎôȁɜŋѶô̒ŏƦōñǿòƧφ@ƨН̎@@Ȁ̐Őöʷ̐ԫ̎ôȂѺôòŌôƧ̒Őƨ̏̎ȁφ@ŋƩͩםȃƨ@ȁ̑ʶ@Ōóôɛƥѹ̑συ݇@ɜρƧȃࢯƨôəȂɛōƩɛ̏υρóõƪʴυφ@ʶôŌóρք@ɜƧ@ɝǿƧͪρȀƩó̏ŐƨȂ̍غړȃɛԮƨͪ̏ςƩôɚφȁƦôɜƧôʶφȄ"],encodeOffsets:[[126181,47341]]}},{type:"Feature",id:"13",properties:{name:"河北",cp:[115.4004,37.9688],childNum:11},geometry:{type:"MultiPolygon",coordinates:[["@@Ʃ̒̏ŌѺ̒ƩóȄƧŌƥͪòôñȂ̎ŐóȂ̒̐̎ôНɜנ̎ôŋɞȀѶ@ôͪφƨŌɚɜȃóƧƨƥƪ@ʳƩɞρ݈@υНφʵɜƦρƨƧ̍ɝóɛѹ̍ρŏ̑ôóƨ@ƧƦôƨɛ@ƥƨ@ȂƦ@@ôəŐƧʶƨŌυ̍̎ɛŋôōɝ@óƧ̍ƦʵѵʳôʵɜŏςôƪŋƨŌɚ@ôНƥƧ@ōѸɛ̐ô̎ʵѵНԭ@̍̍Ƨò@ȁɝ@əρυͩƪ̏ƩõƧŎƧōóॡȄɛʶɜȀ@ɞςѶƧƥςɛŐ@ɚɜɜ@Ŏôôςƪς"],["@@õə@Ƨɛ@ŐóƦφô"]],encodeOffsets:[[[117271,40455]],[[120061,41040]]]}},{type:"Feature",id:"42",properties:{name:"湖北",cp:[112.2363,31.1572],childNum:17},geometry:{type:"Polygon",coordinates:["@@ñȄυƦöŐƩóנƨƨφ@@Ő̏Ʀ@Ő̑ôƨŌנóɜôƪŋɜŌѶօڔə݈òɞōɜŎôӏƦóƨô̒óôȃƨó̎ŐôƧƪ@ƨȁςƧə̑̎Н@̍Ƨŏρôԭͩԫ̍ʵƧóȀôɞƧŌ@ŐѹͩñòɞñɛǿƩɛñρͪ߻Ȃ̑ŏƪəƩóםôõŏƧ@ɛНƥȄó̑ѺƧôφóƨƨƦƪóɜŐôóòôƨóφ̐ƨóƦ̎"],encodeOffsets:[[112860,31905]]}},{type:"Feature",id:"52",properties:{name:"贵州",cp:[106.6113,26.9385],childNum:9},geometry:{type:"Polygon",coordinates:["@@ɜȀƦŋԮô̒ɚôōעƪƧʴɝ@ɛʶ̒ʶ̐ȁƦóȂô@ôŏ@ōôƨʶѸô@ʶƨɞó@ōτöòυƨ@@əƨô@ɛ̒@Ʀɜôȃ@̍ôʵԩНôóςŌƨŋ@ȃƧñôŏƧɛƨôɝƧʵ̍ôȃυ@ɝɛȂƥóóȁɛóõôɛ@əͪɛŋôȁƩóםȃ@ƥƧŏړʶѹ̍ƥŌƦȂóôɜƨѵО̎נəɜѹŋƧȂ@ȀóɜͪɞƧ"],encodeOffsets:[[106651,27901]]}},{type:"Feature",id:"37",properties:{name:"山东",cp:[118.7402,36.4307],childNum:17},geometry:{type:"Polygon",coordinates:["@@Ʃ̐φͪɚςɞ@@Ȃƨñ̎̎Ԯ@ѶОƨƧڔ@φН̑ŋ@Ʃ̒ǿ̎@ƨɜԬςôʶ̐ʶöԫƨƧנƥɜŎôō̎@ôŏóρƧŏԫôóƧԩó@ƥɜƧԭóƨʵɛƨ߻ӑɜНԩóô̑óƧʳəóɛƧ@õȀƧ̍ȃɛŐóŏυО̍óɝƩԩ@ƧɚԫȄɚʶƨɞʶԪ̐ړɛƪ̒"],encodeOffsets:[[118261,37036]]}},{type:"Feature",id:"36",properties:{name:"江西",cp:[116.0156,27.29],childNum:11},geometry:{type:"Polygon",coordinates:["@@ƧȄôɚəȄ̎ʶԬԮͪςóƨŐƪτɞƦōƥƧ@ŏςôóŐôô̒ʷѶƪƩƩǿ@ō̒ɛôυ@Ƨȁѹɛəƨѹ̑ƨ̏óƥѵʷô̍ɛȁôŏɝǿƧԫƧôʳƥōòȃρȄ߻ɛɝƨɞɚɜƨôŐƧŎԭōñƦòԮɜôɛôͪƥ@ʶƧƨôƦƧô@Ȅô̎Ѷͪ"],encodeOffsets:[[117e3,29025]]}},{type:"Feature",id:"41",properties:{name:"河南",cp:[113.4668,33.8818],childNum:17},geometry:{type:"Polygon",coordinates:["@@φ̎ƪ̐ɞȄɚ@@Ȃעó̎ŌѺ̒ôֆॢȃôƨŎƨōƪöƩ̑ڔɜԩ̏ɝʵƧəʵԬȃƨəԪ@@Ƨ̒ŏô̍υȁƧɚ̍ôóŋ@ɝƧŋõ̑σ@ŏɜŋôɝ̒ƧɚôôطρóóɛƩ@óƨ̍ŏƧôóȄ̑ôƧóƥôóӐɛōɝŎ݇ñړɚѵֆ@ɞ̏ʶ@ʴƩöó̐"],encodeOffsets:[[113040,35416]]}},{type:"Feature",id:"21",properties:{name:"辽宁",cp:[122.3438,41.0889],childNum:14},geometry:{type:"Polygon",coordinates:["@@ƨʴƧôôӔƨô̎ƩɞН̎ͪ߼ͪɜɞɚ̐@ƨςŏ̒ôƦƨɜô̎ƪôςǿƨͩɞȀƨ@@ɛςփôóŋ@ʵφυƩʳö॥փρѹס@əɛ@ͩࢯ@ѹʵρƩʶφȀƧ݈̒۬óʸɝŎѵ@ԭԫןɛƧƨƥςɛυʶφО"],encodeOffsets:[[122131,42301]]}},{type:"Feature",id:"14",properties:{name:"山西",cp:[112.4121,37.6611],childNum:11},geometry:{type:"Polygon",coordinates:["@@ɚѺñŌɚôȄѺ̎ֆφóςȂ̒ɜƨɚ@@Ȁƨŋôȃƪѹ̑̐ŋƪ̑Ʃρρóó@ōɛɛ@əɜŏƦρƨρѵ@ɝɛǿɜʵóօѹ̑̍ŋסô@ȁə@ɝȃ̏̍ƩυƧô@Ȃ̐ظóОó݊φք̑ʸ@Ȃ̒ʶôȀ"],encodeOffsets:[[113581,39645]]}},{type:"Feature",id:"34",properties:{name:"安徽",cp:[117.2461,32.0361],childNum:17},geometry:{type:"Polygon",coordinates:["@@ó̎̑Ő@ƨƪѶǿɜ̑φƦʵ̐ƧѵôóƪôôυςƨȂɞŏ@̍ԫôò̑ƥóȃѶͩƧƥôŏѺôŏƦ@ƥͩƧôȁυó@̑ƧɛѵʵƩƪѵ̑ʸóóôŏρó@ŐƦƨƥŎσɝƩ@̎̍Оɚ̒ρƨƧȂôɜςôóظəó̑ƨóɞɛŌ@Őτö̒ƨŌ@ɞôŌ̎óƨəφȂ"],encodeOffsets:[[119431,34741]]}},{type:"Feature",id:"35",properties:{name:"福建",cp:[118.3008,25.9277],childNum:9},geometry:{type:"Polygon",coordinates:["@@̎óȁƨӑ̒̎ɚƨͩφŐƨɝ̎ŋóŏρ@ōƨòʳəóƨō̏õɛƧ@ƨѵƧōəŏóŋƧô̑ɝɛʳƥ@@óɛõ@Ƨ̑ƧóȁəƧ̑Ƨ̐@ɚəОƧƧɚóñ̑ŎóʴƨƨԬɞȀóŐɜȂó̎ѶʸôƦƧ̐Ѻ̒ɚƧѺɜƨȂ"],encodeOffsets:[[121321,28981]]}},{type:"Feature",id:"33",properties:{name:"浙江",cp:[120.498,29.0918],childNum:11},geometry:{type:"Polygon",coordinates:["@@Ѷʶƨɜ@̒φôóȂƨƦͪ@̐Ѹ̍τȂ̒̑נŐמôƪƧôӑ̑@ƥρͩƨօ̏@@υɝó@ŋɛ@ôƩəóƧѵυó@ƩɜŋƧ@̍ŌƧɞυŏƧͪ̍ə̑ƧӒôȂ̍@óφ̑ɜ@ŎƪȀ"],encodeOffsets:[[121051,30105]]}},{type:"Feature",id:"32",properties:{name:"江苏",cp:[120.0586,32.915],childNum:13},geometry:{type:"Polygon",coordinates:["@@ôɞ̎φНôŐɜŏ̎Ȅƨöǿƨ@ôɜɚƨʴ̒ôôó@Ƨ̎əԮȃԪૉöͩ̐ƧòʵφƧôʵ@óړɜóŏɜǿƧɝρσȁѷ̎̏ƥóŐѹóŐƨƦѵͪôȄƦñ̒Ԭó@̎ɝŐƧȁρóφƩóóôƨѶ̏ƥʶυɛ̒ѵȀ"],encodeOffsets:[[119161,35460]]}},{type:"Feature",id:"50",properties:{name:"重庆",cp:[107.7539,30.1904],childNum:40},geometry:{type:"Polygon",coordinates:["@@əȂòɜƨѺɛƦȁ̐@ƪõŏφƥòȃƥ̍Ƨôυ̏ƧôñóóôɛŏƩôƧƥôƧóυƨ̒ѹôƦȃ@փƥɛ̑@@ɜƧó@ɚƧ@ñφσõ@ŎɝôƧ@ʵѷóƧʵó@ŎóŐó@ôȁƥó̒υôóʶəƧȄς̎ƧȂôƨƨƨφɛ̎Őƨʷɞ@ςԮóŌôôφ@ɜֈ̎ƨ"],encodeOffsets:[[111150,32446]]}},{type:"Feature",id:"64",properties:{name:"宁夏",cp:[105.9961,37.3096],childNum:5},geometry:{type:"Polygon",coordinates:["@@ల̒ôޠφӒςôƪͧυևɜŋѺó̎ȁ̍ɛ@ѹס@@ʵƧȁôó@ǿ̐ŏöʵɝŋɛ@ô̑ƥóóƨƧóôó@ƩôóƦ̍óȀƨŎɛӒôŐυͪɛ@@Ȁə@"],encodeOffsets:[[106831,38340]]}},{type:"Feature",id:"46",properties:{name:"海南",cp:[109.9512,19.2041],childNum:18},geometry:{type:"Polygon",coordinates:["@@φɜƦʶ̐ôφô̎@ƨŎö@τʵƦԩ۫õН̏óƥȃƧ@Ʃəםƨ̑Ʀ@ޤ"],encodeOffsets:[[111240,19846]]}},{type:"Feature",id:"71",properties:{name:"台湾",cp:[121.0254,23.5986],childNum:1},geometry:{type:"Polygon",coordinates:["@@ôƩɝöƧɝѵəޣ̏ρƩԭóōóͪρɞƧОôԪ݈ଦѶɜ̒ɛ"],encodeOffsets:[[124831,25650]]}},{type:"Feature",id:"11",properties:{name:"北京",cp:[116.4551,40.2539],childNum:19},geometry:{type:"Polygon",coordinates:["@@óóóυóôƥ@ŏóóə@ƧŋƩŌρóɛŐóʶѶʴƥʶ̎ôƨɞ@óŎɜŌ̎̍φƧŋƨʵ"],encodeOffsets:[[120241,41176]]}},{type:"Feature",id:"12",properties:{name:"天津",cp:[117.4219,39.4189],childNum:18},geometry:{type:"Polygon",coordinates:["@@ôôɜ@ƨöɚôôôɚŏ@óƥ@@ȁƦƧɜ@óƧƨƥ@ƧóəН̏óѷɜ@ŎƦƨóО"],encodeOffsets:[[119610,40545]]}},{type:"Feature",id:"31",properties:{name:"上海",cp:[121.4648,31.2891],childNum:19},geometry:{type:"Polygon",coordinates:["@@ɞςƨɛȀôŐڔɛóυô̍ןŏ̑̒"],encodeOffsets:[[123840,31771]]}},{type:"Feature",id:"81",properties:{name:"香港",cp:[114.2578,22.3242],childNum:1},geometry:{type:"Polygon",coordinates:["@@óɛƩ@ρ@óôȀɚŎƨ@ö@@ōƨ@"],encodeOffsets:[[117361,22950]]}},{type:"Feature",id:"82",properties:{name:"澳门",cp:[113.5547,22.1484],childNum:1},geometry:{type:"Polygon",coordinates:["@@X¯aWĀ@l"],encodeOffsets:[[116325,22697]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/65",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"6528",properties:{name:"巴音郭楞蒙古自治州",cp:[88.1653,39.6002],childNum:9},geometry:{type:"Polygon",coordinates:["@@@ÈÒĊanwŎVȮ¦ͪŃĢÜōȂçČéƐżLɆóĊĊaʊŁ±¯²Um»ˌmÈ»VʠţWÑÅ¯ǓéôƑƒğÆīŎī@Ƿwô˺LÞ¯ƨVǪÑƒĢȘV°wĢôk°¯ƒ»΀@Ȃ»ĸǔ@΀͔ôôLɆó̐ÝɜLɲōͪƨóŤK@ī@IU܃ÛmȻţǩÝ˹ÛǉťǓǫō@Ɲ²¯VçōKͿŁΗÇţ»ƽɅƑLÓŏÅÅɱV@ÝĊU¯ÑĊĭÞLÞŎJ±̃XȣˌōlUÈ¯ŎKÆƅ°XÑÜ±nŗġV¯óaUƧUōŁÑ±çɲ¥lĉkğ°k¥nğţL¯ÝÝUƽĬ΁lķ°@ōXÿÝ¯V»ŹLʉÞɱŤĉó°ÝJ¦ÝKÝ£ţÜÈĉ@xǩUċƑ@ky͓¹`U²ĉVġ»ğa¯¥ť@ĉó@ŻÛÛJw¯nó¯ġWƽʩķÝɛwĉĕÝ¼ȭÞķō@ó£Å΀Ƒ¯ôȯÞ¯ȰÆōèĉXÇ¼ó@ÝnºĸÞVƜĸȚUʶõˀĵĖɱŎÝĖVࢰӒѢ°˘nϚVˌÈmɼĵŦW¤öʊõʔ@°ÈXVènŎȁb¯ǫĉ±Èğ`ġwōÔğ»mVVÝ¥ó@ĸķô@bXĶmV²²`Þ_ɴbͪÈ°ÞWĸÈŌmÞkɲÈUÆ»n¼ǬVķĸźô¯°n¦ɄÇÈ"],encodeOffsets:[[86986,44534]]}},{type:"Feature",id:"6532",properties:{name:"和田地区",cp:[81.167,36.9855],childNum:8},geometry:{type:"Polygon",coordinates:["@@ƨ¥èź٨ΘƑᩄbUࢯÞĕɲōĶĕöʿVʵķșUƛÝķm¹Þô@È»ĊWŎçÅ°ȯȰÝ°óƒÆͿĉ»̽çnmɱĵƧºóUƽ@±wóL¯°̻L±Æ¯Vƴķb¯VÇ¥ğ²Ǖbk¥ÇKlÅɱġ@ÑóK@ÇaÝXğţxĉČǫķê¯K@ÑaŹƑK¼¯VóaónġwóÞéUġbóĉğÇl¹aUóğKWVÅ¯nÇŋƑķnʇ»óxĉwçÇ°Åw°ċXób±kÈÇJm²ţx@ÒÝŦÇºnó¼n°ÇbUÒ±¼XĸĠłƽXmwĉºzÈÜmnxmx²ĖmÒbnƧêUºĊêÆVóĖóUĉ¼ÅĬƑ°ɆƆŻŚlłÞL¼nĠ¼@ÞÞź@ŎÞ°VɄɴжϼِ͈Ŏ"],encodeOffsets:[[81293,39764]]}},{type:"Feature",id:"6522",properties:{name:"哈密地区",cp:[93.7793,42.9236],childNum:3},geometry:{type:"Polygon",coordinates:["@@WnŐÆĶLĢ¦ţºźlxÅĸƽŚɄĮè@ô²ÞUĔƐńV°¯ĸX¦Ɛm̐bƒ»Ɇa΀ĢƐLˤȘÑnІǉĸÿn¯ĶaŎ¯ĢĕȘ¯°΂la¯¥ǕǔwˤӱlťО̻nŻmɃĕċţUw°WUóƨÅţķ°ýV±óÅǓéʉ¯ƽŁéōǖȁÝƏůǕw˹ǫȗǓƧǕVýé@ĬţLƧôͩɱŎɛK̏ÞɅôóK@²@°ōŘ¼lŦ¯ŰóƜÛlV¼ķ¼°kȰŰĠǬŚÝŎmĖ`@ÇÜn"],encodeOffsets:[[93387,44539]]}},{type:"Feature",id:"6529",properties:{name:"阿克苏地区",cp:[82.9797,41.0229],childNum:10},geometry:{type:"Polygon",coordinates:["@@VÆxˌŎÞŎ°nȂÒ°²VĊ¯VğƾˍǬƨÞÞKÈÞĊVźôɆÞĢèŌôWČ²ŤVÞĸʶbl¯ôn_VÆĸlmÞnVź_ĸ¼ȮmǖéĸW°°ĸJkʠ¼Æw°¤ÈlxɆzČºĶI²ÆǔU°ô@Þ¦UnUĠ¼ŎÓĢxĠ_²ÇĊǬ°ȂamōçUÇW@¯öʓõʉX£ĶťnɻÇUˋmϙ¯˗ӑѡᩃaΗƒɜ°xWƴUxɃÒˣ¤ɅwğʉōóÝŹ±°ȗ@¯Æƒ²¼","@@ōгwȁ¥Ƨ°ŹÑķV¼ÞêĊ»lĵm¦ÅW@ĀôÈźaɜxÈbÞÆĶIОŘnIÇŃÛÝĊÑĠƏ"],encodeOffsets:[[80022,41294],[83914,41474]]}},{type:"Feature",id:"6543",properties:{name:"阿勒泰地区",cp:[88.2971,47.0929],childNum:7},geometry:{type:"Polygon",coordinates:["@@ɲˣĊIÈ¥ÅU±Ċýkō°ĉƽó»ĶƽXóʵʵȯƑÅȁɅ¯ĉ@ÇሗK֛@@ˤV֜ʵрƒǬVĸƑŎ@ƆϯÑóķ@ʇ»ķ¦έmlÈĸĊX¼WźÛÞÝѸĢČþĀĊôάVö¼ĊUƨ°°èŎČUÜÆóôVôô²êȘlˌç°`n²ǬĊaÛ°±kğmm»@°ÝɆÛÅÇVaÝVm͔ğôÝÈb@n¯ÜUĢÑĊ@źīżWŤÈǖWôŁÆI²ÓƨL@ĊXmmÑÆ»ȰÑkĶō@ý°m¯"],encodeOffsets:[[92656,48460]]}},{type:"Feature",id:"6531",properties:{name:"喀什地区",cp:[77.168,37.8534],childNum:13},geometry:{type:"Polygon",coordinates:["@@Č@°ĠôÓô@Ŏĉ@Ƴĸ@Ť£ĢlVôWVóřXĉŤêÞ@ƐÒĢÑlèÈV@ĠIk°ÆŘ@ÈÈĀ@ǶťÒğ@@ÒĉlŻ_@ƧĖÅĬōÆ@bźÞnƒlVÝĬWÆ¼ʇÝÅ@ÇÅÈwWóĉ±ğzĬČƨÆÝIĉÝ¯bÇÑĉ¯ʈV°xUŰĊ¤ƪ_ôÓɚI@lȚXȮŎlɴȘ՘¦ɲÆʈ_ɴźôÞʊŎĠɆxˤ£ɄÑVwXƳ¯wɛŹ٧çƧ¦ōُ͇еϻɃɳUÝ¯@ōÝŹ@Ý»mğ»ÝKkŁżřɅƅƒ¯ÆīĊ»ôVôĕÅUĉéV¹ƨémanÑ±ĕnwmwnÇÛyĉ¹ŹlŏkĵèķmōÞġKñÔċKÅèĉzômxȗÿƿI@þÅČÝKÝ°@¼ÈVº@ÅĢÆUċłnÝÆǕČĵJm£ÝJ¦@ĊxV°ƏLċ¼ǩ@m@ÅĢómÇÆğ¹ÇÆĖÞKxwô¦ÆÑÆL²ÆƾU±ŚÅŻĖ@ĬŤÈñ@ǔÇxÈÇƒ","@@VÇţ°ğUĠ¯mk¯ó¥ķIġÿƏbĉa±ÒĸĀlKU_m»nwm@ÈŤ¦ĉbÞ°±Þżł̦°ĢŁVé"],encodeOffsets:[[76624,39196],[81507,40877]]}},{type:"Feature",id:"6542",properties:{name:"塔城地区",cp:[86.6272,45.8514],childNum:7},geometry:{type:"Polygon",coordinates:["@@ήnĸ¥ʈ¼ĸ@ôϰÒ@ƅƒōUķƑǫʶпU֛܃LګK@΋ĸ@Æ£ÞġÅĠċLVÝ»@Å»Ýnm¯»nŻĊ@nķŃ@¯ómóÛÝǟ¯aÝóȭ¥ōUmxĉbÇÑ@bUº¯X¯ÆƧbVÒĉnǕw¯°ƑVÇ@kx±UɱnÅK¯ƒĠǠU°ɜL@°xnĬĀŋŎÇLğϱÞέƜkôÅĀǕłĸĊŤUŰĢ°¦ȂϰÜɨ°x@°żǠÆƈČVĠ»ČL°ÇbĊÑ̐óÞlĶwÞɆVÞwǬxǪţÈ¼ÜLŐĶˢ@","@@óKĵĀV͈ĉłƾǊÆŤzXl°ÆL²¼źôÈĢǔ¦lô°ɜÞʊĠğÅm»ʵƳƑʝȗīV¥¯ĉ°Ñ@ŃÅI»ĉmğnaċƨbVğwġ¯@UōaĉÝJğÑÆŎkŎÞĀlź¦"],encodeOffsets:[[87593,48184],[86884,45760]]}},{type:"Feature",id:"6523",properties:{name:"昌吉回族自治州",cp:[89.6814,44.4507],childNum:7},geometry:{type:"MultiPolygon",coordinates:[["@@መL@È°ĊȂɆƒÆĊ£ťôWÓɆbĢÅŎÆ¦ČÑW¥°ķU¯ƏŃVē±Ý@óçĭɃƾřÆķkwŹŤ¹ġ¥ĵKŏÅXmˍщwǓ¤Ƒ@wóōVķ£ɱġôÛa±ÒȁóèţIVƽ¼k¤ó¹ġJmx»ÝU²@ÅÆĸǫŎĊmŎǬ՘"],["@@Þô°bÞǠôÜôn@°ĸńǶkł¼UÞKğČÆÝĢÅ¤ķ@@ΌڬL܄K@ˣȂ˭lĉÅW¥ĵVÆý@ŃÞēUŃȗƅ@ŹƩǕĉ»k»ÇVğóřXŻKƏċêȁèÛŎġͩń"]],encodeOffsets:[[[90113,46080]],[[87638,44579]]]}},{type:"Feature",id:"6530",properties:{name:"克孜勒苏柯尔克孜自治州",cp:[74.6301,39.5233],childNum:4},geometry:{type:"Polygon",coordinates:["@@ˎǫĠƽ°UUĉ¯±ȁÑm¯ÝōˋōwUÅ±»ÅƑ°Ș@²¯ɳʇ`ɱÅ¥՗ɳȗōkȭșW@kəJóÔƩ`ĉ£Vů¯wU°ʇĊÈÒ°aĊÞÞJÅċƧīĠyĊ²XôÇxÈÆÆ@ÞʈÅ»XÞīUƑkmŹÝ@aŎÅÆīƨĕ@ż`Ċk@ÑĠ@ŦÑ@ǵÇÿ@ÇÅŗl¯ğJ@ÇUkçġÒƏÑÝ@ţéWĊôŚUóXUġkţ¤ķ@@ƴōĊó@óÔğ¯ċ@@Ò¤kôˣŰ͓k»KX¯ċwƧôğɐÒôIVÆ¯UķǬķn¼ôb°ÒȰVVÈÞ°ĸó¤V¼°V°²êlĢÒUƨ¦ôȰƴĊVV¼ǖIċĊÞɜénČW˸ǸařÈw±īçĸ¤ĊôwĸUĢ¦éǖĬĀô¼lÞkÒ°x°ƆÞxÆV²ǔ»b°wÞȘ¥°nŎV@°ʠèŰȂb"],encodeOffsets:[[80269,42396]]}},{type:"Feature",id:"6521",properties:{name:"吐鲁番地区",cp:[89.6375,42.4127],childNum:3},geometry:{type:"Polygon",coordinates:["@@ôKĉǪa²¼lÜô@ʠê°ĬôȂ²ÑÜbĢóɲĸ¤ŎUô@xƒǔ£ъxˎmÈÛ@_nĕÞōřǫğůlȯ¯ĸ»U»Ükôƛ°ůkť»Ŏŗ@¯@±͓óͿǓ@ķȁ¼Ϳ@Ƒ¼¯°ólġ¯xȗUġƑǩÒƧUÝ°˹Kóx@ǸōĬÅĬƑĠóƒǔêÆ°XÒʟŤUÇ¼ˋnn¼±V²°ȂUŌÝbʟǔɅô@żǬaҎÈ"],encodeOffsets:[[90248,44371]]}},{type:"Feature",id:"6540",properties:{name:"伊犁哈萨克自治州",cp:[82.5513,43.5498],childNum:10},geometry:{type:"MultiPolygon",coordinates:[["@@ĉÆŘȁ̐mÞ¯ĀX°±¼@ƾ¯ƴ°ŎÝþŋ¦WÜÞbȂĉźUÇmwVUȂóô@ȰÝ΀nÆJnƾʠŌLČóǪ¯¥ǔaǖŌaôÝĢLxÆLɲm²VlwÈ@Uƒ°¯ǖxĊmUÑƨa°Å°WV¹aÇɃÈm¥°¯ŹóĸķǫUm»Å¼ÇVɱlÝŋnķÇÝX¯ͩÇɳaÝ`±_U±ĵnWa@ĸóķ¯ǓV±ÅĵJċ¹ɅykwÇ¯£Åxʟ»lķI¯X¯ķêǕȭnķ»Ź`±kÞ@Ýô@Þ°xŤŎIƨÆUxō¯²ǔĬǬlUŚ"],["@@ÞĀlź¦¯ĸŤKÞċƨbVğwġ¯@ţƽJ"]],encodeOffsets:[[[82722,44337]],[[86817,45456]]]}},{type:"Feature",id:"6527",properties:{name:"博尔塔拉蒙古自治州",cp:[81.8481,44.6979],childNum:3},geometry:{type:"Polygon",coordinates:["@@ήƛϲÝĠÈKŌōÿmīw@¯ɛKV¯ğǟ°ƑwġKóÞŋbǕǓb¦ǩ°ċôŋKʟƽmÅImͿȯÞó@ȁôUVnxÈŹVȁĊÝabŻ£¯°lóxȂŤĸkĊÞyĊêĊmĢxVƨÈĠXΘÆĠÔźɆţ°LXƾŤŤb"],encodeOffsets:[[84555,46311]]}},{type:"Feature",id:"6501",properties:{name:"乌鲁木齐市",cp:[87.9236,43.5883],childNum:4},geometry:{type:"Polygon",coordinates:["@@WôŚUĠÈl¼Ċ¼ƪǖ@źȘƆ@ýlÜXVŘÞ¦V¼kĖóÒèkĊȁˮ֜@ǫ՗nōĉǬōķÆÅ@±ÞV¼nwĢIôºl£ƾ»UŤJôçó¯īʟéó@kÛ±»ǩbĊóLҍÇǫb@ŻɆóʠǓaŋÞȁVʉłĉbĉɅô"],encodeOffsets:[[88887,44146]]}},{type:"Feature",id:"6502",properties:{name:"克拉玛依市",cp:[85.2869,45.5054],childNum:2},geometry:{type:"MultiPolygon",coordinates:[["@@ɜÞʊĊýVaÅm»ʵƳƑʝȗīV¥¯ĉ°Ñ@ŃÅI»ĉmğnaÝţL°ķóKĵĀV͈ĉłƾǊÆŤzXl°ÆL²¼źôÈĢǔ¦lô°"],["@@ƾIŤ@UUwōaĉÝJğÑÆŎkŎ"]],encodeOffsets:[[[87424,47245]],[[86817,45456]]]}},{type:"Feature",id:"659002",properties:{name:"阿拉尔市",cp:[81.2769,40.6549],childNum:1},geometry:{type:"Polygon",coordinates:["@@nIÇŃÛÝĊÑĠƏōгwȁ¥Ƨ°ŹÑķV¼ÞêĊ»lĵm¦ÅW@ĀôÈźaɜxÈbÞÆĶIОŘ"],encodeOffsets:[[83824,41929]]}},{type:"Feature",id:"659003",properties:{name:"图木舒克市",cp:[79.1345,39.8749],childNum:1},geometry:{type:"Polygon",coordinates:["@@VéVÇţ°ğUĠ¯mk¯ó¥ķIġÿƏbĉa±ÒĸĀlKU_m»nwm@ÈŤ¦ĉbÞ°±Þżł̦°ĢŁ"],encodeOffsets:[[81496,40962]]}},{type:"Feature",id:"659004",properties:{name:"五家渠市",cp:[87.5391,44.3024],childNum:1},geometry:{type:"Polygon",coordinates:["@@çôÑlĕU»¥ÝUŗWkÛ@þVńÝĔ@ńÅþĶUX¦Æ"],encodeOffsets:[[89674,45636]]}},{type:"Feature",id:"659001",properties:{name:"石河子市",cp:[86.0229,44.2914],childNum:1},geometry:{type:"Polygon",coordinates:["@@lŁǵmĉ@mż¼n°ÞmÆ¼@"],encodeOffsets:[[88178,45529]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/54",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"5424",properties:{name:"那曲地区",cp:[88.1982,33.3215],childNum:10},geometry:{type:"Polygon",coordinates:["@@ƨʔĸbÜºÞwnxźbÞ°ô@ĶĸIÈ¼ĊJŎÈôUÝƒ¤ǔLÞŎ@ĢȘblôLÇźçÈ¤ôL¥ÞIÞ¯ĶxʊťƨƿÑĉXVķŦ¯ȂKÇǕÑ¯IU£¯Óƿ£VĕÅÞÿÆwƑ£ǖxÞĕ±ÇÝaUÑÈU¯UōÈÝwWŁĵ±ÝóĢÿ°IÞ±mÅĢ¯mÿ¥°UnÑŤĢĕĶwǬŻͪwŎ¼źÇĢĠĕˎŁ°óƨ¼Èam@¥°wǔǖ°ƨÇŤġƨŎŃôbÈÛŎĊ°@Ġw²ÑÞJÆÆb²°êĊUÞlÈ²VÈKĊÒĸĉ»ÅôťUÅÇk¯@ÇÑklÇÅlĢVÑó@°@ÛĸV¯ÇĊn¯Uĕƽ¯m¯bÈ@Ò°Ĭbĵ¼kxķýÇJk£ÝaUÑÅóĶǟkÓʉnĉÝ¼Ƒó»Þmn£mČ¯@ȮÿV¯ĸk@Ýów»ğġ±ǓLōV¼Əèķĉè±b@ÒţUÑóakl£Ó@¯L@ÇlUóȁ¯aġÈÅĕÝLķ¯Ė¯@WĬxÒÈnW°ţôU²ǓÓġ²V°¯ôǔÝLċk»Ý»Ý¯ÞVwÛÝÇōͩÈĉċ»ĉm¯£W¥ţKkóġƏW@¯±kōÈb@ÒÇaÆ¯akóÛÇ¦Ýa¯Ýĉ@Ç»ÛmǓxķƛ¯lVĀÅÞġbÇJUÅVĖƑWzō»ōWn@è¯ÞóVkwƩnkźÇÞÒÞ¯ýğÇUxÆÈnè±bĉÝ»ÈŃwwÞ@m»ÈV@ýÇ°ķxaÝ¯Xċ¥ÈóW@ôkxlnxVÈóĊkŤġ¼@°¯ŰƑL̻Ű±ŎÝVÞVÇÞÅÇakƞ@èğŎĸżƾ°ÒLÞôĠKȰĖźVÈÒĠ¤VôUÈþťL@ôǬÞlÜÈnÇÒUŚ@ĊƨW°°X@ČÇþƴĉÒķ¦@ĢôWĀôłUÞĢǬź°¼@ôV°bUÆnzm¤ƽĸÈ"],encodeOffsets:[[88133,36721]]}},{type:"Feature",id:"5425",properties:{name:"阿里地区",cp:[82.3645,32.7667],childNum:7},geometry:{type:"Polygon",coordinates:["@@Çƾķn£myVÅaU¯ó@¯»ŹġǫVÝóŁXÿġó@ĸ¥ĊÑƳÈý@ċW¯X¯ĉƧ@VřÈÑÇmkÛǫÝ@óŦKÇýVUó£ğÇÑŹUȯĕğLÝóK¯ÑƽķŻĠō@çlƝÈbÆÈÝUÝÞU²ō̼ůƒK°ů@¯UK±ĊƧbōÇmçÈġóÅóbźó¥kīÆ¯ólçKôĵUÅVŃķ¥nÅŏm¯¹Å»@ÑÇóxÝkʇȤU¤ķb@ƒ¯ĊÇx¯ĸĉKm°Āk¦lKnĬȀƾÛ¦WÆÅmǊĉ°ōUţ¤UŎ°ŎKÞłÆǓ¦Þř¯bmUÝl¯Umğl¯£șwÅǫaÝnĉĶk@¯Kō»ĉnaÞ»ťnkmlĸ¥UÅŻkÑťĉVôó°LôīĠUÿĉǕÅz±K¤²ō¤¯Ė¯UÝ¥VĵóÈťÝwķÈÑk¤óWýĵĕVĠVóǓķ°k±VU±ţ¦UǟÝÅJVÑ¥XUċUÅlÛƆǕÆȗƆ¯wŏÞÅ@ĉlÝóÒnUôÅlxólÝôÛ±LÛôÝL@ġ¯X¯ÇUÅ¼óaó¤¼XÒġŎóLk¦ôÅ¼ĸĠ¼KġƆô¦ÆƑÔĉĶ¯ImÒ°¦n°¯ÞlÝČnƒÒKĠÞĕklýƾťôIĖŤÒnƜm¼¯lnżóÞ@Ůó¦ôƽĖċŚn°Ý°ôÈUƜblÞó@ǖô°UÈƆ°XþôôlѢ²Ėm¦°@¤XĊblÜzkºƒĖmXŎWVóÞn°lĠxȚa°»żLźb@Æ°XĠÝȚxĊĕŤaȚ°È@@èŤ¦Ü¼WÞkÈ@V°lŤkŎ±²¦ƐUǉ°aÈÑŎbĢŎbÆ¥ÞIȘlôVÈUbkɲĶnmnXb̼òƾĖŎ@ĢȂÑôÓĠĖʊĊÔ"],encodeOffsets:[[88133,36721]]}},{type:"Feature",id:"5423",properties:{name:"日喀则地区",cp:[86.2427,29.5093],childNum:18},geometry:{type:"Polygon",coordinates:["@@ĶĖXþôl£ÒĸÇÞxÇŦôUĶÞ¦°V°ĕŎ£±£²LÆyĊǖĀğVóĬ¯KóôUĊŦlÒżVÆķ¦klnŦmÝ¼bĊmŎ¼L@°lĊĵÞmǬbÆȚx°¤Ġkn°VÞkVn°aŚÝǔ¥ÅÝŁōL¯ōVŤ£ŎVĊ¯nǉÆXÅÜ¥ǿƽmīLkl¥ÿn¯ĊL°ķÈw°ĉ@ƑĸaV£ʈȣÞlôwÈ@Ò¼Æ°ºŐnmÆĸ¦UńÆVóĶLèôkÅ°lĬ¦ŹôôaÆôÇĢnèŎÈƨaĉ²VLĢ»lţôĉUÇwkmlw@óôXÇČ¦°WÞbwĸÈ¯@þÇUn¼Ý@xxÇńÞ¼Ċ²amçÅÇVwĠÈþ°ÝÑÈÝlŹƪmlxôU°Ý@çmXŎŎ¼yƒXĕÆUVÈIĢaÆÝUÿ°kĸƜǔwnÜÈ¼Ċ@Þ°ÞbÈ¥Üôl°bÅÈb@ÑaÇ¯UU¯Vġ»¯aV¯Ç°ÅmnÑŤçǬVǬ±ĉ¯¥Vĕ¯Ýk£ōw@±ġÛ°ÇVÑ@Ûa@ČLƳÇa¯¤ÝIĵ¼U¥ƿōķÅţŻókÝóĕ¥¯U»Æ£X¯ġŃÛkÝ°V°ó¼¯èWôÞĖȎkĀƧĀówm¥¯JÅ¹ÝJÝōVVÅaÝƑ@ğŭÇ¯_ĵVnxÅónĵxÇĖĉVÝÈğVÒó¯±Żĉ£ķÆÅLǈĉýţÛ¯VnV¤ÝÈ@°ÅÞÝ¤ŰğŁm¦ÝxóK¥ɱÈUĠôêVôÛ¼ÇWÝçĵaō¦óĖƧlÇĢƑnŎÇV¼¼ºÛ@m¦ƽĉmm¯ÝKÛç¯bŏłĬb¼ÅLmxť°ÅUÝXkÝmĉ¦W¯KÒknÝaVÝè¯KɅńÝKnÞ¯¼"],encodeOffsets:[[84117,30927]]}},{type:"Feature",id:"5426",properties:{name:"林芝地区",cp:[95.4602,29.1138],childNum:7},geometry:{type:"Polygon",coordinates:["@@VÈłVôÈk@°K@Ôk¤lôbVÒŤ@Ñ²açĸĊƐçU»ŎǔKĢ²Ġ¼ôx@ÞlƨĬUl¯ÈLVÞJ°ÜnʊwÜbXêVÞ¯°anaU°wÆ¼ɴÑWÑ°mÈýÈam¥Þ£Ť@¥ôblÞĢź¥ôxÈÅmÝĕÅV»ĉōŤōnó»ÈīķIUĠÑ°ġĸLÞ¯VÒÆ@Āb¼WôÈ@V¼ôóŤKÈÑU»wVǫżnWÒÈx¼lŦ£ĊōŤx²¯@ÆU¯çÆ@¤°£é°k°lůÈó@¯ŤÇÈĉkkÿó¥ÝXķÑÜ@ÒóŚÝ¯°ĉówÇ±¦ÅJUÒĉĀķw¯°mĖ¯±akxÝÅn»lÑK@¯lU¯UVÑ¯óĊ¯mōğVǓƅÞWÝÈÛ@ƿô¯ÜġzÅþ¯ólmôʇġĊÅUͿřŏȁˋŁóÇˡōƧÇbw°Ķôk¦ÒnUþġÒÔkǔķèó@²@ŘōńĵyzġaÝ¤ÅI¤Ƀť¦ğÑ¯¤ķbó¯ó±U²°¤ČÜVnÈÆŚŎ°ôĢþÆzèVĀÇĀÇXŹÑ¯¤ówċķk¦łUÒġzÇ@ÆÝx@²Þ@Æ¤Uô¦U°xU"],encodeOffsets:[[94737,30809]]}},{type:"Feature",id:"5421",properties:{name:"昌都地区",cp:[97.0203,30.7068],childNum:11},geometry:{type:"Polygon",coordinates:["@@VĖm°ĉÈU°ķÜ¯@@ôUÒġkÆkÈlÒ@Èl°ÈVÆóŦÆ¼aÅĢɄwnōw@¥Ŏ¦°ŹÞmV°wnÿwwÝw@¯mÞŗ°wĠĸkÞğlĔ²¦°@ĕĸwVóal@nĢÇĊn°@¦źUXçǔůĸVÆKÈÝĠ²ÅĔô@lÈ_mzǖlaU¼ôwV°¯¦ĬÈal@ČÇ¼nIxô»ɜ@ƨ¥ɆŁŃǪȁkƛƨȍʊȡóĭ@ÈÇVůÞĸƅmēƨťÅÈʉVǵ°ġVŭÅɧ°ÿnɛ£mķ²ŃóÑUĉ°mÇ»¯@mxUĀ¯èţ°ȁÝçġU¯ÆÇţÈ@°ÇôŰ¯k¯lê¯¤£Å@èV°Å@±°ţwĉŎť¤k»ÇwXÑŻmUǬxV¼ÇÒţLóôU»Ç@Xó»a@ÿÅUÑÝ°ķK¯ĢğÒVĸJÇĬ¼môţŎĊŎU¼ÆĖnÞÇÆówŹ¦ġkÝóa¦ţ@Ý¤n¦ÇbÇþ¯nXÒɳÒÅ»¯xVmbb¯Ý°UWéÛaxʉÛm¯ÝIUÇKk°VƧīķU°ȭĀ@ċ°nm¤Ýnô¼ƒÞ»ĊʊmlÔĵǠÆôVÒÞbl¤ÈIĸþlw»Ķa¯ī@ÑÇ°anƾ°"],encodeOffsets:[[97302,31917]]}},{type:"Feature",id:"5422",properties:{name:"山南地区",cp:[92.2083,28.3392],childNum:12},geometry:{type:"Polygon",coordinates:["@@°ÞUĖ°¦²ĊôÇÜLǖĀɜȘŰÞLĸźêÞ@UÜUŤ°ɞ¯Ü°WŦĀmŎ¦ĢyVÑŁl¥Čĸôx°£źÒWÈÿÈUÿçÅyýóġō¯řÅmÇÛUċ¯£V±²°ôôĸa°£ĠÒŦ¥Ʉ£ÆJÞ£ĢbyĶzŎŃ@ŗ±ô@ĸçlǓÓĢÑVýmÑl¥ĵó¯̻̥ƛǫÝһÇƧĉyţ¼ҍēVĶĉŎ°ĸmÞVÝĸÒÛaċóŹĖèÈÈl¼k¤ÝX@`Þŏ¼Æō¼ÇçĉKUÝÝ£ğ¤@¦ġl¯Òġĉ¯ómóxÝÞğVƴċK@b@ÜUÒ¯ÈĢÜ@²xŎl¤"],encodeOffsets:[[92363,29672]]}},{type:"Feature",id:"5401",properties:{name:"拉萨市",cp:[91.1865,30.1465],childNum:8},geometry:{type:"Polygon",coordinates:["@@Ŏ²l@°XĢƐlôŤLX¦°¤ĊnČ¼ÇĊŎͪÞÈÜxU°ÝÞÞ¼¼lČÞKǓ°óU¯Ģ±ǔÔV±ŤóX¯ÇmÑwXī°@°ĕĸÞKÆĖĢÇ°bȂÇŁUV¯wVó¥VÅ£Ý@@±ÞwÅÈ@¥nōťÿ¯XÛɝ°ţ¯ÛVVÝ@ŹéķÝKȗůɛǕÿÛKóÈǫǫUţèmÒn¯Æ°ÈU°b¼UĢV°°V"],encodeOffsets:[[92059,30696]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/15",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"1507",properties:{name:"呼伦贝尔市",cp:[120.8057,50.2185],childNum:13},geometry:{type:"Polygon",coordinates:["@@m@Łkklô@£kJ°ýɅķÑó¤ğLĉÅlÇğŁW¯¯ƥóÿlwkţÈéÝƛó°ÞÅxV¤ĉĖWƒ¯lȭţυ̃ɱÿķƅˋğɱřÝţϙȍƧĊţ@¯kWKUKm¹Å@ķJU@ƧÑƧō¥˹Ɔ@L@ÞVLn@VōČWJX¦@JŻbU@ţÞmVU@ȁýóbkWWLÅ¯UWġkmó±UŹôV¼ƽ¼ł̥ĖƽǬʉxĉŻȗKΕ̛ʵƨʟÞ˹»Ƨţ»Ǖō˷Ȍ±ȚʊĠUɾɜɨmÜ֞߼˸ƅȂ¯ǖKˢğÈÒǔnƾŎŐ@Ċbôô̐¼ƒ@ĊôĊÞĀxĖƧL±U°U°ĬƒČ°ÜêɴȂVł°@nxŎèbÈÞȌ΀Ǹl²IlxĊl²ÒmôĖÈlĵºmÈêVþxɛČʉÇĵVmÒÈɆôƐŰǀĊ°ÆǬĮƾbyĊ@ĠƒXǀċm»ôw°Ûk¥Çm¯çkkÇǫţǕéX_ĶWǖīŎaÆĵĸĊ@ȚȘĊLĢĉVÆĉʊÇĕóaU¥ĉ°mkÅ°ġUĠřk°mÑČÿÛƒWĸ£ʠÆxÈÞŎÞ»ʈ²ĊÇČalÒ°Ť±ĸzĊKÈ²m¤Ŏ@Ò°¼nyȂUźīǖƳÈē°@ÝĶ@Èkl¥ÇçkxkJXÇUÅ@£k»óƿīÛ@lÅJl¥óý@¯ƽġÆÅanċ°é¯¹"],encodeOffsets:[[128194,51014]]}},{type:"Feature",id:"1529",properties:{name:"阿拉善盟",cp:[102.019,40.1001],childNum:3},geometry:{type:"Polygon",coordinates:["@@ƏnǟƨʫŹɆÿ°¯ÆV²ˢżÿ@ÝÆŁȰ¯ȀƳĉó@ğky¹@īwl£Ź¯Ŧé@ÇÇxŋĉƩUUŃōLÇĵóÝnóç@ó@ġƱ¥çWUçÆō@éçťKçȭVһƽ̻aW¥ȁ£ʵǊǓƲɳÞǔlżÞmĠóĬȂɲȮ@ÈĢŮźÔnĶŻǠŎȭгŃċóȭţΗÆƑÞƧÅΫóȘǫɱȁġlÛkÇ°ȁÈnõl¯ôÞɛÝkĢóWĊzÇɼʝ@ÇÈķlUČÅÜķnέƒǓKȮŎŎb°ĢǀŌ@ȼôĬmĠğŰōĖƧbЇƧōx@ķó£Ål±ĀƧīXÝġÆêĉK°Ýʇƅ@ΌʉżÅÒϱʈ@˺ƾ֛।࡬ţશóЈèʞU¤Ґ_޸Ƒʠɽ̦ÝɜL׈ɛϜóȂJϚÈ@ǟͪaÞ»Ȯź"],encodeOffsets:[[107764,42750]]}},{type:"Feature",id:"1525",properties:{name:"锡林郭勒盟",cp:[115.6421,44.176],childNum:12},geometry:{type:"Polygon",coordinates:["@@ʶĬĊIȘƨƨ@ĬÛĢșŤĉĬĀóUÈŚÜènŦƐȤȄłϰUƨťƾÑ܆ğɲƜǔÈèʈƲĊƞƒɆ¯̼V˺Ò˺ȂŤVĢêUÜxĀˌ˘ƨÆ°ѢmÞżU¼ÆlŎ@ĊçŎnÈÒͪŎźĸU°lżwUb°°°V£ÞlĠĉĊLÞɆnźÞn¦ĊaȂīġŃ¯Iĉůl»kÇý¥Ŏ¯én£ġÑÝȭxÇ@Åçķ»óƱŎ¥çWÿmlóa£ÇbyVÅČÇV»ÝU¯KĉýǕċţnġ¯»ÇōUm»ğÑwƏbċÇÅċwˋÈÛÿʉÑ°Łkw@óÇ»ĉw¥VÑŹUmW»ğğǉVÿŤÅźī@ř¯ğnõƐ@ÞÅnŁVǉóJwĊÑkĕÝw¯nk¥ŏaó¦ĉV¦Å`ğÑÑÝ@mwn¯m±@óƒÛKˍƏǓ±UÝa¯lōșkèĬÞn@ŤġŰk°ċx@ĉ`Ƨĕ°@ţÒĉwmĉ@na¥ķnÞĉVóÆókĉķ@ÝkƧƧÛa°Ç@ÝÈUóbÝ¼@ÛÒV°@V¼ˋLÞɅŤŹǠVÞȗŤÇĖÅōbȁƜ"],encodeOffsets:[[113817,44421]]}},{type:"Feature",id:"1506",properties:{name:"鄂尔多斯市",cp:[108.9734,39.2487],childNum:8},geometry:{type:"Polygon",coordinates:["@@ĶL²ĬVłƑkkl@ȎŘWńÈĬȗ¯ºlz@ĠĊôŦôÒĠ°kÞÜn@¤UĸèĸbŌÈXĸLlÒĢxɲÆ¤ÈÛƾJÈÝ°UÅĶ»²VW¯ĸJôbkV@ôlbnĊyÈzVôab@ĸÞUl°yǬ²Ǭm°k±lbn°@È»JXVŎÑÆJ@kLÆl²Ġ²ʊůĊġřóƛÞÅ@mmLUÿóĉƧ@»L@`ČĸmȗÑţů±ĉğl¯ĀwÇçƧŤÛI@±ÜĉǓçō°UwôǫůķƳÅ±bÅ£ÓÇwnÑó@ȁƽ@ÇƧĢón»ŏĕóĊ¯bÅVȯÅImōKULǓ±ÝxċŋV±Āȗ°Źl±Û@WÒȁŚŹНŚÅèŌô¼°ȰɞȂVĊ"],encodeOffsets:[[109542,39983]]}},{type:"Feature",id:"1504",properties:{name:"赤峰市",cp:[118.6743,43.2642],childNum:10},geometry:{type:"Polygon",coordinates:["@@ɲŁĢǉĊwƾōÞĭ°_ŎŃźȹƒUČÿl»¯ôķVÿǬƽɅġÅÑǫ»̐ʟȣU¯wVWÝÈġW»Þ¹mÝƒɛŎÿŎōͩůV¹ōéċóŹÅVVĢǩʈ@Ėċ@ķÛV°¯xÇÅţ¥»°Ûôĉʟ¥WýČ¥wç»±mnÅķ¥ˋVbUÒġ»ÅxğLƧbWĖÅx¦U°ÝVóŰlô²@¥ÜÞÛôV@²±`¦¯Ý@ÅVÒō¼ô¤V²ŹĬÇĊƑţxç¯Lk»ʟlƽýmłÝÆƏ@mö°Ġ@ŚŹĬţÆUĀĠǊĠX¼nźVUÒ¦ĊxÈ¼@ôlx¯łʊÒÜĀˌÇČxÆČÈƐaxÒĠn¼ŎVÈ¼Ģ°ŤmǖČĊþLV°ÞU¼ċÈUÆzÈa¤ôbknXĀè"],encodeOffsets:[[122232,46328]]}},{type:"Feature",id:"1508",properties:{name:"巴彦淖尔市",cp:[107.5562,41.3196],childNum:7},geometry:{type:"Polygon",coordinates:["@@²@Ζǀݴʶհĸƒ¦Ķ̒Uˌ¼ӾÇƾ¼̨UÞĉƧéÝ»ĕĉƐȍōǪakóó¯a@ôţaV¯Þ¯°@²él¥ĵğťwōxó¯k±Vó@aóbUÇyĉzmkaóU@laóķIX°±Uĵ¼Æ¯VÇÞƽIÇÜÅ£ɱġwkÑķKWŋÇķaķçV@£mÛlÝğ¯Ñťóǿƴȯ°Åł@ÞŻĀˡ±ÅU¯°ɅĀźƧʬmǠƐ"],encodeOffsets:[[107764,42750]]}},{type:"Feature",id:"1505",properties:{name:"通辽市",cp:[121.4758,43.9673],childNum:8},geometry:{type:"Polygon",coordinates:["@@ôƲĸ¼Æè@ÈȮwƾ»ʠĢ¥VÆ@²¥@»ŎÑ¯ĊJŤ£k»ÆÇX¯̼ōī°aX£ôƾȁź¥aôŤĢL°ĸ@Ȯ¼ÈÒʈŚôVXůÆaĠƛÈKķĉôÿ@ğÈĉ»ÇVnĉVwXĠÝ°ČÿĸwV¯¯ǵ±ĉǫÅÅm»²Ż±ƽIm¥ţÈķ@¯ƧJV»ÞUÝç¯UġºU£ţóaÅÅlƧī¯K¯ÞÝğL̑ȍƽ@ōŎōĀƑɜnÞÝºX¼ÇĢÞUX°xVʠȤ̏Ǭ¼ÆÒɆĢǫƾUĀóĸ°k¼ċĀƑVŹȺōń¯`ÝĮƽŎĉxġǊɱłō¦"],encodeOffsets:[[122097,46379]]}},{type:"Feature",id:"1509",properties:{name:"乌兰察布市",cp:[112.5769,41.77],childNum:11},geometry:{type:"Polygon",coordinates:["@@ʠǠÞĸɲȺƒÒȂƛŎaÆÈĕȘţUÝźǟɆţÝˌKU»@U¯ÜÑ@Þ»ôaVÞÇÈ@¯ÜbƨƨÞlĸ@ĊôlôÅĊUÝĸm¦bmĊ@nĊxŤÑ@¯ƨĖĊ_@Čwl¯ȭLÝ»ƽ¯ķůǓ@ÇǓbċÅÅÆwÿĠÇU£óa¥¯aŎğĠţkw°»¯ůlÝĵkÇ»Ý°ɱƧǫaóôɱ»Çk¯ŃóʇŐŻĉǊŻĢ¯ÒÈUl°x°nÒĬónĊğ°ÇŚĉ¦ʵV°°ĬÛżÇJȁńʇʹó˂ƽŎÆţ¦"],encodeOffsets:[[112984,43763]]}},{type:"Feature",id:"1522",properties:{name:"兴安盟",cp:[121.3879,46.1426],childNum:6},geometry:{type:"Polygon",coordinates:["@@ÆXnlŎ°@LVLĠþxĊUȮĊnUĠV@żaW¯XIŎġ¥Ý@K@w@K@I˺ŻŎ¦ƨƨÒŎIÆ@X@VºnX°lŎ@ƾĉˤƒȘǷȘÑÝÝÞbVţĸÿŤxÈĖƐêÇKnĸ¥ô@ķÞUnÒl@UÅaīˋ¯ÑƧx@±kXřƐƏÛéVˋ»lō¯ĉÅÇÓǫÞĖġV@ğ»°ĵÇÞǓ¼¯mÛÅŃĉĠÇƾb²çéż¯VğÞml»ōÑVç»V¯¯ĕÆU¯y°k¯¯V»ôÇÑ°a@ŹkġKţóbŹ¦ƽȂóW¤¯bĬ̻ŎW°ÅÈl¼ţ¤ĉI°ōÒ@¼±¦Å@Uġ¦ʟƽ¼ÞĢÒm¤êō°¦Èþlk¼ĊŰ°JĢńȁĬ°żnÇbVÝ¼@¼óĸţ¤@°Ånl"],encodeOffsets:[[122412,48482]]}},{type:"Feature",id:"1502",properties:{name:"包头市",cp:[110.3467,41.4899],childNum:5},geometry:{type:"Polygon",coordinates:["@@źxżĀǔÆǬVȘĀŤ¥ÅƾōôˁʈͳȂŃÈIÜŻ¯ī¯ōm¯ɱĖ¯ķÒÝIÝ»ÅVlÅôÑġğVmÞnnWçkWÜXƝÆwU»Șĕ£ĉÑğ±±ÅkK@lÅIōÒUWIÇ¼¯@mka²l¯ǫnǫ±¯zkÝVķUôl²ô°ŎwŦxĶĠk¦±ê¯@Ý°U°bóŤ@°bôlôǩbŎƏȎĊĖÞ¼êƨÝĊ"],encodeOffsets:[[112017,43465]]}},{type:"Feature",id:"1501",properties:{name:"呼和浩特市",cp:[111.4124,40.4901],childNum:6},geometry:{type:"Polygon",coordinates:["@@ʶUĊ¥ÈřĠ¯ĉômīÑ¯mwk¯ÇV°ÑżġĊǉǓɱţǓƝóX¯ɛÒóa@nÝÆôƜŚĉĢʉŰĊÒ¤ȗĖV¼ÅxWƞÛlXXèmÝmUnĠĢóÒkÆÆUÞ¼ÞJĸÑ°ɲĕ°Ŏn"],encodeOffsets:[[114098,42312]]}},{type:"Feature",id:"1503",properties:{name:"乌海市",cp:[106.886,39.4739],childNum:1},geometry:{type:"Polygon",coordinates:["@@Ș°ÇīXŃŗ@ȍlkƒlUŁ±īĵKō¼VÇôXĸ¯@ťê°źk¤x@Ĭ"],encodeOffsets:[[109317,40799]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/63",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"6328",properties:{name:"海西蒙古族藏族自治州",cp:[94.9768,37.1118],childNum:7},geometry:{type:"MultiPolygon",coordinates:[["@@V£°@laXô±źwô@UlżaÜnKw@Uaa²LmÈLÆÈxlaUawÞmÜbÞUnJ°akôÑkwÝVğwÇ@ÝkkV¯¥@ò»nŤ¥XImw@mVwa@ÅwmLkaWw¥l»kçó»@WÑĉğ@ĉŃUwóřVómĵ»Ý@VǕ¯kÝĊÅk°ÓUklkU±IÇÞk±@ƽJ@UġIk@W¦VÑșÓÅnťKULn¯X@¯mUÛ@WÅmóKknōbxÝ@U@kw@ÿÇLţÝUkmwklċVÅU¦LkUWlÅÑ@a@ÅÑ±UóġŹ¼ÈĉmŻ@@wkwKl¯Uġ@lÇUÓ¯_Waĉ²Åló¼VbknKÇÅ@ƧĢō°Ý@ğWÅxUUm@ÝXÛWULUè¯@mbUaLbUWġxIUJWza¯by@ōÈóLU`ÇXUlUĉV¯nmÛbǕLklUĉVóaġƏbġKţnkbÝmmnÝWȭÈÝXţWókUÇl¯U¯ġUɅĀ@°¯¯VÆnmJ@ĊķnóJUbÝXUlVkL@lVxnnmb@¤Vz`ÞÞŤ@VnÆJV°bUôJkzlkl@²ó@ÆÇ°kĖÇbÛU@lmbXVkzVɅĀXˢlńĬŹ@éÅ@ĉńÆ°ğbUlɜ_°@xŦkbVbƒKĢŤVŎ°@żÈźlĊôKôb@nôxŦÆ@ôŎL@þÆb@nnWˌbÈxInaŎxlU@Ñ²±ğVUĢƨbɲ@Þ¥ôUUķWVô¯ĊWʶnôaŤˁ@£nmnIôǪK°xUXô@Ŧa°mkXÆÞVŎkĊ°ÞLÈôyVaIlwX°UVwĢÑÜKôw@nV@m°nmnÜɞ£VbmXn°ÜÒ@xx@Vb²UlbkxVnJUnVVĊ°KČm°nxÇnn¤±¦@UXVV@lVbmVVÈVxÒ°IbźaČbVw@VLƾÑ@Ŧô¯ĊkôÑ"],["@@@@nòVaw²bVxxÜaČVô_ĊJIVmLa°@Ŏ¥XlK@klKVbUb@nUĢnaÈ@lmǬ»Ġ¯nmnƨVyÑǖĠ»ɲIn@@ÅĢƳ@¯°ôVKÈbVIÇ¥¯@Ýó@ÑnīWKkk@¥¯ÅaX±VÅw@±Ġ¯@»nWmw@@¯VUUWçKĉa±VkkV¯wx@UJx@bknÇbmÅ@Uw±U¯¦UKm¯I¯ť¼ğĊ@ÇŹÈ¯@Ý»ÇnˡJbÛèÇnÅK¯ġĠŹW¼Ålm@¤n²Ýb@b¯l¯@Å¤W¼nV@x°@Vx@lbUblbX¼WÇ²lU@¼V¦@bÇlVxUbVxÞbVbm¦VV"]],encodeOffsets:[[[100452,39719]],[[91980,35742]]]}},{type:"Feature",id:"6327",properties:{name:"玉树藏族自治州",cp:[93.5925,33.9368],childNum:6},geometry:{type:"Polygon",coordinates:["@@ɆÿĢV°°VÈklVôŤXÞWȮÇÞXnmÞnlaŤmĢLƐaĢôbĊUVlkǖKÜan°mĊUVVkÈWV_ôKŎÇ@z°abXyVIJĢwVXaKVbna°@VçVKXÜÞWn@VVÆwXĠÞ@Ŏ¯ƨġÆ@ÈLlmUaô»ÆkĊ±Xb°`ÔVkÈĢ@Vk°Llx@xż@ĊnÇź»ôĢ²VÆÒ@@bÆÒXklVKV¥ÆČUklnxlç¥ċç@±m¥wÅJ@VmÈIléÈa°U¥@kÞVK²ÑW°w²ÑK²ñyÆÝVmw»kkWĉJWUVÅwLmÅ@@mwkn¥VÑ»°°@@»¯LlaJônVUÅ¯U@W¯UmÑ¯¯k@WykU@¯wV¥kVwţk»wWÇĉĶçKÞÇaĉbIlU@kwWXU°w±@UKn£WĉKWxkĕVamwXw@Wmnk@aVkbĉLlImmwUÇWxnÝJn@¥ÆkwaXÜĉ¯ÅV¯¤mkx¯kķÜ²VWôŹVU@V£¥@°wn@m@¯@UbUôķmn@ÆÛ@ÇýVaUÇĊV@Çlğ¯xÝŤlVÈÈVx¤VxkK@@x@kVĖġ¥kIWbXŎx@nxÅUW`_@±UaLUxK¯WbkVlbbmLÛÆWIUwWkwÝV@kIéUbUUkV¯Km¯k@UmÝ¯m¯mLÞĉÛUmġ£UxkKm°Lwk@kVmKVUk@¯a¯ĢmóKUUxImlÅnÇbXèVVU°@@xXnm@¼ğ°@²ÆxU²WÆb°@¦llXLmĬ@ÒÞô°@È¦UJÇaLóU¯@°ġƴ@Æ@mɱJğ¼ǕÒUzƧmnmğ°ǫ¼knÇ@bġmmV@VaUaLkl@kLWō¦¯@bKUnJĉIó`ċUÛbwUw±axbñUm@@babÇÅXmƒÝÅôVbÞblUÞVÞU°VUx@UV@l`¼nL@ĊLW¤kXķWġXUVVVķUbVb@°kVVxÈa@Č¦ĊbaźJU@ÈVl@XkôaWĢÞ@laĸUÆb²mÞLĠÞÑôbÒĊaJVbm¦"],encodeOffsets:[[93285,37030]]}},{type:"Feature",id:"6326",properties:{name:"果洛藏族自治州",cp:[99.3823,34.0466],childNum:6},geometry:{type:"Polygon",coordinates:["@@ÞVŤÈK@ĀlxV@Þ@wŎalmôLnXÆÜ@nV°@°WmVKŦLÆmȚÔÒUX¥l@ĢJV@ƾI@wW°Ån¥kÅÝVwôÈç@lÑĊĕaJnaÆLVw°kny°UnkÆVČĊll¦Vƾ@@nUźÈÇIn°XwÞKô¦VWV£@£°ókċ±Iam¯Va»ČĉV¥°@mk¥l@Ċm@aUmwX@wÆxmĢ_`VnÆbKVw@@nUVğVmVVöIll@@çÛm£UÇw°@VU¯»m¯JōĖÅLa@»ĉĢ±`U_k`ÇçókXlK@akÝÞ£WċkÝkxJÝ¯ÅwxķxmIÅx@k±J@ýŋ¤UkmV°ÅÝxkwmġnÝVU¦ŤlmóXk¤UKç@mVkK@klī£m¯VUbW¯¼ċb¯ĵam¼mVXm@k¤ÇXÇbU¯J¯¯È@bVXVÒ¤V¼kxÝV@lVWxÛ¦W¯mKnlkU@nƑUĉÝ@ÇºÛċUĉ¥UÞÅz±òL±Ò¯xX±ÒLÝU@lV¦¯ÇbkêÇJnU@ÆIxn¦@²Čè¦è"],encodeOffsets:[[99709,36130]]}},{type:"Feature",id:"6325",properties:{name:"海南藏族自治州",cp:[100.3711,35.9418],childNum:5},geometry:{type:"Polygon",coordinates:["@@Vxń@ĊĠĊXÒ°UƾĕÞm°£nb@@LUUWÛº@nlÆǬĠ£ÞV°UXbVȂǵé@kWanm°@xzK°¯ĠVVkwLnm°kÞxÆa¥@wnĉÆ@_l_VwmĸèŤÅČU@Wn@ÑmKUnğK@°¯UÿV£nmLlUUÛé±óókkmnakV@Ç°óÝXWəÞťIţxmmVÛUVȂÓnWyȁĉkV°WnkĊa¥_K°ÿWna@mU¯wlÝIU¤UXó¥ÝLx¯WmJÇÈŹmV@ƽ@Uk¥ĉkċÅUml¯Vmz¯lUxÅKmbIbĉĖkÒ@ÇèóUxÆÞlm¦Æ¯X@x@²ÝlÈJV²klVl¯ÔlĉÆÞ°lUǖÞ@Ķ¼nUôôŚ"],encodeOffsets:[[101712,37632]]}},{type:"Feature",id:"6322",properties:{name:"海北藏族自治州",cp:[100.3711,37.9138],childNum:4},geometry:{type:"Polygon",coordinates:["@@ōmġxƽUm±LǿþġÔ@kxmWb¯I¯mIUx@bbŹVÇkĵblĉI¯¥Um@Æ¯È@aóUlČ»@w»wXaó°ţçÝkUaV¥ÅbÝw¯lmnKlxUğU¯°Lyw¯@mnXbl@êȁǶUWa¯VÝUğ¤ǫkÅ@mÜ¹XVV@K@ma¯¤ÝnƽĖ¯V@¼ôlèk¼¦xXlbnKÆx@bUx@nnxWJţ¦m¼ñ@°¦lUÞlÈ@ĠxÞUlxÒól¯bmIÝVÛaÝnxVbkbÇwÅÇKn±Kbb@VxLmÛŻbkVó@Źxó²Wkb@¯U¤źĊ@lUX°lÆôUlLXaV°wxUb°xÜôÈKVkÈmlwkÈKwKVUŤĉŎ»»Il¥na°LV»²¯Üy@wĢ°ĸwlwĢw°±_lVk@°bÆ¯z@l_@Ģ±lÅVlUaÞLVnKlnÈ°IllČawÞÑ°xUU@wVkmĠLô»KÞýôaÞ¥ôĀÞmÆmUŎV¥Èl°²°a²¥V@@wamm@Ñn@Æ£żVĠ£@W¯Þl@»@Uk@"],encodeOffsets:[[105087,37992]]}},{type:"Feature",id:"6323",properties:{name:"黄南藏族自治州",cp:[101.5686,35.1178],childNum:4},geometry:{type:"Polygon",coordinates:["@@ôl²ôÜêVVkKmnU¤VĀ¯°@LmĠVnLÈL@alb@al@n°V_XmWUÈamaVIn@naV£óVWU£°axÈ¥@aĊwÈ¹@óağbm@kw@maÆw@In¯mm@UkkWÑÅ@@kċÅçVkÝJÅkVykŹl¥@¯ĢUÜX¥òýmmXÝÅlmU@£WlyXW»Åbl@aI»k@klm@UxUUV¼¯XlaUnķI@x@¯KĉUU`ólČ¯ô@¤ÞJk°xVn@mbX¯ĀL`¦ĉbml¯XUlȂĊXzmȁÔUÜVUnnŤwŦJɚÝXÞW¯ô@ÈlUbmln"],encodeOffsets:[[103984,36344]]}},{type:"Feature",id:"6321",properties:{name:"海东地区",cp:[102.3706,36.2988],childNum:6},geometry:{type:"Polygon",coordinates:["@@@Òb¤ÆI°ôU¼°UnnWx@b¯L@lUUWbXxWlƨnxVUllXVUnL@lȀý²KVnƾĢwV»@mÞ£nÆÞÑmLKUaVżĕWVk²ÆÝ@Xw°@ô@a°wóUUmIkaVmÞwmkny¹VÿƧnÅm£X»naV±Ýw@ab@am¯ĉVó¦kÝWKUU@WanUb@ôÇºĉxb@Ç¦w¯bV¤UXôU¤bmm@UJnbÇbXVWn`¯Umk@@bka@bÇK"],encodeOffsets:[[104108,37030]]}},{type:"Feature",id:"6301",properties:{name:"西宁市",cp:[101.4038,36.8207],childNum:4},geometry:{type:"Polygon",coordinates:["@@@kmKVUWkVkUmwƧXkWwXaVV@k°K@aXwmmV¯V»¯óÅJ£amX@ċVţÆķçnUx`k`@ÅmĊx@¦U¦blVÞŤèô¯Wbx¼@xċ¼kVôbÇ@Å°@nV°¦ĊJkĶalÈźUa@aVwnJ°°JanXlw@ĢÓ"],encodeOffsets:[[104356,38042]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/51",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"5133",properties:{name:"甘孜藏族自治州",cp:[99.9207,31.0803],childNum:18},geometry:{type:"Polygon",coordinates:["@@aXam¯wm@±°wUwV@UaVw²KU@UU¥a@£ÞôxKnkmX¥IUÝUwlk°V@ÈKUwlkUyV¹mx²XllÑW»lw°UŎnJl¯°V@wôIVÇnnUllLVÇLô¼XW£@±@¥k_ÇJkUékwXa@Llw²Vxbm¼ÈxlLÈVWÞn¯mÇÑUÝlÛkwlĉmULmwUJç@wkm@ÑlUXÑôġVaUÑ¯@wķÓkbVmnU@@y¯IķKV@¹aé@kmÞU°¥@a¯@anKlblU¥@óğç@Çw@wklaçÝ±k¯±@ğÝUÛmÝ¯w@kb±¯akXWÜkXUÆÇU¤X_ƐwV@¤XUbUIUlÇUkġ@aXČmlUlèUV@mVk¦Vx@¦±¯¯¯anlW¯nÅw@w°KVak£m@klKknÇU»óKīlaUaV£@¯@ÆUVÛÝÇXÇlÓlŹ»WUğJ¯£mxLĵôºXVlUll²bllxónn°ÝU¼mJU¯nV@êĉ°Uĸw@m@¯kmXamÑ¯aUwÝKU¥mÅn¥Wmn¹n±ƑƆÇôXê±ǊnUôlĖkȂVÒ¯¼VnȮ¯ĀnƆĢ@k°V°¯ĢVlkVxm¼X²Ŏ@VxknWÜ°U¯nÆÝ@`ôÝ²ÒÇznmX@xè°K°ÅUČĬóĖÝó¼ÅêÒbmk@V@Òl@nĉÜêx@ĖmlÅJ¯¦óxȭ°Ým¯LĵèĀ@Æl°żX@xmkV@z@°blnÞ°J@bn@Æ¼UVUóóL°X°ÝLxUn°Ĭn@lnL@Æ@nKÆxnUnVInĬmÆnxŎ¼ĊIĢóÞ@ĊƨbUmV¥lkwnLmÅÆ¥XwU@wwUÞ@alUUÅUVkkm°aU°Ó°w°Ub°a²K¯ĕ@ÈbÞĊa»XVm°InĬk¼VbaJô£VĊankůnÜU@anKnĮbÈmÆ»nIé£Ġ"],encodeOffsets:[[103073,33295]]}},{type:"Feature",id:"5132",properties:{name:"阿坝藏族羌族自治州",cp:[102.4805,32.4536],childNum:13},geometry:{type:"Polygon",coordinates:["@@l@@þ²I@lVL°wnJ°UĸŎèIlwV°¤nĮ¤ÝlèL@@xlè²ôĊ_ĊġVÈôJżīlbXÆÈVkxÇVn°¦Üb@è@nn@@°UÈ¥WÇ_Uala¯¯UÇk»mVwk»k²°VxlL@¤_@x`ÈĖöb@l²alXa@bnK°¦VK@nnWmx@nUnl@@llĉk°l°UXkmW@Un`kÇLWÛÈVxVVlVk@lIXb@ylXÈWĮWŤzy@mI²J@n°@VJ°aÅ@ŎkVÇkaUwKVwV@nkm@±ôkôĊJ¼InÑm±nIÞXÈĊxĊUÈbÜyÈ£Vkw@kVUVm@a»ÜbÈmUXwÝxUn¥@°ġÅaJVkaW¯Û@W¥UŏĶ@¯kUŃ@aI@mmanwÞW@mw°»Uřk¹±WxVx¯¦U°zţWw@°ÇVÑk¯@y°a£@mnl¼aÝÝakwU±aĉImlĵn@m@kkV¯Ñmĸ°xl@XVÞmlÛÝĉUÅ¥mwÅ¥VaUwXġċaVůÛŹlwU¯Uó±xÛV±¯¯n¯mċLmnĊm@_kJWaXmwUĉK»@mwXÝUÇkKÇw»naUw±kxK@WbxlVêlÈIl`@¦@²X¤Wó»KUÈKkkmVmUÈóJ@x¯Uk°Imō¯VxkX¼Òkk±WwnUºVzklVxLÇ@¯UklVxÞVJW¦nmlLówÝ@¤b¦V@VV±LUxVbU@Vx¯x@²n°xnWbb"],encodeOffsets:[[103073,33295]]}},{type:"Feature",id:"5134",properties:{name:"凉山彝族自治州",cp:[101.9641,27.6746],childNum:17},geometry:{type:"Polygon",coordinates:["@@ĶóKnw°¤ĠIXV¼kźÔkÈWÞÈÜUVÅ°@@U¤VbkbĬôL¼ÈVlmLlkn@l¤Ub¯L@xÆx°mXmk°b°°²@¥Uwl¥nU@VUkçVnkWċbĢ@lÈVVkJVaVW@£UƏxW`£ÈVVÅlWXÛlW°b²la@°xnÞVÜĠÞ²@l°Þ²èkbl@xÈx@Ġènal£nUÇ²@ÞKnn¤@¼°U¼nVXUbnĠUVbUlV°LX@lVèÜUnK@_yXVyUwmIU»VkÇ¥ÿkkV¯m±n@n¯ÜanVVÆz@bwÜbm@wa@kmk»@a@VUUów@nb°mXmnVbÞVôanwJak£lwLÅnÝ@wl¥IÇÓ@UL¼kVÇÅó¯kVmmw@n_Vn»°LÅ»@éÇçŹīVÇÝ@ÝğUaVÝ¯ķlŭġl@óÞÛċ@¯nkUÓm±IVġUwóKUn±¯Kw»KÝVnl@óxUwţ£ĉUmÅÇÝKÝUlmK£UV@ÞÈW¦Ò@Ĭnny@nÒmV¼@°Vbl@VlnUUwl°a@@llnk°lbnKWĀnUVxU²Åm¦ÛÇÅaUVb@¦m`móXUmmxÅ@±Þnè²U¯»mVm@wU@wÝÝmLa@VÇUkl°¯VlkV¦UmxaULUèVx@kIUxmWV¼¯VmÈ¯UnlÈ@m»ÅVWxÅbÅğW@km@kVV¦mlnn@ōl¦ÅÆxk"],encodeOffsets:[[102466,28756]]}},{type:"Feature",id:"5107",properties:{name:"绵阳市",cp:[104.7327,31.8713],childNum:8},geometry:{type:"Polygon",coordinates:["@@ńlV°@ŐĵVX»ÆUĊÑJw@È»m»£°Kk@ÇnÑÆ@w°JUwnw@wbVb@VlźLUwa»aUklyUUVakwWXwWUxkLmn¥mwkUXlJw@aIk°X¥W²l¥aUIlmkklÈL@m°nlWUaW@V@UaV¥@ak@Çk¹K@aK@kKkÇX@VU@kx±VèkIWwUVUkkKÇ@a@wkml¯@kUWn£WaaVwnaVÝw¯@UaWxnJÅUxUma@L@mbUU±VVnkxUÆVm@kkKW°X@¤ÇUkÆÇnU¦¯kmLVwÅK@UóbÇÆV¦L@±êX¦mVÞkÜÝnWU@k¯wķn°ÒUlln@@ĶmnkĊJ²bVlxÞbÞbk»mn@¤¯bz@l°UÒ¯È@xŤXyV¯°¥Uww²XlºVŚ¯¼nx@XÝmxnb@nJ@b"],encodeOffsets:[[106448,33694]]}},{type:"Feature",id:"5117",properties:{name:"达州市",cp:[107.6111,31.333],childNum:7},geometry:{type:"Polygon",coordinates:["@@Uxn°bnlUnÒÆnn@n¤LnxlUV@Ælx°XXxl`XVWLè±nÈb°b@²x°KÜ¼°ĉV¦lJnU@¦ÞJÞğmLÞ»xUlbVÆannalVÆX@lnŎVmUmaÅXa@aWm@£@wĉJVkkkkmnk@mna@alKJ@ÞwmÅÅ@ambkU@KUġKU@mak¯±a@aĉÑÅaVwXlw±V¥l@@ak@@£mĉÝónWV@nÝÇÇxUmbaVkkk@m@m°ÝýXmakÅī@@mb@@xmnb@mxkWL@¯b@WUXmWWKkbm@kxXmm@LUlxlêóKnUallLlLó°m¯JVUK@xK²Āô¦l°"],encodeOffsets:[[109519,31917]]}},{type:"Feature",id:"5108",properties:{name:"广元市",cp:[105.6885,32.2284],childNum:5},geometry:{type:"Polygon",coordinates:["@@ÆLĊx°»Ŧ¦WLÈ@xÞKÜ°ÞnVxÅĀlÒnJ°a@wV¯l@XWknKnwVÈ°XXalX°VI°bWna¥@w°n@yÆ@nkÞ@°¯lJn°IÈlUlXÅ@ķlUV¥VUUÝÞUU@UwJUkĉm@ýlkWUwVwWJk@VUKlUkaVUmLkm@@UIk`@UmlUkV¯ÇXKÝ_mm¯@U`kwml¼±KV¯¯Vk±Vk±kzmaKUnÇ±bk¦±X¦¯WlJ@bxkIWVlxnm¦nlKVwXWxXlxUbVVkzVlb¼bVxŹKUk@Uaa@xmxVx¯Ix@ÅmÒ@Èl¯L¤n¼"],encodeOffsets:[[107146,33452]]}},{type:"Feature",id:"5118",properties:{name:"雅安市",cp:[102.6672,29.8938],childNum:8},geometry:{type:"Polygon",coordinates:["@@ln@xèVInxVKnĊklxkÜVÞÒnÈm°nx@¼ĊLVnxWXblI`@nmĉnKČôÅlUÑmUK²¹@ÇÅVÓÅ¯VýÞWUVmXÆbnwKUÿ@UmmIUb¯¥Uw¯ÇmçmanUm»UUlk¤a¯bVU_WĕmÇÅ±ĢUlUlÛVçkU@W¯KUVkUağVmaVWUmV»¯@»m£mÝL±@ÈmVk¤mb@ô¦kVkamL@b°@b¯¦ÝVn@lêb@ºUĸL°J@zV@nmUlaĸÔ@x°VÒUbóĢÒWkV@Ò"],encodeOffsets:[[104727,30797]]}},{type:"Feature",id:"5115",properties:{name:"宜宾市",cp:[104.6558,28.548],childNum:10},geometry:{type:"Polygon",coordinates:["@@VlÈnlXnWLX`m²nV@b°xĢçlnVmnn@@°UzlV°nÞÒkxlw`UnVbmL@albÞKÈÛmÜ¼°@XÇ@wmW@ÅKĊLlVLVŎçÞL²±ğkw@Uy@¹lKXlKVa@wČ@w@aÇU¯n@@wġakaōK@Å»VakUWmķwkbğ¥mLak@ġÞ°¯xVVÞ@VxVVWxXlxU@k²WVÅULmèULVĊklĠVJVx±nÅ¯¦mwğ@mlğkkl±@kUk@¯±ÇKkxl¤bImx"],encodeOffsets:[[106099,29279]]}},{type:"Feature",id:"5111",properties:{name:"乐山市",cp:[103.5791,29.1742],childNum:9},geometry:{type:"Polygon",coordinates:["@@kVkÆkV²UlºÈIlxLXèÜlUXUmkbVèx°@@¼°Knnn@mÆIUbnJ@bVI°b°±@nK@mVakkKl¯nbmĸèl@VnÈlUUwwmwnm°¥LlLnU@VaImbkmKnk@mbLVJVUUVnkVmb@a¯JUaÆkk¥IW¥KlwÑmÝU¯kVy¯@@mmnUkmġè¯w@aU±mnW_XKWmkÇmUkóbUÝUanmW¯nma@xVôUV@b@l¼n@lb@xnÛaxa@yUÅmUÛbm°@mn²U°llĀÈ¦lUV¼nJVxUzWz@`mL"],encodeOffsets:[[105480,29993]]}},{type:"Feature",id:"5113",properties:{name:"南充市",cp:[106.2048,31.1517],childNum:7},geometry:{type:"Polygon",coordinates:["@@È²VmLnblyl²²UUl°U°²L»knlx_V°@nnÞ`WL°ÈUVlnkV@l_JV@n@lnKV£ÇUV¯m@laXUUbVx@VkôJU°Jn@wUk°wnUV_nJmknmm¯Vwk¯ó¥±ÿL@wLVUkUbX¯mykI@a±Kk¦ULmaXVm¯Kz±klUIVbÇJkL¯lUÿUlUkJUmUUkVVklKk@@aU@J²x¦kĬ@¼±ºXnWbxU@xx@lL@bLlº@Èl@bU¦Vb@U@XbVkX¯m@nÇKkllknJV"],encodeOffsets:[[107989,32282]]}},{type:"Feature",id:"5119",properties:{name:"巴中市",cp:[107.0618,31.9977],childNum:4},geometry:{type:"Polygon",coordinates:["@@VUlbkVVLUl@XIUxVxXkl@þĊnVlIVx@VVÝVÞUVU¦kV@ĸWÆô²@VÞn@Vaôb²W@K@XUmÑUW°¯°Ina@y_lWn¼lLUbô¼Kla@nkUyôÆx°@n£Ý@¥mVkIU¥Ċ¯Û»¯L±w@¯aÇa²mçKXUWk_Ww¯WwÅk@UkVmwK£@mmmÅmÑkVmamnnlmIU`Vm¯xVlx@m¯IVóIUl@UwVaVWkb@nU°VÈU¤"],encodeOffsets:[[108957,32569]]}},{type:"Feature",id:"5105",properties:{name:"泸州市",cp:[105.4578,28.493],childNum:5},geometry:{type:"Polygon",coordinates:["@@VVXwVKnwnVnl@b¯xmKUbVn°°X°@blLènV@Vnl@ULnmmUnaVV_ĶV@wnJl@@kkKVólaUwnJmwUlm@aUaôKVnJWbÞ@VwVLX¥VV_Þ`wWÞŹmmnIn¥W@kWV¯@°kILk¼Ç@k¤±XknmÝ¯UlÅÛKWV¯klUwkLÓ@U@w@ġXVWX@UbVbV_kÇVlU°lnwŎ¦ÞaÆ¯nmm¯Um¥nkVmkl_ó¥¯UÇl¯@Lk`¯ķLUy¯@mw¼ķ°ġ_ÅU°mlnÇVUÞ@_JUnVUXblĢb@x@mV°Èb@xċ@@xUbkLWkL@ºzV@lxĠ±²"],encodeOffsets:[[107674,29639]]}},{type:"Feature",id:"5101",properties:{name:"成都市",cp:[103.9526,30.7617],childNum:11},geometry:{type:"Polygon",coordinates:["@@°n°m²°ÜUw²ôV°VkxÜźUŰČbĢlaÈL»@kwVÇ@nÛÆ»ÈUÝ°Kl_V°U`Vbn@VbÈLaVU@ƨ»VnIlUUa±lIk±@VnKmÅ@WaK¦lVōkKÝ@maXÇmw¯IU@kVwUmVIçÿU±Å@¯È@xK@wLUbÇKÅ@mÝ£@yóUóóUxkI@WlIUabaVĀLmxÅaWUnVÝXUþÆ°UÔÈÆ@±ºLnVVÒkóÆ"],encodeOffsets:[[105492,31534]]}},{type:"Feature",id:"5120",properties:{name:"资阳市",cp:[104.9744,30.1575],childNum:4},geometry:{type:"Polygon",coordinates:["@@èUJVnxU@lV°JnxWÈnbÞ@lLŎUk¥LXbÆ@nmLU@zlbXmlnVynLçJVbUnómUnamUan¥lKV_²aValWôn@nbVK°¯VblW@kklUnlV£°W@wUXk°KVwmVkwVyVI@wkmVÅ_Umm@Uÿmbk£xUaVw±V¼V¤kLWxU@UkbyXóm°V@@zÝÒkKn±U@@_VVkÇaVwnLWalm@@kkVVl¦kIV`±n@wKk²aVUUV¤nkxmUkVWVnLUbVb`kUUmLUmX@`ÅbÇXbWLXn"],encodeOffsets:[[106695,31062]]}},{type:"Feature",id:"5104",properties:{name:"攀枝花市",cp:[101.6895,26.7133],childNum:3},geometry:{type:"Polygon",coordinates:["@@bKÞnÞ@xV@xnUn°¼V±mç²ÝÆ@wnnVWnôn_@¥UaVbÆÈÜn¥Æ±VUwVmXÿmLkal¯km@k@¯bkVxmVUkk@Ua@¯»UnmÑ@mzm@īÑX¥Ç@ÝxU¦ÅÇUkx@lbUWVXmV@xĵĖ±@@¯xUÆLnÆmx@nXL±lUUVwKWak@WxkbÞĉbUn@@@xó¦Ŏ"],encodeOffsets:[[103602,27816]]}},{type:"Feature",id:"5114",properties:{name:"眉山市",cp:[103.8098,30.0146],childNum:6},geometry:{type:"Polygon",coordinates:["@@Vx°¦VanJVn@baVbkJ@XlJVwôôôV@zÞ¤@nÆÈLVaK@xL@w°ÇÆ@²VĀmWXKWaÈÆa@_nWVnKVlV_UaVamKXUWwnmmwÑm£@ynUkWĉUkWVkkV±çkJmkKK¯¦mnnxxVxVÇkUmk@çķnmak°LllUb@nmL@¯²¯aUJ@amIVaÅJnm@mm¯L@»¯@wUçanlVWVÛkWçKkwÇJk¹±VUÅlġV²ÈÆnXĖV`U°ab£lkVVn¼mVnbèÈn°"],encodeOffsets:[[105683,30685]]}},{type:"Feature",id:"5116",properties:{name:"广安市",cp:[106.6333,30.4376],childNum:5},geometry:{type:"Polygon",coordinates:["@@VlIVkVĀVk°lKÈIUaVJlk²yLn°UWnbVKl¥²L@blJnzW°alV°Inô¯KkKkkbVmôLkéwVk@KnnWlwn@laXLnXVW@X°a@XKlnw@man@w@na@@wĕġġwUkUWb@mk@¦¥mUÛb±yÅn@bml@kV@lknVbmVnlmbÇk¯bWyk@V_UamJ@I@WaVXamIVWkUkbVaUUx@VnkVU¼bkKUxmK@WxnV@n"],encodeOffsets:[[108518,31208]]}},{type:"Feature",id:"5106",properties:{name:"德阳市",cp:[104.48,31.1133],childNum:6},geometry:{type:"Polygon",coordinates:["@@nUW¥²é@K¥UÈÅôa@VÆLUxnKl°V¥ÈmlÅÈV@£WX¯lLln@UVÅlwUm²UVVna@@KnbVVwÆImXwWkIVwÝĕVUaIèmKUzkmWnka@y@l²kJ²VbVkmJUƧ¼@UVbÇKUam@Ua_¯VUk`¯LVÞÇÅ¼mÜ@UÈx@l¼ÇKkbWVxUbÆ¦nxÆ¦ĊV"],encodeOffsets:[[106594,32457]]}},{type:"Feature",id:"5110",properties:{name:"内江市",cp:[104.8535,29.6136],childNum:4},geometry:{type:"Polygon",coordinates:["@@²èlUUllXĊVXlmV@zn¤ÒnxmnXxlUnVlwmU£VVUbl±L@x²mU_lJ¥UklU@ln@kXbmKUxÈblUU@`V@²mlLÞÑ@yU@¯ônWzaVlV@XwlKU£»aVaUwm@mwUVUwklVÇ²LlKVm_@ykUm@mUçkKmxkIUÝ@LUJ@n±kºLXb¼@mmIXa@mamnkWKUx_U`UklwUwmUbV²akbmkn@`UmÒVxUbI`UaÝÈ"],encodeOffsets:[[106774,30342]]}},{type:"Feature",id:"5109",properties:{name:"遂宁市",cp:[105.5347,30.6683],childNum:4},geometry:{type:"Polygon",coordinates:["@@ÞĖUxlJXVb°@xUÞmbUxbXbm¤VX@lk°ln@xbÈ@lLVlVUXxlJç²UlwV@@UÈWlLw@wVwXaWm²¹@»lī¥w±I@V@bl@kLUllUVVn@mmUwXċbVb@VUkbmamW@ka@k@laUa@¯b@mmwó@@lkXUa¯°LUamm@ókXUb±bU`kLm¦bnVmbnVmô"],encodeOffsets:[[107595,31270]]}},{type:"Feature",id:"5103",properties:{name:"自贡市",cp:[104.6667,29.2786],childNum:3},geometry:{type:"Polygon",coordinates:["@@lIÞÇbV_JVaUwnÑV@_lmnlab±UVanVxkxVlV_`wVLlXnmnb@WbnJ@n»WaKl¹²@mVI@KÞVlJnw@aW¯¯¯UmVanL°w@akmmUxmULWxUUÝKōèUKUkĉKL@ÆnX@xWÈ¯@Û»nÇÜÝLka@bKnUaVm_xkLX¦Jl¦ÅlVb°I@bnaUmlUVUVIUKa@nmlnLlnaJUbV@"],encodeOffsets:[[106752,30347]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/23",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"2311",properties:{name:"黑河市",cp:[127.1448,49.2957],childNum:6},geometry:{type:"Polygon",coordinates:["@@VÈÞ@kxnX°VÈa°V@kôwbJVkXlVUx@lL@xkVV°VbxlVUnVxk@KkVbIl@°kVl@lÆnkll@@VVX@V²bUlVlVUVÇn@nkJlkVb@x²V@n°VUnlKUn`@n°bWLnVUblVUVVbknV`°kkl@@V°@nzJ@XxlWXb°n@bĠlbXbbVbJ@Vba@@lbUbVmn@lVmnIW@WbÞ@n@x°@ĢaƐéϚnlČ¯ĠŻÈwm@ôçUmm£Xy°UV@wÈ£Ǫ¯kõÝçUÑUķĢkVÑÆÞU°nŎ¥ČUĊx°m°¦żVƐx°Ç£@yUônÞÆ@Èĉ°Kô¦WkWUbÇ»@ÈĕWÇÈ£ŤU@n£ÆUUKVamanwÅmÝJ¯k@JIkaVaUUÇbkaÆÑkWmÝUÛÝ@wnU±@kkV¯KUkJ¼U¦Å@ówķaķůV¥Uaó@Åwm_kVwĉĉmmn_V»a@UVwķóU¦LǫéóXÇmōLǓÇķxÝkĉkmakbUĶ°@W¼@bÈÆ@ĖLl@°J¯mkl¯LÝ±LamJ@¼VƧUóUXċb¯ńVbkÆÝI@llxk°V²V@UxÞL@b@b`ÇzkókÝ¤@ğ¯WLĉÇLmmnċVkbUaL@¯bU°ğLÝÝ@"],encodeOffsets:[[127744,50102]]}},{type:"Feature",id:"2327",properties:{name:"大兴安岭地区",cp:[124.1016,52.2345],childNum:3},geometry:{type:"Polygon",coordinates:["@@kϙmƏêġb¯@@wmÝ@XV@Ill@bUxl¯VlVbV@ULVlUV_kxVVVÈÝJ@¯Ulm¯x@xóÒĉ¼m¯Wxţ@Uz¯WwnUwť@knW£óVUUwğyó¦WIVmmI@±kwÇ@@b@ĉ¼ó@¯wó@¯aó¼KÅaUwmWUwÅI@aKó@UaLaVÅwō¼UUÝl±I¤VxÇx@zkJmnnmbnzxll¯ČkJl°@kbmx@x@kêmVnWxôXxU°bWLóJnÇWĵV¦UUbbÆġKk¯VU±aXmċÑUwĉKġkVxkÇKkbIÛXWl¯bX¯KbĊÞVÆnĸ²lxU°n°òÈb¦xVb@¯Vx@¯VķÞČlĊ°KĸȘI°¤ČIôò»ƨnȰKǬ¦ôWŎÈƨwlnKVXmbX`lbwkVWXXL°aƾaĊ£n°@°¥ŎzÞ¥»alwôkƒJa@ĶK£bU°ĊxźVÈUĠ¥ƨVI@XU°x°Ln¥w°UmwXmÝV¥Ģ°@nU@mÆ£¯lKÜw@aÅU¥UaÝIkmV²nn@Ķ»@Uk¥VKÞ@ÞÛ@kVmĢa@_Jómǖ¯ÆwóÇa@alUwwĢřk@wÆWXUWXWam@_ƒ»ÇéXaĸwVa@ÝKkUWkXkKXxn@lĊV@¯m¯nřÆw¥"],encodeOffsets:[[130084,52206]]}},{type:"Feature",id:"2301",properties:{name:"哈尔滨市",cp:[127.9688,45.368],childNum:11},geometry:{type:"Polygon",coordinates:["@@°`_JlU@@V¦°JUnLôlnŤ@@ÈaUÒVbkbl¤zk°ÇVÛô°IlVUVôUxÆU@bźĀº@¦b@l²UVl@°ÒĠxnXxÆVô¼Þ@Üx²KÞlVÑ°UȰôlwô@²ĸ°lanV@VŎUll@bÈnÜmwĢ@la@ÝÞb°UXblŎ²ÆkVI@nJnĠ°knÜbĢwna@akÞKƒĀaIVbU¥wĠwkôxnLċVçkaU±IUmnġW°WôĉalÞÅĵ¯@W¹XÝab¯a±X¯ºLaVmkLóbkaVUKVkkKV_@aÝykk±L@ÅU@yV_aU¥ówÇx@UkVn@lkÅlwWVwUkĉmkklW@abVwnWWwWL@UUÇLÇm@wJĉL¥@Ý_@a¯yUWw¯¯Uġx¯aÝXVmaU£ó±¯nwa¯óÅVXmanUlUXkWa@mkIğamIklÇUkĊzkKlUōĬl@nX°@llUxŹ²mKĉVWwk@UbUK@bmVmIVmwaWxXlWČmºÞÆbUxV@ĵńWÆĉLkWUbaWzkbĉ`U±LklōwUVÝ£UW`Uwk@mk¯VkaõVX@WbLK@XƧºWzxK@lmX@bkVVÆk¼Vbk@Vn"],encodeOffsets:[[128712,46604]]}},{type:"Feature",id:"2302",properties:{name:"齐齐哈尔市",cp:[124.541,47.5818],childNum:11},geometry:{type:"Polygon",coordinates:["@@Þ@ÞĠKV¯a°@KVblaČUmnnKĊÈKX°Ġ@Þ£ôllÈy_@a@aKÝVwU@±¯Ulkw@kÞJlÅUa°ŃČaWVôƨVU@»nIb²KÞ°Klkn°¯I@kK@ĕÇÅ@aX»¯@VĵlaÿVamI@aÅÝउýĊȗJôȁÅkmƑÛ@kxġ@@laVk¯»īŹak¥Å¯JUaWU@@wa»KUkÆkUmUmwÛ±±UUbUUXwWwÆÝklkUanaWwnKlkal¯kaƽakÅxa¯@amb¯VlÇwÛĀV@xmêVÆVVaôVwÈx@ˌx¦VÞ¯VlmX@L@¯Ua¯LmV@°XċKV@UÈ@¥@wġIUkm¥Źw¦¯lmn@°kxVV@¦óamn¦l@nxlĉVómxnÒĉĀĊ¼þǔêÞ°ˌĠÞÒ°ĀɲĀƨźˤȤƨĊ°w@£nymwnkUUV¥ôÑVmkÆmUUVamVIkmôlxkXÞþbll@kVƆVxV@¼VÒ@UnnÞJ"],encodeOffsets:[[127744,50102]]}},{type:"Feature",id:"2310",properties:{name:"牡丹江市",cp:[129.7815,44.7089],childNum:7},geometry:{type:"Polygon",coordinates:["@@U`lLUlVLUlbaôlKnUbK°¹²W°baÞbknyUlUkamř²L@m°@lm²n`ôÅlKxÜKnxV@l@ÅXyW_k@wmŹĕmX»Ûl°ôÈ»ôô_WW@Ual»wU@@wUV@VXI@wĢ͑ÞȻaU_@mUkly@¯óV»XmWUXUWmnm¥nUUaWLk»Æ²IÇawÅaÝ°¯nUa±a@¦õÆğ@@ÅbxUÜnÇłlb¯¦ôó»m@±Uk@Wwa¯xUV°xXbÇÅUVK@¹KUaȯ@ōÝXallÛkalÇUǫÇÅÇakbÝƆ¯nl¯@¼VUx@x¯W¼Æ¯mĖĬ¯ČVkķÅmx°ô²V¤bUnÞW°bĢw°V°XxV°z@bÞ`@¦KĊI@xnÈÈKV@VXKxXmXUxab@kXllĊnVlUxXkxlÆkm@UVl@ÈwôxV¦bU`@zÆV@²KllÞz@b"],encodeOffsets:[[132672,46936]]}},{type:"Feature",id:"2312",properties:{name:"绥化市",cp:[126.7163,46.8018],childNum:10},geometry:{type:"Polygon",coordinates:["@@ऊþÆÞ@bnJUbĀnblĊÞlĸwǔÈŎKÈnôWǬêKV¥ĸôUx@VbU¼m`nnĊĊxlUmkaVÿLw@°»UmbKmÝUwUmVknKUUl¯KUUÈnK@ĠkX±lX°L@¯¥@wV_mĵ¯WwL¯UkōÇVUlwVó±¯aVka°wVk°mÞ¯ŦřÆl²ŎkU@mUkb¯ķ±ó@kxȯó¯VUÒkÝ±LÛwÝ@ó»ÅUWwmğw¯Ñ@UkV±@ka@¥¹Źÿ@aÅVwóVVUkU¯JÜóÈUl¯yk£laUaVÑÇb@ţ@kmómKV¯IU¥@@kVI`@ô¼blUlbÈb@xÇKkĢɳaÅɆō@VK@z@@¥ÆKnÜ@@aÛUwwnUķ@_V°@klVnULVVÞbVl@°@nxn°LÅÆlVÈmU²@VmĠLxn¯xkWzJwnLmbXbW°Æ²@x@JVxLĀ²Æ°I¯ºÈ@ÒnÈ"],encodeOffsets:[[128352,48421]]}},{type:"Feature",id:"2307",properties:{name:"伊春市",cp:[129.1992,47.9608],childNum:3},geometry:{type:"Polygon",coordinates:["@@K¯kWW²ğl@mLÇVVLk°VVmLUlVnxVnÞLnaV¯¼@xKUĀlbn`nÆxô@VbU¦ĸŰĸbôxÆ@V¥»IVl°LUll@²mVx@ÞÜÞVnlXÅÒlbÈaVVUblbJ@I°lÞInÆmxnbUbVLÅVm¤@ţVÇ¤XÈÇĖ@È¼aXVÜaXbWnzŎařKôbUlw@¯naÆKnUU¯Üa@mkkVUĊmżÝǖK°L²lÆI@¯¥ĉƛVaÞk@ÝVaĠlnUVwóma@wĉ@aVxamX@a@UaÅLaVW_nWm£nWm_ÅV¯m@mó¤Ý¦¯ÅalmX£VWUÅwmÇ@@IVWUw@aI@k@wŎ»WÅVaKIka@¥lUkUlwÅwVyÈwWU@a¯U°mÇ@UçaVa¯mV»ÅwÝUlUkV@kmUkX£w°@@ÇaÝIamÛam¯lğmmI@JUl±ÅōkWa¯VÝa@Þkbġ@xÛnÇm@akkōVōl±kÅťŚÝ°¯nUl¯xlbU°b²ôUxkVÈUŎVl°KXxĶ°nU`@x°¦@"],encodeOffsets:[[131637,48556]]}},{type:"Feature",id:"2308",properties:{name:"佳木斯市",cp:[133.0005,47.5763],childNum:7},geometry:{type:"Polygon",coordinates:["@@nbÞJb@È¯@xW¤Vln@lUVlkÞVÆxU¼°nUbbVèÈ@nIn@ĢmlUw°żVUn@lnL@VôbwĊlJķĸĢlwôwƨxVVUŦxLźÈ°`nnĠwŎJÞĶwôJ@¤XnÜĸln°¼È°lUbx@l@ÞÞÈm°lôwL°¼ĸ°Þ²nĠ@ôwÞ`ŤIVÒĠU@VJĸbÆ²@°ĊKJĶaĢȰ@ô¥°n¤bČU@VxmUw@aÝţÇķ@ĕķīU¯²@ÆmVÑô¯X¥ċç@ĉ»U¥ÝţKWVÅkUVÝŎUmÇÝx¯aķxÛUóL¯a±óōb¯ÑÅVÿ_Åķa@UK@wm@Van@UmmLVa@VImmXUWÝUÅKUwÝUUkVk@l¯XÅ_J¯kJmÅLa@¥U@¯Vz¯@`@¼mxƥŏKÛk@±laÛ@@Xm@@xƽ@WŎnˣĕÅ@@aÅ@@nÝbÇ¯@_UkUWkbwÝU@çWlw@anI¯lyX°m°VaÛm@mVwÞK°XlaXmm_@UkwÝK@VIXmV»I@a¯ğWbġaU_¯JU¯ġĉkō`±nÝÆkbóĊ¯XĢXmVn²JVlbUèČmKwlóğxxV¦UaJbƑÿÝLl@bmbġx"],encodeOffsets:[[132615,47740]]}},{type:"Feature",id:"2303",properties:{name:"鸡西市",cp:[132.7917,45.7361],childNum:4},geometry:{type:"Polygon",coordinates:["@@LKVVnkbVÈb²U°VnklVlaÈL@anU°ÜmXV`nôLèxlLXL²aVVmÈX@ķlnUÈl`È¹@Ť°U@xKnnVmlnnUllVnnaŎwlVÞÒ@n¦LV°lwVkLaÞlnÒ@xmLÞ¤Wn¼WÈLVVUxlÈôWVaU_VKKXUÆbnnôKbÞw°bÆWXamVwKUw¯WUkUlJUwVUa@@kmyzmĉw@kVwkW¯ÅKU_VmxU@aW@@kK@wa@K@@kVUaky°_Vmkna¯K@Lwġk@@IÇóXwVakmV@mwXUWanlĉ@ÇUwKóܛǊÛm°@wÅ@±b¯W¹WVwŹĕ¯kVmōb¯w@awmVUUbVIkaVwķxk¼b@VXXó`ó¼Çó¯kÜ¼WnźĖnxl@X`WzÆ"],encodeOffsets:[[133921,46716]]}},{type:"Feature",id:"2305",properties:{name:"双鸭山市",cp:[133.5938,46.7523],childNum:5},geometry:{type:"Polygon",coordinates:["@@UUwómÑÞÑUÝÝUkmmÅyV¯ī¥Uÿĉ¯mÇkaWbÅX¯aÝxaóLmmÅaWVLULV`UbXókÇVwUUÇKX»XmÝ£nK@wmÑkÝbKUlx¯kUKm¥@ÝÑkUōxmbUmkVkmmnkUmmL@w¯Vţ@Çºk_ÇmVk@ĸVxVÈ°lLkllUbōwnVW¼nlUx¯XmWUnÝ@xÝUó¼¯J@LVbkJWnkbW¯ÝLUxn@nÜb¯U¯nWkz°mJ@bkxX@èÞVxlaXlVV`°@ÈÞa@mÆ@@bÆ@ˤĖmXōƾ@@wn@@WÜ@kb@²ÜlŐLƦnw@»_°@y°UV@@¦bÆKnI°lIÆ`°W@kllUVÞVVxLÆÞVXWVnnUJ@UbnKVnm@Ubn@@xL@VbÆĸ`UĀÆÒ°Ŏa²ô°bôKÜVĸw°bÞwÈVnÞōVUÆlXU"],encodeOffsets:[[137577,48578]]}},{type:"Feature",id:"2306",properties:{name:"大庆市",cp:[124.7717,46.4282],childNum:5},geometry:{type:"Polygon",coordinates:["@@mÇ@ÑÇ°¹¯J±ÅÿKUwI@w@±ÅX¯WanamKxIylX°wmwğKUn±@nVÇUÅkÆ¯Kmmw@@¯UkÝaUUVKmUlk@¯U`ĸ@VmxVxÜ@bÛ@mÅL@¦@@yLUŎ@ÆɅɴblġÈL@wÇaakkVa»@ó¯_ÝJwÇaÅXnyU¯¥Å@wbÝaLmm@@VUlbğVm¯Xm_`¯_UxmLa¯b@maó¦Çk¤V@bóJknVxVXx±aLUbVxkLVlLWl@nX@VÅbWlÈnxbWÅbm@xbml°bXbWXVmnn`Lmnbmb@k@mwU@@¯Jlbk°lbkmLXxmbVbkllÅÞxXxVWVVa²VÜ²nxVVnÅlVlL¼b@xV@XVbIÆ°¦lźbĬ°¼Ulb@kĢ@lw@ƒÜlnȂÆóȘIĉ"],encodeOffsets:[[128352,48421]]}},{type:"Feature",id:"2304",properties:{name:"鹤岗市",cp:[130.4407,47.7081],childNum:3},geometry:{type:"Polygon",coordinates:["@@Þ¥ô£nn@°ÆUn`mXn¤mX`UXbÆKVb@@bnWbwUbĊ@x@nbWVm_mm@ó»UmÅWXkĠ»²¯¯nķwŎ@ĊŎK°bĸUnÑKČ¦ĠÈbÆknJÆUĢV°IVƾwaVkÇ¯¯»mķkÛWm@£óIĵxÝōIğxmm¯_ÇŹKwťUVUƧwóxxġkĸķIkĉxóa@UmK@kVmUŻ¯Vxkġn@mmJ¯n°V@bXVÇxUzÆxkxlVkV@¦lbJLUbÆXō¼@xl@J@bVxXU@JÈ@nxVÆUXW¤knÆb°"],encodeOffsets:[[132998,49478]]}},{type:"Feature",id:"2309",properties:{name:"七台河市",cp:[131.2756,45.9558],childNum:2},geometry:{type:"Polygon",coordinates:["@@²mŎ_lĊĢV°°IV`ĢbaĠX°@bJU¼WnUJ@ÞLlxV@n`lIUa@K°Iô»ÞVwÞ@VmnX°WVwmkX»UmŎxVaklkkKÇ¯UUwÇWUnU±bKWKkwçóKmU_nW¯ÛmV@bÇKkbkUml¯U±VÇaUamlUULKk@U@mwÛLwkLóÆm_±nk¯@@n±KnŚlbkVVmzlWXº@Ķ°"],encodeOffsets:[[133369,47228]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/62",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"6209",properties:{name:"酒泉市",cp:[96.2622,40.4517],childNum:8},geometry:{type:"Polygon",coordinates:["@@ÇnÅaĉ@U¯¥UŹ£WUýUU±JkkUwyÞIČxĊĕĊ¯¥ÆUkţUÅÓ±¼IUx¯UÒƑÝÅ°KÝnğ°ÅU@@Vn@þ¼¯WnŎ°XLWlnVnbWnVXxmbabóUlǕUUaIUmlU¥k¥ĉwkkÝɛa@¯U¯°mVkVnKlōÑÇÑU@klUġkUŻnUW@¯k»mWV£UKnUmUww@UIVaXwm»Èmmwn¯ċ¯LĉUJUalka±Va@Uk@ÛÑ¯WmnUaɝ¤Ûmn¯m±x@wóxÛLġÒUx¯VÈJUbózÝÇKĉ¯ōlÝUÅWl¯nťbÝ@¯ǩLġmV@Æ¯ĢkÆmĊkVťLɃmÝXó°@ĢbVóVÝ¦ɱ@ƧaġUVĠÇÈV¼UVţwmbJÇwˋaXmÇ¯KkkmbXm¼V¼ǬŚ²¤ôŰÆƴô̐ŤǪnɆӨ¼ɆLÆłUĊxŎƞȘǔˎǬǪnƨŮǬö°»ġÞÜÆĸÒĊǀbƾèôÈ@¼¯þŤĸƧ°VĀ¯b@lÈĊʠń̐ȘKǀֲॗţÿǕý@ʊǓƨóÆÑǖŃôw@΋ʈƆÅÈVVĊVóĊÅ@ÞƒĬV@Þī@°V@ĸĢ°XτƜĠ@ÈaÜ¥ŐƅnğóĕVġUůƿŋĕa±VUťÇğÑ"],encodeOffsets:[[101892,40821]]}},{type:"Feature",id:"6207",properties:{name:"张掖市",cp:[99.7998,38.7433],childNum:9},geometry:{type:"Polygon",coordinates:["@@ÈÒŎÒkmLUlU¯nV°@°ɜbÞĠaÈ»ĸlLVUÈ@Ċ@ýUm@@ÆVĠ¯ÞmLÆ¯ÞƒÑ°VVwJ²»ÆÔVlŤÅV¦ĉ°ĉĖċwÝJzVxll²IVVVþX¤źV°¦VĊ@ÆbÈmǔLĸĠ¯Ģaô¯ĸmÆÛUlÇĸk°XyĊUǔVǩnmV»a@ýnK°n@l¥@»żĊ¤mç@£ČU@mmVkÞUƐ±²¹°ĠwÅƑŃU¯V¯aÈŁÇ»ġn_°xŎKlxklx@Þw@Æm²bÇ²LlkWXať¯ĊaÑK±w@wUÅçV±Uk@@¯¯xU±±UU°ōxVxÅÔō°ó¯UÝ¦óbÝþ@ĉÈóUVUx@VUVÝwÅÈÇóVkk¯JÇkmmL@KÇx@bk@U°ķ²ó`mn¯°UwlÅkU`¦ɛôķz@ÅnÇ°U¼¯KmVk²J¼ƏÞķô¤UL@mnğ`ÇnUxÇ@ÛÿU@kŻ@x@móJkÅ¥VŹĉóÒĉlċ°ķUƽÜ@x"],encodeOffsets:[[99720,40090]]}},{type:"Feature",id:"6230",properties:{name:"甘南藏族自治州",cp:[102.9199,34.6893],childNum:9},geometry:{type:"Polygon",coordinates:["@@ÞnKlnwX¥WÝXkxÞUn°aĊVnUUKlÞĶWXnĠ¥ô»@nmVL@¤°VzJanU@aÆwna@kU¯yX_aĉbwéXkWwÅa¯V¥m¯UI@@mb°aÈçU¥@»knwɜƇ°I°ÑÈmVU¯Xa@wW@wV¯Č¥l¯Uwnm@kaUaóKkk@Çab@ÒWa¯IÇxÛam¼VUxÒl@zÝÒ¯bÝaĉVĉwÇWzJmJn²mÜ¯U¯ĉ@ġ¤Åb@²nml@@ULVxVU¼Ålmab@°l@WIU¯@m@ó@UzţyXÇUÇVUUVLkbWakVWmUbkkKUÆ»n°Knk@aUVmnk»l¯Ģlw@_kKVU@na@lUk@¯¥mV@kmbWb¯Åõa@mkU@kÇkU@`@óóbl¼Uxn¼lVÈx@blVkVVn`XÈġÈ@ÇK£ÝJmUUnUĖmlUmKUnVÅaUwUĉ`¯n¯wW¼nxV@bĉnkIċŘkXU±ÒxÈ@X°`lVIÈ¯ĊVVVan@VaUVażVmblkÈWWIXaalL@wVbV¦lL@lĠnÒUnkL@ÆÞkÞKbñþW¦ÛċVULUºkÈlŎUxÆxÞUUxÒx@XbL@lÆ@ÒlXVln@bm¼J@Ånx@bnĠmxVXmbÈè@Ċ£ČWw"],encodeOffsets:[[105210,36349]]}},{type:"Feature",id:"6206",properties:{name:"武威市",cp:[103.0188,38.1061],childNum:4},geometry:{type:"Polygon",coordinates:["@@±¯¥@klwU»ÞÝmwKm¯ç@kVÇUL¯lVUKġġm@a@U@X£°l°LŎÇ@aōVÝwÔKUÅWJ¯lm@ÛVWa@klĉUmaLUanak¯J±KkXóÜÅx²Ç@nUÒĊb°@ÆkLXÇÆ@xÝnxWxţ¯¤I@ÆnVVVlU²ÆèV@x²xLÒĉbŦ°WbXklÞ@l¤XĊ`wl@ĢÈŎm@bnVUb@ÈÆÛLèÇUÒÅ¦lĸ`°ĮʟÆǓbĉôϚĊÆĢnŤé΀ÑĸĀĊ¦@@l°l¦Ȯ¦ɆÞĊKŤĵĸů»mŁyġķŭ@Çɱȭ¯mƧUĊķnŁŻ»UaUƛɞÝƨů"],encodeOffsets:[[106336,38543]]}},{type:"Feature",id:"6212",properties:{name:"陇南市",cp:[105.304,33.5632],childNum:9},geometry:{type:"Polygon",coordinates:["@@ÈÞ@l`UmV¼@nnÆwVlnVVaLVÈ_ÿÞ@naxÆ@l_@VxnK@llLnxmÈŎJnbUxI°l@n¦lÈIlmX¥k°@kJk²é@klaUaVaU@@ÝnIWnmnxkºÞaV°V@nwKxôbÞ£VUbþLn»mVwIJ°@nb@°°IġUkÇKV@Å¯»lLnm£@anK@ÑÜn@»mL@£ykUUmbUÞÝ@kyÇbó»XUxWVzb±mÝbXawUamL¯»@wUKVwm¯ĵJ°ÅUWVkKVk°wÈVVÑlU¥kmVamknUw¯¯bċ¥ÅKkKkVċVk£kKVwÑa@kóyÛ¯ÇVkówXō¥Ç¼ów¯U±k@xIĉÒÅVmÈnÜ@n°bUbÝVUnnJ¯Į@m¦nVÜ@L°JXbÑ@aÈb@llôLVbb@lmnVxk°ċ¦U°@xX@xWb°UVÇn¯Ò¯Jɛƈmxl@¼"],encodeOffsets:[[106527,34943]]}},{type:"Feature",id:"6210",properties:{name:"庆阳市",cp:[107.5342,36.2],childNum:8},geometry:{type:"Polygon",coordinates:["@@kwĉ»VamV¯wIóVkl¯KmVō¯ÝWkL@bÝKō¦@@Lx@b@la@km@@l¯nm@UaÅ@óWUXm¥nw`@UUxķôÇ°ğ¦@VJ_nIVnalxkXJWn¯nVLxl¤nnVbklVX@xnxmV@bUK@nm@@xV°±aÅnkUWnUax@mn@¯LmUĀlU@lV@blLUblxklkIÇx¯°UXbaVUnV@°LUlnbX@`°nVmbnÆmVkLmK¦U@Xy@kl@U°K@¼XbW@bWnLVaVVz@xlVČ¥lbUxÞlVU@nÆWôn²VJlUƧLnmÜLXan@mw@wlUlV²mblwVÈlLÞ±@lVnUlxnkma@mkJ@kXVU@mn@¼VXUVlLnmVbôaVnWV»ÈUl°È¯ÆInÆU@kk»mKkÆġk¯@»mk¯@óÇlÇ@VykklUml¯Þ@w"],encodeOffsets:[[111229,36383]]}},{type:"Feature",id:"6204",properties:{name:"白银市",cp:[104.8645,36.5076],childNum:6},geometry:{type:"Polygon",coordinates:["@@VKUÈl@è°nLnxÝÞV¼kx@l¦²°ĊóĠĊ»@ÈxaĊxlwÈVŤa@¯²aÇ£Jk£lnUÞ@°ô@ywl»lIX¥Ǫnw@ÑÞWlaÅlL@Uwĉakl@¯mwna°JV¯nUVÓÞÑm£²óWaUÇ@óÝUçV»ÈkkW@¯xV@XlK@wX@Vmm_@wÈÝKU¯ÇwVwÅK¯VkJXkWVaIm¯UkÇlVĀV°mxók@¼óWxĉÜU@UbzÛJÇk@ÆnVlÔ@kxô@ĬWL¯K@aÛImm@IUa@UÇêU¤VÒÇx¯ÒVlk@Wbĉ¦UbkWV_y¯Laók@b@nmbkx°"],encodeOffsets:[[106077,37885]]}},{type:"Feature",id:"6211",properties:{name:"定西市",cp:[104.5569,35.0848],childNum:7},geometry:{type:"Polygon",coordinates:["@@aV²wVJV_@LlanÅllŦçÜÓ_lnWaôkxUbmV@È°lènk°l¦`@nnL@ÈlÜIyVaV@ĊÛXwô@»lônwU¯ÿUÈkl°VnJUblXWIl°UV@aVVVmnL@lUUwmk£bV¥VUVwÛlaÇÝÞmk£LUy¯L@WlkKW_XaWmġU@akakXkmVwmŹVUbWónmwnWW£KÈnV¥¥Æ_klWbU¯V°aôbnaVwmaōInÇmwkK@kmLUw@`kÅ@wb@mÝĀÇ`UKUbmUUkÅxmm@»nUVk_Ý@Ç¦VÇè¯ban@@JV°nU¦°ÆbXxWlêxĊabW`zV°@lmbÅx@bmVbI`¦@ÒUVUI@ÆL@b¼@@lmxnL°ULÞğÞ°kLUL°xVnKVl@zX@"],encodeOffsets:[[106122,36794]]}},{type:"Feature",id:"6205",properties:{name:"天水市",cp:[105.6445,34.6289],childNum:6},geometry:{type:"Polygon",coordinates:["@@UyÈVVUnn@VU`UblzJnk@VbKU°lwW°nkVUÈl£°V@n¥VklkU±Unlw¯UkwmKUlmkUmnkym@Å@UmWÈU°l°anlJkUKlU¯Èm@kmWV»kkÝLUWUx±b@¯ma@¯IJUxnm¼KýaVUÝ¤óawLmxU@¯UbÝ¹lmwmnXmJ@ÞV@UbVbkbl@±êlIl¯@lW¦knÇJkm¥k@¯Jmbóa¯bUV°akXlÅ`¦U¦ÇmLX¤mXnxmôXaVźUnUxlnlWbl@bĢVnXWbX`lLXk@°KVzKl¤nÞÝÈkbÜ"],encodeOffsets:[[108180,35984]]}},{type:"Feature",id:"6201",properties:{name:"兰州市",cp:[103.5901,36.3043],childNum:5},geometry:{type:"MultiPolygon",coordinates:[["@@lW²L°IlmbVbKnbĊVlk@XbÜU@kn°XIÆVLÓÞxŎUlôb°KzU`lXVaĊ¥Xal@kU°ÑÈwUÑV£ÈéV@VbJ@nnÜJ@bL°XK@īówl@kÓmUÅmK@m_k¥l¯mkçÇ¯@nUaVwólXbmk`ÛÔťèkkmÆkbK@U`UI±xUbWlXmbVbÅÒólkIWJk@zKŻ¼@xUxó¯LWb@ÅÒ±¦U`nbťĀUVbLU"],["@@¯lwna@mōÈ¯K¯kW¤@@V@bĢnĢVLU°k"]],encodeOffsets:[[[105188,37649]],[[106077,37885]]]}},{type:"Feature",id:"6208",properties:{name:"平凉市",cp:[107.0728,35.321],childNum:7},geometry:{type:"Polygon",coordinates:["@@ÆLUxÈxV°LÇÞ@xn`Ü@X@nĊÆwnJmwUxaUkw@V@waVmlLXÝl@XVĢmV°@nl@UUUWK@wÿVI²Òlm@nÝĊýVV@nJ°Ułm@kV¼nKĢÈ¤ôKblnKllVk²aĠ¥È¯ĸóVw@V_xmn¦VWôXÆ@Vbn@°m@kn@@lb@ka@wK@@UlKVaWXW²¹lÓw@_°n@@_lKÅķW@mLUWn»Û@l_Ç`Ûmm°ÅbWb@VWbUUKÇÅaġlmkUġl»LlUm¦@¯U¤ÇkVUml¯Xx¯kVLUa@mlIkyVa_UV@mmUVUÇVzUxUVU¦a¤lnVxVk@mKUnUU@bU","@@@ż@mlkġk"],encodeOffsets:[[107877,36338],[108439,36265]]}},{type:"Feature",id:"6229",properties:{name:"临夏回族自治州",cp:[103.2715,35.5737],childNum:8},geometry:{type:"Polygon",coordinates:["@@@ż»Ly@lXIJlôkÆÑUanaWXkW@yk@ULmUw¯KVlK¯ĠÝÝVK¯mKnwk@@»@aK@ÅVJVU@Ñ¥_Uy¯@£UKmn@ó¼ğ¦WmĵXÝkVLmVĉU¯bmÝVwWlXÞW¦xkmmLÝ±U@VÞ@ÅÈW°XÜ¼ƨyUĮnWnXÝxUx°lVXJlôV"],encodeOffsets:[[105548,37075]]}},{type:"Feature",id:"6203",properties:{name:"金昌市",cp:[102.074,38.5126],childNum:2},geometry:{type:"Polygon",coordinates:["@@ĢÈ¼Çł°bU°VƒńÆǖŰnÆōĬǔaʠÅ¯ĭ_kķÆ¥VÑÈçÜKÅ@ÇVaUm@aōnġÇk@xĉ_Wk£@Ý±KÈ±aÅn@Ýx@kwlkwōL¯wm`"],encodeOffsets:[[103849,38970]]}},{type:"Feature",id:"6202",properties:{name:"嘉峪关市",cp:[98.1738,39.8035],childNum:1},geometry:{type:"Polygon",coordinates:["@@llĊx¦l¦kVVnJVbǖVkôVabnaWwUXmmamUXkWKō¯Xm°»ĉÇ@UVKķkÇ¼ğb"],encodeOffsets:[[100182,40664]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/53",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"5308",properties:{name:"普洱市",cp:[100.7446,23.4229],childNum:10},geometry:{type:"Polygon",coordinates:["@@Uô²a@²²Ķ¥V°Ķ²bl¤kVxl@°Ś²@y@ô¦¯@xxVxUVbVÜm¼ŎĢmºXXWÆ@ĀmmXU°ÅÒm¼Þx°w@°XêĠ°»nV°Ul@k@V±ôī@£ČŃÆ£KÞý@¥k@ya@nWVUVwm£Jknm@wmknXX¥mUUlUnb¯°nkVInlIUw°nmk@@mlanXlanmk@wVWUw_@éĠanmUaÜ£mX¥¯@@óUmÝ¯¯ÞÝlKnxô£»»ĠJ°aVUÝÿV¥ÛbI@wmón¯yÛL@WkÅmÈ`IWa¯K@¯mUnmaXmbmak¯ĢÒÝm¯mV¯KÇb¯KÛWWX@aVknċLUWVkXóW@ka@ób¯Uwmb¥UUlaU¥U£maķKXkmÝ@kwmÑ¯k±ċbUUVakaġ¦kL@`a¯xmÅLUW@ċnÅUV°LkL@b°°@¤²nôôkl°kèÒÈzV¤ÈWôônV@¦@¼Ux"],encodeOffsets:[[101903,23637]]}},{type:"Feature",id:"5325",properties:{name:"红河哈尼族彝族自治州",cp:[103.0408,23.6041],childNum:13},geometry:{type:"Polygon",coordinates:["@@°°nÞôV@°@¦WnÛ¤Vbmnğb@ê`VxUX@xÆÞUnnWÞĸĢÈ@Çè@zÛÜWÅêl²KnV¯ĖĊx@bk@@°JÆ£Èblnnm°nlUkVUUwVmKnnVÞxVLX¥laX@@xl@VzÈVmk@b°ÈĸmV¦`WXbUbbX¼°x@aVVkn@lþnXUlVxŤÅyIUkaIŎĊ@lXx@bz@ô¥_V@ln@ôy@al_l`nmÈ»@kmXwWKU¯»aÅ@wmUÝKUaUUwW@w²»@kÆV£mm£VKkÑV@@»nw¥@kÆnllIVlnLVakalknJWmnaUaVÑVVÞn¥m@¯Uÿl@VçaXaV¯UyVLVk@nJlXLlkxlbla²Òl@nVJVkxKlkUaVķÝÑU@Åm¯@±Uó°ğńķĠmUÑ@Ç¯¯Å¼@nml@°¯¯`@w£@¯Çk@»nmċ¯U»I¯LÇĶÛn@bó°Uwm¯UmÇ¯aI@ykIVU¯bIğ¼¼ó¤mwkLÝÞ"],encodeOffsets:[[104243,23429]]}},{type:"Feature",id:"5326",properties:{name:"文山壮族苗族自治州",cp:[104.8865,23.5712],childNum:8},geometry:{type:"Polygon",coordinates:["@@wô@²¯maUmôUÆx@XbÞInlVUVwJVaUK°¥xmÞXnlKlnna°@ĊČÆwUmnkl@°£nyn@VV@Vak@@kÞÝbmx°Vnw°klÞInĖÞVlKl@Xa°KlVU@JnxU@ÈĢbUKlm@ak_wanWUk°l»k@Wk@lwU_@UalóU¥ÇnkJW@mVXx±bK@nV±a@Åa£ÝK²WknamKknÇk¯aVV¯ĀUÒ¥I@mm¯¯xÅW@@`k@ó»UU¯lm£ÅWlĵw@mmwÅmWU@y±UxmwU¯U¥Ý¥¯£m@kÇVUV°VbklLwUlUImk@±ÑkbkalwkWKkmI@UlUKVzU°WbbUè@kVĀ°@nm¦ÝUUUÒVbmbXnmIkllbUbmKUkkJmkÅ@l¦mx@¼U@lÒULn¤nU¤Å@l±¼@xXxVVVbÞLVn@xÆb°¼V"],encodeOffsets:[[106504,25037]]}},{type:"Feature",id:"5303",properties:{name:"曲靖市",cp:[103.9417,25.7025],childNum:9},geometry:{type:"Polygon",coordinates:["@@È¦lKÞĕUV¯Um¯ÇVUnVVUĉnĊÇƾLn°°ÈJÆw@lbÞa¦VXJ°¯W¯aÞJVkUa@lKnÅmWUk¯a¯»@m±@ÑkkbWWX_WÓU»_lkÑm@U»m@l@IWċn¯l@VanVUVUVwVxKÈVmUē@n@VÝÆLwVVwnVlmkUVÑÇ°ka@kÿÝaÞUl£ċĕX±±ĉa@UnVnalónk@wlUVmkÝJaW@ÅwóVVnnb±°@óxXLWxn@lÇ¼nmk_k`@bózm@kU@`¦ó@nW@ÜÅXWw@yb¦@ÒlnUb@xlÜk@²Ç@U¯bmy@kV@bb¦U`lLVx@bLl¼Þ¤@°VVÞU@WÞUbJ@nn@lnnmxUUUbK@ÇwklkUVWakn@lbU@@ULVxkKUn°¯Ò@¼km¦m@klȰ@lUl¦@Vl°wnnþĊUÆbUxbVĖU°annaVal@@b"],encodeOffsets:[[106099,27653]]}},{type:"Feature",id:"5323",properties:{name:"楚雄彝族自治州",cp:[101.6016,25.3619],childNum:10},geometry:{type:"Polygon",coordinates:["@@mÒXU`Wn@Xl±¦Uxnbl°knmKUxxVôUx°¼ôÒÈ°JlnÞKĠW°¦Vx²JVw_°¥@UV@@wnymknK¯I@²b°£V¥wUV¤nLkÆJÈwôô°l»Č¯ġVUU@@°ÝXl@U»°Å@U¯@w±¯VmUUlm@mÑnIVyUwmak£Vwm±@Çw@n@UxkwlÇnLmkÅ@±kka@kóJV¯Ç»U£lw¯Xalbl¥¯UX@aUaÈL@ÇVIVkaU¯mmakLWkUJ¯Umxn@kUx¯xmWÅīÝkkbŤbkxWmXwWk¯wKkLÅ¤ċń@¤óĬU²@@lk¯VmU¯¼@xV@k°l°kbU°nmVnU@°UVèÞÆbUÒÞnU¦V¼lô@Vl"],encodeOffsets:[[103433,26196]]}},{type:"Feature",id:"5329",properties:{name:"大理白族自治州",cp:[99.9536,25.6805],childNum:12},geometry:{type:"Polygon",coordinates:["@@lbKVIUa@²m@bxôÒÜxXLmbnl@K°¼kUôxôlV¦nJUÆnm@xÆwbXÆôôLUVwôK@wlmaVw@WknmIUmlnJla@_@kÝmKUaÑm¯Xw°aUaVl»²JVbÆJkôĶĀ²VVkmbVwUówVwnLlmk¯maVw²¥Wk@XmV_WnÑUk@kó»UV¥ÝmVÑÅaÝUçV@¯VUmn¯mVlak¯l¯U@@wğWé¯@¯xÝw¯¯Jċa¯U¥mLU¤bÞȤbÇLWUwmIUVW¼kb`UVb¯L±ĊÛkÿÝKkwKţêUĉþÈV¯ÞVbU°KVk²ÝmImV@kmUkVxm¯KXÈķJU¦V°ULWxL@môb@bkx±LnVUVLnkÜWnwlLÅƒmW@kkJU_VWĊÞ"],encodeOffsets:[[101408,26770]]}},{type:"Feature",id:"5309",properties:{name:"临沧市",cp:[99.613,24.0546],childNum:8},geometry:{type:"Polygon",coordinates:["@@xĢl`²X°Vx@x°Þ°KXağUÑWbnIl`X²°bxl°V@xVxk¦mbl@xXVÆzX¤Æk°kx@lźêlaX»VUnJVxXÈKaÝȣaV£nKV¦°Čb°I°n»ÆÑV¯nWn@ÿXÅWWn¹ġōn»ÛUaUVUww@w°ó¥@z±@ř¯@kUwlk£±aĵ¯Uĵ¦±±@bó±VÝ@ó¤w¯I@mÅóm±X¯IólK@°UllbzkKlln@@ÔºUmVk²ôÒxŎUVóLbmÈnmbnlax@z@Æ¦k"],encodeOffsets:[[101251,24734]]}},{type:"Feature",id:"5334",properties:{name:"迪庆藏族自治州",cp:[99.4592,27.9327],childNum:3},geometry:{type:"Polygon",coordinates:["@@WXw@akk@yk°īX¥Uóķ¯w@n»UaVaUÛ¯mV¼kÞċô@n¯xÛÒmV¯Ô@x@kwmÅa@UaÝ¯VÅyVa@ÿn»ÝVmankmmÞÅô@n£±ğzÇmU¦VmnÜmbn@°nV@xmzÅ@mºV¦k°ln¤¼õôn@xkÆIUxU@Ť¦VmVkmkXW¤XzVx@Æx¼Þ¯b@lVĸÞVm¼Xm¦VÞ@Æ¹Vón¥ÆKnKX¯x@èĊÈ±łXaÆxnlV@UÛlȻkğV¥m²ǉmÅÞĕƒƛm°ÆmX¤mznÆV¦ÞVVb°bnÞWbn°l@VÈ@VĵĊ±@óInxÆw¥@£ÞW¯ĸ£UUKk±akkkbmWmÈķaÆÇUÈÆW@wmknmU¯"],encodeOffsets:[[102702,28401]]}},{type:"Feature",id:"5306",properties:{name:"昭通市",cp:[104.0955,27.6031],childNum:11},geometry:{type:"Polygon",coordinates:["@@mnK@wmUÅ¥móXǓŏmX@VmL@xţnk@mlUŻÒğŋ@L@mmLkm@bXÅW¼ka¯lÇŹ¯aÇ»ÝÝ_@m@@a@UklwUm@ak@bUmbmbV¯ĕUaVwÅaĉVmým¯xUk@k¥VUX¤VÈm`@ńÇÜ@ĀknĔkƞÆĠÞUVôƆÞI@UxÆ¦nl@ĊĊnxUÒ°¦Vb¯WUnWIml@xnUbô¤¼ÈxlI»KV@ÈÔJkUĖ±ÆVb@nVÜVUVLwĠlknĠ@nx°¥Æ²mUw@mmÅUl¯UÑÑUmLllIl±@VkwW@w°@U»kUóI°»ĢÑL`nUĠ²lmbôV@nJUxÆ¦X¦l@ŎUV@lVKVÅV£UaÞUnW@¯VU@ó"],encodeOffsets:[[107787,28244]]}},{type:"Feature",id:"5301",properties:{name:"昆明市",cp:[102.9199,25.4663],childNum:11},geometry:{type:"Polygon",coordinates:["@@n@VkVUn²°@x°V@¯ÆV¼k@WÞ¯@@VVUĢċ°k¼VĊx¤Ōx°mVkÑÈL°x°X°VmĊLVxUĖ°bX¦VW@kȯlkn@¥ln@»°Ñ¯VmlLUwVK@V@ka@lmXbUlVlkÈx@LVaVVwnmm@km@mIVaÝ@XVUÝ¯U@Ý£k»K@aUwkKV_¥a@alU@nz°aVÈ@@±lÛk@wVakm@Ñ¥az@XxÆW@ÛX@m@y@aWw@kōĉJlbVJzţÆUwVkmWkým@UlU@b¯wVºUVUêĠXUaUbVĊUWXUmkKWnUUUVVVÝ@kk±¯Lk±WkXlVkl@wXbmLVUIVmk@Ubma@kkaVKUkmlXLWnJ¯ÒĊ°@zkºlLUŤn@@nô@lÆnmKkÈlxVw@@mÈx@n²Uxl¤nbVxUzmJÒn"],encodeOffsets:[[104828,25999]]}},{type:"Feature",id:"5307",properties:{name:"丽江市",cp:[100.448,26.955],childNum:5},geometry:{type:"Polygon",coordinates:["@@l@@w°ÓUnÜÑ°w@mČóÝlU»n°VÜUbVbm¼@°xôĸVW¦¯Ĭl@zll@bWxXaX@ÆĠÆaXwl@XaÆ¦n¼Jn@mnKW¯È»V¯°akVanXVwl@VyUĕVUbÈīlaUk°k¯l²VUkƛô@I@mVwĊaVakaÆbUVLaXIWKUwaWÑÅKUaVk°@Uw¯¥XğÝLkm¯IÇóÑ¯»anUl±UĵÿlóÅIaU±Ik¼UVb¯bWxn°ÒVbnLlÞ@@`kbmIkVnJmnXl@Uxbkn@xóLUxVKóóÅWaÅxw@nÅmVôXLlVU¤b¦m¼@ĀbUzUÆ°ÞVb@Æbnx"],encodeOffsets:[[101937,28227]]}},{type:"Feature",id:"5328",properties:{name:"西双版纳傣族自治州",cp:[100.8984,21.8628],childNum:3},geometry:{type:"Polygon",coordinates:["@@l²°nÒlxÞ@nWlLĸnbV¤V¦kbVV¦nax°Vôa@b@lôXlWUVXČKlmU@bWXXÜ°LÈa°LnU°ÞnÑġ°lnba¯¯KWó@kmK@UĉV@k°VV¹a@y_ċl_nÓlL@anI@óWl£VUlkĕlKVwU@kVam¯ÅL@bÝk@VnUbÇbÝwÅ@ċ¥¯lk¼ÅÒ°b@¦nlUn@ÇVmÆbWôU@ÝÅōm¯aUmkWWw@±n¯UèaL¯mLkwl@°mnÈÒ¯ów@VxĀU¤°Į°Xl"],encodeOffsets:[[102376,22579]]}},{type:"Feature",id:"5305",properties:{name:"保山市",cp:[99.0637,24.9884],childNum:5},geometry:{type:"Polygon",coordinates:["@@X°Il@¦È¼m¼ÞaÞÅlÈxV¼lVôÈÆlLÞ£ÈºlkUUw¯UĕVwĊ@n¦mlnVĸIWÇ°LnUwlVn@lnUnJÞl±U¯LVUa°ÝUÇĊýVŤéLlxÞLĀÜl²ĉ°KUaV_Źé@klw¯lÅW£ÅyUW@wknal¥Uw@wUk¯w¯aW±k_mJaXVÒĠWb¯L¯Ý@wwU¯±Wk_ġwwōKmb@¤bk°lĖôUJVnÅlťU¯°VbnbWxXmÞWUĀLyWzÛKmbUxVKknÝkVĀċ¤Ux@¯m@¦"],encodeOffsets:[[100440,25943]]}},{type:"Feature",id:"5304",properties:{name:"玉溪市",cp:[101.9312,23.8898],childNum:9},geometry:{type:"Polygon",coordinates:["@@lL°xXlWxXnlwaţlaÞlÆĬnX°wVwl@mnw°VVIXllKbnnV°lbUUJ@ÈÇKVb@bW°Vk¦kaWb°kxV¤È¼U°ôI@llbl²@@ó@mm@VţkKl¹@yĉ¯°ÑIXmWKnklVULlb@lnbVal@UnVJUnKWax@lkkUlW²XlK°l²@lÞUUUVVVXmlLVnXWVUĉVaVbWğVéUVU¹W»aVaaWX_U¥nÇķ¯@alUnÇUyk@@wW@kbW¦UKÝwUmmLUnVxUVVlk¯mmnmkÇaÅ¤¯I@l@@aĉw°ĕmUL±kÆéXÜÛ@yÈç@ÇġÝķXmmÝVÅlmnkbmWkb@nl@nm¯VxkJmUJml¯°makVVnV¦WWmnl@xmnlI¤nxUVUmX@b@zl@¦Ýþ"],encodeOffsets:[[103703,24874]]}},{type:"Feature",id:"5333",properties:{name:"怒江傈僳族自治州",cp:[99.1516,26.5594],childNum:4},geometry:{type:"Polygon",coordinates:["@@WyX£lWlnnUU¥@ţVVwJlÅ@wmöó»£kml¯U¥n¹Æ@ny@wmU@¯mnamÛnUV¥ÈnĠy²m¤@ÆónÝnmlnbÞU¥aV£kUKWómIU¥ókwVól»¯Lk@mnaWKÛwóÑw@a±n@VbUJLkaÝXĉUV`lI@lnXÆƑkKmxÛXmlUKVmU²Klw@aaó@nKXwVKU¯V¥mUnkm¥ĉ@UxVĖ°VxVklmÞkKWĀkVWnl°Lnm@°UxlV@nk¦JVÈ°VÒ@nX°@ÆlUômlnô²nxmłnVV¯x@Èm°XblVUl°@xkXU¤WXXWXÆmkÅJmÞw±bxUīkKmÅVUĖÝèVkx@lXlnk¤LkĖk¦xUL°¯Ė@LnK@b°xVI¥Ua°Ñ@»nm@¹KŎÞÈWln²n"],encodeOffsets:[[101071,28891]]}},{type:"Feature",id:"5331",properties:{name:"德宏傣族景颇族自治州",cp:[98.1299,24.5874],childNum:5},geometry:{type:"Polygon",coordinates:["@@¥n@°@VwČ£ÿUlÞlmULVwnaÜLXyzKVÿXÝnWXwmaUa°¯VŦÆkUmVIókĕl¯a@£nama@¯m¯ó@óyţbġkÅm±ÛammVkLwU`Wk@VkUmÅlUUKmbkkUVUw¦ó°¼bn°ô¦lºz@x¯@U°nU¤ţU°VƆ@ÈmlnzÞl°¦ÆaxUxLkxWƒn@²ŰW@°ÈXl°Llx"],encodeOffsets:[[100440,25943]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/45",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"4510",properties:{name:"百色市",cp:[106.6003,23.9227],childNum:12},geometry:{type:"Polygon",coordinates:["@@lklWXL@VIl@XnJn@VUUalk@mK@kny@UlU@a°UU@VmaU@Ua@UWw@n@KmLm@alkmnIm@an@VIUamWÅImwU@@a@KX@JVLUVmUaVkUa@m@@Ulmkk°UaVUlKXbVwVIkaVmUk@KVk@aaW¯m@w¥laX@KmakVmnUl@nxVKInU@yVaVIV@na°KlxX@@_lmXUV`VIVV@n@lbn@@WUkValK@²yl@VUV@@K°L@KU@@UVaXIVVV@naVkVa@K@UUK@UUaLWaw@m@K@UVV@mVUUVKnLmVLKbVK@UUIkmI@mUIVK@IUK@VkL@WU@mU@WmUk@I@VJk@WwX_@amK@UUWkIK@LVb@mVmakL@J@bU@Ux@xbmI@`Iwm@UbmKUaUWa¯UkJWV@XJUU¯LUmV@ma@kkamKwLUUmWVkkm@aVUUkVKnVVUmXK@UW@km@Ukkm@@W@UkUy@I@aUUmb¤U@kUmL@bmJU@Ua@wkLWWkL@U@VaU@LUakKWbkUWVkKkLVLUV@JVbz@V@VmUU@kVmK¯@VU_VWakVmIUKUaU@@bml@XU@@V@LmKUVmVUKKbkaUXKUL@x@V@l@mxU¦V@lL@V@Ln@@VV@nlKUaV@nLUbmJnL@VWLkbmV@@LWXLlxVVIVV@x@V²blUVmLVUK@kWWXUlV@Xl`LXl@@Vn@VnbV@lVUVUÈVb@@`UXU`l@@XUVm@k@xmVknUJVXUbmKULmbx@VlJ@LVbkKUbVLÇUUVUVmU@VaUkUKVUwmLkUUVVlbkaXmwKUVVU@@V±Uk@VWUUm»XamUbKk`U@UnWW_kKmbUVUVmnUV@nJVUlUbU@UV@n@JmI@VmbnVUXlx¯kKmnVV@L@VbkVUmm@Ub¯LmlUL@VWLkmkLmmn£WmnKU_mWbnbmx@U¦UJU@Xmlk¦@mnUUm@@Jn@lVÔVJnIVWI@aÆK@I@aVKIlÞnnl@nl`nbÆX²l@xV@llbVn²VVl@nnV@IlW@Un@@kVa°KnÈmVaVXUlaVÈUVlwôUlynIVaan@lVXbI@n¥la@K_n@bÆx@XnJVnKVz@`VXVU`@b¦UV@VIlxUnVKXÈbVllbVbnVn@"],encodeOffsets:[[109126,25684]]}},{type:"Feature",id:"4512",properties:{name:"河池市",cp:[107.8638,24.5819],childNum:11},geometry:{type:"Polygon",coordinates:["@@lLVlbVV@nXVlI@JVXmnW°bIVV@ln@nalVUbnW@kVkÒlbVKn²°bUlV²@X@`nbaUI@°wlU@aXJVI@aVK@wUamIXm@XUV@@bV@VmImnUUwVaVKXUnVK@akVwV@nL@UV`n@@XlnIUJl@X¦V@aUIVm@anV@UwnL@VlbVL@KVVXUWwUUVUka@UVJnUlbnalbVVn@°LV`Þ@XVxV@@bVlUVVbXnWlXnml@XXWVXJmbUI@VllUVkn@@VWV@Vnb@VXUJVnn`lLVka»lVLnw@WV@lInw@WnU@U@mknUVóKwUmUXUU@@wVJVIl@XKVVVbVIJ@Un@lVLnmb@U@Ul@nU°VUVJnnVJV@@mVU@@wkUVwkKWkyUUkU@alkÈ@lJ@xIl@UUWVkUw@Kn@@kmaVUlUULÇUUKl@UUmL@aXU@mlUUwmKkUUVKVUaKUnK@U@Vl@XUWUKlwX@b@K@XkV@UwWJka@aUwmV@U@@U@wUm@»kLWVkIWXnmV@VkbmKLUbkVa@aa@@aVU@aVak£@±UkVU¯VUUJVUI@kxmUmWUbLw@K@aU@@aVU@Kma@aka@_VWkk@UWVUKULWKULU@KUnwVaUKxU@UmaLm@kVmVa@UkmI@@KmIkxU@@KU@mmakI@VLkmWkkJ_U@V@L@nxXbKVb@VVL@V@LUbUlmbU@UUWJUb@VV@@L¯K@LU@UVk@±z@kLUbVl@Xm@akm@U@UUJU_VWkn@`W@kw¯LmbU@UJUb@zmVJULmwk@mVUnlnb@LWkb¦@x°nXb@bUl@LVlUnlbUJUxWakLUVVb¯llkn@V@@nVbUlVbUnVUK@IW@L@bV@nxÆJnXVbUJm@@bnmJnkl@bnnK@Lm@Xx@VVbV@nb@UVV¯@bkV@Vmz@lnLl@kVbUVm@mI@WkJ@UWKkXkl"],encodeOffsets:[[109126,25684]]}},{type:"Feature",id:"4503",properties:{name:"桂林市",cp:[110.5554,25.318],childNum:13},geometry:{type:"Polygon",coordinates:["@@nU@JX@`XLm¦Vb`lVXXW@VblČnVlanLnmVLK@_Va¥@kUa@VmVbaV@XVVzlVVK@knKVmX£VKLlbn@b@llL@xĊôXaV@°È@¤bnV@@Wl_VU@WnVamwwVbn@KVLX@VmVUxlV@nVV_nK@mI@Wn@@IUĊ@@wVWX@@I°VVm@wmU@m@IUVklkUmmkÅV@@aV@@Wn_UKla@kaVlVanb@k@@KlVn@@aV@nIWWUUaVU@kKmwU@UImKk@UU@w@W@k@UkW@mk_W@Ua@a@¯mV£@mUUam@kWakVama@UUm@nw@alaUmnUlVlIVLVyk£Vm@k@UUJkK@kmKUwKkWK@UXImyVwnI@mkUlkUKkUVmw@kkJWUÈm@_k@@aaW@UUJUwU@@IWKkmUUV@nVl@bVb@bUUXakw@WUkbkKbm@xUlkLm@@wmKUX@UaVWXVmU@@UUUxkmWXkKkUWaUaUbL@`UL@LV`UXmK@VmakLVbkLxUJUIVbUVVb¯KV@Xnl@lVXbmÒnV@L@VWKkVUIWJkIUamUUbm@UkU@JUbW@XWxUam@kbVVUnUJmUUV@bU@UUV@Vk@bmULV¦U@VU`VLUL@xVbn@UJ@nWJXXVVV@bkxVbUxL@x¦@UlXUVVlULV@@nUb@xlnJVnlVknUlVUbmU@bVx"],encodeOffsets:[[112399,26500]]}},{type:"Feature",id:"4501",properties:{name:"南宁市",cp:[108.479,23.1152],childNum:7},geometry:{type:"Polygon",coordinates:["@@lKnbnU@Ua@KLlJVX@VnL@bW`Xxl@I@UJl@nV@XV@nXV@lK@UVL@JULVJ@nnJlVJ@VULaLUKnmKULVVU@nU`lIXllnK@UlJnb@nV@LV@lwnJ@L@nJl@VUbUn@lnKnbVV@wVLUbxVm@LVVKXLVKVLXU@VllUX@`lb@bnbL@UV@bV@@b@LxKVanXVUUmVUUUaVUkyUUaImK@mUUVUkKU_@W@UVVVIUWUVaVU@UUKn@k@al@ll@bnL@bVUVX@V@@bKnblmn@V_@aUalL@a@akK@kVKUKlwUUnV¥VmU_VWVIVaX@VaalÅK@LVJnalL@LnKwlVUwmX@VXlLUVnblaUmVUVwXU@Wm¯Va@ÞKnw@wmk»UVW²a@_mW@U@IyLVUUKW@@LX@VUV@@yVU@UV@nwUUmJka@IU@mVkaW@UwUX@`@kLWUk@mkUUm@kUUWkUkWxk@@VK@nV@UVaUUJmIkV@UamLUbkVmamLka@kmL¯WI@wJmwx@akU@aUKmbkaW_nW@_U@Wm@a@wkwUKmk@bkbw@mKUkkU@J@bW@kVWz@bVUaVUx@ULkJWbXVVX`@mJUVU@@Lk@WbU@UJlnXlmVx@Ln@b@KLXWJUUW@kaUVUbmV@nnV@n@lVLVmLXmXkV±@kxÅLUbJWIÅJ@ImXalkUamKkkL±aVwKUU@mÞnbWJXm@lbmKULWUUVkabnn@Vl@VVV@VbVbnLWLXJWxXLV@@VV"],encodeOffsets:[[109958,23806]]}},{type:"Feature",id:"4502",properties:{name:"柳州市",cp:[109.3799,24.9774],childNum:7},geometry:{type:"Polygon",coordinates:["@@wUaV@nVaUVklmkUUmmIk@waVm@U@VKUkVUkWV@¥@wKVwUalw@aUUUWWXI@mVIm@Ua@wVKUKV_UV@U¥VKnal@U@VU@VV@aVUnVVIVmUUlan@VbXwWX@Va@IlVVn@VanVVblJXIVJlUXL@U@KmUnÑWakU@mkJUI@mk@wUmmUV@JXaWIXWmaUIJkk@WnJ@aUak@kkJ@kUKU_@myUóWUkm¥kUmL@KUKm@k_UmVa@k@@UmU@mm_JWIUVUWLUlbVUJÇVUIVwKUVk@mU@n@lUL@Km@@l@LVzJmUU¤m@UbV²U`U@@¼Vn@x@V@@VnUVx@blbXIVxU@Wl@@LaW@kxLXVWVk@@U@VmLVLbUVULVVlnLVxkV@nWV@bnKVVk@VLVÈVKVVkUnb@lm@@LVxUlVX@VkJ@wkIÇ@kl@blVVVzXllLUxlV@x@UV@nU@UImmUIUV¯mVk@@V@VamnUKkm@@VIUJUaUUWLk@UJUI@xV@VVWVnxLUômVV@VkVVVUnV@UVkL@VVV@bVxla@bkXVJVn`nU@bb@bVL@VnJ@l@VaU@@_lW@UUU@Unlll@XLl@@UX@°bVWVanLlknVV@VVX@VVnUVLmbXJ@nllXX@`VXlmaXVWk@WkwJ@VL@JbnU@bn@@bVKUnVJVIVVVL²a@bV@@Vl@nUVakalmUL@VUL@Va@mXl@nK@UlKL@Vl@@nkllb@Vnn@nVV°lVInwlKXxlU°n@@I@UnVlakUJWkUK@anUWK@_ÞJ@U"],encodeOffsets:[[112399,26500]]}},{type:"Feature",id:"4514",properties:{name:"崇左市",cp:[107.3364,22.4725],childNum:7},geometry:{type:"Polygon",coordinates:["@@@JVzl@V@Xn@ll@VlnX@@VWLnUVmUULVlUV@blnUlnXVVKxnLlb@lnbU@Vn°KVVI@WXUlI°VXbVVbnLVan@xJ@_nJa@wVwV@@a@IU@UU@WKXwWIXKmKUaa@UUUUk@@UmmalbVUXVVKnLa@knWXImanÝV@VLUx²blKlnLVbklWbn@JÆIXJIVaÆKlw²@lUnWWnKUUK@k@mmU@mnUVaVUb@lVXVXIWK@Lam@@KUwnWkkmVIV@Xal@@KV@VUnI@_UWWUkam@kkm@ka@mk@wkJWIUU@WXkWXkWWLUU@UakLWXV±VIVWUU@anUWaUK@IU@Vak@@UUKWa@m@ak@@wUkla@mUaUklakwV¯¯@WWUkLkKmakLUnV`UxWX@Jkn@bmlakkk@b@l¯bmbJb@VXnbVV@bJUkkKWVU@mÛVUUW@UVUJWXkVkKmUL@WW@UVl@XXKWXJ@XVlmbUxnnm@UlVnV@XVm¦VJb@mLkKÇbXblVkn@l@bWnX`V@@IVV@VV°n@@_naÆVVbUVVbUJnzlVUlXkV@Vlx@XVnxbKUK@b¯VVUVL"],encodeOffsets:[[109227,23440]]}},{type:"Feature",id:"4513",properties:{name:"来宾市",cp:[109.7095,23.8403],childNum:6},geometry:{type:"Polygon",coordinates:["@@nVlw@VJUIVVUV°lU²V@l¤Ub@bUV@b@b@bUblVaKnLla@UnUWmXlJXUlKV@V_U±Van@V£nVIyU@K@kn@@LVK@k@mnVl@VULUxVJÈUVIUaVkXKVVUXJIn`@nnV@Vl@@UbVnl`n@VL@LnKlVn¦VlôXVnz@V`VL@llIll@Vbb@mIXl@lIVJnbWXXJWb@IUnVVn@xl@nVJI@WU°LUaVUUaVJVIwlKUalKnb@UnLVWU_@KVK@_KVa@VKU¯VLVKn@laaUkU@maVUJ@k@Um@XmbkyVaUIUU@KV@laVn@KXKWUkUk@aWUUVw@aXKmVaUUkmIlUU@wUaxUmmU¯U@WLUmVIUym@UVmUa@wmw@çm@aWLUJUIUamKmL@ax¯¥kU¥U@±kUVmKU_mJUbkKmLÅÇ_@WWUXUmaVUkKUWW@nVxkUxmL@KkKmbUI@KLkÆbUbW@UbUJUXV`UnU¦mVVkxVLUL@llL@b@bkKVb@bU`m@knmaL@a@@UWVUU@amK@akkk@@b@lmVL@VUVUbVVXUJUU@V@XV`lLUVVV@nnLJVbVlzUVVbVVnUVVU"],encodeOffsets:[[111083,24599]]}},{type:"Feature",id:"4509",properties:{name:"玉林市",cp:[110.2148,22.3792],childNum:6},geometry:{type:"Polygon",coordinates:["@@VJUXVVXlWX@VxVnX@@`ULWUXÅbWK@mULUUmJ@n¯b@l@VULVxxXU`VXXJVIV@nm`@nUVXn@lWVn@b@Jn@nU@Lm`@Xn@WJ¦U@@VnLlV@@Xl`nIlJnkVLw@KVK@UaVL@bVKXlUUKVK@IVLa@U@WLUlVL@bU@@blb@VlbUxVbXUVJ@xVLUlV@VUbVLnKlXJ@Lb@an@VanL@`VLKV_UWl@U_a@WVInlVUUUVm@I@W@wVakIWm@U@XwlaVbnI@m»Va@aXaVLU»@aVa@kKkL@KmU@WzUK@wU@VWUUVUUKUa@mKmbUK@_nWVaUkVaUaVUVLXKVVUVmVI@UkKkLm`UkW@UwWW_UaU@WakXmK@xUXJkUUWUk@WlmJ@km@@aUKzmyVka@kkWVUU¯lmU@@wkkmV@Vk@mÅIUka@Ub@m@UUU`mUbWaWmbXXKWIXUWm@Å@y@UkIUJUUWLUWL@UkVUxW@kaWbKWnXxW¦nm`XLVlUbVbUxI@JmLUKUb@VW@@bkL@b@VlU@xk@L@lxXxWXX°V@VVVbUVV@UVVbULVnVJUb²baUb@VVVVInlV@VnXaVUlIVUb"],encodeOffsets:[[112478,22872]]}},{type:"Feature",id:"4504",properties:{name:"梧州市",cp:[110.9949,23.5052],childNum:6},geometry:{type:"Polygon",coordinates:["@@VbXblVlLXWlnwVV@VV@UnWUXVb@VWXa@kVKUaVaVkUlyX@VaVmUwUaVU@UÈymI@aU°@nWV@VaVaw@IV@VmnLVK@kmmna@VbVI@aV@XbW`ULUVVx@VbUV@bl@VLXblJn¦lL°°@n@K@UlLnKa°LWbnJ¦UÒVUllLlVnKnbWnnV`w@@Xa±nl@XKV_WVkVa@kVyUa@wU£UW@UIVW@@awWaX_WKkVmUULmak@UJUI@±m»k@m»VyUImnmmwnkUmVaVIUn_mW@»Vk@VwkmmUXa@IaVmm@Wm_U@mIUWóLmUk@laXmmkUK@UmKULUUmWUL@VakU@Ub@b¼VUKWb@bUbn¼@mJUakbWx@@VXnlJUb@x@X@JUnVVUVmkUJ@XbV`k@VXU`LUK@_mKUbm@@b@U`@nlV@bUnbVbn@@`VbUbVV¯bm@@mJXb@bVnUllVXUlbUl@LU¦VVmkLVb@bl@V@XlK@V@nUJUz°mwmLmlXbWVU@UUUlIU@VVmV@@¦bXbWxXWlXVWL@LUmkbU@@LVVVJUblzna@WVn@@lIUVnbV@Vlbkbm@ULUKV°UL@"],encodeOffsets:[[112973,24863]]}},{type:"Feature",id:"4511",properties:{name:"贺州市",cp:[111.3135,24.4006],childNum:4},geometry:{type:"Polygon",coordinates:["@@nL@xn@lKVkwn@alLlaXV@lxbVWV@aUa@aUk@mVUnVlXL@JV@VxVIVX@b@bl@@`ÇnXVlI@lxUnlVVLkllV@nmJUxnzWJ@VXLlLVxnL@lLlVI@V@lUnl¤UzK@Vl@LlLnb@VnVVU@kaKnxn@VkVJ@ÅUlakmWIUaVanm@_UK@UVWUa@klXamU@VmVIXW@lUVknVlKVLXVXW@b@VlnnVL@KXLKn@lb@UnW°@VaXWVb°aVa@I¯aUkUaVKVwaXk@aa@wkm@alanUVw@alK@Umkw@UaUmU@WXUaUK@UW@UaVWI@¥Xa@w@WWVXwU@mKUXUWVU@a¯kl@akU@UULmK¯VUVW@U_m`U@@xVbUz@lUbUlXU`WLk@m²Wb@@xU_mXmmamLkUkKVkUVÑ¥mIXa¯KbmLkK@V@Lm¯@¯kKm¥kIWaUKk@@aVUUa@UwVUKVX_WaU@@bUJUa@mbnn@lULmKUnU@@JxUbUbU@mX¯@V@bnJÇz@VUVVbVxUnUbW@kzVUlUbVbUL@lWb"],encodeOffsets:[[113220,24947]]}},{type:"Feature",id:"4507",properties:{name:"钦州市",cp:[109.0283,22.0935],childNum:3},geometry:{type:"Polygon",coordinates:["@@@IlVVlnL@xlaal@nVLlx@x@bXnV@@`mXX`lbnaVL@blV@bwnxI@xXJ°nKl@lbnKnblUVanKVb@lUnJVIVUb@VU@mL@Ul@XwllVVXV@lVnlVnl@XVlK@@_VWVxX@lbUnV@@JlbnIlmnVV@UwVK@U@k°a@mnIVVVK@nXLÆaVWXVK@_W@Umw@UXWWkUUVWUIVaUkJUVWbUmU@mkUJUU@UVab±aVaUIUmVKUaVUU@VUUaUUU@W¯XWWww@k@Kl@wkV@U@alK@aX@@UmIUWUI@mmkXU`U_WJUnUJmUk@@amLU@UVW@UkU@@VbUWVUk@@wmKkUWLUWX@JmIlUkkKWKkLWU@UKWa@bU@@a@_UKWUUUmJmw@nV_@ġğKóLmbU¼VÆ@xUX@Um@wklVnUnlkaUV@lV²WVklWXXbWlkVkIm`UULUU@UWx@XU@@lWLU@kbUbV`UXllUV@bmb@LnKVbULmnVVIV`X@"],encodeOffsets:[[110881,22742]]}},{type:"Feature",id:"4508",properties:{name:"贵港市",cp:[109.9402,23.3459],childNum:3},geometry:{type:"Polygon",coordinates:["@@n@VzUJnVK@XV°nVVnwVb@xVVknJlVVUbnWL@bUxVVXbl@lVXkWXwWaa@¥@nUUUV@JVkVVV@XUWanknKxn¯VyVI@m@UkL@W@Uk@aUalKnUUV¥@KVkkaWVkUVkUm@aWanI@n@°aUUVaUa@_m@UamaV@akU@mV_@a@KWIkmLUKaUVU@kVUK@wUIWVUaVwka@Uka@aV@@aUKVkK@X@VbKU@JULVLkVWUL@aUKb@VUL@LxUKmlkImJk_@WU@kmK@UV@¥XIm@@Wn_@KmVm@@I@aUmkXm@UWV@mn_@mUUJWIUWV_WwU@mUknVVmxU@@VUV@zU@UVW@K@X@VLUVKz@J@VnX@`±bUXV¼ln@xmxÝL@Ubn°@XWVUxUVVnkbWVXV@X`ÆÈKnlLVanIV`nLVUl²V@V¦l°¦wb@nKnLVbVJIVXK@bn@ènx@xVbUnV"],encodeOffsets:[[112568,24255]]}},{type:"Feature",id:"4506",properties:{name:"防城港市",cp:[108.0505,21.9287],childNum:3},geometry:{type:"Polygon",coordinates:["@@XV@X°°UlxkbVlVb@nkbVl@xl@@b@nXbVL@Vl@UbV@@JVLXbmV@bVVUXUJU²WXlKVb@VVXKlXWlXXWV@VXJlI@xl@nlbn@lln@lbXalIVK@VwUVbU@aXylUX@@aW@U_UJmUnVKUamL@Kna@aVUkkVWU_ValaV@XK@kV@@WwVXV@VKVVn_lJlUXkWaXWlkXU±kU@VUlbkVmUmlk¯ÝW@mb@¦VxULmkJUU@ma¯wmkX@VóJ±bUVUXÝWklWXXlxUabIğÇ@U@mVUKkkm@UJm@XnWV@x"],encodeOffsets:[[110070,22174]]}},{type:"Feature",id:"4505",properties:{name:"北海市",cp:[109.314,21.6211],childNum:2},geometry:{type:"Polygon",coordinates:["@@VaVLnK@IJVwUaVaUkWKn_mX¥WwXmLXalbU£UyVÅ@Ýwm@°lLÅUmkmwÛaƑLÝUUm@ȣÆV_Ó@£UUV¼U°W̄ÞVbXbôx@b@bmV@ÇUÝ@@ĢU`m@nxnIVVVXVL@`@bV@@aXbVL@XVlKXLlLVlknJ@IWVXXKlVnL@xl@UVVXa@UV@VlX@VUV@nK@bl@nVVIVmXIV`V_lWnn@VJVXnJ"],encodeOffsets:[[112242,22444]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/43",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"4312",properties:{name:"怀化市",cp:[109.9512,27.4438],childNum:12},geometry:{type:"Polygon",coordinates:["@@@n@b@XnJ@k°x@aVUnlUXnV@@VnJWUJVnIVV°UbVVVL@²LUVa°V@aV@nmUXblLXWVXVmVLVK@an_`@X@l°VlXXW`nX@Jmn@b@nV@Lm`bUbn@VUVl@nIVbUlV@LkJUnVV@xVblVUbU@zUKU@mx@xUnn@@WV@lbUb@nVWXXV@VIV@VUnJ@VUz@JWbXllI@VXVVL@Vn@Wlb@lXVlLaV@VJ@XX`kVwVl@bkbUlVXIlnLVamVwV@@nV@XaVJVbX@lwV@n@nV@VWnIVVUÆ@Xxa@IUUKmk@mVIXmWUVJnUVU@anaVwkU@UXa@W@m_@a¯@@K@UVbnK@blIlbXa@WW_n@VU@¯bmyUkUJÇÅ@WU@kWKÅwnm°KVkmankVWnXVWV@UwXkV@mUlLnaVaX@VUn@VnVK@xlnXWU@a@@klakVwmUaV@wmIÛ`m@mVUXmlIXVI@K@aU@UaV_UK@wkUmmUKWXmVkUL@mU_nK@aVU@Ukak»@U@ymU¯UUVKkam@nka@mwkLWb¯mka_VaVKUIUw@kKmU@WK@UnmaULkU@wUalWV¹U@@WUI@WU@_@W@U@mU@WbbUK@Um@@UmbUwWWkk@WUa@anUUwlWUwUU@wlJVUnnV@@mnI@mK@U@wa@wUm@_mVUUaVUk_kċUkVWL@mlU@kn¥W@UwUWV@VÝU@lXLWVUbVLXlVIlknmU@VUJk@@@kVmwmVkxU@@XmVUb@xnKVLl@VxUxkIU`@bWVXX@JWL@bkb¤@bmUUU¯Kkmb@VVUVVn@@Vb@`lnxmblUnbk@xUmV@bmWbUV@VJIl@nVUbK@nn@VbnJVIlJVkXJ@X@lmx@bnnWVXJWXU@UlU@mk@@llb°xIUbnJ@VWbXVmI@JVX@bk@bWL@JUXUK@U@U`n@@Xm@XVW@@nX@@`ImxU@@JUI@KLmK@UÅUUV@VW@¯kUU@UamVUUmJ@nxmLKkmJkwkKm_mKXU@aU@b@Wk@ma@zUJVUmbUlU@xnXlWlXXblK¤V@@nUVVLkVl@Xb@VVKnXKVx@znW@X@@lVK@X@JXbWbnn@JUamLVVXIVxnK@aWUX@x@VnI@WlI@anVIVxkl@lbXXxVVVJVInbV@@ln¦ml@XXVWbkJWb","@@XLVKVXVKUa@UUUmV@l"],encodeOffsets:[[112050,28384],[112174,27394]]}},{type:"Feature",id:"4311",properties:{name:"永州市",cp:[111.709,25.752],childNum:10},geometry:{type:"Polygon",coordinates:["@@lxUXVlXUVnlVĢJVbUXVJV@XUW¯VIUK@klW@Un@nl@V`XUVL@l@Vx@XXW`UnUbxUlVnUVlb@VnJUVVVInJlUVnwVklKnwLVJVV@nIV@nbVa@KVVVUUaKV_nVVJ@_VWnV@n¥lI@anl¥X_VKlwVlULUVVV@U@VXL@IUmn@VU@wmKXUWU@m²l@VIXWWkWUkWlkIVamUXamUnmWUU@@UnlK@XJl@kVUk@mWKXkl@@aVU@UVWUUVaIn`VUVLnw@U@K@U@w@UVmUU°K@UnV@bV@Xk@KVm@amkaU£VWUUmUUwm`UbULkaKXU@kVmU@aV_UWVIn@yXXK@klmVV_kWVUn@WUU@UmaU@wnwWanUmmXkam@UakLmK@bxUUUU@Km¥Va¯@kUaVUlmUU@mUUÇmUkUybbUaXUWWbÅLmL@VaL@WWXUKmmk@a@UUKXW¥kU@VUkxmVkUWbUJnVJ@nVJXzWxk@lVbUX@VVL@`mbUnUnVV¼k@Ulm@mwLb@lmLUK@UamWkK@£Ua@UkJkUmbVlkX@bWbUVnnUVl@bbVK@VX@lbV@nU¤x²Knblb@xVô@l@b@l@XWxnVl@VV@XLVlLUUXV`bXXmJU@@bm@UUkLW@UlUKWUUbwUmL@nklVVmVXXm@@bUKlÆnXkllVUVVL@nUbV@V@nnV@xUn¯U@JW@UX@xĉ@`m@@LV@b"],encodeOffsets:[[113671,26989]]}},{type:"Feature",id:"4305",properties:{name:"邵阳市",cp:[110.9619,26.8121],childNum:10},geometry:{type:"Polygon",coordinates:["@@XIlJIVVK@n@VVVKnLVwVmnLVK@U@wJ@wVIÆ°X@ÜÈUÈxll@kn@VwVaXJWXn@@WVL@UUKVKV_U@@aVKx@UaV@lk@XylbUaV_Vnal@WU@aI@aV@@aVUl@XmUXWaXml@@kk@ma@V_UnUVUUWJUa@kkaWLUmk@@LUVWUkJWkK@¼UnWJIkV@b@JUIm@UlVm@Uw@a@kWXWKUknW@WUU@kmxUkVmIUJUUVmI@UkaUVUmVkwVaVmX_WW@Uw@@kUKWVU_k@mm@@VkX@lVLUJX°WVU@UIVWUaIUġmkVUkWUVWkwWXk`mI@¥kUVUUn±@mXkWknVUVmmU@@XVUk`@Xk@¥¯»mbĉó@mkU@kUKmX@UnmL@lULkKUWUU@bUaUn@Vb@l¦Ub@l@UKmnKUnlUVVbUVn@`Vn@xb@x@VL@nmJ@nU@mmUVkI@xVVVxkXVxmV@bbXVl@XlXVxna@Vn@@VVLaXaV@n@@V@X`V@@XVJ@XV@UºkXVb@xlVVKnbm@VXLV@nlL@VxJVULUb`lb°nXalKnx@lbmn@lbULVV°nV@z@Vl¼lb@VUV@bmLV`@nKlVnUXWVLnnlV@xVLU`VbV@"],encodeOffsets:[[113535,28322]]}},{type:"Feature",id:"4310",properties:{name:"郴州市",cp:[113.2361,25.8673],childNum:10},geometry:{type:"Polygon",coordinates:["@@²zVaVlnVl@nVkJl_XJlIVmnL@mV@VXn@lV@XzV@lyV¯²U@UlJ@XVKnVVIXl@UVLV`@n@JI@mlIKVLnUlVUVVLXaKVLl@nb@WXV°KUnVVL@xVJL@b@LUVVVUVXbmbVbn@@lUbm@x@XVVV@@@bkImx@Vm@Xbb@l°XU¤aLmnL@bl@@VUX@VxnVanLnW¥XKVwnUWXmVIUWÆLVxLw@wVmlU@¥XWUkwlÇn_UwWV@VU°wnUy@aVkVlnL@lVnw@VlJ@bXx@bVKnb@U@WVUl@@Vnbl@XLlK@aVLVKnxÞn@aLlmUaVUm@ÅknUmaUKmVk@mkk@UlWUkVm@w@kUU@WU¯¥@wÇ@aVIlUV@kUWU@UUm»@k@mKVkUKUwaUaUa@kkUWJkImaU@UK@maUzk`@zy@XmJkL@UUJmUkV@z@kkVmK@¦UbWL@a@UbmKmwUKXkVUUkmVkw@UUKmL@WUIWaJW_k@@WmI@mk@WkWULUUVKUUVm@Ub@nUÇ@U@wV@Ua@aL@akl@kUJwó@@L@V@`@J@xnnmV@bkJmUó@nJWUUmU@UV@LkWlnnmVXbmxxV@nbVV@XVm@UVlXU`Ukn@lWLWzm@UJVXU`@bVUn@lWVLlbVKVan_VxnVVVUXV¤bnl@bUn@LWlU@@amU@V¯LVVUn@V@x@V@L@VmxUKUVm_JUbVV"],encodeOffsets:[[114930,26747]]}},{type:"Feature",id:"4307",properties:{name:"常德市",cp:[111.4014,29.2676],childNum:8},geometry:{type:"Polygon",coordinates:["@@lUmkUwUyV@VW@¯VaVmUU@KVUVUVLnaWnkUÓV_@mVU@Ýw@ka@kVmUmK@IkaUamKkXWaUW@WUk@@KVU@aU@L@J@XÇVUKVak_mWkLWakVUbmLUUmlUVKUU@kUWW@UImJ@xkLkKm@@X@óÝ@UUk@UKVULKXkWWbkaIUWU@mUk@WLaUJġ@@XÈÆVIlVnz°aV@Um@X`@XWbkakJ@amLaU@V@L°@@bn`@@XWb@VVlUxmb@bUVmVUIXVWnJU@nnlVLV@JbWzk`m@UVK²VxkLVl@Vn@V°xVKVkVVlUblx@bUÆ@@nVnUllkx@VW@@VkLWxUL@bÝ@kKkVõV@bkXVVUV@VkUkVLkVa@@¯xUxmX@JVb°WXkK@Vm@kVbbn¤xUXkJblxnXÆK²l_@Wnan@UL@bJnIlV@lU@@¯ô@lWȂIVKVmU@aXaV@lwVXn@@K@UVKUUnUbn@lWXlJnULKV@l@²a@UlK@aV@naVXWV_nKlL@KUm@a°U°@VXL@a@wWmXal@k@VLnV@@bl@VnX@mwVa²aVU@mk@"],encodeOffsets:[[114976,30201]]}},{type:"Feature",id:"4331",properties:{name:"湘西土家族苗族自治州",cp:[109.7864,28.6743],childNum:8},geometry:{type:"Polygon",coordinates:["@@@KL@wnK±nnm@WUkÜÈn@n»@mVamkmUl@VnmmU@wUan¯VKLnVWlInyWUI@WWk@KXUn@mnUmU@WmkV@kXaaVaUmIk@kaX@Um@UKWU@UkJWkXa@IVy@UmIUVU@UJU@WXWmU@VakaU@@Xm@Vm@wnwV@VLyV@VakUUa@wUUVmlI@KUVkUamJk@VU@UmVaan_@KmU@@anm@ImWX_WWUk¯@k@W_m`@bULUKUnUWWXkKWaVmnU@@b¯UUbV±K@UKUUVa¯UUmJUVIXmI@UU@WmVmkUV@b¯w@lmI@W@a@m¯LXbmJVLklWL@V@XXmbVVU@@VU²Ul@VlX@b`XxzUmkUVÒl@bXLWxXVl@VbkLma@nmVmULVbmVUb@lnzmbUÒVl@°nLVlJkn@bmJk_VmmkblxÈx@LUbxVb@Vn@JmLVU@nV@¦VbnJ@lVVbkxbm@UxVLV@n`UnVVVkl°zxVb@VU@@ÆlXnWm¦nbVK@XVVUVVl@XKUV@nVL@WnIWXLVKVLlxUbVKXVWbn@@UnKVLVbJU@aVU°b"],encodeOffsets:[[112354,30325]]}},{type:"Feature",id:"4304",properties:{name:"衡阳市",cp:[112.4121,26.7902],childNum:9},geometry:{type:"Polygon",coordinates:["@@lV@XV@mXVlXLWX@l@bVxn@UVkn@VJ@I@alUJXIVm@»LXllIXVVU@Kl@VnXKlb@lVbXIVVUmVVU`@nbl@@lXLVVVKVbnXWJ@VXbWxXbUlVK¦nLVVUVVbbK@ULnK@Un@VxlUV`UnnL@VVL@JV@VUnxnKVbV@@VIVUnJUVUl@nWXllIUaKVbÞLV¼²`V@VIUwlaVmXa@IWanK@U@mkVVUVaX@lnaVLÈ@¥@kkJUWJUaXkaUmwVXJ@_lWUU@¥n_KkamUK@amKnKbV£¯W@kaWan@@UnwlJ@a@@UUU@Wwn@Va@km@UanaWaUVUUVU@K@aKUI@wKUUVm¯LWUX@mak@UKLWbUKVUkUmVUKLkJ@nJ@I@mU_UK@VWkUJmUUL@WkI@V±VU°kzU@Wy@kUm@UWU@@nmKUnkJWIk`IUlmk@mUUkUb±yUX@VUV@bk@WlXL@nVlUlk@WI@kLm@VV@XVmnnVWbnVUblJXkVlXXlWXUJk@±@nXVWVnL@xUVm@Vn@JWK@UV@UUVUVKUkkxULW`k¦m@bkJm¦U@mUX@`UImUU`LVbUVUU@LUbmaU@mJU@UUIKmxkLUl"],encodeOffsets:[[114222,27484]]}},{type:"Feature",id:"4306",properties:{name:"岳阳市",cp:[113.2361,29.1357],childNum:7},geometry:{type:"Polygon",coordinates:["@@@wUklmUUmU@@UVm@wUaV_mmUKmwkIkJmUUnm@@UUbUKUmÛamm¯xVLkbÇÆUVUzkVUlUUKWLX¦W@VUUUaKUbmLKm@akU@amVaUUVIVWkk@wk@@xmLlmÅwmbVlXlÝIWVkK@kkVL@VWKU@Ublnam@b@bnW`@XUJk@UUWKk@UKnn@xmLUVm@kbVbVnV@Vb@KnVLWXÆVĢ¦VblnUJWz@ÆVóUVbkVaÅx@¦lVUbVVknWKk@wKVUÅl@zkb@`m_mJ@xXmbVb@llV@n@llbXLUXalUlalVnwnLVKlVbX@@IV@blJ@bVL@VVVUXÈ¤VnkVÑXmlbnVKkÑÅ@UmaVç@±XUlIxlV@VaX¯lUVVUVJnV@°°n°Vxĸł°¦b²¦lJ@U@aUK@kUm@_m±VIXal@Kl@bV@KK@km@UmUUaK@_UJaXU@Xm_VmUk@WUk@kU@a@m@UaUUU@al@nyXXWWwkly@¯n@@bnV@k@mVIVlUUmlUJUwIbXVaUal@Kb@VKVkXVl@VkUU@ylUVVaVL"],encodeOffsets:[[116888,29526]]}},{type:"Feature",id:"4309",properties:{name:"益阳市",cp:[111.731,28.3832],childNum:5},geometry:{type:"Polygon",coordinates:["@@ÆxXL@lV@ĢVIbXKl@nVV@XVJlbXalXWLVKUVLl@VV@ôÞ@@Wn@lLlK@wnIVJX@VX@lVVULVnkVVnKValUXblKnXl`UbVLÈU@W@IKV@@bUV@L@lXV@VXXblWnLVblb@JnLVUn@llb@x@ÞUV@nU`VÔmlXmbUKUVUV@LVVUnUb@°UX@UVzVxnlVkVnlVnaW@wnIn`@_la@ykÆVULxl@XLlmUUVakU@¥ÆwblUUaôVU@ÅXyVImkUaġ¥ÅUWXKmU@La@UmUUUalan@VUnK@wmmL@VlXLVVl@VI@WX_m@a¯mKUkwW¥UK@_UWWLUVkUWL@WUIkVU@JwkLUUmJVI@WkXm@VmkKUIU@mmm_@VUV@kJċwUU@KUWkkW@IWW@km@klwkWVkkUV¯m@kWLU`mIkmkXm@@`@L@xUKWkU@VL@JUU@mbUKVa¯WVnL@`lXUVkU@xW@UbUWVU@UJ@lnU@mnÈmVa@bULwUb@@VkxmUUUVK@IUmk@akm@wmIkK@bVWXkm@wULUmm@UVW@UbmbkKVnU@WlxVU@UXmWUXmlnbUl¯Lmn"],encodeOffsets:[[113378,28981]]}},{type:"Feature",id:"4301",properties:{name:"长沙市",cp:[113.0823,28.2568],childNum:5},geometry:{type:"Polygon",coordinates:["@@lVUllXkx@lln@XX@JlXXlV@LVVČxlI@VU@Un`nnV@VJlLUnn@lW@XUJnIVVlKx@IVlUVJ@XXKlVVUXKVX@`VLX¦lxVnL°an@bkmVaV@XL@UKlU@llLXUÞJWkUknaÆxnknK@w@l@xllUXUJVVUbn@blV@bnLnKVaLVbVVUX@W¥XKVLVVklUVyUVÈÅlaUK°wnnÜbnVVLaVV@n@VmnVlIlJna@Valkn@na@amwm@UXwK@aUUVUUaVawWK@kU@UaW@kKUU@kW¯XWan@kmmÅ@@I@U@KmLkaVUKkLWVUk@UVmU@am@kkk¥UVUKmaUb@UbI@aKkkWm@W¯K¯b@VmaULVxUXlVk@UxVJVbUb@xUL@ULWWLĕmxVVL@VbKUwaÅ²WwX@@WUWLU@VbkV@aU@@VUnmJ@VUn@VLUK@UmUIk@UÇmU@@UW@J@LbUmVI@aUmW@@bkXUx@lmLUbm@UbkJ@V@XmlUbkKm@ma@kUaVU@aUK@mImJUIkVUVUakbWwka@UWKkLUamKUXm`Å_UULmaU@@lUV@X"],encodeOffsets:[[114582,28694]]}},{type:"Feature",id:"4302",properties:{name:"株洲市",cp:[113.5327,27.0319],childNum:6},geometry:{type:"Polygon",coordinates:["@@XUnwĖKXXVK@VK@wVaUaUIVwl@kUVWUwVKnb@U°a°LX@XnllL@bJVa@VanbVLUV@al@@UV¯ÅÇ@Ummkw@¯yVwnUVVVUkmWVnKVUa@WXkVKn@lUVUVVVXIlV°VnI@VlKnV@mwVm@LXKWkU¥wWw@k@mX@KX¯V@VUVa@VnKWkV@VUkm@aWa@wkUWwkmV£VÿXUVL@mVIXaò@nW@aU@@am@aUUUmXmWUk@nUW@_maVmwUkamaUL@awW@akI@UxUm@kmKUklU@bzVm¯xUVU@XVxm`kÈlxXVW@¦kVUn@xxKUwÅKVXUJWnXmVUxWL¦XmmKbmUUwW@UV@k@VLnlbLm`@¦VVkX@`WIUxVnlbWVbXIVlI@l¦Ç@UKmbkW@UbUVUl@n@VmLXb@JWbUnkbVxUJUxWXXlWL@V@V@XXJWxzUVVVVKnXW`@bkIUlnLVJUbUIWVXlWV@XklVbnn@xl"],encodeOffsets:[[115774,28587]]}},{type:"Feature",id:"4308",properties:{name:"张家界市",cp:[110.5115,29.328],childNum:3},geometry:{type:"Polygon",coordinates:["@@@InWVw°w@@blUKlUlVU@VUUUlW@aöUlUlLÞ@@aVKXwlK@UX@@UlwkVkUm@m@ÅV@akwVaUkUUlUL¯w@UUm@UkKlw±UULVn@l_XyWwÅ@VUUmJUXU@@mmU@kxW@UaUIWbU@@mU@UxnUbmKkWJkUVal@aUkUxlW_@WUIU@bkKWUJVnUbbWblU@nl@XnVmV@nmWV@LXl@XJXVmzkJUXmKULm°Vb@xnVmnUk@VnnlUb@nm¼m@ÛÇVl@Xmnm²mL@xK@LUl@nULÆx@V@VXVWbXXl@nLlm@bVKXWL°bnU@VaVU@mVwJnwVK°zn@VVba@Ċ¼"],encodeOffsets:[[113288,30471]]}},{type:"Feature",id:"4313",properties:{name:"娄底市",cp:[111.6431,27.7185],childNum:5},geometry:{type:"Polygon",coordinates:["@@lLnJ@xln@bnlV@JLVUVnVlw@U@VaxVK@abnUmÇnV@km@I@VUVVXVaX@@wlVVUkW@_mKXU°UbVLnaV@V@IUKV@XlVL@w@K@_n@lWlnnJV_XK@l°nU@WVU@kV@nbVKVl@nLlLXU@lmkw@nW@UKVa¯IVn@@aVUUKl@nXVKVn²aXblKnLlmVI@KUU@akLUaVaUXm@a@wVUVKnLnWlXln@@U@anUVm@UInm@IUK@UmKVmU_kVUwm@@VmLK@VLaUaVUUUmK¥ULkVWaXwWa@UXImWUaULUUWKk@WnXbWVWnk@UV@bU@@bJ@bV@XkmbUU`VbkaWz@klU@b@VwUL@bV@U`ULVL@VUK@Xm@XWWIUbUxm@@lkkÇwVÛÇW@¯ÅUJ@xIx@@VULmKUnUxmKULUUm@@ULUJkIWJ@b@LJUWkJWnUV@nnÜ_nJxU@VbnUxlkb@l@"],encodeOffsets:[[113682,28699]]}},{type:"Feature",id:"4303",properties:{name:"湘潭市",cp:[112.5439,27.7075],childNum:4},geometry:{type:"Polygon",coordinates:["@@Æ`n_VWnLVblKXL@VlbXxlaVbUVlUVJnInJ@VL@bUVVb@lnbn@lLVank@W@UlIVan@VanK@kVwlW@aX@Vn@bUJVna@KIX@@VV@nVÈl@VJn@VVLK@UVm@UnIVm@UV@@blUUaV@XKV@XW@XxÆ±bVxLUa@UKWk@wmmUalk@WXUWkXUVJVaUImKVklJ@aX_mWULUUVUyXwWI@W@U@UXKWkXWVwU@±_U»ÝKUaLVbkJkWmXk@UVVmIUVJ@UU@UamLmwUVU@mnJ@VUnmV@b@Vm@kkWmXmKULUV@x@bWnVUbVblK@bVV@LUJknmKkLWa±bUmULmWk@VLUV@bm@U°JUbVLX@@mlxkn@WVKkmK@k"],encodeOffsets:[[114683,28576]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/61",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"6108",properties:{name:"榆林市",cp:[109.8743,38.205],childNum:12},geometry:{type:"Polygon",coordinates:["@@ýVnIW»W@»kUÇLÝU¯¥ÇIUWWÑUWwX¯m@»n@ÜÈķô@a±kČ±wÑmwçċmU»ÆkkVyImĉÿ@Ý¹WnwÇVÅazmmĉ¦ókVmxxU¼VkVm_UlVlk°IVkmJa¦kLmmV@XmKnlUôVXbb@UaÇLğÜÅw£mKnmċwÅ@UkbmaVn@m¯aUJm_k@kWXyl@@kÅamwLUÞmWÅzUKUk±@b@nnKbX¤mzVVxÇn¯@ÒknWVUbkķÈÑWkk@VaU@mUkbÝÅ@Ý¥ÇbkĬXV`kLÇVmalUUanV±nwmkJ@In°KVw¯UnÅ@¥U±bUU±mWbÛKWnUm`UƒVK@bmnmÈÅ¼@VL@xxmŤ°n@VmK²VllKkô@êÜV@VXLlm¦UV°Ș¯²ÿ@¥@ÆĊ²ImĶnnb°bKVĸLlÞ@UȮÜ°IVÞÝÞlx@ķĀWUxèÆ@°XnlĊĖ°mnV²V°ÒÆ¦aÞ@zll@bÞĀl¼nKĊ¼óÈb²±IǪÒ¯ĖV@lxnVlkJlaXwŌĉ@VnlÆĕUÆLèŌŤôxÈlU@xlaUċĕXmIWmnkVVVW_@aÈWUUmk@¯çVm»±W¯n¥VmkXw±ÇVw"],encodeOffsets:[[113592,39645]]}},{type:"Feature",id:"6106",properties:{name:"延安市",cp:[109.1052,36.4252],childNum:13},geometry:{type:"Polygon",coordinates:["@@@kkÇmImUwVkUU²WmVkm@m`mIĢĕUVa@mXÿVVkyUýĕ@l_UmnWKVkţ¥awğ@@aôWakUma¯¯a±£kxmmxUwÝ@xmUb¯KwóÝ@kmm¹Ub@lklVbmnnVUV@xUknƧJUX@LÇWkwLķƧÅwWJkLkþĉxWzJUnÇk@Ɛk¼ÜÔÈKè@°lÈÆk¦ln@l¼@l¯L°UUVÇ°¹`m¼mXkbUaV@U¯x@¦ÇUUmlmUVmnnmlkw@@¦ÅÇLmx¯Ikl@¦mÆ°VUx¯Lm@JInlmxU²mVbkVbUnÈlKU_WlīÈaÞ¦Æ@ÞlanV@VUbl@XlÇÒĸlVaUXlm@Ñ°ÈmUwUnyW£amL@ma²@lVVLÆynXÝVKnxÆb@lk@WzX@lln`IV°b@nmUnbaVlÆ@ČxmnnL¤ÆxĠÛÈKVb@aWaUókVmnL@WUnnKl¥bnIlU¯JlUkVkn`lUUV»wnwlUôĊ¥nnyÆb"],encodeOffsets:[[113074,37862]]}},{type:"Feature",id:"6107",properties:{name:"汉中市",cp:[106.886,33.0139],childNum:11},geometry:{type:"Polygon",coordinates:["@@lKnb@nlWb°bkxĸwVb@łnlĊ¥L@XlÈVblÈKbakVwôml²`n@nVKlk²xŎ°¦VUJĊw@çnWçÞVkUóÛ@¥kwUmX¯WÑk@UymIUwlUn¥mUk²a°¯V»@ÝVÈÝċÅÅVl»@l@a°±@_kammÅba@m@Å¼KknõĠ@m¯LÅwLVxmb@¼kV@mw¯wVakKW»X±¼¯Vkxb¼W@nx@x±bóakb@ÝmU@ķÓÛLkVUmk¯¤ÝLUlÝ@Ýzx@x°bmX¯aUJW¯k@bÇWwÛwWx@XWlb@VÈUlwLnl°VlUô¦U°¤VUxVXUxlbkVVlI°ÅVlU°m@kÇU¯xUlLUlVL@b°ĠInĠ°ÈnK@xÞa²naUyXUKVkWô¼Èaz°JXUVÇV_JVz@nb"],encodeOffsets:[[109137,34392]]}},{type:"Feature",id:"6109",properties:{name:"安康市",cp:[109.1162,32.7722],childNum:10},geometry:{type:"Polygon",coordinates:["@@bĊaƨèwôô¼b°aXVÞVUÞ@aXm¥kImx¯¯V@anU@UÇéğL@¯¥V£m@ÝÈbKX°wČÿb@xÈblxÈ¯ĊmÆUVnÈ@ƨÜLĢ¥Źn°VnnKaô_ÈwUaXmnW¯klLXÇō¦ÝaÅVmbğUn¥±wÅéVan¥U»°am¥£Ý@wVw¥nUÑUmmVwmķIÅaóVWxkblb@ból@ğÒĉ¤ċX¯XxkÇ@óÆÅx@xķ_kmÝÇ£kblb@`¯²@bk@k¼ÆUČÆÞÇÞU@U¼¯°±bVlnm¦kVVxnJVz@lÒXW°nVlx@¦ôÜVUlÝXèm@è"],encodeOffsets:[[110644,34521]]}},{type:"Feature",id:"6110",properties:{name:"商洛市",cp:[109.8083,33.761],childNum:7},geometry:{type:"Polygon",coordinates:["@@²nlôb°aVwnKÞI`°wXôw°VĊ°@ÅÞÆVzÞK@x@aLÅ@b@nLl@lnmnLVwabVVnbU¼V°blbÈ@ĶŦb@nÇ@amIyUI@ĠVmôUVwkwlanJ¯lwó¥@an°J_@nóƒó@£l¥UwmaÑ@Um±V_J£JUW¥¯@_k¯¼mUVUè¯b@wmL»ğVmağI¯¤ċIUWXKĵ¦ķaJUbIlUóVmk@WÅÅÇ@mUÅVnĉÇ°kwÇa@waċĀ¯xWLÇa@ÞnU¤°¦@ĠKÈê@VmV@bU°°nwlJn¦WbÝ@V"],encodeOffsets:[[111454,34628]]}},{type:"Feature",id:"6103",properties:{name:"宝鸡市",cp:[107.1826,34.3433],childNum:10},geometry:{type:"Polygon",coordinates:["@@@£@°Ib@¯°ynŹaUlU£Umĵĉ@@ylUÞ@@£kWU¯WaU£¯ÇV¥@kb¯wn¥ÇkUÇnU@¯±kULm@m±_kónUxlbaÇLkUaÇkW@Kĉ¦km@ŁUaķxlw¯aXak@mmakL@mÛ@¼m@lXV`nKU°°@²¤UÈ@VxmôxKlVV²aVwXlaVlx@UVnÇnk°VVLlkIJÇk¯V@knÆn@lznmlVkzVVVx@Uxz@x±¼VxxUlkb@¼ČkVXlĠkôV²wLUKlwJ@aIV¥Þn¯Ün@nkl²kÆ@°aVbnI@Ťn"],encodeOffsets:[[110408,35815]]}},{type:"Feature",id:"6105",properties:{name:"渭南市",cp:[109.7864,35.0299],childNum:11},geometry:{type:"Polygon",coordinates:["@@@ÈôLxU°Þ@mÈnl¤nUôLwX`@ÞÝLUmLôôbVbnºlnÞ@ôx°LanVwÞ@Vxnwnlw²¤b°°bVnlXbó@bĠ@xb¦ŤVXġ£W¥ƽɽó@ýóƝÝ»£XmƅĊkU@ókťaĵÇ@aka¯UV»maUUabUxmKnkm@kmK@xó@¯n¯KÇ¦@ôÅèlxkx°nƾ¯KU¯WķL@VÝIUbyWbX¼Ç°"],encodeOffsets:[[111589,35657]]}},{type:"Feature",id:"6104",properties:{name:"咸阳市",cp:[108.4131,34.8706],childNum:14},geometry:{type:"Polygon",coordinates:["@@IXyĊwlýKlXIVaķ»a£¯aVU@awÈōaL²»VUln°WÈ¯W»XazVaÞJ@U»@¯Ýbğwly@£kÑţ±WÑ@kaIUn@¯ómţUbU¯lÇIÝb@¤Ý@kV@zĊ@ĶnVV¤kVbmź¯z@°a¯J@¤@bUxb@`xUÔ±ºVXWUnUJLĢ¯ÈKlblmÈXŎ°U°LlkÞK@Èxl_°ĶUÒkbl"],encodeOffsets:[[111229,36394]]}},{type:"Feature",id:"6101",properties:{name:"西安市",cp:[109.1162,34.2004],childNum:5},geometry:{type:"Polygon",coordinates:["@@°²@mVVÈÈl¦m°xla@U¦°ÈV¤XbV°lXÞaÈJ°kVaŤVôn°@mVJlb@XÒŤ²lÒ@¤kzĠxÞa@°¼ĸK°XV°Lƽ¯mlwkwÆç@óÈ¥°L°mô@w@aÆK@b@wÝLyÅUÝÆ@ĉ¯¯UóxW¯x_ÝJmLUx¯bóak±mÝUUW¯ba»óóxƧçĉbaĉxIUV¯¥ō±wl"],encodeOffsets:[[110206,34532]]}},{type:"Feature",id:"6102",properties:{name:"铜川市",cp:[109.0393,35.1947],childNum:2},geometry:{type:"Polygon",coordinates:["@@ÆxĸƨKlxÈXK@VWƨIlmV@wVUmUnmUalk@kVaUaóaónKVÞK@ÝW_xóKmVk£ÇmnÝ@¯VwóK@Ç¯XkmVU±¼KbÇŎx@bUV°b¤b¼ĸUb"],encodeOffsets:[[111477,36192]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/44",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"4418",properties:{name:"清远市",cp:[112.9175,24.3292],childNum:8},geometry:{type:"Polygon",coordinates:["@@lÇ¯kÿaV¯VaÈU¥ÆÇIlxmnbUxlUôl°kWl@ôVwUanUl@xVkaX¥kU»a¯±@kka@UwmUkwJk±k@L@ÝWUwVÝxÇU¯ÇX@mÅ@@yĉ£VmUwȗ»ÇUnlUnWU¯`Uk@@x@bÇxX¼VV¯LĀkÝL¯@VĀ¯lnĊW¦kVÇôkUÇUK@ţU@aóÜUU»@¦k@VxKVbn@Æl@xbWnlUlxÈlVÈ°Æ@¼@xWxŎVK°¥nÆkŎ@ÈÑmK@¥k@ô@nôV"],encodeOffsets:[[115707,25527]]}},{type:"Feature",id:"4402",properties:{name:"韶关市",cp:[113.7964,24.7028],childNum:8},geometry:{type:"Polygon",coordinates:["@@WXk±Ñ@UwmUwĉwlmn@Æwn£mkI¥ÇÅ@¥aón£nWWw£V`Þ@nVml@xô¼IV¥kUmkamUkVWwÛ»mó£UVÅKmn@x@kbmm¯aXkaVĉaUbÝ²lIlxnVVx@lb@l²°bV¼lW¦bUlwk@mVVbUxó@kX¯lókVkwVmankwJÅÈ¦ÇVUbU°blĀ°kÈ@x¦ÆÜ°@°¦óaVUôlUlbXl@nÜVnKlnIVÞ°W°U@bnm@¥IV²Ul°VnalzXyl_Vyƒ¦lLlx@ÞbKmknVWanwÑVwČº@n_ÞVaVÜIl@KÈVJ@a£È@@kmaV¯W@_a¯KmbkÇkLmw@Å¥"],encodeOffsets:[[117147,25549]]}},{type:"Feature",id:"4408",properties:{name:"湛江市",cp:[110.3577,20.9894],childNum:6},geometry:{type:"Polygon",coordinates:["@@@kX@aUUċlkJk@wVJXUWk°W@nKnwlUl²blU@lIl@XbWxnm@lW@wwUJX¯VU°`ŎóˋkÝÝkÅ@ÇmğÈřmwaĵVxUÛ»°ĠǷnýmóX¥ɅĵҏÇ@°²ĊUĖ±ĮU¤Ç°Ā¯ɐnżUĊĊĬV@è@ÔÒU¼l¤nĠbêVĠ°ÈyzVaVnUÆLabVlwÆ@"],encodeOffsets:[[113040,22416]]}},{type:"Feature",id:"4414",properties:{name:"梅州市",cp:[116.1255,24.1534],childNum:8},geometry:{type:"Polygon",coordinates:["@@nÔlW¼x¦@lVllLkèa@z¤Ė¼UxlnUKUbÝlU¼lb@VxVklJÈwV¯@ĠlÛĖnbkÆźÞUÈôklmL¥LWnKUkVa°Vx@IVV@x°bUkaa@mV@@ywLÑUwVUVUbÞVVann@XwÇÿ¯²aVamkXaÆ»@»nw@¥UXakbWa¯KUw@¥m@kwmLU»UUJ@kmU@UUWU@yanwmçÛl¯¯UmKUmwVkmÝXbW@XWÝbk¯@±w@»U@W¯Å@Ç¥UU@IUakJĀê°þXkam@_J°m@X"],encodeOffsets:[[118125,24419]]}},{type:"Feature",id:"4416",properties:{name:"河源市",cp:[114.917,23.9722],childNum:6},geometry:{type:"Polygon",coordinates:["@@°VlmX¹laĢÒlm@V£@¦Ģklynn¼lW°zW°VbÈV@lÆbnnJkXVÆaÅW@UUw@kaV»ÞkVaVLkmVw»ĕ£@yblçkKkU@k¥wX»kmÓ@Wn¯I`@nlbWý¯éÿlI@XUmWUw@@UJUÇmKUV@xţk¯¯LWnUxK@Å±»Vwa¯@¤WX@Û¦@¤ÇIÈ¼WxX@WxwUnVbÅèmVa±²UWl@klÈ¤nôÜ¼XxlUnVlbVnlU¦Jó»@wnkmUÝ@U_¤XxmXm¤ôb@¦ÈÆ¦lJn"],encodeOffsets:[[117057,25167]]}},{type:"Feature",id:"4412",properties:{name:"肇庆市",cp:[112.1265,23.5822],childNum:7},geometry:{type:"Polygon",coordinates:["@@l@¥@V¼VôÛ@bV@ŤVLÈlVÈólUX¥mĉ°kÿU°@ÞKlÿ°KUUW»Èw@aw@@nm@w£kÓVUVnKk¥£Vam@nkKkbÆǫmakmLU¥UmÛwmVUmUJÇaUxÇIn`mb@Þ¯b@nJ@nlUVlVULW¯Û`Ç_¯`m¯IbĉWċzx±Jx¯ÆU_k@J@UmbXôlLn¦@¼ĊxlUXxUbLĠUnVĊwlUb@lWXm²@ÞWxXUnb"],encodeOffsets:[[114627,24818]]}},{type:"Feature",id:"4413",properties:{name:"惠州市",cp:[114.6204,23.1647],childNum:4},geometry:{type:"Polygon",coordinates:["@@lbW°bnnla@@wnmÆLVUkÇl@XkV²±bnUÆçUaVmxXw@WXwÇ»ÈJ@£Ü¥@XW@£°bUx²¼@ÆLVwmX°K°Ťl@wVUnLÈVVIky±wkKU¯ÅkXġÑÛlwUwlm@mnKWaÅm¯óÇmğb¯alĉUwķbmb@lÞÒVnmĀŹ@VbVUnmakLm`@xĉkklVÔVJVnlVUnmJmaLUblzmkLaō@@zV¦UV²kJnÜU@VXUL@lJL@bÝ¤UnVb@xVnlK²Vx°VxlIlkVl²k¤@n"],encodeOffsets:[[116776,24492]]}},{type:"Feature",id:"4409",properties:{name:"茂名市",cp:[111.0059,22.0221],childNum:5},geometry:{type:"Polygon",coordinates:["@@LnÇlkKnkÆLUmÈxlUJló°n@ana@@X_@mÝóóU@aaU¯mL¯kV¯ÇVwkw@V±Ŏ£@@alw±Vk@mÅm¯ÿÅƧIÇ`ōô¯_UVW°IVx@xkX@mnwXWa@kkJ@kVa±kkVmxmL@¯XXlWVUI@xlIklVČV@blW@@nUxVblVxkôlxnynIÆ»Æ°aXwlKbVnXbL¤kLèVV¼²IlĠVXynz°KVx°@VlLlblK"],encodeOffsets:[[113761,23237]]}},{type:"Feature",id:"4407",properties:{name:"江门市",cp:[112.6318,22.1484],childNum:5},geometry:{type:"Polygon",coordinates:["@@lUXx°JWnnÆXVWX@ºVLV¯nUVnbôxaXmWXIUb°xlKl¯KxXÞ°XÈ¥Ü@ĉÞUç»nóVmax¯UÅU¥Ý¯@ç@ș@çĉÅUmUç±ĉKÝxÝ_ÅJk¯»ó¯nmèkǀWx¼mnUÜġ°@¦@xLkÇaVnUxVVlnIlbnÆÆKX¦"],encodeOffsets:[[114852,22928]]}},{type:"Feature",id:"4417",properties:{name:"阳江市",cp:[111.8298,22.0715],childNum:4},geometry:{type:"Polygon",coordinates:["@@°nKV°b@bôVÞô@nVlÒôÆUnlnn@lmkmVkaÈkÆÆk¥ÅÞ»ÆKXkW¥ÅLmÅkamJUkUVwUmÈblKw@@¥Ģ¯VÛnm»Xwlƿ@kbWaʵ@óLl¯ƽ@Ln°Æ@nUl²kxb@@ō¤U²@lxUxÈU°l"],encodeOffsets:[[114053,22782]]}},{type:"Feature",id:"4453",properties:{name:"云浮市",cp:[111.7859,22.8516],childNum:5},geometry:{type:"Polygon",coordinates:["@@@VIl@`V°Åw²IwČyĊXa°Jn°_È`Ü_°XKVkUUVk@mmI@°a@Ýnam_ÈJVwlĉX@lUómaUmVU°UK¹@WXUWmÅXm¯IWwkVWlÅLÝ¼Æl¦ÅÅÇlbUllnknm@kmVmóÅkÑUW`@@bmb@¯mkôIkVÇwnVÅKmlLklmÈKVĊK°²`n¤nUbWlxVxLUx@°nXm`VklVxmnnx"],encodeOffsets:[[114053,23873]]}},{type:"Feature",id:"4401",properties:{name:"广州市",cp:[113.5107,23.2196],childNum:13},geometry:{type:"Polygon",coordinates:["@@Ș¼VxUnĊ¤@z@Æ@nÈW°ÈVwUÞVxÞX@Kl@ÞVaĊbU@ml£k±lUkkJw¯UUw±kLUm@waUVmÞ£@aKkI@KVUW@ÛVmlIU±VU¥@yğzƧÇƽĠřÅnī±m@²¯l°@nÝÆóUll@XnÝVU¦mVV°V¼Jnb@°mbn@²¯¯wVw@@nmxX¤¯L@VLUm@@l"],encodeOffsets:[[115673,24019]]}},{type:"Feature",id:"4415",properties:{name:"汕尾市",cp:[115.5762,23.0438],childNum:4},geometry:{type:"Polygon",coordinates:["@@@@VxnXWV@bVJV@ÞÅU¥Ċx£UWUwÅUU¥WVUkĊÇnkV`°LVwnU@lbĊ¯Vnal@@çkUÝ¥ġaó¯ÅaÅLŻÆUýmy¯ó@ĉÆóȯwÆXbmL@nknVxkxÜĢÒWÆlV°Ll²xlz"],encodeOffsets:[[118193,23806]]}},{type:"Feature",id:"4452",properties:{name:"揭阳市",cp:[116.1255,23.313],childNum:5},geometry:{type:"Polygon",coordinates:["@@VÈ¦Æ@X°V@@¼x²°@lÞaWXX@aÞWlnUxVnnL°V@kmĢl@ak@mlk°aX±nwm±²¯JV²@wW_maV»U@m¯ĉUÑJlabVnlĸLlƅÛÇ±wÝ@ĉxó@è@kmbUĉ°ka@mVxU¯KU_mlĉÈVlXUV¦ÆVxVVX¤ĉwV¦ÝÆ"],encodeOffsets:[[118384,24036]]}},{type:"Feature",id:"4404",properties:{name:"珠海市",cp:[113.7305,22.1155],childNum:1},geometry:{type:"Polygon",coordinates:["@@è@Þ°V¦VÆ°wnbUÆ»nçÆ@nxÜ¤²llU°VnÈJÞ°UôéķUklô£VVˌKÞV°£n¥£ȗÝy¯¯mÅkw¯bÇĔğ@Ýn¯ĊVğōŁŻķJ@Ț","@@X¯kmèVbnJ"],encodeOffsets:[[115774,22602],[116325,22697]]}},{type:"Feature",id:"4406",properties:{name:"佛山市",cp:[112.8955,23.1097],childNum:1},geometry:{type:"Polygon",coordinates:["@@ÈbInVVnUÜxnVV¦nKlnbÅǬlalL@mnUb¤l¦LUmUVlÔ¤@xmnVl°_XVVmkVmÈ@kn@VUK@°KW£nw@m@Ux°x°@±mna@¯amIU»U¯nUV¥ÞUWmk@Vk¯UknÑWÝĊÛ@Ç¦W¯WÝwLk°kL¯wVaWJXWnbwkVW@kĊ"],encodeOffsets:[[115088,23316]]}},{type:"Feature",id:"4451",properties:{name:"潮州市",cp:[116.7847,23.8293],childNum:3},geometry:{type:"Polygon",coordinates:["@@°Üknèmxbz@VVX@VnV@lIVVV¼nKlxn@@¦Vx°LXblaWbV°£¯W@nW@aUñVwW»@¥ŤÅUÝǓÝóV@ńÇkUVmIUwÅVWÇX¹@W¯bkl@nlb@kġn@l"],encodeOffsets:[[119161,24306]]}},{type:"Feature",id:"4405",properties:{name:"汕头市",cp:[117.1692,23.3405],childNum:2},geometry:{type:"Polygon",coordinates:["@@@U±°I±n²mx²@WºXÈÆUVxJUnlVÈ@ŃôUǔÞVçn»VyĢÛVm@»kaÝUÇ¼óÛÈķKċ¥X¥Wwğk¯@wķKkUmabkIVÒ°Ċ@nVU¼bn`Xx"],encodeOffsets:[[119251,24059]]}},{type:"Feature",id:"4403",properties:{name:"深圳市",cp:[114.5435,22.5439],childNum:1},geometry:{type:"Polygon",coordinates:["@@ÞL@xbVVK°X°Kô¥Vw@anUèlkĊl@wn_lKnbVmUaUź@nÿUmÝÑ¯Ubk@ÆkxŻ@aÇXwJ¯LķÝUĕóĸóêWº@b²nmĬÆ"],encodeOffsets:[[116404,23265]]}},{type:"Feature",id:"4419",properties:{name:"东莞市",cp:[113.8953,22.901],childNum:1},geometry:{type:"Polygon",coordinates:["@@Ŏ@blKnykVaKnbnIVmUkUmUIUÓçmV@bUxó¦¯LW¯LUUa@wÝKğŚƾƨÈĠy"],encodeOffsets:[[116573,23670]]}},{type:"Feature",id:"4420",properties:{name:"中山市",cp:[113.4229,22.478],childNum:1},geometry:{type:"Polygon",coordinates:["@@XÒlmV°ôÞÅ@m¯°k±@@aX¹¯VÝÇIUmV¯kk±Û£mw@ÅmèÅ¼mô¼èV"],encodeOffsets:[[115887,23209]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/22",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"2224",properties:{name:"延边朝鲜族自治州",cp:[129.397,43.2587],childNum:8},geometry:{type:"Polygon",coordinates:["@@Wxĵm@ó¤VX@@xÜ¼ƨ²xWxVV@XVbWXllaÞU°Ċ@ô¼LôÝWanV¥Ñnĉ°¥ÅX¥°¯@w°w@»°k£°mÈŹmÈbÆŎ¦K°z@kxl¦UbU¤klVKŤÞȰ@@bV@nVVUlÞ¦lUllVlU°ÑU¯V°wbXxl@V²@nô¼ó°kmVk²ĕw@wVÞÞ@@Ġö»¯@bnb°mÞ¯°V°ÈJmX¥mamUÅUlaU¯@wKkl±n@@wkÝVUUl±¯I¯bal@kLmakb@ġŹé°Þb°ékLmwXaÅb@bVlbVbÒVbUbUUanwakbVUVak¯ULmxV°UxnôŻX@JXklbkbĉabWU@kWUU¯@@klm@@Å@awWXlKkI@WbUaVIUanU@ĕ¯KmUnWUwm@£ċèkUmbUmm@@nkJUalwk@@nmWUan_óaWmnw±KIwl@UmI@an@@mlUÅmV_KUk@U`@_KUmU@U¯mmb¯@kbImV¯LkbKÛ@ÇnɱJóaÝĢkb@xÒÇll@²VÆUVVUÇ°XóxlV¯lV@bV@nx@¤@șŎnxV¼knJnKX°¦UlnVbUbÆVnÞWVX¦llb@l°VJôÒnLVbbX"],encodeOffsets:[[131086,44798]]}},{type:"Feature",id:"2202",properties:{name:"吉林市",cp:[126.8372,43.6047],childNum:6},geometry:{type:"Polygon",coordinates:["@@ôlzaÈV°K@mLWlnVxUVÈ@ÝĬUÈnôLa²VmĀkV@ĠĊnU@bV@b@nl°UVnÞaôJ@bV¦mlkbmVXx¯@VxmnbbÈKV@bÈLwĠyônmnbÜ@nnVx@n²KJ@kal@nxÞULź±Vwkw¯LWWUkŎīVww°yVĕ°wÈVlkÛ»@wW@Uô£@nĶXwWaUamKóÑUI¯@kakkW¥XUmÝÅUVaUamVk¥W¯LmIlmU»mwȚō@£kJUÇk@am¯y¯UVwa@wġx¦K¯X°Ċ¯¦U°ċWULÅa±b¯@UkÅWmVkIUlóċ¹`óIlXWXxmbULÝbƧ@x¯bÈl@x¯zaÝ¤@nmVWb²bmn¯J¯Ò@n"],encodeOffsets:[[128701,44303]]}},{type:"Feature",id:"2208",properties:{name:"白城市",cp:[123.0029,45.2637],childNum:5},geometry:{type:"Polygon",coordinates:["@@óǩŁ@WlwUaƑwÛÅÇéĉamKōÇ@IôġVȁÑŹçÝUƧċĉwóóÝ@Ƒ»ğL¯ll²@ƆÅV@¦mÅb@nmlU²VxlUn@VbnWbÇbkÒn@èlnlUÒ°Lx@¼ĉb@ÒUċxÅènLVxÒbÅJ±a@_ÅJÅnVbKlnUÜĊ@UxXVÆnmVJÞ¯VĠwXw°xWLxKV¦ôUwVÝǬóÞÞ¼ÞkVôȘxÞUlVn¦ÞĊa°wb°@bÆwlŤL²`z°@V@@nJVnl@@¥nUmmn@mwnmmUnk@mlwUaLnwn¯°anWakIÇmXwÆamUXUlJXaUUklKUknmÞV@K@VWÞ@VkUwV"],encodeOffsets:[[127350,46553]]}},{type:"Feature",id:"2207",properties:{name:"松原市",cp:[124.0906,44.7198],childNum:5},geometry:{type:"Polygon",coordinates:["@@źèȂÒUóĢ@JŎÈLnĊbÈêÜÆƒxVbkx@XǪłôkÞ`Wb@n°abKnVw°`_X`W¦ĊIkmVakwKx°UÞbU@ll@°¦VWaÞbxÞI@mVI@VkÅUWK¥nLa@@È@°Æ@nU@KÞalkUwVékUWwkUVkkJk¯@»ókV¯ÆÇI@bĉô¯@ķw¯nmmÅL¯wVUÞy@UówÇLkmm@@UóxkkĉmL¯wVwkWWXmLõm@kÅ±V_ô»ÛÆ¯@VaVaĠVlmğwķUóÝƽ£ÇJkbǫaƽLW@nxÝ¤kzy¯XɅm@VôÇX¯Ė¯ºÝnUnLVlUÔmV"],encodeOffsets:[[126068,45580]]}},{type:"Feature",id:"2201",properties:{name:"长春市",cp:[125.8154,44.2584],childNum:5},geometry:{type:"Polygon",coordinates:["@@U°xÆKnn°mĸx°@Ċó@aÈJ°ÅUôl@¼l°IllUlVXxlVUêVxkllnÈUVll@Vx²IÞ¤VUlVnIôlÞlwô_bVaĶLXÅÞÇ@K¯@wÛaçn¥¯WXyW¯XwUmmÛ@manómğzxÇK@aUÇLamanUw°@WwnUalnk¥U@aóIÝbUm¯Vmk@@aU@amVğĉ@lUnÿ±UbóKmVÇÞī@ÇVUUwmXkKn@L¯ÇUbyókōè@bn@lÝX@x¯ô@ÆUV_maXm@aóJWxnX@VVnĖVnUJ@nōÆÇ¼V¼kxLklÝw@xx@zV`ÅbmxU±xUnnmknğUbUUb@Å°Üó¼U`Æ²@lönKnXWlXUx°xnKĊllôw@Vn@lnÈKôx@VÝzV"],encodeOffsets:[[128262,45940]]}},{type:"Feature",id:"2206",properties:{name:"白山市",cp:[127.2217,42.0941],childNum:5},geometry:{type:"Polygon",coordinates:["@@Ul¦kÒÆ°IlÒU¤ôz¼lJUnÆXVl°@²aÆbVKČXV¯°¥¯ĉ°WL¥Ģw@xbUx°V°znb@ÈlVlI@w@mU@akU°kUôwWÈ¯VUVUÅ±U@kÈkÑw@laÞġUÞ£@ƅKnÑĢ¯@WaUaVUVkkw@a¯@¯ÝVXnW@@WkXmK@xkKUb@bW@Uw¯mmb@WKUbmUbUaWbJĉIVW@Il±LkmUbUm@nkKWa¯n@`UbmaĉL@bÆ@W`L@n¯Xb@kb@xL@VkL±mlUIU¥mL@lÅx@_la@UaV@kmmK£LmKUnÅKVbmXVlèĉUUbmlĢÅ¤Il¯bÇ¦l@ô¼Ģ@x°l¤nal@xb"],encodeOffsets:[[129567,43262]]}},{type:"Feature",id:"2205",properties:{name:"通化市",cp:[125.9583,41.8579],childNum:7},geometry:{type:"Polygon",coordinates:["@@ÆlXnĠxĢ°lÈ°K°kXm@¦VbkŤJnÝ¤kVÞVVkÈb°y@wkÇ°awƨ@aÞKVnaWwXWkôJ_ČºôVk»óyV£kÑJÅ¯lÑk¥Va@wkbmk£¯@wġó»@kÈ¥°akJÆ£ġnkVaĊVkçWUnUaÆLVmnLKU±@m@a¯UbmV¯m@_KUaÅWó¹@UanmWak@@wmI@y@mkJVa@UaIkJ@n@Um±kkxmIkbÇm@°bXnV@°ÈmlÞ¼¯XVº¯LmkWWXLmVVlkn@@lnWÆVxbmnm¯lÝaVÈè@¼VbÆ°ÞUVJkxIxIV¤ÒXxmn"],encodeOffsets:[[128273,43330]]}},{type:"Feature",id:"2203",properties:{name:"四平市",cp:[124.541,43.4894],childNum:5},geometry:{type:"Polygon",coordinates:["@@Ɇn°WzlyÞ£mwX@ƾKǬblaÈIƾ¤ôÞĸVĠxnmmV²wVnwÆaU_@yw@wÞxlkKlwU»È»ŎÅ@mVIUmmĕUU@mWXwIô@bWnnbU`V@Å°ó@wÞW@km@aŎç@m°Ñ°Inm±aXaUn@mƑU¦@Ç¯aU£aUġ¦ÅÒJōUŻókUÇ@¥¯ak¯mUVak@@aċçÅaUm¦Ý`XbÆ@n`IxĊÞōÞml@Ub@Wl_¯JkÇUÝÆÅb@nllUb¯±a@WĉJġĀ¯Unóm¤xôaVnxôI@xV@bmÆ@lnLmÞ¯ÞxVb¯þ"],encodeOffsets:[[126293,45124]]}},{type:"Feature",id:"2204",properties:{name:"辽源市",cp:[125.343,42.7643],childNum:3},geometry:{type:"Polygon",coordinates:["@@żôŎVIÆÑĢ¥VbV¤°bÈ@V¥ƒÞ£lÇUUUÝlÞ£mţIlUa@¥nlW¯L¯kÇġ¯ğwWmÅk¯UVUbWlXlmnbUx¯xVVknlUbVÇKUb@VnbmlnzUº±bmJUbWÈnèmÒ@X`WL"],encodeOffsets:[[127879,44168]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/13",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"1308",properties:{name:"承德市",cp:[117.5757,41.4075],childNum:11},geometry:{type:"Polygon",coordinates:["@@lLnlmxnIVVlUnb@VVxXJWL@LÞVnnVJ_@wkmKbxwXkWXXKlb²K@nVVVbL@WlU²lKVnUJVz@VVb@lÅ¼mVUVnbôaVX@°Ub@lWbX@b@bVb°x@VxÈLVlaÆ@Þb²k°@lVU@Xn@VWLXb@¤VXKVVVLnm°_ƨ¤@aUIVaalkX°kV@alwUVyU@kó°na°UVUUmUÆw@mkLVUWVIWLnn@xlVnKmyU@U°UXaV@U¥U@UÆ@aVUkWU¯aU@WLUV@bkbmKULmKkUVUkmVIUwlWV²Uml°U@WLUwVm@UUK@_KUUÜaXw@VKUU@mVIUUlmnIVVVbÈVlKnbVK@nI@nVnwVLVKKVnb@aUIVW@In°@lVnI@lWĢ@°UVL@b@VyUUa@w@WUnU@WÇ¯K@UkkJWaÛbmk@mVaÞU@amkW@mXUKkÿ£@akl@Um°UXwlaal@nmlXnW°znW@awV@akbĉ¥VmU@IVUJkUmWUKbmkUaKkUVU@KV@@klwWaU@kmXVènbmlUUKX¯JkbI@JmIUWU@Lml@XkJ@UkK@aVKwWaIWwmU@mU@J@UaċUaUUVkI±k@UU@UbVVm@UVKLlkIWaULUWXUJU@WbUb@lkXUxm@@JVn@J@bnb@Vkx@bLUÆnJaVXnKVVmzX°V@_lJXxWXK¯bÅamU@lUIbñJ@LÇKkIÇ`kxWL@@@bUVUb¯xWKkÅVlULW@n¦Ul@IlmUUUVm@kWnkKma¯XUKWmnwVwÝLmVUbUVWb@LnxmxVmbXx¦@nb@`V@kbLUmVUlkbVXkºmnm@@xk¦bĢÜl"],encodeOffsets:[[118868,42784]]}},{type:"Feature",id:"1307",properties:{name:"张家口市",cp:[115.1477,40.8527],childNum:15},geometry:{type:"Polygon",coordinates:["@@kġÛal¥@wn@nml¹UWlaVknUVKla@U@_ma@¥WwnaUwnmw@KXaVUVaUnmWUk°lnUVUXWVwIWVóKUI@WXxUU@mma@kUKWLkw@yk@aVkUUċaUU@Wk@Unm@UVmLm±IUkJkW@aI@m@UVUla@VXVXmVwnkWKKU_k@m¥mX_JmnU@km@U@KmUVU@U@Umk@@LmW@Û£Wka@wk@aI@mmk@mUa@UmUIwW@aWUbU@kbÇ@kw@makVUkU@am@aU@mxkUbKUXU±KXVWLUK@wkU@V@WXUa@WbUxJI@¦VèVVX@±ê¯KUI`¯UULVx@V@UKIVkLmVkKm@nUJÝbkIUJVXVVxVbUVJUn°bVmlU°XnK@Ul@lVÈVUXx@W@VXVKÞbn@VnbVm`UxkW@UVkLKm¼@lUnUJVnVXV@Vm@@LVklIkl@VWlULWKUL@mJ@blbUVUlmzUJUxm@UUbċÜk@Ub@VLVV¦ôbVmUKUkU@m@VlVn¼WbUJ¯@@°nIllÈl@nXWlLkJ@bkxlxkxlXUlklJXL@bWn`@nÆXxlL@xl@XbLKlVlIXblVUbUJW@lX@VL@VVXJwn@WnL°KbVbl@VI@K@U@nmVmV@XUWI@aXm@VUUkWmn@lmUUk@mUmK@UnwVĉ@mU_V@XJôVVULVUn@llUnJl_n@ml@XlLlw²LVJUL@VmbVblVXmVnl@Ť¦nn@Ü@bl@@XV`Unb@VlLVb²JXn¥ÆÑ@¥Þ@"],encodeOffsets:[[118868,42784]]}},{type:"Feature",id:"1306",properties:{name:"保定市",cp:[115.0488,39.0948],childNum:23},geometry:{type:"Polygon",coordinates:["@@VbXW@@UlV@xVLXKWU²LVVWLalVnwV@@bn@bVVllUnb@lxÈ@laV@aXV@bXxJnV@VVb@nnl@nJ@bll@aU_VWUwVUkUmUkb±mVwU@VIUW@UWk@VU@ynLm@IV@bnKLVaVmnIlaXwV@@WVL°@@xnX@V`V@VbUVVLVKnwnL@ll@@_V@VVnaÆ@KVXÆ@n@wKmUWm@km@kÜKXU@ÑW±nIUwVKla@I°wU±kkmm¯m_JnawW@IVaUama@wUmU@mVw@aXk@mWa@£km@a_kVmUnWW@¯bkUmk@VÇm@@kUUKUU@UVUamVUaWIkb@xU@@amUkKVkam@@kVUkUWmKmUkLUb@xmJU@UImVÛVmnUwJU@VX@UWm@Ub°¦UmxklmX@`ULU@@UW@@xkn¯@makVUmxUb°lUbUbnUJUUVaLkbUUJUU@mUUUJka@xUIWJUnJ@Vz@kb@`@bln@lb@X@@@XlbnbVb@VJlInlbVw@UKl@lbnan@VbJôLnUzlV@lÈLVbVK@LVxVWXX`WxXzbV`UXV¤nx@bVlVnVlUL"],encodeOffsets:[[117304,40512]]}},{type:"Feature",id:"1302",properties:{name:"唐山市",cp:[118.4766,39.6826],childNum:11},geometry:{type:"Polygon",coordinates:["@@@VVl@²lJUVVbČVVb@@InV@VnXxJXbxUL@bLl@VlI@WnkKV@VXnJ@IJla°IWLVVnkmaUçWVkôaÜ¯@nV°wnJlaV@VUnUUaW¯wXWWwna@£UaWKU¯¯@aVUkKUamUUn»anIVwUWlk@LlWVakU@K_lbÞU°@y°n@KÈkWWţ¥ĉōkġWUw¯£¯Çwţw@kK@k¥ÝwÅbÇ¤ÛťVlW°@ĸx@VVVULVLkl@V@X`Ub@Xm@UWbk@ÆVbnLWV@lnXUbl@X¯lmUVkKWLkK@_UK@U@UmmUxmVXLWVULkU@`W@ULUK@XlJXzV@@xml@VU@UX@Kk@WbUK@Xn`XmJnmkxUVbUVlVVxUbV@nKlLkVKÞbVKXI°KVmVUIUKULVxVJVLkV@V@UbU@WUU@UbUK@b@nV@VkLmb@b"],encodeOffsets:[[120398,41159]]}},{type:"Feature",id:"1309",properties:{name:"沧州市",cp:[116.8286,38.2104],childNum:15},geometry:{type:"Polygon",coordinates:["@@@ln@UÈl@Vnl°aX@mXnVlU`@bln@¤Xb@nWl@bUx@nnVV@xnbVbUb@JXxbmXa@kUVwlWkKôVm@wkkK@kl»ÈmVKXkla°@XVV@VI@ml@@Vn@VX@V@J@VxUzVV²blVk¦@Ġ@@»@VK@VÈLlK@XnJ@alIUlaVVb@n@aU@WUIV@mUn@mKXml@lL@LnWb@XV@@aVVbV@VVIVWÈbIÈ»ƒǟlWaVUÅUUm@kVUWVkaUwmaóUJUU¯ÑU¥mk¯UaKÅnÇyóXmWÛX¯aċbÛaJWÝU¯»aóóUm@IVVl@bLUJWLX@@xXUxl¤V@VnVUVXVbV@@@VVn°V@ţU¯VUmUWV@mUXabUKUwUaÇKnVk¦Wb@VnLmV@bkV@nxW`Å_UVV@bUklVX@VmlUx@VVL@xVWVL@VW@UUm@"],encodeOffsets:[[118485,39280]]}},{type:"Feature",id:"1301",properties:{name:"石家庄市",cp:[114.4995,38.1006],childNum:19},geometry:{type:"Polygon",coordinates:["@@la@y@UImVXIVJw@lbIVVnV@VVIVVlaKbVUVVImVaaVk¯VanwVlUnb°@lm@wX@@VV@VK@_nWlknwV¯¥Van@VX@W@UVIVxnmÜUnUVJV@nI@wValKnV@kmU£na@mVk°KLVa@UU@UmknWWkXU@aWW@@km@UaU@@klK@UkaWaUnamm@Ua¯wWU@UkL@Un@xVlUXVJUbLmU@aUWUkmKkLUUm@mWXammkkWUm@@U¯JUUmkU¯@mKĉxÝwÝ¥LUómwkUUUWVkKmkKmLXlxVLVxXJ@nVJnz@VWL@`nX@x@kVUUmJmIXxJVnUV@UVV@LU`UXVVlXL@l@b@VmX@bxn°UbkKWLXlW@@bKmKULmakLUlmb@Xb@xmXU`Vb@`lLx@nWVXL@°WlXnlbKVKXVb@X@l_lJ@V@XnI"],encodeOffsets:[[116562,39691]]}},{type:"Feature",id:"1305",properties:{name:"邢台市",cp:[114.8071,37.2821],childNum:18},geometry:{type:"Polygon",coordinates:["@@nKlLnlLXUVVlVnxôVKÞ¦ÞxĊwnL°@lVnVV°I@Vn@VlXnlnbWnXn@VVlKnLVlVX@bnVKVaUIVWkU@wVm@¯@U¥VmU_°lKkw@LXVaU@wUUUKlUóW@UVUUl°KwlKU_naKVnlKkkWWa@IJVa@IlJnU@KVUUmVlaXUl@lm@kXWÝÑnk±k@wğ@@U@mKĉLmVJ@zmlnWLUÝJU_@@mJkXUVlbklÝ@Ýab¯@¯±JÅwġaUU@kU@mVI±bUKLWUXJkaLóKULWbUVkKmnk@@bmLUl@b@mnmJkUULabnmn@lVV@¦n@l@bznx@`Vz@bxnV@xllbnKVx"],encodeOffsets:[[116764,38346]]}},{type:"Feature",id:"1304",properties:{name:"邯郸市",cp:[114.4775,36.535],childNum:18},geometry:{type:"Polygon",coordinates:["@@bVKlVnInm@@akVnK@al@nmlLVUXaVKôLKlbIVWXKVL²aJnU@lV@VVĢbÆx²I°°@aÞbÞ@lkkaVUlWnI@@V`ÞIVXKmnk@yInUĊKÇkUUamUUk@aU@Uk@WUwVkVJVkkw°a@mK@UX@VVLVW@wwVa@¯Xm@@lUIWaU@UWkXWmU@UwmUkKmn@lkV²VaULUVmJUUUwLma@UmkIUmLmVmx@bLUamKÅL@VmbkU¯KÝamzkJUb±VkbL@lU@WIkJzkKmKnUalWkkKW@@nkbk@WW¯XUVUJ@XlJ@X@XlWLkU`VUnaWaUV@UVIaUxUUmVK@I@W@ÇU@@U@b@nmKXmx@UxkVWUX@`VLlL@`zXÝb@b@VUVkIUJVz°KVlnLlKnLxlLVVUVlXUJ@nnI@mVUlbn@@m@bVnV"],encodeOffsets:[[116528,37885]]}},{type:"Feature",id:"1303",properties:{name:"秦皇岛市",cp:[119.2126,40.0232],childNum:5},geometry:{type:"Polygon",coordinates:["@@lnV@Xbkx@lU@@LUVlVLVbnlaLXVVnlIVUJV@UnĊ¦lab@nJ°UmV@wn@VUJVI°bnWlXnWVLVK²bakklI@aUaVUwVUUalaVwnUVak¥X@WkLVÓmmUK@_lW@n_UK@alÅ@ğÅƑŃÝm@ÑţÇlL@¯mz¯@ÝVak`@LlVUbkXK@klVXUxJmbm¼VnVVblLUV@b°V°XLVb@¤mbXxWX°xXVbmVUVU@kbmI¯xmU@Û°óbUl"],encodeOffsets:[[121411,41254]]}},{type:"Feature",id:"1311",properties:{name:"衡水市",cp:[115.8838,37.7161],childNum:11},geometry:{type:"Polygon",coordinates:["@@KVlV@X°xb@VnnmbVXblb@VkL@lV@Vbn@@l@XX@bWVXlmXnlVV@@VUbK¯LUl@nmbV¤n@lLXnlVUV@ln@lbUlLnV@bV@@wlaXJVbnUVbVU@VVLVVn@VVX@@UKXUU@wUK@UwVnk@UUWlkV@aUVUÆ`X_w@mlU@anUmK@UXal¥UmÈLVbVxVLabVW@nXUVnV°UŤV@U¯Um@U@@UUaWVUmUUU@k£VwW@wW@XKIUa@wU@@al@UK@_mKXKbUU@aVKm@Xm±@kbÇakLğVaUw@a@mkUJk@ykw@£WX@lknk@WVkbUVnUVL@mVkI@JUbI@JXbXllkLUmLmbV`kLx¯LkVUV@VôXkVVLVV@xVUbW@KxlL¯kV`UnV¦°@"],encodeOffsets:[[118024,38549]]}},{type:"Feature",id:"1310",properties:{name:"廊坊市",cp:[116.521,39.0509],childNum:9},geometry:{type:"MultiPolygon",coordinates:[["@@laU@UnL@VWbklWxnIVVV@XJlbUlXVbn@@KmV@@X°WVInJmn²@lmVbnL@amKV_kwlmX@@LVamaXaaVU@UnJVanLlUkaW@UaVakK@IlKUU@an@ln@alKUkIVa@a@klaUKUV@UkUV¯KVV@kUmU@@a¯ImJUU@VV@UL@U@@WXUWa@Ukwm@X@@w@al@@aVIUmVUUUVWUknK@I@l¥kU±aUUVyUw@@I@UUWm@@Uk@@nUJU@WU¯@kbWlULnÇk¼@llLl@xUnóLlkXUxV@lWbI`°nnnllV²¯x@JkbLUVxmJX²@ÒWVÛL@lln@XnnVL"],["@@@kX@Valaa@KWI@UXW@WanaUIW@UaUKķk_W@UVUKU@b@UamxVXnJUbWVXLVbn@W°kb@U@Wó¼mIU¼k`V@bVbl@lX@lUôVlUIV`lXVn@lUlVn@l@UVaIUWl£UmVWU@@UUKlUUUnVL@KUnLVWUa@U"]],encodeOffsets:[[[119037,40467]],[[119970,40776]]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/42",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"4228",properties:{name:"恩施土家族苗族自治州",cp:[109.5007,30.2563],childNum:8},geometry:{type:"Polygon",coordinates:["@@VKbX@lbUVnL°@VlVnUl@VUX@aVmaXlaUUU@wmaVUn@Vnmmk@mU@knaaU¥VamX_@WUmW@_kVaVKnLl@VVal@k¥@kUW@kUKVUlUVÑW@kÇaU»ValmkUVUVak@aV¯_@WUkmVUlU@aalI@akkVWUaWXUWwWVbÆ@lalIVK@Um@UUW@al²a¯UağÇm@bkk@w@@WaULmxIUb¯@U`UXJmL¯aKXWUL@aknmK@aWUXaWm@I@UÅmVU@aUV@bVI@WkUbXkm@VakwUKULWKXmJ@XUK@mL@KUwVaUI@KU@mmnmXka@»V@@UUaw¯yVk@UUVmmkÛÈU@mWUnmxmlUbV¦UlbWVUL@UUIUmÇKVVbUVVxknLUxV`VX@kJVVUXWaUVVlUnmKUbkI@WULmK@L@LVlLnmUIWV@akn`VXUJIVlUVVbUX@¤mbnLmm@UXk@mm@Uka¥@kV@@KkU@aUKWbkLWVkIVk@UbVlmX@bU@@mmL@bn`@Ln@llVLVk@XVVU@`VXU¼k`VULka@VllVIn¤VU@@blÜbkx@bkLkKn@bn@@b@JUnV`UnVbVKlVXUlbn@°Vx@@bnVbUllVn@VVK@UnW@UVUlnkVÈÞxVbVVIxVaÆ@@aka@UVaU@@ak@Wl@nbVIÆ@Jk@L@VlXnlla@VJnw@UmwXU@aVK°ÒnllnLlbxnKVaV@l¦²nVl@llLx@XVVĶ@nax@U@alXUVaLÈþV°XxWXkK@mLnlUb@bxnLVlVVkb@UJ@xWXX"],encodeOffsets:[[112816,32052]]}},{type:"Feature",id:"4203",properties:{name:"十堰市",cp:[110.5115,32.3877],childNum:9},geometry:{type:"MultiPolygon",coordinates:[["@@@a@w@kV@nbVK@nUla@laÅl@nlVakwWX@WkLaVmwV@anK@UlIXmWkk@@mmLkWlwk@U_mKXwWK@U¯K@UU@VUakmkIyUUVUmanU@mlwk@_mWXaUWU@Ç@U@aUaVwUKUIVkK@UWIXmaV@k@Vm@UnwlUamk@V@ULUamxUJkU@I`WkkK¯XWak@@W@IUVLWJkXkaÇVUK@kUmbmUUUKbkKWUkI@kKÝ@@aUm»nI@mU@UnWV_@aUmWbkLUl¯b@akkk@WkkJm_k@UV±@J@bnU@@WÝIUJVbXL@nlJkx@Wn@VkJmbLmU`VbUL@xVn@XV@mVVnnJVbUx@VnVUbVVx@nbUK@b@bJm²VUlbXzVJVJVbn@@Xmb@V@bVJÈ@Vnkn@°aVVV@XKnalLVmUnnVKVlnLWlXXKlk°XWkLUVVV@nU@ml¯nmbk@W`Å@mbLWm¯UxnêVèk@mbVnUK@kKmXk@@JUIlÛLllnbVnlJ@LULnlÆaVLnV@nkVJ@lkô@²bÆm°wLWV@VXKVXI@W°ÆVKb°UJVIVV¦XKVL@lInaVÝnUl@@bX@nmVL@lVLlVLVUnbVW@xXnbU°¤V@a@kWKUUn@VlnL@UV@Ü»@mX@V_akaÞ@VK¯@kkW"],["@@mUkUUm@nllVKXXVK"]],encodeOffsets:[[[113918,33739]],[[113817,32811]]]}},{type:"Feature",id:"4205",properties:{name:"宜昌市",cp:[111.1707,30.7617],childNum:9},geometry:{type:"Polygon",coordinates:["@@°`U@blUbUVlVknUbV¼Èb@lXUÒkVUVVL@lVX@ll¦k@UbU@kmKULUbl@`nXV@XW`nUbV¦bmb@lV@nnlmnUm@UVnb@xVVVkbWnbVnVa@an@UaVUJXnWlXX@l¦@lKÆXbXV@VV@°¯°xXxXV@nV°UVWU_VWXkmaVnWVkn@lln@lb@UVLXWlnX@aXUmaVK@UXUU@WVIWXXVU@¥VK@UÞa²LlV@kV@UanKma@UVUnK@UVLXyVLknJ@UV@@UXKWUXaV@Vb@mVLnKWm@aUUm@@UkK@UlaLXKWaXI@alKlmUk@wVKXL@m@WWn@UVa@K@wna@aW_XWWkXbVW@k@U¯WWwka@UUaVIVkU@m±@U@@wVKka_@VV@XUVwU¥yUkm@V±ÈUKk»ÇLmmLk@ó£kmWwm@UIkWKXwWU@kLwkbmabkK@VLkmWIUKkUUÇIǫJXÅJULVÇLUV@UK@kI@WVI@UaWmXVVUL`±kÅLmKkkÅ@UaXXxWVXVbUXll@bkJb@bkVUVlnV@X"],encodeOffsets:[[112906,30961]]}},{type:"Feature",id:"4206",properties:{name:"襄樊市",cp:[111.9397,31.9263],childNum:7},geometry:{type:"Polygon",coordinates:["@@@Xl@Xb°WlLXl_@JlVVInwVbVK@@UnlVbkmx@VUnl@U@nbWXJ@VlLUVJVLUxVb@b@VÈ@XVVWbnX@`lkx@nmVnbUVVVzlJnlVbUV@@V°L@VXLWxnLV`l@kxlXnK@nl@XlWn`Xnl@@UVa@VÈK£VLVanW°U@UVU@`VInmV@nV@Xa@aVW@UalkXKblIyÆXnlJXbl@@VV@nklU@`nVKLVKVb@VU@UÈKUVKIlUX@V`lIVbn@nblVVmV@@XXJUVV@knKVn@`@XVnKwlLVmUUU@U@aXL@WlU@UUW@UmU@KkLWaXkWmXUWm@U@nk@UmK@U@UaUVUUKV_@al@namWUI@KUK@aV@WUIb¥ULUJkImK@U@KV@U@a@UkU@K@wVaUwlU@mUULmKUkV@@anIWmUK@I¯mKkl@LUb±lUakLmk@WwUKÝVUIm`¯n@Uk@makJU_@Jma¯ImwUVkKbaUÅ@wWaU@VU@mXIVmmUkJkwm@mIlUKWzUK@VmLUV@VnbmLVbU@@lkU±KbÝV@UL@¦VWUWXUJ@XVWV@VULnbWVbW@kmWXUK@Vkam@kkm@UlmXUnbWlUXV`UX¯VmUU@Ul@Lll@nnJ@LnWmbm@b`","@@kUUm@nllVKXXVKmU"],encodeOffsets:[[113423,32597],[113794,32800]]}},{type:"Feature",id:"4211",properties:{name:"黄冈市",cp:[115.2686,30.6628],childNum:10},geometry:{type:"Polygon",coordinates:["@@VVUnWVXnVJ@U@V@VXV@@IVJUn@V@L@KlIVlVanLVbnVlIn@@a@Kl@@IJlI@aXU@KlKkVblJXUVlU@VbVkVKXn@VlxVa²I@VlVUxln@bJXklaVWnLmÅ@y@k@aI@W@aXIlVVaV@nnlKnLVW@IUa@a@KUVVlI@wXKVV@IUla@lUXwWnnalLlxXLll°@XwVKVaXIlnb@nln@Va@U@k°UmÆUVaXIJV¯ÇUmmkU@WaKmakVm@U@aVKkkmKkVmIkÇ°£@aUUVaVVnKlkXmk@lUVaX@@Um@UmlUXVUVU@wK²¥Ua@I@UVl@UV±UIUÇ°»VkUmVI@a@Umĉ¯V±bŹĖğaÇL¯lmkX@óĀ@mÝêb±WkLn@xXx@@b@V@LW@UblţX`kxWnXô¯¦ÆV@L@JVLxkK@V@bkz°llXz@JUlVla@XUVbVKXnW`XXV@laVV@VX@V¯xx@xULVbUJ@n@LU@VmmakbUK@bIWWUUVkUmkLm@VJkb@nUJ@`V@kXaUaVmmLkUmJ@Uk@U±lkzmJUb@bVUxVXU¤L@JX@VlL@JkLUVU@mnUl¦@V"],encodeOffsets:[[117181,32063]]}},{type:"Feature",id:"4210",properties:{name:"荆州市",cp:[113.291,30.0092],childNum:7},geometry:{type:"Polygon",coordinates:["@@ÈJVlVVLXJlnK@UlLanblaxlK@XVWxXLlJ@VnXxlnô¤l@nKnÈKl¼VL²ÇUn@VlzV¦UxWVU@@U`lbUL@xV@²@@nlVUUJVb@VlbXx°XVWX_VKUwVKVa@UVKUUVk@KnblaUU@wnWl@UX@lÆ@@aIVmUkxVJUbÜ@Uk@WWnk@VVm@I@m@Un@mXUlVlUnJ@knJVU°@@aÆLX@llL@¦nJV@XblLVa²U@UlW@VX@`@LV@@bXJlIXml_lJU°bKÆLnVVl@öVmXaVIĢllUlVnLVlX@@bannxVLbn@°ÆXmmkĉ¯w±Uċ@KÝÅƧŃÝçUw¯m¯k@WkV@¯UIUJW¼kbUwk@W`@¦Uônb@VÆlÈ@VU@£UWWnUÆUnmJkUÇ£VWUI@aUU@WkI@Ua@JW@k£kaWVUKmnkKbkkVWbVmUUmwU@kk@UakUUa@V@nlx@lUb±lUbnnWLUyk@UamUK@mlk@Wb@VXL@x@xWI@a¯¯V@bVn@LkKmL@`XmKmVU@@bkL@V±bk@UaaLKUVIWXamVVbUK@b@Lm@UWkxULWVUnm@UlUX"],encodeOffsets:[[113918,30764]]}},{type:"Feature",id:"4208",properties:{name:"荆门市",cp:[112.6758,30.9979],childNum:4},geometry:{type:"Polygon",coordinates:["@@n@lxlInVUnWJ@nUVV@Xb@xVÆbalLVUnx°JnbI@V`lInbl@@V°mn_VJÞUVLXx@nllKVb²kVa@KlknL°@JVLXnmJ@bU@VlnLVKV@nX@lUKVaXal@VKn@¥°L@UnwbnaV@KV@VUX@lVXI@KW@@IXWV@laVLKlaXUVVnkVWV@lwXblIXWVkVmaU£VaUmVIkU@y@WakKUamU@UUK@kmK@w@@mK@LV¯U@WwkmULamVVUU@IbUKUakmm@UakLmxU@UÒWlULţÿmwkIUm@akÈblW@UVUUk@JW@XkWWUkUKUIlw@aUWknWUUmnIWaUwVaÛaVUIwVlUnJ@bÅ@@kVWk@mX@xVVkbma@LUlVVUL@VUbULVxULW`UX@V@lUXWaXlWXX`@bmb@x@LUb@VmXX@@nWKUL@xVlknkL@bWJXbWLKkb@VlL@Vn@VV@bnXmLUK@nUaU@WbXVWL@VU@@V"],encodeOffsets:[[114548,31984]]}},{type:"Feature",id:"4212",properties:{name:"咸宁市",cp:[114.2578,29.6631],childNum:6},geometry:{type:"Polygon",coordinates:["@@ÞÆLČ@V²°xĊnlWnÅ¯m@aK@°nJwnVIUaÆJÅ@wwVXW@aV_l@²V°lĊwlaXLwlUkalVVaX@lVXI@aUXJ@U°UU¥VIVKVklanLVa@VÈIVV@nk@aVa@mV_@aK@klKUa@UnKWk@@lU@@UW@@nUWUwmaVIXlV@mLXblJ@kV@kk@KU@WkUWVÅwkLmW@UmL@lULKULak@maUUÝwUJIbKUU@aWK@kUWVkUwVw@mÝ@I@wkW@aww@LU¥kJ@nVJIkVVnkVUkyUIUl@xWUkaW@@°kzWxkLUWmzk@@bVVVb@@XlV@Vl@bVbUn`Wn@WbVVI@`LVbXLV`mnU@@lL@LUak@Lk@WbUJn¦@lVb@xVb@n"],encodeOffsets:[[116303,30567]]}},{type:"Feature",id:"4213",properties:{name:"随州市",cp:[113.4338,31.8768],childNum:2},geometry:{type:"Polygon",coordinates:["@@@n`lwkUmUVWX@lk@VanUĠ¼V@@mX@@nVVVXLmJVLnK@bV@@J@VUn@VaVUUUVWVLV@@Kk_@almaVkUU@WVVUVLXmmk@wUaUKUV@°@kmaUaÈmWmUVklaX@lVnxl@@UnaUk@VUVwVKn@VVn@VbVJUknUmmVmk_VwKUUmVak¥@UVKVIkW@UmIVWkIVkmmLkwmVU@LUU@VVXL@JmLUbmK@UUKmkKUUmVUaUnÇlk¯mJUnmLUaUJUaWL@UkJU@aklkU@¯@KWLUmUUWVkbLUKkbU@WX@JX@@LWJkUW@UVU@@LUmbamx@V¯K@¦mULk@WbUbLkVW@kVVxUb@x@LlV@V@b@VU@L@VLnlJVIVK¦aVJ@XU@bLV@LVJnXmbk@@bU`VLUVVb@V@VnL@Vml@@VXnWVXnWlXblK@LnV@VVX@VkV@XWK@bVV@VV"],encodeOffsets:[[115830,33154]]}},{type:"Feature",id:"4209",properties:{name:"孝感市",cp:[113.9502,31.1188],childNum:7},geometry:{type:"Polygon",coordinates:["@@VnXK@L@°lVlkb@VlI@VXKVbVIVbnKVmnI°lÈkVmVbnUVVlLnVL@VnLVanK@IWKUUV@V@KVnUlxnKlnUlJUXnJ@VlXUJUL@Vl¦UbnVVLUxl`UnnnmVVlnVKbmVX@a°Ý°LaXJV@VUnKVXVK@LnKlLUbVVX@VwVJVn@@UU¥V@@UUK@maUVUkkJ@L@K@UmVUI@JU@W@U@UV@UIWmXUVmUUÇ@UVmIlmnmakK@akaW@UwVUkKVnUlKVwkVU_WKUkVW@UXaWkUa@w@VU@XaW±@IkbKb¯L@WXkW@UakL@UV@UmVUmL@UXWVL@aUVUUUVU@yUUIUa@wUKWVU@kWk¯UkwVKLUxK@nVxUlUUWVUmw@wUUyXWlX¦WbUV@U@blbUVVbXXl@lVL@bk@lxkVVnVx¦`UnkL@V@L@@@xnL@lVL@VnVVblLXb@@zlVUJVnUbV¤bUnUlWXkJWakxU@UXml"],encodeOffsets:[[116033,32091]]}},{type:"Feature",id:"4201",properties:{name:"武汉市",cp:[114.3896,30.6628],childNum:1},geometry:{type:"Polygon",coordinates:["@@nbnmknJVUÈ@@U¥VknmV@VUlK@IkK@UW@IKV£UWVwU@aVanIly²kVl@@VnIlVnKUnVbblWU@@_VI@mlaUIn@lKVnUlVVXXJ@aVLlanbUnV@@K@mVIUaVK@ww°w@UW@UUUkbU@WWX_WmULaVU@WkbkUV@IWyk¯kly@a@UlLwUK@I@KÅUW@Å±Um@wl¥ka@@_Vw@ķa@akw@kKW£XVUVwVwUaU@VUUxWKkbĉx¯k±Uk@U`@bWXUx@xÆÅIVbUJmxIm¯@UmxnUVVbnJV@L@@kV@bVn@UVULlx°VXllV@XUVL@xVbJVV@zUVVVUVV@bUKWX@VnKUVVnU@@VlKVb@lXW@X°KaLla@JX²Wb@UV@@xVbXlWb@VUXVlXLV`UlUxkLmVUlLUVVxX@lb@blL"],encodeOffsets:[[117e3,32097]]}},{type:"Feature",id:"4202",properties:{name:"黄石市",cp:[115.0159,29.9213],childNum:3},geometry:{type:"Polygon",coordinates:["@@VUVV@VbUxaWUblUVmnKlX@bXJVIlVUxVVVIUzlx¯@VbnL@xx@UVaXKb@XkWU_Vm²klWXVKl@nXV@@wmlK²XaÞén@ôÿ@lWn°kUKmmUÑUmm@wkImWU@UakL@bVLUVċ@bUK@alIXKWK@nXnKmkUVw@¯b@LlUL±Wn@KULUaW@kL@lL@bU`@nUb@bmlU@UÇJ@UUbmKkblUULUJV¦¯V@VWIV@bWJkUW@UbkUlbkV"],encodeOffsets:[[117282,30685]]}},{type:"Feature",id:"429021",properties:{name:"神农架林区",cp:[110.4565,31.5802],childNum:1},geometry:{type:"Polygon",coordinates:["@@n`lIXll@ll@b°aVklKXaVn@bU`mX@VV@nmJn¼V@bÞ@lL@lJXVlLaVLVnVnalV@VLÈUlblWXIKVU@J_@annaXm@KmI@mkk@KVkWWw¯w¯°@UUU@WaÅWkL@¥@kWWXkWmIUVVbm@@bUbmUUbW@UVk@mVkU@U¯mKVUkaW@aULÆVbb@VÅ@Un@VLWl¯L"],encodeOffsets:[[112624,32266]]}},{type:"Feature",id:"429006",properties:{name:"天门市",cp:[113.0273,30.6409],childNum:1},geometry:{type:"Polygon",coordinates:["@@@K@UlKVm_¥UwUmlUkwl@@aUK@kkWWUaVUka@aV@VUXaW¥Xk@WWIklm@ÅxmIVÝUkxka@bWJaUL@W@l¯UULUbkVUa¯bm¤UnÇUkmUUxb@VkXÇal@bVnlJnxŤĀVKXkVÑV@nwlKVbn@nlVbVLaJ@VVUnUbVKlnXxV@°U@KnL"],encodeOffsets:[[116056,31636]]}},{type:"Feature",id:"429004",properties:{name:"仙桃市",cp:[113.3789,30.3003],childNum:1},geometry:{type:"Polygon",coordinates:["@@VK°VkX@@VKbXI@alblwÞVUnJÆwn@lkXJ@XWVzV@xnxVXUVVVkUw@mLVwKVU@Um@alU@@@KUmIUaVUmnwmwmb@aW@UkmKkUkVġkUJWbnUõ@UkmUÅKL¯aVkIk`WnkJ@xVLUVVbUbk@WlXbmVxnxUblbUV@@VUV@nVL"],encodeOffsets:[[115662,31259]]}},{type:"Feature",id:"429005",properties:{name:"潜江市",cp:[112.7637,30.3607],childNum:1},geometry:{type:"Polygon",coordinates:["@@UbVxbXmJVnXVlmVX@bkxVJVLVlXXWlX@@IVlVUaVwVlnÈVVmn£°aVbUlaVUK@mVU@U@VUkaVamwUwnWaXkl@VaUaVUUK@wWI@aU@@K@_UW@kX@V±VUbkKWaU@mI@¥kKkW@ÅK@b¯@UVmI@lmIkVkUWVnm@@V@n@JUnU@mlXXl@@V"],encodeOffsets:[[115234,31118]]}},{type:"Feature",id:"4207",properties:{name:"鄂州市",cp:[114.7302,30.4102],childNum:1},geometry:{type:"Polygon",coordinates:["@@°¥WóXmlw_ŤWkVaX@@K@U@a@WwU@mWk@ULWkX±lUnV`XWl@aWLUb@Vw@wmKUa@°kwyVUJUUVwkUUJWI@akWmLUnkVaXVbUxUVWX¤lL@lx@bb@ĸUx@`@lbk¦@xn²VÆX@"],encodeOffsets:[[117541,31349]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/52",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"5203",properties:{name:"遵义市",cp:[106.908,28.1744],childNum:14},geometry:{type:"MultiPolygon",coordinates:[["@@@UnUlJnwJU°VL@bnVUwlJ@XXVlU@klVUJknlUllL@bUJ@xULUlUblVkblbnwUXmla@wV@VK@L@UXaVKVLXWUVa@U@Im@@W@£UKUakKWIXU@al@@llUnL@W@Un@@VlUV@VIUanKl@Xb@lmxVb@b°bb@nlJVVnnJ@b@LV@ln@LmV@Vx@blnVKnlJXIlwJ@Òb@nlK@Un@UL@VVVVUUUVKl@VUVLJ@UVUUw@Wm@UVÈVlbUb@JLlX@@xLmk@@nlx@bUJUzVJ@@LVxUV@bWxnLnVVK@_K²xVbV@n¥@aVI@b@l@VaKnb@n`nmmýW@U_wV@VlVV@Vn@n@nI@Jn@°¦VaUU@mVVWVaUÅU@aVKnVbVUmmU@a@kUwm@aUUmUUJ¯lakUaXaWUUaVkkamkmUnVlULVlJ@XU@UJWUUwk@aU@WbkWL@U@WU@@XUKmV@aUVwUĕUJUamUUVUÑmnIVJ@kl@XalJVn@KVL¥@UWIXWmU@mVUKnUWLUKUaWUUKVU@U@anUny@UlUkK@w@a@aVU»UkVw@WmkJÅmUUVmwXalLXWWUnam@XkJ@UVU@U@W@@U@I@Wl@Ènlw@KXLWblVUkalKUUVVaV@@wnIlaUmkUKWU@KkUkLWaKUUWUn@VK@LnnWJUIVkUWVnV@V@@XK@VUIUJ@IWJkX@VVJIVkK@I@UVaUWk@m@wnUWKk@mxk@@lV@bxmb@x@VUmLkUJ@nVV@b@VkLVbU`¯Il@U_UW@UU@K¯wm@xL¯¥kI@bkb@Ua@m@kkW@XVbmV@kV@bWbUbV@¦xXlmVk@¦bkaWL@KUImK@wUK@VUIb@bmK@LÅy@akXW@kbWlXblL@ULUb`@UkUymX¯@mUJUUJL@Lm@@WX@lUVlXll@l@Èk°V°X@VU@UVll@XUJVXUVm@@VXLWlnV@Xk@mVULnxV@@bmkL@VWLUbU@UVm@b@ķ¥UnmJ@UUVkkJUlÔU`UIW@°kLUlUI@WVIU@mWKkXk@WU@bXW@J@xX@l@LVl@xLVxXX@xKnxVknbKVV@ULWlXU`@nUlX@llVXVUKlkUKlI@anKVLXKVaUIVWV_VK@VnLlU»VKVLm"],["@@@KlKkUUVVX"]],encodeOffsets:[[[108799,29239]],[[110532,27822]]]}},{type:"Feature",id:"5226",properties:{name:"黔东南苗族侗族自治州",cp:[108.4241,26.4166],childNum:17},geometry:{type:"MultiPolygon",coordinates:[["@@VV@XkV@bUbWJU¼Vb@Vnb@b@J@bL@LV@UVlUI@aKULVb@bkJmxlLVxknVJkxnKmnnL@bn`WIXlWLU@UxVbUVmKVXI@JVIVJ@UL@W@@UmUXUlVUVJXImm@KL@UVmVXVLXblKlV@LXVLlVVnkbmJ@xnXl@bXa@VanaÒLmVnIlÞ¦°k@b@@lVnJlUnVX_@lVlKVUUxVLVWVIXJUlnnWlI@KUaUUVKn@VaVXV@na@mw¯@mUkJUamI@lk@@am@@IUmVImUUw@anUVaUU@LU@WaWUXWWwV@VwnU@L@ynbl@@X@aJ@nW@@Vn@lVLlxnIl@@UWKUnIlJXIVllIVV¼XK@aVIV@@bn@VKXLVKVVVInwJ@UWI@mX@WKnI@KmUUVJUL@VKW@@k@aU@@W@InJWUXwWI@W@¯wkaVaUIl@nValIXWWI@UUm@anwWkXWWIUbk@UJmIUamKVUUUVVama¯VkIVVUlKnXVwX@@WVaUUVa@IlaVmknawkUU@U@mUVUVwl°LVbnJVU¯la@mX@@UWKXU@aV_V@@JlkU¯@VnK@km¯kU@WUW@mmU@kmlU@wkL@WUkL@VmLJ@b@V@bknUUVK@UVKUK@Uk@Wa@LUVVnUbmVk@@UU@@aV¯K@U@UU@WmUL@aU@WVw@IxXll@UXK@KXXVJna@wWa£naUKVm@UU@mUmalm@@XkVm@U@VLmWU@kkWxU@@bVV@VkXVlV@UUk@@mI@KUwm@UmVUUwU@lwkV@IUa@mUaVIVKVa@w@U@UJkb@n@bmJ@XmlVUxWXkJmUkUUVWxUlU@aULUmbU@@WXkmL@xUV@nUxÇm@XLWbnlnVnnUVUnVVz@lbUVVlULVb@V@nUJkwm@Ux@bWbUK@UULkaJbUU@U@lUK@XUJmnJ@bU@UwWax@zkJWnUJUUVVV@bXn@xVb@JLm@Xw@`@bkb@VmXUV¯L@mW@@n@V@L@KIW@@aaUx¯@Um@XbW@@LV@bnVWVkKUzlV@bÆa@lnI@VV@@LnVVKUaV_VJVbnU@bn@nX@yVIVxXKVLlUVaXU°J","@@@KlKkUUVVX"],["@@UUVUkUmV@ln@VXVK@K"]],encodeOffsets:[[[110318,27214],[110532,27822]],[[112219,27394]]]}},{type:"Feature",id:"5224",properties:{name:"毕节地区",cp:[105.1611,27.0648],childNum:8},geometry:{type:"Polygon",coordinates:["@@UkV@kW@Xn@@KKVIVVIn°@nWVzl@V_VaVK@kKWaXklaX@lW@bÆz@KnL@aaVJ@UVL@xnLVJ@LXKlba¥l@nUWkw¥U@VaXa@amLkUKm¯kmkIUaKUIWkKm@anw@mlwXImUk¯@a@amU`kkKWVkxmUUak_mJmw@wmXUW¯X_@WnI@aVwkWWýÅU@WLkUaUbVV@lUVVnm@kUmV¯kKLwmVUUaWVaaWw¯wÈ@VULUVUUK@nWJkIl@Umxnbm@kbUJa¯bUbVxmLUVaU@VUUWxkVVV@bUV@XWbnlUbbUJlbUV¯b@z`WbXnmbawUwVWUbUxmbU@Uam@VkVawVaUWI@mUKóz@lUlÅ@WIb@xXxml@XklULWKUmwUa¯KUXWJkaULmKkLWbkKUVImWa@kUaULW¯LK¯@kbL@bx@J@bmnnlUlzU`U@@Ub@mn¦°bUVx@bkVm¼mx@mkmVV@bkxVnaVV@bU@mL@b²`lIVV@lXLlbVxn@@bl@XllIVnbVn°°wlbXw@mVa°lVnU@mVLVbn@@b@@WVnUV@Xlxn`VznJVb@L@bV`V@UnwU@WUXKV@UUlmUUlaXalLmbIVbnJVIlVVaUUnWVXnVLk@nWnblnlb²xxVKVXlVXLVWLlUVJna@wVL¼@JVX@`@nnx@nWJU@Vx@XXKUblxU°LVKVVlL@KnbVUnJIlUnKl£VWxIlJ@nVÞUVVnbVX@V_°lnK","@@@UmWUwkU@Um@@VkL@V@VVkV@nbVa@"],encodeOffsets:[[108552,28412],[107213,27445]]}},{type:"Feature",id:"5227",properties:{name:"黔南布依族苗族自治州",cp:[107.2485,25.8398],childNum:12},geometry:{type:"Polygon",coordinates:["@@V@IöalK@UV@@KUaVIVVLlaVbVWnX@@LnUlxl@naVLXVVaVUJ@lUUanWWI@VlV@Xbb@Vn@VmVVbk@kU@VV@XJ@zn`ULW@kK@_WVUK@LUb@Jlxn@nnWlU@@bx@XVVU@UbVb@n`VI@VVLUlUIUV@KmL@VV@XIV@@lVLVmXV@WLXLW@U`nkb@Vl@UL@VVVLllX@`lIXbJIXWLaVL@XXWĢb@bmK@L@°@VnxmxnK@xVn@VkL@VLakbl`VnnxVnUlV@@VVXV`@k°JV_UalK@U@aUU@mIlVnKV@U@wnaw@akU@l@nwl@XLmV@xnl@VXUb@V@JlLUJUI@UlWUnLVUUaVwV@XKWkXJm_@amKnmmLwlUIlmUwkKnwlI@aUaVKL@bVJkVUU@@KK@a@I@ama@UUaV»XIVa@alU@WUU¯IWVUbkVUKWLUwUJ@zmWm@@amVUaUIU`VbULmU@KU@@UmJ@kÅb@akUVylLXUmU@aU@KX@Wan@V°@Vwb@bX@J@LK@@U@mX@@n°KVUnW@Ula@a@_x@WnK@IUa@wWm@aUUUVVVIXmlI@ywXbVxV@@aInmVI@WVL@k@VVVaIlbVK@VVLXa@aVwn@lxVI@m@UUaVKUkVUka@UymUVVUmmUmmkXaWK@ÈnVw@mVU@wKlnXW@V@naVVKUk@KVIUW@mk@KXU@Um@@lVk@UVJna@UWaL@a@Xa@kmmVUUk@mkkamJImJUUmIm±aUUkambkamVUU@VlbUbVVxXWVUU@VUakU@UmUVU@mnUVVnUbVJ@bUW¥kLVamVkUaWJU_UVWKk@@nlUVVJUXm@Vm@UnVlmbnmJUbULU@@UUKWVIWxnJVb@xUL@bUJWIkxbkb@xVJbmU@kW±LkKUkVa@a¯am¥ULkalÑlKXUWXaVakImV@ka@UUJ¯aXmmbKWU@wUUaUaKmU@UXlWb¼WLUKUb°UlVbkbVL@VJ@nVlUbUXmJ@VX@lbUbU@@bWb@VnLVJ@bVVUzVL@lnL@bVVVULmKUkJkbm@xVb@VkKVnnV@b@WXUnVlVVXVJUXlVXbWV@VU@Ubk@@KWbUUmL@JnXV°XJ@_`UbkXVVlÆkb@VLXVV@V@kKXX@`V@@n"],encodeOffsets:[[108912,26905]]}},{type:"Feature",id:"5222",properties:{name:"铜仁地区",cp:[108.6218,28.0096],childNum:10},geometry:{type:"Polygon",coordinates:["@@°a@aÈbVUlU@aVKnVVVUlyX¹lWVa@UVnUVU@m@mUl@mÞw@xnIVbna@KVIJ@kwV¥UXÇVkVW@kkKWU@aXUWmnIVa°VXbmL@VVbnVVVUbVbJVbVKXkVKVanU@aWnWUWa@Unk@mVIVK@wXxlLXbVJVlKbl@VI@maXalVVVbX@@aalnkx@b@Vb@Vnx@bVVUXn¤WXn@Vl@Vlzn@`@I@KUU@V£namVkXa@aVKnnU@anVlKa@UUU@amk@»kU¯@aVWnkWmkImU@akaVm@»VUV@UKnkW¯XWlkUKnIWa@nmlIXmWUnwUwWm@wULmaUJkIUaaWaklwkwmJmU@bkJ@XUJ¯W@XbWbUKUkWJUUVKnn@UmmXUWa@mU@@UI@WmXVykwm@kaULWwU@¯lKUUVU@mU@UkmaUbmV@bxVnVUJVn@Jn@@bl@@knJVblInV°@nx@mbU@UWUbm@ULVVVb@LkJmXkmVWIUJUXUKVwVUkLkU@W`UmkVmIU@k@@a¯lÝ¥kmJUnKÑmbUb@Wbak@mWU@UbUVVkLlbUVkXaWK@LkxÇmk@@X@J@V@@X@VUV@VIWln@mbXVWXkKWbnxVUnVÆInl@XUxVl¼UV@b@b@xlLkV@VmzmV@b@VUVVLXVVbVLXKmVVLU@nnVWXXJ@V¦UK@LUmkIWbk@@lUImJnVÒVUnVVbVIVĖUxV@bnUVL@WV@@X@VKlXXaV@@blVxXVVIV@@WkIUVKUkVmlnnbllUVbXVWbblVkb°VInVVV@bnVx@l@bnVVnUUamUL@bVVÆUbUXUn@VVUb"],encodeOffsets:[[110667,29785]]}},{type:"Feature",id:"5223",properties:{name:"黔西南布依族苗族自治州",cp:[105.5347,25.3949],childNum:8},geometry:{type:"Polygon",coordinates:["@@VL@Vl@@IXW@kVUVbnW@XlKVVnUVlL@baVbb@xX°ÔUxV@kbm@VxkxWJV¦@ÈnVKxWXJmV@nÒ@xVbn@@blLk`VX@bla²JVUlnn@U±lw@wnw@mlwVIX@@m@klKnkaKnwmmXkÆVmU¥l@nb°n@aVwVmVIVnI@a¯@mU°l@@VnI@JV@UV@b@IUbVJmXöºzllUbVa@aXUl@U@llLnKVaUa@UmK@UwVbnKV@VwVK@UXV@Vbn@w@UWnX@a@mI@UUKlaUaVk¯VaVLXK»XaWk¯mkğwmW@mIVkwJUIÇVwUUkVKkm@UkmU@WÅwm£Vm¤¯IkJWa_lUbmJzÝJkUÇVU@bUÝnm¯LUb@`mL@VkL@VUmmk@UU±Umka@kU@ķymUkk@mmkÝmUaUakImV@V@VÅL¦JUXmJXWb@n°Æx¼nV@LlbUUbmL¯@ÞbV¤nbVx@bUVlblI@KVVUnVJUn@VlLUlmLUUUxmK@I@@VW@@bU@UJmUkLVVUl@b@V"],encodeOffsets:[[107157,25965]]}},{type:"Feature",id:"5202",properties:{name:"六盘水市",cp:[104.7546,26.0925],childNum:5},geometry:{type:"MultiPolygon",coordinates:[["@@ôyVL@nXJVUbxbUlU@nVbV@naVwaVUXVxxbnaWmXa_@y°aVUkaVIaVamkXa@WVU@aUUlUXwVV@UVbVUnKUwVa°abVIlan@manw@VklJXI@mLVVVUVK@UÇk@KUa@UkaVU@UVWV_XWVXVWlLXKlLXaÆKwVL@akKm@Uw@@XUVk@VUI@wWK@aUVI@UkK@mLW@kImJUÅVmkXUW@UJkx@nmx@xkxV²m@kmUV±Ikb@aUWl_kK@am@Ua@wÑ@mnUWIXwULm@ÇU¥XIlwUwn@laU@Vw¯ÓW@waUab@akKUmVUUkL@WmXUaUV@lWX@Jk@@UUKULmLUJmzkKmVX°VUnWKULL@mU@UnVJ@b@UV@X`m_@l@@bmbXJmnn@°wnn@VLX@V@nVl@nk@@bl@nn°WlXzW`XXVKnUlxVbUb@VXb@VxÈbVlnbmn@kVUL@mLUVVL"],["@@@@UmWUwkU@Um@@VkL@V@@V@VkV@nbVa"]],encodeOffsets:[[[107089,27181]],[[107213,27479]]]}},{type:"Feature",id:"5204",properties:{name:"安顺市",cp:[105.9082,25.9882],childNum:6},geometry:{type:"Polygon",coordinates:["@@lL@bUKxÅLWbkKWLkKUXUWWXU`UX@VUVlb@VVb@Ll°xXxbbXUVbVnUxKlL°nUlVn@UmVU@kUUVablVXKV@ÆXþlXUxnU@mVK@_@ml@UU@blU@KnLVyUw@@UmkWVw@UVK@VXzVK@nVVUUW@kVJnla@nKWkaWL@Uõb@JU@mU@@_WWL@lUU@WUUK@lakÅUUlWVa_@`WIU¯mW@InKVVXa@Ll@VaV@@UXUWakUVWUIUWUkUmVXW@@amUUmLl@UUawn@laIVlnLVKUUU@amK@kUKVyUU@aUImK@UXa@aV@VakaW@@UnIVWVaUkb@mWX@Vxm@UaU@W@VULUxU@mLaUx@VnL@VVbUbmLkK@kVk@WV@bUbVakkyõ¹nWUIVa@J@aVUU@@ImJ@Uk@¯V@n°@bmJUUJUnUxbm@¯mak@¦VUnÅWlnnmxLbmlkL@l@nWVnlÆUVnIlJ@XnK@lL@VJVU@bXL@xVJUl@VU@W@Vxn@"],encodeOffsets:[[108237,26792]]}},{type:"Feature",id:"5201",properties:{name:"贵阳市",cp:[106.6992,26.7682],childNum:5},geometry:{type:"Polygon",coordinates:["@@nlLXVJLVblJn°lnLlVnKlU@nUUa@WlX@ln@Vb@la@alJ°¦Kwn@°xLVkUmmwUmk_labK@UlK@UUm@wLmnwmw@U@¯@KnL@aaġXWW@UKbKWXJIWakJ@_kWkKUU@UVKk@@UlamV_X@WKXK@WUUnUK@kU@WJU@@UnK@LVUVJVkUK@UUJm_@UaVaV@UU@Ww@aV@Xkmmm@kw@IVa@KVLXU@`lLX@VKm_@yI@WU@UlVl@UanU@Um@UaWaU@Uk@XJmXVbkV@IUVUbWUUKmbk@kwmV@K@mWUXUakbKUUUJVb@LU@@VkL@VXKlbXmL@kbmUI@lVXUVU@mULWy@UUL@VUxXnl@V@VxUzmK@LkVa@VVk@@n@`UL@nmV@bmJ@X`WX°WVn@xnxnIl`VbnVlwXUlLl_nV@b@bl°VnWJkx@nmx@b"],encodeOffsets:[[108945,27760]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/37",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3706",properties:{name:"烟台市",cp:[120.7397,37.5128],childNum:9},geometry:{type:"Polygon",coordinates:["@@ŤLLllVń²è°xżĢĠÆlÒŤbV¤ĊXnlĢVĊÒÈ°ĊŰÞèL±@џn»VUźċ²»ÆkôVɆkĊŃ²kŤVVwUUVmUa@KkU@mUmmk@UwUkmW@UVIXa@mw@aKULax@Uk@UbWU@yULmK¯@kXVUwm@@JUUknWKUVLUbU@wWykIa@w@mUI@aUVynIWak@@Wbl@@knmK@wnIl°Kna@V¥ğ@ġUķ»¥@UōJX¯¤k@wmI¯k@mwak@@lX@bUJ@VbknWxkLkxlLVlkLmb@bU@bU@VbU`Vb@nL@mbU@VnUVmnU@mm@kIUWVIUKVkkUJUnmL@VmLUaVWaXamU@U@KUUmVUJUVÇwğnm@mXĉV@l¯xnô"],encodeOffsets:[[122446,38042]]}},{type:"Feature",id:"3713",properties:{name:"临沂市",cp:[118.3118,35.2936],childNum:10},geometry:{type:"Polygon",coordinates:["@@bXll@zlV@lXXmkbVVlU@Vn@@Vmb@XKVXWJ@XXl@ÈbVLUl`@XXV@VVUxVbUxVb¦@WnXVJ@bnVUzl@°ÆxUKlU@mUUnUlUVWVUnVV@XX°V@Vll@VkaXVl@Ux@bmbXLlKlb@b@bUJn@@b@n°x°K@an@@UlLVKVbXb@bVVnK°LVa@UVa@XwKVxnLU°@naV@UWUkWULmVwÝKUUla@aó_@mK@aUU@WUkwVm@aVI°W@@IUw@a±¯@¥kUVUm@awkw@K@kVKk@maXalI@alLWXblaVLVUV@LnK@l@waXaLlnUlLmV@n°J@_VmnIVym£UKmI@WnIVm@anUVmÇ_kġIÅWUXÇm@U@Ý¯Å@@naWIVW@IkK@klKn@naWImk@abkKkLWnWkLWmk_@UaVUKmLUw@mn£WwUmUaóV@UkUm@UKULUwmJUX@WW@XÒzVblJXWXk@UVWKX¤UL@xU@@VUaU@@XmVkLmWkXUyÝLmKXnV@n@lx@bWLnVVn`knULmxUlWLXVb@VK@z¯x¯¼WxKUn@bk@lVVVz"],encodeOffsets:[[120241,36119]]}},{type:"Feature",id:"3707",properties:{name:"潍坊市",cp:[119.0918,36.524],childNum:9},geometry:{type:"Polygon",coordinates:["@@l@@UK@@L@bX@@VlL@JLUVnX@`ÜXn`V²mJ@bU@@nb@l°xnnĸVÆ°@Ċ£Þ@lWnÑnkʶJmó°w@kk»V@»¥k@V@kw@wVmaÅmaô£ŎXI@mlnKla@mV_UK@kUkw@alWIU»m@WUIl±UUÅUbkJ@a@wUKUaVIÆmXIWaka@m@Ul£XKVw@UIJUkmJVkU@aWKImV@UxmL@bX`WXU@U`ÇkUak@@°UblXkmLUKmL@VULóVk@@Vlbn@Ub@ċaUJUbIUlVLUVVbVKXVlVXU@mb¯@VmKUwLWx@Ub@VUb¯KmLUU@aWaUaULkK@Vm@@b¯L¯w@ma@m@UUU@U¦lJUXVmkb@nmXVWkbIVxUV@VUbWLXVLW`Ux@nk@Vn@x@VkJ@V`mXk@VxV@lVI@VULVUIV`°bVXXxV@VWVnL@xVUb"],encodeOffsets:[[121332,37840]]}},{type:"Feature",id:"3702",properties:{name:"青岛市",cp:[120.4651,36.3373],childNum:6},geometry:{type:"Polygon",coordinates:["@@@nUJXL@blVUnIVlIVJ@UxWLk¤@V@nlbXbWJÅnUJVbVL@x@blIaÆVVVk²VJ@XnV¼JkX@blxlV@VLU`@nkbLkm@nWJōó¤bnÆbUn@xlxU@l@¦@¼Ul¼ĊUnW@nĠmÈxUVIVnUVV@LV@nVWbXbUVbnK@UnKVmVIllUVLUJVXlJ@nnV@nmVUUm@Vna@K@mUaV_UaV@aV@@aanlKUkKklwlKXwlma@UVI@akW@l@bnxl@°nJxl@°£WŎIUÑn»lamô¹Ŏ¥VaUUkmkġWɱIUUŹ`@kk@ĉƨřV¥_Ç@Ĭ¤ÝL¯m¯£ƽóķwUW±ī¯kōaĉĕkğmó°bW@UKkLUaVmz@V@UxVn"],encodeOffsets:[[122389,36580]]}},{type:"Feature",id:"3717",properties:{name:"菏泽市",cp:[115.6201,35.2057],childNum:9},geometry:{type:"Polygon",coordinates:["@@@¥IVUÈmÞ»@UlU@Un@VW@UVmkk@aVUUKVÝ@UVknK@UV@VVnIV@wnmwmKXaWaXI@UV@Vy²blkVKkamU@kb@Um@VmUkmKmkXKWwkU@Ul@UnK@UVUUmKXwUVLwKU@@Wl@@wUkV¥@@I@W@_V@VWUw@UUa@aaWa@@_mKUwl¯amzmV@WKnU@kWLķaUKbÝVmV@UWÇbÛ@X°UbW@XmVlk²UJUbmLÇxÅWUzl¯Ll@VkKXUbWJ@bU@¯@kbLmKka@l_WXºVbUz@Jn²V@¤lXnV°Ln`WbXLôVlKVUxXnlXLlU@bVV@XJWLUVnVV@@nl°nnVKÈbVXÆJU°VnXVkV@@xVL@Wlb"],encodeOffsets:[[118654,36726]]}},{type:"Feature",id:"3708",properties:{name:"济宁市",cp:[116.8286,35.3375],childNum:11},geometry:{type:"Polygon",coordinates:["@@nam_nKlVLXaIl`_@KVVXI@m@w@@k@Knô@n`VbV@@LL@KVVn@VX@VLJl@VUUU@Uam@UkwKWaXamkJmIUVUÈblaUnV@kVKl@@lXL°kVJ@VÈnVJUX@VLXl@xVLnU@VKV@aIUaV@bĊUxKkVJXUlVUVaI@WUI@KlUnwmWk@WXIWUL@Wna@Um@@UVkUUlanWW@kkU@ykWkaWVUlÝbUU@kJUIU@@JmaókLKÇUUkKWLk@WbkUUabmKn¯°¥V@XwV@VanaVaU_@Wlk@WÈ@VUÈVVÛmaklKÈ¯lLVUX@lK@aX@@kV@VmV@VwnJV_UWUwXam@kW@wVUkKVIUUVmU@UV@IVK@aUL@aV@LmUKmx@ômLkUWJ@nXmlUxUL@VknVUU@VL`Ub±LkV@kUKÇbÛ@UWó_mJ@Wk@@X@VLxUKVWxLVnUV@VmL@Vk@VlVXxWLnlLnVlUnn@@VlaV@nlbULkl±aUzU@@VWJXbWbnLnxm@xUmJUUU@@VmLUl@VUÞVLUV@bllUn@VUXm@@VkV@VÝ¼ÇnUVJ@¦nnlnVlL@Þb°KVV"],encodeOffsets:[[118834,36844]]}},{type:"Feature",id:"3714",properties:{name:"德州市",cp:[116.6858,37.2107],childNum:11},geometry:{type:"Polygon",coordinates:["@@¤@VmbVXnVVbVJX@ll@zlVInl@@bVxUbĠl@ÈblaIxXVWb@L@nULWVXXWWLnL@`@LUVVL@lVnJU@UUkanVôôb°¼VÞXIÜbČabôWXÞWÈzÆmnLVJ°ÈnlV²lbnW@@UUVmnwmkkKWkla@mVIUKUaaUwmnJU@@amIk@@bVlkX@mmUklUUa@_UaUUV@wwWkXmW@I@WUaÝU@UXaWUU@UUVW@UUUWUn¥nUVa@m@k@alU@wkLWa@UUm@@wnmUwla@anKn_@alK@Ý_@@WUUUmlkaIyU@UwU_Wa¯yU_mWUwkImm@InWWUk@@UVWVkW¯U@VL@b¯b@l±¦@VV@lUbV@kxVnUl¼XV@b@lV@nIWxnb@UULxÅxm¯aUwU@mUÅVÝKULm@bmKUXó@"],encodeOffsets:[[118542,37801]]}},{type:"Feature",id:"3716",properties:{name:"滨州市",cp:[117.8174,37.4963],childNum:7},geometry:{type:"Polygon",coordinates:["@@Vb@`bVkVlnV@nlWUk@al@nJ@bV@InmVxbVbVLUJ@nkblXlLnlmxnUV@V@mXnlbĸ@nnVxb@lnXV@UJ@nVxxnxVbÆVn¯ƒĕ@@wÈçUÇlķVIb@Çmk@¥k@UkUK@aWakUóJW_UW@wkkWK@U@K@XUUkmUUalKXala@U@kkWlkÈl@kVmVIVmU_awnwVW@wwU@wU£wkJWIyUI±bkVUJ@nmVUklXmx@lnbWkVUkLWxkKUUmUkbJ±LÇxUKmkUmkkWamUaVkJÆ_²KĠ@UW@wU¥nUWwK@aÝUkÅVaVK@akLW¯I@bnbVx¯JWñWbUL@nV@VmbkUUV@IÇak@@bWak@WJUJWL@bXV@@VJlb@zUlUUImnbVmz@°UV@VbV@@V@L@xLmKUnmJVXJ@VkLW@UVUL@b"],encodeOffsets:[[120083,38442]]}},{type:"Feature",id:"3715",properties:{name:"聊城市",cp:[115.9167,36.4032],childNum:8},geometry:{type:"Polygon",coordinates:["@@ô@VWnLan@VKÞLÆUnVV@xVbn°ÆwwKVV@maXwmJU@@k@aWUk»VUmlw@UVa@kUU@²¥@k°a@aK@UU@mmm@ówÑ±¥¯@@wKmwI¥kU¯UmakJmIUaVkKUkm@VUUaU@UaKUK¯@wUVUIUKVwk¥wbV@xn@lWnXxlL@`XlJX¦l°XxW¦@¦Uln@@@Um@@VXVmx@¯bllUnUJ@VULVn@bxVVL@bVlnVVblVÈnVlIVJLôlJ@xl²"],encodeOffsets:[[118542,37801]]}},{type:"Feature",id:"3705",properties:{name:"东营市",cp:[118.7073,37.5513],childNum:5},geometry:{type:"Polygon",coordinates:["@@ͬUǪlô@°Uw°ōĠ¯»Ģç»XÇ@wwƑaÇkwVƑ¯@ÅķUmm¯w@ka@mV@@anIU±m_ÛW@_mWVUK@IkK@UW@@a@K@L@Vk@±U@UV@lm@mUU@kLmxV¤@xVx@xUXmxxbV`UnUJnU@lÇkkllX@l@VkbWbkLVbnVVlWV@@L@VXLll@xVXX`ôIlVXb@bVLVll@@¦nlÈ@aUJkĸVÈÇè@x"],encodeOffsets:[[121005,39066]]}},{type:"Feature",id:"3701",properties:{name:"济南市",cp:[117.1582,36.8701],childNum:5},geometry:{type:"Polygon",coordinates:["@@²¦Òôxn@nn@V°VlXUUX@Vl@XVmX@JnnlJVxnXV`°zXbV`VxV@zJlbkVnVV@X@`@ÞkL@bm`mL@bkbxnVm@xn@VV@XbKl@xkV@b@l@nUbmVm¦XVVV@VUXVVV@XVWb@VÞVVb@X@JnXlWXx@xUVV@aVKVUX@lK@UIUWnIVmnLK@w@K@UU@a@UVU@¯nyUmanVJVVk@ykaIU@@WU@aXKIVXIl@Xb@al@Èb@JVUlVna@UmU@VKXaòX°IUwma@aU@UU@wVW@Ñw@aI±`kbUkwUmJ@UkmÇUUkmKknUV@mJUkaWka@KmKkULmyXa¯_@WmImmbLmUkVUbUVJbUkkWJkUlIUmkLlK@knaVmkI@mWaLUKUU@@VmLUVLWK@UUUWUkkVmx@Vl¦"],encodeOffsets:[[119014,37041]]}},{type:"Feature",id:"3709",properties:{name:"泰安市",cp:[117.0264,36.0516],childNum:5},geometry:{type:"Polygon",coordinates:["@@n¼WnxL@x°@¥Uk@nwlUVlXVV@VXLKVUnK@UV@VVLKXb@nlJUnmb@lkLKlVnJklVXIllVaIVUValUnVKannnJ@X°`WbnzKlVnL@LbXlbVlnI@VUU@UmV@U@U¥@VmV@@_Ua@m°@@kmUUm@UVmn@nX@@aanJVUVLmlIVJn@nkVLVa@KVmVLXVVL@@U°bn@VaV@@K@aVkbWaXUVymU@aUImWX@¥UaVwUaVwUUU@WW@k_VUKÇa@nmxkV@LVJ@XJUbVkUWVUIlLwĉVaU@VbJ@bUUL@mVUK@wWkK@UVWUIÇm@UUI¯lWK@kk@UL@lmUVkbÇaUVVnJlInWbXbLxVln@VbV@VUV@kIUK@UWm@UU@LK@KU@Uam_ó@m@L@l@@x@nWJUU@L`k_JWbUKkmLn`mb"],encodeOffsets:[[118834,36844]]}},{type:"Feature",id:"3710",properties:{name:"威海市",cp:[121.9482,37.1393],childNum:4},geometry:{type:"Polygon",coordinates:["@@VbUnVVUxĊ¼¼ô@ÞÑ¯WǬLŎUÆW¹UÇō¯ÑÝkţţóġóLł̥Uwm¥kÝmkkKóbÝ@U¦@mb¯LkmJ@xLmn@lk@a@X@lXbmJUzV@bVJ@n@xblJXzxV@VaKVUXLlmVV@In@VxUlW°@nLVK@zXVVal@@VwbVKL@bnx@WbUJ@VnXVlVxl@nnnV@lV@L"],encodeOffsets:[[124842,38312]]}},{type:"Feature",id:"3711",properties:{name:"日照市",cp:[119.2786,35.5023],childNum:3},geometry:{type:"Polygon",coordinates:["@@UaVUUKVkJVaVIČb@Vam@ka@Ul@UôVK@UnKVLnKlkWVa@¯l@VbÈlV_V@XWW_@anKVwUmVw@@UnyUVblKVLX@aô¯ó¥mÛĊÿÈ¥Þ¹lUī¯Kĉ¼ʟbÇVUUXmakJUnmV@bUnmJ@XnJVLn¤UzmJUn@`¯ImU@nKVkkmKWbb@xk@mL@KUUVUKkbWaXkK@bkJWbnbl@UL@lL@lxx@bnUVlV@¦²°@bVx@J@¯XUJ@bUnlxVX@VV@bL@nô`@bkbVVÞLxnU"],encodeOffsets:[[121883,36895]]}},{type:"Feature",id:"3703",properties:{name:"淄博市",cp:[118.0371,36.6064],childNum:4},geometry:{type:"Polygon",coordinates:["@@nlKV@nVn@@kVU@²VVaU@wmKXU@UUWwUW¯aU_JUVVK@UJU@kUw@UlnWU_@lI@U@wUml@@mVwX_KWUXKVa@UVUUwJlaXWUn@mlanUVWkIV¥V@VVVI@a@akakLWKna@aVwk@WUbUlk@k@U¯UWWU@mUUVUXkVmVVV@nkVLVÅw¯k@WVXbaUl@bV@@b@xkVVXVxkJ@nk@@VLUlVbVXUVVUzVLVbUbVVWVkLmkJ@n±@UxUVVkV@bx@ÒUX@xVVV@°JXlK@bULUblÆÞV@bLXxmV¦V@xXVğ@±LÅ`IUlVbnbXllVnnlVLÈwK²IlanVVVlLwXlKVlUXma@knwWlkVnU@mVIUl²aVJzXJlI"],encodeOffsets:[[121129,37891]]}},{type:"Feature",id:"3704",properties:{name:"枣庄市",cp:[117.323,34.8926],childNum:2},geometry:{type:"Polygon",coordinates:["@@yUUUkl@@aVmLXw°»°w@yL@UUaWXKVknwVKlm_UmmUXK@aw@k@mUWmUL@@@£@KbÝV@akwaULmbUKLUU@lm@°mL@nUJVxVXU`mIUxU@UnU@@lW@@bkLW@UVkKÇ°kLlbnUÜÇUUVÇ@@Xkl@XV`UbmbUbU@WxU@¯¦m°nLaVblVXal@XKlLVVÈLKôlnbI@V@VJI@lVVÞaVkXU"],encodeOffsets:[[120241,36119]]}},{type:"Feature",id:"3712",properties:{name:"莱芜市",cp:[117.6526,36.2714],childNum:1},geometry:{type:"Polygon",coordinates:["@@lmnLVlÈVln@VnIVlxVla²_JlUUUVVw²@@mlInlKXUUUVaUaKUVyUUWVUUaVkUK@l@@mlIUwUWlU@w@aU@@LU@Ubm@¯a@V@UKWUUKUn@LUbUKmlm@UIkJnUKUVmIb@b@mWm@Un@VVnnVl@¯@@nVb@`U@Un@¦@V@VUVnV@"],encodeOffsets:[[120173,37334]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/36",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3607",properties:{name:"赣州市",cp:[115.2795,25.8124],childNum:18},geometry:{type:"Polygon",coordinates:["@@`l@Èbln@KVLl@V@bÈlnKXkVlVL@lJnb¦VKVVnXW@w°@VUmlnUV`UbVUV@xnKVI°KXKVkVL@al@XaLVlULWVVVL@bx@VXVmb@x@VVV@nn¤lb°b°KXXWbX`lbXxz@x`VIVUnKLxWXLVKVbVLVU@wnW°b@nalXmXVJn@U²mKkVlU@@xlnaVmlKn@JVLlnVl@XXÆèVlUX@xVLXVb°W@wnUWmXk@KLVwUmUkUKUw@wVaVK@k@WnkUKWkwlmXL@KVUlLVKXmWUL@aL@malaVk@aaanX@VVUblbJnXaVwn£K@UWmUk@UaWIV@bJW@KmmU@aUUUkmKkVKlUUnKVUlVaV£Å¥WUUK@UkUUw@m@mIkUUWLK¯Uw°¯@wUKUbKm@kkKUL@UUKV¥U@manw@k@U@Wm@@U@WwkmwWaUU@UUmV¯kw@@kmkKkUW@UK@ÅV@XWWkXa@Ul@Va@KVaUUU@aXwla@UkVWaXk@K@lmkUmV@Vmbk@»XI¥VUkVUVU@anKVUKUalU@wX@@a@K@ÝwL@UnÇlUIkJmn@bVVb@VmnkLV¯U@±lIWm@kaUI@aÇU@K@KUIkbWbJUIUyX¯UbU@méUUmUkWKxWIkJm@V¥U_UJUwmVkUU@@knwm@UmkWJkL@n@VW@@U@knm@kUml@xÅx@@XUJlb@VXJVxn@lbV@lULnV@VlnV@bWV@bXL@lVLVbV@blLn@VlK@xln@bX@laLVbnKUVVbKlXVVkxV@nnVUblV@@z°WWkbIkWL@LUJ@bUI@b`@UmI@mkK¯XWmUV¯@UUVUUam@@VULWUJIm`IUJKUkW@UxnWbnnmlXbmIUVmV@Vnb@VLUKWLnÒVVV@VUL@kJUV@bÈ@V°@XVV@l@xUz"],encodeOffsets:[[116753,26596]]}},{type:"Feature",id:"3608",properties:{name:"吉安市",cp:[114.884,26.9659],childNum:12},geometry:{type:"Polygon",coordinates:["@@lxnb@V@bV@ln@nlIn@blVXKnk¼@VUKWL@bL@`UXU`@V¦XLĠ@lJ¦@nV@l°nn@mVXna@nbKn@lIV@VanJ@_lKVVnL@LK@Vn@VbUVanKlLnbnJVbnWVnVVanI@Vb@LbVKVanXVbVJVU@aXLllbôlÆ¼XxVLVK@Xn@xnVVVmb@LnVVKVXV@@mnaVXUVnVK@_UaUmwnKV_anKVL»K@¯ÝU@U@kWlUnlknKVnaUkma@UIUwl»Åw@VwV@nn@ÈXlKVmna@kVw@anm@n_WWk@mUkUK@ImkLUnbkm@wV@klUnLV±m@UInWkWmb@¯amX@xUVUKUaULWKXwKmLUVUJ_@wyWwkaW_XaWW¯L¯akam£@mUU@U@wnaWU@Uw@aUKUXUVKUkKWbk@@bUKUlWL¯LUJmLwU@UVaVU_VkmnUV¯@@xXmWUUUL¥makI@UKUkWlLkmÇ@aUk@UKL@kmÇak@_VlkL@`lbnlLVanLnbmVÆln@kJlbknmKUbÝmmwULUK@bkLWKULUUma@Kk@UV@L@llbVzxUxnl@bVLm@IVJXVlLV`@bn²@J@V@Xmbñ@WbUJ@bm@@LUĬU¦lV@xXb@blnUV"],encodeOffsets:[[116652,27608]]}},{type:"Feature",id:"3611",properties:{name:"上饶市",cp:[117.8613,28.7292],childNum:12},geometry:{type:"Polygon",coordinates:["@@@VI°`nm¤²@bVJUVVXUl@Vmb@xV@XbmVV@lkLmbn`VbnU@VaUnbVllUXVa@w°VW@_VWLnVlbLVbnlKnVK@IUW@_@am@ÑUólK@U@WU@VwU@UI@aUUaX@kwmJV@yX@kan@mkwVmmI@aUU@aUUW@kVkV@@anK»XVWnIVUl`@_W@wlUV@UWKnUbn°InJlUV@VnIbWn@VklL@l@Vn²m@U`kI@bWJnV@°VXnJmXVmx@VVL@bkLmWULUmU@bWXb@llnX@xkxVVnVV@¤nLnVxnJVXX@bn`VIb@blmlLnaV@blWXnlUnbl@KVanUVmm_XK@kWWnaU@UnaWUXaXamUkKmXUWLX¯WakKmnUWwXa@KW_aXWW_@WnIVl@XULnWVknK@ImyUUÆbXKÛ@W@IÆUnVÝlkVK@mUIVwkUVaUm@aVIVyXIaÈwmmk@UnanVUmÅaó»lwW@kkUVmUK@WKLUmWULkamKLk@Wa@wk@UU@U@mbUIWVKUXWmkUmVmU@LkakKw@w@U¯UUn¯l@bmn@xkJWxkL@VkI@mkmJUI@V@b@VVxnbWlkÈkVLbkKmVL@V@²nxWkLUL@xlKVxbXmVnWJ@Þ°@nxUKUw±`UImVmnU@kalm@akwU@UUJmxU@@U@kU@Um@@KnVm@kKmkU@@WUnkLWxkVUwmKmLkUbmKUbV@xUnkJ@n±UxVXUWJ@LUblUnm@W@nknUJUVm@kXllknVbÆKVVb¼V@Ul"],encodeOffsets:[[119194,29751]]}},{type:"Feature",id:"3604",properties:{name:"九江市",cp:[115.4224,29.3774],childNum:12},geometry:{type:"Polygon",coordinates:["@@WUkVUkmaVUb@mVUam_nalK@kUnUWaU@@wna@UVkUWVUUI@a±n£m¯_JU@ĉ¦Ul@UVKmmLlm@ğ¹m`Uk¯@@UVK¯@UUK@amkmKkVVUa@UkUKUaL@VVXUJ@n@WUbnVb¯V@LÅlÝIJÅkÝm@UaWUU@UmUXmmwVUUKWUX±mUam@kWzUaVmÇw@aÅLmKXUWKkL@W¯IwVwlkUJ@Um@ÛÈWKUxWkaUU@KkLVl@UKUX±KUb@nVVUbUVmaUlUL@aUL@@nUlWzX`@V@lx²@Vlb@bVÞ@°nl@UxVL@lUbVV@n²xVUVmnUÞbaJ@IV°xnbl@nbÆ@VwnK@VnXlK°xnUlVXV@Vl@L@lk@W_XK@KkWxUL@JnVx@aX@VVUaIXlmL@bVVX@VbnKa²XVWk°a@UnV¤nbmLmW@XbmJUbVLaÞKL@K@U@aVKlbV@nXlJxV@VnVÈÞKôbźĕČmV@Ċ²xÆIV@Þ¦ĸ¼ÞVlVÞnxln°JkLXWVUVUVwnJVI@yn@lXlaXmWI@w»ma@UmK@akKkXmW@_kaWakKWk@@K@IWkUa"],encodeOffsets:[[119487,30319]]}},{type:"Feature",id:"3610",properties:{name:"抚州市",cp:[116.4441,27.4933],childNum:11},geometry:{type:"Polygon",coordinates:["@@°V°UnÜ@n@lnLlV@bV°LlnLllVzVVXlVV@@L@xX@WlXm@UVL@V@n°kVmVUnKlaXxVbnlU@lVVnaVI@aX@VJ@V@bb@Vb@X@lUL@@VlIVm@wUVanLalVnKnLVxlUXwlKVm@k@Una@mWIXKWUÛVk@a@UVWn@@kl@@WXlW@_Um@UVK@aLnalInWV@@xnI@¥Km@kKmnk@mlI¤laXbVblknV@UKXVlUXa@@Unw@±mU@ak_±a@UJUIVKW_Xa@aWUK@mmUVa@IXa@UWmannlmX¯WKXwVUVw@XUlK@klJXa@kkmm@Uww@¯W¯kw@WmbULaUUU@mVUUWmkUbKmkkK@akU¯¥Ulm@akU@m@KVIVV@KUkUVUkaUWbmIkaVaUU@mWbb@bUlkbb@nK@bKXVWnULkKUV@LWKknlxXVLml@X@lULUb@xVxVLVlVnUxK@LWlXnmV@x¯XaWUUK@wVWUkÅçm`@mn@bUx@lmbUnkLÇWm@mU@Ux@Æxk¼VxVJ@nbVlmbUmLklmkVlX@VV@°Þ"],encodeOffsets:[[118508,28396]]}},{type:"Feature",id:"3609",properties:{name:"宜春市",cp:[115.0159,28.3228],childNum:10},geometry:{type:"Polygon",coordinates:["@@@VlbnK@b@JLlUnx±ĀXxÆWX@l@V@@blJ@nX@xUbVVUbVV@bVmnmJ@bmbm@klUbLmb@lVb@xUX@bVVVbV¤@LVVbXlVwLXÜÇn@@VIlVkUxx°J@XlKXLVWnLÆK@bÈxUnVbylXn@VbnW²XVLVVUnxWnnV@VVVXVbn@ÞÆlIÞJÆk@K°UUamVa@UUU»@wV@VkkUKUVW£U@UmW@@aXkVUnVlKVVUUkVmU@kWaUanUVVamIX¥W@@aUaUVW@_mW@UnIVVn@VbVm@bVL@anKVUkWKUXVIkx@nabVKb@nVJ_V@VwVUVVXUlUUaV@X@VblabnKlkVaXa¯@m@UKVUn@WXkW@@w@KU@UWkUUUykkmKk¯KU@akUmK@k@mmÛ¯V¯U@L¼UKmLbU`mLxVnVb@`LmUVUUWmb@nU@UWULmU@KnaUUmUwmJ¯IUJWIkVkaWVUIUlWaUIUVkKmbUIÒlVUnn@VlLUJ@bUX¯@aWVUKUXKUbm@UwKWa@a@VkUWn@Uak@mbXWJXbm@mLaWVk@wL@WmanU@knwWmkaWLKWUXaU@¥lUVVVbnw¥nKV»@aUk@a@UJ@kmLma@mbUWnm@ULÇº@LXnmxUm@UbkbW@@akLmWk@UXmJmUkV@VUXVlULmKUxkL@lmXnJ@Xl°Vnb@bU@WbKUX@VmKUX"],encodeOffsets:[[116652,28666]]}},{type:"Feature",id:"3601",properties:{name:"南昌市",cp:[116.0046,28.6633],childNum:6},geometry:{type:"Polygon",coordinates:["@@X@m@VIUW@UKVbLlV@VVbUlUnLnl@bVL@V°UL@V°@Vln_Ġºn@knKnLVU@VkĊ¥Vk@U»UaUÅLUalmkklWn@VUVIlm@mXn@VmkVa@KXIVUWVw²@m@U@VK@k@WUa@a@aU@IUW@@bUJmbUU@kkVmUaWwkbmLUVUnlWbUbklmLakbUaW@U@VbkVWVUUUVUx@U`UI@maULamb@lwJWUVXLlUVmL@bUK@aUnUam@UUmJ@VnX@`UXVVb@bX@W¦nJUbUmVVbXb@lVUnVlVUUkLmUUVWl@bX@VnV@X¤VUVLllUU@@x¼VV@V"],encodeOffsets:[[118249,29700]]}},{type:"Feature",id:"3602",properties:{name:"景德镇市",cp:[117.334,29.3225],childNum:3},geometry:{type:"Polygon",coordinates:["@@VVX@VbmzxUlU@mbmL@V²xVbUVVblbX@VkVykValKVI@bn@n`lVWnX@lL@WKnVIVa@¯nK@alIXJVIVWUwn@nUnK@alI@a@anKm_aW@UWmIUwmmK@£UUmUUlwwW@km@kWaXaV@VnVKnXlK@aUK@UnwWUnmIUW@¯mUXI@alJV_n@m±@U@kkKUlm@XamJ@UVUkmI¯JmamVXL@VUkV@xX@`k_UVmJUXW¼mL@bU@UllX@VV@bVV@bnJUnlx@nmb@lW@zUnIlx@WbVV@bVJV@UxV@@X@VkLVôÒn@@b@`VX@J"],encodeOffsets:[[119903,30409]]}},{type:"Feature",id:"3603",properties:{name:"萍乡市",cp:[113.9282,27.4823],childNum:4},geometry:{type:"Polygon",coordinates:["@@VWnL@UVWLXaV@@ama¯Uk@WmInW@klKVwnLVKUkVW@UlUnVnIVWl@nXlK@bX@laVan@VnwWm@KÈ¹VK¯m@kmU@¥kIğ@WKU¥@V_VW@_K@aXKVL@Ul»mWLkU@amkJm@kmU@@a@UmakwU@Xl@VXk`UIW¼kWWX@@lxV¦XlW@Ubn@mUkL@UmJ¯UkUWVUaUlm@UXWlnUJ@LmLUnXll@bUVUUmVUn@¦xlnn@VÆÈU°kbVVxllnL@VnVVUl@VanL"],encodeOffsets:[[116652,28666]]}},{type:"Feature",id:"3606",properties:{name:"鹰潭市",cp:[117.0813,28.2349],childNum:3},geometry:{type:"Polygon",coordinates:["@@@XV@nlL@lUnm@Ln@@VlV@@VV@nwVI@VVlx@bknlbV@nmnUVJ_²VxVLw@m¯@ÝXImnUWaUwkL@wVKlKXmw@±@UKnUlLaKlUlÇXkmaUw@U@a@UUkwUJ@zWJw@WbkVWUL@VmUklUaWakb£kJ@nmlnlL@nL@¦mJ@wU@mXkJmbK@bUL@VVn@`kXW@Xk@@lm@UX@V@blÜUXVWLXJ@nmb@V@l"],encodeOffsets:[[119599,29025]]}},{type:"Feature",id:"3605",properties:{name:"新余市",cp:[114.95,27.8174],childNum:2},geometry:{type:"Polygon",coordinates:["@@m@@WULUKWwÅ»ókakkWK@bUVUIUamWUbULa@KUa@mJUbmUXUmUamImakKmLUbVUam@@UL@KKmUUkL@`mIUb@U@V@bVl@b¼UmL¦mxUaUUVk@¦VWbXVLXKlbXnmx@lmVnb@XKxl@XUbnKn@WaXIWnal@Vb@XmlV@U@bXbLVxn@VaLVWVLXUb°@VW@aVIkK@UmVmkUÑVJnalLVUVJXbVkVJXUlblUXJVI°JnI"],encodeOffsets:[[118182,28542]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/41",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"4113",properties:{name:"南阳市",cp:[112.4011,33.0359],childNum:12},geometry:{type:"Polygon",coordinates:["@@lKl@nVV@bn@VVnmnLLXx@VLlKVUIXWÜ@Člbl@XUĊUlwnWLÞwm@ÞUVmnVl@nXJXLm@VnnJlaI@VkxVb@VlnJ@knKVn@°aVanal@XK°b@¯VJXIVK@al@nVk@nKab@XL@blVVKVLXK@VaVI°mVaX@V_@a@yUkVwVIVaJ°@anIlaV@nKnXÆm@wUUV±UUWUKnaWwXUWmÅ¯Vam@kakImUK»lan@VXXaW@@UlUUa@a@UlwUV@Xal@@anIVaUK@VXmwVmUmVLXl@nalLnal@nKlkV@@UnJUXnl@nVl¦V@@VnJ@nUVVVVIn@VaJÆn@@K@mka@kmWVaUI@a@k@@aUL@mmaVIUKUV@@IU@mUmmL@K@UUUU@mW@@nU@ğ»mVmbk@klW@UXnV@LJmlUnUJUUUW@UnkKxmLa@@@lUUbmUVWk@@nkUmam@UakJU_Vm@ÅlÇLUVmVUwULKU@k@UVUlU@@U@UaUUWaÅzJaWLklb@bmL@kKabWUV_@mV@b¯JmXUbUK¤ÇLUU@b@JkLWmkUWIkJ@VmX@JUbVXU`¯VV¯blK@LXKlUV@Um@@Uk@kxWkbL@KkbmL@UXmaU@@l@x@blX@xUJ@bULUlULÇ@@VnU`W@@nÛ¼U@@VmKUkm@VVX@@xÇ@bUbVb@VX@@xLUb@l¼XLlbUlVVUUb@n"],encodeOffsets:[[113671,34364]]}},{type:"Feature",id:"4115",properties:{name:"信阳市",cp:[114.8291,32.0197],childNum:9},geometry:{type:"Polygon",coordinates:["@@VllInJlknJVkVU@mXlUÞ`VnVVU@U@y@nXlKVnJVkXKWaXIb@yVkVUkVwn@K@nW@kKlUXVVUlbnUV`n@V_V@llX@@Vb@bV@@nlVUb¯WLnbmb@nLnKbUbVWnLlaX@VVUX@Vln@`kL@ll@VXVJÈIVl@XÞJ°UnaLlylU@UXKlnn@lanLWWnbVI@KXKVL@LVWVL@UVKUIVWX@@XÆJ@In`@lJVI@aWÛnK@UlK@UU@VKnlmnXalUllLUbVVknJ@nV@Vm@al@@xnVlJVUU@w@ak@XW@_mWnUlŁUmVKV@VXwW»XWaUwnkWUkVUU@@@WlaUkkaIWVkm¯xmIUmLUVaUIó»m@mmwXk@amk¯¯l@wmkLmmU@UbkUWJ@XUbJ@b@l@znÆmK@Xk@Ub@lm@I@akmVKUUVUkU@U±JUbk@IWmkxa@UUVUWVkIUaW@UlLWn@VkJI@VkK@L@bmKkJmUUaUKWXk¼VxnJ@V@@VULV¼@@UkaUlWL@U@W@IkKmL@KULUWULWKUXUJmIbK²UWnWKUUkLUmUUam@UU@mUL@xkV@VV@bmV@Vk@mwkUVUx@mbXÇnVbUL¯WnUVLVb@xnlWnU@UVUVVUbVVlVkn@llVUXUWUXVbUJ@bmLUJnb@nVK@bl@@@bVJUbnX@lb"],encodeOffsets:[[116551,33385]]}},{type:"Feature",id:"4103",properties:{name:"洛阳市",cp:[112.0605,34.3158],childNum:11},geometry:{type:"Polygon",coordinates:["@@VVUllLXl@LWn@J@bKUVmnL@`VblLnbV@b@JmL@LnV@VV@¯VJVnXL@nm@aÞ@ak@mImVbXLynLk°@°aVJnUV@UVVXk@WJ@VXLlUnJVnn°U@»°Uwl@bWmUXÆ@VLXU@m@Ua@Imkba@naWW@_@WXUV@@U²@K@I±U@¥kKWLóLla@£Um@kWKXU@mlLXUVKUU±J¯_@`UL¯Wmk@WakklUnVUVaU@KUU@mmK@_a@KX@VaUIm±kaVKVUkw@kaW@kbkL±UUaK@UUKVak£@UmmL@lIkmU@Ualw@UJkbmIUmn@WKImWk@mUUnÝV@nÝxKmXkxĉVWVk@kaċÛ@WXJUV@zmVWnbUbVbLlUnlUÒnWVVWnk@@Vm@kxm@Unl@Ll@@V@XnkJVV@nlVXxU@ln@a@VLnWĊ¦nx@lbVKXLl@ÞVLXJl@XXl`lIXVl@XlXUVKwV@lanxzUbVJ@VVX@b"],encodeOffsets:[[114683,35551]]}},{type:"Feature",id:"4117",properties:{name:"驻马店市",cp:[114.1589,32.9041],childNum:10},geometry:{type:"Polygon",coordinates:["@@n@b°UÆXnVlnLÜ@VLm@n@na@Jm@k@lVVxXX@V`lLVXVV@VVÞLVV°²@labnxV@@bLmlm_VWnIWUna@lLbnV°VL@KVLVUVaVLXK@mÆXna@wVma@Xw@KlL@a@Va@wUkaWnIVla@Kn@Vn@VUl@nKVnJ@LnK@aVkVUUW@VakUVanI²XW@UUU°KnUVLl@XaVK@aU@KUI@W@_lm@KkLUKV_U@»@UVJ@XV@@mVL@K@U@Kk@VwUUm@kmWL@VkVkzKmb¯VÝI@WUkÇJUIUWk@@klK@_km@UVWUUW@kbmKUXaVamLmK@namaXK°VakU@mU@@aa@UW@kkU@U`m@U_mVkaUVWUkVL@lmX@Lm@UxVlUUl@zaWJXbWLUlmIUkLmW@@z@VUVUUmÝ_kVW@nUVUlmIklmIkJUkl@n@Lm@ÅIUbm@UJUUVU@mmI@UU@k¥mUk@WmVmI@VU@klmLk@mbkKmb@WkKUVnUnnxW@UVLUbmJ@bk@WbU@Vkx@V@bVbkV@V@XWbUWm@kb¼VLnlJlb"],encodeOffsets:[[115920,33863]]}},{type:"Feature",id:"4116",properties:{name:"周口市",cp:[114.873,33.6951],childNum:10},geometry:{type:"Polygon",coordinates:["@@lnb@xlJ@UnLlKXUlJl_KnV@xVL@bkbVVUè@Wb@UbmkVmbXVJnUl@a°@@bLVblXxInmnLVwanJÆw²IlmnXVl°VVbÈaVb@lkn@VWnLlUVmÞUUklkVkUaVaVaUwK@kkaVWmw_l@nUVVb@baV@VV@zXJl@@kl@lk°WVnÆbnbUVJI@VKVm@kK@_kK@a@aU@@wW@@k@aUW@IUWVUnLlUlVXKVwmk@W@VWa¥@k@lnUIÇKUaU@UUVmIUVUk¥Vma@¯k@Wanwm@@n@@m@UIVkUVamUXWaVU_@mUVUImW@aUIĉK@VmIb@lU@@nJkU@KIUmmLk@UVm@Um@@LkbUmJXlbV@xUb@@bkK@LWx@bUn@xmbÅW@nWLUKUbUVKU@LUK¯mU@VV@xULUVL@bU`WUz¯aUamKUa@@xkX@x"],encodeOffsets:[[116832,34527]]}},{type:"Feature",id:"4114",properties:{name:"商丘市",cp:[115.741,34.2828],childNum:8},geometry:{type:"Polygon",coordinates:["@@XVl@lLÈ@VkV@V»UanWX@VaÆÇô@ÈaVX@xVJXUÞUaVLĸbXKlV@m°Vn_nyXX»mUk¥lK@a_@yInaVKVa°_@WXI@@KVnIlbnaV@l@a@_w@lwUKmXa@UV@»Vw@kUKVUUm@w±VUXUKUwmJUU@km@@±mXkmUI@mmKUwkbWakLWaUIkJmX@l@@VUX@JWbX@VbULWblUVULknlV@bVJkmb¯KknWmk@@nmVkx@VmU¯KUnUL@JUIVmaÅaUm¯Xlkk@@lk@WI@yUUU@b@aUaUmVk@`nxUXlb@lLVxUbUbVbUllkVlÝVUnkVmKUXm@kl@nUx@xnxn@`VX@V²x@V@b@Wl@zU`VUVVbL@VbW@bkXllkLWV@V@VVÈwlV@@XK²LlbWnnÆL@VnJWn"],encodeOffsets:[[118024,35680]]}},{type:"Feature",id:"4112",properties:{name:"三门峡市",cp:[110.8301,34.3158],childNum:6},geometry:{type:"Polygon",coordinates:["@@WKUmUI°U@@UmU@KnK@IaU@makKUa@_KnmVUL@a@IXm@KWkkKVkUU@aUW@UUIVaymwkbU@xLVUWWkk@WUkJk_WWk@WIUKÝk@WKULka@mwĉ¥mXUK@@bm@kVWwkU@mUUlIWm@@Uk@@KkVmn@lwn@@Ul@XmUXUmVÑkmkVKUaVamaUXn@ykLUK@WwKmKnUm@UmaU@mUk@kL@lxċxUnkVmnXxWb@`kzWJ@VLmVUnlmUL@lW@Ub@VXUb`VLUbUJ@nmnUlUUm@@bUJlnUU@lxkb@@XJUn@kb¯VVVmlXXlJlzn@VlkVW@bkKbmkUbVblXVxKÈnwÞlĊKlVnKlwX@lL@xlUnVn@l@lmX@ÆÈb°¼ÈwVJlx_°xalUÈxlUnbVxnL@lllbmn@nb@@VL@V@@VLJnIVVlKnV_"],encodeOffsets:[[114661,35911]]}},{type:"Feature",id:"4107",properties:{name:"新乡市",cp:[114.2029,35.3595],childNum:9},geometry:{type:"Polygon",coordinates:["@@XVlLK°bUblbUbl@nX@WXVVKVk@@mb@UbnW`kLLV@VVLnKlVXIlV@@a@l£nWlkVa@°bnUlLVlnabnUVUXKlU@@lk@aI°y@ôkUU@wmônkWakmlUkVmkUlmUUm@nkUKWanamULXW@UVnUln`lblL°KXV@ĠJ@L°JUVwanK@UUImmkK@¯±Um@IVmUmmÅnWaUK¯aUkw@W±kVxUVwnÅJUIWaÝJóIbm`ÝbÅImJUI¯¥¯@mU¯UJmnUVóUkl±V@zXlbWVXL@bmmº@@XmJUXU°llk@nWJk@U@¦U`m¯Wx"],encodeOffsets:[[116100,36349]]}},{type:"Feature",id:"4104",properties:{name:"平顶山市",cp:[112.9724,33.739],childNum:8},geometry:{type:"Polygon",coordinates:["@@l¤UbVL@VLVb²VlKlaX@lb@lxUVULbln²VJUbW@@Lb@`nL@nVV@LVUbUVmkVllXbl@Xn°VK@_°`²IVVV@VUVJnInaWK@U@KLÆ@nmlXXWVUUw@klKVa@knyVkVanIJXUl@XbVUl@@aa@mXkbnK@UlK@UUUVaXaWmkUm¥nWmXaWakl@VmÞbKVL@aVI@mUwVm@KÅméULKVaUk@kUK@UWXI@VlKXU@VVnInVV@VLlK@UUkKU_@WWUwU@kln@@Imb@@mnUKÛ@mKUkWVXxmbVLXVVU²VV@xÅnmWmLU@kbmJ@b¯IUbJUUxVl@z@bU`W@Ub¯nUJUb@WLUKULkU@aWK@abmL@lmUk@@bULWJUI°@¯aWLk@mbUb¯b"],encodeOffsets:[[114942,34527]]}},{type:"Feature",id:"4101",properties:{name:"郑州市",cp:[113.4668,34.6234],childNum:8},geometry:{type:"Polygon",coordinates:["@@@nWVUKÅ@WnVnIV@kÆwV@nn@lxÞlnôJzXJl@nalUČVll@²UlkôVVUnmI°VnV°@°¦VJnIÆJÞan_VmU@ama@kU¥kaUklw@UIV¥kVUI@mmUÅmUlwVU@amUJWbUakVVé¯Im`k@wVWmLkU¯XkWmLmx@UUbm@@xJ@LbW@UUVWUkVK@kaIUamKUkkmmLUkJUVWXkWmnÅ@KL@@VXLmbmJUIUVU@ULWVkK@nWVXL@lVn@¤bkôKXKlL@¦²V@JL±@@VU@WV@X@`XXmb@blan@Jb@V"],encodeOffsets:[[115617,35584]]}},{type:"Feature",id:"4105",properties:{name:"安阳市",cp:[114.5325,36.0022],childNum:6},geometry:{type:"Polygon",coordinates:["@@°kVaV¥kVmUkWkWVkVKUwkkmKUU@awWWXWakKWkXmlaIVmX¥U@a@WnK@kVI¯@KğI@WU¯LkKak_kmmVU@VWXKnVmbXbVLmln@VVknlVUnVlklnXbmlmlXblnÈlWbn@@nK@VLbVV°VVzln@VxIbU@WLUa¯VUkWõ@¯kkmxk¼lXUlVbVLnlULmU@lLkVUlX@xW@¯mU@UmIUWL@aXakU¯anWk°@kkKmmUIWaambUkkKmV¯a@UblkmXk¤@@b@UbULWVnb@lUVVnmnVVUJ@bWXX@WJkL@blVU°UV@XlWnXUbW@UVkVVWbnLUJWLUK@Lnn@blVUnUblxVUVJXUa@UbLnUVV@mVIVVn@UbV@XbmbUV_lVXUWanJVI@WkI@WVIVU°WXXl@la@mX@lLXlkVbmXylIXJV@@kKla²UVaIVyÞb°LlVna@UÆKnLVbK@anwU"],encodeOffsets:[[117676,36917]]}},{type:"Feature",id:"4102",properties:{name:"开封市",cp:[114.5764,34.6124],childNum:6},geometry:{type:"Polygon",coordinates:["@@lUVbXaInV@bUVxknVVÆnn@VJlUU¦VJ@kxVllb¦lV@nb@bVUnaôJÞIXbVJÆImxUVwU²l@XxVl°bVLXb`XklUnmVblL@lmx°LVK@UXIVaWlL@Uk°KkVaVUXmmI@UÅKmmXka±KL@W@kUÇxUU@@UXUlKkklW@aXa@UKUaVUUV_@yXk@@a@U±w@UUW@_mmw@wVwmUaÇbUa¯UUkmWkn±JÅxmIbUxmKmnJWwkUaK@a¯@bk@mVUIWLmwm@Ua@WJUb@LUl@UUmLUbWJ@VL@VmXWWzUJUê"],encodeOffsets:[[116641,35280]]}},{type:"Feature",id:"4108",properties:{name:"焦作市",cp:[112.8406,35.1508],childNum:8},geometry:{type:"Polygon",coordinates:["@@V@VL@x@bXWV@XklUWX@J@nI@KlLKUVaV@JlL@KUk@KÞLl²_@nWlLUVV@nLWVUJVn@anV@awÞUVLVxb@lW@lbXnVn@@¼L°mKVn@bnl@nVK@blbLWU@VWLXV@nlKn@lVVbXw°nV_@¥Vl@XI@mlkkV¯VWnI@W@n¹n@aWKXUaWk@yk@kċUkVmbk@WIyóImÝkkwm@mU@xÅlU@mJXak@x¯V@¼¯VmUmmIkVWK@UXIl@UWVUU@mVUI¯b¯@lmKzWKUanJ@nlbÝ@@b"],encodeOffsets:[[114728,35888]]}},{type:"Feature",id:"4110",properties:{name:"许昌市",cp:[113.6975,34.0466],childNum:6},geometry:{type:"Polygon",coordinates:["@@lIVnKlnVlnLVbJlb@ULVlUXVVX@a@KI@wn@aVV@nwnKlXW°lVnKUXx@ln_°JVIXyXnW@UK@UXIVanKVV@Vk@KVaXI@Vbn@nxKnaUlnVa@Xa@VçUUla@aUK@wmULk`kIWVkLmK@V@XUln@JXV@nmbUóImUa±@@ÑóVUUk@UlKVU@akWVUUlUUaUK@UUKWbUkÅJ@XWa@XbmJ@nUJ@bUKLÝaUnk@lXbWbXnmn¦lVXnWbUbVV@VkL@VmLaWl@nb@bk@UVWak@WVImJUbUlmz@lUbkL@lVx"],encodeOffsets:[[115797,35089]]}},{type:"Feature",id:"4109",properties:{name:"濮阳市",cp:[115.1917,35.799],childNum:6},geometry:{type:"Polygon",coordinates:["@@lLXbWXXx@bVVnLllVxULUlXXlVlUnlU¦Ub¯lnK@VbVb@XbVLKVxVVnIlaba¥lU@wnalLnVVlVLXnlWVXn@@lVI@WnU@mÅW¥aW_k@WwXy@km@wUm¦lUxVLV@UwJ°x@VX@Vb@`VX@VX@llIVbnJlIbVlJ@mÑ¯Lóa@KUakX@UK@wU@lWUUÝ¯ImW¯aLUKU@k»k@mwa@UnKWI@UU@akVWKk@a±bóUWKXUmkKUmLbUx@lmLX@@bVW¦UnJkbWnXl"],encodeOffsets:[[117642,36501]]}},{type:"Feature",id:"4111",properties:{name:"漯河市",cp:[113.8733,33.6951],childNum:3},geometry:{type:"Polygon",coordinates:["@@@LUnVxnIWa@Xb@WÆIVlXaVL@VVLVbkVVUVlX@bUVkLVl@VVôU@Ò²@VbnôJVan@mWU@ImVk@WkI@wmak@wlW@w@VbnLVb°bVyXV_@aUKVVK@wUU@aK@kmbXVmJUX`knnK@aU@mwakb±@¯UUÝKUUU@WU@VkLUKU@mUmJUU@WVkL@UWJX@VVL@lVlUbLVKnêÆ"],encodeOffsets:[[116348,34431]]}},{type:"Feature",id:"4106",properties:{name:"鹤壁市",cp:[114.3787,35.744],childNum:3},geometry:{type:"Polygon",coordinates:["@@ón@xVVól@¯zJ@bkl@@kVWLUVmVXbVJnnlLl¯@Xlm°bVlWb@bKVXnJ@VV°nX@@wWVklUK@knVVKmkUKUaVkWkl»nwl°lö@lXV°UVbXKV@aJw@UmkUy¯UUUaK@UL@mm@XaÇkkmWank"],encodeOffsets:[[117158,36338]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/21",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"2102",properties:{name:"大连市",cp:[122.2229,39.4409],childNum:5},geometry:{type:"Polygon",coordinates:["@@IÞmVk@wXWÜbnwlLnU@nLlbXW@awnbl@XLa@Ċ¥@LULnJ@xVnmV@VXXV@VJkn@VÜKXXôJlbxl@IVbnJVLUbnlnVwJVU@XUaUUlwn@°nVKnV°_VJwl@nwlVIXWlIVVnK@IWmkIVaVU@WÈUlmU@UWUalkXġŻ@kI»mmakUmĉUŁV»²ġVĕ@aUU؍IɃ`ȃ@kw@Umwĉ@WķÑIĉÇbÝLkymbIwÇmÛbmbU¯ÜõÈkÆVbŎxnXVÆnǪ¦b¤UxÝnĉÒmĊVÈ¤ÈbÆ¼ĀÆÆÞźbVVbX°²¤"],encodeOffsets:[[124786,41102]]}},{type:"Feature",id:"2113",properties:{name:"朝阳市",cp:[120.0696,41.4899],childNum:6},geometry:{type:"Polygon",coordinates:["@@na@UVI@mÑWkaV¥UI@wl@aÈbm@wVak@@K@k@a@UUmUUalmU@KÇUÅ±¯@±kUKVkUaaU@¥m@@¯k@WLUmkn@mmIkm@amU@wVmkU@Klk@UmaXIWWULaULVbmk@UUmUk±_Uym@mbkImaX¯WWxWKzU@WkJWwkV@Um@UbVVVVXb@VWX@W@Vkb@VnUK±aUUlwXÇWKknU@mmUkLUVVUUVUawbkKmwnIkJ@nmb`kmVkLWwUm@UUUK@UmaUa@UUaWK@mU¯Wkk¯VmUUxVXUVmL¯ymXkWUbmXUKVknWx¯JVnkLl@VVxnxlĀVL²WlXl@bÝVUn@bnlÜaXblIVl@@È¦@VmbXV@@xVVnUn@`°@VnXU@K@VV@VmbnVn@ln@bx°Ub@bLV`ÅnW@@lUnnWVU@Vbkl@Xl`XxVUblkX@°¦VUVVbUlkV@UbVbkLUxmJkX@bbxVKÆlXXbnnala@Uk@UVVklKVUXKVU°KVan@VUnLKVLWVaU_@mmUXa@mwXwVkVWXkk@k@klm@wXKl@U@KVUUUVaUV@alLxUx@b°°VnnVxlIXJmxLUVlV@bnX@VbaVx@XJ@bn@VVXÈl@llX@lUVô°°@ÞVbn@Vk@VW"],encodeOffsets:[[123919,43262]]}},{type:"Feature",id:"2106",properties:{name:"丹东市",cp:[124.541,40.4242],childNum:4},geometry:{type:"Polygon",coordinates:["@@lzXJU@²x@@V@bUVmKUn°n@lnVKnV@n@VlV°WbXn@VzJ@¦@bkbbUl@bkbJ¯zWULWbklVnb¦VJ@K°Ukl@@WbVn°@Vm²UnX`UÜLXmVXlKVbUVVnUbnX@VUL@lUbWx@²kl`n@Vlb@nUVWVLVU@aV@²bl@ÈmxWXVÈUJVl@laWnXKÈkÈ@Va°bÆm@XV°IVV°UnalVUn@UwVU@@VVJI@bl@XK@wWmXUUVbkJVXnJVI@mknwlKXL@`l@VI@UUaVKÞnaVm@aÇ£XWU@aÇUU@mbkKm£@WWL@@Kk@klUbWKUkUU¯UõÛmUUaVUU@WU_W@kVkJ_WKkV@bUL¯¯±mk¯ġğÑ@UmwKUaka@am¥ÝIUWmk@wmţLKʝbȗKWĢklVbX@VVknÇV@XUVUblJXn@J"],encodeOffsets:[[126372,40967]]}},{type:"Feature",id:"2112",properties:{name:"铁岭市",cp:[124.2773,42.7423],childNum:7},geometry:{type:"Polygon",coordinates:["@@XJm@¯mXUlnVbUJU@bV@UJWL@VXLmJVbkXlJXxVL@b@V@n@b@`Vbk@lxknV@VVV@bUL@bV@@bVK@VXLWLXJ@LV@nbWJ@IUVx@LVJUXVxVx@VV@@LXJWL@VU@@L@VnL@bVVmVX@@VVInJmbnLWVnVULVVU@VVmX@@JVzl@nVVKVXÞ@mk_lmUUWV_nJlUÞÑÞVVUVVLUVJ@IVna@@KV@XwWknwnKlalUwaĉÝwJl_@aUaKUUU@WU@WXUÆ@@UVK@n@UnVVblK@bllb@bbW@Xbl@UlnLl°°b¦nKlVnIV@UWU@WXkw@am@nm@aVw@I@KUaVIm±XÑlknJVnVJaX_VaUaVKmwnkmmn@lU@U@mnaXlKUmUIVmklaUK@UlUVUW@UkVma@UUU@JmUU@@bmbKWV¯XUKm@ka@UVKVk@aUKmLkKUUÝUmbXbÇJ@k@WU_@m@klm@UXKVaUI@KWUXaÇWkaWUkWUL±U@lUU@UJI@V¯JmIm@@aU@Uwa@UV@VkIV¯aUkWkb@bVL@@VVVUXW@Ua@@bÝbUVÝ@LmUkVUbVllLUV@LXWbUXm@U`@kxlnnJlbnIllLXlVlUXmVKnV@L"],encodeOffsets:[[126720,43572]]}},{type:"Feature",id:"2101",properties:{name:"沈阳市",cp:[123.1238,42.1216],childNum:5},geometry:{type:"Polygon",coordinates:["@@ȚĊÜ°bLlÞxUbUn±@ÈnVÆL@xnLlUVbxkImJkn@V±LUxkV@bbKVKnzVl@L°@VaxÞUlbôxVV@@V±bn@llXLöXĶnal@nkVJVI@aU@@aVK@aUUUU@lmkwl@Ua@_@a@m@U@aUKWwkIlWUanIWK@UXKVIU@@aVVIUamVknW°n@WI@KUmULWnkVkUWKkkmJkamIkmlw@V_n@VWXaW@KVUkKUkValUnVK@ÞVUÞa@a@VbX@VWUU@U@UK@ala@IkKmUUa@U@VkkWVwU_@KÜUXbl@V¥XUVmXakÅlUUkIm`UIUJW@UIKmkm@UUJImmU@VUXU`mIUbUK@LJUUl@X@UbJkU@nm@Uam@@aUmLKwmWXUK@kUaÇa@JUIUa@aKVUUXmUy_@lmbkLUKWLX`n@bVL@JXLWX@Vnb@Vm@UbnVmL@V@x@LUbVV@V@LUVl@mb¯U@xU@UVVV@X@VVblJ@bnVKUnx@llnL±¤b@k`VXÆK@kV@¼kl@bWIUl@VmLnbm@@JXXmb"],encodeOffsets:[[125359,43139]]}},{type:"Feature",id:"2104",properties:{name:"抚顺市",cp:[124.585,41.8579],childNum:4},geometry:{type:"Polygon",coordinates:["@@XVl°bUlJ@UVU@bVxV@@bn@nJ°I@UJIVV@V@k²VVKlXXVblÈXWbXV@LVJUbWL@Vkn@l@nV`@X@lÈIWanaÞVVVlLnKVL@bUlUL@Vlbn@VL°WXULna@aV@nV@IVV@VbUnl@VXnKVa@UUnyWkXaaVk@aabnm@_WKXmWanU@alaUl@XJVLVxX@wnKnVlw@V_@a¯¥@UkKWUaUUanK@IaU@WUaVw@klUVyUUVUUÇ@Iôba@mnUma@kXa@UWak@Wal@a@WULmU@U`mIUU`mUk@@UUK±nkJbUam@kwm@@a@UU@Ua@@K@VK@kmKU_UKUUaĉWmkkL@`LnmlkLkbmK@k@Ulmb@b@xUVIUlmVXXxm@JUUk@WUk@akx±@¯x¯UmbKUUVmUU¯UmVVnWkÆlWbUnWVU¦k@WaÛV@LV`UxXllU@@VVbnVlL@J"],encodeOffsets:[[126754,42992]]}},{type:"Feature",id:"2114",properties:{name:"葫芦岛市",cp:[120.1575,40.578],childNum:4},geometry:{type:"Polygon",coordinates:["@@ll°XnV@XLVb@VVbnb@VLVV@VVnXxlKnUl_na@mlImJnxlLaxVbUVVUVUKVlnnV@lmXLÈWkxVV²bVLm@Ula@UX@XW@UWaUUUUVan@V@lUXxlIXV@yXLwXXW°nblJnan@Vz`l²nVVVl@nUaVKbVKnXVaUaVUynXK@kVK@X@m@mLXaLWU¯w@a@UVw¥°ó¯¯y¯UÇ¯»w¯Im¯ÇUUl¯»ţKċÑţķm¯w@mU_ómk¼VnU`±IkbVlnnU¼±Lk`@XWl¦UbmVUxkXVlkbllUVb@bkVmx@XVV@Jb±aULkKWXkWmX¯aUJmIkVm@xU@n"],encodeOffsets:[[122097,41575]]}},{type:"Feature",id:"2109",properties:{name:"阜新市",cp:[122.0032,42.2699],childNum:4},geometry:{type:"Polygon",coordinates:["@@Xnb°lVlnXVJLlVnl@zÆxnK@bblKVLn@@VaVLVK@L@Vl@XVVInVVKVwlUXwlKLVVb@aV@XlUXbVW@nlWnXKV@@V@XUVVLUVV@@bVVV@@ln@VbVUXVIxVanJ@UIVWL@UV@@¤V@nInwWklnIVxlnzUVÇJ¦VVÜLĸUnW@aV_WĊXXaKnkl@nmLa@alUVw²K@UlmnIlJwaVUkmK@wÅKmU@Ç²VmVaÝwkKaÛ¯șĉķ¥ğ¥@kUWkƏīÝ@@akUK@KWIUm¯nU¯JmwUVmIkJÇLm@UImJUU@aW@U@@nUbJabXVWn@UVmX@V@b@l@L@lUb@xnÇabk@@xVJU¦lbXÒ@nUJ@Vmb"],encodeOffsets:[[123919,43262]]}},{type:"Feature",id:"2107",properties:{name:"锦州市",cp:[121.6626,41.4294],childNum:5},geometry:{type:"Polygon",coordinates:["@@nJ@nlmVnXKl@@°n@@¦VbVbUlVL²l°@Æ²ÈV@LVknVbVVnnWVU@XmWUabIVa@mV@X@@bVVnIVJ@nÈKlInJVUnx°IV°mVnXJ@LLlV@b@ÞƐĬXllV@Ġ¦ĸ¦naWW@In@manK@UVkXJ@alk@»lU@ÅLUWl_@a²£Kkm@kwVmULm@akIUa@U@WUUVUaÝ@ğwkmĉ£UW@@bÇL@ma@_mKlXUwKLţÓ@UWw@K@UI@mU@UV¥@°UnJ°@@_KUwW@UnaWUmmI@mķwUaÇLóVĵwÝUUW¯¦Ux@Vb@xV°XKWbK@n@nW@UL@lWLmzUVVbUbmWXXWJbn@Vkl@LlVUn@xnV@bln"],encodeOffsets:[[123694,42391]]}},{type:"Feature",id:"2103",properties:{name:"鞍山市",cp:[123.0798,40.6055],childNum:4},geometry:{type:"Polygon",coordinates:["@@lxĠÞ@bV@@w°Vna@UkV@K@UUUVa@K@w@UnKmUVan@@Uma@UXWWK@IUK@amW_XKVLlKna@kmKVak@VU@VmU@anIÆan@aUVnb@blLV`ÞLlUbnaKn@naVU@¥°IVK@anUUKVaUVak@mJkXUVwkVUUa°U@W@WlkXWlIXUlJlaxIVVXLll@nLV@lLXlKĊz¥maUlkXaVKX°yIla@aVkala@a@¥IUy@WmXa¯kU@U@mmUULkmm@¯VmnLVU@a@U@±w@VWIkymLUUkJWXJkUmxk@xUI¯`mUULm¯m@kxVVbWV@UVIUx@bkVVVxUbVV@V@zJVXUlnk@@lkLlLUU±Jkm@UIUVLUVU@K@UnnV@l@LlaUJ@zn`@nWlIUVUUUV±Ln@nmL@VUVkLVlUxVLVlÅXma@@akLmWUX@JUnVJVkXJ@X@`WXVUVUIlbW@bVUVL@`Un@¦U`@bUV@z@Jm@@XV`LUL¯J@IVKmKÅI@JnWVnLnVxV¤z@bmV@VUV@bUL"],encodeOffsets:[[125123,42447]]}},{type:"Feature",id:"2105",properties:{name:"本溪市",cp:[124.1455,41.1987],childNum:3},geometry:{type:"Polygon",coordinates:["@@lb@VnlnVVUb@VJ@nnJ@bmXUx@xVbkbkWLUxnl@Ul@xWx@nUV@¼UllknkK@bmbnlLVJX@VIVJn_lJVVXUmnU°VVVUnVVLna°V°w²@lwbl@XVl@VVIn@wWWnUVkJVUw@@anaVk@@lnLlalKnkmK@_lKnlĊXVbVVLV`nL@lUL@@L@VbV@@V@bn@lxn@VbalI²mVL@Vl@nV_VVnJV_@nVKV@X@bkXbl@XblylUUk@Xa@UVIlK@UUWVULlm@UUUnKWU@K@UXmXVa@U°KVUUWUk@aUVKkaWkKUknaWa@U@m@mk@aUJk@@_WKkLmxl@nUJmIUWlIUaVWVXn@xWLk@@aJUI@U@UVVxm@UVkmb¯VUU¯JWU@Ån¯aUbÇ@ÇlLmWXkbk@UIÇVUXWwÇnk@±aU@@bUVUKUXmV@kaUm@k_±l@XwVa@kVK@UWmVaUmVUUakLUWWnÛKVW_m±VnU¯@Uma@Xk@l¯V"],encodeOffsets:[[126552,41839]]}},{type:"Feature",id:"2108",properties:{name:"营口市",cp:[122.4316,40.4297],childNum:4},geometry:{type:"Polygon",coordinates:["@@ĊĖÆn¤°Ċ¯ŎWô@xXbwnKl@nX@VUVKmL@VU@UxÝ@VlbxU@VUb@bk`IUlVUnV@@UV@@JnXlK@b@nbÆWUkUKVwUklKVU@UnK@mm²KVUVVVUJXk@mm_@yVIbk@K@kmUm@VLV@VUKVUVJn@l²IVVKklK@kl@kmVUWI@y@UUUVawUUUl@akmmVaUKmIUaJk@wkaóIWWÛL@UlmUIU@WW@UnUUm@wmIVK@Kĉ¦@bWKk@max@bWXkamK@mVkKmxÛaWX@xUlÝnJ"],encodeOffsets:[[124786,41102]]}},{type:"Feature",id:"2110",properties:{name:"辽阳市",cp:[123.4094,41.1383],childNum:5},geometry:{type:"Polygon",coordinates:["@@`VzWnVUVL@bVbVJ@IÈbVb@lVLXWnxLnKVb@n@Vbn@mV@lIVa@@WkVVI@KVLVanJV_VWUV@nnJVIVn@na@alLlmkVk@»VU@mXwwk@@VmkVwXKllaUa@wVwnW@amI@mUI@VaUUkmm@UkaL@UIĉyLWkkKU@mKk@kWKUUJwkbkIWVkJWXkl@X@X¯VVbUVlUxVWlnI@lUbVUbVLmV@bUL¯J@¦UVmbm@LmbakVÝKU_kK@amaVUbm@ÅbmJ@bVUn@UVl@UbnL"],encodeOffsets:[[125562,42194]]}},{type:"Feature",id:"2111",properties:{name:"盘锦市",cp:[121.9482,41.0449],childNum:3},geometry:{type:"Polygon",coordinates:["@@Vbĸx@nnJVnXmb@VXVxL@`¯@mI¯V@U¦@VV@nJ@V@LXx@VŤÔKLVxWknL@`b@nÈK@a@VXĊ¤nVK@aVU@UnU@ayU£UwmmKXUm@IÆJnLUL@J°IVKKU_@Wn@@I@yVU@aV_@¥Vm@_UKUV@aXkaVJVUUXW@_@WWIUlUIVm@IVW@IU@@VU@mUVVkJ_l@aVa@UVwka@UÞVwV@@UnKLVU@UmWk@mLxWa@wóUVUIÇÆĉ¦¯¦¯xʟJ"],encodeOffsets:[[124392,41822]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/14",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"1409",properties:{name:"忻州市",cp:[112.4561,38.8971],childNum:14},geometry:{type:"Polygon",coordinates:["@@Vx@lnbn¦WlnnUm°²VVVVVnUnºlz@l@J@kXWVXl@La@KULlbnKlLnKLnKÆXn°bVV@bUVl°Un@LnaVJUbW@UX²l@ČwlVVIWnkÆa°anVKn°UW¯@aVUVk@Un@aV@ValwUanmWUk@WVUUanaVwnLVl°@nk@mVU@UVK@wLVKVU@K@UUKVUV@@bnLaVaôlIXmlKX_°KVV@bVV@zV`kblIVUlL@bnV@VĊllVlIXW@kaU²blKVnIlJalbXXlWVn°JnnL@l@XlJlaX@XW²@l_VmnKUblU@mnkVK¯@U@ma@kX¥VmakkLa@a@WIUUVXWWnk@a°a@kkm@kUUmJm@WUUUIk`m@VkaWWkXKmXk¯@WKLkak@±bw@aa@aka@ma¯@LKÇÅkKWbkmġ±ÅULUKVVkm¯LUVVbUwUW¯bmULxWJ@klmkUm@@KnwVkVK@akw@@a¯bKknVUIb¯mmbk@UbmKUL@xUU@klmLUlVXIVVVUVUU`mLXVWbXnW`Å²°xmxU@mĉwU@mbU@UmbkVW¦kJ@X@`¯Im@UlUVVnb@bWJXnmbJUUUUa@UamIkax@@x@b"],encodeOffsets:[[113614,39657]]}},{type:"Feature",id:"1411",properties:{name:"吕梁市",cp:[111.3574,37.7325],childNum:13},geometry:{type:"Polygon",coordinates:["@@@a@w@wlbnJVb@VbVVVInaWmXI@aaUmVUVkn@°J@_W@lIX¥lUnaVV@naV@xĊnV@wn¯wÆ±X_WmXaWUnKV_VVUUUUWJkUVnKlk¯@@kmKUaÅ±KkU@WmI@WUIlUUmVwXw@UlUVwV@LnbW@anU@UaVkô@l»n@naJnUÈLVaÆUUVmVKV²L@mU_lK@UVWkUa@a@U¯aUaÑóÑUbKk@@ak¯mVaUwVÑkWUmK@UUKmXUWÝwUaLUU@aWJUUU@UaÝU@WL@VKVaVI@WnU@alIVK@kImIkJ@m@@@_K@x@kaW@U@Vmn@UK@mIJUXV¤XXWlkKkkK@XmJVakImJU@ó¯LWKUV@nUVLkxmKkLma@kXKmmLabLmK@V@mXVÆUxX@`nLaV@@VmLUVnLlLb@°²nx@bVUxlb@V¯bUV@zVXVĊXVx@lVn@VnnmU@LlJXVz¯VWVXbV@bmnVUVkÇþÅ@XVxmbUlVUlnW@Xl@VLXÒ@bÞJ°¦Lò@nUb@°X@XbmVUVnb@xx"],encodeOffsets:[[113614,39657]]}},{type:"Feature",id:"1410",properties:{name:"临汾市",cp:[111.4783,36.1615],childNum:17},geometry:{type:"Polygon",coordinates:["@@nW@@UnLKabKnnWL@lnblKnLlwKVU@mVUXL°KôV@nIlJUbnI@WlLllLXkWWU£VWInJ@VL@nm@UVX@lb@@wL@`@n@V@lw@nVmVXWmwnUla@_lKwVlUn°xVKVXXWlUVVI@K@Kn°KwlVlU@kna@V_WnmUVm@kXml_@mLlKXw°m@_ôJVUV@Xl@UaV@Va°Ilk»VwUkVmwUmmVn@V¯@KUwmK@U¯wUVÝ@mJUnWK@@UnKVa_lykUmKÛnm@x@UUlwVkXW@a@U@@K@kIVnammVakUl@wX@@k¯@VVbml@°UbULmlVbnbÅK±VKVXUJWa@ULWaUU@@U@aWK@UkxUKLUUUJ±UkL@V±kk@kam@UV@l@LWl@n@VVUxLlUUx@VUVU@aIUlL@°mLUbkUUaWUUaUU@aWKLWJ@bUL@VUVVbU@m@a@kmKmnĉlUKXWUblbxmIkU@xWb@lkVxLXmzVV@bklVVUzm@bk@Vx@xlU@lUbVnl@Wxnl@n@UbVmLmb@`X@lUX@@xlnkLWaUJnnWVVn@l@bULVV@lV@XnJVX"],encodeOffsets:[[113063,37784]]}},{type:"Feature",id:"1407",properties:{name:"晋中市",cp:[112.7747,37.37],childNum:11},geometry:{type:"Polygon",coordinates:["@@@lInJlJ@ULkJ@bmV@XUJUbL@UXKV@ÞVbV@VVXI@bVVKVbÞxVXnWVL@VnLVlXÒUVxUb°nl@bl@LVaôÒÒVb°b@VnLnnV@lmn@lbUV@JUVVXkl@lUzmJ@xXklbUnJVUbnUlbV@nlLX@lakV`Ub°@XVJnUL²KlxnI@KV@lbUbVVKnVl@zlm@U@nI@WUaVl@@mVU@XkW@nkVKV_Vwy@knwVa@XalU@Vnml@X@VLKVaÞbnnlJImVKnVVVInVlU@m@mXK@UmyUI@mWUUakamw@wUwmLkakwVmKw@wUam£y@am_W@UU@knmmamU@WUa@knw@UUUUV@nJm@mVUkKVUUUkKmwKULKUImV@lUnnm@mbUK@°bUnmbUmkkWUb@am@UXkK@a±@V@ĉÅVUXVxUVkLWl¯@@bULUlm@@nm`XlWakIkmVUbUL@Vm@kI@@Km@VaXI@W@aU@kUVU_KbJkkÇb@nkKmLwÅW@kVUUVU@WUIJmIXmma@_kyVaUUlkUm@kUx¯Lm@L@LUJUkVWXUWUL¯wVmUkxkL@`bkmVnxXUWUnm@kxU@"],encodeOffsets:[[114087,37682]]}},{type:"Feature",id:"1408",properties:{name:"运城市",cp:[111.1487,35.2002],childNum:13},geometry:{type:"Polygon",coordinates:["@@VlnJwkaVaXWVLĊknmnLl@@bnV@UaVU@UVK@aXIKXL@bVVVbXVVblVaVnK@¯KVkJ@bVVU@UVwkVKVwUUm@@Xk@K@kVUn@lbl@²l@UlK²VVIVVKVLlw@VXL@b@VV@VXbVK@XbVIUWLU²ÆLmaUankVKVa¯@nkUaU°@n@@kWaUVaXUW@IXKVw@UWU@W@@UUU@mn@`m@UUULkUmJIU@@UK@U@anak_@wmKUwmakVkmKVk¯bw`kwUIÇx¯»ÇaÅmn@@mmUkV@wkKW@kxmLUkĉLÝkxÝw¯lóVUmV@ĀVVX¦W¤kz@`Vx°²ĸ@Ul@xêĸǊ°¤VVlXLWnXxmV@nUl@"],encodeOffsets:[[113232,36597]]}},{type:"Feature",id:"1402",properties:{name:"大同市",cp:[113.7854,39.8035],childNum:8},geometry:{type:"Polygon",coordinates:["@@²£yl@ČĖ@bĸĢbĸXaKŤnn@ŎôllÈxnVnÞÇV@bnXllL°KbVb@J@b@UxlKXLlKlXk@UlkJlkUVKXUÇVIVm@_nÇLalwVnU@UUwma@aaÝaLmUk@@W@U@@XwVWÝUUUk@@VmLKV»nwUwaUL@`mzJUIVUaUwKUaVIlJôanÑlLVUn@a@VV@@UUwVK°Vn_lJÆLéW@UUUÅ@»lm@aÞIVwXWUUkkm@U@aU@mwU£VWU_kWmXwW_°yUkkK@UÇK@kkUVymóKU@KWIbUak@mJ@bkbmLkUmkVUW¦@lnb@@V°ULml@nkVaVmLUnk`±@XWW@kbÇ¦X¯WxI@xmbmxXlWV@bÅUz@Jb@bÞbU@Wbk@xk@WX¯VÛWÝbÝUkVUU@alI@a@akLWam@U¯UUmÇL@K@aU@¯VUkKmX@`@kJ@nVUb@lbVÆXVWULU`VbkLUV@XWl@bXJ@VbV@Vl"],encodeOffsets:[[115335,41209]]}},{type:"Feature",id:"1404",properties:{name:"长治市",cp:[112.8625,36.4746],childNum:12},geometry:{type:"Polygon",coordinates:["@@UkLky@IJVa@mÞaWy@_W@_WXVlUVw@nw°K@mUVamVkU@mmmnLVUmKXaU@IlKVUnK@UmWkX@WV_V@akU@aKWIXyIUVmUnUa@WaXUVKVmkUWVkULU@@VbKbIUm@mbVLxWUUkn±V¯wbÅJUbmLkbmKÅKbVnUbVKUbKUbmLKmbaKkUm@UnnVnxUVlUxl¼k¯JUbU@Vbk@WU@UVóI@`¯nWxkLK@nk`Wn@lUnVnmXU`@mb@lkV@VnklVVUblz@`nbWnnJIVJ@XUVVUV@lÆXxnKlL@maÈllIaLV`UlVV@@b@XJWUb@n@L@lJn@@UVKVaUlnlJXbkWn_@mn@VkVK@a°@XklKVUUwVWUĊÆ@U²@@blLVWn@@bVaXllVnnaVma@¯VLnan@mVm@knUVJ"],encodeOffsets:[[116269,37637]]}},{type:"Feature",id:"1406",properties:{name:"朔州市",cp:[113.0713,39.6991],childNum:5},geometry:{type:"Polygon",coordinates:["@@XXWVXVWnnlnn@èÆ¼@xlVnblVÈUVl@blnLÜĊmUkU@Ua@WI@aXk@WVUlKUaV_VKXWUUÅka@VaU@mlI@@_nWLVl°UV@@b@LÈKVn°V@VnXblK@b@bkJ@bVVlUÞVÞaXÜ°UXWl@wl@XaV@Ýa@aa@IVyÆ@aXUWknwna@wJXw°WÈ¥kI@W@kmKm¯IUmkXWWkabkImJUkL±aVb@lWXkJUkĉk@UmU@aKkVUkJlaU_y@UU@aUU¯LW`kLWnkJóbUbmK@aU@UVVL@VL@UVULK@xUL@VUV@nml¯@UkmKUxmbVbUV@XlXVmnVbkxUbU@bm@@VUlUVb°@VX¯m"],encodeOffsets:[[114615,40562]]}},{type:"Feature",id:"1405",properties:{name:"晋城市",cp:[112.7856,35.6342],childNum:6},geometry:{type:"Polygon",coordinates:["@@lVLbanLnKVaLVaLUVaUmaÆLnLlanKVaÆIa°x²UlmVVXwUKna@VnJaLa@UV@@alUkKVKnkmmVwUkw@@kxWUXW@@mk@aUa@a¯aLkKmwkUm@kL@K@aWIXmVXWkUVakL@UVKw@aUK@UUKmLU@¯nKUwVUIWJUWmka@UXJk@UkmW@kLWKVx@bmI@VUaVU@a¯@UUmVKmX@±`kÝKVxUL±akL@VbLkKmV@XWVUbVXb@lm@@lW@@xklVUbnnmbUlJ@@L@@Vb@WXUlkxVV@wn@ÜmnLlVkz`UbmL@V@XLmVnIÞ@VU°x@VnLxV@LU°"],encodeOffsets:[[115223,36895]]}},{type:"Feature",id:"1401",properties:{name:"太原市",cp:[112.3352,37.9413],childNum:5},geometry:{type:"Polygon",coordinates:["@@@VV@wVKnLVal@na°naVJUlmL°a@b@lx@bULUlmx@Ln@lVknl@XIwKVn°aVXVxUaVU°KnUlUVLKÆV²ĢlnXalLÈÆLKUaVkUanmWUa@WwkUWU¯y¯Ñ@anIl@@aVUmIymULUUVakaU@@LmJkw±LKmVUI@W¯VaU_lkbW@kK@mUkaVmVaUIVmalkW@wnIVy@klkWUUVI@UVkam@knU@mmmK@bblVUX@VkLV`@n±KUULUnVVÅUbÇKmVImbm@k¼ó@Ulb@VmV@bXmaK@UUxkVV@xWUxVnkVVJ@XnJ@XlV²LÆVbnL@l@°"],encodeOffsets:[[114503,39134]]}},{type:"Feature",id:"1403",properties:{name:"阳泉市",cp:[113.4778,38.0951],childNum:3},geometry:{type:"Polygon",coordinates:["@@°@nb@lb@bbb@x²al@lbKXU@mkUWkkmUUVwV@XUW@naVklKXblKnLnLVanImaXKlLaV@U@KUKWalXK@£WKXUV@VUUUVW_V@W@@K@UIWmXUmULnJkImmÝaUbLK@UWk@mnU@kVWb@Ubmx@lzUx`UULml@XWl@UV@nk@UVb@XJm@@Vknyk@zJnUV@bk@mJ@b°Ò°zXVlVXx@bXVmnVbUlVb"],encodeOffsets:[[115864,39336]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/34",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3415",properties:{name:"六安市",cp:[116.3123,31.8329],childNum:6},geometry:{type:"Polygon",coordinates:["@@nJUXUV°UÑnU@mlLVaVln@@bn@VU@xlb@lLnKlVIJUVxnI@lVL@b°VX@bxnVVUnVVnU@kX@VwV@al¥UUnUWa@@wĸULU¥lKUa@aUI@alLVaU¯anWkUKm@XV@VaXlW@aU_UWVUI¯@ma¯W¯I@UU@WWU@U@@UU@VkV@@WUUm@UaU@lK@IUKL@KWmXUWaXI@@a@a@U@U@KV¥lwk°b²JVIVKlV@UXlaUl`UVLVVVUJU@Lnm@_VK@KUIW@J@Xk@WW@UmmXmWk@kK@aUUVmmkUwUmWL@WmU@UJmUULkKWakLWVkIlwULW@X°lUJ@°ULWVwmJ@bmb¯Vkm@@WkWm¯wL@lkXWmXym¯UImJUbkV@Vn¯@V@lUb@mk@maUxmlUbULWn@JLmKUkWKkwUKbmXWxkVUKmLkVV@JUUWL@xkJUUV@X@VVlUbVX@xk¤x¼xWxnnn@Þ¼JVb°aVn@mlnXUJlbVlkz@lUlXJmxVxXnWxXÈWlU@UxU@VX@xUL@UÆmLnV@lWXk@@JlbXblnlJ"],encodeOffsets:[[118710,33351]]}},{type:"Feature",id:"3408",properties:{name:"安庆市",cp:[116.7517,30.5255],childNum:9},geometry:{type:"Polygon",coordinates:["@@n°znWXlW@kK°xXnl@Xn@l°Una@anIxXUVK@¯VIkW¯X@VKxklJXUlKXblLVKnVVIV@Xn@XKVnVxlnnUlmV@²óUkVlWbln@VVVIn@lw@WVIXblV@ÈxaUaVIVVnKVLKln@b²K@»U£ÑķġÝÅbKa@Im@Û@kWÓkkmKÅnóJUÅ£W@wĕ@wĉţ¯¯UkK±l¯U¥UÑkÝUķ»Ý¥¯JIUVbUl¯ÈV¼VJU¼Vb@bkLUl@VJ@bUXÇ@lkVmXmKkLVxVL@VkVVVlzWkbmLUUUbVbUVlÒnJlUnLllUL@bUVxlLXVÆ¦ÈVU¦WJ"],encodeOffsets:[[118834,31759]]}},{type:"Feature",id:"3411",properties:{name:"滁州市",cp:[118.1909,32.536],childNum:7},geometry:{type:"Polygon",coordinates:["@@@`nnl@xK@X°KXVIXVlbXVWnXlL@È»LVan@VJêVVn@X@laÞbVayn@_xnWVXnWl@VnUVkI@lnXKVLVV@V@kW@LlVô@J@bVnnKnkVa@»lç@nwKmaUUUVÑ@nmWXalI@alVn@VwUaVU@nlaôJnUVVXlJaXXVK@UV@VWx@nXVWXVUlLUbVULVVnUVbUbVb@@aKÆnnKVK@U@UU@@a@V°¯ÈJVIlķ@aaUaVKU_@mkxUI@aUlyU@@wkKWmUbUnUVWbkJW_J@bn@Vm@@KULk@V@@bVbÅm@LW@UVVbkK@UkKWL@VULUKWIUJUbkK@_WVXUJka@XVa@ky@aVIUUW@@mUlLKWÑUKVan@UkVmmIXKaVaUwVU@UmykU¯@±UUL@WUIVUU@KkIWaaU@kUUaÇUó»mKk¯@y@kWK@bkI¯`mnl¯XWlkVUzUJlbUbVJl@nnm@VULV`XnWÆbmUUnJmUknJ¯km@yk@kUxL@VUbmnn¤lX@`z@JmaULUVl@Xn@xllkXWaaW@UVmUb@mVXWxXbWbUÒnVVnVVUL"],encodeOffsets:[[120004,33520]]}},{type:"Feature",id:"3418",properties:{name:"宣城市",cp:[118.8062,30.6244],childNum:7},geometry:{type:"Polygon",coordinates:["@@Vb@XLJXxlIXxlVlV@I²¤nlUnVU@VULWVUJ@Lnb@lV@UnV@@VVVlLnbnJUVkUUVWn@@anUVnVJVIV@@nUJVbUb@VUbVK@bn@VbnIlxkllXVlXKWUXUlL°¤UVVb@bUlkXWxXz@IlaUlnUlJVInVÆJULVUnVK°@VnlVnxV@XLlK@wVL@KnUlJXUbnKVLXlUw@VWlLXKm@@a@VLnmlIVVnKn@kVaVlwk@@a@k@VIUa@maUa@wna@kmWUUmVUIVÇ@aKmakUJ@InmUUaVaklX@Vk@m@VU@wnK@alKVUkUkKbmUkm@U£WVk@@UÝbbaÇx@b@WVUa¯@wVwUUV@VwnK@KWaÅ@KIUyUI@WmXóUbWaKm@km@IUyIUaWKx@zUKUL@llVUnkLVVkJWX@VUKUVIkVWakb@VWb@n@JkXUlmL@xkL@`VxLUÈUJ@Vm@@bmIUlUL@VUVVbknm@mKUwKVÈ@J@LV±kkJUIl"],encodeOffsets:[[120803,31247]]}},{type:"Feature",id:"3412",properties:{name:"阜阳市",cp:[115.7629,32.9919],childNum:6},geometry:{type:"Polygon",coordinates:["@@Vn@ak°a±@¥@UUI@aUmlwUUxb@¥XU@mmI@a@Kn@@_W@@WI@mUVVXUl@XaV@K@I@aLX@aVI°K@KVLUUwyXkK@kKÆbXnlK@k@aJlU@w@U@»@aXKWn_JXkVKn@°LlKXW@¯U@aUK@kmJUwVIUJkmLK@kka@wUVm@@am@UkUbkK@nmVÒ¯VUWVVmIULk@ma@kkK@nUbUamU`UUVUkKVkkW@@bkmnmUXVKXVL@VbUmbVXJ@nmKÅI@KWKUXVJUL@VUKUX@KUKWL@LUJmaXXm@kVVV@L@VUL@VlK@L@V@LUK@VUb@UUU@°@nVxU`Lkn@`@XVJ@XVmk@UKmV¯LVVn±Wm@Ub@JlLUl@VLk@lmVVn@bnV@V°IVaVJXI°K°V@XXVlVVUnKVlUbWXnV@bV`U@@m@@@nxmn@bXVlL@¤nbUl¦VVUnJVUVl@@bÞL"],encodeOffsets:[[118418,34392]]}},{type:"Feature",id:"3413",properties:{name:"宿州市",cp:[117.5208,33.6841],childNum:5},geometry:{type:"Polygon",coordinates:["@@@UWU@bkW@aWU@aUIkWVlLXblVIUVV@mn@V_n@VaUK@I@UaanJVU@lVUVnnKVVlaUaI@wnKLnll@nVlk@wVKXkl@@bbUJ@VU@UUUyVk@aVUXwlWXXWU¹@aU@WUI@mlUnJ@Il@aXbV@VKl@XxVL@WIJlb@al@IUUm@@aVK@¥¯@mUķ¯bWk£Vm@akm@VaÅ@UVWa@UJWkJUbWbU@UlXk@amV@K¯nk@lU@Uxmz@bU`ÇbUbÅVm£U@Wwx@akLUK@UlakwUJWVkLmaUal@n_mVUnKVUUmÅXWa@kJmx@XUJ@bVLXxl@VVUVVUbkLWbU@@lUVVVVXK@XkJ@nU@@bV@VxUVlbU@xXLWn@UxVbVĊV@b@XV`mnkJ@kUKmbaU@VbnbÆx@XU@@`k@@bl@@bkL@WakXWaU@Vmkx@XWW@@wUUUbJU¯V@¯ÞU@WxXlL@bkb@lVlnbJW@kkU@mbkaWJIVlmz¯`UnU@mb@@`@bkVlnV@b@V@aVxn@VxKXnl@nbVKbVK@a_V@Vw@WLlwnK@UmIU@VW@UÈ@lKnalw@@V°@aUmlUUw@V@@UXK"],encodeOffsets:[[119836,35061]]}},{type:"Feature",id:"3410",properties:{name:"黄山市",cp:[118.0481,29.9542],childNum:5},geometry:{type:"Polygon",coordinates:["@@lXnlWX@VUJVnUJVzXJVxkVJlI²lU@K@IUÇLVxnLn@lmUaVU@UVKVknJ@an@@UVIVÇKUw@_lK@wnKVklW@I@mXa@UlaXblUJVUVL@UXWlIUUlKVmkU@kVKVL@ywXLVbJVz@Jln@nLXbVaônW@la@UVWUa@@a@mk@WIk@VwUa¯¥m@UUVK@ImK@aX£kKÅVa_@±akXWWLnU@@a@¯mK@LJUWwUVVmbXX@lWLn`mzUJUbLk@makVWmkXambkKkna@ab@U@Unm@WV@VbUbUJWIk@@lmL@°UVUVmn@@kmWkb@x_m@@aU@b@JlUzlWxXn@b²@l`IVlUlL@VKnVbUl@VlIn@@bbVWUk@@bX@Valb@bnb°Vn@xVKlbVnV@VxL@ln@UXVVL"],encodeOffsets:[[120747,31095]]}},{type:"Feature",id:"3414",properties:{name:"巢湖市",cp:[117.7734,31.4978],childNum:5},geometry:{type:"Polygon",coordinates:["@@VV@blL@XlWnnn@VXXl@@WIX@VJ@LxŎxln@bXJVblX@VVbUVn@VbUVlb@LnJVbVLVXLÒVLÒVbVIVylUXk°Wknm°_lJ@aXL@lz°@lnLô¼VÈVUUaVKU@WW@@UUa@knmVLlaV@a@kak±@UmwkKmkǉÝUUkL@mlIVmnÝWkkUÝ@KƑĉa@»mma@mX¤¯Uw@@UU@bU±±L@akmLUKmLUUUJVbbÇw@kUWaUJ@Xkxm@UJUUm@kakXUVl±ôU@kn"],encodeOffsets:[[119847,32007]]}},{type:"Feature",id:"3416",properties:{name:"亳州市",cp:[116.1914,33.4698],childNum:4},geometry:{type:"Polygon",coordinates:["@@lU@Un@@anUlw@KVmUwlaX_lKna@KU@@kWKUU@ankWXK@@V²VVIÈU@al@VaÈamK@wU@klaUV@XVUU»WUUbkmUkVmk@aÈw@mWU@VkIkVWKUÑķXȭºU¯l@kkLWmÅaL@lLWlzVxVUK@L¯LUJ@bWK@b@JLU@Wbk@WVUUV@nJ@XX@@`m@@L@bnJ@nWV@¦awVVkxVn@bVJ@V¦@²¯blb@mUU@¼¦XbUV`@nnxUxWLkUkVWKkV@XV@@VVL@VX@lVV@L@blL@`L@xXKVL@VnU@lwnU@ml@XnV@@UVW°LnalUI@aUK@aa@UkXW@I@mWL@UXK@UVW@U@@kWn@@V@XblaVxL@bVKXbIlJ"],encodeOffsets:[[119183,34594]]}},{type:"Feature",id:"3417",properties:{name:"池州市",cp:[117.3889,30.2014],childNum:4},geometry:{type:"Polygon",coordinates:["@@V°°ĊŤ@xĖ@xXÆ¤VôIÆmnLllXÔ@lÜn@@JbLÆaĢÞĸ°VVUUKVanK@UV@VLVVnln@xnklxXamk@WV@Xa@naVkKlk@mkUWwkJWwIWK@UaUwWIUyVIUmVI@UXWmkkWKUUVWm@@kKw@UUUmkaULwm@¯Uma@akaUbW@@a@VlUXa@am@kJ@UVkUamL@UkKVUkJk_±@a@WmXwÇkkaVaUa±wV@VkwnyUaW@UU¯amLk@m@kmmU¯K@L@lUX¯WlkXVbbVUL@J@LVKnlJXnlb@`nXlalV@bnL@Vnb¼@lXbWlkLK@zUJmIUxUVUVmX","@@llUL@VlxL@a@UwXa¯@"],encodeOffsets:[[119543,30781],[120061,31152]]}},{type:"Feature",id:"3401",properties:{name:"合肥市",cp:[117.29,32.0581],childNum:4},geometry:{type:"Polygon",coordinates:["@@LxVĊLÞkVlVVXaWaXwWnU@anVVUX@bXblWkk@wWmk@VUVKnb@Iy@_kWm£nmVa@UKwlVl@zn@°lIlmnVIVmnVaXÅWmU_VK@Unmmk@UIVakaaUÑUKÑWKUUKUamI@KkaVUUam@VUUa@UkWUaWI@akmōwwUL@`mn@KVIUVUUUKVk_VkbW@VkUULUJ±I¯alkxU¦@L@V@V@b@b@WJXbWVXn@LKVL@JkLV@Vbn@VV@XU@UlV@@VV@V@XXV@@VJ°°Xnb°@JUVVXV`@bkXWUbU@Wn@VLXlm°bVUbkK@bVJ@bVbkLV¦KķV@x@XbmVVVk¦"],encodeOffsets:[[119678,33323]]}},{type:"Feature",id:"3403",properties:{name:"蚌埠市",cp:[117.4109,33.1073],childNum:4},geometry:{type:"Polygon",coordinates:["@@VÒXLlUlJ@UXV@nÇx@bnlUVllnVaXVV¼UVWU@V²wVV@Vl@VnwlI@XbÆWVnUVmLUVnm`k@VbnblKXUVIlxkb@VVLlK@bwXxV@n¤ÆUVaÈaV_@anyVwV@kl@°m@LnUbl@WVkV@XaaVIXlIV@XbVUÆ@XKWwUkmW@_UmnIlJXkWKXmV@w@_XV@Kl@kU@KlX@@UUUUKWLm@klJVUUmk@mXUWmXw`m@zUbÝakbW@m@UUéUIm@UbKÇ¼@kKWXmWUkaWUJWU¯L@WLwk@mm@_ÅlUVkmWUnV@VWLUbbƑĬ¯l"],encodeOffsets:[[119543,33722]]}},{type:"Feature",id:"3402",properties:{name:"芜湖市",cp:[118.3557,31.0858],childNum:4},geometry:{type:"Polygon",coordinates:["@@bVaV@XllLXU°lL@V@VUnVl¯IkVUVU@@b@lUXUWmbn@¼bƒĊLÞ@lVXlmÞUnkJ@nlKVVÞXklWVaVI@aUKn»lL@Kn@XXwlm@mn°@V@WywXlWVk@aUaVU¯£kKWVXVWLUkkWlkkwmJUam@@aULVa@UVaUaVI@m@UUJUIUmmV@bm@UXVVUlVmImakKUU@UU@VmU@@kma@KVIXUVK@UVmUkVm±£@JkU@nlkLUlmb@WbU@@XnlWb"],encodeOffsets:[[120814,31585]]}},{type:"Feature",id:"3406",properties:{name:"淮北市",cp:[116.6968,33.6896],childNum:3},geometry:{type:"MultiPolygon",coordinates:[["@@lnnK@¦n@@VV@@VV@nIVV@VW²a@b@bVnUVVV@Vz@l@°UVIVaVV@x@XX@WlwUnV@XblWb@XlK@a@k@al@@_V@@WÅwmaUaV@bnaVL@llInmU_@W@aUUĉUaVwm@XWK@wVkaVUUwU@@aV@@mlI@WLWUUUVU@kV@XalKVaUVUUUk@WwUK@aVI@WUk@@UUU±xkb@lV@xnLÇbUbk@@bÇVUJ±U@U@WLXml@bVVXL@lV@@LmbkLW`kbVxUn@LkxmV@bm@@VkV"],["@@VVVkV@¥@UV@U@VUUJkWakKUlXVJ@bXV@blX@aXV@V"]],encodeOffsets:[[[119183,34594]],[[119836,35061]]]}},{type:"Feature",id:"3404",properties:{name:"淮南市",cp:[116.7847,32.7722],childNum:2},geometry:{type:"Polygon",coordinates:["@@°kƒīaVaXK@UUVmnXUlVÆkVKUUUmmUÑkUUÝlĉKUwKbU@UxW@@lmVUUVmUUmwaWkL¯K@mULWlIm`XWL@b@¼@V@xkVI@b@l@lkV°Ȯ¹ĸW"],encodeOffsets:[[119543,33722]]}},{type:"Feature",id:"3405",properties:{name:"马鞍山市",cp:[118.6304,31.5363],childNum:2},geometry:{type:"Polygon",coordinates:["@@ǊnllLnxV@laXLVKmaaXbVIbVKVVVIVyn@n_W@@UnJlUVVXlLnaUWlV@VVIXW@_W@XK@K@UVUUwVamÑXmmwwKUnUKçU@JU¯@m@nknWxWm@@LkKm¼VL@bUJUbkXWl"],encodeOffsets:[[121219,32288]]}},{type:"Feature",id:"3407",properties:{name:"铜陵市",cp:[117.9382,30.9375],childNum:3},geometry:{type:"MultiPolygon",coordinates:[["@@ÒV¤@¼V²@aVV@@x°V£nW@nbnaVXVW@k@aV@VUUl°JUkVm@U@UkK¯WVkKWkU@Ubakwmlwm@kUmUUKU@@VmLUbVLUV¯U"],["@@LllUL@VlxL@a@UwXamK"]],encodeOffsets:[[[120522,31529]],[[120094,31146]]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/35",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3507",properties:{name:"南平市",cp:[118.136,27.2845],childNum:10},geometry:{type:"Polygon",coordinates:["@@@knyk@KU¥wV@nkWzUmk@@lKUa@aVI@UKUamKUUVaUI@X@UV@K±IUVVlUbUbUL@KWUXmWk@KkXmmkÅKUa@amUbkUkKWUnwUÇwVUUÝUKV£U@nKWwXLVKm¥@wUXkmWk@@wX@lU@yVImaXwV@knU@mbk@mlUXmU@mV@n@bnW@bUIWJImVUKWbUK@nkKaU@W_VUUmWmL@UU@bUWUL@V@bmVUz@`mUUVVbXL@VL@lmLUxmVamXkW@xWbUVbUxkU±@ÅUmmkLUbW@@`kLknVlV@lbXxlVUXVVUU@UbWkIWVUUUJkI@llbUxVL@VVUU°ULUmWXUV@VULWb@xm@UaVLVKUa@w@VbkmVambUUm@@VkK@@bxlxX@n¤@X@@lkLWV@nVkb@bWJXLWx@nkxmmbXn@VWVUn@VnJ@bVXl@VJXnWbX`lLUlJVI@@VXV@Vl@bn@@Æmn@VxXU@mVIlxVnIl@nVJaXI@mlU@aXkVm°klmnVV_na°@V@xÜ¦XKVnnUlVXbVKLXKV@naV@@VVl@@lXblXWnLlbVK²n@@VLUnlV@lXxô°V@UnaUUlKXLVUVVUbVVlUnJVX@VW@an@lb@nl@VU@anUVW@kaUm@InVVKVU@kUW@Uam@km@kVa@a@nwU@WlI@mVI@WXaW_n@nlkkW@U¥@kV@Uw@wU@@IXK¥VIn@nU@`@Xl@VVLnaWbVaUwnU@VIKlV"],encodeOffsets:[[122119,28086]]}},{type:"Feature",id:"3504",properties:{name:"三明市",cp:[117.5317,26.3013],childNum:11},geometry:{type:"Polygon",coordinates:["@@lL@Un@VVnabnUla@Ux@VbULUKVbn@w@XaVK@UVUXWVnVKV¯VU@UUKVwka@klJVIVVXUlJXVaV@VUUVWkUWwkaU@UklmlK@_X@ValKnnÆV²@lVVwUaVXa@wlXnWbnUVwnK@kK@UWKUaVUnV@_VynU@a@UVKVXaV@@VnKnXVVUX`V@blL@mVLXaVLnUJXIVJ@amX@a@mnUV@nVWnkl@naV@ml@@KmKUam@UU@@UlKUVkUK@aVaUwVU¥UIkJ@wmI@mbkwkVW@UXKULU`IVKUa@LkkVmUU@WlULUWÅU@I@WWnU@@w@a@Uam_XyVIVWkk@mwVKXUV@nwVXkWÅU@aU¯KUnK@¯mULXVLnWVbVbUVm@Ub¯¼W@am`kbamLUUUaUXV`@x@XmJ@n@L@xkJUU@kU@mWm@kUUwUUVWl@VUkIy@kkaVUUmIWVXbWxU@kmVkK@nWVX¦WxU@@bkx@VU@Wk@kUbmJUUmkUW@_kKWK@knV¤kIUKWLUbV@Wbk@@VWL@VkI@lUXVxUVU@@mWIV@a¯nUaaUV@Jb@bÞ°VbU@XaUVmL@VXblnV°n@Vnx@VUUUlK@InJVb@Vlnn@VL@VWJUx@XlJUVVVl@LUUUJ@L@lUL°¦kVVnV@xVl@blLnlLVaXll@nVUn@xn@nml°X@lb"],encodeOffsets:[[119858,27754]]}},{type:"Feature",id:"3508",properties:{name:"龙岩市",cp:[116.8066,25.2026],childNum:7},geometry:{type:"Polygon",coordinates:["@@aI@VUbVb°m@bUXJ@nV@VUUwVW@klJ@UXK@Ul@Xa@UVaXKVLlJU£lm@XLlL@`VXnlVVnIVall@XV@@Ulw@aV@XwW¥XU@mlLnUlV@XwWaXUJVnUVlb@lzlJUVk@UXVVVxlVn@nXV@@lVVlI@w@K@mnI@W@wU_VWbVVVnKbla_nbX@°»Van@VUUaUamXUKWK@a@Uk@wWkXWW@wUUKw@_lywUkU@@U@kamVmXaUVUka@Wk@»UUUVKkbWUVUbk@mkxkKnIVUmW@kUKmXUmVaU@kU@m@KUWVkIWJ@U@UI@wUUUa@KW»nU@mVkUmm@XwWU@UUmL@w@mnVUU@aWak@@amxU@UxULWVXbVLU`mbUImVUbnV@@bVn@bnVWxLmyUbIUK@aVmakbVUXWUlKWbkV@WLUlk@@nbb@lkKmU@UIWJkw¯UUVVxm@@XkbWxXKlUzWJkUUL@bmKkV@@VUIUlWV@XK@VkbWx°xUb@LUbk@@VWb@LXJ@VWXU@@bUVVVVn@VVlLn@l@xk¦Vx@bVJXbn@JlnXxV@@nJ@X@V@lmxbUn@xVL@VVKlL@lnLVaVL@xkl@LxVl°XWVXVlJWnxlJ"],encodeOffsets:[[119194,26657]]}},{type:"Feature",id:"3509",properties:{name:"宁德市",cp:[119.6521,26.9824],childNum:9},geometry:{type:"Polygon",coordinates:["@@@LVKVaVaUkVU²J@LVU@@WVJUbVVnLVbL@VUJ@bVbkL@l@VnyXmlU@xV¦L@lmz@lnL@bVVbVb@lnKVkVl¤@zXV@l@XJVLVKnXVKVnU@wUm@KU@UlVlw@U@U@UaUKlU@kXKlmXIWKXaVIVUVK@KU@@kJVUnLVJUL@VIVa@VnLKUnl`VbVV@Vbn@Vzn@lKnVlIVVKUalkXJl@XXVWVLVUUmVU@Unm£lK@Uk@WUXK@U@WVwVkĠkĢÇ°aUÅUwmaţɱUÇaw±V¹XalKôx@UVaÜʓͿVóbÅLJm¯Vk¦k@mamXkKUULakbk@mV@LkJWb@VkmXk@UVmaUV@amLUKUamI@KUaU@WbU@UUUUIWJUkm@wKkVJm@kxÇVUK@mUVUkmlkkVm@amwLVWU@UbVLkUb@VmK@XaVWU_VJnwV@@kUmWakx@kwWakIWxnbUJz@kVW@@x@XllnVW@xn¦ULWKXxmL@VU¤VLÞVVUÈxVmxXVlLlVanV@bbVLlÆnnlW@LXlWnXV"],encodeOffsets:[[121816,27816]]}},{type:"Feature",id:"3501",properties:{name:"福州市",cp:[119.4543,25.9222],childNum:9},geometry:{type:"Polygon",coordinates:["@@lxna@nJ@xlIVJV¦UVxUb@bLVUlVkL@V@VVn@VbLn@LUlJXblx@lwXbVn@lU@mxUIV`UXWb@nLU@ValUKVaV@UXKnxbn@lUkllnUVnV@VLUÈlwn@UIlLxn@VlXIVJVVVV@XaV@Vb@LnJVbVLnK@bVUnbVUl@nWl@UXalI@KnUl@labVKVlLnWnbl@l¥°UnIÆKôa΀Ua@UUwÇWǓIUWUÅVkƨm@@£@KmLU¤ULˣJkUVǟUUķ@ĉVKUk@Ñ°wôÇç@īé@Åţ¥mīÛkm¼Å@VķVó°ō¦U°n@bVJXVVL@bUakLmx@xmxXzW`XbWnXV@bWLÛ@a@aXbWVkaÝwU@mlWKkLWWkLUKULW@kVmVUUÝUamV¤n@xUVUzkJV¦lJU"],encodeOffsets:[[121253,26511]]}},{type:"Feature",id:"3506",properties:{name:"漳州市",cp:[117.5757,24.3732],childNum:10},geometry:{type:"Polygon",coordinates:["@@@bl@Xb@bVVUm@nx@nKVV@XVWxn@VnUl@nmVX¼@LVbVV@xVJV@@XIlJXUV@Ln@lVV@UbVnnWVL@lnXUVmJLlwnll@VaUXVlaLVUVV@¼Xl@lbUVVWbnnUlb@@VV@aVUmlUaUny@kU@Wkk@WaUVk@@ammk@@U@UlU@aUa@wl@mXLllnLU@anVnU@L@VVV@KlXnWVnVanUw@w@wmnÅ@waUam@UkmUl@@aa@U@¥kôKwÈ¯°w@ŻkwǕaKÑÛk@ĕōřċ£ĵUKW»kÅŻLU@Ulġw@¤VzVUbkKUbmLmlULU¼UxmbXl@bWVb@bUnVUVbULU@@VkbVL@`U@WX@XV@b°@b¯@¤@Xm@@b@`UVVUL"],encodeOffsets:[[119712,24953]]}},{type:"Feature",id:"3505",properties:{name:"泉州市",cp:[118.3228,25.1147],childNum:9},geometry:{type:"Polygon",coordinates:["@@Vlxkz@`xLVV@xXXWXl@xl@V@bnV°@LVm°LVbV@ÆXWlUmxU@WVULnx@llUXUJWzn`Vb@@b@xV@mXX@@JÆVVXVKXkV@nVlUl@KVbULJV_VKLVWX@lUVkIU¥lIVyVU@wm£nUVWU@am@UmWw@UX@@amVUn@@aUUlUVanaWUXWmUnkK@VUlVVUUw@XLWWXma@knmbVbVXbVL@XJlInlLwmXów@çV»ÇçŋaķƧóƅóKġ°nÅUķƑUÇW@¯xÇ°öÆlVn@lla@Lb`@VXVVx@V@bULVJUkÇ@¼XUKk@mmULkaWbk@x@UkL@a@K@U@UmKmbU@kV@UmVUbUmmXkW@LUU@U@KmVmU@bVmKkkWKnk@@xVb@bkV@V@Vl@nn@bl@VUXbl@XlV@@lmzVVbknUVb"],encodeOffsets:[[120398,25797]]}},{type:"Feature",id:"3503",properties:{name:"莆田市",cp:[119.0918,25.3455],childNum:2},geometry:{type:"Polygon",coordinates:["@@VbÞVVnUlUX@VKVLlKXXlKXLnkV@ÞxlbXUWab@bÜ@XK@aWUXmWaX_Wynw@wnwlKbV@aUKWUUI@amV¯Ŏ¥ô¯ĸUUÆ@n»¯aƿé@ţ¯nĉĬÝKóó@ÑU¼@èxWônxKmkkJWI@UKWaUUaamn@lnbWXXWK@VxUVkUV@ULmlnVWXXVmbUbkVVV@bm@UVn@bW@@VXxn@Vn@bVUX"],encodeOffsets:[[121388,26264]]}},{type:"Feature",id:"3502",properties:{name:"厦门市",cp:[118.1689,24.6478],childNum:1},geometry:{type:"Polygon",coordinates:["@@@VlUV@nanL@V@V@L@blK@Vwl@XalbVKnnl@VLW»È@lVUIVK@a@UUwWUU@_aK@bkkm@UkõÅxóLl@¦@Vb@bk@VnVln@Vbb@xmÆn@x@xx"],encodeOffsets:[[120747,25465]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/33",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3311",properties:{name:"丽水市",cp:[119.5642,28.1854],childNum:9},geometry:{type:"Polygon",coordinates:["@@@VbVl@XnUXKV@¦nxlUXVnKVmnLUV@bn¤lLXK²`nnlJXIVJIVnn°KnnVll@VLXWV@UkVaVKzV@VVaUK@U»VUl@@WnUU@wVLn@Vwl@XW°LVbn@VU@Xl`@XnKVbkl@XVJlUnlVxlL@lnXl@VUnV°°@aUVLXblWVXn@VVUV@L¤VLVUVbnalLUUVX_laVaWVzXKV@@a@KUmImmXama@kU@yVIUKaVa@kXK@aWU@VIUmW@kkVmU@VwUa@K@k@U`@kUKVk@UV@VaUm²Vy@klUUWUkVmUa@_KVaXaXmU@mUlWkaUX@mmkL@wJnVVÅbWKXa@@I@aJUUÇ@VULW@akLmb@K@aXXw@mVmUVkUy@£@aU@@VkUWm@kUKXUWU_mW@wkkmJUUkLWWUXW@IkJ@k@mW_kÓ_UlLm@I@aUa¯m@ka¯LUJ@mVVxUba@LUKkXbm@Uak@@a@Um`IUbUJ@nUVW@@LnVV@lUbVlUX@`@blXklWUmXlm¦U@@V¯bml@@nUb@llnn@VbX@lV@UVULmU@JVnbVbkbVWxU@@nUVk@"],encodeOffsets:[[121546,28992]]}},{type:"Feature",id:"3301",properties:{name:"杭州市",cp:[119.5313,29.8773],childNum:6},geometry:{type:"Polygon",coordinates:["@@X@l°KXXlWb@²`bIX`l@@bWl@n@VnLUV@V@°¦@l@XVlU@@xVbUb@Vkb@@XVJVzJ@LÞ@VmLUxUJ@LUVxbxXUl@VaÈwbaÞa@Vl@XUVx@V@VLlbnVal@lbVnnLnKnL@VlbVJXalIb@KUU@mVInJUVl@xUVLnU@UÞaV@lkV@UanKL@UlKVUnbÆmn@@nUlVnVJl@@UXUL@WVIVJVxVLXV@IÜKnbn@V¥V@@I@y°b@UUwnk°ÆƨVlUçXm£aÇIkV@WV@@aWIUWUIkb@WW@UnK@UU@kaWVkVIVVnU@UWVUV@VmVkKkWIkVWaULU`UImJUImmU@wmwUVIUWVkUamaU@mVkb@KVU@aVU@anKULVJU@kÛUJUVkkVakU@aVwkW@UWkXmWaULUaUK@XJUUmVU@UVUkJ@ImwmKU@k@lUW@@akKmkamIkWl_UwVm@UkaVUUa@UamakbWlkL@aUalU@mkL@U@UlmK@XkKm@Ýakb@xnXb`nUUU@U@wU@@mKkkV¯U@lULUbVbUb@Va@LºÝb@bLmKx@VUL@bk@mxULWl"],encodeOffsets:[[121185,30184]]}},{type:"Feature",id:"3303",properties:{name:"温州市",cp:[120.498,27.8119],childNum:9},geometry:{type:"Polygon",coordinates:["@@ll@xnXV`VXWVL@lXnlV@UV@@b@¤VzUlnVU@nWxW@b@LnalK@bXVKUÈ@VVI@b@J@WbXLÆaUUmI@xlKnn@VWlbkXV@nVWnWbUbL@`VbUnVlVXkV@lUz±VnUbU@@VUlVL@l_@V@l@LVbV@XLV`VÈlxn@lU@aaVVk@XJ@nl@@LU`°LVbL°a@aUVy@anI@aanV@²wÜJX@VVV°kna@WVkaWwU@m@kaUĕÝÝŤnÈaaóI»@±XWkUķ@kV±kwUkWwUÝ»ÛkɳlImaUaWóXÿǬkUnWVmmkKţnŏÞğlUlUx@XWbV@JkX°mb@VULVxUVk@@LWWk@WIkUkJmUkVmI@y@UakLmU@mUUUkaVk@mK@UlUU@UmKmbUUUJ@n@KVLUL@VkJWXX`mnULWlkL@JVLVb@°kxkU@LVV@VLV`UL@VUX"],encodeOffsets:[[122502,28334]]}},{type:"Feature",id:"3302",properties:{name:"宁波市",cp:[121.5967,29.6466],childNum:6},geometry:{type:"Polygon",coordinates:["@@Ċ¦ĸĀ°nXÞVKkƨƑźÿ°»n@wô¥ÜbU°ÆXÞWóçĉÝ±IUÈ¥@U°wÆ»²mm_@aXVKÞVlk@akk̅@£X»VwÆXWa¯aȗbKƽŰĊxLók@@¯nKUL@xkLÑkWULUUmJUXVU@mUX¯@V`mbXbV@@nn¤WXx@kJ@nVVUVl²UbÝVUVk@Wx@V@VXzmlaL@VlLU`XUVVVUnl@VbnJlnUVVnlUKkbmnnVxlJnxmbU@UL@KUVX@xmb@lk@mnVVUè"],encodeOffsets:[[123784,30977]]}},{type:"Feature",id:"3309",properties:{name:"舟山市",cp:[122.2559,30.2234],childNum:3},geometry:{type:"Polygon",coordinates:["@@l΢ƒʠþÆVĢLĊǬXĊÜXôVÑÆwlƏÈóVĭVǓ@ĉwɛkmK@ĉXīWaĉUĵÝm¯ĉwĉ±±nÅ¼¯x@VÇ¦V²JĊÞôèÝXÅW¯VÛaó¦@xm¯¼ŹĀ"],encodeOffsets:[[124437,30983]]}},{type:"Feature",id:"3310",properties:{name:"台州市",cp:[121.1353,28.6688],childNum:7},geometry:{type:"Polygon",coordinates:["@@lVIVWVz@bXJl@Xal@°nLll@nVxnVK@UJVb¦°k`UIWJXnÆ@bUJXl@lbWn@UzVV@bVVmVnnJVXnabKUKnUVVUnVLlKVLXaJm£@mU@WanaU_°@VWnV@UVWnIVVVKlXÒlK@wVKL°m@l@ôKwĉƾůUl£@»UVkm@ƅUaÛIŏmUk@mw@a£Wk@ţIm±@ankôUlaUUw¯ōabÇbţmÞÞVĖbl@@nVXxbUl@Xmb¯lUUUW@ÛI±xU@mb@bmJ@bUzV@b¯bKUa¯KV_@Kk@@mWI@lUUb@bkVm@kwUÇU_WKU@Ux@VUnllX@VnJ@UXV@bWL@lUbbVLUJ@zV@lnbWbnnnJV@L"],encodeOffsets:[[123312,29526]]}},{type:"Feature",id:"3307",properties:{name:"金华市",cp:[120.0037,29.1028],childNum:8},geometry:{type:"Polygon",coordinates:["@@nbVb@VbUVlb@VUnVxk`lXnJlbnlL@bX@V@klV@nLnx@JlIVU@VUVnVVI@WVLVbVKXbWnXl@VlXUxb@lVUbllVUIÜVnalKX@@bV@@aUUlUwUw@naWWUVaUUaVbLlxXJVk°UlkU¥@ka@LVlXLVlVWznVn@lxJl_@WX_@mVaa@alU@kVVnaKVLlKb@UUaVabnUWmXU@k@yVI@aÅWmXIVJl_¯¥UaVI@LmUUw@mkkmK¯k@Wbk@WI@aUyUXJkU@bU@WLUyXUbkbW`UVVkKmbUaVUUK£@KVUUUm@UWkXWaUKV@b¯¯mUV@UkmW@kkKwUmkkVUI@WlkUamL@Wk_W@UVm@Ua¯KWXk@Uxm@UK@xVmV@Xk@UVV¼@VLUbUU@yULUbVlU@@XlVUVVbU@lXXVW@XUVl@@VUVÈn@VVU@lVa@UmL@`X@`WL@VUX@lUL@xlx"],encodeOffsets:[[122119,29948]]}},{type:"Feature",id:"3308",properties:{name:"衢州市",cp:[118.6853,28.8666],childNum:5},geometry:{type:"Polygon",coordinates:["@@XkVKnwl@@aVK@UwnLK@aÞa¹@Kb@UVaUaVaVK@k°VUllnL@V@xV@V@VVm_Wam@wlaÞbn@lL@WnLk@V@VlK@nkVVb@blKXklakw@wVK@kVW@UXK@_W@_nKV@Ub@kVUUm@ÇVU@Uk@VU@WUXWW@kVUaVUkU@WWXUKk@Ukmm¯LmmUJUIWJkImm_±WLkKm£@aVUmKUnLmWUkVmw@¥ULVWm@WUka@UmmLmm@@bUX@@WUIm@UVUK@UVUUUVVJmb@bXnmV¼nnn¦mJUVLV@VW@UzUlVnUbl`UnVl@XU@kl@bmÈUxVk@@J@¼W@ÅaVVnzmV@WJk@kWJ@lXbWbXxmVnlLXb@°lKVXnWbWVXmbV@XlbI@Kn@@x@VLlm"],encodeOffsets:[[121185,30184]]}},{type:"Feature",id:"3306",properties:{name:"绍兴市",cp:[120.564,29.7565],childNum:6},geometry:{type:"Polygon",coordinates:["@@x@VnnVJnIVJV_VKXblUXJllLUUnU@UVVX@mVUUUJlXUlbV@@VLVmX@@XlaVJVXXJ@b@XU@lUJÈb¤ŌJçVUUnml@@kna@wWVU@LVKV@namwkIUwmnmlaVLkUmVUkmmIUak@VmUUVUWV_kK@UKbnkWyU@@UXwl@VUÞUVak±VUUU@mlI@wXWIWbUKkLUKVmUUmVVLLambUWmIUmnUU@aUUVym@Xkak@W@z@lWVXnmVaUbVb@VakLUKLmbUU@lkV@bbUb@nW`@Xk`Ikwm@mUXyUUkWKUk@Kb@lV¦klV¯UlWIkwKUabVVUbVXXmb@VxxkVVV@bU@@aW@kLmb@lVUIVKmL@bUV@bUV@LalnUV@nbVbUlVXJVUnx"],encodeOffsets:[[122997,30561]]}},{type:"Feature",id:"3304",properties:{name:"嘉兴市",cp:[120.9155,30.6354],childNum:6},geometry:{type:"Polygon",coordinates:["@@@blIX@@VÜVUnn@lklKnI°Þl`²LVKVbnbVaVLUVn@W¦@VkVVb@VI`@blLnLaX@VVb@U@XlVa@@kVaUKV»U_lWXU@albk@VllnLVKn@@UVIUw@y°IVVXU@VV@lwm@wVkƾaJLkΡƧƒlLÝUmW¯ķÿĉ¥IŋWnèkVƧU¯ÅmlVx@V¯az@@JU@U¦m@@nVmn@VLV"],encodeOffsets:[[123233,31382]]}},{type:"Feature",id:"3305",properties:{name:"湖州市",cp:[119.8608,30.7782],childNum:4},geometry:{type:"Polygon",coordinates:["@@kLlkm@VmÛU@UW@kJ@aUK@UnmmU@maÛL@JWUUKUwUIUJ@XKWV@Vk@UIUmVk@mm@ÅnmaUVkL@VKmLVbU@klU@ÝbV@mVUKV@wUkVmIUJ@nVV@LakJWbUIka@UmKmLKmmUUVk@@nmLX`WXUV@@nUlkmlU@UbxVVIlVnn@@nUÒ@°n@@xmb@VbnV@@b@`@L@L@x@blVklVbnnV@aXb°VlU@Wb°ULXWVUVVwÈwÜ»ĸaĠnUVw²X@V@lVU@wlaUUVm@knUV"],encodeOffsets:[[123379,31500]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/32",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"3209",properties:{name:"盐城市",cp:[120.2234,33.5577],childNum:8},geometry:{type:"Polygon",coordinates:["@@n@°ĀÞ°@¦ULWKkx@bkLWb@lUlVXXJVbnUKmxXV@bm@@XLÞÜ¦XlVnmzVJ@n@²ÞôkÆÞaȰĉwnǉÜóéVÛnĊīČǉĉ@ō@KÞUlU@kklÇÈÑÑlġXɛ@UġaU@U_W@n@kaUL@VW@kKmkUV@bkbWW@bkzma@JWI@KUKUL@U¦`@XUJU@KmXw¯KXkmy@aUIWJXXmV@K¯UU@@bVL@¤VLXbV@@JVXVK@JVn@bkKmakVVXUVVVlI@`U@nzVVb@¤n@@UlKXLVVI@V@nV@V@ÈUx@óVōkÅWó@mU@bk@Ýwk@WbXxm@@J@zV@kVbVnLWVUXWUXUWLU@Wl°z@VkxU@UVWIxWJkbĬnW@@bUl"],encodeOffsets:[[122344,34504]]}},{type:"Feature",id:"3203",properties:{name:"徐州市",cp:[117.5208,34.3268],childNum:7},geometry:{type:"Polygon",coordinates:["@@XKVX@WnIVx@K°Lnll@@I°KnVaU°x²mlx@VanU@ak@akmV@@w@Ua@aUwVwUw@w@UK@£kaĉlóIÇVk±@@kUKmVkIkxW@Ua¯UUm@UVI@WVIJV@@Um@UanaU@mI@J@XV@XaVlkXVaUUWLUyVIXmWak@XkJókJUL@KWkk@ULU@WalUIkJmImkVbV@lV°kXUKWKULUmb@VUlVnb@VV@IVKUUmU@ak@@bmV@xklUU@UKmV@nJVbkXKUamLUJ¯UUVmIbVVLl`@LLU`m@kXUVU@VlxUK@xkIWbUKx@VkVVnb¯@@U@xkmbkLÇKb@@XnJ@LmVkl@@XlUVkxakVVb@bVnUbU@@xVUVb@nIĊ`XVVôJ_K@xlU²KlkU@VaVVÈm@kVUVmnamUUaVXIVJ@ç@¥nkVLn@@XVK@VUX@JVUV@UnVJVLUJVLUVlnIbKnU@m°VanI@anVKVLanlKblKÞk@¦@¤@VKnLVKLKVzlWLX@VmV@VbnU°@UalkWXLVUKWkUUW@£Wa"],encodeOffsets:[[121005,35213]]}},{type:"Feature",id:"3206",properties:{name:"南通市",cp:[121.1023,32.1625],childNum:7},geometry:{type:"Polygon",coordinates:["@@VJ@bnzWl°LxnW@LVVI@W_V¥@VKVL@LXJI@nbly@aXXla@aVUnllLX@@UVKlb@@mXV`V@bĢlkČÇÆȘ¯wnĕVĉVÿUƒUĠŦğlXÑVǵ@±ōLʵĖ¯lÇbÝÞ¯xk@Çkķén¯@ğġƴǫ@kVVlUbL@xULÇóLUl¤@nkVV°VLkxVb@laUXUKWĖklVX@¤UUkb"],encodeOffsets:[[123087,33385]]}},{type:"Feature",id:"3208",properties:{name:"淮安市",cp:[118.927,33.4039],childNum:5},geometry:{type:"Polygon",coordinates:["@@nźUôÒɴèl¦nĖVkbmX@xVlVL@xUb@bUJVnUxlKVLÈxmzXV@lW@XVb@bÈVxnbVIXa°LaÆVVaXUlK@aXIÆVlXKVUlIXalK@alwXLVK@¥Ý¯¯ÿ@mVk@aX@mīlaXIwXJVUV@lw@U¯ybUaUġUÅaUKVknaġm@kUm@wÆIV±nLÆwÇnUUk@ƅÝU¯JÝI¯¦Ul@b@@VVL@l@LLÅmL@b@UaVaUWmLUKV¹KLWKX¥WI@mXk@UmaUVUU@VmL@WbkIUWUmVóIkbmm@UbVLUxmJkU@bkJWbnXU`WzKUÞÈlVbLmx@kè@Æ"],encodeOffsets:[[121062,33975]]}},{type:"Feature",id:"3205",properties:{name:"苏州市",cp:[120.6519,31.3989],childNum:6},geometry:{type:"Polygon",coordinates:["@@ôèĊVnX°¤²lxƒÈÜ@²x@J@b@X`nIUÆUUV@bl@VVnL@L@xJ@X@blJXnW@@`XbWkV@UbVxXUxkV@LóxVbUVW²VJĸklUǬ@ĢƳĠ°@mƒī°»ÈÇ¥ULUU±a@bU@¯U@KnImUVWUkmXUVU@lIVaUUVWKUbUkWKU¥n£WakJUkULK¯LKkVIn@VaUVUUUkVk@U@amUkJ@UUlwX¥W@@UkVmk@JUakL@kk¯ÝmJUn@nmVXlmbVVkn@UJ@±WUxV¯a¯KōbÅ¼ÇxUxUUlWL"],encodeOffsets:[[122794,31917]]}},{type:"Feature",id:"3213",properties:{name:"宿迁市",cp:[118.5535,33.7775],childNum:4},geometry:{type:"Polygon",coordinates:["@@XbWnUJVzXKVVUbWklUWbU@@W@IJ@nVmbVbn@@V@UIUJ@XUJ@VVn°VVbX@lwlJnUVL@l²@lÈUôJĊklb@¤VL@@xVxUxVx@bVb@@xU@lnmnXmXLVmV@X@lxVnVJôLLXax@b@@KVL@bn@@m@@alLUUVaU¥nIV±I@mXI@aWWXU@LlUXWW_XWmaUwÇ@aaWUX@@kWUynÇwUKkLVwUmVI@aVa@wUKUk@wWnlaUmĕk¥ɳçóÑŹVmmzkVmm@a@Iók@@LWU@`WbXLWlkImJVn@`nXVbXmL@Vn@l@nUVl°Xx°U@LVĠ@z°@¦UV@Xn@VJmV"],encodeOffsets:[[121005,34560]]}},{type:"Feature",id:"3207",properties:{name:"连云港市",cp:[119.1248,34.552],childNum:5},geometry:{type:"Polygon",coordinates:["@@@lzXxmÆV@@¦@l`XnlKXXmKnLlab@xmbm@kL@V@Vl@@VUXJXmb@@°Æ@èÈzlW°XĢJlÈ`lInbWV_@m@UUķnôw°ÆmnaVVÛVmĸ»Ģw±Ý@@mUInyUmWkÛ¥ÝK@Wn@@aWUnwVLmUaWIUWVk@kkJUVWLUkÅWJ@bkLWVUbÅUb¯KWbUJWXX`WXkV@KWVXX@bWJ@nJU²mJV¦UbVVkK@b@@nm@@aUK@L@@awWbKóKUIUmkwW@U@UnWKnmWn@bl@bmVUb@kw±n¯wVUb"],encodeOffsets:[[121253,35264]]}},{type:"Feature",id:"3210",properties:{name:"扬州市",cp:[119.4653,32.8162],childNum:5},geometry:{type:"Polygon",coordinates:["@@VUXblVVVb@xV@kzV@lwVLUbVV@VU@VbUblb@nkĶ°IÞV@ƆVlmVÈÅxmKU²ÅJ@xVn@lĢnmbUlVLÆbĢVVbVaXk@VXKVVWXVWXUmKUaWaU@¥@£XWUUV@@ynam_VWkUVUna@ÆV@mnkWmXkWUW@k@@akkllWUI@UnKl¥I@VVma@a@I@U@a@anK@UmK@ÅVUnJlkI@aVwka@mVIUW@UWL@WÅbmIULkaUWUxkLUKWlXL@VImÅVUmĉLUól¯I±l@ÒUbVbUVVXUJUnVV@lnbl@"],encodeOffsets:[[121928,33244]]}},{type:"Feature",id:"3201",properties:{name:"南京市",cp:[118.8062,31.9208],childNum:3},geometry:{type:"Polygon",coordinates:["@@k@ma@kUUVmVIUWVUUaVa@Ñ²k°Jôk@Wmk¯KmX¯aUakKWU@XULXaV@@mUaVUUl@VmkaUXm@WUUna°IlmVmIUW@Uk@@aV@VVX@VI°»nmU@VKVan@m»UaU@U_@WlIUaaVaUala@¯n@kaUkUUWKU@mwkUUmmL@K@LmUUVKVÅImUJVkVVLèVLVU@WLV@nVÜULVUL@bW@XbWbkJUUVUxVXmVk@WUUkVmIV@nbnVWbJUkUULa@Jma@XkK@VVL@L@JLUVU@V¼nXlbm@kbUKmn@lVb@VXXVUV@b@LVbÆxXbl@@lV@UVV@XVK²VlI`UbVbUlVVn@WXn@@VUV@@KmbVLXÒLkKV@nX@VVUV@bnVllbmnbIWVXU@`lLlknVnmlLlbUmVInK°nUU@l@VU@Vn@@alI`VIXaVaVa"],encodeOffsets:[[121928,33244]]}},{type:"Feature",id:"3212",properties:{name:"泰州市",cp:[120.0586,32.5525],childNum:5},geometry:{type:"Polygon",coordinates:["@@lUU@@y@In@WwXal@Þxl@@anVô@ÆXlŎôU@Vw@ÇUU@@m@UJUUWKkL@Vm@@£aUUmyV@@_kJUUVUUWlUnblL@aUmI@ULUW@IU@WaUK@£UK@aV@°V@LnUWWXIlaVV@£UWlkXĕVLVWb@kUalwUKU¯lU@mk£VôKÈVK@wKVaUkķlUI±ğ¥ÝUŹ¯ôm¦ĸ@XXK@VVXUJ@nlbUx@blJkmIUV@ÆnL@VmL@b@b@V@J@bnbU@UJk¦mL@VVJkXkll@b@@lXXVWlXnml@nÅU@mbUVlVUXn`mb@zU@VVWX@¤¦V@Xb"],encodeOffsets:[[122592,34015]]}},{type:"Feature",id:"3202",properties:{name:"无锡市",cp:[120.3442,31.5527],childNum:3},geometry:{type:"Polygon",coordinates:["@@nLÒlxUVkLam@kVWUULUxVVVbUV@bVLUnnźÞVĠ¦XVUUaôw@KlUVwWUwVa@lUXWa@_X@WmkI@a@WI@w@KmKUUk@@aVUVVÅmJ_@W@a@I±wÛ@ƑÇkw±¯£mWĉUóçK¯VkUWK@XkV¯UWabmUaUUblln@b@xbXWX`@VxUblL@bn@Vb@`m@XbWnn@l¤n@xnVlUVLÆWkV@VbÞJ_nl@nKVU@aUU@mVk°WVLUV¯bVXbXlVn@VmL@xV@bl@nW@X@VVJ@²VJVU"],encodeOffsets:[[123064,32513]]}},{type:"Feature",id:"3204",properties:{name:"常州市",cp:[119.4543,31.5582],childNum:3},geometry:{type:"Polygon",coordinates:["@@LnxUbVVL@xnnWnn@VVXn@yImx°La¥n@VkKVwW@nXVJ@b@UVn@UnUV@Lb@`VLklVÞnÆ@VaXLlÈJmmVUK@aVUUaUUVwVKXVlUn@blKVUkwÑmKUVUI@±UI@U@WmX@k@aU@wnK@UUmWkaWU°aVUUK¯XUl@nVV@bUVmLk@m`ÝIUaU@lÅXUKkVmU@wmk£m@XmWan@@_Uam@@akKVaUw@W_XWa@w@akmm@mL@UJmnUK@@XnJWLkKUb@VxkWLaWVUImVULUK@L@lkLVVVllbm@@°kbVbUbbVbkJ@XV`V@Vbn¼"],encodeOffsets:[[122097,32389]]}},{type:"Feature",id:"3211",properties:{name:"镇江市",cp:[119.4763,31.9702],childNum:4},geometry:{type:"Polygon",coordinates:["@@VĊKnVÆUnJ@UWKXkVLlKVwXVlbVKnJÆaķn¥°óÇIkWKUbÅ@mUÝlkUK@_a@KVUVm@mVU@@aUIW@mXUxLUlm@¦bK¯nwJzm@UW@UmmXmm@wKUUVamwKm@UbUL@Vmn¯¼JUW@UUU@@bl@@VVXJnnUk¯JmbVVXn@VWlbUnk@VVUVb@nU@WbKWV@XVlLVb°bnW°Lnl@X"],encodeOffsets:[[122097,32997]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/50",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"500242",properties:{name:"酉阳土家族苗族自治县",cp:[108.8196,28.8666],childNum:1},geometry:{type:"Polygon",coordinates:["@@XJ°lJX@lbl@XbV@VLnJlxnbUU@IVK@lVIVwnJlU@n@J@L@Jn@l_nWVLVln@@blLmV@@xÔ`nxVÈLlxLVxVVV_U»VWn_m¥XwVmnX°lmUUVwÞaVk@a@mmIUa@mwk@m@@U¯a@UV@@K@ykkmwkV@kU@ÑVkKWLÅamaUm@kyU@WkU@UaIUaVaUUmUUa@aVLXKWa¯UUbmJXnWnX`l@@xkzWÆ@VLU¦x@b@JkIkJ@LmbUamJwm@óxnk@V@xVnUVmVUVUbVlUbkXW"],encodeOffsets:[[110914,29695]]}},{type:"Feature",id:"500236",properties:{name:"奉节县",cp:[109.3909,30.9265],childNum:1},geometry:{type:"Polygon",coordinates:["@@WVXbUnK@x@b²kxmKkl¯_VV°VU@bnKVVV@@nk@nbn@°@VLČU@°WV@VnU@InKVl@nUbKnXWlknLlKUwnalLaVlUXmWk@UU@UWWIUyķ¹XaWW@XKUIVmU@W@UVU@KV@n»VkUkÇmUmVIUmULUbm@wUaKkkm¯ÑUL@bWVnx@VmxUI@klmkkK@aK@IlJ@I¯k@mak@mnkJVL@bV@UbW`UUUVI@VU@VVbUJVLUVVbUXVVxk¦VJUnVxnVVUJV@Ubl@@bXV@L"],encodeOffsets:[[111781,31658]]}},{type:"Feature",id:"500238",properties:{name:"巫溪县",cp:[109.3359,31.4813],childNum:1},geometry:{type:"Polygon",coordinates:["@@nLWbXVLVUV@KIVl@b@lbUVnU@JÆU@V@n°KĢUl@VbÞKV@_VKXUU@KX@wlkkU@mWKUU@UôJ@XV@aVmÞIVaVL@»km@UkLU@aU@WWLUUUKkbwWa@KU@kaXmWLamVk@UmL@JmVUU@¯X@ċVUK¯@ÅnWKLkKULWK@UXK@wW@LkV@bVLlXn`¯xU°LnlV@n°Lnl"],encodeOffsets:[[111488,32361]]}},{type:"Feature",id:"500234",properties:{name:"开县",cp:[108.4131,31.2561],childNum:1},geometry:{type:"Polygon",coordinates:["@@n@naIw@@VVKLVbVxnVÆUnanKWXamKmk¯K@mkUm¯KV°w@Wm@UIUUlKUU@a¯KWanwmUXamKkUWUnU@KkUwWKXaWLUWkImaUUUKka±k@l¯wwmbUkXm@UJkIWXXbmUJXUV@°KllVXV@xmbnV@blV@VU`UL@Va@bULlb°VXbÜ@V@bL@JxnLVb@lVb@V@@zbXWXKVLV@@bUVVL@blVna@ll@zl@@J"],encodeOffsets:[[111150,32434]]}},{type:"Feature",id:"500243",properties:{name:"彭水苗族土家族自治县",cp:[108.2043,29.3994],childNum:1},geometry:{type:"Polygon",coordinates:["@@Jlb@nVV@bXb@ÆlLUl`nVKU¼VxkbWnlUxlXX@°°WnnJ@VUn@Jk°L@VlV@nUJx@bVVVz@VnLlaKnalVlIU¼@nV@@anKUwVal@UlJlI@akU@UWXKVI¯Uak@@KmkXWÜkXWykIWwXw@laXamkVUUym_XmlkkmmakwmIUKU@Wak@kaW@kI¯WIk¦VUUmaUV@XkVUV±aUb¯b¯¥m@@ImJ@mmL@kUKUkkJbV¦"],encodeOffsets:[[110408,29729]]}},{type:"Feature",id:"500235",properties:{name:"云阳县",cp:[108.8306,31.0089],childNum:1},geometry:{type:"Polygon",coordinates:["@@lbLVVVnblJVXXKWbXLVxl@LmVXVVlnLWbnVmxXb°L@bVVkLVVVJn@@X_WmkUK@alUKX@@xWL@VXLVKlLKXLÆm@ma@ml@mU@UUmL@aVUU¯U°`lknLlw±@a@wmLVWaXU@KWU@ak@VaU@IUVmUUwVmUIl¥UwUVWUaVUUKVIUa@UUUUJUUmknl@@VWV@L¯aUbUlx@@b@VULUx@VUxVVU@bU@mxUU@mUVklkk@WxknlxK@amLKUK"],encodeOffsets:[[111016,31742]]}},{type:"Feature",id:"500101",properties:{name:"万州区",cp:[108.3911,30.6958],childNum:1},geometry:{type:"Polygon",coordinates:["@@ĸĊVInaWWXlJVIn@lWVnax°xkl@²LVLnK@bLkwlmXw@lllkUnVV@VnwV@@aVUUVw@UVwVK@U@a@kwVVa°b@KXU@U@mkÇÑamlkUVmn@VULUm@kUVkUawUWm@Uw¯mKUUmVUUULUKUW@XbWVkaWwkUUk@maUbmbVlk¦xUVUIWVUkJVVkL@UmJUUVU@lLUVUlx@@VbJUL¯¤@V"],encodeOffsets:[[110464,31551]]}},{type:"Feature",id:"500229",properties:{name:"城口县",cp:[108.7756,31.9098],childNum:1},geometry:{type:"Polygon",coordinates:["@@VK@w¯L@m@UÅV@ImVUVka@@aUkJ@LUUVUKmLmbÅVmUUwUaKUL@U@xJmbm@nVJ@X@VkVnlLXx@b@bUVLU`UnbU@@mVVX@JX@VLVVklV`@bUL@VLVKn@U@UJkn@lmLmK@X@Jn@mbnÞWVXnJkKČÑÆ@VK@knaÜmXlUČW°kôÇÆ@a@yÞ_VmUnU@K"],encodeOffsets:[[111893,32513]]}},{type:"Feature",id:"500116",properties:{name:"江津区",cp:[106.2158,28.9874],childNum:1},geometry:{type:"Polygon",coordinates:["@@InWUUlU@LValX@°²lÒXxlK@Ul@@Un@UaVJ@I@W@UUUVUwVIUKUaUUVwn@Üx@XUlnnbJ@¥VklKUUlk@ynU@kVUUVWnI@¥V£VWVIUKU@UVa@n@Vm@@nlUaVkUwJ@blLkLW@XWmXkmmLn@m@U@UVm@UVUUlakUVaVkV@@wnaWUk@VwklmVIkUUxmJ@U@KIkx±V@IUm@K@IUKkbWKUbnm@bmVnbmb@xkxUJ@ULW`@bX@WVXL@V¯mk¯@UJ@VmLUaWnX@WJ@nkKkxW@UIV@@KkImmkK@UW@XaWIU@UIkbWbxXlLVbnV@bWlX@VxVLnl@nÆÞVÜ"],encodeOffsets:[[108585,30032]]}},{type:"Feature",id:"500240",properties:{name:"石柱土家族自治县",cp:[108.2813,30.1025],childNum:1},geometry:{type:"Polygon",coordinates:["@@@kl@¼UbmVXJ@bV@nxVIVJULVVk@@LWbnJVU@bVbUJ@blLXnWV@mbnV@Vbn@VJVLnaVanbl@VlVXxlbXUWaX@VUUVwUUVm@I@WmI@amlLlK@alwnUV@kóVaÝk@UlbVK@VU»VUUVWU@U`ULkwm@@KmU@knK»VkJkUmbLkbmK@UUyUU@awm@@XXJ@VVLVVUbVnUJVX@Kk`WXXJWXUbmW@bkLUm`Xnb@JVL@LU@°VVXKVnUxVLUbmJ"],encodeOffsets:[[110588,30769]]}},{type:"Feature",id:"500237",properties:{name:"巫山县",cp:[109.8853,31.1188],childNum:1},geometry:{type:"Polygon",coordinates:["@@kVUbkKmbVxkLmKkllbV@@LXbxlaLVVVKXXV@@bVlKV@ln@¼°KXaU@Ulw°JXalIUaÝWXW@kVU@VUVWUUUamUw@aVamwn@VUUlLXWm£@wÇĉkKklmLUÒ¯Wn@ğ±kwmaWm¼U@@LUV@V@XVUnVJLW@XXWbĸºVzXJVXV@@VXlWn"],encodeOffsets:[[112399,31917]]}},{type:"Feature",id:"500102",properties:{name:"涪陵区",cp:[107.3364,29.6796],childNum:1},geometry:{type:"Polygon",coordinates:["@@nèVblĖVVnL@xVn@nJ@LUVVX@lbUJV@@nn@VVVK@zV@nzVJVUlmX@@_VVVbnaVal@@knW@wnaVK@aVIJ@£kUVW@wXUVJam@Ik_X¥@WwkKkwmkUxnÅmm¥WV@Um@UlVL@JU@@X@UVkKVkKVkKkb@bmJVXUVVUbU@@`W_UV¯b"],encodeOffsets:[[109508,30207]]}},{type:"Feature",id:"500230",properties:{name:"丰都县",cp:[107.8418,29.9048],childNum:1},geometry:{type:"Polygon",coordinates:["@@Þè@XUK@LlV@blbUJ@V@bnV@VVVXU@lbXal@VXnKV@maXUÞ@amk@aVKXVanb£°mnIVaUKVwUmWLUU¯V@@KUK@IaWmn_VlK@anXVaXWWIXWl_@LUWVIUmVaUUUK@UWI@Wn@VI@mkU@U¯Kl@ImVÅLwU¤óbUU@wWXkmm@LU@@VUIWVUL@JUnax@JnbUIWVx@UXlV@¤IUJ@bULmb@xmX@lk@UbmbUaUU@`W@kn"],encodeOffsets:[[110048,30713]]}},{type:"Feature",id:"500232",properties:{name:"武隆县",cp:[107.655,29.35],childNum:1},geometry:{type:"Polygon",coordinates:["@@lwbVm@IVKXUVJ@UV@@KnnWlX@xVVôaV£xÆKnUVm@UmIXm¯¯@WkWVwmkXlaUwV»ULmk_VkK@ÅWa@aUU@mkaIb@n¼nm_@mmK@ULUVVmI@aUJ@XWJ@U`UIkm±kk@@lULmUmKUnVnlUVmI@VkVlxbkIVmLUxkKUXn¦ÆnmVwlnlxlLXx@W¦`"],encodeOffsets:[[110262,30291]]}},{type:"Feature",id:"500119",properties:{name:"南川区",cp:[107.1716,29.1302],childNum:1},geometry:{type:"Polygon",coordinates:["@@VUbVJVUn@VLX@WVXVVI@VUVWxU@m@ĊX@@¼V°aVUX`@_V@VaUUVUWnI@alaLUlLUllLVU@@WV@@IUKVkn@@VlLVwnKUlJakwlU@UnJVUmkUVmXa@wVK@UUw@VVI@ak@alInwlKXUmaUW@wWLkKVak_ÇaUV@XbLVxUlWIk@UK@V@kU@VbUVUlVnLUV@lVXmxkV@L@V@Vk@WbUwmL@JUI@xVxkx"],encodeOffsets:[[109463,29830]]}},{type:"Feature",id:"500241",properties:{name:"秀山土家族苗族自治县",cp:[109.0173,28.5205],childNum:1},geometry:{type:"Polygon",coordinates:["@@XlV@lzn@VnbÆbXKlLUÒV@@llUnxll@z@LU@@V°b@Vn@l@VÑUnK@UU@aUakVm@K¯wklmnnUl`nI@almkIUwmWVkUakkJmUUa@K@aU@@_m@@wUyVUUa@Um@awl@Wka±UkUykIWVb@bUVk@aU@UXUUIWakUWmUxUV@nUVWb@XXVVmXX@VbVLkVWx"],encodeOffsets:[[111330,29183]]}},{type:"Feature",id:"500114",properties:{name:"黔江区",cp:[108.7207,29.4708],childNum:1},geometry:{type:"Polygon",coordinates:["@@VX@V@LV@VJUL@lVnnxlb@VXVXV@@W@UIVK@kUKna@£VWUaVUUalIVJVIUW_lm@bXKV@mn@JUUw@KnIVll@VanLVmUkVKXLVKUIVamw@UaU_lwKlwUWV_Ua@aUa@KUwm_Ó@wU@nkK@am@UkUKmXk`m@@I@K@I@mkVmIUxUJ@kUL@JVVlnklWnn`VzUVnlWbkb@WxXxlJXzWÛlWXnl@Ll@Vb°UJWLX@VlV@bkJ"],encodeOffsets:[[111106,30420]]}},{type:"Feature",id:"500117",properties:{name:"合川区",cp:[106.3257,30.108],childNum:1},geometry:{type:"Polygon",coordinates:["@@XKVXlKVL@UnV@aValXXKU@WVwUaVU@IV@@aVWL@U@anVV@@bVK@UVL@bnJWL@VnUnb@@JnIlVl@@bXIWbn@UKVLVKXLlaV@VVnK@bVLmIV@KmknUUWVI@aVJ@_WU_VmUwU@KVak@am¯mJU_UJUkU@WkIV`UI@JV@LmmU@@mbUzÅ@VK@nUKbakb@UWK@bkVVbVÛ@@`Xk@W@n@lXL@bmb@VVJUn@JnUlnUlmX@`XLlbkJW@kzlb@`@b@b"],encodeOffsets:[[108529,31101]]}},{type:"Feature",id:"500222",properties:{name:"綦江县",cp:[106.6553,28.8171],childNum:1},geometry:{type:"Polygon",coordinates:["@@@¦@XlVX@@UVKlVUX@lanVlUVbXWVXVVVUnKVUlwUwU@UJ@nmVkUVlwXam@VaUUUw@W@kk»mV@UmKkwVKVUU@@LUKVI@mV@XVWxnXVKUUUK@wWU@UUWnUlLXamUIam@wI@K@amImUUkI@makUkKWUUan@wamLVxk@UVmUUL@Vm@kV@I@ak@@bWVXJlLVbVL@@bn@@`Un@WbUKULWVXb@UVmbXWVb@bVmxUKUV@Un@V@V@nmnKlnnWWXX@lKkK@aIVxUlVbk@mn@@U@mbVUV@VLUJUXU¤"],encodeOffsets:[[109137,29779]]}},{type:"Feature",id:"500233",properties:{name:"忠县",cp:[107.8967,30.3223],childNum:1},geometry:{type:"Polygon",coordinates:["@@VLÞĊU@W@¼V@lk@w²mlVUllVnI@VlKUUlIVXUVJVUwl¥UkUKUIm@aU@mUna@XUWmkK@aVIUa@aUVmIXa@Kl@UUVKUIUJmwU@@aWInUVa»k@@l¯n¤mabWUUL@bnl@bÝWVnbU@mLUWk@Wbka@WVUU@UmUmVkUULVlVUxl@L@VbÈÒlb"],encodeOffsets:[[110239,31146]]}},{type:"Feature",id:"500228",properties:{name:"梁平县",cp:[107.7429,30.6519],childNum:1},geometry:{type:"Polygon",coordinates:["@@XLV@VV@b°°nnkb@bnJWVXblIUVxWnUJnVVLVUJlUnLVK@UnUVJ²nKVbVKla@aXlJkKlb@U°£KVIUa@@kwVVUkKV@VUkkUVk±n@xkl@U@»@XVÝĉUJnxWb@UXKkVUbUKWUkVmkkLU`b"],encodeOffsets:[[109980,31247]]}},{type:"Feature",id:"500113",properties:{name:"巴南区",cp:[106.7322,29.4214],childNum:1},geometry:{type:"Polygon",coordinates:["@@nxnVlJlUXL¦@x@Vl@nKVVX@V_V@@KlVXU@lKlxXIl@ÈĊ@Vl@n_VJlnVlnb²VVVJVVmUUkĕUamçU@»W@@ĉnV@XwVU@UUJWUXUW@UKm@UVUIVaUUVmLUVUUUWWXUakVmUkbW@UVkUL@VW@kUW@mJUXVVU@lmV@zklVVkLUl@¦I"],encodeOffsets:[[108990,30061]]}},{type:"Feature",id:"500223",properties:{name:"潼南县",cp:[105.7764,30.1135],childNum:1},geometry:{type:"Polygon",coordinates:["@@@a@a@_kalyX@lIkaWK@_nWVkkmmV@IVmUI@Una@aWK@k@mkbWaknmJUk@mk@@kUal@Ua@Wa@aXLlwUKlkk@KmI@VUJ@Lk@@VUUmL@amJU£kKUaWakLmU@bVVUbnbWV@xkL@bUbxUxVbXJVbUVWIUVU@kLWxkKWV@n¯VUbU@@VVX@VmaUL@VUK@VVbn@lVnI@@lnLULm@Ub@l@na@lK@XVVkJ@b@zl@@VnV@bVb@J@bnXV`lXXmVI@W@InbV@@aVKUblKVLUanLlmnLlK"],encodeOffsets:[[108529,31101]]}},{type:"Feature",id:"500118",properties:{name:"永川区",cp:[105.8643,29.2566],childNum:1},geometry:{type:"Polygon",coordinates:["@@@bÜnWVLXlxVVxXxlVn@@bVblK@a@UnLVJV@@UnLVU@VXaVKVX@n`WUÿ@IUKlaUUUkWyUÛÅÝ@mmkUKUwW@Xk@amUUakKWwXaK@VVLklXVlkxVUL@bm@Vxn`IVxUVkLVUl@@lkXmmVUn@VV@Xb"],encodeOffsets:[[108192,30038]]}},{type:"Feature",id:"500231",properties:{name:"垫江县",cp:[107.4573,30.2454],childNum:1},geometry:{type:"Polygon",coordinates:["@@Ċ°¤nÒ¼aV_lKnllUXVVLValULVW@XamwVIUKkaÇÑa@U@KkVwkUUVKlVnU@aU@VIka@akU@KVL@WÝçUV@VmbÅ¯@LKnnJWVkxlL@VX@VxmnXVWxUb@bkn"],encodeOffsets:[[109812,30961]]}},{type:"Feature",id:"500112",properties:{name:"渝北区",cp:[106.7212,29.8499],childNum:1},geometry:{type:"Polygon",coordinates:["@@@bVVXLa@lnbWn@L@XVlK@VVLUVlbkLUKVVVL@VnXVL@VV@UbVb@x@¦UxVb@bUJL@LVVxlK@nk@U@WUVLlKXV@VblU@UUKVU@wn@VJVanLlkX@VaVK¯@a@U@U@VaUKkUU±maUkm@UUkbm@@Vk@@JwU@Ub@I@JmwUL@a@@KkVÇLkWk@kUU@@xUVmKUnllUb"],encodeOffsets:[[109013,30381]]}},{type:"Feature",id:"500115",properties:{name:"长寿区",cp:[107.1606,29.9762],childNum:1},geometry:{type:"Polygon",coordinates:["@@VVUbXlX¥l@XnVmlxUx@@blVnnôĀlm@aVaXwWUnmUwW@@UkKlwUXmImL@KÆ°na@UUImyU@@yULUUm@@mU@VIkaW@UUV@KI@mmUw@mKUnUUIlVLUb@@V@V@b°ULUbW@klmKUbUIm@@xUVVL"],encodeOffsets:[[109429,30747]]}},{type:"Feature",id:"500225",properties:{name:"大足县",cp:[105.7544,29.6136],childNum:1},geometry:{type:"Polygon",coordinates:["@@XUmaVaUU@anVlKXbValU@aV@@IXK@@bV@VxVK@UXLlUJXa@_@@aVKÅWVkwWawUa@am@kUWLU@kWmX@ykI@W@UV@na@LlLV@UkwWUKmXX`mIVl@bXLWVkbkkx@`VXm@@J@U@UUKUxk@WbUIVl@VXLWJUkUlUImxXlmb@X@VUJUnVbW@UV@@VVX@bnW@LVxUnlJUV@n@VxVIn@l`UVVVL"],encodeOffsets:[[108270,30578]]}},{type:"Feature",id:"500224",properties:{name:"铜梁县",cp:[106.0291,29.8059],childNum:1},geometry:{type:"Polygon",coordinates:["@@VblLV¤nI@bnKVV@Ul@@KVI@UnJ@LlklVLkxWK@bXb@Vbk@Vb@ll@@nVlnIlmXblaXl@W@_Ü@UUalU@aXL@VlabaVL@mUL@UUÇXUWX_WaU»m_@UWULWb@UUVmK@VU@UImK@V@bkLxXblxXUÆUL@b@@`WbIkVWK@VULUwU@@a@WL@JU@@bkVUb"],encodeOffsets:[[108316,30527]]}},{type:"Feature",id:"500226",properties:{name:"荣昌县",cp:[105.5127,29.4708],childNum:1},geometry:{type:"Polygon",coordinates:["@@VI@U@WnaWknwVJVkVlIXWK@UUkVJXal@VwVL@V@V@In@UW@_wlllaXUWK@aUknJW_Û@aWaU@@UVmUUaUImJVnÅUmVUm`kUUVWLnVU@VVmXK@nxmULkxImJ@nU`@X@Vkn@`@nlV@nVJVaXVLnK@bVV@nV@lbXW@"],encodeOffsets:[[108012,30392]]}},{type:"Feature",id:"500227",properties:{name:"璧山县",cp:[106.2048,29.5807],childNum:1},geometry:{type:"Polygon",coordinates:["@@XzVlVVkbVL@JVĀX¼VXbW`XWVÈVVVkV@@UXa@alK@IU@UKWUyUI@wVUUWVak@VUkW¹@WXI@yVIUK@kWwkÑ¯±W@kUb@KkVVVmXJ"],encodeOffsets:[[108585,30032]]}},{type:"Feature",id:"500109",properties:{name:"北碚区",cp:[106.5674,29.8883],childNum:1},geometry:{type:"Polygon",coordinates:["@@XVLV@@JkL@bWb@VU@UlÆVya@nV@nn@KU@IVJU_lJXV@VlVIV`nIn°@blUbKVI@aUaVw@¥@wUaVaU@@UUKWm@UUKUUVLlKkaVUUK@UkLWU@@KXmma@kbWKUU@aUamLnÞ@VWLk@@Wm@ULU@@UKUVWI"],encodeOffsets:[[108855,30449]]}},{type:"Feature",id:"500110",properties:{name:"万盛区",cp:[106.908,28.9325],childNum:1},geometry:{type:"Polygon",coordinates:["@@VIV@@wVJ@InKVxXal@@U@U@KlUnwUW@kVUKUmVkUa@I@KW@@bk@@mU@m@k@a@aIUxmJk@wULwkKmVVX@VXV@xVLVVULmWXwWUU@@nUJVL@KV@UVULlxnL@VnUl¼@l@XVxVVUbn@WbkxUlVnU@m"],encodeOffsets:[[109452,29779]]}},{type:"Feature",id:"500107",properties:{name:"九龙坡区",cp:[106.3586,29.4049],childNum:1},geometry:{type:"Polygon",coordinates:["@@XKL@V@XbV@lW@UV@@VXIV@UVKlL@KnnJ@VV@VU@I@@mVUVWUUmL@V¯LUK@UV@UU@a@U@yU@WLUK@X@KUVmL@@aXI@w@ammVk@WÛwm@UxVVVbVLUJVxVUV@V@X@JUIVbm@@Vk@@VkL@lVLUJ@zWJ@X"],encodeOffsets:[[108799,30241]]}},{type:"Feature",id:"500106",properties:{name:"沙坪坝区",cp:[106.3696,29.6191],childNum:1},geometry:{type:"Polygon",coordinates:["@@XºlUVl@UbVXUV@xVJVzXJVUL@VV@VKn@@Xl@XK@UmÝnKVbVakkVm@kUK@UmIm@LkKULVU@WJ@UU@@VkXU@Wa@@UKWL"],encodeOffsets:[[108799,30241]]}},{type:"Feature",id:"500108",properties:{name:"南岸区",cp:[106.6663,29.5367],childNum:1},geometry:{type:"Polygon",coordinates:["@@VVJVL@bUVVnl`XIlwXJlw°nnlIXW@UÇĉk@WJkwkL@WVkU@LU@U`W@UXUV@n"],encodeOffsets:[[109092,30241]]}},{type:"Feature",id:"500105",properties:{name:"江北区",cp:[106.8311,29.6191],childNum:1},geometry:{type:"Polygon",coordinates:["@@nLVU@wV@lV@XllÈKlU@L@@bVKnx@I@JVaV@x@Il@@Un@laVVn@mkUIm`k@WXJmk¯mkxWIkxWJk_UmVUUK@UU@@l"],encodeOffsets:[[109013,30319]]}},{type:"Feature",id:"500104",properties:{name:"大渡口区",cp:[106.4905,29.4214],childNum:1},geometry:{type:"Polygon",coordinates:["@@k@@U@w¥WKkVkImUmwa@b@xWJ@b@nKVU@L@WVLXKV@@z@V@bVVU@@VVL°K@U"],encodeOffsets:[[109080,30190]]}},{type:"Feature",id:"500111",properties:{name:"双桥区",cp:[105.7874,29.4928],childNum:1},geometry:{type:"Polygon",coordinates:["@@WwUwU@kK@KmbU@@V@XlJ@znWlXV@XK"],encodeOffsets:[[108372,30235]]}},{type:"Feature",id:"500103",properties:{name:"渝中区",cp:[106.5344,29.5477],childNum:1},geometry:{type:"Polygon",coordinates:["@@VL@VV@VL@aUKIUU@@JUVU@"],encodeOffsets:[[109036,30257]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/64",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"6403",properties:{name:"吴忠市",cp:[106.853,37.3755],childNum:4},geometry:{type:"Polygon",coordinates:["@@nLV@VLaÞbn@@l@bUVlUVzVx¤kÞVèXn@nm°a@UÑ@VXnV@VaUVKUUU@@U@@KVa@U²@wXkWnk±lLnU@UmmVKnIVWnI@UK@UK@@UVKXkmWLWUXmlkVwUyVa@ww@aVIK@aVÈwKlLVV@LnVVVnUÜ²°WÈIUÆ@nÞ¼@¦@UÞUVW@UxUxVnbKb¯ÞU`VbǬV@XXÆVVl°InmnUô°¯anam£WVXKXmkôaVU@Vak@@wman@K@UÛUWKXUÇ@UIb@alW@akLUKV@@Ukw±InL@kmwkWmk@JUIůVmnnU@m@UKVKlkUwknVUKmbkI±KkmVkKb@U@aVkUmn`kIlaUK@UUKmbUIÝUa@mUa@am@UUULUK@bmKkbWI@WXwlkXWa@k@kKLVkkK@L@JUVmzUKlwUUnW£XVlKUwVU@aXI@aWaUw@W@_nam@¯UkWVkUWaU@nwmJkUVkWVUmUkJ@ImbUa@@WÅ_mJknmak@@mXaUV@xU@@VUnkV@Vn@`ULUbWLXVW@kbUJ@XW`@nÅĖWJ@m°@xxbnUaw²lÞ°xŤIVVULÛWbbkVVXÆ`UbVL@kx°LlV@VWbJn@bl¤ULV°@lmL@£U@@aUwmKULVxUVVx@@kU@mK¯LÇa¯@"],encodeOffsets:[[108124,38605]]}},{type:"Feature",id:"6405",properties:{name:"中卫市",cp:[105.4028,36.9525],childNum:3},geometry:{type:"Polygon",coordinates:["@@°@Èb°KnL@lV@@UwVUUwVKnLVx@bV@¤@nK@k¯UVKk£@amIXa@UkU¯Klw@UKVaÅ_UWlUaXaÜVKUUţJ¯wÝ±kxVbmaw@wn¯@XIÆĕm@X_@WVIlaX@WUXKVaVK@_Um@lUVm@U@Vw@VUÛwm@@W@ImKUkU@UaaX@wWaUKkw@UVaUamLUnk@»±`¯@kW@UaykbI@VWJkLWUkJwU@n¤mL¯wm@Um²XVWbnV@bmxVkxUblLUV@kVWKU¼kU@mn@JnV@bUnmJUn@k@XlxLVVnKlLVV@@LkKULVbk`WL@lkXW@kV@UÞUlÇXlkaUbmV¯@@L@V@bkb@xlWbbW@±@UJ@IU@mVkVxV@@lIlln@Vm@VUbl@JLmKÛXmVkUKULU`@LĉwKUXlVUl@VbJX¦̼bÞxŎxɜĖĠŎaô@"],encodeOffsets:[[108124,38605]]}},{type:"Feature",id:"6404",properties:{name:"固原市",cp:[106.1389,35.9363],childNum:6},geometry:{type:"MultiPolygon",coordinates:[["@@Vnn@°xnK£mV@xlIXVlKXI@UJlazVbX@l°@²_@¼mlVnKVbUb@VlxVLXb@xWbVbV@VlnL@J@Xn@ÜxbW@nl@nblmnIÆ`@X@Vbna@aVUUWVk@kbWakbU@VwW@_l@nmn@@alVlk@UkmVak@@aUXaL@¯@KVa@axWI@KnkVaVJn_lJ@X@m@nVanUVb@mXLlJVWnLlaVVaVX@KXVVkVKlknKVa@aVU@KXb@klJUknUm@K@_UW@alIUamaU¯kJma@IUK@U@@UW@@aXLVVJVaXIKlaUkUV@ambUUJkIWJ@wUIV@JU@UwV@@Um@nU`@UkUmVUxWUUV@aÅb@aWXkKUUUUaWK@wnm@IVU@aXwm@UmVaUalk@anKUwlUwlkK@wmaUkmmIk@VmkUUbW@UVUnW@kV@xkVmbVnU@UbUV@ak@kkW@kLW¤@nV@VU@W_UVUU`VLUV@IUVõVULU@UUUJ@wmkUJ@WI@l@bkKkbVVbVbUL@UUJ@Vm@@L@xbVVVLVlVwX@Vb@bmUkbk@@JWIUVÅw@Km@UkWKXxWLÅ@UVUnWK@xkVW@KULwWVXVWzXVVKVXkVV@VUbV@UVV@@LXxVL@VbLnKVLVxXVmb@l"],["@@@J@aU@LWK¯UUxVVn@ĠLUW@UbUUUa@KUX"]],encodeOffsets:[[[108023,37052]],[[108541,36299]]]}},{type:"Feature",id:"6401",properties:{name:"银川市",cp:[106.3586,38.1775],childNum:4},geometry:{type:"Polygon",coordinates:["@@UwVK@UVWÞUbwV@knV@@KU_VK@Kn@W_XWlL@Vn@Ċw@Ula@Wanamī@a»ŋó@aÆÅɲÿUaV_°ÝaLaUmVwVwX@VUVÝ@@¥Ý»@mVÅÇJ¯XÛ±VUmUmU@KUUkKLÇxU@bLUJ@bx@xUbVzUxklWnXVKnXWlUL@V@VL@VL@mJUXmJULnn@VmVkK²mlXWlx±@@VUb@L@@VV@VVULVUbU@WmU@Ò@V¯bmn@V@lVnUnVWXVl@¦VVUn@x@XL@¦lXxVb"],encodeOffsets:[[108563,39803]]}},{type:"Feature",id:"6402",properties:{name:"石嘴山市",cp:[106.4795,39.0015],childNum:2},geometry:{type:"Polygon",coordinates:["@@U¯ķó±ÇÛ¯ķmbXb@kb@Vĉxm@@UkKWXX`m@@LULV`@L@mU@lUxaÝVUX@VULxVkLWV@JnVLXVlUV@zlVL@V@bn@lU²WVLlLVbUVxUx@xǀLxôÒkK²VaU@wXa@WÈĉUa@bÈkm@¯"],encodeOffsets:[[109542,39938]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/46",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"469003",properties:{name:"儋州市",cp:[109.3291,19.5653],childNum:1},geometry:{type:"Polygon",coordinates:["@@à®¼jpnr``pRVHÊÌ¤Zt^JÖA[CâlTébQhRPOhMBcRSQiROE[FYdGNOEIH]MgEAMLLIAG_WMCSL@ED]PCLYC[ZIHgjSxJTMbHNEFCMEE_HSDFHSLECRNSFDRICHNADGPI\\RZGIJTIAHLDQOHG`GTNCOIC@eIGDWHIS[kiE[FMbECZS@KKS[FDWsCeRuU_DUQNOE[LKGUBM¨EDQP@HWHGDImXCog_~I_fGDG|QDUWKBC\\ore|}[KLsISBHVXHCN`lNdQLOnFJSXcUEJMCKSHOUMDIm_DI`kNDIGEYFM\\YPEEIPMSGLIKOVAU_EBGQ@CIk`WGGDUM_XcIOLCJphHT_NCISG_R@V]\\OjSGAQSAKF]@q^mGFKSW^cQUC[]T}SGD@^_aRUTO@OHAT"],encodeOffsets:[[111506,20018]]}},{type:"Feature",id:"469005",properties:{name:"文昌市",cp:[110.8905,19.7823],childNum:1},geometry:{type:"Polygon",coordinates:["@@hĲ¤Ī¯LQDaFßL[VQìwGF~Z^Ab[¹ZYöpFº lN®D´INQQk]U[GSU©S_­c}aoSiA£cÅ¡©EiQeU­qWoESKSSOmwćõWkàmJMAAMMCWHGoM]gA[FGZLZCTURFNBncVOXCdGB@TSbk\\gDOKMNKWQHIvXDJ\\VDTXPERHJMFNj@OwX@LOTGzL^GHN^@RPHPE^KTDhhtBjZL[Pg@MNGLEdHV[HbRb@JHEV_NKLBRTPZhERHJcH^HDRlZJOPGdDJPOpXTETaV[GOZXTARQTRLBLWDa^QAF`ENUPBP\\Eji`yºEvåà"],encodeOffsets:[[113115,20665]]}},{type:"Feature",id:"469033",properties:{name:"乐东黎族自治县",cp:[109.0283,18.6301],childNum:1},geometry:{type:"Polygon",coordinates:["@@ªVLP`@PEdNRAHOPEAKHEVL`GZBJfvdTAXNNTZJFPrHHNpKTD\\ILHbEVd^JOHLh@NNBnHP`\\xH@NBRLJTlNv_^CTLd@bNDVFbxdFVUPBTKOGEOUO@OEBXQP[H_EI\\EbeYa@UO_JMEJ_IEDKJUGMDcNUd_FMTEJSGoZ]EIYGO[YWgEQ]a@WHEDQKUSDUGAbYBUpSCYNiWqOSQEoF[UcQISWWNMSDe_cLQ_UBiKQOOASQAWgS­ā]ZaSPÝZ]XMXS[^oVËNgNKlE RôEø"],encodeOffsets:[[111263,19164]]}},{type:"Feature",id:"4602",properties:{name:"三亚市",cp:[109.3716,18.3698],childNum:1},geometry:{type:"Polygon",coordinates:["@@®ĂhTBXTRPBRPjLVAR`dKf`TCNXMTXRJVdE\\FpTRrPjXZMTDVoZABaVHTCLVCRGF@X^bFRhZXP\\ZHHMA[^wBWXJlW¤EJ[bCTOFWWMm@ILMGWQ@DQ^QNWFSHEbF`OXNbOVNKTEPDTLTCCVTREfvfEHNbRAENH^RJXCFHNFRpVGHWISDOTMVCZeGamaLoLÛD¹¹ėgsia{OųETtlÉwr}jR±E{L}j]HąKÃT[P"],encodeOffsets:[[111547,18737]]}},{type:"Feature",id:"469036",properties:{name:"琼中黎族苗族自治县",cp:[109.8413,19.0736],childNum:1},geometry:{type:"Polygon",coordinates:["@@bRFnHNbHgN@NPEnbXP@bND`NT\\@\\QZb@`@J]V@XhDpWnCJGHGXO@CR§FANHVKLF\\MPVR`CvVfQtDPKpGHG@S`WJP~^dSTHWX\\RHTFACQTIAUPOU@MG__IaYSFQKNSbORHXCZeTFJgB`YBMNMFi~IVDV[tGJWXGDQRGF]JrALgESLSAYDGIaFeXQLS\\MKSLSQYJY}eKO[EHiGSaK[Yw[bmdURgEK^_kcSGEOHKIAS]aFSU@Y]IWFUTYlkP_CUOUEkmYbSQK@EMWUuAU\\M@EpK^_ZMDQ^OXwC_ZODBrERURGVVZ\\DTXcFWNIAWJWAYUUFYEWLQQaCIZeDM`cLKRGpanJZQd"],encodeOffsets:[[112153,19488]]}},{type:"Feature",id:"469007",properties:{name:"东方市",cp:[108.8498,19.0414],childNum:1},geometry:{type:"Polygon",coordinates:["@@ºxJYZQIYXLl@dR\\WZEn]bA\\S~F`KXaDeTiNO^EEKWEDQXITBXaWaDQMUJOIaTWf@NJV@dSxGZFu_@WMKAU}AQ@MwG_[GOAmMMg@GKP]IUcaFKG[JSCoLGMqGEOYIMSWMSBucIeYA_HUKGFBLOFGPQBcMOF_@KO©UAtERadwZQ\\@ÊJÒgòUĪRlR°KĮVLJ"],encodeOffsets:[[111208,19833]]}},{type:"Feature",id:"4601",properties:{name:"海口市",cp:[110.3893,19.8516],childNum:1},geometry:{type:"Polygon",coordinates:["@@ńZƂtĢ¬æßFuz¹j_Fi[AOVOFME_RBb]XCAKQKRSBQWSPY\\HbUFSWSPoIOcCOHIPkYCQ]GdGGIFQYgSOAQLK`MFUIGa@aQ\\GGUFcHKNMh@\\OYKAigsCgLSF]GOQO]@GM]HyKSHKPW@Pxi@EMINYREXWRQ@MQcFGWIAwXGRH\\yDI`KJIdOCGRNPNtd\\UTMbQYi@]JeYOWaL[EcICMUJqWGDNZEXGJWFEXNbZRELFV]XQbAZFrYVUBCLNFCHmJaMIDDHXHEhQNXZ_TARFHVB@DTQIRR@YHAJVnAbKFUEMLd\\c^ÍÞ"],encodeOffsets:[[112711,20572]]}},{type:"Feature",id:"469006",properties:{name:"万宁市",cp:[110.3137,18.8388],childNum:1},geometry:{type:"Polygon",coordinates:["@@^J@ZTVbET^JBGLFPTHld]`FLQhcVanx\\\\ZbLHTGj\\FLP~fIZRZPVTQFSVAFJE^NDLEE[~LjsxVTG\\NZZNGlLRRGLJTV@hPZANN^@T\\NEPPbDZXO`d^HSvcJDIV\\XZAJUFCLNP@PQ¤@[ïKLÑIÏ]ÇE±I{u­YśUćFcYUmsVeBSVgB[RO@aYYPO^]@UVaNeDShMLG\\EfFVE\\F`"],encodeOffsets:[[112657,19182]]}},{type:"Feature",id:"469027",properties:{name:"澄迈县",cp:[109.9937,19.7314],childNum:1},geometry:{type:"Polygon",coordinates:["@@T\\GJCXJH@fJDDPNCNJENN^NLHBNSx@DDYbBLLDRbjZTj@`XXTlG^Xr@PJLW\\WLTlWR@HDJTD@X_PO@STMDNTMVV@NLDM`M\\XM\\JNBH[PYZúYzŸ`Ċ\\ÎÝd]c[NKVFLEBaUmBIZGQ@JQSR@CUAEGBQ`SWYRMFgWGCGJCbNnIDGMEDKVAZUEqBYRa^WEUFKYQMaFWXEHIFWMYHCrXVIIiaK@aMCUYNSIISTwXALKH@XWXIEIJQCG[IEQDE_XSBaa[AIPW@]RS[FWS[CD]PEBYNGFSaSyJG]@ugEUDQlGHiBKHUIoNSKqHFaPMICK]UUHIPDJMuCA[SCPIDIOILGAEmU[POPBVSJDREBGS[QXWSGcT}]IO_X@TGHoHOLCX\\ELT@LYTDaFENF\\lj"],encodeOffsets:[[112385,19987]]}},{type:"Feature",id:"469030",properties:{name:"白沙黎族自治县",cp:[109.3703,19.211],childNum:1},geometry:{type:"Polygon",coordinates:["@@D\\RV]dTXELnHr]^@LETBBRTHPi^[@U`QTHDJ`MGSogDIPKdJ`WVNHCXHl_DJR@AH`FBVPUJLHKNTJOFFZON[ZEHFCJlMJ_Cn`CJVNGPLTNDFIdVTWEIPmRKMc_kDMWGGUTAtJLK~\\f{pqD[LAVXRCH{HC`eJ`}@W^U@I@_Ya[R[@MSC_aMO@aWFmMOM@haGGMEmaQ[@MESHaIQJQMckBIw[AOSKKAMPSDSLOAV_@@`KJRbKRDfMdHZERgAWVsDMTUHqOUr@VQXTT@TfgL^NH\\@heTCZaESNObHPHeZF\\X^ElM^F^"],encodeOffsets:[[111665,19890]]}},{type:"Feature",id:"469002",properties:{name:"琼海市",cp:[110.4208,19.224],childNum:1},geometry:{type:"Polygon",coordinates:["@@TP\\pATHTGlZDJGAQjE\\Rb@jVBDCN`JZ[NCNHNXbULPrP\\KNbMTLjJJRFP`pNLZz^FLRHjVPZ@hxVKbHBHMNNJFRlLzGPnNHhIrHHADcPWdUAmEMVQDSKYHY\\EhBN^HpXGNDBNNBnIßÅ_g{³So]Ã£@ORO@KMEDIVYB[WJUICudGTc]P_YWaCOOMFS[]@MMYBgOU@ISHKQQkKMHYY[MSHwUit}KF\\KFMCF]EIUBETSROUKTLT[NKTWREfJbCHBZKTFTKh"],encodeOffsets:[[112763,19595]]}},{type:"Feature",id:"469031",properties:{name:"昌江黎族自治县",cp:[109.0407,19.2137],childNum:1},geometry:{type:"Polygon",coordinates:["@@`ZĤd`òü BSPGP@VSbQ`@]HC~T^SE]N]FkW]E[fYGGOPaTMbFDYfS@g[MGK]he@SSSRW@UVqrPVGNStCXUhBFQGYNcCeLQQaLI@_`@EUwcEaCUaMc@SK]Du`MSkKI~BVNL@X`EvYwHcTU@MIe@SXJbIPNVCRXbWbSAWJCRXFFL]FMPSjCfWb_L}E[TaBm^YF[XcQk@WKZJYRIZw¹ "],encodeOffsets:[[111208,19833]]}},{type:"Feature",id:"469028",properties:{name:"临高县",cp:[109.6957,19.8063],childNum:1},geometry:{type:"Polygon",coordinates:["@@jD`hNd\\^dZädĒH´Op@ùZY\\OAGIMN[[W_NCNMKU@NUMSNCTSP@`O@WSCCI@GXQSkXKX[IK@OWqH]SkWW@_SiiYQaKCAKZaCCw@MTGAMKM]FMMIMDSM_HGHRPKCBGSJJIYH[QOJCHMBDGQJECMTDQKFGTCEGTF`NFEDMFaGSNwIiTGhYJD\\KZODC^@FTKND`XBHKJNKFBNhG^FJMPcHEZF\\QPRjQTAdgNOPgQaRSê"],encodeOffsets:[[112122,20431]]}},{type:"Feature",id:"469034",properties:{name:"陵水黎族自治县",cp:[109.9924,18.5415],childNum:1},geometry:{type:"Polygon",coordinates:["@@R]NC`YL]FoN@V[vBXVFNL@TRZalnVFVP`DlOZkVSXEE_F[EUFeH[NKTgfCbMVU^@P]ZObZP@\\QhATUfAtUasñiāEoI]eYǯ@aKmaeWuCºKÜKpnbHbYfUDSNCPJTRAHJTDJSfDNLHXC``VBNGTYCQDIXMDSP@xLNEFRNXBIpVNLXah@RgF@`qOML@LJNSPLbaHAh@Jdj"],encodeOffsets:[[112409,19261]]}},{type:"Feature",id:"469026",properties:{name:"屯昌县",cp:[110.0377,19.362],childNum:1},geometry:{type:"Polygon",coordinates:["@@\\OnVBFKHPJCJOJTDB\\vDINOCGJVVL^JDONEbrGTLpMVJLGjAHGRkVChF@vH^zIbTETMHAZOFC^\\DXT\\EffAP\\PdAV@UIYfS|S@YPICMeM@sC[_A]VQEwyHSMuNcAUlQJMVGMS@mVBZPFO\\CSFQK[LqDMACiUa@[QiFBRIHYCHkGSBS[oSOqBIE^QHCRWHIXsHU\\UC}JEjMNAN_ZAIhSEYfWDQGaPMTLERZTJb``NHV@"],encodeOffsets:[[112513,19852]]}},{type:"Feature",id:"469025",properties:{name:"定安县",cp:[110.3384,19.4698],childNum:1},geometry:{type:"Polygon",coordinates:["@@JjDNdJ\\FbKPXfZ^Ij@RZNaVSc[MsMOHQPDJcLIJ_zCG[HQxWJBHXdENRR@XQFWZQQGOFSWUCI[WCJuRGLXNMPLhCl[Ta@SqGgJMGOmyHkKEQMINMAGaGULgwY@UOGiKQ]EYyMKoO_QEIIKiNSMa[LqOKOaVMWMGMDY\\_IKrL\\ERT[DEPYOUA@nNTUHINkRBVMdNvGTxzRF^U`BD\\@tfNDNOJ@Z{TeTJZ@VUcB[OBOeeQT@^OXBJb\\AbWTF`RCJFH\\RDJIJFXW@WLGBKxWTSJJMTVZND@bbL"],encodeOffsets:[[112903,20139]]}},{type:"Feature",id:"469035",properties:{name:"保亭黎族苗族自治县",cp:[109.6284,18.6108],childNum:1},geometry:{type:"Polygon",coordinates:["@@FJp@fxpQ\\ApN\\GNPNBM`HLMrXLXj\\PEHnI@WUCEM\\GTc\\GZYHTPBHRCPTdH\\K\\@HXiBJILJJAVNTOZJNtFPC`YxDPWci@IBgbGKaTOIM@KNKrP@_hE@QbgKWUMJoWAQMFEKM@wTONCJWRCZDHSAM_UD_GWMKeCITSCGIQBGXUHQoMEEGWDQIG]FMQBMaFGueFeSQDUSDSKOCSFMLUaPWM_PaEGFETMX]RCRR@HXKN@JNnXXESPaDI\\£FkXWIAX]xB\\GN"],encodeOffsets:[[112031,19071]]}},{type:"Feature",id:"469001",properties:{name:"五指山市",cp:[109.5282,18.8299],childNum:1},geometry:{type:"Polygon",coordinates:["@@TCNOLBTLBPx\\AJdlNRRIbJTGNF\\@RcIYbmHoLQdKN_fCJYbDRRXKZFVEZVXBXIJBXMdESW[CUYHUVQFQAqsEIMPYMSBUIIJKAIjGW[@[LGScDOGQOAGSYZ[HSd[HFNVD@XmJFG[OWiWKNqGKN_MAMO[HoM[BoRewo@Y^HpITSFENc`MVCdHNIVCLJFI`NFIP`@VZbaf[FFJG`O\\WRFA@PVPFPPH"],encodeOffsets:[[111973,19401]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/71",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"7100",properties:{name:"台湾",cp:[121.0295,23.6082],childNum:1},geometry:{type:"Polygon",coordinates:["@@\\s@pS}aekgKSuSsMß`¡CqZ·be@Q^o@gieMp]}}Ľc_Kk{ùA¡r[uom@ÑĥJiq©mŉq¯Bq]ÙYgSåk_gwU­isTEĕiqiUEkue_OSsZaWKo¡­qycY£w}ĩĕS§Z©SN¥SyLÑ¡±Ks^IYPdY[UoFp}´\\¬\\j]eÜò¤¡ā a\\bnUãº¹Ìs¼j®[cíȈEĝĆ`ļf¶®K|VØDdKGpVnUFjpHF`B[pMºxÖjbpÎxp¬|ÎŸÜÒC²®ÜApZG~dÞàV¨|¸`|²tx~\\~|dFf^zGĄŚhdL\\hĸ¼OªP®lV`p\\]Xpllæ¤CpQ|oF}fMRiNSon_²qämMNM\\"],encodeOffsets:[[124853,25650]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/11",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"110228",properties:{name:"密云县",cp:[117.0923,40.5121],childNum:1},geometry:{type:"Polygon",coordinates:["@@vIHZDZQtDLNMXIbHRCXXITbJ@H`LGPRDDJNCLHTOCWFGvGBUJMKGFO^IHWXITQCIY^AXGfRDXF`DJOLB~G\\DZIHHpErUVMhHb]\\MBVF@FTP`@zTbD\\@~M\\K`H^EVODWICAakAQXoIcCOCIgGYNWFWNGGKKGaJEGMEIKYJUT_J_Go@_SyQaSFMEGTcYOQLIIi@EKAUPCV[EEXQCW|aMUMAaYCYNIDGGACIMGGSKDQGaF_C[GaB@GOIiOKAYLmI@CN]F[SWWAcKKI@HMUimEKbeYQYISNUOcBKPIFBNgvDPGZYFSf]CMSIWGEUFgDIQ[MeDMJS@RR@LphFPCHaBAJKF@J]IBJO@HlO@@RKAMPJHCNDJTHFP@ZGNANBRFH@J_fM^ONJNF\\VTDJHDON@XRND\\XRCPVETCLBVKDFJINHRGPRV@\\CLJN@VbXbLVT"],encodeOffsets:[[119561,41684]]}},{type:"Feature",id:"110116",properties:{name:"怀柔区",cp:[116.6377,40.6219],childNum:1},geometry:{type:"Polygon",coordinates:["@@JHTVHXCHPfnDJGHNDJSB[JSBGVSAOH@PMPuDEHHXZN@PHF@ZLJ@LHVYJA\\OFWP]BMtMBSRGV[JeVAPQVIFENMD¡@^NV\\JH@NNL@NM\\kTQ\\I^FNIpBHGTBFFAZQfKDIXQTLXFXNNVMVHRGpCFLlRLEVBBH`IVO\\G`RDPAXLXBXORHZEHTDLLN@VGTMrQNFPeASKG@GMOAKBYMK@GTUHUXSHMVDNMOUEOZMJML@^KRACMZEZMRQLUHE@OFENPR@DI\\ChMHIDG\\GJMDWHCKGMDCIQCHO_K@GaIJSWWQDaGWJMNCKRsCYGYuJUSaKaW@UIMDK@[QUHOGQJMEILCAUDKFSOUQD[WMCQ@WPMGCCIUSE[IMPMN]`e@IEGAQBMHM@YEOSGCIDMIGNOLB@QP@GkP@AI^J@ILEBIbADGEOog@KQQWSekWQQUOFKZLF@PUNmIaHIUeBCTSHENcJa@_IWSaGu`GLSBKJQFOXGDXVQVOBIHcDSJWBEFGTMH[^mLaXcHiKElTRKtFXZ`MHMPCNRDxZB\\ICIHK@KHbIVFZ@BPnGTGbDXRDJaZKRiGEFSFEJhjFNZFjn"],encodeOffsets:[[119314,41552]]}},{type:"Feature",id:"110111",properties:{name:"房山区",cp:[115.8453,39.7163],childNum:1},geometry:{type:"Polygon",coordinates:["@@h@bl@HRJDZ``TA\\VVD^H`\\pF\\J`JGv@ZO\\GPSTEjPTR`FnEbDTDHEhLFMTK@ETSPULKEI@OVISKSJACEQNQbVIXGDIN@dMB[IIBcN]ZHNLP@XOWCFWCNRHTpATD@^NVNLED@Rh@jCEF}E[OOHUEW]W@QGGDIQSH_MmFmCUT_K]i@MHCMWFCFE{BMHMPOHKS]CFNGBELDH_@BcAKOACESAOBELaXAROB@FODMEDWJAG[aE@UM@DImEWJMC@OeCA{aE[@{L@MINUCQXKfUJORCHqJBF@TCXWNQX]M[EAJO@@KMBQJIC]EWMCCUBEBFHKDOTMBGNGF]MWDBRDdMDQVyE@LPVHDCP@JVVMTG~HNSH[CmRUvHPHBbA\\PTNRC\\YNJPRARPJDDR"],encodeOffsets:[[118343,40770]]}},{type:"Feature",id:"110229",properties:{name:"延庆县",cp:[116.1543,40.5286],childNum:1},geometry:{type:"Polygon",coordinates:["@@^AXOPEB[ZIGU@KKI@YGE@OYMGWFGvCNO@OPGTBHUTA\\ITACIGMIHmCOeDGGWSUIGimYEEMgiFITEFEjHLQbYCIWQaCSHmHAOY@UEaJG@LGLDJ[JAwYQCDMNONGY_EWLsSQFkMO[NWAIGaIYL@HMBOKiOQDWEUDMQSF_QIUBWdg@[NaAKQ@M]OQ@WhgLUMMFYQDIRCEUZOOCIOJ[KIUMKL@HIDKVEBM`HJAJSJUdBLGNEdMBMO[BYEWJSNKNaD]PE\\SjOT_RQVEZPpNQXfNA~lNG`@PNLp¼RFLfbdKbATUh@FSNWjGFZVLFHVA~X¨PPROfFJbNJPLFbENJPrEFNPFRHDDJdENJLVEPBJTVTHGHFRFH@PXP\\ORQHW\\BjWFDERLPPBbB\\E`B\\D\\L`@F]FCnJ^AZL"],encodeOffsets:[[119262,41751]]}},{type:"Feature",id:"110109",properties:{name:"门头沟区",cp:[115.8,39.9957],childNum:1},geometry:{type:"Polygon",coordinates:["@@V@XMnGPY²JQNEhH\\AZMPDVTTDZCPiJkHSHCjIdFtEHITCNITQEKUAMCEIKCECABYESKFWAKBEIIHABGDCKCAIHMHALKEI\\CFIBILIJQZS]BBEECS@E@@C]COKI@CABAAEEDMGCH]A[M@CJWHJaUMRFRBDTITLUJ@PFJKLOVST@FSLENgKGFSCaCmF_ESQiOSFOT[HYPu@IH_[IoE_[]GUC[USB__CYQI@Gakg@qZeHQNMNV\\FVLPgJAFJPRLCH[XcPELUT[JiV_EELFTADBXRTRLJC@fHXHHbPd`fR@NfT`@TLplHMpCEJHJBVLF@JTVnG^KXDXHNVGRLRXFJVdDHSNWLGfEzA"],encodeOffsets:[[118635,41113]]}},{type:"Feature",id:"110114",properties:{name:"昌平区",cp:[116.1777,40.2134],childNum:1},geometry:{type:"Polygon",coordinates:["@@VNLJI\\JPPDYPFVQDCJZRNEVNhKXgR@^P@NLRbB\\Mh@XcVARJE`RTCNFVXRCjPPLNA@GZKbJJHXB\\MNPjLdGbWnK\\]NGHSFEXATIdCJGPARUWUHCPWRELITAHKv_E@iYCaW_BQ\\Y@QIO@QDCIGZCEMWGFMFAFgHEDOCSqKCCFGAMKEAC@ODGCGs@WH@KQA@EE@CE@GEA@EH@GGUEEJEAYD@JM@@DAA@FHD@FTJEHUC@JUBKCKG@G[CIIQReAYhO@OXGDO@@FF@IHJFCPEBACBIAAKDOABXARHPNEHGbQAAKQFGIAM[C@WHKaGiCEGOAHUKCIokSCUSOCYN[BgGMFIR±OZmHWNU@ShbbXDHVXXGJ^lZ@PZ\\Nb@\\FHJAD"],encodeOffsets:[[118750,41232]]}},{type:"Feature",id:"110115",properties:{name:"大兴区",cp:[116.4716,39.6352],childNum:1},geometry:{type:"Polygon",coordinates:["@@F\\E~DFN@BDFEpHFCHBBEGCDCJBHUDSBB@ELCPbF@B\\J@BJVAFJ\\ADKTCBGECFMT@BMN@@FH@DaNBEnvB@FPBATK@FHEFIAKFBFL@@PKBFJHC@FXBRAFCDMPDTOL@JIVFDHH@DDH@BGRFCDLD@N^@@CNA@KNOAEBCECFEGCFGMGFIPMOEJOLBADBBHGG@GCHIECY@INC@DMGS\\AIOZAAEYA@GT@KKMBEETCGMVINFxA@MJADB@FlA@HJA@NND@DFA@DVAZBBOFKH_JA@K^GBC@EFEG@gAENMXKJigC@IbSJMqGOP£RGSMGE@kbQFDPEFiBSGGSBK]I{CDWCIDOic[C_G@SuSO@EWKCO@MNY@\\uZOPENQD[LKESSKGBKEG@EJGAGHoH¥CqhifeJkX_XFFGHFNEDFPENKHM^IFIVL^S`DVEnNnG`RTCJHH@R^XFXGVPP"],encodeOffsets:[[119042,40704]]}},{type:"Feature",id:"110113",properties:{name:"顺义区",cp:[116.7242,40.1619],childNum:1},geometry:{type:"Polygon",coordinates:["@@EhEBENXHFNYDJHCD@RJP@R[ZARX`DbjZF@bHXT`Jb@dIFMTGDSfAJVbGnJVM@OKELYPERVXRflXTT@NIfC\\NJRhCVEHFJXNT^DTeZEHYCOhuAMJELOdAVPTMOWBWNMNEJgl]@WGUFIC[T{EEDEHGCIGMI@SECUQI[D{A{GQESPUH]CsiMCmHUeoHENcAaDGCMDGMQCACCBaCGLMAHB@DIEQLOAAEEJ@CW@CDINGAAGKQOCgV@LG@BEGDKNeREFBNCFIDOPKD[@YRW@GFWDAFE@EHDDrLDTCPGF","@@KrJEH[\\B@FF@CHFBHUNAJKADGECBCMAG^E@EbI@BEGP"],encodeOffsets:[[119283,41084],[119377,41046]]}},{type:"Feature",id:"110117",properties:{name:"平谷区",cp:[117.1706,40.2052],childNum:1},geometry:{type:"Polygon",coordinates:["@@ZJZRafFLjnVGNJ@LLBdXX\\T^EDMJ@nZKLBjPPJ@HbA\\H`DbERHLCFK^BZaFWXQLAGMHa\\OLO@SBIpBdCLVQfElO@GSAKEDQTC@GEBKG@ORIJBDAPDFA@CaOq@GGQAAEJK@KMUGAAGEAa@MGMBGCGSIIW@WSUCMDOJeWOM@IUF{WMWaDIMgIoRoCOKeEOEAG_I[cg@wLIFENQFDVTFJ@HNDJGHCFFFS|D\\EJHV@Xk^IhMFMNAXPX"],encodeOffsets:[[119748,41190]]}},{type:"Feature",id:"110112",properties:{name:"通州区",cp:[116.7297,39.8131],childNum:1},geometry:{type:"Polygon",coordinates:["@@FDAJTGDNDCTDDEDBBE@DT@@EHCDGJ@EIZ@@FDBR@ATFBBVFFE@@HNA\\VE@CLIFNJFNJBCP]A@LJFA@HJEDD\\C@DBCHLAEPF@@DH@APHAERDF\\GIxDTM@CFLBBFJ@CNUPMHECGDBF]BMFPDLRBHHBJMDCX@@DFIBFPBRKJF@CGANBHKbDDABDRDHNNCHDbCdBFMpGHiOYMefKJMC}HWAUNW\\NNBNAkNU|]HMTMN@MZBLFFF@RIRUTBMFIEGaAGGAOIIUGTSFcYKS@MSLYPKRUBU]EWDOI]CKGASgW@MTWKIMCS@uMAKKADMECGAKVUTSDy@IjWLMNBF@hHEF@FAD]H@LIBG`ELAPYAUB@CEB@CMC@MIB@GkB@ECAIB@NwBMEUJHNSDFFNALLS@@HZBBFYBJP[BHTCND@JMZ@FDGJHDH@GHAABCKAIPPFONEJNHEHHDEFFDADBFMP@L"],encodeOffsets:[[119329,40782]]}},{type:"Feature",id:"110105",properties:{name:"朝阳区",cp:[116.4977,39.949],childNum:2},geometry:{type:"MultiPolygon",coordinates:[["@@bFGHBHFBFIVFHHG@@FFB@HDFF@@FRB@LXGt@DHCH@PBDLFBNF@BEXCHEX@ZQ\\@LCPOJCDEAMFEfQLMHCAFH@@KhUNE^AAEHCFDNGVODMI@AEKADEN@CSJw[HCEFQGBBOG@@CE@FOKBDGCAD@C[FCGIB@IE@K^BDOIAEMMIJEDKF@[UMB@GF@EEAUEABSQ@CA@EY@FJI@CHGD@FS@@CAFCACFSCCDCMSHBIECMB@D]@@MKCDCQEAHG@CCG@CGUEIJK@SPOCCNEDQBDNDB@DJCDLFCBBALJB@BVGPBKVO@KHCCCD@FE@BNA@FNCTDDJA@FGB@NBDW@CL@hT@@ZHHQDDDAFSAANBC@HG@EFS@@DE@@PCB@Ue@CADNJB@FCBWA@LI^ix@FIHrH"],["@@HUNAJKADGECBCMAG^E@EbI@BEGPKrJEH[\\B@FF@CHFB"]],encodeOffsets:[[[119169,40992]],[[119398,41063]]]}},{type:"Feature",id:"110108",properties:{name:"海淀区",cp:[116.2202,40.0239],childNum:1},geometry:{type:"Polygon",coordinates:["@@plDJVLGPBFHjDbHGL@X\\DBNHJREBLRBHaFGMGOBQAWPBLCBBAJBDFADOIEJGE@@EP@HCPWP@ZgfBRQJJ\\D@HLHLDVA@IVDFGSI@EGC@EBB@CN@@IZCAGHGaEqGJG@EjwJ]@K@GSA@e_I@NE@CA@Kg@KC@ENCFAKQAW@WIMK@V@I@@F@^EDFB@HcIaDYCBRRDCHD@EFLN@FE@CJUPEJOJMTBPEDIFCMIAKNOGMRFJNDVBFLSRMJSDGJsFcEiJGDGTIlOjYD"],encodeOffsets:[[118834,41050]]}},{type:"Feature",id:"110106",properties:{name:"丰台区",cp:[116.2683,39.8309],childNum:1},geometry:{type:"Polygon",coordinates:["@@hMN@NFTQCFRCBJFA@HJ@@HJ@HJ\\FTACD@@UNLXJX@@MA@@IECAQlDFEHBDI~D@GXCFMVDFCH@@NF@ANJC@FnAB@AMF@@EDCDDLGP@LUOAUH@AIABKAAEDCKID@CCACMWA@EGDEILA@OK@AELEJBFEEGL@BSOA@EuAFmMACbG@@EM@ANS@ENFDAHSDCL[BEIUBAII@A[E@OaKD@FAACTGVIACDHDAFGAEDoGEFACM@ig@@QFCMKMU@]SCoBGSMQDEXXDWPO@MKYGM^AdJJA\\cNB\\G^DNHFCBFABDBJ@PL^D@DF@T@FDAF^A"],encodeOffsets:[[118958,40846]]}},{type:"Feature",id:"110107",properties:{name:"石景山区",cp:[116.1887,39.9346],childNum:1},geometry:{type:"Polygon",coordinates:["@@NQPHLMJBDNJEFCAONSPIFIVODIF@@EKMFEC@DGQCAQZDbCdJ@GEAFC@]@EJ@DCSB[EGII@@GI@@GEBAIQDDESRMEM@gNYTIRKJAJEJ[DFJKLGBGNBJLDCDAHGBJJAFBLEXTLZFBAFDLD"],encodeOffsets:[[118940,40953]]}},{type:"Feature",id:"110102",properties:{name:"西城区",cp:[116.3631,39.9353],childNum:1},geometry:{type:"Polygon",coordinates:["@@XBDA@EIACM@IJAD]BC@SFABISAD]H@@OAEDQEW@BLEMD@FLDh@@LDBF@@M`J@fTB@H"],encodeOffsets:[[119175,40932]]}},{type:"Feature",id:"110101",properties:{name:"东城区",cp:[116.418,39.9367],childNum:1},geometry:{type:"Polygon",coordinates:["@@DBf@@VDA@OF@@CT@FEH@@GADBMTBBECCRCGG@YS@@gDK@AC@PG@C^TBAJEB@TADC^IB@J"],encodeOffsets:[[119182,40921]]}},{type:"Feature",id:"110104",properties:{name:"宣武区",cp:[116.3603,39.8852],childNum:1},geometry:{type:"Polygon",coordinates:["@@RBX@RFFCBFU@aK@WA}CCJGAEFkCBRFD@JB@@N"],encodeOffsets:[[119118,40855]]}},{type:"Feature",id:"110103",properties:{name:"崇文区",cp:[116.4166,39.8811],childNum:1},geometry:{type:"Polygon",coordinates:["@@XBL@@bEVD@BX@AC@MHA@EIBCCDSEMmB@EIDBME@@MG@EDUCENWD@H"],encodeOffsets:[[119175,40829]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/12",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"120225",properties:{name:"蓟县",cp:[117.4672,40.004],childNum:1},geometry:{type:"Polygon",coordinates:["@@EUDAEI@WNMNCBFAHFFNACDJDPBD@@GD@DIFFHEFGDBDEQOFG@EI_KG@OcJQM]RMEKBGPG@[LaCIICBWKCEEG@WBQHCDFD@HSLEJI@IHWECFGAAEKCGDBFCBSBIDCKKHEADMJMFABKOKEQAA@IEEG@GIQAEK@OZEESMOLlu@SLUTYFQCMG@@SQUAYKAACA@IB@BDB@B@DC@@BGAEFAA@BEGKJCC@AGAIHA@@JC@QEIP@@A@EGIDC@O@C@@@@CJCWKABFLBBEBSQGBAAMIEM@AKBcJEN@BEBCFMAEFEF@J@BG@BFABECKFG@AFQ@@F@BEB@@A@@AAAKAE@GFGDECEFEECBKIKDELDFEDYH@EIACDCHKBEB@BAAC@ADBHABKJIAIJICEDGDCD@@A@A@DHCHJHDFEFGBKRKBGIK@GIMHSBCH_BOJECCJCFKKMD@DNJEDEGC@OJCJHRUL@HRJ@H[DCNKDZHCTFDHCFFKR`TANVDFZRDLFARB@HPAPG`ILAR@TERNDFNHDLCLDDCXDYbHF@FEB@LDDVE@JPNfXPINCVDJJD@NJPAJHLXHDNANHhB@DPNLRMTBFRBHHr@`NBFEBOCCBIAQJDHCHLHFA@HSDCRLFTB@HEFLNF@PELBDJALFLTC@EPFLLP@tUHQJDfIHGTB^JTCPDLKAIBATFPADIEGECEMJ@JIAIHGECFEAGDI\\SPOXAFCL@BQTQBBTMZECYGAHA@GJAE@HCAEME@IECFKJADDBABLTHHG@ILEAMNDJCDHEBF@@JNFJELDFKTOT@JETBFFHBHEHKI@@IJEJ@XKEOUMS@AF@CEB"],encodeOffsets:[[120575,41009]]}},{type:"Feature",id:"120114",properties:{name:"武清区",cp:[117.0621,39.4121],childNum:1},geometry:{type:"Polygon",coordinates:["@@FWôµ@IFCLIB@EHNBp]AGEAKAEDMGZKFGBGME@ILGP@HEFB@BXMEAHUGC@IHCLOD@X[NWHWPKAEF[@EKIOL@EKGBNMJ@EIEHKBIC@BAKMIACCFQZCF]DB@ERAKADIHGEIBCGIIECFaGLZO@EFCNGAGDGAKL@BMG@IE@ADSDEH[JGC@CGA@BMDeK@EIACFE@@GG@FIAMM@CCGC@EM@ADE@CFMAAGHBDKIEAJG@DOGCDEKAGIS@KFCHKAEHIE]BeKNO[IFIOELC@A]GMBKVYCDDgGAICARc@MW@AQE@DGI@@AQ@@BKBAIQQYEFW@CEADIGGBCEIiMEMF_LGEKMBBDWEBGRC@E_CHYGCH_IAED@FFBQh@FGJaJ}AHRAREF@bE\\C@CT`FHC@\\BBF@BID@HGDDJ@@FAHKBARECKDAZBJIVNHCTA@EREAMLHDAFFBVFFC@RNRETHD@FOJMACH@CAB@P@DF@@FGDWE@FFSIEMKQDYCCHKb^JADOCIDGNDBdBCFJB@EC\\A@BJEA@JAAAD@HHD@LFBCFF@BERDHNhZQHMBGHOACCEBWEGD@PSJKCGEUD@CINLFGHE@AJK@HDABBHTB@F`DBFLBBHEDARCFG@ABJBAPVFE^FBGLGCFG_BMLEXGAAFE@@JNRVJHFALFBEHQJCTbNDHCF@PlFLJSXCHFHfVBTNJ\\BPJXC^FAVNFCHFB@FFH@JF@\\ABCFD\\BDMCAAJKQBGAILOEGHILECQLWFENJHADC@QxNHFJNLDFA@CBA@DUÂmR@FBL@BD"],encodeOffsets:[[119959,40574]]}},{type:"Feature",id:"120115",properties:{name:"宝坻区",cp:[117.4274,39.5913],childNum:1},geometry:{type:"Polygon",coordinates:["@@TZbB@JHD@DODCLM@AP@LL@BNH@ETFN@`E@DNG@CHLBCJA@AICFKDDBKA@\\N@AFNAGRBFjFFFL@DHLBLFQPcXAZMJ]GAVHAIZJFNE@JpDRRDCLFDGXA@EFF@CFFPDfEBDB@DCHCFCJDJIJBLI@I@CB@@ADBB@FALADGDC@@H@BB@FZGFCCE@@FMLALJDAFFFEFDFCB@@AHCF@L@@BBB@BB@FC@E@@R@BEL@HEFD@G@AH@AIB@@@FEFEBALDDEFAFO^IF@JCBBFPNJJ@D@PRDCEKBAXL@BIFD@T@JE@BHHJORFDI@@B@JGH@@B@BDDLIFFHCD@D@DEE@BAAAB@DAF@B@H@NGLJLMRDNMfGIEPMI@GDAKK@KIDIJ@GE@CFDN@FE@GFEPGV@TCDFKHBBF@RW@DD@@ID@TJFKIKLI@EP@IGBCLAEKLEN@KSHIGYACSD@SEAMBBMGEBMQBCMIGKFB[D@HDLPHDBC@IFITDLG@IIIFGVBNJDLN@VIRI@YIAIHIC@CLKZCBEE@JECEIHEAKGDGECBGEEM@@DA@CCCBBEGA[GEDBBoNAAH]MKiIAWKQoIIPMFQAEEDMH@FMSUYIeF@EK@BIOEKJEBICFKaKPFAFSE@LWCCFMHDDEKESBOGBKIEIODLG@CCDEQCEDWEMDIEIB@EHGEEDAEAa@@HqDEJGF[AECCFa@WCEIKAAEQB@FCAE^YDERDDJBLNABD@AJGLJF@FNIAMLH@FPKLJ@FE\\BFOLGXMXW\\C@KPGD@JHDGVFBWN@AEAGFO@KH@JNFAHEHYLNHFCLBFBBHo^MAFGA@KJED@Jó¶EX"],encodeOffsets:[[119959,40574]]}},{type:"Feature",id:"120223",properties:{name:"静海县",cp:[116.9824,38.8312],childNum:1},geometry:{type:"Polygon",coordinates:["@@NGFMDATCNDR@CCbINEHNJA@C\\EEGVE@IhE[wepc¢·²^QEKIEKIgiQDkehY£uSDBMkUDOJDHC@GF@CAFBFEN@CQ@BeP@@G@HD@@MHQKi@[IGCOCESE@GMA_OcCGDu`a@VZzKDkJBLNXGDqKEWE@cFEFA@ISIi@@KMABJGBcMuFEzGVH\\ATSEUBeALCEMG@CEBUHUCGXaBPtUBBFIBFTDFF@DDKBFNGBJPHXDDMDCLJ^mBIHIL@LR\\@LCR[@@z@NFD@LLBNb@RHDBNTPT\\F@BJF@BXCFBHHBDLFB@HODADE@@JHVXCPDHCFTLBBFNCDCCCU@@GAABEHHZHBCAEdEjFDD@GfD@DXFCHF@ERFDLBH@"],encodeOffsets:[[119688,40010]]}},{type:"Feature",id:"120221",properties:{name:"宁河县",cp:[117.6801,39.3853],childNum:1},geometry:{type:"Polygon",coordinates:["@@BFLBFJXDb@DEFD\\BHEFIrC@Gb@FBCBFFGH@FJAJFNCXFFCRDCFDDH@CKJPJFALPHTALFCFGCENDDKXF@ETEBObLELJDFALIPFAJL@@FfEZJTVENG@CNFFRBNEJOpJLRBXjJNLG^BBpMAAFC\\HHBAFDADDB@@CN@FFAHFDCHLHFBJGFCFUNKJJTD\\XUXF\\^F@DDDQXXBRLRCBDFEVCDLVDpUl@LEDJHAPRFGL@CETGPBTCDDVI@CFF@GFDCCVGLKEK[Y@MECISG@BKNSCGCKWEAaEBEKNGFSECO@GGM@GYI@DÅCMLHPTF@DJHAVVNKEGDETJ^[TJNNd@NOAMFYJ@@GFANDPEJB^aOadSTQSI@MHBDIEOKCG@EEFCKCqXO@@DMFENCDDHCCGJ]AKFoDaGGHYFDHKJiCMFGC@EQ@AEHGAC@IEAATKOHGIC@IXIFEoGE[JCFCDHNmRADFZMF[EEBMO{GU@AOW@@]ZeHBDEHBKEfQkuIWBs@EC@d[@[^EDMTKCEEcI@cDAB@FCBCACmOCG{PYHeBgPwPFDDALFFFCHQGSD@BHFAR[TaFYXMASUiGFL@DQNCJI@@D@PLDN`ETEFIGMCGBCE~CAIFDPEHGEQPHJADFJGHCJLB"],encodeOffsets:[[120145,40295]]}},{type:"Feature",id:"120109",properties:{name:"大港区",cp:[117.3875,38.757],childNum:1},geometry:{type:"Polygon",coordinates:["@@JFFL°_`ONJKDDFIFZN xlb~yFVNRrdJGzDPVFBCTNND\\UR@E`F@@Ip@IWGUoawOEE@ÏDgK{İEEMFëCb@KwOCDHHKBDJCDEEEAGHOABFABMCgDLSQ@CFEBMgYIDQINE@AUSwSAdYEHQMEyK[KI@GRMLE@@OqOoBOnpJ@BmEAFHL^FDB[C@BBDVFAHFJENB@sNEjQAMYsUgCSBGDJH@\\LjGR@NC@@G@HO@AfR@DM@EFEADBE@@HGDICCPlVANTC¤vgZlfRChjLJ"],encodeOffsets:[[120065,39771]]}},{type:"Feature",id:"120107",properties:{name:"塘沽区",cp:[117.6801,38.9987],childNum:1},geometry:{type:"Polygon",coordinates:["@@|ODHnPBDADEDA@CB@ddJFFLDNSFC\\]\\@@cFD@nACOMW@M@ITURBRZNHNWRQoOj½fcqAqeiDÿÍyÓįFL|Ch@ÐFFxPpbHVJXo@@JCTR^BPABQA]^MB@bE@@FQBFVJRH@FXtPNZSBAja@@NDTLJrQTHFXZFB`"],encodeOffsets:[[120391,40118]]}},{type:"Feature",id:"120111",properties:{name:"西青区",cp:[117.1829,39.0022],childNum:1},geometry:{type:"Polygon",coordinates:["@@@LHAHRHATh`LHNHDG`HDGZ`D@FQDAHXFACNAFLVRTBFOfHDCVBFQH@HSXHEPFB@LDBF[bDbLFKJBFLADBDjLvCPEI]FGEIGCBEUSjcFiBIVWfaHCjN^HtwBBFGPBJGjFBEGECGDONMFAP]TDHQOWCMGAMHKIJEIGQ]aDlUG]VGEGDC{PEbBZmE@@GH@BCA@FMQCFMYMJECELCMI_P¯`]R±¡¸odfx\\gF@JUFFH[F@DIBGMMFaJDDQ@MCSDCBENMH"],encodeOffsets:[[119688,40010]]}},{type:"Feature",id:"120113",properties:{name:"北辰区",cp:[117.1761,39.2548],childNum:1},geometry:{type:"Polygon",coordinates:["@@ROHFFGCOJEDB}DFHANDJHFEFSM_KC@O@CJ@DIRM@CEKKALFKACHoLSJSIBETDJaEIIE]E]K[MYUYQILC@GF[MGNKEK@A@BCWECAIFEFYAGFOMI[OFuDiKACBCEKIAELaKaCE\\CA@KEAFOWGGTG@ERUACDeGEPSAUQKHE`FNjNFJADHHCJFB@DEXZFRRBJLA@AR@@BJ@CHF@BRX@@NQdDBBJhHCCZDLUNA^H@BKDPFEJ\\JMPfL^AJFFGLBDGLET@HJLBCFHDCPH@BIJFCLGABHNBDEF@BCN@@FHDDDN@BNEJH@@HF@DEJB@FfLNC@AHB@DHD\\IFGTCBCF@@JNH@ALKHBHCHBDMFEP@KYbHDEJF"],encodeOffsets:[[120139,40273]]}},{type:"Feature",id:"120110",properties:{name:"东丽区",cp:[117.4013,39.1223],childNum:1},geometry:{type:"Polygon",coordinates:["@@ZV\\N^L^FJFFJIbSCAFTJTIpKDGLBEKLBjHTVNBZWbE\\SBQGE@ATCRHDGEEKECBECxOhOfAZGA_YEEWSGqRKISC@Mb@BiTAMYsOEWG@IQEURA@EF@@acUOXQRYCUDCHDTEF[SUEgAYDcVGJM`iAWDWLQRMHUHgDsDBLHJFCFDFGHBFFVEAGHCJN@RJFPIhBD\\FENCPWA@LFBAFHBEJUEARCDIAEDQBRNa^"],encodeOffsets:[[120048,40134]]}},{type:"Feature",id:"120108",properties:{name:"汉沽区",cp:[117.8888,39.2191],childNum:1},geometry:{type:"Polygon",coordinates:["@@LMEI\\MTABKN@FCDMH@COAcH[AoēAM¡Wa[MeqpQRMXMGQYQASV@J@NNXDPmBAtJXlveRLFGACFGAYf@^X@BPV@|HNPFA\\FNEEYBCnQGMDCDE\\IHFpEFWJ@JJDGHLPBSFB@JBDGHBFR@@FHDNEjDLICGZEHGbHpCLE^BHIDDCGDCFMNE@CP@rWLDEDFFH@"],encodeOffsets:[[120859,40235]]}},{type:"Feature",id:"120112",properties:{name:"津南区",cp:[117.3958,38.9603],childNum:1},geometry:{type:"Polygon",coordinates:["@@TLv@CNHFFBHGZFETNPhCVGNGRQXKXCjBN_HIdUZChBVF\\TFECSDGVCZDRQPWdVNA^]RBBAAOQ]DSE@F_Q@[VMCSMADUECOHycIqMQEU}zkawENRDENB@ADG@@HF@YnaAOF|CDFHUHH^kVbCR^JHIFLJNGHBDNPXGRSCO^EBMNCPDHHFAFiEIHOAEH"],encodeOffsets:[[120045,39982]]}},{type:"Feature",id:"120103",properties:{name:"河西区",cp:[117.2365,39.0804],childNum:1},geometry:{type:"Polygon",coordinates:["@@d@hZNFdcLYXKRCtCMOFSYEGHEAGEDMu@SKAAsx]GMTGt"],encodeOffsets:[[119992,40041]]}},{type:"Feature",id:"120102",properties:{name:"河东区",cp:[117.2571,39.1209],childNum:1},geometry:{type:"Polygon",coordinates:["@@ZBVFFIGABEEA@KXBDOFM[EACJgOIE@QIMGDBHUFEEGAEHECEDGIAKQDWLKZcdQPEP@FOFBJTJ@HNORJf@DBCN"],encodeOffsets:[[120063,40098]]}},{type:"Feature",id:"120104",properties:{name:"南开区",cp:[117.1527,39.1065],childNum:1},geometry:{type:"Polygon",coordinates:["@@NMVDCG\\E^B@HlB@YEDS@CHsNSiMGDebUXAJEjidVTAFHDFJ"],encodeOffsets:[[119940,40093]]}},{type:"Feature",id:"120105",properties:{name:"河北区",cp:[117.2145,39.1615],childNum:1},geometry:{type:"Polygon",coordinates:["@@DBXFADB@L@LFHM\\NHED@JKZRb]QMRAFCJBDCBQYADMCAe@QIMP@GSIAIPE@E[EGH@ZEF]^HJAXK@KF"],encodeOffsets:[[119980,40125]]}},{type:"Feature",id:"120106",properties:{name:"红桥区",cp:[117.1596,39.1663],childNum:1},geometry:{type:"Polygon",coordinates:["@@J\\PNHEZBFEJELEL@BWGI^]FEkA@G]A[FDHUCMNEHJ^"],encodeOffsets:[[119942,40112]]}},{type:"Feature",id:"120101",properties:{name:"和平区",cp:[117.2008,39.1189],childNum:1},geometry:{type:"Polygon",coordinates:["@@DT@FCHG\\FFOROMEgYc@"],encodeOffsets:[[119992,40041]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/31",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"310230",properties:{name:"崇明县",cp:[121.5637,31.5383],childNum:1},geometry:{type:"Polygon",coordinates:["@@uŏu»GPIV±ÐɃŜ{\\qJmC[W\\t¾ÕjÕpnÃ±Â|ěÔe`² nZzZ~V|B^IpUbU{bs\\a\\OvQKªsMň£RAhQĤlA`GĂA@ĥWĝO"],encodeOffsets:[[124908,32105]]}},{type:"Feature",id:"310119",properties:{name:"南汇区",cp:[121.8755,30.954],childNum:1},geometry:{type:"Polygon",coordinates:["@@`yĉNǕDwǏ»ÖLxCdJ`HB@LBTD@CPFXANC@@PGBKNECCBB@EBFHEDDDSNKAUNBDMNqf[HcDCCcF@EFGLEBa@ACoCCDDD@LGHD@DJFBBJED@BGAEGGFKIGDBDLBAD@FHBEF@RFDMLE@SGANFFJBANPH@@E@FJjRIACDMDOEKLFD@DbDAJI@AP@BGHFBCBGDCC@DCA@CECGH@FKCEHFJGBFDIHACEDNJDCVFBDCRKRLDLITB@CjNJI^DBCfNVDHDFKHAFGDIICDWBIF@@CFAjFJNJBBHD@CJ@AEFJ@@DH@BFBCPDBMFEQGDIFCNDHIP@HDABFACBJFHEBSZC@DP@@JDBƤ~"],encodeOffsets:[[124854,31907]]}},{type:"Feature",id:"310120",properties:{name:"奉贤区",cp:[121.5747,30.8475],childNum:1},geometry:{type:"Polygon",coordinates:["@@~T~JjZdDbLXDLCB_J@@FHFZJJIAGH@HGR@BENBLID@@LFCDF\\FpDBDb@FAHKFE@dEDDdC\\GreNMACVMLBTMCCFCEGFAA@DAFDLMHA@OD@BMEWDOC@AS@KGAI_DcKwÕísƝåĆctKbMBQ@EGEBEJ@@MBKL@BJB@FIBGKE@ABG@@FMFCPL@AjCD@ZOFCJIDICIlKJHNGJALH@@FPDCTJDGDBNCn"],encodeOffsets:[[124274,31722]]}},{type:"Feature",id:"310115",properties:{name:"浦东新区",cp:[121.6928,31.2561],childNum:1},geometry:{type:"Polygon",coordinates:["@@EN@JJLNHjLJNR^GRYVBNZJRBV@PDvbLNDN@LGNER@nCNQNuT_TIVFV\\Z\\XnDrI|[Ʉś²ÏJUHOƣ}CA@IO@@CYDATGFIEDAEBBAGCO@GJMCEDCJRHEFANOCADAEG@@CI@FE@BDIC@AGIAIMiEEB@DE@AJCXJDCJEHGBELGCUCeMAD]CIJiM@DSAKJKCLQDQACUECDMIFCBDJGECHAEIWCK@GLMCCGEACNKCEJG@MMBMC@@CIJUINT@JAJSTEPZZCP"],encodeOffsets:[[124383,31915]]}},{type:"Feature",id:"310116",properties:{name:"金山区",cp:[121.2657,30.8112],childNum:1},geometry:{type:"Polygon",coordinates:["@@L@BIHFN@@EE@@EFBDGDAADVDD@@EF@CA@IIsRE@GDAF@BF@CV@|FBCHBLCNHAFCADBMDCFZXHILBVEEQA@MWFARJJ@DCX@@TEFBLHAAERE@AJABRPBNK\\BrJ\\VHGND@CNADKDADQjGAGNC@GJ@FCFFHC@JF@@dLBDSFADHVG\\DTEPDDHJALIJkJDJCDIPE@YDCBiK@DONE@EH@BAF@HLJA@EIA@ALKNA@@FIFAFHR@NALadsæąyQY@A±DŉXUVI^BF@FFF@HBJEDFFGFEBSRkVEXGHFBMFIVW@GAEEFOIAIPKABGWEKFSCQLQBSEIBC\\FdBLRR@JGACFDDEF@AWB@LJJYNABBA@CUEGPaO_AIE@MYMFIGAEFECHSAAKAO\\[JEDB@E@MMA@@AGBKMGDFFCDDFEDFJF@NPBAFLHFH@EDDHBADDC@DDCDHHCDDFDABDAD@FEFOBCJ[D@HEDDNJBDDHABJIBBvGLBJAH"],encodeOffsets:[[123901,31695]]}},{type:"Feature",id:"310118",properties:{name:"青浦区",cp:[121.1751,31.1909],childNum:1},geometry:{type:"Polygon",coordinates:["@@RUNKdOFDJCbRFMLAHPLDN@JGL@@APBWYCKN@TU@SHGCEJIDIJKVIZVNM`iNY@CIE@CA@KBOEGEUFCCSADEIEFCDDDIDDHC@CKIeDCG@IG@DHWFEEGCH@@GO@@O]CNpeEQDBFME[JC]DGF@CKOA@QSB@GB@@GW@@ED@AQIJIAAFE@@DO@CFI@KNG@CDACAFEGKGBEGBDCCAIFCCLIECFI@MBCLDHGNAHSF@DMB@EEKBA@@C]DEICFG@ADBHGFKCDAKKHKD@@FHGAANGEEFCHKCECBCKG@ADKCNE\\[A[I@@mGBDQQEO@BCE@AI[AML@JGACLOAFKEMM@EQKC@CUCBCCBCHEA@FF@@FM@GEAJK@GNF@EXPH@FD@M^@HIADJCFDBER@DK@@DE@CAKFOCCBDHIBCNSB@GFC@GQEEOWFICGDUAEJIDBTAHJHEB@DIF@NE@H|HBDBEH@DKBAHEF@HEEUB@FGFGCCCE@AHOB@NH@PRLVNNFBX@RCPbAvMtBfH@DJF@ELBFA@EH@HNED@FFB@HLC@CJ@@DJ@PIRf@HE@CFF@GPHD@DKE@FFBEFFD@DEFCA@DD@IjCRFBAHFDKD@HF@@PM@H@BlbDJDBFEF@DLXB@HCD@@IFCBIFEJD@FDC@FBALLF@PAACJERACAJCBD@EL@JD"],encodeOffsets:[[124061,32028]]}},{type:"Feature",id:"310117",properties:{name:"松江区",cp:[121.1984,31.0268],childNum:1},geometry:{type:"Polygon",coordinates:["@@@DLDFRN@FNELPBDKHB@INK\\BBJF@ADP@RFCRHA@nJ@B\\[\\MFLDBCH@DLDADFGLEDFFMHBBGH@EC@GLLLCBLDHEAGBCH@DEFJ^C@DB@LAFFA@CNE@GTMBGHKCAD@NEJFDKJDDJEDBCDHAAFLHFHBEBDDCH@LMJ@DEP@@CF@BEJBJIBRC@@FX@@HA@@HTA@RPBDLE@CHD^\\INFAERCfFMo^D@PP@@HG@HDFFXECGH@@JDHfCLJ@DGDCCCJCCEDJFCFTBDDVEHFPFLAB@NBFCFKFC@CHIACNOHWHCAAFIDD@CDAGEI@ACFMF@R@R_@GQED@EGFEQEDE_IAHKAEXCQUOQCUDEN@ZI\\DDmAMHCICDSOC@EG@BKHIGMIBCGOCSF[CUHCGEBCTKA@cE@@IGDEEEDI@@HMDBHiHCRCBCLMB@DMCGH[UqI[AMLOAAQIB@BQFBFGBAKFE@SW@CDI@QIEBNXB@FRUFKAGJYWDENCCADBBEMGKDGAAD{EU@@DAEE@CB@HQFJt@JDBE@@FC@"],encodeOffsets:[[123933,31687]]}},{type:"Feature",id:"310114",properties:{name:"嘉定区",cp:[121.2437,31.3625],childNum:1},geometry:{type:"Polygon",coordinates:["@@F@LI@IDKJADKIEJICADGACFECCJ@HKCAFOHAJI@aCBEE@ICAEB[GFGCKL@FGEIFADMLCAEJM@ELQECEIG@BE^QKKLQCA@EHBIGQ[GEHOMGGDHKH@JOECFCjCBEFDNCACMBCILGTABDLEEOEIG@GFIMM@CGKFBFCDE@@GEAGEEACIcGaHMFITIHDN[AKF@FS@OA@BK@IHM@KCGOKBENaQIDECcPMLQVFHFB@BFBKLGD@FAJOVGIACQ@A`LPCB@JEF@RU@ANS@@RCL\\HIFpRBFRBBDKLLDADJDGBFDABHBEDNF@DGBBBADKDAHC@\\JJFBDEH[DEFDH\\LX@XLBLbT@DNJLDCEL@VJABJNDHB@HBHYFBAA@GNFB@@AFB@AFABFLFBHFCL@HJBAFBLC@DN@HN"],encodeOffsets:[[124213,32254]]}},{type:"Feature",id:"310113",properties:{name:"宝山区",cp:[121.4346,31.4051],childNum:1},geometry:{type:"Polygon",coordinates:["@@mÖoÖi½[s[YEUJU`SCIEBCCWJY_LIICDWU@@FaBCJIB[ICH[@@CDKEE@MK@@IMCAEBCH@AMFI@SMGEFGB@FK@BHCAIFJNQD@FEBDFMBKGACG@ECWH@@CDDTOEEBGEK@GC@EE@GPHFR\\JHGA@FDBKRLL]RAFH@FJFDKR@FINBFKDCNEBFJEHK@DLEH\\HFADB@JFFDA@bIJGBEPDBGLI@DDEFBDCHDBIJJFCLIBCL@JKJE@ADHDBHJ@HIBBDFHBBAEIJ@BJFAVL¢"],encodeOffsets:[[124300,32302]]}},{type:"Feature",id:"310112",properties:{name:"闵行区",cp:[121.4992,31.0838],childNum:1},geometry:{type:"Polygon",coordinates:["@@T@@ELE\\BCMJGJSNEbGdHDJFBJAFIEIFCEWG@@gMENSFCVJFAxR~B@IH@AIiI@GE@FGEAFQPDRiV[\\DFSGMHAXHDOMCJCDETBBNVJJI@DD@ANNNH@FILDDMFBDHNDHKL@XDFGLD@EHGFD@DDB@CDDHCDAEAHG@ABOJ@BIaC@CECLKPFNCDCJBiQEIF@@@OGBMIAEEBMTHF@NKEC@QFEGA@EBCKAACHCLJHEFHHB@AFCAIEACIC@HG@KCCDC[ECEED@KC@KJMAAFQ@GHG@BHIJYIGE@EI@A`KDWCaKcCiY}I}S[CYJM@CFDVPRRVWDFLBBG`JCFRFEFFHC@RF@HQ`Q@E@ENBDJ@HFCB@DCCEJBBGDGXMPBDGJ@DEDELEDMA@DJF@DMZ_jMNYUUJILCJIJDFGH@TSVM@DLXZ"],encodeOffsets:[[124165,32010]]}},{type:"Feature",id:"310110",properties:{name:"杨浦区",cp:[121.528,31.2966],childNum:1},geometry:{type:"Polygon",coordinates:["@@V@CXJDKJZ`XIDDFADJvSRMDM@mFQHM@KCMKMuaOCU@BDAJSX@HKJGD@PNJCJWAGT@R"],encodeOffsets:[[124402,32064]]}},{type:"Feature",id:"310107",properties:{name:"普陀区",cp:[121.3879,31.2602],childNum:1},geometry:{type:"Polygon",coordinates:["@@F@@FHDL@HFFAPFCSDC@@XGFDH@BDLHNACEFA@ERCIMJEDBAGL@@EHAFENHHJ\\ONQBQCIBC[MKACKI@GGGH@I_G@CW@[DMHCDIBMTDHN@JNHEH@FJFPKFACSBKHDJNABDMDECAFiDEDFDIPG@GLHCNH"],encodeOffsets:[[124248,32045]]}},{type:"Feature",id:"310104",properties:{name:"徐汇区",cp:[121.4333,31.1607],childNum:1},geometry:{type:"Polygon",coordinates:["@@RADL\\NCPHFfLJaJ@FWLGMGIK@IFMDOYYFOTSBI@IMSAMSACFIDNDCPWGGBHNET[CU\\QjOCERFBEHF@@HjJBJG@@J"],encodeOffsets:[[124327,31941]]}},{type:"Feature",id:"310105",properties:{name:"长宁区",cp:[121.3852,31.2115],childNum:1},geometry:{type:"Polygon",coordinates:["@@HFFB@HF@DCAELENSJADCNG\\CX@@D`H@JHGHHJ@BINBFUGEDO[MCKQB}AwQEBUIEDMTNF@hH@FXEDFJEJIB"],encodeOffsets:[[124250,31987]]}},{type:"Feature",id:"310108",properties:{name:"闸北区",cp:[121.4511,31.2794],childNum:1},geometry:{type:"Polygon",coordinates:["@@CSG@BQGODUPWTOBQAAFMECKBGEMFKEOHADDJARMR[PGI@TEJBNG@ADBFND@JL@@NFFCL@D\\@DG\\JJADI"],encodeOffsets:[[124385,32068]]}},{type:"Feature",id:"310109",properties:{name:"虹口区",cp:[121.4882,31.2788],childNum:1},geometry:{type:"Polygon",coordinates:["@@bA@E@QHSXBDIMI@OHCLI@GTWBIACQAYIOFGCENBBARSPOXCVHPARH@DT"],encodeOffsets:[[124385,32068]]}},{type:"Feature",id:"310101",properties:{name:"黄浦区",cp:[121.4868,31.219],childNum:1},geometry:{type:"Polygon",coordinates:["@@NEHFLAFDHDPEAMZUHQQ]IMKJG@EPERABHBGRUCCNGV"],encodeOffsets:[[124379,31992]]}},{type:"Feature",id:"310103",properties:{name:"卢湾区",cp:[121.4758,31.2074],childNum:1},geometry:{type:"Polygon",coordinates:["@@VDHQGABAFQFOH@LIiKKHEXI@IbAFZB"],encodeOffsets:[[124385,31974]]}},{type:"Feature",id:"310106",properties:{name:"静安区",cp:[121.4484,31.2286],childNum:1},geometry:{type:"Polygon",coordinates:["@@DLLB\\NPGLFHUDMYABEeKEVMAAJ"],encodeOffsets:[[124343,31979]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/81",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"8100",properties:{name:"香港",cp:[114.2784,22.3057],childNum:1},geometry:{type:"Polygon",coordinates:["@@@}ScTʟ@cWuJÁ]l¦RLj¼BĄà H@TOHCTDDDHDNAT@PEHDDNJLX@BABALHFF@DKHADBBLDHHFBLEJB@GDBBFBADDB@@KFAFBBJJA@BB@@FFDDADFF@FADDDBJC@AFBD@@DDD@DAA@D@DB@DHHBFJBBFEHDFAN@DGDC@DLCBDDCFDlAFBFCBEF@BC@GDAB@FD@DZJX´HĐMja@Ý`p_PCZ@lLnRGSDMFK|a\\Y}­§Mën"],encodeOffsets:[[117078,22678]]}}],UTF8Encoding:!0}}),define("echarts/util/mapData/china/82",[],function(){return{type:"FeatureCollection",features:[{type:"Feature",id:"8200",properties:{name:"澳门",cp:[113.5715,22.1583],childNum:1},geometry:{type:"Polygon",coordinates:["@@HQFMDIDGBI@E@EEKEGCEIGGEKEMGSEU@CBEDAJAP@F@LBT@JCHMPOdADCFADAB@LFLDFFP@DAB@@AF@D@B@@FBD@FADHBBHAD@FAJ@JEDCJI`gFIJW"],encodeOffsets:[[116325,22699]]}}],UTF8Encoding:!0}}),define("echarts/util/shape/halfSmoothPolygon",["require","zrender/shape","zrender/shape/base","zrender/shape"],function(e){function t(){this.type="halfSmoothPolygon"}return t.prototype={buildPath:function(t,n){var r=n.pointList;if(r.length<2)return;if(n.smooth){var i=this.smoothBezier(r.slice(0,-2),n.smooth);t.moveTo(r[0][0],r[0][1]);var s,o,u,a=r.length;for(var f=0;f<a-3;f++)s=i[f*2],o=i[f*2+1],u=r[f+1],t.bezierCurveTo(s[0],s[1],o[0],o[1],u[0],u[1]);t.lineTo(r[a-2][0],r[a-2][1]),t.lineTo(r[a-1][0],r[a-1][1]),t.lineTo(r[0][0],r[0][1])}else e("zrender/shape").get("polygon").buildPath(t,n);return}},e("zrender/shape/base").derive(t),e("zrender/shape").define("halfSmoothPolygon",new t),t}),define("echarts/chart/line",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","zrender/shape","zrender/shape","../util/shape/halfSmoothPolygon","../chart"],function(e){function t(t,r,i,s){function y(){d={},c.selectedMap={};var e={top:[],bottom:[],left:[],right:[]},t,n,i,o;for(var u=0,f=h.length;u<f;u++)h[u].type==c.type&&(h[u]=c.reformOption(h[u]),t=h[u].xAxisIndex,n=h[u].yAxisIndex,i=s.xAxis.getAxis(t),o=s.yAxis.getAxis(n),i.type==a.COMPONENT_TYPE_AXIS_CATEGORY?e[i.getPosition()].push(u):o.type==a.COMPONENT_TYPE_AXIS_CATEGORY&&e[o.getPosition()].push(u));for(var l in e)e[l].length>0&&b(l,e[l]);for(var u=0,f=c.shapeList.length;u<f;u++)c.shapeList[u].id=r.newShapeId(c.type),r.addShape(c.shapeList[u])}function b(e,t){var n=w(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;switch(e){case"bottom":case"top":E(i,r);break;case"left":case"right":S(i,r)}}function w(e){var t,n=0,i={},o="__kener__stack__",u,a,f=s.legend,l=[],p=0,d;for(var y=0,b=e.length;y<b;y++)t=h[e[y]],a=t.name,g[e[y]]=g[e[y]]||c.deepQuery([t],"symbol")||m[y%m.length],f?(c.selectedMap[a]=f.isSelected(a),v[e[y]]=f.getColor(a),d=f.getItemShape(a),d&&(d.shape="icon",d.style.iconType="legendLineIcon",d.style.symbol=g[e[y]],f.setItemShape(a,d))):(c.selectedMap[a]=!0,v[e[y]]=r.getColor(e[y])),c.selectedMap[a]&&(u=t.stack||o+e[y],typeof i[u]=="undefined"?(i[u]=n,l[n]=[e[y]],n++):l[i[u]].push(e[y])),p=Math.max(p,t.data.length);return{locationMap:l,maxDataLength:p}}function E(e,t){var n=t[0][0],r=h[n],o=r.xAxisIndex,u=s.xAxis.getAxis(o),a,f,l,p,v,m,g,y,b={},w,E;for(var S=0,T=e;S<T;S++){if(typeof u.getNameByIndex(S)=="undefined")break;l=u.getCoordByIndex(S);for(var C=0,k=t.length;C<k;C++){a=h[t[C][0]].yAxisIndex||0,f=s.yAxis.getAxis(a),m=v=y=g=f.getCoord(0);for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[S],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-",b[n]=b[n]||[];if(E=="-"){b[n].length>0&&(d[n]=d[n]||[],d[n].push(b[n]),b[n]=[]);continue}p=f.getCoord(E),E>=0?(v-=m-p,p=v):E<0&&(g+=p-y,p=g),b[n].push([l,p,S,u.getNameByIndex(S),l,m])}}v=s.grid.getY();var O;for(var C=0,k=t.length;C<k;C++)for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[S],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-";if(E!="-")continue;c.deepQuery([w,r,i],"calculable")&&(O=c.deepQuery([w,r],"symbolSize"),v+=O*2+5,p=v,c.shapeList.push(N(n,S,u.getNameByIndex(S),l,p,"horizontal")))}}for(var M in b)b[M].length>0&&(d[M]=d[M]||[],d[M].push(b[M]),b[M]=[]);x(d,u,"horizontal")}function S(e,t){var n=t[0][0],r=h[n],o=r.yAxisIndex,u=s.yAxis.getAxis(o),a,f,l,p,v,m,g,y,b={},w,E;for(var S=0,T=e;S<T;S++){if(typeof u.getNameByIndex(S)=="undefined")break;p=u.getCoordByIndex(S);for(var C=0,k=t.length;C<k;C++){a=h[t[C][0]].xAxisIndex||0,f=s.xAxis.getAxis(a),m=v=y=g=f.getCoord(0);for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[S],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-",b[n]=b[n]||[];if(E=="-"){b[n].length>0&&(d[n]=d[n]||[],d[n].push(b[n]),b[n]=[]);continue}l=f.getCoord(E),E>=0?(v+=l-m,l=v):E<0&&(g-=y-l,l=g),b[n].push([l,p,S,u.getNameByIndex(S),m,p])}}v=s.grid.getXend();var O;for(var C=0,k=t.length;C<k;C++)for(var L=0,A=t[C].length;L<A;L++){n=t[C][L],r=h[n],w=r.data[S],E=typeof w!="undefined"?typeof w.value!="undefined"?w.value:w:"-";if(E!="-")continue;c.deepQuery([w,r,i],"calculable")&&(O=c.deepQuery([w,r],"symbolSize"),v-=O*2+5,l=v,c.shapeList.push(N(n,S,u.getNameByIndex(S),l,p,"vertical")))}}for(var M in b)b[M].length>0&&(d[M]=d[M]||[],d[M].push(b[M]),b[M]=[]);x(d,u,"vertical")}function x(e,t,n){var r,s,o,u,a,f,d,m,g,y,b,w;for(var E=h.length-1;E>=0;E--){g=h[E],b=e[E];if(g.type==c.type&&typeof b!="undefined"){r=v[E],s=c.deepQuery([g],"itemStyle.normal.lineStyle.width"),o=c.deepQuery([g],"itemStyle.normal.lineStyle.type"),u=c.deepQuery([g],"itemStyle.normal.lineStyle.color"),a=c.deepQuery([g],"itemStyle.normal.color"),f=c.deepQuery([g],"itemStyle.emphasis.color"),d=typeof c.deepQuery([g],"itemStyle.normal.areaStyle")!="undefined",m=c.deepQuery([g],"itemStyle.normal.areaStyle.color");for(var S=0,x=b.length;S<x;S++){w=b[S];for(var N=0,k=w.length;N<k;N++)y=g.data[w[N][2]],(c.deepQuery([y,g],"showAllSymbol")||t.isMainAxis(w[N][2])&&c.deepQuery([y,g],"symbol")!="none"||c.deepQuery([y,g,i],"calculable"))&&c.shapeList.push(C(E,w[N][2],w[N][3],w[N][0],w[N][1],c.deepQuery([y],"itemStyle.normal.color")||a||r,c.deepQuery([y],"itemStyle.emphasis.color")||f||a||r,s,c.deepQuery([y,g],"symbolRotate"),n));c.shapeList.push({shape:"brokenLine",zlevel:p,style:{pointList:w,strokeColor:u||a||r,lineWidth:s,lineType:o,smooth:T(g.smooth),shadowColor:c.deepQuery([g],"itemStyle.normal.lineStyle.shadowColor"),shadowBlur:c.deepQuery([g],"itemStyle.normal.lineStyle.shadowBlur"),shadowOffsetX:c.deepQuery([g],"itemStyle.normal.lineStyle.shadowOffsetX"),shadowOffsetY:c.deepQuery([g],"itemStyle.normal.lineStyle.shadowOffsetY")},hoverable:!1,_main:!0,_seriesIndex:E,_orient:n}),d&&c.shapeList.push({shape:"halfSmoothPolygon",zlevel:p,style:{pointList:w.concat([[w[w.length-1][4],w[w.length-1][5]-2],[w[0][4],w[0][5]-2]]),brushType:"fill",smooth:T(g.smooth),color:m?m:l.alpha(r,.5)},hoverable:!1,_main:!0,_seriesIndex:E,_orient:n})}}}}function T(e){return e?.3:0}function N(e,t,n,r,i,s){var o=h[e].calculableHolderColor||a.calculableHolderColor,u=C(e,t,n,r,i,o,v[e],2,0,s);return u.hoverable=!1,u.draggable=!1,u.style.text=undefined,u}function C(e,t,n,r,s,o,u,a,l,d){var v=h[e],m=v.data[t],y=c.deepQuery([m],"symbol")||g[e]||"cricle",b=c.deepQuery([m,v],"symbolSize"),w={shape:"icon",zlevel:p+1,style:{iconType:y.replace("empty","").toLowerCase(),x:r-b,y:s-b,width:b*2,height:b*2,brushType:"both",color:y.match("empty")?"#fff":o,strokeColor:o,lineWidth:a*2},highlightStyle:{color:y.match("empty")?"#fff":u,strokeColor:u,lineWidth:a*2+2},clickable:!0};return typeof l!="undefined"&&(w.rotation=[l*Math.PI/180,r,s]),y.match("star")&&(w.style.iconType="star",w.style.n=y.replace("empty","").replace("star","")-0||5),y=="none"&&(w.invisible=!0,w.hoverable=!1),c.deepQuery([m,v,i],"calculable")&&(c.setCalculable(w),w.draggable=!0),w=c.addLabel(w,h[e],h[e].data[t],n,d=="vertical"?"horizontal":"vertical"),y.match("empty")&&(typeof w.style.textColor=="undefined"&&(w.style.textColor=w.style.strokeColor),typeof w.highlightStyle.textColor=="undefined"&&(w.highlightStyle.textColor=w.highlightStyle.strokeColor)),f.pack(w,h[e],e,h[e].data[t],t,n),w._x=r,w._y=s,w._dataIndex=t,w._seriesIndex=e,w}function k(e,t){s=t,L(e)}function L(e){e&&(i=e,h=i.series),c.clear(),y()}function A(e,t){var n=e.seriesIndex,r=e.dataIndex,i,s,o,u=n.length;while(u--){i=d[n[u]];if(i){s=h[n[u]],o=[s],defaultColor=v[n[u]],lineWidth=c.deepQuery([s],"itemStyle.normal.lineStyle.width"),lineType=c.deepQuery([s],"itemStyle.normal.lineStyle.type"),lineColor=c.deepQuery([s],"itemStyle.normal.lineStyle.color"),normalColor=c.deepQuery([s],"itemStyle.normal.color"),emphasisColor=c.deepQuery([s],"itemStyle.emphasis.color");var a;for(var f=0,l=i.length;f<l;f++){singlePL=i[f];for(var p=0,m=singlePL.length;p<m;p++)r==singlePL[p][2]&&(data=s.data[singlePL[p][2]],a=C(n[u],singlePL[p][2],singlePL[p][3],singlePL[p][0],singlePL[p][1],c.deepQuery([data],"itemStyle.normal.color")||normalColor||defaultColor,c.deepQuery([data],"itemStyle.emphasis.color")||emphasisColor||normalColor||defaultColor,lineWidth,c.deepQuery([data,s],"symbolRotate"),"horizontal"),t.push(a))}}}}function O(e){var t={};for(var n=0,i=e.length;n<i;n++)t[e[n][0]]=e[n];var s,o,u,a,f,l,p;for(var n=c.shapeList.length-1;n>=0;n--){f=c.shapeList[n]._seriesIndex;if(t[f]&&!t[f][3]){if(c.shapeList[n]._main){l=c.shapeList[n].style.pointList,o=Math.abs(l[0][0]-l[1][0]),a=Math.abs(l[0][1]-l[1][1]),p=c.shapeList[n]._orient=="horizontal";if(t[f][2]){if(c.shapeList[n].shape=="polygon"){var d=l.length;c.shapeList[n].style.pointList[d-3]=l[d-2],p?c.shapeList[n].style.pointList[d-3][0]=l[d-4][0]:c.shapeList[n].style.pointList[d-3][1]=l[d-4][1],c.shapeList[n].style.pointList[d-2]=l[d-1]}c.shapeList[n].style.pointList.pop(),p?(s=o,u=0):(s=0,u=-a)}else{c.shapeList[n].style.pointList.shift();if(c.shapeList[n].shape=="polygon"){var v=c.shapeList[n].style.pointList.pop();p?v[0]=l[0][0]:v[1]=l[0][1],c.shapeList[n].style.pointList.push(v)}p?(s=-o,u=0):(s=0,u=a)}r.modShape(c.shapeList[n].id,{style:{pointList:c.shapeList[n].style.pointList}})}else{if(t[f][2]&&c.shapeList[n]._dataIndex==h[f].data.length-1){r.delShape(c.shapeList[n].id);continue}if(!t[f][2]&&c.shapeList[n]._dataIndex===0){r.delShape(c.shapeList[n].id);continue}}r.animate(c.shapeList[n].id,"").when(500,{position:[s,u]}).start()}}}function M(){var e=c.deepQuery([i],"animationDuration"),t=c.deepQuery([i],"animationEasing"),n,s,o,u=0;for(var a=0,f=c.shapeList.length;a<f;a++)c.shapeList[a]._main?(o=h[c.shapeList[a]._seriesIndex],u+=1,n=c.shapeList[a].style.pointList[0][0],s=c.shapeList[a].style.pointList[0][1],c.shapeList[a]._orient=="horizontal"?r.modShape(c.shapeList[a].id,{scale:[0,1,n,s]}):r.modShape(c.shapeList[a].id,{scale:[1,0,n,s]}),r.animate(c.shapeList[a].id,"").when((c.deepQuery([o],"animationDuration")||e)+u*100,{scale:[1,1,n,s]}).start(c.deepQuery([o],"animationEasing")||t)):(n=c.shapeList[a]._x||0,s=c.shapeList[a]._y||0,r.modShape(c.shapeList[a].id,{scale:[0,0,n,s]}),r.animate(c.shapeList[a].id,"").when(e,{scale:[1,1,n,s]}).start("QuinticOut"))}var o=e("../component/base");o.call(this,r);var u=e("./calculableBase");u.call(this,r,i);var a=e("../config"),f=e("../util/ecData"),l=e("zrender/tool/color"),c=this;c.type=a.CHART_TYPE_LINE;var h,p=c.getZlevelBase(),d={},v={},m=["circle","rectangle","triangle","diamond","emptyCircle","emptyRectangle","emptyTriangle","emptyDiamond"],g={};e("zrender/shape").get("icon").define("legendLineIcon",n),c.init=k,c.refresh=L,c.ontooltipHover=A,c.addDataAnimation=O,c.animation=M,k(i,s)}function n(t,n){var r=n.x,i=n.y,s=n.width,o=n.height,u=o/2;t.moveTo(r,i+u),t.lineTo(r+s,i+u),n.symbol.match("empty")&&(t.fillStyle="#fff"),n.brushType="both";var a=n.symbol.replace("empty","").toLowerCase();if(a.match("star"))u=a.replace("star","")-0||5,i-=1,a="star";else if(a=="rectangle"||a=="arrow")r+=(s-o)/2,s=o;a=e("zrender/shape").get("icon").get(a),a&&a(t,{x:r+3,y:i+3,width:s-6,height:o-6,n:u})}return e("../util/shape/halfSmoothPolygon"),e("../chart").define("line",t),t}),define("echarts/chart/bar",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/color","../chart"],function(e){function t(t,n,r,i){function d(){l.selectedMap={};var e={top:[],bottom:[],left:[],right:[]},t,r,s,o;for(var a=0,f=c.length;a<f;a++)c[a].type==u.CHART_TYPE_BAR&&(c[a]=l.reformOption(c[a]),t=c[a].xAxisIndex,r=c[a].yAxisIndex,s=i.xAxis.getAxis(t),o=i.yAxis.getAxis(r),s.type==u.COMPONENT_TYPE_AXIS_CATEGORY?e[s.getPosition()].push(a):o.type==u.COMPONENT_TYPE_AXIS_CATEGORY&&e[o.getPosition()].push(a));for(var h in e)e[h].length>0&&v(h,e[h]);for(var a=0,f=l.shapeList.length;a<f;a++)l.shapeList[a].id=n.newShapeId(l.type),n.addShape(l.shapeList[a])}function v(e,t){var n=m(t),r=n.locationMap,i=n.maxDataLength;if(i===0||r.length===0)return;switch(e){case"bottom":case"top":g(i,r);break;case"left":case"right":y(i,r)}}function m(e){var t,r=0,s={},o="__kener__stack__",u,a,f=i.legend,h=[],d=0;for(var v=0,m=e.length;v<m;v++)t=c[e[v]],a=t.name,f?(l.selectedMap[a]=f.isSelected(a),p[e[v]]=f.getColor(a)):(l.selectedMap[a]=!0,p[e[v]]=n.getColor(e[v])),l.selectedMap[a]&&(u=t.stack||o+e[v],typeof s[u]=="undefined"?(s[u]=r,h[r]=[e[v]],r++):h[s[u]].push(e[v])),d=Math.max(d,t.data.length);return{locationMap:h,maxDataLength:d}}function g(e,t){var n=t[0][0],s=c[n],o=s.xAxisIndex,a=i.xAxis.getAxis(o),f,h,p=b(a,t),d=p.gap,v=p.barGap,m=p.barWidthMap,g=p.barWidth,y=p.barMinHeightMap,E,S,x,T,N,C,k,L,A,O;for(var M=0,_=e;M<_;M++){if(typeof a.getNameByIndex(M)=="undefined")break;S=a.getCoordByIndex(M)-d/2;for(var D=0,P=t.length;D<P;D++){f=c[t[D][0]].yAxisIndex||0,h=i.yAxis.getAxis(f),N=T=h.getCoord(0)-1,k=C=T+2;for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=c[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O=="-")continue;x=h.getCoord(O),O>0?(E=N-x,B==1&&y[n]>E&&(E=y[n]),T-=E,x=T,T-=.5):O<0?(E=x-k,B==1&&y[n]>E&&(E=y[n]),x=C,C+=E,C+=.5):(E=N-x,T-=E,x=T,T-=.5),L=w(n,M,a.getNameByIndex(M),S,x,m[n]||g,E,"vertical"),l.shapeList.push(L)}for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=c[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O!="-")continue;l.deepQuery([A,s,r],"calculable")&&(T-=y[n],x=T,L=w(n,M,a.getNameByIndex(M),S+1,x,(m[n]||g)-2,y[n],"vertical"),L.hoverable=!1,L.draggable=!1,L.style.brushType="stroke",L.style.strokeColor=s.calculableHolderColor||u.calculableHolderColor,l.shapeList.push(L))}S+=(m[n]||g)+v}}}function y(e,t){var n=t[0][0],s=c[n],o=s.yAxisIndex,a=i.yAxis.getAxis(o),f,h,p=b(a,t),d=p.gap,v=p.barGap,m=p.barWidthMap,g=p.barWidth,y=p.barMinHeightMap,E,S,x,T,N,C,k,L,A,O;for(var M=0,_=e;M<_;M++){if(typeof a.getNameByIndex(M)=="undefined")break;x=a.getCoordByIndex(M)+d/2;for(var D=0,P=t.length;D<P;D++){f=c[t[D][0]].xAxisIndex||0,h=i.xAxis.getAxis(f),N=T=h.getCoord(0)+1,k=C=T-2;for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=c[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O=="-")continue;S=h.getCoord(O),O>0?(E=S-N,B==1&&y[n]>E&&(E=y[n]),S=T,T+=E,T+=.5):O<0?(E=k-S,B==1&&y[n]>E&&(E=y[n]),C-=E,S=C,C-=.5):(E=S-N,S=T,T+=E,T+=.5),L=w(n,M,a.getNameByIndex(M),S,x-(m[n]||g),E,m[n]||g,"horizontal"),l.shapeList.push(L)}for(var H=0,B=t[D].length;H<B;H++){n=t[D][H],s=c[n],A=s.data[M],O=typeof A!="undefined"?typeof A.value!="undefined"?A.value:A:"-";if(O!="-")continue;l.deepQuery([A,s,r],"calculable")&&(S=T,T+=y[n],L=w(n,M,a.getNameByIndex(M),S,x+1-(m[n]||g),y[n],(m[n]||g)-2,"horizontal"),L.hoverable=!1,L.draggable=!1,L.style.brushType="stroke",L.style.strokeColor=s.calculableHolderColor||u.calculableHolderColor,l.shapeList.push(L))}x-=(m[n]||g)+v}}}function b(e,t,n){var r={},i={},s,o=0,u=0,a,f;for(var h=0,p=t.length;h<p;h++){f=!1;for(var d=0,v=t[h].length;d<v;d++)seriesIndex=t[h][d],n||(f?r[seriesIndex]=s:(s=l.deepQuery([c[seriesIndex]],"barWidth"),typeof s!="undefined"&&(r[seriesIndex]=s,u+=s,o++,f=!0))),a=l.deepQuery([c[seriesIndex]],"barMinHeight"),typeof a!="undefined"&&(i[seriesIndex]=a)}var m,g,y;if(t.length!=o){m=Math.round(e.getGap()*4/5),g=Math.round((m-u)*3/(4*t.length-3*o-1)),y=Math.round(g/3);if(g<0)return b(e,t,!0)}else{g=0,y=Math.round(u/o/3),m=u+y*(o-1);if(Math.round(e.getGap()*4/5)<m)return b(e,t,!0)}return{barWidthMap:r,barMinHeightMap:i,gap:m,barWidth:g,barGap:y}}function w(e,t,n,i,s,o,u,d){var v,m=c[e],g=m.data[t],y=p[e],b=l.deepQuery([g,m],"itemStyle.normal.color")||y,w=l.deepQuery([g,m],"itemStyle.emphasis.color");return v={shape:"rectangle",zlevel:h,clickable:!0,style:{x:i,y:s,width:o,height:u,brushType:"both",color:b,strokeColor:"#fff"},highlightStyle:{color:w||(typeof b=="string"?f.lift(b,-0.2):b),strokeColor:"rgba(0,0,0,0)"},_orient:d},v.highlightStyle.textColor=v.highlightStyle.color,v=l.addLabel(v,m,g,n,d),l.deepQuery([g,m,r],"calculable")&&(l.setCalculable(v),v.draggable=!0),a.pack(v,c[e],e,c[e].data[t],t,n),v}function E(e,t){i=t,S(e)}function S(e){e&&(r=e,c=r.series),l.clear(),d()}function x(e){var t={};for(var r=0,s=e.length;r<s;r++)t[e[r][0]]=e[r];var o,u,f,h,p,d,v;for(var r=l.shapeList.length-1;r>=0;r--){d=a.get(l.shapeList[r],"seriesIndex");if(t[d]&&!t[d][3]&&l.shapeList[r].shape=="rectangle"){v=a.get(l.shapeList[r],"dataIndex"),p=c[d];if(t[d][2]&&v==p.data.length-1){n.delShape(l.shapeList[r].id);continue}if(!t[d][2]&&v===0){n.delShape(l.shapeList[r].id);continue}l.shapeList[r]._orient=="horizontal"?(h=i.yAxis.getAxis(p.yAxisIndex||0).getGap(),f=t[d][2]?-h:h,o=0):(u=i.xAxis.getAxis(p.xAxisIndex||0).getGap(),o=t[d][2]?u:-u,f=0),n.animate(l.shapeList[r].id,"").when(500,{position:[o,f]}).start()}}}function T(){var e,t,i,s,o,u,f,c,h;for(var p=0,d=l.shapeList.length;p<d;p++)l.shapeList[p].shape=="rectangle"&&(f=a.get(l.shapeList[p],"series"),c=a.get(l.shapeList[p],"dataIndex"),h=a.get(l.shapeList[p],"value"),e=l.deepQuery([f,r],"animationDuration"),t=l.deepQuery([f,r],"animationEasing"),l.shapeList[p]._orient=="horizontal"?(i=l.shapeList[p].style.width,o=l.shapeList[p].style.x,h<0?(n.modShape(l.shapeList[p].id,{style:{x:o+i,width:0}}),n.animate(l.shapeList[p].id,"style").when(e+c*100,{x:o,width:i}).start(t)):(n.modShape(l.shapeList[p].id,{style:{width:0}}),n.animate(l.shapeList[p].id,"style").when(e+c*100,{width:i}).start(t))):(s=l.shapeList[p].style.height,u=l.shapeList[p].style.y,h<0?(n.modShape(l.shapeList[p].id,{style:{height:0}}),n.animate(l.shapeList[p].id,"style").when(e+c*100,{height:s}).start(t)):(n.modShape(l.shapeList[p].id,{style:{y:u+s,height:0}}),n.animate(l.shapeList[p].id,"style").when(e+c*100,{y:u,height:s}).start(t))))}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/color"),l=this;l.type=u.CHART_TYPE_BAR;var c,h=l.getZlevelBase(),p={};l.init=E,l.refresh=S,l.addDataAnimation=x,l.animation=T,E(r,i)}return e("../chart").define("bar",t),t}),define("echarts/chart/pie",["require","../component/base","./calculableBase","../config","../util/ecData","zrender/tool/math","zrender/tool/util","zrender/tool/color","../chart"],function(e){function t(t,n,r,i){function g(){h.selectedMap={},m={};var e;v=!1;for(var t=0,i=p.length;t<i;t++)p[t].type==u.CHART_TYPE_PIE&&(p[t]=h.reformOption(p[t]),v=v||p[t].selectedMode,m[t]=[],h.deepQuery([p[t],r],"calculable")&&(e={shape:p[t].radius[0]<=10?"circle":"ring",zlevel:d,hoverable:!1,style:{x:p[t].center[0],y:p[t].center[1],r0:p[t].radius[0]<=10?0:p[t].radius[0]-10,r:p[t].radius[1]+10,brushType:"stroke",strokeColor:p[t].calculableHolderColor||u.calculableHolderColor}},a.pack(e,p[t],t,undefined,-1),h.setCalculable(e),h.shapeList.push(e)),y(t));for(var t=0,i=h.shapeList.length;t<i;t++)h.shapeList[t].id=n.newShapeId(h.type),n.addShape(h.shapeList[t])}function y(e){var t=p[e],r=t.data,s=i.legend,o,u=0,a=0,f=Number.NEGATIVE_INFINITY;for(var l=0,c=r.length;l<c;l++)o=r[l].name,s?h.selectedMap[o]=s.isSelected(o):h.selectedMap[o]=!0,h.selectedMap[o]&&(u++,a+=+r[l].value,f=Math.max(f,+r[l].value));var d,v=t.startAngle.toFixed(2)-0,m,g=t.minAngle,y=360-g*u,w,E=t.roseType,S,x;for(var l=0,c=r.length;l<c;l++){o=r[l].name;if(!h.selectedMap[o])continue;s?w=s.getColor(o):w=n.getColor(l),d=r[l].value/a,E!="area"?m=(d*y+v+g).toFixed(2)-0:m=(y/c+v+g).toFixed(2)-0,d=(d*100).toFixed(2),S=+t.radius[0],x=+t.radius[1],E=="radius"?x=r[l].value/f*(x-S)*.8+(x-S)*.2+S:E=="area"&&(x=Math.sqrt(r[l].value/f)*(x-S)+S),b(e,l,d,r[l].selected,S,x,v,m,w),v=m}}function b(e,t,n,r,i,s,o,u,f){var l=w(e,t,n,r,i,s,o,u,f);a.pack(l,p[e],e,p[e].data[t],t,p[e].data[t].name,n),h.shapeList.push(l);var c=E(e,t,n,o,u,f,!1);c&&(c._dataIndex=t,h.shapeList.push(c));var d=x(e,t,i,s,o,u,f,!1);d&&(d._dataIndex=t,h.shapeList.push(d))}function w(e,t,n,i,s,o,u,a,l){var g=p[e],y=g.data[t],b=h.deepQuery([y,g],"itemStyle.normal.color")||l,w=h.deepQuery([y,g],"itemStyle.emphasis.color"),E={shape:"sector",zlevel:d,clickable:!0,style:{x:g.center[0],y:g.center[1],r0:s,r:o,startAngle:u,endAngle:a,brushType:"both",color:b,strokeColor:"#fff",lineWidth:1},highlightStyle:{color:w||(typeof b=="string"?c.lift(b,-0.2):b),strokeColor:"rgba(0,0,0,0)"},_seriesIndex:e,_dataIndex:t};if(i){var x=((E.style.startAngle+E.style.endAngle)/2).toFixed(2)-0;E.style._hasSelected=!0,E.style._x=E.style.x,E.style._y=E.style.y;var C=h.deepQuery([g],"selectedOffset");E.style.x+=f.cos(x,!0)*C,E.style.y-=f.sin(x,!0)*C,m[e][t]=!0}else m[e][t]=!1;v&&(E.onclick=h.shapeHandler.onclick),h.deepQuery([y,g,r],"calculable")&&(h.setCalculable(E),E.draggable=!0),T(g,y,!1)&&h.deepQuery([y,g],"itemStyle.normal.label.position")=="inner"&&(E.style.text=S(e,t,n,"normal"),E.style.textPosition="specific",E.style.textColor=h.deepQuery([y,g],"itemStyle.normal.label.textStyle.color")||"#fff",E.style.textAlign=h.deepQuery([y,g],"itemStyle.normal.label.textStyle.align")||"center",E.style.textBaseLine=h.deepQuery([y,g],"itemStyle.normal.label.textStyle.baseline")||"middle",E.style.textX=Math.round(g.center[0]+(o+s)/2*f.cos((u+a)/2,!0)),E.style.textY=Math.round(g.center[1]-(o+s)/2*f.sin((u+a)/2,!0)),E.style.textFont=h.getFont(h.deepQuery([y,g],"itemStyle.normal.label.textStyle"))),T(g,y,!0)&&h.deepQuery([y,g],"itemStyle.emphasis.label.position")=="inner"&&(E.highlightStyle.text=S(e,t,n,"emphasis"),E.highlightStyle.textPosition="specific",E.highlightStyle.textColor=h.deepQuery([y,g],"itemStyle.emphasis.label.textStyle.color")||"#fff",E.highlightStyle.textAlign=h.deepQuery([y,g],"itemStyle.emphasis.label.textStyle.align")||"center",E.highlightStyle.textBaseLine=h.deepQuery([y,g],"itemStyle.normal.label.textStyle.baseline")||"middle",E.highlightStyle.textX=Math.round(g.center[0]+(o+s)/2*f.cos((u+a)/2,!0)),E.highlightStyle.textY=Math.round(g.center[1]-(o+s)/2*f.sin((u+a)/2,!0)),E.highlightStyle.textFont=h.getFont(h.deepQuery([y,g],"itemStyle.emphasis.label.textStyle")));if(T(g,y,!0)||N(g,y,!0))E.onmouseover=h.shapeHandler.onmouserover;return E}function E(e,t,n,r,i,s,o){var u=p[e],a=u.data[t];if(T(u,a,o)){var c=o?"emphasis":"normal",v=l.merge(l.clone(a.itemStyle)||{},u.itemStyle,{overwrite:!1,recursive:!0}),m=v[c].label,g=m.textStyle||{},y=u.center[0],b=u.center[1],w=(i+r)/2%360,E,x;if(m.position=="outer")return E=u.radius[1]- -v[c].labelLine.length- -g.fontSize,x=w>=150&&w<=210?"right":w<=30||w>=330?"left":"center",{shape:"text",zlevel:d+1,hoverable:!1,style:{x:y+E*f.cos(w,!0),y:b-E*f.sin(w,!0),color:g.color||s,text:S(e,t,n,c),textAlign:g.align||x,textBaseline:g.baseline||"middle",textFont:h.getFont(g)},highlightStyle:{brushType:"fill"},_seriesIndex:e,_dataIndex:t};if(m.position=="center")return{shape:"text",zlevel:d+1,hoverable:!1,style:{x:y,y:b,color:g.color||s,text:S(e,t,n,c),textAlign:g.align||"center",textBaseline:g.baseline||"middle",textFont:h.getFont(g)},highlightStyle:{brushType:"fill"},_seriesIndex:e,_dataIndex:t};return}return}function S(e,t,n,r){var i=p[e],s=i.data[t],o=h.deepQuery([s,i],"itemStyle."+r+".label.formatter");if(!o)return s.name;if(typeof o=="function")return o(i.name,s.name,s.value,n);if(typeof o=="string")return o=o.replace("{a}","{a0}").replace("{b}","{b0}").replace("{c}","{c0}").replace("{d}","{d0}"),o=o.replace("{a0}",i.name).replace("{b0}",s.name).replace("{c0}",s.value).replace("{d0}",n),o}function x(e,t,n,r,i,s,o,u){var a=p[e],c=a.data[t];if(N(a,c,u)){var h=u?"emphasis":"normal",v=l.merge(l.clone(c.itemStyle)||{},a.itemStyle,{overwrite:!1,recursive:!0}),m=v[h].labelLine,g=m.lineStyle||{},y=a.center[0],b=a.center[1],w=r,E=a.radius[1]- -m.length,S=(s+i)/2%360,x=f.cos(S,!0),T=f.sin(S,!0);return{shape:"line",zlevel:d+1,hoverable:!1,style:{xStart:y+w*x,yStart:b-w*T,xEnd:y+E*x,yEnd:b-E*T,strokeColor:g.color||o,lineType:g.type,lineWidth:g.width},_seriesIndex:e,_dataIndex:t}}return}function T(e,t,n){return h.deepQuery([t,e],"itemStyle."+(n?"emphasis":"normal")+".label.show")}function N(e,t,n){return h.deepQuery([t,e],"itemStyle."+(n?"emphasis":"normal")+".labelLine.show")}function C(e){var t=l.merge;return e=t(e||{},u.pie,{overwrite:!1,recursive:!0}),e.center=h.parseCenter(e.center),typeof e.radius=="undefined"?e.radius=[0,Math.round(Math.min(n.getWidth(),n.getHeight())/2-50)]:e.radius instanceof Array||(e.radius=[0,e.radius]),e.itemStyle.normal.label.textStyle=t(e.itemStyle.normal.label.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),e.itemStyle.emphasis.label.textStyle=t(e.itemStyle.emphasis.label.textStyle||{},u.textStyle,{overwrite:!1,recursive:!0}),e}function k(e,t){i=t,L(e)}function L(e){e&&(r=e,p=r.series,h.backupAdaptiveParams(p,["center","radius"])),h.clear(),g()}function A(){h.restoreAdaptiveParams(p,["center","radius"]),L()}function O(e){var t={};for(var r=0,i=e.length;r<i;r++)t[e[r][0]]=e[r];var s={},o={},a={},f=l.clone(h.shapeList);h.shapeList=[];var c,d,v,m={};for(var r=0,i=e.length;r<i;r++)c=e[r][0],d=e[r][2],v=e[r][3],p[c]&&p[c].type==u.CHART_TYPE_PIE&&(d?(v||(s[c+"_"+p[c].data.length]="delete"),m[c]=1):v?m[c]=0:(s[c+"_-1"]="delete",m[c]=-1),y(c));var g,b;for(var r=0,i=h.shapeList.length;r<i;r++){c=h.shapeList[r]._seriesIndex,g=h.shapeList[r]._dataIndex,b=c+"_"+g;switch(h.shapeList[r].shape){case"sector":s[b]=h.shapeList[r];break;case"text":o[b]=h.shapeList[r];break;case"line":a[b]=h.shapeList[r]}}h.shapeList=[];var w;for(var r=0,i=f.length;r<i;r++){c=f[r]._seriesIndex;if(t[c]){g=f[r]._dataIndex+m[c],b=c+"_"+g,w=s[b];if(!w)continue;if(f[r].shape=="sector")w!="delete"?n.animate(f[r].id,"style").when(400,{startAngle:w.style.startAngle,endAngle:w.style.endAngle}).start():n.animate(f[r].id,"style").when(400,m[c]<0?{endAngle:f[r].style.startAngle}:{startAngle:f[r].style.endAngle}).start();else if(f[r].shape=="text"||f[r].shape=="line")if(w=="delete")n.delShape(f[r].id);else switch(f[r].shape){case"text":w=o[b],n.animate(f[r].id,"style").when(400,{x:w.style.x,y:w.style.y}).start();break;case"line":w=a[b],n.animate(f[r].id,"style").when(400,{xStart:w.style.xStart,yStart:w.style.yStart,xEnd:w.style.xEnd,yEnd:w.style.yEnd}).start()}}}h.shapeList=f}function M(){var e=h.deepQuery([r],"animationDuration"),t=h.deepQuery([r],"animationEasing"),i,s,o,u,f,l;for(var c=0,p=h.shapeList.length;c<p;c++)h.shapeList[c].shape=="sector"||h.shapeList[c].shape=="circle"||h.shapeList[c].shape=="ring"?(i=h.shapeList[c].style.x,s=h.shapeList[c].style.y,o=h.shapeList[c].style.r0,u=h.shapeList[c].style.r,n.modShape(h.shapeList[c].id,{rotation:[Math.PI*2,i,s],style:{r0:0,r:0}}),f=a.get(h.shapeList[c],"series"),l=a.get(h.shapeList[c],"dataIndex"),n.animate(h.shapeList[c].id,"style").when((h.deepQuery([f],"animationDuration")||e)+l*10,{r0:o,r:u}).start("QuinticOut"),n.animate(h.shapeList[c].id,"").when((h.deepQuery([f],"animationDuration")||e)+l*100,{rotation:[0,i,s]}).start(h.deepQuery([f],"animationEasing")||t)):(l=h.shapeList[c]._dataIndex,n.modShape(h.shapeList[c].id,{scale:[0,0,i,s]}),n.animate(h.shapeList[c].id,"").when(e+l*100,{scale:[1,1,i,s]}).start("QuinticOut"))}function _(e){if(!h.isClick||!e.target)return;var r,i=e.target,s=i.style,o=a.get(i,"seriesIndex"),l=a.get(i,"dataIndex");for(var c=0,d=h.shapeList.length;c<d;c++)if(h.shapeList[c].id==i.id){o=a.get(i,"seriesIndex"),l=a.get(i,"dataIndex");if(!s._hasSelected){var g=((s.startAngle+s.endAngle)/2).toFixed(2)-0;i.style._hasSelected=!0,m[o][l]=!0,i.style._x=i.style.x,i.style._y=i.style.y,r=h.deepQuery([p[o]],"selectedOffset"),i.style.x+=f.cos(g,!0)*r,i.style.y-=f.sin(g,!0)*r}else i.style.x=i.style._x,i.style.y=i.style._y,i.style._hasSelected=!1,m[o][l]=!1;n.modShape(i.id,i)}else h.shapeList[c].style._hasSelected&&v=="single"&&(o=a.get(h.shapeList[c],"seriesIndex"),l=a.get(h.shapeList[c],"dataIndex"),h.shapeList[c].style.x=h.shapeList[c].style._x,h.shapeList[c].style.y=h.shapeList[c].style._y,h.shapeList[c].style._hasSelected=!1,m[o][l]=!1,n.modShape(h.shapeList[c].id,h.shapeList[c]));t.dispatch(u.EVENT.PIE_SELECTED,e.event,{selected:m}),n.refresh()}function D(e,t){if(!h.isDrop||!e.target)return;var n=e.target,s=e.dragged,o=a.get(n,"seriesIndex"),u=a.get(n,"dataIndex"),f,l=i.legend;u==-1?(f={value:a.get(s,"value"),name:a.get(s,"name")},f.value<0&&(f.value=0),p[o].data.push(f),l.add(f.name,s.style.color||s.style.strokeColor)):(f=p[o].data[u],l.del(f.name),f.name+=r.nameConnector+a.get(s,"name"),f.value+=a.get(s,"value"),l.add(f.name,s.style.color||s.style.strokeColor)),t.dragIn=t.dragIn||!0,h.isDrop=!1;return}function P(e,t){if(!h.isDragend||!e.target)return;var n=e.target,r=a.get(n,"seriesIndex"),s=a.get(n,"dataIndex");i.legend.del(p[r].data[s].name),p[r].data.splice(s,1),t.dragOut=!0,t.needRefresh=!0,h.isDragend=!1;return}var s=e("../component/base");s.call(this,n);var o=e("./calculableBase");o.call(this,n,r);var u=e("../config"),a=e("../util/ecData"),f=e("zrender/tool/math"),l=e("zrender/tool/util"),c=e("zrender/tool/color"),h=this;h.type=u.CHART_TYPE_PIE;var p,d=h.getZlevelBase(),v,m={};h.shapeHandler.onmouserover=function(e){var t=e.target,r=a.get(t,"seriesIndex"),i=a.get(t,"dataIndex"),s=a.get(t,"special"),o=t.style.startAngle,u=t.style.endAngle,f=t.highlightStyle.color,l=E(r,i,s,o,u,f,!0);l&&n.addHoverShape(l);var c=x(r,i,t.style.r0,t.style.r,o,u,f,!0);c&&n.addHoverShape(c)},h.reformOption=C,h.init=k,h.refresh=L,h.resize=A,h.addDataAnimation=O,h.animation=M,h.onclick=_,h.ondrop=D,h.ondragend=P,k(r,i)}return e("../chart").define("pie",t),t});