// Code generated by protoc-gen-go.
// source: query.proto
// DO NOT EDIT!

/*
Package query is a generated protocol buffer package.

It is generated from these files:
	query.proto

It has these top-level messages:
	Target
	VTGateCallerID
	EventToken
	Value
	BindVariable
	BoundQuery
	ExecuteOptions
	Field
	Row
	ResultExtras
	QueryResult
	StreamEvent
	ExecuteRequest
	ExecuteResponse
	ResultWithError
	ExecuteBatchRequest
	ExecuteBatchResponse
	StreamExecuteRequest
	StreamExecuteResponse
	BeginRequest
	BeginResponse
	CommitRequest
	CommitResponse
	RollbackRequest
	RollbackResponse
	PrepareRequest
	PrepareResponse
	CommitPreparedRequest
	CommitPreparedResponse
	RollbackPreparedRequest
	RollbackPreparedResponse
	CreateTransactionRequest
	CreateTransactionResponse
	StartCommitRequest
	StartCommitResponse
	SetRollbackRequest
	SetRollbackResponse
	ConcludeTransactionRequest
	ConcludeTransactionResponse
	ReadTransactionRequest
	ReadTransactionResponse
	BeginExecuteRequest
	BeginExecuteResponse
	BeginExecuteBatchRequest
	BeginExecuteBatchResponse
	MessageStreamRequest
	MessageStreamResponse
	MessageAckRequest
	MessageAckResponse
	SplitQueryRequest
	QuerySplit
	SplitQueryResponse
	StreamHealthRequest
	RealtimeStats
	StreamHealthResponse
	UpdateStreamRequest
	UpdateStreamResponse
	TransactionMetadata
*/
package query

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import topodata "github.com/youtube/vitess/go/vt/proto/topodata"
import vtrpc "github.com/youtube/vitess/go/vt/proto/vtrpc"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Flags sent from the MySQL C API
type MySqlFlag int32

const (
	MySqlFlag_EMPTY                 MySqlFlag = 0
	MySqlFlag_NOT_NULL_FLAG         MySqlFlag = 1
	MySqlFlag_PRI_KEY_FLAG          MySqlFlag = 2
	MySqlFlag_UNIQUE_KEY_FLAG       MySqlFlag = 4
	MySqlFlag_MULTIPLE_KEY_FLAG     MySqlFlag = 8
	MySqlFlag_BLOB_FLAG             MySqlFlag = 16
	MySqlFlag_UNSIGNED_FLAG         MySqlFlag = 32
	MySqlFlag_ZEROFILL_FLAG         MySqlFlag = 64
	MySqlFlag_BINARY_FLAG           MySqlFlag = 128
	MySqlFlag_ENUM_FLAG             MySqlFlag = 256
	MySqlFlag_AUTO_INCREMENT_FLAG   MySqlFlag = 512
	MySqlFlag_TIMESTAMP_FLAG        MySqlFlag = 1024
	MySqlFlag_SET_FLAG              MySqlFlag = 2048
	MySqlFlag_NO_DEFAULT_VALUE_FLAG MySqlFlag = 4096
	MySqlFlag_ON_UPDATE_NOW_FLAG    MySqlFlag = 8192
	MySqlFlag_NUM_FLAG              MySqlFlag = 32768
	MySqlFlag_PART_KEY_FLAG         MySqlFlag = 16384
	MySqlFlag_GROUP_FLAG            MySqlFlag = 32768
	MySqlFlag_UNIQUE_FLAG           MySqlFlag = 65536
	MySqlFlag_BINCMP_FLAG           MySqlFlag = 131072
)

var MySqlFlag_name = map[int32]string{
	0:     "EMPTY",
	1:     "NOT_NULL_FLAG",
	2:     "PRI_KEY_FLAG",
	4:     "UNIQUE_KEY_FLAG",
	8:     "MULTIPLE_KEY_FLAG",
	16:    "BLOB_FLAG",
	32:    "UNSIGNED_FLAG",
	64:    "ZEROFILL_FLAG",
	128:   "BINARY_FLAG",
	256:   "ENUM_FLAG",
	512:   "AUTO_INCREMENT_FLAG",
	1024:  "TIMESTAMP_FLAG",
	2048:  "SET_FLAG",
	4096:  "NO_DEFAULT_VALUE_FLAG",
	8192:  "ON_UPDATE_NOW_FLAG",
	32768: "NUM_FLAG",
	16384: "PART_KEY_FLAG",
	// Duplicate value: 32768: "GROUP_FLAG",
	65536:  "UNIQUE_FLAG",
	131072: "BINCMP_FLAG",
}
var MySqlFlag_value = map[string]int32{
	"EMPTY":                 0,
	"NOT_NULL_FLAG":         1,
	"PRI_KEY_FLAG":          2,
	"UNIQUE_KEY_FLAG":       4,
	"MULTIPLE_KEY_FLAG":     8,
	"BLOB_FLAG":             16,
	"UNSIGNED_FLAG":         32,
	"ZEROFILL_FLAG":         64,
	"BINARY_FLAG":           128,
	"ENUM_FLAG":             256,
	"AUTO_INCREMENT_FLAG":   512,
	"TIMESTAMP_FLAG":        1024,
	"SET_FLAG":              2048,
	"NO_DEFAULT_VALUE_FLAG": 4096,
	"ON_UPDATE_NOW_FLAG":    8192,
	"NUM_FLAG":              32768,
	"PART_KEY_FLAG":         16384,
	"GROUP_FLAG":            32768,
	"UNIQUE_FLAG":           65536,
	"BINCMP_FLAG":           131072,
}

func (x MySqlFlag) String() string {
	return proto.EnumName(MySqlFlag_name, int32(x))
}
func (MySqlFlag) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Flag allows us to qualify types by their common properties.
type Flag int32

const (
	Flag_NONE       Flag = 0
	Flag_ISINTEGRAL Flag = 256
	Flag_ISUNSIGNED Flag = 512
	Flag_ISFLOAT    Flag = 1024
	Flag_ISQUOTED   Flag = 2048
	Flag_ISTEXT     Flag = 4096
	Flag_ISBINARY   Flag = 8192
)

var Flag_name = map[int32]string{
	0:    "NONE",
	256:  "ISINTEGRAL",
	512:  "ISUNSIGNED",
	1024: "ISFLOAT",
	2048: "ISQUOTED",
	4096: "ISTEXT",
	8192: "ISBINARY",
}
var Flag_value = map[string]int32{
	"NONE":       0,
	"ISINTEGRAL": 256,
	"ISUNSIGNED": 512,
	"ISFLOAT":    1024,
	"ISQUOTED":   2048,
	"ISTEXT":     4096,
	"ISBINARY":   8192,
}

func (x Flag) String() string {
	return proto.EnumName(Flag_name, int32(x))
}
func (Flag) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Type defines the various supported data types in bind vars
// and query results.
type Type int32

const (
	// NULL_TYPE specifies a NULL type.
	Type_NULL_TYPE Type = 0
	// INT8 specifies a TINYINT type.
	// Properties: 1, IsNumber.
	Type_INT8 Type = 257
	// UINT8 specifies a TINYINT UNSIGNED type.
	// Properties: 2, IsNumber, IsUnsigned.
	Type_UINT8 Type = 770
	// INT16 specifies a SMALLINT type.
	// Properties: 3, IsNumber.
	Type_INT16 Type = 259
	// UINT16 specifies a SMALLINT UNSIGNED type.
	// Properties: 4, IsNumber, IsUnsigned.
	Type_UINT16 Type = 772
	// INT24 specifies a MEDIUMINT type.
	// Properties: 5, IsNumber.
	Type_INT24 Type = 261
	// UINT24 specifies a MEDIUMINT UNSIGNED type.
	// Properties: 6, IsNumber, IsUnsigned.
	Type_UINT24 Type = 774
	// INT32 specifies a INTEGER type.
	// Properties: 7, IsNumber.
	Type_INT32 Type = 263
	// UINT32 specifies a INTEGER UNSIGNED type.
	// Properties: 8, IsNumber, IsUnsigned.
	Type_UINT32 Type = 776
	// INT64 specifies a BIGINT type.
	// Properties: 9, IsNumber.
	Type_INT64 Type = 265
	// UINT64 specifies a BIGINT UNSIGNED type.
	// Properties: 10, IsNumber, IsUnsigned.
	Type_UINT64 Type = 778
	// FLOAT32 specifies a FLOAT type.
	// Properties: 11, IsFloat.
	Type_FLOAT32 Type = 1035
	// FLOAT64 specifies a DOUBLE or REAL type.
	// Properties: 12, IsFloat.
	Type_FLOAT64 Type = 1036
	// TIMESTAMP specifies a TIMESTAMP type.
	// Properties: 13, IsQuoted.
	Type_TIMESTAMP Type = 2061
	// DATE specifies a DATE type.
	// Properties: 14, IsQuoted.
	Type_DATE Type = 2062
	// TIME specifies a TIME type.
	// Properties: 15, IsQuoted.
	Type_TIME Type = 2063
	// DATETIME specifies a DATETIME type.
	// Properties: 16, IsQuoted.
	Type_DATETIME Type = 2064
	// YEAR specifies a YEAR type.
	// Properties: 17, IsNumber, IsUnsigned.
	Type_YEAR Type = 785
	// DECIMAL specifies a DECIMAL or NUMERIC type.
	// Properties: 18, None.
	Type_DECIMAL Type = 18
	// TEXT specifies a TEXT type.
	// Properties: 19, IsQuoted, IsText.
	Type_TEXT Type = 6163
	// BLOB specifies a BLOB type.
	// Properties: 20, IsQuoted, IsBinary.
	Type_BLOB Type = 10260
	// VARCHAR specifies a VARCHAR type.
	// Properties: 21, IsQuoted, IsText.
	Type_VARCHAR Type = 6165
	// VARBINARY specifies a VARBINARY type.
	// Properties: 22, IsQuoted, IsBinary.
	Type_VARBINARY Type = 10262
	// CHAR specifies a CHAR type.
	// Properties: 23, IsQuoted, IsText.
	Type_CHAR Type = 6167
	// BINARY specifies a BINARY type.
	// Properties: 24, IsQuoted, IsBinary.
	Type_BINARY Type = 10264
	// BIT specifies a BIT type.
	// Properties: 25, IsQuoted.
	Type_BIT Type = 2073
	// ENUM specifies an ENUM type.
	// Properties: 26, IsQuoted.
	Type_ENUM Type = 2074
	// SET specifies a SET type.
	// Properties: 27, IsQuoted.
	Type_SET Type = 2075
	// TUPLE specifies a a tuple. This cannot
	// be returned in a QueryResult, but it can
	// be sent as a bind var.
	// Properties: 28, None.
	Type_TUPLE Type = 28
	// GEOMETRY specifies a GEOMETRY type.
	// Properties: 29, IsQuoted.
	Type_GEOMETRY Type = 2077
	// JSON specified a JSON type.
	// Properties: 30, IsQuoted.
	Type_JSON Type = 2078
)

var Type_name = map[int32]string{
	0:     "NULL_TYPE",
	257:   "INT8",
	770:   "UINT8",
	259:   "INT16",
	772:   "UINT16",
	261:   "INT24",
	774:   "UINT24",
	263:   "INT32",
	776:   "UINT32",
	265:   "INT64",
	778:   "UINT64",
	1035:  "FLOAT32",
	1036:  "FLOAT64",
	2061:  "TIMESTAMP",
	2062:  "DATE",
	2063:  "TIME",
	2064:  "DATETIME",
	785:   "YEAR",
	18:    "DECIMAL",
	6163:  "TEXT",
	10260: "BLOB",
	6165:  "VARCHAR",
	10262: "VARBINARY",
	6167:  "CHAR",
	10264: "BINARY",
	2073:  "BIT",
	2074:  "ENUM",
	2075:  "SET",
	28:    "TUPLE",
	2077:  "GEOMETRY",
	2078:  "JSON",
}
var Type_value = map[string]int32{
	"NULL_TYPE": 0,
	"INT8":      257,
	"UINT8":     770,
	"INT16":     259,
	"UINT16":    772,
	"INT24":     261,
	"UINT24":    774,
	"INT32":     263,
	"UINT32":    776,
	"INT64":     265,
	"UINT64":    778,
	"FLOAT32":   1035,
	"FLOAT64":   1036,
	"TIMESTAMP": 2061,
	"DATE":      2062,
	"TIME":      2063,
	"DATETIME":  2064,
	"YEAR":      785,
	"DECIMAL":   18,
	"TEXT":      6163,
	"BLOB":      10260,
	"VARCHAR":   6165,
	"VARBINARY": 10262,
	"CHAR":      6167,
	"BINARY":    10264,
	"BIT":       2073,
	"ENUM":      2074,
	"SET":       2075,
	"TUPLE":     28,
	"GEOMETRY":  2077,
	"JSON":      2078,
}

func (x Type) String() string {
	return proto.EnumName(Type_name, int32(x))
}
func (Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// TransactionState represents the state of a distributed transaction.
type TransactionState int32

const (
	TransactionState_UNKNOWN  TransactionState = 0
	TransactionState_PREPARE  TransactionState = 1
	TransactionState_COMMIT   TransactionState = 2
	TransactionState_ROLLBACK TransactionState = 3
)

var TransactionState_name = map[int32]string{
	0: "UNKNOWN",
	1: "PREPARE",
	2: "COMMIT",
	3: "ROLLBACK",
}
var TransactionState_value = map[string]int32{
	"UNKNOWN":  0,
	"PREPARE":  1,
	"COMMIT":   2,
	"ROLLBACK": 3,
}

func (x TransactionState) String() string {
	return proto.EnumName(TransactionState_name, int32(x))
}
func (TransactionState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type ExecuteOptions_IncludedFields int32

const (
	ExecuteOptions_TYPE_AND_NAME ExecuteOptions_IncludedFields = 0
	ExecuteOptions_TYPE_ONLY     ExecuteOptions_IncludedFields = 1
	ExecuteOptions_ALL           ExecuteOptions_IncludedFields = 2
)

var ExecuteOptions_IncludedFields_name = map[int32]string{
	0: "TYPE_AND_NAME",
	1: "TYPE_ONLY",
	2: "ALL",
}
var ExecuteOptions_IncludedFields_value = map[string]int32{
	"TYPE_AND_NAME": 0,
	"TYPE_ONLY":     1,
	"ALL":           2,
}

func (x ExecuteOptions_IncludedFields) String() string {
	return proto.EnumName(ExecuteOptions_IncludedFields_name, int32(x))
}
func (ExecuteOptions_IncludedFields) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{6, 0}
}

// The category of one statement.
type StreamEvent_Statement_Category int32

const (
	StreamEvent_Statement_Error StreamEvent_Statement_Category = 0
	StreamEvent_Statement_DML   StreamEvent_Statement_Category = 1
	StreamEvent_Statement_DDL   StreamEvent_Statement_Category = 2
)

var StreamEvent_Statement_Category_name = map[int32]string{
	0: "Error",
	1: "DML",
	2: "DDL",
}
var StreamEvent_Statement_Category_value = map[string]int32{
	"Error": 0,
	"DML":   1,
	"DDL":   2,
}

func (x StreamEvent_Statement_Category) String() string {
	return proto.EnumName(StreamEvent_Statement_Category_name, int32(x))
}
func (StreamEvent_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{11, 0, 0}
}

type SplitQueryRequest_Algorithm int32

const (
	SplitQueryRequest_EQUAL_SPLITS SplitQueryRequest_Algorithm = 0
	SplitQueryRequest_FULL_SCAN    SplitQueryRequest_Algorithm = 1
)

var SplitQueryRequest_Algorithm_name = map[int32]string{
	0: "EQUAL_SPLITS",
	1: "FULL_SCAN",
}
var SplitQueryRequest_Algorithm_value = map[string]int32{
	"EQUAL_SPLITS": 0,
	"FULL_SCAN":    1,
}

func (x SplitQueryRequest_Algorithm) String() string {
	return proto.EnumName(SplitQueryRequest_Algorithm_name, int32(x))
}
func (SplitQueryRequest_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{49, 0}
}

// Target describes what the client expects the tablet is.
// If the tablet does not match, an error is returned.
type Target struct {
	Keyspace   string              `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	Shard      string              `protobuf:"bytes,2,opt,name=shard" json:"shard,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
}

func (m *Target) Reset()                    { *m = Target{} }
func (m *Target) String() string            { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()               {}
func (*Target) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Target) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Target) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Target) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

// VTGateCallerID is sent by VTGate to VTTablet to describe the
// caller. If possible, this information is secure. For instance,
// if using unique certificates that guarantee that VTGate->VTTablet
// traffic cannot be spoofed, then VTTablet can trust this information,
// and VTTablet will use it for tablet ACLs, for instance.
// Because of this security guarantee, this is different than the CallerID
// structure, which is not secure at all, because it is provided
// by the Vitess client.
type VTGateCallerID struct {
	Username string   `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	Groups   []string `protobuf:"bytes,2,rep,name=groups" json:"groups,omitempty"`
}

func (m *VTGateCallerID) Reset()                    { *m = VTGateCallerID{} }
func (m *VTGateCallerID) String() string            { return proto.CompactTextString(m) }
func (*VTGateCallerID) ProtoMessage()               {}
func (*VTGateCallerID) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VTGateCallerID) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *VTGateCallerID) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

// EventToken is a structure that describes a point in time in a
// replication stream on one shard. The most recent known replication
// position can be retrieved from vttablet when executing a query. It
// is also sent with the replication streams from the binlog service.
type EventToken struct {
	// timestamp is the MySQL timestamp of the statements. Seconds since Epoch.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// The shard name that applied the statements. Note this is not set when
	// streaming from a vttablet. It is only used on the client -> vtgate link.
	Shard string `protobuf:"bytes,2,opt,name=shard" json:"shard,omitempty"`
	// The position on the replication stream after this statement was applied.
	// It is not the transaction ID / GTID, but the position / GTIDSet.
	Position string `protobuf:"bytes,3,opt,name=position" json:"position,omitempty"`
}

func (m *EventToken) Reset()                    { *m = EventToken{} }
func (m *EventToken) String() string            { return proto.CompactTextString(m) }
func (*EventToken) ProtoMessage()               {}
func (*EventToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *EventToken) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *EventToken) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *EventToken) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

// Value represents a typed value.
type Value struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Value) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Value) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// BindVariable represents a single bind variable in a Query.
type BindVariable struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// values are set if type is TUPLE.
	Values []*Value `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *BindVariable) Reset()                    { *m = BindVariable{} }
func (m *BindVariable) String() string            { return proto.CompactTextString(m) }
func (*BindVariable) ProtoMessage()               {}
func (*BindVariable) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *BindVariable) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *BindVariable) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *BindVariable) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// BoundQuery is a query with its bind variables
type BoundQuery struct {
	// sql is the SQL query to execute
	Sql string `protobuf:"bytes,1,opt,name=sql" json:"sql,omitempty"`
	// bind_variables is a map of all bind variables to expand in the query
	BindVariables map[string]*BindVariable `protobuf:"bytes,2,rep,name=bind_variables,json=bindVariables" json:"bind_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *BoundQuery) Reset()                    { *m = BoundQuery{} }
func (m *BoundQuery) String() string            { return proto.CompactTextString(m) }
func (*BoundQuery) ProtoMessage()               {}
func (*BoundQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *BoundQuery) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *BoundQuery) GetBindVariables() map[string]*BindVariable {
	if m != nil {
		return m.BindVariables
	}
	return nil
}

// ExecuteOptions is passed around for all Execute calls.
type ExecuteOptions struct {
	// If set, we will try to include an EventToken with the responses.
	IncludeEventToken bool `protobuf:"varint,2,opt,name=include_event_token,json=includeEventToken" json:"include_event_token,omitempty"`
	// If set, the fresher field may be set as a result comparison to this token.
	// This is a shortcut so the application doesn't need to care about
	// comparing EventTokens.
	CompareEventToken *EventToken `protobuf:"bytes,3,opt,name=compare_event_token,json=compareEventToken" json:"compare_event_token,omitempty"`
	// Controls what fields are returned in Field message responses from mysql, i.e.
	// field name, table name, etc. This is an optimization for high-QPS queries where
	// the client knows what it's getting
	IncludedFields ExecuteOptions_IncludedFields `protobuf:"varint,4,opt,name=included_fields,json=includedFields,enum=query.ExecuteOptions_IncludedFields" json:"included_fields,omitempty"`
}

func (m *ExecuteOptions) Reset()                    { *m = ExecuteOptions{} }
func (m *ExecuteOptions) String() string            { return proto.CompactTextString(m) }
func (*ExecuteOptions) ProtoMessage()               {}
func (*ExecuteOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ExecuteOptions) GetIncludeEventToken() bool {
	if m != nil {
		return m.IncludeEventToken
	}
	return false
}

func (m *ExecuteOptions) GetCompareEventToken() *EventToken {
	if m != nil {
		return m.CompareEventToken
	}
	return nil
}

func (m *ExecuteOptions) GetIncludedFields() ExecuteOptions_IncludedFields {
	if m != nil {
		return m.IncludedFields
	}
	return ExecuteOptions_TYPE_AND_NAME
}

// Field describes a single column returned by a query
type Field struct {
	// name of the field as returned by mysql C API
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// vitess-defined type. Conversion function is in sqltypes package.
	Type Type `protobuf:"varint,2,opt,name=type,enum=query.Type" json:"type,omitempty"`
	// Remaining fields from mysql C API.
	// These fields are only populated when ExecuteOptions.included_fields
	// is set to IncludedFields.ALL.
	Table    string `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
	OrgTable string `protobuf:"bytes,4,opt,name=org_table,json=orgTable" json:"org_table,omitempty"`
	Database string `protobuf:"bytes,5,opt,name=database" json:"database,omitempty"`
	OrgName  string `protobuf:"bytes,6,opt,name=org_name,json=orgName" json:"org_name,omitempty"`
	// column_length is really a uint32. All 32 bits can be used.
	ColumnLength uint32 `protobuf:"varint,7,opt,name=column_length,json=columnLength" json:"column_length,omitempty"`
	// charset is actually a uint16. Only the lower 16 bits are used.
	Charset uint32 `protobuf:"varint,8,opt,name=charset" json:"charset,omitempty"`
	// decimals is actualy a uint8. Only the lower 8 bits are used.
	Decimals uint32 `protobuf:"varint,9,opt,name=decimals" json:"decimals,omitempty"`
	// flags is actually a uint16. Only the lower 16 bits are used.
	Flags uint32 `protobuf:"varint,10,opt,name=flags" json:"flags,omitempty"`
}

func (m *Field) Reset()                    { *m = Field{} }
func (m *Field) String() string            { return proto.CompactTextString(m) }
func (*Field) ProtoMessage()               {}
func (*Field) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Field) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Field) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Field) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *Field) GetOrgTable() string {
	if m != nil {
		return m.OrgTable
	}
	return ""
}

func (m *Field) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *Field) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *Field) GetColumnLength() uint32 {
	if m != nil {
		return m.ColumnLength
	}
	return 0
}

func (m *Field) GetCharset() uint32 {
	if m != nil {
		return m.Charset
	}
	return 0
}

func (m *Field) GetDecimals() uint32 {
	if m != nil {
		return m.Decimals
	}
	return 0
}

func (m *Field) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// Row is a database row.
type Row struct {
	// lengths contains the length of each value in values.
	// A length of -1 means that the field is NULL. While
	// reading values, you have to accummulate the length
	// to know the offset where the next value begins in values.
	Lengths []int64 `protobuf:"zigzag64,1,rep,packed,name=lengths" json:"lengths,omitempty"`
	// values contains a concatenation of all values in the row.
	Values []byte `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Row) GetLengths() []int64 {
	if m != nil {
		return m.Lengths
	}
	return nil
}

func (m *Row) GetValues() []byte {
	if m != nil {
		return m.Values
	}
	return nil
}

// ResultExtras contains optional out-of-band information. Usually the
// extras are requested by adding ExecuteOptions flags.
type ResultExtras struct {
	// event_token is populated if the include_event_token flag is set
	// in ExecuteOptions.
	EventToken *EventToken `protobuf:"bytes,1,opt,name=event_token,json=eventToken" json:"event_token,omitempty"`
	// If set, it means the data returned with this result is fresher
	// than the compare_token passed in the ExecuteOptions.
	Fresher bool `protobuf:"varint,2,opt,name=fresher" json:"fresher,omitempty"`
}

func (m *ResultExtras) Reset()                    { *m = ResultExtras{} }
func (m *ResultExtras) String() string            { return proto.CompactTextString(m) }
func (*ResultExtras) ProtoMessage()               {}
func (*ResultExtras) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ResultExtras) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

func (m *ResultExtras) GetFresher() bool {
	if m != nil {
		return m.Fresher
	}
	return false
}

// QueryResult is returned by Execute and ExecuteStream.
//
// As returned by Execute, len(fields) is always equal to len(row)
// (for each row in rows).
//
// As returned by StreamExecute, the first QueryResult has the fields
// set, and subsequent QueryResult have rows set. And as Execute,
// len(QueryResult[0].fields) is always equal to len(row) (for each
// row in rows for each QueryResult in QueryResult[1:]).
type QueryResult struct {
	Fields       []*Field      `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty"`
	RowsAffected uint64        `protobuf:"varint,2,opt,name=rows_affected,json=rowsAffected" json:"rows_affected,omitempty"`
	InsertId     uint64        `protobuf:"varint,3,opt,name=insert_id,json=insertId" json:"insert_id,omitempty"`
	Rows         []*Row        `protobuf:"bytes,4,rep,name=rows" json:"rows,omitempty"`
	Extras       *ResultExtras `protobuf:"bytes,5,opt,name=extras" json:"extras,omitempty"`
}

func (m *QueryResult) Reset()                    { *m = QueryResult{} }
func (m *QueryResult) String() string            { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()               {}
func (*QueryResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *QueryResult) GetFields() []*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *QueryResult) GetRowsAffected() uint64 {
	if m != nil {
		return m.RowsAffected
	}
	return 0
}

func (m *QueryResult) GetInsertId() uint64 {
	if m != nil {
		return m.InsertId
	}
	return 0
}

func (m *QueryResult) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *QueryResult) GetExtras() *ResultExtras {
	if m != nil {
		return m.Extras
	}
	return nil
}

// StreamEvent describes a set of transformations that happened as a
// single transactional unit on a server. It is streamed back by the
// Update Stream calls.
type StreamEvent struct {
	// The statements in this transaction.
	Statements []*StreamEvent_Statement `protobuf:"bytes,1,rep,name=statements" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken *EventToken `protobuf:"bytes,2,opt,name=event_token,json=eventToken" json:"event_token,omitempty"`
}

func (m *StreamEvent) Reset()                    { *m = StreamEvent{} }
func (m *StreamEvent) String() string            { return proto.CompactTextString(m) }
func (*StreamEvent) ProtoMessage()               {}
func (*StreamEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *StreamEvent) GetStatements() []*StreamEvent_Statement {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *StreamEvent) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

// One individual Statement in a transaction.
type StreamEvent_Statement struct {
	Category StreamEvent_Statement_Category `protobuf:"varint,1,opt,name=category,enum=query.StreamEvent_Statement_Category" json:"category,omitempty"`
	// table_name, primary_key_fields and primary_key_values are set for DML.
	TableName        string   `protobuf:"bytes,2,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	PrimaryKeyFields []*Field `protobuf:"bytes,3,rep,name=primary_key_fields,json=primaryKeyFields" json:"primary_key_fields,omitempty"`
	PrimaryKeyValues []*Row   `protobuf:"bytes,4,rep,name=primary_key_values,json=primaryKeyValues" json:"primary_key_values,omitempty"`
	// sql is set for all queries.
	// FIXME(alainjobart) we may not need it for DMLs.
	Sql []byte `protobuf:"bytes,5,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (m *StreamEvent_Statement) Reset()                    { *m = StreamEvent_Statement{} }
func (m *StreamEvent_Statement) String() string            { return proto.CompactTextString(m) }
func (*StreamEvent_Statement) ProtoMessage()               {}
func (*StreamEvent_Statement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11, 0} }

func (m *StreamEvent_Statement) GetCategory() StreamEvent_Statement_Category {
	if m != nil {
		return m.Category
	}
	return StreamEvent_Statement_Error
}

func (m *StreamEvent_Statement) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *StreamEvent_Statement) GetPrimaryKeyFields() []*Field {
	if m != nil {
		return m.PrimaryKeyFields
	}
	return nil
}

func (m *StreamEvent_Statement) GetPrimaryKeyValues() []*Row {
	if m != nil {
		return m.PrimaryKeyValues
	}
	return nil
}

func (m *StreamEvent_Statement) GetSql() []byte {
	if m != nil {
		return m.Sql
	}
	return nil
}

// ExecuteRequest is the payload to Execute
type ExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	TransactionId     int64           `protobuf:"varint,5,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()               {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute
type ExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()               {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ResultWithError represents a query response
// in the form of result or error but not both.
// TODO: To be used in ExecuteBatchResponse and BeginExecuteBatchResponse.
type ResultWithError struct {
	// error contains an query level error, only set if result is unset.
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *QueryResult `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
}

func (m *ResultWithError) Reset()                    { *m = ResultWithError{} }
func (m *ResultWithError) String() string            { return proto.CompactTextString(m) }
func (*ResultWithError) ProtoMessage()               {}
func (*ResultWithError) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ResultWithError) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ResultWithError) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch
type ExecuteBatchRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	TransactionId     int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteBatchRequest) Reset()                    { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchRequest) ProtoMessage()               {}
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch
type ExecuteBatchResponse struct {
	Results []*QueryResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchResponse) Reset()                    { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchResponse) ProtoMessage()               {}
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute
type StreamExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteRequest) Reset()                    { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteRequest) ProtoMessage()               {}
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *StreamExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute
type StreamExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteResponse) Reset()                    { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteResponse) ProtoMessage()               {}
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *StreamExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin
type BeginRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
}

func (m *BeginRequest) Reset()                    { *m = BeginRequest{} }
func (m *BeginRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginRequest) ProtoMessage()               {}
func (*BeginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *BeginRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// BeginResponse is the returned value from Begin
type BeginResponse struct {
	TransactionId int64 `protobuf:"varint,1,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginResponse) Reset()                    { *m = BeginResponse{} }
func (m *BeginResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginResponse) ProtoMessage()               {}
func (*BeginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *BeginResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitRequest is the payload to Commit
type CommitRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *CommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitResponse is the returned value from Commit
type CommitResponse struct {
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

// RollbackRequest is the payload to Rollback
type RollbackRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *RollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// RollbackResponse is the returned value from Rollback
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()               {}
func (*RollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

// PrepareRequest is the payload to Prepare
type PrepareRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *PrepareRequest) Reset()                    { *m = PrepareRequest{} }
func (m *PrepareRequest) String() string            { return proto.CompactTextString(m) }
func (*PrepareRequest) ProtoMessage()               {}
func (*PrepareRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *PrepareRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *PrepareRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *PrepareRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *PrepareRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *PrepareRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// PrepareResponse is the returned value from Prepare
type PrepareResponse struct {
}

func (m *PrepareResponse) Reset()                    { *m = PrepareResponse{} }
func (m *PrepareResponse) String() string            { return proto.CompactTextString(m) }
func (*PrepareResponse) ProtoMessage()               {}
func (*PrepareResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

// CommitPreparedRequest is the payload to CommitPrepared
type CommitPreparedRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *CommitPreparedRequest) Reset()                    { *m = CommitPreparedRequest{} }
func (m *CommitPreparedRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitPreparedRequest) ProtoMessage()               {}
func (*CommitPreparedRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *CommitPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// CommitPreparedResponse is the returned value from CommitPrepared
type CommitPreparedResponse struct {
}

func (m *CommitPreparedResponse) Reset()                    { *m = CommitPreparedResponse{} }
func (m *CommitPreparedResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitPreparedResponse) ProtoMessage()               {}
func (*CommitPreparedResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

// RollbackPreparedRequest is the payload to RollbackPrepared
type RollbackPreparedRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *RollbackPreparedRequest) Reset()                    { *m = RollbackPreparedRequest{} }
func (m *RollbackPreparedRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackPreparedRequest) ProtoMessage()               {}
func (*RollbackPreparedRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *RollbackPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *RollbackPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// RollbackPreparedResponse is the returned value from RollbackPrepared
type RollbackPreparedResponse struct {
}

func (m *RollbackPreparedResponse) Reset()                    { *m = RollbackPreparedResponse{} }
func (m *RollbackPreparedResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackPreparedResponse) ProtoMessage()               {}
func (*RollbackPreparedResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

// CreateTransactionRequest is the payload to CreateTransaction
type CreateTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
	Participants      []*Target       `protobuf:"bytes,5,rep,name=participants" json:"participants,omitempty"`
}

func (m *CreateTransactionRequest) Reset()                    { *m = CreateTransactionRequest{} }
func (m *CreateTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTransactionRequest) ProtoMessage()               {}
func (*CreateTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *CreateTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CreateTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *CreateTransactionRequest) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

// CreateTransactionResponse is the returned value from CreateTransaction
type CreateTransactionResponse struct {
}

func (m *CreateTransactionResponse) Reset()                    { *m = CreateTransactionResponse{} }
func (m *CreateTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateTransactionResponse) ProtoMessage()               {}
func (*CreateTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

// StartCommitRequest is the payload to StartCommit
type StartCommitRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *StartCommitRequest) Reset()                    { *m = StartCommitRequest{} }
func (m *StartCommitRequest) String() string            { return proto.CompactTextString(m) }
func (*StartCommitRequest) ProtoMessage()               {}
func (*StartCommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *StartCommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StartCommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *StartCommitRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// StartCommitResponse is the returned value from StartCommit
type StartCommitResponse struct {
}

func (m *StartCommitResponse) Reset()                    { *m = StartCommitResponse{} }
func (m *StartCommitResponse) String() string            { return proto.CompactTextString(m) }
func (*StartCommitResponse) ProtoMessage()               {}
func (*StartCommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

// SetRollbackRequest is the payload to SetRollback
type SetRollbackRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *SetRollbackRequest) Reset()                    { *m = SetRollbackRequest{} }
func (m *SetRollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*SetRollbackRequest) ProtoMessage()               {}
func (*SetRollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *SetRollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SetRollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *SetRollbackRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// SetRollbackResponse is the returned value from SetRollback
type SetRollbackResponse struct {
}

func (m *SetRollbackResponse) Reset()                    { *m = SetRollbackResponse{} }
func (m *SetRollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*SetRollbackResponse) ProtoMessage()               {}
func (*SetRollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

// ConcludeTransactionRequest is the payload to ConcludeTransaction
type ConcludeTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *ConcludeTransactionRequest) Reset()                    { *m = ConcludeTransactionRequest{} }
func (m *ConcludeTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*ConcludeTransactionRequest) ProtoMessage()               {}
func (*ConcludeTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ConcludeTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ConcludeTransactionResponse is the returned value from ConcludeTransaction
type ConcludeTransactionResponse struct {
}

func (m *ConcludeTransactionResponse) Reset()                    { *m = ConcludeTransactionResponse{} }
func (m *ConcludeTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*ConcludeTransactionResponse) ProtoMessage()               {}
func (*ConcludeTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

// ReadTransactionRequest is the payload to ReadTransaction
type ReadTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *ReadTransactionRequest) Reset()                    { *m = ReadTransactionRequest{} }
func (m *ReadTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadTransactionRequest) ProtoMessage()               {}
func (*ReadTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *ReadTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ReadTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ReadTransactionResponse is the returned value from ReadTransaction
type ReadTransactionResponse struct {
	Metadata *TransactionMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
}

func (m *ReadTransactionResponse) Reset()                    { *m = ReadTransactionResponse{} }
func (m *ReadTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*ReadTransactionResponse) ProtoMessage()               {}
func (*ReadTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *ReadTransactionResponse) GetMetadata() *TransactionMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// BeginExecuteRequest is the payload to BeginExecute
type BeginExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *BeginExecuteRequest) Reset()                    { *m = BeginExecuteRequest{} }
func (m *BeginExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginExecuteRequest) ProtoMessage()               {}
func (*BeginExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *BeginExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BeginExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteResponse is the returned value from BeginExecute
type BeginExecuteResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error  *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	Result *QueryResult    `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginExecuteResponse) Reset()                    { *m = BeginExecuteResponse{} }
func (m *BeginExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginExecuteResponse) ProtoMessage()               {}
func (*BeginExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *BeginExecuteResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BeginExecuteResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// BeginExecuteBatchRequest is the payload to BeginExecuteBatch
type BeginExecuteBatchRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *BeginExecuteBatchRequest) Reset()                    { *m = BeginExecuteBatchRequest{} }
func (m *BeginExecuteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginExecuteBatchRequest) ProtoMessage()               {}
func (*BeginExecuteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *BeginExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *BeginExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteBatchResponse is the returned value from BeginExecuteBatch
type BeginExecuteBatchResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error   *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	Results []*QueryResult  `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginExecuteBatchResponse) Reset()                    { *m = BeginExecuteBatchResponse{} }
func (m *BeginExecuteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginExecuteBatchResponse) ProtoMessage()               {}
func (*BeginExecuteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *BeginExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *MessageStreamRequest) Reset()                    { *m = MessageStreamRequest{} }
func (m *MessageStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*MessageStreamRequest) ProtoMessage()               {}
func (*MessageStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *MessageStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// MessageStreamResponse is a response for MessageStream.
type MessageStreamResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *MessageStreamResponse) Reset()                    { *m = MessageStreamResponse{} }
func (m *MessageStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*MessageStreamResponse) ProtoMessage()               {}
func (*MessageStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *MessageStreamResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// name is the message table name.
	Name string   `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	Ids  []*Value `protobuf:"bytes,5,rep,name=ids" json:"ids,omitempty"`
}

func (m *MessageAckRequest) Reset()                    { *m = MessageAckRequest{} }
func (m *MessageAckRequest) String() string            { return proto.CompactTextString(m) }
func (*MessageAckRequest) ProtoMessage()               {}
func (*MessageAckRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *MessageAckRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageAckRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckRequest) GetIds() []*Value {
	if m != nil {
		return m.Ids
	}
	return nil
}

// MessageAckResponse is the response for MessageAck.
type MessageAckResponse struct {
	// result contains the result of the ack operation.
	// Since this acts like a DML, only
	// RowsAffected is returned in the result.
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *MessageAckResponse) Reset()                    { *m = MessageAckResponse{} }
func (m *MessageAckResponse) String() string            { return proto.CompactTextString(m) }
func (*MessageAckResponse) ProtoMessage()               {}
func (*MessageAckResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *MessageAckResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// SplitQueryRequest is the payload for SplitQuery sent by VTGate to a VTTablet.
// See vtgate.SplitQueryRequest for more details.
type SplitQueryRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	SplitColumn       []string        `protobuf:"bytes,5,rep,name=split_column,json=splitColumn" json:"split_column,omitempty"`
	// Exactly one of the following must be nonzero.
	SplitCount          int64                       `protobuf:"varint,6,opt,name=split_count,json=splitCount" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64                       `protobuf:"varint,8,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart" json:"num_rows_per_query_part,omitempty"`
	Algorithm           SplitQueryRequest_Algorithm `protobuf:"varint,9,opt,name=algorithm,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
}

func (m *SplitQueryRequest) Reset()                    { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryRequest) ProtoMessage()               {}
func (*SplitQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *SplitQueryRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SplitQueryRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitColumn() []string {
	if m != nil {
		return m.SplitColumn
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitCount() int64 {
	if m != nil {
		return m.SplitCount
	}
	return 0
}

func (m *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if m != nil {
		return m.NumRowsPerQueryPart
	}
	return 0
}

func (m *SplitQueryRequest) GetAlgorithm() SplitQueryRequest_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return SplitQueryRequest_EQUAL_SPLITS
}

// QuerySplit represents one query to execute on the tablet
type QuerySplit struct {
	// query is the query to execute
	Query *BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// row_count is the approximate row count the query will return
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount" json:"row_count,omitempty"`
}

func (m *QuerySplit) Reset()                    { *m = QuerySplit{} }
func (m *QuerySplit) String() string            { return proto.CompactTextString(m) }
func (*QuerySplit) ProtoMessage()               {}
func (*QuerySplit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *QuerySplit) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *QuerySplit) GetRowCount() int64 {
	if m != nil {
		return m.RowCount
	}
	return 0
}

// SplitQueryResponse is returned by SplitQuery and represents all the queries
// to execute in order to get the entire data set.
type SplitQueryResponse struct {
	Queries []*QuerySplit `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
}

func (m *SplitQueryResponse) Reset()                    { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryResponse) ProtoMessage()               {}
func (*SplitQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *SplitQueryResponse) GetQueries() []*QuerySplit {
	if m != nil {
		return m.Queries
	}
	return nil
}

// StreamHealthRequest is the payload for StreamHealth
type StreamHealthRequest struct {
}

func (m *StreamHealthRequest) Reset()                    { *m = StreamHealthRequest{} }
func (m *StreamHealthRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamHealthRequest) ProtoMessage()               {}
func (*StreamHealthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

// RealtimeStats contains information about the tablet status
type RealtimeStats struct {
	// health_error is the last error we got from health check,
	// or empty is the server is healthy. This is used for subset selection,
	// we do not send queries to servers that are not healthy.
	HealthError string `protobuf:"bytes,1,opt,name=health_error,json=healthError" json:"health_error,omitempty"`
	// seconds_behind_master is populated for slaves only. It indicates
	// how far behind on (MySQL) replication a slave currently is.  It is used
	// by clients for subset selection (so we don't try to send traffic
	// to tablets that are too far behind).
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// TODO(mberlin): Let's switch it to int64 instead?
	SecondsBehindMaster uint32 `protobuf:"varint,2,opt,name=seconds_behind_master,json=secondsBehindMaster" json:"seconds_behind_master,omitempty"`
	// bin_log_players_count is the number of currently running binlog players.
	// if the value is 0, it means that filtered replication is currently not
	// running on the tablet. If >0, filtered replication is running.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	BinlogPlayersCount int32 `protobuf:"varint,3,opt,name=binlog_players_count,json=binlogPlayersCount" json:"binlog_players_count,omitempty"`
	// seconds_behind_master_filtered_replication is populated for the receiving
	// master of an ongoing filtered replication only.
	// It specifies how far the receiving master lags behind the sending master.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// NOTE: This field must not be evaluated if "bin_log_players_count" is 0.
	SecondsBehindMasterFilteredReplication int64 `protobuf:"varint,4,opt,name=seconds_behind_master_filtered_replication,json=secondsBehindMasterFilteredReplication" json:"seconds_behind_master_filtered_replication,omitempty"`
	// cpu_usage is used for load-based balancing
	CpuUsage float64 `protobuf:"fixed64,5,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	// qps is the average QPS (queries per second) rate in the last XX seconds
	// where XX is usually 60 (See query_service_stats.go).
	Qps float64 `protobuf:"fixed64,6,opt,name=qps" json:"qps,omitempty"`
}

func (m *RealtimeStats) Reset()                    { *m = RealtimeStats{} }
func (m *RealtimeStats) String() string            { return proto.CompactTextString(m) }
func (*RealtimeStats) ProtoMessage()               {}
func (*RealtimeStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *RealtimeStats) GetHealthError() string {
	if m != nil {
		return m.HealthError
	}
	return ""
}

func (m *RealtimeStats) GetSecondsBehindMaster() uint32 {
	if m != nil {
		return m.SecondsBehindMaster
	}
	return 0
}

func (m *RealtimeStats) GetBinlogPlayersCount() int32 {
	if m != nil {
		return m.BinlogPlayersCount
	}
	return 0
}

func (m *RealtimeStats) GetSecondsBehindMasterFilteredReplication() int64 {
	if m != nil {
		return m.SecondsBehindMasterFilteredReplication
	}
	return 0
}

func (m *RealtimeStats) GetCpuUsage() float64 {
	if m != nil {
		return m.CpuUsage
	}
	return 0
}

func (m *RealtimeStats) GetQps() float64 {
	if m != nil {
		return m.Qps
	}
	return 0
}

// StreamHealthResponse is streamed by StreamHealth on a regular basis
type StreamHealthResponse struct {
	// target is the current server type. Only queries with that exact Target
	// record will be accepted.
	Target *Target `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
	// serving is true iff the tablet is serving. A tablet may not be serving
	// if filtered replication is enabled on a master for instance,
	// or if a replica should not be used because the keyspace is being resharded.
	Serving bool `protobuf:"varint,2,opt,name=serving" json:"serving,omitempty"`
	// tablet_externally_reparented_timestamp contains the last time
	// tabletmanager.TabletExternallyReparented was called on this tablet,
	// or 0 if it was never called. This is meant to differentiate two tablets
	// that report a target.TabletType of MASTER, only the one with the latest
	// timestamp should be trusted.
	TabletExternallyReparentedTimestamp int64 `protobuf:"varint,3,opt,name=tablet_externally_reparented_timestamp,json=tabletExternallyReparentedTimestamp" json:"tablet_externally_reparented_timestamp,omitempty"`
	// realtime_stats contains information about the tablet status
	RealtimeStats *RealtimeStats `protobuf:"bytes,4,opt,name=realtime_stats,json=realtimeStats" json:"realtime_stats,omitempty"`
}

func (m *StreamHealthResponse) Reset()                    { *m = StreamHealthResponse{} }
func (m *StreamHealthResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamHealthResponse) ProtoMessage()               {}
func (*StreamHealthResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *StreamHealthResponse) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamHealthResponse) GetServing() bool {
	if m != nil {
		return m.Serving
	}
	return false
}

func (m *StreamHealthResponse) GetTabletExternallyReparentedTimestamp() int64 {
	if m != nil {
		return m.TabletExternallyReparentedTimestamp
	}
	return 0
}

func (m *StreamHealthResponse) GetRealtimeStats() *RealtimeStats {
	if m != nil {
		return m.RealtimeStats
	}
	return nil
}

// UpdateStreamRequest is the payload for UpdateStream. At most one of
// position and timestamp can be set. If neither is set, we will start
// streaming from the current binlog position.
type UpdateStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// If position is set, we will start the streaming from that replication
	// position. Incompatible with timestamp.
	Position string `protobuf:"bytes,4,opt,name=position" json:"position,omitempty"`
	// If timestamp is set, we will start the streaming from the first
	// event in the binlogs that have that timestamp. Incompatible with position.
	Timestamp int64 `protobuf:"varint,5,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *UpdateStreamRequest) Reset()                    { *m = UpdateStreamRequest{} }
func (m *UpdateStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateStreamRequest) ProtoMessage()               {}
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *UpdateStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *UpdateStreamRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *UpdateStreamRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

// UpdateStreamResponse is returned by UpdateStream
type UpdateStreamResponse struct {
	Event *StreamEvent `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
}

func (m *UpdateStreamResponse) Reset()                    { *m = UpdateStreamResponse{} }
func (m *UpdateStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateStreamResponse) ProtoMessage()               {}
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *UpdateStreamResponse) GetEvent() *StreamEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// TransactionMetadata contains the metadata for a distributed transaction.
type TransactionMetadata struct {
	Dtid         string           `protobuf:"bytes,1,opt,name=dtid" json:"dtid,omitempty"`
	State        TransactionState `protobuf:"varint,2,opt,name=state,enum=query.TransactionState" json:"state,omitempty"`
	TimeCreated  int64            `protobuf:"varint,3,opt,name=time_created,json=timeCreated" json:"time_created,omitempty"`
	Participants []*Target        `protobuf:"bytes,4,rep,name=participants" json:"participants,omitempty"`
}

func (m *TransactionMetadata) Reset()                    { *m = TransactionMetadata{} }
func (m *TransactionMetadata) String() string            { return proto.CompactTextString(m) }
func (*TransactionMetadata) ProtoMessage()               {}
func (*TransactionMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *TransactionMetadata) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *TransactionMetadata) GetState() TransactionState {
	if m != nil {
		return m.State
	}
	return TransactionState_UNKNOWN
}

func (m *TransactionMetadata) GetTimeCreated() int64 {
	if m != nil {
		return m.TimeCreated
	}
	return 0
}

func (m *TransactionMetadata) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

func init() {
	proto.RegisterType((*Target)(nil), "query.Target")
	proto.RegisterType((*VTGateCallerID)(nil), "query.VTGateCallerID")
	proto.RegisterType((*EventToken)(nil), "query.EventToken")
	proto.RegisterType((*Value)(nil), "query.Value")
	proto.RegisterType((*BindVariable)(nil), "query.BindVariable")
	proto.RegisterType((*BoundQuery)(nil), "query.BoundQuery")
	proto.RegisterType((*ExecuteOptions)(nil), "query.ExecuteOptions")
	proto.RegisterType((*Field)(nil), "query.Field")
	proto.RegisterType((*Row)(nil), "query.Row")
	proto.RegisterType((*ResultExtras)(nil), "query.ResultExtras")
	proto.RegisterType((*QueryResult)(nil), "query.QueryResult")
	proto.RegisterType((*StreamEvent)(nil), "query.StreamEvent")
	proto.RegisterType((*StreamEvent_Statement)(nil), "query.StreamEvent.Statement")
	proto.RegisterType((*ExecuteRequest)(nil), "query.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "query.ExecuteResponse")
	proto.RegisterType((*ResultWithError)(nil), "query.ResultWithError")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "query.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "query.ExecuteBatchResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "query.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "query.StreamExecuteResponse")
	proto.RegisterType((*BeginRequest)(nil), "query.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "query.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "query.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "query.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "query.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "query.RollbackResponse")
	proto.RegisterType((*PrepareRequest)(nil), "query.PrepareRequest")
	proto.RegisterType((*PrepareResponse)(nil), "query.PrepareResponse")
	proto.RegisterType((*CommitPreparedRequest)(nil), "query.CommitPreparedRequest")
	proto.RegisterType((*CommitPreparedResponse)(nil), "query.CommitPreparedResponse")
	proto.RegisterType((*RollbackPreparedRequest)(nil), "query.RollbackPreparedRequest")
	proto.RegisterType((*RollbackPreparedResponse)(nil), "query.RollbackPreparedResponse")
	proto.RegisterType((*CreateTransactionRequest)(nil), "query.CreateTransactionRequest")
	proto.RegisterType((*CreateTransactionResponse)(nil), "query.CreateTransactionResponse")
	proto.RegisterType((*StartCommitRequest)(nil), "query.StartCommitRequest")
	proto.RegisterType((*StartCommitResponse)(nil), "query.StartCommitResponse")
	proto.RegisterType((*SetRollbackRequest)(nil), "query.SetRollbackRequest")
	proto.RegisterType((*SetRollbackResponse)(nil), "query.SetRollbackResponse")
	proto.RegisterType((*ConcludeTransactionRequest)(nil), "query.ConcludeTransactionRequest")
	proto.RegisterType((*ConcludeTransactionResponse)(nil), "query.ConcludeTransactionResponse")
	proto.RegisterType((*ReadTransactionRequest)(nil), "query.ReadTransactionRequest")
	proto.RegisterType((*ReadTransactionResponse)(nil), "query.ReadTransactionResponse")
	proto.RegisterType((*BeginExecuteRequest)(nil), "query.BeginExecuteRequest")
	proto.RegisterType((*BeginExecuteResponse)(nil), "query.BeginExecuteResponse")
	proto.RegisterType((*BeginExecuteBatchRequest)(nil), "query.BeginExecuteBatchRequest")
	proto.RegisterType((*BeginExecuteBatchResponse)(nil), "query.BeginExecuteBatchResponse")
	proto.RegisterType((*MessageStreamRequest)(nil), "query.MessageStreamRequest")
	proto.RegisterType((*MessageStreamResponse)(nil), "query.MessageStreamResponse")
	proto.RegisterType((*MessageAckRequest)(nil), "query.MessageAckRequest")
	proto.RegisterType((*MessageAckResponse)(nil), "query.MessageAckResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "query.SplitQueryRequest")
	proto.RegisterType((*QuerySplit)(nil), "query.QuerySplit")
	proto.RegisterType((*SplitQueryResponse)(nil), "query.SplitQueryResponse")
	proto.RegisterType((*StreamHealthRequest)(nil), "query.StreamHealthRequest")
	proto.RegisterType((*RealtimeStats)(nil), "query.RealtimeStats")
	proto.RegisterType((*StreamHealthResponse)(nil), "query.StreamHealthResponse")
	proto.RegisterType((*UpdateStreamRequest)(nil), "query.UpdateStreamRequest")
	proto.RegisterType((*UpdateStreamResponse)(nil), "query.UpdateStreamResponse")
	proto.RegisterType((*TransactionMetadata)(nil), "query.TransactionMetadata")
	proto.RegisterEnum("query.MySqlFlag", MySqlFlag_name, MySqlFlag_value)
	proto.RegisterEnum("query.Flag", Flag_name, Flag_value)
	proto.RegisterEnum("query.Type", Type_name, Type_value)
	proto.RegisterEnum("query.TransactionState", TransactionState_name, TransactionState_value)
	proto.RegisterEnum("query.ExecuteOptions_IncludedFields", ExecuteOptions_IncludedFields_name, ExecuteOptions_IncludedFields_value)
	proto.RegisterEnum("query.StreamEvent_Statement_Category", StreamEvent_Statement_Category_name, StreamEvent_Statement_Category_value)
	proto.RegisterEnum("query.SplitQueryRequest_Algorithm", SplitQueryRequest_Algorithm_name, SplitQueryRequest_Algorithm_value)
}

func init() { proto.RegisterFile("query.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2808 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5a, 0xc9, 0x73, 0x1b, 0xc7,
	0xb9, 0xd7, 0x60, 0x23, 0xf0, 0x81, 0x00, 0x87, 0x0d, 0xd2, 0x82, 0x29, 0x2f, 0x7c, 0x63, 0xcb,
	0xe6, 0x93, 0xfd, 0xf8, 0x64, 0x4a, 0x4f, 0xcf, 0x65, 0x67, 0xd1, 0x10, 0x1c, 0xca, 0xb0, 0x80,
	0x01, 0xd4, 0x18, 0xc8, 0xa1, 0xcb, 0x55, 0x53, 0x43, 0xa0, 0x05, 0x4e, 0x11, 0xc0, 0x40, 0x33,
	0x0d, 0xca, 0xb8, 0x29, 0x71, 0x36, 0x67, 0x75, 0x16, 0xc7, 0x59, 0x2a, 0x4e, 0xaa, 0x72, 0xcf,
	0x7f, 0x90, 0xaa, 0x54, 0xfe, 0x80, 0xdc, 0x72, 0x48, 0x72, 0xc8, 0x29, 0x95, 0xca, 0x2d, 0xa7,
	0x1c, 0x72, 0x48, 0xa5, 0x7a, 0x99, 0xc1, 0x80, 0x84, 0x2d, 0x59, 0xc9, 0x85, 0xb2, 0x4f, 0x98,
	0x6f, 0x99, 0xfe, 0xfa, 0xf7, 0x6d, 0xdd, 0xd3, 0x0d, 0xc8, 0xdf, 0x1e, 0x13, 0x7f, 0xb2, 0x39,
	0xf2, 0x3d, 0xea, 0xa1, 0x34, 0x27, 0xd6, 0x8a, 0xd4, 0x1b, 0x79, 0x5d, 0x87, 0x3a, 0x82, 0xbd,
	0x96, 0x3f, 0xa2, 0xfe, 0xa8, 0x23, 0x08, 0xed, 0x36, 0x64, 0x2c, 0xc7, 0xef, 0x11, 0x8a, 0xd6,
	0x20, 0x7b, 0x48, 0x26, 0xc1, 0xc8, 0xe9, 0x90, 0xb2, 0xb2, 0xae, 0x6c, 0xe4, 0x70, 0x44, 0xa3,
	0x15, 0x48, 0x07, 0x07, 0x8e, 0xdf, 0x2d, 0x27, 0xb8, 0x40, 0x10, 0xe8, 0xff, 0x20, 0x4f, 0x9d,
	0xfd, 0x3e, 0xa1, 0x36, 0x9d, 0x8c, 0x48, 0x39, 0xb9, 0xae, 0x6c, 0x14, 0xb7, 0x56, 0x36, 0x23,
	0x73, 0x16, 0x17, 0x5a, 0x93, 0x11, 0xc1, 0x40, 0xa3, 0x67, 0x6d, 0x07, 0x8a, 0x37, 0xad, 0x6b,
	0x0e, 0x25, 0x15, 0xa7, 0xdf, 0x27, 0x7e, 0x75, 0x87, 0x99, 0x1e, 0x07, 0xc4, 0x1f, 0x3a, 0x83,
	0xc8, 0x74, 0x48, 0xa3, 0x47, 0x20, 0xd3, 0xf3, 0xbd, 0xf1, 0x28, 0x28, 0x27, 0xd6, 0x93, 0x1b,
	0x39, 0x2c, 0x29, 0xed, 0x0d, 0x00, 0xe3, 0x88, 0x0c, 0xa9, 0xe5, 0x1d, 0x92, 0x21, 0x7a, 0x0c,
	0x72, 0xd4, 0x1d, 0x90, 0x80, 0x3a, 0x83, 0x11, 0x1f, 0x22, 0x89, 0xa7, 0x8c, 0x0f, 0x98, 0xfe,
	0x1a, 0x64, 0x47, 0x5e, 0xe0, 0x52, 0xd7, 0x1b, 0xf2, 0xb9, 0xe7, 0x70, 0x44, 0x6b, 0x9f, 0x81,
	0xf4, 0x4d, 0xa7, 0x3f, 0x26, 0xe8, 0x49, 0x48, 0x71, 0x70, 0x0a, 0x07, 0x97, 0xdf, 0x14, 0xfe,
	0xe5, 0x98, 0xb8, 0x80, 0x8d, 0x7d, 0xc4, 0x34, 0xf9, 0xd8, 0x8b, 0x58, 0x10, 0xda, 0x21, 0x2c,
	0x6e, 0xbb, 0xc3, 0xee, 0x4d, 0xc7, 0x77, 0x19, 0xf0, 0x07, 0x1c, 0x06, 0x3d, 0x0d, 0x19, 0xfe,
	0x10, 0x94, 0x93, 0xeb, 0xc9, 0x8d, 0xfc, 0xd6, 0xa2, 0x7c, 0x91, 0xcf, 0x0d, 0x4b, 0x99, 0xf6,
	0x1b, 0x05, 0x60, 0xdb, 0x1b, 0x0f, 0xbb, 0x37, 0x98, 0x10, 0xa9, 0x90, 0x0c, 0x6e, 0xf7, 0xa5,
	0x23, 0xd9, 0x23, 0xba, 0x0e, 0xc5, 0x7d, 0x77, 0xd8, 0xb5, 0x8f, 0xe4, 0x74, 0x84, 0x2f, 0xf3,
	0x5b, 0x4f, 0xcb, 0xe1, 0xa6, 0x2f, 0x6f, 0xc6, 0x67, 0x1d, 0x18, 0x43, 0xea, 0x4f, 0x70, 0x61,
	0x3f, 0xce, 0x5b, 0x6b, 0x03, 0x3a, 0xa9, 0xc4, 0x8c, 0x1e, 0x92, 0x49, 0x68, 0xf4, 0x90, 0x4c,
	0xd0, 0x7f, 0xc7, 0x11, 0xe5, 0xb7, 0x4a, 0xa1, 0xad, 0xd8, 0xbb, 0x12, 0xe6, 0x4b, 0x89, 0x17,
	0x15, 0xed, 0xdd, 0x04, 0x14, 0x8d, 0x37, 0x49, 0x67, 0x4c, 0x49, 0x63, 0xc4, 0x62, 0x10, 0xa0,
	0x4d, 0x28, 0xb9, 0xc3, 0x4e, 0x7f, 0xdc, 0x25, 0x36, 0x61, 0xa1, 0xb6, 0x29, 0x8b, 0x35, 0x1f,
	0x2f, 0x8b, 0x97, 0xa5, 0x28, 0x96, 0x04, 0x3a, 0x94, 0x3a, 0xde, 0x60, 0xe4, 0xf8, 0xb3, 0xfa,
	0x49, 0x6e, 0x7f, 0x59, 0xda, 0x9f, 0xea, 0xe3, 0x65, 0xa9, 0x1d, 0x1b, 0xa2, 0x0e, 0x4b, 0x72,
	0xdc, 0xae, 0x7d, 0xcb, 0x25, 0xfd, 0x6e, 0x50, 0x4e, 0xf1, 0x90, 0x85, 0xae, 0x9a, 0x9d, 0xe2,
	0x66, 0x55, 0x2a, 0xef, 0x72, 0x5d, 0x5c, 0x74, 0x67, 0x68, 0xed, 0x65, 0x28, 0xce, 0x6a, 0xa0,
	0x65, 0x28, 0x58, 0x7b, 0x4d, 0xc3, 0xd6, 0xcd, 0x1d, 0xdb, 0xd4, 0xeb, 0x86, 0x7a, 0x06, 0x15,
	0x20, 0xc7, 0x59, 0x0d, 0xb3, 0xb6, 0xa7, 0x2a, 0x68, 0x01, 0x92, 0x7a, 0xad, 0xa6, 0x26, 0x5e,
	0x4d, 0x65, 0x15, 0x35, 0xa1, 0xbd, 0x97, 0x80, 0x34, 0x7f, 0x17, 0x21, 0x48, 0xc5, 0x2a, 0x84,
	0x3f, 0x47, 0x79, 0x95, 0xf8, 0x90, 0xbc, 0xe2, 0xa5, 0x27, 0x33, 0x5c, 0x10, 0xe8, 0x1c, 0xe4,
	0x3c, 0xbf, 0x67, 0x0b, 0x49, 0x4a, 0xe4, 0xbe, 0xe7, 0xf7, 0x78, 0xc1, 0xb2, 0xba, 0x60, 0xe5,
	0xbb, 0xef, 0x04, 0xa4, 0x9c, 0x16, 0xb2, 0x90, 0x46, 0x8f, 0x02, 0xd3, 0xb3, 0xf9, 0x3c, 0x32,
	0x5c, 0xb6, 0xe0, 0xf9, 0x3d, 0x93, 0x4d, 0xe5, 0x29, 0x28, 0x74, 0xbc, 0xfe, 0x78, 0x30, 0xb4,
	0xfb, 0x64, 0xd8, 0xa3, 0x07, 0xe5, 0x85, 0x75, 0x65, 0xa3, 0x80, 0x17, 0x05, 0xb3, 0xc6, 0x79,
	0xa8, 0x0c, 0x0b, 0x9d, 0x03, 0xc7, 0x0f, 0x08, 0x2d, 0x67, 0xb9, 0x38, 0x24, 0xb9, 0x55, 0xd2,
	0x71, 0x07, 0x4e, 0x3f, 0x28, 0xe7, 0xb8, 0x28, 0xa2, 0x19, 0x88, 0x5b, 0x7d, 0xa7, 0x17, 0x94,
	0x81, 0x0b, 0x04, 0xa1, 0xfd, 0x3f, 0x24, 0xb1, 0x77, 0x87, 0x0d, 0x29, 0x0c, 0x06, 0x65, 0x65,
	0x3d, 0xb9, 0x81, 0x70, 0x48, 0xb2, 0xd6, 0x21, 0xab, 0x47, 0x14, 0x55, 0x58, 0x2f, 0x6f, 0xc0,
	0x22, 0x26, 0xc1, 0xb8, 0x4f, 0x8d, 0x37, 0xa9, 0xef, 0x04, 0x68, 0x0b, 0xf2, 0xf1, 0x7c, 0x51,
	0x3e, 0x28, 0x5f, 0x80, 0x4c, 0x13, 0xa5, 0x0c, 0x0b, 0xb7, 0x7c, 0x12, 0x1c, 0x10, 0x5f, 0xe6,
	0x63, 0x48, 0xb2, 0x6a, 0xcc, 0xf3, 0x5a, 0x12, 0x36, 0x58, 0x0d, 0xcb, 0x4c, 0x52, 0x66, 0x6a,
	0x98, 0x07, 0x15, 0x4b, 0x19, 0xf3, 0x9e, 0xef, 0xdd, 0x09, 0x6c, 0xe7, 0xd6, 0x2d, 0xd2, 0xa1,
	0x44, 0xb4, 0xaa, 0x14, 0x5e, 0x64, 0x4c, 0x5d, 0xf2, 0x58, 0xd8, 0xdc, 0x61, 0x40, 0x7c, 0x6a,
	0xbb, 0x5d, 0x1e, 0xd0, 0x14, 0xce, 0x0a, 0x46, 0xb5, 0x8b, 0x9e, 0x80, 0x14, 0x53, 0x2e, 0xa7,
	0xb8, 0x15, 0x90, 0x56, 0xb0, 0x77, 0x07, 0x73, 0x3e, 0x7a, 0x0e, 0x32, 0x84, 0xe3, 0xe5, 0x41,
	0x9d, 0x16, 0x64, 0xdc, 0x15, 0x58, 0xaa, 0x68, 0x3f, 0x4f, 0x42, 0xbe, 0x45, 0x7d, 0xe2, 0x0c,
	0x38, 0x7e, 0xf4, 0x29, 0x80, 0x80, 0x3a, 0x94, 0x0c, 0xc8, 0x90, 0x86, 0x40, 0x1e, 0x93, 0x03,
	0xc4, 0xf4, 0x36, 0x5b, 0xa1, 0x12, 0x8e, 0xe9, 0x1f, 0x77, 0x70, 0xe2, 0x3e, 0x1c, 0xbc, 0xf6,
	0x7e, 0x02, 0x72, 0xd1, 0x68, 0x48, 0x87, 0x6c, 0xc7, 0xa1, 0xa4, 0xe7, 0xf9, 0x13, 0xd9, 0x43,
	0xcf, 0x7f, 0x98, 0xf5, 0xcd, 0x8a, 0x54, 0xc6, 0xd1, 0x6b, 0xe8, 0x71, 0x10, 0x8b, 0x90, 0x48,
	0x5e, 0xb1, 0x12, 0xe4, 0x38, 0x87, 0xa7, 0xef, 0x4b, 0x80, 0x46, 0xbe, 0x3b, 0x70, 0xfc, 0x89,
	0x7d, 0x48, 0x26, 0x61, 0xf1, 0x27, 0xe7, 0x84, 0x4c, 0x95, 0x7a, 0xd7, 0xc9, 0x44, 0x16, 0xf5,
	0x8b, 0xb3, 0xef, 0xca, 0xa4, 0x3b, 0x19, 0x88, 0xd8, 0x9b, 0xbc, 0x83, 0x07, 0x61, 0xaf, 0x4e,
	0xf3, 0xfc, 0x64, 0x8f, 0xda, 0xb3, 0x90, 0x0d, 0x27, 0x8f, 0x72, 0x90, 0x36, 0x7c, 0xdf, 0xf3,
	0xd5, 0x33, 0xac, 0x2b, 0xec, 0xd4, 0x6b, 0xa2, 0x3d, 0xec, 0xec, 0xd4, 0xd4, 0x84, 0xf6, 0xeb,
	0x69, 0xc3, 0xc4, 0xe4, 0xf6, 0x98, 0x04, 0x14, 0x7d, 0x16, 0x4a, 0x84, 0xe7, 0x8a, 0x7b, 0x44,
	0xec, 0x0e, 0x5f, 0x5d, 0x59, 0xa6, 0x88, 0x84, 0x5e, 0xda, 0x14, 0xeb, 0x7e, 0xb8, 0xea, 0xe2,
	0xe5, 0x48, 0x57, 0xb2, 0xba, 0xc8, 0x80, 0x92, 0x3b, 0x18, 0x90, 0xae, 0xeb, 0xd0, 0xf8, 0x00,
	0x22, 0x60, 0xab, 0xe1, 0xe2, 0x33, 0xb3, 0x78, 0xe3, 0xe5, 0xe8, 0x8d, 0x68, 0x98, 0xf3, 0x90,
	0xa1, 0x7c, 0x53, 0x21, 0x7b, 0x6f, 0x21, 0xec, 0x4b, 0x9c, 0x89, 0xa5, 0x10, 0x3d, 0x0b, 0x62,
	0x87, 0xc2, 0x3b, 0xd0, 0x34, 0x21, 0xa6, 0xab, 0x11, 0x16, 0x72, 0x74, 0x1e, 0x8a, 0xd4, 0x77,
	0x86, 0x81, 0xd3, 0x61, 0x5d, 0x97, 0xcd, 0x28, 0xcd, 0x97, 0xf8, 0x42, 0x8c, 0x5b, 0xed, 0xa2,
	0xff, 0x85, 0x05, 0x4f, 0xf4, 0x65, 0xde, 0x9b, 0xa6, 0x33, 0x9e, 0x6d, 0xda, 0x38, 0xd4, 0xd2,
	0x3e, 0x0d, 0x4b, 0x91, 0x07, 0x83, 0x91, 0x37, 0x0c, 0x08, 0xba, 0x00, 0x19, 0x9f, 0x17, 0x84,
	0xf4, 0x1a, 0x92, 0x43, 0xc4, 0x2a, 0x1a, 0x4b, 0x0d, 0xad, 0x0b, 0x4b, 0x82, 0xf3, 0x9a, 0x4b,
	0x0f, 0x78, 0xa0, 0xd0, 0x79, 0x48, 0x13, 0xf6, 0x70, 0xcc, 0xe7, 0xb8, 0x59, 0xe1, 0x72, 0x2c,
	0xa4, 0x31, 0x2b, 0x89, 0x7b, 0x5a, 0xf9, 0x5b, 0x02, 0x4a, 0x72, 0x96, 0xdb, 0x0e, 0xed, 0x1c,
	0x9c, 0xd2, 0x60, 0x3f, 0x07, 0x0b, 0x8c, 0xef, 0x46, 0x85, 0x31, 0x27, 0xdc, 0xa1, 0x06, 0x0b,
	0xb8, 0x13, 0xd8, 0xb1, 0xe8, 0xf2, 0x80, 0x67, 0x71, 0xc1, 0x09, 0xac, 0x29, 0x73, 0x4e, 0x5e,
	0x64, 0xee, 0x91, 0x17, 0x0b, 0xf7, 0x95, 0x17, 0x3b, 0xb0, 0x32, 0xeb, 0x71, 0x99, 0x1c, 0xcf,
	0xc3, 0x82, 0x08, 0x4a, 0xd8, 0x02, 0xe7, 0xc5, 0x2d, 0x54, 0xd1, 0x7e, 0x96, 0x80, 0x15, 0xd9,
	0x9d, 0x3e, 0x1e, 0x65, 0x1a, 0xf3, 0x73, 0xfa, 0xbe, 0xfc, 0x5c, 0x81, 0xd5, 0x63, 0x0e, 0x7a,
	0x80, 0x2a, 0xfc, 0x95, 0x02, 0x8b, 0xdb, 0xa4, 0xe7, 0x0e, 0x4f, 0xa7, 0x7b, 0xb5, 0x2b, 0x50,
	0x90, 0xd3, 0x97, 0xe0, 0x4f, 0x66, 0xb5, 0x32, 0x27, 0xab, 0xb5, 0x3f, 0x2b, 0x50, 0xa8, 0x78,
	0x83, 0x81, 0x4b, 0x4f, 0x69, 0x5e, 0x9d, 0xc4, 0x99, 0x9a, 0x87, 0x53, 0x85, 0x62, 0x08, 0x53,
	0x38, 0x48, 0xfb, 0x8b, 0x02, 0x4b, 0xd8, 0xeb, 0xf7, 0xf7, 0x9d, 0xce, 0xe1, 0xc3, 0x8d, 0x1d,
	0x81, 0x3a, 0x05, 0x2a, 0xd1, 0xff, 0x43, 0x81, 0x62, 0xd3, 0x27, 0xec, 0xc3, 0xe5, 0xa1, 0x06,
	0xcf, 0xbe, 0x77, 0xba, 0x54, 0xae, 0xf5, 0x39, 0xcc, 0x9f, 0xb5, 0x65, 0x58, 0x8a, 0xb0, 0x4b,
	0x7f, 0xfc, 0x41, 0x81, 0x55, 0x91, 0x20, 0x52, 0xd2, 0x3d, 0xa5, 0x6e, 0x09, 0xf1, 0xa6, 0x62,
	0x78, 0xcb, 0xf0, 0xc8, 0x71, 0x6c, 0x12, 0xf6, 0x5b, 0x09, 0x38, 0x1b, 0xe6, 0xc6, 0x29, 0x07,
	0xfe, 0x6f, 0xe4, 0xc3, 0x1a, 0x94, 0x4f, 0x3a, 0x41, 0x7a, 0xe8, 0x9d, 0x04, 0x94, 0x2b, 0x3e,
	0x71, 0x28, 0x89, 0xed, 0x19, 0x1e, 0x9e, 0xdc, 0x40, 0x2f, 0xc0, 0xe2, 0xc8, 0xf1, 0xa9, 0xdb,
	0x71, 0x47, 0x0e, 0xfb, 0x2a, 0x4b, 0xf3, 0x2d, 0xc9, 0xb1, 0x01, 0x66, 0x54, 0xb4, 0x73, 0xf0,
	0xe8, 0x1c, 0x8f, 0x48, 0x7f, 0xfd, 0x53, 0x01, 0xd4, 0xa2, 0x8e, 0x4f, 0x3f, 0x06, 0xab, 0xca,
	0xdc, 0x64, 0x5a, 0x85, 0xd2, 0x0c, 0xfe, 0xb8, 0x5f, 0x08, 0xfd, 0x58, 0xac, 0x38, 0x1f, 0xe8,
	0x97, 0x38, 0x7e, 0xe9, 0x97, 0x3f, 0x29, 0xb0, 0x56, 0xf1, 0xc4, 0xf1, 0xd6, 0x43, 0x59, 0x61,
	0xda, 0xe3, 0x70, 0x6e, 0x2e, 0x40, 0xe9, 0x80, 0x3f, 0x2a, 0xf0, 0x08, 0x26, 0x4e, 0xf7, 0xe1,
	0x04, 0x7f, 0x03, 0xce, 0x9e, 0x00, 0x27, 0x77, 0xa8, 0x57, 0x20, 0x3b, 0x20, 0xd4, 0xe9, 0x3a,
	0xd4, 0x91, 0x90, 0xd6, 0xc2, 0x71, 0xa7, 0xda, 0x75, 0xa9, 0x81, 0x23, 0x5d, 0xed, 0xfd, 0x04,
	0x94, 0xf8, 0x5e, 0xf7, 0x93, 0x0f, 0xa2, 0xf9, 0x1f, 0x44, 0xef, 0x28, 0xb0, 0x32, 0xeb, 0xa0,
	0xe8, 0x9b, 0xe0, 0x3f, 0x7d, 0xae, 0x30, 0xa7, 0x21, 0x24, 0xe7, 0x6d, 0x41, 0x7f, 0x9b, 0x80,
	0x72, 0x7c, 0x4a, 0x9f, 0x9c, 0x41, 0xcc, 0x9e, 0x41, 0x7c, 0xe4, 0x43, 0xa7, 0xf7, 0x14, 0x78,
	0x74, 0x8e, 0x43, 0x3f, 0x5a, 0xa0, 0x63, 0x27, 0x11, 0x89, 0x7b, 0x9e, 0x44, 0xdc, 0x6f, 0xa8,
	0x7f, 0xaf, 0xc0, 0x4a, 0x9d, 0x04, 0x81, 0xd3, 0x23, 0xe2, 0xb3, 0xfc, 0xf4, 0x76, 0x33, 0x7e,
	0xc6, 0x9b, 0x9a, 0x5e, 0x94, 0x68, 0x15, 0x58, 0x3d, 0x06, 0xed, 0x01, 0x8e, 0x1a, 0xfe, 0xae,
	0xc0, 0xb2, 0x1c, 0x45, 0x3f, 0xb5, 0x1b, 0x81, 0x39, 0xde, 0x41, 0x4f, 0x40, 0xd2, 0xed, 0x86,
	0x3b, 0xc8, 0xd9, 0x4b, 0x46, 0x26, 0xd0, 0xae, 0x02, 0x8a, 0xe3, 0x7e, 0x00, 0xd7, 0xfd, 0x2e,
	0x09, 0xcb, 0xad, 0x51, 0xdf, 0xa5, 0x52, 0xf8, 0x70, 0x37, 0xfe, 0xff, 0x82, 0xc5, 0x80, 0x81,
	0xb5, 0xc5, 0xe5, 0x17, 0x77, 0x6c, 0x0e, 0xe7, 0x39, 0xaf, 0xc2, 0x59, 0xe8, 0x49, 0xc8, 0x87,
	0x2a, 0xe3, 0x21, 0x95, 0x07, 0x97, 0x20, 0x35, 0xc6, 0x43, 0x8a, 0x2e, 0xc3, 0xd9, 0xe1, 0x78,
	0x60, 0xf3, 0x5b, 0xa1, 0x11, 0xf1, 0x6d, 0x3e, 0xb2, 0xcd, 0xb6, 0xf3, 0xfc, 0xea, 0x2c, 0x89,
	0x4b, 0xc3, 0xf1, 0x00, 0x7b, 0x77, 0x82, 0x26, 0xf1, 0xb9, 0xf1, 0xa6, 0xe3, 0x53, 0x74, 0x15,
	0x72, 0x4e, 0xbf, 0xe7, 0xf9, 0x2e, 0x3d, 0x18, 0xf0, 0x7b, 0xb4, 0xe2, 0x96, 0x16, 0xde, 0x94,
	0x1c, 0x77, 0xff, 0xa6, 0x1e, 0x6a, 0xe2, 0xe9, 0x4b, 0xda, 0xf3, 0x90, 0x8b, 0xf8, 0x48, 0x85,
	0x45, 0xe3, 0x46, 0x5b, 0xaf, 0xd9, 0xad, 0x66, 0xad, 0x6a, 0xb5, 0xc4, 0x6d, 0xe5, 0x6e, 0xbb,
	0x56, 0xb3, 0x5b, 0x15, 0xdd, 0x54, 0x15, 0x0d, 0x03, 0xf0, 0x21, 0xf9, 0xe0, 0x53, 0x07, 0x29,
	0xf7, 0x70, 0xd0, 0x39, 0xc8, 0xf9, 0xde, 0x1d, 0x89, 0x3d, 0xc1, 0xe1, 0x64, 0x7d, 0xef, 0x0e,
	0x47, 0xae, 0xe9, 0x80, 0xe2, 0x73, 0x95, 0xd9, 0x16, 0x6b, 0xde, 0xca, 0x4c, 0xf3, 0x9e, 0xda,
	0x8f, 0x9a, 0xb7, 0xd8, 0xca, 0xb3, 0x3a, 0x7f, 0x85, 0x38, 0x7d, 0x1a, 0xae, 0x57, 0xda, 0x2f,
	0x12, 0x50, 0xc0, 0x8c, 0xe3, 0x0e, 0x48, 0x8b, 0x3a, 0x34, 0x60, 0x91, 0x3a, 0xe0, 0x2a, 0xf6,
	0xb4, 0xed, 0xe6, 0x70, 0x5e, 0xf0, 0xc4, 0x99, 0xfe, 0x16, 0xac, 0x06, 0xa4, 0xe3, 0x0d, 0xbb,
	0x81, 0xbd, 0x4f, 0x0e, 0xdc, 0x61, 0xd7, 0x1e, 0x38, 0x01, 0x95, 0x17, 0x7f, 0x05, 0x5c, 0x92,
	0xc2, 0x6d, 0x2e, 0xab, 0x73, 0x11, 0xba, 0x08, 0x2b, 0xfb, 0xee, 0xb0, 0xef, 0xf5, 0xec, 0x51,
	0xdf, 0x99, 0x10, 0x3f, 0x90, 0x50, 0x59, 0x7a, 0xa5, 0x31, 0x12, 0xb2, 0xa6, 0x10, 0x89, 0x70,
	0xbf, 0x0e, 0x17, 0xe6, 0x5a, 0xb1, 0x6f, 0xb9, 0x7d, 0x4a, 0x7c, 0xd2, 0xb5, 0x7d, 0x32, 0xea,
	0xbb, 0x1d, 0x87, 0x2f, 0x45, 0x62, 0xef, 0xfe, 0xcc, 0x1c, 0xd3, 0xbb, 0x52, 0x1d, 0x4f, 0xb5,
	0x99, 0xb7, 0x3b, 0xa3, 0xb1, 0x3d, 0x66, 0x05, 0xcc, 0x57, 0x31, 0x05, 0x67, 0x3b, 0xa3, 0x71,
	0x9b, 0xd1, 0x48, 0x85, 0xe4, 0xed, 0x91, 0x58, 0xbc, 0x14, 0xcc, 0x1e, 0xb5, 0xbf, 0x2a, 0xe1,
	0xc1, 0x75, 0xe8, 0xbd, 0x68, 0x71, 0x0a, 0xcb, 0x44, 0xf9, 0xb0, 0x32, 0x29, 0xc3, 0x42, 0x40,
	0xfc, 0x23, 0x77, 0xd8, 0x0b, 0xef, 0x46, 0x25, 0x89, 0x5a, 0xf0, 0x8c, 0xfc, 0xc7, 0x08, 0x79,
	0x93, 0x12, 0x7f, 0xe8, 0xf4, 0xfb, 0x13, 0x5b, 0x7c, 0xb7, 0x0f, 0x29, 0xe9, 0xda, 0xd3, 0xff,
	0x70, 0x88, 0x05, 0xea, 0x29, 0xa1, 0x6d, 0x44, 0xca, 0x38, 0xd2, 0xb5, 0xa2, 0x7f, 0x77, 0xbc,
	0x0c, 0x45, 0x5f, 0xc6, 0xd4, 0x0e, 0x58, 0x50, 0x65, 0x79, 0xae, 0x44, 0x17, 0x9c, 0xb1, 0x80,
	0xe3, 0x82, 0x1f, 0x27, 0xd9, 0xc7, 0x5d, 0xa9, 0x3d, 0xea, 0x3a, 0xf4, 0x74, 0x2f, 0x79, 0xf1,
	0xff, 0xb2, 0xa4, 0x66, 0xff, 0xcb, 0x32, 0xfb, 0xdf, 0x98, 0xf4, 0xb1, 0xff, 0xc6, 0x68, 0x57,
	0x61, 0x65, 0x16, 0xbf, 0x8c, 0xf5, 0x06, 0xa4, 0xf9, 0x6d, 0xec, 0xb1, 0xde, 0x1e, 0xbb, 0x6e,
	0xc5, 0x42, 0x41, 0xfb, 0xa5, 0x02, 0xa5, 0x39, 0xfb, 0xfe, 0xe8, 0xa3, 0x42, 0x89, 0x9d, 0x59,
	0xfc, 0x0f, 0xa4, 0xf9, 0xbd, 0xb0, 0xfc, 0xc3, 0xc2, 0xd9, 0x93, 0x9f, 0x0d, 0xfc, 0x0e, 0x17,
	0x0b, 0x2d, 0x56, 0x9d, 0x3c, 0xac, 0x1d, 0x7e, 0x68, 0x11, 0x6e, 0x5b, 0xf2, 0x8c, 0x27, 0xce,
	0x31, 0x4e, 0x9e, 0x82, 0xa4, 0xee, 0x79, 0x0a, 0x72, 0xe1, 0xbb, 0x49, 0xc8, 0xd5, 0x27, 0xad,
	0xdb, 0xfd, 0xdd, 0xbe, 0xd3, 0xe3, 0x97, 0xac, 0xf5, 0xa6, 0xb5, 0xa7, 0x9e, 0x41, 0xcb, 0x50,
	0x30, 0x1b, 0x96, 0x6d, 0xb2, 0xfe, 0xb6, 0x5b, 0xd3, 0xaf, 0xa9, 0x0a, 0x6b, 0x80, 0x4d, 0x5c,
	0xb5, 0xaf, 0x1b, 0x7b, 0x82, 0x93, 0x40, 0x25, 0x58, 0x6a, 0x9b, 0xd5, 0x1b, 0x6d, 0x63, 0xca,
	0x4c, 0xa1, 0x55, 0x58, 0xae, 0xb7, 0x6b, 0x56, 0xb5, 0x59, 0x8b, 0xb1, 0xb3, 0xac, 0x59, 0x6e,
	0xd7, 0x1a, 0xdb, 0x82, 0x54, 0xd9, 0xf8, 0x6d, 0xb3, 0x55, 0xbd, 0x66, 0x1a, 0x3b, 0x82, 0xb5,
	0xce, 0x58, 0xaf, 0x1b, 0xb8, 0xb1, 0x5b, 0x0d, 0x4d, 0x5e, 0x45, 0x2a, 0xe4, 0xb7, 0xab, 0xa6,
	0x8e, 0xe5, 0x28, 0x77, 0x15, 0x54, 0x84, 0x9c, 0x61, 0xb6, 0xeb, 0x92, 0x4e, 0xa0, 0x32, 0x94,
	0xf4, 0xb6, 0xd5, 0xb0, 0xab, 0x66, 0x05, 0x1b, 0x75, 0xc3, 0xb4, 0xa4, 0x24, 0x85, 0x4a, 0x50,
	0xb4, 0xaa, 0x75, 0xa3, 0x65, 0xe9, 0xf5, 0xa6, 0x64, 0xb2, 0x59, 0x64, 0x5b, 0x46, 0xa8, 0xa3,
	0xa2, 0x35, 0x58, 0x35, 0x1b, 0xf6, 0x8e, 0xb1, 0xab, 0xb7, 0x6b, 0x96, 0x7d, 0x53, 0xaf, 0xb5,
	0x0d, 0x29, 0x5b, 0x47, 0x67, 0x01, 0x35, 0x4c, 0xbb, 0xdd, 0xdc, 0xd1, 0x2d, 0xc3, 0x36, 0x1b,
	0xaf, 0x49, 0xc1, 0x55, 0x54, 0x84, 0xec, 0x74, 0x06, 0x77, 0x99, 0x17, 0x0a, 0x4d, 0x1d, 0x5b,
	0x53, 0xb0, 0x77, 0xef, 0x32, 0x67, 0xc1, 0x35, 0xdc, 0x68, 0x37, 0xa7, 0x6a, 0xcb, 0x90, 0x97,
	0xce, 0x92, 0xac, 0x14, 0x63, 0x6d, 0x57, 0xcd, 0x4a, 0x34, 0xbf, 0xbb, 0xd9, 0xb5, 0x84, 0xaa,
	0x5c, 0x38, 0x84, 0x14, 0x0f, 0x47, 0x16, 0x52, 0x66, 0xc3, 0x34, 0xd4, 0x33, 0x68, 0x09, 0xa0,
	0xda, 0xaa, 0x9a, 0x96, 0x71, 0x0d, 0xeb, 0x35, 0x06, 0x9b, 0x33, 0x42, 0x07, 0x32, 0xb4, 0x8b,
	0xb0, 0x50, 0x6d, 0xed, 0xd6, 0x1a, 0xba, 0x25, 0x61, 0x56, 0x5b, 0x37, 0xda, 0x0d, 0x8b, 0x09,
	0x55, 0x94, 0x87, 0x4c, 0xb5, 0x65, 0x19, 0x9f, 0xb3, 0x18, 0x2e, 0x2e, 0x13, 0x5e, 0x55, 0xef,
	0x5e, 0xbd, 0xf0, 0x76, 0x12, 0x52, 0xd6, 0x64, 0x44, 0x58, 0x80, 0x78, 0xb4, 0xad, 0xbd, 0x26,
	0x33, 0x99, 0x83, 0x54, 0xd5, 0xb4, 0x5e, 0x54, 0x3f, 0x9f, 0x40, 0x00, 0xe9, 0x36, 0x7f, 0xfe,
	0x42, 0x86, 0x3d, 0x57, 0x4d, 0xeb, 0x85, 0x2b, 0xea, 0x5b, 0x09, 0x36, 0x6c, 0x5b, 0x10, 0x5f,
	0x0c, 0x05, 0x5b, 0x97, 0xd5, 0x2f, 0x45, 0x82, 0xad, 0xcb, 0xea, 0x97, 0x43, 0xc1, 0xa5, 0x2d,
	0xf5, 0x2b, 0x91, 0xe0, 0xd2, 0x96, 0xfa, 0xd5, 0x50, 0x70, 0xe5, 0xb2, 0xfa, 0x76, 0x24, 0xb8,
	0x72, 0x59, 0xfd, 0x5a, 0x86, 0x61, 0xe1, 0x48, 0x2e, 0x6d, 0xa9, 0x5f, 0xcf, 0x46, 0xd4, 0x95,
	0xcb, 0xea, 0x37, 0xb2, 0x2c, 0xfe, 0x51, 0x54, 0xd5, 0x6f, 0xaa, 0x6c, 0x9a, 0x2c, 0x40, 0xea,
	0xb7, 0xf8, 0x23, 0x13, 0xa9, 0xdf, 0x56, 0x19, 0x46, 0xc6, 0xe5, 0xe4, 0x3b, 0x5c, 0xb2, 0x67,
	0xe8, 0x58, 0xfd, 0x4e, 0x06, 0xe5, 0x61, 0x61, 0xc7, 0xa8, 0x54, 0xeb, 0x7a, 0x4d, 0x45, 0xfc,
	0x0d, 0xe6, 0x95, 0xef, 0x5d, 0x64, 0x8f, 0x2c, 0x3d, 0xd5, 0xef, 0x37, 0x99, 0xc1, 0x9b, 0x3a,
	0xae, 0xbc, 0xa2, 0x63, 0xf5, 0xdd, 0x8b, 0xcc, 0xe0, 0x4d, 0x1d, 0x4b, 0x7f, 0xfd, 0xa0, 0xc9,
	0x14, 0xb9, 0xe8, 0xbd, 0x8b, 0x6c, 0xd2, 0x92, 0xff, 0xc3, 0x26, 0xca, 0x42, 0x72, 0xbb, 0x6a,
	0xa9, 0x3f, 0xe2, 0xd6, 0x58, 0x8a, 0xaa, 0x3f, 0x56, 0x19, 0xb3, 0x65, 0x58, 0xea, 0x4f, 0x18,
	0x33, 0x6d, 0xb5, 0x9b, 0x35, 0x43, 0x7d, 0x8c, 0x4d, 0xee, 0x9a, 0xd1, 0xa8, 0x1b, 0x16, 0xde,
	0x53, 0x7f, 0xca, 0xd5, 0x5f, 0x6d, 0x35, 0x4c, 0xf5, 0x7d, 0xf5, 0xc2, 0x2e, 0xa8, 0xc7, 0xcb,
	0x9f, 0x4d, 0xb8, 0x6d, 0x5e, 0x37, 0x1b, 0xaf, 0x99, 0xea, 0x19, 0x46, 0x34, 0xb1, 0xd1, 0xd4,
	0xb1, 0xa1, 0x2a, 0x08, 0x20, 0x53, 0x69, 0xd4, 0xeb, 0x55, 0x4b, 0x4d, 0xa0, 0x45, 0xc8, 0xe2,
	0x46, 0xad, 0xb6, 0xad, 0x57, 0xae, 0xab, 0xc9, 0xed, 0x65, 0x58, 0x72, 0xbd, 0xcd, 0x23, 0x97,
	0x92, 0x20, 0x10, 0x7f, 0x6e, 0xdc, 0xcf, 0xf0, 0x9f, 0x4b, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff,
	0xeb, 0x58, 0x34, 0x89, 0x16, 0x29, 0x00, 0x00,
}
