// Code generated by protoc-gen-go.
// source: tabletmanagerdata.proto
// DO NOT EDIT!

/*
Package tabletmanagerdata is a generated protocol buffer package.

It is generated from these files:
	tabletmanagerdata.proto

It has these top-level messages:
	TableDefinition
	SchemaDefinition
	SchemaChangeResult
	UserPermission
	DbPermission
	Permissions
	BlpPosition
	PingRequest
	PingResponse
	SleepRequest
	SleepResponse
	ExecuteHookRequest
	ExecuteHookResponse
	GetSchemaRequest
	GetSchemaResponse
	GetPermissionsRequest
	GetPermissionsResponse
	SetReadOnlyRequest
	SetReadOnlyResponse
	SetReadWriteRequest
	SetReadWriteResponse
	ChangeTypeRequest
	ChangeTypeResponse
	RefreshStateRequest
	RefreshStateResponse
	RunHealthCheckRequest
	RunHealthCheckResponse
	IgnoreHealthErrorRequest
	IgnoreHealthErrorResponse
	ReloadSchemaRequest
	ReloadSchemaResponse
	PreflightSchemaRequest
	PreflightSchemaResponse
	ApplySchemaRequest
	ApplySchemaResponse
	ExecuteFetchAsDbaRequest
	ExecuteFetchAsDbaResponse
	ExecuteFetchAsAllPrivsRequest
	ExecuteFetchAsAllPrivsResponse
	ExecuteFetchAsAppRequest
	ExecuteFetchAsAppResponse
	SlaveStatusRequest
	SlaveStatusResponse
	MasterPositionRequest
	MasterPositionResponse
	StopSlaveRequest
	StopSlaveResponse
	StopSlaveMinimumRequest
	StopSlaveMinimumResponse
	StartSlaveRequest
	StartSlaveResponse
	TabletExternallyReparentedRequest
	TabletExternallyReparentedResponse
	TabletExternallyElectedRequest
	TabletExternallyElectedResponse
	GetSlavesRequest
	GetSlavesResponse
	WaitBlpPositionRequest
	WaitBlpPositionResponse
	StopBlpRequest
	StopBlpResponse
	StartBlpRequest
	StartBlpResponse
	RunBlpUntilRequest
	RunBlpUntilResponse
	ResetReplicationRequest
	ResetReplicationResponse
	InitMasterRequest
	InitMasterResponse
	PopulateReparentJournalRequest
	PopulateReparentJournalResponse
	InitSlaveRequest
	InitSlaveResponse
	DemoteMasterRequest
	DemoteMasterResponse
	PromoteSlaveWhenCaughtUpRequest
	PromoteSlaveWhenCaughtUpResponse
	SlaveWasPromotedRequest
	SlaveWasPromotedResponse
	SetMasterRequest
	SetMasterResponse
	SlaveWasRestartedRequest
	SlaveWasRestartedResponse
	StopReplicationAndGetStatusRequest
	StopReplicationAndGetStatusResponse
	PromoteSlaveRequest
	PromoteSlaveResponse
	BackupRequest
	BackupResponse
	RestoreFromBackupRequest
	RestoreFromBackupResponse
*/
package tabletmanagerdata

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import query "github.com/youtube/vitess/go/vt/proto/query"
import topodata "github.com/youtube/vitess/go/vt/proto/topodata"
import replicationdata "github.com/youtube/vitess/go/vt/proto/replicationdata"
import logutil "github.com/youtube/vitess/go/vt/proto/logutil"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type TableDefinition struct {
	// the table name
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// the SQL to run to create the table
	Schema string `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	// the columns in the order that will be used to dump and load the data
	Columns []string `protobuf:"bytes,3,rep,name=columns" json:"columns,omitempty"`
	// the primary key columns in the primary key order
	PrimaryKeyColumns []string `protobuf:"bytes,4,rep,name=primary_key_columns,json=primaryKeyColumns" json:"primary_key_columns,omitempty"`
	// type is either mysqlctl.TableBaseTable or mysqlctl.TableView
	Type string `protobuf:"bytes,5,opt,name=type" json:"type,omitempty"`
	// how much space the data file takes.
	DataLength uint64 `protobuf:"varint,6,opt,name=data_length,json=dataLength" json:"data_length,omitempty"`
	// approximate number of rows
	RowCount uint64 `protobuf:"varint,7,opt,name=row_count,json=rowCount" json:"row_count,omitempty"`
}

func (m *TableDefinition) Reset()                    { *m = TableDefinition{} }
func (m *TableDefinition) String() string            { return proto.CompactTextString(m) }
func (*TableDefinition) ProtoMessage()               {}
func (*TableDefinition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *TableDefinition) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TableDefinition) GetSchema() string {
	if m != nil {
		return m.Schema
	}
	return ""
}

func (m *TableDefinition) GetColumns() []string {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TableDefinition) GetPrimaryKeyColumns() []string {
	if m != nil {
		return m.PrimaryKeyColumns
	}
	return nil
}

func (m *TableDefinition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *TableDefinition) GetDataLength() uint64 {
	if m != nil {
		return m.DataLength
	}
	return 0
}

func (m *TableDefinition) GetRowCount() uint64 {
	if m != nil {
		return m.RowCount
	}
	return 0
}

type SchemaDefinition struct {
	DatabaseSchema   string             `protobuf:"bytes,1,opt,name=database_schema,json=databaseSchema" json:"database_schema,omitempty"`
	TableDefinitions []*TableDefinition `protobuf:"bytes,2,rep,name=table_definitions,json=tableDefinitions" json:"table_definitions,omitempty"`
	Version          string             `protobuf:"bytes,3,opt,name=version" json:"version,omitempty"`
}

func (m *SchemaDefinition) Reset()                    { *m = SchemaDefinition{} }
func (m *SchemaDefinition) String() string            { return proto.CompactTextString(m) }
func (*SchemaDefinition) ProtoMessage()               {}
func (*SchemaDefinition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *SchemaDefinition) GetDatabaseSchema() string {
	if m != nil {
		return m.DatabaseSchema
	}
	return ""
}

func (m *SchemaDefinition) GetTableDefinitions() []*TableDefinition {
	if m != nil {
		return m.TableDefinitions
	}
	return nil
}

func (m *SchemaDefinition) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type SchemaChangeResult struct {
	// before_schema holds the schema before each change.
	BeforeSchema *SchemaDefinition `protobuf:"bytes,1,opt,name=before_schema,json=beforeSchema" json:"before_schema,omitempty"`
	// after_schema holds the schema after each change.
	AfterSchema *SchemaDefinition `protobuf:"bytes,2,opt,name=after_schema,json=afterSchema" json:"after_schema,omitempty"`
}

func (m *SchemaChangeResult) Reset()                    { *m = SchemaChangeResult{} }
func (m *SchemaChangeResult) String() string            { return proto.CompactTextString(m) }
func (*SchemaChangeResult) ProtoMessage()               {}
func (*SchemaChangeResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *SchemaChangeResult) GetBeforeSchema() *SchemaDefinition {
	if m != nil {
		return m.BeforeSchema
	}
	return nil
}

func (m *SchemaChangeResult) GetAfterSchema() *SchemaDefinition {
	if m != nil {
		return m.AfterSchema
	}
	return nil
}

// UserPermission describes a single row in the mysql.user table
// Primary key is Host+User
// PasswordChecksum is the crc64 of the password, for security reasons
type UserPermission struct {
	Host             string            `protobuf:"bytes,1,opt,name=host" json:"host,omitempty"`
	User             string            `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	PasswordChecksum uint64            `protobuf:"varint,3,opt,name=password_checksum,json=passwordChecksum" json:"password_checksum,omitempty"`
	Privileges       map[string]string `protobuf:"bytes,4,rep,name=privileges" json:"privileges,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *UserPermission) Reset()                    { *m = UserPermission{} }
func (m *UserPermission) String() string            { return proto.CompactTextString(m) }
func (*UserPermission) ProtoMessage()               {}
func (*UserPermission) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *UserPermission) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *UserPermission) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *UserPermission) GetPasswordChecksum() uint64 {
	if m != nil {
		return m.PasswordChecksum
	}
	return 0
}

func (m *UserPermission) GetPrivileges() map[string]string {
	if m != nil {
		return m.Privileges
	}
	return nil
}

// DbPermission describes a single row in the mysql.db table
// Primary key is Host+Db+User
type DbPermission struct {
	Host       string            `protobuf:"bytes,1,opt,name=host" json:"host,omitempty"`
	Db         string            `protobuf:"bytes,2,opt,name=db" json:"db,omitempty"`
	User       string            `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Privileges map[string]string `protobuf:"bytes,4,rep,name=privileges" json:"privileges,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DbPermission) Reset()                    { *m = DbPermission{} }
func (m *DbPermission) String() string            { return proto.CompactTextString(m) }
func (*DbPermission) ProtoMessage()               {}
func (*DbPermission) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *DbPermission) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *DbPermission) GetDb() string {
	if m != nil {
		return m.Db
	}
	return ""
}

func (m *DbPermission) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *DbPermission) GetPrivileges() map[string]string {
	if m != nil {
		return m.Privileges
	}
	return nil
}

// Permissions have all the rows in mysql.{user,db} tables,
// (all rows are sorted by primary key)
type Permissions struct {
	UserPermissions []*UserPermission `protobuf:"bytes,1,rep,name=user_permissions,json=userPermissions" json:"user_permissions,omitempty"`
	DbPermissions   []*DbPermission   `protobuf:"bytes,2,rep,name=db_permissions,json=dbPermissions" json:"db_permissions,omitempty"`
}

func (m *Permissions) Reset()                    { *m = Permissions{} }
func (m *Permissions) String() string            { return proto.CompactTextString(m) }
func (*Permissions) ProtoMessage()               {}
func (*Permissions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Permissions) GetUserPermissions() []*UserPermission {
	if m != nil {
		return m.UserPermissions
	}
	return nil
}

func (m *Permissions) GetDbPermissions() []*DbPermission {
	if m != nil {
		return m.DbPermissions
	}
	return nil
}

// BlpPosition is a replication position for a given binlog player
type BlpPosition struct {
	Uid      uint32 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	Position string `protobuf:"bytes,2,opt,name=position" json:"position,omitempty"`
}

func (m *BlpPosition) Reset()                    { *m = BlpPosition{} }
func (m *BlpPosition) String() string            { return proto.CompactTextString(m) }
func (*BlpPosition) ProtoMessage()               {}
func (*BlpPosition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *BlpPosition) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *BlpPosition) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type PingRequest struct {
	Payload string `protobuf:"bytes,1,opt,name=payload" json:"payload,omitempty"`
}

func (m *PingRequest) Reset()                    { *m = PingRequest{} }
func (m *PingRequest) String() string            { return proto.CompactTextString(m) }
func (*PingRequest) ProtoMessage()               {}
func (*PingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *PingRequest) GetPayload() string {
	if m != nil {
		return m.Payload
	}
	return ""
}

type PingResponse struct {
	Payload string `protobuf:"bytes,1,opt,name=payload" json:"payload,omitempty"`
}

func (m *PingResponse) Reset()                    { *m = PingResponse{} }
func (m *PingResponse) String() string            { return proto.CompactTextString(m) }
func (*PingResponse) ProtoMessage()               {}
func (*PingResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *PingResponse) GetPayload() string {
	if m != nil {
		return m.Payload
	}
	return ""
}

type SleepRequest struct {
	// duration is in nanoseconds
	Duration int64 `protobuf:"varint,1,opt,name=duration" json:"duration,omitempty"`
}

func (m *SleepRequest) Reset()                    { *m = SleepRequest{} }
func (m *SleepRequest) String() string            { return proto.CompactTextString(m) }
func (*SleepRequest) ProtoMessage()               {}
func (*SleepRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SleepRequest) GetDuration() int64 {
	if m != nil {
		return m.Duration
	}
	return 0
}

type SleepResponse struct {
}

func (m *SleepResponse) Reset()                    { *m = SleepResponse{} }
func (m *SleepResponse) String() string            { return proto.CompactTextString(m) }
func (*SleepResponse) ProtoMessage()               {}
func (*SleepResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type ExecuteHookRequest struct {
	Name       string            `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Parameters []string          `protobuf:"bytes,2,rep,name=parameters" json:"parameters,omitempty"`
	ExtraEnv   map[string]string `protobuf:"bytes,3,rep,name=extra_env,json=extraEnv" json:"extra_env,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ExecuteHookRequest) Reset()                    { *m = ExecuteHookRequest{} }
func (m *ExecuteHookRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteHookRequest) ProtoMessage()               {}
func (*ExecuteHookRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExecuteHookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExecuteHookRequest) GetParameters() []string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ExecuteHookRequest) GetExtraEnv() map[string]string {
	if m != nil {
		return m.ExtraEnv
	}
	return nil
}

type ExecuteHookResponse struct {
	ExitStatus int64  `protobuf:"varint,1,opt,name=exit_status,json=exitStatus" json:"exit_status,omitempty"`
	Stdout     string `protobuf:"bytes,2,opt,name=stdout" json:"stdout,omitempty"`
	Stderr     string `protobuf:"bytes,3,opt,name=stderr" json:"stderr,omitempty"`
}

func (m *ExecuteHookResponse) Reset()                    { *m = ExecuteHookResponse{} }
func (m *ExecuteHookResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteHookResponse) ProtoMessage()               {}
func (*ExecuteHookResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecuteHookResponse) GetExitStatus() int64 {
	if m != nil {
		return m.ExitStatus
	}
	return 0
}

func (m *ExecuteHookResponse) GetStdout() string {
	if m != nil {
		return m.Stdout
	}
	return ""
}

func (m *ExecuteHookResponse) GetStderr() string {
	if m != nil {
		return m.Stderr
	}
	return ""
}

type GetSchemaRequest struct {
	Tables        []string `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
	IncludeViews  bool     `protobuf:"varint,2,opt,name=include_views,json=includeViews" json:"include_views,omitempty"`
	ExcludeTables []string `protobuf:"bytes,3,rep,name=exclude_tables,json=excludeTables" json:"exclude_tables,omitempty"`
}

func (m *GetSchemaRequest) Reset()                    { *m = GetSchemaRequest{} }
func (m *GetSchemaRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSchemaRequest) ProtoMessage()               {}
func (*GetSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetSchemaRequest) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *GetSchemaRequest) GetIncludeViews() bool {
	if m != nil {
		return m.IncludeViews
	}
	return false
}

func (m *GetSchemaRequest) GetExcludeTables() []string {
	if m != nil {
		return m.ExcludeTables
	}
	return nil
}

type GetSchemaResponse struct {
	SchemaDefinition *SchemaDefinition `protobuf:"bytes,1,opt,name=schema_definition,json=schemaDefinition" json:"schema_definition,omitempty"`
}

func (m *GetSchemaResponse) Reset()                    { *m = GetSchemaResponse{} }
func (m *GetSchemaResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSchemaResponse) ProtoMessage()               {}
func (*GetSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetSchemaResponse) GetSchemaDefinition() *SchemaDefinition {
	if m != nil {
		return m.SchemaDefinition
	}
	return nil
}

type GetPermissionsRequest struct {
}

func (m *GetPermissionsRequest) Reset()                    { *m = GetPermissionsRequest{} }
func (m *GetPermissionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPermissionsRequest) ProtoMessage()               {}
func (*GetPermissionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type GetPermissionsResponse struct {
	Permissions *Permissions `protobuf:"bytes,1,opt,name=permissions" json:"permissions,omitempty"`
}

func (m *GetPermissionsResponse) Reset()                    { *m = GetPermissionsResponse{} }
func (m *GetPermissionsResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPermissionsResponse) ProtoMessage()               {}
func (*GetPermissionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetPermissionsResponse) GetPermissions() *Permissions {
	if m != nil {
		return m.Permissions
	}
	return nil
}

type SetReadOnlyRequest struct {
}

func (m *SetReadOnlyRequest) Reset()                    { *m = SetReadOnlyRequest{} }
func (m *SetReadOnlyRequest) String() string            { return proto.CompactTextString(m) }
func (*SetReadOnlyRequest) ProtoMessage()               {}
func (*SetReadOnlyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type SetReadOnlyResponse struct {
}

func (m *SetReadOnlyResponse) Reset()                    { *m = SetReadOnlyResponse{} }
func (m *SetReadOnlyResponse) String() string            { return proto.CompactTextString(m) }
func (*SetReadOnlyResponse) ProtoMessage()               {}
func (*SetReadOnlyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

type SetReadWriteRequest struct {
}

func (m *SetReadWriteRequest) Reset()                    { *m = SetReadWriteRequest{} }
func (m *SetReadWriteRequest) String() string            { return proto.CompactTextString(m) }
func (*SetReadWriteRequest) ProtoMessage()               {}
func (*SetReadWriteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

type SetReadWriteResponse struct {
}

func (m *SetReadWriteResponse) Reset()                    { *m = SetReadWriteResponse{} }
func (m *SetReadWriteResponse) String() string            { return proto.CompactTextString(m) }
func (*SetReadWriteResponse) ProtoMessage()               {}
func (*SetReadWriteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

type ChangeTypeRequest struct {
	TabletType topodata.TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
}

func (m *ChangeTypeRequest) Reset()                    { *m = ChangeTypeRequest{} }
func (m *ChangeTypeRequest) String() string            { return proto.CompactTextString(m) }
func (*ChangeTypeRequest) ProtoMessage()               {}
func (*ChangeTypeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ChangeTypeRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

type ChangeTypeResponse struct {
}

func (m *ChangeTypeResponse) Reset()                    { *m = ChangeTypeResponse{} }
func (m *ChangeTypeResponse) String() string            { return proto.CompactTextString(m) }
func (*ChangeTypeResponse) ProtoMessage()               {}
func (*ChangeTypeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

type RefreshStateRequest struct {
}

func (m *RefreshStateRequest) Reset()                    { *m = RefreshStateRequest{} }
func (m *RefreshStateRequest) String() string            { return proto.CompactTextString(m) }
func (*RefreshStateRequest) ProtoMessage()               {}
func (*RefreshStateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

type RefreshStateResponse struct {
}

func (m *RefreshStateResponse) Reset()                    { *m = RefreshStateResponse{} }
func (m *RefreshStateResponse) String() string            { return proto.CompactTextString(m) }
func (*RefreshStateResponse) ProtoMessage()               {}
func (*RefreshStateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

type RunHealthCheckRequest struct {
}

func (m *RunHealthCheckRequest) Reset()                    { *m = RunHealthCheckRequest{} }
func (m *RunHealthCheckRequest) String() string            { return proto.CompactTextString(m) }
func (*RunHealthCheckRequest) ProtoMessage()               {}
func (*RunHealthCheckRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

type RunHealthCheckResponse struct {
}

func (m *RunHealthCheckResponse) Reset()                    { *m = RunHealthCheckResponse{} }
func (m *RunHealthCheckResponse) String() string            { return proto.CompactTextString(m) }
func (*RunHealthCheckResponse) ProtoMessage()               {}
func (*RunHealthCheckResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type IgnoreHealthErrorRequest struct {
	Pattern string `protobuf:"bytes,1,opt,name=pattern" json:"pattern,omitempty"`
}

func (m *IgnoreHealthErrorRequest) Reset()                    { *m = IgnoreHealthErrorRequest{} }
func (m *IgnoreHealthErrorRequest) String() string            { return proto.CompactTextString(m) }
func (*IgnoreHealthErrorRequest) ProtoMessage()               {}
func (*IgnoreHealthErrorRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *IgnoreHealthErrorRequest) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

type IgnoreHealthErrorResponse struct {
}

func (m *IgnoreHealthErrorResponse) Reset()                    { *m = IgnoreHealthErrorResponse{} }
func (m *IgnoreHealthErrorResponse) String() string            { return proto.CompactTextString(m) }
func (*IgnoreHealthErrorResponse) ProtoMessage()               {}
func (*IgnoreHealthErrorResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type ReloadSchemaRequest struct {
	// wait_position allows scheduling a schema reload to occur after a
	// given DDL has replicated to this slave, by specifying a replication
	// position to wait for. Leave empty to trigger the reload immediately.
	WaitPosition string `protobuf:"bytes,1,opt,name=wait_position,json=waitPosition" json:"wait_position,omitempty"`
}

func (m *ReloadSchemaRequest) Reset()                    { *m = ReloadSchemaRequest{} }
func (m *ReloadSchemaRequest) String() string            { return proto.CompactTextString(m) }
func (*ReloadSchemaRequest) ProtoMessage()               {}
func (*ReloadSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ReloadSchemaRequest) GetWaitPosition() string {
	if m != nil {
		return m.WaitPosition
	}
	return ""
}

type ReloadSchemaResponse struct {
}

func (m *ReloadSchemaResponse) Reset()                    { *m = ReloadSchemaResponse{} }
func (m *ReloadSchemaResponse) String() string            { return proto.CompactTextString(m) }
func (*ReloadSchemaResponse) ProtoMessage()               {}
func (*ReloadSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type PreflightSchemaRequest struct {
	Changes []string `protobuf:"bytes,1,rep,name=changes" json:"changes,omitempty"`
}

func (m *PreflightSchemaRequest) Reset()                    { *m = PreflightSchemaRequest{} }
func (m *PreflightSchemaRequest) String() string            { return proto.CompactTextString(m) }
func (*PreflightSchemaRequest) ProtoMessage()               {}
func (*PreflightSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *PreflightSchemaRequest) GetChanges() []string {
	if m != nil {
		return m.Changes
	}
	return nil
}

type PreflightSchemaResponse struct {
	// change_results has for each change the schema before and after it.
	// The number of elements is identical to the length of "changes" in the request.
	ChangeResults []*SchemaChangeResult `protobuf:"bytes,1,rep,name=change_results,json=changeResults" json:"change_results,omitempty"`
}

func (m *PreflightSchemaResponse) Reset()                    { *m = PreflightSchemaResponse{} }
func (m *PreflightSchemaResponse) String() string            { return proto.CompactTextString(m) }
func (*PreflightSchemaResponse) ProtoMessage()               {}
func (*PreflightSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *PreflightSchemaResponse) GetChangeResults() []*SchemaChangeResult {
	if m != nil {
		return m.ChangeResults
	}
	return nil
}

type ApplySchemaRequest struct {
	Sql              string            `protobuf:"bytes,1,opt,name=sql" json:"sql,omitempty"`
	Force            bool              `protobuf:"varint,2,opt,name=force" json:"force,omitempty"`
	AllowReplication bool              `protobuf:"varint,3,opt,name=allow_replication,json=allowReplication" json:"allow_replication,omitempty"`
	BeforeSchema     *SchemaDefinition `protobuf:"bytes,4,opt,name=before_schema,json=beforeSchema" json:"before_schema,omitempty"`
	AfterSchema      *SchemaDefinition `protobuf:"bytes,5,opt,name=after_schema,json=afterSchema" json:"after_schema,omitempty"`
}

func (m *ApplySchemaRequest) Reset()                    { *m = ApplySchemaRequest{} }
func (m *ApplySchemaRequest) String() string            { return proto.CompactTextString(m) }
func (*ApplySchemaRequest) ProtoMessage()               {}
func (*ApplySchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *ApplySchemaRequest) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *ApplySchemaRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *ApplySchemaRequest) GetAllowReplication() bool {
	if m != nil {
		return m.AllowReplication
	}
	return false
}

func (m *ApplySchemaRequest) GetBeforeSchema() *SchemaDefinition {
	if m != nil {
		return m.BeforeSchema
	}
	return nil
}

func (m *ApplySchemaRequest) GetAfterSchema() *SchemaDefinition {
	if m != nil {
		return m.AfterSchema
	}
	return nil
}

type ApplySchemaResponse struct {
	BeforeSchema *SchemaDefinition `protobuf:"bytes,1,opt,name=before_schema,json=beforeSchema" json:"before_schema,omitempty"`
	AfterSchema  *SchemaDefinition `protobuf:"bytes,2,opt,name=after_schema,json=afterSchema" json:"after_schema,omitempty"`
}

func (m *ApplySchemaResponse) Reset()                    { *m = ApplySchemaResponse{} }
func (m *ApplySchemaResponse) String() string            { return proto.CompactTextString(m) }
func (*ApplySchemaResponse) ProtoMessage()               {}
func (*ApplySchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *ApplySchemaResponse) GetBeforeSchema() *SchemaDefinition {
	if m != nil {
		return m.BeforeSchema
	}
	return nil
}

func (m *ApplySchemaResponse) GetAfterSchema() *SchemaDefinition {
	if m != nil {
		return m.AfterSchema
	}
	return nil
}

type ExecuteFetchAsDbaRequest struct {
	Query          []byte `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	DbName         string `protobuf:"bytes,2,opt,name=db_name,json=dbName" json:"db_name,omitempty"`
	MaxRows        uint64 `protobuf:"varint,3,opt,name=max_rows,json=maxRows" json:"max_rows,omitempty"`
	DisableBinlogs bool   `protobuf:"varint,4,opt,name=disable_binlogs,json=disableBinlogs" json:"disable_binlogs,omitempty"`
	ReloadSchema   bool   `protobuf:"varint,5,opt,name=reload_schema,json=reloadSchema" json:"reload_schema,omitempty"`
}

func (m *ExecuteFetchAsDbaRequest) Reset()                    { *m = ExecuteFetchAsDbaRequest{} }
func (m *ExecuteFetchAsDbaRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsDbaRequest) ProtoMessage()               {}
func (*ExecuteFetchAsDbaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ExecuteFetchAsDbaRequest) GetQuery() []byte {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteFetchAsDbaRequest) GetDbName() string {
	if m != nil {
		return m.DbName
	}
	return ""
}

func (m *ExecuteFetchAsDbaRequest) GetMaxRows() uint64 {
	if m != nil {
		return m.MaxRows
	}
	return 0
}

func (m *ExecuteFetchAsDbaRequest) GetDisableBinlogs() bool {
	if m != nil {
		return m.DisableBinlogs
	}
	return false
}

func (m *ExecuteFetchAsDbaRequest) GetReloadSchema() bool {
	if m != nil {
		return m.ReloadSchema
	}
	return false
}

type ExecuteFetchAsDbaResponse struct {
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteFetchAsDbaResponse) Reset()                    { *m = ExecuteFetchAsDbaResponse{} }
func (m *ExecuteFetchAsDbaResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsDbaResponse) ProtoMessage()               {}
func (*ExecuteFetchAsDbaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ExecuteFetchAsDbaResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

type ExecuteFetchAsAllPrivsRequest struct {
	Query        []byte `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	DbName       string `protobuf:"bytes,2,opt,name=db_name,json=dbName" json:"db_name,omitempty"`
	MaxRows      uint64 `protobuf:"varint,3,opt,name=max_rows,json=maxRows" json:"max_rows,omitempty"`
	ReloadSchema bool   `protobuf:"varint,4,opt,name=reload_schema,json=reloadSchema" json:"reload_schema,omitempty"`
}

func (m *ExecuteFetchAsAllPrivsRequest) Reset()                    { *m = ExecuteFetchAsAllPrivsRequest{} }
func (m *ExecuteFetchAsAllPrivsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsAllPrivsRequest) ProtoMessage()               {}
func (*ExecuteFetchAsAllPrivsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ExecuteFetchAsAllPrivsRequest) GetQuery() []byte {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteFetchAsAllPrivsRequest) GetDbName() string {
	if m != nil {
		return m.DbName
	}
	return ""
}

func (m *ExecuteFetchAsAllPrivsRequest) GetMaxRows() uint64 {
	if m != nil {
		return m.MaxRows
	}
	return 0
}

func (m *ExecuteFetchAsAllPrivsRequest) GetReloadSchema() bool {
	if m != nil {
		return m.ReloadSchema
	}
	return false
}

type ExecuteFetchAsAllPrivsResponse struct {
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteFetchAsAllPrivsResponse) Reset()                    { *m = ExecuteFetchAsAllPrivsResponse{} }
func (m *ExecuteFetchAsAllPrivsResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsAllPrivsResponse) ProtoMessage()               {}
func (*ExecuteFetchAsAllPrivsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *ExecuteFetchAsAllPrivsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

type ExecuteFetchAsAppRequest struct {
	Query   []byte `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	MaxRows uint64 `protobuf:"varint,2,opt,name=max_rows,json=maxRows" json:"max_rows,omitempty"`
}

func (m *ExecuteFetchAsAppRequest) Reset()                    { *m = ExecuteFetchAsAppRequest{} }
func (m *ExecuteFetchAsAppRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsAppRequest) ProtoMessage()               {}
func (*ExecuteFetchAsAppRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *ExecuteFetchAsAppRequest) GetQuery() []byte {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteFetchAsAppRequest) GetMaxRows() uint64 {
	if m != nil {
		return m.MaxRows
	}
	return 0
}

type ExecuteFetchAsAppResponse struct {
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteFetchAsAppResponse) Reset()                    { *m = ExecuteFetchAsAppResponse{} }
func (m *ExecuteFetchAsAppResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteFetchAsAppResponse) ProtoMessage()               {}
func (*ExecuteFetchAsAppResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *ExecuteFetchAsAppResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

type SlaveStatusRequest struct {
}

func (m *SlaveStatusRequest) Reset()                    { *m = SlaveStatusRequest{} }
func (m *SlaveStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*SlaveStatusRequest) ProtoMessage()               {}
func (*SlaveStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

type SlaveStatusResponse struct {
	Status *replicationdata.Status `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *SlaveStatusResponse) Reset()                    { *m = SlaveStatusResponse{} }
func (m *SlaveStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*SlaveStatusResponse) ProtoMessage()               {}
func (*SlaveStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *SlaveStatusResponse) GetStatus() *replicationdata.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

type MasterPositionRequest struct {
}

func (m *MasterPositionRequest) Reset()                    { *m = MasterPositionRequest{} }
func (m *MasterPositionRequest) String() string            { return proto.CompactTextString(m) }
func (*MasterPositionRequest) ProtoMessage()               {}
func (*MasterPositionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

type MasterPositionResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *MasterPositionResponse) Reset()                    { *m = MasterPositionResponse{} }
func (m *MasterPositionResponse) String() string            { return proto.CompactTextString(m) }
func (*MasterPositionResponse) ProtoMessage()               {}
func (*MasterPositionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *MasterPositionResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type StopSlaveRequest struct {
}

func (m *StopSlaveRequest) Reset()                    { *m = StopSlaveRequest{} }
func (m *StopSlaveRequest) String() string            { return proto.CompactTextString(m) }
func (*StopSlaveRequest) ProtoMessage()               {}
func (*StopSlaveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

type StopSlaveResponse struct {
}

func (m *StopSlaveResponse) Reset()                    { *m = StopSlaveResponse{} }
func (m *StopSlaveResponse) String() string            { return proto.CompactTextString(m) }
func (*StopSlaveResponse) ProtoMessage()               {}
func (*StopSlaveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

type StopSlaveMinimumRequest struct {
	Position    string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
	WaitTimeout int64  `protobuf:"varint,2,opt,name=wait_timeout,json=waitTimeout" json:"wait_timeout,omitempty"`
}

func (m *StopSlaveMinimumRequest) Reset()                    { *m = StopSlaveMinimumRequest{} }
func (m *StopSlaveMinimumRequest) String() string            { return proto.CompactTextString(m) }
func (*StopSlaveMinimumRequest) ProtoMessage()               {}
func (*StopSlaveMinimumRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *StopSlaveMinimumRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *StopSlaveMinimumRequest) GetWaitTimeout() int64 {
	if m != nil {
		return m.WaitTimeout
	}
	return 0
}

type StopSlaveMinimumResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *StopSlaveMinimumResponse) Reset()                    { *m = StopSlaveMinimumResponse{} }
func (m *StopSlaveMinimumResponse) String() string            { return proto.CompactTextString(m) }
func (*StopSlaveMinimumResponse) ProtoMessage()               {}
func (*StopSlaveMinimumResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *StopSlaveMinimumResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type StartSlaveRequest struct {
}

func (m *StartSlaveRequest) Reset()                    { *m = StartSlaveRequest{} }
func (m *StartSlaveRequest) String() string            { return proto.CompactTextString(m) }
func (*StartSlaveRequest) ProtoMessage()               {}
func (*StartSlaveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

type StartSlaveResponse struct {
}

func (m *StartSlaveResponse) Reset()                    { *m = StartSlaveResponse{} }
func (m *StartSlaveResponse) String() string            { return proto.CompactTextString(m) }
func (*StartSlaveResponse) ProtoMessage()               {}
func (*StartSlaveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

type TabletExternallyReparentedRequest struct {
	// external_id is an string value that may be provided by an external
	// agent for tracking purposes. The tablet will emit this string in
	// events triggered by TabletExternallyReparented, such as VitessReparent.
	ExternalId string `protobuf:"bytes,1,opt,name=external_id,json=externalId" json:"external_id,omitempty"`
}

func (m *TabletExternallyReparentedRequest) Reset()         { *m = TabletExternallyReparentedRequest{} }
func (m *TabletExternallyReparentedRequest) String() string { return proto.CompactTextString(m) }
func (*TabletExternallyReparentedRequest) ProtoMessage()    {}
func (*TabletExternallyReparentedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{51}
}

func (m *TabletExternallyReparentedRequest) GetExternalId() string {
	if m != nil {
		return m.ExternalId
	}
	return ""
}

type TabletExternallyReparentedResponse struct {
}

func (m *TabletExternallyReparentedResponse) Reset()         { *m = TabletExternallyReparentedResponse{} }
func (m *TabletExternallyReparentedResponse) String() string { return proto.CompactTextString(m) }
func (*TabletExternallyReparentedResponse) ProtoMessage()    {}
func (*TabletExternallyReparentedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{52}
}

type TabletExternallyElectedRequest struct {
}

func (m *TabletExternallyElectedRequest) Reset()                    { *m = TabletExternallyElectedRequest{} }
func (m *TabletExternallyElectedRequest) String() string            { return proto.CompactTextString(m) }
func (*TabletExternallyElectedRequest) ProtoMessage()               {}
func (*TabletExternallyElectedRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

type TabletExternallyElectedResponse struct {
}

func (m *TabletExternallyElectedResponse) Reset()         { *m = TabletExternallyElectedResponse{} }
func (m *TabletExternallyElectedResponse) String() string { return proto.CompactTextString(m) }
func (*TabletExternallyElectedResponse) ProtoMessage()    {}
func (*TabletExternallyElectedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{54}
}

type GetSlavesRequest struct {
}

func (m *GetSlavesRequest) Reset()                    { *m = GetSlavesRequest{} }
func (m *GetSlavesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSlavesRequest) ProtoMessage()               {}
func (*GetSlavesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

type GetSlavesResponse struct {
	Addrs []string `protobuf:"bytes,1,rep,name=addrs" json:"addrs,omitempty"`
}

func (m *GetSlavesResponse) Reset()                    { *m = GetSlavesResponse{} }
func (m *GetSlavesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSlavesResponse) ProtoMessage()               {}
func (*GetSlavesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *GetSlavesResponse) GetAddrs() []string {
	if m != nil {
		return m.Addrs
	}
	return nil
}

type WaitBlpPositionRequest struct {
	BlpPosition *BlpPosition `protobuf:"bytes,1,opt,name=blp_position,json=blpPosition" json:"blp_position,omitempty"`
	WaitTimeout int64        `protobuf:"varint,2,opt,name=wait_timeout,json=waitTimeout" json:"wait_timeout,omitempty"`
}

func (m *WaitBlpPositionRequest) Reset()                    { *m = WaitBlpPositionRequest{} }
func (m *WaitBlpPositionRequest) String() string            { return proto.CompactTextString(m) }
func (*WaitBlpPositionRequest) ProtoMessage()               {}
func (*WaitBlpPositionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *WaitBlpPositionRequest) GetBlpPosition() *BlpPosition {
	if m != nil {
		return m.BlpPosition
	}
	return nil
}

func (m *WaitBlpPositionRequest) GetWaitTimeout() int64 {
	if m != nil {
		return m.WaitTimeout
	}
	return 0
}

type WaitBlpPositionResponse struct {
}

func (m *WaitBlpPositionResponse) Reset()                    { *m = WaitBlpPositionResponse{} }
func (m *WaitBlpPositionResponse) String() string            { return proto.CompactTextString(m) }
func (*WaitBlpPositionResponse) ProtoMessage()               {}
func (*WaitBlpPositionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

type StopBlpRequest struct {
}

func (m *StopBlpRequest) Reset()                    { *m = StopBlpRequest{} }
func (m *StopBlpRequest) String() string            { return proto.CompactTextString(m) }
func (*StopBlpRequest) ProtoMessage()               {}
func (*StopBlpRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

type StopBlpResponse struct {
	BlpPositions []*BlpPosition `protobuf:"bytes,1,rep,name=blp_positions,json=blpPositions" json:"blp_positions,omitempty"`
}

func (m *StopBlpResponse) Reset()                    { *m = StopBlpResponse{} }
func (m *StopBlpResponse) String() string            { return proto.CompactTextString(m) }
func (*StopBlpResponse) ProtoMessage()               {}
func (*StopBlpResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *StopBlpResponse) GetBlpPositions() []*BlpPosition {
	if m != nil {
		return m.BlpPositions
	}
	return nil
}

type StartBlpRequest struct {
}

func (m *StartBlpRequest) Reset()                    { *m = StartBlpRequest{} }
func (m *StartBlpRequest) String() string            { return proto.CompactTextString(m) }
func (*StartBlpRequest) ProtoMessage()               {}
func (*StartBlpRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

type StartBlpResponse struct {
}

func (m *StartBlpResponse) Reset()                    { *m = StartBlpResponse{} }
func (m *StartBlpResponse) String() string            { return proto.CompactTextString(m) }
func (*StartBlpResponse) ProtoMessage()               {}
func (*StartBlpResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{62} }

type RunBlpUntilRequest struct {
	BlpPositions []*BlpPosition `protobuf:"bytes,1,rep,name=blp_positions,json=blpPositions" json:"blp_positions,omitempty"`
	WaitTimeout  int64          `protobuf:"varint,2,opt,name=wait_timeout,json=waitTimeout" json:"wait_timeout,omitempty"`
}

func (m *RunBlpUntilRequest) Reset()                    { *m = RunBlpUntilRequest{} }
func (m *RunBlpUntilRequest) String() string            { return proto.CompactTextString(m) }
func (*RunBlpUntilRequest) ProtoMessage()               {}
func (*RunBlpUntilRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *RunBlpUntilRequest) GetBlpPositions() []*BlpPosition {
	if m != nil {
		return m.BlpPositions
	}
	return nil
}

func (m *RunBlpUntilRequest) GetWaitTimeout() int64 {
	if m != nil {
		return m.WaitTimeout
	}
	return 0
}

type RunBlpUntilResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *RunBlpUntilResponse) Reset()                    { *m = RunBlpUntilResponse{} }
func (m *RunBlpUntilResponse) String() string            { return proto.CompactTextString(m) }
func (*RunBlpUntilResponse) ProtoMessage()               {}
func (*RunBlpUntilResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{64} }

func (m *RunBlpUntilResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type ResetReplicationRequest struct {
}

func (m *ResetReplicationRequest) Reset()                    { *m = ResetReplicationRequest{} }
func (m *ResetReplicationRequest) String() string            { return proto.CompactTextString(m) }
func (*ResetReplicationRequest) ProtoMessage()               {}
func (*ResetReplicationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{65} }

type ResetReplicationResponse struct {
}

func (m *ResetReplicationResponse) Reset()                    { *m = ResetReplicationResponse{} }
func (m *ResetReplicationResponse) String() string            { return proto.CompactTextString(m) }
func (*ResetReplicationResponse) ProtoMessage()               {}
func (*ResetReplicationResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{66} }

type InitMasterRequest struct {
}

func (m *InitMasterRequest) Reset()                    { *m = InitMasterRequest{} }
func (m *InitMasterRequest) String() string            { return proto.CompactTextString(m) }
func (*InitMasterRequest) ProtoMessage()               {}
func (*InitMasterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{67} }

type InitMasterResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *InitMasterResponse) Reset()                    { *m = InitMasterResponse{} }
func (m *InitMasterResponse) String() string            { return proto.CompactTextString(m) }
func (*InitMasterResponse) ProtoMessage()               {}
func (*InitMasterResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{68} }

func (m *InitMasterResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type PopulateReparentJournalRequest struct {
	TimeCreatedNs       int64                 `protobuf:"varint,1,opt,name=time_created_ns,json=timeCreatedNs" json:"time_created_ns,omitempty"`
	ActionName          string                `protobuf:"bytes,2,opt,name=action_name,json=actionName" json:"action_name,omitempty"`
	MasterAlias         *topodata.TabletAlias `protobuf:"bytes,3,opt,name=master_alias,json=masterAlias" json:"master_alias,omitempty"`
	ReplicationPosition string                `protobuf:"bytes,4,opt,name=replication_position,json=replicationPosition" json:"replication_position,omitempty"`
}

func (m *PopulateReparentJournalRequest) Reset()                    { *m = PopulateReparentJournalRequest{} }
func (m *PopulateReparentJournalRequest) String() string            { return proto.CompactTextString(m) }
func (*PopulateReparentJournalRequest) ProtoMessage()               {}
func (*PopulateReparentJournalRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{69} }

func (m *PopulateReparentJournalRequest) GetTimeCreatedNs() int64 {
	if m != nil {
		return m.TimeCreatedNs
	}
	return 0
}

func (m *PopulateReparentJournalRequest) GetActionName() string {
	if m != nil {
		return m.ActionName
	}
	return ""
}

func (m *PopulateReparentJournalRequest) GetMasterAlias() *topodata.TabletAlias {
	if m != nil {
		return m.MasterAlias
	}
	return nil
}

func (m *PopulateReparentJournalRequest) GetReplicationPosition() string {
	if m != nil {
		return m.ReplicationPosition
	}
	return ""
}

type PopulateReparentJournalResponse struct {
}

func (m *PopulateReparentJournalResponse) Reset()         { *m = PopulateReparentJournalResponse{} }
func (m *PopulateReparentJournalResponse) String() string { return proto.CompactTextString(m) }
func (*PopulateReparentJournalResponse) ProtoMessage()    {}
func (*PopulateReparentJournalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{70}
}

type InitSlaveRequest struct {
	Parent              *topodata.TabletAlias `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	ReplicationPosition string                `protobuf:"bytes,2,opt,name=replication_position,json=replicationPosition" json:"replication_position,omitempty"`
	TimeCreatedNs       int64                 `protobuf:"varint,3,opt,name=time_created_ns,json=timeCreatedNs" json:"time_created_ns,omitempty"`
}

func (m *InitSlaveRequest) Reset()                    { *m = InitSlaveRequest{} }
func (m *InitSlaveRequest) String() string            { return proto.CompactTextString(m) }
func (*InitSlaveRequest) ProtoMessage()               {}
func (*InitSlaveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{71} }

func (m *InitSlaveRequest) GetParent() *topodata.TabletAlias {
	if m != nil {
		return m.Parent
	}
	return nil
}

func (m *InitSlaveRequest) GetReplicationPosition() string {
	if m != nil {
		return m.ReplicationPosition
	}
	return ""
}

func (m *InitSlaveRequest) GetTimeCreatedNs() int64 {
	if m != nil {
		return m.TimeCreatedNs
	}
	return 0
}

type InitSlaveResponse struct {
}

func (m *InitSlaveResponse) Reset()                    { *m = InitSlaveResponse{} }
func (m *InitSlaveResponse) String() string            { return proto.CompactTextString(m) }
func (*InitSlaveResponse) ProtoMessage()               {}
func (*InitSlaveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

type DemoteMasterRequest struct {
}

func (m *DemoteMasterRequest) Reset()                    { *m = DemoteMasterRequest{} }
func (m *DemoteMasterRequest) String() string            { return proto.CompactTextString(m) }
func (*DemoteMasterRequest) ProtoMessage()               {}
func (*DemoteMasterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

type DemoteMasterResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *DemoteMasterResponse) Reset()                    { *m = DemoteMasterResponse{} }
func (m *DemoteMasterResponse) String() string            { return proto.CompactTextString(m) }
func (*DemoteMasterResponse) ProtoMessage()               {}
func (*DemoteMasterResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *DemoteMasterResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type PromoteSlaveWhenCaughtUpRequest struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *PromoteSlaveWhenCaughtUpRequest) Reset()         { *m = PromoteSlaveWhenCaughtUpRequest{} }
func (m *PromoteSlaveWhenCaughtUpRequest) String() string { return proto.CompactTextString(m) }
func (*PromoteSlaveWhenCaughtUpRequest) ProtoMessage()    {}
func (*PromoteSlaveWhenCaughtUpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{75}
}

func (m *PromoteSlaveWhenCaughtUpRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type PromoteSlaveWhenCaughtUpResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *PromoteSlaveWhenCaughtUpResponse) Reset()         { *m = PromoteSlaveWhenCaughtUpResponse{} }
func (m *PromoteSlaveWhenCaughtUpResponse) String() string { return proto.CompactTextString(m) }
func (*PromoteSlaveWhenCaughtUpResponse) ProtoMessage()    {}
func (*PromoteSlaveWhenCaughtUpResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{76}
}

func (m *PromoteSlaveWhenCaughtUpResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type SlaveWasPromotedRequest struct {
}

func (m *SlaveWasPromotedRequest) Reset()                    { *m = SlaveWasPromotedRequest{} }
func (m *SlaveWasPromotedRequest) String() string            { return proto.CompactTextString(m) }
func (*SlaveWasPromotedRequest) ProtoMessage()               {}
func (*SlaveWasPromotedRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{77} }

type SlaveWasPromotedResponse struct {
}

func (m *SlaveWasPromotedResponse) Reset()                    { *m = SlaveWasPromotedResponse{} }
func (m *SlaveWasPromotedResponse) String() string            { return proto.CompactTextString(m) }
func (*SlaveWasPromotedResponse) ProtoMessage()               {}
func (*SlaveWasPromotedResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{78} }

type SetMasterRequest struct {
	Parent          *topodata.TabletAlias `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	TimeCreatedNs   int64                 `protobuf:"varint,2,opt,name=time_created_ns,json=timeCreatedNs" json:"time_created_ns,omitempty"`
	ForceStartSlave bool                  `protobuf:"varint,3,opt,name=force_start_slave,json=forceStartSlave" json:"force_start_slave,omitempty"`
}

func (m *SetMasterRequest) Reset()                    { *m = SetMasterRequest{} }
func (m *SetMasterRequest) String() string            { return proto.CompactTextString(m) }
func (*SetMasterRequest) ProtoMessage()               {}
func (*SetMasterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *SetMasterRequest) GetParent() *topodata.TabletAlias {
	if m != nil {
		return m.Parent
	}
	return nil
}

func (m *SetMasterRequest) GetTimeCreatedNs() int64 {
	if m != nil {
		return m.TimeCreatedNs
	}
	return 0
}

func (m *SetMasterRequest) GetForceStartSlave() bool {
	if m != nil {
		return m.ForceStartSlave
	}
	return false
}

type SetMasterResponse struct {
}

func (m *SetMasterResponse) Reset()                    { *m = SetMasterResponse{} }
func (m *SetMasterResponse) String() string            { return proto.CompactTextString(m) }
func (*SetMasterResponse) ProtoMessage()               {}
func (*SetMasterResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

type SlaveWasRestartedRequest struct {
	// the parent alias the tablet should have
	Parent *topodata.TabletAlias `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
}

func (m *SlaveWasRestartedRequest) Reset()                    { *m = SlaveWasRestartedRequest{} }
func (m *SlaveWasRestartedRequest) String() string            { return proto.CompactTextString(m) }
func (*SlaveWasRestartedRequest) ProtoMessage()               {}
func (*SlaveWasRestartedRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{81} }

func (m *SlaveWasRestartedRequest) GetParent() *topodata.TabletAlias {
	if m != nil {
		return m.Parent
	}
	return nil
}

type SlaveWasRestartedResponse struct {
}

func (m *SlaveWasRestartedResponse) Reset()                    { *m = SlaveWasRestartedResponse{} }
func (m *SlaveWasRestartedResponse) String() string            { return proto.CompactTextString(m) }
func (*SlaveWasRestartedResponse) ProtoMessage()               {}
func (*SlaveWasRestartedResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{82} }

type StopReplicationAndGetStatusRequest struct {
}

func (m *StopReplicationAndGetStatusRequest) Reset()         { *m = StopReplicationAndGetStatusRequest{} }
func (m *StopReplicationAndGetStatusRequest) String() string { return proto.CompactTextString(m) }
func (*StopReplicationAndGetStatusRequest) ProtoMessage()    {}
func (*StopReplicationAndGetStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{83}
}

type StopReplicationAndGetStatusResponse struct {
	Status *replicationdata.Status `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *StopReplicationAndGetStatusResponse) Reset()         { *m = StopReplicationAndGetStatusResponse{} }
func (m *StopReplicationAndGetStatusResponse) String() string { return proto.CompactTextString(m) }
func (*StopReplicationAndGetStatusResponse) ProtoMessage()    {}
func (*StopReplicationAndGetStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{84}
}

func (m *StopReplicationAndGetStatusResponse) GetStatus() *replicationdata.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

type PromoteSlaveRequest struct {
}

func (m *PromoteSlaveRequest) Reset()                    { *m = PromoteSlaveRequest{} }
func (m *PromoteSlaveRequest) String() string            { return proto.CompactTextString(m) }
func (*PromoteSlaveRequest) ProtoMessage()               {}
func (*PromoteSlaveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{85} }

type PromoteSlaveResponse struct {
	Position string `protobuf:"bytes,1,opt,name=position" json:"position,omitempty"`
}

func (m *PromoteSlaveResponse) Reset()                    { *m = PromoteSlaveResponse{} }
func (m *PromoteSlaveResponse) String() string            { return proto.CompactTextString(m) }
func (*PromoteSlaveResponse) ProtoMessage()               {}
func (*PromoteSlaveResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{86} }

func (m *PromoteSlaveResponse) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

type BackupRequest struct {
	Concurrency int64 `protobuf:"varint,1,opt,name=concurrency" json:"concurrency,omitempty"`
}

func (m *BackupRequest) Reset()                    { *m = BackupRequest{} }
func (m *BackupRequest) String() string            { return proto.CompactTextString(m) }
func (*BackupRequest) ProtoMessage()               {}
func (*BackupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{87} }

func (m *BackupRequest) GetConcurrency() int64 {
	if m != nil {
		return m.Concurrency
	}
	return 0
}

type BackupResponse struct {
	Event *logutil.Event `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
}

func (m *BackupResponse) Reset()                    { *m = BackupResponse{} }
func (m *BackupResponse) String() string            { return proto.CompactTextString(m) }
func (*BackupResponse) ProtoMessage()               {}
func (*BackupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{88} }

func (m *BackupResponse) GetEvent() *logutil.Event {
	if m != nil {
		return m.Event
	}
	return nil
}

type RestoreFromBackupRequest struct {
}

func (m *RestoreFromBackupRequest) Reset()                    { *m = RestoreFromBackupRequest{} }
func (m *RestoreFromBackupRequest) String() string            { return proto.CompactTextString(m) }
func (*RestoreFromBackupRequest) ProtoMessage()               {}
func (*RestoreFromBackupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{89} }

type RestoreFromBackupResponse struct {
	Event *logutil.Event `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
}

func (m *RestoreFromBackupResponse) Reset()                    { *m = RestoreFromBackupResponse{} }
func (m *RestoreFromBackupResponse) String() string            { return proto.CompactTextString(m) }
func (*RestoreFromBackupResponse) ProtoMessage()               {}
func (*RestoreFromBackupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{90} }

func (m *RestoreFromBackupResponse) GetEvent() *logutil.Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func init() {
	proto.RegisterType((*TableDefinition)(nil), "tabletmanagerdata.TableDefinition")
	proto.RegisterType((*SchemaDefinition)(nil), "tabletmanagerdata.SchemaDefinition")
	proto.RegisterType((*SchemaChangeResult)(nil), "tabletmanagerdata.SchemaChangeResult")
	proto.RegisterType((*UserPermission)(nil), "tabletmanagerdata.UserPermission")
	proto.RegisterType((*DbPermission)(nil), "tabletmanagerdata.DbPermission")
	proto.RegisterType((*Permissions)(nil), "tabletmanagerdata.Permissions")
	proto.RegisterType((*BlpPosition)(nil), "tabletmanagerdata.BlpPosition")
	proto.RegisterType((*PingRequest)(nil), "tabletmanagerdata.PingRequest")
	proto.RegisterType((*PingResponse)(nil), "tabletmanagerdata.PingResponse")
	proto.RegisterType((*SleepRequest)(nil), "tabletmanagerdata.SleepRequest")
	proto.RegisterType((*SleepResponse)(nil), "tabletmanagerdata.SleepResponse")
	proto.RegisterType((*ExecuteHookRequest)(nil), "tabletmanagerdata.ExecuteHookRequest")
	proto.RegisterType((*ExecuteHookResponse)(nil), "tabletmanagerdata.ExecuteHookResponse")
	proto.RegisterType((*GetSchemaRequest)(nil), "tabletmanagerdata.GetSchemaRequest")
	proto.RegisterType((*GetSchemaResponse)(nil), "tabletmanagerdata.GetSchemaResponse")
	proto.RegisterType((*GetPermissionsRequest)(nil), "tabletmanagerdata.GetPermissionsRequest")
	proto.RegisterType((*GetPermissionsResponse)(nil), "tabletmanagerdata.GetPermissionsResponse")
	proto.RegisterType((*SetReadOnlyRequest)(nil), "tabletmanagerdata.SetReadOnlyRequest")
	proto.RegisterType((*SetReadOnlyResponse)(nil), "tabletmanagerdata.SetReadOnlyResponse")
	proto.RegisterType((*SetReadWriteRequest)(nil), "tabletmanagerdata.SetReadWriteRequest")
	proto.RegisterType((*SetReadWriteResponse)(nil), "tabletmanagerdata.SetReadWriteResponse")
	proto.RegisterType((*ChangeTypeRequest)(nil), "tabletmanagerdata.ChangeTypeRequest")
	proto.RegisterType((*ChangeTypeResponse)(nil), "tabletmanagerdata.ChangeTypeResponse")
	proto.RegisterType((*RefreshStateRequest)(nil), "tabletmanagerdata.RefreshStateRequest")
	proto.RegisterType((*RefreshStateResponse)(nil), "tabletmanagerdata.RefreshStateResponse")
	proto.RegisterType((*RunHealthCheckRequest)(nil), "tabletmanagerdata.RunHealthCheckRequest")
	proto.RegisterType((*RunHealthCheckResponse)(nil), "tabletmanagerdata.RunHealthCheckResponse")
	proto.RegisterType((*IgnoreHealthErrorRequest)(nil), "tabletmanagerdata.IgnoreHealthErrorRequest")
	proto.RegisterType((*IgnoreHealthErrorResponse)(nil), "tabletmanagerdata.IgnoreHealthErrorResponse")
	proto.RegisterType((*ReloadSchemaRequest)(nil), "tabletmanagerdata.ReloadSchemaRequest")
	proto.RegisterType((*ReloadSchemaResponse)(nil), "tabletmanagerdata.ReloadSchemaResponse")
	proto.RegisterType((*PreflightSchemaRequest)(nil), "tabletmanagerdata.PreflightSchemaRequest")
	proto.RegisterType((*PreflightSchemaResponse)(nil), "tabletmanagerdata.PreflightSchemaResponse")
	proto.RegisterType((*ApplySchemaRequest)(nil), "tabletmanagerdata.ApplySchemaRequest")
	proto.RegisterType((*ApplySchemaResponse)(nil), "tabletmanagerdata.ApplySchemaResponse")
	proto.RegisterType((*ExecuteFetchAsDbaRequest)(nil), "tabletmanagerdata.ExecuteFetchAsDbaRequest")
	proto.RegisterType((*ExecuteFetchAsDbaResponse)(nil), "tabletmanagerdata.ExecuteFetchAsDbaResponse")
	proto.RegisterType((*ExecuteFetchAsAllPrivsRequest)(nil), "tabletmanagerdata.ExecuteFetchAsAllPrivsRequest")
	proto.RegisterType((*ExecuteFetchAsAllPrivsResponse)(nil), "tabletmanagerdata.ExecuteFetchAsAllPrivsResponse")
	proto.RegisterType((*ExecuteFetchAsAppRequest)(nil), "tabletmanagerdata.ExecuteFetchAsAppRequest")
	proto.RegisterType((*ExecuteFetchAsAppResponse)(nil), "tabletmanagerdata.ExecuteFetchAsAppResponse")
	proto.RegisterType((*SlaveStatusRequest)(nil), "tabletmanagerdata.SlaveStatusRequest")
	proto.RegisterType((*SlaveStatusResponse)(nil), "tabletmanagerdata.SlaveStatusResponse")
	proto.RegisterType((*MasterPositionRequest)(nil), "tabletmanagerdata.MasterPositionRequest")
	proto.RegisterType((*MasterPositionResponse)(nil), "tabletmanagerdata.MasterPositionResponse")
	proto.RegisterType((*StopSlaveRequest)(nil), "tabletmanagerdata.StopSlaveRequest")
	proto.RegisterType((*StopSlaveResponse)(nil), "tabletmanagerdata.StopSlaveResponse")
	proto.RegisterType((*StopSlaveMinimumRequest)(nil), "tabletmanagerdata.StopSlaveMinimumRequest")
	proto.RegisterType((*StopSlaveMinimumResponse)(nil), "tabletmanagerdata.StopSlaveMinimumResponse")
	proto.RegisterType((*StartSlaveRequest)(nil), "tabletmanagerdata.StartSlaveRequest")
	proto.RegisterType((*StartSlaveResponse)(nil), "tabletmanagerdata.StartSlaveResponse")
	proto.RegisterType((*TabletExternallyReparentedRequest)(nil), "tabletmanagerdata.TabletExternallyReparentedRequest")
	proto.RegisterType((*TabletExternallyReparentedResponse)(nil), "tabletmanagerdata.TabletExternallyReparentedResponse")
	proto.RegisterType((*TabletExternallyElectedRequest)(nil), "tabletmanagerdata.TabletExternallyElectedRequest")
	proto.RegisterType((*TabletExternallyElectedResponse)(nil), "tabletmanagerdata.TabletExternallyElectedResponse")
	proto.RegisterType((*GetSlavesRequest)(nil), "tabletmanagerdata.GetSlavesRequest")
	proto.RegisterType((*GetSlavesResponse)(nil), "tabletmanagerdata.GetSlavesResponse")
	proto.RegisterType((*WaitBlpPositionRequest)(nil), "tabletmanagerdata.WaitBlpPositionRequest")
	proto.RegisterType((*WaitBlpPositionResponse)(nil), "tabletmanagerdata.WaitBlpPositionResponse")
	proto.RegisterType((*StopBlpRequest)(nil), "tabletmanagerdata.StopBlpRequest")
	proto.RegisterType((*StopBlpResponse)(nil), "tabletmanagerdata.StopBlpResponse")
	proto.RegisterType((*StartBlpRequest)(nil), "tabletmanagerdata.StartBlpRequest")
	proto.RegisterType((*StartBlpResponse)(nil), "tabletmanagerdata.StartBlpResponse")
	proto.RegisterType((*RunBlpUntilRequest)(nil), "tabletmanagerdata.RunBlpUntilRequest")
	proto.RegisterType((*RunBlpUntilResponse)(nil), "tabletmanagerdata.RunBlpUntilResponse")
	proto.RegisterType((*ResetReplicationRequest)(nil), "tabletmanagerdata.ResetReplicationRequest")
	proto.RegisterType((*ResetReplicationResponse)(nil), "tabletmanagerdata.ResetReplicationResponse")
	proto.RegisterType((*InitMasterRequest)(nil), "tabletmanagerdata.InitMasterRequest")
	proto.RegisterType((*InitMasterResponse)(nil), "tabletmanagerdata.InitMasterResponse")
	proto.RegisterType((*PopulateReparentJournalRequest)(nil), "tabletmanagerdata.PopulateReparentJournalRequest")
	proto.RegisterType((*PopulateReparentJournalResponse)(nil), "tabletmanagerdata.PopulateReparentJournalResponse")
	proto.RegisterType((*InitSlaveRequest)(nil), "tabletmanagerdata.InitSlaveRequest")
	proto.RegisterType((*InitSlaveResponse)(nil), "tabletmanagerdata.InitSlaveResponse")
	proto.RegisterType((*DemoteMasterRequest)(nil), "tabletmanagerdata.DemoteMasterRequest")
	proto.RegisterType((*DemoteMasterResponse)(nil), "tabletmanagerdata.DemoteMasterResponse")
	proto.RegisterType((*PromoteSlaveWhenCaughtUpRequest)(nil), "tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest")
	proto.RegisterType((*PromoteSlaveWhenCaughtUpResponse)(nil), "tabletmanagerdata.PromoteSlaveWhenCaughtUpResponse")
	proto.RegisterType((*SlaveWasPromotedRequest)(nil), "tabletmanagerdata.SlaveWasPromotedRequest")
	proto.RegisterType((*SlaveWasPromotedResponse)(nil), "tabletmanagerdata.SlaveWasPromotedResponse")
	proto.RegisterType((*SetMasterRequest)(nil), "tabletmanagerdata.SetMasterRequest")
	proto.RegisterType((*SetMasterResponse)(nil), "tabletmanagerdata.SetMasterResponse")
	proto.RegisterType((*SlaveWasRestartedRequest)(nil), "tabletmanagerdata.SlaveWasRestartedRequest")
	proto.RegisterType((*SlaveWasRestartedResponse)(nil), "tabletmanagerdata.SlaveWasRestartedResponse")
	proto.RegisterType((*StopReplicationAndGetStatusRequest)(nil), "tabletmanagerdata.StopReplicationAndGetStatusRequest")
	proto.RegisterType((*StopReplicationAndGetStatusResponse)(nil), "tabletmanagerdata.StopReplicationAndGetStatusResponse")
	proto.RegisterType((*PromoteSlaveRequest)(nil), "tabletmanagerdata.PromoteSlaveRequest")
	proto.RegisterType((*PromoteSlaveResponse)(nil), "tabletmanagerdata.PromoteSlaveResponse")
	proto.RegisterType((*BackupRequest)(nil), "tabletmanagerdata.BackupRequest")
	proto.RegisterType((*BackupResponse)(nil), "tabletmanagerdata.BackupResponse")
	proto.RegisterType((*RestoreFromBackupRequest)(nil), "tabletmanagerdata.RestoreFromBackupRequest")
	proto.RegisterType((*RestoreFromBackupResponse)(nil), "tabletmanagerdata.RestoreFromBackupResponse")
}

func init() { proto.RegisterFile("tabletmanagerdata.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2049 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x5b, 0x6f, 0x1b, 0xc7,
	0xf5, 0x07, 0x45, 0x49, 0x96, 0x0e, 0x2f, 0x22, 0x97, 0xba, 0x50, 0x0a, 0xfe, 0xba, 0xac, 0x9d,
	0x7f, 0x54, 0x17, 0x55, 0x6a, 0x25, 0x0d, 0x82, 0x04, 0x29, 0xaa, 0xab, 0xed, 0xc4, 0x89, 0x95,
	0x95, 0x2f, 0x45, 0x5f, 0x16, 0x43, 0xee, 0x11, 0xb9, 0xd0, 0x72, 0x77, 0x3d, 0x33, 0x2b, 0x89,
	0x40, 0xd1, 0x8f, 0xd0, 0xb7, 0xbe, 0xf5, 0xad, 0x40, 0xfb, 0xde, 0x0f, 0x93, 0xa2, 0x9f, 0xa4,
	0x0f, 0x7d, 0x29, 0xe6, 0x46, 0xce, 0x92, 0x94, 0x4d, 0x19, 0x2e, 0xd0, 0x17, 0x81, 0xe7, 0x37,
	0xe7, 0x3e, 0x67, 0xce, 0x39, 0x0b, 0xc1, 0x1a, 0x27, 0xad, 0x08, 0x79, 0x8f, 0xc4, 0xa4, 0x83,
	0x34, 0x20, 0x9c, 0xec, 0xa5, 0x34, 0xe1, 0x89, 0x53, 0x1f, 0x3b, 0xd8, 0x28, 0xbd, 0xc9, 0x90,
	0xf6, 0xd5, 0xf9, 0x46, 0x95, 0x27, 0x69, 0x32, 0xe4, 0xdf, 0x58, 0xa1, 0x98, 0x46, 0x61, 0x9b,
	0xf0, 0x30, 0x89, 0x2d, 0xb8, 0x12, 0x25, 0x9d, 0x8c, 0x87, 0x91, 0x22, 0xdd, 0x7f, 0x16, 0x60,
	0xe9, 0x85, 0x50, 0x7c, 0x8c, 0x17, 0x61, 0x1c, 0x0a, 0x66, 0xc7, 0x81, 0xd9, 0x98, 0xf4, 0xb0,
	0x59, 0xd8, 0x2e, 0xec, 0x2e, 0x7a, 0xf2, 0xb7, 0xb3, 0x0a, 0xf3, 0xac, 0xdd, 0xc5, 0x1e, 0x69,
	0xce, 0x48, 0x54, 0x53, 0x4e, 0x13, 0xee, 0xb5, 0x93, 0x28, 0xeb, 0xc5, 0xac, 0x59, 0xdc, 0x2e,
	0xee, 0x2e, 0x7a, 0x86, 0x74, 0xf6, 0xa0, 0x91, 0xd2, 0xb0, 0x47, 0x68, 0xdf, 0xbf, 0xc4, 0xbe,
	0x6f, 0xb8, 0x66, 0x25, 0x57, 0x5d, 0x1f, 0x7d, 0x87, 0xfd, 0x23, 0xcd, 0xef, 0xc0, 0x2c, 0xef,
	0xa7, 0xd8, 0x9c, 0x53, 0x56, 0xc5, 0x6f, 0x67, 0x0b, 0x4a, 0xc2, 0x75, 0x3f, 0xc2, 0xb8, 0xc3,
	0xbb, 0xcd, 0xf9, 0xed, 0xc2, 0xee, 0xac, 0x07, 0x02, 0x7a, 0x26, 0x11, 0xe7, 0x23, 0x58, 0xa4,
	0xc9, 0xb5, 0xdf, 0x4e, 0xb2, 0x98, 0x37, 0xef, 0xc9, 0xe3, 0x05, 0x9a, 0x5c, 0x1f, 0x09, 0xda,
	0xfd, 0x6b, 0x01, 0x6a, 0xe7, 0xd2, 0x4d, 0x2b, 0xb8, 0x4f, 0x60, 0x49, 0xc8, 0xb7, 0x08, 0x43,
	0x5f, 0x47, 0xa4, 0xe2, 0xac, 0x1a, 0x58, 0x89, 0x38, 0xcf, 0x41, 0x65, 0xdc, 0x0f, 0x06, 0xc2,
	0xac, 0x39, 0xb3, 0x5d, 0xdc, 0x2d, 0xed, 0xbb, 0x7b, 0xe3, 0x97, 0x34, 0x92, 0x44, 0xaf, 0xc6,
	0xf3, 0x00, 0x13, 0xa9, 0xba, 0x42, 0xca, 0xc2, 0x24, 0x6e, 0x16, 0xa5, 0x45, 0x43, 0x0a, 0x47,
	0x1d, 0x65, 0xf5, 0xa8, 0x4b, 0xe2, 0x0e, 0x7a, 0xc8, 0xb2, 0x88, 0x3b, 0x4f, 0xa0, 0xd2, 0xc2,
	0x8b, 0x84, 0xe6, 0x1c, 0x2d, 0xed, 0xdf, 0x9f, 0x60, 0x7d, 0x34, 0x4c, 0xaf, 0xac, 0x24, 0x75,
	0x2c, 0xa7, 0x50, 0x26, 0x17, 0x1c, 0xa9, 0x6f, 0xdd, 0xe1, 0x94, 0x8a, 0x4a, 0x52, 0x50, 0xc1,
	0xee, 0xbf, 0x0a, 0x50, 0x7d, 0xc9, 0x90, 0x9e, 0x21, 0xed, 0x85, 0x8c, 0xe9, 0x62, 0xe9, 0x26,
	0x8c, 0x9b, 0x62, 0x11, 0xbf, 0x05, 0x96, 0x31, 0xa4, 0xba, 0x54, 0xe4, 0x6f, 0xe7, 0xe7, 0x50,
	0x4f, 0x09, 0x63, 0xd7, 0x09, 0x0d, 0xfc, 0x76, 0x17, 0xdb, 0x97, 0x2c, 0xeb, 0xc9, 0x3c, 0xcc,
	0x7a, 0x35, 0x73, 0x70, 0xa4, 0x71, 0xe7, 0x47, 0x80, 0x94, 0x86, 0x57, 0x61, 0x84, 0x1d, 0x54,
	0x25, 0x53, 0xda, 0x7f, 0x34, 0xc1, 0xdb, 0xbc, 0x2f, 0x7b, 0x67, 0x03, 0x99, 0x93, 0x98, 0xd3,
	0xbe, 0x67, 0x29, 0xd9, 0xf8, 0x06, 0x96, 0x46, 0x8e, 0x9d, 0x1a, 0x14, 0x2f, 0xb1, 0xaf, 0x3d,
	0x17, 0x3f, 0x9d, 0x65, 0x98, 0xbb, 0x22, 0x51, 0x86, 0xda, 0x73, 0x45, 0x7c, 0x35, 0xf3, 0x65,
	0xc1, 0xfd, 0xa9, 0x00, 0xe5, 0xe3, 0xd6, 0x3b, 0xe2, 0xae, 0xc2, 0x4c, 0xd0, 0xd2, 0xb2, 0x33,
	0x41, 0x6b, 0x90, 0x87, 0xa2, 0x95, 0x87, 0xe7, 0x13, 0x42, 0xfb, 0x74, 0x42, 0x68, 0xb6, 0xb1,
	0xff, 0x66, 0x60, 0x7f, 0x29, 0x40, 0x69, 0x68, 0x89, 0x39, 0xcf, 0xa0, 0x26, 0xfc, 0xf4, 0xd3,
	0x21, 0xd6, 0x2c, 0x48, 0x2f, 0x77, 0xde, 0x79, 0x01, 0xde, 0x52, 0x96, 0xa3, 0x99, 0x73, 0x0a,
	0xd5, 0xa0, 0x95, 0xd3, 0xa5, 0x5e, 0xd0, 0xd6, 0x3b, 0x22, 0xf6, 0x2a, 0x81, 0x45, 0x31, 0xf7,
	0x6b, 0x28, 0x1d, 0x46, 0xe9, 0x59, 0xc2, 0xd4, 0x23, 0xae, 0x41, 0x31, 0x0b, 0x03, 0x19, 0x60,
	0xc5, 0x13, 0x3f, 0x9d, 0x0d, 0x58, 0x48, 0xf5, 0xa9, 0x8e, 0x71, 0x40, 0xbb, 0x9f, 0x40, 0xe9,
	0x2c, 0x8c, 0x3b, 0x1e, 0xbe, 0xc9, 0x90, 0x71, 0xf1, 0x0e, 0x53, 0xd2, 0x8f, 0x12, 0x12, 0xe8,
	0x0c, 0x19, 0xd2, 0xdd, 0x85, 0xb2, 0x62, 0x64, 0x69, 0x12, 0x33, 0x7c, 0x0b, 0xe7, 0x43, 0x28,
	0x9f, 0x47, 0x88, 0xa9, 0xd1, 0xb9, 0x01, 0x0b, 0x41, 0x46, 0x65, 0xaf, 0x95, 0xac, 0x45, 0x6f,
	0x40, 0xbb, 0x4b, 0x50, 0xd1, 0xbc, 0x4a, 0xad, 0xfb, 0x8f, 0x02, 0x38, 0x27, 0x37, 0xd8, 0xce,
	0x38, 0x3e, 0x49, 0x92, 0x4b, 0xa3, 0x63, 0x52, 0xdb, 0xdd, 0x04, 0x48, 0x09, 0x25, 0x3d, 0xe4,
	0x48, 0x55, 0xee, 0x16, 0x3d, 0x0b, 0x71, 0xce, 0x60, 0x11, 0x6f, 0x38, 0x25, 0x3e, 0xc6, 0x57,
	0xb2, 0x01, 0x97, 0xf6, 0x3f, 0x9b, 0x90, 0xda, 0x71, 0x6b, 0x7b, 0x27, 0x42, 0xec, 0x24, 0xbe,
	0x52, 0x05, 0xb5, 0x80, 0x9a, 0xdc, 0xf8, 0x1a, 0x2a, 0xb9, 0xa3, 0x3b, 0x15, 0xd3, 0x05, 0x34,
	0x72, 0xa6, 0x74, 0x1e, 0xb7, 0xa0, 0x84, 0x37, 0x21, 0xf7, 0x19, 0x27, 0x3c, 0x63, 0x3a, 0x41,
	0x20, 0xa0, 0x73, 0x89, 0xc8, 0xe9, 0xc2, 0x83, 0x24, 0xe3, 0x83, 0xe9, 0x22, 0x29, 0x8d, 0x23,
	0x35, 0x4f, 0x48, 0x53, 0xee, 0x15, 0xd4, 0x1e, 0x23, 0x57, 0x4d, 0xc9, 0xa4, 0x6f, 0x15, 0xe6,
	0x65, 0xe0, 0xaa, 0x5c, 0x17, 0x3d, 0x4d, 0x39, 0xf7, 0xa1, 0x12, 0xc6, 0xed, 0x28, 0x0b, 0xd0,
	0xbf, 0x0a, 0xf1, 0x9a, 0x49, 0x13, 0x0b, 0x5e, 0x59, 0x83, 0xaf, 0x04, 0xe6, 0x7c, 0x0c, 0x55,
	0xbc, 0x51, 0x4c, 0x5a, 0x89, 0x9a, 0x66, 0x15, 0x8d, 0xca, 0xee, 0xce, 0x5c, 0x84, 0xba, 0x65,
	0x57, 0x47, 0x77, 0x06, 0x75, 0xd5, 0x56, 0xad, 0x49, 0x71, 0x97, 0x56, 0x5d, 0x63, 0x23, 0x88,
	0xbb, 0x06, 0x2b, 0x8f, 0x91, 0x5b, 0xf5, 0xaf, 0x63, 0x74, 0x7f, 0x07, 0xab, 0xa3, 0x07, 0xda,
	0x89, 0xdf, 0x40, 0x29, 0xff, 0x62, 0x85, 0xf9, 0xcd, 0x09, 0xe6, 0x6d, 0x61, 0x5b, 0xc4, 0x5d,
	0x06, 0xe7, 0x1c, 0xb9, 0x87, 0x24, 0x78, 0x1e, 0x47, 0x7d, 0x63, 0x71, 0x05, 0x1a, 0x39, 0x54,
	0x97, 0xf0, 0x10, 0x7e, 0x4d, 0x43, 0x8e, 0x86, 0x7b, 0x15, 0x96, 0xf3, 0xb0, 0x66, 0xff, 0x16,
	0xea, 0x6a, 0xb2, 0xbd, 0xe8, 0xa7, 0x86, 0xd9, 0xf9, 0x15, 0x94, 0x94, 0x7b, 0xbe, 0x9c, 0xfb,
	0xc2, 0xe5, 0xea, 0xfe, 0xf2, 0xde, 0x60, 0x8d, 0x91, 0x39, 0xe7, 0x52, 0x02, 0xf8, 0xe0, 0xb7,
	0xf0, 0xd3, 0xd6, 0x35, 0x74, 0xc8, 0xc3, 0x0b, 0x8a, 0xac, 0x2b, 0x4a, 0xca, 0x76, 0x28, 0x0f,
	0x6b, 0xf6, 0x35, 0x58, 0xf1, 0xb2, 0xf8, 0x09, 0x92, 0x88, 0x77, 0xe5, 0xd4, 0x31, 0x02, 0x4d,
	0x58, 0x1d, 0x3d, 0xd0, 0x22, 0x9f, 0x43, 0xf3, 0x69, 0x27, 0x4e, 0x28, 0xaa, 0xc3, 0x13, 0x4a,
	0x13, 0x9a, 0x6b, 0x29, 0x9c, 0x23, 0x8d, 0x87, 0x8d, 0x42, 0x92, 0xee, 0x47, 0xb0, 0x3e, 0x41,
	0x4a, 0xab, 0xfc, 0x4a, 0x38, 0x2d, 0xfa, 0x49, 0xbe, 0x92, 0xef, 0x43, 0xe5, 0x9a, 0x84, 0xdc,
	0x1f, 0x34, 0x34, 0xa5, 0xb3, 0x2c, 0x40, 0xd3, 0x02, 0x55, 0x64, 0xb6, 0xac, 0xd6, 0xb9, 0x0f,
	0xab, 0x67, 0x14, 0x2f, 0xa2, 0xb0, 0xd3, 0x1d, 0x79, 0x20, 0x62, 0x55, 0x93, 0x89, 0x33, 0x2f,
	0xc4, 0x90, 0x6e, 0x07, 0xd6, 0xc6, 0x64, 0x74, 0x5d, 0x3d, 0x83, 0xaa, 0xe2, 0xf2, 0xa9, 0x5c,
	0x4a, 0xcc, 0x30, 0xf8, 0xf8, 0xd6, 0xca, 0xb6, 0x57, 0x18, 0xaf, 0xd2, 0xb6, 0x28, 0xe6, 0xfe,
	0xbb, 0x00, 0xce, 0x41, 0x9a, 0x46, 0xfd, 0xbc, 0x67, 0x35, 0x28, 0xb2, 0x37, 0x91, 0x69, 0x31,
	0xec, 0x4d, 0x24, 0x5a, 0xcc, 0x45, 0x42, 0xdb, 0xa8, 0x1f, 0xab, 0x22, 0xc4, 0x0e, 0x41, 0xa2,
	0x28, 0xb9, 0xf6, 0xad, 0xd5, 0x56, 0x76, 0x86, 0x05, 0xaf, 0x26, 0x0f, 0xbc, 0x21, 0x3e, 0xbe,
	0x3d, 0xcd, 0x7e, 0xa8, 0xed, 0x69, 0xee, 0x3d, 0xb7, 0xa7, 0xbf, 0x15, 0xa0, 0x91, 0x8b, 0x5e,
	0xe7, 0xf8, 0x7f, 0x6f, 0xcf, 0xfb, 0x7b, 0x01, 0x9a, 0xba, 0x91, 0x9f, 0x22, 0x6f, 0x77, 0x0f,
	0xd8, 0x71, 0x6b, 0x70, 0x5b, 0xcb, 0x30, 0x27, 0xbf, 0x3b, 0xa4, 0x9b, 0x65, 0x4f, 0x11, 0xce,
	0x1a, 0xdc, 0x0b, 0x5a, 0xbe, 0x1c, 0x60, 0xba, 0x87, 0x07, 0xad, 0x1f, 0xc4, 0x08, 0x5b, 0x87,
	0x85, 0x1e, 0xb9, 0xf1, 0x69, 0x72, 0xcd, 0xf4, 0xbe, 0x77, 0xaf, 0x47, 0x6e, 0xbc, 0xe4, 0x9a,
	0xc9, 0x5d, 0x3c, 0x64, 0x72, 0xc9, 0x6e, 0x85, 0x71, 0x94, 0x74, 0x98, 0xbc, 0xa4, 0x05, 0xaf,
	0xaa, 0xe1, 0x43, 0x85, 0x8a, 0x17, 0x41, 0x65, 0xb1, 0xdb, 0x57, 0xb0, 0xe0, 0x95, 0xa9, 0xf5,
	0x02, 0xdc, 0xc7, 0xb0, 0x3e, 0xc1, 0x67, 0x9d, 0xe3, 0x87, 0x30, 0xaf, 0x0a, 0x58, 0x27, 0xd7,
	0xd9, 0x53, 0xdf, 0x4e, 0x3f, 0x8a, 0xbf, 0xba, 0x58, 0x35, 0x87, 0xfb, 0xc7, 0x02, 0xfc, 0x5f,
	0x5e, 0xd3, 0x41, 0x14, 0x89, 0x1d, 0x8b, 0x7d, 0xf8, 0x14, 0x8c, 0x45, 0x36, 0x3b, 0x21, 0xb2,
	0x67, 0xb0, 0x79, 0x9b, 0x3f, 0xef, 0x11, 0xde, 0x77, 0xa3, 0x77, 0x7b, 0x90, 0xa6, 0x6f, 0x0f,
	0xcc, 0xf6, 0x7f, 0x26, 0xe7, 0xff, 0x78, 0xd2, 0xa5, 0xb2, 0xf7, 0xf0, 0x4a, 0x8c, 0x9f, 0x88,
	0x5c, 0xa1, 0xda, 0x08, 0x4c, 0x3b, 0x3e, 0x85, 0x46, 0x0e, 0xd5, 0x8a, 0x3f, 0x15, 0x7b, 0xc1,
	0x60, 0x97, 0x28, 0xed, 0xaf, 0xed, 0x8d, 0x7e, 0xec, 0x6a, 0x01, 0xcd, 0x26, 0xfa, 0xfd, 0xf7,
	0x84, 0x71, 0xa4, 0xa6, 0x7f, 0x1a, 0x03, 0x9f, 0xc3, 0xea, 0xe8, 0x81, 0xb6, 0x61, 0x6f, 0x94,
	0x85, 0x91, 0x8d, 0xd2, 0x81, 0xda, 0x39, 0x4f, 0x52, 0xe9, 0x9a, 0xd1, 0xd4, 0x80, 0xba, 0x85,
	0xe9, 0x6e, 0xfc, 0x5b, 0x58, 0x1b, 0x80, 0xdf, 0x87, 0x71, 0xd8, 0xcb, 0x7a, 0xd6, 0xca, 0x78,
	0x9b, 0x7e, 0x67, 0x07, 0x64, 0xb3, 0xf7, 0x79, 0xd8, 0x43, 0xb3, 0x15, 0x15, 0xbd, 0x92, 0xc0,
	0x5e, 0x28, 0xc8, 0xfd, 0x02, 0x9a, 0xe3, 0x9a, 0xa7, 0x70, 0x5d, 0xba, 0x49, 0x28, 0xcf, 0xf9,
	0x2e, 0x92, 0x6f, 0x81, 0xda, 0xf9, 0x63, 0xd8, 0x51, 0x33, 0xf8, 0xe4, 0x46, 0xcc, 0x32, 0x12,
	0x89, 0x05, 0x20, 0x25, 0x14, 0x63, 0x8e, 0x81, 0x09, 0x43, 0xee, 0x76, 0xea, 0xd8, 0x0f, 0xcd,
	0x9e, 0x0c, 0x06, 0x7a, 0x1a, 0xb8, 0x0f, 0xc0, 0x7d, 0x9b, 0x16, 0x6d, 0x6b, 0x1b, 0x36, 0x47,
	0xb9, 0x4e, 0x22, 0x6c, 0x0f, 0x0d, 0xb9, 0x3b, 0xb0, 0x75, 0x2b, 0x87, 0x56, 0xe2, 0xa8, 0xb5,
	0x50, 0x04, 0x31, 0xa8, 0xa0, 0x9f, 0xa9, 0x95, 0x4d, 0x63, 0x3a, 0x41, 0xcb, 0x30, 0x47, 0x82,
	0x80, 0x9a, 0x41, 0xa8, 0x08, 0xf7, 0x0f, 0xb0, 0xfa, 0x9a, 0x84, 0xdc, 0xfa, 0xd0, 0x30, 0x41,
	0x1e, 0x40, 0xb9, 0x15, 0xa5, 0xf9, 0x81, 0x3c, 0x79, 0xbd, 0xb2, 0x85, 0x4b, 0x2d, 0xeb, 0x93,
	0x65, 0x8a, 0x2b, 0x5d, 0x87, 0xb5, 0x31, 0xfb, 0x3a, 0xb2, 0x1a, 0x54, 0xc5, 0x6d, 0x1f, 0x46,
	0xe6, 0xa5, 0xba, 0xaf, 0x60, 0x69, 0x80, 0xe8, 0xa8, 0x8e, 0xa0, 0x62, 0x7b, 0x69, 0x46, 0xf5,
	0xbb, 0xdc, 0x2c, 0x5b, 0x6e, 0x32, 0xb7, 0x2e, 0xf4, 0x12, 0xca, 0x2d, 0x53, 0xb2, 0xda, 0x0d,
	0xa4, 0x1d, 0xfa, 0x3d, 0x38, 0x5e, 0x16, 0x1f, 0x46, 0xe9, 0xcb, 0x98, 0x87, 0x91, 0xc9, 0xd3,
	0x87, 0xf0, 0x60, 0x9a, 0x4c, 0x3d, 0x82, 0x46, 0xce, 0xfa, 0x14, 0x75, 0xbf, 0x0e, 0x6b, 0x1e,
	0x32, 0xb1, 0x9c, 0x0e, 0x1a, 0x85, 0x89, 0x6f, 0x03, 0x9a, 0xe3, 0x47, 0x3a, 0xce, 0x06, 0xd4,
	0x9f, 0xc6, 0x21, 0x57, 0x3d, 0xc2, 0x08, 0xfc, 0x12, 0x1c, 0x1b, 0x9c, 0xc2, 0xfa, 0x4f, 0x05,
	0xd8, 0x3c, 0x4b, 0xd2, 0x2c, 0x92, 0x4b, 0xa8, 0xaa, 0xfe, 0x6f, 0x93, 0x4c, 0x94, 0xb1, 0xc9,
	0xdd, 0xff, 0xc3, 0x92, 0x88, 0xd8, 0x6f, 0x53, 0x24, 0x1c, 0x03, 0x3f, 0x36, 0x1f, 0x4a, 0x15,
	0x01, 0x1f, 0x29, 0xf4, 0x07, 0x26, 0x1e, 0x1c, 0x69, 0x0b, 0xa5, 0xf6, 0xa4, 0x01, 0x05, 0xc9,
	0x69, 0xf3, 0x25, 0x94, 0x7b, 0xd2, 0x33, 0x9f, 0x44, 0x21, 0x51, 0x13, 0xa7, 0xb4, 0xbf, 0x32,
	0xba, 0x58, 0x1f, 0x88, 0x43, 0xaf, 0xa4, 0x58, 0x25, 0xe1, 0x3c, 0x82, 0x65, 0xab, 0x8f, 0x0e,
	0xcb, 0x7d, 0x56, 0xda, 0x68, 0x58, 0x67, 0x83, 0x35, 0x74, 0x07, 0xb6, 0x6e, 0x8d, 0x4b, 0xa7,
	0xf0, 0xcf, 0x05, 0xa8, 0x89, 0x74, 0xd9, 0x1d, 0xc7, 0xf9, 0x05, 0xcc, 0x2b, 0x6e, 0xfd, 0x96,
	0x6e, 0x71, 0x4f, 0x33, 0xdd, 0xea, 0xd9, 0xcc, 0xad, 0x9e, 0x4d, 0xca, 0x67, 0x71, 0x42, 0x3e,
	0xcd, 0x0d, 0xe7, 0x5b, 0xdf, 0x0a, 0x34, 0x8e, 0xb1, 0x97, 0x70, 0xcc, 0x5f, 0xfc, 0x3e, 0x2c,
	0xe7, 0xe1, 0x29, 0xae, 0xfe, 0x1b, 0xd8, 0x3a, 0xa3, 0x89, 0x10, 0x92, 0x26, 0x5e, 0x77, 0x31,
	0x3e, 0x22, 0x59, 0xa7, 0xcb, 0x5f, 0xa6, 0x53, 0x8c, 0x02, 0xf7, 0xd7, 0xb0, 0x7d, 0xbb, 0xf8,
	0x74, 0x75, 0xaf, 0x04, 0x09, 0xd3, 0x7a, 0x02, 0xab, 0xee, 0xc7, 0x8f, 0x74, 0x02, 0xfe, 0x54,
	0x80, 0xda, 0x39, 0xe6, 0xeb, 0xfe, 0xae, 0x97, 0x36, 0xe1, 0x06, 0x66, 0x26, 0x55, 0xf4, 0x43,
	0xa8, 0xcb, 0xfd, 0xde, 0x67, 0xa2, 0xcb, 0xf8, 0x4c, 0xf8, 0xa4, 0xd7, 0xfa, 0x25, 0x79, 0x30,
	0x9c, 0x4d, 0x72, 0x7c, 0xe1, 0xc8, 0xcb, 0x73, 0x9f, 0x0e, 0x03, 0xf1, 0x50, 0x2a, 0x19, 0xce,
	0xa7, 0xbb, 0xf9, 0x2c, 0xbe, 0xd7, 0x26, 0xa8, 0xd2, 0x76, 0x1e, 0x80, 0x2b, 0x7a, 0xae, 0xd5,
	0x27, 0x0e, 0xe2, 0x40, 0x4c, 0x97, 0xdc, 0xce, 0xf2, 0x0a, 0xee, 0xbf, 0x95, 0xeb, 0x7d, 0x77,
	0x98, 0x15, 0x68, 0xd8, 0x95, 0x60, 0xd5, 0x64, 0x1e, 0x9e, 0xa2, 0x28, 0x1e, 0x41, 0xe5, 0x90,
	0xb4, 0x2f, 0xb3, 0x41, 0x05, 0x6e, 0x43, 0xa9, 0x9d, 0xc4, 0xed, 0x8c, 0x52, 0x8c, 0xdb, 0x7d,
	0xdd, 0x78, 0x6c, 0xc8, 0xfd, 0x02, 0xaa, 0x46, 0x44, 0x1b, 0x78, 0x00, 0x73, 0x78, 0x35, 0x4c,
	0x6c, 0x75, 0xcf, 0xfc, 0x67, 0xe1, 0x44, 0xa0, 0x9e, 0x3a, 0xd4, 0xcd, 0x95, 0x27, 0x14, 0x4f,
	0x69, 0xd2, 0xcb, 0x59, 0x75, 0x0f, 0x60, 0x7d, 0xc2, 0xd9, 0x5d, 0xd4, 0xb7, 0xe6, 0xe5, 0xbf,
	0x31, 0x3e, 0xfb, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xe5, 0x67, 0xfd, 0x4a, 0x37, 0x19, 0x00,
	0x00,
}
