// Code generated by protoc-gen-go.
// source: tabletmanagerservice.proto
// DO NOT EDIT!

/*
Package tabletmanagerservice is a generated protocol buffer package.

It is generated from these files:
	tabletmanagerservice.proto

It has these top-level messages:
*/
package tabletmanagerservice

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import tabletmanagerdata "github.com/youtube/vitess/go/vt/proto/tabletmanagerdata"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for TabletManager service

type TabletManagerClient interface {
	// Ping returns the input payload
	Ping(ctx context.Context, in *tabletmanagerdata.PingRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PingResponse, error)
	// Sleep sleeps for the provided duration
	Sleep(ctx context.Context, in *tabletmanagerdata.SleepRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SleepResponse, error)
	// ExecuteHook executes the hook remotely
	ExecuteHook(ctx context.Context, in *tabletmanagerdata.ExecuteHookRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteHookResponse, error)
	// GetSchema asks the tablet for its schema
	GetSchema(ctx context.Context, in *tabletmanagerdata.GetSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetSchemaResponse, error)
	// GetPermissions asks the tablet for its permissions
	GetPermissions(ctx context.Context, in *tabletmanagerdata.GetPermissionsRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetPermissionsResponse, error)
	SetReadOnly(ctx context.Context, in *tabletmanagerdata.SetReadOnlyRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetReadOnlyResponse, error)
	SetReadWrite(ctx context.Context, in *tabletmanagerdata.SetReadWriteRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetReadWriteResponse, error)
	// ChangeType asks the remote tablet to change its type
	ChangeType(ctx context.Context, in *tabletmanagerdata.ChangeTypeRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ChangeTypeResponse, error)
	RefreshState(ctx context.Context, in *tabletmanagerdata.RefreshStateRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RefreshStateResponse, error)
	RunHealthCheck(ctx context.Context, in *tabletmanagerdata.RunHealthCheckRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RunHealthCheckResponse, error)
	IgnoreHealthError(ctx context.Context, in *tabletmanagerdata.IgnoreHealthErrorRequest, opts ...grpc.CallOption) (*tabletmanagerdata.IgnoreHealthErrorResponse, error)
	ReloadSchema(ctx context.Context, in *tabletmanagerdata.ReloadSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ReloadSchemaResponse, error)
	PreflightSchema(ctx context.Context, in *tabletmanagerdata.PreflightSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PreflightSchemaResponse, error)
	ApplySchema(ctx context.Context, in *tabletmanagerdata.ApplySchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ApplySchemaResponse, error)
	ExecuteFetchAsDba(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsDbaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsDbaResponse, error)
	ExecuteFetchAsAllPrivs(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsAllPrivsRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsAllPrivsResponse, error)
	ExecuteFetchAsApp(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsAppRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsAppResponse, error)
	// SlaveStatus returns the current slave status.
	SlaveStatus(ctx context.Context, in *tabletmanagerdata.SlaveStatusRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveStatusResponse, error)
	// MasterPosition returns the current master position
	MasterPosition(ctx context.Context, in *tabletmanagerdata.MasterPositionRequest, opts ...grpc.CallOption) (*tabletmanagerdata.MasterPositionResponse, error)
	// StopSlave makes mysql stop its replication
	StopSlave(ctx context.Context, in *tabletmanagerdata.StopSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopSlaveResponse, error)
	// StopSlaveMinimum stops the mysql replication after it reaches
	// the provided minimum point
	StopSlaveMinimum(ctx context.Context, in *tabletmanagerdata.StopSlaveMinimumRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopSlaveMinimumResponse, error)
	// StartSlave starts the mysql replication
	StartSlave(ctx context.Context, in *tabletmanagerdata.StartSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StartSlaveResponse, error)
	// TabletExternallyReparented tells a tablet that its underlying MySQL is
	// currently the master. It is only used in environments (tabletmanagerdata.such as Vitess+MoB)
	// in which MySQL is reparented by some agent external to Vitess, and then
	// that agent simply notifies Vitess.
	//
	// This call is idempotent with respect to a single target tablet.
	// However, the tablet assumes there is a cooling-off period following the
	// initial external reparent from A to B, before this call is repeated on any
	// tablet other than B. This assumption is configurable with the vttablet flag
	// "finalize_external_reparent_timeout".
	//
	// For more information, see the design doc at go/vt-fast-failover.
	TabletExternallyReparented(ctx context.Context, in *tabletmanagerdata.TabletExternallyReparentedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.TabletExternallyReparentedResponse, error)
	// TabletExternallyElected is an notification that may be sent in
	// anticipation of potentially later sending TabletExternallyReparented.
	// The tablet can use this extra lead time to prepare to react quickly if
	// TabletExternallyReparented does follow.
	//
	// This call is effectively a no-op if it is not followed by a call to
	// TabletExternallyReparented, so the external agent doing the reparent can
	// still change its mind.
	//
	// The agent does not need to wait for this call or cancel it before calling
	// TabletExternallyReparented if the external reparent operation finishes
	// before TabletExternallyElected returns.
	TabletExternallyElected(ctx context.Context, in *tabletmanagerdata.TabletExternallyElectedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.TabletExternallyElectedResponse, error)
	// GetSlaves asks for the list of mysql slaves
	GetSlaves(ctx context.Context, in *tabletmanagerdata.GetSlavesRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetSlavesResponse, error)
	// WaitBlpPosition tells the remote tablet to wait until it reaches
	// the specified binolg player position
	WaitBlpPosition(ctx context.Context, in *tabletmanagerdata.WaitBlpPositionRequest, opts ...grpc.CallOption) (*tabletmanagerdata.WaitBlpPositionResponse, error)
	// StopBlp asks the tablet to stop all its binlog players,
	// and returns the current position for all of them
	StopBlp(ctx context.Context, in *tabletmanagerdata.StopBlpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopBlpResponse, error)
	// StartBlp asks the tablet to restart its binlog players
	StartBlp(ctx context.Context, in *tabletmanagerdata.StartBlpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StartBlpResponse, error)
	// RunBlpUntil asks the tablet to restart its binlog players
	RunBlpUntil(ctx context.Context, in *tabletmanagerdata.RunBlpUntilRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RunBlpUntilResponse, error)
	// ResetReplication makes the target not replicating
	ResetReplication(ctx context.Context, in *tabletmanagerdata.ResetReplicationRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ResetReplicationResponse, error)
	// InitMaster initializes the tablet as a master
	InitMaster(ctx context.Context, in *tabletmanagerdata.InitMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.InitMasterResponse, error)
	// PopulateReparentJournal tells the tablet to add an entry to its
	// reparent journal
	PopulateReparentJournal(ctx context.Context, in *tabletmanagerdata.PopulateReparentJournalRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PopulateReparentJournalResponse, error)
	// InitSlave tells the tablet to reparent to the master unconditionnally
	InitSlave(ctx context.Context, in *tabletmanagerdata.InitSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.InitSlaveResponse, error)
	// DemoteMaster tells the soon-to-be-former master it's gonna change
	DemoteMaster(ctx context.Context, in *tabletmanagerdata.DemoteMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.DemoteMasterResponse, error)
	// PromoteSlaveWhenCaughtUp tells the remote tablet to catch up,
	// and then be the master
	PromoteSlaveWhenCaughtUp(ctx context.Context, in *tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PromoteSlaveWhenCaughtUpResponse, error)
	// SlaveWasPromoted tells the remote tablet it is now the master
	SlaveWasPromoted(ctx context.Context, in *tabletmanagerdata.SlaveWasPromotedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveWasPromotedResponse, error)
	// SetMaster tells the slave to reparent
	SetMaster(ctx context.Context, in *tabletmanagerdata.SetMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetMasterResponse, error)
	// SlaveWasRestarted tells the remote tablet its master has changed
	SlaveWasRestarted(ctx context.Context, in *tabletmanagerdata.SlaveWasRestartedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveWasRestartedResponse, error)
	// StopReplicationAndGetStatus stops MySQL replication, and returns the
	// replication status
	StopReplicationAndGetStatus(ctx context.Context, in *tabletmanagerdata.StopReplicationAndGetStatusRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopReplicationAndGetStatusResponse, error)
	// PromoteSlave makes the slave the new master
	PromoteSlave(ctx context.Context, in *tabletmanagerdata.PromoteSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PromoteSlaveResponse, error)
	Backup(ctx context.Context, in *tabletmanagerdata.BackupRequest, opts ...grpc.CallOption) (TabletManager_BackupClient, error)
	// RestoreFromBackup deletes all local data and restores it from the latest backup.
	RestoreFromBackup(ctx context.Context, in *tabletmanagerdata.RestoreFromBackupRequest, opts ...grpc.CallOption) (TabletManager_RestoreFromBackupClient, error)
}

type tabletManagerClient struct {
	cc *grpc.ClientConn
}

func NewTabletManagerClient(cc *grpc.ClientConn) TabletManagerClient {
	return &tabletManagerClient{cc}
}

func (c *tabletManagerClient) Ping(ctx context.Context, in *tabletmanagerdata.PingRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PingResponse, error) {
	out := new(tabletmanagerdata.PingResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/Ping", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) Sleep(ctx context.Context, in *tabletmanagerdata.SleepRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SleepResponse, error) {
	out := new(tabletmanagerdata.SleepResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/Sleep", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ExecuteHook(ctx context.Context, in *tabletmanagerdata.ExecuteHookRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteHookResponse, error) {
	out := new(tabletmanagerdata.ExecuteHookResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ExecuteHook", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) GetSchema(ctx context.Context, in *tabletmanagerdata.GetSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetSchemaResponse, error) {
	out := new(tabletmanagerdata.GetSchemaResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/GetSchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) GetPermissions(ctx context.Context, in *tabletmanagerdata.GetPermissionsRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetPermissionsResponse, error) {
	out := new(tabletmanagerdata.GetPermissionsResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/GetPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SetReadOnly(ctx context.Context, in *tabletmanagerdata.SetReadOnlyRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetReadOnlyResponse, error) {
	out := new(tabletmanagerdata.SetReadOnlyResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SetReadOnly", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SetReadWrite(ctx context.Context, in *tabletmanagerdata.SetReadWriteRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetReadWriteResponse, error) {
	out := new(tabletmanagerdata.SetReadWriteResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SetReadWrite", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ChangeType(ctx context.Context, in *tabletmanagerdata.ChangeTypeRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ChangeTypeResponse, error) {
	out := new(tabletmanagerdata.ChangeTypeResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ChangeType", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) RefreshState(ctx context.Context, in *tabletmanagerdata.RefreshStateRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RefreshStateResponse, error) {
	out := new(tabletmanagerdata.RefreshStateResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/RefreshState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) RunHealthCheck(ctx context.Context, in *tabletmanagerdata.RunHealthCheckRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RunHealthCheckResponse, error) {
	out := new(tabletmanagerdata.RunHealthCheckResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/RunHealthCheck", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) IgnoreHealthError(ctx context.Context, in *tabletmanagerdata.IgnoreHealthErrorRequest, opts ...grpc.CallOption) (*tabletmanagerdata.IgnoreHealthErrorResponse, error) {
	out := new(tabletmanagerdata.IgnoreHealthErrorResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/IgnoreHealthError", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ReloadSchema(ctx context.Context, in *tabletmanagerdata.ReloadSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ReloadSchemaResponse, error) {
	out := new(tabletmanagerdata.ReloadSchemaResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ReloadSchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) PreflightSchema(ctx context.Context, in *tabletmanagerdata.PreflightSchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PreflightSchemaResponse, error) {
	out := new(tabletmanagerdata.PreflightSchemaResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/PreflightSchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ApplySchema(ctx context.Context, in *tabletmanagerdata.ApplySchemaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ApplySchemaResponse, error) {
	out := new(tabletmanagerdata.ApplySchemaResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ApplySchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ExecuteFetchAsDba(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsDbaRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsDbaResponse, error) {
	out := new(tabletmanagerdata.ExecuteFetchAsDbaResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ExecuteFetchAsDba", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ExecuteFetchAsAllPrivs(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsAllPrivsRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsAllPrivsResponse, error) {
	out := new(tabletmanagerdata.ExecuteFetchAsAllPrivsResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ExecuteFetchAsAllPrivs", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ExecuteFetchAsApp(ctx context.Context, in *tabletmanagerdata.ExecuteFetchAsAppRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ExecuteFetchAsAppResponse, error) {
	out := new(tabletmanagerdata.ExecuteFetchAsAppResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ExecuteFetchAsApp", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SlaveStatus(ctx context.Context, in *tabletmanagerdata.SlaveStatusRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveStatusResponse, error) {
	out := new(tabletmanagerdata.SlaveStatusResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SlaveStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) MasterPosition(ctx context.Context, in *tabletmanagerdata.MasterPositionRequest, opts ...grpc.CallOption) (*tabletmanagerdata.MasterPositionResponse, error) {
	out := new(tabletmanagerdata.MasterPositionResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/MasterPosition", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StopSlave(ctx context.Context, in *tabletmanagerdata.StopSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopSlaveResponse, error) {
	out := new(tabletmanagerdata.StopSlaveResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StopSlave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StopSlaveMinimum(ctx context.Context, in *tabletmanagerdata.StopSlaveMinimumRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopSlaveMinimumResponse, error) {
	out := new(tabletmanagerdata.StopSlaveMinimumResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StopSlaveMinimum", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StartSlave(ctx context.Context, in *tabletmanagerdata.StartSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StartSlaveResponse, error) {
	out := new(tabletmanagerdata.StartSlaveResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StartSlave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) TabletExternallyReparented(ctx context.Context, in *tabletmanagerdata.TabletExternallyReparentedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.TabletExternallyReparentedResponse, error) {
	out := new(tabletmanagerdata.TabletExternallyReparentedResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/TabletExternallyReparented", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) TabletExternallyElected(ctx context.Context, in *tabletmanagerdata.TabletExternallyElectedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.TabletExternallyElectedResponse, error) {
	out := new(tabletmanagerdata.TabletExternallyElectedResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/TabletExternallyElected", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) GetSlaves(ctx context.Context, in *tabletmanagerdata.GetSlavesRequest, opts ...grpc.CallOption) (*tabletmanagerdata.GetSlavesResponse, error) {
	out := new(tabletmanagerdata.GetSlavesResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/GetSlaves", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) WaitBlpPosition(ctx context.Context, in *tabletmanagerdata.WaitBlpPositionRequest, opts ...grpc.CallOption) (*tabletmanagerdata.WaitBlpPositionResponse, error) {
	out := new(tabletmanagerdata.WaitBlpPositionResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/WaitBlpPosition", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StopBlp(ctx context.Context, in *tabletmanagerdata.StopBlpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopBlpResponse, error) {
	out := new(tabletmanagerdata.StopBlpResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StopBlp", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StartBlp(ctx context.Context, in *tabletmanagerdata.StartBlpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StartBlpResponse, error) {
	out := new(tabletmanagerdata.StartBlpResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StartBlp", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) RunBlpUntil(ctx context.Context, in *tabletmanagerdata.RunBlpUntilRequest, opts ...grpc.CallOption) (*tabletmanagerdata.RunBlpUntilResponse, error) {
	out := new(tabletmanagerdata.RunBlpUntilResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/RunBlpUntil", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) ResetReplication(ctx context.Context, in *tabletmanagerdata.ResetReplicationRequest, opts ...grpc.CallOption) (*tabletmanagerdata.ResetReplicationResponse, error) {
	out := new(tabletmanagerdata.ResetReplicationResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/ResetReplication", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) InitMaster(ctx context.Context, in *tabletmanagerdata.InitMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.InitMasterResponse, error) {
	out := new(tabletmanagerdata.InitMasterResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/InitMaster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) PopulateReparentJournal(ctx context.Context, in *tabletmanagerdata.PopulateReparentJournalRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PopulateReparentJournalResponse, error) {
	out := new(tabletmanagerdata.PopulateReparentJournalResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/PopulateReparentJournal", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) InitSlave(ctx context.Context, in *tabletmanagerdata.InitSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.InitSlaveResponse, error) {
	out := new(tabletmanagerdata.InitSlaveResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/InitSlave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) DemoteMaster(ctx context.Context, in *tabletmanagerdata.DemoteMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.DemoteMasterResponse, error) {
	out := new(tabletmanagerdata.DemoteMasterResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/DemoteMaster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) PromoteSlaveWhenCaughtUp(ctx context.Context, in *tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PromoteSlaveWhenCaughtUpResponse, error) {
	out := new(tabletmanagerdata.PromoteSlaveWhenCaughtUpResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/PromoteSlaveWhenCaughtUp", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SlaveWasPromoted(ctx context.Context, in *tabletmanagerdata.SlaveWasPromotedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveWasPromotedResponse, error) {
	out := new(tabletmanagerdata.SlaveWasPromotedResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SlaveWasPromoted", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SetMaster(ctx context.Context, in *tabletmanagerdata.SetMasterRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SetMasterResponse, error) {
	out := new(tabletmanagerdata.SetMasterResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SetMaster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) SlaveWasRestarted(ctx context.Context, in *tabletmanagerdata.SlaveWasRestartedRequest, opts ...grpc.CallOption) (*tabletmanagerdata.SlaveWasRestartedResponse, error) {
	out := new(tabletmanagerdata.SlaveWasRestartedResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/SlaveWasRestarted", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) StopReplicationAndGetStatus(ctx context.Context, in *tabletmanagerdata.StopReplicationAndGetStatusRequest, opts ...grpc.CallOption) (*tabletmanagerdata.StopReplicationAndGetStatusResponse, error) {
	out := new(tabletmanagerdata.StopReplicationAndGetStatusResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/StopReplicationAndGetStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) PromoteSlave(ctx context.Context, in *tabletmanagerdata.PromoteSlaveRequest, opts ...grpc.CallOption) (*tabletmanagerdata.PromoteSlaveResponse, error) {
	out := new(tabletmanagerdata.PromoteSlaveResponse)
	err := grpc.Invoke(ctx, "/tabletmanagerservice.TabletManager/PromoteSlave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tabletManagerClient) Backup(ctx context.Context, in *tabletmanagerdata.BackupRequest, opts ...grpc.CallOption) (TabletManager_BackupClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_TabletManager_serviceDesc.Streams[0], c.cc, "/tabletmanagerservice.TabletManager/Backup", opts...)
	if err != nil {
		return nil, err
	}
	x := &tabletManagerBackupClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TabletManager_BackupClient interface {
	Recv() (*tabletmanagerdata.BackupResponse, error)
	grpc.ClientStream
}

type tabletManagerBackupClient struct {
	grpc.ClientStream
}

func (x *tabletManagerBackupClient) Recv() (*tabletmanagerdata.BackupResponse, error) {
	m := new(tabletmanagerdata.BackupResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *tabletManagerClient) RestoreFromBackup(ctx context.Context, in *tabletmanagerdata.RestoreFromBackupRequest, opts ...grpc.CallOption) (TabletManager_RestoreFromBackupClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_TabletManager_serviceDesc.Streams[1], c.cc, "/tabletmanagerservice.TabletManager/RestoreFromBackup", opts...)
	if err != nil {
		return nil, err
	}
	x := &tabletManagerRestoreFromBackupClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TabletManager_RestoreFromBackupClient interface {
	Recv() (*tabletmanagerdata.RestoreFromBackupResponse, error)
	grpc.ClientStream
}

type tabletManagerRestoreFromBackupClient struct {
	grpc.ClientStream
}

func (x *tabletManagerRestoreFromBackupClient) Recv() (*tabletmanagerdata.RestoreFromBackupResponse, error) {
	m := new(tabletmanagerdata.RestoreFromBackupResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for TabletManager service

type TabletManagerServer interface {
	// Ping returns the input payload
	Ping(context.Context, *tabletmanagerdata.PingRequest) (*tabletmanagerdata.PingResponse, error)
	// Sleep sleeps for the provided duration
	Sleep(context.Context, *tabletmanagerdata.SleepRequest) (*tabletmanagerdata.SleepResponse, error)
	// ExecuteHook executes the hook remotely
	ExecuteHook(context.Context, *tabletmanagerdata.ExecuteHookRequest) (*tabletmanagerdata.ExecuteHookResponse, error)
	// GetSchema asks the tablet for its schema
	GetSchema(context.Context, *tabletmanagerdata.GetSchemaRequest) (*tabletmanagerdata.GetSchemaResponse, error)
	// GetPermissions asks the tablet for its permissions
	GetPermissions(context.Context, *tabletmanagerdata.GetPermissionsRequest) (*tabletmanagerdata.GetPermissionsResponse, error)
	SetReadOnly(context.Context, *tabletmanagerdata.SetReadOnlyRequest) (*tabletmanagerdata.SetReadOnlyResponse, error)
	SetReadWrite(context.Context, *tabletmanagerdata.SetReadWriteRequest) (*tabletmanagerdata.SetReadWriteResponse, error)
	// ChangeType asks the remote tablet to change its type
	ChangeType(context.Context, *tabletmanagerdata.ChangeTypeRequest) (*tabletmanagerdata.ChangeTypeResponse, error)
	RefreshState(context.Context, *tabletmanagerdata.RefreshStateRequest) (*tabletmanagerdata.RefreshStateResponse, error)
	RunHealthCheck(context.Context, *tabletmanagerdata.RunHealthCheckRequest) (*tabletmanagerdata.RunHealthCheckResponse, error)
	IgnoreHealthError(context.Context, *tabletmanagerdata.IgnoreHealthErrorRequest) (*tabletmanagerdata.IgnoreHealthErrorResponse, error)
	ReloadSchema(context.Context, *tabletmanagerdata.ReloadSchemaRequest) (*tabletmanagerdata.ReloadSchemaResponse, error)
	PreflightSchema(context.Context, *tabletmanagerdata.PreflightSchemaRequest) (*tabletmanagerdata.PreflightSchemaResponse, error)
	ApplySchema(context.Context, *tabletmanagerdata.ApplySchemaRequest) (*tabletmanagerdata.ApplySchemaResponse, error)
	ExecuteFetchAsDba(context.Context, *tabletmanagerdata.ExecuteFetchAsDbaRequest) (*tabletmanagerdata.ExecuteFetchAsDbaResponse, error)
	ExecuteFetchAsAllPrivs(context.Context, *tabletmanagerdata.ExecuteFetchAsAllPrivsRequest) (*tabletmanagerdata.ExecuteFetchAsAllPrivsResponse, error)
	ExecuteFetchAsApp(context.Context, *tabletmanagerdata.ExecuteFetchAsAppRequest) (*tabletmanagerdata.ExecuteFetchAsAppResponse, error)
	// SlaveStatus returns the current slave status.
	SlaveStatus(context.Context, *tabletmanagerdata.SlaveStatusRequest) (*tabletmanagerdata.SlaveStatusResponse, error)
	// MasterPosition returns the current master position
	MasterPosition(context.Context, *tabletmanagerdata.MasterPositionRequest) (*tabletmanagerdata.MasterPositionResponse, error)
	// StopSlave makes mysql stop its replication
	StopSlave(context.Context, *tabletmanagerdata.StopSlaveRequest) (*tabletmanagerdata.StopSlaveResponse, error)
	// StopSlaveMinimum stops the mysql replication after it reaches
	// the provided minimum point
	StopSlaveMinimum(context.Context, *tabletmanagerdata.StopSlaveMinimumRequest) (*tabletmanagerdata.StopSlaveMinimumResponse, error)
	// StartSlave starts the mysql replication
	StartSlave(context.Context, *tabletmanagerdata.StartSlaveRequest) (*tabletmanagerdata.StartSlaveResponse, error)
	// TabletExternallyReparented tells a tablet that its underlying MySQL is
	// currently the master. It is only used in environments (tabletmanagerdata.such as Vitess+MoB)
	// in which MySQL is reparented by some agent external to Vitess, and then
	// that agent simply notifies Vitess.
	//
	// This call is idempotent with respect to a single target tablet.
	// However, the tablet assumes there is a cooling-off period following the
	// initial external reparent from A to B, before this call is repeated on any
	// tablet other than B. This assumption is configurable with the vttablet flag
	// "finalize_external_reparent_timeout".
	//
	// For more information, see the design doc at go/vt-fast-failover.
	TabletExternallyReparented(context.Context, *tabletmanagerdata.TabletExternallyReparentedRequest) (*tabletmanagerdata.TabletExternallyReparentedResponse, error)
	// TabletExternallyElected is an notification that may be sent in
	// anticipation of potentially later sending TabletExternallyReparented.
	// The tablet can use this extra lead time to prepare to react quickly if
	// TabletExternallyReparented does follow.
	//
	// This call is effectively a no-op if it is not followed by a call to
	// TabletExternallyReparented, so the external agent doing the reparent can
	// still change its mind.
	//
	// The agent does not need to wait for this call or cancel it before calling
	// TabletExternallyReparented if the external reparent operation finishes
	// before TabletExternallyElected returns.
	TabletExternallyElected(context.Context, *tabletmanagerdata.TabletExternallyElectedRequest) (*tabletmanagerdata.TabletExternallyElectedResponse, error)
	// GetSlaves asks for the list of mysql slaves
	GetSlaves(context.Context, *tabletmanagerdata.GetSlavesRequest) (*tabletmanagerdata.GetSlavesResponse, error)
	// WaitBlpPosition tells the remote tablet to wait until it reaches
	// the specified binolg player position
	WaitBlpPosition(context.Context, *tabletmanagerdata.WaitBlpPositionRequest) (*tabletmanagerdata.WaitBlpPositionResponse, error)
	// StopBlp asks the tablet to stop all its binlog players,
	// and returns the current position for all of them
	StopBlp(context.Context, *tabletmanagerdata.StopBlpRequest) (*tabletmanagerdata.StopBlpResponse, error)
	// StartBlp asks the tablet to restart its binlog players
	StartBlp(context.Context, *tabletmanagerdata.StartBlpRequest) (*tabletmanagerdata.StartBlpResponse, error)
	// RunBlpUntil asks the tablet to restart its binlog players
	RunBlpUntil(context.Context, *tabletmanagerdata.RunBlpUntilRequest) (*tabletmanagerdata.RunBlpUntilResponse, error)
	// ResetReplication makes the target not replicating
	ResetReplication(context.Context, *tabletmanagerdata.ResetReplicationRequest) (*tabletmanagerdata.ResetReplicationResponse, error)
	// InitMaster initializes the tablet as a master
	InitMaster(context.Context, *tabletmanagerdata.InitMasterRequest) (*tabletmanagerdata.InitMasterResponse, error)
	// PopulateReparentJournal tells the tablet to add an entry to its
	// reparent journal
	PopulateReparentJournal(context.Context, *tabletmanagerdata.PopulateReparentJournalRequest) (*tabletmanagerdata.PopulateReparentJournalResponse, error)
	// InitSlave tells the tablet to reparent to the master unconditionnally
	InitSlave(context.Context, *tabletmanagerdata.InitSlaveRequest) (*tabletmanagerdata.InitSlaveResponse, error)
	// DemoteMaster tells the soon-to-be-former master it's gonna change
	DemoteMaster(context.Context, *tabletmanagerdata.DemoteMasterRequest) (*tabletmanagerdata.DemoteMasterResponse, error)
	// PromoteSlaveWhenCaughtUp tells the remote tablet to catch up,
	// and then be the master
	PromoteSlaveWhenCaughtUp(context.Context, *tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest) (*tabletmanagerdata.PromoteSlaveWhenCaughtUpResponse, error)
	// SlaveWasPromoted tells the remote tablet it is now the master
	SlaveWasPromoted(context.Context, *tabletmanagerdata.SlaveWasPromotedRequest) (*tabletmanagerdata.SlaveWasPromotedResponse, error)
	// SetMaster tells the slave to reparent
	SetMaster(context.Context, *tabletmanagerdata.SetMasterRequest) (*tabletmanagerdata.SetMasterResponse, error)
	// SlaveWasRestarted tells the remote tablet its master has changed
	SlaveWasRestarted(context.Context, *tabletmanagerdata.SlaveWasRestartedRequest) (*tabletmanagerdata.SlaveWasRestartedResponse, error)
	// StopReplicationAndGetStatus stops MySQL replication, and returns the
	// replication status
	StopReplicationAndGetStatus(context.Context, *tabletmanagerdata.StopReplicationAndGetStatusRequest) (*tabletmanagerdata.StopReplicationAndGetStatusResponse, error)
	// PromoteSlave makes the slave the new master
	PromoteSlave(context.Context, *tabletmanagerdata.PromoteSlaveRequest) (*tabletmanagerdata.PromoteSlaveResponse, error)
	Backup(*tabletmanagerdata.BackupRequest, TabletManager_BackupServer) error
	// RestoreFromBackup deletes all local data and restores it from the latest backup.
	RestoreFromBackup(*tabletmanagerdata.RestoreFromBackupRequest, TabletManager_RestoreFromBackupServer) error
}

func RegisterTabletManagerServer(s *grpc.Server, srv TabletManagerServer) {
	s.RegisterService(&_TabletManager_serviceDesc, srv)
}

func _TabletManager_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.PingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).Ping(ctx, req.(*tabletmanagerdata.PingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_Sleep_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SleepRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).Sleep(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/Sleep",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).Sleep(ctx, req.(*tabletmanagerdata.SleepRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ExecuteHook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ExecuteHookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ExecuteHook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ExecuteHook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ExecuteHook(ctx, req.(*tabletmanagerdata.ExecuteHookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_GetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.GetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).GetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/GetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).GetSchema(ctx, req.(*tabletmanagerdata.GetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_GetPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.GetPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).GetPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/GetPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).GetPermissions(ctx, req.(*tabletmanagerdata.GetPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SetReadOnly_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SetReadOnlyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SetReadOnly(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SetReadOnly",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SetReadOnly(ctx, req.(*tabletmanagerdata.SetReadOnlyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SetReadWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SetReadWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SetReadWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SetReadWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SetReadWrite(ctx, req.(*tabletmanagerdata.SetReadWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ChangeType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ChangeTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ChangeType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ChangeType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ChangeType(ctx, req.(*tabletmanagerdata.ChangeTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_RefreshState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.RefreshStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).RefreshState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/RefreshState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).RefreshState(ctx, req.(*tabletmanagerdata.RefreshStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_RunHealthCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.RunHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).RunHealthCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/RunHealthCheck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).RunHealthCheck(ctx, req.(*tabletmanagerdata.RunHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_IgnoreHealthError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.IgnoreHealthErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).IgnoreHealthError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/IgnoreHealthError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).IgnoreHealthError(ctx, req.(*tabletmanagerdata.IgnoreHealthErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ReloadSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ReloadSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ReloadSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ReloadSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ReloadSchema(ctx, req.(*tabletmanagerdata.ReloadSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_PreflightSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.PreflightSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).PreflightSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/PreflightSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).PreflightSchema(ctx, req.(*tabletmanagerdata.PreflightSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ApplySchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ApplySchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ApplySchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ApplySchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ApplySchema(ctx, req.(*tabletmanagerdata.ApplySchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ExecuteFetchAsDba_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ExecuteFetchAsDbaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ExecuteFetchAsDba(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ExecuteFetchAsDba",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ExecuteFetchAsDba(ctx, req.(*tabletmanagerdata.ExecuteFetchAsDbaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ExecuteFetchAsAllPrivs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ExecuteFetchAsAllPrivsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ExecuteFetchAsAllPrivs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ExecuteFetchAsAllPrivs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ExecuteFetchAsAllPrivs(ctx, req.(*tabletmanagerdata.ExecuteFetchAsAllPrivsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ExecuteFetchAsApp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ExecuteFetchAsAppRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ExecuteFetchAsApp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ExecuteFetchAsApp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ExecuteFetchAsApp(ctx, req.(*tabletmanagerdata.ExecuteFetchAsAppRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SlaveStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SlaveStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SlaveStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SlaveStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SlaveStatus(ctx, req.(*tabletmanagerdata.SlaveStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_MasterPosition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.MasterPositionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).MasterPosition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/MasterPosition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).MasterPosition(ctx, req.(*tabletmanagerdata.MasterPositionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StopSlave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StopSlaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StopSlave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StopSlave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StopSlave(ctx, req.(*tabletmanagerdata.StopSlaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StopSlaveMinimum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StopSlaveMinimumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StopSlaveMinimum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StopSlaveMinimum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StopSlaveMinimum(ctx, req.(*tabletmanagerdata.StopSlaveMinimumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StartSlave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StartSlaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StartSlave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StartSlave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StartSlave(ctx, req.(*tabletmanagerdata.StartSlaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_TabletExternallyReparented_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.TabletExternallyReparentedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).TabletExternallyReparented(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/TabletExternallyReparented",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).TabletExternallyReparented(ctx, req.(*tabletmanagerdata.TabletExternallyReparentedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_TabletExternallyElected_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.TabletExternallyElectedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).TabletExternallyElected(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/TabletExternallyElected",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).TabletExternallyElected(ctx, req.(*tabletmanagerdata.TabletExternallyElectedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_GetSlaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.GetSlavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).GetSlaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/GetSlaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).GetSlaves(ctx, req.(*tabletmanagerdata.GetSlavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_WaitBlpPosition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.WaitBlpPositionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).WaitBlpPosition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/WaitBlpPosition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).WaitBlpPosition(ctx, req.(*tabletmanagerdata.WaitBlpPositionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StopBlp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StopBlpRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StopBlp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StopBlp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StopBlp(ctx, req.(*tabletmanagerdata.StopBlpRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StartBlp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StartBlpRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StartBlp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StartBlp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StartBlp(ctx, req.(*tabletmanagerdata.StartBlpRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_RunBlpUntil_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.RunBlpUntilRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).RunBlpUntil(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/RunBlpUntil",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).RunBlpUntil(ctx, req.(*tabletmanagerdata.RunBlpUntilRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_ResetReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.ResetReplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).ResetReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/ResetReplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).ResetReplication(ctx, req.(*tabletmanagerdata.ResetReplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_InitMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.InitMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).InitMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/InitMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).InitMaster(ctx, req.(*tabletmanagerdata.InitMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_PopulateReparentJournal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.PopulateReparentJournalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).PopulateReparentJournal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/PopulateReparentJournal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).PopulateReparentJournal(ctx, req.(*tabletmanagerdata.PopulateReparentJournalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_InitSlave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.InitSlaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).InitSlave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/InitSlave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).InitSlave(ctx, req.(*tabletmanagerdata.InitSlaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_DemoteMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.DemoteMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).DemoteMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/DemoteMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).DemoteMaster(ctx, req.(*tabletmanagerdata.DemoteMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_PromoteSlaveWhenCaughtUp_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).PromoteSlaveWhenCaughtUp(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/PromoteSlaveWhenCaughtUp",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).PromoteSlaveWhenCaughtUp(ctx, req.(*tabletmanagerdata.PromoteSlaveWhenCaughtUpRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SlaveWasPromoted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SlaveWasPromotedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SlaveWasPromoted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SlaveWasPromoted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SlaveWasPromoted(ctx, req.(*tabletmanagerdata.SlaveWasPromotedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SetMaster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SetMasterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SetMaster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SetMaster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SetMaster(ctx, req.(*tabletmanagerdata.SetMasterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_SlaveWasRestarted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.SlaveWasRestartedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).SlaveWasRestarted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/SlaveWasRestarted",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).SlaveWasRestarted(ctx, req.(*tabletmanagerdata.SlaveWasRestartedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_StopReplicationAndGetStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.StopReplicationAndGetStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).StopReplicationAndGetStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/StopReplicationAndGetStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).StopReplicationAndGetStatus(ctx, req.(*tabletmanagerdata.StopReplicationAndGetStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_PromoteSlave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(tabletmanagerdata.PromoteSlaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TabletManagerServer).PromoteSlave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tabletmanagerservice.TabletManager/PromoteSlave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TabletManagerServer).PromoteSlave(ctx, req.(*tabletmanagerdata.PromoteSlaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TabletManager_Backup_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(tabletmanagerdata.BackupRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TabletManagerServer).Backup(m, &tabletManagerBackupServer{stream})
}

type TabletManager_BackupServer interface {
	Send(*tabletmanagerdata.BackupResponse) error
	grpc.ServerStream
}

type tabletManagerBackupServer struct {
	grpc.ServerStream
}

func (x *tabletManagerBackupServer) Send(m *tabletmanagerdata.BackupResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _TabletManager_RestoreFromBackup_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(tabletmanagerdata.RestoreFromBackupRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TabletManagerServer).RestoreFromBackup(m, &tabletManagerRestoreFromBackupServer{stream})
}

type TabletManager_RestoreFromBackupServer interface {
	Send(*tabletmanagerdata.RestoreFromBackupResponse) error
	grpc.ServerStream
}

type tabletManagerRestoreFromBackupServer struct {
	grpc.ServerStream
}

func (x *tabletManagerRestoreFromBackupServer) Send(m *tabletmanagerdata.RestoreFromBackupResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _TabletManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tabletmanagerservice.TabletManager",
	HandlerType: (*TabletManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Ping",
			Handler:    _TabletManager_Ping_Handler,
		},
		{
			MethodName: "Sleep",
			Handler:    _TabletManager_Sleep_Handler,
		},
		{
			MethodName: "ExecuteHook",
			Handler:    _TabletManager_ExecuteHook_Handler,
		},
		{
			MethodName: "GetSchema",
			Handler:    _TabletManager_GetSchema_Handler,
		},
		{
			MethodName: "GetPermissions",
			Handler:    _TabletManager_GetPermissions_Handler,
		},
		{
			MethodName: "SetReadOnly",
			Handler:    _TabletManager_SetReadOnly_Handler,
		},
		{
			MethodName: "SetReadWrite",
			Handler:    _TabletManager_SetReadWrite_Handler,
		},
		{
			MethodName: "ChangeType",
			Handler:    _TabletManager_ChangeType_Handler,
		},
		{
			MethodName: "RefreshState",
			Handler:    _TabletManager_RefreshState_Handler,
		},
		{
			MethodName: "RunHealthCheck",
			Handler:    _TabletManager_RunHealthCheck_Handler,
		},
		{
			MethodName: "IgnoreHealthError",
			Handler:    _TabletManager_IgnoreHealthError_Handler,
		},
		{
			MethodName: "ReloadSchema",
			Handler:    _TabletManager_ReloadSchema_Handler,
		},
		{
			MethodName: "PreflightSchema",
			Handler:    _TabletManager_PreflightSchema_Handler,
		},
		{
			MethodName: "ApplySchema",
			Handler:    _TabletManager_ApplySchema_Handler,
		},
		{
			MethodName: "ExecuteFetchAsDba",
			Handler:    _TabletManager_ExecuteFetchAsDba_Handler,
		},
		{
			MethodName: "ExecuteFetchAsAllPrivs",
			Handler:    _TabletManager_ExecuteFetchAsAllPrivs_Handler,
		},
		{
			MethodName: "ExecuteFetchAsApp",
			Handler:    _TabletManager_ExecuteFetchAsApp_Handler,
		},
		{
			MethodName: "SlaveStatus",
			Handler:    _TabletManager_SlaveStatus_Handler,
		},
		{
			MethodName: "MasterPosition",
			Handler:    _TabletManager_MasterPosition_Handler,
		},
		{
			MethodName: "StopSlave",
			Handler:    _TabletManager_StopSlave_Handler,
		},
		{
			MethodName: "StopSlaveMinimum",
			Handler:    _TabletManager_StopSlaveMinimum_Handler,
		},
		{
			MethodName: "StartSlave",
			Handler:    _TabletManager_StartSlave_Handler,
		},
		{
			MethodName: "TabletExternallyReparented",
			Handler:    _TabletManager_TabletExternallyReparented_Handler,
		},
		{
			MethodName: "TabletExternallyElected",
			Handler:    _TabletManager_TabletExternallyElected_Handler,
		},
		{
			MethodName: "GetSlaves",
			Handler:    _TabletManager_GetSlaves_Handler,
		},
		{
			MethodName: "WaitBlpPosition",
			Handler:    _TabletManager_WaitBlpPosition_Handler,
		},
		{
			MethodName: "StopBlp",
			Handler:    _TabletManager_StopBlp_Handler,
		},
		{
			MethodName: "StartBlp",
			Handler:    _TabletManager_StartBlp_Handler,
		},
		{
			MethodName: "RunBlpUntil",
			Handler:    _TabletManager_RunBlpUntil_Handler,
		},
		{
			MethodName: "ResetReplication",
			Handler:    _TabletManager_ResetReplication_Handler,
		},
		{
			MethodName: "InitMaster",
			Handler:    _TabletManager_InitMaster_Handler,
		},
		{
			MethodName: "PopulateReparentJournal",
			Handler:    _TabletManager_PopulateReparentJournal_Handler,
		},
		{
			MethodName: "InitSlave",
			Handler:    _TabletManager_InitSlave_Handler,
		},
		{
			MethodName: "DemoteMaster",
			Handler:    _TabletManager_DemoteMaster_Handler,
		},
		{
			MethodName: "PromoteSlaveWhenCaughtUp",
			Handler:    _TabletManager_PromoteSlaveWhenCaughtUp_Handler,
		},
		{
			MethodName: "SlaveWasPromoted",
			Handler:    _TabletManager_SlaveWasPromoted_Handler,
		},
		{
			MethodName: "SetMaster",
			Handler:    _TabletManager_SetMaster_Handler,
		},
		{
			MethodName: "SlaveWasRestarted",
			Handler:    _TabletManager_SlaveWasRestarted_Handler,
		},
		{
			MethodName: "StopReplicationAndGetStatus",
			Handler:    _TabletManager_StopReplicationAndGetStatus_Handler,
		},
		{
			MethodName: "PromoteSlave",
			Handler:    _TabletManager_PromoteSlave_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Backup",
			Handler:       _TabletManager_Backup_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RestoreFromBackup",
			Handler:       _TabletManager_RestoreFromBackup_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "tabletmanagerservice.proto",
}

func init() { proto.RegisterFile("tabletmanagerservice.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 969 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x98, 0x6d, 0x6f, 0x1c, 0x35,
	0x10, 0xc7, 0x39, 0x09, 0x0a, 0x98, 0xc7, 0x5a, 0x88, 0xa2, 0x20, 0x01, 0x4d, 0x5a, 0x1e, 0x52,
	0x54, 0xf5, 0x81, 0xf2, 0xfe, 0x2e, 0xbd, 0xb6, 0x41, 0x44, 0x1c, 0x77, 0x8d, 0x82, 0x84, 0x84,
	0xe4, 0xec, 0x4d, 0x6f, 0x97, 0x78, 0x6d, 0x63, 0x7b, 0xa3, 0xe4, 0x15, 0x12, 0x12, 0xaf, 0x90,
	0xf8, 0x04, 0x7c, 0x58, 0xb4, 0x0f, 0xf6, 0x8d, 0xef, 0xbc, 0xbe, 0xbb, 0xb7, 0xf9, 0xff, 0x66,
	0xc6, 0x3b, 0x9e, 0x19, 0xcf, 0x85, 0xec, 0x59, 0x76, 0xce, 0xc1, 0x96, 0x4c, 0xb0, 0x05, 0x68,
	0x03, 0xfa, 0xb2, 0xc8, 0xe0, 0xbe, 0xd2, 0xd2, 0x4a, 0xfa, 0x51, 0x4c, 0xdb, 0xbb, 0x15, 0xfc,
	0x75, 0xce, 0x2c, 0x6b, 0xf1, 0x47, 0xff, 0xed, 0x93, 0xf7, 0x5e, 0x36, 0xda, 0x49, 0xab, 0xd1,
	0x63, 0xf2, 0xfa, 0xa4, 0x10, 0x0b, 0xfa, 0xd9, 0xfd, 0x75, 0x9b, 0x5a, 0x98, 0xc2, 0x1f, 0x15,
	0x18, 0xbb, 0xf7, 0x79, 0xaf, 0x6e, 0x94, 0x14, 0x06, 0xf6, 0x5f, 0xa3, 0x3f, 0x92, 0x37, 0x66,
	0x1c, 0x40, 0xd1, 0x18, 0xdb, 0x28, 0xce, 0xd9, 0x17, 0xfd, 0x80, 0xf7, 0xf6, 0x1b, 0x79, 0x67,
	0x7c, 0x05, 0x59, 0x65, 0xe1, 0x85, 0x94, 0x17, 0xf4, 0x6e, 0xc4, 0x04, 0xe9, 0xce, 0xf3, 0x97,
	0x9b, 0x30, 0xef, 0xff, 0x17, 0xf2, 0xf6, 0x73, 0xb0, 0xb3, 0x2c, 0x87, 0x92, 0xd1, 0x83, 0x88,
	0x99, 0x57, 0x9d, 0xef, 0x3b, 0x69, 0xc8, 0x7b, 0x5e, 0x90, 0xf7, 0x9f, 0x83, 0x9d, 0x80, 0x2e,
	0x0b, 0x63, 0x0a, 0x29, 0x0c, 0xfd, 0x3a, 0x6e, 0x89, 0x10, 0x17, 0xe3, 0x9b, 0x2d, 0x48, 0x9c,
	0xa2, 0x19, 0xd8, 0x29, 0xb0, 0xf9, 0x4f, 0x82, 0x5f, 0x47, 0x53, 0x84, 0xf4, 0x54, 0x8a, 0x02,
	0xcc, 0xfb, 0x67, 0xe4, 0xdd, 0x4e, 0x38, 0xd3, 0x85, 0x05, 0x9a, 0xb0, 0x6c, 0x00, 0x17, 0xe1,
	0xab, 0x8d, 0x9c, 0x0f, 0xf1, 0x2b, 0x21, 0x47, 0x39, 0x13, 0x0b, 0x78, 0x79, 0xad, 0x80, 0xc6,
	0x32, 0xbc, 0x94, 0x9d, 0xfb, 0xbb, 0x1b, 0x28, 0x7c, 0xfe, 0x29, 0xbc, 0xd2, 0x60, 0xf2, 0x99,
	0x65, 0x3d, 0xe7, 0xc7, 0x40, 0xea, 0xfc, 0x21, 0x87, 0xef, 0x7a, 0x5a, 0x89, 0x17, 0xc0, 0xb8,
	0xcd, 0x8f, 0x72, 0xc8, 0x2e, 0xa2, 0x77, 0x1d, 0x22, 0xa9, 0xbb, 0x5e, 0x25, 0x7d, 0x20, 0x45,
	0x6e, 0x1e, 0x2f, 0x84, 0xd4, 0xd0, 0xca, 0x63, 0xad, 0xa5, 0xa6, 0xf7, 0x22, 0x1e, 0xd6, 0x28,
	0x17, 0xee, 0xdb, 0xed, 0xe0, 0x30, 0x7b, 0x5c, 0xb2, 0x79, 0xd7, 0x23, 0xf1, 0xec, 0x2d, 0x81,
	0x74, 0xf6, 0x30, 0xe7, 0x43, 0xfc, 0x4e, 0x3e, 0x98, 0x68, 0x78, 0xc5, 0x8b, 0x45, 0xee, 0x3a,
	0x31, 0x96, 0x94, 0x15, 0xc6, 0x05, 0x3a, 0xdc, 0x06, 0xc5, 0xcd, 0x32, 0x54, 0x8a, 0x5f, 0x77,
	0x71, 0x62, 0x45, 0x84, 0xf4, 0x54, 0xb3, 0x04, 0x18, 0xbe, 0xa0, 0x6e, 0xd0, 0x3c, 0x03, 0x9b,
	0xe5, 0x43, 0xf3, 0xf4, 0x9c, 0x45, 0x2f, 0x68, 0x8d, 0x4a, 0x5d, 0x50, 0x04, 0xf6, 0x11, 0xff,
	0x24, 0x1f, 0x87, 0xf2, 0x90, 0xf3, 0x89, 0x2e, 0x2e, 0x0d, 0x7d, 0xb0, 0xd1, 0x93, 0x43, 0x5d,
	0xec, 0x87, 0x3b, 0x58, 0xf4, 0x7f, 0xf2, 0x50, 0xa9, 0x2d, 0x3e, 0x79, 0xa8, 0xd4, 0xf6, 0x9f,
	0xdc, 0xc0, 0xc1, 0xc4, 0xe3, 0xec, 0x12, 0xea, 0x36, 0xac, 0x4c, 0x7c, 0xe2, 0x2d, 0xf5, 0xe4,
	0xc4, 0xc3, 0x18, 0x6e, 0xe7, 0x13, 0x66, 0x2c, 0xe8, 0x89, 0x34, 0x85, 0x2d, 0xa4, 0x88, 0xb6,
	0x73, 0x88, 0xa4, 0xda, 0x79, 0x95, 0xc4, 0xaf, 0xcf, 0xcc, 0x4a, 0xd5, 0x9c, 0x22, 0xfa, 0xfa,
	0x78, 0x35, 0xf5, 0xfa, 0x20, 0xc8, 0x7b, 0x2e, 0xc9, 0x87, 0xfe, 0xcf, 0x27, 0x85, 0x28, 0xca,
	0xaa, 0xa4, 0x87, 0x29, 0xdb, 0x0e, 0x72, 0x71, 0xee, 0x6d, 0xc5, 0xe2, 0x01, 0x3e, 0xb3, 0x4c,
	0xdb, 0xf6, 0x4b, 0xe2, 0x87, 0x74, 0x72, 0x6a, 0x80, 0x63, 0xca, 0x3b, 0xff, 0x67, 0x40, 0xf6,
	0xda, 0x75, 0x65, 0x7c, 0x65, 0x41, 0x0b, 0xc6, 0xeb, 0xf7, 0x49, 0x31, 0x0d, 0xc2, 0xc2, 0x9c,
	0x7e, 0x17, 0xf1, 0xd3, 0x8f, 0xbb, 0xe8, 0x4f, 0x76, 0xb4, 0xf2, 0xa7, 0xf9, 0x6b, 0x40, 0x6e,
	0xad, 0x82, 0x63, 0x0e, 0x59, 0x7d, 0x94, 0x87, 0x5b, 0x38, 0xed, 0x58, 0x77, 0x8e, 0x47, 0xbb,
	0x98, 0xac, 0xae, 0x2d, 0x75, 0xa2, 0x4c, 0xef, 0xda, 0xd2, 0xa8, 0x9b, 0xd6, 0x96, 0x0e, 0xc2,
	0xc3, 0xf8, 0x8c, 0x15, 0x76, 0xc4, 0x95, 0x2f, 0xfe, 0x58, 0x49, 0xaf, 0x30, 0xa9, 0x61, 0xbc,
	0x86, 0xfa, 0x58, 0x53, 0xf2, 0x66, 0x5d, 0x53, 0x23, 0xae, 0xe8, 0xed, 0x9e, 0x7a, 0x1b, 0x71,
	0x3f, 0x25, 0xf6, 0x53, 0x88, 0xf7, 0x79, 0x4a, 0xde, 0x6a, 0x8a, 0xa8, 0x76, 0xba, 0xdf, 0x57,
	0x61, 0xc8, 0xeb, 0x41, 0x92, 0xc1, 0x23, 0x67, 0x5a, 0x89, 0x11, 0x57, 0xa7, 0xc2, 0x16, 0x3c,
	0x3a, 0x72, 0x90, 0x9e, 0x1a, 0x39, 0x01, 0x86, 0xfb, 0x75, 0x0a, 0xa6, 0xde, 0x8e, 0x14, 0x2f,
	0x32, 0xd6, 0xe4, 0xfd, 0x30, 0xfa, 0x84, 0x86, 0x50, 0xaa, 0x5f, 0xd7, 0x59, 0xdc, 0xaf, 0xc7,
	0xa2, 0xb0, 0xed, 0x60, 0x8a, 0xf6, 0xeb, 0x52, 0x4e, 0xf5, 0x2b, 0xa6, 0x82, 0x0e, 0x99, 0x48,
	0x55, 0xf1, 0x66, 0x49, 0x6a, 0x5b, 0xe8, 0x07, 0x59, 0xd5, 0xb5, 0x1c, 0xed, 0x90, 0x1e, 0x36,
	0xd5, 0x21, 0xbd, 0x26, 0xb8, 0x43, 0xea, 0xc3, 0xf5, 0x8f, 0x56, 0xaf, 0xa6, 0x3a, 0x04, 0x41,
	0x78, 0x23, 0x7a, 0x0a, 0xa5, 0xb4, 0xd0, 0x65, 0x2f, 0x76, 0xc9, 0x18, 0x48, 0x6d, 0x44, 0x21,
	0xe7, 0x43, 0xfc, 0x3d, 0x20, 0x9f, 0x4c, 0xb4, 0xac, 0xb5, 0x26, 0xfa, 0x59, 0x0e, 0xe2, 0x88,
	0x55, 0x8b, 0xdc, 0x9e, 0x2a, 0x1a, 0xcd, 0x47, 0x0f, 0xec, 0x62, 0x3f, 0xde, 0xc9, 0x26, 0x78,
	0x45, 0x1a, 0x99, 0x99, 0x8e, 0x9e, 0xc7, 0x5f, 0x91, 0x15, 0x28, 0xf9, 0x8a, 0xac, 0xb1, 0xc1,
	0x73, 0x08, 0xae, 0x28, 0x0f, 0xe2, 0x3f, 0x1f, 0xc2, 0x9c, 0xde, 0x49, 0x43, 0x78, 0x47, 0x71,
	0x71, 0xa7, 0x60, 0xea, 0xf6, 0x86, 0x39, 0x4d, 0x9d, 0xce, 0x53, 0xa9, 0x1d, 0x25, 0x02, 0xfb,
	0x88, 0xff, 0x0e, 0xc8, 0xa7, 0xf5, 0x74, 0x42, 0xfd, 0x37, 0x14, 0xf3, 0x7a, 0xe2, 0xb6, 0x4b,
	0xcb, 0x93, 0x9e, 0x69, 0xd6, 0xc3, 0xbb, 0x63, 0x7c, 0xbf, 0xab, 0x19, 0x2e, 0x5b, 0x7c, 0xe3,
	0xd1, 0xb2, 0xc5, 0x40, 0xaa, 0x6c, 0x43, 0xce, 0x87, 0xf8, 0x99, 0xdc, 0x18, 0xb1, 0xec, 0xa2,
	0x52, 0x34, 0xf6, 0xd3, 0xbe, 0x95, 0x9c, 0xdb, 0xdb, 0x09, 0xc2, 0x39, 0x7c, 0x30, 0xa0, 0x9a,
	0xdc, 0xac, 0xb3, 0x2b, 0x35, 0x3c, 0xd3, 0xb2, 0xec, 0xbc, 0xf7, 0x0c, 0xbb, 0x90, 0x4a, 0x5d,
	0x5c, 0x04, 0x5e, 0xc6, 0x3c, 0xbf, 0xd1, 0xfc, 0x97, 0xe4, 0xf1, 0xff, 0x01, 0x00, 0x00, 0xff,
	0xff, 0xa7, 0xa6, 0x78, 0xaf, 0x72, 0x11, 0x00, 0x00,
}
