// Code generated by protoc-gen-go.
// source: workflow.proto
// DO NOT EDIT!

/*
Package workflow is a generated protocol buffer package.

It is generated from these files:
	workflow.proto

It has these top-level messages:
	Workflow
	WorkflowCheckpoint
	Task
*/
package workflow

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// WorkflowState describes the state of a workflow.
// This constant should match the Node object described in
// web/vtctld2/src/app/workflows/node.ts as it is exposed as JSON to
// the Angular 2 web app.
type WorkflowState int32

const (
	WorkflowState_NotStarted WorkflowState = 0
	WorkflowState_Running    WorkflowState = 1
	WorkflowState_Done       WorkflowState = 2
)

var WorkflowState_name = map[int32]string{
	0: "NotStarted",
	1: "Running",
	2: "Done",
}
var WorkflowState_value = map[string]int32{
	"NotStarted": 0,
	"Running":    1,
	"Done":       2,
}

func (x WorkflowState) String() string {
	return proto.EnumName(WorkflowState_name, int32(x))
}
func (WorkflowState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type TaskState int32

const (
	TaskState_TaskNotStarted TaskState = 0
	TaskState_TaskRunning    TaskState = 1
	TaskState_TaskDone       TaskState = 2
)

var TaskState_name = map[int32]string{
	0: "TaskNotStarted",
	1: "TaskRunning",
	2: "TaskDone",
}
var TaskState_value = map[string]int32{
	"TaskNotStarted": 0,
	"TaskRunning":    1,
	"TaskDone":       2,
}

func (x TaskState) String() string {
	return proto.EnumName(TaskState_name, int32(x))
}
func (TaskState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Workflow is the persisted state of a long-running workflow.
type Workflow struct {
	// uuid is set when the workflow is created, and immutable after
	// that.
	Uuid string `protobuf:"bytes,1,opt,name=uuid" json:"uuid,omitempty"`
	// factory_name is set with the name of the factory that created the
	// job (and can also restart it). It is set at creation time, and
	// immutable after that.
	FactoryName string `protobuf:"bytes,2,opt,name=factory_name,json=factoryName" json:"factory_name,omitempty"`
	// name is the display name of the workflow.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// state describes the state of the job. A job is created as
	// NotStarted, then the Workflow Manager picks it up and starts it,
	// switching it to Running (and populating 'start_time').  The
	// workflow can then fail over to a new Workflow Manager is
	// necessary, and still be in Running state.  When done, it goes to
	// Done, 'end_time' is populated, and 'error' is set if there was an
	// error.
	State WorkflowState `protobuf:"varint,4,opt,name=state,enum=workflow.WorkflowState" json:"state,omitempty"`
	// data is workflow-specific stored data. It is usually a binary
	// proto-encoded data structure. It can vary throughout the
	// execution of the workflow.  It will not change after the workflow
	// is Done.
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// error is set if the job finished with an error. This field only
	// makes sense if 'state' is Done.
	Error string `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
	// start_time is set when the workflow manager starts a workflow for
	// the first time. This field only makes sense if 'state' is Running
	// or Done.
	StartTime int64 `protobuf:"varint,7,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// end_time is set when the workflow is finished.
	// This field only makes sense if 'state' is Done.
	EndTime int64 `protobuf:"varint,8,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
}

func (m *Workflow) Reset()                    { *m = Workflow{} }
func (m *Workflow) String() string            { return proto.CompactTextString(m) }
func (*Workflow) ProtoMessage()               {}
func (*Workflow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Workflow) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *Workflow) GetFactoryName() string {
	if m != nil {
		return m.FactoryName
	}
	return ""
}

func (m *Workflow) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Workflow) GetState() WorkflowState {
	if m != nil {
		return m.State
	}
	return WorkflowState_NotStarted
}

func (m *Workflow) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Workflow) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Workflow) GetStartTime() int64 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *Workflow) GetEndTime() int64 {
	if m != nil {
		return m.EndTime
	}
	return 0
}

type WorkflowCheckpoint struct {
	// code_version is used to detect incompabilities between the version of the
	// running workflow and the one which wrote the checkpoint. If they don't
	// match, the workflow must not continue. The author of workflow must update
	// this variable in their implementation when incompabilities are introduced.
	CodeVersion int32 `protobuf:"varint,1,opt,name=code_version,json=codeVersion" json:"code_version,omitempty"`
	// Task is the data structure that stores the execution status and the
	// attributes of a task.
	Tasks map[string]*Task `protobuf:"bytes,2,rep,name=tasks" json:"tasks,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// settings includes workflow specific data, e.g. the resharding workflow
	// would store the source shards and destination shards.
	Settings map[string]string `protobuf:"bytes,3,rep,name=settings" json:"settings,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *WorkflowCheckpoint) Reset()                    { *m = WorkflowCheckpoint{} }
func (m *WorkflowCheckpoint) String() string            { return proto.CompactTextString(m) }
func (*WorkflowCheckpoint) ProtoMessage()               {}
func (*WorkflowCheckpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *WorkflowCheckpoint) GetCodeVersion() int32 {
	if m != nil {
		return m.CodeVersion
	}
	return 0
}

func (m *WorkflowCheckpoint) GetTasks() map[string]*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *WorkflowCheckpoint) GetSettings() map[string]string {
	if m != nil {
		return m.Settings
	}
	return nil
}

type Task struct {
	Id    string    `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	State TaskState `protobuf:"varint,2,opt,name=state,enum=workflow.TaskState" json:"state,omitempty"`
	// attributes includes the parameters the task needs.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Error      string            `protobuf:"bytes,4,opt,name=error" json:"error,omitempty"`
}

func (m *Task) Reset()                    { *m = Task{} }
func (m *Task) String() string            { return proto.CompactTextString(m) }
func (*Task) ProtoMessage()               {}
func (*Task) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Task) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Task) GetState() TaskState {
	if m != nil {
		return m.State
	}
	return TaskState_TaskNotStarted
}

func (m *Task) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Task) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func init() {
	proto.RegisterType((*Workflow)(nil), "workflow.Workflow")
	proto.RegisterType((*WorkflowCheckpoint)(nil), "workflow.WorkflowCheckpoint")
	proto.RegisterType((*Task)(nil), "workflow.Task")
	proto.RegisterEnum("workflow.WorkflowState", WorkflowState_name, WorkflowState_value)
	proto.RegisterEnum("workflow.TaskState", TaskState_name, TaskState_value)
}

func init() { proto.RegisterFile("workflow.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 477 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xdb, 0x6e, 0xd3, 0x40,
	0x10, 0x65, 0x7d, 0x69, 0x9c, 0x71, 0xea, 0x46, 0x43, 0x25, 0x4c, 0x24, 0x90, 0x89, 0x90, 0x30,
	0x91, 0xc8, 0x43, 0x90, 0x10, 0x02, 0xb5, 0x12, 0xe2, 0x22, 0x9e, 0xfa, 0xe0, 0x54, 0xf0, 0x18,
	0x6d, 0xe3, 0x6d, 0x59, 0xa5, 0xd9, 0xad, 0xd6, 0xeb, 0x56, 0xf9, 0x40, 0x7e, 0x81, 0x6f, 0xe0,
	0x33, 0xd0, 0xee, 0xc6, 0x4e, 0x0c, 0x08, 0x89, 0xb7, 0x99, 0x39, 0x73, 0xce, 0x78, 0xf6, 0x8c,
	0x21, 0xb9, 0x93, 0x6a, 0x75, 0x79, 0x2d, 0xef, 0xa6, 0x37, 0x4a, 0x6a, 0x89, 0x51, 0x93, 0x8f,
	0x7f, 0x12, 0x88, 0xbe, 0x6e, 0x13, 0x44, 0x08, 0xea, 0x9a, 0x97, 0x29, 0xc9, 0x48, 0xde, 0x2f,
	0x6c, 0x8c, 0x4f, 0x60, 0x70, 0x49, 0x97, 0x5a, 0xaa, 0xcd, 0x42, 0xd0, 0x35, 0x4b, 0x3d, 0x8b,
	0xc5, 0xdb, 0xda, 0x19, 0x5d, 0x33, 0x43, 0xb3, 0x90, 0xef, 0x68, 0x26, 0xc6, 0x17, 0x10, 0x56,
	0x9a, 0x6a, 0x96, 0x06, 0x19, 0xc9, 0x93, 0xd9, 0x83, 0x69, 0xfb, 0x05, 0xcd, 0xb4, 0xb9, 0x81,
	0x0b, 0xd7, 0x65, 0x24, 0x4a, 0xaa, 0x69, 0x1a, 0x66, 0x24, 0x1f, 0x14, 0x36, 0xc6, 0x63, 0x08,
	0x99, 0x52, 0x52, 0xa5, 0x07, 0x56, 0xd7, 0x25, 0xf8, 0x08, 0xa0, 0xd2, 0x54, 0xe9, 0x85, 0xe6,
	0x6b, 0x96, 0xf6, 0x32, 0x92, 0xfb, 0x45, 0xdf, 0x56, 0xce, 0xf9, 0x9a, 0xe1, 0x43, 0x88, 0x98,
	0x28, 0x1d, 0x18, 0x59, 0xb0, 0xc7, 0x44, 0x69, 0xa0, 0xf1, 0x77, 0x0f, 0xb0, 0x19, 0xfe, 0xfe,
	0x1b, 0x5b, 0xae, 0x6e, 0x24, 0x17, 0xda, 0x2c, 0xb8, 0x94, 0x25, 0x5b, 0xdc, 0x32, 0x55, 0x71,
	0x29, 0xec, 0xf2, 0x61, 0x11, 0x9b, 0xda, 0x17, 0x57, 0xc2, 0x13, 0x08, 0x35, 0xad, 0x56, 0x55,
	0xea, 0x65, 0x7e, 0x1e, 0xcf, 0x9e, 0xfd, 0xb9, 0xcc, 0x4e, 0x6f, 0x7a, 0x6e, 0x3a, 0x3f, 0x0a,
	0xad, 0x36, 0x85, 0x63, 0xe1, 0x27, 0x88, 0x2a, 0xa6, 0x35, 0x17, 0x57, 0x55, 0xea, 0x5b, 0x85,
	0xc9, 0x3f, 0x15, 0xe6, 0xdb, 0x66, 0x27, 0xd2, 0x72, 0x47, 0x9f, 0x01, 0x76, 0xe2, 0x38, 0x04,
	0x7f, 0xc5, 0x36, 0x5b, 0xaf, 0x4c, 0x88, 0x4f, 0x21, 0xbc, 0xa5, 0xd7, 0xb5, 0xf3, 0x28, 0x9e,
	0x25, 0xbb, 0x21, 0x86, 0x56, 0x38, 0xf0, 0x8d, 0xf7, 0x9a, 0x8c, 0xde, 0xc2, 0x61, 0x67, 0xc8,
	0x5f, 0xc4, 0x8e, 0xf7, 0xc5, 0xfa, 0x7b, 0xe4, 0xf1, 0x0f, 0x02, 0x81, 0x11, 0xc4, 0x04, 0xbc,
	0xf6, 0x58, 0x3c, 0x5e, 0xe2, 0xf3, 0xc6, 0x73, 0xcf, 0x7a, 0x7e, 0xbf, 0x3b, 0xbf, 0xe3, 0xf7,
	0x29, 0x00, 0xd5, 0x5a, 0xf1, 0x8b, 0x5a, 0xb3, 0xe6, 0x51, 0x1e, 0x77, 0xfb, 0xa7, 0xef, 0xda,
	0x06, 0xf7, 0x10, 0x7b, 0x8c, 0xdd, 0x6d, 0x04, 0x7b, 0xb7, 0x31, 0x3a, 0x81, 0xa3, 0xdf, 0x48,
	0xff, 0xb3, 0xd8, 0xe4, 0x15, 0x1c, 0x76, 0x8e, 0x13, 0x13, 0x80, 0x33, 0xa9, 0xe7, 0xe6, 0xb8,
	0x58, 0x39, 0xbc, 0x87, 0x31, 0xf4, 0x8a, 0x5a, 0x08, 0x2e, 0xae, 0x86, 0x04, 0x23, 0x08, 0x3e,
	0x48, 0xc1, 0x86, 0xde, 0xe4, 0x14, 0xfa, 0xed, 0x82, 0x88, 0x90, 0x98, 0xa4, 0xc3, 0x3b, 0x82,
	0xd8, 0x3a, 0xd0, 0x72, 0x07, 0x10, 0x99, 0x82, 0xe3, 0x5f, 0x1c, 0xd8, 0x9f, 0xf2, 0xe5, 0xaf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x72, 0x5c, 0x6d, 0x7f, 0xa6, 0x03, 0x00, 0x00,
}
