//line ./go/vt/sqlparser/sql.y:6
package sqlparser

import __yyfmt__ "fmt"

//line ./go/vt/sqlparser/sql.y:6
func setParseTree(yylex interface{}, stmt Statement) {
	yylex.(*Tokenizer).ParseTree = stmt
}

func setAllowComments(yylex interface{}, allow bool) {
	yylex.(*Tokenizer).AllowComments = allow
}

func incNesting(yylex interface{}) bool {
	yylex.(*Tokenizer).nesting++
	if yylex.(*Tokenizer).nesting == 200 {
		return true
	}
	return false
}

func decNesting(yylex interface{}) {
	yylex.(*Tokenizer).nesting--
}

func forceEOF(yylex interface{}) {
	yylex.(*Tokenizer).ForceEOF = true
}

//line ./go/vt/sqlparser/sql.y:34
type yySymType struct {
	yys              int
	empty            struct{}
	statement        Statement
	selStmt          SelectStatement
	ins              *Insert
	byt              byte
	bytes            []byte
	bytes2           [][]byte
	str              string
	selectExprs      SelectExprs
	selectExpr       SelectExpr
	columns          Columns
	colName          *ColName
	tableExprs       TableExprs
	tableExpr        TableExpr
	tableName        *TableName
	indexHints       *IndexHints
	expr             Expr
	exprs            Exprs
	boolVal          BoolVal
	colTuple         ColTuple
	values           Values
	valTuple         ValTuple
	subquery         *Subquery
	whens            []*When
	when             *When
	orderBy          OrderBy
	order            *Order
	limit            *Limit
	updateExprs      UpdateExprs
	updateExpr       *UpdateExpr
	colIdent         ColIdent
	colIdents        []ColIdent
	tableIdent       TableIdent
	convertType      *ConvertType
	aliasedTableName *AliasedTableExpr
}

const LEX_ERROR = 57346
const UNION = 57347
const SELECT = 57348
const INSERT = 57349
const UPDATE = 57350
const DELETE = 57351
const FROM = 57352
const WHERE = 57353
const GROUP = 57354
const HAVING = 57355
const ORDER = 57356
const BY = 57357
const LIMIT = 57358
const OFFSET = 57359
const FOR = 57360
const ALL = 57361
const DISTINCT = 57362
const AS = 57363
const EXISTS = 57364
const ASC = 57365
const DESC = 57366
const INTO = 57367
const DUPLICATE = 57368
const KEY = 57369
const DEFAULT = 57370
const SET = 57371
const LOCK = 57372
const VALUES = 57373
const LAST_INSERT_ID = 57374
const NEXT = 57375
const VALUE = 57376
const SHARE = 57377
const MODE = 57378
const SQL_NO_CACHE = 57379
const SQL_CACHE = 57380
const JOIN = 57381
const STRAIGHT_JOIN = 57382
const LEFT = 57383
const RIGHT = 57384
const INNER = 57385
const OUTER = 57386
const CROSS = 57387
const NATURAL = 57388
const USE = 57389
const FORCE = 57390
const ON = 57391
const ID = 57392
const HEX = 57393
const STRING = 57394
const INTEGRAL = 57395
const FLOAT = 57396
const HEXNUM = 57397
const VALUE_ARG = 57398
const LIST_ARG = 57399
const COMMENT = 57400
const NULL = 57401
const TRUE = 57402
const FALSE = 57403
const OR = 57404
const AND = 57405
const NOT = 57406
const BETWEEN = 57407
const CASE = 57408
const WHEN = 57409
const THEN = 57410
const ELSE = 57411
const END = 57412
const LE = 57413
const GE = 57414
const NE = 57415
const NULL_SAFE_EQUAL = 57416
const IS = 57417
const LIKE = 57418
const REGEXP = 57419
const IN = 57420
const SHIFT_LEFT = 57421
const SHIFT_RIGHT = 57422
const DIV = 57423
const MOD = 57424
const UNARY = 57425
const COLLATE = 57426
const BINARY = 57427
const INTERVAL = 57428
const JSON_EXTRACT_OP = 57429
const JSON_UNQUOTE_EXTRACT_OP = 57430
const CREATE = 57431
const ALTER = 57432
const DROP = 57433
const RENAME = 57434
const ANALYZE = 57435
const TABLE = 57436
const INDEX = 57437
const VIEW = 57438
const TO = 57439
const IGNORE = 57440
const IF = 57441
const UNIQUE = 57442
const USING = 57443
const SHOW = 57444
const DESCRIBE = 57445
const EXPLAIN = 57446
const DATE = 57447
const ESCAPE = 57448
const REPAIR = 57449
const OPTIMIZE = 57450
const TRUNCATE = 57451
const DATABASES = 57452
const TABLES = 57453
const VITESS_KEYSPACES = 57454
const VITESS_SHARDS = 57455
const VSCHEMA_TABLES = 57456
const INTEGER = 57457
const CHARACTER = 57458
const CURRENT_TIMESTAMP = 57459
const DATABASE = 57460
const CURRENT_DATE = 57461
const CURRENT_TIME = 57462
const LOCALTIME = 57463
const LOCALTIMESTAMP = 57464
const UTC_DATE = 57465
const UTC_TIME = 57466
const UTC_TIMESTAMP = 57467
const REPLACE = 57468
const CONVERT = 57469
const CAST = 57470
const GROUP_CONCAT = 57471
const SEPARATOR = 57472
const MATCH = 57473
const AGAINST = 57474
const BOOLEAN = 57475
const LANGUAGE = 57476
const WITH = 57477
const QUERY = 57478
const EXPANSION = 57479
const UNUSED = 57480

var yyToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"LEX_ERROR",
	"UNION",
	"SELECT",
	"INSERT",
	"UPDATE",
	"DELETE",
	"FROM",
	"WHERE",
	"GROUP",
	"HAVING",
	"ORDER",
	"BY",
	"LIMIT",
	"OFFSET",
	"FOR",
	"ALL",
	"DISTINCT",
	"AS",
	"EXISTS",
	"ASC",
	"DESC",
	"INTO",
	"DUPLICATE",
	"KEY",
	"DEFAULT",
	"SET",
	"LOCK",
	"VALUES",
	"LAST_INSERT_ID",
	"NEXT",
	"VALUE",
	"SHARE",
	"MODE",
	"SQL_NO_CACHE",
	"SQL_CACHE",
	"JOIN",
	"STRAIGHT_JOIN",
	"LEFT",
	"RIGHT",
	"INNER",
	"OUTER",
	"CROSS",
	"NATURAL",
	"USE",
	"FORCE",
	"ON",
	"'('",
	"','",
	"')'",
	"ID",
	"HEX",
	"STRING",
	"INTEGRAL",
	"FLOAT",
	"HEXNUM",
	"VALUE_ARG",
	"LIST_ARG",
	"COMMENT",
	"NULL",
	"TRUE",
	"FALSE",
	"OR",
	"AND",
	"NOT",
	"'!'",
	"BETWEEN",
	"CASE",
	"WHEN",
	"THEN",
	"ELSE",
	"END",
	"'='",
	"'<'",
	"'>'",
	"LE",
	"GE",
	"NE",
	"NULL_SAFE_EQUAL",
	"IS",
	"LIKE",
	"REGEXP",
	"IN",
	"'|'",
	"'&'",
	"SHIFT_LEFT",
	"SHIFT_RIGHT",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"DIV",
	"'%'",
	"MOD",
	"'^'",
	"'~'",
	"UNARY",
	"COLLATE",
	"BINARY",
	"INTERVAL",
	"'.'",
	"JSON_EXTRACT_OP",
	"JSON_UNQUOTE_EXTRACT_OP",
	"CREATE",
	"ALTER",
	"DROP",
	"RENAME",
	"ANALYZE",
	"TABLE",
	"INDEX",
	"VIEW",
	"TO",
	"IGNORE",
	"IF",
	"UNIQUE",
	"USING",
	"SHOW",
	"DESCRIBE",
	"EXPLAIN",
	"DATE",
	"ESCAPE",
	"REPAIR",
	"OPTIMIZE",
	"TRUNCATE",
	"DATABASES",
	"TABLES",
	"VITESS_KEYSPACES",
	"VITESS_SHARDS",
	"VSCHEMA_TABLES",
	"INTEGER",
	"CHARACTER",
	"CURRENT_TIMESTAMP",
	"DATABASE",
	"CURRENT_DATE",
	"CURRENT_TIME",
	"LOCALTIME",
	"LOCALTIMESTAMP",
	"UTC_DATE",
	"UTC_TIME",
	"UTC_TIMESTAMP",
	"REPLACE",
	"CONVERT",
	"CAST",
	"GROUP_CONCAT",
	"SEPARATOR",
	"MATCH",
	"AGAINST",
	"BOOLEAN",
	"LANGUAGE",
	"WITH",
	"QUERY",
	"EXPANSION",
	"UNUSED",
	"';'",
}
var yyStatenames = [...]string{}

const yyEofCode = 1
const yyErrCode = 2
const yyInitialStackSize = 16

//line yacctab:1
var yyExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
	-1, 3,
	5, 20,
	-2, 4,
	-1, 203,
	103, 325,
	-2, 321,
	-1, 204,
	103, 326,
	-2, 322,
	-1, 405,
	5, 20,
	-2, 276,
	-1, 423,
	103, 328,
	-2, 324,
	-1, 568,
	5, 21,
	-2, 159,
	-1, 592,
	5, 21,
	-2, 277,
	-1, 635,
	5, 20,
	-2, 279,
	-1, 708,
	5, 21,
	-2, 280,
}

const yyPrivate = 57344

const yyLast = 3757

var yyAct = [...]int{

	219, 627, 364, 522, 616, 204, 231, 198, 663, 489,
	626, 306, 615, 640, 674, 523, 484, 561, 487, 554,
	255, 304, 417, 363, 3, 453, 519, 503, 54, 178,
	308, 422, 221, 81, 278, 284, 228, 172, 199, 36,
	230, 233, 292, 187, 37, 434, 741, 736, 740, 729,
	196, 739, 41, 200, 735, 196, 728, 177, 80, 432,
	619, 657, 209, 427, 477, 214, 478, 173, 174, 175,
	176, 43, 44, 45, 46, 543, 477, 196, 478, 196,
	206, 545, 376, 196, 437, 72, 312, 486, 715, 332,
	331, 341, 342, 334, 335, 336, 337, 338, 339, 340,
	333, 309, 34, 343, 532, 477, 227, 478, 410, 412,
	531, 571, 479, 71, 530, 72, 218, 74, 75, 76,
	207, 353, 354, 210, 479, 320, 319, 17, 18, 19,
	20, 77, 73, 480, 318, 679, 646, 595, 431, 433,
	430, 565, 321, 62, 724, 480, 535, 562, 362, 300,
	21, 296, 57, 479, 333, 716, 343, 343, 321, 299,
	727, 66, 61, 621, 504, 302, 544, 319, 542, 286,
	725, 34, 213, 685, 480, 435, 411, 303, 572, 53,
	460, 564, 215, 321, 649, 652, 436, 320, 319, 224,
	279, 320, 319, 689, 458, 459, 457, 196, 504, 196,
	578, 220, 34, 196, 321, 712, 220, 281, 321, 661,
	220, 196, 456, 17, 54, 493, 196, 54, 34, 196,
	323, 298, 196, 547, 548, 549, 280, 22, 23, 25,
	24, 26, 590, 311, 681, 220, 324, 282, 634, 171,
	27, 28, 29, 573, 661, 30, 31, 32, 56, 216,
	65, 63, 67, 559, 322, 559, 220, 34, 59, 336,
	337, 338, 339, 340, 333, 587, 365, 343, 320, 319,
	520, 351, 298, 374, 389, 55, 719, 60, 69, 64,
	58, 68, 394, 320, 319, 321, 536, 320, 319, 54,
	623, 445, 447, 448, 196, 418, 446, 200, 408, 196,
	321, 520, 196, 38, 321, 200, 559, 54, 315, 420,
	393, 405, 421, 594, 220, 196, 391, 392, 196, 493,
	220, 196, 54, 424, 722, 17, 395, 416, 414, 442,
	443, 423, 449, 450, 701, 298, 413, 419, 440, 702,
	559, 355, 356, 357, 358, 359, 360, 454, 476, 378,
	379, 380, 381, 382, 383, 384, 184, 629, 320, 319,
	401, 70, 451, 721, 492, 494, 54, 699, 455, 34,
	698, 697, 700, 738, 491, 321, 365, 734, 506, 498,
	499, 54, 334, 335, 336, 337, 338, 339, 340, 333,
	495, 546, 343, 423, 481, 482, 441, 188, 189, 279,
	34, 517, 192, 508, 703, 191, 669, 670, 501, 285,
	200, 521, 54, 247, 246, 248, 249, 250, 251, 516,
	15, 252, 283, 732, 511, 524, 512, 686, 534, 290,
	526, 529, 452, 54, 54, 461, 462, 463, 464, 465,
	466, 467, 468, 469, 470, 471, 472, 473, 474, 475,
	538, 222, 632, 588, 425, 496, 497, 314, 673, 500,
	182, 17, 533, 223, 185, 186, 285, 539, 179, 515,
	660, 692, 180, 507, 38, 509, 510, 514, 454, 691,
	418, 256, 33, 550, 403, 557, 404, 197, 518, 676,
	317, 40, 42, 35, 1, 54, 568, 569, 570, 455,
	78, 574, 672, 567, 291, 34, 580, 560, 581, 582,
	583, 584, 426, 48, 579, 33, 541, 540, 429, 196,
	205, 183, 513, 527, 390, 277, 591, 592, 593, 690,
	577, 659, 576, 373, 502, 365, 232, 444, 243, 240,
	242, 54, 196, 241, 396, 402, 196, 601, 589, 341,
	342, 334, 335, 336, 337, 338, 339, 340, 333, 609,
	325, 343, 225, 600, 409, 551, 552, 553, 54, 287,
	664, 605, 662, 558, 596, 628, 253, 491, 610, 604,
	611, 586, 656, 614, 714, 617, 618, 400, 622, 575,
	39, 190, 14, 196, 13, 12, 423, 613, 11, 52,
	54, 54, 625, 54, 54, 54, 633, 10, 54, 624,
	9, 524, 642, 643, 8, 647, 648, 635, 653, 654,
	620, 651, 7, 201, 644, 6, 639, 5, 4, 630,
	181, 16, 2, 658, 0, 0, 0, 196, 677, 0,
	0, 680, 0, 682, 683, 0, 0, 254, 0, 0,
	0, 0, 54, 0, 0, 524, 0, 688, 601, 0,
	678, 0, 607, 608, 694, 33, 696, 196, 196, 196,
	196, 0, 693, 630, 695, 706, 0, 0, 196, 708,
	704, 196, 0, 200, 707, 54, 711, 54, 0, 0,
	305, 713, 194, 305, 202, 718, 0, 194, 0, 495,
	0, 717, 365, 630, 630, 630, 630, 0, 0, 0,
	0, 352, 0, 645, 0, 726, 723, 630, 0, 194,
	0, 194, 0, 0, 0, 194, 733, 0, 0, 730,
	731, 0, 0, 0, 0, 361, 193, 737, 366, 367,
	368, 369, 370, 371, 372, 0, 375, 377, 377, 377,
	377, 377, 377, 377, 377, 385, 386, 387, 388, 0,
	0, 0, 687, 0, 0, 0, 0, 0, 0, 406,
	332, 331, 341, 342, 334, 335, 336, 337, 338, 339,
	340, 333, 0, 305, 343, 307, 208, 62, 307, 0,
	0, 0, 0, 0, 0, 0, 57, 0, 305, 0,
	0, 0, 0, 0, 0, 66, 61, 555, 211, 0,
	212, 0, 0, 0, 217, 665, 668, 669, 670, 666,
	0, 667, 671, 53, 0, 720, 665, 668, 669, 670,
	666, 0, 667, 671, 33, 50, 0, 0, 0, 194,
	0, 294, 0, 0, 0, 194, 0, 0, 366, 0,
	0, 0, 0, 194, 0, 0, 0, 0, 194, 0,
	397, 194, 0, 0, 194, 0, 0, 201, 0, 0,
	0, 0, 0, 0, 0, 201, 0, 307, 307, 0,
	0, 47, 0, 49, 0, 0, 525, 51, 33, 0,
	0, 0, 56, 307, 65, 63, 67, 0, 0, 0,
	0, 0, 59, 0, 0, 0, 0, 0, 0, 0,
	305, 0, 0, 0, 0, 0, 0, 0, 0, 55,
	0, 60, 69, 64, 58, 68, 0, 0, 289, 0,
	0, 0, 0, 0, 297, 0, 194, 483, 202, 307,
	0, 294, 301, 0, 415, 0, 202, 310, 415, 0,
	313, 0, 505, 316, 0, 0, 0, 194, 0, 0,
	194, 0, 0, 194, 606, 0, 0, 0, 0, 0,
	0, 0, 0, 566, 0, 0, 0, 0, 0, 0,
	201, 0, 0, 528, 332, 331, 341, 342, 334, 335,
	336, 337, 338, 339, 340, 333, 0, 0, 343, 0,
	0, 0, 0, 0, 537, 307, 0, 0, 0, 490,
	415, 0, 597, 598, 599, 490, 490, 0, 0, 490,
	0, 0, 0, 0, 0, 407, 0, 0, 0, 0,
	0, 0, 0, 490, 490, 490, 490, 0, 0, 0,
	0, 0, 0, 0, 17, 0, 428, 0, 490, 438,
	0, 202, 439, 0, 0, 62, 0, 0, 0, 0,
	0, 0, 0, 0, 57, 0, 563, 0, 0, 631,
	0, 0, 525, 66, 61, 636, 0, 0, 0, 17,
	0, 0, 0, 0, 305, 0, 0, 0, 34, 0,
	62, 195, 0, 0, 0, 0, 0, 0, 650, 57,
	0, 655, 0, 0, 0, 0, 0, 0, 66, 61,
	0, 0, 307, 675, 0, 0, 525, 0, 33, 0,
	0, 0, 0, 34, 0, 0, 53, 0, 0, 0,
	0, 0, 0, 490, 0, 0, 0, 0, 0, 563,
	0, 0, 307, 631, 631, 631, 631, 0, 0, 490,
	0, 171, 0, 0, 0, 0, 0, 675, 0, 0,
	56, 194, 65, 63, 67, 0, 0, 0, 0, 0,
	59, 637, 638, 0, 641, 641, 641, 0, 0, 307,
	0, 0, 0, 0, 194, 0, 171, 55, 194, 60,
	69, 64, 58, 68, 0, 56, 0, 65, 63, 67,
	0, 0, 0, 0, 0, 59, 0, 490, 0, 0,
	0, 0, 0, 415, 490, 0, 0, 556, 0, 0,
	0, 0, 55, 307, 60, 69, 64, 58, 68, 0,
	0, 0, 0, 0, 0, 194, 0, 332, 331, 341,
	342, 334, 335, 336, 337, 338, 339, 340, 333, 0,
	585, 343, 0, 201, 0, 0, 709, 0, 710, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 327, 602, 330, 0, 0, 603, 0, 194,
	344, 345, 346, 347, 348, 349, 350, 0, 328, 329,
	326, 332, 331, 341, 342, 334, 335, 336, 337, 338,
	339, 340, 333, 0, 0, 343, 0, 0, 0, 194,
	194, 194, 194, 0, 0, 0, 0, 0, 0, 0,
	705, 0, 0, 194, 202, 160, 147, 121, 162, 99,
	113, 170, 114, 115, 141, 87, 129, 62, 111, 0,
	102, 83, 108, 84, 100, 123, 57, 126, 98, 149,
	132, 168, 0, 136, 0, 66, 61, 0, 0, 125,
	154, 127, 146, 120, 142, 92, 135, 163, 112, 139,
	0, 0, 0, 53, 0, 0, 0, 0, 0, 0,
	0, 0, 138, 159, 110, 140, 82, 137, 0, 85,
	88, 169, 157, 105, 106, 0, 0, 0, 0, 0,
	0, 0, 124, 128, 143, 118, 0, 0, 0, 0,
	0, 0, 684, 0, 103, 0, 134, 0, 0, 0,
	89, 86, 122, 0, 0, 0, 91, 0, 104, 144,
	0, 155, 119, 171, 158, 117, 116, 161, 164, 153,
	101, 109, 56, 107, 65, 63, 67, 97, 156, 150,
	151, 152, 59, 0, 95, 96, 93, 94, 130, 131,
	165, 166, 167, 145, 90, 0, 0, 148, 133, 55,
	0, 60, 69, 64, 58, 68, 160, 147, 121, 162,
	99, 113, 170, 114, 115, 141, 87, 129, 62, 111,
	0, 102, 83, 108, 84, 100, 123, 57, 126, 98,
	149, 132, 168, 0, 136, 0, 66, 61, 0, 0,
	125, 154, 127, 146, 120, 142, 92, 135, 163, 112,
	139, 34, 0, 0, 53, 0, 0, 0, 0, 0,
	0, 0, 0, 138, 159, 110, 140, 82, 137, 0,
	85, 88, 169, 157, 105, 106, 0, 0, 0, 0,
	0, 0, 0, 124, 128, 143, 118, 0, 0, 0,
	0, 0, 0, 0, 0, 103, 0, 134, 0, 0,
	0, 89, 86, 122, 0, 0, 0, 91, 0, 104,
	144, 0, 155, 119, 171, 158, 117, 116, 161, 164,
	153, 101, 109, 56, 107, 65, 63, 67, 97, 156,
	150, 151, 152, 59, 0, 95, 96, 93, 94, 130,
	131, 165, 166, 167, 145, 90, 0, 0, 148, 133,
	55, 0, 60, 69, 64, 58, 68, 160, 147, 121,
	162, 99, 113, 170, 114, 115, 141, 87, 129, 62,
	111, 0, 102, 83, 108, 84, 100, 123, 57, 126,
	98, 149, 132, 168, 0, 136, 0, 66, 61, 0,
	0, 125, 154, 127, 146, 120, 142, 92, 135, 163,
	112, 139, 0, 0, 0, 203, 0, 0, 0, 0,
	0, 0, 0, 0, 138, 159, 110, 140, 82, 137,
	0, 85, 88, 169, 157, 105, 106, 0, 0, 0,
	0, 0, 0, 0, 124, 128, 143, 118, 0, 0,
	0, 0, 0, 0, 612, 0, 103, 0, 134, 0,
	0, 0, 89, 86, 122, 0, 0, 0, 91, 0,
	104, 144, 0, 155, 119, 171, 158, 117, 116, 161,
	164, 153, 101, 109, 56, 107, 65, 63, 67, 97,
	156, 150, 151, 152, 59, 0, 95, 96, 93, 94,
	130, 131, 165, 166, 167, 145, 90, 0, 0, 148,
	133, 55, 0, 60, 69, 64, 58, 68, 160, 147,
	121, 162, 99, 113, 170, 114, 115, 141, 87, 129,
	62, 111, 0, 102, 83, 108, 84, 100, 123, 57,
	126, 98, 149, 132, 168, 0, 136, 0, 66, 61,
	0, 0, 125, 154, 127, 146, 120, 142, 92, 135,
	163, 112, 139, 0, 0, 0, 53, 0, 0, 0,
	0, 0, 0, 0, 0, 138, 159, 110, 140, 82,
	137, 0, 85, 88, 169, 157, 105, 106, 0, 0,
	0, 0, 0, 0, 0, 124, 128, 143, 118, 0,
	0, 0, 0, 0, 0, 0, 0, 103, 0, 134,
	0, 0, 0, 89, 86, 122, 0, 0, 0, 91,
	0, 104, 144, 0, 155, 119, 171, 158, 117, 116,
	161, 164, 153, 101, 109, 56, 107, 65, 63, 67,
	97, 156, 150, 151, 152, 59, 0, 95, 96, 93,
	94, 130, 131, 165, 166, 167, 145, 90, 0, 0,
	148, 133, 55, 0, 60, 69, 64, 58, 68, 160,
	147, 121, 162, 99, 113, 170, 114, 115, 141, 87,
	129, 62, 111, 0, 102, 83, 108, 84, 100, 123,
	57, 126, 98, 149, 132, 168, 0, 136, 0, 66,
	61, 0, 0, 125, 154, 127, 146, 120, 142, 92,
	135, 163, 112, 139, 0, 0, 0, 203, 0, 0,
	0, 0, 0, 0, 0, 0, 138, 159, 110, 140,
	82, 137, 0, 85, 88, 169, 157, 105, 106, 0,
	0, 0, 0, 0, 0, 0, 124, 128, 143, 118,
	0, 0, 0, 0, 0, 0, 0, 0, 103, 0,
	134, 0, 0, 0, 89, 86, 122, 0, 0, 0,
	91, 0, 104, 144, 0, 155, 119, 171, 158, 117,
	116, 161, 164, 153, 101, 109, 56, 107, 65, 63,
	67, 97, 156, 150, 151, 152, 59, 0, 95, 96,
	93, 94, 130, 131, 165, 166, 167, 145, 90, 0,
	0, 148, 133, 55, 0, 60, 69, 64, 58, 68,
	160, 147, 121, 162, 99, 113, 170, 114, 115, 141,
	87, 129, 62, 111, 0, 102, 83, 108, 84, 100,
	123, 57, 126, 98, 149, 132, 168, 0, 136, 0,
	66, 61, 0, 0, 125, 154, 127, 146, 120, 142,
	92, 135, 163, 112, 139, 0, 0, 0, 195, 0,
	0, 0, 0, 0, 0, 0, 0, 138, 159, 110,
	140, 82, 137, 0, 85, 88, 169, 157, 105, 106,
	0, 0, 0, 0, 0, 0, 0, 124, 128, 143,
	118, 0, 0, 0, 0, 0, 0, 0, 0, 103,
	0, 134, 0, 0, 0, 89, 86, 122, 0, 0,
	0, 91, 0, 104, 144, 0, 155, 119, 171, 158,
	117, 116, 161, 164, 153, 101, 109, 56, 107, 65,
	63, 67, 97, 156, 150, 151, 152, 59, 0, 95,
	96, 93, 94, 130, 131, 165, 166, 167, 145, 90,
	0, 0, 148, 133, 55, 0, 60, 69, 64, 58,
	68, 160, 147, 121, 162, 99, 113, 170, 114, 115,
	141, 87, 129, 62, 111, 0, 102, 83, 108, 84,
	100, 123, 57, 126, 98, 149, 132, 168, 0, 136,
	0, 66, 61, 0, 0, 125, 154, 127, 146, 120,
	142, 92, 135, 163, 112, 139, 0, 0, 0, 79,
	0, 0, 0, 0, 0, 0, 0, 0, 138, 159,
	110, 140, 82, 137, 0, 85, 88, 169, 157, 105,
	106, 0, 0, 0, 0, 0, 0, 0, 124, 128,
	143, 118, 0, 0, 0, 0, 0, 0, 0, 0,
	103, 0, 134, 0, 0, 0, 89, 86, 122, 0,
	0, 0, 91, 0, 104, 144, 0, 155, 119, 171,
	158, 117, 116, 161, 164, 153, 101, 109, 56, 107,
	65, 63, 67, 97, 156, 150, 151, 152, 59, 0,
	95, 96, 93, 94, 130, 131, 165, 166, 167, 145,
	90, 0, 0, 148, 133, 55, 0, 60, 69, 64,
	58, 68, 62, 0, 0, 485, 0, 229, 0, 0,
	0, 57, 0, 0, 0, 0, 264, 0, 0, 0,
	66, 61, 0, 0, 0, 0, 257, 258, 0, 0,
	0, 0, 0, 0, 0, 34, 0, 0, 203, 247,
	246, 248, 249, 250, 251, 0, 0, 252, 244, 245,
	0, 0, 226, 238, 0, 263, 332, 331, 341, 342,
	334, 335, 336, 337, 338, 339, 340, 333, 0, 0,
	343, 0, 0, 0, 0, 235, 236, 488, 0, 0,
	0, 275, 0, 237, 0, 0, 234, 239, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 171, 0,
	0, 273, 0, 0, 0, 0, 0, 56, 0, 65,
	63, 67, 0, 0, 0, 0, 0, 59, 0, 265,
	274, 271, 272, 269, 270, 268, 267, 266, 276, 259,
	260, 262, 0, 261, 55, 0, 60, 69, 64, 58,
	68, 62, 0, 0, 0, 0, 229, 0, 0, 0,
	57, 0, 0, 0, 0, 264, 0, 0, 0, 66,
	61, 0, 0, 0, 0, 257, 258, 0, 0, 0,
	0, 0, 0, 0, 34, 0, 0, 203, 247, 246,
	248, 249, 250, 251, 0, 0, 252, 244, 245, 0,
	0, 226, 238, 0, 263, 331, 341, 342, 334, 335,
	336, 337, 338, 339, 340, 333, 0, 0, 343, 0,
	0, 0, 0, 0, 235, 236, 488, 0, 0, 0,
	275, 0, 237, 0, 0, 234, 239, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 171, 0, 0,
	273, 0, 0, 0, 0, 0, 56, 0, 65, 63,
	67, 0, 0, 0, 0, 0, 59, 0, 265, 274,
	271, 272, 269, 270, 268, 267, 266, 276, 259, 260,
	262, 0, 261, 55, 0, 60, 69, 64, 58, 68,
	62, 0, 0, 0, 0, 229, 0, 0, 0, 57,
	0, 0, 0, 0, 264, 0, 0, 0, 66, 61,
	0, 0, 0, 0, 257, 258, 0, 0, 0, 0,
	0, 0, 0, 34, 0, 220, 203, 247, 246, 248,
	249, 250, 251, 0, 0, 252, 244, 245, 0, 0,
	226, 238, 0, 263, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 235, 236, 0, 0, 0, 0, 275,
	0, 237, 0, 0, 234, 239, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 171, 0, 0, 273,
	0, 0, 0, 0, 0, 56, 0, 65, 63, 67,
	0, 0, 0, 0, 0, 59, 0, 265, 274, 271,
	272, 269, 270, 268, 267, 266, 276, 259, 260, 262,
	17, 261, 55, 0, 60, 69, 64, 58, 68, 0,
	0, 62, 0, 0, 0, 0, 229, 0, 0, 0,
	57, 0, 0, 0, 0, 264, 0, 0, 0, 66,
	61, 0, 0, 0, 0, 257, 258, 0, 0, 0,
	0, 0, 0, 0, 34, 0, 0, 203, 247, 246,
	248, 249, 250, 251, 0, 0, 252, 244, 245, 0,
	0, 226, 238, 0, 263, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 235, 236, 0, 0, 0, 0,
	275, 0, 237, 0, 0, 234, 239, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 171, 0, 0,
	273, 0, 0, 0, 0, 0, 56, 0, 65, 63,
	67, 0, 0, 0, 0, 0, 59, 0, 265, 274,
	271, 272, 269, 270, 268, 267, 266, 276, 259, 260,
	262, 0, 261, 55, 0, 60, 69, 64, 58, 68,
	62, 0, 0, 0, 0, 229, 0, 0, 0, 57,
	0, 0, 0, 0, 264, 0, 0, 0, 66, 61,
	0, 0, 0, 0, 257, 258, 0, 0, 0, 0,
	0, 0, 0, 34, 0, 0, 203, 247, 246, 248,
	249, 250, 251, 0, 0, 252, 244, 245, 0, 0,
	226, 238, 0, 263, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 235, 236, 0, 0, 0, 0, 275,
	0, 237, 0, 0, 234, 239, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 171, 0, 0, 273,
	0, 0, 0, 0, 0, 56, 0, 65, 63, 67,
	0, 0, 0, 0, 0, 59, 0, 265, 274, 271,
	272, 269, 270, 268, 267, 266, 276, 259, 260, 262,
	62, 261, 55, 0, 60, 69, 64, 58, 68, 57,
	0, 0, 0, 0, 264, 0, 0, 0, 66, 61,
	0, 0, 0, 0, 257, 258, 0, 0, 0, 0,
	0, 0, 0, 34, 0, 0, 203, 247, 246, 248,
	249, 250, 251, 0, 0, 252, 244, 245, 0, 0,
	0, 238, 0, 263, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 235, 236, 0, 0, 0, 0, 275,
	0, 237, 0, 0, 234, 239, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 171, 0, 0, 273,
	0, 0, 0, 0, 0, 56, 0, 65, 63, 67,
	0, 0, 0, 0, 0, 59, 0, 265, 274, 271,
	272, 269, 270, 268, 267, 266, 276, 259, 260, 262,
	62, 261, 55, 0, 60, 69, 64, 58, 68, 57,
	0, 0, 0, 0, 264, 0, 0, 0, 66, 61,
	0, 0, 0, 0, 257, 258, 0, 0, 0, 0,
	0, 0, 0, 34, 0, 0, 203, 247, 246, 248,
	249, 250, 251, 0, 0, 252, 0, 62, 0, 0,
	0, 238, 0, 263, 0, 0, 57, 0, 0, 0,
	0, 0, 0, 0, 0, 66, 61, 0, 0, 0,
	0, 0, 0, 235, 236, 0, 0, 0, 0, 275,
	0, 237, 0, 53, 234, 239, 398, 0, 0, 399,
	0, 0, 0, 0, 62, 0, 171, 0, 0, 273,
	0, 0, 0, 57, 0, 56, 0, 65, 63, 67,
	0, 0, 66, 61, 0, 59, 0, 265, 274, 271,
	272, 269, 270, 268, 267, 266, 276, 259, 260, 262,
	53, 261, 55, 0, 60, 69, 64, 58, 68, 0,
	62, 0, 0, 171, 293, 0, 0, 0, 0, 57,
	0, 0, 56, 0, 65, 63, 67, 0, 66, 61,
	0, 0, 59, 332, 331, 341, 342, 334, 335, 336,
	337, 338, 339, 340, 333, 0, 195, 343, 295, 55,
	0, 60, 69, 64, 58, 68, 62, 0, 0, 0,
	171, 0, 0, 0, 0, 57, 0, 0, 0, 56,
	0, 65, 63, 67, 66, 61, 0, 0, 0, 59,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 34,
	0, 0, 195, 0, 0, 0, 55, 0, 60, 69,
	64, 58, 68, 62, 0, 0, 171, 0, 0, 0,
	0, 0, 57, 0, 0, 56, 0, 65, 63, 67,
	0, 66, 61, 0, 0, 59, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 53,
	62, 564, 55, 0, 60, 69, 64, 58, 68, 57,
	0, 0, 171, 0, 0, 0, 0, 0, 66, 61,
	0, 56, 0, 65, 63, 67, 0, 0, 0, 0,
	0, 59, 0, 0, 0, 0, 195, 62, 295, 0,
	0, 0, 0, 0, 0, 288, 57, 0, 55, 0,
	60, 69, 64, 58, 68, 66, 61, 0, 0, 171,
	0, 0, 0, 0, 0, 0, 0, 0, 56, 0,
	65, 63, 67, 195, 62, 0, 0, 0, 59, 0,
	0, 0, 0, 57, 0, 0, 0, 0, 0, 0,
	0, 0, 66, 61, 0, 55, 171, 60, 69, 64,
	58, 68, 0, 0, 0, 56, 0, 65, 63, 67,
	53, 62, 0, 0, 0, 59, 0, 0, 0, 0,
	57, 0, 0, 0, 0, 0, 0, 0, 0, 66,
	61, 0, 55, 171, 60, 69, 64, 58, 68, 0,
	0, 0, 56, 0, 65, 63, 67, 203, 62, 0,
	0, 0, 59, 0, 0, 0, 0, 57, 0, 0,
	0, 0, 0, 0, 0, 0, 66, 61, 0, 55,
	171, 60, 69, 64, 58, 68, 0, 0, 0, 56,
	0, 65, 63, 67, 195, 0, 0, 0, 0, 59,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 55, 171, 60, 69,
	64, 58, 68, 0, 0, 0, 56, 0, 65, 63,
	67, 0, 0, 0, 0, 0, 59, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 55, 171, 60, 69, 64, 58, 68,
	0, 0, 0, 56, 0, 65, 63, 67, 0, 0,
	0, 0, 0, 59, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	55, 0, 60, 69, 64, 58, 68,
}
var yyPact = [...]int{

	121, -1000, -117, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 460, 486, -1000, -1000, -1000,
	-1000, -1000, 770, 0, 21, 6, 20, 2226, -1000, -1000,
	-1000, -1000, -1000, 319, -1000, -1000, -1000, 452, 457, 350,
	445, 360, -1000, -30, 3601, 477, 3564, -36, 8, 3601,
	-81, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	12, 3601, -1000, 3601, -51, 129, -51, 3601, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, 149, 433, 2923,
	2923, 460, -1000, 319, -1000, -1000, -1000, 389, -1000, -1000,
	108, 3490, 400, 3323, 48, -1000, -1000, 3601, 170, -1000,
	84, -1000, 46, -1000, -1000, 3601, 98, 124, 1471, -12,
	3601, 1471, -28, 3601, 435, 259, 3601, -1000, -1000, -1000,
	-1000, -1000, 482, 49, 203, -1000, 2923, 1205, -1000, 168,
	-1000, 17, -1000, -1000, 3183, 3183, 3183, 3183, 3183, 3183,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, 168, 45, -1000, 2784, 168, 168, 168,
	168, 168, 168, 2923, 168, 168, 168, 168, 168, 168,
	168, 168, 168, 168, 168, 168, 168, 223, -1000, 293,
	452, 149, 360, 3230, 320, -1000, -1000, 455, 3601, -1000,
	3564, 61, -1000, 3453, -1000, -1000, 2075, 469, 3564, 2923,
	1924, 1471, 432, -55, -1000, -1000, -1000, -1000, -1000, 3601,
	31, -1000, 3601, -1000, -1000, 3601, 1471, -1000, 361, 2923,
	2923, 229, 2923, 2923, 76, 3053, 152, 111, 3183, 3183,
	3183, 3183, 3183, 3183, 3183, 3183, 3183, 3183, 3183, 3183,
	3183, 3183, 3183, 23, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, 319, 359, 359, 56, 56, 56, 56, 56,
	3277, 2365, 1924, 149, 268, 122, 2784, 2504, 2504, 2923,
	2923, 2504, 446, 93, 122, 3527, -1000, 149, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, 2504, 2504, 2504, 2504, 2923,
	-1000, -1000, -1000, 433, -1000, 446, 459, -1000, 388, 370,
	2504, -1000, 252, 3564, 168, -1000, 1073, -1000, 284, -1000,
	2, -2, -8, -1000, -1000, -1000, -1000, 460, 2923, -1000,
	122, -1000, 43, -1000, -1000, -1000, 237, 3527, 1471, -1000,
	54, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 355, 76, 101, -1000, -1000, 161, -1000, -1000, 122,
	122, -1000, 2350, -1000, -1000, -1000, -1000, 152, 3183, 3183,
	3183, 684, 2350, 1151, 461, 2488, 56, 167, 167, 57,
	57, 57, 57, 57, 292, 292, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 149, 2504, 202, -1000, -1000, 126,
	38, 168, -1000, 2923, -1000, 149, 204, 204, 60, 222,
	204, 2504, 127, -1000, 2923, 149, -1000, 204, 149, 204,
	204, -1000, -1000, 3601, -1000, -1000, -1000, -1000, 255, -1000,
	427, 221, 181, -1000, -1000, 2643, 149, 262, 34, 460,
	168, 168, 168, 452, 122, 1773, 3601, -1000, -1000, -1000,
	3601, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 684, 2350, 898, -1000, 3183, 3183, -1000, 204, 2504,
	-1000, -1000, 3416, -1000, -1000, 1622, 2504, 122, -1000, -1000,
	-1000, 23, 23, 23, -89, 289, 89, -1000, 2923, 218,
	-1000, -1000, -1000, -1000, -1000, -1000, 469, 3369, 425, -1000,
	168, -1000, -1000, 207, 3527, 3527, 452, 3527, 3527, 3527,
	-1000, -1000, 1471, -1000, -1000, -1000, 3183, 2350, 2350, -1000,
	-1000, -1000, -1000, 33, 149, 149, 52, 149, 149, 168,
	-86, -1000, 122, 2923, 458, 193, 787, -1000, -1000, -1000,
	437, 1038, 481, -1000, 168, -1000, 319, 32, -1000, -1000,
	183, -1000, 183, 183, -1000, 2350, 1320, -1000, -1000, -1000,
	117, -1000, 398, -1000, -1000, 3183, 149, 138, 122, 466,
	456, 3369, 3369, 3369, 3369, -1000, 332, 331, -1000, 328,
	295, 365, 3601, -1000, 158, 1038, 3564, 181, 149, 3527,
	-1000, 3527, -1000, -1000, -1000, 154, 23, 3, -1000, -1000,
	-1000, 2923, 2923, 787, 227, 776, -1000, -1000, -1000, -1000,
	324, -1000, 285, -1000, -1000, -1000, -1000, 170, -1000, -1000,
	-1000, 11, 114, -1000, 149, 10, -104, 122, 164, 2923,
	2923, -1000, -1000, -1000, 394, 149, -1000, 341, -97, -107,
	122, 122, 23, -1000, -1000, 337, -1000, -1000, -101, -105,
	-108, -1000,
}
var yyPgo = [...]int{

	0, 632, 23, 420, 631, 630, 628, 627, 625, 622,
	614, 610, 607, 598, 595, 594, 592, 52, 591, 590,
	35, 587, 43, 584, 582, 19, 87, 16, 18, 9,
	581, 14, 10, 1, 575, 572, 8, 570, 736, 569,
	357, 564, 13, 22, 562, 36, 560, 545, 40, 106,
	544, 543, 540, 539, 538, 537, 25, 2, 3, 20,
	15, 536, 41, 6, 534, 27, 533, 532, 531, 529,
	44, 525, 34, 524, 29, 32, 523, 26, 7, 38,
	522, 361, 172, 520, 518, 517, 516, 513, 512, 30,
	5, 576, 11, 17, 507, 647, 31, 42, 504, 502,
	37, 21, 4, 12, 500, 494, 493, 481, 0, 492,
	82,
}
var yyR1 = [...]int{

	0, 105, 106, 106, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 2, 2, 2, 3,
	4, 4, 5, 5, 6, 6, 7, 8, 9, 10,
	10, 10, 10, 11, 11, 11, 11, 12, 13, 13,
	13, 14, 104, 104, 104, 15, 16, 16, 16, 16,
	16, 109, 17, 18, 18, 19, 19, 19, 22, 22,
	22, 20, 20, 21, 21, 27, 27, 26, 26, 28,
	28, 28, 28, 94, 94, 94, 93, 93, 30, 30,
	31, 31, 32, 32, 33, 33, 33, 40, 34, 34,
	34, 34, 99, 99, 98, 98, 98, 97, 97, 35,
	35, 35, 35, 36, 36, 36, 36, 37, 37, 39,
	39, 38, 38, 41, 41, 41, 41, 42, 42, 43,
	43, 29, 29, 29, 29, 29, 29, 45, 45, 44,
	44, 44, 44, 44, 44, 44, 44, 44, 44, 44,
	44, 55, 55, 55, 55, 55, 55, 46, 46, 46,
	46, 46, 46, 46, 25, 25, 56, 56, 56, 62,
	57, 57, 102, 102, 102, 102, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	49, 49, 49, 49, 49, 53, 53, 53, 51, 51,
	51, 51, 51, 51, 51, 51, 51, 52, 52, 52,
	52, 52, 52, 52, 52, 110, 110, 54, 54, 54,
	54, 23, 23, 23, 23, 23, 103, 103, 103, 103,
	103, 103, 103, 103, 66, 66, 24, 24, 64, 64,
	65, 67, 67, 63, 63, 63, 48, 48, 48, 48,
	48, 48, 48, 50, 50, 50, 68, 68, 69, 69,
	70, 70, 71, 71, 72, 73, 73, 73, 74, 74,
	74, 74, 75, 75, 75, 47, 47, 47, 47, 47,
	47, 76, 76, 76, 76, 77, 77, 58, 58, 60,
	60, 59, 61, 78, 78, 79, 80, 80, 82, 82,
	83, 83, 81, 81, 84, 84, 84, 84, 84, 84,
	84, 85, 85, 85, 86, 86, 87, 87, 87, 88,
	88, 91, 91, 92, 92, 95, 95, 96, 96, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 89, 89,
	89, 89, 89, 89, 89, 89, 89, 89, 90, 90,
	90, 90, 90, 90, 90, 90, 90, 90, 90, 90,
	90, 90, 90, 90, 107, 108, 100, 101, 101, 101,
}
var yyR2 = [...]int{

	0, 2, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 4, 6, 7, 10,
	1, 3, 1, 3, 6, 7, 8, 7, 3, 5,
	8, 4, 6, 6, 7, 7, 4, 5, 4, 5,
	5, 3, 1, 1, 1, 3, 2, 2, 2, 2,
	2, 0, 2, 0, 2, 1, 2, 2, 0, 1,
	1, 0, 1, 0, 1, 0, 1, 1, 3, 1,
	2, 3, 5, 0, 1, 2, 1, 1, 0, 2,
	1, 3, 1, 1, 1, 3, 3, 3, 3, 5,
	5, 3, 0, 1, 0, 1, 2, 1, 1, 1,
	2, 2, 1, 2, 3, 2, 3, 2, 2, 2,
	1, 1, 3, 0, 5, 5, 5, 1, 3, 0,
	2, 1, 3, 3, 2, 3, 1, 1, 1, 1,
	3, 3, 3, 4, 4, 5, 3, 4, 5, 6,
	2, 1, 2, 1, 2, 1, 2, 1, 1, 1,
	1, 1, 1, 1, 0, 2, 1, 1, 1, 3,
	1, 3, 1, 1, 1, 1, 1, 1, 1, 1,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 2, 2, 2, 2, 2,
	3, 1, 1, 1, 1, 4, 5, 6, 4, 4,
	6, 6, 6, 9, 7, 5, 4, 2, 2, 2,
	2, 2, 2, 2, 2, 0, 2, 4, 4, 4,
	4, 0, 3, 4, 7, 3, 1, 2, 4, 5,
	7, 2, 4, 6, 0, 1, 0, 2, 1, 2,
	4, 0, 2, 1, 3, 5, 1, 1, 1, 1,
	1, 1, 1, 1, 2, 2, 0, 3, 0, 2,
	0, 3, 1, 3, 2, 0, 1, 1, 0, 2,
	4, 4, 0, 2, 4, 2, 1, 3, 5, 4,
	6, 1, 3, 3, 5, 0, 5, 1, 3, 1,
	2, 3, 1, 1, 3, 3, 1, 1, 0, 2,
	0, 3, 0, 1, 1, 1, 1, 1, 1, 1,
	1, 0, 1, 1, 1, 1, 0, 1, 1, 0,
	2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 0, 0, 1, 1,
}
var yyChk = [...]int{

	-1000, -105, -1, -2, -6, -7, -8, -9, -10, -11,
	-12, -13, -14, -15, -16, -3, -4, 6, 7, 8,
	9, 29, 106, 107, 109, 108, 110, 119, 120, 121,
	124, 125, 126, -107, 50, -106, 156, -70, 14, -19,
	5, -17, -109, -17, -17, -17, -17, 111, -87, 113,
	65, 117, -91, 53, -90, 149, 122, 26, 154, 132,
	151, 36, 17, 125, 153, 124, 35, 126, 155, 152,
	-81, 113, 115, 111, 111, 112, 113, 111, -104, 53,
	-89, -90, 66, 21, 23, 69, 101, 15, 70, 100,
	144, 106, 45, 136, 137, 134, 135, 127, 28, 9,
	24, 120, 20, 94, 108, 73, 74, 123, 22, 121,
	64, 18, 48, 10, 12, 13, 116, 115, 85, 112,
	43, 7, 102, 25, 82, 39, 27, 41, 83, 16,
	138, 139, 30, 148, 96, 46, 33, 67, 62, 49,
	65, 14, 44, 84, 109, 143, 42, 6, 147, 29,
	129, 130, 131, 119, 40, 111, 128, 72, 114, 63,
	5, 117, 8, 47, 118, 140, 141, 142, 31, 71,
	11, 113, -100, -100, -100, -100, -100, -2, -74, 16,
	15, -5, -3, -107, 6, 19, 20, -22, 37, 38,
	-18, -81, -40, -38, -95, 53, -90, 10, -78, -79,
	-63, -91, -95, 53, -90, -83, 116, 112, -38, 143,
	111, -38, -38, -82, 116, 53, -82, -38, -100, -108,
	52, -75, 18, 30, -29, -44, 67, -49, -45, 22,
	-48, -63, -61, -62, 101, 90, 91, 98, 68, 102,
	-53, -51, -52, -54, 63, 64, 55, 54, 56, 57,
	58, 59, 62, -91, -95, -59, -107, 41, 42, 144,
	145, 148, 146, 70, 31, 134, 142, 141, 140, 138,
	139, 136, 137, 116, 135, 96, 143, -71, -72, -29,
	-70, -2, -17, 33, -20, 20, 61, -39, 25, -38,
	29, -98, -97, 21, -95, 55, 103, -38, 51, 75,
	103, -38, 67, 53, -101, -107, -92, -91, -89, 113,
	-38, -101, 114, -38, 22, 49, -38, 8, 85, 66,
	65, 82, 51, 17, -29, -46, 85, 67, 83, 84,
	69, 87, 86, 97, 90, 91, 92, 93, 94, 95,
	96, 88, 89, 100, 75, 76, 77, 78, 79, 80,
	81, -62, -107, 104, 105, -49, -49, -49, -49, -49,
	-49, -107, 103, -2, -57, -29, -107, -107, -107, -107,
	-107, -107, -107, -66, -29, -107, -110, -107, -110, -110,
	-110, -110, -110, -110, -110, -107, -107, -107, -107, 51,
	-73, 23, 24, -74, -108, -22, -50, -91, 56, 59,
	-21, 40, -47, 29, 31, -2, -107, -38, -78, -41,
	47, 115, 48, -97, -96, -95, -89, -43, 11, -79,
	-29, -92, -96, -89, -101, 22, -88, 118, -38, -84,
	109, 107, 28, 108, 14, 144, 155, 53, -38, -38,
	-101, 35, -29, -29, -55, 62, 67, 63, 64, -29,
	-29, -45, -49, -56, -59, -62, 60, 85, 83, 84,
	69, -49, -49, -49, -49, -49, -49, -49, -49, -49,
	-49, -49, -49, -49, -49, -49, -102, 53, 55, 101,
	122, -48, -48, -91, -27, 20, -26, -28, 92, -29,
	-95, -92, -108, 51, -108, -2, -26, -26, -29, -29,
	-26, -20, -64, -65, 71, -91, -108, -26, -27, -26,
	-26, -72, -75, -80, 18, 10, 31, 31, -26, -77,
	49, -78, -58, -60, -59, -107, -2, -76, -91, -43,
	112, 112, 112, -70, -29, 103, 49, -91, -101, -100,
	-85, -86, 114, 21, 112, 27, 36, 62, 63, 64,
	-56, -49, -49, -49, -25, 123, 66, -108, -26, 51,
	-94, -93, 21, -91, 55, 103, -107, -29, -108, -108,
	-108, 51, 118, 21, -108, -26, -67, -65, 73, -29,
	-108, -108, -108, -108, -108, -38, -30, 10, 26, -77,
	51, -108, -108, -108, 51, 103, -70, -107, -107, -107,
	-74, -92, -38, -38, -100, -25, 66, -49, -49, -108,
	-28, -93, 92, -96, -27, -103, -102, -103, -103, 149,
	-70, 74, -29, 72, -43, -31, -32, -33, -34, -40,
	-62, -107, 27, -60, 31, -2, -107, -91, -91, -74,
	-42, -91, -42, -42, -101, -49, 103, -108, -108, 132,
	-107, -102, 133, -108, -108, -107, -24, 147, -29, -68,
	12, 51, -35, -36, -37, 39, 43, 45, 40, 41,
	42, 46, -99, 21, -31, -107, 8, -58, -2, 103,
	-108, 51, -108, -108, 92, 56, 29, -49, -108, 55,
	-69, 13, 15, -32, -33, -32, -33, 39, 39, 39,
	44, 39, 44, 39, -36, -95, -108, -78, -108, -91,
	-91, -108, 51, -102, -23, 85, 152, -29, -57, 49,
	49, 39, 39, -102, 133, 56, -108, 150, 46, 153,
	-29, -29, 29, -108, 36, 151, 154, -102, 36, 152,
	153, 154,
}
var yyDef = [...]int{

	0, -2, 2, -2, 5, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 260, 0, 51, 51, 51,
	51, 51, 316, 302, 0, 0, 0, 0, 436, 436,
	436, 436, 436, 0, 434, 1, 3, 268, 0, 0,
	55, 58, 53, 302, 0, 0, 0, 300, 0, 432,
	0, 317, 318, 321, 322, 418, 419, 420, 421, 422,
	423, 424, 425, 426, 427, 428, 429, 430, 431, 433,
	0, 0, 303, 0, 298, 0, 298, 0, 436, 42,
	43, 44, 329, 330, 331, 332, 333, 334, 335, 336,
	337, 338, 339, 340, 341, 342, 343, 344, 345, 346,
	347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
	357, 358, 359, 360, 361, 362, 363, 364, 365, 366,
	367, 368, 369, 370, 371, 372, 373, 374, 375, 376,
	377, 378, 379, 380, 381, 382, 383, 384, 385, 386,
	387, 388, 389, 390, 391, 392, 393, 394, 395, 396,
	397, 398, 399, 400, 401, 402, 403, 404, 405, 406,
	407, 408, 409, 410, 411, 412, 413, 414, 415, 416,
	417, 432, 46, 47, 48, 49, 50, 20, 272, 0,
	0, 260, 22, 0, 51, 56, 57, 61, 59, 60,
	52, 0, 0, 94, 111, 325, 326, 0, 28, 293,
	0, 243, 0, -2, -2, 0, 0, 0, 437, 0,
	0, 437, 0, 0, 0, 0, 0, 41, 45, 21,
	435, 16, 0, 0, 269, 121, 0, 126, 129, 0,
	166, 167, 168, 169, 0, 0, 0, 0, 0, 0,
	191, 192, 193, 194, 127, 128, 246, 247, 248, 249,
	250, 251, 252, 243, 0, 292, 0, 0, 0, 0,
	0, 0, 0, 234, 0, 215, 215, 215, 215, 215,
	215, 215, 215, 0, 0, 0, 0, 261, 262, 265,
	268, 20, 58, 0, 63, 62, 54, 0, 0, 110,
	0, 113, 95, 0, 97, 98, 0, 119, 0, 0,
	0, 437, 0, 319, 31, 438, 439, 323, 324, 0,
	0, 36, 0, 38, 299, 0, 437, 273, 0, 0,
	0, 0, 0, 0, 124, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 147, 148, 149, 150, 151, 152,
	153, 140, 0, 0, 0, 185, 186, 187, 188, 189,
	0, 65, 0, 20, 0, 160, 0, 0, 0, 0,
	0, 0, 61, 0, 235, 0, 207, 0, 208, 209,
	210, 211, 212, 213, 214, 0, 65, 0, 0, 0,
	264, 266, 267, 272, 23, 61, 0, 253, 0, 0,
	0, 64, 285, 0, 0, -2, 0, 109, 119, 87,
	0, 0, 0, 96, 112, 327, 328, 260, 0, 294,
	295, 244, 0, -2, 29, 301, 0, 0, 437, 436,
	311, 304, 305, 306, 307, 308, 309, 310, 37, 39,
	40, 0, 122, 123, 125, 141, 0, 143, 145, 270,
	271, 130, 131, 132, 156, 157, 158, 0, 0, 0,
	0, 154, 136, 0, 170, 171, 172, 173, 174, 175,
	176, 177, 178, 179, 180, 181, 184, 162, 163, 164,
	165, 182, 183, 190, 0, 0, 66, 67, 69, 73,
	0, 244, 159, 0, 291, 20, 0, 0, 0, 0,
	0, 0, 241, 238, 0, 0, 216, 0, 0, 0,
	0, 263, 17, 0, 296, 297, 254, 255, 78, 24,
	0, 285, 275, 287, 289, 0, 20, 0, 281, 260,
	0, 0, 0, 268, 120, 0, 0, 320, 32, 33,
	0, 436, 312, 313, 314, 315, 274, 142, 144, 146,
	133, 154, 137, 0, 134, 0, 0, 195, 0, 0,
	70, 74, 0, 76, 77, 0, 65, 161, -2, 198,
	199, 0, 0, 0, 0, 260, 0, 239, 0, 0,
	206, 217, 218, 219, 220, 18, 119, 0, 0, 25,
	0, 290, -2, 0, 0, 0, 268, 0, 0, 0,
	27, 245, 437, 34, 35, 135, 0, 155, 138, 196,
	68, 75, 71, 0, 0, 0, 226, 0, 0, 0,
	236, 205, 242, 0, 256, 79, 80, 82, 83, 84,
	92, 0, 0, 288, 0, -2, 0, 283, 282, 26,
	0, 117, 0, 0, 30, 139, 0, 197, 200, 227,
	0, 231, 0, 201, 202, 0, 0, 0, 240, 258,
	0, 0, 0, 0, 0, 99, 0, 0, 102, 0,
	0, 0, 0, 93, 0, 0, 0, 278, 20, 0,
	114, 0, 115, 116, 72, 0, 0, 221, 204, 237,
	19, 0, 0, 81, 88, 0, 91, 100, 101, 103,
	0, 105, 0, 107, 108, 85, 86, 286, -2, 284,
	118, 228, 0, 232, 0, 0, 0, 259, 257, 0,
	0, 104, 106, 229, 0, 0, 203, 0, 0, 0,
	89, 90, 0, 233, 222, 0, 225, 230, 223, 0,
	0, 224,
}
var yyTok1 = [...]int{

	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 68, 3, 3, 3, 95, 87, 3,
	50, 52, 92, 90, 51, 91, 103, 93, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 156,
	76, 75, 77, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 97, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 86, 3, 98,
}
var yyTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 53, 54,
	55, 56, 57, 58, 59, 60, 61, 62, 63, 64,
	65, 66, 67, 69, 70, 71, 72, 73, 74, 78,
	79, 80, 81, 82, 83, 84, 85, 88, 89, 94,
	96, 99, 100, 101, 102, 104, 105, 106, 107, 108,
	109, 110, 111, 112, 113, 114, 115, 116, 117, 118,
	119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
	129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
	139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 153, 154, 155,
}
var yyTok3 = [...]int{
	0,
}

var yyErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	yyDebug        = 0
	yyErrorVerbose = false
)

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

type yyParser interface {
	Parse(yyLexer) int
	Lookahead() int
}

type yyParserImpl struct {
	lval  yySymType
	stack [yyInitialStackSize]yySymType
	char  int
}

func (p *yyParserImpl) Lookahead() int {
	return p.char
}

func yyNewParser() yyParser {
	return &yyParserImpl{}
}

const yyFlag = -1000

func yyTokname(c int) string {
	if c >= 1 && c-1 < len(yyToknames) {
		if yyToknames[c-1] != "" {
			return yyToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yyErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !yyErrorVerbose {
		return "syntax error"
	}

	for _, e := range yyErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + yyTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := yyPact[state]
	for tok := TOKSTART; tok-1 < len(yyToknames); tok++ {
		if n := base + tok; n >= 0 && n < yyLast && yyChk[yyAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if yyDef[state] == -2 {
		i := 0
		for yyExca[i] != -1 || yyExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; yyExca[i] >= 0; i += 2 {
			tok := yyExca[i]
			if tok < TOKSTART || yyExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if yyExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += yyTokname(tok)
	}
	return res
}

func yylex1(lex yyLexer, lval *yySymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		token = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			token = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		token = yyTok3[i+0]
		if token == char {
			token = yyTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(token), uint(char))
	}
	return char, token
}

func yyParse(yylex yyLexer) int {
	return yyNewParser().Parse(yylex)
}

func (yyrcvr *yyParserImpl) Parse(yylex yyLexer) int {
	var yyn int
	var yyVAL yySymType
	var yyDollar []yySymType
	_ = yyDollar // silence set and not used
	yyS := yyrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yyrcvr.char = -1
	yytoken := -1 // yyrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		yystate = -1
		yyrcvr.char = -1
		yytoken = -1
	}()
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yytoken), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yyrcvr.char < 0 {
		yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
	}
	yyn += yytoken
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yytoken { /* valid shift */
		yyrcvr.char = -1
		yytoken = -1
		yyVAL = yyrcvr.lval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yyrcvr.char < 0 {
			yyrcvr.char, yytoken = yylex1(yylex, &yyrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yytoken {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error(yyErrorMessage(yystate, yytoken))
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yytoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yytoken))
			}
			if yytoken == yyEofCode {
				goto ret1
			}
			yyrcvr.char = -1
			yytoken = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	// yyp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if yyp+1 >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:202
		{
			setParseTree(yylex, yyDollar[1].statement)
		}
	case 2:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:207
		{
		}
	case 3:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:208
		{
		}
	case 4:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:212
		{
			yyVAL.statement = yyDollar[1].selStmt
		}
	case 16:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:229
		{
			sel := yyDollar[1].selStmt.(*Select)
			sel.OrderBy = yyDollar[2].orderBy
			sel.Limit = yyDollar[3].limit
			sel.Lock = yyDollar[4].str
			yyVAL.selStmt = sel
		}
	case 17:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:237
		{
			yyVAL.selStmt = &Union{Type: yyDollar[2].str, Left: yyDollar[1].selStmt, Right: yyDollar[3].selStmt, OrderBy: yyDollar[4].orderBy, Limit: yyDollar[5].limit, Lock: yyDollar[6].str}
		}
	case 18:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:241
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyDollar[2].bytes2), Cache: yyDollar[3].str, SelectExprs: SelectExprs{Nextval{Expr: yyDollar[5].expr}}, From: TableExprs{&AliasedTableExpr{Expr: yyDollar[7].tableName}}}
		}
	case 19:
		yyDollar = yyS[yypt-10 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:248
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyDollar[2].bytes2), Cache: yyDollar[3].str, Distinct: yyDollar[4].str, Hints: yyDollar[5].str, SelectExprs: yyDollar[6].selectExprs, From: yyDollar[7].tableExprs, Where: NewWhere(WhereStr, yyDollar[8].expr), GroupBy: GroupBy(yyDollar[9].exprs), Having: NewWhere(HavingStr, yyDollar[10].expr)}
		}
	case 20:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:254
		{
			yyVAL.selStmt = yyDollar[1].selStmt
		}
	case 21:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:258
		{
			yyVAL.selStmt = &ParenSelect{Select: yyDollar[2].selStmt}
		}
	case 22:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:264
		{
			yyVAL.selStmt = yyDollar[1].selStmt
		}
	case 23:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:268
		{
			yyVAL.selStmt = &ParenSelect{Select: yyDollar[2].selStmt}
		}
	case 24:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:275
		{
			// insert_data returns a *Insert pre-filled with Columns & Values
			ins := yyDollar[5].ins
			ins.Comments = yyDollar[2].bytes2
			ins.Ignore = yyDollar[3].str
			ins.Table = yyDollar[4].tableName
			ins.OnDup = OnDup(yyDollar[6].updateExprs)
			yyVAL.statement = ins
		}
	case 25:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:285
		{
			cols := make(Columns, 0, len(yyDollar[6].updateExprs))
			vals := make(ValTuple, 0, len(yyDollar[7].updateExprs))
			for _, updateList := range yyDollar[6].updateExprs {
				cols = append(cols, updateList.Name.Name)
				vals = append(vals, updateList.Expr)
			}
			yyVAL.statement = &Insert{Comments: Comments(yyDollar[2].bytes2), Ignore: yyDollar[3].str, Table: yyDollar[4].tableName, Columns: cols, Rows: Values{vals}, OnDup: OnDup(yyDollar[7].updateExprs)}
		}
	case 26:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:297
		{
			yyVAL.statement = &Update{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[3].aliasedTableName, Exprs: yyDollar[5].updateExprs, Where: NewWhere(WhereStr, yyDollar[6].expr), OrderBy: yyDollar[7].orderBy, Limit: yyDollar[8].limit}
		}
	case 27:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:303
		{
			yyVAL.statement = &Delete{Comments: Comments(yyDollar[2].bytes2), Table: yyDollar[4].tableName, Where: NewWhere(WhereStr, yyDollar[5].expr), OrderBy: yyDollar[6].orderBy, Limit: yyDollar[7].limit}
		}
	case 28:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:309
		{
			yyVAL.statement = &Set{Comments: Comments(yyDollar[2].bytes2), Exprs: yyDollar[3].updateExprs}
		}
	case 29:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:315
		{
			yyVAL.statement = &DDL{Action: CreateStr, NewName: yyDollar[4].tableName}
		}
	case 30:
		yyDollar = yyS[yypt-8 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:319
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[7].tableName, NewName: yyDollar[7].tableName}
		}
	case 31:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:324
		{
			yyVAL.statement = &DDL{Action: CreateStr, NewName: yyDollar[3].tableName.ToViewName()}
		}
	case 32:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:328
		{
			yyVAL.statement = &DDL{Action: CreateStr, NewName: yyDollar[5].tableName.ToViewName()}
		}
	case 33:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:334
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 34:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:338
		{
			// Change this to a rename statement
			yyVAL.statement = &DDL{Action: RenameStr, Table: yyDollar[4].tableName, NewName: yyDollar[7].tableName}
		}
	case 35:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:343
		{
			// Rename an index can just be an alter
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[4].tableName, NewName: yyDollar[4].tableName}
		}
	case 36:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:348
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[3].tableName.ToViewName(), NewName: yyDollar[3].tableName.ToViewName()}
		}
	case 37:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:354
		{
			yyVAL.statement = &DDL{Action: RenameStr, Table: yyDollar[3].tableName, NewName: yyDollar[5].tableName}
		}
	case 38:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:360
		{
			var exists bool
			if yyDollar[3].byt != 0 {
				exists = true
			}
			yyVAL.statement = &DDL{Action: DropStr, Table: yyDollar[4].tableName, IfExists: exists}
		}
	case 39:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:368
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[5].tableName, NewName: yyDollar[5].tableName}
		}
	case 40:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:373
		{
			var exists bool
			if yyDollar[3].byt != 0 {
				exists = true
			}
			yyVAL.statement = &DDL{Action: DropStr, Table: yyDollar[4].tableName.ToViewName(), IfExists: exists}
		}
	case 41:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:383
		{
			yyVAL.statement = &DDL{Action: AlterStr, Table: yyDollar[3].tableName, NewName: yyDollar[3].tableName}
		}
	case 42:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:389
		{
			yyVAL.str = ShowUnsupportedStr
		}
	case 43:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:393
		{
			if string(yyDollar[1].bytes) == "databases" {
				yyVAL.str = ShowDatabasesStr
			} else if string(yyDollar[1].bytes) == "tables" {
				yyVAL.str = ShowTablesStr
			} else if string(yyDollar[1].bytes) == "vitess_keyspaces" {
				yyVAL.str = ShowKeyspacesStr
			} else if string(yyDollar[1].bytes) == "vitess_shards" {
				yyVAL.str = ShowShardsStr
			} else if string(yyDollar[1].bytes) == "vschema_tables" {
				yyVAL.str = ShowVSchemaTablesStr
			} else {
				yyVAL.str = ShowUnsupportedStr
			}
		}
	case 44:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:409
		{
			yyVAL.str = ShowUnsupportedStr
		}
	case 45:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:415
		{
			yyVAL.statement = &Show{Type: yyDollar[2].str}
		}
	case 46:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:421
		{
			yyVAL.statement = &Other{}
		}
	case 47:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:425
		{
			yyVAL.statement = &Other{}
		}
	case 48:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:429
		{
			yyVAL.statement = &Other{}
		}
	case 49:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:433
		{
			yyVAL.statement = &Other{}
		}
	case 50:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:437
		{
			yyVAL.statement = &Other{}
		}
	case 51:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:442
		{
			setAllowComments(yylex, true)
		}
	case 52:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:446
		{
			yyVAL.bytes2 = yyDollar[2].bytes2
			setAllowComments(yylex, false)
		}
	case 53:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:452
		{
			yyVAL.bytes2 = nil
		}
	case 54:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:456
		{
			yyVAL.bytes2 = append(yyDollar[1].bytes2, yyDollar[2].bytes)
		}
	case 55:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:462
		{
			yyVAL.str = UnionStr
		}
	case 56:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:466
		{
			yyVAL.str = UnionAllStr
		}
	case 57:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:470
		{
			yyVAL.str = UnionDistinctStr
		}
	case 58:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:475
		{
			yyVAL.str = ""
		}
	case 59:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:479
		{
			yyVAL.str = SQLNoCacheStr
		}
	case 60:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:483
		{
			yyVAL.str = SQLCacheStr
		}
	case 61:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:488
		{
			yyVAL.str = ""
		}
	case 62:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:492
		{
			yyVAL.str = DistinctStr
		}
	case 63:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:497
		{
			yyVAL.str = ""
		}
	case 64:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:501
		{
			yyVAL.str = StraightJoinHint
		}
	case 65:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:506
		{
			yyVAL.selectExprs = nil
		}
	case 66:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:510
		{
			yyVAL.selectExprs = yyDollar[1].selectExprs
		}
	case 67:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:516
		{
			yyVAL.selectExprs = SelectExprs{yyDollar[1].selectExpr}
		}
	case 68:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:520
		{
			yyVAL.selectExprs = append(yyVAL.selectExprs, yyDollar[3].selectExpr)
		}
	case 69:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:526
		{
			yyVAL.selectExpr = &StarExpr{}
		}
	case 70:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:530
		{
			yyVAL.selectExpr = &NonStarExpr{Expr: yyDollar[1].expr, As: yyDollar[2].colIdent}
		}
	case 71:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:534
		{
			yyVAL.selectExpr = &StarExpr{TableName: &TableName{Name: yyDollar[1].tableIdent}}
		}
	case 72:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:538
		{
			yyVAL.selectExpr = &StarExpr{TableName: &TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}}
		}
	case 73:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:543
		{
			yyVAL.colIdent = ColIdent{}
		}
	case 74:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:547
		{
			yyVAL.colIdent = yyDollar[1].colIdent
		}
	case 75:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:551
		{
			yyVAL.colIdent = yyDollar[2].colIdent
		}
	case 77:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:558
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 78:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:563
		{
			yyVAL.tableExprs = TableExprs{&AliasedTableExpr{Expr: &TableName{Name: NewTableIdent("dual")}}}
		}
	case 79:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:567
		{
			yyVAL.tableExprs = yyDollar[2].tableExprs
		}
	case 80:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:573
		{
			yyVAL.tableExprs = TableExprs{yyDollar[1].tableExpr}
		}
	case 81:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:577
		{
			yyVAL.tableExprs = append(yyVAL.tableExprs, yyDollar[3].tableExpr)
		}
	case 84:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:587
		{
			yyVAL.tableExpr = yyDollar[1].aliasedTableName
		}
	case 85:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:591
		{
			yyVAL.tableExpr = &AliasedTableExpr{Expr: yyDollar[1].subquery, As: yyDollar[3].tableIdent}
		}
	case 86:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:595
		{
			yyVAL.tableExpr = &ParenTableExpr{Exprs: yyDollar[2].tableExprs}
		}
	case 87:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:601
		{
			yyVAL.aliasedTableName = &AliasedTableExpr{Expr: yyDollar[1].tableName, As: yyDollar[2].tableIdent, Hints: yyDollar[3].indexHints}
		}
	case 88:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:614
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr}
		}
	case 89:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:618
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, On: yyDollar[5].expr}
		}
	case 90:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:622
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr, On: yyDollar[5].expr}
		}
	case 91:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:626
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyDollar[1].tableExpr, Join: yyDollar[2].str, RightExpr: yyDollar[3].tableExpr}
		}
	case 92:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:631
		{
			yyVAL.empty = struct{}{}
		}
	case 93:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:633
		{
			yyVAL.empty = struct{}{}
		}
	case 94:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:636
		{
			yyVAL.tableIdent = NewTableIdent("")
		}
	case 95:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:640
		{
			yyVAL.tableIdent = yyDollar[1].tableIdent
		}
	case 96:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:644
		{
			yyVAL.tableIdent = yyDollar[2].tableIdent
		}
	case 98:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:651
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 99:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:657
		{
			yyVAL.str = JoinStr
		}
	case 100:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:661
		{
			yyVAL.str = JoinStr
		}
	case 101:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:665
		{
			yyVAL.str = JoinStr
		}
	case 102:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:669
		{
			yyVAL.str = StraightJoinStr
		}
	case 103:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:675
		{
			yyVAL.str = LeftJoinStr
		}
	case 104:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:679
		{
			yyVAL.str = LeftJoinStr
		}
	case 105:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:683
		{
			yyVAL.str = RightJoinStr
		}
	case 106:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:687
		{
			yyVAL.str = RightJoinStr
		}
	case 107:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:693
		{
			yyVAL.str = NaturalJoinStr
		}
	case 108:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:697
		{
			if yyDollar[2].str == LeftJoinStr {
				yyVAL.str = NaturalLeftJoinStr
			} else {
				yyVAL.str = NaturalRightJoinStr
			}
		}
	case 109:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:707
		{
			yyVAL.tableName = yyDollar[2].tableName
		}
	case 110:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:711
		{
			yyVAL.tableName = yyDollar[1].tableName
		}
	case 111:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:717
		{
			yyVAL.tableName = &TableName{Name: yyDollar[1].tableIdent}
		}
	case 112:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:721
		{
			yyVAL.tableName = &TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}
		}
	case 113:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:726
		{
			yyVAL.indexHints = nil
		}
	case 114:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:730
		{
			yyVAL.indexHints = &IndexHints{Type: UseStr, Indexes: yyDollar[4].colIdents}
		}
	case 115:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:734
		{
			yyVAL.indexHints = &IndexHints{Type: IgnoreStr, Indexes: yyDollar[4].colIdents}
		}
	case 116:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:738
		{
			yyVAL.indexHints = &IndexHints{Type: ForceStr, Indexes: yyDollar[4].colIdents}
		}
	case 117:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:744
		{
			yyVAL.colIdents = []ColIdent{yyDollar[1].colIdent}
		}
	case 118:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:748
		{
			yyVAL.colIdents = append(yyDollar[1].colIdents, yyDollar[3].colIdent)
		}
	case 119:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:753
		{
			yyVAL.expr = nil
		}
	case 120:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:757
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 121:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:763
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 122:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:767
		{
			yyVAL.expr = &AndExpr{Left: yyDollar[1].expr, Right: yyDollar[3].expr}
		}
	case 123:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:771
		{
			yyVAL.expr = &OrExpr{Left: yyDollar[1].expr, Right: yyDollar[3].expr}
		}
	case 124:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:775
		{
			yyVAL.expr = &NotExpr{Expr: yyDollar[2].expr}
		}
	case 125:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:779
		{
			yyVAL.expr = &IsExpr{Operator: yyDollar[3].str, Expr: yyDollar[1].expr}
		}
	case 126:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:783
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 127:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:789
		{
			yyVAL.boolVal = BoolVal(true)
		}
	case 128:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:793
		{
			yyVAL.boolVal = BoolVal(false)
		}
	case 129:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:799
		{
			yyVAL.expr = yyDollar[1].boolVal
		}
	case 130:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:803
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: yyDollar[2].str, Right: yyDollar[3].boolVal}
		}
	case 131:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:807
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: yyDollar[2].str, Right: yyDollar[3].expr}
		}
	case 132:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:811
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: InStr, Right: yyDollar[3].colTuple}
		}
	case 133:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:815
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotInStr, Right: yyDollar[4].colTuple}
		}
	case 134:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:819
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: LikeStr, Right: yyDollar[3].expr, Escape: yyDollar[4].expr}
		}
	case 135:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:823
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotLikeStr, Right: yyDollar[4].expr, Escape: yyDollar[5].expr}
		}
	case 136:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:827
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: RegexpStr, Right: yyDollar[3].expr}
		}
	case 137:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:831
		{
			yyVAL.expr = &ComparisonExpr{Left: yyDollar[1].expr, Operator: NotRegexpStr, Right: yyDollar[4].expr}
		}
	case 138:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:835
		{
			yyVAL.expr = &RangeCond{Left: yyDollar[1].expr, Operator: BetweenStr, From: yyDollar[3].expr, To: yyDollar[5].expr}
		}
	case 139:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:839
		{
			yyVAL.expr = &RangeCond{Left: yyDollar[1].expr, Operator: NotBetweenStr, From: yyDollar[4].expr, To: yyDollar[6].expr}
		}
	case 140:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:843
		{
			yyVAL.expr = &ExistsExpr{Subquery: yyDollar[2].subquery}
		}
	case 141:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:849
		{
			yyVAL.str = IsNullStr
		}
	case 142:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:853
		{
			yyVAL.str = IsNotNullStr
		}
	case 143:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:857
		{
			yyVAL.str = IsTrueStr
		}
	case 144:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:861
		{
			yyVAL.str = IsNotTrueStr
		}
	case 145:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:865
		{
			yyVAL.str = IsFalseStr
		}
	case 146:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:869
		{
			yyVAL.str = IsNotFalseStr
		}
	case 147:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:875
		{
			yyVAL.str = EqualStr
		}
	case 148:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:879
		{
			yyVAL.str = LessThanStr
		}
	case 149:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:883
		{
			yyVAL.str = GreaterThanStr
		}
	case 150:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:887
		{
			yyVAL.str = LessEqualStr
		}
	case 151:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:891
		{
			yyVAL.str = GreaterEqualStr
		}
	case 152:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:895
		{
			yyVAL.str = NotEqualStr
		}
	case 153:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:899
		{
			yyVAL.str = NullSafeEqualStr
		}
	case 154:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:904
		{
			yyVAL.expr = nil
		}
	case 155:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:908
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 156:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:914
		{
			yyVAL.colTuple = yyDollar[1].valTuple
		}
	case 157:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:918
		{
			yyVAL.colTuple = yyDollar[1].subquery
		}
	case 158:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:922
		{
			yyVAL.colTuple = ListArg(yyDollar[1].bytes)
		}
	case 159:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:928
		{
			yyVAL.subquery = &Subquery{yyDollar[2].selStmt}
		}
	case 160:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:934
		{
			yyVAL.exprs = Exprs{yyDollar[1].expr}
		}
	case 161:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:938
		{
			yyVAL.exprs = append(yyDollar[1].exprs, yyDollar[3].expr)
		}
	case 162:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:944
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 163:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:948
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 164:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:952
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 165:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:956
		{
			yyVAL.str = string(yyDollar[1].bytes)
		}
	case 166:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:962
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 167:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:966
		{
			yyVAL.expr = yyDollar[1].colName
		}
	case 168:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:970
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 169:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:974
		{
			yyVAL.expr = yyDollar[1].subquery
		}
	case 170:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:978
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitAndStr, Right: yyDollar[3].expr}
		}
	case 171:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:982
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitOrStr, Right: yyDollar[3].expr}
		}
	case 172:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:986
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: BitXorStr, Right: yyDollar[3].expr}
		}
	case 173:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:990
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: PlusStr, Right: yyDollar[3].expr}
		}
	case 174:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:994
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: MinusStr, Right: yyDollar[3].expr}
		}
	case 175:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:998
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: MultStr, Right: yyDollar[3].expr}
		}
	case 176:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1002
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: DivStr, Right: yyDollar[3].expr}
		}
	case 177:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1006
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: IntDivStr, Right: yyDollar[3].expr}
		}
	case 178:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1010
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ModStr, Right: yyDollar[3].expr}
		}
	case 179:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1014
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ModStr, Right: yyDollar[3].expr}
		}
	case 180:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1018
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ShiftLeftStr, Right: yyDollar[3].expr}
		}
	case 181:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1022
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].expr, Operator: ShiftRightStr, Right: yyDollar[3].expr}
		}
	case 182:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1026
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].colName, Operator: JSONExtractOp, Right: yyDollar[3].expr}
		}
	case 183:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1030
		{
			yyVAL.expr = &BinaryExpr{Left: yyDollar[1].colName, Operator: JSONUnquoteExtractOp, Right: yyDollar[3].expr}
		}
	case 184:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1034
		{
			yyVAL.expr = &CollateExpr{Expr: yyDollar[1].expr, Charset: yyDollar[3].str}
		}
	case 185:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1038
		{
			yyVAL.expr = &UnaryExpr{Operator: BinaryStr, Expr: yyDollar[2].expr}
		}
	case 186:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1042
		{
			if num, ok := yyDollar[2].expr.(*SQLVal); ok && num.Type == IntVal {
				yyVAL.expr = num
			} else {
				yyVAL.expr = &UnaryExpr{Operator: UPlusStr, Expr: yyDollar[2].expr}
			}
		}
	case 187:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1050
		{
			if num, ok := yyDollar[2].expr.(*SQLVal); ok && num.Type == IntVal {
				// Handle double negative
				if num.Val[0] == '-' {
					num.Val = num.Val[1:]
					yyVAL.expr = num
				} else {
					yyVAL.expr = NewIntVal(append([]byte("-"), num.Val...))
				}
			} else {
				yyVAL.expr = &UnaryExpr{Operator: UMinusStr, Expr: yyDollar[2].expr}
			}
		}
	case 188:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1064
		{
			yyVAL.expr = &UnaryExpr{Operator: TildaStr, Expr: yyDollar[2].expr}
		}
	case 189:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1068
		{
			yyVAL.expr = &UnaryExpr{Operator: BangStr, Expr: yyDollar[2].expr}
		}
	case 190:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1072
		{
			// This rule prevents the usage of INTERVAL
			// as a function. If support is needed for that,
			// we'll need to revisit this. The solution
			// will be non-trivial because of grammar conflicts.
			yyVAL.expr = &IntervalExpr{Expr: yyDollar[2].expr, Unit: yyDollar[3].colIdent}
		}
	case 195:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1090
		{
			yyVAL.expr = &FuncExpr{Name: yyDollar[1].colIdent, Exprs: yyDollar[3].selectExprs}
		}
	case 196:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1094
		{
			yyVAL.expr = &FuncExpr{Name: yyDollar[1].colIdent, Distinct: true, Exprs: yyDollar[4].selectExprs}
		}
	case 197:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1098
		{
			yyVAL.expr = &FuncExpr{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].colIdent, Exprs: yyDollar[5].selectExprs}
		}
	case 198:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1108
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("left"), Exprs: yyDollar[3].selectExprs}
		}
	case 199:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1112
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("right"), Exprs: yyDollar[3].selectExprs}
		}
	case 200:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1116
		{
			yyVAL.expr = &ConvertExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].convertType}
		}
	case 201:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1120
		{
			yyVAL.expr = &ConvertExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].convertType}
		}
	case 202:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1124
		{
			yyVAL.expr = &ConvertExpr{Expr: yyDollar[3].expr, Type: yyDollar[5].convertType}
		}
	case 203:
		yyDollar = yyS[yypt-9 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1128
		{
			yyVAL.expr = &MatchExpr{Columns: yyDollar[3].selectExprs, Expr: yyDollar[7].expr, Option: yyDollar[8].str}
		}
	case 204:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1132
		{
			yyVAL.expr = &GroupConcatExpr{Distinct: yyDollar[3].str, Exprs: yyDollar[4].selectExprs, OrderBy: yyDollar[5].orderBy, Separator: yyDollar[6].str}
		}
	case 205:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1136
		{
			yyVAL.expr = &CaseExpr{Expr: yyDollar[2].expr, Whens: yyDollar[3].whens, Else: yyDollar[4].expr}
		}
	case 206:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1140
		{
			yyVAL.expr = &ValuesFuncExpr{Name: yyDollar[3].colIdent}
		}
	case 207:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1150
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_timestamp")}
		}
	case 208:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1154
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_timestamp")}
		}
	case 209:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1158
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_time")}
		}
	case 210:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1162
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("utc_date")}
		}
	case 211:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1167
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("localtime")}
		}
	case 212:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1172
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("localtimestamp")}
		}
	case 213:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1177
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_date")}
		}
	case 214:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1182
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("current_time")}
		}
	case 217:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1196
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("if"), Exprs: yyDollar[3].selectExprs}
		}
	case 218:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1200
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("database"), Exprs: yyDollar[3].selectExprs}
		}
	case 219:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1204
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("mod"), Exprs: yyDollar[3].selectExprs}
		}
	case 220:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1208
		{
			yyVAL.expr = &FuncExpr{Name: NewColIdent("replace"), Exprs: yyDollar[3].selectExprs}
		}
	case 221:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1214
		{
			yyVAL.str = ""
		}
	case 222:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1218
		{
			yyVAL.str = BooleanModeStr
		}
	case 223:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1222
		{
			yyVAL.str = NaturalLanguageModeStr
		}
	case 224:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1226
		{
			yyVAL.str = NaturalLanguageModeWithQueryExpansionStr
		}
	case 225:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1230
		{
			yyVAL.str = QueryExpansionStr
		}
	case 226:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1237
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str}
		}
	case 227:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1241
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str}
		}
	case 228:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1245
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Length: NewIntVal(yyDollar[3].bytes)}
		}
	case 229:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1249
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Length: NewIntVal(yyDollar[3].bytes), Charset: yyDollar[5].str}
		}
	case 230:
		yyDollar = yyS[yypt-7 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1253
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Length: NewIntVal(yyDollar[3].bytes), Charset: yyDollar[7].str, Operator: CharacterSetStr}
		}
	case 231:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1257
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Charset: yyDollar[2].str}
		}
	case 232:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1261
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Charset: yyDollar[4].str, Operator: CharacterSetStr}
		}
	case 233:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1265
		{
			yyVAL.convertType = &ConvertType{Type: yyDollar[1].str, Length: NewIntVal(yyDollar[3].bytes), Scale: NewIntVal(yyDollar[5].bytes)}
		}
	case 234:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1270
		{
			yyVAL.expr = nil
		}
	case 235:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1274
		{
			yyVAL.expr = yyDollar[1].expr
		}
	case 236:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1279
		{
			yyVAL.str = string("")
		}
	case 237:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1283
		{
			yyVAL.str = " separator '" + string(yyDollar[2].bytes) + "'"
		}
	case 238:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1289
		{
			yyVAL.whens = []*When{yyDollar[1].when}
		}
	case 239:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1293
		{
			yyVAL.whens = append(yyDollar[1].whens, yyDollar[2].when)
		}
	case 240:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1299
		{
			yyVAL.when = &When{Cond: yyDollar[2].expr, Val: yyDollar[4].expr}
		}
	case 241:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1304
		{
			yyVAL.expr = nil
		}
	case 242:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1308
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 243:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1314
		{
			yyVAL.colName = &ColName{Name: yyDollar[1].colIdent}
		}
	case 244:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1318
		{
			yyVAL.colName = &ColName{Qualifier: &TableName{Name: yyDollar[1].tableIdent}, Name: yyDollar[3].colIdent}
		}
	case 245:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1322
		{
			yyVAL.colName = &ColName{Qualifier: &TableName{Qualifier: yyDollar[1].tableIdent, Name: yyDollar[3].tableIdent}, Name: yyDollar[5].colIdent}
		}
	case 246:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1328
		{
			yyVAL.expr = NewStrVal(yyDollar[1].bytes)
		}
	case 247:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1332
		{
			yyVAL.expr = NewHexVal(yyDollar[1].bytes)
		}
	case 248:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1336
		{
			yyVAL.expr = NewIntVal(yyDollar[1].bytes)
		}
	case 249:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1340
		{
			yyVAL.expr = NewFloatVal(yyDollar[1].bytes)
		}
	case 250:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1344
		{
			yyVAL.expr = NewHexNum(yyDollar[1].bytes)
		}
	case 251:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1348
		{
			yyVAL.expr = NewValArg(yyDollar[1].bytes)
		}
	case 252:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1352
		{
			yyVAL.expr = &NullVal{}
		}
	case 253:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1358
		{
			// TODO(sougou): Deprecate this construct.
			if yyDollar[1].colIdent.Lowered() != "value" {
				yylex.Error("expecting value after next")
				return 1
			}
			yyVAL.expr = NewIntVal([]byte("1"))
		}
	case 254:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1367
		{
			yyVAL.expr = NewIntVal(yyDollar[1].bytes)
		}
	case 255:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1371
		{
			yyVAL.expr = NewValArg(yyDollar[1].bytes)
		}
	case 256:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1376
		{
			yyVAL.exprs = nil
		}
	case 257:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1380
		{
			yyVAL.exprs = yyDollar[3].exprs
		}
	case 258:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1385
		{
			yyVAL.expr = nil
		}
	case 259:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1389
		{
			yyVAL.expr = yyDollar[2].expr
		}
	case 260:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1394
		{
			yyVAL.orderBy = nil
		}
	case 261:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1398
		{
			yyVAL.orderBy = yyDollar[3].orderBy
		}
	case 262:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1404
		{
			yyVAL.orderBy = OrderBy{yyDollar[1].order}
		}
	case 263:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1408
		{
			yyVAL.orderBy = append(yyDollar[1].orderBy, yyDollar[3].order)
		}
	case 264:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1414
		{
			yyVAL.order = &Order{Expr: yyDollar[1].expr, Direction: yyDollar[2].str}
		}
	case 265:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1419
		{
			yyVAL.str = AscScr
		}
	case 266:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1423
		{
			yyVAL.str = AscScr
		}
	case 267:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1427
		{
			yyVAL.str = DescScr
		}
	case 268:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1432
		{
			yyVAL.limit = nil
		}
	case 269:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1436
		{
			yyVAL.limit = &Limit{Rowcount: yyDollar[2].expr}
		}
	case 270:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1440
		{
			yyVAL.limit = &Limit{Offset: yyDollar[2].expr, Rowcount: yyDollar[4].expr}
		}
	case 271:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1444
		{
			yyVAL.limit = &Limit{Offset: yyDollar[4].expr, Rowcount: yyDollar[2].expr}
		}
	case 272:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1449
		{
			yyVAL.str = ""
		}
	case 273:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1453
		{
			yyVAL.str = ForUpdateStr
		}
	case 274:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1457
		{
			yyVAL.str = ShareModeStr
		}
	case 275:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1470
		{
			yyVAL.ins = &Insert{Rows: yyDollar[2].values}
		}
	case 276:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1474
		{
			yyVAL.ins = &Insert{Rows: yyDollar[1].selStmt}
		}
	case 277:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1478
		{
			// Drop the redundant parenthesis.
			yyVAL.ins = &Insert{Rows: yyDollar[2].selStmt}
		}
	case 278:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1483
		{
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[5].values}
		}
	case 279:
		yyDollar = yyS[yypt-4 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1487
		{
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[4].selStmt}
		}
	case 280:
		yyDollar = yyS[yypt-6 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1491
		{
			// Drop the redundant parenthesis.
			yyVAL.ins = &Insert{Columns: yyDollar[2].columns, Rows: yyDollar[5].selStmt}
		}
	case 281:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1498
		{
			yyVAL.columns = Columns{yyDollar[1].colIdent}
		}
	case 282:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1502
		{
			yyVAL.columns = Columns{yyDollar[3].colIdent}
		}
	case 283:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1506
		{
			yyVAL.columns = append(yyVAL.columns, yyDollar[3].colIdent)
		}
	case 284:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1510
		{
			yyVAL.columns = append(yyVAL.columns, yyDollar[5].colIdent)
		}
	case 285:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1515
		{
			yyVAL.updateExprs = nil
		}
	case 286:
		yyDollar = yyS[yypt-5 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1519
		{
			yyVAL.updateExprs = yyDollar[5].updateExprs
		}
	case 287:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1525
		{
			yyVAL.values = Values{yyDollar[1].valTuple}
		}
	case 288:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1529
		{
			yyVAL.values = append(yyDollar[1].values, yyDollar[3].valTuple)
		}
	case 289:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1535
		{
			yyVAL.valTuple = yyDollar[1].valTuple
		}
	case 290:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1539
		{
			yyVAL.valTuple = ValTuple{}
		}
	case 291:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1545
		{
			yyVAL.valTuple = ValTuple(yyDollar[2].exprs)
		}
	case 292:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1551
		{
			if len(yyDollar[1].valTuple) == 1 {
				yyVAL.expr = &ParenExpr{yyDollar[1].valTuple[0]}
			} else {
				yyVAL.expr = yyDollar[1].valTuple
			}
		}
	case 293:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1561
		{
			yyVAL.updateExprs = UpdateExprs{yyDollar[1].updateExpr}
		}
	case 294:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1565
		{
			yyVAL.updateExprs = append(yyDollar[1].updateExprs, yyDollar[3].updateExpr)
		}
	case 295:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1571
		{
			yyVAL.updateExpr = &UpdateExpr{Name: yyDollar[1].colName, Expr: yyDollar[3].expr}
		}
	case 298:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1580
		{
			yyVAL.byt = 0
		}
	case 299:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1582
		{
			yyVAL.byt = 1
		}
	case 300:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1585
		{
			yyVAL.empty = struct{}{}
		}
	case 301:
		yyDollar = yyS[yypt-3 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1587
		{
			yyVAL.empty = struct{}{}
		}
	case 302:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1590
		{
			yyVAL.str = ""
		}
	case 303:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1592
		{
			yyVAL.str = IgnoreStr
		}
	case 304:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1596
		{
			yyVAL.empty = struct{}{}
		}
	case 305:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1598
		{
			yyVAL.empty = struct{}{}
		}
	case 306:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1600
		{
			yyVAL.empty = struct{}{}
		}
	case 307:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1602
		{
			yyVAL.empty = struct{}{}
		}
	case 308:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1604
		{
			yyVAL.empty = struct{}{}
		}
	case 309:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1606
		{
			yyVAL.empty = struct{}{}
		}
	case 310:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1608
		{
			yyVAL.empty = struct{}{}
		}
	case 311:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1611
		{
			yyVAL.empty = struct{}{}
		}
	case 312:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1613
		{
			yyVAL.empty = struct{}{}
		}
	case 313:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1615
		{
			yyVAL.empty = struct{}{}
		}
	case 314:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1619
		{
			yyVAL.empty = struct{}{}
		}
	case 315:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1621
		{
			yyVAL.empty = struct{}{}
		}
	case 316:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1624
		{
			yyVAL.empty = struct{}{}
		}
	case 317:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1626
		{
			yyVAL.empty = struct{}{}
		}
	case 318:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1628
		{
			yyVAL.empty = struct{}{}
		}
	case 319:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1631
		{
			yyVAL.empty = struct{}{}
		}
	case 320:
		yyDollar = yyS[yypt-2 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1633
		{
			yyVAL.empty = struct{}{}
		}
	case 321:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1637
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 322:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1641
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 324:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1648
		{
			yyVAL.colIdent = NewColIdent(string(yyDollar[1].bytes))
		}
	case 325:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1654
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 326:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1658
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 328:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1665
		{
			yyVAL.tableIdent = NewTableIdent(string(yyDollar[1].bytes))
		}
	case 434:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1795
		{
			if incNesting(yylex) {
				yylex.Error("max nesting level reached")
				return 1
			}
		}
	case 435:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1804
		{
			decNesting(yylex)
		}
	case 436:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1809
		{
			forceEOF(yylex)
		}
	case 437:
		yyDollar = yyS[yypt-0 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1814
		{
			forceEOF(yylex)
		}
	case 438:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1818
		{
			forceEOF(yylex)
		}
	case 439:
		yyDollar = yyS[yypt-1 : yypt+1]
		//line ./go/vt/sqlparser/sql.y:1822
		{
			forceEOF(yylex)
		}
	}
	goto yystack /* stack new state and value */
}
