<div class="row">
  <div class="col-md-4">
    <h2><i class="fa fa-cubes"></i>&nbsp;Scalability</h2>
    <p class="desc">Vitess combines many important MySQL features with the scalability of a NoSQL database. Its built-in sharding features let you grow your database without adding sharding logic to your application.</p>
<!--<p><a class="btn btn-default" href="/user-guide/sharding.html">View details</a></p>-->
  </div>
  <div class="col-md-4">
    <h2><i class="fa fa-fighter-jet"></i>&nbsp;Performance</h2>
    <p class="desc">Vitess automatically rewrites queries that hurt database performance. It also uses caching mechanisms to mediate queries and prevent duplicate queries from simultaneously reaching your database.</p>
  </div>
  <div class="col-md-4">
    <h2><i class="fa fa-dashboard"></i>&nbsp;Manageability</h2>
    <p class="desc">Vitess automatically handles functions like master failovers and backups. It uses a lock server to track and administer servers, letting your application be blissfully ignorant of database topology.</p>
  </div>
</div>
<div class="row">
  <div class="col-md-4">
    <h2><i class="fa fa-share-alt"></i>&nbsp;Connection pooling</h2>
    <p class="desc">Vitess eliminates the high-memory overhead of MySQL connections. Its gRPC-based protocol lets Vitess servers easily handle thousands of connections at once.</p>
<!--<p><a class="btn btn-default" href="/user-guide/sharding.html">View details</a></p>-->
  </div>
  <div class="col-md-4">
    <h2><i class="fa fa-object-ungroup"></i>&nbsp;Shard Management</h2>
    <p class="desc">MySQL doesn't natively support sharding, but you will likely need it as your database grows. Vitess saves you from having to add sharding logic to your app and also enables live resharding with minimal read-only downtime.</p>
  </div>
  <div class="col-md-4">
    <h2><i class="fa fa-magic"></i>&nbsp;Workflow</h2>
    <p class="desc">Vitess keeps track of all of the metadata about your cluster configuration so that the cluster view is always up-to-date and consistent for different clients.</p>
  </div>
</div>

<!--
## Contact

Ask questions in the
[vitess@googlegroups.com](https://groups.google.com/forum/#!forum/vitess)
discussion forum.

Subscribe to
[vitess-announce@googlegroups.com](https://groups.google.com/forum/#!forum/vitess-announce)
for low-frequency updates like new features and releases.
-->
