---
id: otelfiber-example
---

# Example

An HTTP server using gofiber fiber and instrumentation. The server has a
`/users/:id` endpoint. The server generates span information to
`stdout`.

These instructions expect you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `fiber-server` and `fiber-client` services to run the
example:

```sh
docker-compose up --detach fiber-server fiber-client
```

The `fiber-client` service sends just one HTTP request to `fiber-server`
and then exits. View the span generated by `fiber-server` in the logs:

```sh
docker-compose logs fiber-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
