import { global as globalThis } from '@storybook/global';

const COLORS = [
  { name: 'red', value: '#FB001D' },
  { name: 'orange', value: '#FB8118' },
  { name: 'yellow', value: '#FCFF0C' },
  { name: 'green', value: '#1AB408' },
  { name: 'blue', value: '#0F0084' },
  { name: 'purple', value: '#620073' },
];

export default {
  component: globalThis.Components.Button,
  args: {
    label: 'Click Me!',
  },
  parameters: {
    backgrounds: {
      values: COLORS,
    },
    chromatic: { disable: true },
  },
};

export const Basic = {
  parameters: {},
};

export const Default = {
  parameters: {
    backgrounds: {
      default: COLORS[0].name,
    },
  },
};

export const StorySpecific = {
  parameters: {
    backgrounds: {
      default: 'white',
      values: [
        { name: 'white', value: '#F9F5F1' },
        { name: 'pink', value: '#F99CB4' },
        { name: 'teal', value: '#67CDE8' },
        { name: 'brown', value: '#4D2C10' },
        { name: 'black', value: '#000400' },
      ],
    },
  },
};

export const Gradient = {
  parameters: {
    backgrounds: {
      default: 'gradient',
      values: [
        {
          name: 'gradient',
          value: 'linear-gradient(90deg, #CA005E 0%, #863783 50%, #112396)',
        },
      ],
    },
  },
};

const img =
  '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';

export const Image = {
  parameters: {
    backgrounds: {
      default: 'component-driven',
      values: [
        {
          name: 'component-driven',
          value: `#000 center / cover no-repeat url(data:image/svg+xml;base64,${img})`,
        },
      ],
    },
  },
};

export const Disabled = {
  parameters: {
    backgrounds: { disable: true },
  },
};
