/**
 * This data originates from the storiesHash state in Storybook. Grab it from the Manager node
 * using React DevTools by assigning it to a global variable, then use the following script to
 * remove the parameters, otherwise you'll end up with a huge file:
 *
 * JSON.stringify(
 *   Object.values($reactTemp1)
 *     .reduce((acc, {parameters, ...node}) => {
 *       acc[node.id] = node;
 *       return acc;
 *     }, {}), null, 2)
 */

import type { Dataset } from './types';

// @ts-expect-error (TODO)
export const index = {
  images: {
    name: 'Images',
    id: 'images',
    depth: 0,
    children: [
      'images--marketing-hero',
      'images--brand',
      'images--colored-icons',
      'images--logos',
      'images--shapes',
      'images--thumbnails',
      'images--payment',
    ],
    type: 'component',
  },
  'images--marketing-hero': {
    id: 'images--marketing-hero',
    title: 'Images',
    name: 'marketing hero',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--brand': {
    id: 'images--brand',
    title: 'Images',
    name: 'brand',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--colored-icons': {
    id: 'images--colored-icons',
    title: 'Images',
    name: 'colored icons',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--logos': {
    id: 'images--logos',
    title: 'Images',
    name: 'logos',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--shapes': {
    id: 'images--shapes',
    title: 'Images',
    name: 'shapes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--thumbnails': {
    id: 'images--thumbnails',
    title: 'Images',
    name: 'thumbnails',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  'images--payment': {
    id: 'images--payment',
    title: 'Images',
    name: 'payment',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 1,
    parent: 'images',
    type: 'story',
    prepared: true,
  },
  emails: {
    name: 'Emails',
    id: 'emails',
    depth: 0,
    children: [
      'emails-introduction',
      'emails-buildnotification',
      'emails-commentnotification',
      'emails-paymentnotification',
      'emails-reviewnotification',
      'emails-snapshotnotification',
    ],
    type: 'root',
  },
  'emails-introduction': {
    id: 'emails-introduction',
    title: 'Emails',
    name: 'Introduction',
    importPath: './path.js',
    parent: 'emails',
    depth: 1,
    type: 'docs',
  },
  'emails-buildnotification': {
    name: 'BuildNotification',
    id: 'emails-buildnotification',
    parent: 'emails',
    depth: 1,
    children: [
      'emails-buildnotification--with-changes',
      'emails-buildnotification--without-email',
      'emails-buildnotification--with-error',
    ],
    type: 'component',
  },
  'emails-buildnotification--with-changes': {
    id: 'emails-buildnotification--with-changes',
    title: 'Emails/BuildNotification',
    name: 'with changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-buildnotification',
    type: 'story',
    prepared: true,
  },
  'emails-buildnotification--without-email': {
    id: 'emails-buildnotification--without-email',
    title: 'Emails/BuildNotification',
    name: 'without email',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-buildnotification',
    type: 'story',
    prepared: true,
  },
  'emails-buildnotification--with-error': {
    id: 'emails-buildnotification--with-error',
    title: 'Emails/BuildNotification',
    name: 'with error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-buildnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification': {
    name: 'CommentNotification',
    id: 'emails-commentnotification',
    parent: 'emails',
    depth: 1,
    children: [
      'emails-commentnotification--new-discussion',
      'emails-commentnotification--new-discussion-no-diff',
      'emails-commentnotification--new-discussion-no-snapshot',
      'emails-commentnotification--new-discussion-no-pr',
      'emails-commentnotification--new-reply',
      'emails-commentnotification--resolution',
    ],
    type: 'component',
  },
  'emails-commentnotification--new-discussion': {
    id: 'emails-commentnotification--new-discussion',
    title: 'Emails/CommentNotification',
    name: 'new discussion',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification--new-discussion-no-diff': {
    id: 'emails-commentnotification--new-discussion-no-diff',
    title: 'Emails/CommentNotification',
    name: 'new discussion, no diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification--new-discussion-no-snapshot': {
    id: 'emails-commentnotification--new-discussion-no-snapshot',
    title: 'Emails/CommentNotification',
    name: 'new discussion, no snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification--new-discussion-no-pr': {
    id: 'emails-commentnotification--new-discussion-no-pr',
    title: 'Emails/CommentNotification',
    name: 'new discussion, no PR',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification--new-reply': {
    id: 'emails-commentnotification--new-reply',
    title: 'Emails/CommentNotification',
    name: 'new reply',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-commentnotification--resolution': {
    id: 'emails-commentnotification--resolution',
    title: 'Emails/CommentNotification',
    name: 'resolution',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-commentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-paymentnotification': {
    name: 'PaymentNotification',
    id: 'emails-paymentnotification',
    parent: 'emails',
    depth: 1,
    children: [
      'emails-paymentnotification--trial-ending',
      'emails-paymentnotification--trial-ended',
      'emails-paymentnotification--payment-failed',
      'emails-paymentnotification--payment-due',
    ],
    type: 'component',
  },
  'emails-paymentnotification--trial-ending': {
    id: 'emails-paymentnotification--trial-ending',
    title: 'Emails/PaymentNotification',
    name: 'trial ending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-paymentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-paymentnotification--trial-ended': {
    id: 'emails-paymentnotification--trial-ended',
    title: 'Emails/PaymentNotification',
    name: 'trial ended',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-paymentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-paymentnotification--payment-failed': {
    id: 'emails-paymentnotification--payment-failed',
    title: 'Emails/PaymentNotification',
    name: 'payment failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-paymentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-paymentnotification--payment-due': {
    id: 'emails-paymentnotification--payment-due',
    title: 'Emails/PaymentNotification',
    name: 'payment due',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-paymentnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification': {
    name: 'ReviewNotification',
    id: 'emails-reviewnotification',
    parent: 'emails',
    depth: 1,
    children: [
      'emails-reviewnotification--approval',
      'emails-reviewnotification--approval-with-pending-reviews',
      'emails-reviewnotification--approval-with-pending-review',
      'emails-reviewnotification--approval-git-lab',
      'emails-reviewnotification--requesting-review',
      'emails-reviewnotification--requesting-review-small-diff-count',
      'emails-reviewnotification--requesting-review-with-errors',
      'emails-reviewnotification--requesting-review-only-errors',
    ],
    type: 'component',
  },
  'emails-reviewnotification--approval': {
    id: 'emails-reviewnotification--approval',
    title: 'Emails/ReviewNotification',
    name: 'Approval',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--approval-with-pending-reviews': {
    id: 'emails-reviewnotification--approval-with-pending-reviews',
    title: 'Emails/ReviewNotification',
    name: 'Approval, With Pending Reviews',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--approval-with-pending-review': {
    id: 'emails-reviewnotification--approval-with-pending-review',
    title: 'Emails/ReviewNotification',
    name: 'Approval, With Single Pending Review',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--approval-git-lab': {
    id: 'emails-reviewnotification--approval-git-lab',
    title: 'Emails/ReviewNotification',
    name: 'Approval, GitLab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--requesting-review': {
    id: 'emails-reviewnotification--requesting-review',
    title: 'Emails/ReviewNotification',
    name: 'Requesting Review',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--requesting-review-small-diff-count': {
    id: 'emails-reviewnotification--requesting-review-small-diff-count',
    title: 'Emails/ReviewNotification',
    name: 'Requesting Review, Small Diff Count',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--requesting-review-with-errors': {
    id: 'emails-reviewnotification--requesting-review-with-errors',
    title: 'Emails/ReviewNotification',
    name: 'Requesting Review, With Errored Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-reviewnotification--requesting-review-only-errors': {
    id: 'emails-reviewnotification--requesting-review-only-errors',
    title: 'Emails/ReviewNotification',
    name: 'Requesting Review, Only Errored Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-reviewnotification',
    type: 'story',
    prepared: true,
  },
  'emails-snapshotnotification': {
    name: 'SnapshotNotification',
    id: 'emails-snapshotnotification',
    parent: 'emails',
    depth: 1,
    children: [
      'emails-snapshotnotification--ninety-percent',
      'emails-snapshotnotification--limit-reached',
    ],
    type: 'component',
  },
  'emails-snapshotnotification--ninety-percent': {
    id: 'emails-snapshotnotification--ninety-percent',
    title: 'Emails/SnapshotNotification',
    name: 'Ninety Percent',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-snapshotnotification',
    type: 'story',
    prepared: true,
  },
  'emails-snapshotnotification--limit-reached': {
    id: 'emails-snapshotnotification--limit-reached',
    title: 'Emails/SnapshotNotification',
    name: 'Limit Reached',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'emails-snapshotnotification',
    type: 'story',
    prepared: true,
  },
  tooltip: {
    name: 'tooltip',
    id: 'tooltip',
    depth: 0,
    children: ['tooltip-tooltipbuildlist', 'tooltip-tooltipselect'],
    type: 'root',
  },
  'tooltip-tooltipbuildlist': {
    name: 'TooltipBuildList',
    id: 'tooltip-tooltipbuildlist',
    parent: 'tooltip',
    depth: 1,
    children: ['tooltip-tooltipbuildlist--default', 'tooltip-tooltipbuildlist--no-commit'],
    type: 'component',
  },
  'tooltip-tooltipbuildlist--default': {
    id: 'tooltip-tooltipbuildlist--default',
    title: 'tooltip/TooltipBuildList',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'tooltip-tooltipbuildlist',
    type: 'story',
    prepared: true,
  },
  'tooltip-tooltipbuildlist--no-commit': {
    id: 'tooltip-tooltipbuildlist--no-commit',
    title: 'tooltip/TooltipBuildList',
    name: 'no commit',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'tooltip-tooltipbuildlist',
    type: 'story',
    prepared: true,
  },
  'tooltip-tooltipselect': {
    name: 'TooltipSelect',
    id: 'tooltip-tooltipselect',
    parent: 'tooltip',
    depth: 1,
    children: ['tooltip-tooltipselect--default'],
    type: 'component',
  },
  'tooltip-tooltipselect--default': {
    id: 'tooltip-tooltipselect--default',
    title: 'tooltip/TooltipSelect',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'tooltip-tooltipselect',
    type: 'story',
    prepared: true,
  },
  'webapp-components': {
    name: 'Webapp components',
    id: 'webapp-components',
    depth: 0,
    children: [
      'webapp-components-accountmenu',
      'webapp-components-activityitem',
      'webapp-components-activitylist',
      'webapp-components-appowneritem',
      'webapp-components-appownerlist',
      'webapp-components-aspectratiopreserver',
      'webapp-components-asynctextaction',
      'webapp-components-badgecount',
      'webapp-components-banner',
      'webapp-components-baselinehistory',
      'webapp-components-billingplans',
      'webapp-components-branchpicker',
      'webapp-components-breadcrumb',
      'webapp-components-buildcomponentlist',
      'webapp-components-builditem',
      'webapp-components-buildlist',
      'webapp-components-buildstatuslight',
      'webapp-components-button',
      'webapp-components-buttonmulti',
      'webapp-components-buttontoggle',
      'webapp-components-canvas',
      'webapp-components-cardinal',
      'webapp-components-checkbox',
      'webapp-components-cieyebrow',
      'webapp-components-clipboard',
      'webapp-components-clipboardcode',
      'webapp-components-clipboardicon',
      'webapp-components-clipboardinput',
      'webapp-components-comment',
      'webapp-components-componentbranchlist',
      'webapp-components-componentbuildlist',
      'webapp-components-componentbuildspicker',
      'webapp-components-componentitem',
      'webapp-components-componentlist',
      'webapp-components-componentrepresentationimage',
      'webapp-components-creditcardform',
      'webapp-components-dateformatter',
      'webapp-components-diffimage',
      'webapp-components-difftoggles',
      'webapp-components-emptymessage',
      'webapp-components-eyebrow',
      'webapp-components-eyebrowonboarding',
      'webapp-components-flexcenter',
      'webapp-components-form',
      'webapp-components-header',
      'webapp-components-heading',
      'webapp-components-ignoredregions',
      'webapp-components-imagetile',
      'webapp-components-interstitial',
      'webapp-components-inviteeyebrow',
      'webapp-components-isactiveelement',
      'webapp-components-isolatorframe',
      'webapp-components-linklist',
      'webapp-components-linktabs',
      'webapp-components-listheading',
      'webapp-components-liveview',
      'webapp-components-mailinglistsubscribeform',
      'webapp-components-newappform',
      'webapp-components-notifications',
      'webapp-components-pageheader',
      'webapp-components-pagetitlebar',
      'webapp-components-pagination',
      'webapp-components-paymentcollectcta',
      'webapp-components-paymentcollectmodal',
      'webapp-components-paymenteyebrow',
      'webapp-components-progressbar',
      'webapp-components-projectitem',
      'webapp-components-projectlist',
      'webapp-components-pullrequestitem',
      'webapp-components-pullrequestlist',
      'webapp-components-pullrequeststatuslight',
      'webapp-components-questiontooltip',
      'webapp-components-radar',
      'webapp-components-radio',
      'webapp-components-rawspeclist',
      'webapp-components-repositoryitem',
      'webapp-components-repositorylist',
      'webapp-components-repositoryowneritem',
      'webapp-components-repositoryownerlist',
      'webapp-components-repositorypicker',
      'webapp-components-scrollintoview',
      'webapp-components-section',
      'webapp-components-sharetooltipmessage',
      'webapp-components-sidebarnav',
      'webapp-components-snapshoterror',
      'webapp-components-snapshoterrormessage',
      'webapp-components-snapshotsizechanged',
      'webapp-components-specitem',
      'webapp-components-speclist',
      'webapp-components-specname',
      'webapp-components-startchat',
      'webapp-components-statuslight',
      'webapp-components-statustooltip',
      'webapp-components-subheader',
      'webapp-components-table',
      'webapp-components-tabledrawer',
      'webapp-components-tooltipignore',
      'webapp-components-useritem',
      'webapp-components-userlist',
      'webapp-components-video',
      'webapp-components-warning',
      'webapp-components-wobbler',
    ],
    type: 'root',
  },
  'webapp-components-accountmenu': {
    name: 'AccountMenu',
    id: 'webapp-components-accountmenu',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-accountmenu--default',
      'webapp-components-accountmenu--saml-user',
    ],
    type: 'component',
  },
  'webapp-components-accountmenu--default': {
    id: 'webapp-components-accountmenu--default',
    title: 'Webapp components/AccountMenu',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-accountmenu',
    type: 'story',
    prepared: true,
  },
  'webapp-components-accountmenu--saml-user': {
    id: 'webapp-components-accountmenu--saml-user',
    title: 'Webapp components/AccountMenu',
    name: 'saml user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-accountmenu',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem': {
    name: 'ActivityItem',
    id: 'webapp-components-activityitem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-activityitem--all-activity-item',
      'webapp-components-activityitem--loading',
      'webapp-components-activityitem--passed',
      'webapp-components-activityitem--failed',
      'webapp-components-activityitem--unreviewed',
      'webapp-components-activityitem--in-progress',
      'webapp-components-activityitem--from-agent-passed',
      'webapp-components-activityitem--timed-out',
      'webapp-components-activityitem--errored',
      'webapp-components-activityitem--no-account-name',
      'webapp-components-activityitem--long-account-name',
    ],
    type: 'component',
  },
  'webapp-components-activityitem--all-activity-item': {
    id: 'webapp-components-activityitem--all-activity-item',
    title: 'Webapp components/ActivityItem',
    name: 'All ActivityItem',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--loading': {
    id: 'webapp-components-activityitem--loading',
    title: 'Webapp components/ActivityItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--passed': {
    id: 'webapp-components-activityitem--passed',
    title: 'Webapp components/ActivityItem',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--failed': {
    id: 'webapp-components-activityitem--failed',
    title: 'Webapp components/ActivityItem',
    name: 'Failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--unreviewed': {
    id: 'webapp-components-activityitem--unreviewed',
    title: 'Webapp components/ActivityItem',
    name: 'Unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--in-progress': {
    id: 'webapp-components-activityitem--in-progress',
    title: 'Webapp components/ActivityItem',
    name: 'In progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--from-agent-passed': {
    id: 'webapp-components-activityitem--from-agent-passed',
    title: 'Webapp components/ActivityItem',
    name: 'From agent, passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--timed-out': {
    id: 'webapp-components-activityitem--timed-out',
    title: 'Webapp components/ActivityItem',
    name: 'Timed out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--errored': {
    id: 'webapp-components-activityitem--errored',
    title: 'Webapp components/ActivityItem',
    name: 'Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--no-account-name': {
    id: 'webapp-components-activityitem--no-account-name',
    title: 'Webapp components/ActivityItem',
    name: 'no account name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activityitem--long-account-name': {
    id: 'webapp-components-activityitem--long-account-name',
    title: 'Webapp components/ActivityItem',
    name: 'long account name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activitylist': {
    name: 'ActivityList',
    id: 'webapp-components-activitylist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-activitylist--loading',
      'webapp-components-activitylist--full',
      'webapp-components-activitylist--full-no-account-name',
      'webapp-components-activitylist--empty',
    ],
    type: 'component',
  },
  'webapp-components-activitylist--loading': {
    id: 'webapp-components-activitylist--loading',
    title: 'Webapp components/ActivityList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activitylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activitylist--full': {
    id: 'webapp-components-activitylist--full',
    title: 'Webapp components/ActivityList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activitylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activitylist--full-no-account-name': {
    id: 'webapp-components-activitylist--full-no-account-name',
    title: 'Webapp components/ActivityList',
    name: 'full, no account name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activitylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-activitylist--empty': {
    id: 'webapp-components-activitylist--empty',
    title: 'Webapp components/ActivityList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-activitylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem': {
    name: 'AppOwnerItem',
    id: 'webapp-components-appowneritem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-appowneritem--user',
      'webapp-components-appowneritem--user-active',
      'webapp-components-appowneritem--org',
      'webapp-components-appowneritem--org-active',
      'webapp-components-appowneritem--org-no-avatar',
      'webapp-components-appowneritem--org-no-avatar-active',
      'webapp-components-appowneritem--shared-with-you',
      'webapp-components-appowneritem--shared-with-you-active',
    ],
    type: 'component',
  },
  'webapp-components-appowneritem--user': {
    id: 'webapp-components-appowneritem--user',
    title: 'Webapp components/AppOwnerItem',
    name: 'user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--user-active': {
    id: 'webapp-components-appowneritem--user-active',
    title: 'Webapp components/AppOwnerItem',
    name: 'user, active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--org': {
    id: 'webapp-components-appowneritem--org',
    title: 'Webapp components/AppOwnerItem',
    name: 'org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--org-active': {
    id: 'webapp-components-appowneritem--org-active',
    title: 'Webapp components/AppOwnerItem',
    name: 'org, active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--org-no-avatar': {
    id: 'webapp-components-appowneritem--org-no-avatar',
    title: 'Webapp components/AppOwnerItem',
    name: 'org no avatar, ',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--org-no-avatar-active': {
    id: 'webapp-components-appowneritem--org-no-avatar-active',
    title: 'Webapp components/AppOwnerItem',
    name: 'org no avatar, active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--shared-with-you': {
    id: 'webapp-components-appowneritem--shared-with-you',
    title: 'Webapp components/AppOwnerItem',
    name: 'shared with you',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appowneritem--shared-with-you-active': {
    id: 'webapp-components-appowneritem--shared-with-you-active',
    title: 'Webapp components/AppOwnerItem',
    name: 'shared with you, active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist': {
    name: 'AppOwnerList',
    id: 'webapp-components-appownerlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-appownerlist--user-selected',
      'webapp-components-appownerlist--shared-with-you-selected',
      'webapp-components-appownerlist--org-selected',
      'webapp-components-appownerlist--org-selected-saml',
      'webapp-components-appownerlist--org-selected-adding-pure',
      'webapp-components-appownerlist--org-selected-adding-pure-no-accounts',
      'webapp-components-appownerlist--org-selected-adding-pure-refreshing',
      'webapp-components-appownerlist--org-selected-adding-pure-bitbucket',
    ],
    type: 'component',
  },
  'webapp-components-appownerlist--user-selected': {
    id: 'webapp-components-appownerlist--user-selected',
    title: 'Webapp components/AppOwnerList',
    name: 'user selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--shared-with-you-selected': {
    id: 'webapp-components-appownerlist--shared-with-you-selected',
    title: 'Webapp components/AppOwnerList',
    name: 'sharedWithYou selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected': {
    id: 'webapp-components-appownerlist--org-selected',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected-saml': {
    id: 'webapp-components-appownerlist--org-selected-saml',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected, saml',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected-adding-pure': {
    id: 'webapp-components-appownerlist--org-selected-adding-pure',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected, adding (pure)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected-adding-pure-no-accounts': {
    id: 'webapp-components-appownerlist--org-selected-adding-pure-no-accounts',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected, adding (pure) no accounts',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected-adding-pure-refreshing': {
    id: 'webapp-components-appownerlist--org-selected-adding-pure-refreshing',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected, adding (pure), refreshing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-appownerlist--org-selected-adding-pure-bitbucket': {
    id: 'webapp-components-appownerlist--org-selected-adding-pure-bitbucket',
    title: 'Webapp components/AppOwnerList',
    name: 'org selected, adding (pure), bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-appownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-aspectratiopreserver': {
    name: 'AspectRatioPreserver',
    id: 'webapp-components-aspectratiopreserver',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-aspectratiopreserver--default'],
    type: 'component',
  },
  'webapp-components-aspectratiopreserver--default': {
    id: 'webapp-components-aspectratiopreserver--default',
    title: 'Webapp components/AspectRatioPreserver',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-aspectratiopreserver',
    type: 'story',
    prepared: true,
  },
  'webapp-components-asynctextaction': {
    name: 'AsyncTextAction',
    id: 'webapp-components-asynctextaction',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-asynctextaction--base',
      'webapp-components-asynctextaction--loading',
      'webapp-components-asynctextaction--loading-with-loading-message',
      'webapp-components-asynctextaction--loading-left-placement',
    ],
    type: 'component',
  },
  'webapp-components-asynctextaction--base': {
    id: 'webapp-components-asynctextaction--base',
    title: 'Webapp components/AsyncTextAction',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-asynctextaction',
    type: 'story',
    prepared: true,
  },
  'webapp-components-asynctextaction--loading': {
    id: 'webapp-components-asynctextaction--loading',
    title: 'Webapp components/AsyncTextAction',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-asynctextaction',
    type: 'story',
    prepared: true,
  },
  'webapp-components-asynctextaction--loading-with-loading-message': {
    id: 'webapp-components-asynctextaction--loading-with-loading-message',
    title: 'Webapp components/AsyncTextAction',
    name: 'Loading, With Loading Message',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-asynctextaction',
    type: 'story',
    prepared: true,
  },
  'webapp-components-asynctextaction--loading-left-placement': {
    id: 'webapp-components-asynctextaction--loading-left-placement',
    title: 'Webapp components/AsyncTextAction',
    name: 'Loading, Left Placement',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-asynctextaction',
    type: 'story',
    prepared: true,
  },
  'webapp-components-badgecount': {
    name: 'BadgeCount',
    id: 'webapp-components-badgecount',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-badgecount--all-badge-counts',
      'webapp-components-badgecount--positive',
      'webapp-components-badgecount--negative',
      'webapp-components-badgecount--warning',
    ],
    type: 'component',
  },
  'webapp-components-badgecount--all-badge-counts': {
    id: 'webapp-components-badgecount--all-badge-counts',
    title: 'Webapp components/BadgeCount',
    name: 'all badgeCounts',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-badgecount',
    type: 'story',
    prepared: true,
  },
  'webapp-components-badgecount--positive': {
    id: 'webapp-components-badgecount--positive',
    title: 'Webapp components/BadgeCount',
    name: 'positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-badgecount',
    type: 'story',
    prepared: true,
  },
  'webapp-components-badgecount--negative': {
    id: 'webapp-components-badgecount--negative',
    title: 'Webapp components/BadgeCount',
    name: 'negative',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-badgecount',
    type: 'story',
    prepared: true,
  },
  'webapp-components-badgecount--warning': {
    id: 'webapp-components-badgecount--warning',
    title: 'Webapp components/BadgeCount',
    name: 'warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-badgecount',
    type: 'story',
    prepared: true,
  },
  'webapp-components-banner': {
    name: 'Banner',
    id: 'webapp-components-banner',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-banner--base',
      'webapp-components-banner--positive',
      'webapp-components-banner--negative',
    ],
    type: 'component',
  },
  'webapp-components-banner--base': {
    id: 'webapp-components-banner--base',
    title: 'Webapp components/Banner',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-banner',
    type: 'story',
    prepared: true,
  },
  'webapp-components-banner--positive': {
    id: 'webapp-components-banner--positive',
    title: 'Webapp components/Banner',
    name: 'Positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-banner',
    type: 'story',
    prepared: true,
  },
  'webapp-components-banner--negative': {
    id: 'webapp-components-banner--negative',
    title: 'Webapp components/Banner',
    name: 'Negative',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-banner',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory': {
    name: 'BaselineHistory',
    id: 'webapp-components-baselinehistory',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-baselinehistory--loading',
      'webapp-components-baselinehistory--new-story',
      'webapp-components-baselinehistory--typical',
      'webapp-components-baselinehistory--baseline-was-accepted',
      'webapp-components-baselinehistory--second-build',
      'webapp-components-baselinehistory--third-build',
      'webapp-components-baselinehistory--most-recent-ancestor',
      'webapp-components-baselinehistory--in-tooltip-smaller',
    ],
    type: 'component',
  },
  'webapp-components-baselinehistory--loading': {
    id: 'webapp-components-baselinehistory--loading',
    title: 'Webapp components/BaselineHistory',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--new-story': {
    id: 'webapp-components-baselinehistory--new-story',
    title: 'Webapp components/BaselineHistory',
    name: 'new story',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--typical': {
    id: 'webapp-components-baselinehistory--typical',
    title: 'Webapp components/BaselineHistory',
    name: 'typical',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--baseline-was-accepted': {
    id: 'webapp-components-baselinehistory--baseline-was-accepted',
    title: 'Webapp components/BaselineHistory',
    name: 'baseline was accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--second-build': {
    id: 'webapp-components-baselinehistory--second-build',
    title: 'Webapp components/BaselineHistory',
    name: 'second build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--third-build': {
    id: 'webapp-components-baselinehistory--third-build',
    title: 'Webapp components/BaselineHistory',
    name: 'third build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--most-recent-ancestor': {
    id: 'webapp-components-baselinehistory--most-recent-ancestor',
    title: 'Webapp components/BaselineHistory',
    name: 'most recent ancestor',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-baselinehistory--in-tooltip-smaller': {
    id: 'webapp-components-baselinehistory--in-tooltip-smaller',
    title: 'Webapp components/BaselineHistory',
    name: 'inTooltip (smaller)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-baselinehistory',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans': {
    name: 'BillingPlans',
    id: 'webapp-components-billingplans',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-billingplans--is-subscribed',
      'webapp-components-billingplans--is-subscribed-changing-plan',
      'webapp-components-billingplans--free',
      'webapp-components-billingplans--trial',
      'webapp-components-billingplans--in-trial-plan-chosen',
      'webapp-components-billingplans--open-source-paying-for-plan',
      'webapp-components-billingplans--open-source-paying-for-plan-changing-plan',
      'webapp-components-billingplans--open-source-free-account',
      'webapp-components-billingplans--open-source-plan-chosen',
    ],
    type: 'component',
  },
  'webapp-components-billingplans--is-subscribed': {
    id: 'webapp-components-billingplans--is-subscribed',
    title: 'Webapp components/BillingPlans',
    name: 'is subscribed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--is-subscribed-changing-plan': {
    id: 'webapp-components-billingplans--is-subscribed-changing-plan',
    title: 'Webapp components/BillingPlans',
    name: 'is subscribed, changing plan',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--free': {
    id: 'webapp-components-billingplans--free',
    title: 'Webapp components/BillingPlans',
    name: 'Free',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--trial': {
    id: 'webapp-components-billingplans--trial',
    title: 'Webapp components/BillingPlans',
    name: 'trial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--in-trial-plan-chosen': {
    id: 'webapp-components-billingplans--in-trial-plan-chosen',
    title: 'Webapp components/BillingPlans',
    name: 'inTrial, plan chosen',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--open-source-paying-for-plan': {
    id: 'webapp-components-billingplans--open-source-paying-for-plan',
    title: 'Webapp components/BillingPlans',
    name: 'openSource, paying for plan',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--open-source-paying-for-plan-changing-plan': {
    id: 'webapp-components-billingplans--open-source-paying-for-plan-changing-plan',
    title: 'Webapp components/BillingPlans',
    name: 'openSource, paying for plan, changing plan',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--open-source-free-account': {
    id: 'webapp-components-billingplans--open-source-free-account',
    title: 'Webapp components/BillingPlans',
    name: 'openSource, free account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-billingplans--open-source-plan-chosen': {
    id: 'webapp-components-billingplans--open-source-plan-chosen',
    title: 'Webapp components/BillingPlans',
    name: 'openSource, plan chosen',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-billingplans',
    type: 'story',
    prepared: true,
  },
  'webapp-components-branchpicker': {
    name: 'BranchPicker',
    id: 'webapp-components-branchpicker',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-branchpicker--default'],
    type: 'component',
  },
  'webapp-components-branchpicker--default': {
    id: 'webapp-components-branchpicker--default',
    title: 'Webapp components/BranchPicker',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-branchpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-breadcrumb': {
    name: 'Breadcrumb',
    id: 'webapp-components-breadcrumb',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-breadcrumb--loading',
      'webapp-components-breadcrumb--root',
      'webapp-components-breadcrumb--many-breadcrumbs',
    ],
    type: 'component',
  },
  'webapp-components-breadcrumb--loading': {
    id: 'webapp-components-breadcrumb--loading',
    title: 'Webapp components/Breadcrumb',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-breadcrumb',
    type: 'story',
    prepared: true,
  },
  'webapp-components-breadcrumb--root': {
    id: 'webapp-components-breadcrumb--root',
    title: 'Webapp components/Breadcrumb',
    name: 'root',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-breadcrumb',
    type: 'story',
    prepared: true,
  },
  'webapp-components-breadcrumb--many-breadcrumbs': {
    id: 'webapp-components-breadcrumb--many-breadcrumbs',
    title: 'Webapp components/Breadcrumb',
    name: 'many breadcrumbs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-breadcrumb',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist': {
    name: 'BuildComponentList',
    id: 'webapp-components-buildcomponentlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-buildcomponentlist-buildcomponentlist',
      'webapp-components-buildcomponentlist-buildcomponentlistheader',
      'webapp-components-buildcomponentlist-groupitem',
      'webapp-components-buildcomponentlist-polymorphiclist',
      'webapp-components-buildcomponentlist-rootitem',
    ],
    type: 'group',
  },
  'webapp-components-buildcomponentlist-buildcomponentlist': {
    name: 'BuildComponentList',
    id: 'webapp-components-buildcomponentlist-buildcomponentlist',
    parent: 'webapp-components-buildcomponentlist',
    depth: 2,
    children: [
      'webapp-components-buildcomponentlist-buildcomponentlist--loading',
      'webapp-components-buildcomponentlist-buildcomponentlist--full',
      'webapp-components-buildcomponentlist-buildcomponentlist--full-prefixed',
      'webapp-components-buildcomponentlist-buildcomponentlist--empty',
      'webapp-components-buildcomponentlist-buildcomponentlist--filtering-results',
      'webapp-components-buildcomponentlist-buildcomponentlist--filtering-no-results',
    ],
    type: 'component',
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--loading': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--loading',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--full': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--full',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--full-prefixed': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--full-prefixed',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'full, prefixed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--empty': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--empty',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--filtering-results': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--filtering-results',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'filtering, results',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlist--filtering-no-results': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlist--filtering-no-results',
    title: 'Webapp components/BuildComponentList/BuildComponentList',
    name: 'filtering, no results',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader': {
    name: 'BuildComponentListHeader',
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    parent: 'webapp-components-buildcomponentlist',
    depth: 2,
    children: [
      'webapp-components-buildcomponentlist-buildcomponentlistheader--loading',
      'webapp-components-buildcomponentlist-buildcomponentlistheader--default',
      'webapp-components-buildcomponentlist-buildcomponentlistheader--with-actions',
      'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching',
      'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching-no-results',
      'webapp-components-buildcomponentlist-buildcomponentlistheader--navigating-with-breadcrumb',
    ],
    type: 'component',
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--loading': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--loading',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--default': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--default',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--with-actions': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--with-actions',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'with actions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'isSearching',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching-no-results': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--is-searching-no-results',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'isSearching no results',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-buildcomponentlistheader--navigating-with-breadcrumb': {
    id: 'webapp-components-buildcomponentlist-buildcomponentlistheader--navigating-with-breadcrumb',
    title: 'Webapp components/BuildComponentList/BuildComponentListHeader',
    name: 'navigating with breadcrumb',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-buildcomponentlistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem': {
    name: 'GroupItem',
    id: 'webapp-components-buildcomponentlist-groupitem',
    parent: 'webapp-components-buildcomponentlist',
    depth: 2,
    children: [
      'webapp-components-buildcomponentlist-groupitem--all',
      'webapp-components-buildcomponentlist-groupitem--loading',
      'webapp-components-buildcomponentlist-groupitem--empty',
      'webapp-components-buildcomponentlist-groupitem--single',
      'webapp-components-buildcomponentlist-groupitem--fewer',
      'webapp-components-buildcomponentlist-groupitem--full',
      'webapp-components-buildcomponentlist-groupitem--full-snapshotting',
      'webapp-components-buildcomponentlist-groupitem--full-errored',
      'webapp-components-buildcomponentlist-groupitem--complex',
    ],
    type: 'component',
  },
  'webapp-components-buildcomponentlist-groupitem--all': {
    id: 'webapp-components-buildcomponentlist-groupitem--all',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'all',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--loading': {
    id: 'webapp-components-buildcomponentlist-groupitem--loading',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--empty': {
    id: 'webapp-components-buildcomponentlist-groupitem--empty',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--single': {
    id: 'webapp-components-buildcomponentlist-groupitem--single',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'single',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--fewer': {
    id: 'webapp-components-buildcomponentlist-groupitem--fewer',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'fewer',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--full': {
    id: 'webapp-components-buildcomponentlist-groupitem--full',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--full-snapshotting': {
    id: 'webapp-components-buildcomponentlist-groupitem--full-snapshotting',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'full snapshotting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--full-errored': {
    id: 'webapp-components-buildcomponentlist-groupitem--full-errored',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'full errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-groupitem--complex': {
    id: 'webapp-components-buildcomponentlist-groupitem--complex',
    title: 'Webapp components/BuildComponentList/GroupItem',
    name: 'complex',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-groupitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-polymorphiclist': {
    name: 'PolymorphicList',
    id: 'webapp-components-buildcomponentlist-polymorphiclist',
    parent: 'webapp-components-buildcomponentlist',
    depth: 2,
    children: [
      'webapp-components-buildcomponentlist-polymorphiclist--default',
      'webapp-components-buildcomponentlist-polymorphiclist--complex',
      'webapp-components-buildcomponentlist-polymorphiclist--loading',
    ],
    type: 'component',
  },
  'webapp-components-buildcomponentlist-polymorphiclist--default': {
    id: 'webapp-components-buildcomponentlist-polymorphiclist--default',
    title: 'Webapp components/BuildComponentList/PolymorphicList',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-polymorphiclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-polymorphiclist--complex': {
    id: 'webapp-components-buildcomponentlist-polymorphiclist--complex',
    title: 'Webapp components/BuildComponentList/PolymorphicList',
    name: 'complex',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-polymorphiclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-polymorphiclist--loading': {
    id: 'webapp-components-buildcomponentlist-polymorphiclist--loading',
    title: 'Webapp components/BuildComponentList/PolymorphicList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-polymorphiclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-rootitem': {
    name: 'RootItem',
    id: 'webapp-components-buildcomponentlist-rootitem',
    parent: 'webapp-components-buildcomponentlist',
    depth: 2,
    children: [
      'webapp-components-buildcomponentlist-rootitem--default',
      'webapp-components-buildcomponentlist-rootitem--complex',
    ],
    type: 'component',
  },
  'webapp-components-buildcomponentlist-rootitem--default': {
    id: 'webapp-components-buildcomponentlist-rootitem--default',
    title: 'Webapp components/BuildComponentList/RootItem',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-rootitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildcomponentlist-rootitem--complex': {
    id: 'webapp-components-buildcomponentlist-rootitem--complex',
    title: 'Webapp components/BuildComponentList/RootItem',
    name: 'complex',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-buildcomponentlist-rootitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem': {
    name: 'BuildItem',
    id: 'webapp-components-builditem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-builditem--all-build-item',
      'webapp-components-builditem--loading',
      'webapp-components-builditem--passed',
      'webapp-components-builditem--failed',
      'webapp-components-builditem--unreviewed',
      'webapp-components-builditem--in-progress',
      'webapp-components-builditem--from-agent-passed',
      'webapp-components-builditem--timed-out',
      'webapp-components-builditem--errored',
      'webapp-components-builditem--publish-only',
      'webapp-components-builditem--upgrade',
    ],
    type: 'component',
  },
  'webapp-components-builditem--all-build-item': {
    id: 'webapp-components-builditem--all-build-item',
    title: 'Webapp components/BuildItem',
    name: 'All BuildItem',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--loading': {
    id: 'webapp-components-builditem--loading',
    title: 'Webapp components/BuildItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--passed': {
    id: 'webapp-components-builditem--passed',
    title: 'Webapp components/BuildItem',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--failed': {
    id: 'webapp-components-builditem--failed',
    title: 'Webapp components/BuildItem',
    name: 'Failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--unreviewed': {
    id: 'webapp-components-builditem--unreviewed',
    title: 'Webapp components/BuildItem',
    name: 'Unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--in-progress': {
    id: 'webapp-components-builditem--in-progress',
    title: 'Webapp components/BuildItem',
    name: 'In progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--from-agent-passed': {
    id: 'webapp-components-builditem--from-agent-passed',
    title: 'Webapp components/BuildItem',
    name: 'From agent, passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--timed-out': {
    id: 'webapp-components-builditem--timed-out',
    title: 'Webapp components/BuildItem',
    name: 'Timed out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--errored': {
    id: 'webapp-components-builditem--errored',
    title: 'Webapp components/BuildItem',
    name: 'Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--publish-only': {
    id: 'webapp-components-builditem--publish-only',
    title: 'Webapp components/BuildItem',
    name: 'Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-builditem--upgrade': {
    id: 'webapp-components-builditem--upgrade',
    title: 'Webapp components/BuildItem',
    name: 'Upgrade',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-builditem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildlist': {
    name: 'BuildList',
    id: 'webapp-components-buildlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-buildlist--loading',
      'webapp-components-buildlist--full',
      'webapp-components-buildlist--has-next-page',
      'webapp-components-buildlist--empty',
      'webapp-components-buildlist--error',
    ],
    type: 'component',
  },
  'webapp-components-buildlist--loading': {
    id: 'webapp-components-buildlist--loading',
    title: 'Webapp components/BuildList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildlist--full': {
    id: 'webapp-components-buildlist--full',
    title: 'Webapp components/BuildList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildlist--has-next-page': {
    id: 'webapp-components-buildlist--has-next-page',
    title: 'Webapp components/BuildList',
    name: 'has next page',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildlist--empty': {
    id: 'webapp-components-buildlist--empty',
    title: 'Webapp components/BuildList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildlist--error': {
    id: 'webapp-components-buildlist--error',
    title: 'Webapp components/BuildList',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight': {
    name: 'BuildStatusLight',
    id: 'webapp-components-buildstatuslight',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-buildstatuslight--loading',
      'webapp-components-buildstatuslight--in-progress',
      'webapp-components-buildstatuslight--in-progress-rep-only',
      'webapp-components-buildstatuslight--in-progress-rep-only-limited',
      'webapp-components-buildstatuslight--pending',
      'webapp-components-buildstatuslight--passed-limited',
      'webapp-components-buildstatuslight--passed',
      'webapp-components-buildstatuslight--denied',
      'webapp-components-buildstatuslight--accepted',
      'webapp-components-buildstatuslight--timed-out',
      'webapp-components-buildstatuslight--timed-out-rep-only',
      'webapp-components-buildstatuslight--timed-out-rep-only-limited',
      'webapp-components-buildstatuslight--build-error',
      'webapp-components-buildstatuslight--build-error-rep-only',
      'webapp-components-buildstatuslight--build-error-rep-only-limited',
    ],
    type: 'component',
  },
  'webapp-components-buildstatuslight--loading': {
    id: 'webapp-components-buildstatuslight--loading',
    title: 'Webapp components/BuildStatusLight',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--in-progress': {
    id: 'webapp-components-buildstatuslight--in-progress',
    title: 'Webapp components/BuildStatusLight',
    name: 'In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--in-progress-rep-only': {
    id: 'webapp-components-buildstatuslight--in-progress-rep-only',
    title: 'Webapp components/BuildStatusLight',
    name: 'In Progress, Representative Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--in-progress-rep-only-limited': {
    id: 'webapp-components-buildstatuslight--in-progress-rep-only-limited',
    title: 'Webapp components/BuildStatusLight',
    name: 'In Progress, Representative Only, Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--pending': {
    id: 'webapp-components-buildstatuslight--pending',
    title: 'Webapp components/BuildStatusLight',
    name: 'Pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--passed-limited': {
    id: 'webapp-components-buildstatuslight--passed-limited',
    title: 'Webapp components/BuildStatusLight',
    name: 'Passed, Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--passed': {
    id: 'webapp-components-buildstatuslight--passed',
    title: 'Webapp components/BuildStatusLight',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--denied': {
    id: 'webapp-components-buildstatuslight--denied',
    title: 'Webapp components/BuildStatusLight',
    name: 'Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--accepted': {
    id: 'webapp-components-buildstatuslight--accepted',
    title: 'Webapp components/BuildStatusLight',
    name: 'Accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--timed-out': {
    id: 'webapp-components-buildstatuslight--timed-out',
    title: 'Webapp components/BuildStatusLight',
    name: 'Timed Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--timed-out-rep-only': {
    id: 'webapp-components-buildstatuslight--timed-out-rep-only',
    title: 'Webapp components/BuildStatusLight',
    name: 'Timed Out, Representative Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--timed-out-rep-only-limited': {
    id: 'webapp-components-buildstatuslight--timed-out-rep-only-limited',
    title: 'Webapp components/BuildStatusLight',
    name: 'Timed Out, Representative Only, Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--build-error': {
    id: 'webapp-components-buildstatuslight--build-error',
    title: 'Webapp components/BuildStatusLight',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--build-error-rep-only': {
    id: 'webapp-components-buildstatuslight--build-error-rep-only',
    title: 'Webapp components/BuildStatusLight',
    name: 'Build Error, Representative Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buildstatuslight--build-error-rep-only-limited': {
    id: 'webapp-components-buildstatuslight--build-error-rep-only-limited',
    title: 'Webapp components/BuildStatusLight',
    name: 'Build Error, Representative Only, Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buildstatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-button': {
    name: 'Button',
    id: 'webapp-components-button',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-button--positive'],
    type: 'component',
  },
  'webapp-components-button--positive': {
    id: 'webapp-components-button--positive',
    title: 'Webapp components/Button',
    name: 'positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-button',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttonmulti': {
    name: 'ButtonMulti',
    id: 'webapp-components-buttonmulti',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-buttonmulti--default'],
    type: 'component',
  },
  'webapp-components-buttonmulti--default': {
    id: 'webapp-components-buttonmulti--default',
    title: 'Webapp components/ButtonMulti',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttonmulti',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttontoggle': {
    name: 'ButtonToggle',
    id: 'webapp-components-buttontoggle',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-buttontoggle--outline-buttons-small',
      'webapp-components-buttontoggle--outline-three-buttons-small',
      'webapp-components-buttontoggle--pill-w-text',
      'webapp-components-buttontoggle--pill-w-image',
      'webapp-components-buttontoggle--tab',
    ],
    type: 'component',
  },
  'webapp-components-buttontoggle--outline-buttons-small': {
    id: 'webapp-components-buttontoggle--outline-buttons-small',
    title: 'Webapp components/ButtonToggle',
    name: 'outline buttons small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttontoggle',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttontoggle--outline-three-buttons-small': {
    id: 'webapp-components-buttontoggle--outline-three-buttons-small',
    title: 'Webapp components/ButtonToggle',
    name: 'outline three buttons small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttontoggle',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttontoggle--pill-w-text': {
    id: 'webapp-components-buttontoggle--pill-w-text',
    title: 'Webapp components/ButtonToggle',
    name: 'pill w/text',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttontoggle',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttontoggle--pill-w-image': {
    id: 'webapp-components-buttontoggle--pill-w-image',
    title: 'Webapp components/ButtonToggle',
    name: 'pill w/image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttontoggle',
    type: 'story',
    prepared: true,
  },
  'webapp-components-buttontoggle--tab': {
    id: 'webapp-components-buttontoggle--tab',
    title: 'Webapp components/ButtonToggle',
    name: 'tab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-buttontoggle',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas': {
    name: 'Canvas',
    id: 'webapp-components-canvas',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-canvas--default',
      'webapp-components-canvas--default-w-label-link',
      'webapp-components-canvas--pure-w-label-link-at-top',
      'webapp-components-canvas--pure-w-label-link-not-at-top',
      'webapp-components-canvas--default-w-label-link-baseline-tooltip',
      'webapp-components-canvas--default-w-figure-link',
      'webapp-components-canvas--default-w-diff-figure',
      'webapp-components-canvas--default-w-diff-figure-horizontally-larger',
      'webapp-components-canvas--default-w-diff-figure-vertically-larger',
      'webapp-components-canvas--default-w-diff-figure-larger-both-ways',
      'webapp-components-canvas--loading',
      'webapp-components-canvas--in-progress',
      'webapp-components-canvas--snapshot-error',
      'webapp-components-canvas--ignored-regions-hidden',
      'webapp-components-canvas--ignored-regions-shown',
      'webapp-components-canvas--ignored-regions-shown-w-diff-figure',
      'webapp-components-canvas--interactive-url-w-interactive-mode',
      'webapp-components-canvas--interactive-url-w-interactive-mode-bad-url',
      'webapp-components-canvas--interactive-url-w-interactive-mode-bad-spec',
      'webapp-components-canvas--interactive-url-wo-interactive-mode',
      'webapp-components-canvas--pure-interactive-url-connection-problem',
      'webapp-components-canvas--tall-thin-image',
      'webapp-components-canvas--tall-thin-image-w-ignored-regions',
      'webapp-components-canvas--wide-short-image',
    ],
    type: 'component',
  },
  'webapp-components-canvas--default': {
    id: 'webapp-components-canvas--default',
    title: 'Webapp components/Canvas',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-label-link': {
    id: 'webapp-components-canvas--default-w-label-link',
    title: 'Webapp components/Canvas',
    name: 'default w/label link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--pure-w-label-link-at-top': {
    id: 'webapp-components-canvas--pure-w-label-link-at-top',
    title: 'Webapp components/Canvas',
    name: 'pure, w/label link, at top',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--pure-w-label-link-not-at-top': {
    id: 'webapp-components-canvas--pure-w-label-link-not-at-top',
    title: 'Webapp components/Canvas',
    name: 'pure, w/label link, not at top',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-label-link-baseline-tooltip': {
    id: 'webapp-components-canvas--default-w-label-link-baseline-tooltip',
    title: 'Webapp components/Canvas',
    name: 'default w/label link + baseline tooltip',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-figure-link': {
    id: 'webapp-components-canvas--default-w-figure-link',
    title: 'Webapp components/Canvas',
    name: 'default w/figureLink',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-diff-figure': {
    id: 'webapp-components-canvas--default-w-diff-figure',
    title: 'Webapp components/Canvas',
    name: 'default w/diffFigure',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-diff-figure-horizontally-larger': {
    id: 'webapp-components-canvas--default-w-diff-figure-horizontally-larger',
    title: 'Webapp components/Canvas',
    name: 'default w/diffFigure, horizontally larger',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-diff-figure-vertically-larger': {
    id: 'webapp-components-canvas--default-w-diff-figure-vertically-larger',
    title: 'Webapp components/Canvas',
    name: 'default w/diffFigure, vertically larger',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--default-w-diff-figure-larger-both-ways': {
    id: 'webapp-components-canvas--default-w-diff-figure-larger-both-ways',
    title: 'Webapp components/Canvas',
    name: 'default w/diffFigure, larger both ways',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--loading': {
    id: 'webapp-components-canvas--loading',
    title: 'Webapp components/Canvas',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--in-progress': {
    id: 'webapp-components-canvas--in-progress',
    title: 'Webapp components/Canvas',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--snapshot-error': {
    id: 'webapp-components-canvas--snapshot-error',
    title: 'Webapp components/Canvas',
    name: 'snapshotError',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--ignored-regions-hidden': {
    id: 'webapp-components-canvas--ignored-regions-hidden',
    title: 'Webapp components/Canvas',
    name: 'ignored regions hidden',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--ignored-regions-shown': {
    id: 'webapp-components-canvas--ignored-regions-shown',
    title: 'Webapp components/Canvas',
    name: 'ignored regions shown',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--ignored-regions-shown-w-diff-figure': {
    id: 'webapp-components-canvas--ignored-regions-shown-w-diff-figure',
    title: 'Webapp components/Canvas',
    name: 'ignored regions shown w/diffFigure',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--interactive-url-w-interactive-mode': {
    id: 'webapp-components-canvas--interactive-url-w-interactive-mode',
    title: 'Webapp components/Canvas',
    name: 'interactiveUrl w/ interactiveMode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--interactive-url-w-interactive-mode-bad-url': {
    id: 'webapp-components-canvas--interactive-url-w-interactive-mode-bad-url',
    title: 'Webapp components/Canvas',
    name: 'interactiveUrl w/ interactiveMode, bad URL',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--interactive-url-w-interactive-mode-bad-spec': {
    id: 'webapp-components-canvas--interactive-url-w-interactive-mode-bad-spec',
    title: 'Webapp components/Canvas',
    name: 'interactiveUrl w/ interactiveMode, bad spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--interactive-url-wo-interactive-mode': {
    id: 'webapp-components-canvas--interactive-url-wo-interactive-mode',
    title: 'Webapp components/Canvas',
    name: 'interactiveUrl w/o interactiveMode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--pure-interactive-url-connection-problem': {
    id: 'webapp-components-canvas--pure-interactive-url-connection-problem',
    title: 'Webapp components/Canvas',
    name: 'pure, interactiveUrl connection problem',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--tall-thin-image': {
    id: 'webapp-components-canvas--tall-thin-image',
    title: 'Webapp components/Canvas',
    name: 'tall thin image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--tall-thin-image-w-ignored-regions': {
    id: 'webapp-components-canvas--tall-thin-image-w-ignored-regions',
    title: 'Webapp components/Canvas',
    name: 'tall thin image w/ ignored regions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-canvas--wide-short-image': {
    id: 'webapp-components-canvas--wide-short-image',
    title: 'Webapp components/Canvas',
    name: 'wide short image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-canvas',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal': {
    name: 'Cardinal',
    id: 'webapp-components-cardinal',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-cardinal--all-cardinals',
      'webapp-components-cardinal--small-loading',
      'webapp-components-cardinal--small-default',
      'webapp-components-cardinal--small-positive',
      'webapp-components-cardinal--small-negative',
      'webapp-components-cardinal--small-warning',
      'webapp-components-cardinal--small-neutral',
      'webapp-components-cardinal--small-selectable',
      'webapp-components-cardinal--large-loading',
      'webapp-components-cardinal--large-default',
      'webapp-components-cardinal--large-link',
      'webapp-components-cardinal--large-singular',
      'webapp-components-cardinal--large-plural',
    ],
    type: 'component',
  },
  'webapp-components-cardinal--all-cardinals': {
    id: 'webapp-components-cardinal--all-cardinals',
    title: 'Webapp components/Cardinal',
    name: 'all cardinals',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-loading': {
    id: 'webapp-components-cardinal--small-loading',
    title: 'Webapp components/Cardinal',
    name: 'small loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-default': {
    id: 'webapp-components-cardinal--small-default',
    title: 'Webapp components/Cardinal',
    name: 'small default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-positive': {
    id: 'webapp-components-cardinal--small-positive',
    title: 'Webapp components/Cardinal',
    name: 'small positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-negative': {
    id: 'webapp-components-cardinal--small-negative',
    title: 'Webapp components/Cardinal',
    name: 'small negative',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-warning': {
    id: 'webapp-components-cardinal--small-warning',
    title: 'Webapp components/Cardinal',
    name: 'small warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-neutral': {
    id: 'webapp-components-cardinal--small-neutral',
    title: 'Webapp components/Cardinal',
    name: 'small neutral',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--small-selectable': {
    id: 'webapp-components-cardinal--small-selectable',
    title: 'Webapp components/Cardinal',
    name: 'small selectable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--large-loading': {
    id: 'webapp-components-cardinal--large-loading',
    title: 'Webapp components/Cardinal',
    name: 'large loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--large-default': {
    id: 'webapp-components-cardinal--large-default',
    title: 'Webapp components/Cardinal',
    name: 'large default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--large-link': {
    id: 'webapp-components-cardinal--large-link',
    title: 'Webapp components/Cardinal',
    name: 'large link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--large-singular': {
    id: 'webapp-components-cardinal--large-singular',
    title: 'Webapp components/Cardinal',
    name: 'large singular',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cardinal--large-plural': {
    id: 'webapp-components-cardinal--large-plural',
    title: 'Webapp components/Cardinal',
    name: 'large plural',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cardinal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-checkbox': {
    name: 'Checkbox',
    id: 'webapp-components-checkbox',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-checkbox--all-checkboxes',
      'webapp-components-checkbox--unchecked',
      'webapp-components-checkbox--checked',
      'webapp-components-checkbox--primary',
    ],
    type: 'component',
  },
  'webapp-components-checkbox--all-checkboxes': {
    id: 'webapp-components-checkbox--all-checkboxes',
    title: 'Webapp components/Checkbox',
    name: 'all checkboxes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-checkbox',
    type: 'story',
    prepared: true,
  },
  'webapp-components-checkbox--unchecked': {
    id: 'webapp-components-checkbox--unchecked',
    title: 'Webapp components/Checkbox',
    name: 'unchecked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-checkbox',
    type: 'story',
    prepared: true,
  },
  'webapp-components-checkbox--checked': {
    id: 'webapp-components-checkbox--checked',
    title: 'Webapp components/Checkbox',
    name: 'checked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-checkbox',
    type: 'story',
    prepared: true,
  },
  'webapp-components-checkbox--primary': {
    id: 'webapp-components-checkbox--primary',
    title: 'Webapp components/Checkbox',
    name: 'primary',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-checkbox',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cieyebrow': {
    name: 'CIEyebrow',
    id: 'webapp-components-cieyebrow',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-cieyebrow--unlinked',
      'webapp-components-cieyebrow--github',
      'webapp-components-cieyebrow--bitbucket',
      'webapp-components-cieyebrow--gitlab',
      'webapp-components-cieyebrow--dismissed',
    ],
    type: 'component',
  },
  'webapp-components-cieyebrow--unlinked': {
    id: 'webapp-components-cieyebrow--unlinked',
    title: 'Webapp components/CIEyebrow',
    name: 'Unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cieyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cieyebrow--github': {
    id: 'webapp-components-cieyebrow--github',
    title: 'Webapp components/CIEyebrow',
    name: 'Github',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cieyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cieyebrow--bitbucket': {
    id: 'webapp-components-cieyebrow--bitbucket',
    title: 'Webapp components/CIEyebrow',
    name: 'Bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cieyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cieyebrow--gitlab': {
    id: 'webapp-components-cieyebrow--gitlab',
    title: 'Webapp components/CIEyebrow',
    name: 'Gitlab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cieyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-cieyebrow--dismissed': {
    id: 'webapp-components-cieyebrow--dismissed',
    title: 'Webapp components/CIEyebrow',
    name: 'Dismissed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-cieyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboard': {
    name: 'Clipboard',
    id: 'webapp-components-clipboard',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-clipboard--default',
      'webapp-components-clipboard--with-feedback',
    ],
    type: 'component',
  },
  'webapp-components-clipboard--default': {
    id: 'webapp-components-clipboard--default',
    title: 'Webapp components/Clipboard',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboard',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboard--with-feedback': {
    id: 'webapp-components-clipboard--with-feedback',
    title: 'Webapp components/Clipboard',
    name: 'With Feedback',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboard',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboardcode': {
    name: 'ClipboardCode',
    id: 'webapp-components-clipboardcode',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-clipboardcode--default',
      'webapp-components-clipboardcode--wrapped',
    ],
    type: 'component',
  },
  'webapp-components-clipboardcode--default': {
    id: 'webapp-components-clipboardcode--default',
    title: 'Webapp components/ClipboardCode',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboardcode',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboardcode--wrapped': {
    id: 'webapp-components-clipboardcode--wrapped',
    title: 'Webapp components/ClipboardCode',
    name: 'Wrapped',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboardcode',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboardicon': {
    name: 'ClipboardIcon',
    id: 'webapp-components-clipboardicon',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-clipboardicon--default'],
    type: 'component',
  },
  'webapp-components-clipboardicon--default': {
    id: 'webapp-components-clipboardicon--default',
    title: 'Webapp components/ClipboardIcon',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboardicon',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboardinput': {
    name: 'ClipboardInput',
    id: 'webapp-components-clipboardinput',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-clipboardinput--default',
      'webapp-components-clipboardinput--clipped',
    ],
    type: 'component',
  },
  'webapp-components-clipboardinput--default': {
    id: 'webapp-components-clipboardinput--default',
    title: 'Webapp components/ClipboardInput',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboardinput',
    type: 'story',
    prepared: true,
  },
  'webapp-components-clipboardinput--clipped': {
    id: 'webapp-components-clipboardinput--clipped',
    title: 'Webapp components/ClipboardInput',
    name: 'Clipped',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-clipboardinput',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment': {
    name: 'Comment',
    id: 'webapp-components-comment',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-comment-addcomment',
      'webapp-components-comment-comment',
      'webapp-components-comment-commentdate',
      'webapp-components-comment-commentformmanager',
      'webapp-components-comment-commentheading',
      'webapp-components-comment-commentlist',
      'webapp-components-comment-commenttextarea',
      'webapp-components-comment-commentthread',
      'webapp-components-comment-deletecomment',
      'webapp-components-comment-inlinecommentthread',
      'webapp-components-comment-replytocomment',
      'webapp-components-comment-resolvecommentthreadbutton',
      'webapp-components-comment-undoresolvecommentthreadbutton',
    ],
    type: 'group',
  },
  'webapp-components-comment-addcomment': {
    name: 'AddComment',
    id: 'webapp-components-comment-addcomment',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-addcomment--base',
      'webapp-components-comment-addcomment--initial-value',
      'webapp-components-comment-addcomment--with-form-open',
      'webapp-components-comment-addcomment--with-form-open-loading',
      'webapp-components-comment-addcomment--form-pure-with-value',
      'webapp-components-comment-addcomment--form-pure-with-value-loading',
      'webapp-components-comment-addcomment--form-pure-with-error',
    ],
    type: 'component',
  },
  'webapp-components-comment-addcomment--base': {
    id: 'webapp-components-comment-addcomment--base',
    title: 'Webapp components/Comment/AddComment',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--initial-value': {
    id: 'webapp-components-comment-addcomment--initial-value',
    title: 'Webapp components/Comment/AddComment',
    name: 'Initial Value',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--with-form-open': {
    id: 'webapp-components-comment-addcomment--with-form-open',
    title: 'Webapp components/Comment/AddComment',
    name: 'with form open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--with-form-open-loading': {
    id: 'webapp-components-comment-addcomment--with-form-open-loading',
    title: 'Webapp components/Comment/AddComment',
    name: 'with form open, loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--form-pure-with-value': {
    id: 'webapp-components-comment-addcomment--form-pure-with-value',
    title: 'Webapp components/Comment/AddComment',
    name: 'form, pure, with value',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--form-pure-with-value-loading': {
    id: 'webapp-components-comment-addcomment--form-pure-with-value-loading',
    title: 'Webapp components/Comment/AddComment',
    name: 'form, pure, with value, loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-addcomment--form-pure-with-error': {
    id: 'webapp-components-comment-addcomment--form-pure-with-error',
    title: 'Webapp components/Comment/AddComment',
    name: 'form, pure, with error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-addcomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-comment': {
    name: 'Comment',
    id: 'webapp-components-comment-comment',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-comment--base',
      'webapp-components-comment-comment--with-link',
      'webapp-components-comment-comment--collapsed',
      'webapp-components-comment-comment--collapsed-truncated',
    ],
    type: 'component',
  },
  'webapp-components-comment-comment--base': {
    id: 'webapp-components-comment-comment--base',
    title: 'Webapp components/Comment/Comment',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-comment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-comment--with-link': {
    id: 'webapp-components-comment-comment--with-link',
    title: 'Webapp components/Comment/Comment',
    name: 'with link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-comment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-comment--collapsed': {
    id: 'webapp-components-comment-comment--collapsed',
    title: 'Webapp components/Comment/Comment',
    name: 'collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-comment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-comment--collapsed-truncated': {
    id: 'webapp-components-comment-comment--collapsed-truncated',
    title: 'Webapp components/Comment/Comment',
    name: 'collapsed, truncated',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-comment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentdate': {
    name: 'CommentDate',
    id: 'webapp-components-comment-commentdate',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-commentdate--base',
      'webapp-components-comment-commentdate--with-build',
    ],
    type: 'component',
  },
  'webapp-components-comment-commentdate--base': {
    id: 'webapp-components-comment-commentdate--base',
    title: 'Webapp components/Comment/CommentDate',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentdate',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentdate--with-build': {
    id: 'webapp-components-comment-commentdate--with-build',
    title: 'Webapp components/Comment/CommentDate',
    name: 'with build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentdate',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentformmanager': {
    name: 'CommentFormManager',
    id: 'webapp-components-comment-commentformmanager',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-commentformmanager--base',
      'webapp-components-comment-commentformmanager--pure-form-visible',
      'webapp-components-comment-commentformmanager--pure-form-not-visible',
    ],
    type: 'component',
  },
  'webapp-components-comment-commentformmanager--base': {
    id: 'webapp-components-comment-commentformmanager--base',
    title: 'Webapp components/Comment/CommentFormManager',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentformmanager',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentformmanager--pure-form-visible': {
    id: 'webapp-components-comment-commentformmanager--pure-form-visible',
    title: 'Webapp components/Comment/CommentFormManager',
    name: 'pure, form visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentformmanager',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentformmanager--pure-form-not-visible': {
    id: 'webapp-components-comment-commentformmanager--pure-form-not-visible',
    title: 'Webapp components/Comment/CommentFormManager',
    name: 'pure, form not visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentformmanager',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentheading': {
    name: 'CommentHeading',
    id: 'webapp-components-comment-commentheading',
    parent: 'webapp-components-comment',
    depth: 2,
    children: ['webapp-components-comment-commentheading--base'],
    type: 'component',
  },
  'webapp-components-comment-commentheading--base': {
    id: 'webapp-components-comment-commentheading--base',
    title: 'Webapp components/Comment/CommentHeading',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentheading',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentlist': {
    name: 'CommentList',
    id: 'webapp-components-comment-commentlist',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-commentlist--can-comment',
      'webapp-components-comment-commentlist--cannot-comment',
    ],
    type: 'component',
  },
  'webapp-components-comment-commentlist--can-comment': {
    id: 'webapp-components-comment-commentlist--can-comment',
    title: 'Webapp components/Comment/CommentList',
    name: 'can comment',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentlist--cannot-comment': {
    id: 'webapp-components-comment-commentlist--cannot-comment',
    title: 'Webapp components/Comment/CommentList',
    name: 'cannot comment',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commenttextarea': {
    name: 'CommentTextarea',
    id: 'webapp-components-comment-commenttextarea',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-commenttextarea--base',
      'webapp-components-comment-commenttextarea--with-value',
    ],
    type: 'component',
  },
  'webapp-components-comment-commenttextarea--base': {
    id: 'webapp-components-comment-commenttextarea--base',
    title: 'Webapp components/Comment/CommentTextarea',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commenttextarea',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commenttextarea--with-value': {
    id: 'webapp-components-comment-commenttextarea--with-value',
    title: 'Webapp components/Comment/CommentTextarea',
    name: 'with value',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commenttextarea',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentthread': {
    name: 'CommentThread',
    id: 'webapp-components-comment-commentthread',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-commentthread--pure-collapsed',
      'webapp-components-comment-commentthread--pure-expanded',
      'webapp-components-comment-commentthread--pure-expanded-w-list',
    ],
    type: 'component',
  },
  'webapp-components-comment-commentthread--pure-collapsed': {
    id: 'webapp-components-comment-commentthread--pure-collapsed',
    title: 'Webapp components/Comment/CommentThread',
    name: 'pure, collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentthread--pure-expanded': {
    id: 'webapp-components-comment-commentthread--pure-expanded',
    title: 'Webapp components/Comment/CommentThread',
    name: 'pure, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-commentthread--pure-expanded-w-list': {
    id: 'webapp-components-comment-commentthread--pure-expanded-w-list',
    title: 'Webapp components/Comment/CommentThread',
    name: 'pure, expanded, w/ list',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-commentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-deletecomment': {
    name: 'DeleteComment',
    id: 'webapp-components-comment-deletecomment',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-deletecomment--can-delete',
      'webapp-components-comment-deletecomment--can-delete-with-children',
      'webapp-components-comment-deletecomment--cannot-delete',
    ],
    type: 'component',
  },
  'webapp-components-comment-deletecomment--can-delete': {
    id: 'webapp-components-comment-deletecomment--can-delete',
    title: 'Webapp components/Comment/DeleteComment',
    name: 'can delete',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-deletecomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-deletecomment--can-delete-with-children': {
    id: 'webapp-components-comment-deletecomment--can-delete-with-children',
    title: 'Webapp components/Comment/DeleteComment',
    name: 'can delete, with children',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-deletecomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-deletecomment--cannot-delete': {
    id: 'webapp-components-comment-deletecomment--cannot-delete',
    title: 'Webapp components/Comment/DeleteComment',
    name: 'cannot delete',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-deletecomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread': {
    name: 'InlineCommentThread',
    id: 'webapp-components-comment-inlinecommentthread',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-inlinecommentthread--active-logged-out',
      'webapp-components-comment-inlinecommentthread--active',
      'webapp-components-comment-inlinecommentthread--active-non-owner',
      'webapp-components-comment-inlinecommentthread--resolved-logged-out',
      'webapp-components-comment-inlinecommentthread--resolved',
      'webapp-components-comment-inlinecommentthread--header-not-commentable',
      'webapp-components-comment-inlinecommentthread--header-resolved-owner',
      'webapp-components-comment-inlinecommentthread--header-resolved-non-owner',
      'webapp-components-comment-inlinecommentthread--header-resolved-logged-out',
      'webapp-components-comment-inlinecommentthread--header-active-owner',
      'webapp-components-comment-inlinecommentthread--header-active-non-owner',
      'webapp-components-comment-inlinecommentthread--collapsed',
      'webapp-components-comment-inlinecommentthread--collapsed-mutating',
      'webapp-components-comment-inlinecommentthread--collapsed-mutating-logged-out',
    ],
    type: 'component',
  },
  'webapp-components-comment-inlinecommentthread--active-logged-out': {
    id: 'webapp-components-comment-inlinecommentthread--active-logged-out',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'active, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--active': {
    id: 'webapp-components-comment-inlinecommentthread--active',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--active-non-owner': {
    id: 'webapp-components-comment-inlinecommentthread--active-non-owner',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'active, non-owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--resolved-logged-out': {
    id: 'webapp-components-comment-inlinecommentthread--resolved-logged-out',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'resolved, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--resolved': {
    id: 'webapp-components-comment-inlinecommentthread--resolved',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'resolved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-not-commentable': {
    id: 'webapp-components-comment-inlinecommentthread--header-not-commentable',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, not-commentable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-resolved-owner': {
    id: 'webapp-components-comment-inlinecommentthread--header-resolved-owner',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, resolved, owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-resolved-non-owner': {
    id: 'webapp-components-comment-inlinecommentthread--header-resolved-non-owner',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, resolved, non-owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-resolved-logged-out': {
    id: 'webapp-components-comment-inlinecommentthread--header-resolved-logged-out',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, resolved, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-active-owner': {
    id: 'webapp-components-comment-inlinecommentthread--header-active-owner',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, active, owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--header-active-non-owner': {
    id: 'webapp-components-comment-inlinecommentthread--header-active-non-owner',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'header, active, non-owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--collapsed': {
    id: 'webapp-components-comment-inlinecommentthread--collapsed',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--collapsed-mutating': {
    id: 'webapp-components-comment-inlinecommentthread--collapsed-mutating',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'collapsed, mutating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-inlinecommentthread--collapsed-mutating-logged-out': {
    id: 'webapp-components-comment-inlinecommentthread--collapsed-mutating-logged-out',
    title: 'Webapp components/Comment/InlineCommentThread',
    name: 'collapsed, mutating, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-inlinecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-replytocomment': {
    name: 'ReplyToComment',
    id: 'webapp-components-comment-replytocomment',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-replytocomment--base',
      'webapp-components-comment-replytocomment--initial-value',
      'webapp-components-comment-replytocomment--base-with-form-open',
      'webapp-components-comment-replytocomment--form-pure-with-value',
      'webapp-components-comment-replytocomment--form-pure-with-error',
    ],
    type: 'component',
  },
  'webapp-components-comment-replytocomment--base': {
    id: 'webapp-components-comment-replytocomment--base',
    title: 'Webapp components/Comment/ReplyToComment',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-replytocomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-replytocomment--initial-value': {
    id: 'webapp-components-comment-replytocomment--initial-value',
    title: 'Webapp components/Comment/ReplyToComment',
    name: 'Initial Value',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-replytocomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-replytocomment--base-with-form-open': {
    id: 'webapp-components-comment-replytocomment--base-with-form-open',
    title: 'Webapp components/Comment/ReplyToComment',
    name: 'base, with form open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-replytocomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-replytocomment--form-pure-with-value': {
    id: 'webapp-components-comment-replytocomment--form-pure-with-value',
    title: 'Webapp components/Comment/ReplyToComment',
    name: 'form, pure, with value',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-replytocomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-replytocomment--form-pure-with-error': {
    id: 'webapp-components-comment-replytocomment--form-pure-with-error',
    title: 'Webapp components/Comment/ReplyToComment',
    name: 'form, pure, with error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-replytocomment',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-resolvecommentthreadbutton': {
    name: 'ResolveCommentThreadButton',
    id: 'webapp-components-comment-resolvecommentthreadbutton',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-resolvecommentthreadbutton--base',
      'webapp-components-comment-resolvecommentthreadbutton--with-text',
    ],
    type: 'component',
  },
  'webapp-components-comment-resolvecommentthreadbutton--base': {
    id: 'webapp-components-comment-resolvecommentthreadbutton--base',
    title: 'Webapp components/Comment/ResolveCommentThreadButton',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-resolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-resolvecommentthreadbutton--with-text': {
    id: 'webapp-components-comment-resolvecommentthreadbutton--with-text',
    title: 'Webapp components/Comment/ResolveCommentThreadButton',
    name: 'with text',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-resolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-undoresolvecommentthreadbutton': {
    name: 'UndoResolveCommentThreadButton',
    id: 'webapp-components-comment-undoresolvecommentthreadbutton',
    parent: 'webapp-components-comment',
    depth: 2,
    children: [
      'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-large',
      'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-loading-large',
      'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-large',
      'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-small',
      'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-small',
    ],
    type: 'component',
  },
  'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-large': {
    id: 'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-large',
    title: 'Webapp components/Comment/UndoResolveCommentThreadButton',
    name: 'can undo, large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-undoresolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-loading-large': {
    id: 'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-loading-large',
    title: 'Webapp components/Comment/UndoResolveCommentThreadButton',
    name: 'can undo, loading, large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-undoresolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-large': {
    id: 'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-large',
    title: 'Webapp components/Comment/UndoResolveCommentThreadButton',
    name: 'cannot undo, large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-undoresolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-small': {
    id: 'webapp-components-comment-undoresolvecommentthreadbutton--can-undo-small',
    title: 'Webapp components/Comment/UndoResolveCommentThreadButton',
    name: 'can undo, small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-undoresolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-small': {
    id: 'webapp-components-comment-undoresolvecommentthreadbutton--cannot-undo-small',
    title: 'Webapp components/Comment/UndoResolveCommentThreadButton',
    name: 'cannot undo, small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-comment-undoresolvecommentthreadbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbranchlist': {
    name: 'ComponentBranchList',
    id: 'webapp-components-componentbranchlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentbranchlist--master',
      'webapp-components-componentbranchlist--feature',
    ],
    type: 'component',
  },
  'webapp-components-componentbranchlist--master': {
    id: 'webapp-components-componentbranchlist--master',
    title: 'Webapp components/ComponentBranchList',
    name: 'master',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbranchlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbranchlist--feature': {
    id: 'webapp-components-componentbranchlist--feature',
    title: 'Webapp components/ComponentBranchList',
    name: 'feature',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbranchlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildlist': {
    name: 'ComponentBuildList',
    id: 'webapp-components-componentbuildlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentbuildlist--latest',
      'webapp-components-componentbuildlist--historical',
    ],
    type: 'component',
  },
  'webapp-components-componentbuildlist--latest': {
    id: 'webapp-components-componentbuildlist--latest',
    title: 'Webapp components/ComponentBuildList',
    name: 'latest',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildlist--historical': {
    id: 'webapp-components-componentbuildlist--historical',
    title: 'Webapp components/ComponentBuildList',
    name: 'historical',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildspicker': {
    name: 'ComponentBuildsPicker',
    id: 'webapp-components-componentbuildspicker',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentbuildspicker--loading',
      'webapp-components-componentbuildspicker--interactive',
      'webapp-components-componentbuildspicker--feature-selected',
      'webapp-components-componentbuildspicker--hide-branches',
    ],
    type: 'component',
  },
  'webapp-components-componentbuildspicker--loading': {
    id: 'webapp-components-componentbuildspicker--loading',
    title: 'Webapp components/ComponentBuildsPicker',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildspicker--interactive': {
    id: 'webapp-components-componentbuildspicker--interactive',
    title: 'Webapp components/ComponentBuildsPicker',
    name: 'interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildspicker--feature-selected': {
    id: 'webapp-components-componentbuildspicker--feature-selected',
    title: 'Webapp components/ComponentBuildsPicker',
    name: 'feature selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentbuildspicker--hide-branches': {
    id: 'webapp-components-componentbuildspicker--hide-branches',
    title: 'Webapp components/ComponentBuildsPicker',
    name: 'hide branches',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem': {
    name: 'ComponentItem',
    id: 'webapp-components-componentitem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentitem--all',
      'webapp-components-componentitem--various-image-sizes',
      'webapp-components-componentitem--loading',
      'webapp-components-componentitem--in-progress',
      'webapp-components-componentitem--errored',
      'webapp-components-componentitem--no-capture',
      'webapp-components-componentitem--first-run-using-baseline-images',
      'webapp-components-componentitem--unchanged-using-baseline-images',
      'webapp-components-componentitem--unchanged-not-using-baseline-images',
    ],
    type: 'component',
  },
  'webapp-components-componentitem--all': {
    id: 'webapp-components-componentitem--all',
    title: 'Webapp components/ComponentItem',
    name: 'All',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--various-image-sizes': {
    id: 'webapp-components-componentitem--various-image-sizes',
    title: 'Webapp components/ComponentItem',
    name: 'Various Image Sizes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--loading': {
    id: 'webapp-components-componentitem--loading',
    title: 'Webapp components/ComponentItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--in-progress': {
    id: 'webapp-components-componentitem--in-progress',
    title: 'Webapp components/ComponentItem',
    name: 'In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--errored': {
    id: 'webapp-components-componentitem--errored',
    title: 'Webapp components/ComponentItem',
    name: 'Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--no-capture': {
    id: 'webapp-components-componentitem--no-capture',
    title: 'Webapp components/ComponentItem',
    name: 'No Capture',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--first-run-using-baseline-images': {
    id: 'webapp-components-componentitem--first-run-using-baseline-images',
    title: 'Webapp components/ComponentItem',
    name: 'First Run Using Baseline Images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--unchanged-using-baseline-images': {
    id: 'webapp-components-componentitem--unchanged-using-baseline-images',
    title: 'Webapp components/ComponentItem',
    name: 'Unchanged Using Baseline Images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentitem--unchanged-not-using-baseline-images': {
    id: 'webapp-components-componentitem--unchanged-not-using-baseline-images',
    title: 'Webapp components/ComponentItem',
    name: 'Unchanged Not Using Baseline Images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentlist': {
    name: 'ComponentList',
    id: 'webapp-components-componentlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentlist--loading',
      'webapp-components-componentlist--full',
      'webapp-components-componentlist--empty',
    ],
    type: 'component',
  },
  'webapp-components-componentlist--loading': {
    id: 'webapp-components-componentlist--loading',
    title: 'Webapp components/ComponentList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentlist--full': {
    id: 'webapp-components-componentlist--full',
    title: 'Webapp components/ComponentList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentlist--empty': {
    id: 'webapp-components-componentlist--empty',
    title: 'Webapp components/ComponentList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage': {
    name: 'ComponentRepresentationImage',
    id: 'webapp-components-componentrepresentationimage',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-componentrepresentationimage--all',
      'webapp-components-componentrepresentationimage--various-image-sizes',
      'webapp-components-componentrepresentationimage--in-progress',
      'webapp-components-componentrepresentationimage--with-error',
      'webapp-components-componentrepresentationimage--first-run-using-baseline-images',
      'webapp-components-componentrepresentationimage--unchanged-using-baseline-images',
      'webapp-components-componentrepresentationimage--unchanged-not-using-baseline-images',
      'webapp-components-componentrepresentationimage--no-capture',
      'webapp-components-componentrepresentationimage--image',
      'webapp-components-componentrepresentationimage--long-name',
    ],
    type: 'component',
  },
  'webapp-components-componentrepresentationimage--all': {
    id: 'webapp-components-componentrepresentationimage--all',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'all',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--various-image-sizes': {
    id: 'webapp-components-componentrepresentationimage--various-image-sizes',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'various image sizes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--in-progress': {
    id: 'webapp-components-componentrepresentationimage--in-progress',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--with-error': {
    id: 'webapp-components-componentrepresentationimage--with-error',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'with error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--first-run-using-baseline-images': {
    id: 'webapp-components-componentrepresentationimage--first-run-using-baseline-images',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'first run, using baseline images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--unchanged-using-baseline-images': {
    id: 'webapp-components-componentrepresentationimage--unchanged-using-baseline-images',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'unchanged, using baseline images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--unchanged-not-using-baseline-images': {
    id: 'webapp-components-componentrepresentationimage--unchanged-not-using-baseline-images',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'unchanged, not using baseline images',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--no-capture': {
    id: 'webapp-components-componentrepresentationimage--no-capture',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'no capture',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--image': {
    id: 'webapp-components-componentrepresentationimage--image',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-componentrepresentationimage--long-name': {
    id: 'webapp-components-componentrepresentationimage--long-name',
    title: 'Webapp components/ComponentRepresentationImage',
    name: 'long name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-componentrepresentationimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform': {
    name: 'CreditCardForm',
    id: 'webapp-components-creditcardform',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-creditcardform--default',
      'webapp-components-creditcardform--default-billing-fails',
      'webapp-components-creditcardform--pure-submitting',
      'webapp-components-creditcardform--pure-errored',
      'webapp-components-creditcardform--with-billing-email',
      'webapp-components-creditcardform--custom-label-and-cta',
    ],
    type: 'component',
  },
  'webapp-components-creditcardform--default': {
    id: 'webapp-components-creditcardform--default',
    title: 'Webapp components/CreditCardForm',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform--default-billing-fails': {
    id: 'webapp-components-creditcardform--default-billing-fails',
    title: 'Webapp components/CreditCardForm',
    name: 'default, billing fails',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform--pure-submitting': {
    id: 'webapp-components-creditcardform--pure-submitting',
    title: 'Webapp components/CreditCardForm',
    name: 'pure, submitting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform--pure-errored': {
    id: 'webapp-components-creditcardform--pure-errored',
    title: 'Webapp components/CreditCardForm',
    name: 'pure, errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform--with-billing-email': {
    id: 'webapp-components-creditcardform--with-billing-email',
    title: 'Webapp components/CreditCardForm',
    name: 'with billing email',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-creditcardform--custom-label-and-cta': {
    id: 'webapp-components-creditcardform--custom-label-and-cta',
    title: 'Webapp components/CreditCardForm',
    name: 'custom label and cta',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-creditcardform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-dateformatter': {
    name: 'DateFormatter',
    id: 'webapp-components-dateformatter',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-dateformatter--all-dates'],
    type: 'component',
  },
  'webapp-components-dateformatter--all-dates': {
    id: 'webapp-components-dateformatter--all-dates',
    title: 'Webapp components/DateFormatter',
    name: 'all dates',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-dateformatter',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage': {
    name: 'DiffImage',
    id: 'webapp-components-diffimage',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-diffimage--default',
      'webapp-components-diffimage--loading',
      'webapp-components-diffimage--with-diff',
      'webapp-components-diffimage--with-strobe-diff',
      'webapp-components-diffimage--with-focus-diff',
      'webapp-components-diffimage--with-focus-strobe-diff',
      'webapp-components-diffimage--with-bigger-diff',
      'webapp-components-diffimage--with-horizontally-bigger-diff',
      'webapp-components-diffimage--with-vertically-bigger-diff',
      'webapp-components-diffimage--responsive',
      'webapp-components-diffimage--responsive-centered',
      'webapp-components-diffimage--with-scaled-diff',
      'webapp-components-diffimage--with-scaled-overflow-diff',
      'webapp-components-diffimage--with-link',
      'webapp-components-diffimage--with-link-wrapper',
    ],
    type: 'component',
  },
  'webapp-components-diffimage--default': {
    id: 'webapp-components-diffimage--default',
    title: 'Webapp components/DiffImage',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--loading': {
    id: 'webapp-components-diffimage--loading',
    title: 'Webapp components/DiffImage',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-diff': {
    id: 'webapp-components-diffimage--with-diff',
    title: 'Webapp components/DiffImage',
    name: 'with diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-strobe-diff': {
    id: 'webapp-components-diffimage--with-strobe-diff',
    title: 'Webapp components/DiffImage',
    name: 'with strobe diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-focus-diff': {
    id: 'webapp-components-diffimage--with-focus-diff',
    title: 'Webapp components/DiffImage',
    name: 'with focus diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-focus-strobe-diff': {
    id: 'webapp-components-diffimage--with-focus-strobe-diff',
    title: 'Webapp components/DiffImage',
    name: 'with focus+strobe diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-bigger-diff': {
    id: 'webapp-components-diffimage--with-bigger-diff',
    title: 'Webapp components/DiffImage',
    name: 'with bigger diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-horizontally-bigger-diff': {
    id: 'webapp-components-diffimage--with-horizontally-bigger-diff',
    title: 'Webapp components/DiffImage',
    name: 'with horizontally bigger diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-vertically-bigger-diff': {
    id: 'webapp-components-diffimage--with-vertically-bigger-diff',
    title: 'Webapp components/DiffImage',
    name: 'with vertically bigger diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--responsive': {
    id: 'webapp-components-diffimage--responsive',
    title: 'Webapp components/DiffImage',
    name: 'responsive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--responsive-centered': {
    id: 'webapp-components-diffimage--responsive-centered',
    title: 'Webapp components/DiffImage',
    name: 'responsive, centered',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-scaled-diff': {
    id: 'webapp-components-diffimage--with-scaled-diff',
    title: 'Webapp components/DiffImage',
    name: 'with scaled diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-scaled-overflow-diff': {
    id: 'webapp-components-diffimage--with-scaled-overflow-diff',
    title: 'Webapp components/DiffImage',
    name: 'with scaled overflow diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-link': {
    id: 'webapp-components-diffimage--with-link',
    title: 'Webapp components/DiffImage',
    name: 'with link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-diffimage--with-link-wrapper': {
    id: 'webapp-components-diffimage--with-link-wrapper',
    title: 'Webapp components/DiffImage',
    name: 'with link wrapper',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-diffimage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-difftoggles': {
    name: 'DiffToggles',
    id: 'webapp-components-difftoggles',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-difftoggles--no-diff',
      'webapp-components-difftoggles--diff',
      'webapp-components-difftoggles--diff-strobe',
      'webapp-components-difftoggles--diff-focus',
      'webapp-components-difftoggles--diff-focus-strobe',
    ],
    type: 'component',
  },
  'webapp-components-difftoggles--no-diff': {
    id: 'webapp-components-difftoggles--no-diff',
    title: 'Webapp components/DiffToggles',
    name: 'no diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-difftoggles',
    type: 'story',
    prepared: true,
  },
  'webapp-components-difftoggles--diff': {
    id: 'webapp-components-difftoggles--diff',
    title: 'Webapp components/DiffToggles',
    name: 'diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-difftoggles',
    type: 'story',
    prepared: true,
  },
  'webapp-components-difftoggles--diff-strobe': {
    id: 'webapp-components-difftoggles--diff-strobe',
    title: 'Webapp components/DiffToggles',
    name: 'diff strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-difftoggles',
    type: 'story',
    prepared: true,
  },
  'webapp-components-difftoggles--diff-focus': {
    id: 'webapp-components-difftoggles--diff-focus',
    title: 'Webapp components/DiffToggles',
    name: 'diff focus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-difftoggles',
    type: 'story',
    prepared: true,
  },
  'webapp-components-difftoggles--diff-focus-strobe': {
    id: 'webapp-components-difftoggles--diff-focus-strobe',
    title: 'Webapp components/DiffToggles',
    name: 'diff focus+strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-difftoggles',
    type: 'story',
    prepared: true,
  },
  'webapp-components-emptymessage': {
    name: 'EmptyMessage',
    id: 'webapp-components-emptymessage',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-emptymessage--all-messages',
      'webapp-components-emptymessage--default',
      'webapp-components-emptymessage--custom',
      'webapp-components-emptymessage--custom-noun',
    ],
    type: 'component',
  },
  'webapp-components-emptymessage--all-messages': {
    id: 'webapp-components-emptymessage--all-messages',
    title: 'Webapp components/EmptyMessage',
    name: 'all messages',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-emptymessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-emptymessage--default': {
    id: 'webapp-components-emptymessage--default',
    title: 'Webapp components/EmptyMessage',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-emptymessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-emptymessage--custom': {
    id: 'webapp-components-emptymessage--custom',
    title: 'Webapp components/EmptyMessage',
    name: 'custom',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-emptymessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-emptymessage--custom-noun': {
    id: 'webapp-components-emptymessage--custom-noun',
    title: 'Webapp components/EmptyMessage',
    name: 'custom noun',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-emptymessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-eyebrow': {
    name: 'Eyebrow',
    id: 'webapp-components-eyebrow',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-eyebrow--default',
      'webapp-components-eyebrow--positive',
      'webapp-components-eyebrow--warning',
      'webapp-components-eyebrow--negative',
    ],
    type: 'component',
  },
  'webapp-components-eyebrow--default': {
    id: 'webapp-components-eyebrow--default',
    title: 'Webapp components/Eyebrow',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-eyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-eyebrow--positive': {
    id: 'webapp-components-eyebrow--positive',
    title: 'Webapp components/Eyebrow',
    name: 'Positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-eyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-eyebrow--warning': {
    id: 'webapp-components-eyebrow--warning',
    title: 'Webapp components/Eyebrow',
    name: 'Warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-eyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-eyebrow--negative': {
    id: 'webapp-components-eyebrow--negative',
    title: 'Webapp components/Eyebrow',
    name: 'Negative',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-eyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-eyebrowonboarding': {
    name: 'EyebrowOnboarding',
    id: 'webapp-components-eyebrowonboarding',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-eyebrowonboarding--default'],
    type: 'component',
  },
  'webapp-components-eyebrowonboarding--default': {
    id: 'webapp-components-eyebrowonboarding--default',
    title: 'Webapp components/EyebrowOnboarding',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-eyebrowonboarding',
    type: 'story',
    prepared: true,
  },
  'webapp-components-flexcenter': {
    name: 'FlexCenter',
    id: 'webapp-components-flexcenter',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-flexcenter--21',
      'webapp-components-flexcenter--22',
      'webapp-components-flexcenter--23',
    ],
    type: 'component',
  },
  'webapp-components-flexcenter--21': {
    id: 'webapp-components-flexcenter--21',
    title: 'Webapp components/FlexCenter',
    name: '2:1',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-flexcenter',
    type: 'story',
    prepared: true,
  },
  'webapp-components-flexcenter--22': {
    id: 'webapp-components-flexcenter--22',
    title: 'Webapp components/FlexCenter',
    name: '2:2',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-flexcenter',
    type: 'story',
    prepared: true,
  },
  'webapp-components-flexcenter--23': {
    id: 'webapp-components-flexcenter--23',
    title: 'Webapp components/FlexCenter',
    name: '2:3',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-flexcenter',
    type: 'story',
    prepared: true,
  },
  'webapp-components-form': {
    name: 'Form',
    id: 'webapp-components-form',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-form--all-inputs'],
    type: 'component',
  },
  'webapp-components-form--all-inputs': {
    id: 'webapp-components-form--all-inputs',
    title: 'Webapp components/Form',
    name: 'all inputs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-form',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header': {
    name: 'Header',
    id: 'webapp-components-header',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-header--loading',
      'webapp-components-header--logged-in-app',
      'webapp-components-header--logged-in-app-saml-user',
      'webapp-components-header--logged-in-app-shared-with-you',
      'webapp-components-header--logged-in-app-shared-with-admin',
      'webapp-components-header--logged-in-app-shared-with-you-open-source',
      'webapp-components-header--logged-in-linked-account',
      'webapp-components-header--logged-in-personal-account',
      'webapp-components-header--logged-in-shared-with-you-app-owner',
      'webapp-components-header--logged-in-no-app-owner-or-app',
      'webapp-components-header--logged-in-no-app-owner-onboarding',
      'webapp-components-header--not-logged-in-can-login',
      'webapp-components-header--not-logged-in-can-not-login',
      'webapp-components-header--long-name',
    ],
    type: 'component',
  },
  'webapp-components-header--loading': {
    id: 'webapp-components-header--loading',
    title: 'Webapp components/Header',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-app': {
    id: 'webapp-components-header--logged-in-app',
    title: 'Webapp components/Header',
    name: 'Logged in, app',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-app-saml-user': {
    id: 'webapp-components-header--logged-in-app-saml-user',
    title: 'Webapp components/Header',
    name: 'Logged in, app, saml user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-app-shared-with-you': {
    id: 'webapp-components-header--logged-in-app-shared-with-you',
    title: 'Webapp components/Header',
    name: 'Logged in, app, shared with you',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-app-shared-with-admin': {
    id: 'webapp-components-header--logged-in-app-shared-with-admin',
    title: 'Webapp components/Header',
    name: 'Logged in, app, shared with admin',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-app-shared-with-you-open-source': {
    id: 'webapp-components-header--logged-in-app-shared-with-you-open-source',
    title: 'Webapp components/Header',
    name: 'Logged in, app, shared with you, open source',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-linked-account': {
    id: 'webapp-components-header--logged-in-linked-account',
    title: 'Webapp components/Header',
    name: 'Logged in, linked account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-personal-account': {
    id: 'webapp-components-header--logged-in-personal-account',
    title: 'Webapp components/Header',
    name: 'Logged in, personal account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-shared-with-you-app-owner': {
    id: 'webapp-components-header--logged-in-shared-with-you-app-owner',
    title: 'Webapp components/Header',
    name: 'Logged in, shared with you appOwner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-no-app-owner-or-app': {
    id: 'webapp-components-header--logged-in-no-app-owner-or-app',
    title: 'Webapp components/Header',
    name: 'Logged in no appOwner or app',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--logged-in-no-app-owner-onboarding': {
    id: 'webapp-components-header--logged-in-no-app-owner-onboarding',
    title: 'Webapp components/Header',
    name: 'Logged in no appOwner (onboarding)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--not-logged-in-can-login': {
    id: 'webapp-components-header--not-logged-in-can-login',
    title: 'Webapp components/Header',
    name: 'Not logged in, can login',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--not-logged-in-can-not-login': {
    id: 'webapp-components-header--not-logged-in-can-not-login',
    title: 'Webapp components/Header',
    name: 'Not logged in, can not login',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-header--long-name': {
    id: 'webapp-components-header--long-name',
    title: 'Webapp components/Header',
    name: 'Long name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-header',
    type: 'story',
    prepared: true,
  },
  'webapp-components-heading': {
    name: 'Heading',
    id: 'webapp-components-heading',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-heading--loading',
      'webapp-components-heading--default',
      'webapp-components-heading--no-subtitle',
    ],
    type: 'component',
  },
  'webapp-components-heading--loading': {
    id: 'webapp-components-heading--loading',
    title: 'Webapp components/Heading',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-heading',
    type: 'story',
    prepared: true,
  },
  'webapp-components-heading--default': {
    id: 'webapp-components-heading--default',
    title: 'Webapp components/Heading',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-heading',
    type: 'story',
    prepared: true,
  },
  'webapp-components-heading--no-subtitle': {
    id: 'webapp-components-heading--no-subtitle',
    title: 'Webapp components/Heading',
    name: 'no subtitle',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-heading',
    type: 'story',
    prepared: true,
  },
  'webapp-components-ignoredregions': {
    name: 'IgnoredRegions',
    id: 'webapp-components-ignoredregions',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-ignoredregions--basic'],
    type: 'component',
  },
  'webapp-components-ignoredregions--basic': {
    id: 'webapp-components-ignoredregions--basic',
    title: 'Webapp components/IgnoredRegions',
    name: 'basic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-ignoredregions',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile': {
    name: 'ImageTile',
    id: 'webapp-components-imagetile',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-imagetile--loading',
      'webapp-components-imagetile--default',
      'webapp-components-imagetile--long-text',
      'webapp-components-imagetile--no-label',
      'webapp-components-imagetile--no-description',
      'webapp-components-imagetile--as-link',
      'webapp-components-imagetile--as-button',
      'webapp-components-imagetile--with-image',
      'webapp-components-imagetile--with-background',
      'webapp-components-imagetile--with-border',
    ],
    type: 'component',
  },
  'webapp-components-imagetile--loading': {
    id: 'webapp-components-imagetile--loading',
    title: 'Webapp components/ImageTile',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--default': {
    id: 'webapp-components-imagetile--default',
    title: 'Webapp components/ImageTile',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--long-text': {
    id: 'webapp-components-imagetile--long-text',
    title: 'Webapp components/ImageTile',
    name: 'Long Text',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--no-label': {
    id: 'webapp-components-imagetile--no-label',
    title: 'Webapp components/ImageTile',
    name: 'No Label',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--no-description': {
    id: 'webapp-components-imagetile--no-description',
    title: 'Webapp components/ImageTile',
    name: 'No Description',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--as-link': {
    id: 'webapp-components-imagetile--as-link',
    title: 'Webapp components/ImageTile',
    name: 'As Link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--as-button': {
    id: 'webapp-components-imagetile--as-button',
    title: 'Webapp components/ImageTile',
    name: 'As Button',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--with-image': {
    id: 'webapp-components-imagetile--with-image',
    title: 'Webapp components/ImageTile',
    name: 'With Image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--with-background': {
    id: 'webapp-components-imagetile--with-background',
    title: 'Webapp components/ImageTile',
    name: 'With Background',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-imagetile--with-border': {
    id: 'webapp-components-imagetile--with-border',
    title: 'Webapp components/ImageTile',
    name: 'With Border',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-imagetile',
    type: 'story',
    prepared: true,
  },
  'webapp-components-interstitial': {
    name: 'Interstitial',
    id: 'webapp-components-interstitial',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-interstitial--dots',
      'webapp-components-interstitial--bar',
      'webapp-components-interstitial--ring',
      'webapp-components-interstitial--icon',
    ],
    type: 'component',
  },
  'webapp-components-interstitial--dots': {
    id: 'webapp-components-interstitial--dots',
    title: 'Webapp components/Interstitial',
    name: 'Dots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-interstitial',
    type: 'story',
    prepared: true,
  },
  'webapp-components-interstitial--bar': {
    id: 'webapp-components-interstitial--bar',
    title: 'Webapp components/Interstitial',
    name: 'Bar',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-interstitial',
    type: 'story',
    prepared: true,
  },
  'webapp-components-interstitial--ring': {
    id: 'webapp-components-interstitial--ring',
    title: 'Webapp components/Interstitial',
    name: 'Ring',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-interstitial',
    type: 'story',
    prepared: true,
  },
  'webapp-components-interstitial--icon': {
    id: 'webapp-components-interstitial--icon',
    title: 'Webapp components/Interstitial',
    name: 'Icon',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-interstitial',
    type: 'story',
    prepared: true,
  },
  'webapp-components-inviteeyebrow': {
    name: 'InviteEyebrow',
    id: 'webapp-components-inviteeyebrow',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-inviteeyebrow--unlinked',
      'webapp-components-inviteeyebrow--linked',
    ],
    type: 'component',
  },
  'webapp-components-inviteeyebrow--unlinked': {
    id: 'webapp-components-inviteeyebrow--unlinked',
    title: 'Webapp components/InviteEyebrow',
    name: 'Unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-inviteeyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-inviteeyebrow--linked': {
    id: 'webapp-components-inviteeyebrow--linked',
    title: 'Webapp components/InviteEyebrow',
    name: 'Linked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-inviteeyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isactiveelement': {
    name: 'IsActiveElement',
    id: 'webapp-components-isactiveelement',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-isactiveelement--active',
      'webapp-components-isactiveelement--not-active',
    ],
    type: 'component',
  },
  'webapp-components-isactiveelement--active': {
    id: 'webapp-components-isactiveelement--active',
    title: 'Webapp components/IsActiveElement',
    name: 'active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isactiveelement',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isactiveelement--not-active': {
    id: 'webapp-components-isactiveelement--not-active',
    title: 'Webapp components/IsActiveElement',
    name: 'not active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isactiveelement',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe': {
    name: 'IsolatorFrame',
    id: 'webapp-components-isolatorframe',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-isolatorframe--fail-to-connect',
      'webapp-components-isolatorframe--hidden',
      'webapp-components-isolatorframe--storybook-34',
      'webapp-components-isolatorframe--storybook-40',
      'webapp-components-isolatorframe--storybook-5',
      'webapp-components-isolatorframe--storybook-5-legacy-package',
      'webapp-components-isolatorframe--storybook-5-error',
      'webapp-components-isolatorframe--storybook-6',
      'webapp-components-isolatorframe--invalid-spec',
    ],
    type: 'component',
  },
  'webapp-components-isolatorframe--fail-to-connect': {
    id: 'webapp-components-isolatorframe--fail-to-connect',
    title: 'Webapp components/IsolatorFrame',
    name: 'fail to connect',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--hidden': {
    id: 'webapp-components-isolatorframe--hidden',
    title: 'Webapp components/IsolatorFrame',
    name: 'hidden',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-34': {
    id: 'webapp-components-isolatorframe--storybook-34',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 3.4',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-40': {
    id: 'webapp-components-isolatorframe--storybook-40',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 4.0',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-5': {
    id: 'webapp-components-isolatorframe--storybook-5',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 5',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-5-legacy-package': {
    id: 'webapp-components-isolatorframe--storybook-5-legacy-package',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 5, legacy package',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-5-error': {
    id: 'webapp-components-isolatorframe--storybook-5-error',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 5, error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--storybook-6': {
    id: 'webapp-components-isolatorframe--storybook-6',
    title: 'Webapp components/IsolatorFrame',
    name: 'Storybook 6',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-isolatorframe--invalid-spec': {
    id: 'webapp-components-isolatorframe--invalid-spec',
    title: 'Webapp components/IsolatorFrame',
    name: 'invalid spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-isolatorframe',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist': {
    name: 'LinkList',
    id: 'webapp-components-linklist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-linklist--all-link-lists',
      'webapp-components-linklist--loading',
      'webapp-components-linklist--full',
      'webapp-components-linklist--paginated',
      'webapp-components-linklist--empty-w-custom-noun',
      'webapp-components-linklist--empty',
    ],
    type: 'component',
  },
  'webapp-components-linklist--all-link-lists': {
    id: 'webapp-components-linklist--all-link-lists',
    title: 'Webapp components/LinkList',
    name: 'All LinkLists',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist--loading': {
    id: 'webapp-components-linklist--loading',
    title: 'Webapp components/LinkList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist--full': {
    id: 'webapp-components-linklist--full',
    title: 'Webapp components/LinkList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist--paginated': {
    id: 'webapp-components-linklist--paginated',
    title: 'Webapp components/LinkList',
    name: 'paginated',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist--empty-w-custom-noun': {
    id: 'webapp-components-linklist--empty-w-custom-noun',
    title: 'Webapp components/LinkList',
    name: 'empty w/custom noun',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linklist--empty': {
    id: 'webapp-components-linklist--empty',
    title: 'Webapp components/LinkList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linklist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-linktabs': {
    name: 'LinkTabs',
    id: 'webapp-components-linktabs',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-linktabs--default'],
    type: 'component',
  },
  'webapp-components-linktabs--default': {
    id: 'webapp-components-linktabs--default',
    title: 'Webapp components/LinkTabs',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-linktabs',
    type: 'story',
    prepared: true,
  },
  'webapp-components-listheading': {
    name: 'ListHeading',
    id: 'webapp-components-listheading',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-listheading--all'],
    type: 'component',
  },
  'webapp-components-listheading--all': {
    id: 'webapp-components-listheading--all',
    title: 'Webapp components/ListHeading',
    name: 'all',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-listheading',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview': {
    name: 'LiveView',
    id: 'webapp-components-liveview',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-liveview--storybook-5-preloading',
      'webapp-components-liveview--storybook-34-preloading',
      'webapp-components-liveview--storybook-40-preloading',
      'webapp-components-liveview--storybook-5-visible',
      'webapp-components-liveview--storybook-5-error-visible',
      'webapp-components-liveview--storybook-34-visible',
      'webapp-components-liveview--storybook-40-visible',
      'webapp-components-liveview--pure-downloading',
      'webapp-components-liveview--pure-connecting',
      'webapp-components-liveview--pure-connected',
      'webapp-components-liveview--staging',
      'webapp-components-liveview--production',
    ],
    type: 'component',
  },
  'webapp-components-liveview--storybook-5-preloading': {
    id: 'webapp-components-liveview--storybook-5-preloading',
    title: 'Webapp components/LiveView',
    name: 'Storybook 5, preloading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-34-preloading': {
    id: 'webapp-components-liveview--storybook-34-preloading',
    title: 'Webapp components/LiveView',
    name: 'Storybook 3.4, preloading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-40-preloading': {
    id: 'webapp-components-liveview--storybook-40-preloading',
    title: 'Webapp components/LiveView',
    name: 'Storybook 4.0, preloading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-5-visible': {
    id: 'webapp-components-liveview--storybook-5-visible',
    title: 'Webapp components/LiveView',
    name: 'Storybook 5, visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-5-error-visible': {
    id: 'webapp-components-liveview--storybook-5-error-visible',
    title: 'Webapp components/LiveView',
    name: 'Storybook 5, error, visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-34-visible': {
    id: 'webapp-components-liveview--storybook-34-visible',
    title: 'Webapp components/LiveView',
    name: 'Storybook 3.4, visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--storybook-40-visible': {
    id: 'webapp-components-liveview--storybook-40-visible',
    title: 'Webapp components/LiveView',
    name: 'Storybook 4.0, visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--pure-downloading': {
    id: 'webapp-components-liveview--pure-downloading',
    title: 'Webapp components/LiveView',
    name: 'pure, downloading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--pure-connecting': {
    id: 'webapp-components-liveview--pure-connecting',
    title: 'Webapp components/LiveView',
    name: 'pure, connecting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--pure-connected': {
    id: 'webapp-components-liveview--pure-connected',
    title: 'Webapp components/LiveView',
    name: 'pure, connected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--staging': {
    id: 'webapp-components-liveview--staging',
    title: 'Webapp components/LiveView',
    name: 'Staging',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-liveview--production': {
    id: 'webapp-components-liveview--production',
    title: 'Webapp components/LiveView',
    name: 'Production',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-liveview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-mailinglistsubscribeform': {
    name: 'MailingListSubscribeForm',
    id: 'webapp-components-mailinglistsubscribeform',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-mailinglistsubscribeform--basic',
      'webapp-components-mailinglistsubscribeform--opt-in',
    ],
    type: 'component',
  },
  'webapp-components-mailinglistsubscribeform--basic': {
    id: 'webapp-components-mailinglistsubscribeform--basic',
    title: 'Webapp components/MailingListSubscribeForm',
    name: 'basic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-mailinglistsubscribeform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-mailinglistsubscribeform--opt-in': {
    id: 'webapp-components-mailinglistsubscribeform--opt-in',
    title: 'Webapp components/MailingListSubscribeForm',
    name: 'opt-in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-mailinglistsubscribeform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform': {
    name: 'NewAppForm',
    id: 'webapp-components-newappform',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-newappform--default-personal',
      'webapp-components-newappform--default-personal-creating',
      'webapp-components-newappform--default-personal-unlinked',
      'webapp-components-newappform--default-organization',
      'webapp-components-newappform--default-github-failure',
      'webapp-components-newappform--compact-personal-unlinked',
    ],
    type: 'component',
  },
  'webapp-components-newappform--default-personal': {
    id: 'webapp-components-newappform--default-personal',
    title: 'Webapp components/NewAppForm',
    name: 'default, personal',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform--default-personal-creating': {
    id: 'webapp-components-newappform--default-personal-creating',
    title: 'Webapp components/NewAppForm',
    name: 'default, personal, creating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform--default-personal-unlinked': {
    id: 'webapp-components-newappform--default-personal-unlinked',
    title: 'Webapp components/NewAppForm',
    name: 'default, personal, unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform--default-organization': {
    id: 'webapp-components-newappform--default-organization',
    title: 'Webapp components/NewAppForm',
    name: 'default, organization',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform--default-github-failure': {
    id: 'webapp-components-newappform--default-github-failure',
    title: 'Webapp components/NewAppForm',
    name: 'default, github, failure',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-newappform--compact-personal-unlinked': {
    id: 'webapp-components-newappform--compact-personal-unlinked',
    title: 'Webapp components/NewAppForm',
    name: 'compact, personal, unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-newappform',
    type: 'story',
    prepared: true,
  },
  'webapp-components-notifications': {
    name: 'Notifications',
    id: 'webapp-components-notifications',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-notifications-notification',
      'webapp-components-notifications-notifications',
      'webapp-components-notifications-reviewsyncfailednotification',
      'webapp-components-notifications-syncingnotification',
    ],
    type: 'group',
  },
  'webapp-components-notifications-notification': {
    name: 'Notification',
    id: 'webapp-components-notifications-notification',
    parent: 'webapp-components-notifications',
    depth: 2,
    children: ['webapp-components-notifications-notification--notification'],
    type: 'component',
  },
  'webapp-components-notifications-notification--notification': {
    id: 'webapp-components-notifications-notification--notification',
    title: 'Webapp components/Notifications/Notification',
    name: 'notification',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-notifications-notification',
    type: 'story',
    prepared: true,
  },
  'webapp-components-notifications-notifications': {
    name: 'Notifications',
    id: 'webapp-components-notifications-notifications',
    parent: 'webapp-components-notifications',
    depth: 2,
    children: ['webapp-components-notifications-notifications--with-initial-notifications'],
    type: 'component',
  },
  'webapp-components-notifications-notifications--with-initial-notifications': {
    id: 'webapp-components-notifications-notifications--with-initial-notifications',
    title: 'Webapp components/Notifications/Notifications',
    name: 'with initial notifications',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-notifications-notifications',
    type: 'story',
    prepared: true,
  },
  'webapp-components-notifications-reviewsyncfailednotification': {
    name: 'ReviewSyncFailedNotification',
    id: 'webapp-components-notifications-reviewsyncfailednotification',
    parent: 'webapp-components-notifications',
    depth: 2,
    children: ['webapp-components-notifications-reviewsyncfailednotification--notification'],
    type: 'component',
  },
  'webapp-components-notifications-reviewsyncfailednotification--notification': {
    id: 'webapp-components-notifications-reviewsyncfailednotification--notification',
    title: 'Webapp components/Notifications/ReviewSyncFailedNotification',
    name: 'notification',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-notifications-reviewsyncfailednotification',
    type: 'story',
    prepared: true,
  },
  'webapp-components-notifications-syncingnotification': {
    name: 'SyncingNotification',
    id: 'webapp-components-notifications-syncingnotification',
    parent: 'webapp-components-notifications',
    depth: 2,
    children: ['webapp-components-notifications-syncingnotification--notification'],
    type: 'component',
  },
  'webapp-components-notifications-syncingnotification--notification': {
    id: 'webapp-components-notifications-syncingnotification--notification',
    title: 'Webapp components/Notifications/SyncingNotification',
    name: 'notification',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-components-notifications-syncingnotification',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pageheader': {
    name: 'PageHeader',
    id: 'webapp-components-pageheader',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-pageheader--default',
      'webapp-components-pageheader--loading',
      'webapp-components-pageheader--long',
    ],
    type: 'component',
  },
  'webapp-components-pageheader--default': {
    id: 'webapp-components-pageheader--default',
    title: 'Webapp components/PageHeader',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pageheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pageheader--loading': {
    id: 'webapp-components-pageheader--loading',
    title: 'Webapp components/PageHeader',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pageheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pageheader--long': {
    id: 'webapp-components-pageheader--long',
    title: 'Webapp components/PageHeader',
    name: 'Long',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pageheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pagetitlebar': {
    name: 'PageTitleBar',
    id: 'webapp-components-pagetitlebar',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-pagetitlebar--loading',
      'webapp-components-pagetitlebar--with-actions',
      'webapp-components-pagetitlebar--with-children-and-actions',
    ],
    type: 'component',
  },
  'webapp-components-pagetitlebar--loading': {
    id: 'webapp-components-pagetitlebar--loading',
    title: 'Webapp components/PageTitleBar',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pagetitlebar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pagetitlebar--with-actions': {
    id: 'webapp-components-pagetitlebar--with-actions',
    title: 'Webapp components/PageTitleBar',
    name: 'with actions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pagetitlebar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pagetitlebar--with-children-and-actions': {
    id: 'webapp-components-pagetitlebar--with-children-and-actions',
    title: 'Webapp components/PageTitleBar',
    name: 'with children and actions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pagetitlebar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pagination': {
    name: 'Pagination',
    id: 'webapp-components-pagination',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-pagination--back', 'webapp-components-pagination--next'],
    type: 'component',
  },
  'webapp-components-pagination--back': {
    id: 'webapp-components-pagination--back',
    title: 'Webapp components/Pagination',
    name: 'back',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pagination',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pagination--next': {
    id: 'webapp-components-pagination--next',
    title: 'Webapp components/Pagination',
    name: 'next',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pagination',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectcta': {
    name: 'PaymentCollectCTA',
    id: 'webapp-components-paymentcollectcta',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-paymentcollectcta--account-upgrading'],
    type: 'component',
  },
  'webapp-components-paymentcollectcta--account-upgrading': {
    id: 'webapp-components-paymentcollectcta--account-upgrading',
    title: 'Webapp components/PaymentCollectCTA',
    name: 'account upgrading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectcta',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal': {
    name: 'PaymentCollectModal',
    id: 'webapp-components-paymentcollectmodal',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-paymentcollectmodal--account-upgrading',
      'webapp-components-paymentcollectmodal--pre-subscribed',
      'webapp-components-paymentcollectmodal--exceeded-threshold',
      'webapp-components-paymentcollectmodal--free',
      'webapp-components-paymentcollectmodal--in-trial',
      'webapp-components-paymentcollectmodal--trial-ending',
      'webapp-components-paymentcollectmodal--payment-failed',
      'webapp-components-paymentcollectmodal--payment-required',
    ],
    type: 'component',
  },
  'webapp-components-paymentcollectmodal--account-upgrading': {
    id: 'webapp-components-paymentcollectmodal--account-upgrading',
    title: 'Webapp components/PaymentCollectModal',
    name: 'account upgrading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--pre-subscribed': {
    id: 'webapp-components-paymentcollectmodal--pre-subscribed',
    title: 'Webapp components/PaymentCollectModal',
    name: 'Pre Subscribed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--exceeded-threshold': {
    id: 'webapp-components-paymentcollectmodal--exceeded-threshold',
    title: 'Webapp components/PaymentCollectModal',
    name: 'Exceeded Threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--free': {
    id: 'webapp-components-paymentcollectmodal--free',
    title: 'Webapp components/PaymentCollectModal',
    name: 'Free',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--in-trial': {
    id: 'webapp-components-paymentcollectmodal--in-trial',
    title: 'Webapp components/PaymentCollectModal',
    name: 'in trial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--trial-ending': {
    id: 'webapp-components-paymentcollectmodal--trial-ending',
    title: 'Webapp components/PaymentCollectModal',
    name: 'trial ending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--payment-failed': {
    id: 'webapp-components-paymentcollectmodal--payment-failed',
    title: 'Webapp components/PaymentCollectModal',
    name: 'payment failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymentcollectmodal--payment-required': {
    id: 'webapp-components-paymentcollectmodal--payment-required',
    title: 'Webapp components/PaymentCollectModal',
    name: 'payment required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymentcollectmodal',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymenteyebrow': {
    name: 'PaymentEyebrow',
    id: 'webapp-components-paymenteyebrow',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-paymenteyebrow--trial-ending',
      'webapp-components-paymenteyebrow--payment-failed',
      'webapp-components-paymenteyebrow--payment-required',
      'webapp-components-paymenteyebrow--exceeded-threshold',
    ],
    type: 'component',
  },
  'webapp-components-paymenteyebrow--trial-ending': {
    id: 'webapp-components-paymenteyebrow--trial-ending',
    title: 'Webapp components/PaymentEyebrow',
    name: 'trial ending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymenteyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymenteyebrow--payment-failed': {
    id: 'webapp-components-paymenteyebrow--payment-failed',
    title: 'Webapp components/PaymentEyebrow',
    name: 'payment failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymenteyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymenteyebrow--payment-required': {
    id: 'webapp-components-paymenteyebrow--payment-required',
    title: 'Webapp components/PaymentEyebrow',
    name: 'payment required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymenteyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-paymenteyebrow--exceeded-threshold': {
    id: 'webapp-components-paymenteyebrow--exceeded-threshold',
    title: 'Webapp components/PaymentEyebrow',
    name: 'exceeded threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-paymenteyebrow',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar': {
    name: 'ProgressBar',
    id: 'webapp-components-progressbar',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-progressbar--loading',
      'webapp-components-progressbar--short',
      'webapp-components-progressbar--inprogress-25',
      'webapp-components-progressbar--inprogress-50',
      'webapp-components-progressbar--inprogress-tooltip',
      'webapp-components-progressbar--reviewing-partial',
      'webapp-components-progressbar--reviewing-complete',
    ],
    type: 'component',
  },
  'webapp-components-progressbar--loading': {
    id: 'webapp-components-progressbar--loading',
    title: 'Webapp components/ProgressBar',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--short': {
    id: 'webapp-components-progressbar--short',
    title: 'Webapp components/ProgressBar',
    name: 'short',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--inprogress-25': {
    id: 'webapp-components-progressbar--inprogress-25',
    title: 'Webapp components/ProgressBar',
    name: 'inprogress 25',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--inprogress-50': {
    id: 'webapp-components-progressbar--inprogress-50',
    title: 'Webapp components/ProgressBar',
    name: 'inprogress 50',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--inprogress-tooltip': {
    id: 'webapp-components-progressbar--inprogress-tooltip',
    title: 'Webapp components/ProgressBar',
    name: 'inprogress, tooltip',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--reviewing-partial': {
    id: 'webapp-components-progressbar--reviewing-partial',
    title: 'Webapp components/ProgressBar',
    name: 'reviewing partial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-progressbar--reviewing-complete': {
    id: 'webapp-components-progressbar--reviewing-complete',
    title: 'Webapp components/ProgressBar',
    name: 'reviewing complete',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-progressbar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem': {
    name: 'ProjectItem',
    id: 'webapp-components-projectitem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-projectitem--all-project-item',
      'webapp-components-projectitem--loading',
      'webapp-components-projectitem--app-screen-loading-see-1196',
      'webapp-components-projectitem--default',
      'webapp-components-projectitem--default-no-account-name',
      'webapp-components-projectitem--default-few-users',
      'webapp-components-projectitem--in-setup',
    ],
    type: 'component',
  },
  'webapp-components-projectitem--all-project-item': {
    id: 'webapp-components-projectitem--all-project-item',
    title: 'Webapp components/ProjectItem',
    name: 'All ProjectItem',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--loading': {
    id: 'webapp-components-projectitem--loading',
    title: 'Webapp components/ProjectItem',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--app-screen-loading-see-1196': {
    id: 'webapp-components-projectitem--app-screen-loading-see-1196',
    title: 'Webapp components/ProjectItem',
    name: 'app screen loading (see #1196)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--default': {
    id: 'webapp-components-projectitem--default',
    title: 'Webapp components/ProjectItem',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--default-no-account-name': {
    id: 'webapp-components-projectitem--default-no-account-name',
    title: 'Webapp components/ProjectItem',
    name: 'default, noAccountName',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--default-few-users': {
    id: 'webapp-components-projectitem--default-few-users',
    title: 'Webapp components/ProjectItem',
    name: 'default few users',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectitem--in-setup': {
    id: 'webapp-components-projectitem--in-setup',
    title: 'Webapp components/ProjectItem',
    name: 'in setup',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectlist': {
    name: 'ProjectList',
    id: 'webapp-components-projectlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-projectlist--loading',
      'webapp-components-projectlist--full',
      'webapp-components-projectlist--full-no-account-name',
    ],
    type: 'component',
  },
  'webapp-components-projectlist--loading': {
    id: 'webapp-components-projectlist--loading',
    title: 'Webapp components/ProjectList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectlist--full': {
    id: 'webapp-components-projectlist--full',
    title: 'Webapp components/ProjectList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-projectlist--full-no-account-name': {
    id: 'webapp-components-projectlist--full-no-account-name',
    title: 'Webapp components/ProjectList',
    name: 'full, no account name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-projectlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem': {
    name: 'PullRequestItem',
    id: 'webapp-components-pullrequestitem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-pullrequestitem--all-pull-request-item',
      'webapp-components-pullrequestitem--loading',
      'webapp-components-pullrequestitem--unbuilt',
      'webapp-components-pullrequestitem--building',
      'webapp-components-pullrequestitem--passed',
      'webapp-components-pullrequestitem--pending',
      'webapp-components-pullrequestitem--errored-diffs',
      'webapp-components-pullrequestitem--errored-build-closed',
    ],
    type: 'component',
  },
  'webapp-components-pullrequestitem--all-pull-request-item': {
    id: 'webapp-components-pullrequestitem--all-pull-request-item',
    title: 'Webapp components/PullRequestItem',
    name: 'All PullRequestItem',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--loading': {
    id: 'webapp-components-pullrequestitem--loading',
    title: 'Webapp components/PullRequestItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--unbuilt': {
    id: 'webapp-components-pullrequestitem--unbuilt',
    title: 'Webapp components/PullRequestItem',
    name: 'Unbuilt',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--building': {
    id: 'webapp-components-pullrequestitem--building',
    title: 'Webapp components/PullRequestItem',
    name: 'Building',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--passed': {
    id: 'webapp-components-pullrequestitem--passed',
    title: 'Webapp components/PullRequestItem',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--pending': {
    id: 'webapp-components-pullrequestitem--pending',
    title: 'Webapp components/PullRequestItem',
    name: 'Pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--errored-diffs': {
    id: 'webapp-components-pullrequestitem--errored-diffs',
    title: 'Webapp components/PullRequestItem',
    name: 'Errored Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestitem--errored-build-closed': {
    id: 'webapp-components-pullrequestitem--errored-build-closed',
    title: 'Webapp components/PullRequestItem',
    name: 'Errored build, closed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist': {
    name: 'PullRequestList',
    id: 'webapp-components-pullrequestlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-pullrequestlist--loading',
      'webapp-components-pullrequestlist--full',
      'webapp-components-pullrequestlist--full-ui-review-disabled',
      'webapp-components-pullrequestlist--empty',
      'webapp-components-pullrequestlist--empty-branch',
      'webapp-components-pullrequestlist--error',
    ],
    type: 'component',
  },
  'webapp-components-pullrequestlist--loading': {
    id: 'webapp-components-pullrequestlist--loading',
    title: 'Webapp components/PullRequestList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist--full': {
    id: 'webapp-components-pullrequestlist--full',
    title: 'Webapp components/PullRequestList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist--full-ui-review-disabled': {
    id: 'webapp-components-pullrequestlist--full-ui-review-disabled',
    title: 'Webapp components/PullRequestList',
    name: 'full, UI review disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist--empty': {
    id: 'webapp-components-pullrequestlist--empty',
    title: 'Webapp components/PullRequestList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist--empty-branch': {
    id: 'webapp-components-pullrequestlist--empty-branch',
    title: 'Webapp components/PullRequestList',
    name: 'empty branch',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequestlist--error': {
    id: 'webapp-components-pullrequestlist--error',
    title: 'Webapp components/PullRequestList',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequestlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight': {
    name: 'PullRequestStatusLight',
    id: 'webapp-components-pullrequeststatuslight',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-pullrequeststatuslight--loading',
      'webapp-components-pullrequeststatuslight--passed',
      'webapp-components-pullrequeststatuslight--no-builds',
      'webapp-components-pullrequeststatuslight--checklist',
      'webapp-components-pullrequeststatuslight--errored-diffs',
      'webapp-components-pullrequeststatuslight--errored-diffs-and-checklist',
      'webapp-components-pullrequeststatuslight--build-in-progress',
      'webapp-components-pullrequeststatuslight--comparison-in-progress',
      'webapp-components-pullrequeststatuslight--build-error',
      'webapp-components-pullrequeststatuslight--comparison-error',
      'webapp-components-pullrequeststatuslight--paused',
      'webapp-components-pullrequeststatuslight--payment-required',
      'webapp-components-pullrequeststatuslight--publish-only',
      'webapp-components-pullrequeststatuslight--publish-only-build-in-progress',
      'webapp-components-pullrequeststatuslight--publish-only-build-error',
      'webapp-components-pullrequeststatuslight--ui-review-disabled',
      'webapp-components-pullrequeststatuslight--ui-review-disabled-build-in-progress',
      'webapp-components-pullrequeststatuslight--ui-review-disabled-build-error',
      'webapp-components-pullrequeststatuslight--ui-review-disabled-publish-only',
      'webapp-components-pullrequeststatuslight--ui-review-disabled-paused',
      'webapp-components-pullrequeststatuslight--tiny',
    ],
    type: 'component',
  },
  'webapp-components-pullrequeststatuslight--loading': {
    id: 'webapp-components-pullrequeststatuslight--loading',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--passed': {
    id: 'webapp-components-pullrequeststatuslight--passed',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--no-builds': {
    id: 'webapp-components-pullrequeststatuslight--no-builds',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'No Builds',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--checklist': {
    id: 'webapp-components-pullrequeststatuslight--checklist',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Checklist',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--errored-diffs': {
    id: 'webapp-components-pullrequeststatuslight--errored-diffs',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Errored Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--errored-diffs-and-checklist': {
    id: 'webapp-components-pullrequeststatuslight--errored-diffs-and-checklist',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Errored Diffs And Checklist',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--build-in-progress': {
    id: 'webapp-components-pullrequeststatuslight--build-in-progress',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--comparison-in-progress': {
    id: 'webapp-components-pullrequeststatuslight--comparison-in-progress',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Comparison In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--build-error': {
    id: 'webapp-components-pullrequeststatuslight--build-error',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--comparison-error': {
    id: 'webapp-components-pullrequeststatuslight--comparison-error',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Comparison Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--paused': {
    id: 'webapp-components-pullrequeststatuslight--paused',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--payment-required': {
    id: 'webapp-components-pullrequeststatuslight--payment-required',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--publish-only': {
    id: 'webapp-components-pullrequeststatuslight--publish-only',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--publish-only-build-in-progress': {
    id: 'webapp-components-pullrequeststatuslight--publish-only-build-in-progress',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Publish Only, Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--publish-only-build-error': {
    id: 'webapp-components-pullrequeststatuslight--publish-only-build-error',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Publish Only, Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--ui-review-disabled': {
    id: 'webapp-components-pullrequeststatuslight--ui-review-disabled',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--ui-review-disabled-build-in-progress': {
    id: 'webapp-components-pullrequeststatuslight--ui-review-disabled-build-in-progress',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'UI Review Disabled, Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--ui-review-disabled-build-error': {
    id: 'webapp-components-pullrequeststatuslight--ui-review-disabled-build-error',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'UI Review Disabled, Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--ui-review-disabled-publish-only': {
    id: 'webapp-components-pullrequeststatuslight--ui-review-disabled-publish-only',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'UI Review Disabled, Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--ui-review-disabled-paused': {
    id: 'webapp-components-pullrequeststatuslight--ui-review-disabled-paused',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'UI Review Disabled, Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-pullrequeststatuslight--tiny': {
    id: 'webapp-components-pullrequeststatuslight--tiny',
    title: 'Webapp components/PullRequestStatusLight',
    name: 'Tiny',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-pullrequeststatuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-questiontooltip': {
    name: 'QuestionTooltip',
    id: 'webapp-components-questiontooltip',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-questiontooltip--default',
      'webapp-components-questiontooltip--start-open',
    ],
    type: 'component',
  },
  'webapp-components-questiontooltip--default': {
    id: 'webapp-components-questiontooltip--default',
    title: 'Webapp components/QuestionTooltip',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-questiontooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-questiontooltip--start-open': {
    id: 'webapp-components-questiontooltip--start-open',
    title: 'Webapp components/QuestionTooltip',
    name: 'start open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-questiontooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-radar': {
    name: 'Radar',
    id: 'webapp-components-radar',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-radar--radar'],
    type: 'component',
  },
  'webapp-components-radar--radar': {
    id: 'webapp-components-radar--radar',
    title: 'Webapp components/Radar',
    name: 'Radar',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-radar',
    type: 'story',
    prepared: true,
  },
  'webapp-components-radio': {
    name: 'Radio',
    id: 'webapp-components-radio',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-radio--all-radios',
      'webapp-components-radio--unchecked',
      'webapp-components-radio--checked',
      'webapp-components-radio--primary',
    ],
    type: 'component',
  },
  'webapp-components-radio--all-radios': {
    id: 'webapp-components-radio--all-radios',
    title: 'Webapp components/Radio',
    name: 'all radios',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-radio',
    type: 'story',
    prepared: true,
  },
  'webapp-components-radio--unchecked': {
    id: 'webapp-components-radio--unchecked',
    title: 'Webapp components/Radio',
    name: 'unchecked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-radio',
    type: 'story',
    prepared: true,
  },
  'webapp-components-radio--checked': {
    id: 'webapp-components-radio--checked',
    title: 'Webapp components/Radio',
    name: 'checked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-radio',
    type: 'story',
    prepared: true,
  },
  'webapp-components-radio--primary': {
    id: 'webapp-components-radio--primary',
    title: 'Webapp components/Radio',
    name: 'primary',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-radio',
    type: 'story',
    prepared: true,
  },
  'webapp-components-rawspeclist': {
    name: 'RawSpecList',
    id: 'webapp-components-rawspeclist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-rawspeclist--loading',
      'webapp-components-rawspeclist--default',
      'webapp-components-rawspeclist--empty',
    ],
    type: 'component',
  },
  'webapp-components-rawspeclist--loading': {
    id: 'webapp-components-rawspeclist--loading',
    title: 'Webapp components/RawSpecList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-rawspeclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-rawspeclist--default': {
    id: 'webapp-components-rawspeclist--default',
    title: 'Webapp components/RawSpecList',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-rawspeclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-rawspeclist--empty': {
    id: 'webapp-components-rawspeclist--empty',
    title: 'Webapp components/RawSpecList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-rawspeclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositoryitem': {
    name: 'RepositoryItem',
    id: 'webapp-components-repositoryitem',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-repositoryitem--default'],
    type: 'component',
  },
  'webapp-components-repositoryitem--default': {
    id: 'webapp-components-repositoryitem--default',
    title: 'Webapp components/RepositoryItem',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositoryitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorylist': {
    name: 'RepositoryList',
    id: 'webapp-components-repositorylist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-repositorylist--personal',
      'webapp-components-repositorylist--personal-bitbucket',
      'webapp-components-repositorylist--empty',
      'webapp-components-repositorylist--empty-bitbucket',
    ],
    type: 'component',
  },
  'webapp-components-repositorylist--personal': {
    id: 'webapp-components-repositorylist--personal',
    title: 'Webapp components/RepositoryList',
    name: 'personal',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorylist--personal-bitbucket': {
    id: 'webapp-components-repositorylist--personal-bitbucket',
    title: 'Webapp components/RepositoryList',
    name: 'personal, bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorylist--empty': {
    id: 'webapp-components-repositorylist--empty',
    title: 'Webapp components/RepositoryList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorylist--empty-bitbucket': {
    id: 'webapp-components-repositorylist--empty-bitbucket',
    title: 'Webapp components/RepositoryList',
    name: 'empty, bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorylist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositoryowneritem': {
    name: 'RepositoryOwnerItem',
    id: 'webapp-components-repositoryowneritem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-repositoryowneritem--user',
      'webapp-components-repositoryowneritem--org',
    ],
    type: 'component',
  },
  'webapp-components-repositoryowneritem--user': {
    id: 'webapp-components-repositoryowneritem--user',
    title: 'Webapp components/RepositoryOwnerItem',
    name: 'user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositoryowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositoryowneritem--org': {
    id: 'webapp-components-repositoryowneritem--org',
    title: 'Webapp components/RepositoryOwnerItem',
    name: 'org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositoryowneritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositoryownerlist': {
    name: 'RepositoryOwnerList',
    id: 'webapp-components-repositoryownerlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-repositoryownerlist--user-selected',
      'webapp-components-repositoryownerlist--org-selected',
    ],
    type: 'component',
  },
  'webapp-components-repositoryownerlist--user-selected': {
    id: 'webapp-components-repositoryownerlist--user-selected',
    title: 'Webapp components/RepositoryOwnerList',
    name: 'user selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositoryownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositoryownerlist--org-selected': {
    id: 'webapp-components-repositoryownerlist--org-selected',
    title: 'Webapp components/RepositoryOwnerList',
    name: 'org selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositoryownerlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorypicker': {
    name: 'RepositoryPicker',
    id: 'webapp-components-repositorypicker',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-repositorypicker--loading',
      'webapp-components-repositorypicker--personal',
      'webapp-components-repositorypicker--personal-w-no-apps',
      'webapp-components-repositorypicker--organization',
      'webapp-components-repositorypicker--organization-w-no-apps',
    ],
    type: 'component',
  },
  'webapp-components-repositorypicker--loading': {
    id: 'webapp-components-repositorypicker--loading',
    title: 'Webapp components/RepositoryPicker',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorypicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorypicker--personal': {
    id: 'webapp-components-repositorypicker--personal',
    title: 'Webapp components/RepositoryPicker',
    name: 'personal',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorypicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorypicker--personal-w-no-apps': {
    id: 'webapp-components-repositorypicker--personal-w-no-apps',
    title: 'Webapp components/RepositoryPicker',
    name: 'personal w/ no apps',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorypicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorypicker--organization': {
    id: 'webapp-components-repositorypicker--organization',
    title: 'Webapp components/RepositoryPicker',
    name: 'organization',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorypicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-repositorypicker--organization-w-no-apps': {
    id: 'webapp-components-repositorypicker--organization-w-no-apps',
    title: 'Webapp components/RepositoryPicker',
    name: 'organization w/ no apps',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-repositorypicker',
    type: 'story',
    prepared: true,
  },
  'webapp-components-scrollintoview': {
    name: 'ScrollIntoView',
    id: 'webapp-components-scrollintoview',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-scrollintoview--w-scroll-into-view',
      'webapp-components-scrollintoview--w-out-scroll-into-view',
    ],
    type: 'component',
  },
  'webapp-components-scrollintoview--w-scroll-into-view': {
    id: 'webapp-components-scrollintoview--w-scroll-into-view',
    title: 'Webapp components/ScrollIntoView',
    name: 'w/ scroll into view',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-scrollintoview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-scrollintoview--w-out-scroll-into-view': {
    id: 'webapp-components-scrollintoview--w-out-scroll-into-view',
    title: 'Webapp components/ScrollIntoView',
    name: 'w/out scroll into view',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-scrollintoview',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section': {
    name: 'Section',
    id: 'webapp-components-section',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-section--full',
      'webapp-components-section--with-children',
      'webapp-components-section--with-callout',
      'webapp-components-section--multiple-sections-nochrome',
      'webapp-components-section--blank',
      'webapp-components-section--loading',
    ],
    type: 'component',
  },
  'webapp-components-section--full': {
    id: 'webapp-components-section--full',
    title: 'Webapp components/Section',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section--with-children': {
    id: 'webapp-components-section--with-children',
    title: 'Webapp components/Section',
    name: 'with children',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section--with-callout': {
    id: 'webapp-components-section--with-callout',
    title: 'Webapp components/Section',
    name: 'with callout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section--multiple-sections-nochrome': {
    id: 'webapp-components-section--multiple-sections-nochrome',
    title: 'Webapp components/Section',
    name: 'multiple sections nochrome',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section--blank': {
    id: 'webapp-components-section--blank',
    title: 'Webapp components/Section',
    name: 'blank',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-section--loading': {
    id: 'webapp-components-section--loading',
    title: 'Webapp components/Section',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-section',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sharetooltipmessage': {
    name: 'ShareTooltipMessage',
    id: 'webapp-components-sharetooltipmessage',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-sharetooltipmessage--unlinked',
      'webapp-components-sharetooltipmessage--linked',
    ],
    type: 'component',
  },
  'webapp-components-sharetooltipmessage--unlinked': {
    id: 'webapp-components-sharetooltipmessage--unlinked',
    title: 'Webapp components/ShareTooltipMessage',
    name: 'Unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sharetooltipmessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sharetooltipmessage--linked': {
    id: 'webapp-components-sharetooltipmessage--linked',
    title: 'Webapp components/ShareTooltipMessage',
    name: 'Linked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sharetooltipmessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sidebarnav': {
    name: 'SidebarNav',
    id: 'webapp-components-sidebarnav',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-sidebarnav--loading',
      'webapp-components-sidebarnav--account',
      'webapp-components-sidebarnav--project',
      'webapp-components-sidebarnav--project-setup',
    ],
    type: 'component',
  },
  'webapp-components-sidebarnav--loading': {
    id: 'webapp-components-sidebarnav--loading',
    title: 'Webapp components/SidebarNav',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sidebarnav',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sidebarnav--account': {
    id: 'webapp-components-sidebarnav--account',
    title: 'Webapp components/SidebarNav',
    name: 'account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sidebarnav',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sidebarnav--project': {
    id: 'webapp-components-sidebarnav--project',
    title: 'Webapp components/SidebarNav',
    name: 'project',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sidebarnav',
    type: 'story',
    prepared: true,
  },
  'webapp-components-sidebarnav--project-setup': {
    id: 'webapp-components-sidebarnav--project-setup',
    title: 'Webapp components/SidebarNav',
    name: 'project setup',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-sidebarnav',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterror': {
    name: 'SnapshotError',
    id: 'webapp-components-snapshoterror',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-snapshoterror--default',
      'webapp-components-snapshoterror--with-metadata',
    ],
    type: 'component',
  },
  'webapp-components-snapshoterror--default': {
    id: 'webapp-components-snapshoterror--default',
    title: 'Webapp components/SnapshotError',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterror',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterror--with-metadata': {
    id: 'webapp-components-snapshoterror--with-metadata',
    title: 'Webapp components/SnapshotError',
    name: 'With Metadata',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterror',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterrormessage': {
    name: 'SnapshotErrorMessage',
    id: 'webapp-components-snapshoterrormessage',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-snapshoterrormessage--image-too-large',
      'webapp-components-snapshoterrormessage--navigation-timeout',
      'webapp-components-snapshoterrormessage--no-js',
      'webapp-components-snapshoterrormessage--failed-js',
      'webapp-components-snapshoterrormessage--story-missing',
    ],
    type: 'component',
  },
  'webapp-components-snapshoterrormessage--image-too-large': {
    id: 'webapp-components-snapshoterrormessage--image-too-large',
    title: 'Webapp components/SnapshotErrorMessage',
    name: 'Image Too Large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterrormessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterrormessage--navigation-timeout': {
    id: 'webapp-components-snapshoterrormessage--navigation-timeout',
    title: 'Webapp components/SnapshotErrorMessage',
    name: 'Navigation Timeout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterrormessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterrormessage--no-js': {
    id: 'webapp-components-snapshoterrormessage--no-js',
    title: 'Webapp components/SnapshotErrorMessage',
    name: 'No JS',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterrormessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterrormessage--failed-js': {
    id: 'webapp-components-snapshoterrormessage--failed-js',
    title: 'Webapp components/SnapshotErrorMessage',
    name: 'Failed JS',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterrormessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshoterrormessage--story-missing': {
    id: 'webapp-components-snapshoterrormessage--story-missing',
    title: 'Webapp components/SnapshotErrorMessage',
    name: 'Story Missing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshoterrormessage',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshotsizechanged': {
    name: 'SnapshotSizeChanged',
    id: 'webapp-components-snapshotsizechanged',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-snapshotsizechanged--width-increased',
      'webapp-components-snapshotsizechanged--width-decreased',
      'webapp-components-snapshotsizechanged--height-increased',
      'webapp-components-snapshotsizechanged--height-decreased',
    ],
    type: 'component',
  },
  'webapp-components-snapshotsizechanged--width-increased': {
    id: 'webapp-components-snapshotsizechanged--width-increased',
    title: 'Webapp components/SnapshotSizeChanged',
    name: 'width increased',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshotsizechanged',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshotsizechanged--width-decreased': {
    id: 'webapp-components-snapshotsizechanged--width-decreased',
    title: 'Webapp components/SnapshotSizeChanged',
    name: 'width decreased',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshotsizechanged',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshotsizechanged--height-increased': {
    id: 'webapp-components-snapshotsizechanged--height-increased',
    title: 'Webapp components/SnapshotSizeChanged',
    name: 'height increased',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshotsizechanged',
    type: 'story',
    prepared: true,
  },
  'webapp-components-snapshotsizechanged--height-decreased': {
    id: 'webapp-components-snapshotsizechanged--height-decreased',
    title: 'Webapp components/SnapshotSizeChanged',
    name: 'height decreased',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-snapshotsizechanged',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem': {
    name: 'SpecItem',
    id: 'webapp-components-specitem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-specitem--all',
      'webapp-components-specitem--loading',
      'webapp-components-specitem--needs-review',
      'webapp-components-specitem--default',
      'webapp-components-specitem--long-name',
      'webapp-components-specitem--selected',
      'webapp-components-specitem--w-ignored-selectors',
    ],
    type: 'component',
  },
  'webapp-components-specitem--all': {
    id: 'webapp-components-specitem--all',
    title: 'Webapp components/SpecItem',
    name: 'All',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--loading': {
    id: 'webapp-components-specitem--loading',
    title: 'Webapp components/SpecItem',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--needs-review': {
    id: 'webapp-components-specitem--needs-review',
    title: 'Webapp components/SpecItem',
    name: 'needs review',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--default': {
    id: 'webapp-components-specitem--default',
    title: 'Webapp components/SpecItem',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--long-name': {
    id: 'webapp-components-specitem--long-name',
    title: 'Webapp components/SpecItem',
    name: 'long name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--selected': {
    id: 'webapp-components-specitem--selected',
    title: 'Webapp components/SpecItem',
    name: 'selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specitem--w-ignored-selectors': {
    id: 'webapp-components-specitem--w-ignored-selectors',
    title: 'Webapp components/SpecItem',
    name: 'w/ignored selectors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specitem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-speclist': {
    name: 'SpecList',
    id: 'webapp-components-speclist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-speclist--loading',
      'webapp-components-speclist--full',
      'webapp-components-speclist--empty',
    ],
    type: 'component',
  },
  'webapp-components-speclist--loading': {
    id: 'webapp-components-speclist--loading',
    title: 'Webapp components/SpecList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-speclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-speclist--full': {
    id: 'webapp-components-speclist--full',
    title: 'Webapp components/SpecList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-speclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-speclist--empty': {
    id: 'webapp-components-speclist--empty',
    title: 'Webapp components/SpecList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-speclist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specname': {
    name: 'SpecName',
    id: 'webapp-components-specname',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-specname--basic',
      'webapp-components-specname--basic-is-link',
      'webapp-components-specname--unnamed',
      'webapp-components-specname--with-build-number',
    ],
    type: 'component',
  },
  'webapp-components-specname--basic': {
    id: 'webapp-components-specname--basic',
    title: 'Webapp components/SpecName',
    name: 'basic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specname',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specname--basic-is-link': {
    id: 'webapp-components-specname--basic-is-link',
    title: 'Webapp components/SpecName',
    name: 'basic isLink',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specname',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specname--unnamed': {
    id: 'webapp-components-specname--unnamed',
    title: 'Webapp components/SpecName',
    name: 'unnamed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specname',
    type: 'story',
    prepared: true,
  },
  'webapp-components-specname--with-build-number': {
    id: 'webapp-components-specname--with-build-number',
    title: 'Webapp components/SpecName',
    name: 'with build number',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-specname',
    type: 'story',
    prepared: true,
  },
  'webapp-components-startchat': {
    name: 'StartChat',
    id: 'webapp-components-startchat',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-startchat--base', 'webapp-components-startchat--custom'],
    type: 'component',
  },
  'webapp-components-startchat--base': {
    id: 'webapp-components-startchat--base',
    title: 'Webapp components/StartChat',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-startchat',
    type: 'story',
    prepared: true,
  },
  'webapp-components-startchat--custom': {
    id: 'webapp-components-startchat--custom',
    title: 'Webapp components/StartChat',
    name: 'Custom',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-startchat',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight': {
    name: 'StatusLight',
    id: 'webapp-components-statuslight',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-statuslight--all-statuslights',
      'webapp-components-statuslight--positive',
      'webapp-components-statuslight--negative',
      'webapp-components-statuslight--warning',
      'webapp-components-statuslight--loading',
      'webapp-components-statuslight--disabled',
      'webapp-components-statuslight--progress',
      'webapp-components-statuslight--error',
      'webapp-components-statuslight--tiny',
      'webapp-components-statuslight--small',
      'webapp-components-statuslight--medium',
      'webapp-components-statuslight--large',
    ],
    type: 'component',
  },
  'webapp-components-statuslight--all-statuslights': {
    id: 'webapp-components-statuslight--all-statuslights',
    title: 'Webapp components/StatusLight',
    name: 'all statuslights',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--positive': {
    id: 'webapp-components-statuslight--positive',
    title: 'Webapp components/StatusLight',
    name: 'positive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--negative': {
    id: 'webapp-components-statuslight--negative',
    title: 'Webapp components/StatusLight',
    name: 'negative',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--warning': {
    id: 'webapp-components-statuslight--warning',
    title: 'Webapp components/StatusLight',
    name: 'warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--loading': {
    id: 'webapp-components-statuslight--loading',
    title: 'Webapp components/StatusLight',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--disabled': {
    id: 'webapp-components-statuslight--disabled',
    title: 'Webapp components/StatusLight',
    name: 'disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--progress': {
    id: 'webapp-components-statuslight--progress',
    title: 'Webapp components/StatusLight',
    name: 'progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--error': {
    id: 'webapp-components-statuslight--error',
    title: 'Webapp components/StatusLight',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--tiny': {
    id: 'webapp-components-statuslight--tiny',
    title: 'Webapp components/StatusLight',
    name: 'tiny',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--small': {
    id: 'webapp-components-statuslight--small',
    title: 'Webapp components/StatusLight',
    name: 'small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--medium': {
    id: 'webapp-components-statuslight--medium',
    title: 'Webapp components/StatusLight',
    name: 'medium',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statuslight--large': {
    id: 'webapp-components-statuslight--large',
    title: 'Webapp components/StatusLight',
    name: 'large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statuslight',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statustooltip': {
    name: 'StatusTooltip',
    id: 'webapp-components-statustooltip',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-statustooltip--base',
      'webapp-components-statustooltip--with-message',
      'webapp-components-statustooltip--single-link',
      'webapp-components-statustooltip--multiple-links',
    ],
    type: 'component',
  },
  'webapp-components-statustooltip--base': {
    id: 'webapp-components-statustooltip--base',
    title: 'Webapp components/StatusTooltip',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statustooltip--with-message': {
    id: 'webapp-components-statustooltip--with-message',
    title: 'Webapp components/StatusTooltip',
    name: 'With Message',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statustooltip--single-link': {
    id: 'webapp-components-statustooltip--single-link',
    title: 'Webapp components/StatusTooltip',
    name: 'Single Link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-statustooltip--multiple-links': {
    id: 'webapp-components-statustooltip--multiple-links',
    title: 'Webapp components/StatusTooltip',
    name: 'Multiple Links',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-statustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-components-subheader': {
    name: 'Subheader',
    id: 'webapp-components-subheader',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-subheader--all',
      'webapp-components-subheader--loading',
      'webapp-components-subheader--full',
      'webapp-components-subheader--left',
    ],
    type: 'component',
  },
  'webapp-components-subheader--all': {
    id: 'webapp-components-subheader--all',
    title: 'Webapp components/Subheader',
    name: 'all',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-subheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-subheader--loading': {
    id: 'webapp-components-subheader--loading',
    title: 'Webapp components/Subheader',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-subheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-subheader--full': {
    id: 'webapp-components-subheader--full',
    title: 'Webapp components/Subheader',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-subheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-subheader--left': {
    id: 'webapp-components-subheader--left',
    title: 'Webapp components/Subheader',
    name: 'left',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-subheader',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table': {
    name: 'Table',
    id: 'webapp-components-table',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-table--all-tables',
      'webapp-components-table--loading',
      'webapp-components-table--empty',
      'webapp-components-table--full',
      'webapp-components-table--with-drawers',
      'webapp-components-table--without-headings',
    ],
    type: 'component',
  },
  'webapp-components-table--all-tables': {
    id: 'webapp-components-table--all-tables',
    title: 'Webapp components/Table',
    name: 'All tables',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table--loading': {
    id: 'webapp-components-table--loading',
    title: 'Webapp components/Table',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table--empty': {
    id: 'webapp-components-table--empty',
    title: 'Webapp components/Table',
    name: 'Empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table--full': {
    id: 'webapp-components-table--full',
    title: 'Webapp components/Table',
    name: 'Full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table--with-drawers': {
    id: 'webapp-components-table--with-drawers',
    title: 'Webapp components/Table',
    name: 'With drawers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-table--without-headings': {
    id: 'webapp-components-table--without-headings',
    title: 'Webapp components/Table',
    name: 'Without headings',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-table',
    type: 'story',
    prepared: true,
  },
  'webapp-components-tabledrawer': {
    name: 'TableDrawer',
    id: 'webapp-components-tabledrawer',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-tabledrawer--open'],
    type: 'component',
  },
  'webapp-components-tabledrawer--open': {
    id: 'webapp-components-tabledrawer--open',
    title: 'Webapp components/TableDrawer',
    name: 'open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-tabledrawer',
    type: 'story',
    prepared: true,
  },
  'webapp-components-tooltipignore': {
    name: 'TooltipIgnore',
    id: 'webapp-components-tooltipignore',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-tooltipignore--default'],
    type: 'component',
  },
  'webapp-components-tooltipignore--default': {
    id: 'webapp-components-tooltipignore--default',
    title: 'Webapp components/TooltipIgnore',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-tooltipignore',
    type: 'story',
    prepared: true,
  },
  'webapp-components-useritem': {
    name: 'UserItem',
    id: 'webapp-components-useritem',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-useritem--all-user-items',
      'webapp-components-useritem--loading',
      'webapp-components-useritem--no-link',
      'webapp-components-useritem--link',
    ],
    type: 'component',
  },
  'webapp-components-useritem--all-user-items': {
    id: 'webapp-components-useritem--all-user-items',
    title: 'Webapp components/UserItem',
    name: 'All UserItems',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-useritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-useritem--loading': {
    id: 'webapp-components-useritem--loading',
    title: 'Webapp components/UserItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-useritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-useritem--no-link': {
    id: 'webapp-components-useritem--no-link',
    title: 'Webapp components/UserItem',
    name: 'No link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-useritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-useritem--link': {
    id: 'webapp-components-useritem--link',
    title: 'Webapp components/UserItem',
    name: 'Link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-useritem',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist': {
    name: 'UserList',
    id: 'webapp-components-userlist',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-userlist--all-user-lists',
      'webapp-components-userlist--loading',
      'webapp-components-userlist--full-w-links',
      'webapp-components-userlist--full-no-links',
      'webapp-components-userlist--paginated-no-links',
      'webapp-components-userlist--empty',
    ],
    type: 'component',
  },
  'webapp-components-userlist--all-user-lists': {
    id: 'webapp-components-userlist--all-user-lists',
    title: 'Webapp components/UserList',
    name: 'All UserLists',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist--loading': {
    id: 'webapp-components-userlist--loading',
    title: 'Webapp components/UserList',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist--full-w-links': {
    id: 'webapp-components-userlist--full-w-links',
    title: 'Webapp components/UserList',
    name: 'full w/links',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist--full-no-links': {
    id: 'webapp-components-userlist--full-no-links',
    title: 'Webapp components/UserList',
    name: 'full no links',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist--paginated-no-links': {
    id: 'webapp-components-userlist--paginated-no-links',
    title: 'Webapp components/UserList',
    name: 'paginated no links',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-userlist--empty': {
    id: 'webapp-components-userlist--empty',
    title: 'Webapp components/UserList',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-userlist',
    type: 'story',
    prepared: true,
  },
  'webapp-components-video': {
    name: 'Video',
    id: 'webapp-components-video',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-video--default'],
    type: 'component',
  },
  'webapp-components-video--default': {
    id: 'webapp-components-video--default',
    title: 'Webapp components/Video',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-video',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning': {
    name: 'Warning',
    id: 'webapp-components-warning',
    parent: 'webapp-components',
    depth: 1,
    children: [
      'webapp-components-warning--base',
      'webapp-components-warning--with-icon',
      'webapp-components-warning--with-action',
      'webapp-components-warning--with-icon-action',
      'webapp-components-warning--stacked-multiple-items',
      'webapp-components-warning--stacked-single-item',
    ],
    type: 'component',
  },
  'webapp-components-warning--base': {
    id: 'webapp-components-warning--base',
    title: 'Webapp components/Warning',
    name: 'base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning--with-icon': {
    id: 'webapp-components-warning--with-icon',
    title: 'Webapp components/Warning',
    name: 'with icon',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning--with-action': {
    id: 'webapp-components-warning--with-action',
    title: 'Webapp components/Warning',
    name: 'with action',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning--with-icon-action': {
    id: 'webapp-components-warning--with-icon-action',
    title: 'Webapp components/Warning',
    name: 'with icon, action',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning--stacked-multiple-items': {
    id: 'webapp-components-warning--stacked-multiple-items',
    title: 'Webapp components/Warning',
    name: 'stacked, multiple items',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-warning--stacked-single-item': {
    id: 'webapp-components-warning--stacked-single-item',
    title: 'Webapp components/Warning',
    name: 'stacked, single item',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-warning',
    type: 'story',
    prepared: true,
  },
  'webapp-components-wobbler': {
    name: 'Wobbler',
    id: 'webapp-components-wobbler',
    parent: 'webapp-components',
    depth: 1,
    children: ['webapp-components-wobbler--simple'],
    type: 'component',
  },
  'webapp-components-wobbler--simple': {
    id: 'webapp-components-wobbler--simple',
    title: 'Webapp components/Wobbler',
    name: 'simple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-components-wobbler',
    type: 'story',
    prepared: true,
  },
  'webapp-containers': {
    name: 'Webapp containers',
    id: 'webapp-containers',
    depth: 0,
    children: ['webapp-containers-appbuildspaginated', 'webapp-containers-componentbuildspicker'],
    type: 'root',
  },
  'webapp-containers-appbuildspaginated': {
    name: 'AppBuildsPaginated',
    id: 'webapp-containers-appbuildspaginated',
    parent: 'webapp-containers',
    depth: 1,
    children: [
      'webapp-containers-appbuildspaginated--loading',
      'webapp-containers-appbuildspaginated--has-next-page',
      'webapp-containers-appbuildspaginated--error',
    ],
    type: 'component',
  },
  'webapp-containers-appbuildspaginated--loading': {
    id: 'webapp-containers-appbuildspaginated--loading',
    title: 'Webapp containers/AppBuildsPaginated',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-appbuildspaginated',
    type: 'story',
    prepared: true,
  },
  'webapp-containers-appbuildspaginated--has-next-page': {
    id: 'webapp-containers-appbuildspaginated--has-next-page',
    title: 'Webapp containers/AppBuildsPaginated',
    name: 'has next page',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-appbuildspaginated',
    type: 'story',
    prepared: true,
  },
  'webapp-containers-appbuildspaginated--error': {
    id: 'webapp-containers-appbuildspaginated--error',
    title: 'Webapp containers/AppBuildsPaginated',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-appbuildspaginated',
    type: 'story',
    prepared: true,
  },
  'webapp-containers-componentbuildspicker': {
    name: 'ComponentBuildsPicker',
    id: 'webapp-containers-componentbuildspicker',
    parent: 'webapp-containers',
    depth: 1,
    children: [
      'webapp-containers-componentbuildspicker--loading',
      'webapp-containers-componentbuildspicker--app',
      'webapp-containers-componentbuildspicker--component',
    ],
    type: 'component',
  },
  'webapp-containers-componentbuildspicker--loading': {
    id: 'webapp-containers-componentbuildspicker--loading',
    title: 'Webapp containers/ComponentBuildsPicker',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-containers-componentbuildspicker--app': {
    id: 'webapp-containers-componentbuildspicker--app',
    title: 'Webapp containers/ComponentBuildsPicker',
    name: 'app',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-containers-componentbuildspicker--component': {
    id: 'webapp-containers-componentbuildspicker--component',
    title: 'Webapp containers/ComponentBuildsPicker',
    name: 'component',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-containers-componentbuildspicker',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts': {
    name: 'Webapp layouts',
    id: 'webapp-layouts',
    depth: 0,
    children: [
      'webapp-layouts-account',
      'webapp-layouts-app',
      'webapp-layouts-interstitial',
      'webapp-layouts-marketing',
      'webapp-layouts-onboarding',
      'webapp-layouts-page',
      'webapp-layouts-setup',
    ],
    type: 'root',
  },
  'webapp-layouts-account': {
    name: 'Account',
    id: 'webapp-layouts-account',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-account--loading',
      'webapp-layouts-account--projects',
      'webapp-layouts-account--projects-personal-account',
      'webapp-layouts-account--projects-personal-account-saml',
      'webapp-layouts-account--projects-shared-with-you',
      'webapp-layouts-account--projects-saml-account-owner',
      'webapp-layouts-account--projects-saml-account-not-owner',
      'webapp-layouts-account--billing',
    ],
    type: 'component',
  },
  'webapp-layouts-account--loading': {
    id: 'webapp-layouts-account--loading',
    title: 'Webapp layouts/Account',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects': {
    id: 'webapp-layouts-account--projects',
    title: 'Webapp layouts/Account',
    name: 'projects',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects-personal-account': {
    id: 'webapp-layouts-account--projects-personal-account',
    title: 'Webapp layouts/Account',
    name: 'projects, personal account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects-personal-account-saml': {
    id: 'webapp-layouts-account--projects-personal-account-saml',
    title: 'Webapp layouts/Account',
    name: 'projects, personal account, saml',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects-shared-with-you': {
    id: 'webapp-layouts-account--projects-shared-with-you',
    title: 'Webapp layouts/Account',
    name: 'projects, shared with you',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects-saml-account-owner': {
    id: 'webapp-layouts-account--projects-saml-account-owner',
    title: 'Webapp layouts/Account',
    name: 'projects, saml account, owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--projects-saml-account-not-owner': {
    id: 'webapp-layouts-account--projects-saml-account-not-owner',
    title: 'Webapp layouts/Account',
    name: 'projects, saml account, not owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-account--billing': {
    id: 'webapp-layouts-account--billing',
    title: 'Webapp layouts/Account',
    name: 'billing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-account',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app': {
    name: 'App',
    id: 'webapp-layouts-app',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-app--loading',
      'webapp-layouts-app--builds',
      'webapp-layouts-app--builds-shared-with-you',
      'webapp-layouts-app--setup',
      'webapp-layouts-app--builds-with-branch',
      'webapp-layouts-app--components',
      'webapp-layouts-app--no-ci',
      'webapp-layouts-app--no-ci-100-builds',
      'webapp-layouts-app--not-logged-in',
      'webapp-layouts-app--admin',
      'webapp-layouts-app--gerrit',
    ],
    type: 'component',
  },
  'webapp-layouts-app--loading': {
    id: 'webapp-layouts-app--loading',
    title: 'Webapp layouts/App',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--builds': {
    id: 'webapp-layouts-app--builds',
    title: 'Webapp layouts/App',
    name: 'builds',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--builds-shared-with-you': {
    id: 'webapp-layouts-app--builds-shared-with-you',
    title: 'Webapp layouts/App',
    name: 'builds, sharedWithYou',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--setup': {
    id: 'webapp-layouts-app--setup',
    title: 'Webapp layouts/App',
    name: 'setup',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--builds-with-branch': {
    id: 'webapp-layouts-app--builds-with-branch',
    title: 'Webapp layouts/App',
    name: 'builds with branch',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--components': {
    id: 'webapp-layouts-app--components',
    title: 'Webapp layouts/App',
    name: 'components',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--no-ci': {
    id: 'webapp-layouts-app--no-ci',
    title: 'Webapp layouts/App',
    name: 'no CI',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--no-ci-100-builds': {
    id: 'webapp-layouts-app--no-ci-100-builds',
    title: 'Webapp layouts/App',
    name: 'no CI, 100 builds',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--not-logged-in': {
    id: 'webapp-layouts-app--not-logged-in',
    title: 'Webapp layouts/App',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--admin': {
    id: 'webapp-layouts-app--admin',
    title: 'Webapp layouts/App',
    name: 'admin',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-app--gerrit': {
    id: 'webapp-layouts-app--gerrit',
    title: 'Webapp layouts/App',
    name: 'Gerrit',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-app',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-interstitial': {
    name: 'Interstitial',
    id: 'webapp-layouts-interstitial',
    parent: 'webapp-layouts',
    depth: 1,
    children: ['webapp-layouts-interstitial--default'],
    type: 'component',
  },
  'webapp-layouts-interstitial--default': {
    id: 'webapp-layouts-interstitial--default',
    title: 'Webapp layouts/Interstitial',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-interstitial',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-marketing': {
    name: 'Marketing',
    id: 'webapp-layouts-marketing',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-marketing--not-logged-in',
      'webapp-layouts-marketing--logged-in',
      'webapp-layouts-marketing--maintenance-mode',
      'webapp-layouts-marketing--dark-hero',
    ],
    type: 'component',
  },
  'webapp-layouts-marketing--not-logged-in': {
    id: 'webapp-layouts-marketing--not-logged-in',
    title: 'Webapp layouts/Marketing',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-marketing',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-marketing--logged-in': {
    id: 'webapp-layouts-marketing--logged-in',
    title: 'Webapp layouts/Marketing',
    name: 'logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-marketing',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-marketing--maintenance-mode': {
    id: 'webapp-layouts-marketing--maintenance-mode',
    title: 'Webapp layouts/Marketing',
    name: 'maintenanceMode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-marketing',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-marketing--dark-hero': {
    id: 'webapp-layouts-marketing--dark-hero',
    title: 'Webapp layouts/Marketing',
    name: 'darkHero',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-marketing',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-onboarding': {
    name: 'Onboarding',
    id: 'webapp-layouts-onboarding',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-onboarding--loading',
      'webapp-layouts-onboarding--logged-out',
      'webapp-layouts-onboarding--logged-in',
      'webapp-layouts-onboarding--logged-in-with-app',
    ],
    type: 'component',
  },
  'webapp-layouts-onboarding--loading': {
    id: 'webapp-layouts-onboarding--loading',
    title: 'Webapp layouts/Onboarding',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-onboarding',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-onboarding--logged-out': {
    id: 'webapp-layouts-onboarding--logged-out',
    title: 'Webapp layouts/Onboarding',
    name: 'loggedOut',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-onboarding',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-onboarding--logged-in': {
    id: 'webapp-layouts-onboarding--logged-in',
    title: 'Webapp layouts/Onboarding',
    name: 'loggedIn',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-onboarding',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-onboarding--logged-in-with-app': {
    id: 'webapp-layouts-onboarding--logged-in-with-app',
    title: 'Webapp layouts/Onboarding',
    name: 'loggedIn with app',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-onboarding',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page': {
    name: 'Page',
    id: 'webapp-layouts-page',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-page--loading',
      'webapp-layouts-page--logged-in-has-app-owner',
      'webapp-layouts-page--logged-in-has-app-owner-personal',
      'webapp-layouts-page--logged-in-has-exceeded-threshold',
      'webapp-layouts-page--logged-in-has-app',
      'webapp-layouts-page--logged-in-has-app-shared-with-you',
      'webapp-layouts-page--not-logged-in',
      'webapp-layouts-page--with-eyebrow',
      'webapp-layouts-page--tall-eyebrow',
    ],
    type: 'component',
  },
  'webapp-layouts-page--loading': {
    id: 'webapp-layouts-page--loading',
    title: 'Webapp layouts/Page',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--logged-in-has-app-owner': {
    id: 'webapp-layouts-page--logged-in-has-app-owner',
    title: 'Webapp layouts/Page',
    name: 'loggedIn has appOwner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--logged-in-has-app-owner-personal': {
    id: 'webapp-layouts-page--logged-in-has-app-owner-personal',
    title: 'Webapp layouts/Page',
    name: 'loggedIn has appOwner, personal',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--logged-in-has-exceeded-threshold': {
    id: 'webapp-layouts-page--logged-in-has-exceeded-threshold',
    title: 'Webapp layouts/Page',
    name: 'loggedIn, exceeded threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--logged-in-has-app': {
    id: 'webapp-layouts-page--logged-in-has-app',
    title: 'Webapp layouts/Page',
    name: 'loggedIn has app',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--logged-in-has-app-shared-with-you': {
    id: 'webapp-layouts-page--logged-in-has-app-shared-with-you',
    title: 'Webapp layouts/Page',
    name: 'loggedIn has app, shared with you',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--not-logged-in': {
    id: 'webapp-layouts-page--not-logged-in',
    title: 'Webapp layouts/Page',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--with-eyebrow': {
    id: 'webapp-layouts-page--with-eyebrow',
    title: 'Webapp layouts/Page',
    name: 'eyebrow',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-page--tall-eyebrow': {
    id: 'webapp-layouts-page--tall-eyebrow',
    title: 'Webapp layouts/Page',
    name: 'tall eyebrow',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-page',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup': {
    name: 'Setup',
    id: 'webapp-layouts-setup',
    parent: 'webapp-layouts',
    depth: 1,
    children: [
      'webapp-layouts-setup--loading',
      'webapp-layouts-setup--loading-onboarding',
      'webapp-layouts-setup--basic',
      'webapp-layouts-setup--basic-onboarding',
      'webapp-layouts-setup--basic-read-only',
      'webapp-layouts-setup--basic-admin',
    ],
    type: 'component',
  },
  'webapp-layouts-setup--loading': {
    id: 'webapp-layouts-setup--loading',
    title: 'Webapp layouts/Setup',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup--loading-onboarding': {
    id: 'webapp-layouts-setup--loading-onboarding',
    title: 'Webapp layouts/Setup',
    name: 'Loading Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup--basic': {
    id: 'webapp-layouts-setup--basic',
    title: 'Webapp layouts/Setup',
    name: 'Basic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup--basic-onboarding': {
    id: 'webapp-layouts-setup--basic-onboarding',
    title: 'Webapp layouts/Setup',
    name: 'Basic Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup--basic-read-only': {
    id: 'webapp-layouts-setup--basic-read-only',
    title: 'Webapp layouts/Setup',
    name: 'Basic Read Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-layouts-setup--basic-admin': {
    id: 'webapp-layouts-setup--basic-admin',
    title: 'Webapp layouts/Setup',
    name: 'Basic Admin',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-layouts-setup',
    type: 'story',
    prepared: true,
  },
  'webapp-screens': {
    name: 'Webapp screens',
    id: 'webapp-screens',
    depth: 0,
    children: [
      'webapp-screens-appsscreen',
      'webapp-screens-billingscreen',
      'webapp-screens-build',
      'webapp-screens-buildsscreen',
      'webapp-screens-component',
      'webapp-screens-componentsscreen',
      'webapp-screens-error',
      'webapp-screens-installgithubappsuccessscreen',
      'webapp-screens-installwebhookscreen',
      'webapp-screens-joinbetascreen',
      'webapp-screens-loadingscreen',
      'webapp-screens-loginscreen',
      'webapp-screens-managescreen',
      'webapp-screens-marketing',
      'webapp-screens-notificationsscreen',
      'webapp-screens-onboarding',
      'webapp-screens-preferencesupdatedscreen',
      'webapp-screens-pullrequest',
      'webapp-screens-pullrequestsscreen',
      'webapp-screens-settingsscreen',
      'webapp-screens-setup',
      'webapp-screens-snapshot',
    ],
    type: 'root',
  },
  'webapp-screens-appsscreen': {
    name: 'AppsScreen',
    id: 'webapp-screens-appsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-appsscreen--loading',
      'webapp-screens-appsscreen--personal',
      'webapp-screens-appsscreen--personal-modal-open',
      'webapp-screens-appsscreen--personal-saml-user',
      'webapp-screens-appsscreen--personal-saml-user-modal-open',
      'webapp-screens-appsscreen--organization',
      'webapp-screens-appsscreen--organization-modal-open',
      'webapp-screens-appsscreen--saml-account',
      'webapp-screens-appsscreen--saml-account-modal-open',
      'webapp-screens-appsscreen--shared-with-you',
      'webapp-screens-appsscreen--no-projects-personal-account',
      'webapp-screens-appsscreen--personal-account-creating-first-app',
      'webapp-screens-appsscreen--no-projects-shared-with-you-app-owner',
      'webapp-screens-appsscreen--no-projects-linked-account',
      'webapp-screens-appsscreen--no-projects-saml-account',
    ],
    type: 'component',
  },
  'webapp-screens-appsscreen--loading': {
    id: 'webapp-screens-appsscreen--loading',
    title: 'Webapp screens/AppsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--personal': {
    id: 'webapp-screens-appsscreen--personal',
    title: 'Webapp screens/AppsScreen',
    name: 'personal',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--personal-modal-open': {
    id: 'webapp-screens-appsscreen--personal-modal-open',
    title: 'Webapp screens/AppsScreen',
    name: 'personal, modal open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--personal-saml-user': {
    id: 'webapp-screens-appsscreen--personal-saml-user',
    title: 'Webapp screens/AppsScreen',
    name: 'personal, samlUser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--personal-saml-user-modal-open': {
    id: 'webapp-screens-appsscreen--personal-saml-user-modal-open',
    title: 'Webapp screens/AppsScreen',
    name: 'personal, samlUser, modal open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--organization': {
    id: 'webapp-screens-appsscreen--organization',
    title: 'Webapp screens/AppsScreen',
    name: 'organization',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--organization-modal-open': {
    id: 'webapp-screens-appsscreen--organization-modal-open',
    title: 'Webapp screens/AppsScreen',
    name: 'organization, modal open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--saml-account': {
    id: 'webapp-screens-appsscreen--saml-account',
    title: 'Webapp screens/AppsScreen',
    name: 'saml account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--saml-account-modal-open': {
    id: 'webapp-screens-appsscreen--saml-account-modal-open',
    title: 'Webapp screens/AppsScreen',
    name: 'saml account, modal open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--shared-with-you': {
    id: 'webapp-screens-appsscreen--shared-with-you',
    title: 'Webapp screens/AppsScreen',
    name: 'sharedWithYou',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--no-projects-personal-account': {
    id: 'webapp-screens-appsscreen--no-projects-personal-account',
    title: 'Webapp screens/AppsScreen',
    name: 'no projects, personal account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--personal-account-creating-first-app': {
    id: 'webapp-screens-appsscreen--personal-account-creating-first-app',
    title: 'Webapp screens/AppsScreen',
    name: 'personal account, creatingFirstApp',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--no-projects-shared-with-you-app-owner': {
    id: 'webapp-screens-appsscreen--no-projects-shared-with-you-app-owner',
    title: 'Webapp screens/AppsScreen',
    name: 'no projects, sharedWithYou app owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--no-projects-linked-account': {
    id: 'webapp-screens-appsscreen--no-projects-linked-account',
    title: 'Webapp screens/AppsScreen',
    name: 'no projects, linked account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-appsscreen--no-projects-saml-account': {
    id: 'webapp-screens-appsscreen--no-projects-saml-account',
    title: 'Webapp screens/AppsScreen',
    name: 'no projects, saml account',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-appsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen': {
    name: 'BillingScreen',
    id: 'webapp-screens-billingscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-billingscreen--loading',
      'webapp-screens-billingscreen--pre-subscribed',
      'webapp-screens-billingscreen--free',
      'webapp-screens-billingscreen--free-with-bonus',
      'webapp-screens-billingscreen--free-with-bonus-in-past',
      'webapp-screens-billingscreen--free-over-limit',
      'webapp-screens-billingscreen--paid-plan-over-limit',
      'webapp-screens-billingscreen--trial',
      'webapp-screens-billingscreen--trial-ending',
      'webapp-screens-billingscreen--subscribed',
      'webapp-screens-billingscreen--subscribed-still-in-trial',
      'webapp-screens-billingscreen--subscribed-still-in-trial-over-limit',
      'webapp-screens-billingscreen--subscribed-custom-plan',
      'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits',
      'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits-exceeded-threshold',
      'webapp-screens-billingscreen--subscribed-open-source-plan-free',
      'webapp-screens-billingscreen--subscribed-open-source-plan-free-exceeded-threshold',
      'webapp-screens-billingscreen--subscribed-open-source-plan-paid',
      'webapp-screens-billingscreen--subscribed-invoice-failed',
      'webapp-screens-billingscreen--subscribed-payment-required',
      'webapp-screens-billingscreen--subscribed-slow-builds-no-parallelization-saving',
      'webapp-screens-billingscreen--pure-subscribed-change-plan-drawer-open',
      'webapp-screens-billingscreen--pure-subscribed-email-drawer-open',
      'webapp-screens-billingscreen-billingemailform',
      'webapp-screens-billingscreen-invoicelist',
    ],
    type: 'group',
  },
  'webapp-screens-billingscreen--loading': {
    id: 'webapp-screens-billingscreen--loading',
    title: 'Webapp screens/BillingScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--pre-subscribed': {
    id: 'webapp-screens-billingscreen--pre-subscribed',
    title: 'Webapp screens/BillingScreen',
    name: 'pre subscribed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--free': {
    id: 'webapp-screens-billingscreen--free',
    title: 'Webapp screens/BillingScreen',
    name: 'Free',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--free-with-bonus': {
    id: 'webapp-screens-billingscreen--free-with-bonus',
    title: 'Webapp screens/BillingScreen',
    name: 'Free With Bonus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--free-with-bonus-in-past': {
    id: 'webapp-screens-billingscreen--free-with-bonus-in-past',
    title: 'Webapp screens/BillingScreen',
    name: 'Free With Bonus In Past',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--free-over-limit': {
    id: 'webapp-screens-billingscreen--free-over-limit',
    title: 'Webapp screens/BillingScreen',
    name: 'Free Over Limit',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--paid-plan-over-limit': {
    id: 'webapp-screens-billingscreen--paid-plan-over-limit',
    title: 'Webapp screens/BillingScreen',
    name: 'Paid Plan Over Limit',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--trial': {
    id: 'webapp-screens-billingscreen--trial',
    title: 'Webapp screens/BillingScreen',
    name: 'trial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--trial-ending': {
    id: 'webapp-screens-billingscreen--trial-ending',
    title: 'Webapp screens/BillingScreen',
    name: 'trial ending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed': {
    id: 'webapp-screens-billingscreen--subscribed',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-still-in-trial': {
    id: 'webapp-screens-billingscreen--subscribed-still-in-trial',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, still in trial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-still-in-trial-over-limit': {
    id: 'webapp-screens-billingscreen--subscribed-still-in-trial-over-limit',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, still in trial, over limit',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-custom-plan': {
    id: 'webapp-screens-billingscreen--subscribed-custom-plan',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, custom plan',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits': {
    id: 'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, custom plan, usage limits',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits-exceeded-threshold': {
    id: 'webapp-screens-billingscreen--subscribed-custom-plan-usage-limits-exceeded-threshold',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, custom plan, usage limits, exceeded threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-open-source-plan-free': {
    id: 'webapp-screens-billingscreen--subscribed-open-source-plan-free',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, open source plan, free',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-open-source-plan-free-exceeded-threshold': {
    id: 'webapp-screens-billingscreen--subscribed-open-source-plan-free-exceeded-threshold',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, open source plan, free, exceeded threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-open-source-plan-paid': {
    id: 'webapp-screens-billingscreen--subscribed-open-source-plan-paid',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, open source plan, paid',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-invoice-failed': {
    id: 'webapp-screens-billingscreen--subscribed-invoice-failed',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, invoice failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-payment-required': {
    id: 'webapp-screens-billingscreen--subscribed-payment-required',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, payment required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--subscribed-slow-builds-no-parallelization-saving': {
    id: 'webapp-screens-billingscreen--subscribed-slow-builds-no-parallelization-saving',
    title: 'Webapp screens/BillingScreen',
    name: 'subscribed, slow builds (no parallelization saving)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--pure-subscribed-change-plan-drawer-open': {
    id: 'webapp-screens-billingscreen--pure-subscribed-change-plan-drawer-open',
    title: 'Webapp screens/BillingScreen',
    name: 'pure, subscribed, change plan drawer open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen--pure-subscribed-email-drawer-open': {
    id: 'webapp-screens-billingscreen--pure-subscribed-email-drawer-open',
    title: 'Webapp screens/BillingScreen',
    name: 'pure, subscribed, email drawer open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-billingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-billingemailform': {
    name: 'BillingEmailForm',
    id: 'webapp-screens-billingscreen-billingemailform',
    parent: 'webapp-screens-billingscreen',
    depth: 2,
    children: [
      'webapp-screens-billingscreen-billingemailform--default',
      'webapp-screens-billingscreen-billingemailform--pure-default',
      'webapp-screens-billingscreen-billingemailform--submitting',
    ],
    type: 'component',
  },
  'webapp-screens-billingscreen-billingemailform--default': {
    id: 'webapp-screens-billingscreen-billingemailform--default',
    title: 'Webapp screens/BillingScreen/BillingEmailForm',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-billingemailform',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-billingemailform--pure-default': {
    id: 'webapp-screens-billingscreen-billingemailform--pure-default',
    title: 'Webapp screens/BillingScreen/BillingEmailForm',
    name: 'pure default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-billingemailform',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-billingemailform--submitting': {
    id: 'webapp-screens-billingscreen-billingemailform--submitting',
    title: 'Webapp screens/BillingScreen/BillingEmailForm',
    name: 'submitting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-billingemailform',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-invoicelist': {
    name: 'InvoiceList',
    id: 'webapp-screens-billingscreen-invoicelist',
    parent: 'webapp-screens-billingscreen',
    depth: 2,
    children: [
      'webapp-screens-billingscreen-invoicelist--full',
      'webapp-screens-billingscreen-invoicelist--full-first-invoice-not-finalized',
      'webapp-screens-billingscreen-invoicelist--full-payment-failed',
      'webapp-screens-billingscreen-invoicelist--trial',
      'webapp-screens-billingscreen-invoicelist--free',
    ],
    type: 'component',
  },
  'webapp-screens-billingscreen-invoicelist--full': {
    id: 'webapp-screens-billingscreen-invoicelist--full',
    title: 'Webapp screens/BillingScreen/InvoiceList',
    name: 'full',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-invoicelist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-invoicelist--full-first-invoice-not-finalized': {
    id: 'webapp-screens-billingscreen-invoicelist--full-first-invoice-not-finalized',
    title: 'Webapp screens/BillingScreen/InvoiceList',
    name: 'full, first invoice not finalized',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-invoicelist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-invoicelist--full-payment-failed': {
    id: 'webapp-screens-billingscreen-invoicelist--full-payment-failed',
    title: 'Webapp screens/BillingScreen/InvoiceList',
    name: 'full, payment failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-invoicelist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-invoicelist--trial': {
    id: 'webapp-screens-billingscreen-invoicelist--trial',
    title: 'Webapp screens/BillingScreen/InvoiceList',
    name: 'trial',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-invoicelist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-billingscreen-invoicelist--free': {
    id: 'webapp-screens-billingscreen-invoicelist--free',
    title: 'Webapp screens/BillingScreen/InvoiceList',
    name: 'Free',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-billingscreen-invoicelist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build': {
    name: 'Build',
    id: 'webapp-screens-build',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-build-buildcomponents',
      'webapp-screens-build-buildheader',
      'webapp-screens-build-buildscreen',
      'webapp-screens-build-buildsummary',
      'webapp-screens-build-componentrow',
      'webapp-screens-build-rowexpander',
      'webapp-screens-build-snapshotrow',
      'webapp-screens-build-snapshotstable',
      'webapp-screens-build-specrow',
      'webapp-screens-build-testsummary',
    ],
    type: 'group',
  },
  'webapp-screens-build-buildcomponents': {
    name: 'BuildComponents',
    id: 'webapp-screens-build-buildcomponents',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-buildcomponents--loading',
      'webapp-screens-build-buildcomponents--simple',
      'webapp-screens-build-buildcomponents--passed',
      'webapp-screens-build-buildcomponents--failed',
      'webapp-screens-build-buildcomponents--in-progress',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildcomponents--loading': {
    id: 'webapp-screens-build-buildcomponents--loading',
    title: 'Webapp screens/Build/BuildComponents',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildcomponents--simple': {
    id: 'webapp-screens-build-buildcomponents--simple',
    title: 'Webapp screens/Build/BuildComponents',
    name: 'simple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildcomponents--passed': {
    id: 'webapp-screens-build-buildcomponents--passed',
    title: 'Webapp screens/Build/BuildComponents',
    name: 'passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildcomponents--failed': {
    id: 'webapp-screens-build-buildcomponents--failed',
    title: 'Webapp screens/Build/BuildComponents',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildcomponents--in-progress': {
    id: 'webapp-screens-build-buildcomponents--in-progress',
    title: 'Webapp screens/Build/BuildComponents',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader': {
    name: 'BuildHeader',
    id: 'webapp-screens-build-buildheader',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-buildheader--loading',
      'webapp-screens-build-buildheader--automatic',
      'webapp-screens-build-buildheader--passed',
      'webapp-screens-build-buildheader--denied',
      'webapp-screens-build-buildheader--failed',
      'webapp-screens-build-buildheader--errored',
      'webapp-screens-build-buildheader--timed-out',
      'webapp-screens-build-buildheader--in-progress',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildheader--loading': {
    id: 'webapp-screens-build-buildheader--loading',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--automatic': {
    id: 'webapp-screens-build-buildheader--automatic',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Automatic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--passed': {
    id: 'webapp-screens-build-buildheader--passed',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--denied': {
    id: 'webapp-screens-build-buildheader--denied',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--failed': {
    id: 'webapp-screens-build-buildheader--failed',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--errored': {
    id: 'webapp-screens-build-buildheader--errored',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--timed-out': {
    id: 'webapp-screens-build-buildheader--timed-out',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'Timed Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildheader--in-progress': {
    id: 'webapp-screens-build-buildheader--in-progress',
    title: 'Webapp screens/Build/BuildHeader',
    name: 'In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen': {
    name: 'BuildScreen',
    id: 'webapp-screens-build-buildscreen',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-buildscreen--loading',
      'webapp-screens-build-buildscreen--unreviewed',
      'webapp-screens-build-buildscreen--passed',
      'webapp-screens-build-buildscreen--paused',
      'webapp-screens-build-buildscreen--disabled',
      'webapp-screens-build-buildscreen--denied',
      'webapp-screens-build-buildscreen--component-errors',
      'webapp-screens-build-buildscreen--build-error',
      'webapp-screens-build-buildscreen--build-timeout',
      'webapp-screens-build-buildscreen--build-in-progress',
      'webapp-screens-build-buildscreen--tunnelled-build',
      'webapp-screens-build-buildscreen--newer-build',
      'webapp-screens-build-buildscreen--upgrade-build-with-newer-build',
      'webapp-screens-build-buildscreen--upgrade-build-no-newer-build',
      'webapp-screens-build-buildscreen--no-ancestor',
      'webapp-screens-build-buildscreen--no-ancestor-newer-build',
      'webapp-screens-build-buildscreen--multiple-ancestors',
      'webapp-screens-build-buildscreen--onboarding',
      'webapp-screens-build-buildscreen--onboarding-no-tests',
      'webapp-screens-build-buildscreen--no-snapshots-remaining',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildscreen--loading': {
    id: 'webapp-screens-build-buildscreen--loading',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--unreviewed': {
    id: 'webapp-screens-build-buildscreen--unreviewed',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--passed': {
    id: 'webapp-screens-build-buildscreen--passed',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--paused': {
    id: 'webapp-screens-build-buildscreen--paused',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--disabled': {
    id: 'webapp-screens-build-buildscreen--disabled',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--denied': {
    id: 'webapp-screens-build-buildscreen--denied',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--component-errors': {
    id: 'webapp-screens-build-buildscreen--component-errors',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Component Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--build-error': {
    id: 'webapp-screens-build-buildscreen--build-error',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--build-timeout': {
    id: 'webapp-screens-build-buildscreen--build-timeout',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Build Timeout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--build-in-progress': {
    id: 'webapp-screens-build-buildscreen--build-in-progress',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--tunnelled-build': {
    id: 'webapp-screens-build-buildscreen--tunnelled-build',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Tunnelled Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--newer-build': {
    id: 'webapp-screens-build-buildscreen--newer-build',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Newer Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--upgrade-build-with-newer-build': {
    id: 'webapp-screens-build-buildscreen--upgrade-build-with-newer-build',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Upgrade Build With Newer Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--upgrade-build-no-newer-build': {
    id: 'webapp-screens-build-buildscreen--upgrade-build-no-newer-build',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Upgrade Build No Newer Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--no-ancestor': {
    id: 'webapp-screens-build-buildscreen--no-ancestor',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'No Ancestor',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--no-ancestor-newer-build': {
    id: 'webapp-screens-build-buildscreen--no-ancestor-newer-build',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'No Ancestor Newer Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--multiple-ancestors': {
    id: 'webapp-screens-build-buildscreen--multiple-ancestors',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Multiple Ancestors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--onboarding': {
    id: 'webapp-screens-build-buildscreen--onboarding',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--onboarding-no-tests': {
    id: 'webapp-screens-build-buildscreen--onboarding-no-tests',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'Onboarding No Tests',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildscreen--no-snapshots-remaining': {
    id: 'webapp-screens-build-buildscreen--no-snapshots-remaining',
    title: 'Webapp screens/Build/BuildScreen',
    name: 'No Snapshots Remaining',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary': {
    name: 'BuildSummary',
    id: 'webapp-screens-build-buildsummary',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-buildsummary--loading',
      'webapp-screens-build-buildsummary--default',
      'webapp-screens-build-buildsummary--tests-paused',
      'webapp-screens-build-buildsummary--tests-disabled',
      'webapp-screens-build-buildsummary--single-pull-request',
      'webapp-screens-build-buildsummary--multiple-pull-requests',
      'webapp-screens-build-buildsummary--build-error',
      'webapp-screens-build-buildsummary--build-timeout',
      'webapp-screens-build-buildsummary-ancestors',
      'webapp-screens-build-buildsummary-commit',
      'webapp-screens-build-buildsummary-pullrequests',
      'webapp-screens-build-buildsummary-tests',
    ],
    type: 'group',
  },
  'webapp-screens-build-buildsummary--loading': {
    id: 'webapp-screens-build-buildsummary--loading',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--default': {
    id: 'webapp-screens-build-buildsummary--default',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--tests-paused': {
    id: 'webapp-screens-build-buildsummary--tests-paused',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Tests Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--tests-disabled': {
    id: 'webapp-screens-build-buildsummary--tests-disabled',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Tests Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--single-pull-request': {
    id: 'webapp-screens-build-buildsummary--single-pull-request',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Single Pull Request',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--multiple-pull-requests': {
    id: 'webapp-screens-build-buildsummary--multiple-pull-requests',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Multiple Pull Requests',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--build-error': {
    id: 'webapp-screens-build-buildsummary--build-error',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary--build-timeout': {
    id: 'webapp-screens-build-buildsummary--build-timeout',
    title: 'Webapp screens/Build/BuildSummary',
    name: 'Build Timeout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-buildsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-ancestors': {
    name: 'Ancestors',
    id: 'webapp-screens-build-buildsummary-ancestors',
    parent: 'webapp-screens-build-buildsummary',
    depth: 3,
    children: [
      'webapp-screens-build-buildsummary-ancestors--loading',
      'webapp-screens-build-buildsummary-ancestors--none',
      'webapp-screens-build-buildsummary-ancestors--one',
      'webapp-screens-build-buildsummary-ancestors--multiple',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildsummary-ancestors--loading': {
    id: 'webapp-screens-build-buildsummary-ancestors--loading',
    title: 'Webapp screens/Build/BuildSummary/Ancestors',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-ancestors',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-ancestors--none': {
    id: 'webapp-screens-build-buildsummary-ancestors--none',
    title: 'Webapp screens/Build/BuildSummary/Ancestors',
    name: 'None',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-ancestors',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-ancestors--one': {
    id: 'webapp-screens-build-buildsummary-ancestors--one',
    title: 'Webapp screens/Build/BuildSummary/Ancestors',
    name: 'One',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-ancestors',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-ancestors--multiple': {
    id: 'webapp-screens-build-buildsummary-ancestors--multiple',
    title: 'Webapp screens/Build/BuildSummary/Ancestors',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-ancestors',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-commit': {
    name: 'Commit',
    id: 'webapp-screens-build-buildsummary-commit',
    parent: 'webapp-screens-build-buildsummary',
    depth: 3,
    children: [
      'webapp-screens-build-buildsummary-commit--loading',
      'webapp-screens-build-buildsummary-commit--default',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildsummary-commit--loading': {
    id: 'webapp-screens-build-buildsummary-commit--loading',
    title: 'Webapp screens/Build/BuildSummary/Commit',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-commit',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-commit--default': {
    id: 'webapp-screens-build-buildsummary-commit--default',
    title: 'Webapp screens/Build/BuildSummary/Commit',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-commit',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests': {
    name: 'PullRequests',
    id: 'webapp-screens-build-buildsummary-pullrequests',
    parent: 'webapp-screens-build-buildsummary',
    depth: 3,
    children: [
      'webapp-screens-build-buildsummary-pullrequests--loading',
      'webapp-screens-build-buildsummary-pullrequests--none',
      'webapp-screens-build-buildsummary-pullrequests--one',
      'webapp-screens-build-buildsummary-pullrequests--multiple',
      'webapp-screens-build-buildsummary-pullrequests--gitlab',
      'webapp-screens-build-buildsummary-pullrequests--missing-app-installation',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildsummary-pullrequests--loading': {
    id: 'webapp-screens-build-buildsummary-pullrequests--loading',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests--none': {
    id: 'webapp-screens-build-buildsummary-pullrequests--none',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'None',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests--one': {
    id: 'webapp-screens-build-buildsummary-pullrequests--one',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'One',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests--multiple': {
    id: 'webapp-screens-build-buildsummary-pullrequests--multiple',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests--gitlab': {
    id: 'webapp-screens-build-buildsummary-pullrequests--gitlab',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'Gitlab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-pullrequests--missing-app-installation': {
    id: 'webapp-screens-build-buildsummary-pullrequests--missing-app-installation',
    title: 'Webapp screens/Build/BuildSummary/PullRequests',
    name: 'Missing App Installation',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-pullrequests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests': {
    name: 'Tests',
    id: 'webapp-screens-build-buildsummary-tests',
    parent: 'webapp-screens-build-buildsummary',
    depth: 3,
    children: [
      'webapp-screens-build-buildsummary-tests--loading',
      'webapp-screens-build-buildsummary-tests--default',
      'webapp-screens-build-buildsummary-tests--currently-paused',
      'webapp-screens-build-buildsummary-tests--currently-paused-payment-required',
      'webapp-screens-build-buildsummary-tests--currently-paused-no-subscription',
      'webapp-screens-build-buildsummary-tests--currently-paused-org',
      'webapp-screens-build-buildsummary-tests--paused-in-the-past',
      'webapp-screens-build-buildsummary-tests--currently-disabled',
      'webapp-screens-build-buildsummary-tests--currently-disabled-no-savings',
      'webapp-screens-build-buildsummary-tests--currently-disabled-read-only',
      'webapp-screens-build-buildsummary-tests--disabled-in-the-past',
      'webapp-screens-build-buildsummary-tests--one-browser',
      'webapp-screens-build-buildsummary-tests--two-browsers',
      'webapp-screens-build-buildsummary-tests--all-browsers',
    ],
    type: 'component',
  },
  'webapp-screens-build-buildsummary-tests--loading': {
    id: 'webapp-screens-build-buildsummary-tests--loading',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--default': {
    id: 'webapp-screens-build-buildsummary-tests--default',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-paused': {
    id: 'webapp-screens-build-buildsummary-tests--currently-paused',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-paused-payment-required': {
    id: 'webapp-screens-build-buildsummary-tests--currently-paused-payment-required',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Paused, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-paused-no-subscription': {
    id: 'webapp-screens-build-buildsummary-tests--currently-paused-no-subscription',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Paused, No Subscription',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-paused-org': {
    id: 'webapp-screens-build-buildsummary-tests--currently-paused-org',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Paused, Org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--paused-in-the-past': {
    id: 'webapp-screens-build-buildsummary-tests--paused-in-the-past',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Paused In The Past',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-disabled': {
    id: 'webapp-screens-build-buildsummary-tests--currently-disabled',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-disabled-no-savings': {
    id: 'webapp-screens-build-buildsummary-tests--currently-disabled-no-savings',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Disabled, No Savings',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--currently-disabled-read-only': {
    id: 'webapp-screens-build-buildsummary-tests--currently-disabled-read-only',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Currently Disabled, Read Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--disabled-in-the-past': {
    id: 'webapp-screens-build-buildsummary-tests--disabled-in-the-past',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Disabled In The Past',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--one-browser': {
    id: 'webapp-screens-build-buildsummary-tests--one-browser',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'One Browser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--two-browsers': {
    id: 'webapp-screens-build-buildsummary-tests--two-browsers',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'Two Browsers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-buildsummary-tests--all-browsers': {
    id: 'webapp-screens-build-buildsummary-tests--all-browsers',
    title: 'Webapp screens/Build/BuildSummary/Tests',
    name: 'All Browsers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-build-buildsummary-tests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow': {
    name: 'ComponentRow',
    id: 'webapp-screens-build-componentrow',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-componentrow--pending',
      'webapp-screens-build-componentrow--pending-single-spec',
      'webapp-screens-build-componentrow--pending-multiple-stories-per-spec',
      'webapp-screens-build-componentrow--pending-mixed',
      'webapp-screens-build-componentrow--pending-unreviewable',
      'webapp-screens-build-componentrow--pending-reviewing-build',
      'webapp-screens-build-componentrow--pending-reviewing-component',
      'webapp-screens-build-componentrow--pending-reviewing-spec',
      'webapp-screens-build-componentrow--pending-reviewing-snapshot',
      'webapp-screens-build-componentrow--pure-pending-expanded',
      'webapp-screens-build-componentrow--pure-pending-unexpanded',
      'webapp-screens-build-componentrow--accepted',
      'webapp-screens-build-componentrow--denied',
      'webapp-screens-build-componentrow--reviewed-many-reviewers',
      'webapp-screens-build-componentrow--pure-unexpanded-reviewed-many-reviewers',
    ],
    type: 'component',
  },
  'webapp-screens-build-componentrow--pending': {
    id: 'webapp-screens-build-componentrow--pending',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-single-spec': {
    id: 'webapp-screens-build-componentrow--pending-single-spec',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, single spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-multiple-stories-per-spec': {
    id: 'webapp-screens-build-componentrow--pending-multiple-stories-per-spec',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, multiple stories per spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-mixed': {
    id: 'webapp-screens-build-componentrow--pending-mixed',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, mixed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-unreviewable': {
    id: 'webapp-screens-build-componentrow--pending-unreviewable',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-reviewing-build': {
    id: 'webapp-screens-build-componentrow--pending-reviewing-build',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, reviewing build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-reviewing-component': {
    id: 'webapp-screens-build-componentrow--pending-reviewing-component',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, reviewing component',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-reviewing-spec': {
    id: 'webapp-screens-build-componentrow--pending-reviewing-spec',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, reviewing spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pending-reviewing-snapshot': {
    id: 'webapp-screens-build-componentrow--pending-reviewing-snapshot',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pending, reviewing snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pure-pending-expanded': {
    id: 'webapp-screens-build-componentrow--pure-pending-expanded',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pure, pending, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pure-pending-unexpanded': {
    id: 'webapp-screens-build-componentrow--pure-pending-unexpanded',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pure, pending, unexpanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--accepted': {
    id: 'webapp-screens-build-componentrow--accepted',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--denied': {
    id: 'webapp-screens-build-componentrow--denied',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--reviewed-many-reviewers': {
    id: 'webapp-screens-build-componentrow--reviewed-many-reviewers',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'reviewed, many reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-componentrow--pure-unexpanded-reviewed-many-reviewers': {
    id: 'webapp-screens-build-componentrow--pure-unexpanded-reviewed-many-reviewers',
    title: 'Webapp screens/Build/ComponentRow',
    name: 'pure, unexpanded, reviewed, many reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-componentrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-rowexpander': {
    name: 'RowExpander',
    id: 'webapp-screens-build-rowexpander',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-rowexpander--expanded',
      'webapp-screens-build-rowexpander--collapsed',
    ],
    type: 'component',
  },
  'webapp-screens-build-rowexpander--expanded': {
    id: 'webapp-screens-build-rowexpander--expanded',
    title: 'Webapp screens/Build/RowExpander',
    name: 'expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-rowexpander',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-rowexpander--collapsed': {
    id: 'webapp-screens-build-rowexpander--collapsed',
    title: 'Webapp screens/Build/RowExpander',
    name: 'collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-rowexpander',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow': {
    name: 'SnapshotRow',
    id: 'webapp-screens-build-snapshotrow',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-snapshotrow--pending',
      'webapp-screens-build-snapshotrow--pending-unreviewable',
      'webapp-screens-build-snapshotrow--pending-accepting',
      'webapp-screens-build-snapshotrow--pending-denying',
      'webapp-screens-build-snapshotrow--pending-spec-reviewing',
      'webapp-screens-build-snapshotrow--accepted',
      'webapp-screens-build-snapshotrow--accepted-undoing',
      'webapp-screens-build-snapshotrow--denied',
      'webapp-screens-build-snapshotrow--denied-undoing',
      'webapp-screens-build-snapshotrow--new',
      'webapp-screens-build-snapshotrow--failed',
      'webapp-screens-build-snapshotrow--in-progress',
      'webapp-screens-build-snapshotrow--pending-indented-1',
      'webapp-screens-build-snapshotrow--pending-indented-1-for-snapshot',
      'webapp-screens-build-snapshotrow--pending-indented-2',
    ],
    type: 'component',
  },
  'webapp-screens-build-snapshotrow--pending': {
    id: 'webapp-screens-build-snapshotrow--pending',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-unreviewable': {
    id: 'webapp-screens-build-snapshotrow--pending-unreviewable',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-accepting': {
    id: 'webapp-screens-build-snapshotrow--pending-accepting',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, accepting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-denying': {
    id: 'webapp-screens-build-snapshotrow--pending-denying',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, denying',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-spec-reviewing': {
    id: 'webapp-screens-build-snapshotrow--pending-spec-reviewing',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, spec reviewing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--accepted': {
    id: 'webapp-screens-build-snapshotrow--accepted',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--accepted-undoing': {
    id: 'webapp-screens-build-snapshotrow--accepted-undoing',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'accepted, undoing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--denied': {
    id: 'webapp-screens-build-snapshotrow--denied',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--denied-undoing': {
    id: 'webapp-screens-build-snapshotrow--denied-undoing',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'denied, undoing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--new': {
    id: 'webapp-screens-build-snapshotrow--new',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'new',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--failed': {
    id: 'webapp-screens-build-snapshotrow--failed',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--in-progress': {
    id: 'webapp-screens-build-snapshotrow--in-progress',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-indented-1': {
    id: 'webapp-screens-build-snapshotrow--pending-indented-1',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, indented 1',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-indented-1-for-snapshot': {
    id: 'webapp-screens-build-snapshotrow--pending-indented-1-for-snapshot',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, indented 1, for snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotrow--pending-indented-2': {
    id: 'webapp-screens-build-snapshotrow--pending-indented-2',
    title: 'Webapp screens/Build/SnapshotRow',
    name: 'pending, indented 2',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable': {
    name: 'SnapshotsTable',
    id: 'webapp-screens-build-snapshotstable',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-snapshotstable--changes',
      'webapp-screens-build-snapshotstable--changes-single-snaphot-only',
      'webapp-screens-build-snapshotstable--changes-multiple-components',
      'webapp-screens-build-snapshotstable--changes-multiple-snapshots-per-spec',
      'webapp-screens-build-snapshotstable--changes-mixed',
      'webapp-screens-build-snapshotstable--changes-unreviewable',
      'webapp-screens-build-snapshotstable--changes-review-failed',
      'webapp-screens-build-snapshotstable--changes-review-passed',
      'webapp-screens-build-snapshotstable--new-stories',
      'webapp-screens-build-snapshotstable--new-stories-in-progress',
      'webapp-screens-build-snapshotstable--errors',
    ],
    type: 'component',
  },
  'webapp-screens-build-snapshotstable--changes': {
    id: 'webapp-screens-build-snapshotstable--changes',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-single-snaphot-only': {
    id: 'webapp-screens-build-snapshotstable--changes-single-snaphot-only',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, single snaphot only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-multiple-components': {
    id: 'webapp-screens-build-snapshotstable--changes-multiple-components',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, multiple components',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-multiple-snapshots-per-spec': {
    id: 'webapp-screens-build-snapshotstable--changes-multiple-snapshots-per-spec',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, multiple snapshots per spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-mixed': {
    id: 'webapp-screens-build-snapshotstable--changes-mixed',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, mixed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-unreviewable': {
    id: 'webapp-screens-build-snapshotstable--changes-unreviewable',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-review-failed': {
    id: 'webapp-screens-build-snapshotstable--changes-review-failed',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, review failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--changes-review-passed': {
    id: 'webapp-screens-build-snapshotstable--changes-review-passed',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'changes, review passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--new-stories': {
    id: 'webapp-screens-build-snapshotstable--new-stories',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'new stories',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--new-stories-in-progress': {
    id: 'webapp-screens-build-snapshotstable--new-stories-in-progress',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'new stories, in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-snapshotstable--errors': {
    id: 'webapp-screens-build-snapshotstable--errors',
    title: 'Webapp screens/Build/SnapshotsTable',
    name: 'errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-snapshotstable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow': {
    name: 'SpecRow',
    id: 'webapp-screens-build-specrow',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-specrow--pending',
      'webapp-screens-build-specrow--pending-reviewing-component',
      'webapp-screens-build-specrow--pending-reviewing-spec',
      'webapp-screens-build-specrow--pending-reviewing-snapshot',
      'webapp-screens-build-specrow--pending-single-snapshot',
      'webapp-screens-build-specrow--pending-unreviewable',
      'webapp-screens-build-specrow--pure-pending-expanded',
      'webapp-screens-build-specrow--pure-pending-unexpanded',
      'webapp-screens-build-specrow--accepted',
      'webapp-screens-build-specrow--denied',
      'webapp-screens-build-specrow--reviewed-many-reviewers',
    ],
    type: 'component',
  },
  'webapp-screens-build-specrow--pending': {
    id: 'webapp-screens-build-specrow--pending',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pending-reviewing-component': {
    id: 'webapp-screens-build-specrow--pending-reviewing-component',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending, reviewing component',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pending-reviewing-spec': {
    id: 'webapp-screens-build-specrow--pending-reviewing-spec',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending, reviewing spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pending-reviewing-snapshot': {
    id: 'webapp-screens-build-specrow--pending-reviewing-snapshot',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending, reviewing snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pending-single-snapshot': {
    id: 'webapp-screens-build-specrow--pending-single-snapshot',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending, single snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pending-unreviewable': {
    id: 'webapp-screens-build-specrow--pending-unreviewable',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pending, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pure-pending-expanded': {
    id: 'webapp-screens-build-specrow--pure-pending-expanded',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pure, pending, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--pure-pending-unexpanded': {
    id: 'webapp-screens-build-specrow--pure-pending-unexpanded',
    title: 'Webapp screens/Build/SpecRow',
    name: 'pure, pending, unexpanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--accepted': {
    id: 'webapp-screens-build-specrow--accepted',
    title: 'Webapp screens/Build/SpecRow',
    name: 'accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--denied': {
    id: 'webapp-screens-build-specrow--denied',
    title: 'Webapp screens/Build/SpecRow',
    name: 'denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-specrow--reviewed-many-reviewers': {
    id: 'webapp-screens-build-specrow--reviewed-many-reviewers',
    title: 'Webapp screens/Build/SpecRow',
    name: 'reviewed, many reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-specrow',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary': {
    name: 'TestSummary',
    id: 'webapp-screens-build-testsummary',
    parent: 'webapp-screens-build',
    depth: 2,
    children: [
      'webapp-screens-build-testsummary--loading',
      'webapp-screens-build-testsummary--no-changes',
      'webapp-screens-build-testsummary--all-accepted',
      'webapp-screens-build-testsummary--some-denied',
      'webapp-screens-build-testsummary--reviewing',
      'webapp-screens-build-testsummary--reviewing-multiple-baselines',
      'webapp-screens-build-testsummary--reviewing-paginated',
      'webapp-screens-build-testsummary--reviewing-new-stories',
      'webapp-screens-build-testsummary--reviewing-readonly',
      'webapp-screens-build-testsummary--not-reviewable',
      'webapp-screens-build-testsummary--first-build',
      'webapp-screens-build-testsummary--first-cross-browser-build',
      'webapp-screens-build-testsummary--upgrade-build',
      'webapp-screens-build-testsummary--upgraded-build',
      'webapp-screens-build-testsummary--single-component-error',
      'webapp-screens-build-testsummary--multiple-component-errors',
      'webapp-screens-build-testsummary--only-component-errors',
      'webapp-screens-build-testsummary--build-in-progress',
      'webapp-screens-build-testsummary--build-timeout',
      'webapp-screens-build-testsummary--build-error',
      'webapp-screens-build-testsummary--pure-reviewing-build',
      'webapp-screens-build-testsummary--pure-reviewing-component',
      'webapp-screens-build-testsummary--pure-paginating',
    ],
    type: 'component',
  },
  'webapp-screens-build-testsummary--loading': {
    id: 'webapp-screens-build-testsummary--loading',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--no-changes': {
    id: 'webapp-screens-build-testsummary--no-changes',
    title: 'Webapp screens/Build/TestSummary',
    name: 'No Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--all-accepted': {
    id: 'webapp-screens-build-testsummary--all-accepted',
    title: 'Webapp screens/Build/TestSummary',
    name: 'All Accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--some-denied': {
    id: 'webapp-screens-build-testsummary--some-denied',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Some Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--reviewing': {
    id: 'webapp-screens-build-testsummary--reviewing',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Reviewing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--reviewing-multiple-baselines': {
    id: 'webapp-screens-build-testsummary--reviewing-multiple-baselines',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Reviewing Multiple Baselines',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--reviewing-paginated': {
    id: 'webapp-screens-build-testsummary--reviewing-paginated',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Reviewing Paginated',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--reviewing-new-stories': {
    id: 'webapp-screens-build-testsummary--reviewing-new-stories',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Reviewing New Stories',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--reviewing-readonly': {
    id: 'webapp-screens-build-testsummary--reviewing-readonly',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Reviewing Readonly',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--not-reviewable': {
    id: 'webapp-screens-build-testsummary--not-reviewable',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Not Reviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--first-build': {
    id: 'webapp-screens-build-testsummary--first-build',
    title: 'Webapp screens/Build/TestSummary',
    name: 'First Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--first-cross-browser-build': {
    id: 'webapp-screens-build-testsummary--first-cross-browser-build',
    title: 'Webapp screens/Build/TestSummary',
    name: 'First Cross Browser Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--upgrade-build': {
    id: 'webapp-screens-build-testsummary--upgrade-build',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Upgrade Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--upgraded-build': {
    id: 'webapp-screens-build-testsummary--upgraded-build',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Upgraded Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--single-component-error': {
    id: 'webapp-screens-build-testsummary--single-component-error',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Single Component Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--multiple-component-errors': {
    id: 'webapp-screens-build-testsummary--multiple-component-errors',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Multiple Component Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--only-component-errors': {
    id: 'webapp-screens-build-testsummary--only-component-errors',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Only Component Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--build-in-progress': {
    id: 'webapp-screens-build-testsummary--build-in-progress',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--build-timeout': {
    id: 'webapp-screens-build-testsummary--build-timeout',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Build Timeout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--build-error': {
    id: 'webapp-screens-build-testsummary--build-error',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--pure-reviewing-build': {
    id: 'webapp-screens-build-testsummary--pure-reviewing-build',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Pure Reviewing Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--pure-reviewing-component': {
    id: 'webapp-screens-build-testsummary--pure-reviewing-component',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Pure Reviewing Component',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-build-testsummary--pure-paginating': {
    id: 'webapp-screens-build-testsummary--pure-paginating',
    title: 'Webapp screens/Build/TestSummary',
    name: 'Pure Paginating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-build-testsummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-buildsscreen': {
    name: 'BuildsScreen',
    id: 'webapp-screens-buildsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-buildsscreen--loading',
      'webapp-screens-buildsscreen--simple',
      'webapp-screens-buildsscreen--simple-shared-with-you',
      'webapp-screens-buildsscreen--simple-ci-explainer',
      'webapp-screens-buildsscreen--simple-branch-selected',
    ],
    type: 'component',
  },
  'webapp-screens-buildsscreen--loading': {
    id: 'webapp-screens-buildsscreen--loading',
    title: 'Webapp screens/BuildsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-buildsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-buildsscreen--simple': {
    id: 'webapp-screens-buildsscreen--simple',
    title: 'Webapp screens/BuildsScreen',
    name: 'simple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-buildsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-buildsscreen--simple-shared-with-you': {
    id: 'webapp-screens-buildsscreen--simple-shared-with-you',
    title: 'Webapp screens/BuildsScreen',
    name: 'simple, shared with you',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-buildsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-buildsscreen--simple-ci-explainer': {
    id: 'webapp-screens-buildsscreen--simple-ci-explainer',
    title: 'Webapp screens/BuildsScreen',
    name: 'simple, ci explainer',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-buildsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-buildsscreen--simple-branch-selected': {
    id: 'webapp-screens-buildsscreen--simple-branch-selected',
    title: 'Webapp screens/BuildsScreen',
    name: 'simple, branch selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-buildsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component': {
    name: 'Component',
    id: 'webapp-screens-component',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-component-componentcanvas',
      'webapp-screens-component-componentcomments',
      'webapp-screens-component-componentcommentthread',
      'webapp-screens-component-componentheader',
      'webapp-screens-component-componentscreen',
      'webapp-screens-component-componentsidebar',
    ],
    type: 'group',
  },
  'webapp-screens-component-componentcanvas': {
    name: 'ComponentCanvas',
    id: 'webapp-screens-component-componentcanvas',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentcanvas--loading',
      'webapp-screens-component-componentcanvas--empty',
      'webapp-screens-component-componentcanvas--in-progress',
      'webapp-screens-component-componentcanvas--in-progress-interactive',
      'webapp-screens-component-componentcanvas--snapshot-error',
      'webapp-screens-component-componentcanvas--snapshot-error-interactive',
      'webapp-screens-component-componentcanvas--snapshot-failed',
      'webapp-screens-component-componentcanvas--snapshot-did-not-capture',
      'webapp-screens-component-componentcanvas--pending-non-interactive',
      'webapp-screens-component-componentcanvas--pending-non-interactive-ignored-regions',
      'webapp-screens-component-componentcanvas--pending-interactive',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentcanvas--loading': {
    id: 'webapp-screens-component-componentcanvas--loading',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--empty': {
    id: 'webapp-screens-component-componentcanvas--empty',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--in-progress': {
    id: 'webapp-screens-component-componentcanvas--in-progress',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--in-progress-interactive': {
    id: 'webapp-screens-component-componentcanvas--in-progress-interactive',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'in progress, interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--snapshot-error': {
    id: 'webapp-screens-component-componentcanvas--snapshot-error',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'snapshot error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--snapshot-error-interactive': {
    id: 'webapp-screens-component-componentcanvas--snapshot-error-interactive',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'snapshot error, interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--snapshot-failed': {
    id: 'webapp-screens-component-componentcanvas--snapshot-failed',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'snapshot failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--snapshot-did-not-capture': {
    id: 'webapp-screens-component-componentcanvas--snapshot-did-not-capture',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'snapshot did not capture',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--pending-non-interactive': {
    id: 'webapp-screens-component-componentcanvas--pending-non-interactive',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'pending, non-interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--pending-non-interactive-ignored-regions': {
    id: 'webapp-screens-component-componentcanvas--pending-non-interactive-ignored-regions',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'pending, non-interactive, ignored regions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcanvas--pending-interactive': {
    id: 'webapp-screens-component-componentcanvas--pending-interactive',
    title: 'Webapp screens/Component/ComponentCanvas',
    name: 'pending, interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcanvas',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments': {
    name: 'ComponentComments',
    id: 'webapp-screens-component-componentcomments',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentcomments--without-comments',
      'webapp-screens-component-componentcomments--without-comments-comments-disabled',
      'webapp-screens-component-componentcomments--without-comments-logged-out',
      'webapp-screens-component-componentcomments--with-comments-resolved',
      'webapp-screens-component-componentcomments--with-comments-resolved-logged-out',
      'webapp-screens-component-componentcomments--with-comments-active',
      'webapp-screens-component-componentcomments--with-comments-active-non-owner',
      'webapp-screens-component-componentcomments--with-comments-active-logged-out',
      'webapp-screens-component-componentcomments--with-comments-combined',
      'webapp-screens-component-componentcomments--with-comments-combined-comments-disabled',
      'webapp-screens-component-componentcomments--with-comments-combined-logged-out',
      'webapp-screens-component-componentcomments--with-comments-comments-disabled',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentcomments--without-comments': {
    id: 'webapp-screens-component-componentcomments--without-comments',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'without comments',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--without-comments-comments-disabled': {
    id: 'webapp-screens-component-componentcomments--without-comments-comments-disabled',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'without comments, comments disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--without-comments-logged-out': {
    id: 'webapp-screens-component-componentcomments--without-comments-logged-out',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'without comments, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-resolved': {
    id: 'webapp-screens-component-componentcomments--with-comments-resolved',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, resolved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-resolved-logged-out': {
    id: 'webapp-screens-component-componentcomments--with-comments-resolved-logged-out',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, resolved, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-active': {
    id: 'webapp-screens-component-componentcomments--with-comments-active',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-active-non-owner': {
    id: 'webapp-screens-component-componentcomments--with-comments-active-non-owner',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, active, non-owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-active-logged-out': {
    id: 'webapp-screens-component-componentcomments--with-comments-active-logged-out',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, active, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-combined': {
    id: 'webapp-screens-component-componentcomments--with-comments-combined',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, combined',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-combined-comments-disabled': {
    id: 'webapp-screens-component-componentcomments--with-comments-combined-comments-disabled',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, combined, comments disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-combined-logged-out': {
    id: 'webapp-screens-component-componentcomments--with-comments-combined-logged-out',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, combined, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcomments--with-comments-comments-disabled': {
    id: 'webapp-screens-component-componentcomments--with-comments-comments-disabled',
    title: 'Webapp screens/Component/ComponentComments',
    name: 'with comments, comments disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread': {
    name: 'ComponentCommentThread',
    id: 'webapp-screens-component-componentcommentthread',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentcommentthread--active',
      'webapp-screens-component-componentcommentthread--active-unreviewable',
      'webapp-screens-component-componentcommentthread--active-logged-out',
      'webapp-screens-component-componentcommentthread--resolved',
      'webapp-screens-component-componentcommentthread--resolved-expanded',
      'webapp-screens-component-componentcommentthread--resolved-expanded-non-owner',
      'webapp-screens-component-componentcommentthread--resolved-unreviewable',
      'webapp-screens-component-componentcommentthread--resolved-unreviewable-expanded',
      'webapp-screens-component-componentcommentthread--resolved-logged-out',
      'webapp-screens-component-componentcommentthread--resolved-logged-out-expanded',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentcommentthread--active': {
    id: 'webapp-screens-component-componentcommentthread--active',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--active-unreviewable': {
    id: 'webapp-screens-component-componentcommentthread--active-unreviewable',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'active, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--active-logged-out': {
    id: 'webapp-screens-component-componentcommentthread--active-logged-out',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'active, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved': {
    id: 'webapp-screens-component-componentcommentthread--resolved',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-expanded': {
    id: 'webapp-screens-component-componentcommentthread--resolved-expanded',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-expanded-non-owner': {
    id: 'webapp-screens-component-componentcommentthread--resolved-expanded-non-owner',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, expanded, non-owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-unreviewable': {
    id: 'webapp-screens-component-componentcommentthread--resolved-unreviewable',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, unreviewable',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-unreviewable-expanded': {
    id: 'webapp-screens-component-componentcommentthread--resolved-unreviewable-expanded',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, unreviewable, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-logged-out': {
    id: 'webapp-screens-component-componentcommentthread--resolved-logged-out',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentcommentthread--resolved-logged-out-expanded': {
    id: 'webapp-screens-component-componentcommentthread--resolved-logged-out-expanded',
    title: 'Webapp screens/Component/ComponentCommentThread',
    name: 'resolved, logged out, expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentcommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentheader': {
    name: 'ComponentHeader',
    id: 'webapp-screens-component-componentheader',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentheader--loading',
      'webapp-screens-component-componentheader--default',
      'webapp-screens-component-componentheader--long-name',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentheader--loading': {
    id: 'webapp-screens-component-componentheader--loading',
    title: 'Webapp screens/Component/ComponentHeader',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentheader--default': {
    id: 'webapp-screens-component-componentheader--default',
    title: 'Webapp screens/Component/ComponentHeader',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentheader--long-name': {
    id: 'webapp-screens-component-componentheader--long-name',
    title: 'Webapp screens/Component/ComponentHeader',
    name: 'long name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen': {
    name: 'ComponentScreen',
    id: 'webapp-screens-component-componentscreen',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentscreen--loading',
      'webapp-screens-component-componentscreen--in-progress',
      'webapp-screens-component-componentscreen--in-progress-canvas',
      'webapp-screens-component-componentscreen--default-not-logged-in',
      'webapp-screens-component-componentscreen--default-not-all-snapshots-not-logged-in',
      'webapp-screens-component-componentscreen--default',
      'webapp-screens-component-componentscreen--comments',
      'webapp-screens-component-componentscreen--default-canvas',
      'webapp-screens-component-componentscreen--default-not-all-snapshots',
      'webapp-screens-component-componentscreen--default-docs',
      'webapp-screens-component-componentscreen--default-no-docs',
      'webapp-screens-component-componentscreen--default-explainer-eyebrow',
      'webapp-screens-component-componentscreen--cross-browser-no-browser-selected',
      'webapp-screens-component-componentscreen--cross-browser-browser-selected',
      'webapp-screens-component-componentscreen--default-one-viewport-from-default',
      'webapp-screens-component-componentscreen--default-from-snapshot',
      'webapp-screens-component-componentscreen--default-from-build',
      'webapp-screens-component-componentscreen--default-from-library',
      'webapp-screens-component-componentscreen--story-selected',
      'webapp-screens-component-componentscreen--story-and-viewport-selected',
      'webapp-screens-component-componentscreen--story-selected-with-ignored-regions',
      'webapp-screens-component-componentscreen--errored-story-snapshot',
      'webapp-screens-component-componentscreen--errored-story-canvas',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentscreen--loading': {
    id: 'webapp-screens-component-componentscreen--loading',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--in-progress': {
    id: 'webapp-screens-component-componentscreen--in-progress',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--in-progress-canvas': {
    id: 'webapp-screens-component-componentscreen--in-progress-canvas',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'in progress, canvas',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-not-logged-in': {
    id: 'webapp-screens-component-componentscreen--default-not-logged-in',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-not-all-snapshots-not-logged-in': {
    id: 'webapp-screens-component-componentscreen--default-not-all-snapshots-not-logged-in',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'Default Not All Snapshots Not Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default': {
    id: 'webapp-screens-component-componentscreen--default',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--comments': {
    id: 'webapp-screens-component-componentscreen--comments',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'comments',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-canvas': {
    id: 'webapp-screens-component-componentscreen--default-canvas',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, canvas',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-not-all-snapshots': {
    id: 'webapp-screens-component-componentscreen--default-not-all-snapshots',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'Default Not All Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-docs': {
    id: 'webapp-screens-component-componentscreen--default-docs',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, docs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-no-docs': {
    id: 'webapp-screens-component-componentscreen--default-no-docs',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, no docs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-explainer-eyebrow': {
    id: 'webapp-screens-component-componentscreen--default-explainer-eyebrow',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default explainer eyebrow ',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--cross-browser-no-browser-selected': {
    id: 'webapp-screens-component-componentscreen--cross-browser-no-browser-selected',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'cross browser, no browser selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--cross-browser-browser-selected': {
    id: 'webapp-screens-component-componentscreen--cross-browser-browser-selected',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'cross browser, browser selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-one-viewport-from-default': {
    id: 'webapp-screens-component-componentscreen--default-one-viewport-from-default',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, one viewport from default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-from-snapshot': {
    id: 'webapp-screens-component-componentscreen--default-from-snapshot',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, from snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-from-build': {
    id: 'webapp-screens-component-componentscreen--default-from-build',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, from build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--default-from-library': {
    id: 'webapp-screens-component-componentscreen--default-from-library',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'default, from library',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--story-selected': {
    id: 'webapp-screens-component-componentscreen--story-selected',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'story selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--story-and-viewport-selected': {
    id: 'webapp-screens-component-componentscreen--story-and-viewport-selected',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'story and viewport selected',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--story-selected-with-ignored-regions': {
    id: 'webapp-screens-component-componentscreen--story-selected-with-ignored-regions',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'story selected with ignored regions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--errored-story-snapshot': {
    id: 'webapp-screens-component-componentscreen--errored-story-snapshot',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'errored story, snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentscreen--errored-story-canvas': {
    id: 'webapp-screens-component-componentscreen--errored-story-canvas',
    title: 'Webapp screens/Component/ComponentScreen',
    name: 'errored story, canvas',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentsidebar': {
    name: 'ComponentSidebar',
    id: 'webapp-screens-component-componentsidebar',
    parent: 'webapp-screens-component',
    depth: 2,
    children: [
      'webapp-screens-component-componentsidebar--loading',
      'webapp-screens-component-componentsidebar--default',
      'webapp-screens-component-componentsidebar--not-logged-in',
    ],
    type: 'component',
  },
  'webapp-screens-component-componentsidebar--loading': {
    id: 'webapp-screens-component-componentsidebar--loading',
    title: 'Webapp screens/Component/ComponentSidebar',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentsidebar',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentsidebar--default': {
    id: 'webapp-screens-component-componentsidebar--default',
    title: 'Webapp screens/Component/ComponentSidebar',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentsidebar',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-component-componentsidebar--not-logged-in': {
    id: 'webapp-screens-component-componentsidebar--not-logged-in',
    title: 'Webapp screens/Component/ComponentSidebar',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-component-componentsidebar',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-componentsscreen': {
    name: 'ComponentsScreen',
    id: 'webapp-screens-componentsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: ['webapp-screens-componentsscreen-componentsscreen'],
    type: 'group',
  },
  'webapp-screens-componentsscreen-componentsscreen': {
    name: 'ComponentsScreen',
    id: 'webapp-screens-componentsscreen-componentsscreen',
    parent: 'webapp-screens-componentsscreen',
    depth: 2,
    children: [
      'webapp-screens-componentsscreen-componentsscreen--loading',
      'webapp-screens-componentsscreen-componentsscreen--default-unlinked-click-share-dropdown',
      'webapp-screens-componentsscreen-componentsscreen--default-linked-click-share-dropdown',
      'webapp-screens-componentsscreen-componentsscreen--default-explainer-eyebrow',
      'webapp-screens-componentsscreen-componentsscreen--in-group',
    ],
    type: 'component',
  },
  'webapp-screens-componentsscreen-componentsscreen--loading': {
    id: 'webapp-screens-componentsscreen-componentsscreen--loading',
    title: 'Webapp screens/ComponentsScreen/ComponentsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-componentsscreen-componentsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-componentsscreen-componentsscreen--default-unlinked-click-share-dropdown': {
    id: 'webapp-screens-componentsscreen-componentsscreen--default-unlinked-click-share-dropdown',
    title: 'Webapp screens/ComponentsScreen/ComponentsScreen',
    name: 'default unlinked (click share dropdown)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-componentsscreen-componentsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-componentsscreen-componentsscreen--default-linked-click-share-dropdown': {
    id: 'webapp-screens-componentsscreen-componentsscreen--default-linked-click-share-dropdown',
    title: 'Webapp screens/ComponentsScreen/ComponentsScreen',
    name: 'default linked (click share dropdown)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-componentsscreen-componentsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-componentsscreen-componentsscreen--default-explainer-eyebrow': {
    id: 'webapp-screens-componentsscreen-componentsscreen--default-explainer-eyebrow',
    title: 'Webapp screens/ComponentsScreen/ComponentsScreen',
    name: 'default explainer eyebrow',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-componentsscreen-componentsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-componentsscreen-componentsscreen--in-group': {
    id: 'webapp-screens-componentsscreen-componentsscreen--in-group',
    title: 'Webapp screens/ComponentsScreen/ComponentsScreen',
    name: 'in group',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-componentsscreen-componentsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error': {
    name: 'Error',
    id: 'webapp-screens-error',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-error-errorscreen',
      'webapp-screens-error-noaccessscreen',
      'webapp-screens-error-notfoundscreen',
    ],
    type: 'group',
  },
  'webapp-screens-error-errorscreen': {
    name: 'ErrorScreen',
    id: 'webapp-screens-error-errorscreen',
    parent: 'webapp-screens-error',
    depth: 2,
    children: [
      'webapp-screens-error-errorscreen--status-code',
      'webapp-screens-error-errorscreen--status-code-logged-out',
      'webapp-screens-error-errorscreen--not-found',
      'webapp-screens-error-errorscreen--no-access',
      'webapp-screens-error-errorscreen--no-access-logged-out',
      'webapp-screens-error-errorscreen--error',
    ],
    type: 'component',
  },
  'webapp-screens-error-errorscreen--status-code': {
    id: 'webapp-screens-error-errorscreen--status-code',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'statusCode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-errorscreen--status-code-logged-out': {
    id: 'webapp-screens-error-errorscreen--status-code-logged-out',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'statusCode logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-errorscreen--not-found': {
    id: 'webapp-screens-error-errorscreen--not-found',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'not found',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-errorscreen--no-access': {
    id: 'webapp-screens-error-errorscreen--no-access',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'no access',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-errorscreen--no-access-logged-out': {
    id: 'webapp-screens-error-errorscreen--no-access-logged-out',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'no access, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-errorscreen--error': {
    id: 'webapp-screens-error-errorscreen--error',
    title: 'Webapp screens/Error/ErrorScreen',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-errorscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-noaccessscreen': {
    name: 'NoAccessScreen',
    id: 'webapp-screens-error-noaccessscreen',
    parent: 'webapp-screens-error',
    depth: 2,
    children: ['webapp-screens-error-noaccessscreen--default'],
    type: 'component',
  },
  'webapp-screens-error-noaccessscreen--default': {
    id: 'webapp-screens-error-noaccessscreen--default',
    title: 'Webapp screens/Error/NoAccessScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-noaccessscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-error-notfoundscreen': {
    name: 'NotFoundScreen',
    id: 'webapp-screens-error-notfoundscreen',
    parent: 'webapp-screens-error',
    depth: 2,
    children: ['webapp-screens-error-notfoundscreen--default'],
    type: 'component',
  },
  'webapp-screens-error-notfoundscreen--default': {
    id: 'webapp-screens-error-notfoundscreen--default',
    title: 'Webapp screens/Error/NotFoundScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-error-notfoundscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-installgithubappsuccessscreen': {
    name: 'InstallGitHubAppSuccessScreen',
    id: 'webapp-screens-installgithubappsuccessscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: ['webapp-screens-installgithubappsuccessscreen--default'],
    type: 'component',
  },
  'webapp-screens-installgithubappsuccessscreen--default': {
    id: 'webapp-screens-installgithubappsuccessscreen--default',
    title: 'Webapp screens/InstallGitHubAppSuccessScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-installgithubappsuccessscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-installwebhookscreen': {
    name: 'InstallWebhookScreen',
    id: 'webapp-screens-installwebhookscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-installwebhookscreen--github',
      'webapp-screens-installwebhookscreen--bitbucket',
      'webapp-screens-installwebhookscreen--gitlab',
    ],
    type: 'component',
  },
  'webapp-screens-installwebhookscreen--github': {
    id: 'webapp-screens-installwebhookscreen--github',
    title: 'Webapp screens/InstallWebhookScreen',
    name: 'Github',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-installwebhookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-installwebhookscreen--bitbucket': {
    id: 'webapp-screens-installwebhookscreen--bitbucket',
    title: 'Webapp screens/InstallWebhookScreen',
    name: 'Bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-installwebhookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-installwebhookscreen--gitlab': {
    id: 'webapp-screens-installwebhookscreen--gitlab',
    title: 'Webapp screens/InstallWebhookScreen',
    name: 'Gitlab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-installwebhookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-joinbetascreen': {
    name: 'JoinBetaScreen',
    id: 'webapp-screens-joinbetascreen',
    parent: 'webapp-screens',
    depth: 1,
    children: ['webapp-screens-joinbetascreen--default'],
    type: 'component',
  },
  'webapp-screens-joinbetascreen--default': {
    id: 'webapp-screens-joinbetascreen--default',
    title: 'Webapp screens/JoinBetaScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-joinbetascreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loadingscreen': {
    name: 'LoadingScreen',
    id: 'webapp-screens-loadingscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: ['webapp-screens-loadingscreen--default'],
    type: 'component',
  },
  'webapp-screens-loadingscreen--default': {
    id: 'webapp-screens-loadingscreen--default',
    title: 'Webapp screens/LoadingScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-loadingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen': {
    name: 'LoginScreen',
    id: 'webapp-screens-loginscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-loginscreen--loading',
      'webapp-screens-loginscreen--default',
      'webapp-screens-loginscreen--default-logged-in',
      'webapp-screens-loginscreen--subdomain',
      'webapp-screens-loginscreen-loginbuttons',
    ],
    type: 'group',
  },
  'webapp-screens-loginscreen--loading': {
    id: 'webapp-screens-loginscreen--loading',
    title: 'Webapp screens/LoginScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-loginscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen--default': {
    id: 'webapp-screens-loginscreen--default',
    title: 'Webapp screens/LoginScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-loginscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen--default-logged-in': {
    id: 'webapp-screens-loginscreen--default-logged-in',
    title: 'Webapp screens/LoginScreen',
    name: 'Default Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-loginscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen--subdomain': {
    id: 'webapp-screens-loginscreen--subdomain',
    title: 'Webapp screens/LoginScreen',
    name: 'Subdomain',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-loginscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen-loginbuttons': {
    name: 'LoginButtons',
    id: 'webapp-screens-loginscreen-loginbuttons',
    parent: 'webapp-screens-loginscreen',
    depth: 2,
    children: [
      'webapp-screens-loginscreen-loginbuttons--default',
      'webapp-screens-loginscreen-loginbuttons--is-loading',
      'webapp-screens-loginscreen-loginbuttons--saml',
    ],
    type: 'component',
  },
  'webapp-screens-loginscreen-loginbuttons--default': {
    id: 'webapp-screens-loginscreen-loginbuttons--default',
    title: 'Webapp screens/LoginScreen/LoginButtons',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-loginscreen-loginbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen-loginbuttons--is-loading': {
    id: 'webapp-screens-loginscreen-loginbuttons--is-loading',
    title: 'Webapp screens/LoginScreen/LoginButtons',
    name: 'isLoading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-loginscreen-loginbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-loginscreen-loginbuttons--saml': {
    id: 'webapp-screens-loginscreen-loginbuttons--saml',
    title: 'Webapp screens/LoginScreen/LoginButtons',
    name: 'saml',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-loginscreen-loginbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen': {
    name: 'ManageScreen',
    id: 'webapp-screens-managescreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-managescreen-browserpicker',
      'webapp-screens-managescreen-integrations',
      'webapp-screens-managescreen-managescreen',
      'webapp-screens-managescreen-uireview',
      'webapp-screens-managescreen-visualtests',
    ],
    type: 'group',
  },
  'webapp-screens-managescreen-browserpicker': {
    name: 'BrowserPicker',
    id: 'webapp-screens-managescreen-browserpicker',
    parent: 'webapp-screens-managescreen',
    depth: 2,
    children: [
      'webapp-screens-managescreen-browserpicker--interactive',
      'webapp-screens-managescreen-browserpicker--browser-upgrade',
      'webapp-screens-managescreen-browserpicker--adding',
      'webapp-screens-managescreen-browserpicker--added',
      'webapp-screens-managescreen-browserpicker--removing',
      'webapp-screens-managescreen-browserpicker--removed',
    ],
    type: 'component',
  },
  'webapp-screens-managescreen-browserpicker--interactive': {
    id: 'webapp-screens-managescreen-browserpicker--interactive',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'interactive',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-browserpicker--browser-upgrade': {
    id: 'webapp-screens-managescreen-browserpicker--browser-upgrade',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'browser upgrade',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-browserpicker--adding': {
    id: 'webapp-screens-managescreen-browserpicker--adding',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'adding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-browserpicker--added': {
    id: 'webapp-screens-managescreen-browserpicker--added',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'added',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-browserpicker--removing': {
    id: 'webapp-screens-managescreen-browserpicker--removing',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'removing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-browserpicker--removed': {
    id: 'webapp-screens-managescreen-browserpicker--removed',
    title: 'Webapp screens/ManageScreen/BrowserPicker',
    name: 'removed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-browserpicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations': {
    name: 'Integrations',
    id: 'webapp-screens-managescreen-integrations',
    parent: 'webapp-screens-managescreen',
    depth: 2,
    children: [
      'webapp-screens-managescreen-integrations--loading',
      'webapp-screens-managescreen-integrations--interactive',
      'webapp-screens-managescreen-integrations--unset',
      'webapp-screens-managescreen-integrations--expanded',
      'webapp-screens-managescreen-integrations--filled',
      'webapp-screens-managescreen-integrations--filled-overflow',
      'webapp-screens-managescreen-integrations--saving',
      'webapp-screens-managescreen-integrations--set',
      'webapp-screens-managescreen-integrations--set-overflow',
    ],
    type: 'component',
  },
  'webapp-screens-managescreen-integrations--loading': {
    id: 'webapp-screens-managescreen-integrations--loading',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Loading',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
      isLoading: true,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      isLoading: {
        control: {
          type: 'boolean',
        },
        name: 'isLoading',
        type: {
          name: 'boolean',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
      isLoading: true,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--interactive': {
    id: 'webapp-screens-managescreen-integrations--interactive',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Interactive',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--unset': {
    id: 'webapp-screens-managescreen-integrations--unset',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Unset',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--expanded': {
    id: 'webapp-screens-managescreen-integrations--expanded',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Expanded',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--filled': {
    id: 'webapp-screens-managescreen-integrations--filled',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Filled',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: 'https://slack-webhook-url.slack.com',
      customWebhookUrl: 'https://custom-webhook-url.example.com',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: 'https://slack-webhook-url.slack.com',
      customWebhookUrl: 'https://custom-webhook-url.example.com',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--filled-overflow': {
    id: 'webapp-screens-managescreen-integrations--filled-overflow',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Filled Overflow',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl:
        'https://slack-webhook-url.slack.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      customWebhookUrl:
        'https://custom-webhook-url.example.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl:
        'https://slack-webhook-url.slack.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      customWebhookUrl:
        'https://custom-webhook-url.example.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--saving': {
    id: 'webapp-screens-managescreen-integrations--saving',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Saving',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: 'https://slack-webhook-url.slack.com',
      customWebhookUrl: 'https://custom-webhook-url.example.com',
      isSlackSaving: true,
      isCustomSaving: true,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: '',
        customWebhookUrl: '',
      },
      slackWebhookUrl: 'https://slack-webhook-url.slack.com',
      customWebhookUrl: 'https://custom-webhook-url.example.com',
      isSlackSaving: true,
      isCustomSaving: true,
      isSlackDrawerOpen: true,
      isCustomDrawerOpen: true,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--set': {
    id: 'webapp-screens-managescreen-integrations--set',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Set',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl: 'https://slack-webhook-url.slack.com',
        customWebhookUrl: 'https://custom-webhook-url.example.com',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-integrations--set-overflow': {
    id: 'webapp-screens-managescreen-integrations--set-overflow',
    title: 'Webapp screens/ManageScreen/Integrations',
    name: 'Set Overflow',
    importPath: './path.js',
    args: {
      app: {
        id: ':appId',
        slackWebhookUrl:
          'https://slack-webhook-url.slack.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
        customWebhookUrl:
          'https://custom-webhook-url.example.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    argTypes: {
      app: {
        control: {
          type: 'object',
        },
        name: 'app',
        type: {
          name: 'object',
          value: {
            id: {
              name: 'string',
            },
            slackWebhookUrl: {
              name: 'string',
            },
            customWebhookUrl: {
              name: 'string',
            },
          },
        },
      },
      onUpdateApp: {
        name: 'onUpdateApp',
        type: {
          name: 'function',
        },
      },
      slackWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'slackWebhookUrl',
        type: {
          name: 'string',
        },
      },
      customWebhookUrl: {
        control: {
          type: 'text',
        },
        name: 'customWebhookUrl',
        type: {
          name: 'string',
        },
      },
      isSlackSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackSaving',
        type: {
          name: 'boolean',
        },
      },
      isCustomSaving: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomSaving',
        type: {
          name: 'boolean',
        },
      },
      isSlackDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isSlackDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      isCustomDrawerOpen: {
        control: {
          type: 'boolean',
        },
        name: 'isCustomDrawerOpen',
        type: {
          name: 'boolean',
        },
      },
      toggleDrawer: {
        name: 'toggleDrawer',
        type: {
          name: 'function',
        },
      },
      setCustomWebhookUrl: {
        name: 'setCustomWebhookUrl',
        type: {
          name: 'function',
        },
      },
      setSlackWebhookUrl: {
        name: 'setSlackWebhookUrl',
        type: {
          name: 'function',
        },
      },
    },
    initialArgs: {
      app: {
        id: ':appId',
        slackWebhookUrl:
          'https://slack-webhook-url.slack.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
        customWebhookUrl:
          'https://custom-webhook-url.example.com?some-really-long-query-string-to-make-the-url-overflow-by-a-lot',
      },
      slackWebhookUrl: '',
      customWebhookUrl: '',
      isSlackSaving: false,
      isCustomSaving: false,
      isSlackDrawerOpen: false,
      isCustomDrawerOpen: false,
    },
    depth: 3,
    parent: 'webapp-screens-managescreen-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen': {
    name: 'ManageScreen',
    id: 'webapp-screens-managescreen-managescreen',
    parent: 'webapp-screens-managescreen',
    depth: 2,
    children: [
      'webapp-screens-managescreen-managescreen--loading',
      'webapp-screens-managescreen-managescreen--unlinked-one-user',
      'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url',
      'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url-saml',
      'webapp-screens-managescreen-managescreen--unlinked-multiple-users',
      'webapp-screens-managescreen-managescreen--unlinked-cross-browser',
      'webapp-screens-managescreen-managescreen--linked',
      'webapp-screens-managescreen-managescreen--linked-refreshing',
    ],
    type: 'component',
  },
  'webapp-screens-managescreen-managescreen--loading': {
    id: 'webapp-screens-managescreen-managescreen--loading',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--unlinked-one-user': {
    id: 'webapp-screens-managescreen-managescreen--unlinked-one-user',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'unlinked one user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url': {
    id: 'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'unlinked one user, no invite url',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url-saml': {
    id: 'webapp-screens-managescreen-managescreen--unlinked-one-user-no-invite-url-saml',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'unlinked one user, no invite url, saml',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--unlinked-multiple-users': {
    id: 'webapp-screens-managescreen-managescreen--unlinked-multiple-users',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'unlinked multiple users',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--unlinked-cross-browser': {
    id: 'webapp-screens-managescreen-managescreen--unlinked-cross-browser',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'unlinked, cross browser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--linked': {
    id: 'webapp-screens-managescreen-managescreen--linked',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'linked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-managescreen--linked-refreshing': {
    id: 'webapp-screens-managescreen-managescreen--linked-refreshing',
    title: 'Webapp screens/ManageScreen/ManageScreen',
    name: 'linked, refreshing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-managescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview': {
    name: 'UIReview',
    id: 'webapp-screens-managescreen-uireview',
    parent: 'webapp-screens-managescreen',
    depth: 2,
    children: [
      'webapp-screens-managescreen-uireview--loading',
      'webapp-screens-managescreen-uireview--enabled',
      'webapp-screens-managescreen-uireview--enabled-updating',
      'webapp-screens-managescreen-uireview--just-enabled',
      'webapp-screens-managescreen-uireview--enabled-exceeded-threshold',
      'webapp-screens-managescreen-uireview--enabled-payment-required',
      'webapp-screens-managescreen-uireview--disabled',
      'webapp-screens-managescreen-uireview--disabled-updating',
      'webapp-screens-managescreen-uireview--just-disabled',
      'webapp-screens-managescreen-uireview--just-disabled-paused',
      'webapp-screens-managescreen-uireview--disabled-exceeded-threshold',
      'webapp-screens-managescreen-uireview--disabled-exceeded-threshold-org',
      'webapp-screens-managescreen-uireview--disabled-payment-required',
      'webapp-screens-managescreen-uireview--unlinked',
    ],
    type: 'component',
  },
  'webapp-screens-managescreen-uireview--loading': {
    id: 'webapp-screens-managescreen-uireview--loading',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--enabled': {
    id: 'webapp-screens-managescreen-uireview--enabled',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Enabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--enabled-updating': {
    id: 'webapp-screens-managescreen-uireview--enabled-updating',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Enabled, Updating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--just-enabled': {
    id: 'webapp-screens-managescreen-uireview--just-enabled',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Just Enabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--enabled-exceeded-threshold': {
    id: 'webapp-screens-managescreen-uireview--enabled-exceeded-threshold',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Enabled, Exceeded Threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--enabled-payment-required': {
    id: 'webapp-screens-managescreen-uireview--enabled-payment-required',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Enabled, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--disabled': {
    id: 'webapp-screens-managescreen-uireview--disabled',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--disabled-updating': {
    id: 'webapp-screens-managescreen-uireview--disabled-updating',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Disabled, Updating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--just-disabled': {
    id: 'webapp-screens-managescreen-uireview--just-disabled',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Just Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--just-disabled-paused': {
    id: 'webapp-screens-managescreen-uireview--just-disabled-paused',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Just Disabled Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--disabled-exceeded-threshold': {
    id: 'webapp-screens-managescreen-uireview--disabled-exceeded-threshold',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Disabled, Exceeded Threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--disabled-exceeded-threshold-org': {
    id: 'webapp-screens-managescreen-uireview--disabled-exceeded-threshold-org',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Disabled, Exceeded Threshold, Org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--disabled-payment-required': {
    id: 'webapp-screens-managescreen-uireview--disabled-payment-required',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Disabled, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-uireview--unlinked': {
    id: 'webapp-screens-managescreen-uireview--unlinked',
    title: 'Webapp screens/ManageScreen/UIReview',
    name: 'Unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-uireview',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests': {
    name: 'VisualTests',
    id: 'webapp-screens-managescreen-visualtests',
    parent: 'webapp-screens-managescreen',
    depth: 2,
    children: [
      'webapp-screens-managescreen-visualtests--loading',
      'webapp-screens-managescreen-visualtests--enabled',
      'webapp-screens-managescreen-visualtests--enabled-updating',
      'webapp-screens-managescreen-visualtests--just-enabled',
      'webapp-screens-managescreen-visualtests--just-enabled-two-browsers',
      'webapp-screens-managescreen-visualtests--just-enabled-three-browsers',
      'webapp-screens-managescreen-visualtests--enabled-no-snapshots',
      'webapp-screens-managescreen-visualtests--enabled-payment-required',
      'webapp-screens-managescreen-visualtests--disabled-has-snapshots',
      'webapp-screens-managescreen-visualtests--disabled-updating',
      'webapp-screens-managescreen-visualtests--disabled-no-snapshots',
      'webapp-screens-managescreen-visualtests--disabled-no-snapshots-org',
      'webapp-screens-managescreen-visualtests--disabled-payment-required',
      'webapp-screens-managescreen-visualtests--capture-stack-upgrade-available',
      'webapp-screens-managescreen-visualtests--capture-stack-upgrading',
      'webapp-screens-managescreen-visualtests--capture-stack-just-upgraded',
      'webapp-screens-managescreen-visualtests--capture-stack-downgrade-available',
      'webapp-screens-managescreen-visualtests--capture-stack-downgrading',
      'webapp-screens-managescreen-visualtests--capture-stack-just-downgraded',
    ],
    type: 'component',
  },
  'webapp-screens-managescreen-visualtests--loading': {
    id: 'webapp-screens-managescreen-visualtests--loading',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--enabled': {
    id: 'webapp-screens-managescreen-visualtests--enabled',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Enabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--enabled-updating': {
    id: 'webapp-screens-managescreen-visualtests--enabled-updating',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Enabled, Updating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--just-enabled': {
    id: 'webapp-screens-managescreen-visualtests--just-enabled',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Just Enabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--just-enabled-two-browsers': {
    id: 'webapp-screens-managescreen-visualtests--just-enabled-two-browsers',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Just Enabled Two Browsers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--just-enabled-three-browsers': {
    id: 'webapp-screens-managescreen-visualtests--just-enabled-three-browsers',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Just Enabled Three Browsers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--enabled-no-snapshots': {
    id: 'webapp-screens-managescreen-visualtests--enabled-no-snapshots',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Enabled, No Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--enabled-payment-required': {
    id: 'webapp-screens-managescreen-visualtests--enabled-payment-required',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Enabled, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--disabled-has-snapshots': {
    id: 'webapp-screens-managescreen-visualtests--disabled-has-snapshots',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Disabled, Has Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--disabled-updating': {
    id: 'webapp-screens-managescreen-visualtests--disabled-updating',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Disabled, Updating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--disabled-no-snapshots': {
    id: 'webapp-screens-managescreen-visualtests--disabled-no-snapshots',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Disabled, No Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--disabled-no-snapshots-org': {
    id: 'webapp-screens-managescreen-visualtests--disabled-no-snapshots-org',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Disabled, No Snapshots, Org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--disabled-payment-required': {
    id: 'webapp-screens-managescreen-visualtests--disabled-payment-required',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Disabled, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-upgrade-available': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-upgrade-available',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Upgrade Available',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-upgrading': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-upgrading',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Upgrading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-just-upgraded': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-just-upgraded',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Just Upgraded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-downgrade-available': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-downgrade-available',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Downgrade Available',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-downgrading': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-downgrading',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Downgrading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-managescreen-visualtests--capture-stack-just-downgraded': {
    id: 'webapp-screens-managescreen-visualtests--capture-stack-just-downgraded',
    title: 'Webapp screens/ManageScreen/VisualTests',
    name: 'Capture Stack Just Downgraded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-managescreen-visualtests',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing': {
    name: 'Marketing',
    id: 'webapp-screens-marketing',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-marketing-articles',
      'webapp-screens-marketing-companyscreen',
      'webapp-screens-marketing-comparescreen',
      'webapp-screens-marketing-cta',
      'webapp-screens-marketing-faq',
      'webapp-screens-marketing-feature',
      'webapp-screens-marketing-featurecallout',
      'webapp-screens-marketing-featuresscreens',
      'webapp-screens-marketing-hero',
      'webapp-screens-marketing-integrations',
      'webapp-screens-marketing-landingscreen',
      'webapp-screens-marketing-marketingfooter',
      'webapp-screens-marketing-marketingheader',
      'webapp-screens-marketing-marketingpagetitle',
      'webapp-screens-marketing-personascreens',
      'webapp-screens-marketing-pricingscreen',
      'webapp-screens-marketing-socialproof',
      'webapp-screens-marketing-testimonial',
      'webapp-screens-marketing-testimonials',
      'webapp-screens-marketing-valueprop',
      'webapp-screens-marketing-workflows',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-articles': {
    name: 'Articles',
    id: 'webapp-screens-marketing-articles',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-articles--default'],
    type: 'component',
  },
  'webapp-screens-marketing-articles--default': {
    id: 'webapp-screens-marketing-articles--default',
    title: 'Webapp screens/Marketing/Articles',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-articles',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-companyscreen': {
    name: 'CompanyScreen',
    id: 'webapp-screens-marketing-companyscreen',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-companyscreen-aboutscreen',
      'webapp-screens-marketing-companyscreen-jobsscreen',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-companyscreen-aboutscreen': {
    name: 'AboutScreen',
    id: 'webapp-screens-marketing-companyscreen-aboutscreen',
    parent: 'webapp-screens-marketing-companyscreen',
    depth: 3,
    children: ['webapp-screens-marketing-companyscreen-aboutscreen--base'],
    type: 'component',
  },
  'webapp-screens-marketing-companyscreen-aboutscreen--base': {
    id: 'webapp-screens-marketing-companyscreen-aboutscreen--base',
    title: 'Webapp screens/Marketing/CompanyScreen/AboutScreen',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-companyscreen-aboutscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-companyscreen-jobsscreen': {
    name: 'JobsScreen',
    id: 'webapp-screens-marketing-companyscreen-jobsscreen',
    parent: 'webapp-screens-marketing-companyscreen',
    depth: 3,
    children: ['webapp-screens-marketing-companyscreen-jobsscreen--base'],
    type: 'component',
  },
  'webapp-screens-marketing-companyscreen-jobsscreen--base': {
    id: 'webapp-screens-marketing-companyscreen-jobsscreen--base',
    title: 'Webapp screens/Marketing/CompanyScreen/JobsScreen',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-companyscreen-jobsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen': {
    name: 'CompareScreen',
    id: 'webapp-screens-marketing-comparescreen',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-comparescreen-comparelayout',
      'webapp-screens-marketing-comparescreen-comparescreen',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-comparescreen-comparelayout': {
    name: 'CompareLayout',
    id: 'webapp-screens-marketing-comparescreen-comparelayout',
    parent: 'webapp-screens-marketing-comparescreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-comparescreen-comparelayout--default',
      'webapp-screens-marketing-comparescreen-comparelayout--arc',
      'webapp-screens-marketing-comparescreen-comparelayout--rect',
      'webapp-screens-marketing-comparescreen-comparelayout--tetrisl',
      'webapp-screens-marketing-comparescreen-comparelayout--tetriss',
      'webapp-screens-marketing-comparescreen-comparelayout--tetrist',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-comparescreen-comparelayout--default': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--default',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparelayout--arc': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--arc',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'arc',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparelayout--rect': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--rect',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'rect',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparelayout--tetrisl': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--tetrisl',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'tetrisl',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparelayout--tetriss': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--tetriss',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'tetriss',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparelayout--tetrist': {
    id: 'webapp-screens-marketing-comparescreen-comparelayout--tetrist',
    title: 'Webapp screens/Marketing/CompareScreen/CompareLayout',
    name: 'tetrist',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparelayout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen': {
    name: 'CompareScreen',
    id: 'webapp-screens-marketing-comparescreen-comparescreen',
    parent: 'webapp-screens-marketing-comparescreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-comparescreen-comparescreen--chromatic',
      'webapp-screens-marketing-comparescreen-comparescreen--jest-image-snapshot',
      'webapp-screens-marketing-comparescreen-comparescreen--backstop-js',
      'webapp-screens-marketing-comparescreen-comparescreen--percy',
      'webapp-screens-marketing-comparescreen-comparescreen--screener',
      'webapp-screens-marketing-comparescreen-comparescreen--applitools',
      'webapp-screens-marketing-comparescreen-comparescreen--visual-testing',
      'webapp-screens-marketing-comparescreen-comparescreen--deploy-storybook',
      'webapp-screens-marketing-comparescreen-comparescreen--netlify',
      'webapp-screens-marketing-comparescreen-comparescreen--vercel',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-comparescreen-comparescreen--chromatic': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--chromatic',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Chromatic',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--jest-image-snapshot': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--jest-image-snapshot',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Jest image snapshot',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--backstop-js': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--backstop-js',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'BackstopJS',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--percy': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--percy',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Percy',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--screener': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--screener',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Screener',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--applitools': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--applitools',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Applitools',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--visual-testing': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--visual-testing',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Visual testing overview',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--deploy-storybook': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--deploy-storybook',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Deploy Storybook overview',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--netlify': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--netlify',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Netlify',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-comparescreen-comparescreen--vercel': {
    id: 'webapp-screens-marketing-comparescreen-comparescreen--vercel',
    title: 'Webapp screens/Marketing/CompareScreen/CompareScreen',
    name: 'Vercel',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-comparescreen-comparescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-cta': {
    name: 'CTA',
    id: 'webapp-screens-marketing-cta',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-cta--default'],
    type: 'component',
  },
  'webapp-screens-marketing-cta--default': {
    id: 'webapp-screens-marketing-cta--default',
    title: 'Webapp screens/Marketing/CTA',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-cta',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-faq': {
    name: 'FAQ',
    id: 'webapp-screens-marketing-faq',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-faq--default'],
    type: 'component',
  },
  'webapp-screens-marketing-faq--default': {
    id: 'webapp-screens-marketing-faq--default',
    title: 'Webapp screens/Marketing/FAQ',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-faq',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-feature': {
    name: 'Feature',
    id: 'webapp-screens-marketing-feature',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-feature--default',
      'webapp-screens-marketing-feature--w-children',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-feature--default': {
    id: 'webapp-screens-marketing-feature--default',
    title: 'Webapp screens/Marketing/Feature',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-feature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-feature--w-children': {
    id: 'webapp-screens-marketing-feature--w-children',
    title: 'Webapp screens/Marketing/Feature',
    name: 'w/children',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-feature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featurecallout': {
    name: 'FeatureCallout',
    id: 'webapp-screens-marketing-featurecallout',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-featurecallout--default'],
    type: 'component',
  },
  'webapp-screens-marketing-featurecallout--default': {
    id: 'webapp-screens-marketing-featurecallout--default',
    title: 'Webapp screens/Marketing/FeatureCallout',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-featurecallout',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens': {
    name: 'FeaturesScreens',
    id: 'webapp-screens-marketing-featuresscreens',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-featuresscreens-documentscreen',
      'webapp-screens-marketing-featuresscreens-featuresscreenshero',
      'webapp-screens-marketing-featuresscreens-publishscreen',
      'webapp-screens-marketing-featuresscreens-testscreen',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-featuresscreens-documentscreen': {
    name: 'DocumentScreen',
    id: 'webapp-screens-marketing-featuresscreens-documentscreen',
    parent: 'webapp-screens-marketing-featuresscreens',
    depth: 3,
    children: [
      'webapp-screens-marketing-featuresscreens-documentscreen--base',
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
      'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation',
      'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-featuresscreens-documentscreen--base': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample': {
    name: 'ComponentExample',
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--base',
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--did-activate-docs',
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot',
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot-ff',
      'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-docs',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--base': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/ComponentExample',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--did-activate-docs': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--did-activate-docs',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/ComponentExample',
    name: 'Did Activate Docs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/ComponentExample',
    name: 'Pure, Snapshot View',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot-ff': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-snapshot-ff',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/ComponentExample',
    name: 'Pure, Snapshot View, Firefox',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-docs': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample--pure-docs',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/ComponentExample',
    name: 'Pure, Docs View',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-componentexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation': {
    name: 'DocumentAnimation',
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation',
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--base',
      'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--cutoff',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--base': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/DocumentAnimation',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--cutoff': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation--cutoff',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/DocumentAnimation',
    name: 'Cutoff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-documentanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero': {
    name: 'DocumentScreenHero',
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero',
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--base',
      'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--maintenance-mode',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--base': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/DocumentScreenHero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--maintenance-mode': {
    id: 'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero--maintenance-mode',
    title: 'Webapp screens/Marketing/FeaturesScreens/DocumentScreen/DocumentScreenHero',
    name: 'Maintenance Mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-documentscreen-documentscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-featuresscreenshero': {
    name: 'FeaturesScreensHero',
    id: 'webapp-screens-marketing-featuresscreens-featuresscreenshero',
    parent: 'webapp-screens-marketing-featuresscreens',
    depth: 3,
    children: ['webapp-screens-marketing-featuresscreens-featuresscreenshero--base'],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-featuresscreenshero--base': {
    id: 'webapp-screens-marketing-featuresscreens-featuresscreenshero--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/FeaturesScreensHero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-featuresscreens-featuresscreenshero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen': {
    name: 'PublishScreen',
    id: 'webapp-screens-marketing-featuresscreens-publishscreen',
    parent: 'webapp-screens-marketing-featuresscreens',
    depth: 3,
    children: [
      'webapp-screens-marketing-featuresscreens-publishscreen--base',
      'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation',
      'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero',
      'webapp-screens-marketing-featuresscreens-publishscreen-review',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-featuresscreens-publishscreen--base': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation': {
    name: 'FeedbackAnimation',
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation',
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--base',
      'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--no-animation',
      'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--cutoff',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--base': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/FeedbackAnimation',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--no-animation': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--no-animation',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/FeedbackAnimation',
    name: 'No Animation',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--cutoff': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation--cutoff',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/FeedbackAnimation',
    name: 'Cutoff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-feedbackanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero': {
    name: 'PublishScreenHero',
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero',
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--base',
      'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--maintenance-mode',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--base': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/PublishScreenHero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--maintenance-mode': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero--maintenance-mode',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/PublishScreenHero',
    name: 'Maintenance Mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-publishscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-review': {
    name: 'Review',
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-review',
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen',
    depth: 4,
    children: ['webapp-screens-marketing-featuresscreens-publishscreen-review--base'],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-publishscreen-review--base': {
    id: 'webapp-screens-marketing-featuresscreens-publishscreen-review--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/PublishScreen/Review',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-publishscreen-review',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen': {
    name: 'TestScreen',
    id: 'webapp-screens-marketing-featuresscreens-testscreen',
    parent: 'webapp-screens-marketing-featuresscreens',
    depth: 3,
    children: [
      'webapp-screens-marketing-featuresscreens-testscreen--base',
      'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation',
      'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample',
      'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-featuresscreens-testscreen--base': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation': {
    name: 'PinpointBugsAnimation',
    id: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation',
    parent: 'webapp-screens-marketing-featuresscreens-testscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--base',
      'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--paused',
      'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--cutoff',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--base': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/PinpointBugsAnimation',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--paused': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--paused',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/PinpointBugsAnimation',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--cutoff': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation--cutoff',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/PinpointBugsAnimation',
    name: 'Cutoff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-pinpointbugsanimation',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample': {
    name: 'SnapshotExample',
    id: 'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample',
    parent: 'webapp-screens-marketing-featuresscreens-testscreen',
    depth: 4,
    children: ['webapp-screens-marketing-featuresscreens-testscreen-snapshotexample--default'],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample--default': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample--default',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/SnapshotExample',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-snapshotexample',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero': {
    name: 'TestScreenHero',
    id: 'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero',
    parent: 'webapp-screens-marketing-featuresscreens-testscreen',
    depth: 4,
    children: [
      'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--base',
      'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--maintenance-mode',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--base': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--base',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/TestScreenHero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--maintenance-mode': {
    id: 'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero--maintenance-mode',
    title: 'Webapp screens/Marketing/FeaturesScreens/TestScreen/TestScreenHero',
    name: 'Maintenance Mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 5,
    parent: 'webapp-screens-marketing-featuresscreens-testscreen-testscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-hero': {
    name: 'Hero',
    id: 'webapp-screens-marketing-hero',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-hero--base',
      'webapp-screens-marketing-hero--bottom-animation',
      'webapp-screens-marketing-hero--bottom-animation-inverted',
      'webapp-screens-marketing-hero--maintenance-mode',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-hero--base': {
    id: 'webapp-screens-marketing-hero--base',
    title: 'Webapp screens/Marketing/Hero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-hero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-hero--bottom-animation': {
    id: 'webapp-screens-marketing-hero--bottom-animation',
    title: 'Webapp screens/Marketing/Hero',
    name: 'Bottom Animation',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-hero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-hero--bottom-animation-inverted': {
    id: 'webapp-screens-marketing-hero--bottom-animation-inverted',
    title: 'Webapp screens/Marketing/Hero',
    name: 'Bottom Animation Inverted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-hero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-hero--maintenance-mode': {
    id: 'webapp-screens-marketing-hero--maintenance-mode',
    title: 'Webapp screens/Marketing/Hero',
    name: 'Maintenance Mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-hero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-integrations': {
    name: 'Integrations',
    id: 'webapp-screens-marketing-integrations',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-integrations--default'],
    type: 'component',
  },
  'webapp-screens-marketing-integrations--default': {
    id: 'webapp-screens-marketing-integrations--default',
    title: 'Webapp screens/Marketing/Integrations',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-integrations',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen': {
    name: 'LandingScreen',
    id: 'webapp-screens-marketing-landingscreen',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-landingscreen-automatedworkflows',
      'webapp-screens-marketing-landingscreen-landingscreen',
      'webapp-screens-marketing-landingscreen-landingscreenhero',
      'webapp-screens-marketing-landingscreen-notables',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-landingscreen-automatedworkflows': {
    name: 'AutomatedWorkflows',
    id: 'webapp-screens-marketing-landingscreen-automatedworkflows',
    parent: 'webapp-screens-marketing-landingscreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-landingscreen-automatedworkflows--base',
      'webapp-screens-marketing-landingscreen-automatedworkflows--paused',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-landingscreen-automatedworkflows--base': {
    id: 'webapp-screens-marketing-landingscreen-automatedworkflows--base',
    title: 'Webapp screens/Marketing/LandingScreen/AutomatedWorkflows',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-automatedworkflows',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-automatedworkflows--paused': {
    id: 'webapp-screens-marketing-landingscreen-automatedworkflows--paused',
    title: 'Webapp screens/Marketing/LandingScreen/AutomatedWorkflows',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-automatedworkflows',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-landingscreen': {
    name: 'LandingScreen',
    id: 'webapp-screens-marketing-landingscreen-landingscreen',
    parent: 'webapp-screens-marketing-landingscreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in',
      'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in-maintenance-mode',
      'webapp-screens-marketing-landingscreen-landingscreen--logged-in',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in': {
    id: 'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in',
    title: 'Webapp screens/Marketing/LandingScreen/LandingScreen',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-landingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in-maintenance-mode': {
    id: 'webapp-screens-marketing-landingscreen-landingscreen--not-logged-in-maintenance-mode',
    title: 'Webapp screens/Marketing/LandingScreen/LandingScreen',
    name: 'not logged in, maintenance mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-landingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-landingscreen--logged-in': {
    id: 'webapp-screens-marketing-landingscreen-landingscreen--logged-in',
    title: 'Webapp screens/Marketing/LandingScreen/LandingScreen',
    name: 'logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-landingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-landingscreenhero': {
    name: 'LandingScreenHero',
    id: 'webapp-screens-marketing-landingscreen-landingscreenhero',
    parent: 'webapp-screens-marketing-landingscreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-landingscreen-landingscreenhero--base',
      'webapp-screens-marketing-landingscreen-landingscreenhero--maintenance-mode',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-landingscreen-landingscreenhero--base': {
    id: 'webapp-screens-marketing-landingscreen-landingscreenhero--base',
    title: 'Webapp screens/Marketing/LandingScreen/LandingScreenHero',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-landingscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-landingscreenhero--maintenance-mode': {
    id: 'webapp-screens-marketing-landingscreen-landingscreenhero--maintenance-mode',
    title: 'Webapp screens/Marketing/LandingScreen/LandingScreenHero',
    name: 'Maintenance Mode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-landingscreenhero',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-landingscreen-notables': {
    name: 'Notables',
    id: 'webapp-screens-marketing-landingscreen-notables',
    parent: 'webapp-screens-marketing-landingscreen',
    depth: 3,
    children: ['webapp-screens-marketing-landingscreen-notables--default'],
    type: 'component',
  },
  'webapp-screens-marketing-landingscreen-notables--default': {
    id: 'webapp-screens-marketing-landingscreen-notables--default',
    title: 'Webapp screens/Marketing/LandingScreen/Notables',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-landingscreen-notables',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingfooter': {
    name: 'MarketingFooter',
    id: 'webapp-screens-marketing-marketingfooter',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-marketingfooter--default'],
    type: 'component',
  },
  'webapp-screens-marketing-marketingfooter--default': {
    id: 'webapp-screens-marketing-marketingfooter--default',
    title: 'Webapp screens/Marketing/MarketingFooter',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingfooter',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader': {
    name: 'MarketingHeader',
    id: 'webapp-screens-marketing-marketingheader',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-marketingheader--not-logged-in',
      'webapp-screens-marketing-marketingheader--logged-in',
      'webapp-screens-marketing-marketingheader--not-logged-in-maintenance-mode',
      'webapp-screens-marketing-marketingheader--logged-in-maintenance-mode',
      'webapp-screens-marketing-marketingheader--inverse-logged-in',
      'webapp-screens-marketing-marketingheader--inverse-not-logged-in',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-marketingheader--not-logged-in': {
    id: 'webapp-screens-marketing-marketingheader--not-logged-in',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader--logged-in': {
    id: 'webapp-screens-marketing-marketingheader--logged-in',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader--not-logged-in-maintenance-mode': {
    id: 'webapp-screens-marketing-marketingheader--not-logged-in-maintenance-mode',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'not logged in, maintenanceMode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader--logged-in-maintenance-mode': {
    id: 'webapp-screens-marketing-marketingheader--logged-in-maintenance-mode',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'logged in, maintenanceMode',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader--inverse-logged-in': {
    id: 'webapp-screens-marketing-marketingheader--inverse-logged-in',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'logged in, inverse',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingheader--inverse-not-logged-in': {
    id: 'webapp-screens-marketing-marketingheader--inverse-not-logged-in',
    title: 'Webapp screens/Marketing/MarketingHeader',
    name: 'not logged in, inverse',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-marketingpagetitle': {
    name: 'MarketingPageTitle',
    id: 'webapp-screens-marketing-marketingpagetitle',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-marketingpagetitle--default'],
    type: 'component',
  },
  'webapp-screens-marketing-marketingpagetitle--default': {
    id: 'webapp-screens-marketing-marketingpagetitle--default',
    title: 'Webapp screens/Marketing/MarketingPageTitle',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-marketingpagetitle',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-personascreens': {
    name: 'PersonaScreens',
    id: 'webapp-screens-marketing-personascreens',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-personascreens-designsystemsscreen',
      'webapp-screens-marketing-personascreens-digitalagenciesscreen',
      'webapp-screens-marketing-personascreens-frontendteamsscreen',
      'webapp-screens-marketing-personascreens-personaheader',
      'webapp-screens-marketing-personascreens-storybookusersscreen',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-personascreens-designsystemsscreen': {
    name: 'DesignSystemsScreen',
    id: 'webapp-screens-marketing-personascreens-designsystemsscreen',
    parent: 'webapp-screens-marketing-personascreens',
    depth: 3,
    children: ['webapp-screens-marketing-personascreens-designsystemsscreen--default'],
    type: 'component',
  },
  'webapp-screens-marketing-personascreens-designsystemsscreen--default': {
    id: 'webapp-screens-marketing-personascreens-designsystemsscreen--default',
    title: 'Webapp screens/Marketing/PersonaScreens/DesignSystemsScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-personascreens-designsystemsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-personascreens-digitalagenciesscreen': {
    name: 'DigitalAgenciesScreen',
    id: 'webapp-screens-marketing-personascreens-digitalagenciesscreen',
    parent: 'webapp-screens-marketing-personascreens',
    depth: 3,
    children: ['webapp-screens-marketing-personascreens-digitalagenciesscreen--default'],
    type: 'component',
  },
  'webapp-screens-marketing-personascreens-digitalagenciesscreen--default': {
    id: 'webapp-screens-marketing-personascreens-digitalagenciesscreen--default',
    title: 'Webapp screens/Marketing/PersonaScreens/DigitalAgenciesScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-personascreens-digitalagenciesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-personascreens-frontendteamsscreen': {
    name: 'FrontendTeamsScreen',
    id: 'webapp-screens-marketing-personascreens-frontendteamsscreen',
    parent: 'webapp-screens-marketing-personascreens',
    depth: 3,
    children: ['webapp-screens-marketing-personascreens-frontendteamsscreen--default'],
    type: 'component',
  },
  'webapp-screens-marketing-personascreens-frontendteamsscreen--default': {
    id: 'webapp-screens-marketing-personascreens-frontendteamsscreen--default',
    title: 'Webapp screens/Marketing/PersonaScreens/FrontendTeamsScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-personascreens-frontendteamsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-personascreens-personaheader': {
    name: 'PersonaHeader',
    id: 'webapp-screens-marketing-personascreens-personaheader',
    parent: 'webapp-screens-marketing-personascreens',
    depth: 3,
    children: ['webapp-screens-marketing-personascreens-personaheader--default'],
    type: 'component',
  },
  'webapp-screens-marketing-personascreens-personaheader--default': {
    id: 'webapp-screens-marketing-personascreens-personaheader--default',
    title: 'Webapp screens/Marketing/PersonaScreens/PersonaHeader',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-personascreens-personaheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-personascreens-storybookusersscreen': {
    name: 'StorybookUsersScreen',
    id: 'webapp-screens-marketing-personascreens-storybookusersscreen',
    parent: 'webapp-screens-marketing-personascreens',
    depth: 3,
    children: ['webapp-screens-marketing-personascreens-storybookusersscreen--default'],
    type: 'component',
  },
  'webapp-screens-marketing-personascreens-storybookusersscreen--default': {
    id: 'webapp-screens-marketing-personascreens-storybookusersscreen--default',
    title: 'Webapp screens/Marketing/PersonaScreens/StorybookUsersScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-personascreens-storybookusersscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen': {
    name: 'PricingScreen',
    id: 'webapp-screens-marketing-pricingscreen',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-pricingscreen-faqpricing',
      'webapp-screens-marketing-pricingscreen-prices',
      'webapp-screens-marketing-pricingscreen-pricingfeatures',
      'webapp-screens-marketing-pricingscreen-pricingscreen',
    ],
    type: 'group',
  },
  'webapp-screens-marketing-pricingscreen-faqpricing': {
    name: 'FAQPricing',
    id: 'webapp-screens-marketing-pricingscreen-faqpricing',
    parent: 'webapp-screens-marketing-pricingscreen',
    depth: 3,
    children: ['webapp-screens-marketing-pricingscreen-faqpricing--default'],
    type: 'component',
  },
  'webapp-screens-marketing-pricingscreen-faqpricing--default': {
    id: 'webapp-screens-marketing-pricingscreen-faqpricing--default',
    title: 'Webapp screens/Marketing/PricingScreen/FAQPricing',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-faqpricing',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen-prices': {
    name: 'Prices',
    id: 'webapp-screens-marketing-pricingscreen-prices',
    parent: 'webapp-screens-marketing-pricingscreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-pricingscreen-prices--logged-in',
      'webapp-screens-marketing-pricingscreen-prices--not-logged-in',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-pricingscreen-prices--logged-in': {
    id: 'webapp-screens-marketing-pricingscreen-prices--logged-in',
    title: 'Webapp screens/Marketing/PricingScreen/Prices',
    name: 'Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-prices',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen-prices--not-logged-in': {
    id: 'webapp-screens-marketing-pricingscreen-prices--not-logged-in',
    title: 'Webapp screens/Marketing/PricingScreen/Prices',
    name: 'Not Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-prices',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen-pricingfeatures': {
    name: 'PricingFeatures',
    id: 'webapp-screens-marketing-pricingscreen-pricingfeatures',
    parent: 'webapp-screens-marketing-pricingscreen',
    depth: 3,
    children: ['webapp-screens-marketing-pricingscreen-pricingfeatures--default'],
    type: 'component',
  },
  'webapp-screens-marketing-pricingscreen-pricingfeatures--default': {
    id: 'webapp-screens-marketing-pricingscreen-pricingfeatures--default',
    title: 'Webapp screens/Marketing/PricingScreen/PricingFeatures',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-pricingfeatures',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen-pricingscreen': {
    name: 'PricingScreen',
    id: 'webapp-screens-marketing-pricingscreen-pricingscreen',
    parent: 'webapp-screens-marketing-pricingscreen',
    depth: 3,
    children: [
      'webapp-screens-marketing-pricingscreen-pricingscreen--logged-in',
      'webapp-screens-marketing-pricingscreen-pricingscreen--not-logged-in',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-pricingscreen-pricingscreen--logged-in': {
    id: 'webapp-screens-marketing-pricingscreen-pricingscreen--logged-in',
    title: 'Webapp screens/Marketing/PricingScreen/PricingScreen',
    name: 'Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-pricingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-pricingscreen-pricingscreen--not-logged-in': {
    id: 'webapp-screens-marketing-pricingscreen-pricingscreen--not-logged-in',
    title: 'Webapp screens/Marketing/PricingScreen/PricingScreen',
    name: 'Not Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-marketing-pricingscreen-pricingscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-socialproof': {
    name: 'SocialProof',
    id: 'webapp-screens-marketing-socialproof',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-socialproof--default'],
    type: 'component',
  },
  'webapp-screens-marketing-socialproof--default': {
    id: 'webapp-screens-marketing-socialproof--default',
    title: 'Webapp screens/Marketing/SocialProof',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-socialproof',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-testimonial': {
    name: 'Testimonial',
    id: 'webapp-screens-marketing-testimonial',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-testimonial--default',
      'webapp-screens-marketing-testimonial--compact',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-testimonial--default': {
    id: 'webapp-screens-marketing-testimonial--default',
    title: 'Webapp screens/Marketing/Testimonial',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-testimonial',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-testimonial--compact': {
    id: 'webapp-screens-marketing-testimonial--compact',
    title: 'Webapp screens/Marketing/Testimonial',
    name: 'compact',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-testimonial',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-testimonials': {
    name: 'Testimonials',
    id: 'webapp-screens-marketing-testimonials',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-testimonials--default'],
    type: 'component',
  },
  'webapp-screens-marketing-testimonials--default': {
    id: 'webapp-screens-marketing-testimonials--default',
    title: 'Webapp screens/Marketing/Testimonials',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-testimonials',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-valueprop': {
    name: 'ValueProp',
    id: 'webapp-screens-marketing-valueprop',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: ['webapp-screens-marketing-valueprop--default'],
    type: 'component',
  },
  'webapp-screens-marketing-valueprop--default': {
    id: 'webapp-screens-marketing-valueprop--default',
    title: 'Webapp screens/Marketing/ValueProp',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-valueprop',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-workflows': {
    name: 'Workflows',
    id: 'webapp-screens-marketing-workflows',
    parent: 'webapp-screens-marketing',
    depth: 2,
    children: [
      'webapp-screens-marketing-workflows--publish',
      'webapp-screens-marketing-workflows--test',
      'webapp-screens-marketing-workflows--document',
    ],
    type: 'component',
  },
  'webapp-screens-marketing-workflows--publish': {
    id: 'webapp-screens-marketing-workflows--publish',
    title: 'Webapp screens/Marketing/Workflows',
    name: 'Publish',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-workflows',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-workflows--test': {
    id: 'webapp-screens-marketing-workflows--test',
    title: 'Webapp screens/Marketing/Workflows',
    name: 'Test',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-workflows',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-marketing-workflows--document': {
    id: 'webapp-screens-marketing-workflows--document',
    title: 'Webapp screens/Marketing/Workflows',
    name: 'Document',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-marketing-workflows',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-notificationsscreen': {
    name: 'NotificationsScreen',
    id: 'webapp-screens-notificationsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-notificationsscreen--loading',
      'webapp-screens-notificationsscreen--default',
      'webapp-screens-notificationsscreen--empty',
      'webapp-screens-notificationsscreen--without-an-email-link',
    ],
    type: 'component',
  },
  'webapp-screens-notificationsscreen--loading': {
    id: 'webapp-screens-notificationsscreen--loading',
    title: 'Webapp screens/NotificationsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-notificationsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-notificationsscreen--default': {
    id: 'webapp-screens-notificationsscreen--default',
    title: 'Webapp screens/NotificationsScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-notificationsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-notificationsscreen--empty': {
    id: 'webapp-screens-notificationsscreen--empty',
    title: 'Webapp screens/NotificationsScreen',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-notificationsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-notificationsscreen--without-an-email-link': {
    id: 'webapp-screens-notificationsscreen--without-an-email-link',
    title: 'Webapp screens/NotificationsScreen',
    name: 'without an email link',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-notificationsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding': {
    name: 'Onboarding',
    id: 'webapp-screens-onboarding',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-onboarding-chooserepository',
      'webapp-screens-onboarding-createproject',
      'webapp-screens-onboarding-onboardingscreen-clickable',
      'webapp-screens-onboarding-projecttypepicker',
      'webapp-screens-onboarding-setupprojectflow-clickable',
    ],
    type: 'group',
  },
  'webapp-screens-onboarding-chooserepository': {
    name: 'ChooseRepository',
    id: 'webapp-screens-onboarding-chooserepository',
    parent: 'webapp-screens-onboarding',
    depth: 2,
    children: [
      'webapp-screens-onboarding-chooserepository--loading',
      'webapp-screens-onboarding-chooserepository--default',
      'webapp-screens-onboarding-chooserepository--default-refreshing',
      'webapp-screens-onboarding-chooserepository--default-bitbucket',
    ],
    type: 'component',
  },
  'webapp-screens-onboarding-chooserepository--loading': {
    id: 'webapp-screens-onboarding-chooserepository--loading',
    title: 'Webapp screens/Onboarding/ChooseRepository',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-chooserepository',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-chooserepository--default': {
    id: 'webapp-screens-onboarding-chooserepository--default',
    title: 'Webapp screens/Onboarding/ChooseRepository',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-chooserepository',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-chooserepository--default-refreshing': {
    id: 'webapp-screens-onboarding-chooserepository--default-refreshing',
    title: 'Webapp screens/Onboarding/ChooseRepository',
    name: 'default, refreshing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-chooserepository',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-chooserepository--default-bitbucket': {
    id: 'webapp-screens-onboarding-chooserepository--default-bitbucket',
    title: 'Webapp screens/Onboarding/ChooseRepository',
    name: 'default, bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-chooserepository',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-createproject': {
    name: 'CreateProject',
    id: 'webapp-screens-onboarding-createproject',
    parent: 'webapp-screens-onboarding',
    depth: 2,
    children: ['webapp-screens-onboarding-createproject--default'],
    type: 'component',
  },
  'webapp-screens-onboarding-createproject--default': {
    id: 'webapp-screens-onboarding-createproject--default',
    title: 'Webapp screens/Onboarding/CreateProject',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-createproject',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-onboardingscreen-clickable': {
    name: 'OnboardingScreen (clickable)',
    id: 'webapp-screens-onboarding-onboardingscreen-clickable',
    parent: 'webapp-screens-onboarding',
    depth: 2,
    children: [
      'webapp-screens-onboarding-onboardingscreen-clickable--loading',
      'webapp-screens-onboarding-onboardingscreen-clickable--default',
      'webapp-screens-onboarding-onboardingscreen-clickable--saml',
    ],
    type: 'component',
  },
  'webapp-screens-onboarding-onboardingscreen-clickable--loading': {
    id: 'webapp-screens-onboarding-onboardingscreen-clickable--loading',
    title: 'Webapp screens/Onboarding/OnboardingScreen (clickable)',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-onboardingscreen-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-onboardingscreen-clickable--default': {
    id: 'webapp-screens-onboarding-onboardingscreen-clickable--default',
    title: 'Webapp screens/Onboarding/OnboardingScreen (clickable)',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-onboardingscreen-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-onboardingscreen-clickable--saml': {
    id: 'webapp-screens-onboarding-onboardingscreen-clickable--saml',
    title: 'Webapp screens/Onboarding/OnboardingScreen (clickable)',
    name: 'saml',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-onboardingscreen-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-projecttypepicker': {
    name: 'ProjectTypePicker',
    id: 'webapp-screens-onboarding-projecttypepicker',
    parent: 'webapp-screens-onboarding',
    depth: 2,
    children: [
      'webapp-screens-onboarding-projecttypepicker--github',
      'webapp-screens-onboarding-projecttypepicker--bitbucket',
      'webapp-screens-onboarding-projecttypepicker--gitlab',
    ],
    type: 'component',
  },
  'webapp-screens-onboarding-projecttypepicker--github': {
    id: 'webapp-screens-onboarding-projecttypepicker--github',
    title: 'Webapp screens/Onboarding/ProjectTypePicker',
    name: 'Github',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-projecttypepicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-projecttypepicker--bitbucket': {
    id: 'webapp-screens-onboarding-projecttypepicker--bitbucket',
    title: 'Webapp screens/Onboarding/ProjectTypePicker',
    name: 'Bitbucket',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-projecttypepicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-projecttypepicker--gitlab': {
    id: 'webapp-screens-onboarding-projecttypepicker--gitlab',
    title: 'Webapp screens/Onboarding/ProjectTypePicker',
    name: 'Gitlab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-projecttypepicker',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-setupprojectflow-clickable': {
    name: 'SetupProjectFlow (clickable)',
    id: 'webapp-screens-onboarding-setupprojectflow-clickable',
    parent: 'webapp-screens-onboarding',
    depth: 2,
    children: [
      'webapp-screens-onboarding-setupprojectflow-clickable--loading',
      'webapp-screens-onboarding-setupprojectflow-clickable--onboarding',
      'webapp-screens-onboarding-setupprojectflow-clickable--onboarding-saml-user',
      'webapp-screens-onboarding-setupprojectflow-clickable--add-project',
    ],
    type: 'component',
  },
  'webapp-screens-onboarding-setupprojectflow-clickable--loading': {
    id: 'webapp-screens-onboarding-setupprojectflow-clickable--loading',
    title: 'Webapp screens/Onboarding/SetupProjectFlow (clickable)',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-setupprojectflow-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-setupprojectflow-clickable--onboarding': {
    id: 'webapp-screens-onboarding-setupprojectflow-clickable--onboarding',
    title: 'Webapp screens/Onboarding/SetupProjectFlow (clickable)',
    name: 'onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-setupprojectflow-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-setupprojectflow-clickable--onboarding-saml-user': {
    id: 'webapp-screens-onboarding-setupprojectflow-clickable--onboarding-saml-user',
    title: 'Webapp screens/Onboarding/SetupProjectFlow (clickable)',
    name: 'onboarding, saml user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-setupprojectflow-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-onboarding-setupprojectflow-clickable--add-project': {
    id: 'webapp-screens-onboarding-setupprojectflow-clickable--add-project',
    title: 'Webapp screens/Onboarding/SetupProjectFlow (clickable)',
    name: 'add project',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-onboarding-setupprojectflow-clickable',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-preferencesupdatedscreen': {
    name: 'PreferencesUpdatedScreen',
    id: 'webapp-screens-preferencesupdatedscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: ['webapp-screens-preferencesupdatedscreen--default'],
    type: 'component',
  },
  'webapp-screens-preferencesupdatedscreen--default': {
    id: 'webapp-screens-preferencesupdatedscreen--default',
    title: 'Webapp screens/PreferencesUpdatedScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-preferencesupdatedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest': {
    name: 'PullRequest',
    id: 'webapp-screens-pullrequest',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-pullrequest-activity',
      'webapp-screens-pullrequest-buildstatustooltip',
      'webapp-screens-pullrequest-checklist',
      'webapp-screens-pullrequest-features',
      'webapp-screens-pullrequest-nocomparison',
      'webapp-screens-pullrequest-pullrequestchangecomments',
      'webapp-screens-pullrequest-pullrequestchangecommentthread',
      'webapp-screens-pullrequest-pullrequestchangeitem',
      'webapp-screens-pullrequest-pullrequestchanges',
      'webapp-screens-pullrequest-pullrequestchecktooltip',
      'webapp-screens-pullrequest-pullrequestcomponents',
      'webapp-screens-pullrequest-pullrequestexplainer',
      'webapp-screens-pullrequest-pullrequestheader',
      'webapp-screens-pullrequest-pullrequestparticipants',
      'webapp-screens-pullrequest-pullrequestreviewers',
      'webapp-screens-pullrequest-pullrequestscreen',
      'webapp-screens-pullrequest-reviewbutton',
      'webapp-screens-pullrequest-selectreviewers',
    ],
    type: 'group',
  },
  'webapp-screens-pullrequest-activity': {
    name: 'Activity',
    id: 'webapp-screens-pullrequest-activity',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-activity-activity',
      'webapp-screens-pullrequest-activity-activityitem',
      'webapp-screens-pullrequest-activity-buildactivity',
      'webapp-screens-pullrequest-activity-commentthreadactivity',
      'webapp-screens-pullrequest-activity-reviewactivity',
    ],
    type: 'group',
  },
  'webapp-screens-pullrequest-activity-activity': {
    name: 'Activity',
    id: 'webapp-screens-pullrequest-activity-activity',
    parent: 'webapp-screens-pullrequest-activity',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-activity-activity--loading',
      'webapp-screens-pullrequest-activity-activity--no-builds',
      'webapp-screens-pullrequest-activity-activity--simple',
      'webapp-screens-pullrequest-activity-activity--ui-review-disabled',
      'webapp-screens-pullrequest-activity-activity--ui-review-disabled-no-reviewers',
      'webapp-screens-pullrequest-activity-activity--reviews',
      'webapp-screens-pullrequest-activity-activity--in-progress-build',
      'webapp-screens-pullrequest-activity-activity--comments',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-activity-activity--loading': {
    id: 'webapp-screens-pullrequest-activity-activity--loading',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--no-builds': {
    id: 'webapp-screens-pullrequest-activity-activity--no-builds',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'No Builds',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--simple': {
    id: 'webapp-screens-pullrequest-activity-activity--simple',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'Simple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--ui-review-disabled': {
    id: 'webapp-screens-pullrequest-activity-activity--ui-review-disabled',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--ui-review-disabled-no-reviewers': {
    id: 'webapp-screens-pullrequest-activity-activity--ui-review-disabled-no-reviewers',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'UI Review Disabled No Reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--reviews': {
    id: 'webapp-screens-pullrequest-activity-activity--reviews',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'Reviews',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--in-progress-build': {
    id: 'webapp-screens-pullrequest-activity-activity--in-progress-build',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'In Progress Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activity--comments': {
    id: 'webapp-screens-pullrequest-activity-activity--comments',
    title: 'Webapp screens/PullRequest/Activity/Activity',
    name: 'Comments',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activityitem': {
    name: 'ActivityItem',
    id: 'webapp-screens-pullrequest-activity-activityitem',
    parent: 'webapp-screens-pullrequest-activity',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-activity-activityitem--default',
      'webapp-screens-pullrequest-activity-activityitem--loading',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-activity-activityitem--default': {
    id: 'webapp-screens-pullrequest-activity-activityitem--default',
    title: 'Webapp screens/PullRequest/Activity/ActivityItem',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-activityitem--loading': {
    id: 'webapp-screens-pullrequest-activity-activityitem--loading',
    title: 'Webapp screens/PullRequest/Activity/ActivityItem',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-activityitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity': {
    name: 'BuildActivity',
    id: 'webapp-screens-pullrequest-activity-buildactivity',
    parent: 'webapp-screens-pullrequest-activity',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-activity-buildactivity--loading',
      'webapp-screens-pullrequest-activity-buildactivity--no-capture',
      'webapp-screens-pullrequest-activity-buildactivity--in-progress',
      'webapp-screens-pullrequest-activity-buildactivity--timed-out',
      'webapp-screens-pullrequest-activity-buildactivity--error',
      'webapp-screens-pullrequest-activity-buildactivity--failed',
      'webapp-screens-pullrequest-activity-buildactivity--passed',
      'webapp-screens-pullrequest-activity-buildactivity--pending',
      'webapp-screens-pullrequest-activity-buildactivity--accepted',
      'webapp-screens-pullrequest-activity-buildactivity--denied',
      'webapp-screens-pullrequest-activity-buildactivity--limited',
      'webapp-screens-pullrequest-activity-buildactivity--publish-only',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-activity-buildactivity--loading': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--loading',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--no-capture': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--no-capture',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'No Capture',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--in-progress': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--in-progress',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--timed-out': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--timed-out',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Timed Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--error': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--error',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--failed': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--failed',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--passed': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--passed',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--pending': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--pending',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--accepted': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--accepted',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--denied': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--denied',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--limited': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--limited',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-buildactivity--publish-only': {
    id: 'webapp-screens-pullrequest-activity-buildactivity--publish-only',
    title: 'Webapp screens/PullRequest/Activity/BuildActivity',
    name: 'Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-buildactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity': {
    name: 'CommentThreadActivity',
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    parent: 'webapp-screens-pullrequest-activity',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-activity-commentthreadactivity--active',
      'webapp-screens-pullrequest-activity-commentthreadactivity--active-truncated-text',
      'webapp-screens-pullrequest-activity-commentthreadactivity--active-diff-thread',
      'webapp-screens-pullrequest-activity-commentthreadactivity--active-short-height',
      'webapp-screens-pullrequest-activity-commentthreadactivity--active-non-owner',
      'webapp-screens-pullrequest-activity-commentthreadactivity--active-logged-out',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-diff-thread',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-mutating',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded-mutating',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out',
      'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out-expanded',
      'webapp-screens-pullrequest-activity-commentthreadactivity--outdated',
      'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-non-owner',
      'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-logged-out',
      'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-collapsed',
      'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-tooltip',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active-truncated-text': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active-truncated-text',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active Truncated Text',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active-diff-thread': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active-diff-thread',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active Diff Thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active-short-height': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active-short-height',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active Short Height',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active-non-owner': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active-non-owner',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active Non Owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--active-logged-out': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--active-logged-out',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Active Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-diff-thread': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-diff-thread',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Diff Thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-mutating': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-mutating',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Mutating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded-mutating': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-expanded-mutating',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Expanded Mutating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out-expanded': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--resolved-logged-out-expanded',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Resolved Logged Out Expanded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--outdated': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--outdated',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Outdated',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-non-owner': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-non-owner',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Outdated Non Owner',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-logged-out': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-logged-out',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Outdated Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-collapsed': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-collapsed',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Outdated Collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-tooltip': {
    id: 'webapp-screens-pullrequest-activity-commentthreadactivity--outdated-tooltip',
    title: 'Webapp screens/PullRequest/Activity/CommentThreadActivity',
    name: 'Outdated Tooltip',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-commentthreadactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity': {
    name: 'ReviewActivity',
    id: 'webapp-screens-pullrequest-activity-reviewactivity',
    parent: 'webapp-screens-pullrequest-activity',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-activity-reviewactivity--assigned-self',
      'webapp-screens-pullrequest-activity-reviewactivity--assigned-other',
      'webapp-screens-pullrequest-activity-reviewactivity--approved',
      'webapp-screens-pullrequest-activity-reviewactivity--unapproved',
      'webapp-screens-pullrequest-activity-reviewactivity--unassigned-self',
      'webapp-screens-pullrequest-activity-reviewactivity--unassigned-other',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-activity-reviewactivity--assigned-self': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--assigned-self',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Assigned Self',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity--assigned-other': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--assigned-other',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Assigned Other',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity--approved': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--approved',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Approved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity--unapproved': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--unapproved',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Unapproved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity--unassigned-self': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--unassigned-self',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Unassigned Self',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-activity-reviewactivity--unassigned-other': {
    id: 'webapp-screens-pullrequest-activity-reviewactivity--unassigned-other',
    title: 'Webapp screens/PullRequest/Activity/ReviewActivity',
    name: 'Unassigned Other',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-activity-reviewactivity',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip': {
    name: 'BuildStatusTooltip',
    id: 'webapp-screens-pullrequest-buildstatustooltip',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-buildstatustooltip--passing',
      'webapp-screens-pullrequest-buildstatustooltip--build-in-progress',
      'webapp-screens-pullrequest-buildstatustooltip--build-in-progress-tests-disabled',
      'webapp-screens-pullrequest-buildstatustooltip--paused',
      'webapp-screens-pullrequest-buildstatustooltip--errored-build',
      'webapp-screens-pullrequest-buildstatustooltip--errored-snapshots',
      'webapp-screens-pullrequest-buildstatustooltip--denied-snapshots',
      'webapp-screens-pullrequest-buildstatustooltip--pending-snapshots',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-buildstatustooltip--passing': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--passing',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Passing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--build-in-progress': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--build-in-progress',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--build-in-progress-tests-disabled': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--build-in-progress-tests-disabled',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Build In Progress Tests Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--paused': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--paused',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--errored-build': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--errored-build',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Errored Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--errored-snapshots': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--errored-snapshots',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Errored Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--denied-snapshots': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--denied-snapshots',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Denied Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-buildstatustooltip--pending-snapshots': {
    id: 'webapp-screens-pullrequest-buildstatustooltip--pending-snapshots',
    title: 'Webapp screens/PullRequest/BuildStatusTooltip',
    name: 'Pending Snapshots',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-buildstatustooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist': {
    name: 'Checklist',
    id: 'webapp-screens-pullrequest-checklist',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-checklist-checklist',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthread',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
      'webapp-screens-pullrequest-checklist-checklistbuilderrors',
      'webapp-screens-pullrequest-checklist-checklisterroreddiffs',
      'webapp-screens-pullrequest-checklist-checklistheader',
      'webapp-screens-pullrequest-checklist-checklistitemheader',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews',
      'webapp-screens-pullrequest-checklist-checklistspeccolumn',
      'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    ],
    type: 'group',
  },
  'webapp-screens-pullrequest-checklist-checklist': {
    name: 'Checklist',
    id: 'webapp-screens-pullrequest-checklist-checklist',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklist--empty',
      'webapp-screens-pullrequest-checklist-checklist--no-checks',
      'webapp-screens-pullrequest-checklist-checklist--all-passing',
      'webapp-screens-pullrequest-checklist-checklist--pending-reviews',
      'webapp-screens-pullrequest-checklist-checklist--active-comment-threads',
      'webapp-screens-pullrequest-checklist-checklist--visual-changes',
      'webapp-screens-pullrequest-checklist-checklist--build-error',
      'webapp-screens-pullrequest-checklist-checklist--build-in-progress',
      'webapp-screens-pullrequest-checklist-checklist--comparison-in-progress',
      'webapp-screens-pullrequest-checklist-checklist--no-comparison',
      'webapp-screens-pullrequest-checklist-checklist--diff-errors',
      'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold',
      'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-org',
      'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-no-plan-access',
      'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-in-progress-build',
      'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-error-build',
      'webapp-screens-pullrequest-checklist-checklist--paused-payment-required',
      'webapp-screens-pullrequest-checklist-checklist--was-paused-now-resumed',
      'webapp-screens-pullrequest-checklist-checklist--all-tests',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-exceeded-threshold',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-was-paused-now-resumed',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled-publish-only',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-build-error',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-build-in-progress',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-comparison-in-progress',
      'webapp-screens-pullrequest-checklist-checklist--all-tests-no-reviewers',
      'webapp-screens-pullrequest-checklist-checklist--logged-out',
      'webapp-screens-pullrequest-checklist-checklist--logged-out-no-reviewers',
      'webapp-screens-pullrequest-checklist-checklist--pure-selecting-reviewers',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklist--empty': {
    id: 'webapp-screens-pullrequest-checklist-checklist--empty',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--no-checks': {
    id: 'webapp-screens-pullrequest-checklist-checklist--no-checks',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'No Checks',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-passing': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-passing',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Passing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--pending-reviews': {
    id: 'webapp-screens-pullrequest-checklist-checklist--pending-reviews',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Pending Reviews',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--active-comment-threads': {
    id: 'webapp-screens-pullrequest-checklist-checklist--active-comment-threads',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Active Comment Threads',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--visual-changes': {
    id: 'webapp-screens-pullrequest-checklist-checklist--visual-changes',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Visual Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--build-error': {
    id: 'webapp-screens-pullrequest-checklist-checklist--build-error',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--build-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklist--build-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--comparison-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklist--comparison-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Comparison In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--no-comparison': {
    id: 'webapp-screens-pullrequest-checklist-checklist--no-comparison',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'No Comparison',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--diff-errors': {
    id: 'webapp-screens-pullrequest-checklist-checklist--diff-errors',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Diff Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Exceeded Threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-org': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-org',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Exceeded Threshold, Org',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-no-plan-access': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-no-plan-access',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Exceeded Threshold, No Access To Update Plans',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-in-progress-build': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-in-progress-build',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Exceeded Threshold, In Progress Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-error-build': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-exceeded-threshold-error-build',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Exceeded Threshold, Error Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--paused-payment-required': {
    id: 'webapp-screens-pullrequest-checklist-checklist--paused-payment-required',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Paused, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--was-paused-now-resumed': {
    id: 'webapp-screens-pullrequest-checklist-checklist--was-paused-now-resumed',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Was Paused, Now Resumed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-exceeded-threshold': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-exceeded-threshold',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests Exceeded Threshold',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-was-paused-now-resumed': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-was-paused-now-resumed',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests, Was Paused, Now Resumed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled-publish-only': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-ui-review-disabled-publish-only',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests UI Review Disabled Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-build-error': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-build-error',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests, Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-build-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-build-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests, Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-comparison-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-comparison-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests, Comparison In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--all-tests-no-reviewers': {
    id: 'webapp-screens-pullrequest-checklist-checklist--all-tests-no-reviewers',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'All Tests, No Reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--logged-out': {
    id: 'webapp-screens-pullrequest-checklist-checklist--logged-out',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--logged-out-no-reviewers': {
    id: 'webapp-screens-pullrequest-checklist-checklist--logged-out-no-reviewers',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Logged Out, No Reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklist--pure-selecting-reviewers': {
    id: 'webapp-screens-pullrequest-checklist-checklist--pure-selecting-reviewers',
    title: 'Webapp screens/PullRequest/Checklist/Checklist',
    name: 'Pure, Selecting Reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthread': {
    name: 'ChecklistActiveCommentThread',
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistactivecommentthread--base',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthread--logged-out',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthread--pure-resolving',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthread--base': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread--base',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThread',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthread--logged-out': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread--logged-out',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThread',
    name: 'Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthread--pure-resolving': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread--pure-resolving',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThread',
    name: 'Pure, Resolving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads': {
    name: 'ChecklistActiveCommentThreads',
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--single',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-constrained',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-logged-out',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-git-lab',
      'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--pure-resolving-all',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--single': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--single',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Single',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-constrained': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-constrained',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Multiple, Constrained',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-logged-out': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-logged-out',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Multiple, Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-git-lab': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--multiple-git-lab',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Multiple, GitLab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--pure-resolving-all': {
    id: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads--pure-resolving-all',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistActiveCommentThreads',
    name: 'Pure, Resolving All',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistactivecommentthreads',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistbuilderrors': {
    name: 'ChecklistBuildErrors',
    id: 'webapp-screens-pullrequest-checklist-checklistbuilderrors',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: ['webapp-screens-pullrequest-checklist-checklistbuilderrors--base'],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistbuilderrors--base': {
    id: 'webapp-screens-pullrequest-checklist-checklistbuilderrors--base',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistBuildErrors',
    name: 'Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistbuilderrors',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklisterroreddiffs': {
    name: 'ChecklistErroredDiffs',
    id: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklisterroreddiffs--single',
      'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple',
      'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple-git-lab',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklisterroreddiffs--single': {
    id: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs--single',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistErroredDiffs',
    name: 'Single',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple': {
    id: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistErroredDiffs',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple-git-lab': {
    id: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs--multiple-git-lab',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistErroredDiffs',
    name: 'Multiple, GitLab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklisterroreddiffs',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader': {
    name: 'ChecklistHeader',
    id: 'webapp-screens-pullrequest-checklist-checklistheader',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistheader--no-checks',
      'webapp-screens-pullrequest-checklist-checklistheader--all-passing',
      'webapp-screens-pullrequest-checklist-checklistheader--publish-only',
      'webapp-screens-pullrequest-checklist-checklistheader--with-warnings',
      'webapp-screens-pullrequest-checklist-checklistheader--with-warnings-git-lab',
      'webapp-screens-pullrequest-checklist-checklistheader--with-errors',
      'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors',
      'webapp-screens-pullrequest-checklist-checklistheader--build-in-progress',
      'webapp-screens-pullrequest-checklist-checklistheader--comparison-in-progress',
      'webapp-screens-pullrequest-checklist-checklistheader--ui-review-disabled',
      'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors-ui-review-disabled',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistheader--no-checks': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--no-checks',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'No Checks',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--all-passing': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--all-passing',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'All Passing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--publish-only': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--publish-only',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'Publish Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--with-warnings': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--with-warnings',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'With Warnings',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--with-warnings-git-lab': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--with-warnings-git-lab',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'With Warnings, GitLab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--with-errors': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--with-errors',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'With Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'With Build Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--build-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--build-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--comparison-in-progress': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--comparison-in-progress',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'Comparison In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--ui-review-disabled': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--ui-review-disabled',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors-ui-review-disabled': {
    id: 'webapp-screens-pullrequest-checklist-checklistheader--with-build-errors-ui-review-disabled',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistHeader',
    name: 'With Build Errors, UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistitemheader': {
    name: 'ChecklistItemHeader',
    id: 'webapp-screens-pullrequest-checklist-checklistitemheader',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistitemheader--warning',
      'webapp-screens-pullrequest-checklist-checklistitemheader--with-action',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistitemheader--warning': {
    id: 'webapp-screens-pullrequest-checklist-checklistitemheader--warning',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistItemHeader',
    name: 'Warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistitemheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistitemheader--with-action': {
    id: 'webapp-screens-pullrequest-checklist-checklistitemheader--with-action',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistItemHeader',
    name: 'With Action',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistitemheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews': {
    name: 'ChecklistPendingReviews',
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--single',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-approving',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-unassigning',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-logged-out',
      'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-git-lab',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--single': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--single',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Single',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-approving': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-approving',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Multiple, Approving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-unassigning': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-unassigning',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Multiple, Unassigning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-logged-out': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-logged-out',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Multiple, Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-git-lab': {
    id: 'webapp-screens-pullrequest-checklist-checklistpendingreviews--multiple-git-lab',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistPendingReviews',
    name: 'Multiple, GitLab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistpendingreviews',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistspeccolumn': {
    name: 'ChecklistSpecColumn',
    id: 'webapp-screens-pullrequest-checklist-checklistspeccolumn',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistspeccolumn--loading-spec',
      'webapp-screens-pullrequest-checklist-checklistspeccolumn--default-spec',
      'webapp-screens-pullrequest-checklist-checklistspeccolumn--low-data-spec',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistspeccolumn--loading-spec': {
    id: 'webapp-screens-pullrequest-checklist-checklistspeccolumn--loading-spec',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistSpecColumn',
    name: 'Loading Spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistspeccolumn',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistspeccolumn--default-spec': {
    id: 'webapp-screens-pullrequest-checklist-checklistspeccolumn--default-spec',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistSpecColumn',
    name: 'Default Spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistspeccolumn',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistspeccolumn--low-data-spec': {
    id: 'webapp-screens-pullrequest-checklist-checklistspeccolumn--low-data-spec',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistSpecColumn',
    name: 'Low Data Spec',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistspeccolumn',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges': {
    name: 'ChecklistVisualChanges',
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    parent: 'webapp-screens-pullrequest-checklist',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-checklist-checklistvisualchanges--single',
      'webapp-screens-pullrequest-checklist-checklistvisualchanges--single-tall-image',
      'webapp-screens-pullrequest-checklist-checklistvisualchanges--multiple',
      'webapp-screens-pullrequest-checklist-checklistvisualchanges--approving',
      'webapp-screens-pullrequest-checklist-checklistvisualchanges--logged-out',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges--single': {
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges--single',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistVisualChanges',
    name: 'Single',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges--single-tall-image': {
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges--single-tall-image',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistVisualChanges',
    name: 'Single, Tall Image',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges--multiple': {
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges--multiple',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistVisualChanges',
    name: 'Multiple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges--approving': {
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges--approving',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistVisualChanges',
    name: 'Approving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-checklist-checklistvisualchanges--logged-out': {
    id: 'webapp-screens-pullrequest-checklist-checklistvisualchanges--logged-out',
    title: 'Webapp screens/PullRequest/Checklist/ChecklistVisualChanges',
    name: 'Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-checklist-checklistvisualchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features': {
    name: 'Features',
    id: 'webapp-screens-pullrequest-features',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-features-uireviewfeature',
      'webapp-screens-pullrequest-features-uitestsfeature',
    ],
    type: 'group',
  },
  'webapp-screens-pullrequest-features-uireviewfeature': {
    name: 'UIReviewFeature',
    id: 'webapp-screens-pullrequest-features-uireviewfeature',
    parent: 'webapp-screens-pullrequest-features',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-features-uireviewfeature--logged-in',
      'webapp-screens-pullrequest-features-uireviewfeature--logged-out',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-features-uireviewfeature--logged-in': {
    id: 'webapp-screens-pullrequest-features-uireviewfeature--logged-in',
    title: 'Webapp screens/PullRequest/Features/UIReviewFeature',
    name: 'Logged In',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uireviewfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uireviewfeature--logged-out': {
    id: 'webapp-screens-pullrequest-features-uireviewfeature--logged-out',
    title: 'Webapp screens/PullRequest/Features/UIReviewFeature',
    name: 'Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uireviewfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature': {
    name: 'UITestsFeature',
    id: 'webapp-screens-pullrequest-features-uitestsfeature',
    parent: 'webapp-screens-pullrequest-features',
    depth: 3,
    children: [
      'webapp-screens-pullrequest-features-uitestsfeature--passed',
      'webapp-screens-pullrequest-features-uitestsfeature--in-progress',
      'webapp-screens-pullrequest-features-uitestsfeature--accepted',
      'webapp-screens-pullrequest-features-uitestsfeature--pending',
      'webapp-screens-pullrequest-features-uitestsfeature--denied',
      'webapp-screens-pullrequest-features-uitestsfeature--failed',
      'webapp-screens-pullrequest-features-uitestsfeature--errored',
      'webapp-screens-pullrequest-features-uitestsfeature--timed-out',
      'webapp-screens-pullrequest-features-uitestsfeature--paused',
      'webapp-screens-pullrequest-features-uitestsfeature--paused-payment-required',
      'webapp-screens-pullrequest-features-uitestsfeature--paused-organization',
      'webapp-screens-pullrequest-features-uitestsfeature--paused-organization-no-plan',
      'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-disabled-for-build-enabled-on-app',
      'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-paused-for-build-enabled-on-app',
      'webapp-screens-pullrequest-features-uitestsfeature--disabled',
      'webapp-screens-pullrequest-features-uitestsfeature--disabled-read-only',
      'webapp-screens-pullrequest-features-uitestsfeature--disabled-low-spec-count',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-features-uitestsfeature--passed': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--passed',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--in-progress': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--in-progress',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--accepted': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--accepted',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--pending': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--pending',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--denied': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--denied',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--failed': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--failed',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--errored': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--errored',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--timed-out': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--timed-out',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Timed Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--paused': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--paused',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--paused-payment-required': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--paused-payment-required',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Paused, Payment Required',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--paused-organization': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--paused-organization',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Paused, Organization',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--paused-organization-no-plan': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--paused-organization-no-plan',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Paused, Organization, No Plan',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-disabled-for-build-enabled-on-app':
    {
      id: 'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-disabled-for-build-enabled-on-app',
      title: 'Webapp screens/PullRequest/Features/UITestsFeature',
      name: 'UI Tests Disabled For Build, Enabled On App',
      importPath: './path.js',
      args: {},
      argTypes: {},
      initialArgs: {},
      depth: 4,
      parent: 'webapp-screens-pullrequest-features-uitestsfeature',
      type: 'story',
      prepared: true,
    },
  'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-paused-for-build-enabled-on-app': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--ui-tests-paused-for-build-enabled-on-app',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'UI Tests Paused For Build, Enabled On App',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--disabled': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--disabled',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--disabled-read-only': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--disabled-read-only',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Disabled, Read Only',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-features-uitestsfeature--disabled-low-spec-count': {
    id: 'webapp-screens-pullrequest-features-uitestsfeature--disabled-low-spec-count',
    title: 'Webapp screens/PullRequest/Features/UITestsFeature',
    name: 'Disabled, Low Spec Count',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-pullrequest-features-uitestsfeature',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison': {
    name: 'NoComparison',
    id: 'webapp-screens-pullrequest-nocomparison',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-nocomparison--no-head-build',
      'webapp-screens-pullrequest-nocomparison--no-merge-base-build',
      'webapp-screens-pullrequest-nocomparison--head-build-in-progress',
      'webapp-screens-pullrequest-nocomparison--patch-build-in-progress',
      'webapp-screens-pullrequest-nocomparison--publish-only-head-build',
      'webapp-screens-pullrequest-nocomparison--publish-only-merge-base',
      'webapp-screens-pullrequest-nocomparison--head-build-errored',
      'webapp-screens-pullrequest-nocomparison--patch-build-errored',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-nocomparison--no-head-build': {
    id: 'webapp-screens-pullrequest-nocomparison--no-head-build',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'No Head Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--no-merge-base-build': {
    id: 'webapp-screens-pullrequest-nocomparison--no-merge-base-build',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'No Merge Base Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--head-build-in-progress': {
    id: 'webapp-screens-pullrequest-nocomparison--head-build-in-progress',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Head Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--patch-build-in-progress': {
    id: 'webapp-screens-pullrequest-nocomparison--patch-build-in-progress',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Patch Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--publish-only-head-build': {
    id: 'webapp-screens-pullrequest-nocomparison--publish-only-head-build',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Publish Only Head Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--publish-only-merge-base': {
    id: 'webapp-screens-pullrequest-nocomparison--publish-only-merge-base',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Publish Only Merge Base',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--head-build-errored': {
    id: 'webapp-screens-pullrequest-nocomparison--head-build-errored',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Head Build Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-nocomparison--patch-build-errored': {
    id: 'webapp-screens-pullrequest-nocomparison--patch-build-errored',
    title: 'Webapp screens/PullRequest/NoComparison',
    name: 'Patch Build Errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-nocomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecomments': {
    name: 'PullRequestChangeComments',
    id: 'webapp-screens-pullrequest-pullrequestchangecomments',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestchangecomments--no-thread',
      'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-new-story',
      'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-removed-story',
      'webapp-screens-pullrequest-pullrequestchangecomments--active-thread',
      'webapp-screens-pullrequest-pullrequestchangecomments--resolved-thread',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestchangecomments--no-thread': {
    id: 'webapp-screens-pullrequest-pullrequestchangecomments--no-thread',
    title: 'Webapp screens/PullRequest/PullRequestChangeComments',
    name: 'no thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-new-story': {
    id: 'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-new-story',
    title: 'Webapp screens/PullRequest/PullRequestChangeComments',
    name: 'no thread, new story',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-removed-story': {
    id: 'webapp-screens-pullrequest-pullrequestchangecomments--no-thread-removed-story',
    title: 'Webapp screens/PullRequest/PullRequestChangeComments',
    name: 'no thread, removed story',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecomments--active-thread': {
    id: 'webapp-screens-pullrequest-pullrequestchangecomments--active-thread',
    title: 'Webapp screens/PullRequest/PullRequestChangeComments',
    name: 'active thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecomments--resolved-thread': {
    id: 'webapp-screens-pullrequest-pullrequestchangecomments--resolved-thread',
    title: 'Webapp screens/PullRequest/PullRequestChangeComments',
    name: 'resolved thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecommentthread': {
    name: 'PullRequestChangeCommentThread',
    id: 'webapp-screens-pullrequest-pullrequestchangecommentthread',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestchangecommentthread--no-user',
      'webapp-screens-pullrequest-pullrequestchangecommentthread--w-user',
      'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user',
      'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user-collapsed',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestchangecommentthread--no-user': {
    id: 'webapp-screens-pullrequest-pullrequestchangecommentthread--no-user',
    title: 'Webapp screens/PullRequest/PullRequestChangeCommentThread',
    name: 'no user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecommentthread--w-user': {
    id: 'webapp-screens-pullrequest-pullrequestchangecommentthread--w-user',
    title: 'Webapp screens/PullRequest/PullRequestChangeCommentThread',
    name: 'w/ user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user': {
    id: 'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user',
    title: 'Webapp screens/PullRequest/PullRequestChangeCommentThread',
    name: 'pure, w/ user',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user-collapsed': {
    id: 'webapp-screens-pullrequest-pullrequestchangecommentthread--pure-w-user-collapsed',
    title: 'Webapp screens/PullRequest/PullRequestChangeCommentThread',
    name: 'pure, w/ user, collapsed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangecommentthread',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem': {
    name: 'PullRequestChangeItem',
    id: 'webapp-screens-pullrequest-pullrequestchangeitem',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestchangeitem--loading',
      'webapp-screens-pullrequest-pullrequestchangeitem--added',
      'webapp-screens-pullrequest-pullrequestchangeitem--added-logged-out',
      'webapp-screens-pullrequest-pullrequestchangeitem--added-w-active-comment-thread',
      'webapp-screens-pullrequest-pullrequestchangeitem--removed',
      'webapp-screens-pullrequest-pullrequestchangeitem--visually-different',
      'webapp-screens-pullrequest-pullrequestchangeitem--visually-different-after-upgrade',
      'webapp-screens-pullrequest-pullrequestchangeitem--scaled',
      'webapp-screens-pullrequest-pullrequestchangeitem--size-changed',
      'webapp-screens-pullrequest-pullrequestchangeitem--errored',
      'webapp-screens-pullrequest-pullrequestchangeitem--fixed',
      'webapp-screens-pullrequest-pullrequestchangeitem--no-diff',
      'webapp-screens-pullrequest-pullrequestchangeitem--diff',
      'webapp-screens-pullrequest-pullrequestchangeitem--diff-strobe',
      'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus',
      'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus-strobe',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--loading': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--loading',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--added': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--added',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'added',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--added-logged-out': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--added-logged-out',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'added, logged out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--added-w-active-comment-thread': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--added-w-active-comment-thread',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'added, w/ active comment thread',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--removed': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--removed',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'removed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--visually-different': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--visually-different',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'visually different',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--visually-different-after-upgrade': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--visually-different-after-upgrade',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'visually different after upgrade',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--scaled': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--scaled',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'scaled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--size-changed': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--size-changed',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'size changed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--errored': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--errored',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'errored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--fixed': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--fixed',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'fixed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--no-diff': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--no-diff',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'no diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--diff': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--diff',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'diff',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--diff-strobe': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--diff-strobe',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'diff strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'diff focus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus-strobe': {
    id: 'webapp-screens-pullrequest-pullrequestchangeitem--diff-focus-strobe',
    title: 'Webapp screens/PullRequest/PullRequestChangeItem',
    name: 'diff focus+strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchangeitem',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges': {
    name: 'PullRequestChanges',
    id: 'webapp-screens-pullrequest-pullrequestchanges',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestchanges--default',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled-logged-out',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused-logged-out',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked',
      'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked-logged-out',
      'webapp-screens-pullrequest-pullrequestchanges--loading',
      'webapp-screens-pullrequest-pullrequestchanges--build-in-progress-80-complete',
      'webapp-screens-pullrequest-pullrequestchanges--comparison-in-progress-20-complete',
      'webapp-screens-pullrequest-pullrequestchanges--empty',
      'webapp-screens-pullrequest-pullrequestchanges--unsupported',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestchanges--default': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--default',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled-logged-out': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-disabled-logged-out',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Disabled Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused-logged-out': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-paused-logged-out',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Paused Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Blocked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked-logged-out': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--ui-review-blocked-logged-out',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'UI Review Blocked Logged Out',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--loading': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--loading',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--build-in-progress-80-complete': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--build-in-progress-80-complete',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Build In Progress (80% complete)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--comparison-in-progress-20-complete': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--comparison-in-progress-20-complete',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Comparison In Progress (20% complete)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--empty': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--empty',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchanges--unsupported': {
    id: 'webapp-screens-pullrequest-pullrequestchanges--unsupported',
    title: 'Webapp screens/PullRequest/PullRequestChanges',
    name: 'Unsupported',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchanges',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip': {
    name: 'PullRequestCheckTooltip',
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestchecktooltip--passing',
      'webapp-screens-pullrequest-pullrequestchecktooltip--passing-ui-review-disabled',
      'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes',
      'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes-in-progress',
      'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build',
      'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-resumed',
      'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-in-progress',
      'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-error',
      'webapp-screens-pullrequest-pullrequestchecktooltip--pending-incomplete-setup',
      'webapp-screens-pullrequest-pullrequestchecktooltip--awaiting-activity',
      'webapp-screens-pullrequest-pullrequestchecktooltip--pending-visual-changes',
      'webapp-screens-pullrequest-pullrequestchecktooltip--pending-reviews',
      'webapp-screens-pullrequest-pullrequestchecktooltip--active-comment-threads',
      'webapp-screens-pullrequest-pullrequestchecktooltip--errored-diffs',
      'webapp-screens-pullrequest-pullrequestchecktooltip--all-tests',
      'webapp-screens-pullrequest-pullrequestchecktooltip--build-error',
      'webapp-screens-pullrequest-pullrequestchecktooltip--git-lab',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--passing': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--passing',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Passing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--passing-ui-review-disabled': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--passing-ui-review-disabled',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Passing, UI Review Disabled',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Passing, No Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes-in-progress': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--passing-no-changes-in-progress',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Passing, No Changes, In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Representative Only Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-resumed': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-resumed',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Representative Only Build, Resumed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-in-progress': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-in-progress',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Representative Only Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-error': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--representative-only-build-error',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Representative Only Build w/ Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--pending-incomplete-setup': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--pending-incomplete-setup',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Pending, Incomplete Setup',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--awaiting-activity': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--awaiting-activity',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Awaiting activity',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--pending-visual-changes': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--pending-visual-changes',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Pending, Visual Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--pending-reviews': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--pending-reviews',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Pending Reviews',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--active-comment-threads': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--active-comment-threads',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Active Comment Threads',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--errored-diffs': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--errored-diffs',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Errored Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--all-tests': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--all-tests',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'All Tests',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--build-error': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--build-error',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Build Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestchecktooltip--git-lab': {
    id: 'webapp-screens-pullrequest-pullrequestchecktooltip--git-lab',
    title: 'Webapp screens/PullRequest/PullRequestCheckTooltip',
    name: 'Git Lab',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestchecktooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents': {
    name: 'PullRequestComponents',
    id: 'webapp-screens-pullrequest-pullrequestcomponents',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestcomponents--loading',
      'webapp-screens-pullrequest-pullrequestcomponents--simple',
      'webapp-screens-pullrequest-pullrequestcomponents--passed',
      'webapp-screens-pullrequest-pullrequestcomponents--failed',
      'webapp-screens-pullrequest-pullrequestcomponents--in-progress',
      'webapp-screens-pullrequest-pullrequestcomponents--empty',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestcomponents--loading': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--loading',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents--simple': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--simple',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'simple',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents--passed': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--passed',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents--failed': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--failed',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents--in-progress': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--in-progress',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestcomponents--empty': {
    id: 'webapp-screens-pullrequest-pullrequestcomponents--empty',
    title: 'Webapp screens/PullRequest/PullRequestComponents',
    name: 'empty',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestcomponents',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestexplainer': {
    name: 'PullRequestExplainer',
    id: 'webapp-screens-pullrequest-pullrequestexplainer',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: ['webapp-screens-pullrequest-pullrequestexplainer--default'],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestexplainer--default': {
    id: 'webapp-screens-pullrequest-pullrequestexplainer--default',
    title: 'Webapp screens/PullRequest/PullRequestExplainer',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestexplainer',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader': {
    name: 'PullRequestHeader',
    id: 'webapp-screens-pullrequest-pullrequestheader',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestheader--loading',
      'webapp-screens-pullrequest-pullrequestheader--open-unbuilt',
      'webapp-screens-pullrequest-pullrequestheader--open-building',
      'webapp-screens-pullrequest-pullrequestheader--merged-passed',
      'webapp-screens-pullrequest-pullrequestheader--open-pending',
      'webapp-screens-pullrequest-pullrequestheader--errored-closed',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestheader--loading': {
    id: 'webapp-screens-pullrequest-pullrequestheader--loading',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader--open-unbuilt': {
    id: 'webapp-screens-pullrequest-pullrequestheader--open-unbuilt',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Open, unbuilt',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader--open-building': {
    id: 'webapp-screens-pullrequest-pullrequestheader--open-building',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Open, building',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader--merged-passed': {
    id: 'webapp-screens-pullrequest-pullrequestheader--merged-passed',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Merged, passed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader--open-pending': {
    id: 'webapp-screens-pullrequest-pullrequestheader--open-pending',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Open, pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestheader--errored-closed': {
    id: 'webapp-screens-pullrequest-pullrequestheader--errored-closed',
    title: 'Webapp screens/PullRequest/PullRequestHeader',
    name: 'Errored, closed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestparticipants': {
    name: 'PullRequestParticipants',
    id: 'webapp-screens-pullrequest-pullrequestparticipants',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestparticipants--loading',
      'webapp-screens-pullrequest-pullrequestparticipants--default',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestparticipants--loading': {
    id: 'webapp-screens-pullrequest-pullrequestparticipants--loading',
    title: 'Webapp screens/PullRequest/PullRequestParticipants',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestparticipants',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestparticipants--default': {
    id: 'webapp-screens-pullrequest-pullrequestparticipants--default',
    title: 'Webapp screens/PullRequest/PullRequestParticipants',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestparticipants',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers': {
    name: 'PullRequestReviewers',
    id: 'webapp-screens-pullrequest-pullrequestreviewers',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestreviewers--loading',
      'webapp-screens-pullrequest-pullrequestreviewers--stateful',
      'webapp-screens-pullrequest-pullrequestreviewers--unreviewed',
      'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-limited',
      'webapp-screens-pullrequest-pullrequestreviewers--assigning',
      'webapp-screens-pullrequest-pullrequestreviewers--assigned-tooltip',
      'webapp-screens-pullrequest-pullrequestreviewers--assigned',
      'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-assigned',
      'webapp-screens-pullrequest-pullrequestreviewers--paused',
      'webapp-screens-pullrequest-pullrequestreviewers--approved',
      'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-approved',
      'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-anonymous',
      'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-unreviewed-anonymous',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestreviewers--loading': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--loading',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--stateful': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--stateful',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Stateful',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--unreviewed': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--unreviewed',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-limited': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-limited',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Unreviewed Limited',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--assigning': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--assigning',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Assigning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--assigned-tooltip': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--assigned-tooltip',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Assigned PR, open tooltip, selecting reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--assigned': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--assigned',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Assigned',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-assigned': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-assigned',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'UI Review Disabled, Assigned',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--paused': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--paused',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Paused',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--approved': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--approved',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Approved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-approved': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-approved',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'UI Review Disabled, Approved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-anonymous': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--unreviewed-anonymous',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'Unreviewed, anonymous',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-unreviewed-anonymous': {
    id: 'webapp-screens-pullrequest-pullrequestreviewers--ui-review-disabled-unreviewed-anonymous',
    title: 'Webapp screens/PullRequest/PullRequestReviewers',
    name: 'UI Review Disabled, Unreviewed, anonymous',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen': {
    name: 'PullRequestScreen',
    id: 'webapp-screens-pullrequest-pullrequestscreen',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-pullrequestscreen--loading',
      'webapp-screens-pullrequest-pullrequestscreen--no-builds',
      'webapp-screens-pullrequest-pullrequestscreen--activity',
      'webapp-screens-pullrequest-pullrequestscreen--activity-no-merge-base-build',
      'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-approving',
      'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-unapproving',
      'webapp-screens-pullrequest-pullrequestscreen--explainer',
      'webapp-screens-pullrequest-pullrequestscreen--comments',
      'webapp-screens-pullrequest-pullrequestscreen--components',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes-loading-diffs',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes-build-in-progress',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes-comparison-in-progress',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes-no-changes',
      'webapp-screens-pullrequest-pullrequestscreen--ui-changes-with-errors',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-pullrequestscreen--loading': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--loading',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--no-builds': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--no-builds',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'No Builds',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--activity': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--activity',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Activity',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--activity-no-merge-base-build': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--activity-no-merge-base-build',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Activity No Merge Base Build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-approving': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-approving',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Loading Reviews Approving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-unapproving': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--loading-reviews-unapproving',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Loading Reviews Unapproving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--explainer': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--explainer',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Explainer',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--comments': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--comments',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Comments',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--components': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--components',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'Components',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes-loading-diffs': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes-loading-diffs',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes Loading Diffs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes-build-in-progress': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes-build-in-progress',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes Build In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes-comparison-in-progress': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes-comparison-in-progress',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes Comparison In Progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes-no-changes': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes-no-changes',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes No Changes',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-pullrequestscreen--ui-changes-with-errors': {
    id: 'webapp-screens-pullrequest-pullrequestscreen--ui-changes-with-errors',
    title: 'Webapp screens/PullRequest/PullRequestScreen',
    name: 'UI Changes With Errors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-pullrequestscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton': {
    name: 'ReviewButton',
    id: 'webapp-screens-pullrequest-reviewbutton',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-reviewbutton--unreviewed',
      'webapp-screens-pullrequest-reviewbutton--assigned',
      'webapp-screens-pullrequest-reviewbutton--approving',
      'webapp-screens-pullrequest-reviewbutton--approved',
      'webapp-screens-pullrequest-reviewbutton--retracting',
      'webapp-screens-pullrequest-reviewbutton--actions-story',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-reviewbutton--unreviewed': {
    id: 'webapp-screens-pullrequest-reviewbutton--unreviewed',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton--assigned': {
    id: 'webapp-screens-pullrequest-reviewbutton--assigned',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Assigned',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton--approving': {
    id: 'webapp-screens-pullrequest-reviewbutton--approving',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Approving',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton--approved': {
    id: 'webapp-screens-pullrequest-reviewbutton--approved',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Approved',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton--retracting': {
    id: 'webapp-screens-pullrequest-reviewbutton--retracting',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Retracting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-reviewbutton--actions-story': {
    id: 'webapp-screens-pullrequest-reviewbutton--actions-story',
    title: 'Webapp screens/PullRequest/ReviewButton',
    name: 'Actions',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-reviewbutton',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-selectreviewers': {
    name: 'SelectReviewers',
    id: 'webapp-screens-pullrequest-selectreviewers',
    parent: 'webapp-screens-pullrequest',
    depth: 2,
    children: [
      'webapp-screens-pullrequest-selectreviewers--select-reviewers',
      'webapp-screens-pullrequest-selectreviewers--changing-reviewers',
      'webapp-screens-pullrequest-selectreviewers--many-collaborators-long-name',
      'webapp-screens-pullrequest-selectreviewers--no-collaborators-found',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequest-selectreviewers--select-reviewers': {
    id: 'webapp-screens-pullrequest-selectreviewers--select-reviewers',
    title: 'Webapp screens/PullRequest/SelectReviewers',
    name: 'Select reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-selectreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-selectreviewers--changing-reviewers': {
    id: 'webapp-screens-pullrequest-selectreviewers--changing-reviewers',
    title: 'Webapp screens/PullRequest/SelectReviewers',
    name: 'Changing reviewers',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-selectreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-selectreviewers--many-collaborators-long-name': {
    id: 'webapp-screens-pullrequest-selectreviewers--many-collaborators-long-name',
    title: 'Webapp screens/PullRequest/SelectReviewers',
    name: 'Many collaborators, long name',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-selectreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequest-selectreviewers--no-collaborators-found': {
    id: 'webapp-screens-pullrequest-selectreviewers--no-collaborators-found',
    title: 'Webapp screens/PullRequest/SelectReviewers',
    name: 'No collaborators found',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-pullrequest-selectreviewers',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequestsscreen': {
    name: 'PullRequestsScreen',
    id: 'webapp-screens-pullrequestsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-pullrequestsscreen--loading',
      'webapp-screens-pullrequestsscreen--git-hub-p-rs',
      'webapp-screens-pullrequestsscreen--git-lab-m-rs',
      'webapp-screens-pullrequestsscreen--explainer',
    ],
    type: 'component',
  },
  'webapp-screens-pullrequestsscreen--loading': {
    id: 'webapp-screens-pullrequestsscreen--loading',
    title: 'Webapp screens/PullRequestsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-pullrequestsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequestsscreen--git-hub-p-rs': {
    id: 'webapp-screens-pullrequestsscreen--git-hub-p-rs',
    title: 'Webapp screens/PullRequestsScreen',
    name: 'GitHub PRs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-pullrequestsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequestsscreen--git-lab-m-rs': {
    id: 'webapp-screens-pullrequestsscreen--git-lab-m-rs',
    title: 'Webapp screens/PullRequestsScreen',
    name: 'GitLab MRs',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-pullrequestsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-pullrequestsscreen--explainer': {
    id: 'webapp-screens-pullrequestsscreen--explainer',
    title: 'Webapp screens/PullRequestsScreen',
    name: 'Explainer',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-pullrequestsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-settingsscreen': {
    name: 'SettingsScreen',
    id: 'webapp-screens-settingsscreen',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-settingsscreen--loading',
      'webapp-screens-settingsscreen--default',
      'webapp-screens-settingsscreen--default-refreshing-membership',
      'webapp-screens-settingsscreen--unlinked',
    ],
    type: 'component',
  },
  'webapp-screens-settingsscreen--loading': {
    id: 'webapp-screens-settingsscreen--loading',
    title: 'Webapp screens/SettingsScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-settingsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-settingsscreen--default': {
    id: 'webapp-screens-settingsscreen--default',
    title: 'Webapp screens/SettingsScreen',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-settingsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-settingsscreen--default-refreshing-membership': {
    id: 'webapp-screens-settingsscreen--default-refreshing-membership',
    title: 'Webapp screens/SettingsScreen',
    name: 'default, refreshing membership',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-settingsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-settingsscreen--unlinked': {
    id: 'webapp-screens-settingsscreen--unlinked',
    title: 'Webapp screens/SettingsScreen',
    name: 'unlinked',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 2,
    parent: 'webapp-screens-settingsscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup': {
    name: 'Setup',
    id: 'webapp-screens-setup',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-setup-catchchanges',
      'webapp-screens-setup-publishstorybook',
      'webapp-screens-setup-verifychanges',
      'webapp-screens-setup-wrapup',
    ],
    type: 'group',
  },
  'webapp-screens-setup-catchchanges': {
    name: 'CatchChanges',
    id: 'webapp-screens-setup-catchchanges',
    parent: 'webapp-screens-setup',
    depth: 2,
    children: [
      'webapp-screens-setup-catchchanges-catchchangesscreen',
      'webapp-screens-setup-catchchanges-changesspottedscreen',
      'webapp-screens-setup-catchchanges-changessummary',
      'webapp-screens-setup-catchchanges-instructions',
    ],
    type: 'group',
  },
  'webapp-screens-setup-catchchanges-catchchangesscreen': {
    name: 'CatchChangesScreen',
    id: 'webapp-screens-setup-catchchanges-catchchangesscreen',
    parent: 'webapp-screens-setup-catchchanges',
    depth: 3,
    children: [
      'webapp-screens-setup-catchchanges-catchchangesscreen--loading',
      'webapp-screens-setup-catchchanges-catchchangesscreen--default',
      'webapp-screens-setup-catchchanges-catchchangesscreen--default-onboarding',
      'webapp-screens-setup-catchchanges-catchchangesscreen--no-changes-warning',
    ],
    type: 'component',
  },
  'webapp-screens-setup-catchchanges-catchchangesscreen--loading': {
    id: 'webapp-screens-setup-catchchanges-catchchangesscreen--loading',
    title: 'Webapp screens/Setup/CatchChanges/CatchChangesScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-catchchangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-catchchangesscreen--default': {
    id: 'webapp-screens-setup-catchchanges-catchchangesscreen--default',
    title: 'Webapp screens/Setup/CatchChanges/CatchChangesScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-catchchangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-catchchangesscreen--default-onboarding': {
    id: 'webapp-screens-setup-catchchanges-catchchangesscreen--default-onboarding',
    title: 'Webapp screens/Setup/CatchChanges/CatchChangesScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-catchchangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-catchchangesscreen--no-changes-warning': {
    id: 'webapp-screens-setup-catchchanges-catchchangesscreen--no-changes-warning',
    title: 'Webapp screens/Setup/CatchChanges/CatchChangesScreen',
    name: 'No Changes Warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-catchchangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-changesspottedscreen': {
    name: 'ChangesSpottedScreen',
    id: 'webapp-screens-setup-catchchanges-changesspottedscreen',
    parent: 'webapp-screens-setup-catchchanges',
    depth: 3,
    children: [
      'webapp-screens-setup-catchchanges-changesspottedscreen--loading',
      'webapp-screens-setup-catchchanges-changesspottedscreen--default',
      'webapp-screens-setup-catchchanges-changesspottedscreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-catchchanges-changesspottedscreen--loading': {
    id: 'webapp-screens-setup-catchchanges-changesspottedscreen--loading',
    title: 'Webapp screens/Setup/CatchChanges/ChangesSpottedScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-changesspottedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-changesspottedscreen--default': {
    id: 'webapp-screens-setup-catchchanges-changesspottedscreen--default',
    title: 'Webapp screens/Setup/CatchChanges/ChangesSpottedScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-changesspottedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-changesspottedscreen--default-onboarding': {
    id: 'webapp-screens-setup-catchchanges-changesspottedscreen--default-onboarding',
    title: 'Webapp screens/Setup/CatchChanges/ChangesSpottedScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-changesspottedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-changessummary': {
    name: 'ChangesSummary',
    id: 'webapp-screens-setup-catchchanges-changessummary',
    parent: 'webapp-screens-setup-catchchanges',
    depth: 3,
    children: [
      'webapp-screens-setup-catchchanges-changessummary--loading',
      'webapp-screens-setup-catchchanges-changessummary--default',
    ],
    type: 'component',
  },
  'webapp-screens-setup-catchchanges-changessummary--loading': {
    id: 'webapp-screens-setup-catchchanges-changessummary--loading',
    title: 'Webapp screens/Setup/CatchChanges/ChangesSummary',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-changessummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-changessummary--default': {
    id: 'webapp-screens-setup-catchchanges-changessummary--default',
    title: 'Webapp screens/Setup/CatchChanges/ChangesSummary',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-changessummary',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-instructions': {
    name: 'Instructions',
    id: 'webapp-screens-setup-catchchanges-instructions',
    parent: 'webapp-screens-setup-catchchanges',
    depth: 3,
    children: [
      'webapp-screens-setup-catchchanges-instructions--loading',
      'webapp-screens-setup-catchchanges-instructions--default',
      'webapp-screens-setup-catchchanges-instructions--no-changes-warning',
    ],
    type: 'component',
  },
  'webapp-screens-setup-catchchanges-instructions--loading': {
    id: 'webapp-screens-setup-catchchanges-instructions--loading',
    title: 'Webapp screens/Setup/CatchChanges/Instructions',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-instructions--default': {
    id: 'webapp-screens-setup-catchchanges-instructions--default',
    title: 'Webapp screens/Setup/CatchChanges/Instructions',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-catchchanges-instructions--no-changes-warning': {
    id: 'webapp-screens-setup-catchchanges-instructions--no-changes-warning',
    title: 'Webapp screens/Setup/CatchChanges/Instructions',
    name: 'No Changes Warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-catchchanges-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook': {
    name: 'PublishStorybook',
    id: 'webapp-screens-setup-publishstorybook',
    parent: 'webapp-screens-setup',
    depth: 2,
    children: [
      'webapp-screens-setup-publishstorybook-builderrorlist',
      'webapp-screens-setup-publishstorybook-confirmationsuccess',
      'webapp-screens-setup-publishstorybook-instructions',
      'webapp-screens-setup-publishstorybook-publishfailedscreen',
      'webapp-screens-setup-publishstorybook-publishstorybookscreen',
      'webapp-screens-setup-publishstorybook-publishsuccessscreen',
    ],
    type: 'group',
  },
  'webapp-screens-setup-publishstorybook-builderrorlist': {
    name: 'BuildErrorList',
    id: 'webapp-screens-setup-publishstorybook-builderrorlist',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-builderrorlist--loading',
      'webapp-screens-setup-publishstorybook-builderrorlist--default',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-builderrorlist--loading': {
    id: 'webapp-screens-setup-publishstorybook-builderrorlist--loading',
    title: 'Webapp screens/Setup/PublishStorybook/BuildErrorList',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-builderrorlist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-builderrorlist--default': {
    id: 'webapp-screens-setup-publishstorybook-builderrorlist--default',
    title: 'Webapp screens/Setup/PublishStorybook/BuildErrorList',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-builderrorlist',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess': {
    name: 'ConfirmationSuccess',
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-confirmationsuccess--loading',
      'webapp-screens-setup-publishstorybook-confirmationsuccess--default',
      'webapp-screens-setup-publishstorybook-confirmationsuccess--scroll',
      'webapp-screens-setup-publishstorybook-confirmationsuccess--small',
      'webapp-screens-setup-publishstorybook-confirmationsuccess--small-scroll',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess--loading': {
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess--loading',
    title: 'Webapp screens/Setup/PublishStorybook/ConfirmationSuccess',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess--default': {
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess--default',
    title: 'Webapp screens/Setup/PublishStorybook/ConfirmationSuccess',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess--scroll': {
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess--scroll',
    title: 'Webapp screens/Setup/PublishStorybook/ConfirmationSuccess',
    name: 'Scroll',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess--small': {
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess--small',
    title: 'Webapp screens/Setup/PublishStorybook/ConfirmationSuccess',
    name: 'Small',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-confirmationsuccess--small-scroll': {
    id: 'webapp-screens-setup-publishstorybook-confirmationsuccess--small-scroll',
    title: 'Webapp screens/Setup/PublishStorybook/ConfirmationSuccess',
    name: 'Small Scroll',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-confirmationsuccess',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-instructions': {
    name: 'Instructions',
    id: 'webapp-screens-setup-publishstorybook-instructions',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-instructions--loading',
      'webapp-screens-setup-publishstorybook-instructions--default',
      'webapp-screens-setup-publishstorybook-instructions--retry',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-instructions--loading': {
    id: 'webapp-screens-setup-publishstorybook-instructions--loading',
    title: 'Webapp screens/Setup/PublishStorybook/Instructions',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-instructions--default': {
    id: 'webapp-screens-setup-publishstorybook-instructions--default',
    title: 'Webapp screens/Setup/PublishStorybook/Instructions',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-instructions--retry': {
    id: 'webapp-screens-setup-publishstorybook-instructions--retry',
    title: 'Webapp screens/Setup/PublishStorybook/Instructions',
    name: 'Retry',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-instructions',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishfailedscreen': {
    name: 'PublishFailedScreen',
    id: 'webapp-screens-setup-publishstorybook-publishfailedscreen',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-publishfailedscreen--loading',
      'webapp-screens-setup-publishstorybook-publishfailedscreen--default',
      'webapp-screens-setup-publishstorybook-publishfailedscreen--default-onboarding',
      'webapp-screens-setup-publishstorybook-publishfailedscreen--infrastructure-error',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-publishfailedscreen--loading': {
    id: 'webapp-screens-setup-publishstorybook-publishfailedscreen--loading',
    title: 'Webapp screens/Setup/PublishStorybook/PublishFailedScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishfailedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishfailedscreen--default': {
    id: 'webapp-screens-setup-publishstorybook-publishfailedscreen--default',
    title: 'Webapp screens/Setup/PublishStorybook/PublishFailedScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishfailedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishfailedscreen--default-onboarding': {
    id: 'webapp-screens-setup-publishstorybook-publishfailedscreen--default-onboarding',
    title: 'Webapp screens/Setup/PublishStorybook/PublishFailedScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishfailedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishfailedscreen--infrastructure-error': {
    id: 'webapp-screens-setup-publishstorybook-publishfailedscreen--infrastructure-error',
    title: 'Webapp screens/Setup/PublishStorybook/PublishFailedScreen',
    name: 'Infrastructure Error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishfailedscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishstorybookscreen': {
    name: 'PublishStorybookScreen',
    id: 'webapp-screens-setup-publishstorybook-publishstorybookscreen',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-publishstorybookscreen--loading',
      'webapp-screens-setup-publishstorybook-publishstorybookscreen--default',
      'webapp-screens-setup-publishstorybook-publishstorybookscreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-publishstorybookscreen--loading': {
    id: 'webapp-screens-setup-publishstorybook-publishstorybookscreen--loading',
    title: 'Webapp screens/Setup/PublishStorybook/PublishStorybookScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishstorybookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishstorybookscreen--default': {
    id: 'webapp-screens-setup-publishstorybook-publishstorybookscreen--default',
    title: 'Webapp screens/Setup/PublishStorybook/PublishStorybookScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishstorybookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishstorybookscreen--default-onboarding': {
    id: 'webapp-screens-setup-publishstorybook-publishstorybookscreen--default-onboarding',
    title: 'Webapp screens/Setup/PublishStorybook/PublishStorybookScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishstorybookscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishsuccessscreen': {
    name: 'PublishSuccessScreen',
    id: 'webapp-screens-setup-publishstorybook-publishsuccessscreen',
    parent: 'webapp-screens-setup-publishstorybook',
    depth: 3,
    children: [
      'webapp-screens-setup-publishstorybook-publishsuccessscreen--loading',
      'webapp-screens-setup-publishstorybook-publishsuccessscreen--default',
      'webapp-screens-setup-publishstorybook-publishsuccessscreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-publishstorybook-publishsuccessscreen--loading': {
    id: 'webapp-screens-setup-publishstorybook-publishsuccessscreen--loading',
    title: 'Webapp screens/Setup/PublishStorybook/PublishSuccessScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishsuccessscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishsuccessscreen--default': {
    id: 'webapp-screens-setup-publishstorybook-publishsuccessscreen--default',
    title: 'Webapp screens/Setup/PublishStorybook/PublishSuccessScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishsuccessscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-publishstorybook-publishsuccessscreen--default-onboarding': {
    id: 'webapp-screens-setup-publishstorybook-publishsuccessscreen--default-onboarding',
    title: 'Webapp screens/Setup/PublishStorybook/PublishSuccessScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-publishstorybook-publishsuccessscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges': {
    name: 'VerifyChanges',
    id: 'webapp-screens-setup-verifychanges',
    parent: 'webapp-screens-setup',
    depth: 2,
    children: [
      'webapp-screens-setup-verifychanges-comparison',
      'webapp-screens-setup-verifychanges-comparisoncomments',
      'webapp-screens-setup-verifychanges-feedbackscreen',
      'webapp-screens-setup-verifychanges-verifychangesscreen',
    ],
    type: 'group',
  },
  'webapp-screens-setup-verifychanges-comparison': {
    name: 'Comparison',
    id: 'webapp-screens-setup-verifychanges-comparison',
    parent: 'webapp-screens-setup-verifychanges',
    depth: 3,
    children: [
      'webapp-screens-setup-verifychanges-comparison--loading',
      'webapp-screens-setup-verifychanges-comparison--default',
    ],
    type: 'component',
  },
  'webapp-screens-setup-verifychanges-comparison--loading': {
    id: 'webapp-screens-setup-verifychanges-comparison--loading',
    title: 'Webapp screens/Setup/VerifyChanges/Comparison',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-comparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-comparison--default': {
    id: 'webapp-screens-setup-verifychanges-comparison--default',
    title: 'Webapp screens/Setup/VerifyChanges/Comparison',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-comparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-comparisoncomments': {
    name: 'ComparisonComments',
    id: 'webapp-screens-setup-verifychanges-comparisoncomments',
    parent: 'webapp-screens-setup-verifychanges',
    depth: 3,
    children: [
      'webapp-screens-setup-verifychanges-comparisoncomments--loading',
      'webapp-screens-setup-verifychanges-comparisoncomments--default',
    ],
    type: 'component',
  },
  'webapp-screens-setup-verifychanges-comparisoncomments--loading': {
    id: 'webapp-screens-setup-verifychanges-comparisoncomments--loading',
    title: 'Webapp screens/Setup/VerifyChanges/ComparisonComments',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-comparisoncomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-comparisoncomments--default': {
    id: 'webapp-screens-setup-verifychanges-comparisoncomments--default',
    title: 'Webapp screens/Setup/VerifyChanges/ComparisonComments',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-comparisoncomments',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-feedbackscreen': {
    name: 'FeedbackScreen',
    id: 'webapp-screens-setup-verifychanges-feedbackscreen',
    parent: 'webapp-screens-setup-verifychanges',
    depth: 3,
    children: [
      'webapp-screens-setup-verifychanges-feedbackscreen--loading',
      'webapp-screens-setup-verifychanges-feedbackscreen--default',
      'webapp-screens-setup-verifychanges-feedbackscreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-verifychanges-feedbackscreen--loading': {
    id: 'webapp-screens-setup-verifychanges-feedbackscreen--loading',
    title: 'Webapp screens/Setup/VerifyChanges/FeedbackScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-feedbackscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-feedbackscreen--default': {
    id: 'webapp-screens-setup-verifychanges-feedbackscreen--default',
    title: 'Webapp screens/Setup/VerifyChanges/FeedbackScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-feedbackscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-feedbackscreen--default-onboarding': {
    id: 'webapp-screens-setup-verifychanges-feedbackscreen--default-onboarding',
    title: 'Webapp screens/Setup/VerifyChanges/FeedbackScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-feedbackscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-verifychangesscreen': {
    name: 'VerifyChangesScreen',
    id: 'webapp-screens-setup-verifychanges-verifychangesscreen',
    parent: 'webapp-screens-setup-verifychanges',
    depth: 3,
    children: [
      'webapp-screens-setup-verifychanges-verifychangesscreen--loading',
      'webapp-screens-setup-verifychanges-verifychangesscreen--default',
      'webapp-screens-setup-verifychanges-verifychangesscreen--default-onboarding',
      'webapp-screens-setup-verifychanges-verifychangesscreen--mutating',
    ],
    type: 'component',
  },
  'webapp-screens-setup-verifychanges-verifychangesscreen--loading': {
    id: 'webapp-screens-setup-verifychanges-verifychangesscreen--loading',
    title: 'Webapp screens/Setup/VerifyChanges/VerifyChangesScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-verifychangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-verifychangesscreen--default': {
    id: 'webapp-screens-setup-verifychanges-verifychangesscreen--default',
    title: 'Webapp screens/Setup/VerifyChanges/VerifyChangesScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-verifychangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-verifychangesscreen--default-onboarding': {
    id: 'webapp-screens-setup-verifychanges-verifychangesscreen--default-onboarding',
    title: 'Webapp screens/Setup/VerifyChanges/VerifyChangesScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-verifychangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-verifychanges-verifychangesscreen--mutating': {
    id: 'webapp-screens-setup-verifychanges-verifychangesscreen--mutating',
    title: 'Webapp screens/Setup/VerifyChanges/VerifyChangesScreen',
    name: 'Mutating',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-verifychanges-verifychangesscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup': {
    name: 'WrapUp',
    id: 'webapp-screens-setup-wrapup',
    parent: 'webapp-screens-setup',
    depth: 2,
    children: [
      'webapp-screens-setup-wrapup-mergechecksscreen',
      'webapp-screens-setup-wrapup-setupcompletescreen',
    ],
    type: 'group',
  },
  'webapp-screens-setup-wrapup-mergechecksscreen': {
    name: 'MergeChecksScreen',
    id: 'webapp-screens-setup-wrapup-mergechecksscreen',
    parent: 'webapp-screens-setup-wrapup',
    depth: 3,
    children: [
      'webapp-screens-setup-wrapup-mergechecksscreen--loading',
      'webapp-screens-setup-wrapup-mergechecksscreen--default',
      'webapp-screens-setup-wrapup-mergechecksscreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-wrapup-mergechecksscreen--loading': {
    id: 'webapp-screens-setup-wrapup-mergechecksscreen--loading',
    title: 'Webapp screens/Setup/WrapUp/MergeChecksScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-mergechecksscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup-mergechecksscreen--default': {
    id: 'webapp-screens-setup-wrapup-mergechecksscreen--default',
    title: 'Webapp screens/Setup/WrapUp/MergeChecksScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-mergechecksscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup-mergechecksscreen--default-onboarding': {
    id: 'webapp-screens-setup-wrapup-mergechecksscreen--default-onboarding',
    title: 'Webapp screens/Setup/WrapUp/MergeChecksScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-mergechecksscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup-setupcompletescreen': {
    name: 'SetupCompleteScreen',
    id: 'webapp-screens-setup-wrapup-setupcompletescreen',
    parent: 'webapp-screens-setup-wrapup',
    depth: 3,
    children: [
      'webapp-screens-setup-wrapup-setupcompletescreen--loading',
      'webapp-screens-setup-wrapup-setupcompletescreen--default',
      'webapp-screens-setup-wrapup-setupcompletescreen--default-onboarding',
    ],
    type: 'component',
  },
  'webapp-screens-setup-wrapup-setupcompletescreen--loading': {
    id: 'webapp-screens-setup-wrapup-setupcompletescreen--loading',
    title: 'Webapp screens/Setup/WrapUp/SetupCompleteScreen',
    name: 'Loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-setupcompletescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup-setupcompletescreen--default': {
    id: 'webapp-screens-setup-wrapup-setupcompletescreen--default',
    title: 'Webapp screens/Setup/WrapUp/SetupCompleteScreen',
    name: 'Default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-setupcompletescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-setup-wrapup-setupcompletescreen--default-onboarding': {
    id: 'webapp-screens-setup-wrapup-setupcompletescreen--default-onboarding',
    title: 'Webapp screens/Setup/WrapUp/SetupCompleteScreen',
    name: 'Default Onboarding',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 4,
    parent: 'webapp-screens-setup-wrapup-setupcompletescreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot': {
    name: 'Snapshot',
    id: 'webapp-screens-snapshot',
    parent: 'webapp-screens',
    depth: 1,
    children: [
      'webapp-screens-snapshot-capturewarningtooltip',
      'webapp-screens-snapshot-reviewbuttons',
      'webapp-screens-snapshot-snapshotcomparison',
      'webapp-screens-snapshot-snapshotheader',
      'webapp-screens-snapshot-snapshothtmldiff',
      'webapp-screens-snapshot-snapshotscreen',
    ],
    type: 'group',
  },
  'webapp-screens-snapshot-capturewarningtooltip': {
    name: 'CaptureWarningTooltip',
    id: 'webapp-screens-snapshot-capturewarningtooltip',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: ['webapp-screens-snapshot-capturewarningtooltip--default-story'],
    type: 'component',
  },
  'webapp-screens-snapshot-capturewarningtooltip--default-story': {
    id: 'webapp-screens-snapshot-capturewarningtooltip--default-story',
    title: 'Webapp screens/Snapshot/CaptureWarningTooltip',
    name: 'open',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-capturewarningtooltip',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons': {
    name: 'ReviewButtons',
    id: 'webapp-screens-snapshot-reviewbuttons',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: [
      'webapp-screens-snapshot-reviewbuttons--in-progress',
      'webapp-screens-snapshot-reviewbuttons--failed',
      'webapp-screens-snapshot-reviewbuttons--unreviewed',
      'webapp-screens-snapshot-reviewbuttons--unreviewed-accepting',
      'webapp-screens-snapshot-reviewbuttons--unreviewed-denying',
      'webapp-screens-snapshot-reviewbuttons--accepted',
      'webapp-screens-snapshot-reviewbuttons--accepted-undoing',
      'webapp-screens-snapshot-reviewbuttons--auto-accepted-first-build',
      'webapp-screens-snapshot-reviewbuttons--denied',
      'webapp-screens-snapshot-reviewbuttons--denied-undoing',
      'webapp-screens-snapshot-reviewbuttons--unreviewable-no-descendant',
      'webapp-screens-snapshot-reviewbuttons--unreviewable-with-descendant',
      'webapp-screens-snapshot-reviewbuttons--read-only-logged-in',
      'webapp-screens-snapshot-reviewbuttons--read-only-not-logged-in',
      'webapp-screens-snapshot-reviewbuttons--error',
      'webapp-screens-snapshot-reviewbuttons--error-last',
    ],
    type: 'component',
  },
  'webapp-screens-snapshot-reviewbuttons--in-progress': {
    id: 'webapp-screens-snapshot-reviewbuttons--in-progress',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--failed': {
    id: 'webapp-screens-snapshot-reviewbuttons--failed',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--unreviewed': {
    id: 'webapp-screens-snapshot-reviewbuttons--unreviewed',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'unreviewed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--unreviewed-accepting': {
    id: 'webapp-screens-snapshot-reviewbuttons--unreviewed-accepting',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'unreviewed, accepting',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--unreviewed-denying': {
    id: 'webapp-screens-snapshot-reviewbuttons--unreviewed-denying',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'unreviewed, denying',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--accepted': {
    id: 'webapp-screens-snapshot-reviewbuttons--accepted',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--accepted-undoing': {
    id: 'webapp-screens-snapshot-reviewbuttons--accepted-undoing',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'accepted, undoing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--auto-accepted-first-build': {
    id: 'webapp-screens-snapshot-reviewbuttons--auto-accepted-first-build',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'auto-accepted, first build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--denied': {
    id: 'webapp-screens-snapshot-reviewbuttons--denied',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--denied-undoing': {
    id: 'webapp-screens-snapshot-reviewbuttons--denied-undoing',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'denied, undoing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--unreviewable-no-descendant': {
    id: 'webapp-screens-snapshot-reviewbuttons--unreviewable-no-descendant',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'unreviewable, no descendant',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--unreviewable-with-descendant': {
    id: 'webapp-screens-snapshot-reviewbuttons--unreviewable-with-descendant',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'unreviewable, with descendant',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--read-only-logged-in': {
    id: 'webapp-screens-snapshot-reviewbuttons--read-only-logged-in',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'read only, logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--read-only-not-logged-in': {
    id: 'webapp-screens-snapshot-reviewbuttons--read-only-not-logged-in',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'read only, not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--error': {
    id: 'webapp-screens-snapshot-reviewbuttons--error',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-reviewbuttons--error-last': {
    id: 'webapp-screens-snapshot-reviewbuttons--error-last',
    title: 'Webapp screens/Snapshot/ReviewButtons',
    name: 'error, last',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-reviewbuttons',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison': {
    name: 'SnapshotComparison',
    id: 'webapp-screens-snapshot-snapshotcomparison',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: [
      'webapp-screens-snapshot-snapshotcomparison--loading',
      'webapp-screens-snapshot-snapshotcomparison--2-up',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-strobe',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus-and-strobe',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible',
      'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible-diff-focus-diff-strobe',
      'webapp-screens-snapshot-snapshotcomparison--2-up-diff-version-1',
      'webapp-screens-snapshot-snapshotcomparison--2-up-ignoring',
      'webapp-screens-snapshot-snapshotcomparison--2-up-diff-bigger',
      'webapp-screens-snapshot-snapshotcomparison--1-up',
      'webapp-screens-snapshot-snapshotcomparison--1-up-header-offset',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-strobe',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus-and-strobe',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-invisible',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-strobe',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus-and-strobe',
      'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-invisible',
      'webapp-screens-snapshot-snapshotcomparison--1-up-diff-version-1',
      'webapp-screens-snapshot-snapshotcomparison--1-up-diff-bigger',
      'webapp-screens-snapshot-snapshotcomparison--1-up-ignoring',
      'webapp-screens-snapshot-snapshotcomparison--no-baseline',
      'webapp-screens-snapshot-snapshotcomparison--no-baseline-in-progress',
      'webapp-screens-snapshot-snapshotcomparison--no-baseline-ignoring',
      'webapp-screens-snapshot-snapshotcomparison--failed',
    ],
    type: 'component',
  },
  'webapp-screens-snapshot-snapshotcomparison--loading': {
    id: 'webapp-screens-snapshot-snapshotcomparison--loading',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff visible, diff strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff visible, diff focus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus-and-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-visible-diff-focus-and-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff visible, diff focus and strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff invisible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible-diff-focus-diff-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-pure-diff-invisible-diff-focus-diff-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, pure, diff invisible, diffFocus + diffStrobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-diff-version-1': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-diff-version-1',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, diff version 1',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-ignoring': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-ignoring',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up ignoring',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--2-up-diff-bigger': {
    id: 'webapp-screens-snapshot-snapshotcomparison--2-up-diff-bigger',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '2 up, diff bigger',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-header-offset': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-header-offset',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, header offset',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, diff visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, diff visible, diff strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, diff visible, diff focus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus-and-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-visible-diff-focus-and-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, diff visible, diff focus and strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-invisible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-diff-invisible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, diff invisible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, switching, diff visible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-strobe': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-strobe',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, switching, diff visible, diff strobe',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, switching, diff visible, diff focus',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus-and-strobe':
    {
      id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-visible-diff-focus-and-strobe',
      title: 'Webapp screens/Snapshot/SnapshotComparison',
      name: '1 up, pure, switching, diff visible, diff focus and strobe',
      importPath: './path.js',
      args: {},
      argTypes: {},
      initialArgs: {},
      depth: 3,
      parent: 'webapp-screens-snapshot-snapshotcomparison',
      type: 'story',
      prepared: true,
    },
  'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-invisible': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-pure-switching-diff-invisible',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, pure, switching, diff invisible',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-diff-version-1': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-diff-version-1',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, diff version 1',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-diff-bigger': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-diff-bigger',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up, diff bigger',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--1-up-ignoring': {
    id: 'webapp-screens-snapshot-snapshotcomparison--1-up-ignoring',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: '1 up ignoring',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--no-baseline': {
    id: 'webapp-screens-snapshot-snapshotcomparison--no-baseline',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: 'no baseline',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--no-baseline-in-progress': {
    id: 'webapp-screens-snapshot-snapshotcomparison--no-baseline-in-progress',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: 'no baseline in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--no-baseline-ignoring': {
    id: 'webapp-screens-snapshot-snapshotcomparison--no-baseline-ignoring',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: 'no baseline ignoring',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotcomparison--failed': {
    id: 'webapp-screens-snapshot-snapshotcomparison--failed',
    title: 'Webapp screens/Snapshot/SnapshotComparison',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotcomparison',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader': {
    name: 'SnapshotHeader',
    id: 'webapp-screens-snapshot-snapshotheader',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: [
      'webapp-screens-snapshot-snapshotheader--loading',
      'webapp-screens-snapshot-snapshotheader--pending',
      'webapp-screens-snapshot-snapshotheader--pending-viewport-default',
      'webapp-screens-snapshot-snapshotheader--pending-first',
      'webapp-screens-snapshot-snapshotheader--pending-last',
      'webapp-screens-snapshot-snapshotheader--pending-no-baseline',
      'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors',
      'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors-showing',
      'webapp-screens-snapshot-snapshotheader--accepted',
      'webapp-screens-snapshot-snapshotheader--auto-accepted-first-build',
      'webapp-screens-snapshot-snapshotheader--denied',
      'webapp-screens-snapshot-snapshotheader--unreviewable-with-descendant',
      'webapp-screens-snapshot-snapshotheader--read-only-logged-in',
      'webapp-screens-snapshot-snapshotheader--read-only-not-logged-in',
      'webapp-screens-snapshot-snapshotheader--in-progress',
      'webapp-screens-snapshot-snapshotheader--failed',
      'webapp-screens-snapshot-snapshotheader--error',
      'webapp-screens-snapshot-snapshotheader--error-last',
    ],
    type: 'component',
  },
  'webapp-screens-snapshot-snapshotheader--loading': {
    id: 'webapp-screens-snapshot-snapshotheader--loading',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending': {
    id: 'webapp-screens-snapshot-snapshotheader--pending',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-viewport-default': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-viewport-default',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, viewport default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-first': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-first',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, first',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-last': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-last',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, last',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-no-baseline': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-no-baseline',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, no baseline',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, has ignored selectors',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors-showing': {
    id: 'webapp-screens-snapshot-snapshotheader--pending-has-ignored-selectors-showing',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'pending, has ignored selectors, showing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--accepted': {
    id: 'webapp-screens-snapshot-snapshotheader--accepted',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'accepted',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--auto-accepted-first-build': {
    id: 'webapp-screens-snapshot-snapshotheader--auto-accepted-first-build',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'auto-accepted, first build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--denied': {
    id: 'webapp-screens-snapshot-snapshotheader--denied',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'denied',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--unreviewable-with-descendant': {
    id: 'webapp-screens-snapshot-snapshotheader--unreviewable-with-descendant',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'unreviewable, with descendant',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--read-only-logged-in': {
    id: 'webapp-screens-snapshot-snapshotheader--read-only-logged-in',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'read only, logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--read-only-not-logged-in': {
    id: 'webapp-screens-snapshot-snapshotheader--read-only-not-logged-in',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'read only, not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--in-progress': {
    id: 'webapp-screens-snapshot-snapshotheader--in-progress',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'in progress',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--failed': {
    id: 'webapp-screens-snapshot-snapshotheader--failed',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--error': {
    id: 'webapp-screens-snapshot-snapshotheader--error',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotheader--error-last': {
    id: 'webapp-screens-snapshot-snapshotheader--error-last',
    title: 'Webapp screens/Snapshot/SnapshotHeader',
    name: 'error, last',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotheader',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff': {
    name: 'SnapshotHtmlDiff',
    id: 'webapp-screens-snapshot-snapshothtmldiff',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: [
      'webapp-screens-snapshot-snapshothtmldiff--loading',
      'webapp-screens-snapshot-snapshothtmldiff--loading-baseline',
      'webapp-screens-snapshot-snapshothtmldiff--default',
      'webapp-screens-snapshot-snapshothtmldiff--long-lines',
      'webapp-screens-snapshot-snapshothtmldiff--too-large-issue-1885',
      'webapp-screens-snapshot-snapshothtmldiff--large-after-pretty-print-issue-1885-b',
      'webapp-screens-snapshot-snapshothtmldiff--too-large-html',
      'webapp-screens-snapshot-snapshothtmldiff--too-large-diff',
    ],
    type: 'component',
  },
  'webapp-screens-snapshot-snapshothtmldiff--loading': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--loading',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--loading-baseline': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--loading-baseline',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'loading-baseline',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--default': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--default',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'default',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--long-lines': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--long-lines',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'long lines',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--too-large-issue-1885': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--too-large-issue-1885',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'too large (issue #1885)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--large-after-pretty-print-issue-1885-b': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--large-after-pretty-print-issue-1885-b',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'large after pretty print (issue #1885b)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--too-large-html': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--too-large-html',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'too large (HTML)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshothtmldiff--too-large-diff': {
    id: 'webapp-screens-snapshot-snapshothtmldiff--too-large-diff',
    title: 'Webapp screens/Snapshot/SnapshotHtmlDiff',
    name: 'too large (DIFF)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshothtmldiff',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen': {
    name: 'SnapshotScreen',
    id: 'webapp-screens-snapshot-snapshotscreen',
    parent: 'webapp-screens-snapshot',
    depth: 2,
    children: [
      'webapp-screens-snapshot-snapshotscreen--loading',
      'webapp-screens-snapshot-snapshotscreen--pending-metadata-loading',
      'webapp-screens-snapshot-snapshotscreen--pending',
      'webapp-screens-snapshot-snapshotscreen--pending-multi-browser',
      'webapp-screens-snapshot-snapshotscreen--pending-multi-browser-one-unchanged',
      'webapp-screens-snapshot-snapshotscreen--pending-new-browser',
      'webapp-screens-snapshot-snapshotscreen--baseline-upgraded',
      'webapp-screens-snapshot-snapshotscreen--pending-tall',
      'webapp-screens-snapshot-snapshotscreen--pending-has-ignored',
      'webapp-screens-snapshot-snapshotscreen--pending-no-baseline-new-specs',
      'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline',
      'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline-one-complete',
      'webapp-screens-snapshot-snapshotscreen--disabled-because-of-newer-build',
      'webapp-screens-snapshot-snapshotscreen--read-only-logged-in',
      'webapp-screens-snapshot-snapshotscreen--read-only-not-logged-in',
      'webapp-screens-snapshot-snapshotscreen--failed',
      'webapp-screens-snapshot-snapshotscreen--failed-cross-browser-one-complete',
      'webapp-screens-snapshot-snapshotscreen--error',
      'webapp-screens-snapshot-snapshotscreen--error-cross-browser-same',
      'webapp-screens-snapshot-snapshotscreen--error-cross-browser-different',
      'webapp-screens-snapshot-snapshotscreen--error-image-too-large',
      'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout',
      'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout-cross-browser',
      'webapp-screens-snapshot-snapshotscreen--error-no-js',
      'webapp-screens-snapshot-snapshotscreen--error-failed-js',
      'webapp-screens-snapshot-snapshotscreen--error-story-missing',
      'webapp-screens-snapshot-snapshotscreen--error-metadata-loading',
      'webapp-screens-snapshot-snapshotscreen--timeout-warning',
      'webapp-screens-snapshot-snapshotscreen--certificate-warning',
    ],
    type: 'component',
  },
  'webapp-screens-snapshot-snapshotscreen--loading': {
    id: 'webapp-screens-snapshot-snapshotscreen--loading',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-metadata-loading': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-metadata-loading',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, metadata loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-multi-browser': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-multi-browser',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, multi-browser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-multi-browser-one-unchanged': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-multi-browser-one-unchanged',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, multi-browser, one unchanged',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-new-browser': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-new-browser',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, new browser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--baseline-upgraded': {
    id: 'webapp-screens-snapshot-snapshotscreen--baseline-upgraded',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, baseline upgraded',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-tall': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-tall',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, tall',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-has-ignored': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-has-ignored',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, has ignored',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--pending-no-baseline-new-specs': {
    id: 'webapp-screens-snapshot-snapshotscreen--pending-no-baseline-new-specs',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'pending, no baseline (new specs)',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline': {
    id: 'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'in progress, no baseline',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline-one-complete': {
    id: 'webapp-screens-snapshot-snapshotscreen--in-progress-no-baseline-one-complete',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'in progress, no baseline, one complete',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--disabled-because-of-newer-build': {
    id: 'webapp-screens-snapshot-snapshotscreen--disabled-because-of-newer-build',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'disabled because of newer build',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--read-only-logged-in': {
    id: 'webapp-screens-snapshot-snapshotscreen--read-only-logged-in',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'read only logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--read-only-not-logged-in': {
    id: 'webapp-screens-snapshot-snapshotscreen--read-only-not-logged-in',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'read only not logged in',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--failed': {
    id: 'webapp-screens-snapshot-snapshotscreen--failed',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'failed',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--failed-cross-browser-one-complete': {
    id: 'webapp-screens-snapshot-snapshotscreen--failed-cross-browser-one-complete',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'failed, cross browser, one complete',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error': {
    id: 'webapp-screens-snapshot-snapshotscreen--error',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-cross-browser-same': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-cross-browser-same',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, cross-browser, same',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-cross-browser-different': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-cross-browser-different',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, cross-browser, different',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-image-too-large': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-image-too-large',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, image too large',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, navigation timeout',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout-cross-browser': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-navigation-timeout-cross-browser',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, navigation timeout, cross browser',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-no-js': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-no-js',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'Error No JS',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-failed-js': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-failed-js',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'Error Failed JS',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-story-missing': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-story-missing',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, story missing',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--error-metadata-loading': {
    id: 'webapp-screens-snapshot-snapshotscreen--error-metadata-loading',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'error, metadata loading',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--timeout-warning': {
    id: 'webapp-screens-snapshot-snapshotscreen--timeout-warning',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'timeoutWarning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
  'webapp-screens-snapshot-snapshotscreen--certificate-warning': {
    id: 'webapp-screens-snapshot-snapshotscreen--certificate-warning',
    title: 'Webapp screens/Snapshot/SnapshotScreen',
    name: 'Certificate Warning',
    importPath: './path.js',
    args: {},
    argTypes: {},
    initialArgs: {},
    depth: 3,
    parent: 'webapp-screens-snapshot-snapshotscreen',
    type: 'story',
    prepared: true,
  },
} as Dataset;
