```mdx renderer="common" language="mdx"
{/* src/GettingStarted.mdx */}

# Getting Started

Welcome! Whether you're a designer or a developer, this guide will help you get started and connect you to the essential resources you need.

## Table of Contents

- [Design Resources](#design-resources)
  - [Figma](#figma)
  - [UI/UX Design Guidelines](#uiux-design-guidelines)
  - [Design Assets](#design-assets)

- [Development Resources](#development-resources)
  - [Coding Standards](#coding-standards)
  - [Version Control](#version-control)
  - [Development Tools](#development-tools)

---

## Design Resources

### Figma

[Figma](https://www.figma.com/) is a collaborative design and prototyping tool. It's the heart of the design process, allowing designers to work together seamlessly.

- **Get Access**: If you're not already part of the Figma project, request access from the project lead or manager.

### UI/UX Design Guidelines

Before you dive into designing, familiarize yourself with our UI/UX design guidelines. They provide valuable insights into our design philosophy and standards.

- [UI/UX Guidelines Document](https://your-design-guidelines-link.com)

### Design Assets

All the essential design assets like logos, icons, and brand guidelines can be found in the Figma project. Ensure you have access and familiarize yourself with these assets for consistency.

---

## Development Resources

### Coding Standards

Maintaining a consistent code style is essential for collaborative development. Our coding standards document will guide you on best practices.

- [Coding Standards Document](https://your-coding-standards-link.com)

### Version Control

We use Git for version control. Make sure you have Git installed and are familiar with its basics.

### Development Tools

Your development environment is critical. Here are some tools and resources to help you set up your workspace:

- **Code Editor**: We recommend using [Visual Studio Code](https://code.visualstudio.com/) for development. It's highly customizable and supports a wide range of extensions.

- **Package Manager**: [npm](https://www.npmjs.com/) is the package manager we use for JavaScript projects. Install it to manage project dependencies.

---
```

