window.EmberENV = (function(EmberENV, extra) {
  for (var key in extra) {
    EmberENV[key] = extra[key];
  }

  return EmberENV;
})(window.EmberENV || {}, {"FEATURES":{},"EXTEND_PROTOTYPES":{"Date":false},"_APPLICATION_TEMPLATE_WRAPPER":false,"_JQUERY_INTEGRATION":false,"_TEMPLATE_ONLY_GLIMMER_COMPONENTS":true});

var runningTests = false;



;var loader, define, requireModule, require, requirejs;

(function (global) {
  'use strict';

  function dict() {
    var obj = Object.create(null);
    obj['__'] = undefined;
    delete obj['__'];
    return obj;
  }

  // Save off the original values of these globals, so we can restore them if someone asks us to
  var oldGlobals = {
    loader: loader,
    define: define,
    requireModule: requireModule,
    require: require,
    requirejs: requirejs
  };

  requirejs = require = requireModule = function (id) {
    var pending = [];
    var mod = findModule(id, '(require)', pending);

    for (var i = pending.length - 1; i >= 0; i--) {
      pending[i].exports();
    }

    return mod.module.exports;
  };

  loader = {
    noConflict: function (aliases) {
      var oldName, newName;

      for (oldName in aliases) {
        if (aliases.hasOwnProperty(oldName)) {
          if (oldGlobals.hasOwnProperty(oldName)) {
            newName = aliases[oldName];

            global[newName] = global[oldName];
            global[oldName] = oldGlobals[oldName];
          }
        }
      }
    },
    // Option to enable or disable the generation of default exports
    makeDefaultExport: true
  };

  var registry = dict();
  var seen = dict();

  var uuid = 0;

  function unsupportedModule(length) {
    throw new Error('an unsupported module was defined, expected `define(id, deps, module)` instead got: `' + length + '` arguments to define`');
  }

  var defaultDeps = ['require', 'exports', 'module'];

  function Module(id, deps, callback, alias) {
    this.uuid = uuid++;
    this.id = id;
    this.deps = !deps.length && callback.length ? defaultDeps : deps;
    this.module = { exports: {} };
    this.callback = callback;
    this.hasExportsAsDep = false;
    this.isAlias = alias;
    this.reified = new Array(deps.length);

    /*
       Each module normally passes through these states, in order:
         new       : initial state
         pending   : this module is scheduled to be executed
         reifying  : this module's dependencies are being executed
         reified   : this module's dependencies finished executing successfully
         errored   : this module's dependencies failed to execute
         finalized : this module executed successfully
     */
    this.state = 'new';
  }

  Module.prototype.makeDefaultExport = function () {
    var exports = this.module.exports;
    if (exports !== null && (typeof exports === 'object' || typeof exports === 'function') && exports['default'] === undefined && Object.isExtensible(exports)) {
      exports['default'] = exports;
    }
  };

  Module.prototype.exports = function () {
    // if finalized, there is no work to do. If reifying, there is a
    // circular dependency so we must return our (partial) exports.
    if (this.state === 'finalized' || this.state === 'reifying') {
      return this.module.exports;
    }


    if (loader.wrapModules) {
      this.callback = loader.wrapModules(this.id, this.callback);
    }

    this.reify();

    var result = this.callback.apply(this, this.reified);
    this.reified.length = 0;
    this.state = 'finalized';

    if (!(this.hasExportsAsDep && result === undefined)) {
      this.module.exports = result;
    }
    if (loader.makeDefaultExport) {
      this.makeDefaultExport();
    }
    return this.module.exports;
  };

  Module.prototype.unsee = function () {
    this.state = 'new';
    this.module = { exports: {} };
  };

  Module.prototype.reify = function () {
    if (this.state === 'reified') {
      return;
    }
    this.state = 'reifying';
    try {
      this.reified = this._reify();
      this.state = 'reified';
    } finally {
      if (this.state === 'reifying') {
        this.state = 'errored';
      }
    }
  };

  Module.prototype._reify = function () {
    var reified = this.reified.slice();
    for (var i = 0; i < reified.length; i++) {
      var mod = reified[i];
      reified[i] = mod.exports ? mod.exports : mod.module.exports();
    }
    return reified;
  };

  Module.prototype.findDeps = function (pending) {
    if (this.state !== 'new') {
      return;
    }

    this.state = 'pending';

    var deps = this.deps;

    for (var i = 0; i < deps.length; i++) {
      var dep = deps[i];
      var entry = this.reified[i] = { exports: undefined, module: undefined };
      if (dep === 'exports') {
        this.hasExportsAsDep = true;
        entry.exports = this.module.exports;
      } else if (dep === 'require') {
        entry.exports = this.makeRequire();
      } else if (dep === 'module') {
        entry.exports = this.module;
      } else {
        entry.module = findModule(resolve(dep, this.id), this.id, pending);
      }
    }
  };

  Module.prototype.makeRequire = function () {
    var id = this.id;
    var r = function (dep) {
      return require(resolve(dep, id));
    };
    r['default'] = r;
    r.moduleId = id;
    r.has = function (dep) {
      return has(resolve(dep, id));
    };
    return r;
  };

  define = function (id, deps, callback) {
    var module = registry[id];

    // If a module for this id has already been defined and is in any state
    // other than `new` (meaning it has been or is currently being required),
    // then we return early to avoid redefinition.
    if (module && module.state !== 'new') {
      return;
    }

    if (arguments.length < 2) {
      unsupportedModule(arguments.length);
    }

    if (!Array.isArray(deps)) {
      callback = deps;
      deps = [];
    }

    if (callback instanceof Alias) {
      registry[id] = new Module(callback.id, deps, callback, true);
    } else {
      registry[id] = new Module(id, deps, callback, false);
    }
  };

  define.exports = function (name, defaultExport) {
    var module = registry[name];

    // If a module for this name has already been defined and is in any state
    // other than `new` (meaning it has been or is currently being required),
    // then we return early to avoid redefinition.
    if (module && module.state !== 'new') {
      return;
    }

    module = new Module(name, [], noop, null);
    module.module.exports = defaultExport;
    module.state = 'finalized';
    registry[name] = module;

    return module;
  };

  function noop() {}
  // we don't support all of AMD
  // define.amd = {};

  function Alias(id) {
    this.id = id;
  }

  define.alias = function (id, target) {
    if (arguments.length === 2) {
      return define(target, new Alias(id));
    }

    return new Alias(id);
  };

  function missingModule(id, referrer) {
    throw new Error('Could not find module `' + id + '` imported from `' + referrer + '`');
  }

  function findModule(id, referrer, pending) {
    var mod = registry[id] || registry[id + '/index'];

    while (mod && mod.isAlias) {
      mod = registry[mod.id] || registry[mod.id + '/index'];
    }

    if (!mod) {
      missingModule(id, referrer);
    }

    if (pending && mod.state !== 'pending' && mod.state !== 'finalized') {
      mod.findDeps(pending);
      pending.push(mod);
    }
    return mod;
  }

  function resolve(child, id) {
    if (child.charAt(0) !== '.') {
      return child;
    }


    var parts = child.split('/');
    var nameParts = id.split('/');
    var parentBase = nameParts.slice(0, -1);

    for (var i = 0, l = parts.length; i < l; i++) {
      var part = parts[i];

      if (part === '..') {
        if (parentBase.length === 0) {
          throw new Error('Cannot access parent module of root');
        }
        parentBase.pop();
      } else if (part === '.') {
        continue;
      } else {
        parentBase.push(part);
      }
    }

    return parentBase.join('/');
  }

  function has(id) {
    return !!(registry[id] || registry[id + '/index']);
  }

  requirejs.entries = requirejs._eak_seen = registry;
  requirejs.has = has;
  requirejs.unsee = function (id) {
    findModule(id, '(unsee)', false).unsee();
  };

  requirejs.clear = function () {
    requirejs.entries = requirejs._eak_seen = registry = dict();
    seen = dict();
  };

  // This code primes the JS engine for good performance by warming the
  // JIT compiler for these functions.
  define('foo', function () {});
  define('foo/bar', [], function () {});
  define('foo/asdf', ['module', 'exports', 'require'], function (module, exports, require) {
    if (require.has('foo/bar')) {
      require('foo/bar');
    }
  });
  define('foo/baz', [], define.alias('foo'));
  define('foo/quz', define.alias('foo'));
  define.alias('foo', 'foo/qux');
  define('foo/bar', ['foo', './quz', './baz', './asdf', './bar', '../foo'], function () {});
  define('foo/main', ['foo/bar'], function () {});
  define.exports('foo/exports', {});

  require('foo/exports');
  require('foo/main');
  require.unsee('foo/bar');

  requirejs.clear();

  if (typeof exports === 'object' && typeof module === 'object' && module.exports) {
    module.exports = { require: require, define: define };
  }
})(this);
;(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2020 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   3.24.6
 */
/*globals process */
var define, require, Ember;

// Used in @ember/-internals/environment/lib/global.js
mainContext = this; // eslint-disable-line no-undef

(function () {
  var registry;
  var seen;
  function missingModule(name, referrerName) {
    if (referrerName) {
      throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
    } else {
      throw new Error('Could not find module ' + name);
    }
  }
  function internalRequire(_name, referrerName) {
    var name = _name;
    var mod = registry[name];
    if (!mod) {
      name = name + '/index';
      mod = registry[name];
    }
    var exports = seen[name];
    if (exports !== undefined) {
      return exports;
    }
    exports = seen[name] = {};
    if (!mod) {
      missingModule(_name, referrerName);
    }
    var deps = mod.deps;
    var callback = mod.callback;
    var reified = new Array(deps.length);
    for (var i = 0; i < deps.length; i++) {
      if (deps[i] === 'exports') {
        reified[i] = exports;
      } else if (deps[i] === 'require') {
        reified[i] = require;
      } else {
        reified[i] = internalRequire(deps[i], name);
      }
    }
    callback.apply(this, reified);
    return exports;
  }
  var isNode = typeof window === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }
  if (typeof Ember === 'undefined') {
    Ember = {};
  }
  if (typeof Ember.__loader === 'undefined') {
    registry = Object.create(null);
    seen = Object.create(null);
    define = function define(name, deps, callback) {
      var value = {};
      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }
      registry[name] = value;
    };
    require = function require(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    require['default'] = require;
    require.has = function registryHas(moduleName) {
      return Boolean(registry[moduleName]) || Boolean(registry[moduleName + '/index']);
    };
    require._eak_seen = registry;
    Ember.__loader = {
      define: define,
      require: require,
      registry: registry
    };
  } else {
    define = Ember.__loader.define;
    require = Ember.__loader.require;
  }
})();
define("@ember/-internals/browser-environment/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.window = _exports.userAgent = _exports.location = _exports.isFirefox = _exports.isChrome = _exports.history = _exports.hasDOM = void 0;
  // check if window exists and actually is the global
  var hasDom = typeof self === 'object' && self !== null && self.Object === Object && typeof Window !== 'undefined' && self.constructor === Window && typeof document === 'object' && document !== null && self.document === document && typeof location === 'object' && location !== null && self.location === location && typeof history === 'object' && history !== null && self.history === history && typeof navigator === 'object' && navigator !== null && self.navigator === navigator && typeof navigator.userAgent === 'string';
  _exports.hasDOM = hasDom;
  var window = hasDom ? self : null;
  _exports.window = window;
  var location$1 = hasDom ? self.location : null;
  _exports.location = location$1;
  var history$1 = hasDom ? self.history : null;
  _exports.history = history$1;
  var userAgent = hasDom ? self.navigator.userAgent : 'Lynx (textmode)';
  _exports.userAgent = userAgent;
  var isChrome = hasDom ? Boolean(window.chrome) && !window.opera : false;
  _exports.isChrome = isChrome;
  var isFirefox = hasDom ? typeof InstallTrigger !== 'undefined' : false;
  _exports.isFirefox = isFirefox;
});
define("@ember/-internals/console/index", ["exports", "@ember/debug", "@ember/deprecated-features"], function (_exports, _debug, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  // Deliver message that the function is deprecated

  var DEPRECATION_MESSAGE = 'Use of Ember.Logger is deprecated. Please use `console` for logging.';
  var DEPRECATION_ID = 'ember-console.deprecate-logger';
  var DEPRECATION_URL = 'https://emberjs.com/deprecations/v3.x#toc_use-console-rather-than-ember-logger';
  /**
     @module ember
  */

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @deprecated Use 'console' instead
  
    @namespace Ember
    @public
  */

  var DEPRECATED_LOGGER;
  if (_deprecatedFeatures.LOGGER) {
    DEPRECATED_LOGGER = {
      /**
      Logs the arguments to the console.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      log: function log() {
        var _console;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return (_console = console).log.apply(_console, arguments); // eslint-disable-line no-console
      },
      /**
      Prints the arguments to the console with a warning icon.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      warn: function warn() {
        var _console2;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return (_console2 = console).warn.apply(_console2, arguments); // eslint-disable-line no-console
      },
      /**
      Prints the arguments to the console with an error icon, red text and a stack trace.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      error: function error() {
        var _console3;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return (_console3 = console).error.apply(_console3, arguments); // eslint-disable-line no-console
      },
      /**
      Logs the arguments to the console.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      info: function info() {
        var _console4;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return (_console4 = console).info.apply(_console4, arguments); // eslint-disable-line no-console
      },
      /**
      Logs the arguments to the console in blue text.
      You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
      @for Ember.Logger
      @param {*} arguments
      @public
      */
      debug: function debug() {
        var _console6;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        /* eslint-disable no-console */
        if (console.debug) {
          var _console5;
          return (_console5 = console).debug.apply(_console5, arguments);
        }
        return (_console6 = console).info.apply(_console6, arguments);
        /* eslint-enable no-console */
      },
      /**
      If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
      @for Ember.Logger
      @param {Boolean} bool Value to test
      @param {String} message Assertion message on failed
      @public
      */
      assert: function assert() {
        var _console7;
        (true && !(false) && (0, _debug.deprecate)(DEPRECATION_MESSAGE, false, {
          id: DEPRECATION_ID,
          until: '4.0.0',
          url: DEPRECATION_URL
        }));
        return (_console7 = console).assert.apply(_console7, arguments); // eslint-disable-line no-console
      }
    };
  }
  var _default = DEPRECATED_LOGGER;
  _exports.default = _default;
});
define("@ember/-internals/container/index", ["exports", "@ember/-internals/owner", "@ember/-internals/utils", "@ember/debug", "@ember/polyfills"], function (_exports, _owner, _utils, _debug, _polyfills) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.Registry = _exports.INIT_FACTORY = _exports.Container = void 0;
  _exports.getFactoryFor = getFactoryFor;
  _exports.privatize = privatize;
  _exports.setFactoryFor = setFactoryFor;
  var leakTracking;
  var containers;
  if (true /* DEBUG */) {
    // requires v8
    // chrome --js-flags="--allow-natives-syntax --expose-gc"
    // node --allow-natives-syntax --expose-gc
    try {
      if (typeof gc === 'function') {
        leakTracking = function () {
          // avoid syntax errors when --allow-natives-syntax not present
          var GetWeakSetValues = new Function('weakSet', 'return %GetWeakSetValues(weakSet, 0)');
          containers = new WeakSet();
          return {
            hasContainers: function hasContainers() {
              gc();
              return GetWeakSetValues(containers).length > 0;
            },
            reset: function reset() {
              var values = GetWeakSetValues(containers);
              for (var i = 0; i < values.length; i++) {
                containers.delete(values[i]);
              }
            }
          };
        }();
      }
    } catch (e) {// ignore
    }
  }
  /**
   A container used to instantiate and cache objects.
  
   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.
  
   The public API for `Container` is still in flux and should not be considered
   stable.
  
   @private
   @class Container
   */
  var Container = /*#__PURE__*/function () {
    function Container(registry, options) {
      if (options === void 0) {
        options = {};
      }
      this.registry = registry;
      this.owner = options.owner || null;
      this.cache = (0, _utils.dictionary)(options.cache || null);
      this.factoryManagerCache = (0, _utils.dictionary)(options.factoryManagerCache || null);
      this.isDestroyed = false;
      this.isDestroying = false;
      if (true /* DEBUG */) {
        this.validationCache = (0, _utils.dictionary)(options.validationCache || null);
        if (containers !== undefined) {
          containers.add(this);
        }
      }
    }
    /**
     @private
     @property registry
     @type Registry
     @since 1.11.0
     */

    /**
     @private
     @property cache
     @type InheritingDict
     */

    /**
     @private
     @property validationCache
     @type InheritingDict
     */

    /**
     Given a fullName return a corresponding instance.
      The default behavior is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted, an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @private
     @method lookup
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    var _proto = Container.prototype;
    _proto.lookup = function lookup(fullName, options) {
      if (this.isDestroyed) {
        throw new Error("Can not call `.lookup` after the owner has been destroyed");
      }
      (true && !(this.registry.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.registry.isValidFullName(fullName)));
      return _lookup(this, this.registry.normalize(fullName), options);
    }
    /**
     A depth first traversal, destroying the container, its descendant containers and all
     their managed objects.
      @private
     @method destroy
     */;
    _proto.destroy = function destroy() {
      this.isDestroying = true;
      destroyDestroyables(this);
    };
    _proto.finalizeDestroy = function finalizeDestroy() {
      resetCache(this);
      this.isDestroyed = true;
    }
    /**
     Clear either the entire cache or just the cache for a particular key.
        @private
     @method reset
     @param {String} fullName optional key to reset; if missing, resets everything
    */;
    _proto.reset = function reset(fullName) {
      if (this.isDestroyed) return;
      if (fullName === undefined) {
        destroyDestroyables(this);
        resetCache(this);
      } else {
        resetMember(this, this.registry.normalize(fullName));
      }
    }
    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      @private
     @method ownerInjection
     @returns { Object }
    */;
    _proto.ownerInjection = function ownerInjection() {
      var injection = {};
      (0, _owner.setOwner)(injection, this.owner);
      return injection;
    }
    /**
     Given a fullName, return the corresponding factory. The consumer of the factory
     is responsible for the destruction of any factory instances, as there is no
     way for the container to ensure instances are destroyed when it itself is
     destroyed.
      @public
     @method factoryFor
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */;
    _proto.factoryFor = function factoryFor(fullName) {
      if (this.isDestroyed) {
        throw new Error("Can not call `.factoryFor` after the owner has been destroyed");
      }
      var normalizedName = this.registry.normalize(fullName);
      (true && !(this.registry.isValidFullName(normalizedName)) && (0, _debug.assert)('fullName must be a proper full name', this.registry.isValidFullName(normalizedName)));
      return _factoryFor(this, normalizedName, fullName);
    };
    return Container;
  }();
  _exports.Container = Container;
  if (true /* DEBUG */) {
    Container._leakTracking = leakTracking;
  }
  /*
   * Wrap a factory manager in a proxy which will not permit properties to be
   * set on the manager.
   */

  function wrapManagerInDeprecationProxy(manager) {
    if (_utils.HAS_NATIVE_PROXY) {
      var validator = {
        set: function set(_obj, prop) {
          throw new Error("You attempted to set \"" + prop + "\" on a factory manager created by container#factoryFor. A factory manager is a read-only construct.");
        }
      }; // Note:
      // We have to proxy access to the manager here so that private property
      // access doesn't cause the above errors to occur.

      var m = manager;
      var proxiedManager = {
        class: m.class,
        create: function create(props) {
          return m.create(props);
        }
      };
      return new Proxy(proxiedManager, validator);
    }
    return manager;
  }
  function isSingleton(container, fullName) {
    return container.registry.getOption(fullName, 'singleton') !== false;
  }
  function isInstantiatable(container, fullName) {
    return container.registry.getOption(fullName, 'instantiate') !== false;
  }
  function _lookup(container, fullName, options) {
    if (options === void 0) {
      options = {};
    }
    var normalizedName = fullName;
    if (options.singleton !== false) {
      var cached = container.cache[normalizedName];
      if (cached !== undefined) {
        return cached;
      }
    }
    return instantiateFactory(container, normalizedName, fullName, options);
  }
  function _factoryFor(container, normalizedName, fullName) {
    var cached = container.factoryManagerCache[normalizedName];
    if (cached !== undefined) {
      return cached;
    }
    var factory = container.registry.resolve(normalizedName);
    if (factory === undefined) {
      return;
    }
    if (true /* DEBUG */ && factory && typeof factory._onLookup === 'function') {
      factory._onLookup(fullName);
    }
    var manager = new FactoryManager(container, factory, fullName, normalizedName);
    if (true /* DEBUG */) {
      manager = wrapManagerInDeprecationProxy(manager);
    }
    container.factoryManagerCache[normalizedName] = manager;
    return manager;
  }
  function isSingletonClass(container, fullName, _ref) {
    var instantiate = _ref.instantiate,
      singleton = _ref.singleton;
    return singleton !== false && !instantiate && isSingleton(container, fullName) && !isInstantiatable(container, fullName);
  }
  function isSingletonInstance(container, fullName, _ref2) {
    var instantiate = _ref2.instantiate,
      singleton = _ref2.singleton;
    return singleton !== false && instantiate !== false && isSingleton(container, fullName) && isInstantiatable(container, fullName);
  }
  function isFactoryClass(container, fullname, _ref3) {
    var instantiate = _ref3.instantiate,
      singleton = _ref3.singleton;
    return instantiate === false && (singleton === false || !isSingleton(container, fullname)) && !isInstantiatable(container, fullname);
  }
  function isFactoryInstance(container, fullName, _ref4) {
    var instantiate = _ref4.instantiate,
      singleton = _ref4.singleton;
    return instantiate !== false && (singleton !== false || isSingleton(container, fullName)) && isInstantiatable(container, fullName);
  }
  function instantiateFactory(container, normalizedName, fullName, options) {
    var factoryManager = _factoryFor(container, normalizedName, fullName);
    if (factoryManager === undefined) {
      return;
    } // SomeClass { singleton: true, instantiate: true } | { singleton: true } | { instantiate: true } | {}
    // By default majority of objects fall into this case

    if (isSingletonInstance(container, fullName, options)) {
      var instance = container.cache[normalizedName] = factoryManager.create(); // if this lookup happened _during_ destruction (emits a deprecation, but
      // is still possible) ensure that it gets destroyed

      if (container.isDestroying) {
        if (typeof instance.destroy === 'function') {
          instance.destroy();
        }
      }
      return instance;
    } // SomeClass { singleton: false, instantiate: true }

    if (isFactoryInstance(container, fullName, options)) {
      return factoryManager.create();
    } // SomeClass { singleton: true, instantiate: false } | { instantiate: false } | { singleton: false, instantiation: false }

    if (isSingletonClass(container, fullName, options) || isFactoryClass(container, fullName, options)) {
      return factoryManager.class;
    }
    throw new Error('Could not create factory');
  }
  function processInjections(container, injections, result) {
    if (true /* DEBUG */) {
      container.registry.validateInjections(injections);
    }
    var hash = result.injections;
    for (var i = 0; i < injections.length; i++) {
      var _injections$i = injections[i],
        property = _injections$i.property,
        specifier = _injections$i.specifier;
      hash[property] = _lookup(container, specifier);
      if (!result.isDynamic) {
        result.isDynamic = !isSingleton(container, specifier);
      }
    }
  }
  function buildInjections(container, typeInjections, injections) {
    var injectionsHash = {};
    (0, _owner.setOwner)(injectionsHash, container.owner);
    var result = {
      injections: injectionsHash,
      isDynamic: false
    };
    if (typeInjections !== undefined) {
      processInjections(container, typeInjections, result);
    }
    if (injections !== undefined) {
      processInjections(container, injections, result);
    }
    return result;
  }
  function injectionsFor(container, fullName) {
    var registry = container.registry;
    var _fullName$split = fullName.split(':'),
      type = _fullName$split[0];
    var typeInjections = registry.getTypeInjections(type);
    var injections = registry.getInjections(fullName);
    return buildInjections(container, typeInjections, injections);
  }
  function destroyDestroyables(container) {
    var cache = container.cache;
    var keys = Object.keys(cache);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = cache[key];
      if (value.destroy) {
        value.destroy();
      }
    }
  }
  function resetCache(container) {
    container.cache = (0, _utils.dictionary)(null);
    container.factoryManagerCache = (0, _utils.dictionary)(null);
  }
  function resetMember(container, fullName) {
    var member = container.cache[fullName];
    delete container.factoryManagerCache[fullName];
    if (member) {
      delete container.cache[fullName];
      if (member.destroy) {
        member.destroy();
      }
    }
  }
  var INIT_FACTORY = (0, _utils.symbol)('INIT_FACTORY');
  _exports.INIT_FACTORY = INIT_FACTORY;
  function getFactoryFor(obj) {
    return obj[INIT_FACTORY];
  }
  function setFactoryFor(obj, factory) {
    obj[INIT_FACTORY] = factory;
  }
  var FactoryManager = /*#__PURE__*/function () {
    function FactoryManager(container, factory, fullName, normalizedName) {
      this.container = container;
      this.owner = container.owner;
      this.class = factory;
      this.fullName = fullName;
      this.normalizedName = normalizedName;
      this.madeToString = undefined;
      this.injections = undefined;
      setFactoryFor(this, this);
    }
    var _proto2 = FactoryManager.prototype;
    _proto2.toString = function toString() {
      if (this.madeToString === undefined) {
        this.madeToString = this.container.registry.makeToString(this.class, this.fullName);
      }
      return this.madeToString;
    };
    _proto2.create = function create(options) {
      var container = this.container;
      if (container.isDestroyed) {
        throw new Error("Can not create new instances after the owner has been destroyed (you attempted to create " + this.fullName + ")");
      }
      var props = this.injections;
      if (props === undefined) {
        var _injectionsFor = injectionsFor(this.container, this.normalizedName),
          injections = _injectionsFor.injections,
          isDynamic = _injectionsFor.isDynamic;
        setFactoryFor(injections, this);
        props = injections;
        if (!isDynamic) {
          this.injections = injections;
        }
      }
      if (options !== undefined) {
        props = (0, _polyfills.assign)({}, props, options);
      }
      if (true /* DEBUG */) {
        var lazyInjections;
        var validationCache = this.container.validationCache; // Ensure that all lazy injections are valid at instantiation time

        if (!validationCache[this.fullName] && this.class && typeof this.class._lazyInjections === 'function') {
          lazyInjections = this.class._lazyInjections();
          lazyInjections = this.container.registry.normalizeInjectionsHash(lazyInjections);
          this.container.registry.validateInjections(lazyInjections);
        }
        validationCache[this.fullName] = true;
        (true && !(typeof this.class.create === 'function') && (0, _debug.assert)("Failed to create an instance of '" + this.normalizedName + "'. Most likely an improperly defined class or an invalid module export.", typeof this.class.create === 'function'));
      }
      return this.class.create(props);
    };
    return FactoryManager;
  }();
  var VALID_FULL_NAME_REGEXP = /^[^:]+:[^:]+$/;
  /**
   A registry used to store factory and option information keyed
   by type.
  
   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.
  
   The API for `Registry` is still in flux and should not be considered stable.
  
   @private
   @class Registry
   @since 1.11.0
  */
  var Registry = /*#__PURE__*/function () {
    function Registry(options) {
      if (options === void 0) {
        options = {};
      }
      this.fallback = options.fallback || null;
      this.resolver = options.resolver || null;
      this.registrations = (0, _utils.dictionary)(options.registrations || null);
      this._typeInjections = (0, _utils.dictionary)(null);
      this._injections = (0, _utils.dictionary)(null);
      this._localLookupCache = Object.create(null);
      this._normalizeCache = (0, _utils.dictionary)(null);
      this._resolveCache = (0, _utils.dictionary)(null);
      this._failSet = new Set();
      this._options = (0, _utils.dictionary)(null);
      this._typeOptions = (0, _utils.dictionary)(null);
    }
    /**
     A backup registry for resolving registrations when no matches can be found.
        @private
     @property fallback
     @type Registry
     */

    /**
     An object that has a `resolve` method that resolves a name.
        @private
     @property resolver
     @type Resolver
     */

    /**
     @private
     @property registrations
     @type InheritingDict
     */

    /**
     @private
        @property _typeInjections
     @type InheritingDict
     */

    /**
     @private
        @property _injections
     @type InheritingDict
     */

    /**
     @private
        @property _normalizeCache
     @type InheritingDict
     */

    /**
     @private
        @property _resolveCache
     @type InheritingDict
     */

    /**
     @private
        @property _options
     @type InheritingDict
     */

    /**
     @private
        @property _typeOptions
     @type InheritingDict
     */

    /**
     Creates a container based on this registry.
        @private
     @method container
     @param {Object} options
     @return {Container} created container
     */
    var _proto3 = Registry.prototype;
    _proto3.container = function container(options) {
      return new Container(this, options);
    }
    /**
     Registers a factory for later injection.
        Example:
        ```javascript
     let registry = new Registry();
        registry.register('model:user', Person, {singleton: false });
     registry.register('fruit:favorite', Orange);
     registry.register('communication:main', Email, {singleton: false});
     ```
        @private
     @method register
     @param {String} fullName
     @param {Function} factory
     @param {Object} options
     */;
    _proto3.register = function register(fullName, factory, options) {
      if (options === void 0) {
        options = {};
      }
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      (true && !(factory !== undefined) && (0, _debug.assert)("Attempting to register an unknown factory: '" + fullName + "'", factory !== undefined));
      var normalizedName = this.normalize(fullName);
      (true && !(!this._resolveCache[normalizedName]) && (0, _debug.assert)("Cannot re-register: '" + fullName + "', as it has already been resolved.", !this._resolveCache[normalizedName]));
      this._failSet.delete(normalizedName);
      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options;
    }
    /**
     Unregister a fullName
        ```javascript
     let registry = new Registry();
     registry.register('model:user', User);
        registry.resolve('model:user').create() instanceof User //=> true
        registry.unregister('model:user')
     registry.resolve('model:user') === undefined //=> true
     ```
        @private
     @method unregister
     @param {String} fullName
     */;
    _proto3.unregister = function unregister(fullName) {
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var normalizedName = this.normalize(fullName);
      this._localLookupCache = Object.create(null);
      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._options[normalizedName];
      this._failSet.delete(normalizedName);
    }
    /**
     Given a fullName return the corresponding factory.
        By default `resolve` will retrieve the factory from
     the registry.
        ```javascript
     let registry = new Registry();
     registry.register('api:twitter', Twitter);
        registry.resolve('api:twitter') // => Twitter
     ```
        Optionally the registry can be provided with a custom resolver.
     If provided, `resolve` will first provide the custom resolver
     the opportunity to resolve the fullName, otherwise it will fallback
     to the registry.
        ```javascript
     let registry = new Registry();
     registry.resolver = function(fullName) {
        // lookup via the module system of choice
      };
        // the twitter factory is added to the module system
     registry.resolve('api:twitter') // => Twitter
     ```
        @private
     @method resolve
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Function} fullName's factory
     */;
    _proto3.resolve = function resolve(fullName) {
      var factory = _resolve(this, this.normalize(fullName));
      if (factory === undefined && this.fallback !== null) {
        var _this$fallback;
        factory = (_this$fallback = this.fallback).resolve.apply(_this$fallback, arguments);
      }
      return factory;
    }
    /**
     A hook that can be used to describe how the resolver will
     attempt to find the factory.
        For example, the default Ember `.describe` returns the full
     class name (including namespace) where Ember's resolver expects
     to find the `fullName`.
        @private
     @method describe
     @param {String} fullName
     @return {string} described fullName
     */;
    _proto3.describe = function describe(fullName) {
      if (this.resolver !== null && this.resolver.lookupDescription) {
        return this.resolver.lookupDescription(fullName);
      } else if (this.fallback !== null) {
        return this.fallback.describe(fullName);
      } else {
        return fullName;
      }
    }
    /**
     A hook to enable custom fullName normalization behavior
        @private
     @method normalizeFullName
     @param {String} fullName
     @return {string} normalized fullName
     */;
    _proto3.normalizeFullName = function normalizeFullName(fullName) {
      if (this.resolver !== null && this.resolver.normalize) {
        return this.resolver.normalize(fullName);
      } else if (this.fallback !== null) {
        return this.fallback.normalizeFullName(fullName);
      } else {
        return fullName;
      }
    }
    /**
     Normalize a fullName based on the application's conventions
        @private
     @method normalize
     @param {String} fullName
     @return {string} normalized fullName
     */;
    _proto3.normalize = function normalize(fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    }
    /**
     @method makeToString
        @private
     @param {any} factory
     @param {string} fullName
     @return {function} toString function
     */;
    _proto3.makeToString = function makeToString(factory, fullName) {
      if (this.resolver !== null && this.resolver.makeToString) {
        return this.resolver.makeToString(factory, fullName);
      } else if (this.fallback !== null) {
        return this.fallback.makeToString(factory, fullName);
      } else {
        return factory.toString();
      }
    }
    /**
     Given a fullName check if the container is aware of its factory
     or singleton instance.
        @private
     @method has
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Boolean}
     */;
    _proto3.has = function has(fullName) {
      if (!this.isValidFullName(fullName)) {
        return false;
      }
      return _has(this, this.normalize(fullName));
    }
    /**
     Allow registering options for all factories of a type.
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        // if all of type `connection` must not be singletons
     registry.optionsForType('connection', { singleton: false });
        registry.register('connection:twitter', TwitterConnection);
     registry.register('connection:facebook', FacebookConnection);
        let twitter = container.lookup('connection:twitter');
     let twitter2 = container.lookup('connection:twitter');
        twitter === twitter2; // => false
        let facebook = container.lookup('connection:facebook');
     let facebook2 = container.lookup('connection:facebook');
        facebook === facebook2; // => false
     ```
        @private
     @method optionsForType
     @param {String} type
     @param {Object} options
     */;
    _proto3.optionsForType = function optionsForType(type, options) {
      this._typeOptions[type] = options;
    };
    _proto3.getOptionsForType = function getOptionsForType(type) {
      var optionsForType = this._typeOptions[type];
      if (optionsForType === undefined && this.fallback !== null) {
        optionsForType = this.fallback.getOptionsForType(type);
      }
      return optionsForType;
    }
    /**
     @private
     @method options
     @param {String} fullName
     @param {Object} options
     */;
    _proto3.options = function options(fullName, _options) {
      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = _options;
    };
    _proto3.getOptions = function getOptions(fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];
      if (options === undefined && this.fallback !== null) {
        options = this.fallback.getOptions(fullName);
      }
      return options;
    };
    _proto3.getOption = function getOption(fullName, optionName) {
      var options = this._options[fullName];
      if (options !== undefined && options[optionName] !== undefined) {
        return options[optionName];
      }
      var type = fullName.split(':')[0];
      options = this._typeOptions[type];
      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback !== null) {
        return this.fallback.getOption(fullName, optionName);
      }
      return undefined;
    }
    /**
     Used only via `injection`.
        Provides a specialized form of injection, specifically enabling
     all objects of one type to be injected with a reference to another
     object.
        For example, provided each object of type `controller` needed a `router`.
     one would do the following:
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        registry.register('router:main', Router);
     registry.register('controller:user', UserController);
     registry.register('controller:post', PostController);
        registry.typeInjection('controller', 'router', 'router:main');
        let user = container.lookup('controller:user');
     let post = container.lookup('controller:post');
        user.router instanceof Router; //=> true
     post.router instanceof Router; //=> true
        // both controllers share the same router
     user.router === post.router; //=> true
     ```
        @private
     @method typeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */;
    _proto3.typeInjection = function typeInjection(type, property, fullName) {
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var fullNameType = fullName.split(':')[0];
      (true && !(fullNameType !== type) && (0, _debug.assert)("Cannot inject a '" + fullName + "' on other " + type + "(s).", fullNameType !== type));
      var injections = this._typeInjections[type] || (this._typeInjections[type] = []);
      injections.push({
        property: property,
        specifier: fullName
      });
    }
    /**
     Defines injection rules.
        These rules are used to inject dependencies onto objects when they
     are instantiated.
        Two forms of injections are possible:
        * Injecting one fullName on another fullName
     * Injecting one fullName on a type
        Example:
        ```javascript
     let registry = new Registry();
     let container = registry.container();
        registry.register('source:main', Source);
     registry.register('model:user', User);
     registry.register('model:post', Post);
        // injecting one fullName on another fullName
     // eg. each user model gets a post model
     registry.injection('model:user', 'post', 'model:post');
        // injecting one fullName on another type
     registry.injection('model', 'source', 'source:main');
        let user = container.lookup('model:user');
     let post = container.lookup('model:post');
        user.source instanceof Source; //=> true
     post.source instanceof Source; //=> true
        user.post instanceof Post; //=> true
        // and both models share the same source
     user.source === post.source; //=> true
     ```
        @private
     @method injection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */;
    _proto3.injection = function injection(fullName, property, injectionName) {
      (true && !(this.isValidFullName(injectionName)) && (0, _debug.assert)("Invalid injectionName, expected: 'type:name' got: " + injectionName, this.isValidFullName(injectionName)));
      var normalizedInjectionName = this.normalize(injectionName);
      if (fullName.indexOf(':') === -1) {
        return this.typeInjection(fullName, property, normalizedInjectionName);
      }
      (true && !(this.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.isValidFullName(fullName)));
      var normalizedName = this.normalize(fullName);
      var injections = this._injections[normalizedName] || (this._injections[normalizedName] = []);
      injections.push({
        property: property,
        specifier: normalizedInjectionName
      });
    }
    /**
     @private
     @method knownForType
     @param {String} type the type to iterate over
    */;
    _proto3.knownForType = function knownForType(type) {
      var localKnown = (0, _utils.dictionary)(null);
      var registeredNames = Object.keys(this.registrations);
      for (var index = 0; index < registeredNames.length; index++) {
        var fullName = registeredNames[index];
        var itemType = fullName.split(':')[0];
        if (itemType === type) {
          localKnown[fullName] = true;
        }
      }
      var fallbackKnown, resolverKnown;
      if (this.fallback !== null) {
        fallbackKnown = this.fallback.knownForType(type);
      }
      if (this.resolver !== null && this.resolver.knownForType) {
        resolverKnown = this.resolver.knownForType(type);
      }
      return (0, _polyfills.assign)({}, fallbackKnown, localKnown, resolverKnown);
    };
    _proto3.isValidFullName = function isValidFullName(fullName) {
      return VALID_FULL_NAME_REGEXP.test(fullName);
    };
    _proto3.getInjections = function getInjections(fullName) {
      var injections = this._injections[fullName];
      if (this.fallback !== null) {
        var fallbackInjections = this.fallback.getInjections(fullName);
        if (fallbackInjections !== undefined) {
          injections = injections === undefined ? fallbackInjections : injections.concat(fallbackInjections);
        }
      }
      return injections;
    };
    _proto3.getTypeInjections = function getTypeInjections(type) {
      var injections = this._typeInjections[type];
      if (this.fallback !== null) {
        var fallbackInjections = this.fallback.getTypeInjections(type);
        if (fallbackInjections !== undefined) {
          injections = injections === undefined ? fallbackInjections : injections.concat(fallbackInjections);
        }
      }
      return injections;
    };
    return Registry;
  }();
  _exports.Registry = Registry;
  if (true /* DEBUG */) {
    var proto = Registry.prototype;
    proto.normalizeInjectionsHash = function (hash) {
      var injections = [];
      for (var key in hash) {
        if (Object.prototype.hasOwnProperty.call(hash, key)) {
          var specifier = hash[key].specifier;
          (true && !(this.isValidFullName(specifier)) && (0, _debug.assert)("Expected a proper full name, given '" + specifier + "'", this.isValidFullName(specifier)));
          injections.push({
            property: key,
            specifier: specifier
          });
        }
      }
      return injections;
    };
    proto.validateInjections = function (injections) {
      if (!injections) {
        return;
      }
      for (var i = 0; i < injections.length; i++) {
        var specifier = injections[i].specifier;
        (true && !(this.has(specifier)) && (0, _debug.assert)("Attempting to inject an unknown injection: '" + specifier + "'", this.has(specifier)));
      }
    };
  }
  function _resolve(registry, _normalizedName) {
    var normalizedName = _normalizedName;
    var cached = registry._resolveCache[normalizedName];
    if (cached !== undefined) {
      return cached;
    }
    if (registry._failSet.has(normalizedName)) {
      return;
    }
    var resolved;
    if (registry.resolver) {
      resolved = registry.resolver.resolve(normalizedName);
    }
    if (resolved === undefined) {
      resolved = registry.registrations[normalizedName];
    }
    if (resolved === undefined) {
      registry._failSet.add(normalizedName);
    } else {
      registry._resolveCache[normalizedName] = resolved;
    }
    return resolved;
  }
  function _has(registry, fullName) {
    return registry.resolve(fullName) !== undefined;
  }
  var privateNames = (0, _utils.dictionary)(null);
  var privateSuffix = ("" + Math.random() + Date.now()).replace('.', '');
  function privatize(_ref5) {
    var fullName = _ref5[0];
    var name = privateNames[fullName];
    if (name) {
      return name;
    }
    var _fullName$split2 = fullName.split(':'),
      type = _fullName$split2[0],
      rawName = _fullName$split2[1];
    return privateNames[fullName] = (0, _utils.intern)(type + ":" + rawName + "-" + privateSuffix);
  }

  /*
  Public API for the container is still in flux.
  The public API, specified on the application namespace should be considered the stable API.
  // @module container
    @private
  */
});
define("@ember/-internals/environment/index", ["exports", "@ember/deprecated-features"], function (_exports, _deprecatedFeatures) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.context = _exports.ENV = void 0;
  _exports.getENV = getENV;
  _exports.getLookup = getLookup;
  _exports.global = void 0;
  _exports.setLookup = setLookup;
  // from lodash to catch fake globals
  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  } // element ids can ruin global miss checks

  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  } // export real global

  var global$1 = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || typeof mainContext !== 'undefined' && mainContext ||
  // set before strict mode in Ember loader/wrapper
  new Function('return this')(); // eval outside of strict mode
  _exports.global = global$1;
  var context = function (global, Ember) {
    return Ember === undefined ? {
      imports: global,
      exports: global,
      lookup: global
    } : {
      // import jQuery
      imports: Ember.imports || global,
      // export Ember
      exports: Ember.exports || global,
      // search for Namespaces
      lookup: Ember.lookup || global
    };
  }(global$1, global$1.Ember);
  _exports.context = context;
  function getLookup() {
    return context.lookup;
  }
  function setLookup(value) {
    context.lookup = value;
  }

  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */

  var ENV = {
    ENABLE_OPTIONAL_FEATURES: false,
    /**
      Determines whether Ember should add to `Array`, `Function`, and `String`
      native object prototypes, a few extra methods in order to provide a more
      friendly API.
         We generally recommend leaving this option set to true however, if you need
      to turn it off, you can add the configuration property
      `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
         Note, when disabled (the default configuration for Ember Addons), you will
      instead have to access all methods and functions from the Ember
      namespace.
         @property EXTEND_PROTOTYPES
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    EXTEND_PROTOTYPES: {
      Array: true,
      Function: true,
      String: true
    },
    /**
      The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
      a full stack trace during deprecation warnings.
         @property LOG_STACKTRACE_ON_DEPRECATION
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    LOG_STACKTRACE_ON_DEPRECATION: true,
    /**
      The `LOG_VERSION` property, when true, tells Ember to log versions of all
      dependent libraries in use.
         @property LOG_VERSION
      @type Boolean
      @default true
      @for EmberENV
      @public
    */
    LOG_VERSION: true,
    RAISE_ON_DEPRECATION: false,
    STRUCTURED_PROFILE: false,
    /**
      Whether to insert a `<div class="ember-view" />` wrapper around the
      application template. See RFC #280.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _APPLICATION_TEMPLATE_WRAPPER
      @for EmberENV
      @type Boolean
      @default true
      @private
    */
    _APPLICATION_TEMPLATE_WRAPPER: true,
    /**
      Whether to use Glimmer Component semantics (as opposed to the classic "Curly"
      components semantics) for template-only components. See RFC #278.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _TEMPLATE_ONLY_GLIMMER_COMPONENTS
      @for EmberENV
      @type Boolean
      @default false
      @private
    */
    _TEMPLATE_ONLY_GLIMMER_COMPONENTS: false,
    /**
      Whether to perform extra bookkeeping needed to make the `captureRenderTree`
      API work.
         This has to be set before the ember JavaScript code is evaluated. This is
      usually done by setting `window.EmberENV = { _DEBUG_RENDER_TREE: true };`
      before the "vendor" `<script>` tag in `index.html`.
         Setting the flag after Ember is already loaded will not work correctly. It
      may appear to work somewhat, but fundamentally broken.
         This is not intended to be set directly. Ember Inspector will enable the
      flag on behalf of the user as needed.
         This flag is always on in development mode.
         The flag is off by default in production mode, due to the cost associated
      with the the bookkeeping work.
         The expected flow is that Ember Inspector will ask the user to refresh the
      page after enabling the feature. It could also offer a feature where the
      user add some domains to the "always on" list. In either case, Ember
      Inspector will inject the code on the page to set the flag if needed.
         @property _DEBUG_RENDER_TREE
      @for EmberENV
      @type Boolean
      @default false
      @private
    */
    _DEBUG_RENDER_TREE: true /* DEBUG */,
    /**
      Whether the app is using jQuery. See RFC #294.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _JQUERY_INTEGRATION
      @for EmberENV
      @type Boolean
      @default true
      @private
    */
    _JQUERY_INTEGRATION: true,
    /**
      Whether the app defaults to using async observers.
         This is not intended to be set directly, as the implementation may change in
      the future. Use `@ember/optional-features` instead.
         @property _DEFAULT_ASYNC_OBSERVERS
      @for EmberENV
      @type Boolean
      @default false
      @private
    */
    _DEFAULT_ASYNC_OBSERVERS: false,
    /**
      Controls the maximum number of scheduled rerenders without "settling". In general,
      applications should not need to modify this environment variable, but please
      open an issue so that we can determine if a better default value is needed.
         @property _RERENDER_LOOP_LIMIT
      @for EmberENV
      @type number
      @default 1000
      @private
     */
    _RERENDER_LOOP_LIMIT: 1000,
    EMBER_LOAD_HOOKS: {},
    FEATURES: {}
  };
  _exports.ENV = ENV;
  (function (EmberENV) {
    if (typeof EmberENV !== 'object' || EmberENV === null) return;
    for (var flag in EmberENV) {
      if (!Object.prototype.hasOwnProperty.call(EmberENV, flag) || flag === 'EXTEND_PROTOTYPES' || flag === 'EMBER_LOAD_HOOKS') continue;
      var defaultValue = ENV[flag];
      if (defaultValue === true) {
        ENV[flag] = EmberENV[flag] !== false;
      } else if (defaultValue === false) {
        ENV[flag] = EmberENV[flag] === true;
      }
    }
    var EXTEND_PROTOTYPES = EmberENV.EXTEND_PROTOTYPES;
    if (EXTEND_PROTOTYPES !== undefined) {
      if (typeof EXTEND_PROTOTYPES === 'object' && EXTEND_PROTOTYPES !== null) {
        ENV.EXTEND_PROTOTYPES.String = EXTEND_PROTOTYPES.String !== false;
        if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS) {
          ENV.EXTEND_PROTOTYPES.Function = EXTEND_PROTOTYPES.Function !== false;
        }
        ENV.EXTEND_PROTOTYPES.Array = EXTEND_PROTOTYPES.Array !== false;
      } else {
        var isEnabled = EXTEND_PROTOTYPES !== false;
        ENV.EXTEND_PROTOTYPES.String = isEnabled;
        if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS) {
          ENV.EXTEND_PROTOTYPES.Function = isEnabled;
        }
        ENV.EXTEND_PROTOTYPES.Array = isEnabled;
      }
    } // TODO this does not seem to be used by anything,
    //      can we remove it? do we need to deprecate it?

    var EMBER_LOAD_HOOKS = EmberENV.EMBER_LOAD_HOOKS;
    if (typeof EMBER_LOAD_HOOKS === 'object' && EMBER_LOAD_HOOKS !== null) {
      for (var hookName in EMBER_LOAD_HOOKS) {
        if (!Object.prototype.hasOwnProperty.call(EMBER_LOAD_HOOKS, hookName)) continue;
        var hooks = EMBER_LOAD_HOOKS[hookName];
        if (Array.isArray(hooks)) {
          ENV.EMBER_LOAD_HOOKS[hookName] = hooks.filter(function (hook) {
            return typeof hook === 'function';
          });
        }
      }
    }
    var FEATURES = EmberENV.FEATURES;
    if (typeof FEATURES === 'object' && FEATURES !== null) {
      for (var feature in FEATURES) {
        if (!Object.prototype.hasOwnProperty.call(FEATURES, feature)) continue;
        ENV.FEATURES[feature] = FEATURES[feature] === true;
      }
    }
    if (true /* DEBUG */) {
      ENV._DEBUG_RENDER_TREE = true;
    }
  })(global$1.EmberENV);
  function getENV() {
    return ENV;
  }
});
define("@ember/-internals/error-handling/index", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getDispatchOverride = getDispatchOverride;
  _exports.getOnerror = getOnerror;
  _exports.onErrorTarget = void 0;
  _exports.setDispatchOverride = setDispatchOverride;
  _exports.setOnerror = setOnerror;
  var onerror;
  var onErrorTarget = {
    get onerror() {
      return onerror;
    }
  }; // Ember.onerror getter
  _exports.onErrorTarget = onErrorTarget;
  function getOnerror() {
    return onerror;
  } // Ember.onerror setter

  function setOnerror(handler) {
    onerror = handler;
  }
  var dispatchOverride; // allows testing adapter to override dispatch

  function getDispatchOverride() {
    return dispatchOverride;
  }
  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }
});
define("@ember/-internals/extension-support/index", ["exports", "@ember/-internals/extension-support/lib/data_adapter", "@ember/-internals/extension-support/lib/container_debug_adapter"], function (_exports, _data_adapter, _container_debug_adapter) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "ContainerDebugAdapter", {
    enumerable: true,
    get: function get() {
      return _container_debug_adapter.default;
    }
  });
  Object.defineProperty(_exports, "DataAdapter", {
    enumerable: true,
    get: function get() {
      return _data_adapter.default;
    }
  });
});
define("@ember/-internals/extension-support/lib/container_debug_adapter", ["exports", "@ember/string", "@ember/-internals/runtime"], function (_exports, _string, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/debug
  */
  /**
    The `ContainerDebugAdapter` helps the container and resolver interface
    with tools that debug Ember such as the
    [Ember Inspector](https://github.com/emberjs/ember-inspector)
    for Chrome and Firefox.
  
    This class can be extended by a custom resolver implementer
    to override some of the methods with library-specific code.
  
    The methods likely to be overridden are:
  
    * `canCatalogEntriesByType`
    * `catalogEntriesByType`
  
    The adapter will need to be registered
    in the application's container as `container-debug-adapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "containerDebugAdapter",
  
      initialize(application) {
        application.register('container-debug-adapter:main', require('app/container-debug-adapter'));
      }
    });
    ```
  
    @class ContainerDebugAdapter
    @extends EmberObject
    @since 1.5.0
    @public
  */
  var _default = _runtime.Object.extend({
    /**
      The resolver instance of the application
      being debugged. This property will be injected
      on creation.
       @property resolver
      @default null
      @public
    */
    resolver: null,
    /**
      Returns true if it is possible to catalog a list of available
      classes in the resolver for a given type.
       @method canCatalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {boolean} whether a list is available for this type.
      @public
    */
    canCatalogEntriesByType: function canCatalogEntriesByType(type) {
      if (type === 'model' || type === 'template') {
        return false;
      }
      return true;
    },
    /**
      Returns the available classes a given type.
       @method catalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {Array} An array of strings.
      @public
    */
    catalogEntriesByType: function catalogEntriesByType(type) {
      var namespaces = (0, _runtime.A)(_runtime.Namespace.NAMESPACES);
      var types = (0, _runtime.A)();
      var typeSuffixRegex = new RegExp((0, _string.classify)(type) + "$");
      namespaces.forEach(function (namespace) {
        for (var key in namespace) {
          if (!Object.prototype.hasOwnProperty.call(namespace, key)) {
            continue;
          }
          if (typeSuffixRegex.test(key)) {
            var klass = namespace[key];
            if ((0, _runtime.typeOf)(klass) === 'class') {
              types.push((0, _string.dasherize)(key.replace(typeSuffixRegex, '')));
            }
          }
        }
      });
      return types;
    }
  });
  _exports.default = _default;
});
define("@ember/-internals/extension-support/lib/data_adapter", ["exports", "@ember/-internals/owner", "@ember/runloop", "@ember/-internals/metal", "@ember/string", "@ember/-internals/runtime"], function (_exports, _owner, _runloop, _metal, _string, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/debug
  */
  /**
    The `DataAdapter` helps a data persistence library
    interface with tools that debug Ember such
    as the [Ember Inspector](https://github.com/emberjs/ember-inspector)
    for Chrome and Firefox.
  
    This class will be extended by a persistence library
    which will override some of the methods with
    library-specific code.
  
    The methods likely to be overridden are:
  
    * `getFilters`
    * `detect`
    * `columnsForType`
    * `getRecords`
    * `getRecordColumnValues`
    * `getRecordKeywords`
    * `getRecordFilterValues`
    * `getRecordColor`
    * `observeRecord`
  
    The adapter will need to be registered
    in the application's container as `dataAdapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "data-adapter",
  
      initialize: function(application) {
        application.register('data-adapter:main', DS.DataAdapter);
      }
    });
    ```
  
    @class DataAdapter
    @extends EmberObject
    @public
  */
  var _default = _runtime.Object.extend({
    init: function init() {
      this._super.apply(this, arguments);
      this.releaseMethods = (0, _runtime.A)();
    },
    /**
      The container-debug-adapter which is used
      to list all models.
       @property containerDebugAdapter
      @default undefined
      @since 1.5.0
      @public
    **/
    containerDebugAdapter: undefined,
    /**
      The number of attributes to send
      as columns. (Enough to make the record
      identifiable).
       @private
      @property attributeLimit
      @default 3
      @since 1.3.0
    */
    attributeLimit: 3,
    /**
       Ember Data > v1.0.0-beta.18
       requires string model names to be passed
       around instead of the actual factories.
        This is a stamp for the Ember Inspector
       to differentiate between the versions
       to be able to support older versions too.
        @public
       @property acceptsModelName
     */
    acceptsModelName: true,
    /**
      Stores all methods that clear observers.
      These methods will be called on destruction.
       @private
      @property releaseMethods
      @since 1.3.0
    */
    releaseMethods: (0, _runtime.A)(),
    /**
      Specifies how records can be filtered.
      Records returned will need to have a `filterValues`
      property with a key for every name in the returned array.
       @public
      @method getFilters
      @return {Array} List of objects defining filters.
       The object should have a `name` and `desc` property.
    */
    getFilters: function getFilters() {
      return (0, _runtime.A)();
    },
    /**
      Fetch the model types and observe them for changes.
       @public
      @method watchModelTypes
       @param {Function} typesAdded Callback to call to add types.
      Takes an array of objects containing wrapped types (returned from `wrapModelType`).
       @param {Function} typesUpdated Callback to call when a type has changed.
      Takes an array of objects containing wrapped types.
       @return {Function} Method to call to remove all observers
    */
    watchModelTypes: function watchModelTypes(typesAdded, typesUpdated) {
      var _this = this;
      var modelTypes = this.getModelTypes();
      var releaseMethods = (0, _runtime.A)();
      var typesToSend;
      typesToSend = modelTypes.map(function (type) {
        var klass = type.klass;
        var wrapped = _this.wrapModelType(klass, type.name);
        releaseMethods.push(_this.observeModelType(type.name, typesUpdated));
        return wrapped;
      });
      typesAdded(typesToSend);
      var release = function release() {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        _this.releaseMethods.removeObject(release);
      };
      this.releaseMethods.pushObject(release);
      return release;
    },
    _nameToClass: function _nameToClass(type) {
      if (typeof type === 'string') {
        var owner = (0, _owner.getOwner)(this);
        var Factory = owner.factoryFor("model:" + type);
        type = Factory && Factory.class;
      }
      return type;
    },
    /**
      Fetch the records of a given type and observe them for changes.
       @public
      @method watchRecords
       @param {String} modelName The model name.
       @param {Function} recordsAdded Callback to call to add records.
      Takes an array of objects containing wrapped records.
      The object should have the following properties:
        columnValues: {Object} The key and value of a table cell.
        object: {Object} The actual record object.
       @param {Function} recordsUpdated Callback to call when a record has changed.
      Takes an array of objects containing wrapped records.
       @param {Function} recordsRemoved Callback to call when a record has removed.
      Takes the following parameters:
        index: The array index where the records were removed.
        count: The number of records removed.
       @return {Function} Method to call to remove all observers.
    */
    watchRecords: function watchRecords(modelName, recordsAdded, recordsUpdated, recordsRemoved) {
      var _this2 = this;
      var releaseMethods = (0, _runtime.A)();
      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);
      var _release;
      function recordUpdated(updatedRecord) {
        recordsUpdated([updatedRecord]);
      }
      var recordsToSend = records.map(function (record) {
        releaseMethods.push(_this2.observeRecord(record, recordUpdated));
        return _this2.wrapRecord(record);
      });
      var contentDidChange = function contentDidChange(array, idx, removedCount, addedCount) {
        for (var i = idx; i < idx + addedCount; i++) {
          var record = (0, _metal.objectAt)(array, i);
          var wrapped = _this2.wrapRecord(record);
          releaseMethods.push(_this2.observeRecord(record, recordUpdated));
          recordsAdded([wrapped]);
        }
        if (removedCount) {
          recordsRemoved(idx, removedCount);
        }
      };
      var observer = {
        didChange: contentDidChange,
        willChange: function willChange() {
          return this;
        }
      };
      (0, _metal.addArrayObserver)(records, this, observer);
      _release = function release() {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        (0, _metal.removeArrayObserver)(records, _this2, observer);
        _this2.releaseMethods.removeObject(_release);
      };
      recordsAdded(recordsToSend);
      this.releaseMethods.pushObject(_release);
      return _release;
    },
    /**
      Clear all observers before destruction
      @private
      @method willDestroy
    */
    willDestroy: function willDestroy() {
      this._super.apply(this, arguments);
      this.releaseMethods.forEach(function (fn) {
        return fn();
      });
    },
    /**
      Detect whether a class is a model.
       Test that against the model class
      of your persistence library.
       @public
      @method detect
      @return boolean Whether the class is a model class or not.
    */
    detect: function detect() {
      return false;
    },
    /**
      Get the columns for a given model type.
       @public
      @method columnsForType
      @return {Array} An array of columns of the following format:
       name: {String} The name of the column.
       desc: {String} Humanized description (what would show in a table column name).
    */
    columnsForType: function columnsForType() {
      return (0, _runtime.A)();
    },
    /**
      Adds observers to a model type class.
       @private
      @method observeModelType
      @param {String} modelName The model type name.
      @param {Function} typesUpdated Called when a type is modified.
      @return {Function} The function to call to remove observers.
    */
    observeModelType: function observeModelType(modelName, typesUpdated) {
      var _this3 = this;
      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);
      function onChange() {
        typesUpdated([this.wrapModelType(klass, modelName)]);
      }
      var observer = {
        didChange: function didChange(array, idx, removedCount, addedCount) {
          // Only re-fetch records if the record count changed
          // (which is all we care about as far as model types are concerned).
          if (removedCount > 0 || addedCount > 0) {
            (0, _runloop.scheduleOnce)('actions', this, onChange);
          }
        },
        willChange: function willChange() {
          return this;
        }
      };
      (0, _metal.addArrayObserver)(records, this, observer);
      var release = function release() {
        return (0, _metal.removeArrayObserver)(records, _this3, observer);
      };
      return release;
    },
    /**
      Wraps a given model type and observes changes to it.
       @private
      @method wrapModelType
      @param {Class} klass A model class.
      @param {String} modelName Name of the class.
      @return {Object} Contains the wrapped type and the function to remove observers
      Format:
        type: {Object} The wrapped type.
          The wrapped type has the following format:
            name: {String} The name of the type.
            count: {Integer} The number of records available.
            columns: {Columns} An array of columns to describe the record.
            object: {Class} The actual Model type class.
        release: {Function} The function to remove observers.
    */
    wrapModelType: function wrapModelType(klass, name) {
      var records = this.getRecords(klass, name);
      var typeToSend;
      typeToSend = {
        name: name,
        count: (0, _metal.get)(records, 'length'),
        columns: this.columnsForType(klass),
        object: klass
      };
      return typeToSend;
    },
    /**
      Fetches all models defined in the application.
       @private
      @method getModelTypes
      @return {Array} Array of model types.
    */
    getModelTypes: function getModelTypes() {
      var _this4 = this;
      var containerDebugAdapter = this.get('containerDebugAdapter');
      var types;
      if (containerDebugAdapter.canCatalogEntriesByType('model')) {
        types = containerDebugAdapter.catalogEntriesByType('model');
      } else {
        types = this._getObjectsOnNamespaces();
      } // New adapters return strings instead of classes.

      types = (0, _runtime.A)(types).map(function (name) {
        return {
          klass: _this4._nameToClass(name),
          name: name
        };
      });
      types = (0, _runtime.A)(types).filter(function (type) {
        return _this4.detect(type.klass);
      });
      return (0, _runtime.A)(types);
    },
    /**
      Loops over all namespaces and all objects
      attached to them.
       @private
      @method _getObjectsOnNamespaces
      @return {Array} Array of model type strings.
    */
    _getObjectsOnNamespaces: function _getObjectsOnNamespaces() {
      var _this5 = this;
      var namespaces = (0, _runtime.A)(_runtime.Namespace.NAMESPACES);
      var types = (0, _runtime.A)();
      namespaces.forEach(function (namespace) {
        for (var key in namespace) {
          if (!Object.prototype.hasOwnProperty.call(namespace, key)) {
            continue;
          } // Even though we will filter again in `getModelTypes`,
          // we should not call `lookupFactory` on non-models

          if (!_this5.detect(namespace[key])) {
            continue;
          }
          var name = (0, _string.dasherize)(key);
          types.push(name);
        }
      });
      return types;
    },
    /**
      Fetches all loaded records for a given type.
       @public
      @method getRecords
      @return {Array} An array of records.
       This array will be observed for changes,
       so it should update when new records are added/removed.
    */
    getRecords: function getRecords() {
      return (0, _runtime.A)();
    },
    /**
      Wraps a record and observers changes to it.
       @private
      @method wrapRecord
      @param {Object} record The record instance.
      @return {Object} The wrapped record. Format:
      columnValues: {Array}
      searchKeywords: {Array}
    */
    wrapRecord: function wrapRecord(record) {
      var recordToSend = {
        object: record
      };
      recordToSend.columnValues = this.getRecordColumnValues(record);
      recordToSend.searchKeywords = this.getRecordKeywords(record);
      recordToSend.filterValues = this.getRecordFilterValues(record);
      recordToSend.color = this.getRecordColor(record);
      return recordToSend;
    },
    /**
      Gets the values for each column.
       @public
      @method getRecordColumnValues
      @return {Object} Keys should match column names defined
      by the model type.
    */
    getRecordColumnValues: function getRecordColumnValues() {
      return {};
    },
    /**
      Returns keywords to match when searching records.
       @public
      @method getRecordKeywords
      @return {Array} Relevant keywords for search.
    */
    getRecordKeywords: function getRecordKeywords() {
      return (0, _runtime.A)();
    },
    /**
      Returns the values of filters defined by `getFilters`.
       @public
      @method getRecordFilterValues
      @param {Object} record The record instance.
      @return {Object} The filter values.
    */
    getRecordFilterValues: function getRecordFilterValues() {
      return {};
    },
    /**
      Each record can have a color that represents its state.
       @public
      @method getRecordColor
      @param {Object} record The record instance
      @return {String} The records color.
        Possible options: black, red, blue, green.
    */
    getRecordColor: function getRecordColor() {
      return null;
    },
    /**
      Observes all relevant properties and re-sends the wrapped record
      when a change occurs.
       @public
      @method observerRecord
      @return {Function} The function to call to remove all observers.
    */
    observeRecord: function observeRecord() {
      return function () {};
    }
  });
  _exports.default = _default;
});
define("@ember/-internals/glimmer/index", ["exports", "ember-babel", "@ember/polyfills", "@glimmer/opcode-compiler", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/-internals/views", "@ember/debug", "@glimmer/reference", "@glimmer/runtime", "@glimmer/validator", "@ember/-internals/browser-environment", "@ember/engine", "@ember/instrumentation", "@ember/service", "@ember/runloop", "@glimmer/util", "@ember/-internals/environment", "@ember/deprecated-features", "@ember/string", "@ember/-internals/container", "@glimmer/node", "@glimmer/global-context", "@ember/-internals/routing", "@ember/component/template-only", "@ember/error", "@glimmer/program", "rsvp"], function (_exports, _emberBabel, _polyfills, _opcodeCompiler, _metal, _owner, _runtime, _utils, _views, _debug, _reference, _runtime2, _validator, _browserEnvironment, _engine, _instrumentation, _service, _runloop, _util, _environment2, _deprecatedFeatures, _string, _container, _node, _globalContext, _routing, _templateOnly, _error, _program, _rsvp) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.Component = _exports.Checkbox = void 0;
  Object.defineProperty(_exports, "DOMChanges", {
    enumerable: true,
    get: function get() {
      return _runtime2.DOMChanges;
    }
  });
  Object.defineProperty(_exports, "DOMTreeConstruction", {
    enumerable: true,
    get: function get() {
      return _runtime2.DOMTreeConstruction;
    }
  });
  _exports.LinkComponent = _exports.InteractiveRenderer = _exports.InertRenderer = _exports.INVOKE = _exports.Helper = void 0;
  Object.defineProperty(_exports, "NodeDOMTreeConstruction", {
    enumerable: true,
    get: function get() {
      return _node.NodeDOMTreeConstruction;
    }
  });
  _exports._experimentalMacros = _exports.TextField = _exports.TextArea = _exports.SafeString = _exports.RootTemplate = _exports.Renderer = _exports.OutletView = void 0;
  _exports._registerMacros = registerMacros;
  _exports._resetRenderers = _resetRenderers;
  _exports.capabilities = capabilities;
  _exports.escapeExpression = escapeExpression;
  Object.defineProperty(_exports, "getComponentTemplate", {
    enumerable: true,
    get: function get() {
      return _runtime2.getComponentTemplate;
    }
  });
  _exports.getTemplate = getTemplate;
  _exports.getTemplates = getTemplates;
  _exports.hasTemplate = hasTemplate;
  _exports.helper = helper;
  _exports.helperCapabilities = helperCapabilities;
  _exports.htmlSafe = htmlSafe;
  _exports.invokeHelper = invokeHelper;
  _exports.isHTMLSafe = isHTMLSafe;
  Object.defineProperty(_exports, "isSerializationFirstNode", {
    enumerable: true,
    get: function get() {
      return _runtime2.isSerializationFirstNode;
    }
  });
  _exports.modifierCapabilities = capabilities$1;
  _exports.renderSettled = renderSettled;
  _exports.setComponentManager = setComponentManager$1;
  Object.defineProperty(_exports, "setComponentTemplate", {
    enumerable: true,
    get: function get() {
      return _runtime2.setComponentTemplate;
    }
  });
  _exports.setTemplate = setTemplate;
  _exports.setTemplates = setTemplates;
  _exports.setupApplicationRegistry = setupApplicationRegistry;
  _exports.setupEngineRegistry = setupEngineRegistry;
  Object.defineProperty(_exports, "template", {
    enumerable: true,
    get: function get() {
      return _opcodeCompiler.templateFactory;
    }
  });
  Object.defineProperty(_exports, "templateCacheCounters", {
    enumerable: true,
    get: function get() {
      return _opcodeCompiler.templateCacheCounters;
    }
  });
  var _CoreView$extend, _templateObject, _templateObject2, _templateObject3, _templateObject4, _templateObject5, _templateObject6, _templateObject7;
  var RootTemplate = (0, _opcodeCompiler.templateFactory)({
    "id": "gxklthW0",
    "block": "{\"symbols\":[],\"statements\":[[1,[30,[36,0],[[32,0]],null]]],\"hasEval\":false,\"upvars\":[\"component\"]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/root.hbs"
  });
  _exports.RootTemplate = RootTemplate;
  var ARGS = (0, _utils.enumerableSymbol)('ARGS');
  var HAS_BLOCK = (0, _utils.enumerableSymbol)('HAS_BLOCK');
  var DIRTY_TAG = (0, _utils.symbol)('DIRTY_TAG');
  var IS_DISPATCHING_ATTRS = (0, _utils.symbol)('IS_DISPATCHING_ATTRS');
  var BOUNDS = (0, _utils.symbol)('BOUNDS');
  /**
  @module @ember/component
  */

  /**
    A component is an isolated piece of UI, represented by a template and an
    optional class. When a component has a class, its template's `this` value
    is an instance of the component class.
  
    ## Template-only Components
  
    The simplest way to create a component is to create a template file in
    `app/templates/components`. For example, if you name a template
    `app/templates/components/person-profile.hbs`:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
    <img src={{@person.avatar}}>
    <p class='signature'>{{@person.signature}}</p>
    ```
  
    You will be able to use `<PersonProfile />` to invoke this component elsewhere
    in your application:
  
    ```app/templates/application.hbs
    <PersonProfile @person={{this.currentUser}} />
    ```
  
    Note that component names are capitalized here in order to distinguish them
    from regular HTML elements, but they are dasherized in the file system.
  
    While the angle bracket invocation form is generally preferred, it is also
    possible to invoke the same component with the `{{person-profile}}` syntax:
  
    ```app/templates/application.hbs
    {{person-profile person=this.currentUser}}
    ```
  
    Note that with this syntax, you use dashes in the component name and
    arguments are passed without the `@` sign.
  
    In both cases, Ember will render the content of the component template we
    created above. The end result will be something like this:
  
    ```html
    <h1>Tomster</h1>
    <img src="https://emberjs.com/tomster.jpg">
    <p class='signature'>Out of office this week</p>
    ```
  
    ## File System Nesting
  
    Components can be nested inside sub-folders for logical groupping. For
    example, if we placed our template in
    `app/templates/components/person/short-profile.hbs`, we can invoke it as
    `<Person::ShortProfile />`:
  
    ```app/templates/application.hbs
    <Person::ShortProfile @person={{this.currentUser}} />
    ```
  
    Or equivalently, `{{person/short-profile}}`:
  
    ```app/templates/application.hbs
    {{person/short-profile person=this.currentUser}}
    ```
  
    ## Yielding Contents
  
    You can use `yield` inside a template to include the **contents** of any block
    attached to the component. The block will be executed in its original context:
  
    ```handlebars
    <PersonProfile @person={{this.currentUser}}>
      <p>Admin mode</p>
      {{! Executed in the current context. }}
    </PersonProfile>
    ```
  
    or
  
    ```handlebars
    {{#person-profile person=this.currentUser}}
      <p>Admin mode</p>
      {{! Executed in the current context. }}
    {{/person-profile}}
    ```
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
    {{yield}}
    ```
  
    ## Customizing Components With JavaScript
  
    If you want to customize the component in order to handle events, transform
    arguments or maintain internal state, you implement a subclass of `Component`.
  
    One example is to add computed properties to your component:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      displayName: computed('person.title', 'person.firstName', 'person.lastName', function() {
        let { title, firstName, lastName } = this;
  
        if (title) {
          return `${title} ${lastName}`;
        } else {
          return `${firstName} ${lastName}`;
        }
      })
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{this.displayName}}</h1>
    {{yield}}
    ```
  
    ## Customizing a Component's HTML Element in JavaScript
  
    ### HTML Tag
  
    The default HTML tag name used for a component's HTML representation is `div`.
    This can be customized by setting the `tagName` property.
  
    Consider the following component class:
  
    ```app/components/emphasized-paragraph.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'em'
    });
    ```
  
    When invoked, this component would produce output that looks something like
    this:
  
    ```html
    <em id="ember1" class="ember-view"></em>
    ```
  
    ### HTML `class` Attribute
  
    The HTML `class` attribute of a component's tag can be set by providing a
    `classNames` property that is set to an array of strings:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNames: ['my-class', 'my-other-class']
    });
    ```
  
    Invoking this component will produce output that looks like this:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class"></div>
    ```
  
    `class` attribute values can also be set by providing a `classNameBindings`
    property set to an array of properties names for the component. The return
    value of these properties will be added as part of the value for the
    components's `class` attribute. These properties can be computed properties:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      classNames: ['my-class', 'my-other-class'],
      classNameBindings: ['propertyA', 'propertyB'],
  
      propertyA: 'from-a',
      propertyB: computed(function() {
        if (someLogic) { return 'from-b'; }
      })
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class from-a from-b"></div>
    ```
  
    Note that `classNames` and `classNameBindings` is in addition to the `class`
    attribute passed with the angle bracket invocation syntax. Therefore, if this
    component was invoked like so:
  
    ```handlebars
    <MyWidget class="from-invocation" />
    ```
  
    The resulting HTML will look similar to this:
  
    ```html
    <div id="ember1" class="from-invocation ember-view my-class my-other-class from-a from-b"></div>
    ```
  
    If the value of a class name binding returns a boolean the property name
    itself will be used as the class name if the property is true. The class name
    will not be added if the value is `false` or `undefined`.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['hovered'],
  
      hovered: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view hovered"></div>
    ```
  
    ### Custom Class Names for Boolean Values
  
    When using boolean class name bindings you can supply a string value other
    than the property name for use as the `class` HTML attribute by appending the
    preferred value after a ":" character when defining the binding:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['awesome:so-very-cool'],
  
      awesome: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view so-very-cool"></div>
    ```
  
    Boolean value class name bindings whose property names are in a
    camelCase-style format will be converted to a dasherized format:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isUrgent'],
  
      isUrgent: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view is-urgent"></div>
    ```
  
    Class name bindings can also refer to object values that are found by
    traversing a path relative to the component itself:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import EmberObject from '@ember/object';
  
    export default Component.extend({
      classNameBindings: ['messages.empty'],
  
      messages: EmberObject.create({
        empty: true
      })
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view empty"></div>
    ```
  
    If you want to add a class name for a property which evaluates to true and
    and a different class name if it evaluates to false, you can pass a binding
    like this:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isEnabled:enabled:disabled'],
      isEnabled: true
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view enabled"></div>
    ```
  
    When isEnabled is `false`, the resulting HTML representation looks like this:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    This syntax offers the convenience to add a class if a property is `false`:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    // Applies no class when isEnabled is true and class 'disabled' when isEnabled is false
    export default Component.extend({
      classNameBindings: ['isEnabled::disabled'],
      isEnabled: true
    });
    ```
  
    Invoking this component when the `isEnabled` property is true will produce
    HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view"></div>
    ```
  
    Invoking it when the `isEnabled` property on the component is `false` will
    produce HTML that looks like:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    Updates to the value of a class name binding will result in automatic update
    of the  HTML `class` attribute in the component's rendered HTML
    representation. If the value becomes `false` or `undefined` the class name
    will be removed.
  
    Both `classNames` and `classNameBindings` are concatenated properties. See
    [EmberObject](/ember/release/classes/EmberObject) documentation for more
    information about concatenated properties.
  
    ### Other HTML Attributes
  
    The HTML attribute section of a component's tag can be set by providing an
    `attributeBindings` property set to an array of property names on the component.
    The return value of these properties will be used as the value of the component's
    HTML associated attribute:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['href'],
  
      href: 'http://google.com'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    One property can be mapped on to another by placing a ":" between
    the source property and the destination property:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['url:href'],
  
      url: 'http://google.com'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    HTML attributes passed with angle bracket invocations will take precedence
    over those specified in `attributeBindings`. Therefore, if this component was
    invoked like so:
  
    ```handlebars
    <MyAnchor href="http://bing.com" @url="http://google.com" />
    ```
  
    The resulting HTML will looks like this:
  
    ```html
    <a id="ember1" class="ember-view" href="http://bing.com"></a>
    ```
  
    Note that the `href` attribute is ultimately set to `http://bing.com`,
    despite it having attribute binidng to the `url` property, which was
    set to `http://google.com`.
  
    Namespaced attributes (e.g. `xlink:href`) are supported, but have to be
    mapped, since `:` is not a valid character for properties in Javascript:
  
    ```app/components/my-use.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'use',
      attributeBindings: ['xlinkHref:xlink:href'],
  
      xlinkHref: '#triangle'
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <use xlink:href="#triangle"></use>
    ```
  
    If the value of a property monitored by `attributeBindings` is a boolean, the
    attribute will be present or absent depending on the value:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: false
    });
    ```
  
    Invoking this component will produce HTML that looks like:
  
    ```html
    <input id="ember1" class="ember-view" />
    ```
  
    `attributeBindings` can refer to computed properties:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: computed(function() {
        if (someLogic) {
          return true;
        } else {
          return false;
        }
      })
    });
    ```
  
    To prevent setting an attribute altogether, use `null` or `undefined` as the
    value of the property used in `attributeBindings`:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'form',
      attributeBindings: ['novalidate'],
      novalidate: null
    });
    ```
  
    Updates to the property of an attribute binding will result in automatic
    update of the  HTML attribute in the component's HTML output.
  
    `attributeBindings` is a concatenated property. See
    [EmberObject](/ember/release/classes/EmberObject) documentation for more
    information about concatenated properties.
  
    ## Layouts
  
    The `layout` property can be used to dynamically specify a template associated
    with a component class, instead of relying on Ember to link together a
    component class and a template based on file names.
  
    In general, applications should not use this feature, but it's commonly used
    in addons for historical reasons.
  
    The `layout` property should be set to the default export of a template
    module, which is the name of a template file without the `.hbs` extension.
  
    ```app/templates/components/person-profile.hbs
    <h1>Person's Title</h1>
    <div class='details'>{{yield}}</div>
    ```
  
    ```app/components/person-profile.js
      import Component from '@ember/component';
      import layout from '../templates/components/person-profile';
  
      export default Component.extend({
        layout
      });
    ```
  
    If you invoke the component:
  
    ```handlebars
    <PersonProfile>
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    </PersonProfile>
    ```
  
    or
  
    ```handlebars
    {{#person-profile}}
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    {{/person-profile}}
    ```
  
    It will result in the following HTML output:
  
    ```html
    <h1>Person's Title</h1>
      <div class="details">
      <h2>Chief Basket Weaver</h2>
      <h3>Fisherman Industries</h3>
    </div>
    ```
  
    ## Handling Browser Events
  
    Components can respond to user-initiated events in one of three ways: passing
    actions with angle bracket invocation, adding event handler methods to the
    component's class, or adding actions to the component's template.
  
    ### Passing Actions With Angle Bracket Invocation
  
    For one-off events specific to particular instance of a component, it is possible
    to pass actions to the component's element using angle bracket invocation syntax.
  
    ```handlebars
    <MyWidget {{action 'firstWidgetClicked'}} />
  
    <MyWidget {{action 'secondWidgetClicked'}} />
    ```
  
    In this case, when the first component is clicked on, Ember will invoke the
    `firstWidgetClicked` action. When the second component is clicked on, Ember
    will invoke the `secondWidgetClicked` action instead.
  
    Besides `{{action}}`, it is also possible to pass any arbitrary element modifiers
    using the angle bracket invocation syntax.
  
    ### Event Handler Methods
  
    Components can also respond to user-initiated events by implementing a method
    that matches the event name. This approach is appropriate when the same event
    should be handled by all instances of the same component.
  
    An event object will be passed as the argument to the event handler method.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click(event) {
        // `event.target` is either the component's element or one of its children
        let tag = event.target.tagName.toLowerCase();
        console.log('clicked on a `<${tag}>` HTML element!');
      }
    });
    ```
  
    In this example, whenever the user clicked anywhere inside the component, it
    will log a message to the console.
  
    It is possible to handle event types other than `click` by implementing the
    following event handler methods. In addition, custom events can be registered
    by using `Application.customEvents`.
  
    Touch events:
  
    * `touchStart`
    * `touchMove`
    * `touchEnd`
    * `touchCancel`
  
    Keyboard events:
  
    * `keyDown`
    * `keyUp`
    * `keyPress`
  
    Mouse events:
  
    * `mouseDown`
    * `mouseUp`
    * `contextMenu`
    * `click`
    * `doubleClick`
    * `focusIn`
    * `focusOut`
  
    Form events:
  
    * `submit`
    * `change`
    * `focusIn`
    * `focusOut`
    * `input`
  
    Drag and drop events:
  
    * `dragStart`
    * `drag`
    * `dragEnter`
    * `dragLeave`
    * `dragOver`
    * `dragEnd`
    * `drop`
  
    ### `{{action}}` Helper
  
    Instead of handling all events of a particular type anywhere inside the
    component's element, you may instead want to limit it to a particular
    element in the component's template. In this case, it would be more
    convenient to implement an action instead.
  
    For example, you could implement the action `hello` for the `person-profile`
    component:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        hello(name) {
          console.log("Hello", name);
        }
      }
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{@person.name}}</h1>
  
    <button {{action 'hello' @person.name}}>
      Say Hello to {{@person.name}}
    </button>
    ```
  
    When the user clicks the button, Ember will invoke the `hello` action,
    passing in the current value of `@person.name` as an argument.
  
    See [Ember.Templates.helpers.action](/ember/release/classes/Ember.Templates.helpers/methods/action?anchor=action).
  
    @class Component
    @extends Ember.CoreView
    @uses Ember.TargetActionSupport
    @uses Ember.ClassNamesSupport
    @uses Ember.ActionSupport
    @uses Ember.ViewMixin
    @uses Ember.ViewStateSupport
    @public
  */

  var Component = _views.CoreView.extend(_views.ChildViewsSupport, _views.ViewStateSupport, _views.ClassNamesSupport, _runtime.TargetActionSupport, _views.ActionSupport, _views.ViewMixin, (_CoreView$extend = {
    isComponent: true,
    init: function init() {
      this._super.apply(this, arguments);
      this[IS_DISPATCHING_ATTRS] = false;
      this[DIRTY_TAG] = (0, _validator.createTag)();
      this[BOUNDS] = null;
      if (true /* DEBUG */ && this.renderer._destinedForDOM && this.tagName === '') {
        var eventNames = [];
        var eventDispatcher = (0, _owner.getOwner)(this).lookup('event_dispatcher:main');
        var events = eventDispatcher && eventDispatcher._finalEvents || {}; // tslint:disable-next-line:forin

        for (var key in events) {
          var methodName = events[key];
          if (typeof this[methodName] === 'function') {
            eventNames.push(methodName);
          }
        } // If in a tagless component, assert that no event handlers are defined
        (true && !(!eventNames.length) && (0, _debug.assert)( // tslint:disable-next-line:max-line-length
        "You can not define `" + eventNames + "` function(s) to handle DOM event in the `" + this + "` tagless component since it doesn't have any DOM element.", !eventNames.length));
      }
      (true && !(this.mouseEnter === undefined) && (0, _debug.deprecate)(this + ": Using `mouseEnter` event handler methods in components has been deprecated.", this.mouseEnter === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move',
        for: 'ember-source',
        since: {
          enabled: '3.13.0-beta.1'
        }
      }));
      (true && !(this.mouseLeave === undefined) && (0, _debug.deprecate)(this + ": Using `mouseLeave` event handler methods in components has been deprecated.", this.mouseLeave === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move',
        for: 'ember-source',
        since: {
          enabled: '3.13.0-beta.1'
        }
      }));
      (true && !(this.mouseMove === undefined) && (0, _debug.deprecate)(this + ": Using `mouseMove` event handler methods in components has been deprecated.", this.mouseMove === undefined, {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_component-mouseenter-leave-move',
        for: 'ember-source',
        since: {
          enabled: '3.13.0-beta.1'
        }
      }));
    },
    rerender: function rerender() {
      (0, _validator.dirtyTag)(this[DIRTY_TAG]);
      this._super();
    }
  }, _CoreView$extend[_metal.PROPERTY_DID_CHANGE] = function (key, value) {
    if (this[IS_DISPATCHING_ATTRS]) {
      return;
    }
    var args = this[ARGS];
    var reference = args !== undefined ? args[key] : undefined;
    if (reference !== undefined && (0, _reference.isUpdatableRef)(reference)) {
      (0, _reference.updateRef)(reference, arguments.length === 2 ? value : (0, _metal.get)(this, key));
    }
  }, _CoreView$extend.getAttr = function getAttr(key) {
    // TODO Intimate API should be deprecated
    return this.get(key);
  }, _CoreView$extend.readDOMAttr = function readDOMAttr(name) {
    // TODO revisit this
    var _element = (0, _views.getViewElement)(this);
    (true && !(_element !== null) && (0, _debug.assert)("Cannot call `readDOMAttr` on " + this + " which does not have an element", _element !== null));
    var element = _element;
    var isSVG = element.namespaceURI === "http://www.w3.org/2000/svg"
    /* SVG */;

    var _normalizeProperty = (0, _runtime2.normalizeProperty)(element, name),
      type = _normalizeProperty.type,
      normalized = _normalizeProperty.normalized;
    if (isSVG || type === 'attr') {
      return element.getAttribute(normalized);
    }
    return element[normalized];
  }, _CoreView$extend.didReceiveAttrs = function didReceiveAttrs() {}, _CoreView$extend.didRender = function didRender() {}, _CoreView$extend.willRender = function willRender() {}, _CoreView$extend.didUpdateAttrs = function didUpdateAttrs() {}, _CoreView$extend.willUpdate = function willUpdate() {}, _CoreView$extend.didUpdate = function didUpdate() {}, _CoreView$extend));
  _exports.Component = Component;
  Component.toString = function () {
    return '@ember/component';
  };
  Component.reopenClass({
    isComponentFactory: true,
    positionalParams: []
  });
  var layout = (0, _opcodeCompiler.templateFactory)({
    "id": "3IKjaxWN",
    "block": "{\"symbols\":[],\"statements\":[],\"hasEval\":false,\"upvars\":[]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/empty.hbs"
  });

  /**
  @module @ember/component
  */

  /**
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `checkbox`.
  
    See [Ember.Templates.helpers.input](/ember/release/classes/Ember.Templates.helpers/methods/input?anchor=input)  for usage details.
  
    ## Direct manipulation of `checked`
  
    The `checked` attribute of an `Checkbox` object should always be set
    through the Ember object or by interacting with its rendered element
    representation via the mouse, keyboard, or touch. Updating the value of the
    checkbox via jQuery will result in the checked value of the object and its
    element losing synchronization.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied.
  
    @class Checkbox
    @extends Component
    @public
  */

  var Checkbox = Component.extend({
    layout: layout,
    /**
      By default, this component will add the `ember-checkbox` class to the component's element.
         @property classNames
      @type Array | String
      @default ['ember-checkbox']
      @public
     */
    classNames: ['ember-checkbox'],
    tagName: 'input',
    /**
      By default this component will forward a number of arguments to attributes on the the
      component's element:
         * indeterminate
      * disabled
      * tabindex
      * name
      * autofocus
      * required
      * form
         When invoked with curly braces, this is the exhaustive list of HTML attributes you can
      customize (i.e. `{{input type="checkbox" disabled=true}}`).
         When invoked with angle bracket invocation, this list is irrelevant, because you can use HTML
      attribute syntax to customize the element (i.e.
      `<Input @type="checkbox" disabled data-custom="custom value" />`). However, `@type` and
      `@checked` must be passed as named arguments, not attributes.
         @property attributeBindings
      @type Array | String
      @default ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form']
      @public
    */
    attributeBindings: ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form'],
    /**
      Sets the `type` attribute of the `Checkbox`'s element
         @property disabled
      @default false
      @private
     */
    type: 'checkbox',
    /**
      Sets the `disabled` attribute of the `Checkbox`'s element
         @property disabled
      @default false
      @public
     */
    disabled: false,
    /**
      Corresponds to the `indeterminate` property of the `Checkbox`'s element
         @property disabled
      @default false
      @public
     */
    indeterminate: false,
    /**
      Whenever the checkbox is inserted into the DOM, perform initialization steps, which include
      setting the indeterminate property if needed.
         If this method is overridden, `super` must be called.
         @method
      @public
     */
    didInsertElement: function didInsertElement() {
      this._super.apply(this, arguments);
      this.element.indeterminate = Boolean(this.indeterminate);
    },
    /**
      Whenever the `change` event is fired on the checkbox, update its `checked` property to reflect
      whether the checkbox is checked.
         If this method is overridden, `super` must be called.
         @method
      @public
     */
    change: function change() {
      (0, _metal.set)(this, 'checked', this.element.checked);
    }
  });
  _exports.Checkbox = Checkbox;
  if (true /* DEBUG */) {
    var UNSET = {};
    Checkbox.reopen({
      value: UNSET,
      didReceiveAttrs: function didReceiveAttrs() {
        this._super();
        (true && !(!(this.type === 'checkbox' && this.value !== UNSET)) && (0, _debug.assert)("`<Input @type='checkbox' @value={{...}} />` is not supported; " + "please use `<Input @type='checkbox' @checked={{...}} />` instead.", !(this.type === 'checkbox' && this.value !== UNSET)));
      }
    });
  }
  Checkbox.toString = function () {
    return '@ember/component/checkbox';
  };

  /**
  @module @ember/component
  */
  var inputTypes = _browserEnvironment.hasDOM ? Object.create(null) : null;
  function canSetTypeOfInput(type) {
    // if running in outside of a browser always return
    // the original type
    if (!_browserEnvironment.hasDOM) {
      return Boolean(type);
    }
    if (type in inputTypes) {
      return inputTypes[type];
    }
    var inputTypeTestElement = document.createElement('input');
    try {
      inputTypeTestElement.type = type;
    } catch (e) {// ignored
    }
    return inputTypes[type] = inputTypeTestElement.type === type;
  }
  /**
    The internal class used to create text inputs when the `Input` component is used with `type` of `text`.
  
    See [Ember.Templates.components.Input](/ember/release/classes/Ember.Templates.components/methods/Input?anchor=Input) for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied.
  
    @class TextField
    @extends Component
    @uses Ember.TextSupport
    @public
  */

  var TextField = Component.extend(_views.TextSupport, {
    layout: layout,
    /**
      By default, this component will add the `ember-text-field` class to the component's element.
         @property classNames
      @type Array | String
      @default ['ember-text-field']
      @public
     */
    classNames: ['ember-text-field'],
    tagName: 'input',
    /**
      By default this component will forward a number of arguments to attributes on the the
      component's element:
         * accept
      * autocomplete
      * autosave
      * dir
      * formaction
      * formenctype
      * formmethod
      * formnovalidate
      * formtarget
      * height
      * inputmode
      * lang
      * list
      * type
      * max
      * min
      * multiple
      * name
      * pattern
      * size
      * step
      * value
      * width
         When invoked with `{{input type="text"}}`, you can only customize these attributes. When invoked
      with `<Input @type="text" />`, you can just use HTML attributes directly.
         @property attributeBindings
      @type Array | String
      @default ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'type', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'value', 'width']
      @public
    */
    attributeBindings: ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'type', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'value', 'width'],
    /**
      As the user inputs text, this property is updated to reflect the `value` property of the HTML
      element.
         @property value
      @type String
      @default ""
      @public
    */
    value: '',
    /**
      The `type` attribute of the input element.
         @property type
      @type String
      @default "text"
      @public
    */
    type: (0, _metal.computed)({
      get: function get() {
        return 'text';
      },
      set: function set(_key, value) {
        var type = 'text';
        if (canSetTypeOfInput(value)) {
          type = value;
        }
        return type;
      }
    }),
    /**
      The `size` of the text field in characters.
         @property size
      @type String
      @default null
      @public
    */
    size: null,
    /**
      The `pattern` attribute of input element.
         @property pattern
      @type String
      @default null
      @public
    */
    pattern: null,
    /**
      The `min` attribute of input element used with `type="number"` or `type="range"`.
         @property min
      @type String
      @default null
      @since 1.4.0
      @public
    */
    min: null,
    /**
      The `max` attribute of input element used with `type="number"` or `type="range"`.
         @property max
      @type String
      @default null
      @since 1.4.0
      @public
    */
    max: null
  });
  _exports.TextField = TextField;
  TextField.toString = function () {
    return '@ember/component/text-field';
  };

  /**
  @module @ember/component
  */
  /**
    The `Textarea` component inserts a new instance of `<textarea>` tag into the template.
  
    The `@value` argument provides the content of the `<textarea>`.
  
    This template:
  
    ```handlebars
    <Textarea @value="A bunch of text" />
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      A bunch of text
    </textarea>
    ```
  
    The `@value` argument is two-way bound. If the user types text into the textarea, the `@value`
    argument is updated. If the `@value` argument is updated, the text in the textarea is updated.
  
    In the following example, the `writtenWords` property on the component will be updated as the user
    types 'Lots of text' into the text area of their browser's window.
  
    ```app/components/word-editor.js
    import Component from '@glimmer/component';
    import { tracked } from '@glimmer/tracking';
  
    export default class WordEditorComponent extends Component {
      @tracked writtenWords = "Lots of text that IS bound";
    }
    ```
  
    ```handlebars
    <Textarea @value={{writtenWords}} />
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    If you wanted a one way binding, you could use the `<textarea>` element directly, and use the
    `value` DOM property and the `input` event.
  
    ### Actions
  
    The `Textarea` component takes a number of arguments with callbacks that are invoked in
    response to user events.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
  
    These callbacks are passed to `Textarea` like this:
  
    ```handlebars
    <Textarea @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    ## Classic Invocation Syntax
  
    The `Textarea` component can also be invoked using curly braces, just like any other Ember
    component.
  
    For example, this is an invocation using angle-bracket notation:
  
    ```handlebars
    <Textarea @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    You could accomplish the same thing using classic invocation:
  
    ```handlebars
    {{textarea value=this.searchWord enter=this.query}}
    ```
  
    The main difference is that angle-bracket invocation supports any HTML attribute using HTML
    attribute syntax, because attributes and arguments have different syntax when using angle-bracket
    invocation. Curly brace invocation, on the other hand, only has a single syntax for arguments,
    and components must manually map attributes onto component arguments.
  
    When using classic invocation with `{{textarea}}`, only the following attributes are mapped onto
    arguments:
  
    * rows
    * cols
    * name
    * selectionEnd
    * selectionStart
    * autocomplete
    * wrap
    * lang
    * dir
    * value
  
    ## Classic `layout` and `layoutName` properties
  
    Because HTML `textarea` elements do not contain inner HTML the `layout` and
    `layoutName` properties will not be applied.
  
    @method Textarea
    @for Ember.Templates.components
    @see {TextArea}
    @public
  */

  /**
    See Ember.Templates.components.Textarea.
  
    @method textarea
    @for Ember.Templates.helpers
    @see {Ember.Templates.components.textarea}
    @public
  */

  /**
    The internal representation used for `Textarea` invocations.
  
    @class TextArea
    @extends Component
    @see {Ember.Templates.components.Textarea}
    @uses Ember.TextSupport
    @public
  */

  var TextArea = Component.extend(_views.TextSupport, {
    classNames: ['ember-text-area'],
    layout: layout,
    tagName: 'textarea',
    attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'autocomplete', 'wrap', 'lang', 'dir', 'value'],
    rows: null,
    cols: null
  });
  _exports.TextArea = TextArea;
  TextArea.toString = function () {
    return '@ember/component/text-area';
  };
  var layout$1 = (0, _opcodeCompiler.templateFactory)({
    "id": "ddnfgiDJ",
    "block": "{\"symbols\":[\"&default\"],\"statements\":[[6,[37,0],[[27,[32,1]]],null,[[\"default\",\"else\"],[{\"statements\":[[18,1,null]],\"parameters\":[]},{\"statements\":[[1,[32,0,[\"linkTitle\"]]]],\"parameters\":[]}]]]],\"hasEval\":false,\"upvars\":[\"if\"]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/link-to.hbs"
  });

  /**
  @module ember
  */
  /**
    The `LinkTo` component renders a link to the supplied `routeName` passing an optionally
    supplied model to the route as its `model` context of the route. The block for `LinkTo`
    becomes the contents of the rendered element:
  
    ```handlebars
    <LinkTo @route='photoGallery'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    This will result in:
  
    ```html
    <a href="/hamster-photos">
      Great Hamster Photos
    </a>
    ```
  
    ### Disabling the `LinkTo` component
  
    The `LinkTo` component can be disabled by using the `disabled` argument. A disabled link
    doesn't result in a transition when activated, and adds the `disabled` class to the `<a>`
    element.
  
    (The class name to apply to the element can be overridden by using the `disabledClass`
    argument)
  
    ```handlebars
    <LinkTo @route='photoGallery' @disabled={{true}}>
      Great Hamster Photos
    </LinkTo>
    ```
  
    ### Handling `href`
  
    `<LinkTo>` will use your application's Router to fill the element's `href` property with a URL
    that matches the path to the supplied `routeName`.
  
    ### Handling current route
  
    The `LinkTo` component will apply a CSS class name of 'active' when the application's current
    route matches the supplied routeName. For example, if the application's current route is
    'photoGallery.recent', then the following invocation of `LinkTo`:
  
    ```handlebars
    <LinkTo @route='photoGallery.recent'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    will result in
  
    ```html
    <a href="/hamster-photos/this-week" class="active">
      Great Hamster Photos
    </a>
    ```
  
    The CSS class used for active classes can be customized by passing an `activeClass` argument:
  
    ```handlebars
    <LinkTo @route='photoGallery.recent' @activeClass="current-url">
      Great Hamster Photos
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/this-week" class="current-url">
      Great Hamster Photos
    </a>
    ```
  
    ### Keeping a link active for other routes
  
    If you need a link to be 'active' even when it doesn't match the current route, you can use the
    `current-when` argument.
  
    ```handlebars
    <LinkTo @route='photoGallery' @current-when='photos'>
      Photo Gallery
    </LinkTo>
    ```
  
    This may be helpful for keeping links active for:
  
    * non-nested routes that are logically related
    * some secondary menu approaches
    * 'top navigation' with 'sub navigation' scenarios
  
    A link will be active if `current-when` is `true` or the current
    route is the route this link would transition to.
  
    To match multiple routes 'space-separate' the routes:
  
    ```handlebars
    <LinkTo @route='gallery' @current-when='photos drawings paintings'>
      Art Gallery
    </LinkTo>
    ```
  
    ### Supplying a model
  
    An optional `model` argument can be used for routes whose
    paths contain dynamic segments. This argument will become
    the model context of the linked route:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", {path: "hamster-photos/:photo_id"});
    });
    ```
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{this.aPhoto}}>
      {{aPhoto.title}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    ### Supplying multiple models
  
    For deep-linking to route paths that contain multiple
    dynamic segments, the `models` argument can be used.
  
    As the router transitions through the route path, each
    supplied model argument will become the context for the
    route with the dynamic segments:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" }, function() {
        this.route("comment", {path: "comments/:comment_id"});
      });
    });
    ```
  
    This argument will become the model context of the linked route:
  
    ```handlebars
    <LinkTo @route='photoGallery.comment' @models={{array this.aPhoto this.comment}}>
      {{comment.body}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42/comments/718">
      A+++ would snuggle again.
    </a>
    ```
  
    ### Supplying an explicit dynamic segment value
  
    If you don't have a model object available to pass to `LinkTo`,
    an optional string or integer argument can be passed for routes whose
    paths contain dynamic segments. This argument will become the value
    of the dynamic segment:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" });
    });
    ```
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{aPhotoId}}>
      {{this.aPhoto.title}}
    </LinkTo>
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    When transitioning into the linked route, the `model` hook will
    be triggered with parameters including this passed identifier.
  
    ### Allowing Default Action
  
    By default the `<LinkTo>` component prevents the default browser action by calling
    `preventDefault()` to avoid reloading the browser page.
  
    If you need to trigger a full browser reload pass `@preventDefault={{false}}`:
  
    ```handlebars
    <LinkTo @route='photoGallery' @model={{this.aPhotoId}} @preventDefault={{false}}>
      {{this.aPhotoId.title}}
    </LinkTo>
    ```
  
    ### Supplying a `tagName`
  
    By default `<LinkTo>` renders an `<a>` element. This can be overridden for a single use of
    `<LinkTo>` by supplying a `tagName` argument:
  
    ```handlebars
    <LinkTo @route='photoGallery' @tagName='li'>
      Great Hamster Photos
    </LinkTo>
    ```
  
    This produces:
  
    ```html
    <li>
      Great Hamster Photos
    </li>
    ```
  
    In general, this is not recommended. Instead, you can use the `transition-to` helper together
    with a click event handler on the HTML tag of your choosing.
  
    ### Supplying query parameters
  
    If you need to add optional key-value pairs that appear to the right of the ? in a URL,
    you can use the `query` argument.
  
    ```handlebars
    <LinkTo @route='photoGallery' @query={{hash page=1 per_page=20}}>
      Great Hamster Photos
    </LinkTo>
    ```
  
    This will result in:
  
    ```html
    <a href="/hamster-photos?page=1&per_page=20">
      Great Hamster Photos
    </a>
    ```
  
    @for Ember.Templates.components
    @method LinkTo
    @see {LinkComponent}
    @public
  */

  /**
    @module @ember/routing
  */

  /**
    See [Ember.Templates.components.LinkTo](/ember/release/classes/Ember.Templates.components/methods/input?anchor=LinkTo).
  
    @for Ember.Templates.helpers
    @method link-to
    @see {Ember.Templates.components.LinkTo}
    @public
  **/

  /**
    `LinkComponent` is the internal component invoked with `<LinkTo>` or `{{link-to}}`.
  
    @class LinkComponent
    @extends Component
    @see {Ember.Templates.components.LinkTo}
    @public
  **/

  var UNDEFINED = Object.freeze({
    toString: function toString() {
      return 'UNDEFINED';
    }
  });
  var EMPTY_QUERY_PARAMS = Object.freeze({});
  var LinkComponent = Component.extend({
    layout: layout$1,
    tagName: 'a',
    /**
      @property route
      @public
    */
    route: UNDEFINED,
    /**
      @property model
      @public
    */
    model: UNDEFINED,
    /**
      @property models
      @public
    */
    models: UNDEFINED,
    /**
      @property query
      @public
    */
    query: UNDEFINED,
    /**
      Used to determine when this `LinkComponent` is active.
         @property current-when
      @public
    */
    'current-when': null,
    /**
      Sets the `title` attribute of the `LinkComponent`'s HTML element.
         @property title
      @default null
      @public
    **/
    title: null,
    /**
      Sets the `rel` attribute of the `LinkComponent`'s HTML element.
         @property rel
      @default null
      @public
    **/
    rel: null,
    /**
      Sets the `tabindex` attribute of the `LinkComponent`'s HTML element.
         @property tabindex
      @default null
      @public
    **/
    tabindex: null,
    /**
      Sets the `target` attribute of the `LinkComponent`'s HTML element.
         @since 1.8.0
      @property target
      @default null
      @public
    **/
    target: null,
    /**
      The CSS class to apply to `LinkComponent`'s element when its `active`
      property is `true`.
         @property activeClass
      @type String
      @default active
      @public
    **/
    activeClass: 'active',
    /**
      The CSS class to apply to `LinkComponent`'s element when its `loading`
      property is `true`.
         @property loadingClass
      @type String
      @default loading
      @private
    **/
    loadingClass: 'loading',
    /**
      The CSS class to apply to a `LinkComponent`'s element when its `disabled`
      property is `true`.
         @property disabledClass
      @type String
      @default disabled
      @private
    **/
    disabledClass: 'disabled',
    /**
      Determines whether the `LinkComponent` will trigger routing via
      the `replaceWith` routing strategy.
         @property replace
      @type Boolean
      @default false
      @public
    **/
    replace: false,
    /**
      By default this component will forward `href`, `title`, `rel`, `tabindex`, and `target`
      arguments to attributes on the component's element. When invoked with `{{link-to}}`, you can
      only customize these attributes. When invoked with `<LinkTo>`, you can just use HTML
      attributes directly.
         @property attributeBindings
      @type Array | String
      @default ['title', 'rel', 'tabindex', 'target']
      @public
    */
    attributeBindings: ['href', 'title', 'rel', 'tabindex', 'target'],
    /**
      By default this component will set classes on its element when any of the following arguments
      are truthy:
         * active
      * loading
      * disabled
         When these arguments are truthy, a class with the same name will be set on the element. When
      falsy, the associated class will not be on the element.
         @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled', 'ember-transitioning-in', 'ember-transitioning-out']
      @public
    */
    classNameBindings: ['active', 'loading', 'disabled', 'transitioningIn', 'transitioningOut'],
    /**
      By default this component responds to the `click` event. When the component element is an
      `<a>` element, activating the link in another way, such as using the keyboard, triggers the
      click event.
         @property eventName
      @type String
      @default click
      @private
    */
    eventName: 'click',
    // this is doc'ed here so it shows up in the events
    // section of the API documentation, which is where
    // people will likely go looking for it.
    /**
      Triggers the `LinkComponent`'s routing behavior. If
      `eventName` is changed to a value other than `click`
      the routing behavior will trigger on that custom event
      instead.
         @event click
      @private
    */
    /**
      An overridable method called when `LinkComponent` objects are instantiated.
         Example:
         ```app/components/my-link.js
      import LinkComponent from '@ember/routing/link-component';
         export default LinkComponent.extend({
        init() {
          this._super(...arguments);
          console.log('Event is ' + this.get('eventName'));
        }
      });
      ```
         NOTE: If you do override `init` for a framework class like `Component`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
         @method init
      @private
    */
    init: function init() {
      this._super.apply(this, arguments);
      this.assertLinkToOrigin(); // Map desired event name to invoke function

      var eventName = this.eventName;
      this.on(eventName, this, this._invoke);
    },
    _routing: (0, _service.inject)('-routing'),
    _currentRoute: (0, _metal.alias)('_routing.currentRouteName'),
    _currentRouterState: (0, _metal.alias)('_routing.currentState'),
    _targetRouterState: (0, _metal.alias)('_routing.targetState'),
    _isEngine: (0, _metal.computed)(function () {
      return (0, _engine.getEngineParent)((0, _owner.getOwner)(this)) !== undefined;
    }),
    _engineMountPoint: (0, _metal.computed)(function () {
      return (0, _owner.getOwner)(this).mountPoint;
    }),
    _route: (0, _metal.computed)('route', '_currentRouterState', function computeLinkToComponentRoute() {
      var route = this.route;
      return route === UNDEFINED ? this._currentRoute : this._namespaceRoute(route);
    }),
    _models: (0, _metal.computed)('model', 'models', function computeLinkToComponentModels() {
      var model = this.model,
        models = this.models;
      (true && !(model === UNDEFINED || models === UNDEFINED) && (0, _debug.assert)('You cannot provide both the `@model` and `@models` arguments to the <LinkTo> component.', model === UNDEFINED || models === UNDEFINED));
      if (model !== UNDEFINED) {
        return [model];
      } else if (models !== UNDEFINED) {
        (true && !(Array.isArray(models)) && (0, _debug.assert)('The `@models` argument must be an array.', Array.isArray(models)));
        return models;
      } else {
        return [];
      }
    }),
    _query: (0, _metal.computed)('query', function computeLinkToComponentQuery() {
      var query = this.query;
      if (query === UNDEFINED) {
        return EMPTY_QUERY_PARAMS;
      } else {
        return (0, _polyfills.assign)({}, query);
      }
    }),
    /**
      Accessed as a classname binding to apply the component's `disabledClass`
      CSS `class` to the element when the link is disabled.
         When `true`, interactions with the element will not trigger route changes.
      @property disabled
      @private
    */
    disabled: (0, _metal.computed)({
      get: function get(_key) {
        // always returns false for `get` because (due to the `set` just below)
        // the cached return value from the set will prevent this getter from _ever_
        // being called after a set has occurred
        return false;
      },
      set: function set(_key, value) {
        this._isDisabled = value;
        return value ? this.disabledClass : false;
      }
    }),
    /**
      Accessed as a classname binding to apply the component's `activeClass`
      CSS `class` to the element when the link is active.
         This component is considered active when its `currentWhen` property is `true`
      or the application's current route is the route this component would trigger
      transitions into.
         The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
         @property active
      @private
    */
    active: (0, _metal.computed)('activeClass', '_active', function computeLinkToComponentActiveClass() {
      return this._active ? this.activeClass : false;
    }),
    _active: (0, _metal.computed)('_currentRouterState', '_route', '_models', '_query', 'loading', 'current-when', function computeLinkToComponentActive() {
      var state = this._currentRouterState;
      if (state) {
        return this._isActive(state);
      } else {
        return false;
      }
    }),
    willBeActive: (0, _metal.computed)('_currentRouterState', '_targetRouterState', '_route', '_models', '_query', 'loading', 'current-when', function computeLinkToComponentWillBeActive() {
      var current = this._currentRouterState,
        target = this._targetRouterState;
      if (current === target) {
        return;
      }
      return this._isActive(target);
    }),
    assertLinkToOrigin: function assertLinkToOrigin() {
      (true && !(!this._isEngine || this._engineMountPoint !== undefined) && (0, _debug.assert)('You attempted to use the <LinkTo> component within a routeless engine, this is not supported. ' + 'If you are using the ember-engines addon, use the <LinkToExternal> component instead. ' + 'See https://ember-engines.com/docs/links for more info.', !this._isEngine || this._engineMountPoint !== undefined));
    },
    _isActive: function _isActive(routerState) {
      var _this = this;
      if (this.loading) {
        return false;
      }
      var currentWhen = this['current-when'];
      if (typeof currentWhen === 'boolean') {
        return currentWhen;
      }
      var models = this._models,
        routing = this._routing;
      if (typeof currentWhen === 'string') {
        return currentWhen.split(' ').some(function (route) {
          return routing.isActiveForRoute(models, undefined, _this._namespaceRoute(route), routerState);
        });
      } else {
        return routing.isActiveForRoute(models, this._query, this._route, routerState);
      }
    },
    transitioningIn: (0, _metal.computed)('_active', 'willBeActive', function computeLinkToComponentTransitioningIn() {
      if (this.willBeActive === true && !this._active) {
        return 'ember-transitioning-in';
      } else {
        return false;
      }
    }),
    transitioningOut: (0, _metal.computed)('_active', 'willBeActive', function computeLinkToComponentTransitioningOut() {
      if (this.willBeActive === false && this._active) {
        return 'ember-transitioning-out';
      } else {
        return false;
      }
    }),
    _namespaceRoute: function _namespaceRoute(route) {
      var mountPoint = this._engineMountPoint;
      if (mountPoint === undefined) {
        return route;
      } else if (route === 'application') {
        return mountPoint;
      } else {
        return mountPoint + "." + route;
      }
    },
    /**
      Event handler that invokes the link, activating the associated route.
         @method _invoke
      @param {Event} event
      @private
    */
    _invoke: function _invoke(event) {
      if (!(0, _views.isSimpleClick)(event)) {
        return true;
      }
      var bubbles = this.bubbles,
        preventDefault = this.preventDefault;
      var target = this.element.target;
      var isSelf = !target || target === '_self';
      if (preventDefault !== false && isSelf) {
        event.preventDefault();
      }
      if (bubbles === false) {
        event.stopPropagation();
      }
      if (this._isDisabled) {
        return false;
      }
      if (this.loading) {
        // tslint:disable-next-line:max-line-length
        (true && (0, _debug.warn)('This link is in an inactive loading state because at least one of its models ' + 'currently has a null/undefined value, or the provided route name is invalid.', false, {
          id: 'ember-glimmer.link-to.inactive-loading-state'
        }));
        return false;
      }
      if (!isSelf) {
        return false;
      }
      var routeName = this._route,
        models = this._models,
        queryParams = this._query,
        shouldReplace = this.replace;
      var payload = {
        queryParams: queryParams,
        routeName: routeName
      };
      (0, _instrumentation.flaggedInstrument)('interaction.link-to', payload, this._generateTransition(payload, routeName, models, queryParams, shouldReplace));
      return false;
    },
    _generateTransition: function _generateTransition(payload, qualifiedRouteName, models, queryParams, shouldReplace) {
      var routing = this._routing;
      return function () {
        payload.transition = routing.transitionTo(qualifiedRouteName, models, queryParams, shouldReplace);
      };
    },
    /**
      Sets the element's `href` attribute to the url for
      the `LinkComponent`'s targeted route.
         If the `LinkComponent`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
         @property href
      @private
    */
    href: (0, _metal.computed)('_currentRouterState', '_route', '_models', '_query', 'tagName', 'loading', 'loadingHref', function computeLinkToComponentHref() {
      if (this.tagName !== 'a') {
        return;
      }
      if (this.loading) {
        return this.loadingHref;
      }
      var route = this._route,
        models = this._models,
        query = this._query,
        routing = this._routing;
      if (true /* DEBUG */) {
        /*
         * Unfortunately, to get decent error messages, we need to do this.
         * In some future state we should be able to use a "feature flag"
         * which allows us to strip this without needing to call it twice.
         *
         * if (isDebugBuild()) {
         *   // Do the useful debug thing, probably including try/catch.
         * } else {
         *   // Do the performant thing.
         * }
         */
        try {
          return routing.generateURL(route, models, query);
        } catch (e) {
          // tslint:disable-next-line:max-line-length
          (true && !(false) && (0, _debug.assert)("You attempted to generate a link for the \"" + this.route + "\" route, but did not " + "pass the models required for generating its dynamic segments. " + e.message));
        }
      } else {
        return routing.generateURL(route, models, query);
      }
    }),
    loading: (0, _metal.computed)('_route', '_modelsAreLoaded', 'loadingClass', function computeLinkToComponentLoading() {
      var route = this._route,
        loaded = this._modelsAreLoaded;
      if (!loaded || route === null || route === undefined) {
        return this.loadingClass;
      }
    }),
    _modelsAreLoaded: (0, _metal.computed)('_models', function computeLinkToComponentModelsAreLoaded() {
      var models = this._models;
      for (var i = 0; i < models.length; i++) {
        var model = models[i];
        if (model === null || model === undefined) {
          return false;
        }
      }
      return true;
    }),
    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
         @property loadingHref
      @type String
      @default #
      @private
    */
    loadingHref: '#',
    didReceiveAttrs: function didReceiveAttrs() {
      var disabledWhen = this.disabledWhen;
      if (disabledWhen !== undefined) {
        this.set('disabled', disabledWhen);
      }
      var params = this.params;
      if (!params || params.length === 0) {
        (true && !(!(this.route === UNDEFINED && this.model === UNDEFINED && this.models === UNDEFINED && this.query === UNDEFINED)) && (0, _debug.assert)('You must provide at least one of the `@route`, `@model`, `@models` or `@query` argument to `<LinkTo>`.', !(this.route === UNDEFINED && this.model === UNDEFINED && this.models === UNDEFINED && this.query === UNDEFINED)));
        var models = this._models;
        if (models.length > 0) {
          var lastModel = models[models.length - 1];
          if (typeof lastModel === 'object' && lastModel !== null && lastModel.isQueryParams) {
            this.query = lastModel.values;
            models.pop();
          }
        }
        return;
      }
      params = params.slice(); // Process the positional arguments, in order.
      // 1. Inline link title comes first, if present.

      if (!this[HAS_BLOCK]) {
        this.set('linkTitle', params.shift());
      } // 2. The last argument is possibly the `query` object.

      var queryParams = params[params.length - 1];
      if (queryParams && queryParams.isQueryParams) {
        this.set('query', params.pop().values);
      } else {
        this.set('query', UNDEFINED);
      } // 3. If there is a `route`, it is now at index 0.

      if (params.length === 0) {
        this.set('route', UNDEFINED);
      } else {
        this.set('route', params.shift());
      } // 4. Any remaining indices (if any) are `models`.

      this.set('model', UNDEFINED);
      this.set('models', params);
    }
  });
  _exports.LinkComponent = LinkComponent;
  LinkComponent.toString = function () {
    return '@ember/routing/link-component';
  };
  LinkComponent.reopenClass({
    positionalParams: 'params'
  });
  function convertToInt(prop) {
    if (typeof prop === 'symbol') return null;
    var num = Number(prop);
    if (isNaN(num)) return null;
    return num % 1 === 0 ? num : null;
  }
  function tagForNamedArg(namedArgs, key) {
    return (0, _validator.track)(function () {
      if (key in namedArgs) {
        (0, _reference.valueForRef)(namedArgs[key]);
      }
    });
  }
  function tagForPositionalArg(positionalArgs, key) {
    return (0, _validator.track)(function () {
      if (key === '[]') {
        // consume all of the tags in the positional array
        positionalArgs.forEach(_reference.valueForRef);
      }
      var parsed = convertToInt(key);
      if (parsed !== null && parsed < positionalArgs.length) {
        // consume the tag of the referenced index
        (0, _reference.valueForRef)(positionalArgs[parsed]);
      }
    });
  }
  var argsProxyFor;
  if (_utils.HAS_NATIVE_PROXY) {
    argsProxyFor = function argsProxyFor(capturedArgs, type) {
      var named = capturedArgs.named,
        positional = capturedArgs.positional;
      var getNamedTag = function getNamedTag(key) {
        return tagForNamedArg(named, key);
      };
      var getPositionalTag = function getPositionalTag(key) {
        return tagForPositionalArg(positional, key);
      };
      var namedHandler = {
        get: function get(_target, prop) {
          var ref = named[prop];
          if (ref !== undefined) {
            return (0, _reference.valueForRef)(ref);
          } else if (prop === _metal.CUSTOM_TAG_FOR) {
            return getNamedTag;
          }
        },
        has: function has(_target, prop) {
          return prop in named;
        },
        ownKeys: function ownKeys(_target) {
          return Object.keys(named);
        },
        isExtensible: function isExtensible() {
          return false;
        },
        getOwnPropertyDescriptor: function getOwnPropertyDescriptor(_target, prop) {
          (true && !(prop in named) && (0, _debug.assert)('args proxies do not have real property descriptors, so you should never need to call getOwnPropertyDescriptor yourself. This code exists for enumerability, such as in for-in loops and Object.keys()', prop in named));
          return {
            enumerable: true,
            configurable: true
          };
        }
      };
      var positionalHandler = {
        get: function get(target, prop) {
          if (prop === 'length') {
            return positional.length;
          }
          var parsed = convertToInt(prop);
          if (parsed !== null && parsed < positional.length) {
            return (0, _reference.valueForRef)(positional[parsed]);
          }
          if (prop === _metal.CUSTOM_TAG_FOR) {
            return getPositionalTag;
          }
          return target[prop];
        },
        isExtensible: function isExtensible() {
          return false;
        },
        has: function has(_target, prop) {
          var parsed = convertToInt(prop);
          return parsed !== null && parsed < positional.length;
        }
      };
      var namedTarget = Object.create(null);
      var positionalTarget = [];
      if (true /* DEBUG */) {
        var setHandler = function setHandler(_target, prop) {
          throw new Error("You attempted to set " + String(prop) + " on the arguments of a component, helper, or modifier. Arguments are immutable and cannot be updated directly, they always represent the values that is passed down. If you want to set default values, you should use a getter and local tracked state instead.");
        };
        var forInDebugHandler = function forInDebugHandler() {
          throw new Error("Object.keys() was called on the positional arguments array for a " + type + ", which is not supported. This function is a low-level function that should not need to be called for positional argument arrays. You may be attempting to iterate over the array using for...in instead of for...of.");
        };
        namedHandler.set = setHandler;
        positionalHandler.set = setHandler;
        positionalHandler.ownKeys = forInDebugHandler;
      }
      return {
        named: new Proxy(namedTarget, namedHandler),
        positional: new Proxy(positionalTarget, positionalHandler)
      };
    };
  } else {
    argsProxyFor = function argsProxyFor(capturedArgs, _type) {
      var named = capturedArgs.named,
        positional = capturedArgs.positional;
      var getNamedTag = function getNamedTag(key) {
        return tagForNamedArg(named, key);
      };
      var getPositionalTag = function getPositionalTag(key) {
        return tagForPositionalArg(positional, key);
      };
      var namedProxy = {};
      Object.defineProperty(namedProxy, _metal.CUSTOM_TAG_FOR, {
        configurable: false,
        enumerable: false,
        value: getNamedTag
      });
      Object.keys(named).forEach(function (name) {
        Object.defineProperty(namedProxy, name, {
          enumerable: true,
          configurable: true,
          get: function get() {
            return (0, _reference.valueForRef)(named[name]);
          }
        });
      });
      var positionalProxy = [];
      Object.defineProperty(positionalProxy, _metal.CUSTOM_TAG_FOR, {
        configurable: false,
        enumerable: false,
        value: getPositionalTag
      });
      positional.forEach(function (ref, index) {
        Object.defineProperty(positionalProxy, index, {
          enumerable: true,
          configurable: true,
          get: function get() {
            return (0, _reference.valueForRef)(ref);
          }
        });
      });
      if (true /* DEBUG */) {
        // Prevent mutations in development mode. This will not prevent the
        // proxy from updating, but will prevent assigning new values or pushing
        // for instance.
        Object.freeze(namedProxy);
        Object.freeze(positionalProxy);
      }
      return {
        named: namedProxy,
        positional: positionalProxy
      };
    };
  }

  /**
  @module @ember/helper
  */

  /**
    `capabilities` returns a capabilities configuration which can be used to modify
    the behavior of the manager. Manager capabilities _must_ be provided using the
    `capabilities` function, as the underlying implementation can change over time.
  
    The first argument to capabilities is a version string, which is the version of
    Ember that the capabilities were defined in. Ember can add new versions at any
    time, and these may have entirely different behaviors, but it will not remove
    old versions until the next major version.
  
    ```js
    capabilities('3.23');
    ```
  
    The second argument is an object of capabilities and boolean values indicating
    whether they are enabled or disabled.
  
    ```js
    capabilities('3.23', {
      hasValue: true,
      hasDestructor: true,
    });
    ```
  
    If no value is specified, then the default value will be used.
  
    ### `3.23` capabilities
  
    #### `hasDestroyable`
  
    - Default value: false
  
    Determines if the helper has a destroyable to include in the destructor
    hierarchy. If enabled, the `getDestroyable` hook will be called, and its result
    will be associated with the destroyable parent block.
  
    #### `hasValue`
  
    - Default value: false
  
    Determines if the helper has a value which can be used externally. The helper's
    `getValue` hook will be run whenever the value of the helper is accessed if this
    capability is enabled.
  
    @method capabilities
    @for @ember/helper
    @static
    @param {String} managerApiVersion The version of capabilities that are being used
    @param options The capabilities values
    @return {Capabilities} The capabilities object instance
    @public
  */

  function helperCapabilities(managerAPI, options) {
    if (options === void 0) {
      options = {};
    }
    (true && !(managerAPI === '3.23') && (0, _debug.assert)('Invalid helper manager compatibility specified', managerAPI === '3.23'));
    (true && !((options.hasValue || options.hasScheduledEffect) && !(options.hasValue && options.hasScheduledEffect)) && (0, _debug.assert)('You must pass either the `hasValue` OR the `hasScheduledEffect` capability when defining a helper manager. Passing neither, or both, is not permitted.', (options.hasValue || options.hasScheduledEffect) && !(options.hasValue && options.hasScheduledEffect)));
    (true && !(!options.hasScheduledEffect) && (0, _debug.assert)('The `hasScheduledEffect` capability has not yet been implemented for helper managers. Please pass `hasValue` instead', !options.hasScheduledEffect));
    return (0, _runtime2.buildCapabilities)({
      hasValue: Boolean(options.hasValue),
      hasDestroyable: Boolean(options.hasDestroyable),
      hasScheduledEffect: Boolean(options.hasScheduledEffect)
    });
  }
  /**
    Sets the helper manager for an object or function.
  
    ```js
    setHelperManager((owner) => new ClassHelperManager(owner), Helper)
    ```
  
    When a value is used as a helper in a template, the helper manager is looked up
    on the object by walking up its prototype chain and finding the first helper
    manager. This manager then receives the value and can create and manage an
    instance of a helper from it. This provides a layer of indirection that allows
    users to design high-level helper APIs, without Ember needing to worry about the
    details. High-level APIs can be experimented with and iterated on while the
    core of Ember helpers remains stable, and new APIs can be introduced gradually
    over time to existing code bases.
  
    `setHelperManager` receives two arguments:
  
    1. A factory function, which receives the `owner` and returns an instance of a
      helper manager.
    2. A helper definition, which is the object or function to associate the factory function with.
  
    The first time the object is looked up, the factory function will be called to
    create the helper manager. It will be cached, and in subsequent lookups the
    cached helper manager will be used instead.
  
    Only one helper manager is guaranteed to exist per `owner` and per usage of
    `setHelperManager`, so many helpers will end up using the same instance of the
    helper manager. As such, you should only store state that is related to the
    manager itself. If you want to store state specific to a particular helper
    definition, you should assign a unique helper manager to that helper. In
    general, most managers should either be stateless, or only have the `owner` they
    were created with as state.
  
    Helper managers must fulfill the following interface (This example uses
    [TypeScript interfaces](https://www.typescriptlang.org/docs/handbook/interfaces.html)
    for precision, you do not need to write helper managers using TypeScript):
  
    ```ts
    interface HelperManager<HelperStateBucket> {
      capabilities: HelperCapabilities;
  
      createHelper(definition: HelperDefinition, args: TemplateArgs): HelperStateBucket;
  
      getValue?(bucket: HelperStateBucket): unknown;
  
      runEffect?(bucket: HelperStateBucket): void;
  
      getDestroyable?(bucket: HelperStateBucket): object;
    }
    ```
  
    The capabilities property _must_ be provided using the `capabilities()` function
    imported from the same module as `setHelperManager`:
  
    ```js
    import { capabilities } from '@ember/helper';
  
    class MyHelperManager {
      capabilities = capabilities('3.21.0', { hasValue: true });
  
      // ...snip...
    }
    ```
  
    Below is a description of each of the methods on the interface and their
    functions.
  
    #### `createHelper`
  
    `createHelper` is a required hook on the HelperManager interface. The hook is
    passed the definition of the helper that is currently being created, and is
    expected to return a _state bucket_. This state bucket is what represents the
    current state of the helper, and will be passed to the other lifecycle hooks at
    appropriate times. It is not necessarily related to the definition of the
    helper itself - for instance, you could return an object _containing_ an
    instance of the helper:
  
    ```js
    class MyManager {
      createHelper(Definition, args) {
        return {
          instance: new Definition(args);
        };
      }
    }
    ```
  
    This allows the manager to store metadata that it doesn't want to expose to the
    user.
  
    This hook is _not_ autotracked - changes to tracked values used within this hook
    will _not_ result in a call to any of the other lifecycle hooks. This is because
    it is unclear what should happen if it invalidates, and rather than make a
    decision at this point, the initial API is aiming to allow as much expressivity
    as possible. This could change in the future with changes to capabilities and
    their behaviors.
  
    If users do want to autotrack some values used during construction, they can
    either create the instance of the helper in `runEffect` or `getValue`, or they
    can use the `cache` API to autotrack the `createHelper` hook themselves. This
    provides maximum flexibility and expressiveness to manager authors.
  
    This hook has the following timing semantics:
  
    **Always**
    - called as discovered during DOM construction
    - called in definition order in the template
  
    #### `getValue`
  
    `getValue` is an optional hook that should return the value of the helper. This
    is the value that is returned from the helper and passed into the template.
  
    This hook is called when the value is requested from the helper (e.g. when the
    template is rendering and the helper value is needed). The hook is autotracked,
    and will rerun whenever any tracked values used inside of it are updated.
    Otherwise it does not rerun.
  
    > Note: This means that arguments which are not _consumed_ within the hook will
    > not trigger updates.
  
    This hook is only called for helpers with the `hasValue` capability enabled.
    This hook has the following timing semantics:
  
    **Always**
    - called the first time the helper value is requested
    - called after autotracked state has changed
  
    **Never**
    - called if the `hasValue` capability is disabled
  
    #### `runEffect`
  
    `runEffect` is an optional hook that should run the effect that the helper is
    applying, setting it up or updating it.
  
    This hook is scheduled to be called some time after render and prior to paint.
    There is not a guaranteed, 1-to-1 relationship between a render pass and this
    hook firing. For instance, multiple render passes could occur, and the hook may
    only trigger once. It may also never trigger if it was dirtied in one render
    pass and then destroyed in the next.
  
    The hook is autotracked, and will rerun whenever any tracked values used inside
    of it are updated. Otherwise it does not rerun.
  
    The hook is also run during a time period where state mutations are _disabled_
    in Ember. Any tracked state mutation will throw an error during this time,
    including changes to tracked properties, changes made using `Ember.set`, updates
    to computed properties, etc. This is meant to prevent infinite rerenders and
    other antipatterns.
  
    This hook is only called for helpers with the `hasScheduledEffect` capability
    enabled. This hook is also not called in SSR currently, though this could be
    added as a capability in the future. It has the following timing semantics:
  
    **Always**
    - called after the helper was first created, if the helper has not been
      destroyed since creation
    - called after autotracked state has changed, if the helper has not been
      destroyed during render
  
    **Never**
    - called if the `hasScheduledEffect` capability is disabled
    - called in SSR
  
    #### `getDestroyable`
  
    `getDestroyable` is an optional hook that users can use to register a
    destroyable object for the helper. This destroyable will be registered to the
    containing block or template parent, and will be destroyed when it is destroyed.
    See the [Destroyables RFC](https://github.com/emberjs/rfcs/blob/master/text/0580-destroyables.md)
    for more details.
  
    `getDestroyable` is only called if the `hasDestroyable` capability is enabled.
  
    This hook has the following timing semantics:
  
    **Always**
    - called immediately after the `createHelper` hook is called
  
    **Never**
    - called if the `hasDestroyable` capability is disabled
  
    @method setHelperManager
    @for @ember/helper
    @static
    @param {Function} factory A factory function which receives an optional owner, and returns a helper manager
    @param {object} definition The definition to associate the manager factory with
    @return {object} The definition passed into setHelperManager
    @public
  */

  function hasValue(manager) {
    return manager.capabilities.hasValue;
  }
  function hasDestroyable(manager) {
    return manager.capabilities.hasDestroyable;
  }
  var ARGS_CACHES = true /* DEBUG */ ? new WeakMap() : undefined;
  function getArgs(proxy) {
    return (0, _validator.getValue)(true /* DEBUG */ ? ARGS_CACHES.get(proxy) : proxy.argsCache);
  }
  var SimpleArgsProxy = /*#__PURE__*/function () {
    function SimpleArgsProxy(context, computeArgs) {
      if (computeArgs === void 0) {
        computeArgs = function computeArgs() {
          return _runtime2.EMPTY_ARGS;
        };
      }
      var argsCache = (0, _validator.createCache)(function () {
        return computeArgs(context);
      });
      if (true /* DEBUG */) {
        ARGS_CACHES.set(this, argsCache);
        Object.freeze(this);
      } else {
        this.argsCache = argsCache;
      }
    }
    (0, _emberBabel.createClass)(SimpleArgsProxy, [{
      key: "named",
      get: function get() {
        return getArgs(this).named || _runtime2.EMPTY_NAMED;
      }
    }, {
      key: "positional",
      get: function get() {
        return getArgs(this).positional || _runtime2.EMPTY_POSITIONAL;
      }
    }]);
    return SimpleArgsProxy;
  }();
  /**
    The `invokeHelper` function can be used to create a helper instance in
    JavaScript.
  
    ```js
    // app/components/data-loader.js
    import Component from '@glimmer/component';
    import Helper from '@ember/component/helper';
    import { invokeHelper } from '@ember/helper';
  
    class PlusOne extends Helper {
      compute([num]) {
        return number + 1;
      }
    }
  
    export default class PlusOne extends Component {
      plusOne = invokeHelper(this, RemoteData, () => {
        return {
          positional: [this.args.number],
        };
      });
    }
    ```
    ```hbs
    {{this.plusOne.value}}
    ```
  
    It receives three arguments:
  
    * `context`: The parent context of the helper. When the parent is torn down and
      removed, the helper will be as well.
    * `definition`: The definition of the helper.
    * `computeArgs`: An optional function that produces the arguments to the helper.
      The function receives the parent context as an argument, and must return an
      object with a `positional` property that is an array and/or a `named`
      property that is an object.
  
    And it returns a Cache instance that contains the most recent value of the
    helper. You can access the helper using `getValue()` like any other cache. The
    cache is also destroyable, and using the `destroy()` function on it will cause
    the helper to be torn down.
  
    Note that using `getValue()` on helpers that have scheduled effects will not
    trigger the effect early. Effects will continue to run at their scheduled time.
  
    @method invokeHelper
    @for @ember/helper
    @static
    @param {object} context The parent context of the helper
    @param {object} definition The helper definition
    @param {Function} computeArgs An optional function that produces args
    @returns
    @public
  */
  function invokeHelper(context, definition, computeArgs) {
    (true && !(context !== null && typeof context === 'object') && (0, _debug.assert)("Expected a context object to be passed as the first parameter to invokeHelper, got " + context, context !== null && typeof context === 'object'));
    var owner = (0, _owner.getOwner)(context);
    var manager = (0, _runtime2.getHelperManager)(owner, definition); // TODO: figure out why assert isn't using the TS assert thing
    (true && !(manager) && (0, _debug.assert)("Expected a helper definition to be passed as the second parameter to invokeHelper, but no helper manager was found. The definition value that was passed was `" + (0, _utils.getDebugName)(definition) + "`. Did you use setHelperManager to associate a helper manager with this value?", manager));
    (true && !(!(0, _runtime2.isInternalHelper)(manager)) && (0, _debug.assert)('Invoke helper does not support internal helpers yet', !(0, _runtime2.isInternalHelper)(manager)));
    var args = new SimpleArgsProxy(context, computeArgs);
    var bucket = manager.createHelper(definition, args);
    var cache;
    if (hasValue(manager)) {
      cache = (0, _validator.createCache)(function () {
        (true && !(!(0, _runtime2.isDestroying)(cache) && !(0, _runtime2.isDestroyed)(cache)) && (0, _debug.assert)("You attempted to get the value of a helper after the helper was destroyed, which is not allowed", !(0, _runtime2.isDestroying)(cache) && !(0, _runtime2.isDestroyed)(cache)));
        return manager.getValue(bucket);
      });
      (0, _runtime2.associateDestroyableChild)(context, cache);
    } else {
      throw new Error('TODO: unreachable, to be implemented with hasScheduledEffect');
    }
    if (hasDestroyable(manager)) {
      var destroyable = manager.getDestroyable(bucket);
      (0, _runtime2.associateDestroyableChild)(cache, destroyable);
    }
    return cache;
  }
  function customHelper(manager, definition) {
    return function (vmArgs, vm) {
      var args = argsProxyFor(vmArgs.capture(), 'helper');
      var bucket = manager.createHelper(definition, args);
      if (hasDestroyable(manager)) {
        vm.associateDestroyable(manager.getDestroyable(bucket));
      }
      if (hasValue(manager)) {
        return (0, _reference.createComputeRef)(function () {
          return manager.getValue(bucket);
        }, null, true /* DEBUG */ && manager.getDebugName && manager.getDebugName(definition));
      } else {
        return _reference.UNDEFINED_REFERENCE;
      }
    };
  }

  /**
  @module @ember/component
  */
  var RECOMPUTE_TAG = (0, _utils.symbol)('RECOMPUTE_TAG');
  var CLASSIC_HELPER_MANAGERS = new _util._WeakSet();
  function isClassicHelperManager(obj) {
    return CLASSIC_HELPER_MANAGERS.has(obj);
  }
  /**
    Ember Helpers are functions that can compute values, and are used in templates.
    For example, this code calls a helper named `format-currency`:
  
    ```app/templates/application.hbs
    <Cost @cents={{230}} />
    ```
  
    ```app/components/cost.hbs
    <div>{{format-currency @cents currency="$"}}</div>
    ```
  
    Additionally a helper can be called as a nested helper.
    In this example, we show the formatted currency value if the `showMoney`
    named argument is truthy.
  
    ```handlebars
    {{if @showMoney (format-currency @cents currency="$")}}
    ```
  
    Helpers defined using a class must provide a `compute` function. For example:
  
    ```app/helpers/format-currency.js
    import Helper from '@ember/component/helper';
  
    export default class extends Helper {
      compute([cents], { currency }) {
        return `${currency}${cents * 0.01}`;
      }
    }
    ```
  
    Each time the input to a helper changes, the `compute` function will be
    called again.
  
    As instances, these helpers also have access to the container and will accept
    injected dependencies.
  
    Additionally, class helpers can call `recompute` to force a new computation.
  
    @class Helper
    @public
    @since 1.13.0
  */

  var Helper = _runtime.FrameworkObject.extend({
    init: function init() {
      this._super.apply(this, arguments);
      this[RECOMPUTE_TAG] = (0, _validator.createTag)();
    },
    /**
      On a class-based helper, it may be useful to force a recomputation of that
      helpers value. This is akin to `rerender` on a component.
         For example, this component will rerender when the `currentUser` on a
      session service changes:
         ```app/helpers/current-user-email.js
      import Helper from '@ember/component/helper'
      import { inject as service } from '@ember/service'
      import { observer } from '@ember/object'
         export default Helper.extend({
        session: service(),
           onNewUser: observer('session.currentUser', function() {
          this.recompute();
        }),
           compute() {
          return this.get('session.currentUser.email');
        }
      });
      ```
         @method recompute
      @public
      @since 1.13.0
    */
    recompute: function recompute() {
      var _this2 = this;
      (0, _runloop.join)(function () {
        return (0, _validator.dirtyTag)(_this2[RECOMPUTE_TAG]);
      });
    }
  });
  _exports.Helper = Helper;
  Helper.isHelperFactory = true;
  var ClassicHelperManager = /*#__PURE__*/function () {
    function ClassicHelperManager(owner) {
      this.capabilities = helperCapabilities('3.23', {
        hasValue: true,
        hasDestroyable: true
      });
      CLASSIC_HELPER_MANAGERS.add(this);
      var ownerInjection = {};
      (0, _owner.setOwner)(ownerInjection, owner);
      this.ownerInjection = ownerInjection;
    }
    var _proto = ClassicHelperManager.prototype;
    _proto.createHelper = function createHelper(definition, args) {
      var instance = definition.class === undefined ? definition.create(this.ownerInjection) : definition.create();
      return {
        instance: instance,
        args: args
      };
    };
    _proto.getDestroyable = function getDestroyable(_ref) {
      var instance = _ref.instance;
      return instance;
    };
    _proto.getValue = function getValue(_ref2) {
      var instance = _ref2.instance,
        args = _ref2.args;
      var ret;
      var positional = args.positional,
        named = args.named;
      if (true /* DEBUG */) {
        (0, _validator.deprecateMutationsInTrackingTransaction)(function () {
          ret = instance.compute(positional, named);
        });
      } else {
        ret = instance.compute(positional, named);
      }
      (0, _validator.consumeTag)(instance[RECOMPUTE_TAG]);
      return ret;
    };
    _proto.getDebugName = function getDebugName(definition) {
      return (0, _utils.getDebugName)(definition.class['prototype']);
    };
    return ClassicHelperManager;
  }();
  (0, _runtime2.setHelperManager)(function (owner) {
    return new ClassicHelperManager(owner);
  }, Helper); ///////////
  var Wrapper = /*#__PURE__*/function () {
    function Wrapper(compute) {
      this.compute = compute;
      this.isHelperFactory = true;
    }
    var _proto2 = Wrapper.prototype;
    _proto2.create = function create() {
      // needs new instance or will leak containers
      return {
        compute: this.compute
      };
    };
    return Wrapper;
  }();
  var SimpleClassicHelperManager = /*#__PURE__*/function () {
    function SimpleClassicHelperManager() {
      this.capabilities = helperCapabilities('3.23', {
        hasValue: true
      });
    }
    var _proto3 = SimpleClassicHelperManager.prototype;
    _proto3.createHelper = function createHelper(definition, args) {
      var compute = definition.compute;
      if (true /* DEBUG */) {
        return function () {
          var ret;
          (0, _validator.deprecateMutationsInTrackingTransaction)(function () {
            ret = compute.call(null, args.positional, args.named);
          });
          return ret;
        };
      }
      return function () {
        return compute.call(null, args.positional, args.named);
      };
    };
    _proto3.getValue = function getValue(fn) {
      return fn();
    };
    _proto3.getDebugName = function getDebugName(definition) {
      return (0, _utils.getDebugName)(definition.compute);
    };
    return SimpleClassicHelperManager;
  }();
  var SIMPLE_CLASSIC_HELPER_MANAGER = new SimpleClassicHelperManager();
  (0, _runtime2.setHelperManager)(function () {
    return SIMPLE_CLASSIC_HELPER_MANAGER;
  }, Wrapper.prototype);
  /**
    In many cases it is not necessary to use the full `Helper` class.
    The `helper` method create pure-function helpers without instances.
    For example:
  
    ```app/helpers/format-currency.js
    import { helper } from '@ember/component/helper';
  
    export default helper(function([cents], {currency}) {
      return `${currency}${cents * 0.01}`;
    });
    ```
  
    @static
    @param {Function} helper The helper function
    @method helper
    @for @ember/component/helper
    @public
    @since 1.13.0
  */

  function helper(helperFn) {
    return new Wrapper(helperFn);
  }

  /**
  @module @ember/template
  */
  var SafeString = /*#__PURE__*/function () {
    function SafeString(string) {
      this.string = string;
    }
    var _proto4 = SafeString.prototype;
    _proto4.toString = function toString() {
      return "" + this.string;
    };
    _proto4.toHTML = function toHTML() {
      return this.toString();
    };
    return SafeString;
  }();
  _exports.SafeString = SafeString;
  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#x27;',
    '`': '&#x60;',
    '=': '&#x3D;'
  };
  var possible = /[&<>"'`=]/;
  var badChars = /[&<>"'`=]/g;
  function escapeChar(chr) {
    return escape[chr];
  }
  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string === null || string === undefined) {
        return '';
      } else if (!string) {
        return String(string);
      } // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.

      string = String(string);
    }
    if (!possible.test(string)) {
      return string;
    }
    return string.replace(badChars, escapeChar);
  }
  /**
    Mark a string as safe for unescaped output with Ember templates. If you
    return HTML from a helper, use this function to
    ensure Ember's rendering layer does not escape the HTML.
  
    ```javascript
    import { htmlSafe } from '@ember/template';
  
    htmlSafe('<div>someString</div>')
    ```
  
    @method htmlSafe
    @for @ember/template
    @static
    @return {SafeString} A string that will not be HTML escaped by Handlebars.
    @public
  */

  function htmlSafe(str) {
    if (str === null || str === undefined) {
      str = '';
    } else if (typeof str !== 'string') {
      str = String(str);
    }
    return new SafeString(str);
  }
  /**
    Detects if a string was decorated using `htmlSafe`.
  
    ```javascript
    import { htmlSafe, isHTMLSafe } from '@ember/template';
  
    var plainString = 'plain string',
        safeString = htmlSafe('<div>someValue</div>');
  
    isHTMLSafe(plainString); // false
    isHTMLSafe(safeString);  // true
    ```
  
    @method isHTMLSafe
    @for @ember/template
    @static
    @return {Boolean} `true` if the string was decorated with `htmlSafe`, `false` otherwise.
    @public
  */

  function isHTMLSafe(str) {
    return str !== null && typeof str === 'object' && typeof str.toHTML === 'function';
  }
  function isStaticComponentManager(_manager, capabilities) {
    return !capabilities.dynamicLayout;
  }
  var CompileTimeResolverImpl = /*#__PURE__*/function () {
    function CompileTimeResolverImpl(resolver) {
      this.resolver = resolver;
    }
    var _proto5 = CompileTimeResolverImpl.prototype;
    _proto5.lookupHelper = function lookupHelper(name, owner) {
      return this.resolver.lookupHelper(name, owner);
    };
    _proto5.lookupModifier = function lookupModifier(name, owner) {
      return this.resolver.lookupModifier(name, owner);
    };
    _proto5.lookupComponent = function lookupComponent(name, owner) {
      var definitionHandle = this.resolver.lookupComponentHandle(name, owner);
      if (definitionHandle === null) {
        return null;
      }
      var _this$resolver$resolv = this.resolver.resolve(definitionHandle),
        manager = _this$resolver$resolv.manager,
        state = _this$resolver$resolv.state;
      var capabilities = manager.getCapabilities(state);
      if (!isStaticComponentManager(manager, capabilities)) {
        return {
          handle: definitionHandle,
          capabilities: capabilities,
          compilable: null
        };
      }
      var template = (0, _util.unwrapTemplate)(manager.getStaticLayout(state));
      var layout = capabilities.wrapped ? template.asWrappedLayout() : template.asLayout();
      return {
        handle: definitionHandle,
        capabilities: capabilities,
        compilable: layout
      };
    };
    _proto5.lookupPartial = function lookupPartial(name, owner) {
      return this.resolver.lookupPartial(name, owner);
    };
    _proto5.resolve = function resolve() {
      return null;
    };
    return CompileTimeResolverImpl;
  }();
  function instrumentationPayload(def) {
    return {
      object: def.name + ":" + def.outlet
    };
  }
  var CAPABILITIES = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: false,
    attributeHook: false,
    elementHook: false,
    createCaller: false,
    dynamicScope: true,
    updateHook: false,
    createInstance: true,
    wrapped: false,
    willDestroy: false
  };
  var OutletComponentManager = /*#__PURE__*/function (_BaseInternalComponen) {
    (0, _emberBabel.inheritsLoose)(OutletComponentManager, _BaseInternalComponen);
    function OutletComponentManager() {
      return _BaseInternalComponen.apply(this, arguments) || this;
    }
    var _proto6 = OutletComponentManager.prototype;
    _proto6.create = function create(env, definition, _args, dynamicScope) {
      var parentStateRef = dynamicScope.get('outletState');
      var currentStateRef = definition.ref;
      dynamicScope.set('outletState', currentStateRef);
      var state = {
        self: (0, _reference.createConstRef)(definition.controller, 'this'),
        finalize: (0, _instrumentation._instrumentStart)('render.outlet', instrumentationPayload, definition)
      };
      if (env.debugRenderTree !== undefined) {
        state.outlet = {
          name: definition.outlet
        };
        var parentState = (0, _reference.valueForRef)(parentStateRef);
        var parentOwner = parentState && parentState.render && parentState.render.owner;
        var currentOwner = (0, _reference.valueForRef)(currentStateRef).render.owner;
        if (parentOwner && parentOwner !== currentOwner) {
          var engine = currentOwner;
          (true && !(typeof currentOwner.mountPoint === 'string') && (0, _debug.assert)('invalid engine: missing mountPoint', typeof currentOwner.mountPoint === 'string'));
          (true && !(currentOwner.routable === true) && (0, _debug.assert)('invalid engine: missing routable', currentOwner.routable === true));
          var mountPoint = engine.mountPoint;
          state.engine = engine;
          state.engineBucket = {
            mountPoint: mountPoint
          };
        }
      }
      return state;
    };
    _proto6.getDebugName = function getDebugName(_ref3) {
      var name = _ref3.name;
      return name;
    };
    _proto6.getDebugCustomRenderTree = function getDebugCustomRenderTree(definition, state, args) {
      var nodes = [];
      if (state.outlet) {
        nodes.push({
          bucket: state.outlet,
          type: 'outlet',
          name: state.outlet.name,
          args: _runtime2.EMPTY_ARGS,
          instance: undefined,
          template: undefined
        });
      }
      if (state.engineBucket) {
        nodes.push({
          bucket: state.engineBucket,
          type: 'engine',
          name: state.engineBucket.mountPoint,
          args: _runtime2.EMPTY_ARGS,
          instance: state.engine,
          template: undefined
        });
      }
      nodes.push({
        bucket: state,
        type: 'route-template',
        name: definition.name,
        args: args,
        instance: definition.controller,
        template: definition.template
      });
      return nodes;
    };
    _proto6.getStaticLayout = function getStaticLayout(_ref4) {
      var template = _ref4.template;
      // The router has already resolved the template
      return template;
    };
    _proto6.getCapabilities = function getCapabilities() {
      return CAPABILITIES;
    };
    _proto6.getSelf = function getSelf(_ref5) {
      var self = _ref5.self;
      return self;
    };
    _proto6.didRenderLayout = function didRenderLayout(state) {
      state.finalize();
    };
    _proto6.getDestroyable = function getDestroyable() {
      return null;
    };
    return OutletComponentManager;
  }(_runtime2.BaseInternalComponentManager);
  var OUTLET_MANAGER = new OutletComponentManager();
  var OutletComponentDefinition = function OutletComponentDefinition(state, manager) {
    if (manager === void 0) {
      manager = OUTLET_MANAGER;
    }
    this.state = state;
    this.manager = manager;
  };
  function createRootOutlet(outletView) {
    if (_environment2.ENV._APPLICATION_TEMPLATE_WRAPPER) {
      var WRAPPED_CAPABILITIES = (0, _polyfills.assign)({}, CAPABILITIES, {
        dynamicTag: true,
        elementHook: true,
        wrapped: true
      });
      var WrappedOutletComponentManager = /*#__PURE__*/function (_OutletComponentManag) {
        (0, _emberBabel.inheritsLoose)(WrappedOutletComponentManager, _OutletComponentManag);
        function WrappedOutletComponentManager() {
          return _OutletComponentManag.apply(this, arguments) || this;
        }
        var _proto7 = WrappedOutletComponentManager.prototype;
        _proto7.getTagName = function getTagName() {
          return 'div';
        };
        _proto7.getStaticLayout = function getStaticLayout(_ref6) {
          var template = _ref6.template;
          // The router has already resolved the template
          return template;
        };
        _proto7.getCapabilities = function getCapabilities() {
          return WRAPPED_CAPABILITIES;
        };
        _proto7.didCreateElement = function didCreateElement(component, element) {
          // to add GUID id and class
          element.setAttribute('class', 'ember-view');
          element.setAttribute('id', (0, _utils.guidFor)(component));
        };
        return WrappedOutletComponentManager;
      }(OutletComponentManager);
      var WRAPPED_OUTLET_MANAGER = new WrappedOutletComponentManager();
      return new OutletComponentDefinition(outletView.state, WRAPPED_OUTLET_MANAGER);
    } else {
      return new OutletComponentDefinition(outletView.state);
    }
  }
  function NOOP() {}
  /**
    @module ember
  */

  /**
    Represents the internal state of the component.
  
    @class ComponentStateBucket
    @private
  */
  var ComponentStateBucket = /*#__PURE__*/function () {
    function ComponentStateBucket(environment, component, args, argsTag, finalizer, hasWrappedElement) {
      var _this3 = this;
      this.environment = environment;
      this.component = component;
      this.args = args;
      this.argsTag = argsTag;
      this.finalizer = finalizer;
      this.hasWrappedElement = hasWrappedElement;
      this.classRef = null;
      this.classRef = null;
      this.argsRevision = args === null ? 0 : (0, _validator.valueForTag)(argsTag);
      this.rootRef = (0, _reference.createConstRef)(component, 'this');
      (0, _runtime2.registerDestructor)(this, function () {
        return _this3.willDestroy();
      }, true);
      (0, _runtime2.registerDestructor)(this, function () {
        return _this3.component.destroy();
      });
    }
    var _proto8 = ComponentStateBucket.prototype;
    _proto8.willDestroy = function willDestroy() {
      var component = this.component,
        environment = this.environment;
      if (environment.isInteractive) {
        (0, _validator.beginUntrackFrame)();
        component.trigger('willDestroyElement');
        component.trigger('willClearRender');
        (0, _validator.endUntrackFrame)();
        var element = (0, _views.getViewElement)(component);
        if (element) {
          (0, _views.clearElementView)(element);
          (0, _views.clearViewElement)(component);
        }
      }
      component.renderer.unregister(component);
    };
    _proto8.finalize = function finalize() {
      var finalizer = this.finalizer;
      finalizer();
      this.finalizer = NOOP;
    };
    return ComponentStateBucket;
  }();
  function isTemplateFactory(template) {
    return typeof template === 'function';
  }
  function referenceForParts(rootRef, parts) {
    var isAttrs = parts[0] === 'attrs'; // TODO deprecate this

    if (isAttrs) {
      parts.shift();
      if (parts.length === 1) {
        return (0, _reference.childRefFor)(rootRef, parts[0]);
      }
    }
    return (0, _reference.childRefFromParts)(rootRef, parts);
  }
  function parseAttributeBinding(microsyntax) {
    var colonIndex = microsyntax.indexOf(':');
    if (colonIndex === -1) {
      (true && !(microsyntax !== 'class') && (0, _debug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', microsyntax !== 'class'));
      return [microsyntax, microsyntax, true];
    } else {
      var prop = microsyntax.substring(0, colonIndex);
      var attribute = microsyntax.substring(colonIndex + 1);
      (true && !(attribute !== 'class') && (0, _debug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', attribute !== 'class'));
      return [prop, attribute, false];
    }
  }
  function installAttributeBinding(component, rootRef, parsed, operations) {
    var prop = parsed[0],
      attribute = parsed[1],
      isSimple = parsed[2];
    if (attribute === 'id') {
      var elementId = (0, _metal.get)(component, prop);
      if (elementId === undefined || elementId === null) {
        elementId = component.elementId;
      }
      elementId = (0, _reference.createPrimitiveRef)(elementId);
      operations.setAttribute('id', elementId, true, null);
      return;
    }
    var isPath = prop.indexOf('.') > -1;
    var reference = isPath ? referenceForParts(rootRef, prop.split('.')) : (0, _reference.childRefFor)(rootRef, prop);
    (true && !(!(isSimple && isPath)) && (0, _debug.assert)("Illegal attributeBinding: '" + prop + "' is not a valid attribute name.", !(isSimple && isPath)));
    if (_deprecatedFeatures.EMBER_COMPONENT_IS_VISIBLE && attribute === 'style' && createStyleBindingRef !== undefined) {
      reference = createStyleBindingRef(reference, (0, _reference.childRefFor)(rootRef, 'isVisible'));
    }
    operations.setAttribute(attribute, reference, false, null);
  }
  var DISPLAY_NONE = 'display: none;';
  var SAFE_DISPLAY_NONE = htmlSafe(DISPLAY_NONE);
  var createStyleBindingRef;
  var installIsVisibleBinding;
  if (_deprecatedFeatures.EMBER_COMPONENT_IS_VISIBLE) {
    createStyleBindingRef = function createStyleBindingRef(inner, isVisibleRef) {
      return (0, _reference.createComputeRef)(function () {
        var value = (0, _reference.valueForRef)(inner);
        var isVisible = (0, _reference.valueForRef)(isVisibleRef);
        if (true /* DEBUG */ && isVisible !== undefined) {
          (true && !(false) && (0, _debug.deprecate)("The `isVisible` property on classic component classes is deprecated. Was accessed:\n\n" + (0, _validator.logTrackingStack)(), false, {
            id: 'ember-component.is-visible',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_ember-component-is-visible',
            for: 'ember-source',
            since: {
              enabled: '3.15.0-beta.1'
            }
          }));
        }
        if (isVisible !== false) {
          return value;
        } else if (!value) {
          return SAFE_DISPLAY_NONE;
        } else {
          var style = value + ' ' + DISPLAY_NONE;
          return isHTMLSafe(value) ? htmlSafe(style) : style;
        }
      });
    };
    installIsVisibleBinding = function installIsVisibleBinding(rootRef, operations) {
      operations.setAttribute('style', createStyleBindingRef(_reference.UNDEFINED_REFERENCE, (0, _reference.childRefFor)(rootRef, 'isVisible')), false, null);
    };
  }
  function createClassNameBindingRef(rootRef, microsyntax, operations) {
    var _microsyntax$split = microsyntax.split(':'),
      prop = _microsyntax$split[0],
      truthy = _microsyntax$split[1],
      falsy = _microsyntax$split[2];
    var isStatic = prop === '';
    if (isStatic) {
      operations.setAttribute('class', (0, _reference.createPrimitiveRef)(truthy), true, null);
    } else {
      var isPath = prop.indexOf('.') > -1;
      var parts = isPath ? prop.split('.') : [];
      var value = isPath ? referenceForParts(rootRef, parts) : (0, _reference.childRefFor)(rootRef, prop);
      var ref;
      if (truthy === undefined) {
        ref = createSimpleClassNameBindingRef(value, isPath ? parts[parts.length - 1] : prop);
      } else {
        ref = createColonClassNameBindingRef(value, truthy, falsy);
      }
      operations.setAttribute('class', ref, false, null);
    }
  }
  function createSimpleClassNameBindingRef(inner, path) {
    var dasherizedPath;
    return (0, _reference.createComputeRef)(function () {
      var value = (0, _reference.valueForRef)(inner);
      if (value === true) {
        (true && !(path !== undefined) && (0, _debug.assert)('You must pass a path when binding a to a class name using classNameBindings', path !== undefined));
        return dasherizedPath || (dasherizedPath = (0, _string.dasherize)(path));
      } else if (value || value === 0) {
        return String(value);
      } else {
        return null;
      }
    });
  }
  function createColonClassNameBindingRef(inner, truthy, falsy) {
    return (0, _reference.createComputeRef)(function () {
      return (0, _reference.valueForRef)(inner) ? truthy : falsy;
    });
  }

  /**
  @module ember
  */
  var ACTIONS = new _util._WeakSet();
  var INVOKE = (0, _utils.symbol)('INVOKE');
  /**
    The `{{action}}` helper provides a way to pass triggers for behavior (usually
    just a function) between components, and into components from controllers.
  
    ### Passing functions with the action helper
  
    There are three contexts an action helper can be used in. The first two
    contexts to discuss are attribute context, and Handlebars value context.
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    {{! Examples of Handlebars value context }}
    {{input on-input=(action "save")}}
    {{yield (action "refreshData") andAnotherParam}}
    ```
  
    In these contexts,
    the helper is called a "closure action" helper. Its behavior is simple:
    If passed a function name, read that function off the `actions` property
    of the current context. Once that function is read, or immediately if a function was
    passed, create a closure over that function and any arguments.
    The resulting value of an action helper used this way is simply a function.
  
    For example, in the attribute context:
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    ```
  
    The resulting template render logic would be:
  
    ```js
    var div = document.createElement('div');
    var actionFunction = (function(context){
      return function() {
        return context.actions.save.apply(context, arguments);
      };
    })(context);
    div.onclick = actionFunction;
    ```
  
    Thus when the div is clicked, the action on that context is called.
    Because the `actionFunction` is just a function, closure actions can be
    passed between components and still execute in the correct context.
  
    Here is an example action handler on a component:
  
    ```app/components/my-component.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      save() {
        this.model.save();
      }
    }
    ```
  
    Actions are always looked up on the `actions` property of the current context.
    This avoids collisions in the naming of common actions, such as `destroy`.
    Two options can be passed to the `action` helper when it is used in this way.
  
    * `target=someProperty` will look to `someProperty` instead of the current
      context for the `actions` hash. This can be useful when targeting a
      service for actions.
    * `value="target.value"` will read the path `target.value` off the first
      argument to the action when it is called and rewrite the first argument
      to be that value. This is useful when attaching actions to event listeners.
  
    ### Invoking an action
  
    Closure actions curry both their scope and any arguments. When invoked, any
    additional arguments are added to the already curried list.
    Actions should be invoked using the [sendAction](/ember/release/classes/Component/methods/sendAction?anchor=sendAction)
    method. The first argument to `sendAction` is the action to be called, and
    additional arguments are passed to the action function. This has interesting
    properties combined with currying of arguments. For example:
  
    ```app/components/update-name.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      setName(model, name) {
        model.set('name', name);
      }
    }
    ```
  
    ```app/components/update-name.hbs
    {{input on-input=(action (action 'setName' @model) value="target.value")}}
    ```
  
    The first argument (`@model`) was curried over, and the run-time argument (`event`)
    becomes a second argument. Action calls can be nested this way because each simply
    returns a function. Any function can be passed to the `{{action}}` helper, including
    other actions.
  
    Actions invoked with `sendAction` have the same currying behavior as demonstrated
    with `on-input` above. For example:
  
    ```app/components/my-input.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class extends Component {
      @action
      setName(model, name) {
        model.set('name', name);
      }
    }
    ```
  
    ```handlebars
    <MyInput @submit={{action 'setName' @model}} />
    ```
  
    or
  
    ```handlebars
    {{my-input submit=(action 'setName' @model)}}
    ```
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click() {
        // Note that model is not passed, it was curried in the template
        this.sendAction('submit', 'bob');
      }
    });
    ```
  
    ### Attaching actions to DOM elements
  
    The third context of the `{{action}}` helper can be called "element space".
    For example:
  
    ```handlebars
    {{! An example of element space }}
    <div {{action "save"}}></div>
    ```
  
    Used this way, the `{{action}}` helper provides a useful shortcut for
    registering an HTML element in a template for a single DOM event and
    forwarding that interaction to the template's context (controller or component).
    If the context of a template is a controller, actions used this way will
    bubble to routes when the controller does not implement the specified action.
    Once an action hits a route, it will bubble through the route hierarchy.
  
    ### Event Propagation
  
    `{{action}}` helpers called in element space can control event bubbling. Note
    that the closure style actions cannot.
  
    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:
  
    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```
  
    To disable bubbling, pass `bubbles=false` to the helper:
  
    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```
  
    To disable bubbling with closure style actions you must create your own
    wrapper helper that makes use of `event.stopPropagation()`:
  
    ```handlebars
    <div onclick={{disable-bubbling (action "sayHello")}}>Hello</div>
    ```
  
    ```app/helpers/disable-bubbling.js
    import { helper } from '@ember/component/helper';
  
    export function disableBubbling([action]) {
      return function(event) {
        event.stopPropagation();
        return action(event);
      };
    }
    export default helper(disableBubbling);
    ```
  
    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See
    ["Responding to Browser Events"](/ember/release/classes/Component)
    in the documentation for `Component` for more information.
  
    ### Specifying DOM event type
  
    `{{action}}` helpers called in element space can specify an event type.
    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:
  
    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```
  
    See ["Event Names"](/ember/release/classes/Component) for a list of
    acceptable DOM event names.
  
    ### Specifying whitelisted modifier keys
  
    `{{action}}` helpers called in element space can specify modifier keys.
    By default the `{{action}}` helper will ignore click events with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```
  
    This way the action will fire when clicking with the alt key pressed down.
    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```
  
    ### Specifying a Target
  
    A `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:
  
    ```app/templates/application.hbs
    <div {{action "anActionName" target=someService}}>
      click me
    </div>
    ```
  
    ```app/controllers/application.js
    import Controller from '@ember/controller';
    import { inject as service } from '@ember/service';
  
    export default class extends Controller {
      @service someService;
    }
    ```
  
    @method action
    @for Ember.Templates.helpers
    @public
  */
  _exports.INVOKE = INVOKE;
  function action(args) {
    var named = args.named,
      positional = args.positional;
    var capturedArgs = positional.capture(); // The first two argument slots are reserved.
    // pos[0] is the context (or `this`)
    // pos[1] is the action name or function
    // Anything else is an action argument.

    var context = capturedArgs[0],
      action = capturedArgs[1],
      restArgs = capturedArgs.slice(2);
    var debugKey = action.debugLabel;
    var target = named.has('target') ? named.get('target') : context;
    var processArgs = makeArgsProcessor(named.has('value') && named.get('value'), restArgs);
    var fn;
    if ((0, _reference.isInvokableRef)(action)) {
      fn = makeClosureAction(action, action, invokeRef, processArgs, debugKey);
    } else {
      fn = makeDynamicClosureAction((0, _reference.valueForRef)(context), target, action, processArgs, debugKey);
    }
    ACTIONS.add(fn);
    return (0, _reference.createUnboundRef)(fn, '(result of an `action` helper)');
  }
  function NOOP$1(args) {
    return args;
  }
  function makeArgsProcessor(valuePathRef, actionArgsRef) {
    var mergeArgs;
    if (actionArgsRef.length > 0) {
      mergeArgs = function mergeArgs(args) {
        return actionArgsRef.map(_reference.valueForRef).concat(args);
      };
    }
    var readValue;
    if (valuePathRef) {
      readValue = function readValue(args) {
        var valuePath = (0, _reference.valueForRef)(valuePathRef);
        if (valuePath && args.length > 0) {
          args[0] = (0, _metal.get)(args[0], valuePath);
        }
        return args;
      };
    }
    if (mergeArgs && readValue) {
      return function (args) {
        return readValue(mergeArgs(args));
      };
    } else {
      return mergeArgs || readValue || NOOP$1;
    }
  }
  function makeDynamicClosureAction(context, targetRef, actionRef, processArgs, debugKey) {
    // We don't allow undefined/null values, so this creates a throw-away action to trigger the assertions
    if (true /* DEBUG */) {
      makeClosureAction(context, (0, _reference.valueForRef)(targetRef), (0, _reference.valueForRef)(actionRef), processArgs, debugKey);
    }
    return function () {
      return makeClosureAction(context, (0, _reference.valueForRef)(targetRef), (0, _reference.valueForRef)(actionRef), processArgs, debugKey).apply(void 0, arguments);
    };
  }
  function makeClosureAction(context, target, action, processArgs, debugKey) {
    var self;
    var fn;
    (true && !(action !== undefined && action !== null) && (0, _debug.assert)("Action passed is null or undefined in (action) from " + target + ".", action !== undefined && action !== null));
    if (typeof action[INVOKE] === 'function') {
      (true && !(false) && (0, _debug.deprecate)("Usage of the private INVOKE API to make an object callable via action or fn is no longer supported. Please update to pass in a callback function instead. Received: " + String(action), false, {
        until: '3.25.0',
        id: 'actions.custom-invoke-invokable',
        for: 'ember-source',
        since: {
          enabled: '3.23.0-beta.1'
        }
      }));
      self = action;
      fn = action[INVOKE];
    } else {
      var typeofAction = typeof action;
      if (typeofAction === 'string') {
        self = target;
        fn = target.actions && target.actions[action];
        (true && !(Boolean(fn)) && (0, _debug.assert)("An action named '" + action + "' was not found in " + target, Boolean(fn)));
      } else if (typeofAction === 'function') {
        self = context;
        fn = action;
      } else {
        // tslint:disable-next-line:max-line-length
        (true && !(false) && (0, _debug.assert)("An action could not be made for `" + (debugKey || action) + "` in " + target + ". Please confirm that you are using either a quoted action name (i.e. `(action '" + (debugKey || 'myAction') + "')`) or a function available in " + target + ".", false));
      }
    }
    return function () {
      for (var _len = arguments.length, args = new Array(_len), _key2 = 0; _key2 < _len; _key2++) {
        args[_key2] = arguments[_key2];
      }
      var payload = {
        target: self,
        args: args,
        label: '@glimmer/closure-action'
      };
      return (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
        return _runloop.join.apply(void 0, [self, fn].concat(processArgs(args)));
      });
    };
  } // The code above:
  // 1. Finds an action function, usually on the `actions` hash
  // 2. Calls it with the target as the correct `this` context
  // Previously, `UPDATE_REFERENCED_VALUE` was a method on the reference itself,
  // so this made a bit more sense. Now, it isn't, and so we need to create a
  // function that can have `this` bound to it when called. This allows us to use
  // the same codepath to call `updateRef` on the reference.

  function invokeRef(value) {
    (0, _reference.updateRef)(this, value);
  }

  // inputs needed by CurlyComponents (attrs and props, with mutable
  // cells, etc).

  function processComponentArgs(namedArgs) {
    var attrs = Object.create(null);
    var props = Object.create(null);
    props[ARGS] = namedArgs;
    for (var name in namedArgs) {
      var ref = namedArgs[name];
      var value = (0, _reference.valueForRef)(ref);
      var isAction = typeof value === 'function' && ACTIONS.has(value);
      if ((0, _reference.isUpdatableRef)(ref) && !isAction) {
        attrs[name] = new MutableCell(ref, value);
      } else {
        attrs[name] = value;
      }
      props[name] = value;
    }
    props.attrs = attrs;
    return props;
  }
  var REF = (0, _utils.symbol)('REF');
  var MutableCell = /*#__PURE__*/function () {
    function MutableCell(ref, value) {
      this[_views.MUTABLE_CELL] = true;
      this[REF] = ref;
      this.value = value;
    }
    var _proto9 = MutableCell.prototype;
    _proto9.update = function update(val) {
      (0, _reference.updateRef)(this[REF], val);
    };
    return MutableCell;
  }();
  var __rest = undefined && undefined.__rest || function (s, e) {
    var t = {};
    for (var p in s) {
      if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }
    if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
      if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
    }
    return t;
  };
  var EMBER_VIEW_REF = (0, _reference.createPrimitiveRef)('ember-view');
  function aliasIdToElementId(args, props) {
    if (args.named.has('id')) {
      // tslint:disable-next-line:max-line-length
      (true && !(!args.named.has('elementId')) && (0, _debug.assert)("You cannot invoke a component with both 'id' and 'elementId' at the same time.", !args.named.has('elementId')));
      props.elementId = props.id;
    }
  } // We must traverse the attributeBindings in reverse keeping track of
  // what has already been applied. This is essentially refining the concatenated
  // properties applying right to left.

  function applyAttributeBindings(attributeBindings, component, rootRef, operations) {
    var seen = [];
    var i = attributeBindings.length - 1;
    while (i !== -1) {
      var binding = attributeBindings[i];
      var parsed = parseAttributeBinding(binding);
      var attribute = parsed[1];
      if (seen.indexOf(attribute) === -1) {
        seen.push(attribute);
        installAttributeBinding(component, rootRef, parsed, operations);
      }
      i--;
    }
    if (seen.indexOf('id') === -1) {
      var id = component.elementId ? component.elementId : (0, _utils.guidFor)(component);
      operations.setAttribute('id', (0, _reference.createPrimitiveRef)(id), false, null);
    }
    if (_deprecatedFeatures.EMBER_COMPONENT_IS_VISIBLE && installIsVisibleBinding !== undefined && seen.indexOf('style') === -1) {
      installIsVisibleBinding(rootRef, operations);
    }
  }
  var DEFAULT_LAYOUT = (0, _container.privatize)(_templateObject || (_templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"])));
  var EMPTY_POSITIONAL_ARGS = [];
  (0, _debug.debugFreeze)(EMPTY_POSITIONAL_ARGS);
  var CurlyComponentManager = /*#__PURE__*/function (_BaseInternalComponen2) {
    (0, _emberBabel.inheritsLoose)(CurlyComponentManager, _BaseInternalComponen2);
    function CurlyComponentManager() {
      return _BaseInternalComponen2.apply(this, arguments) || this;
    }
    var _proto10 = CurlyComponentManager.prototype;
    _proto10.templateFor = function templateFor(component) {
      var layout = component.layout,
        layoutName = component.layoutName;
      var owner = (0, _owner.getOwner)(component);
      var factory;
      if (layout === undefined) {
        if (layoutName !== undefined) {
          var _factory = owner.lookup("template:" + layoutName);
          (true && !(_factory !== undefined) && (0, _debug.assert)("Layout `" + layoutName + "` not found!", _factory !== undefined));
          factory = _factory;
        } else {
          factory = owner.lookup(DEFAULT_LAYOUT);
        }
      } else if (isTemplateFactory(layout)) {
        factory = layout;
      } else {
        // we were provided an instance already
        return layout;
      }
      return factory(owner);
    };
    _proto10.getDynamicLayout = function getDynamicLayout(bucket) {
      return this.templateFor(bucket.component);
    };
    _proto10.getTagName = function getTagName(state) {
      var component = state.component,
        hasWrappedElement = state.hasWrappedElement;
      if (!hasWrappedElement) {
        return null;
      }
      return component && component.tagName || 'div';
    };
    _proto10.getCapabilities = function getCapabilities(state) {
      return state.capabilities;
    };
    _proto10.prepareArgs = function prepareArgs(state, args) {
      if (args.named.has('__ARGS__')) {
        var _a = args.named.capture(),
          __ARGS__ = _a.__ARGS__,
          rest = __rest(_a, ["__ARGS__"]);
        var prepared = {
          positional: EMPTY_POSITIONAL_ARGS,
          named: (0, _polyfills.assign)((0, _polyfills.assign)({}, rest), (0, _reference.valueForRef)(__ARGS__))
        };
        return prepared;
      }
      var positionalParams = state.ComponentClass.class.positionalParams; // early exits

      if (positionalParams === undefined || positionalParams === null || args.positional.length === 0) {
        return null;
      }
      var named;
      if (typeof positionalParams === 'string') {
        var _named;
        (true && !(!args.named.has(positionalParams)) && (0, _debug.assert)("You cannot specify positional parameters and the hash argument `" + positionalParams + "`.", !args.named.has(positionalParams)));
        var captured = args.positional.capture();
        named = (_named = {}, _named[positionalParams] = (0, _reference.createComputeRef)(function () {
          return (0, _runtime2.reifyPositional)(captured);
        }), _named);
        (0, _polyfills.assign)(named, args.named.capture());
      } else if (Array.isArray(positionalParams) && positionalParams.length > 0) {
        var count = Math.min(positionalParams.length, args.positional.length);
        named = {};
        (0, _polyfills.assign)(named, args.named.capture());
        for (var i = 0; i < count; i++) {
          // As of TS 3.7, tsc is giving us the following error on this line without the type annotation
          //
          //   TS7022: 'name' implicitly has type 'any' because it does not have a type annotation and is
          //   referenced directly or indirectly in its own initializer.
          //
          // This is almost certainly a TypeScript bug, feel free to try and remove the annotation after
          // upgrading if it is not needed anymore.
          var name = positionalParams[i];
          (true && !(!args.named.has(name)) && (0, _debug.assert)("You cannot specify both a positional param (at position " + i + ") and the hash argument `" + name + "`.", !args.named.has(name)));
          named[name] = args.positional.at(i);
        }
      } else {
        return null;
      }
      return {
        positional: _util.EMPTY_ARRAY,
        named: named
      };
    }
    /*
     * This hook is responsible for actually instantiating the component instance.
     * It also is where we perform additional bookkeeping to support legacy
     * features like exposed by view mixins like ChildViewSupport, ActionSupport,
     * etc.
     */;
    _proto10.create = function create(environment, state, args, dynamicScope, callerSelfRef, hasBlock) {
      // Get the nearest concrete component instance from the scope. "Virtual"
      // components will be skipped.
      var parentView = dynamicScope.view; // Get the Ember.Component subclass to instantiate for this component.

      var factory = state.ComponentClass; // Capture the arguments, which tells Glimmer to give us our own, stable
      // copy of the Arguments object that is safe to hold on to between renders.

      var capturedArgs = args.named.capture();
      (0, _validator.beginTrackFrame)();
      var props = processComponentArgs(capturedArgs);
      var argsTag = (0, _validator.endTrackFrame)(); // Alias `id` argument to `elementId` property on the component instance.

      aliasIdToElementId(args, props); // Set component instance's parentView property to point to nearest concrete
      // component.

      props.parentView = parentView; // Set whether this component was invoked with a block
      // (`{{#my-component}}{{/my-component}}`) or without one
      // (`{{my-component}}`).

      props[HAS_BLOCK] = hasBlock; // Save the current `this` context of the template as the component's
      // `_target`, so bubbled actions are routed to the right place.

      props._target = (0, _reference.valueForRef)(callerSelfRef); // static layout asserts CurriedDefinition

      if (state.template) {
        props.layout = state.template;
      } // caller:
      // <FaIcon @name="bug" />
      //
      // callee:
      // <i class="fa-{{@name}}"></i>
      // Now that we've built up all of the properties to set on the component instance,
      // actually create it.

      (0, _validator.beginUntrackFrame)();
      var component = factory.create(props);
      var finalizer = (0, _instrumentation._instrumentStart)('render.component', initialRenderInstrumentDetails, component); // We become the new parentView for downstream components, so save our
      // component off on the dynamic scope.

      dynamicScope.view = component; // Unless we're the root component, we need to add ourselves to our parent
      // component's childViews array.

      if (parentView !== null && parentView !== undefined) {
        (0, _views.addChildView)(parentView, component);
      }
      component.trigger('didReceiveAttrs');
      var hasWrappedElement = component.tagName !== ''; // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components

      if (!hasWrappedElement) {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }
        component._transitionTo('hasElement');
        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      } // Track additional lifecycle metadata about this component in a state bucket.
      // Essentially we're saving off all the state we'll need in the future.

      var bucket = new ComponentStateBucket(environment, component, capturedArgs, argsTag, finalizer, hasWrappedElement);
      if (args.named.has('class')) {
        bucket.classRef = args.named.get('class');
      }
      if (true /* DEBUG */) {
        processComponentInitializationAssertions(component, props);
      }
      if (environment.isInteractive && hasWrappedElement) {
        component.trigger('willRender');
      }
      (0, _validator.endUntrackFrame)(); // consume every argument so we always run again

      (0, _validator.consumeTag)(bucket.argsTag);
      (0, _validator.consumeTag)(component[DIRTY_TAG]);
      return bucket;
    };
    _proto10.getDebugName = function getDebugName(_ref7) {
      var name = _ref7.name;
      return name;
    };
    _proto10.getSelf = function getSelf(_ref8) {
      var rootRef = _ref8.rootRef;
      return rootRef;
    };
    _proto10.didCreateElement = function didCreateElement(_ref9, element, operations) {
      var component = _ref9.component,
        classRef = _ref9.classRef,
        environment = _ref9.environment,
        rootRef = _ref9.rootRef;
      (0, _views.setViewElement)(component, element);
      (0, _views.setElementView)(element, component);
      var attributeBindings = component.attributeBindings,
        classNames = component.classNames,
        classNameBindings = component.classNameBindings;
      if (attributeBindings && attributeBindings.length) {
        applyAttributeBindings(attributeBindings, component, rootRef, operations);
      } else {
        var id = component.elementId ? component.elementId : (0, _utils.guidFor)(component);
        operations.setAttribute('id', (0, _reference.createPrimitiveRef)(id), false, null);
        if (_deprecatedFeatures.EMBER_COMPONENT_IS_VISIBLE) {
          installIsVisibleBinding(rootRef, operations);
        }
      }
      if (classRef) {
        var ref = createSimpleClassNameBindingRef(classRef);
        operations.setAttribute('class', ref, false, null);
      }
      if (classNames && classNames.length) {
        classNames.forEach(function (name) {
          operations.setAttribute('class', (0, _reference.createPrimitiveRef)(name), false, null);
        });
      }
      if (classNameBindings && classNameBindings.length) {
        classNameBindings.forEach(function (binding) {
          createClassNameBindingRef(rootRef, binding, operations);
        });
      }
      operations.setAttribute('class', EMBER_VIEW_REF, false, null);
      if ('ariaRole' in component) {
        operations.setAttribute('role', (0, _reference.childRefFor)(rootRef, 'ariaRole'), false, null);
      }
      component._transitionTo('hasElement');
      if (environment.isInteractive) {
        (0, _validator.beginUntrackFrame)();
        component.trigger('willInsertElement');
        (0, _validator.endUntrackFrame)();
      }
    };
    _proto10.didRenderLayout = function didRenderLayout(bucket, bounds) {
      bucket.component[BOUNDS] = bounds;
      bucket.finalize();
    };
    _proto10.didCreate = function didCreate(_ref10) {
      var component = _ref10.component,
        environment = _ref10.environment;
      if (environment.isInteractive) {
        component._transitionTo('inDOM');
        component.trigger('didInsertElement');
        component.trigger('didRender');
      }
    };
    _proto10.update = function update(bucket) {
      var component = bucket.component,
        args = bucket.args,
        argsTag = bucket.argsTag,
        argsRevision = bucket.argsRevision,
        environment = bucket.environment;
      bucket.finalizer = (0, _instrumentation._instrumentStart)('render.component', rerenderInstrumentDetails, component);
      (0, _validator.beginUntrackFrame)();
      if (args !== null && !(0, _validator.validateTag)(argsTag, argsRevision)) {
        (0, _validator.beginTrackFrame)();
        var props = processComponentArgs(args);
        argsTag = bucket.argsTag = (0, _validator.endTrackFrame)();
        bucket.argsRevision = (0, _validator.valueForTag)(argsTag);
        component[IS_DISPATCHING_ATTRS] = true;
        component.setProperties(props);
        component[IS_DISPATCHING_ATTRS] = false;
        component.trigger('didUpdateAttrs');
        component.trigger('didReceiveAttrs');
      }
      if (environment.isInteractive) {
        component.trigger('willUpdate');
        component.trigger('willRender');
      }
      (0, _validator.endUntrackFrame)();
      (0, _validator.consumeTag)(argsTag);
      (0, _validator.consumeTag)(component[DIRTY_TAG]);
    };
    _proto10.didUpdateLayout = function didUpdateLayout(bucket) {
      bucket.finalize();
    };
    _proto10.didUpdate = function didUpdate(_ref11) {
      var component = _ref11.component,
        environment = _ref11.environment;
      if (environment.isInteractive) {
        component.trigger('didUpdate');
        component.trigger('didRender');
      }
    };
    _proto10.getDestroyable = function getDestroyable(bucket) {
      return bucket;
    };
    return CurlyComponentManager;
  }(_runtime2.BaseInternalComponentManager);
  function processComponentInitializationAssertions(component, props) {
    (true && !(function () {
      var classNameBindings = component.classNameBindings;
      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (typeof binding !== 'string' || binding.length === 0) {
          return false;
        }
      }
      return true;
    }()) && (0, _debug.assert)("classNameBindings must be non-empty strings: " + component, function () {
      var classNameBindings = component.classNameBindings;
      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (typeof binding !== 'string' || binding.length === 0) {
          return false;
        }
      }
      return true;
    }()));
    (true && !(function () {
      var classNameBindings = component.classNameBindings;
      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (binding.split(' ').length > 1) {
          return false;
        }
      }
      return true;
    }()) && (0, _debug.assert)("classNameBindings must not have spaces in them: " + component, function () {
      var classNameBindings = component.classNameBindings;
      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (binding.split(' ').length > 1) {
          return false;
        }
      }
      return true;
    }()));
    (true && !(component.tagName !== '' || !component.classNameBindings || component.classNameBindings.length === 0) && (0, _debug.assert)("You cannot use `classNameBindings` on a tag-less component: " + component, component.tagName !== '' || !component.classNameBindings || component.classNameBindings.length === 0));
    (true && !(component.tagName !== '' || props.id === component.elementId || !component.elementId && component.elementId !== '') && (0, _debug.assert)("You cannot use `elementId` on a tag-less component: " + component, component.tagName !== '' || props.id === component.elementId || !component.elementId && component.elementId !== ''));
    (true && !(component.tagName !== '' || !component.attributeBindings || component.attributeBindings.length === 0) && (0, _debug.assert)("You cannot use `attributeBindings` on a tag-less component: " + component, component.tagName !== '' || !component.attributeBindings || component.attributeBindings.length === 0));
  }
  function initialRenderInstrumentDetails(component) {
    return component.instrumentDetails({
      initialRender: true
    });
  }
  function rerenderInstrumentDetails(component) {
    return component.instrumentDetails({
      initialRender: false
    });
  }
  var CURLY_CAPABILITIES = {
    dynamicLayout: true,
    dynamicTag: true,
    prepareArgs: true,
    createArgs: true,
    attributeHook: true,
    elementHook: true,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true,
    wrapped: true,
    willDestroy: true
  };
  var CURLY_COMPONENT_MANAGER = new CurlyComponentManager();
  var CurlyComponentDefinition = function CurlyComponentDefinition(name, ComponentClass, template, args) {
    this.name = name;
    this.ComponentClass = ComponentClass;
    this.template = template;
    this.args = args;
    this.manager = CURLY_COMPONENT_MANAGER;
    this.state = {
      name: name,
      ComponentClass: ComponentClass,
      template: template,
      capabilities: CURLY_CAPABILITIES
    };
  };
  var RootComponentManager = /*#__PURE__*/function (_CurlyComponentManage) {
    (0, _emberBabel.inheritsLoose)(RootComponentManager, _CurlyComponentManage);
    function RootComponentManager(component) {
      var _this4;
      _this4 = _CurlyComponentManage.call(this) || this;
      _this4.component = component;
      return _this4;
    }
    var _proto11 = RootComponentManager.prototype;
    _proto11.getStaticLayout = function getStaticLayout() {
      return this.templateFor(this.component);
    };
    _proto11.create = function create(environment, _state, _args, dynamicScope) {
      var component = this.component;
      var finalizer = (0, _instrumentation._instrumentStart)('render.component', initialRenderInstrumentDetails, component);
      dynamicScope.view = component;
      var hasWrappedElement = component.tagName !== ''; // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components

      if (!hasWrappedElement) {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }
        component._transitionTo('hasElement');
        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }
      if (true /* DEBUG */) {
        processComponentInitializationAssertions(component, {});
      }
      var bucket = new ComponentStateBucket(environment, component, null, _validator.CONSTANT_TAG, finalizer, hasWrappedElement);
      (0, _validator.consumeTag)(component[DIRTY_TAG]);
      return bucket;
    };
    return RootComponentManager;
  }(CurlyComponentManager); // ROOT is the top-level template it has nothing but one yield.
  // it is supposed to have a dummy element
  var ROOT_CAPABILITIES = {
    dynamicLayout: false,
    dynamicTag: true,
    prepareArgs: false,
    createArgs: false,
    attributeHook: true,
    elementHook: true,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true,
    wrapped: true,
    willDestroy: false
  };
  var RootComponentDefinition = function RootComponentDefinition(component) {
    this.component = component;
    var manager = new RootComponentManager(component);
    this.manager = manager;
    var factory = (0, _container.getFactoryFor)(component);
    this.state = {
      name: factory.fullName.slice(10),
      capabilities: ROOT_CAPABILITIES,
      ComponentClass: factory
    };
  };
  /**
  @module ember
  */
  /**
    The `{{#each}}` helper loops over elements in a collection. It is an extension
    of the base Handlebars `{{#each}}` helper.
  
    The default behavior of `{{#each}}` is to yield its inner block once for every
    item in an array passing the item as the first block parameter.
  
    Assuming the `@developers` argument contains this array:
  
    ```javascript
    [{ name: 'Yehuda' },{ name: 'Tom' }, { name: 'Paul' }];
    ```
  
    ```handlebars
    <ul>
      {{#each @developers as |person|}}
        <li>Hello, {{person.name}}!</li>
      {{/each}}
    </ul>
    ```
  
    The same rules apply to arrays of primitives.
  
    ```javascript
    ['Yehuda', 'Tom', 'Paul']
    ```
  
    ```handlebars
    <ul>
      {{#each @developerNames as |name|}}
        <li>Hello, {{name}}!</li>
      {{/each}}
    </ul>
    ```
  
    During iteration, the index of each item in the array is provided as a second block
    parameter.
  
    ```handlebars
    <ul>
      {{#each @developers as |person index|}}
        <li>Hello, {{person.name}}! You're number {{index}} in line</li>
      {{/each}}
    </ul>
    ```
  
    ### Specifying Keys
  
    In order to improve rendering speed, Ember will try to reuse the DOM elements
    where possible. Specifically, if the same item is present in the array both
    before and after the change, its DOM output will be reused.
  
    The `key` option is used to tell Ember how to determine if the items in the
    array being iterated over with `{{#each}}` has changed between renders. By
    default the item's object identity is used.
  
    This is usually sufficient, so in most cases, the `key` option is simply not
    needed. However, in some rare cases, the objects' identities may change even
    though they represent the same underlying data.
  
    For example:
  
    ```javascript
    people.map(person => {
      return { ...person, type: 'developer' };
    });
    ```
  
    In this case, each time the `people` array is `map`-ed over, it will produce
    an new array with completely different objects between renders. In these cases,
    you can help Ember determine how these objects related to each other with the
    `key` option:
  
    ```handlebars
    <ul>
      {{#each @developers key="name" as |person|}}
        <li>Hello, {{person.name}}!</li>
      {{/each}}
    </ul>
    ```
  
    By doing so, Ember will use the value of the property specified (`person.name`
    in the example) to find a "match" from the previous render. That is, if Ember
    has previously seen an object from the `@developers` array with a matching
    name, its DOM elements will be re-used.
  
    There are two special values for `key`:
  
      * `@index` - The index of the item in the array.
      * `@identity` - The item in the array itself.
  
    ### {{else}} condition
  
    `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
    if the collection is empty.
  
    ```handlebars
    <ul>
      {{#each @developers as |person|}}
        <li>{{person.name}} is available!</li>
      {{else}}
        <li>Sorry, nobody is available for this task.</li>
      {{/each}}
    </ul>
    ```
  
    @method each
    @for Ember.Templates.helpers
    @public
   */
  /**
    The `{{each-in}}` helper loops over properties on an object.
  
    For example, given this component definition:
  
    ```app/components/developer-details.js
    import Component from '@glimmer/component';
    import { tracked } from '@glimmer/tracking';
  
    export default class extends Component {
      @tracked developer = {
        "name": "Shelly Sails",
        "age": 42
      };
    }
    ```
  
    This template would display all properties on the `developer`
    object in a list:
  
    ```app/components/developer-details.hbs
    <ul>
      {{#each-in this.developer as |key value|}}
        <li>{{key}}: {{value}}</li>
      {{/each-in}}
    </ul>
    ```
  
    Outputting their name and age.
  
    @method each-in
    @for Ember.Templates.helpers
    @public
    @since 2.1.0
  */
  var EachInWrapper = function EachInWrapper(inner) {
    this.inner = inner;
  };
  function eachIn(args) {
    var inner = args.positional.at(0);
    return (0, _reference.createComputeRef)(function () {
      var iterable = (0, _reference.valueForRef)(inner);
      (0, _validator.consumeTag)((0, _metal.tagForObject)(iterable));
      if ((0, _utils.isProxy)(iterable)) {
        // this is because the each-in doesn't actually get(proxy, 'key') but bypasses it
        // and the proxy's tag is lazy updated on access
        iterable = (0, _runtime._contentFor)(iterable);
      }
      return new EachInWrapper(iterable);
    });
  }
  function toIterator(iterable) {
    if (iterable instanceof EachInWrapper) {
      return toEachInIterator(iterable.inner);
    } else {
      return toEachIterator(iterable);
    }
  }
  function toEachInIterator(iterable) {
    if (!isIndexable(iterable)) {
      return null;
    }
    if (Array.isArray(iterable) || (0, _utils.isEmberArray)(iterable)) {
      return ObjectIterator.fromIndexable(iterable);
    } else if (_utils.HAS_NATIVE_SYMBOL && isNativeIterable(iterable)) {
      return MapLikeNativeIterator.from(iterable);
    } else if (hasForEach(iterable)) {
      return ObjectIterator.fromForEachable(iterable);
    } else {
      return ObjectIterator.fromIndexable(iterable);
    }
  }
  function toEachIterator(iterable) {
    if (!(0, _utils.isObject)(iterable)) {
      return null;
    }
    if (Array.isArray(iterable)) {
      return ArrayIterator.from(iterable);
    } else if ((0, _utils.isEmberArray)(iterable)) {
      return EmberArrayIterator.from(iterable);
    } else if (_utils.HAS_NATIVE_SYMBOL && isNativeIterable(iterable)) {
      return ArrayLikeNativeIterator.from(iterable);
    } else if (hasForEach(iterable)) {
      return ArrayIterator.fromForEachable(iterable);
    } else {
      return null;
    }
  }
  var BoundedIterator = /*#__PURE__*/function () {
    function BoundedIterator(length) {
      this.length = length;
      this.position = 0;
    }
    var _proto12 = BoundedIterator.prototype;
    _proto12.isEmpty = function isEmpty() {
      return false;
    };
    _proto12.memoFor = function memoFor(position) {
      return position;
    };
    _proto12.next = function next() {
      var length = this.length,
        position = this.position;
      if (position >= length) {
        return null;
      }
      var value = this.valueFor(position);
      var memo = this.memoFor(position);
      this.position++;
      return {
        value: value,
        memo: memo
      };
    };
    return BoundedIterator;
  }();
  var ArrayIterator = /*#__PURE__*/function (_BoundedIterator) {
    (0, _emberBabel.inheritsLoose)(ArrayIterator, _BoundedIterator);
    function ArrayIterator(array) {
      var _this5;
      _this5 = _BoundedIterator.call(this, array.length) || this;
      _this5.array = array;
      return _this5;
    }
    ArrayIterator.from = function from(iterable) {
      return iterable.length > 0 ? new this(iterable) : null;
    };
    ArrayIterator.fromForEachable = function fromForEachable(object) {
      var array = [];
      object.forEach(function (item) {
        return array.push(item);
      });
      return this.from(array);
    };
    var _proto13 = ArrayIterator.prototype;
    _proto13.valueFor = function valueFor(position) {
      return this.array[position];
    };
    return ArrayIterator;
  }(BoundedIterator);
  var EmberArrayIterator = /*#__PURE__*/function (_BoundedIterator2) {
    (0, _emberBabel.inheritsLoose)(EmberArrayIterator, _BoundedIterator2);
    function EmberArrayIterator(array) {
      var _this6;
      _this6 = _BoundedIterator2.call(this, array.length) || this;
      _this6.array = array;
      return _this6;
    }
    EmberArrayIterator.from = function from(iterable) {
      return iterable.length > 0 ? new this(iterable) : null;
    };
    var _proto14 = EmberArrayIterator.prototype;
    _proto14.valueFor = function valueFor(position) {
      return (0, _metal.objectAt)(this.array, position);
    };
    return EmberArrayIterator;
  }(BoundedIterator);
  var ObjectIterator = /*#__PURE__*/function (_BoundedIterator3) {
    (0, _emberBabel.inheritsLoose)(ObjectIterator, _BoundedIterator3);
    function ObjectIterator(keys, values) {
      var _this7;
      _this7 = _BoundedIterator3.call(this, values.length) || this;
      _this7.keys = keys;
      _this7.values = values;
      return _this7;
    }
    ObjectIterator.fromIndexable = function fromIndexable(obj) {
      var keys = Object.keys(obj);
      var length = keys.length;
      if (length === 0) {
        return null;
      } else {
        var values = [];
        for (var i = 0; i < length; i++) {
          var value = void 0;
          var key = keys[i];
          value = obj[key]; // Add the tag of the returned value if it is an array, since arrays
          // should always cause updates if they are consumed and then changed

          if ((0, _validator.isTracking)()) {
            (0, _validator.consumeTag)((0, _validator.tagFor)(obj, key));
            if (Array.isArray(value)) {
              (0, _validator.consumeTag)((0, _validator.tagFor)(value, '[]'));
            }
          }
          values.push(value);
        }
        return new this(keys, values);
      }
    };
    ObjectIterator.fromForEachable = function fromForEachable(obj) {
      var keys = [];
      var values = [];
      var length = 0;
      var isMapLike = false; // Not using an arrow function here so we can get an accurate `arguments`

      obj.forEach(function (value, key) {
        isMapLike = isMapLike || arguments.length >= 2;
        if (isMapLike) {
          keys.push(key);
        }
        values.push(value);
        length++;
      });
      if (length === 0) {
        return null;
      } else if (isMapLike) {
        return new this(keys, values);
      } else {
        return new ArrayIterator(values);
      }
    };
    var _proto15 = ObjectIterator.prototype;
    _proto15.valueFor = function valueFor(position) {
      return this.values[position];
    };
    _proto15.memoFor = function memoFor(position) {
      return this.keys[position];
    };
    return ObjectIterator;
  }(BoundedIterator);
  var NativeIterator = /*#__PURE__*/function () {
    function NativeIterator(iterable, result) {
      this.iterable = iterable;
      this.result = result;
      this.position = 0;
    }
    NativeIterator.from = function from(iterable) {
      var iterator = iterable[Symbol.iterator]();
      var result = iterator.next();
      var done = result.done;
      if (done) {
        return null;
      } else {
        return new this(iterator, result);
      }
    };
    var _proto16 = NativeIterator.prototype;
    _proto16.isEmpty = function isEmpty() {
      return false;
    };
    _proto16.next = function next() {
      var iterable = this.iterable,
        result = this.result,
        position = this.position;
      if (result.done) {
        return null;
      }
      var value = this.valueFor(result, position);
      var memo = this.memoFor(result, position);
      this.position++;
      this.result = iterable.next();
      return {
        value: value,
        memo: memo
      };
    };
    return NativeIterator;
  }();
  var ArrayLikeNativeIterator = /*#__PURE__*/function (_NativeIterator) {
    (0, _emberBabel.inheritsLoose)(ArrayLikeNativeIterator, _NativeIterator);
    function ArrayLikeNativeIterator() {
      return _NativeIterator.apply(this, arguments) || this;
    }
    var _proto17 = ArrayLikeNativeIterator.prototype;
    _proto17.valueFor = function valueFor(result) {
      return result.value;
    };
    _proto17.memoFor = function memoFor(_result, position) {
      return position;
    };
    return ArrayLikeNativeIterator;
  }(NativeIterator);
  var MapLikeNativeIterator = /*#__PURE__*/function (_NativeIterator2) {
    (0, _emberBabel.inheritsLoose)(MapLikeNativeIterator, _NativeIterator2);
    function MapLikeNativeIterator() {
      return _NativeIterator2.apply(this, arguments) || this;
    }
    var _proto18 = MapLikeNativeIterator.prototype;
    _proto18.valueFor = function valueFor(result) {
      return result.value[1];
    };
    _proto18.memoFor = function memoFor(result) {
      return result.value[0];
    };
    return MapLikeNativeIterator;
  }(NativeIterator);
  function hasForEach(value) {
    return typeof value['forEach'] === 'function';
  }
  function isNativeIterable(value) {
    return typeof value[Symbol.iterator] === 'function';
  }
  function isIndexable(value) {
    return value !== null && (typeof value === 'object' || typeof value === 'function');
  }
  function toBool$1(predicate) {
    if ((0, _utils.isProxy)(predicate)) {
      (0, _validator.consumeTag)((0, _metal.tagForProperty)(predicate, 'content'));
      return Boolean((0, _metal.get)(predicate, 'isTruthy'));
    } else if ((0, _runtime.isArray)(predicate)) {
      (0, _validator.consumeTag)((0, _metal.tagForProperty)(predicate, '[]'));
      return predicate.length !== 0;
    } else {
      return Boolean(predicate);
    }
  }

  // Setup global context

  (0, _globalContext.default)({
    scheduleRevalidate: function scheduleRevalidate() {
      _runloop.backburner.ensureInstance();
    },
    toBool: toBool$1,
    toIterator: toIterator,
    getProp: _metal._getProp,
    setProp: _metal.set,
    getPath: _metal.get,
    scheduleDestroy: function scheduleDestroy(destroyable, destructor) {
      (0, _runloop.schedule)('actions', null, destructor, destroyable);
    },
    scheduleDestroyed: function scheduleDestroyed(finalizeDestructor) {
      (0, _runloop.schedule)('destroy', null, finalizeDestructor);
    },
    warnIfStyleNotTrusted: function warnIfStyleNotTrusted(value) {
      (true && (0, _debug.warn)((0, _views.constructStyleDeprecationMessage)(value), function () {
        if (value === null || value === undefined || isHTMLSafe(value)) {
          return true;
        }
        return false;
      }(), {
        id: 'ember-htmlbars.style-xss-warning'
      }));
    }
  });
  if (true /* DEBUG */) {
    (0, _validator.setTrackingTransactionEnv)({
      assert: function assert(message) {
        (true && !(false) && (0, _debug.assert)(message, false));
      },
      deprecate: function deprecate(message) {
        (true && !(false) && (0, _debug.deprecate)(message, false, {
          id: 'autotracking.mutation-after-consumption',
          until: '4.0.0',
          for: 'ember-source',
          since: {
            enabled: '3.21.0'
          }
        }));
      },
      debugMessage: function debugMessage(obj, keyName) {
        var dirtyString = keyName ? "`" + keyName + "` on `" + (0, _utils.getDebugName)(obj) + "`" : "`" + (0, _utils.getDebugName)(obj) + "`";
        return "You attempted to update " + dirtyString + ", but it had already been used previously in the same computation.  Attempting to update a value after using it in a computation can cause logical errors, infinite revalidation bugs, and performance issues, and is not supported.";
      }
    });
  } ///////////
  // Define environment delegate
  var EmberEnvironmentDelegate = /*#__PURE__*/function () {
    function EmberEnvironmentDelegate(owner, isInteractive) {
      this.owner = owner;
      this.isInteractive = isInteractive;
      this.enableDebugTooling = _environment2.ENV._DEBUG_RENDER_TREE;
    }
    var _proto19 = EmberEnvironmentDelegate.prototype;
    _proto19.onTransactionCommit = function onTransactionCommit() {};
    return EmberEnvironmentDelegate;
  }();
  var CAPABILITIES$1 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: false,
    dynamicScope: true,
    updateHook: true,
    createInstance: true,
    wrapped: false,
    willDestroy: false
  };
  function capabilities(managerAPI, options) {
    if (options === void 0) {
      options = {};
    }
    (true && !(managerAPI === '3.4' || managerAPI === '3.13') && (0, _debug.assert)('Invalid component manager compatibility specified', managerAPI === '3.4' || managerAPI === '3.13'));
    var updateHook = true;
    if (managerAPI === '3.13') {
      updateHook = Boolean(options.updateHook);
    }
    return (0, _runtime2.buildCapabilities)({
      asyncLifeCycleCallbacks: Boolean(options.asyncLifecycleCallbacks),
      destructor: Boolean(options.destructor),
      updateHook: updateHook
    });
  }
  function hasAsyncLifeCycleCallbacks(delegate) {
    return delegate.capabilities.asyncLifeCycleCallbacks;
  }
  function hasUpdateHook(delegate) {
    return delegate.capabilities.updateHook;
  }
  function hasAsyncUpdateHook(delegate) {
    return hasAsyncLifeCycleCallbacks(delegate) && hasUpdateHook(delegate);
  }
  function hasDestructors(delegate) {
    return delegate.capabilities.destructor;
  }
  /**
    The CustomComponentManager allows addons to provide custom component
    implementations that integrate seamlessly into Ember. This is accomplished
    through a delegate, registered with the custom component manager, which
    implements a set of hooks that determine component behavior.
  
    To create a custom component manager, instantiate a new CustomComponentManager
    class and pass the delegate as the first argument:
  
    ```js
    let manager = new CustomComponentManager({
      // ...delegate implementation...
    });
    ```
  
    ## Delegate Hooks
  
    Throughout the lifecycle of a component, the component manager will invoke
    delegate hooks that are responsible for surfacing those lifecycle changes to
    the end developer.
  
    * `create()` - invoked when a new instance of a component should be created
    * `update()` - invoked when the arguments passed to a component change
    * `getContext()` - returns the object that should be
  */
  var CustomComponentManager = /*#__PURE__*/function (_BaseInternalComponen3) {
    (0, _emberBabel.inheritsLoose)(CustomComponentManager, _BaseInternalComponen3);
    function CustomComponentManager() {
      return _BaseInternalComponen3.apply(this, arguments) || this;
    }
    var _proto20 = CustomComponentManager.prototype;
    _proto20.create = function create(env, definition, vmArgs) {
      var delegate = definition.delegate;
      var args = argsProxyFor(vmArgs.capture(), 'component');
      var component;
      if (true /* DEBUG */ && _validator.deprecateMutationsInTrackingTransaction !== undefined) {
        (0, _validator.deprecateMutationsInTrackingTransaction)(function () {
          component = delegate.createComponent(definition.ComponentClass.class, args);
        });
      } else {
        component = delegate.createComponent(definition.ComponentClass.class, args);
      }
      var bucket = new CustomComponentState(delegate, component, args, env);
      return bucket;
    };
    _proto20.getDebugName = function getDebugName(_ref12) {
      var name = _ref12.name;
      return name;
    };
    _proto20.update = function update(bucket) {
      if (hasUpdateHook(bucket.delegate)) {
        var delegate = bucket.delegate,
          component = bucket.component,
          args = bucket.args;
        delegate.updateComponent(component, args);
      }
    };
    _proto20.didCreate = function didCreate(_ref13) {
      var delegate = _ref13.delegate,
        component = _ref13.component;
      if (hasAsyncLifeCycleCallbacks(delegate)) {
        delegate.didCreateComponent(component);
      }
    };
    _proto20.didUpdate = function didUpdate(_ref14) {
      var delegate = _ref14.delegate,
        component = _ref14.component;
      if (hasAsyncUpdateHook(delegate)) {
        delegate.didUpdateComponent(component);
      }
    };
    _proto20.didRenderLayout = function didRenderLayout() {};
    _proto20.didUpdateLayout = function didUpdateLayout() {};
    _proto20.getSelf = function getSelf(_ref15) {
      var delegate = _ref15.delegate,
        component = _ref15.component;
      return (0, _reference.createConstRef)(delegate.getContext(component), 'this');
    };
    _proto20.getDestroyable = function getDestroyable(bucket) {
      return bucket;
    };
    _proto20.getCapabilities = function getCapabilities() {
      return CAPABILITIES$1;
    };
    _proto20.getStaticLayout = function getStaticLayout(state) {
      return state.template;
    };
    return CustomComponentManager;
  }(_runtime2.BaseInternalComponentManager);
  var CUSTOM_COMPONENT_MANAGER = new CustomComponentManager();
  /**
   * Stores internal state about a component instance after it's been created.
   */
  var CustomComponentState = function CustomComponentState(delegate, component, args, env) {
    this.delegate = delegate;
    this.component = component;
    this.args = args;
    this.env = env;
    if (hasDestructors(delegate)) {
      (0, _runtime2.registerDestructor)(this, function () {
        return delegate.destroyComponent(component);
      });
    }
  };
  var CustomManagerDefinition = function CustomManagerDefinition(name, ComponentClass, delegate, template) {
    this.name = name;
    this.ComponentClass = ComponentClass;
    this.delegate = delegate;
    this.template = template;
    this.manager = CUSTOM_COMPONENT_MANAGER;
    this.state = {
      name: name,
      ComponentClass: ComponentClass,
      template: template,
      delegate: delegate
    };
  };
  var CAPABILITIES$2 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: true,
    dynamicScope: false,
    updateHook: false,
    createInstance: true,
    wrapped: false,
    willDestroy: false
  };
  var InternalComponentDefinition = function InternalComponentDefinition(manager, ComponentClass, layout) {
    this.manager = manager;
    this.state = {
      ComponentClass: ComponentClass,
      layout: layout
    };
  };
  var InternalManager = /*#__PURE__*/function (_BaseInternalComponen4) {
    (0, _emberBabel.inheritsLoose)(InternalManager, _BaseInternalComponen4);
    function InternalManager(owner, name) {
      var _this8;
      _this8 = _BaseInternalComponen4.call(this) || this;
      _this8.owner = owner;
      _this8.name = name;
      return _this8;
    }
    InternalManager.for = function _for(name) {
      return function (owner) {
        return new InternalManager(owner, name);
      };
    };
    var _proto21 = InternalManager.prototype;
    _proto21.getCapabilities = function getCapabilities() {
      return CAPABILITIES$2;
    };
    _proto21.create = function create(env, _ref16, args, _dynamicScope, caller) {
      var ComponentClass = _ref16.ComponentClass;
      (true && !((0, _reference.isConstRef)(caller)) && (0, _debug.assert)('caller must be const', (0, _reference.isConstRef)(caller)));
      (true && !(args.positional.length === 0) && (0, _debug.assert)("The " + this.name + " component does not take any positional arguments", args.positional.length === 0));
      var instance = new ComponentClass(this.owner, args.named.capture(), (0, _reference.valueForRef)(caller));
      var state = {
        env: env,
        instance: instance
      };
      return state;
    };
    _proto21.getDebugName = function getDebugName() {
      return this.name;
    };
    _proto21.getSelf = function getSelf(_ref17) {
      var instance = _ref17.instance;
      return (0, _reference.createConstRef)(instance, 'this');
    };
    _proto21.getDestroyable = function getDestroyable(state) {
      return state.instance;
    };
    _proto21.getStaticLayout = function getStaticLayout(_ref18) {
      var template = _ref18.layout;
      return template;
    };
    return InternalManager;
  }(_runtime2.BaseInternalComponentManager);
  var CAPABILITIES$3 = {
    dynamicLayout: false,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: false,
    attributeHook: false,
    elementHook: false,
    createCaller: false,
    dynamicScope: false,
    updateHook: false,
    createInstance: false,
    wrapped: false,
    willDestroy: false
  };
  var TemplateOnlyComponentManager = /*#__PURE__*/function () {
    function TemplateOnlyComponentManager() {}
    var _proto22 = TemplateOnlyComponentManager.prototype;
    _proto22.getStaticLayout = function getStaticLayout(_ref19) {
      var template = _ref19.template;
      return template;
    };
    _proto22.getCapabilities = function getCapabilities() {
      return CAPABILITIES$3;
    };
    _proto22.getDebugName = function getDebugName(_ref20) {
      var name = _ref20.name;
      return name;
    };
    _proto22.getSelf = function getSelf() {
      return _reference.NULL_REFERENCE;
    };
    _proto22.getDestroyable = function getDestroyable() {
      return null;
    };
    return TemplateOnlyComponentManager;
  }();
  var MANAGER = new TemplateOnlyComponentManager();
  var TemplateOnlyComponentDefinition = /*#__PURE__*/function () {
    function TemplateOnlyComponentDefinition(name, template) {
      this.name = name;
      this.template = template;
      this.manager = MANAGER;
    }
    (0, _emberBabel.createClass)(TemplateOnlyComponentDefinition, [{
      key: "state",
      get: function get() {
        return this;
      }
    }]);
    return TemplateOnlyComponentDefinition;
  }();
  var helper$1;
  if (true /* DEBUG */) {
    helper$1 = function helper$1(args) {
      var inner = args.positional.at(0);
      var messageRef = args.positional.at(1);
      return (0, _reference.createComputeRef)(function () {
        var value = (0, _reference.valueForRef)(inner);
        (true && !(typeof value !== 'string') && (0, _debug.assert)((0, _reference.valueForRef)(messageRef), typeof value !== 'string'));
        return value;
      });
    };
  } else {
    helper$1 = function helper$1(args) {
      return args.positional.at(0);
    };
  }
  var componentAssertionHelper = helper$1;
  var helper$2;
  if (true /* DEBUG */) {
    helper$2 = function helper$2(args) {
      var inner = args.positional.at(0);
      return (0, _reference.createComputeRef)(function () {
        var value = (0, _reference.valueForRef)(inner);
        (true && !(value !== null && value !== undefined) && (0, _debug.assert)('You cannot pass a null or undefined destination element to in-element', value !== null && value !== undefined));
        return value;
      });
    };
  } else {
    helper$2 = function helper$2(args) {
      return args.positional.at(0);
    };
  }
  var inElementNullCheckHelper = helper$2;
  function normalizeClassHelper(args) {
    var positional = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      var classNameParts = (0, _reference.valueForRef)(positional[0]).split('.');
      var className = classNameParts[classNameParts.length - 1];
      var value = (0, _reference.valueForRef)(positional[1]);
      if (value === true) {
        return (0, _string.dasherize)(className);
      } else if (!value && value !== 0) {
        return '';
      } else {
        return String(value);
      }
    });
  }

  /**
  @module ember
  */
  /**
    This reference is used to get the `[]` tag of iterables, so we can trigger
    updates to `{{each}}` when it changes. It is put into place by a template
    transform at build time, similar to the (-each-in) helper
  */

  function trackArray(args) {
    var inner = args.positional.at(0);
    return (0, _reference.createComputeRef)(function () {
      var iterable = (0, _reference.valueForRef)(inner);
      if ((0, _utils.isObject)(iterable)) {
        (0, _validator.consumeTag)((0, _metal.tagForProperty)(iterable, '[]'));
      }
      return iterable;
    });
  }

  /**
  @module ember
  */

  /**
     Use the `{{array}}` helper to create an array to pass as an option to your
     components.
  
     ```handlebars
     <MyComponent @people={{array
       'Tom Dale'
       'Yehuda Katz'
       this.myOtherPerson}}
     />
     ```
      or
     ```handlebars
     {{my-component people=(array
       'Tom Dale'
       'Yehuda Katz'
       this.myOtherPerson)
     }}
     ```
  
     Would result in an object such as:
  
     ```js
     ['Tom Dale', 'Yehuda Katz', this.get('myOtherPerson')]
     ```
  
     Where the 3rd item in the array is bound to updates of the `myOtherPerson` property.
  
     @method array
     @for Ember.Templates.helpers
     @param {Array} options
     @return {Array} Array
     @since 3.8.0
     @public
   */

  function array(args) {
    var captured = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      return (0, _runtime2.reifyPositional)(captured);
    }, null, 'array');
  }
  var isEmpty = function isEmpty(value) {
    return value === null || value === undefined || typeof value.toString !== 'function';
  };
  var normalizeTextValue = function normalizeTextValue(value) {
    if (isEmpty(value)) {
      return '';
    }
    return String(value);
  };
  /**
  @module ember
  */

  /**
    Concatenates the given arguments into a string.
  
    Example:
  
    ```handlebars
    {{some-component name=(concat firstName " " lastName)}}
  
    {{! would pass name="<first name value> <last name value>" to the component}}
    ```
  
    or for angle bracket invocation, you actually don't need concat at all.
  
    ```handlebars
    <SomeComponent @name="{{firstName}} {{lastName}}" />
    ```
  
    @public
    @method concat
    @for Ember.Templates.helpers
    @since 1.13.0
  */

  function concat(args) {
    var captured = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      return (0, _runtime2.reifyPositional)(captured).map(normalizeTextValue).join('');
    }, null, 'concat');
  }
  function buildUntouchableThis(source) {
    var context = null;
    if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY) {
      var assertOnProperty = function assertOnProperty(property) {
        (true && !(false) && (0, _debug.assert)("You accessed `this." + String(property) + "` from a function passed to the " + source + ", but the function itself was not bound to a valid `this` context. Consider updating to usage of `@action`."));
      };
      context = new Proxy({}, {
        get: function get(_target, property) {
          assertOnProperty(property);
        },
        set: function set(_target, property) {
          assertOnProperty(property);
          return false;
        },
        has: function has(_target, property) {
          assertOnProperty(property);
          return false;
        }
      });
    }
    return context;
  }
  var context = buildUntouchableThis('`fn` helper');
  /**
  @module ember
  */

  /**
    The `fn` helper allows you to ensure a function that you are passing off
    to another component, helper, or modifier has access to arguments that are
    available in the template.
  
    For example, if you have an `each` helper looping over a number of items, you
    may need to pass a function that expects to receive the item as an argument
    to a component invoked within the loop. Here's how you could use the `fn`
    helper to pass both the function and its arguments together:
  
      ```app/templates/components/items-listing.hbs
    {{#each @items as |item|}}
      <DisplayItem @item=item @select={{fn this.handleSelected item}} />
    {{/each}}
    ```
  
    ```app/components/items-list.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class ItemsList extends Component {
      @action
      handleSelected(item) {
        // ...snip...
      }
    }
    ```
  
    In this case the `display-item` component will receive a normal function
    that it can invoke. When it invokes the function, the `handleSelected`
    function will receive the `item` and any arguments passed, thanks to the
    `fn` helper.
  
    Let's take look at what that means in a couple circumstances:
  
    - When invoked as `this.args.select()` the `handleSelected` function will
      receive the `item` from the loop as its first and only argument.
    - When invoked as `this.args.select('foo')` the `handleSelected` function
      will receive the `item` from the loop as its first argument and the
      string `'foo'` as its second argument.
  
    In the example above, we used `@action` to ensure that `handleSelected` is
    properly bound to the `items-list`, but let's explore what happens if we
    left out `@action`:
  
    ```app/components/items-list.js
    import Component from '@glimmer/component';
  
    export default class ItemsList extends Component {
      handleSelected(item) {
        // ...snip...
      }
    }
    ```
  
    In this example, when `handleSelected` is invoked inside the `display-item`
    component, it will **not** have access to the component instance. In other
    words, it will have no `this` context, so please make sure your functions
    are bound (via `@action` or other means) before passing into `fn`!
  
    See also [partial application](https://en.wikipedia.org/wiki/Partial_application).
  
    @method fn
    @for Ember.Templates.helpers
    @public
    @since 3.11.0
  */

  function fn(args) {
    var positional = args.positional.capture();
    var callbackRef = positional[0];
    if (true /* DEBUG */) assertCallbackIsFn(callbackRef);
    return (0, _reference.createComputeRef)(function () {
      return function () {
        var _reifyPositional = (0, _runtime2.reifyPositional)(positional),
          fn = _reifyPositional[0],
          args = _reifyPositional.slice(1);
        if (true /* DEBUG */) assertCallbackIsFn(callbackRef);
        for (var _len2 = arguments.length, invocationArgs = new Array(_len2), _key3 = 0; _key3 < _len2; _key3++) {
          invocationArgs[_key3] = arguments[_key3];
        }
        if ((0, _reference.isInvokableRef)(callbackRef)) {
          var value = args.length > 0 ? args[0] : invocationArgs[0];
          return (0, _reference.updateRef)(callbackRef, value);
        } else {
          return fn.call.apply(fn, [context].concat(args, invocationArgs));
        }
      };
    }, null, 'fn');
  }
  function assertCallbackIsFn(callbackRef) {
    (true && !(callbackRef && ((0, _reference.isInvokableRef)(callbackRef) || typeof (0, _reference.valueForRef)(callbackRef) === 'function')) && (0, _debug.assert)("You must pass a function as the `fn` helpers first argument, you passed " + (callbackRef ? (0, _reference.valueForRef)(callbackRef) : callbackRef) + ". While rendering:\n\n" + (callbackRef === null || callbackRef === void 0 ? void 0 : callbackRef.debugLabel), callbackRef && ((0, _reference.isInvokableRef)(callbackRef) || typeof (0, _reference.valueForRef)(callbackRef) === 'function')));
  }

  /**
  @module ember
  */

  /**
    Dynamically look up a property on an object. The second argument to `{{get}}`
    should have a string value, although it can be bound.
  
    For example, these two usages are equivalent:
  
    ```app/components/developer-detail.js
    import Component from '@glimmer/component';
    import { tracked } from '@glimmer/tracking';
  
    export default class extends Component {
      @tracked developer = {
        name: "Sandi Metz",
        language: "Ruby"
      }
    }
    ```
  
    ```handlebars
    {{this.developer.name}}
    {{get this.developer "name"}}
    ```
  
    If there were several facts about a person, the `{{get}}` helper can dynamically
    pick one:
  
    ```app/templates/application.hbs
    <DeveloperDetail @factName="language" />
    ```
  
    ```handlebars
    {{get this.developer @factName}}
    ```
  
    For a more complex example, this template would allow the user to switch
    between showing the user's height and weight with a click:
  
    ```app/components/developer-detail.js
    import Component from '@glimmer/component';
    import { tracked } from '@glimmer/tracking';
  
    export default class extends Component {
      @tracked developer = {
        name: "Sandi Metz",
        language: "Ruby"
      }
  
      @tracked currentFact = 'name'
  
      @action
      showFact(fact) {
        this.currentFact = fact;
      }
    }
    ```
  
    ```app/components/developer-detail.js
    {{get this.developer this.currentFact}}
  
    <button {{on 'click' (fn this.showFact "name")}}>Show name</button>
    <button {{on 'click' (fn this.showFact "language")}}>Show language</button>
    ```
  
    The `{{get}}` helper can also respect mutable values itself. For example:
  
    ```app/components/developer-detail.js
    <Input @value={{mut (get this.person this.currentFact)}} />
  
    <button {{on 'click' (fn this.showFact "name")}}>Show name</button>
    <button {{on 'click' (fn this.showFact "language")}}>Show language</button>
    ```
  
    Would allow the user to swap what fact is being displayed, and also edit
    that fact via a two-way mutable binding.
  
    @public
    @method get
    @for Ember.Templates.helpers
    @since 2.1.0
   */

  function get$1(args) {
    var sourceRef = args.positional.at(0);
    var pathRef = args.positional.at(1);
    if ((0, _reference.isConstRef)(pathRef)) {
      // Since the path is constant, we can create a normal chain of property
      // references. The source reference will update like normal, and all of the
      // child references will update accordingly.
      var path = (0, _reference.valueForRef)(pathRef);
      if (path === undefined || path === null || path === '') {
        return _reference.NULL_REFERENCE;
      } else if (typeof path === 'string' && path.indexOf('.') > -1) {
        return (0, _reference.childRefFromParts)(sourceRef, path.split('.'));
      } else {
        return (0, _reference.childRefFor)(sourceRef, String(path));
      }
    } else {
      return (0, _reference.createComputeRef)(function () {
        var source = (0, _reference.valueForRef)(sourceRef);
        if ((0, _utils.isObject)(source)) {
          return (0, _metal.get)(source, String((0, _reference.valueForRef)(pathRef)));
        }
      }, function (value) {
        var source = (0, _reference.valueForRef)(sourceRef);
        if ((0, _utils.isObject)(source)) {
          return (0, _metal.set)(source, String((0, _reference.valueForRef)(pathRef)), value);
        }
      }, 'get');
    }
  }

  /**
  @module ember
  */

  /**
     Use the `{{hash}}` helper to create a hash to pass as an option to your
     components. This is specially useful for contextual components where you can
     just yield a hash:
  
     ```handlebars
     {{yield (hash
        name='Sarah'
        title=office
     )}}
     ```
  
     Would result in an object such as:
  
     ```js
     { name: 'Sarah', title: this.get('office') }
     ```
  
     Where the `title` is bound to updates of the `office` property.
  
     Note that the hash is an empty object with no prototype chain, therefore
     common methods like `toString` are not available in the resulting hash.
     If you need to use such a method, you can use the `call` or `apply`
     approach:
  
     ```js
     function toString(obj) {
       return Object.prototype.toString.apply(obj);
     }
     ```
  
     @method hash
     @for Ember.Templates.helpers
     @param {Object} options
     @return {Object} Hash
     @since 2.3.0
     @public
   */

  function hash(args) {
    var positional = args.named.capture();
    return (0, _reference.createComputeRef)(function () {
      return (0, _runtime2.reifyNamed)(positional);
    }, null, 'hash');
  }

  /**
  @module ember
  */
  /**
    The `if` helper allows you to conditionally render one of two branches,
    depending on the "truthiness" of a property.
    For example the following values are all falsey: `false`, `undefined`, `null`, `""`, `0`, `NaN` or an empty array.
  
    This helper has two forms, block and inline.
  
    ## Block form
  
    You can use the block form of `if` to conditionally render a section of the template.
  
    To use it, pass the conditional value to the `if` helper,
    using the block form to wrap the section of template you want to conditionally render.
    Like so:
  
    ```app/templates/application.hbs
    <Weather />
    ```
  
    ```app/components/weather.hbs
    {{! will not render because greeting is undefined}}
    {{#if @isRaining}}
      Yes, grab an umbrella!
    {{/if}}
    ```
  
    You can also define what to show if the property is falsey by using
    the `else` helper.
  
    ```app/components/weather.hbs
    {{#if @isRaining}}
      Yes, grab an umbrella!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    You are also able to combine `else` and `if` helpers to create more complex
    conditional logic.
  
    For the following template:
  
     ```app/components/weather.hbs
    {{#if @isRaining}}
      Yes, grab an umbrella!
    {{else if @isCold}}
      Grab a coat, it's chilly!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    If you call it by saying `isCold` is true:
  
    ```app/templates/application.hbs
    <Weather @isCold={{true}} />
    ```
  
    Then `Grab a coat, it's chilly!` will be rendered.
  
    ## Inline form
  
    The inline `if` helper conditionally renders a single property or string.
  
    In this form, the `if` helper receives three arguments, the conditional value,
    the value to render when truthy, and the value to render when falsey.
  
    For example, if `useLongGreeting` is truthy, the following:
  
    ```app/templates/application.hbs
    <Greeting @useLongGreeting={{true}} />
    ```
  
    ```app/components/greeting.hbs
    {{if @useLongGreeting "Hello" "Hi"}} Alex
    ```
  
    Will render:
  
    ```html
    Hello Alex
    ```
  
    One detail to keep in mind is that both branches of the `if` helper will be evaluated,
    so if you have `{{if condition "foo" (expensive-operation "bar")`,
    `expensive-operation` will always calculate.
  
    @method if
    @for Ember.Templates.helpers
    @public
  */

  function inlineIf(args) {
    var positional = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      (true && !(positional.length === 3 || positional.length === 2) && (0, _debug.assert)('The inline form of the `if` helper expects two or three arguments, e.g. `{{if trialExpired "Expired" expiryDate}}`.', positional.length === 3 || positional.length === 2));
      var condition = positional[0],
        truthyValue = positional[1],
        falsyValue = positional[2];
      if ((0, _globalContext.toBool)((0, _reference.valueForRef)(condition)) === true) {
        return (0, _reference.valueForRef)(truthyValue);
      } else {
        return falsyValue !== undefined ? (0, _reference.valueForRef)(falsyValue) : undefined;
      }
    }, null, 'if');
  }
  /**
    The `unless` helper is the inverse of the `if` helper. It displays if a value
    is falsey ("not true" or "is false"). Example values that will display with
    `unless`: `false`, `undefined`, `null`, `""`, `0`, `NaN` or an empty array.
  
    ## Inline form
  
    The inline `unless` helper conditionally renders a single property or string.
    This helper acts like a ternary operator. If the first property is falsy,
    the second argument will be displayed, otherwise, the third argument will be
    displayed
  
    For example, if you pass a falsey `useLongGreeting` to the `Greeting` component:
  
    ```app/templates/application.hbs
    <Greeting @useLongGreeting={{false}} />
    ```
  
    ```app/components/greeting.hbs
    {{unless @useLongGreeting "Hi" "Hello"}} Ben
    ```
  
    Then it will display:
  
    ```html
    Hi Ben
    ```
  
    ## Block form
  
    Like the `if` helper, the `unless` helper also has a block form.
  
    The following will not render anything:
  
    ```app/templates/application.hbs
    <Greeting />
    ```
  
    ```app/components/greeting.hbs
    {{#unless @greeting}}
      No greeting was found. Why not set one?
    {{/unless}}
    ```
  
    You can also use an `else` helper with the `unless` block. The
    `else` will display if the value is truthy.
  
    If you have the following component:
  
    ```app/components/logged-in.hbs
    {{#unless @userData}}
      Please login.
    {{else}}
      Welcome back!
    {{/unless}}
    ```
  
    Calling it with a truthy `userData`:
  
    ```app/templates/application.hbs
    <LoggedIn @userData={{hash username="Zoey"}} />
    ```
  
    Will render:
  
    ```html
    Welcome back!
    ```
  
    and calling it with a falsey `userData`:
  
    ```app/templates/application.hbs
    <LoggedIn @userData={{false}} />
    ```
  
    Will render:
  
    ```html
    Please login.
    ```
  
    @method unless
    @for Ember.Templates.helpers
    @public
  */

  function inlineUnless(args) {
    var positional = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      (true && !(positional.length === 3 || positional.length === 2) && (0, _debug.assert)('The inline form of the `unless` helper expects two or three arguments, e.g. `{{unless isFirstLogin "Welcome back!"}}`.', positional.length === 3 || positional.length === 2));
      var condition = positional[0],
        falsyValue = positional[1],
        truthyValue = positional[2];
      if ((0, _globalContext.toBool)((0, _reference.valueForRef)(condition)) === true) {
        return truthyValue !== undefined ? (0, _reference.valueForRef)(truthyValue) : undefined;
      } else {
        return (0, _reference.valueForRef)(falsyValue);
      }
    }, null, 'unless');
  }

  /**
  @module ember
  */

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.
  
    ```handlebars
    {{log "myVariable:" myVariable }}
    ```
  
    @method log
    @for Ember.Templates.helpers
    @param {Array} params
    @public
  */

  function log(args) {
    var positional = args.positional.capture();
    return (0, _reference.createComputeRef)(function () {
      var _console;
      /* eslint-disable no-console */
      (_console = console).log.apply(_console, (0, _runtime2.reifyPositional)(positional));
      /* eslint-enable no-console */
    });
  }

  /**
  @module ember
  */
  /**
    The `mut` helper lets you __clearly specify__ that a child `Component` can update the
    (mutable) value passed to it, which will __change the value of the parent component__.
  
    To specify that a parameter is mutable, when invoking the child `Component`:
  
    ```handlebars
    <MyChild @childClickCount={{fn (mut totalClicks)}} />
    ```
  
     or
  
    ```handlebars
    {{my-child childClickCount=(mut totalClicks)}}
    ```
  
    The child `Component` can then modify the parent's value just by modifying its own
    property:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    Note that for curly components (`{{my-component}}`) the bindings are already mutable,
    making the `mut` unnecessary.
  
    Additionally, the `mut` helper can be combined with the `fn` helper to
    mutate a value. For example:
  
    ```handlebars
    <MyChild @childClickCount={{this.totalClicks}} @click-count-change={{fn (mut totalClicks))}} />
    ```
  
    or
  
    ```handlebars
    {{my-child childClickCount=totalClicks click-count-change=(fn (mut totalClicks))}}
    ```
  
    The child `Component` would invoke the function with the new click value:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('click-count-change')(this.get('childClickCount') + 1);
      }
    });
    ```
  
    The `mut` helper changes the `totalClicks` value to what was provided as the `fn` argument.
  
    The `mut` helper, when used with `fn`, will return a function that
    sets the value passed to `mut` to its first argument. As an example, we can create a
    button that increments a value passing the value directly to the `fn`:
  
    ```handlebars
    {{! inc helper is not provided by Ember }}
    <button onclick={{fn (mut count) (inc count)}}>
      Increment count
    </button>
    ```
  
    @method mut
    @param {Object} [attr] the "two-way" attribute that can be modified.
    @for Ember.Templates.helpers
    @public
  */

  function mut(args) {
    var ref = args.positional.at(0); // TODO: Improve this error message. This covers at least two distinct
    // cases:
    //
    // 1. (mut "not a path") – passing a literal, result from a helper
    //    invocation, etc
    //
    // 2. (mut receivedValue) – passing a value received from the caller
    //    that was originally derived from a literal, result from a helper
    //    invocation, etc
    //
    // This message is alright for the first case, but could be quite
    // confusing for the second case.
    (true && !((0, _reference.isUpdatableRef)(ref)) && (0, _debug.assert)('You can only pass a path to mut', (0, _reference.isUpdatableRef)(ref)));
    return (0, _reference.createInvokableRef)(ref);
  }

  /**
  @module ember
  */
  /**
    This is a helper to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.
  
    @example In this example we are setting the `direction` query param to the value `"asc"`
  
    ```app/templates/application.hbs
    <LinkTo
      @route="posts"
      {{query-params direction="asc"}}
    >
      Sort
    </LinkTo>
    ```
  
    @method query-params
    @for Ember.Templates.helpers
    @param {Object} hash takes a hash of query parameters
    @return {Object} A `QueryParams` object for `{{link-to}}`
    @public
  */

  function queryParams(args) {
    var _args$capture = args.capture(),
      positional = _args$capture.positional,
      named = _args$capture.named;
    return (0, _reference.createComputeRef)(function () {
      (true && !(positional.length === 0) && (0, _debug.assert)("The `query-params` helper only accepts hash parameters, e.g. (query-params queryParamPropertyName='foo') as opposed to just (query-params 'foo')", positional.length === 0));
      return new _routing.QueryParams((0, _polyfills.assign)({}, (0, _runtime2.reifyNamed)(named)));
    });
  }

  /**
    The `readonly` helper let's you specify that a binding is one-way only,
    instead of two-way.
    When you pass a `readonly` binding from an outer context (e.g. parent component),
    to to an inner context (e.g. child component), you are saying that changing that
    property in the inner context does not change the value in the outer context.
  
    To specify that a binding is read-only, when invoking the child `Component`:
  
    ```app/components/my-parent.js
    export default Component.extend({
      totalClicks: 3
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} // -> 3
    <MyChild @childClickCount={{readonly totalClicks}} />
    ```
    ```
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    Now, when you update `childClickCount`:
  
    ```app/components/my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    The value updates in the child component, but not the parent component:
  
    ```app/templates/components/my-child.hbs
    {{log childClickCount}} //-> 4
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} //-> 3
    <MyChild @childClickCount={{readonly totalClicks}} />
    ```
    or
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} //-> 3
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    ### Objects and Arrays
  
    When passing a property that is a complex object (e.g. object, array) instead of a primitive object (e.g. number, string),
    only the reference to the object is protected using the readonly helper.
    This means that you can change properties of the object both on the parent component, as well as the child component.
    The `readonly` binding behaves similar to the `const` keyword in JavaScript.
  
    Let's look at an example:
  
    First let's set up the parent component:
  
    ```app/components/my-parent.js
    import Component from '@ember/component';
  
    export default Component.extend({
      clicks: null,
  
      init() {
        this._super(...arguments);
        this.set('clicks', { total: 3 });
      }
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 3
    <MyChild @childClicks={{readonly clicks}} />
    ```
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 3
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    Now, if you update the `total` property of `childClicks`:
  
    ```app/components/my-child.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click() {
        this.get('clicks').incrementProperty('total');
      }
    });
    ```
  
    You will see the following happen:
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 4
    <MyChild @childClicks={{readonly clicks}} />
    ```
    or
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 4
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    ```app/templates/components/my-child.hbs
    {{log childClicks.total}} //-> 4
    ```
  
    @method readonly
    @param {Object} [attr] the read-only attribute.
    @for Ember.Templates.helpers
    @private
  */

  function readonly(args) {
    return (0, _reference.createReadOnlyRef)(args.positional.at(0));
  }

  /**
  @module ember
  */
  /**
    The `{{unbound}}` helper disconnects the one-way binding of a property,
    essentially freezing its value at the moment of rendering. For example,
    in this example the display of the variable `name` will not change even
    if it is set with a new value:
  
    ```handlebars
    {{unbound this.name}}
    ```
  
    Like any helper, the `unbound` helper can accept a nested helper expression.
    This allows for custom helpers to be rendered unbound:
  
    ```handlebars
    {{unbound (some-custom-helper)}}
    {{unbound (capitalize this.name)}}
    {{! You can use any helper, including unbound, in a nested expression }}
    {{capitalize (unbound this.name)}}
    ```
  
    The `unbound` helper only accepts a single argument, and it return an
    unbound value.
  
    @method unbound
    @for Ember.Templates.helpers
    @public
  */

  function unbound(args) {
    (true && !(args.positional.length === 1 && args.named.length === 0) && (0, _debug.assert)('unbound helper cannot be called with multiple params or hash params', args.positional.length === 1 && args.named.length === 0));
    return (0, _reference.createUnboundRef)((0, _reference.valueForRef)(args.positional.at(0)), '(resurt of an `unbound` helper)');
  }
  var MODIFIERS = ['alt', 'shift', 'meta', 'ctrl'];
  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;
  function isAllowedEvent(event, allowedKeys) {
    if (allowedKeys === null || allowedKeys === undefined) {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return (0, _views.isSimpleClick)(event);
      } else {
        allowedKeys = '';
      }
    }
    if (allowedKeys.indexOf('any') >= 0) {
      return true;
    }
    for (var i = 0; i < MODIFIERS.length; i++) {
      if (event[MODIFIERS[i] + 'Key'] && allowedKeys.indexOf(MODIFIERS[i]) === -1) {
        return false;
      }
    }
    return true;
  }
  var ActionHelper = {
    // registeredActions is re-exported for compatibility with older plugins
    // that were using this undocumented API.
    registeredActions: _views.ActionManager.registeredActions,
    registerAction: function registerAction(actionState) {
      var actionId = actionState.actionId;
      _views.ActionManager.registeredActions[actionId] = actionState;
      return actionId;
    },
    unregisterAction: function unregisterAction(actionState) {
      var actionId = actionState.actionId;
      delete _views.ActionManager.registeredActions[actionId];
    }
  };
  var ActionState = /*#__PURE__*/function () {
    function ActionState(element, actionId, actionArgs, namedArgs, positionalArgs, dom) {
      var _this9 = this;
      this.tag = (0, _validator.createUpdatableTag)();
      this.element = element;
      this.actionId = actionId;
      this.actionArgs = actionArgs;
      this.namedArgs = namedArgs;
      this.positional = positionalArgs;
      this.dom = dom;
      this.eventName = this.getEventName();
      (0, _runtime2.registerDestructor)(this, function () {
        return ActionHelper.unregisterAction(_this9);
      });
    }
    var _proto23 = ActionState.prototype;
    _proto23.getEventName = function getEventName() {
      var on = this.namedArgs.on;
      return on !== undefined ? (0, _reference.valueForRef)(on) : 'click';
    };
    _proto23.getActionArgs = function getActionArgs() {
      var result = new Array(this.actionArgs.length);
      for (var i = 0; i < this.actionArgs.length; i++) {
        result[i] = (0, _reference.valueForRef)(this.actionArgs[i]);
      }
      return result;
    };
    _proto23.getTarget = function getTarget() {
      var implicitTarget = this.implicitTarget,
        namedArgs = this.namedArgs;
      var target = namedArgs.target;
      return target !== undefined ? (0, _reference.valueForRef)(target) : (0, _reference.valueForRef)(implicitTarget);
    };
    _proto23.handler = function handler(event) {
      var _this10 = this;
      var actionName = this.actionName,
        namedArgs = this.namedArgs;
      var bubbles = namedArgs.bubbles,
        preventDefault = namedArgs.preventDefault,
        allowedKeys = namedArgs.allowedKeys;
      var bubblesVal = bubbles !== undefined ? (0, _reference.valueForRef)(bubbles) : undefined;
      var preventDefaultVal = preventDefault !== undefined ? (0, _reference.valueForRef)(preventDefault) : undefined;
      var allowedKeysVal = allowedKeys !== undefined ? (0, _reference.valueForRef)(allowedKeys) : undefined;
      var target = this.getTarget();
      var shouldBubble = bubblesVal !== false;
      if (!isAllowedEvent(event, allowedKeysVal)) {
        return true;
      }
      if (preventDefaultVal !== false) {
        event.preventDefault();
      }
      if (!shouldBubble) {
        event.stopPropagation();
      }
      (0, _runloop.join)(function () {
        var args = _this10.getActionArgs();
        var payload = {
          args: args,
          target: target,
          name: null
        };
        if (typeof actionName[INVOKE] === 'function') {
          (true && !(false) && (0, _debug.deprecate)("Usage of the private INVOKE API to make an object callable via action or fn is no longer supported. Please update to pass in a callback function instead. Received: " + String(actionName), false, {
            until: '3.25.0',
            id: 'actions.custom-invoke-invokable',
            for: 'ember-source',
            since: {
              enabled: '3.23.0-beta.1'
            }
          }));
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
            actionName[INVOKE].apply(actionName, args);
          });
          return;
        }
        if ((0, _reference.isInvokableRef)(actionName)) {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
            (0, _reference.updateRef)(actionName, args[0]);
          });
          return;
        }
        if (typeof actionName === 'function') {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
            actionName.apply(target, args);
          });
          return;
        }
        payload.name = actionName;
        if (target.send) {
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
            target.send.apply(target, [actionName].concat(args));
          });
        } else {
          (true && !(typeof target[actionName] === 'function') && (0, _debug.assert)("The action '" + actionName + "' did not exist on " + target, typeof target[actionName] === 'function'));
          (0, _instrumentation.flaggedInstrument)('interaction.ember-action', payload, function () {
            target[actionName].apply(target, args);
          });
        }
      });
      return shouldBubble;
    };
    return ActionState;
  }(); // implements ModifierManager<Action>
  var ActionModifierManager = /*#__PURE__*/function () {
    function ActionModifierManager() {}
    var _proto24 = ActionModifierManager.prototype;
    _proto24.create = function create(element, _state, args, _dynamicScope, dom) {
      var _args$capture2 = args.capture(),
        named = _args$capture2.named,
        positional = _args$capture2.positional;
      var actionArgs = []; // The first two arguments are (1) `this` and (2) the action name.
      // Everything else is a param.

      for (var i = 2; i < positional.length; i++) {
        actionArgs.push(positional[i]);
      }
      var actionId = (0, _utils.uuid)();
      var actionState = new ActionState(element, actionId, actionArgs, named, positional, dom);
      (true && !(actionState.eventName !== 'mouseEnter' && actionState.eventName !== 'mouseLeave' && actionState.eventName !== 'mouseMove') && (0, _debug.deprecate)("Using the `{{action}}` modifier with `" + actionState.eventName + "` events has been deprecated.", actionState.eventName !== 'mouseEnter' && actionState.eventName !== 'mouseLeave' && actionState.eventName !== 'mouseMove', {
        id: 'ember-views.event-dispatcher.mouseenter-leave-move',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_action-mouseenter-leave-move',
        for: 'ember-source',
        since: {
          enabled: '3.13.0-beta.1'
        }
      }));
      return actionState;
    };
    _proto24.getDebugName = function getDebugName() {
      return 'action';
    };
    _proto24.install = function install(actionState) {
      var dom = actionState.dom,
        element = actionState.element,
        actionId = actionState.actionId,
        positional = actionState.positional;
      var actionName;
      var actionNameRef;
      var implicitTarget;
      if (positional.length > 1) {
        implicitTarget = positional[0];
        actionNameRef = positional[1];
        if ((0, _reference.isInvokableRef)(actionNameRef)) {
          actionName = actionNameRef;
        } else {
          actionName = (0, _reference.valueForRef)(actionNameRef);
          if (true /* DEBUG */) {
            var actionPath = actionNameRef.debugLabel;
            var actionPathParts = actionPath.split('.');
            var actionLabel = actionPathParts[actionPathParts.length - 1];
            (true && !(typeof actionName === 'string' || typeof actionName === 'function') && (0, _debug.assert)('You specified a quoteless path, `' + actionPath + '`, to the ' + '{{action}} helper which did not resolve to an action name (a ' + 'string). Perhaps you meant to use a quoted actionName? (e.g. ' + '{{action "' + actionLabel + '"}}).', typeof actionName === 'string' || typeof actionName === 'function'));
          }
        }
      }
      actionState.actionName = actionName;
      actionState.implicitTarget = implicitTarget;
      ActionHelper.registerAction(actionState);
      dom.setAttribute(element, 'data-ember-action', '');
      dom.setAttribute(element, "data-ember-action-" + actionId, String(actionId));
    };
    _proto24.update = function update(actionState) {
      var positional = actionState.positional;
      var actionNameRef = positional[1];
      if (!(0, _reference.isInvokableRef)(actionNameRef)) {
        actionState.actionName = (0, _reference.valueForRef)(actionNameRef);
      }
      actionState.eventName = actionState.getEventName();
    };
    _proto24.getTag = function getTag(actionState) {
      return actionState.tag;
    };
    _proto24.getDestroyable = function getDestroyable(actionState) {
      return actionState;
    };
    return ActionModifierManager;
  }();
  function capabilities$1(managerAPI, optionalFeatures) {
    if (optionalFeatures === void 0) {
      optionalFeatures = {};
    }
    (true && !(managerAPI === '3.13' || managerAPI === '3.22') && (0, _debug.assert)('Invalid modifier manager compatibility specified', managerAPI === '3.13' || managerAPI === '3.22'));
    return (0, _runtime2.buildCapabilities)({
      disableAutoTracking: Boolean(optionalFeatures.disableAutoTracking),
      useArgsProxy: managerAPI === '3.13' ? false : true,
      passFactoryToCreate: managerAPI === '3.13'
    });
  }
  var CustomModifierDefinition = function CustomModifierDefinition(name, ModifierClass, delegate, isInteractive) {
    this.name = name;
    this.ModifierClass = ModifierClass;
    this.delegate = delegate;
    this.state = {
      ModifierClass: ModifierClass,
      name: name,
      delegate: delegate
    };
    this.manager = isInteractive ? CUSTOM_INTERACTIVE_MODIFIER_MANAGER : CUSTOM_NON_INTERACTIVE_MODIFIER_MANAGER;
  };
  /**
    The CustomModifierManager allows addons to provide custom modifier
    implementations that integrate seamlessly into Ember. This is accomplished
    through a delegate, registered with the custom modifier manager, which
    implements a set of hooks that determine modifier behavior.
    To create a custom modifier manager, instantiate a new CustomModifierManager
    class and pass the delegate as the first argument:
  
    ```js
    let manager = new CustomModifierManager({
      // ...delegate implementation...
    });
    ```
  
    ## Delegate Hooks
  
    Throughout the lifecycle of a modifier, the modifier manager will invoke
    delegate hooks that are responsible for surfacing those lifecycle changes to
    the end developer.
    * `createModifier()` - invoked when a new instance of a modifier should be created
    * `installModifier()` - invoked when the modifier is installed on the element
    * `updateModifier()` - invoked when the arguments passed to a modifier change
    * `destroyModifier()` - invoked when the modifier is about to be destroyed
  */
  var InteractiveCustomModifierManager = /*#__PURE__*/function () {
    function InteractiveCustomModifierManager() {}
    var _proto25 = InteractiveCustomModifierManager.prototype;
    _proto25.create = function create(element, definition, vmArgs) {
      var delegate = definition.delegate,
        ModifierClass = definition.ModifierClass;
      var capturedArgs = vmArgs.capture();
      var _delegate$capabilitie = delegate.capabilities,
        useArgsProxy = _delegate$capabilitie.useArgsProxy,
        passFactoryToCreate = _delegate$capabilitie.passFactoryToCreate;
      var args = useArgsProxy ? argsProxyFor(capturedArgs, 'modifier') : (0, _runtime2.reifyArgs)(capturedArgs);
      var instance;
      if (true /* DEBUG */ && _validator.deprecateMutationsInTrackingTransaction !== undefined) {
        (0, _validator.deprecateMutationsInTrackingTransaction)(function () {
          instance = delegate.createModifier(passFactoryToCreate ? ModifierClass : ModifierClass.class, args);
        });
      } else {
        instance = delegate.createModifier(passFactoryToCreate ? ModifierClass : ModifierClass.class, args);
      }
      var tag = (0, _validator.createUpdatableTag)();
      var state;
      if (useArgsProxy) {
        state = {
          tag: tag,
          element: element,
          delegate: delegate,
          args: args,
          modifier: instance
        };
      } else {
        state = {
          tag: tag,
          element: element,
          delegate: delegate,
          modifier: instance,
          get args() {
            return (0, _runtime2.reifyArgs)(capturedArgs);
          }
        };
      }
      if (true /* DEBUG */) {
        state.debugName = definition.name;
      }
      (0, _runtime2.registerDestructor)(state, function () {
        return delegate.destroyModifier(instance, state.args);
      });
      return state;
    };
    _proto25.getDebugName = function getDebugName(_ref21) {
      var debugName = _ref21.debugName;
      return debugName;
    };
    _proto25.getTag = function getTag(_ref22) {
      var tag = _ref22.tag;
      return tag;
    };
    _proto25.install = function install(state) {
      var element = state.element,
        args = state.args,
        delegate = state.delegate,
        modifier = state.modifier;
      var capabilities = delegate.capabilities;
      if (capabilities.disableAutoTracking === true) {
        (0, _validator.untrack)(function () {
          return delegate.installModifier(modifier, element, args);
        });
      } else {
        delegate.installModifier(modifier, element, args);
      }
    };
    _proto25.update = function update(state) {
      var args = state.args,
        delegate = state.delegate,
        modifier = state.modifier;
      var capabilities = delegate.capabilities;
      if (capabilities.disableAutoTracking === true) {
        (0, _validator.untrack)(function () {
          return delegate.updateModifier(modifier, args);
        });
      } else {
        delegate.updateModifier(modifier, args);
      }
    };
    _proto25.getDestroyable = function getDestroyable(state) {
      return state;
    };
    return InteractiveCustomModifierManager;
  }();
  var NonInteractiveCustomModifierManager = /*#__PURE__*/function () {
    function NonInteractiveCustomModifierManager() {}
    var _proto26 = NonInteractiveCustomModifierManager.prototype;
    _proto26.create = function create() {
      return null;
    };
    _proto26.getDebugName = function getDebugName() {
      return '';
    };
    _proto26.getTag = function getTag() {
      return null;
    };
    _proto26.install = function install() {};
    _proto26.update = function update() {};
    _proto26.getDestroyable = function getDestroyable() {
      return null;
    };
    return NonInteractiveCustomModifierManager;
  }();
  var CUSTOM_INTERACTIVE_MODIFIER_MANAGER = new InteractiveCustomModifierManager();
  var CUSTOM_NON_INTERACTIVE_MODIFIER_MANAGER = new NonInteractiveCustomModifierManager();
  var untouchableContext = buildUntouchableThis('`on` modifier');
  /**
  @module ember
  */

  /*
    Internet Explorer 11 does not support `once` and also does not support
    passing `eventOptions`. In some situations it then throws a weird script
    error, like:
  
    ```
    Could not complete the operation due to error 80020101
    ```
  
    This flag determines, whether `{ once: true }` and thus also event options in
    general are supported.
  */

  var SUPPORTS_EVENT_OPTIONS = function () {
    try {
      var div = document.createElement('div');
      var counter = 0;
      div.addEventListener('click', function () {
        return counter++;
      }, {
        once: true
      });
      var event;
      if (typeof Event === 'function') {
        event = new Event('click');
      } else {
        event = document.createEvent('Event');
        event.initEvent('click', true, true);
      }
      div.dispatchEvent(event);
      div.dispatchEvent(event);
      return counter === 1;
    } catch (error) {
      return false;
    }
  }();
  var OnModifierState = /*#__PURE__*/function () {
    function OnModifierState(owner, element, args) {
      this.tag = (0, _validator.createUpdatableTag)();
      this.shouldUpdate = true;
      this.owner = owner;
      this.element = element;
      this.args = args;
    }
    var _proto27 = OnModifierState.prototype;
    _proto27.updateFromArgs = function updateFromArgs() {
      var args = this.args;
      var _reifyNamed = (0, _runtime2.reifyNamed)(args.named),
        once = _reifyNamed.once,
        passive = _reifyNamed.passive,
        capture = _reifyNamed.capture;
      if (once !== this.once) {
        this.once = once;
        this.shouldUpdate = true;
      }
      if (passive !== this.passive) {
        this.passive = passive;
        this.shouldUpdate = true;
      }
      if (capture !== this.capture) {
        this.capture = capture;
        this.shouldUpdate = true;
      }
      var options;
      if (once || passive || capture) {
        options = this.options = {
          once: once,
          passive: passive,
          capture: capture
        };
      } else {
        this.options = undefined;
      }
      (true && !(args.positional[0] !== undefined && typeof (0, _reference.valueForRef)(args.positional[0]) === 'string') && (0, _debug.assert)('You must pass a valid DOM event name as the first argument to the `on` modifier', args.positional[0] !== undefined && typeof (0, _reference.valueForRef)(args.positional[0]) === 'string'));
      var eventName = (0, _reference.valueForRef)(args.positional[0]);
      if (eventName !== this.eventName) {
        this.eventName = eventName;
        this.shouldUpdate = true;
      }
      var userProvidedCallbackReference = args.positional[1];
      if (true /* DEBUG */) {
        (true && !(args.positional[1] !== undefined) && (0, _debug.assert)("You must pass a function as the second argument to the `on` modifier.", args.positional[1] !== undefined));
        var value = (0, _reference.valueForRef)(userProvidedCallbackReference);
        (true && !(typeof value === 'function') && (0, _debug.assert)("You must pass a function as the second argument to the `on` modifier, you passed " + (value === null ? 'null' : typeof value) + ". While rendering:\n\n" + userProvidedCallbackReference.debugLabel, typeof value === 'function'));
      }
      var userProvidedCallback = (0, _reference.valueForRef)(userProvidedCallbackReference);
      if (userProvidedCallback !== this.userProvidedCallback) {
        this.userProvidedCallback = userProvidedCallback;
        this.shouldUpdate = true;
      }
      (true && !(args.positional.length === 2) && (0, _debug.assert)("You can only pass two positional arguments (event name and callback) to the `on` modifier, but you provided " + args.positional.length + ". Consider using the `fn` helper to provide additional arguments to the `on` callback.", args.positional.length === 2));
      var needsCustomCallback = SUPPORTS_EVENT_OPTIONS === false && once || /* needs manual once implementation */
      true /* DEBUG */ && passive;
      /* needs passive enforcement */

      if (this.shouldUpdate) {
        if (needsCustomCallback) {
          var callback = this.callback = function (event) {
            if (true /* DEBUG */ && passive) {
              event.preventDefault = function () {
                (true && !(false) && (0, _debug.assert)("You marked this listener as 'passive', meaning that you must not call 'event.preventDefault()': \n\n" + userProvidedCallback));
              };
            }
            if (!SUPPORTS_EVENT_OPTIONS && once) {
              removeEventListener(this, eventName, callback, options);
            }
            return userProvidedCallback.call(untouchableContext, event);
          };
        } else if (true /* DEBUG */) {
          // prevent the callback from being bound to the element
          this.callback = userProvidedCallback.bind(untouchableContext);
        } else {
          this.callback = userProvidedCallback;
        }
      }
    };
    return OnModifierState;
  }();
  var adds = 0;
  var removes = 0;
  function removeEventListener(element, eventName, callback, options) {
    removes++;
    if (SUPPORTS_EVENT_OPTIONS) {
      // when options are supported, use them across the board
      element.removeEventListener(eventName, callback, options);
    } else if (options !== undefined && options.capture) {
      // used only in the following case:
      //
      // `{ once: true | false, passive: true | false, capture: true }
      //
      // `once` is handled via a custom callback that removes after first
      // invocation so we only care about capture here as a boolean
      element.removeEventListener(eventName, callback, true);
    } else {
      // used only in the following cases:
      //
      // * where there is no options
      // * `{ once: true | false, passive: true | false, capture: false }
      element.removeEventListener(eventName, callback);
    }
  }
  function addEventListener(element, eventName, callback, options) {
    adds++;
    if (SUPPORTS_EVENT_OPTIONS) {
      // when options are supported, use them across the board
      element.addEventListener(eventName, callback, options);
    } else if (options !== undefined && options.capture) {
      // used only in the following case:
      //
      // `{ once: true | false, passive: true | false, capture: true }
      //
      // `once` is handled via a custom callback that removes after first
      // invocation so we only care about capture here as a boolean
      element.addEventListener(eventName, callback, true);
    } else {
      // used only in the following cases:
      //
      // * where there is no options
      // * `{ once: true | false, passive: true | false, capture: false }
      element.addEventListener(eventName, callback);
    }
  }
  /**
    The `{{on}}` modifier lets you easily add event listeners (it uses
    [EventTarget.addEventListener](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener)
    internally).
  
    For example, if you'd like to run a function on your component when a `<button>`
    in the components template is clicked you might do something like:
  
    ```app/components/like-post.hbs
    <button {{on 'click' this.saveLike}}>Like this post!</button>
    ```
  
    ```app/components/like-post.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
  
    export default class LikePostComponent extends Component {
      @action
      saveLike() {
        // someone likes your post!
        // better send a request off to your server...
      }
    }
    ```
  
    ### Arguments
  
    `{{on}}` accepts two positional arguments, and a few named arguments.
  
    The positional arguments are:
  
    - `event` -- the name to use when calling `addEventListener`
    - `callback` -- the function to be passed to `addEventListener`
  
    The named arguments are:
  
    - capture -- a `true` value indicates that events of this type will be dispatched
      to the registered listener before being dispatched to any EventTarget beneath it
      in the DOM tree.
    - once -- indicates that the listener should be invoked at most once after being
      added. If true, the listener would be automatically removed when invoked.
    - passive -- if `true`, indicates that the function specified by listener will never
      call preventDefault(). If a passive listener does call preventDefault(), the user
      agent will do nothing other than generate a console warning. See
      [Improving scrolling performance with passive listeners](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Improving_scrolling_performance_with_passive_listeners)
      to learn more.
  
    The callback function passed to `{{on}}` will receive any arguments that are passed
    to the event handler. Most commonly this would be the `event` itself.
  
    If you would like to pass additional arguments to the function you should use
    the `{{fn}}` helper.
  
    For example, in our example case above if you'd like to pass in the post that
    was being liked when the button is clicked you could do something like:
  
    ```app/components/like-post.hbs
    <button {{on 'click' (fn this.saveLike @post)}}>Like this post!</button>
    ```
  
    In this case, the `saveLike` function will receive two arguments: the click event
    and the value of `@post`.
  
    ### Function Context
  
    In the example above, we used `@action` to ensure that `likePost` is
    properly bound to the `items-list`, but let's explore what happens if we
    left out `@action`:
  
    ```app/components/like-post.js
    import Component from '@glimmer/component';
  
    export default class LikePostComponent extends Component {
      saveLike() {
        // ...snip...
      }
    }
    ```
  
    In this example, when the button is clicked `saveLike` will be invoked,
    it will **not** have access to the component instance. In other
    words, it will have no `this` context, so please make sure your functions
    are bound (via `@action` or other means) before passing into `on`!
  
    @method on
    @for Ember.Templates.helpers
    @public
    @since 3.11.0
  */
  var OnModifierManager = /*#__PURE__*/function () {
    function OnModifierManager(owner, isInteractive) {
      this.SUPPORTS_EVENT_OPTIONS = SUPPORTS_EVENT_OPTIONS;
      this.isInteractive = isInteractive;
      this.owner = owner;
    }
    var _proto28 = OnModifierManager.prototype;
    _proto28.getDebugName = function getDebugName() {
      return 'on';
    };
    _proto28.create = function create(element, _state, args) {
      if (!this.isInteractive) {
        return null;
      }
      var capturedArgs = args.capture();
      return new OnModifierState(this.owner, element, capturedArgs);
    };
    _proto28.getTag = function getTag(state) {
      if (state === null) {
        return null;
      }
      return state.tag;
    };
    _proto28.install = function install(state) {
      if (state === null) {
        return;
      }
      state.updateFromArgs();
      var element = state.element,
        eventName = state.eventName,
        callback = state.callback,
        options = state.options;
      addEventListener(element, eventName, callback, options);
      (0, _runtime2.registerDestructor)(state, function () {
        return removeEventListener(element, eventName, callback, options);
      });
      state.shouldUpdate = false;
    };
    _proto28.update = function update(state) {
      if (state === null) {
        return;
      } // stash prior state for el.removeEventListener

      var element = state.element,
        eventName = state.eventName,
        callback = state.callback,
        options = state.options;
      state.updateFromArgs();
      if (!state.shouldUpdate) {
        return;
      } // use prior state values for removal

      removeEventListener(element, eventName, callback, options); // read updated values from the state object

      addEventListener(state.element, state.eventName, state.callback, state.options);
      state.shouldUpdate = false;
    };
    _proto28.getDestroyable = function getDestroyable(state) {
      return state;
    };
    (0, _emberBabel.createClass)(OnModifierManager, [{
      key: "counters",
      get: function get() {
        return {
          adds: adds,
          removes: removes
        };
      }
    }]);
    return OnModifierManager;
  }();
  var CAPABILITIES$4 = {
    dynamicLayout: true,
    dynamicTag: false,
    prepareArgs: false,
    createArgs: true,
    attributeHook: false,
    elementHook: false,
    createCaller: true,
    dynamicScope: true,
    updateHook: true,
    createInstance: true,
    wrapped: false,
    willDestroy: false
  };
  var MountManager = /*#__PURE__*/function (_BaseInternalComponen5) {
    (0, _emberBabel.inheritsLoose)(MountManager, _BaseInternalComponen5);
    function MountManager() {
      return _BaseInternalComponen5.apply(this, arguments) || this;
    }
    var _proto29 = MountManager.prototype;
    _proto29.getDynamicLayout = function getDynamicLayout(state) {
      var templateFactory$$1 = state.engine.lookup('template:application');
      return templateFactory$$1(state.engine);
    };
    _proto29.getCapabilities = function getCapabilities() {
      return CAPABILITIES$4;
    };
    _proto29.create = function create(env, _ref23, args) {
      var name = _ref23.name;
      // TODO
      // mount is a runtime helper, this shouldn't use dynamic layout
      // we should resolve the engine app template in the helper
      // it also should use the owner that looked up the mount helper.
      var engine = env.owner.buildChildEngineInstance(name);
      engine.boot();
      var applicationFactory = engine.factoryFor("controller:application");
      var controllerFactory = applicationFactory || (0, _routing.generateControllerFactory)(engine, 'application');
      var controller;
      var self;
      var bucket;
      var modelRef;
      if (args.named.has('model')) {
        modelRef = args.named.get('model');
      }
      if (modelRef === undefined) {
        controller = controllerFactory.create();
        self = (0, _reference.createConstRef)(controller, 'this');
        bucket = {
          engine: engine,
          controller: controller,
          self: self,
          modelRef: modelRef
        };
      } else {
        var model = (0, _reference.valueForRef)(modelRef);
        controller = controllerFactory.create({
          model: model
        });
        self = (0, _reference.createConstRef)(controller, 'this');
        bucket = {
          engine: engine,
          controller: controller,
          self: self,
          modelRef: modelRef
        };
      }
      if (env.debugRenderTree) {
        (0, _runtime2.associateDestroyableChild)(engine, controller);
      }
      return bucket;
    };
    _proto29.getDebugName = function getDebugName(_ref24) {
      var name = _ref24.name;
      return name;
    };
    _proto29.getDebugCustomRenderTree = function getDebugCustomRenderTree(definition, state, args, template) {
      return [{
        bucket: state.engine,
        instance: state.engine,
        type: 'engine',
        name: definition.name,
        args: args
      }, {
        bucket: state.controller,
        instance: state.controller,
        type: 'route-template',
        name: 'application',
        args: args,
        template: template
      }];
    };
    _proto29.getSelf = function getSelf(_ref25) {
      var self = _ref25.self;
      return self;
    };
    _proto29.getDestroyable = function getDestroyable(bucket) {
      return bucket.engine;
    };
    _proto29.didRenderLayout = function didRenderLayout() {};
    _proto29.update = function update(bucket) {
      var controller = bucket.controller,
        modelRef = bucket.modelRef;
      if (modelRef !== undefined) {
        controller.set('model', (0, _reference.valueForRef)(modelRef));
      }
    };
    _proto29.didUpdateLayout = function didUpdateLayout() {};
    return MountManager;
  }(_runtime2.BaseInternalComponentManager);
  var MOUNT_MANAGER = new MountManager();
  var MountDefinition = function MountDefinition(name) {
    this.manager = MOUNT_MANAGER;
    this.state = {
      name: name
    };
  };
  /**
    The `{{mount}}` helper lets you embed a routeless engine in a template.
    Mounting an engine will cause an instance to be booted and its `application`
    template to be rendered.
  
    For example, the following template mounts the `ember-chat` engine:
  
    ```handlebars
    {{! application.hbs }}
    {{mount "ember-chat"}}
    ```
  
    Additionally, you can also pass in a `model` argument that will be
    set as the engines model. This can be an existing object:
  
    ```
    <div>
      {{mount 'admin' model=userSettings}}
    </div>
    ```
  
    Or an inline `hash`, and you can even pass components:
  
    ```
    <div>
      <h1>Application template!</h1>
      {{mount 'admin' model=(hash
          title='Secret Admin'
          signInButton=(component 'sign-in-button')
      )}}
    </div>
    ```
  
    @method mount
    @param {String} name Name of the engine to mount.
    @param {Object} [model] Object that will be set as
                            the model of the engine.
    @for Ember.Templates.helpers
    @public
  */
  function mountHelper(args, vm) {
    var env = vm.env;
    var nameRef = args.positional.at(0);
    var captured = null;
    (true && !(args.positional.length === 1) && (0, _debug.assert)('You can only pass a single positional argument to the {{mount}} helper, e.g. {{mount "chat-engine"}}.', args.positional.length === 1));
    if (true /* DEBUG */ && args.named) {
      var keys = args.named.names;
      var extra = keys.filter(function (k) {
        return k !== 'model';
      });
      (true && !(extra.length === 0) && (0, _debug.assert)('You can only pass a `model` argument to the {{mount}} helper, ' + 'e.g. {{mount "profile-engine" model=this.profile}}. ' + ("You passed " + extra.join(',') + "."), extra.length === 0));
    } // TODO: the functionality to create a proper CapturedArgument should be
    // exported by glimmer, or that it should provide an overload for `curry`
    // that takes `PreparedArguments`

    if (args.named.has('model')) {
      (true && !(args.named.length === 1) && (0, _debug.assert)('[BUG] this should already be checked by the macro', args.named.length === 1));
      var named = args.named.capture();
      captured = (0, _runtime2.createCapturedArgs)(named, _runtime2.EMPTY_POSITIONAL);
    }
    var lastName, lastDef;
    return (0, _reference.createComputeRef)(function () {
      var name = (0, _reference.valueForRef)(nameRef);
      if (typeof name === 'string') {
        if (lastName === name) {
          return lastDef;
        }
        (true && !(env.owner.hasRegistration("engine:" + name)) && (0, _debug.assert)("You used `{{mount '" + name + "'}}`, but the engine '" + name + "' can not be found.", env.owner.hasRegistration("engine:" + name)));
        if (!env.owner.hasRegistration("engine:" + name)) {
          return null;
        }
        lastName = name;
        lastDef = (0, _runtime2.curry)(new MountDefinition(name), captured);
        return lastDef;
      } else {
        (true && !(name === null || name === undefined) && (0, _debug.assert)("Invalid engine name '" + name + "' specified, engine name must be either a string, null or undefined.", name === null || name === undefined));
        lastDef = null;
        lastName = null;
        return null;
      }
    });
  }

  /**
    The `{{outlet}}` helper lets you specify where a child route will render in
    your template. An important use of the `{{outlet}}` helper is in your
    application's `application.hbs` file:
  
    ```app/templates/application.hbs
    <MyHeader />
  
    <div class="my-dynamic-content">
      <!-- this content will change based on the current route, which depends on the current URL -->
      {{outlet}}
    </div>
  
    <MyFooter />
    ```
  
    You may also specify a name for the `{{outlet}}`, which is useful when using more than one
    `{{outlet}}` in a template:
  
    ```app/templates/application.hbs
    {{outlet "menu"}}
    {{outlet "sidebar"}}
    {{outlet "main"}}
    ```
  
    Your routes can then render into a specific one of these `outlet`s by specifying the `outlet`
    attribute in your `renderTemplate` function:
  
    ```app/routes/menu.js
    import Route from '@ember/routing/route';
  
    export default class MenuRoute extends Route {
      renderTemplate() {
        this.render({ outlet: 'menu' });
      }
    }
    ```
  
    See the [routing guide](https://guides.emberjs.com/release/routing/rendering-a-template/) for more
    information on how your `route` interacts with the `{{outlet}}` helper.
    Note: Your content __will not render__ if there isn't an `{{outlet}}` for it.
  
    @method outlet
    @param {String} [name]
    @for Ember.Templates.helpers
    @public
  */

  function outletHelper(args, vm) {
    var scope = vm.dynamicScope();
    var nameRef;
    if (args.positional.length === 0) {
      nameRef = (0, _reference.createPrimitiveRef)('main');
    } else {
      nameRef = args.positional.at(0);
    }
    var outletRef = (0, _reference.createComputeRef)(function () {
      var state = (0, _reference.valueForRef)(scope.get('outletState'));
      var outlets = state !== undefined ? state.outlets : undefined;
      return outlets !== undefined ? outlets[(0, _reference.valueForRef)(nameRef)] : undefined;
    });
    var lastState = null;
    var definition = null;
    return (0, _reference.createComputeRef)(function () {
      var state = stateFor(outletRef);
      if (!validate(state, lastState)) {
        lastState = state;
        if (state !== null) {
          var named = (0, _util.dict)();
          named.model = (0, _reference.childRefFromParts)(outletRef, ['render', 'model']);
          if (true /* DEBUG */) {
            named.model = (0, _reference.createDebugAliasRef)('@model', named.model);
          }
          var _args2 = (0, _runtime2.createCapturedArgs)(named, _runtime2.EMPTY_POSITIONAL);
          definition = (0, _runtime2.curry)(new OutletComponentDefinition(state), _args2);
        } else {
          definition = null;
        }
      }
      return definition;
    });
  }
  function stateFor(ref) {
    var outlet = (0, _reference.valueForRef)(ref);
    if (outlet === undefined) return null;
    var render = outlet.render;
    if (render === undefined) return null;
    var template = render.template;
    if (template === undefined) return null; // this guard can be removed once @ember/test-helpers@1.6.0 has "aged out"
    // and is no longer considered supported

    if (isTemplateFactory(template)) {
      template = template(render.owner);
    }
    return {
      ref: ref,
      name: render.name,
      outlet: render.outlet,
      template: template,
      controller: render.controller,
      model: render.model
    };
  }
  function validate(state, lastState) {
    if (state === null) {
      return lastState === null;
    }
    if (lastState === null) {
      return false;
    }
    return state.template === lastState.template && state.controller === lastState.controller;
  }
  function instrumentationPayload$1(name) {
    return {
      object: "component:" + name
    };
  }
  function componentFor(name, owner, options) {
    var fullName = "component:" + name;
    return owner.factoryFor(fullName, options) || null;
  }
  function layoutFor(name, owner, options) {
    var templateFullName = "template:components/" + name;
    return owner.lookup(templateFullName, options) || null;
  }
  function lookupComponentPair(owner, name, options) {
    var component = componentFor(name, owner, options);
    if (component !== null && component.class !== undefined) {
      var _layout = (0, _runtime2.getComponentTemplate)(component.class);
      if (_layout !== undefined) {
        return {
          component: component,
          layout: _layout
        };
      }
    }
    var layout = layoutFor(name, owner, options);
    if (component === null && layout === null) {
      return null;
    } else {
      return {
        component: component,
        layout: layout
      };
    }
  }
  var lookupPartial;
  var templateFor;
  var parseUnderscoredName;
  if (_deprecatedFeatures.PARTIALS) {
    lookupPartial = function lookupPartial(templateName, owner) {
      (true && !(false) && (0, _debug.deprecate)("The use of `{{partial}}` is deprecated, please refactor the \"" + templateName + "\" partial to a component", false, {
        id: 'ember-views.partial',
        until: '4.0.0',
        url: 'https://deprecations.emberjs.com/v3.x#toc_ember-views-partial',
        for: 'ember-source',
        since: {
          enabled: '3.15.0-beta.1'
        }
      }));
      if (templateName === null) {
        return;
      }
      var template = templateFor(owner, parseUnderscoredName(templateName), templateName);
      (true && !(Boolean(template)) && (0, _debug.assert)("Unable to find partial with name \"" + templateName + "\"", Boolean(template)));
      return template;
    };
    templateFor = function templateFor(owner, underscored, name) {
      if (_deprecatedFeatures.PARTIALS) {
        if (!name) {
          return;
        }
        (true && !(name.indexOf('.') === -1) && (0, _debug.assert)("templateNames are not allowed to contain periods: " + name, name.indexOf('.') === -1));
        if (!owner) {
          throw new _error.default('Container was not found when looking up a views template. ' + 'This is most likely due to manually instantiating an Ember.View. ' + 'See: http://git.io/EKPpnA');
        }
        return owner.lookup("template:" + underscored) || owner.lookup("template:" + name);
      }
    };
    parseUnderscoredName = function parseUnderscoredName(templateName) {
      var nameParts = templateName.split('/');
      var lastPart = nameParts[nameParts.length - 1];
      nameParts[nameParts.length - 1] = "_" + lastPart;
      return nameParts.join('/');
    };
  }
  var BUILTINS_HELPERS = {
    if: inlineIf,
    action: action,
    array: array,
    concat: concat,
    fn: fn,
    get: get$1,
    hash: hash,
    log: log,
    mut: mut,
    'query-params': queryParams,
    readonly: readonly,
    unbound: unbound,
    unless: inlineUnless,
    '-hash': hash,
    '-each-in': eachIn,
    '-normalize-class': normalizeClassHelper,
    '-track-array': trackArray,
    '-get-dynamic-var': _runtime2.getDynamicVar,
    '-mount': mountHelper,
    '-outlet': outletHelper,
    '-assert-implicit-component-helper-argument': componentAssertionHelper,
    '-in-el-null': inElementNullCheckHelper
  };
  var RuntimeResolverImpl = /*#__PURE__*/function () {
    function RuntimeResolverImpl(owner, isInteractive) {
      this.handles = [undefined];
      this.objToHandle = new WeakMap();
      this.builtInHelpers = BUILTINS_HELPERS;
      this.componentDefinitionCache = new Map();
      this.componentDefinitionCount = 0;
      this.helperDefinitionCount = 0;
      this.isInteractive = isInteractive;
      this.builtInModifiers = {
        action: {
          manager: new ActionModifierManager(),
          state: null
        },
        on: {
          manager: new OnModifierManager(owner, isInteractive),
          state: null
        }
      };
    }
    /***  IRuntimeResolver ***/

    /**
     * public componentDefHandleCount = 0;
     * Called while executing Append Op.PushDynamicComponentManager if string
     */
    var _proto30 = RuntimeResolverImpl.prototype;
    _proto30.lookupComponent = function lookupComponent(name, owner) {
      var handle = this.lookupComponentHandle(name, owner);
      if (handle === null) {
        (true && !(false) && (0, _debug.assert)("Could not find component named \"" + name + "\" (no component or template with that name was found)"));
        return null;
      }
      return this.resolve(handle);
    };
    _proto30.lookupComponentHandle = function lookupComponentHandle(name, owner) {
      var nextHandle = this.handles.length;
      var handle = this.handle(this._lookupComponentDefinition(name, owner));
      (true && !(!(name === 'text-area' && handle === null)) && (0, _debug.assert)('Could not find component `<TextArea />` (did you mean `<Textarea />`?)', !(name === 'text-area' && handle === null)));
      if (nextHandle === handle) {
        this.componentDefinitionCount++;
      }
      return handle;
    }
    /**
     * Called by RuntimeConstants to lookup unresolved handles.
     */;
    _proto30.resolve = function resolve(handle) {
      return this.handles[handle];
    } // End IRuntimeResolver

    /**
     * Called by CompileTimeLookup compiling Unknown or Helper OpCode
     */;
    _proto30.lookupHelper = function lookupHelper(name, owner) {
      var nextHandle = this.handles.length;
      var helper$$1 = this._lookupHelper(name, owner);
      if (helper$$1 !== null) {
        var handle = this.handle(helper$$1);
        if (nextHandle === handle) {
          this.helperDefinitionCount++;
        }
        return handle;
      }
      return null;
    }
    /**
     * Called by CompileTimeLookup compiling the
     */;
    _proto30.lookupModifier = function lookupModifier(name, owner) {
      return this.handle(this._lookupModifier(name, owner));
    }
    /**
     * Called by CompileTimeLookup to lookup partial
     */;
    _proto30.lookupPartial = function lookupPartial(name, owner) {
      if (_deprecatedFeatures.PARTIALS) {
        var partial = this._lookupPartial(name, owner);
        return this.handle(partial);
      } else {
        return null;
      }
    } // TODO: This isn't necessary in all embedding environments, we should likely
    // make it optional within Glimmer-VM
    ;
    _proto30.compilable = function compilable() {} // end CompileTimeLookup
    // needed for lazy compile time lookup
    ;
    _proto30.handle = function handle(obj) {
      if (obj === undefined || obj === null) {
        return null;
      }
      var handle = this.objToHandle.get(obj);
      if (handle === undefined) {
        handle = this.handles.push(obj) - 1;
        this.objToHandle.set(obj, handle);
      }
      return handle;
    };
    _proto30._lookupHelper = function _lookupHelper(_name, owner) {
      (true && !(!(this.builtInHelpers[_name] && owner.hasRegistration("helper:" + _name))) && (0, _debug.assert)("You attempted to overwrite the built-in helper \"" + _name + "\" which is not allowed. Please rename the helper.", !(this.builtInHelpers[_name] && owner.hasRegistration("helper:" + _name))));
      var helper$$1 = this.builtInHelpers[_name];
      if (helper$$1 !== undefined) {
        return helper$$1;
      }
      var name = _name;
      var factory = owner.factoryFor("helper:" + name) || owner.factoryFor("helper:" + name);
      if (factory === undefined || factory.class === undefined) {
        return null;
      }
      var manager = (0, _runtime2.getHelperManager)(owner, factory.class);
      if (manager === undefined) {
        return null;
      }
      (true && !(true
      /* EMBER_GLIMMER_HELPER_MANAGER */ || isClassicHelperManager(manager) || manager === SIMPLE_CLASSIC_HELPER_MANAGER) && (0, _debug.assert)('helper managers have not been enabled yet, you must use classic helpers', true || isClassicHelperManager(manager) || manager === SIMPLE_CLASSIC_HELPER_MANAGER));
      (true && !(!(0, _runtime2.isInternalHelper)(manager)) && (0, _debug.assert)("internal helpers are not supported via `getHelperManager` yet, found an internal manager for " + name, !(0, _runtime2.isInternalHelper)(manager))); // For classic class based helpers, we need to pass the factoryFor result itself rather
      // than the raw value (`factoryFor(...).class`). This is because injections are already
      // bound in the factoryFor result, including type-based injections
      return customHelper(manager, isClassicHelperManager(manager) ? factory : factory.class);
    };
    _proto30._lookupPartial = function _lookupPartial(name, owner) {
      var templateFactory$$1 = lookupPartial(name, owner);
      var template = templateFactory$$1(owner);
      return new _opcodeCompiler.PartialDefinitionImpl(name, template);
    };
    _proto30._lookupModifier = function _lookupModifier(name, owner) {
      var builtin = this.builtInModifiers[name];
      if (builtin === undefined) {
        var modifier = owner.factoryFor("modifier:" + name);
        if (modifier !== undefined) {
          var manager = (0, _runtime2.getModifierManager)(owner, modifier.class);
          (true && !(manager) && (0, _debug.assert)("Expected a modifier manager to exist, but did not find one for " + name, manager));
          (true && !(!(0, _runtime2.isInternalModifierManager)(manager)) && (0, _debug.assert)("Internal modifier managers are not supported via `getModifierManager` yet, found an internal manager for " + name, !(0, _runtime2.isInternalModifierManager)(manager)));
          return new CustomModifierDefinition(name, modifier, manager, this.isInteractive);
        }
      }
      return builtin;
    };
    _proto30._lookupComponentDefinition = function _lookupComponentDefinition(_name, owner) {
      var name = _name;
      var pair = lookupComponentPair(owner, name);
      if (pair === null) {
        return null;
      }
      var layout;
      var key;
      if (pair.component === null) {
        key = layout = pair.layout(owner);
      } else {
        key = pair.component;
      }
      var cachedComponentDefinition = this.componentDefinitionCache.get(key);
      if (cachedComponentDefinition !== undefined) {
        return cachedComponentDefinition;
      }
      if (layout === undefined && pair.layout !== null) {
        layout = pair.layout(owner);
      }
      var finalizer = (0, _instrumentation._instrumentStart)('render.getComponentDefinition', instrumentationPayload$1, name);
      var definition = null;
      if (pair.component === null) {
        if (_environment2.ENV._TEMPLATE_ONLY_GLIMMER_COMPONENTS) {
          definition = new TemplateOnlyComponentDefinition(name, layout);
        }
      } else if ((0, _templateOnly.isTemplateOnlyComponent)(pair.component.class)) {
        definition = new TemplateOnlyComponentDefinition(name, layout);
      }
      if (pair.component !== null) {
        (true && !(pair.component.class !== undefined) && (0, _debug.assert)("missing component class " + name, pair.component.class !== undefined));
        var ComponentClass = pair.component.class;
        var manager = (0, _runtime2.getComponentManager)(owner, ComponentClass);
        if (manager !== undefined) {
          if ((0, _runtime2.isInternalComponentManager)(manager)) {
            (true && !(pair.layout !== null) && (0, _debug.assert)("missing layout for internal component " + name, pair.layout !== null));
            definition = new InternalComponentDefinition(manager, ComponentClass, layout);
          } else {
            definition = new CustomManagerDefinition(name, pair.component, manager, layout !== undefined ? layout : owner.lookup((0, _container.privatize)(_templateObject2 || (_templateObject2 = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"]))))(owner));
          }
        }
      }
      if (definition === null) {
        definition = new CurlyComponentDefinition(name, pair.component || owner.factoryFor((0, _container.privatize)(_templateObject3 || (_templateObject3 = (0, _emberBabel.taggedTemplateLiteralLoose)(["component:-default"])))), layout);
      }
      finalizer();
      this.componentDefinitionCache.set(key, definition);
      return definition;
    };
    return RuntimeResolverImpl;
  }();
  function hashToArgs(hash) {
    if (hash === null) return null;
    var names = hash[0].map(function (key) {
      return "@" + key;
    });
    return [names, hash[1]];
  }
  var experimentalMacros = []; // This is a private API to allow for experimental macros
  // to be created in user space. Registering a macro should
  // should be done in an initializer.
  _exports._experimentalMacros = experimentalMacros;
  function registerMacros(macro) {
    experimentalMacros.push(macro);
  }
  function refineInlineSyntax(name, params, hash, context) {
    var component = context.resolver.lookupComponent(name, context.meta.owner);
    if (component !== null) {
      return (0, _opcodeCompiler.staticComponent)(component, [params === null ? [] : params, hashToArgs(hash), _opcodeCompiler.EMPTY_BLOCKS]);
    }
    return _opcodeCompiler.UNHANDLED;
  }
  function refineBlockSyntax(name, params, hash, blocks, context) {
    var handle = context.resolver.lookupComponent(name, context.meta.owner);
    if (handle !== null) {
      return (0, _opcodeCompiler.staticComponent)(handle, [params, hashToArgs(hash), blocks]);
    }
    (true && !(context.meta.owner.hasRegistration("helper:" + name)) && (0, _debug.assert)("A component or helper named \"" + name + "\" could not be found", context.meta.owner.hasRegistration("helper:" + name)));
    (true && !(!function () {
      var resolver = context.resolver['resolver'];
      var owner = context.meta.owner;
      if (name === 'component' || resolver['builtInHelpers'][name]) {
        return true;
      }
      return owner.hasRegistration("helper:" + name);
    }()) && (0, _debug.assert)("Helpers may not be used in the block form, for example {{#" + name + "}}{{/" + name + "}}. Please use a component, or alternatively use the helper in combination with a built-in Ember helper, for example {{#if (" + name + ")}}{{/if}}.", !function () {
      var resolver = context.resolver['resolver'];
      var owner = context.meta.owner;
      if (name === 'component' || resolver['builtInHelpers'][name]) {
        return true;
      }
      return owner.hasRegistration("helper:" + name);
    }()));
    return _opcodeCompiler.NONE;
  }
  function populateMacros(macros) {
    var inlines = macros.inlines,
      blocks = macros.blocks;
    inlines.addMissing(refineInlineSyntax);
    blocks.addMissing(refineBlockSyntax);
    for (var i = 0; i < experimentalMacros.length; i++) {
      var macro = experimentalMacros[i];
      macro(blocks, inlines);
    }
    return {
      blocks: blocks,
      inlines: inlines
    };
  }
  var DynamicScope = /*#__PURE__*/function () {
    function DynamicScope(view, outletState) {
      this.view = view;
      this.outletState = outletState;
    }
    var _proto31 = DynamicScope.prototype;
    _proto31.child = function child() {
      return new DynamicScope(this.view, this.outletState);
    };
    _proto31.get = function get(key) {
      // tslint:disable-next-line:max-line-length
      (true && !(key === 'outletState') && (0, _debug.assert)("Using `-get-dynamic-scope` is only supported for `outletState` (you used `" + key + "`).", key === 'outletState'));
      return this.outletState;
    };
    _proto31.set = function set(key, value) {
      // tslint:disable-next-line:max-line-length
      (true && !(key === 'outletState') && (0, _debug.assert)("Using `-with-dynamic-scope` is only supported for `outletState` (you used `" + key + "`).", key === 'outletState'));
      this.outletState = value;
      return value;
    };
    return DynamicScope;
  }(); // This wrapper logic prevents us from rerendering in case of a hard failure
  // during render. This prevents infinite revalidation type loops from occuring,
  // and ensures that errors are not swallowed by subsequent follow on failures.
  function errorLoopTransaction(fn) {
    if (true /* DEBUG */) {
      return function () {
        var didError = true;
        try {
          fn();
          didError = false;
        } finally {
          if (didError) {
            // Noop the function so that we won't keep calling it and causing
            // infinite looping failures;
            fn = function fn() {
              console.warn('Attempted to rerender, but the Ember application has had an unrecoverable error occur during render. You should reload the application after fixing the cause of the error.');
            };
          }
        }
      };
    } else {
      return fn;
    }
  }
  var RootState = /*#__PURE__*/function () {
    function RootState(root, runtime, context, template, self, parentElement, dynamicScope, builder) {
      var _this11 = this;
      this.root = root;
      this.runtime = runtime;
      (true && !(template !== undefined) && (0, _debug.assert)("You cannot render `" + (0, _reference.valueForRef)(self) + "` without a template.", template !== undefined));
      this.id = (0, _views.getViewId)(root);
      this.result = undefined;
      this.destroyed = false;
      this.render = errorLoopTransaction(function () {
        var layout = (0, _util.unwrapTemplate)(template).asLayout();
        var handle = layout.compile(context);
        var iterator = (0, _runtime2.renderMain)(runtime, context, self, builder(runtime.env, {
          element: parentElement,
          nextSibling: null
        }), (0, _util.unwrapHandle)(handle), dynamicScope);
        var result = _this11.result = iterator.sync(); // override .render function after initial render

        _this11.render = errorLoopTransaction(function () {
          return result.rerender({
            alwaysRevalidate: false
          });
        });
      });
    }
    var _proto32 = RootState.prototype;
    _proto32.isFor = function isFor(possibleRoot) {
      return this.root === possibleRoot;
    };
    _proto32.destroy = function destroy() {
      var result = this.result,
        env = this.runtime.env;
      this.destroyed = true;
      this.runtime = undefined;
      this.root = null;
      this.result = undefined;
      this.render = undefined;
      if (result !== undefined) {
        /*
         Handles these scenarios:
                * When roots are removed during standard rendering process, a transaction exists already
           `.begin()` / `.commit()` are not needed.
         * When roots are being destroyed manually (`component.append(); component.destroy() case), no
           transaction exists already.
         * When roots are being destroyed during `Renderer#destroy`, no transaction exists
                */
        (0, _runtime2.inTransaction)(env, function () {
          return (0, _runtime2.destroy)(result);
        });
      }
    };
    return RootState;
  }();
  var renderers = [];
  function _resetRenderers() {
    renderers.length = 0;
  }
  function register(renderer) {
    (true && !(renderers.indexOf(renderer) === -1) && (0, _debug.assert)('Cannot register the same renderer twice', renderers.indexOf(renderer) === -1));
    renderers.push(renderer);
  }
  function deregister(renderer) {
    var index = renderers.indexOf(renderer);
    (true && !(index !== -1) && (0, _debug.assert)('Cannot deregister unknown unregistered renderer', index !== -1));
    renderers.splice(index, 1);
  }
  function loopBegin() {
    for (var i = 0; i < renderers.length; i++) {
      renderers[i]._scheduleRevalidate();
    }
  }
  function K() {
    /* noop */
  }
  var renderSettledDeferred = null;
  /*
    Returns a promise which will resolve when rendering has settled. Settled in
    this context is defined as when all of the tags in use are "current" (e.g.
    `renderers.every(r => r._isValid())`). When this is checked at the _end_ of
    the run loop, this essentially guarantees that all rendering is completed.
  
    @method renderSettled
    @returns {Promise<void>} a promise which fulfills when rendering has settled
  */

  function renderSettled() {
    if (renderSettledDeferred === null) {
      renderSettledDeferred = _rsvp.default.defer(); // if there is no current runloop, the promise created above will not have
      // a chance to resolve (because its resolved in backburner's "end" event)

      if (!(0, _runloop.getCurrentRunLoop)()) {
        // ensure a runloop has been kicked off
        _runloop.backburner.schedule('actions', null, K);
      }
    }
    return renderSettledDeferred.promise;
  }
  function resolveRenderPromise() {
    if (renderSettledDeferred !== null) {
      var resolve = renderSettledDeferred.resolve;
      renderSettledDeferred = null;
      _runloop.backburner.join(null, resolve);
    }
  }
  var loops = 0;
  function loopEnd() {
    for (var i = 0; i < renderers.length; i++) {
      if (!renderers[i]._isValid()) {
        if (loops > _environment2.ENV._RERENDER_LOOP_LIMIT) {
          loops = 0; // TODO: do something better

          renderers[i].destroy();
          throw new Error('infinite rendering invalidation detected');
        }
        loops++;
        return _runloop.backburner.join(null, K);
      }
    }
    loops = 0;
    resolveRenderPromise();
  }
  _runloop.backburner.on('begin', loopBegin);
  _runloop.backburner.on('end', loopEnd);
  var Renderer = /*#__PURE__*/function () {
    function Renderer(owner, document, env, rootTemplate, viewRegistry, destinedForDOM, builder) {
      if (destinedForDOM === void 0) {
        destinedForDOM = false;
      }
      if (builder === void 0) {
        builder = _runtime2.clientBuilder;
      }
      this._inRenderTransaction = false;
      this._lastRevision = -1;
      this._destroyed = false;
      this._rootTemplate = rootTemplate(owner);
      this._viewRegistry = viewRegistry;
      this._destinedForDOM = destinedForDOM;
      this._roots = [];
      this._removedRoots = [];
      this._builder = builder; // resolver is exposed for tests

      var runtimeResolver = this._runtimeResolver = new RuntimeResolverImpl(owner, env.isInteractive);
      var compileTimeResolver = new CompileTimeResolverImpl(runtimeResolver);
      var sharedArtifacts = (0, _program.artifacts)();
      var context = this._context = (0, _opcodeCompiler.syntaxCompilationContext)(sharedArtifacts, compileTimeResolver);
      populateMacros(context.macros);
      var runtimeEnvironmentDelegate = new EmberEnvironmentDelegate(owner, env.isInteractive);
      this._runtime = (0, _runtime2.runtimeContext)({
        appendOperations: env.hasDOM ? new _runtime2.DOMTreeConstruction(document) : new _node.NodeDOMTreeConstruction(document),
        updateOperations: new _runtime2.DOMChanges(document)
      }, runtimeEnvironmentDelegate, sharedArtifacts, runtimeResolver);
    }
    var _proto33 = Renderer.prototype;
    // renderer HOOKS
    _proto33.appendOutletView = function appendOutletView(view, target) {
      var definition = createRootOutlet(view);
      this._appendDefinition(view, (0, _runtime2.curry)(definition), target);
    };
    _proto33.appendTo = function appendTo(view, target) {
      var definition = new RootComponentDefinition(view);
      this._appendDefinition(view, (0, _runtime2.curry)(definition), target);
    };
    _proto33._appendDefinition = function _appendDefinition(root, definition, target) {
      var self = (0, _reference.createConstRef)(definition, 'this');
      var dynamicScope = new DynamicScope(null, _reference.UNDEFINED_REFERENCE);
      var rootState = new RootState(root, this._runtime, this._context, this._rootTemplate, self, target, dynamicScope, this._builder);
      this._renderRoot(rootState);
    };
    _proto33.rerender = function rerender() {
      this._scheduleRevalidate();
    };
    _proto33.register = function register(view) {
      var id = (0, _views.getViewId)(view);
      (true && !(!this._viewRegistry[id]) && (0, _debug.assert)('Attempted to register a view with an id already in use: ' + id, !this._viewRegistry[id]));
      this._viewRegistry[id] = view;
    };
    _proto33.unregister = function unregister(view) {
      delete this._viewRegistry[(0, _views.getViewId)(view)];
    };
    _proto33.remove = function remove(view) {
      view._transitionTo('destroying');
      this.cleanupRootFor(view);
      if (this._destinedForDOM) {
        view.trigger('didDestroyElement');
      }
    };
    _proto33.cleanupRootFor = function cleanupRootFor(view) {
      // no need to cleanup roots if we have already been destroyed
      if (this._destroyed) {
        return;
      }
      var roots = this._roots; // traverse in reverse so we can remove items
      // without mucking up the index

      var i = this._roots.length;
      while (i--) {
        var root = roots[i];
        if (root.isFor(view)) {
          root.destroy();
          roots.splice(i, 1);
        }
      }
    };
    _proto33.destroy = function destroy() {
      if (this._destroyed) {
        return;
      }
      this._destroyed = true;
      this._clearAllRoots();
    };
    _proto33.getBounds = function getBounds(view) {
      var bounds = view[BOUNDS];
      (true && !(Boolean(bounds)) && (0, _debug.assert)('object passed to getBounds must have the BOUNDS symbol as a property', Boolean(bounds)));
      var parentElement = bounds.parentElement();
      var firstNode = bounds.firstNode();
      var lastNode = bounds.lastNode();
      return {
        parentElement: parentElement,
        firstNode: firstNode,
        lastNode: lastNode
      };
    };
    _proto33.createElement = function createElement(tagName) {
      return this._runtime.env.getAppendOperations().createElement(tagName);
    };
    _proto33._renderRoot = function _renderRoot(root) {
      var roots = this._roots;
      roots.push(root);
      if (roots.length === 1) {
        register(this);
      }
      this._renderRootsTransaction();
    };
    _proto33._renderRoots = function _renderRoots() {
      var _this12 = this;
      var roots = this._roots,
        runtime = this._runtime,
        removedRoots = this._removedRoots;
      var initialRootsLength;
      do {
        initialRootsLength = roots.length;
        (0, _runtime2.inTransaction)(runtime.env, function () {
          // ensure that for the first iteration of the loop
          // each root is processed
          for (var i = 0; i < roots.length; i++) {
            var root = roots[i];
            if (root.destroyed) {
              // add to the list of roots to be removed
              // they will be removed from `this._roots` later
              removedRoots.push(root); // skip over roots that have been marked as destroyed

              continue;
            } // when processing non-initial reflush loops,
            // do not process more roots than needed

            if (i >= initialRootsLength) {
              continue;
            }
            root.render();
          }
          _this12._lastRevision = (0, _validator.valueForTag)(_validator.CURRENT_TAG);
        });
      } while (roots.length > initialRootsLength); // remove any roots that were destroyed during this transaction

      while (removedRoots.length) {
        var root = removedRoots.pop();
        var rootIndex = roots.indexOf(root);
        roots.splice(rootIndex, 1);
      }
      if (this._roots.length === 0) {
        deregister(this);
      }
    };
    _proto33._renderRootsTransaction = function _renderRootsTransaction() {
      if (this._inRenderTransaction) {
        // currently rendering roots, a new root was added and will
        // be processed by the existing _renderRoots invocation
        return;
      } // used to prevent calling _renderRoots again (see above)
      // while we are actively rendering roots

      this._inRenderTransaction = true;
      var completedWithoutError = false;
      try {
        this._renderRoots();
        completedWithoutError = true;
      } finally {
        if (!completedWithoutError) {
          this._lastRevision = (0, _validator.valueForTag)(_validator.CURRENT_TAG);
        }
        this._inRenderTransaction = false;
      }
    };
    _proto33._clearAllRoots = function _clearAllRoots() {
      var roots = this._roots;
      for (var i = 0; i < roots.length; i++) {
        var root = roots[i];
        root.destroy();
      }
      this._removedRoots.length = 0;
      this._roots = []; // if roots were present before destroying
      // deregister this renderer instance

      if (roots.length) {
        deregister(this);
      }
    };
    _proto33._scheduleRevalidate = function _scheduleRevalidate() {
      _runloop.backburner.scheduleOnce('render', this, this._revalidate);
    };
    _proto33._isValid = function _isValid() {
      return this._destroyed || this._roots.length === 0 || (0, _validator.validateTag)(_validator.CURRENT_TAG, this._lastRevision);
    };
    _proto33._revalidate = function _revalidate() {
      if (this._isValid()) {
        return;
      }
      this._renderRootsTransaction();
    };
    (0, _emberBabel.createClass)(Renderer, [{
      key: "debugRenderTree",
      get: function get() {
        var debugRenderTree = this._runtime.env.debugRenderTree;
        (true && !(debugRenderTree) && (0, _debug.assert)('Attempted to access the DebugRenderTree, but it did not exist. Is the Ember Inspector open?', debugRenderTree));
        return debugRenderTree;
      }
    }]);
    return Renderer;
  }();
  _exports.Renderer = Renderer;
  var InertRenderer = /*#__PURE__*/function (_Renderer) {
    (0, _emberBabel.inheritsLoose)(InertRenderer, _Renderer);
    function InertRenderer() {
      return _Renderer.apply(this, arguments) || this;
    }
    InertRenderer.create = function create(props) {
      var document = props.document,
        env = props.env,
        rootTemplate = props.rootTemplate,
        _viewRegistry = props._viewRegistry,
        builder = props.builder;
      return new this((0, _owner.getOwner)(props), document, env, rootTemplate, _viewRegistry, false, builder);
    };
    var _proto34 = InertRenderer.prototype;
    _proto34.getElement = function getElement(_view) {
      throw new Error('Accessing `this.element` is not allowed in non-interactive environments (such as FastBoot).');
    };
    return InertRenderer;
  }(Renderer);
  _exports.InertRenderer = InertRenderer;
  var InteractiveRenderer = /*#__PURE__*/function (_Renderer2) {
    (0, _emberBabel.inheritsLoose)(InteractiveRenderer, _Renderer2);
    function InteractiveRenderer() {
      return _Renderer2.apply(this, arguments) || this;
    }
    InteractiveRenderer.create = function create(props) {
      var document = props.document,
        env = props.env,
        rootTemplate = props.rootTemplate,
        _viewRegistry = props._viewRegistry,
        builder = props.builder;
      return new this((0, _owner.getOwner)(props), document, env, rootTemplate, _viewRegistry, true, builder);
    };
    var _proto35 = InteractiveRenderer.prototype;
    _proto35.getElement = function getElement(view) {
      return (0, _views.getViewElement)(view);
    };
    return InteractiveRenderer;
  }(Renderer);
  _exports.InteractiveRenderer = InteractiveRenderer;
  var TEMPLATES = {};
  function setTemplates(templates) {
    TEMPLATES = templates;
  }
  function getTemplates() {
    return TEMPLATES;
  }
  function getTemplate(name) {
    if (Object.prototype.hasOwnProperty.call(TEMPLATES, name)) {
      return TEMPLATES[name];
    }
  }
  function hasTemplate(name) {
    return Object.prototype.hasOwnProperty.call(TEMPLATES, name);
  }
  function setTemplate(name, template) {
    return TEMPLATES[name] = template;
  }
  var InternalComponent = /*#__PURE__*/function () {
    function InternalComponent(owner, args, caller) {
      this.owner = owner;
      this.args = args;
      this.caller = caller;
      (0, _owner.setOwner)(this, owner);
    } // Factory interface
    InternalComponent.create = function create() {
      throw (0, _debug.assert)('Use constructor instead of create');
    };
    var _proto36 = InternalComponent.prototype;
    _proto36.arg = function arg(key) {
      var ref = this.args[key];
      return ref ? (0, _reference.valueForRef)(ref) : undefined;
    };
    _proto36.toString = function toString() {
      return "<" + this.constructor.toString() + ":" + (0, _utils.guidFor)(this) + ">";
    };
    (0, _emberBabel.createClass)(InternalComponent, null, [{
      key: "class",
      get: function get() {
        return this;
      }
    }, {
      key: "fullName",
      get: function get() {
        return this.name;
      }
    }, {
      key: "normalizedName",
      get: function get() {
        return this.name;
      }
    }]);
    return InternalComponent;
  }();
  /**
  @module @ember/component
  */
  /**
    See [Ember.Templates.components.Input](/ember/release/classes/Ember.Templates.components/methods/Input?anchor=Input).
  
    @method input
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
    */
  /**
    The `Input` component lets you create an HTML `<input>` element.
  
    ```handlebars
    <Input @value="987" />
    ```
  
    creates an `<input>` element with `type="text"` and value set to 987.
  
    ### Text field
  
    If no `type` argument is specified, a default of type 'text' is used.
  
    ```handlebars
    Search:
    <Input @value={{this.searchWord}} />
    ```
  
    In this example, the initial value in the `<input>` will be set to the value of
    `this.searchWord`. If the user changes the text, the value of `this.searchWord` will also be
    updated.
  
    ### Actions
  
    The `Input` component takes a number of arguments with callbacks that are invoked in response to
    user events.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-down`
    * `key-press`
    * `key-up`
  
    These callbacks are passed to `Input` like this:
  
    ```handlebars
    <Input @value={{this.searchWord}} @enter={{this.query}} />
    ```
  
    ### `<input>` HTML Attributes to Avoid
  
    In most cases, if you want to pass an attribute to the underlying HTML `<input>` element, you
    can pass the attribute directly, just like any other Ember component.
  
    ```handlebars
    <Input @type="text" size="10" />
    ```
  
    In this example, the `size` attribute will be applied to the underlying `<input>` element in the
    outputted HTML.
  
    However, there are a few attributes where you **must** use the `@` version.
  
    * `@type`: This argument is used to control which Ember component is used under the hood
    * `@value`: The `@value` argument installs a two-way binding onto the element. If you wanted a
      one-way binding, use `<input>` with the `value` property and the `input` event instead.
    * `@checked` (for checkboxes): like `@value`, the `@checked` argument installs a two-way binding
      onto the element. If you wanted a one-way binding, use `<input type="checkbox">` with
      `checked` and the `input` event instead.
  
    ### Extending `TextField`
  
    Internally, `<Input @type="text" />` creates an instance of `TextField`, passing arguments from
    the helper to `TextField`'s `create` method. Subclassing `TextField` is supported but not
    recommended.
  
    See [TextField](/ember/release/classes/TextField)
  
    ### Checkbox
  
    To create an `<input type="checkbox">`:
  
    ```handlebars
    Emberize Everything:
    <Input @type="checkbox" @checked={{this.isEmberized}} name="isEmberized" />
    ```
  
    This will bind the checked state of this checkbox to the value of `isEmberized` -- if either one
    changes, it will be reflected in the other.
  
    ### Extending `Checkbox`
  
    Internally, `<Input @type="checkbox" />` creates an instance of `Checkbox`. Subclassing
    `TextField` is supported but not recommended.
  
    See [Checkbox](/ember/release/classes/Checkbox)
  
    @method Input
    @for Ember.Templates.components
    @see {TextField}
    @see {Checkbox}
    @param {Hash} options
    @public
  */
  var Input = /*#__PURE__*/function (_InternalComponent) {
    (0, _emberBabel.inheritsLoose)(Input, _InternalComponent);
    function Input() {
      return _InternalComponent.apply(this, arguments) || this;
    }
    (0, _emberBabel.createClass)(Input, [{
      key: "isCheckbox",
      get: function get() {
        return this.arg('type') === 'checkbox';
      }
    }]);
    return Input;
  }(InternalComponent);
  (0, _runtime2.setComponentManager)(InternalManager.for('input'), Input);
  Input.toString = function () {
    return '@ember/component/input';
  };

  /**
  @module ember
  */
  /**
    Calls [String.loc](/ember/release/classes/String/methods/loc?anchor=loc) with the
    provided string. This is a convenient way to localize text within a template.
    For example:
  
    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```
  
    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```
  
    ```html
    <div class='message'>
      Bonjour
    </div>
    ```
  
    See [String.loc](/ember/release/classes/String/methods/loc?anchor=loc) for how to
    set up localized string references.
  
    @method loc
    @for Ember.Templates.helpers
    @param {String} str The string to format.
    @see {String#loc}
    @public
    @deprecated
  */

  var loc$1 = helper(function (params) {
    return _string.loc.apply(null, params
    /* let the other side handle errors */);
  });

  var ComponentTemplate = (0, _opcodeCompiler.templateFactory)({
    "id": "q4vmP/CB",
    "block": "{\"symbols\":[\"&default\"],\"statements\":[[18,1,null]],\"hasEval\":false,\"upvars\":[]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/component.hbs"
  });
  var InputTemplate = (0, _opcodeCompiler.templateFactory)({
    "id": "6ZtVRptz",
    "block": "{\"symbols\":[\"Checkbox\",\"TextField\",\"&attrs\"],\"statements\":[[6,[37,2],[[30,[36,1],[\"-checkbox\"],null],[30,[36,1],[\"-text-field\"],null]],null,[[\"default\"],[{\"statements\":[[6,[37,0],[[32,0,[\"isCheckbox\"]]],null,[[\"default\",\"else\"],[{\"statements\":[[8,[32,1],[[17,3]],[[\"@target\",\"@__ARGS__\"],[[32,0,[\"caller\"]],[32,0,[\"args\"]]]],null]],\"parameters\":[]},{\"statements\":[[8,[32,2],[[17,3]],[[\"@target\",\"@__ARGS__\"],[[32,0,[\"caller\"]],[32,0,[\"args\"]]]],null]],\"parameters\":[]}]]]],\"parameters\":[1,2]}]]]],\"hasEval\":false,\"upvars\":[\"if\",\"component\",\"let\"]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/input.hbs"
  });
  var OutletTemplate = (0, _opcodeCompiler.templateFactory)({
    "id": "xnYqOkvA",
    "block": "{\"symbols\":[],\"statements\":[[1,[30,[36,1],[[30,[36,0],null,null]],null]]],\"hasEval\":false,\"upvars\":[\"-outlet\",\"component\"]}",
    "moduleName": "packages/@ember/-internals/glimmer/lib/templates/outlet.hbs"
  });
  var TOP_LEVEL_NAME = '-top-level';
  var TOP_LEVEL_OUTLET = 'main';
  var OutletView = /*#__PURE__*/function () {
    function OutletView(_environment, renderer, owner, template) {
      this._environment = _environment;
      this.renderer = renderer;
      this.owner = owner;
      this.template = template;
      var outletStateTag = (0, _validator.createTag)();
      var outletState = {
        outlets: {
          main: undefined
        },
        render: {
          owner: owner,
          into: undefined,
          outlet: TOP_LEVEL_OUTLET,
          name: TOP_LEVEL_NAME,
          controller: undefined,
          model: undefined,
          template: template
        }
      };
      var ref = this.ref = (0, _reference.createComputeRef)(function () {
        (0, _validator.consumeTag)(outletStateTag);
        return outletState;
      }, function (state) {
        (0, _validator.dirtyTag)(outletStateTag);
        outletState.outlets.main = state;
      });
      this.state = {
        ref: ref,
        name: TOP_LEVEL_NAME,
        outlet: TOP_LEVEL_OUTLET,
        template: template,
        controller: undefined,
        model: undefined
      };
    }
    OutletView.extend = function extend(injections) {
      return /*#__PURE__*/function (_OutletView) {
        (0, _emberBabel.inheritsLoose)(_class, _OutletView);
        function _class() {
          return _OutletView.apply(this, arguments) || this;
        }
        _class.create = function create(options) {
          if (options) {
            return _OutletView.create.call(this, (0, _polyfills.assign)({}, injections, options));
          } else {
            return _OutletView.create.call(this, injections);
          }
        };
        return _class;
      }(OutletView);
    };
    OutletView.reopenClass = function reopenClass(injections) {
      (0, _polyfills.assign)(this, injections);
    };
    OutletView.create = function create(options) {
      var _environment = options._environment,
        renderer = options.renderer,
        templateFactory$$1 = options.template;
      var owner = (0, _owner.getOwner)(options);
      var template = templateFactory$$1(owner);
      return new OutletView(_environment, renderer, owner, template);
    };
    var _proto37 = OutletView.prototype;
    _proto37.appendTo = function appendTo(selector) {
      var target;
      if (this._environment.hasDOM) {
        target = typeof selector === 'string' ? document.querySelector(selector) : selector;
      } else {
        target = selector;
      }
      (0, _runloop.schedule)('render', this.renderer, 'appendOutletView', this, target);
    };
    _proto37.rerender = function rerender() {
      /**/
    };
    _proto37.setOutletState = function setOutletState(state) {
      (0, _reference.updateRef)(this.ref, state);
    };
    _proto37.destroy = function destroy() {
      /**/
    };
    return OutletView;
  }();
  _exports.OutletView = OutletView;
  function setupApplicationRegistry(registry) {
    registry.injection('renderer', 'env', '-environment:main'); // because we are using injections we can't use instantiate false
    // we need to use bind() to copy the function so factory for
    // association won't leak

    registry.register('service:-dom-builder', {
      create: function create(_ref26) {
        var bootOptions = _ref26.bootOptions;
        var _renderMode = bootOptions._renderMode;
        switch (_renderMode) {
          case 'serialize':
            return _node.serializeBuilder.bind(null);
          case 'rehydrate':
            return _runtime2.rehydrationBuilder.bind(null);
          default:
            return _runtime2.clientBuilder.bind(null);
        }
      }
    });
    registry.injection('service:-dom-builder', 'bootOptions', '-environment:main');
    registry.injection('renderer', 'builder', 'service:-dom-builder');
    registry.register((0, _container.privatize)(_templateObject4 || (_templateObject4 = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:-root"]))), RootTemplate);
    registry.injection('renderer', 'rootTemplate', (0, _container.privatize)(_templateObject5 || (_templateObject5 = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:-root"]))));
    registry.register('renderer:-dom', InteractiveRenderer);
    registry.register('renderer:-inert', InertRenderer);
    registry.injection('renderer', 'document', 'service:-document');
  }
  function setupEngineRegistry(registry) {
    registry.optionsForType('template', {
      instantiate: false
    });
    registry.register('view:-outlet', OutletView);
    registry.register('template:-outlet', OutletTemplate);
    registry.injection('view:-outlet', 'template', 'template:-outlet');
    registry.register((0, _container.privatize)(_templateObject6 || (_templateObject6 = (0, _emberBabel.taggedTemplateLiteralLoose)(["template:components/-default"]))), ComponentTemplate);
    registry.optionsForType('helper', {
      instantiate: false
    });
    registry.register('helper:loc', loc$1);
    registry.register('component:-text-field', TextField);
    registry.register('component:-checkbox', Checkbox);
    registry.register('component:link-to', LinkComponent);
    registry.register('component:input', Input);
    registry.register('template:components/input', InputTemplate);
    registry.register('component:textarea', TextArea);
    if (!_environment2.ENV._TEMPLATE_ONLY_GLIMMER_COMPONENTS) {
      registry.register((0, _container.privatize)(_templateObject7 || (_templateObject7 = (0, _emberBabel.taggedTemplateLiteralLoose)(["component:-default"]))), Component);
    }
  }
  function setComponentManager$1(stringOrFunction, obj) {
    var factory;
    if (_deprecatedFeatures.COMPONENT_MANAGER_STRING_LOOKUP && typeof stringOrFunction === 'string') {
      (true && !(false) && (0, _debug.deprecate)('Passing the name of the component manager to "setupComponentManager" is deprecated. Please pass a function that produces an instance of the manager.', false, {
        id: 'deprecate-string-based-component-manager',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x/#toc_component-manager-string-lookup',
        for: 'ember-source',
        since: {
          enabled: '3.8.0'
        }
      }));
      factory = function factory(owner) {
        return owner.lookup("component-manager:" + stringOrFunction);
      };
    } else {
      factory = stringOrFunction;
    }
    return (0, _runtime2.setComponentManager)(factory, obj);
  }

  /**
    [Glimmer](https://github.com/tildeio/glimmer) is a templating engine used by Ember.js that is compatible with a subset of the [Handlebars](http://handlebarsjs.com/) syntax.
  
    ### Showing a property
  
    Templates manage the flow of an application's UI, and display state (through
    the DOM) to a user. For example, given a component with the property "name",
    that component's template can use the name in several ways:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      name: 'Jill'
    });
    ```
  
    ```app/components/person-profile.hbs
    {{this.name}}
    <div>{{this.name}}</div>
    <span data-name={{this.name}}></span>
    ```
  
    Any time the "name" property on the component changes, the DOM will be
    updated.
  
    Properties can be chained as well:
  
    ```handlebars
    {{@aUserModel.name}}
    <div>{{@listOfUsers.firstObject.name}}</div>
    ```
  
    ### Using Ember helpers
  
    When content is passed in mustaches `{{}}`, Ember will first try to find a helper
    or component with that name. For example, the `if` helper:
  
    ```app/components/person-profile.hbs
    {{if this.name "I have a name" "I have no name"}}
    <span data-has-name={{if this.name true}}></span>
    ```
  
    The returned value is placed where the `{{}}` is called. The above style is
    called "inline". A second style of helper usage is called "block". For example:
  
    ```handlebars
    {{#if this.name}}
      I have a name
    {{else}}
      I have no name
    {{/if}}
    ```
  
    The block form of helpers allows you to control how the UI is created based
    on the values of properties.
    A third form of helper is called "nested". For example here the concat
    helper will add " Doe" to a displayed name if the person has no last name:
  
    ```handlebars
    <span data-name={{concat this.firstName (
      if this.lastName (concat " " this.lastName) "Doe"
    )}}></span>
    ```
  
    Ember's built-in helpers are described under the [Ember.Templates.helpers](/ember/release/classes/Ember.Templates.helpers)
    namespace. Documentation on creating custom helpers can be found under
    [helper](/ember/release/functions/@ember%2Fcomponent%2Fhelper/helper) (or
    under [Helper](/ember/release/classes/Helper) if a helper requires access to
    dependency injection).
  
    ### Invoking a Component
  
    Ember components represent state to the UI of an application. Further
    reading on components can be found under [Component](/ember/release/classes/Component).
  
    @module @ember/component
    @main @ember/component
    @public
   */
});
define("@ember/-internals/meta/index", ["exports", "@ember/-internals/meta/lib/meta"], function (_exports, _meta) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "Meta", {
    enumerable: true,
    get: function get() {
      return _meta.Meta;
    }
  });
  Object.defineProperty(_exports, "UNDEFINED", {
    enumerable: true,
    get: function get() {
      return _meta.UNDEFINED;
    }
  });
  Object.defineProperty(_exports, "counters", {
    enumerable: true,
    get: function get() {
      return _meta.counters;
    }
  });
  Object.defineProperty(_exports, "meta", {
    enumerable: true,
    get: function get() {
      return _meta.meta;
    }
  });
  Object.defineProperty(_exports, "peekMeta", {
    enumerable: true,
    get: function get() {
      return _meta.peekMeta;
    }
  });
  Object.defineProperty(_exports, "setMeta", {
    enumerable: true,
    get: function get() {
      return _meta.setMeta;
    }
  });
});
define("@ember/-internals/meta/lib/meta", ["exports", "ember-babel", "@ember/-internals/utils", "@ember/debug", "@glimmer/runtime"], function (_exports, _emberBabel, _utils, _debug, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.meta = _exports.counters = _exports.UNDEFINED = _exports.Meta = void 0;
  _exports.peekMeta = peekMeta;
  _exports.setMeta = setMeta;
  var objectPrototype = Object.prototype;
  var counters;
  _exports.counters = counters;
  if (true /* DEBUG */) {
    _exports.counters = counters = {
      peekCalls: 0,
      peekPrototypeWalks: 0,
      setCalls: 0,
      deleteCalls: 0,
      metaCalls: 0,
      metaInstantiated: 0,
      matchingListenersCalls: 0,
      observerEventsCalls: 0,
      addToListenersCalls: 0,
      removeFromListenersCalls: 0,
      removeAllListenersCalls: 0,
      listenersInherited: 0,
      listenersFlattened: 0,
      parentListenersUsed: 0,
      flattenedListenersCalls: 0,
      reopensAfterFlatten: 0,
      readableLazyChainsCalls: 0,
      writableLazyChainsCalls: 0
    };
  }
  /**
  @module ember
  */

  var UNDEFINED = (0, _utils.symbol)('undefined');
  _exports.UNDEFINED = UNDEFINED;
  var currentListenerVersion = 1;
  var Meta = /*#__PURE__*/function () {
    // DEBUG
    function Meta(obj) {
      this._listenersVersion = 1;
      this._inheritedEnd = -1;
      this._flattenedVersion = 0;
      if (true /* DEBUG */) {
        counters.metaInstantiated++;
      }
      this._parent = undefined;
      this._descriptors = undefined;
      this._mixins = undefined;
      this._lazyChains = undefined;
      this._values = undefined;
      this._revisions = undefined; // initial value for all flags right now is false
      // see FLAGS const for detailed list of flags used

      this._isInit = false; // used only internally

      this.source = obj;
      this.proto = obj.constructor === undefined ? undefined : obj.constructor.prototype;
      this._listeners = undefined;
    }
    var _proto = Meta.prototype;
    // These methods are here to prevent errors in legacy compat with some addons
    // that used them as intimate API
    _proto.setSourceDestroying = function setSourceDestroying() {
      (true && !(false) && (0, _debug.deprecate)('setSourceDestroying is deprecated, use the destroy() API to destroy the object directly instead', false, {
        id: 'meta-destruction-apis',
        until: '3.25.0',
        for: 'ember-source',
        since: {
          enabled: '3.21.0'
        }
      }));
    };
    _proto.setSourceDestroyed = function setSourceDestroyed() {
      (true && !(false) && (0, _debug.deprecate)('setSourceDestroyed is deprecated, use the destroy() API to destroy the object directly instead', false, {
        id: 'meta-destruction-apis',
        until: '3.25.0',
        for: 'ember-source',
        since: {
          enabled: '3.21.0'
        }
      }));
    };
    _proto.isSourceDestroying = function isSourceDestroying() {
      (true && !(false) && (0, _debug.deprecate)('isSourceDestroying is deprecated, use the isDestroying() API to check the object destruction state directly instead', false, {
        id: 'meta-destruction-apis',
        until: '3.25.0',
        for: 'ember-source',
        since: {
          enabled: '3.21.0'
        }
      }));
      return (0, _runtime.isDestroying)(this.source);
    };
    _proto.isSourceDestroyed = function isSourceDestroyed() {
      (true && !(false) && (0, _debug.deprecate)('isSourceDestroyed is deprecated, use the isDestroyed() API to check the object destruction state directly instead', false, {
        id: 'meta-destruction-apis',
        until: '3.25.0',
        for: 'ember-source',
        since: {
          enabled: '3.21.0'
        }
      }));
      return (0, _runtime.isDestroyed)(this.source);
    };
    _proto.setInitializing = function setInitializing() {
      this._isInit = true;
    };
    _proto.unsetInitializing = function unsetInitializing() {
      this._isInit = false;
    };
    _proto.isInitializing = function isInitializing() {
      return this._isInit;
    };
    _proto.isPrototypeMeta = function isPrototypeMeta(obj) {
      return this.proto === this.source && this.source === obj;
    };
    _proto._getOrCreateOwnMap = function _getOrCreateOwnMap(key) {
      return this[key] || (this[key] = Object.create(null));
    };
    _proto._getOrCreateOwnSet = function _getOrCreateOwnSet(key) {
      return this[key] || (this[key] = new Set());
    };
    _proto._findInheritedMap = function _findInheritedMap(key, subkey) {
      var pointer = this;
      while (pointer !== null) {
        var map = pointer[key];
        if (map !== undefined) {
          var value = map.get(subkey);
          if (value !== undefined) {
            return value;
          }
        }
        pointer = pointer.parent;
      }
    };
    _proto._hasInInheritedSet = function _hasInInheritedSet(key, value) {
      var pointer = this;
      while (pointer !== null) {
        var set = pointer[key];
        if (set !== undefined && set.has(value)) {
          return true;
        }
        pointer = pointer.parent;
      }
      return false;
    };
    _proto.valueFor = function valueFor(key) {
      var values = this._values;
      return values !== undefined ? values[key] : undefined;
    };
    _proto.setValueFor = function setValueFor(key, value) {
      var values = this._getOrCreateOwnMap('_values');
      values[key] = value;
    };
    _proto.revisionFor = function revisionFor(key) {
      var revisions = this._revisions;
      return revisions !== undefined ? revisions[key] : undefined;
    };
    _proto.setRevisionFor = function setRevisionFor(key, revision) {
      var revisions = this._getOrCreateOwnMap('_revisions');
      revisions[key] = revision;
    };
    _proto.writableLazyChainsFor = function writableLazyChainsFor(key) {
      if (true /* DEBUG */) {
        counters.writableLazyChainsCalls++;
      }
      var lazyChains = this._getOrCreateOwnMap('_lazyChains');
      var chains = lazyChains[key];
      if (chains === undefined) {
        chains = lazyChains[key] = [];
      }
      return chains;
    };
    _proto.readableLazyChainsFor = function readableLazyChainsFor(key) {
      if (true /* DEBUG */) {
        counters.readableLazyChainsCalls++;
      }
      var lazyChains = this._lazyChains;
      if (lazyChains !== undefined) {
        return lazyChains[key];
      }
      return undefined;
    };
    _proto.addMixin = function addMixin(mixin) {
      (true && !(!(0, _runtime.isDestroyed)(this.source)) && (0, _debug.assert)((0, _runtime.isDestroyed)(this.source) ? "Cannot add mixins of `" + (0, _utils.toString)(mixin) + "` on `" + (0, _utils.toString)(this.source) + "` call addMixin after it has been destroyed." : '', !(0, _runtime.isDestroyed)(this.source)));
      var set = this._getOrCreateOwnSet('_mixins');
      set.add(mixin);
    };
    _proto.hasMixin = function hasMixin(mixin) {
      return this._hasInInheritedSet('_mixins', mixin);
    };
    _proto.forEachMixins = function forEachMixins(fn) {
      var pointer = this;
      var seen;
      while (pointer !== null) {
        var set = pointer._mixins;
        if (set !== undefined) {
          seen = seen === undefined ? new Set() : seen; // TODO cleanup typing here

          set.forEach(function (mixin) {
            if (!seen.has(mixin)) {
              seen.add(mixin);
              fn(mixin);
            }
          });
        }
        pointer = pointer.parent;
      }
    };
    _proto.writeDescriptors = function writeDescriptors(subkey, value) {
      (true && !(!(0, _runtime.isDestroyed)(this.source)) && (0, _debug.assert)((0, _runtime.isDestroyed)(this.source) ? "Cannot update descriptors for `" + subkey + "` on `" + (0, _utils.toString)(this.source) + "` after it has been destroyed." : '', !(0, _runtime.isDestroyed)(this.source)));
      var map = this._descriptors || (this._descriptors = new Map());
      map.set(subkey, value);
    };
    _proto.peekDescriptors = function peekDescriptors(subkey) {
      var possibleDesc = this._findInheritedMap('_descriptors', subkey);
      return possibleDesc === UNDEFINED ? undefined : possibleDesc;
    };
    _proto.removeDescriptors = function removeDescriptors(subkey) {
      this.writeDescriptors(subkey, UNDEFINED);
    };
    _proto.forEachDescriptors = function forEachDescriptors(fn) {
      var pointer = this;
      var seen;
      while (pointer !== null) {
        var map = pointer._descriptors;
        if (map !== undefined) {
          seen = seen === undefined ? new Set() : seen;
          map.forEach(function (value, key) {
            if (!seen.has(key)) {
              seen.add(key);
              if (value !== UNDEFINED) {
                fn(key, value);
              }
            }
          });
        }
        pointer = pointer.parent;
      }
    };
    _proto.addToListeners = function addToListeners(eventName, target, method, once, sync) {
      if (true /* DEBUG */) {
        counters.addToListenersCalls++;
      }
      this.pushListener(eventName, target, method, once ? 1
      /* ONCE */ : 0
      /* ADD */, sync);
    };
    _proto.removeFromListeners = function removeFromListeners(eventName, target, method) {
      if (true /* DEBUG */) {
        counters.removeFromListenersCalls++;
      }
      this.pushListener(eventName, target, method, 2
      /* REMOVE */);
    };
    _proto.pushListener = function pushListener(event, target, method, kind, sync) {
      if (sync === void 0) {
        sync = false;
      }
      var listeners = this.writableListeners();
      var i = indexOfListener(listeners, event, target, method); // remove if found listener was inherited

      if (i !== -1 && i < this._inheritedEnd) {
        listeners.splice(i, 1);
        this._inheritedEnd--;
        i = -1;
      } // if not found, push. Note that we must always push if a listener is not
      // found, even in the case of a function listener remove, because we may be
      // attempting to add or remove listeners _before_ flattening has occurred.

      if (i === -1) {
        (true && !(!(this.isPrototypeMeta(this.source) && typeof method === 'function')) && (0, _debug.assert)('You cannot add function listeners to prototypes. Convert the listener to a string listener, or add it to the instance instead.', !(this.isPrototypeMeta(this.source) && typeof method === 'function')));
        (true && !(!(!this.isPrototypeMeta(this.source) && typeof method === 'function' && kind === 2
        /* REMOVE */)) && (0, _debug.assert)('You attempted to remove a function listener which did not exist on the instance, which means you may have attempted to remove it before it was added.', !(!this.isPrototypeMeta(this.source) && typeof method === 'function' && kind === 2)));
        listeners.push({
          event: event,
          target: target,
          method: method,
          kind: kind,
          sync: sync
        });
      } else {
        var listener = listeners[i]; // If the listener is our own listener and we are trying to remove it, we
        // want to splice it out entirely so we don't hold onto a reference.

        if (kind === 2
        /* REMOVE */ && listener.kind !== 2
        /* REMOVE */) {
          listeners.splice(i, 1);
        } else {
          (true && !(!(listener.kind === 0
          /* ADD */ && kind === 0
          /* ADD */ && listener.sync !== sync)) && (0, _debug.assert)("You attempted to add an observer for the same method on '" + event.split(':')[0] + "' twice to " + target + " as both sync and async. Observers must be either sync or async, they cannot be both. This is likely a mistake, you should either remove the code that added the observer a second time, or update it to always be sync or async. The method was " + method + ".", !(listener.kind === 0 && kind === 0 && listener.sync !== sync))); // update own listener
          listener.kind = kind;
          listener.sync = sync;
        }
      }
    };
    _proto.writableListeners = function writableListeners() {
      // Check if we need to invalidate and reflatten. We need to do this if we
      // have already flattened (flattened version is the current version) and
      // we are either writing to a prototype meta OR we have never inherited, and
      // may have cached the parent's listeners.
      if (this._flattenedVersion === currentListenerVersion && (this.source === this.proto || this._inheritedEnd === -1)) {
        if (true /* DEBUG */) {
          counters.reopensAfterFlatten++;
        }
        currentListenerVersion++;
      } // Inherited end has not been set, then we have never created our own
      // listeners, but may have cached the parent's

      if (this._inheritedEnd === -1) {
        this._inheritedEnd = 0;
        this._listeners = [];
      }
      return this._listeners;
    }
    /**
      Flattening is based on a global revision counter. If the revision has
      bumped it means that somewhere in a class inheritance chain something has
      changed, so we need to reflatten everything. This can only happen if:
         1. A meta has been flattened (listener has been called)
      2. The meta is a prototype meta with children who have inherited its
         listeners
      3. A new listener is subsequently added to the meta (e.g. via `.reopen()`)
         This is a very rare occurrence, so while the counter is global it shouldn't
      be updated very often in practice.
    */;
    _proto.flattenedListeners = function flattenedListeners() {
      if (true /* DEBUG */) {
        counters.flattenedListenersCalls++;
      }
      if (this._flattenedVersion < currentListenerVersion) {
        if (true /* DEBUG */) {
          counters.listenersFlattened++;
        }
        var parent = this.parent;
        if (parent !== null) {
          // compute
          var parentListeners = parent.flattenedListeners();
          if (parentListeners !== undefined) {
            if (this._listeners === undefined) {
              // If this instance doesn't have any of its own listeners (writableListeners
              // has never been called) then we don't need to do any flattening, return
              // the parent's listeners instead.
              if (true /* DEBUG */) {
                counters.parentListenersUsed++;
              }
              this._listeners = parentListeners;
            } else {
              var listeners = this._listeners;
              if (this._inheritedEnd > 0) {
                listeners.splice(0, this._inheritedEnd);
                this._inheritedEnd = 0;
              }
              for (var i = 0; i < parentListeners.length; i++) {
                var listener = parentListeners[i];
                var index = indexOfListener(listeners, listener.event, listener.target, listener.method);
                if (index === -1) {
                  if (true /* DEBUG */) {
                    counters.listenersInherited++;
                  }
                  listeners.unshift(listener);
                  this._inheritedEnd++;
                }
              }
            }
          }
        }
        this._flattenedVersion = currentListenerVersion;
      }
      return this._listeners;
    };
    _proto.matchingListeners = function matchingListeners(eventName) {
      var listeners = this.flattenedListeners();
      var result;
      if (true /* DEBUG */) {
        counters.matchingListenersCalls++;
      }
      if (listeners !== undefined) {
        for (var index = 0; index < listeners.length; index++) {
          var listener = listeners[index]; // REMOVE listeners are placeholders that tell us not to
          // inherit, so they never match. Only ADD and ONCE can match.

          if (listener.event === eventName && (listener.kind === 0
          /* ADD */ || listener.kind === 1
          /* ONCE */)) {
            if (result === undefined) {
              // we create this array only after we've found a listener that
              // matches to avoid allocations when no matches are found.
              result = [];
            }
            result.push(listener.target, listener.method, listener.kind === 1
            /* ONCE */);
          }
        }
      }

      return result;
    };
    _proto.observerEvents = function observerEvents() {
      var listeners = this.flattenedListeners();
      var result;
      if (true /* DEBUG */) {
        counters.observerEventsCalls++;
      }
      if (listeners !== undefined) {
        for (var index = 0; index < listeners.length; index++) {
          var listener = listeners[index]; // REMOVE listeners are placeholders that tell us not to
          // inherit, so they never match. Only ADD and ONCE can match.

          if ((listener.kind === 0
          /* ADD */ || listener.kind === 1
          /* ONCE */) && listener.event.indexOf(':change') !== -1) {
            if (result === undefined) {
              // we create this array only after we've found a listener that
              // matches to avoid allocations when no matches are found.
              result = [];
            }
            result.push(listener);
          }
        }
      }
      return result;
    };
    (0, _emberBabel.createClass)(Meta, [{
      key: "parent",
      get: function get() {
        var parent = this._parent;
        if (parent === undefined) {
          var proto = getPrototypeOf(this.source);
          this._parent = parent = proto === null || proto === objectPrototype ? null : meta(proto);
        }
        return parent;
      }
    }]);
    return Meta;
  }();
  _exports.Meta = Meta;
  var getPrototypeOf = Object.getPrototypeOf;
  var metaStore = new WeakMap();
  function setMeta(obj, meta) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `setMeta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `setMeta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `setMeta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));
    if (true /* DEBUG */) {
      counters.setCalls++;
    }
    metaStore.set(obj, meta);
  }
  function peekMeta(obj) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `peekMeta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `peekMeta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `peekMeta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));
    if (true /* DEBUG */) {
      counters.peekCalls++;
    }
    var meta = metaStore.get(obj);
    if (meta !== undefined) {
      return meta;
    }
    var pointer = getPrototypeOf(obj);
    while (pointer !== null) {
      if (true /* DEBUG */) {
        counters.peekPrototypeWalks++;
      }
      meta = metaStore.get(pointer);
      if (meta !== undefined) {
        if (meta.proto !== pointer) {
          // The meta was a prototype meta which was not marked as initializing.
          // This can happen when a prototype chain was created manually via
          // Object.create() and the source object does not have a constructor.
          meta.proto = pointer;
        }
        return meta;
      }
      pointer = getPrototypeOf(pointer);
    }
    return null;
  }
  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */

  var meta = function meta(obj) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `meta` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `meta` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `meta` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));
    if (true /* DEBUG */) {
      counters.metaCalls++;
    }
    var maybeMeta = peekMeta(obj); // remove this code, in-favor of explicit parent

    if (maybeMeta !== null && maybeMeta.source === obj) {
      return maybeMeta;
    }
    var newMeta = new Meta(obj);
    setMeta(obj, newMeta);
    return newMeta;
  };
  _exports.meta = meta;
  if (true /* DEBUG */) {
    meta._counters = counters;
  }
  function indexOfListener(listeners, event, target, method) {
    for (var i = listeners.length - 1; i >= 0; i--) {
      var listener = listeners[i];
      if (listener.event === event && listener.target === target && listener.method === method) {
        return i;
      }
    }
    return -1;
  }
});
define("@ember/-internals/metal/index", ["exports", "ember-babel", "@ember/-internals/meta", "@ember/-internals/utils", "@ember/debug", "@ember/-internals/environment", "@ember/runloop", "@glimmer/runtime", "@glimmer/validator", "@glimmer/util", "@ember/error", "ember/version", "@ember/deprecated-features", "@ember/polyfills", "@ember/-internals/owner"], function (_exports, _emberBabel, _meta2, _utils, _debug, _environment, _runloop, _runtime, _validator, _util, _error, _version, _deprecatedFeatures, _polyfills, _owner) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.SYNC_OBSERVERS = _exports.PROXY_CONTENT = _exports.PROPERTY_DID_CHANGE = _exports.NAMESPACES_BY_ID = _exports.NAMESPACES = _exports.Mixin = _exports.Libraries = _exports.DEBUG_INJECTION_FUNCTIONS = _exports.ComputedProperty = _exports.CUSTOM_TAG_FOR = _exports.ASYNC_OBSERVERS = void 0;
  _exports._getPath = _getPath;
  _exports._getProp = _getProp;
  _exports._globalsComputed = void 0;
  _exports.activateObserver = activateObserver;
  _exports.addArrayObserver = addArrayObserver;
  _exports.addListener = addListener;
  _exports.addNamespace = addNamespace;
  _exports.addObserver = addObserver;
  _exports.alias = alias;
  _exports.aliasMethod = void 0;
  _exports.applyMixin = applyMixin;
  _exports.arrayContentDidChange = arrayContentDidChange;
  _exports.arrayContentWillChange = arrayContentWillChange;
  _exports.autoComputed = autoComputed;
  _exports.beginPropertyChanges = beginPropertyChanges;
  _exports.changeProperties = changeProperties;
  _exports.classToString = classToString;
  _exports.computed = computed;
  Object.defineProperty(_exports, "createCache", {
    enumerable: true,
    get: function get() {
      return _validator.createCache;
    }
  });
  _exports.defineProperty = defineProperty;
  _exports.deprecateProperty = deprecateProperty;
  _exports.descriptorForDecorator = descriptorForDecorator;
  _exports.descriptorForProperty = descriptorForProperty;
  _exports.eachProxyArrayDidChange = eachProxyArrayDidChange;
  _exports.eachProxyArrayWillChange = eachProxyArrayWillChange;
  _exports.endPropertyChanges = endPropertyChanges;
  _exports.expandProperties = expandProperties;
  _exports.findNamespace = findNamespace;
  _exports.findNamespaces = findNamespaces;
  _exports.flushAsyncObservers = flushAsyncObservers;
  _exports.get = _get3;
  _exports.getCachedValueFor = getCachedValueFor;
  _exports.getProperties = getProperties;
  Object.defineProperty(_exports, "getValue", {
    enumerable: true,
    get: function get() {
      return _validator.getValue;
    }
  });
  _exports.getWithDefault = getWithDefault;
  _exports.hasListeners = hasListeners;
  _exports.inject = inject;
  _exports.isBlank = isBlank;
  _exports.isClassicDecorator = isClassicDecorator;
  _exports.isComputed = isComputed;
  Object.defineProperty(_exports, "isConst", {
    enumerable: true,
    get: function get() {
      return _validator.isConst;
    }
  });
  _exports.isElementDescriptor = isElementDescriptor;
  _exports.isEmpty = isEmpty;
  _exports.isNamespaceSearchDisabled = isSearchDisabled;
  _exports.isNone = isNone;
  _exports.isPresent = isPresent;
  _exports.libraries = void 0;
  _exports.markObjectAsDirty = markObjectAsDirty;
  _exports.mixin = mixin;
  _exports.nativeDescDecorator = nativeDescDecorator;
  _exports.notifyPropertyChange = notifyPropertyChange;
  _exports.objectAt = objectAt;
  _exports.observer = observer;
  _exports.on = on;
  _exports.processAllNamespaces = processAllNamespaces;
  _exports.processNamespace = processNamespace;
  _exports.removeArrayObserver = removeArrayObserver;
  _exports.removeListener = removeListener;
  _exports.removeNamespace = removeNamespace;
  _exports.removeObserver = removeObserver;
  _exports.replace = replace;
  _exports.replaceInNativeArray = replaceInNativeArray;
  _exports.sendEvent = sendEvent;
  _exports.set = _set2;
  _exports.setClassicDecorator = setClassicDecorator;
  _exports.setNamespaceSearchDisabled = setSearchDisabled;
  _exports.setProperties = setProperties;
  _exports.tagForObject = tagForObject;
  _exports.tagForProperty = tagForProperty;
  _exports.tracked = tracked;
  _exports.trySet = trySet;
  /**
  @module @ember/object
  */
  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:change": [ // variable name: `actions`
              target, method, once
            ]
          }
        }
  
  */

  /**
    Add an event listener
  
    @method addListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */

  function addListener(obj, eventName, target, method, once, sync) {
    if (sync === void 0) {
      sync = true;
    }
    (true && !(Boolean(obj) && Boolean(eventName)) && (0, _debug.assert)('You must pass at least an object and event name to addListener', Boolean(obj) && Boolean(eventName)));
    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }
    (0, _meta2.meta)(obj).addToListeners(eventName, target, method, once === true, sync);
  }
  /**
    Remove an event listener
  
    Arguments should match those passed to `addListener`.
  
    @method removeListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */

  function removeListener(obj, eventName, targetOrFunction, functionOrName) {
    (true && !(Boolean(obj) && Boolean(eventName) && (typeof targetOrFunction === 'function' || typeof targetOrFunction === 'object' && Boolean(functionOrName))) && (0, _debug.assert)('You must pass at least an object, event name, and method or target and method/method name to removeListener', Boolean(obj) && Boolean(eventName) && (typeof targetOrFunction === 'function' || typeof targetOrFunction === 'object' && Boolean(functionOrName))));
    var target, method;
    if (typeof targetOrFunction === 'object') {
      target = targetOrFunction;
      method = functionOrName;
    } else {
      target = null;
      method = targetOrFunction;
    }
    var m = (0, _meta2.meta)(obj);
    m.removeFromListeners(eventName, target, method);
  }
  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @return {Boolean} if the event was delivered to one or more actions
    @public
  */

  function sendEvent(obj, eventName, params, actions, _meta) {
    if (actions === undefined) {
      var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;
      actions = meta$$1 !== null ? meta$$1.matchingListeners(eventName) : undefined;
    }
    if (actions === undefined || actions.length === 0) {
      return false;
    }
    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var once = actions[i + 2];
      if (!method) {
        continue;
      }
      if (once) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      var type = typeof method;
      if (type === 'string' || type === 'symbol') {
        method = target[method];
      }
      method.apply(target, params);
    }
    return true;
  }
  /**
    @private
    @method hasListeners
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @return {Boolean} if `obj` has listeners for event `eventName`
  */

  function hasListeners(obj, eventName) {
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    if (meta$$1 === null) {
      return false;
    }
    var matched = meta$$1.matchingListeners(eventName);
    return matched !== undefined && matched.length > 0;
  }
  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
    ``` javascript
    import EmberObject from '@ember/object';
    import { on } from '@ember/object/evented';
    import { sendEvent } from '@ember/object/events';
  
    let Job = EmberObject.extend({
      logCompleted: on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @static
    @for @ember/object/evented
    @param {String} eventNames*
    @param {Function} func
    @return {Function} the listener function, passed as last argument to on(...)
    @public
  */

  function on() {
    for (var _len = arguments.length, args = new Array(_len), _key2 = 0; _key2 < _len; _key2++) {
      args[_key2] = arguments[_key2];
    }
    var func = args.pop();
    var events = args;
    (true && !(typeof func === 'function') && (0, _debug.assert)('on expects function as last argument', typeof func === 'function'));
    (true && !(events.length > 0 && events.every(function (p) {
      return typeof p === 'string' && p.length > 0;
    })) && (0, _debug.assert)('on called without valid event names', events.length > 0 && events.every(function (p) {
      return typeof p === 'string' && p.length > 0;
    })));
    (0, _utils.setListeners)(func, events);
    return func;
  }
  var AFTER_OBSERVERS = ':change';
  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }
  var SYNC_DEFAULT = !_environment.ENV._DEFAULT_ASYNC_OBSERVERS;
  var SYNC_OBSERVERS = new Map();
  _exports.SYNC_OBSERVERS = SYNC_OBSERVERS;
  var ASYNC_OBSERVERS = new Map();
  /**
  @module @ember/object
  */

  /**
    @method addObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */
  _exports.ASYNC_OBSERVERS = ASYNC_OBSERVERS;
  function addObserver(obj, path, target, method, sync) {
    if (sync === void 0) {
      sync = SYNC_DEFAULT;
    }
    var eventName = changeEvent(path);
    addListener(obj, eventName, target, method, false, sync);
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    if (meta$$1 === null || !(meta$$1.isPrototypeMeta(obj) || meta$$1.isInitializing())) {
      activateObserver(obj, eventName, sync);
    }
  }
  /**
    @method removeObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function removeObserver(obj, path, target, method, sync) {
    if (sync === void 0) {
      sync = SYNC_DEFAULT;
    }
    var eventName = changeEvent(path);
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    if (meta$$1 === null || !(meta$$1.isPrototypeMeta(obj) || meta$$1.isInitializing())) {
      deactivateObserver(obj, eventName, sync);
    }
    removeListener(obj, eventName, target, method);
  }
  function getOrCreateActiveObserversFor(target, sync) {
    var observerMap = sync === true ? SYNC_OBSERVERS : ASYNC_OBSERVERS;
    if (!observerMap.has(target)) {
      observerMap.set(target, new Map());
      (0, _runtime.registerDestructor)(target, function () {
        return destroyObservers(target);
      }, true);
    }
    return observerMap.get(target);
  }
  function activateObserver(target, eventName, sync) {
    if (sync === void 0) {
      sync = false;
    }
    var activeObservers = getOrCreateActiveObserversFor(target, sync);
    if (activeObservers.has(eventName)) {
      activeObservers.get(eventName).count++;
    } else {
      var _eventName$split = eventName.split(':'),
        path = _eventName$split[0];
      var tag = getChainTagsForKey(target, path, (0, _validator.tagMetaFor)(target), (0, _meta2.peekMeta)(target));
      activeObservers.set(eventName, {
        count: 1,
        path: path,
        tag: tag,
        lastRevision: (0, _validator.valueForTag)(tag),
        suspended: false
      });
    }
  }
  var DEACTIVATE_SUSPENDED = false;
  var SCHEDULED_DEACTIVATE = [];
  function deactivateObserver(target, eventName, sync) {
    if (sync === void 0) {
      sync = false;
    }
    if (DEACTIVATE_SUSPENDED === true) {
      SCHEDULED_DEACTIVATE.push([target, eventName, sync]);
      return;
    }
    var observerMap = sync === true ? SYNC_OBSERVERS : ASYNC_OBSERVERS;
    var activeObservers = observerMap.get(target);
    if (activeObservers !== undefined) {
      var _observer = activeObservers.get(eventName);
      _observer.count--;
      if (_observer.count === 0) {
        activeObservers.delete(eventName);
        if (activeObservers.size === 0) {
          observerMap.delete(target);
        }
      }
    }
  }
  function suspendedObserverDeactivation() {
    DEACTIVATE_SUSPENDED = true;
  }
  function resumeObserverDeactivation() {
    DEACTIVATE_SUSPENDED = false;
    for (var _iterator = (0, _emberBabel.createForOfIteratorHelperLoose)(SCHEDULED_DEACTIVATE), _step; !(_step = _iterator()).done;) {
      var _step$value = _step.value,
        target = _step$value[0],
        eventName = _step$value[1],
        sync = _step$value[2];
      deactivateObserver(target, eventName, sync);
    }
    SCHEDULED_DEACTIVATE = [];
  }
  /**
   * Primarily used for cases where we are redefining a class, e.g. mixins/reopen
   * being applied later. Revalidates all the observers, resetting their tags.
   *
   * @private
   * @param target
   */

  function revalidateObservers(target) {
    if (ASYNC_OBSERVERS.has(target)) {
      ASYNC_OBSERVERS.get(target).forEach(function (observer) {
        observer.tag = getChainTagsForKey(target, observer.path, (0, _validator.tagMetaFor)(target), (0, _meta2.peekMeta)(target));
        observer.lastRevision = (0, _validator.valueForTag)(observer.tag);
      });
    }
    if (SYNC_OBSERVERS.has(target)) {
      SYNC_OBSERVERS.get(target).forEach(function (observer) {
        observer.tag = getChainTagsForKey(target, observer.path, (0, _validator.tagMetaFor)(target), (0, _meta2.peekMeta)(target));
        observer.lastRevision = (0, _validator.valueForTag)(observer.tag);
      });
    }
  }
  var lastKnownRevision = 0;
  function flushAsyncObservers(shouldSchedule) {
    if (shouldSchedule === void 0) {
      shouldSchedule = true;
    }
    var currentRevision = (0, _validator.valueForTag)(_validator.CURRENT_TAG);
    if (lastKnownRevision === currentRevision) {
      return;
    }
    lastKnownRevision = currentRevision;
    ASYNC_OBSERVERS.forEach(function (activeObservers, target) {
      var meta$$1 = (0, _meta2.peekMeta)(target);
      activeObservers.forEach(function (observer, eventName) {
        if (!(0, _validator.validateTag)(observer.tag, observer.lastRevision)) {
          var sendObserver = function sendObserver() {
            try {
              sendEvent(target, eventName, [target, observer.path], undefined, meta$$1);
            } finally {
              observer.tag = getChainTagsForKey(target, observer.path, (0, _validator.tagMetaFor)(target), (0, _meta2.peekMeta)(target));
              observer.lastRevision = (0, _validator.valueForTag)(observer.tag);
            }
          };
          if (shouldSchedule) {
            (0, _runloop.schedule)('actions', sendObserver);
          } else {
            sendObserver();
          }
        }
      });
    });
  }
  function flushSyncObservers() {
    // When flushing synchronous observers, we know that something has changed (we
    // only do this during a notifyPropertyChange), so there's no reason to check
    // a global revision.
    SYNC_OBSERVERS.forEach(function (activeObservers, target) {
      var meta$$1 = (0, _meta2.peekMeta)(target);
      activeObservers.forEach(function (observer, eventName) {
        if (!observer.suspended && !(0, _validator.validateTag)(observer.tag, observer.lastRevision)) {
          try {
            observer.suspended = true;
            sendEvent(target, eventName, [target, observer.path], undefined, meta$$1);
          } finally {
            observer.tag = getChainTagsForKey(target, observer.path, (0, _validator.tagMetaFor)(target), (0, _meta2.peekMeta)(target));
            observer.lastRevision = (0, _validator.valueForTag)(observer.tag);
            observer.suspended = false;
          }
        }
      });
    });
  }
  function setObserverSuspended(target, property, suspended) {
    var activeObservers = SYNC_OBSERVERS.get(target);
    if (!activeObservers) {
      return;
    }
    var observer = activeObservers.get(changeEvent(property));
    if (observer) {
      observer.suspended = suspended;
    }
  }
  function destroyObservers(target) {
    if (SYNC_OBSERVERS.size > 0) SYNC_OBSERVERS.delete(target);
    if (ASYNC_OBSERVERS.size > 0) ASYNC_OBSERVERS.delete(target);
  }
  var CUSTOM_TAG_FOR = (0, _utils.enumerableSymbol)('CUSTOM_TAG_FOR'); // This is exported for `@tracked`, but should otherwise be avoided. Use `tagForObject`.
  _exports.CUSTOM_TAG_FOR = CUSTOM_TAG_FOR;
  var SELF_TAG = (0, _utils.symbol)('SELF_TAG');
  function tagForProperty(obj, propertyKey, addMandatorySetter, meta$$1) {
    if (addMandatorySetter === void 0) {
      addMandatorySetter = false;
    }
    if (typeof obj[CUSTOM_TAG_FOR] === 'function') {
      return obj[CUSTOM_TAG_FOR](propertyKey, addMandatorySetter);
    }
    var tag = (0, _validator.tagFor)(obj, propertyKey, meta$$1);
    if (true /* DEBUG */ && addMandatorySetter) {
      (0, _utils.setupMandatorySetter)(tag, obj, propertyKey);
    }
    return tag;
  }
  function tagForObject(obj) {
    if ((0, _utils.isObject)(obj)) {
      if (true /* DEBUG */) {
        (true && !(!(0, _runtime.isDestroyed)(obj)) && (0, _debug.assert)((0, _runtime.isDestroyed)(obj) ? "Cannot create a new tag for `" + (0, _utils.toString)(obj) + "` after it has been destroyed." : '', !(0, _runtime.isDestroyed)(obj)));
      }
      return (0, _validator.tagFor)(obj, SELF_TAG);
    }
    return _validator.CONSTANT_TAG;
  }
  function markObjectAsDirty(obj, propertyKey) {
    (0, _validator.dirtyTagFor)(obj, propertyKey);
    (0, _validator.dirtyTagFor)(obj, SELF_TAG);
  }

  /**
   @module ember
   @private
   */

  var PROPERTY_DID_CHANGE = (0, _utils.enumerableSymbol)('PROPERTY_DID_CHANGE');
  _exports.PROPERTY_DID_CHANGE = PROPERTY_DID_CHANGE;
  var deferred = 0;
  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually.
  
    @method notifyPropertyChange
    @for @ember/object
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @param {Meta} [_meta] The objects meta.
    @param {unknown} [value] The new value to set for the property
    @return {void}
    @since 3.1.0
    @public
  */

  function notifyPropertyChange(obj, keyName, _meta, value) {
    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;
    if (meta$$1 !== null && (meta$$1.isInitializing() || meta$$1.isPrototypeMeta(obj))) {
      return;
    }
    markObjectAsDirty(obj, keyName);
    if (deferred <= 0) {
      flushSyncObservers();
    }
    if (PROPERTY_DID_CHANGE in obj) {
      // we need to check the arguments length here; there's a check in `PROPERTY_DID_CHANGE`
      // that checks its arguments length, so we have to explicitly not call this with `value`
      // if it is not passed to `notifyPropertyChange`
      if (arguments.length === 4) {
        obj[PROPERTY_DID_CHANGE](keyName, value);
      } else {
        obj[PROPERTY_DID_CHANGE](keyName);
      }
    }
  }
  /**
    @method beginPropertyChanges
    @chainable
    @private
  */

  function beginPropertyChanges() {
    deferred++;
    suspendedObserverDeactivation();
  }
  /**
    @method endPropertyChanges
    @private
  */

  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      flushSyncObservers();
      resumeObserverDeactivation();
    }
  }
  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @private
  */

  function changeProperties(callback) {
    beginPropertyChanges();
    try {
      callback();
    } finally {
      endPropertyChanges();
    }
  }
  function arrayContentWillChange(array, startIdx, removeAmt, addAmt) {
    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }
      if (addAmt === undefined) {
        addAmt = -1;
      }
    }
    sendEvent(array, '@array:before', [array, startIdx, removeAmt, addAmt]);
    return array;
  }
  function arrayContentDidChange(array, startIdx, removeAmt, addAmt, notify) {
    if (notify === void 0) {
      notify = true;
    }
    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }
      if (addAmt === undefined) {
        addAmt = -1;
      }
    }
    var meta$$1 = (0, _meta2.peekMeta)(array);
    if (notify) {
      if (addAmt < 0 || removeAmt < 0 || addAmt - removeAmt !== 0) {
        notifyPropertyChange(array, 'length', meta$$1);
      }
      notifyPropertyChange(array, '[]', meta$$1);
    }
    sendEvent(array, '@array:change', [array, startIdx, removeAmt, addAmt]);
    if (meta$$1 !== null) {
      var length = array.length;
      var addedAmount = addAmt === -1 ? 0 : addAmt;
      var removedAmount = removeAmt === -1 ? 0 : removeAmt;
      var delta = addedAmount - removedAmount;
      var previousLength = length - delta;
      var normalStartIdx = startIdx < 0 ? previousLength + startIdx : startIdx;
      if (meta$$1.revisionFor('firstObject') !== undefined && normalStartIdx === 0) {
        notifyPropertyChange(array, 'firstObject', meta$$1);
      }
      if (meta$$1.revisionFor('lastObject') !== undefined) {
        var previousLastIndex = previousLength - 1;
        var lastAffectedIndex = normalStartIdx + removedAmount;
        if (previousLastIndex < lastAffectedIndex) {
          notifyPropertyChange(array, 'lastObject', meta$$1);
        }
      }
    }
    return array;
  }
  var EMPTY_ARRAY = Object.freeze([]);
  function objectAt(array, index) {
    if (Array.isArray(array)) {
      return array[index];
    } else {
      return array.objectAt(index);
    }
  }
  function replace(array, start, deleteCount, items) {
    if (items === void 0) {
      items = EMPTY_ARRAY;
    }
    if (Array.isArray(array)) {
      replaceInNativeArray(array, start, deleteCount, items);
    } else {
      array.replace(start, deleteCount, items);
    }
  }
  var CHUNK_SIZE = 60000; // To avoid overflowing the stack, we splice up to CHUNK_SIZE items at a time.
  // See https://code.google.com/p/chromium/issues/detail?id=56588 for more details.

  function replaceInNativeArray(array, start, deleteCount, items) {
    arrayContentWillChange(array, start, deleteCount, items.length);
    if (items.length <= CHUNK_SIZE) {
      array.splice.apply(array, [start, deleteCount].concat(items));
    } else {
      array.splice(start, deleteCount);
      for (var i = 0; i < items.length; i += CHUNK_SIZE) {
        var chunk = items.slice(i, i + CHUNK_SIZE);
        array.splice.apply(array, [start + i, 0].concat(chunk));
      }
    }
    arrayContentDidChange(array, start, deleteCount, items.length);
  }
  function arrayObserversHelper(obj, target, opts, operation, notify) {
    var willChange = opts && opts.willChange || 'arrayWillChange';
    var didChange = opts && opts.didChange || 'arrayDidChange';
    var hasObservers = obj.hasArrayObservers;
    operation(obj, '@array:before', target, willChange);
    operation(obj, '@array:change', target, didChange);
    if (hasObservers === notify) {
      notifyPropertyChange(obj, 'hasArrayObservers');
    }
    return obj;
  }
  function addArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, addListener, false);
  }
  function removeArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, removeListener, true);
  }
  var CHAIN_PASS_THROUGH = new _util._WeakSet();
  function finishLazyChains(meta$$1, key, value) {
    var lazyTags = meta$$1.readableLazyChainsFor(key);
    if (lazyTags === undefined) {
      return;
    }
    if ((0, _utils.isObject)(value)) {
      for (var i = 0; i < lazyTags.length; i++) {
        var _lazyTags$i = lazyTags[i],
          tag = _lazyTags$i[0],
          deps = _lazyTags$i[1];
        (0, _validator.updateTag)(tag, getChainTagsForKey(value, deps, (0, _validator.tagMetaFor)(value), (0, _meta2.peekMeta)(value)));
      }
    }
    lazyTags.length = 0;
  }
  function getChainTagsForKeys(obj, keys, tagMeta, meta$$1) {
    var tags = [];
    for (var i = 0; i < keys.length; i++) {
      getChainTags(tags, obj, keys[i], tagMeta, meta$$1);
    }
    return (0, _validator.combine)(tags);
  }
  function getChainTagsForKey(obj, key, tagMeta, meta$$1) {
    return (0, _validator.combine)(getChainTags([], obj, key, tagMeta, meta$$1));
  }
  function getChainTags(chainTags, obj, path, tagMeta, meta$$1) {
    var current = obj;
    var currentTagMeta = tagMeta;
    var currentMeta = meta$$1;
    var pathLength = path.length;
    var segmentEnd = -1; // prevent closures

    var segment, descriptor; // eslint-disable-next-line no-constant-condition

    while (true) {
      var lastSegmentEnd = segmentEnd + 1;
      segmentEnd = path.indexOf('.', lastSegmentEnd);
      if (segmentEnd === -1) {
        segmentEnd = pathLength;
      }
      segment = path.slice(lastSegmentEnd, segmentEnd); // If the segment is an @each, we can process it and then break

      if (segment === '@each' && segmentEnd !== pathLength) {
        lastSegmentEnd = segmentEnd + 1;
        segmentEnd = path.indexOf('.', lastSegmentEnd); // There should be exactly one segment after an `@each` (i.e. `@each.foo`, not `@each.foo.bar`)
        (true && !(segmentEnd === -1) && (0, _debug.deprecate)("When using @each in a dependent-key or an observer, " + "you can only chain one property level deep after " + ("the @each. That is, `" + path.slice(0, segmentEnd) + "` ") + ("is allowed but `" + path + "` (which is what you passed) ") + "is not.\n\n" + "This was never supported. Currently, the extra segments " + ("are silently ignored, i.e. `" + path + "` behaves exactly ") + ("the same as `" + path.slice(0, segmentEnd) + "`. ") + "In the future, this will throw an error.\n\n" + "If the current behavior is acceptable for your use case, " + "please remove the extraneous segments by changing your " + ("key to `" + path.slice(0, segmentEnd) + "`. ") + "Otherwise, please create an intermediary computed property " + "or switch to using tracked properties.", segmentEnd === -1, {
          until: '3.17.0',
          id: 'ember-metal.computed-deep-each',
          for: 'ember-source',
          since: {
            enabled: '3.13.0-beta.3'
          }
        }));
        var arrLength = current.length;
        if (typeof arrLength !== 'number' ||
        // TODO: should the second test be `isEmberArray` instead?
        !(Array.isArray(current) || 'objectAt' in current)) {
          // If the current object isn't an array, there's nothing else to do,
          // we don't watch individual properties. Break out of the loop.
          break;
        } else if (arrLength === 0) {
          // Fast path for empty arrays
          chainTags.push(tagForProperty(current, '[]'));
          break;
        }
        if (segmentEnd === -1) {
          segment = path.slice(lastSegmentEnd);
        } else {
          // Deprecated, remove once we turn the deprecation into an assertion
          segment = path.slice(lastSegmentEnd, segmentEnd);
        } // Push the tags for each item's property

        for (var i = 0; i < arrLength; i++) {
          var item = objectAt(current, i);
          if (item) {
            (true && !(typeof item === 'object') && (0, _debug.assert)("When using @each to observe the array `" + current.toString() + "`, the items in the array must be objects", typeof item === 'object'));
            chainTags.push(tagForProperty(item, segment, true));
            currentMeta = (0, _meta2.peekMeta)(item);
            descriptor = currentMeta !== null ? currentMeta.peekDescriptors(segment) : undefined; // If the key is an alias, we need to bootstrap it

            if (descriptor !== undefined && typeof descriptor.altKey === 'string') {
              // tslint:disable-next-line: no-unused-expression
              item[segment];
            }
          }
        } // Push the tag for the array length itself

        chainTags.push(tagForProperty(current, '[]', true, currentTagMeta));
        break;
      }
      var propertyTag = tagForProperty(current, segment, true, currentTagMeta);
      descriptor = currentMeta !== null ? currentMeta.peekDescriptors(segment) : undefined;
      chainTags.push(propertyTag); // If we're at the end of the path, processing the last segment, and it's
      // not an alias, we should _not_ get the last value, since we already have
      // its tag. There's no reason to access it and do more work.

      if (segmentEnd === pathLength) {
        // If the key was an alias, we should always get the next value in order to
        // bootstrap the alias. This is because aliases, unlike other CPs, should
        // always be in sync with the aliased value.
        if (CHAIN_PASS_THROUGH.has(descriptor)) {
          // tslint:disable-next-line: no-unused-expression
          current[segment];
        }
        break;
      }
      if (descriptor === undefined) {
        // If the descriptor is undefined, then its a normal property, so we should
        // lookup the value to chain off of like normal.
        if (!(segment in current) && typeof current.unknownProperty === 'function') {
          current = current.unknownProperty(segment);
        } else {
          current = current[segment];
        }
      } else if (CHAIN_PASS_THROUGH.has(descriptor)) {
        current = current[segment];
      } else {
        // If the descriptor is defined, then its a normal CP (not an alias, which
        // would have been handled earlier). We get the last revision to check if
        // the CP is still valid, and if so we use the cached value. If not, then
        // we create a lazy chain lookup, and the next time the CP is calculated,
        // it will update that lazy chain.
        var instanceMeta = currentMeta.source === current ? currentMeta : (0, _meta2.meta)(current);
        var lastRevision = instanceMeta.revisionFor(segment);
        if (lastRevision !== undefined && (0, _validator.validateTag)(propertyTag, lastRevision)) {
          current = instanceMeta.valueFor(segment);
        } else {
          // use metaFor here to ensure we have the meta for the instance
          var lazyChains = instanceMeta.writableLazyChainsFor(segment);
          var rest = path.substr(segmentEnd + 1);
          var placeholderTag = (0, _validator.createUpdatableTag)();
          lazyChains.push([placeholderTag, rest]);
          chainTags.push(placeholderTag);
          break;
        }
      }
      if (!(0, _utils.isObject)(current)) {
        // we've hit the end of the chain for now, break out
        break;
      }
      currentTagMeta = (0, _validator.tagMetaFor)(current);
      currentMeta = (0, _meta2.peekMeta)(current);
    }
    return chainTags;
  }
  function isElementDescriptor(args) {
    var maybeTarget = args[0],
      maybeKey = args[1],
      maybeDesc = args[2];
    return (
      // Ensure we have the right number of args
      args.length === 3 && (
      // Make sure the target is a class or object (prototype)
      typeof maybeTarget === 'function' || typeof maybeTarget === 'object' && maybeTarget !== null) &&
      // Make sure the key is a string
      typeof maybeKey === 'string' && (
      // Make sure the descriptor is the right shape
      typeof maybeDesc === 'object' && maybeDesc !== null || maybeDesc === undefined)
    );
  }
  function nativeDescDecorator(propertyDesc) {
    var decorator = function decorator() {
      return propertyDesc;
    };
    setClassicDecorator(decorator);
    return decorator;
  }
  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */
  var ComputedDescriptor = /*#__PURE__*/function () {
    function ComputedDescriptor() {
      this.enumerable = true;
      this.configurable = true;
      this._dependentKeys = undefined;
      this._meta = undefined;
    }
    var _proto = ComputedDescriptor.prototype;
    _proto.setup = function setup(_obj, keyName, _propertyDesc, meta$$1) {
      meta$$1.writeDescriptors(keyName, this);
    };
    _proto.teardown = function teardown(_obj, keyName, meta$$1) {
      meta$$1.removeDescriptors(keyName);
    };
    return ComputedDescriptor;
  }();
  var COMPUTED_GETTERS;
  if (true /* DEBUG */) {
    COMPUTED_GETTERS = new _util._WeakSet();
  }
  function DESCRIPTOR_GETTER_FUNCTION(name, descriptor) {
    function getter() {
      return descriptor.get(this, name);
    }
    if (true /* DEBUG */) {
      COMPUTED_GETTERS.add(getter);
    }
    return getter;
  }
  function DESCRIPTOR_SETTER_FUNCTION(name, descriptor) {
    var set = function CPSETTER_FUNCTION(value) {
      return descriptor.set(this, name, value);
    };
    COMPUTED_SETTERS.add(set);
    return set;
  }
  var COMPUTED_SETTERS = new _util._WeakSet();
  function makeComputedDecorator(desc, DecoratorClass) {
    var decorator = function COMPUTED_DECORATOR(target, key, propertyDesc, maybeMeta, isClassicDecorator) {
      (true && !(isClassicDecorator || !propertyDesc || !propertyDesc.get || !COMPUTED_GETTERS.has(propertyDesc.get)) && (0, _debug.assert)("Only one computed property decorator can be applied to a class field or accessor, but '" + key + "' was decorated twice. You may have added the decorator to both a getter and setter, which is unnecessary.", isClassicDecorator || !propertyDesc || !propertyDesc.get || !COMPUTED_GETTERS.has(propertyDesc.get)));
      var meta$$1 = arguments.length === 3 ? (0, _meta2.meta)(target) : maybeMeta;
      desc.setup(target, key, propertyDesc, meta$$1);
      var computedDesc = {
        enumerable: desc.enumerable,
        configurable: desc.configurable,
        get: DESCRIPTOR_GETTER_FUNCTION(key, desc),
        set: DESCRIPTOR_SETTER_FUNCTION(key, desc)
      };
      return computedDesc;
    };
    setClassicDecorator(decorator, desc);
    Object.setPrototypeOf(decorator, DecoratorClass.prototype);
    return decorator;
  } /////////////

  var DECORATOR_DESCRIPTOR_MAP = new WeakMap();
  /**
    Returns the CP descriptor associated with `obj` and `keyName`, if any.
  
    @method descriptorForProperty
    @param {Object} obj the object to check
    @param {String} keyName the key to check
    @return {Descriptor}
    @private
  */

  function descriptorForProperty(obj, keyName, _meta) {
    (true && !(obj !== null) && (0, _debug.assert)('Cannot call `descriptorForProperty` on null', obj !== null));
    (true && !(obj !== undefined) && (0, _debug.assert)('Cannot call `descriptorForProperty` on undefined', obj !== undefined));
    (true && !(typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call `descriptorForProperty` on " + typeof obj, typeof obj === 'object' || typeof obj === 'function'));
    var meta$$1 = _meta === undefined ? (0, _meta2.peekMeta)(obj) : _meta;
    if (meta$$1 !== null) {
      return meta$$1.peekDescriptors(keyName);
    }
  }
  function descriptorForDecorator(dec) {
    return DECORATOR_DESCRIPTOR_MAP.get(dec);
  }
  /**
    Check whether a value is a decorator
  
    @method isClassicDecorator
    @param {any} possibleDesc the value to check
    @return {boolean}
    @private
  */

  function isClassicDecorator(dec) {
    return typeof dec === 'function' && DECORATOR_DESCRIPTOR_MAP.has(dec);
  }
  /**
    Set a value as a decorator
  
    @method setClassicDecorator
    @param {function} decorator the value to mark as a decorator
    @private
  */

  function setClassicDecorator(dec, value) {
    if (value === void 0) {
      value = true;
    }
    DECORATOR_DESCRIPTOR_MAP.set(dec, value);
  }

  /**
  @module @ember/object
  */

  var END_WITH_EACH_REGEX = /\.@each$/;
  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    import { expandProperties } from '@ember/object/computed';
  
    function echo(arg){ console.log(arg); }
  
    expandProperties('foo.bar', echo);              //=> 'foo.bar'
    expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @static
    @for @ember/object/computed
    @public
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */

  function expandProperties(pattern, callback) {
    (true && !(typeof pattern === 'string') && (0, _debug.assert)("A computed property key must be a string, you passed " + typeof pattern + " " + pattern, typeof pattern === 'string'));
    (true && !(pattern.indexOf(' ') === -1) && (0, _debug.assert)('Brace expanded properties cannot contain spaces, e.g. "user.{firstName, lastName}" should be "user.{firstName,lastName}"', pattern.indexOf(' ') === -1)); // regex to look for double open, double close, or unclosed braces
    (true && !(pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null) && (0, _debug.assert)("Brace expanded properties have to be balanced and cannot be nested, pattern: " + pattern, pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null));
    var start = pattern.indexOf('{');
    if (start < 0) {
      callback(pattern.replace(END_WITH_EACH_REGEX, '.[]'));
    } else {
      dive('', pattern, start, callback);
    }
  }
  function dive(prefix, pattern, start, callback) {
    var end = pattern.indexOf('}'),
      i = 0,
      newStart,
      arrayLength;
    var tempArr = pattern.substring(start + 1, end).split(',');
    var after = pattern.substring(end + 1);
    prefix = prefix + pattern.substring(0, start);
    arrayLength = tempArr.length;
    while (i < arrayLength) {
      newStart = after.indexOf('{');
      if (newStart < 0) {
        callback((prefix + tempArr[i++] + after).replace(END_WITH_EACH_REGEX, '.[]'));
      } else {
        dive(prefix + tempArr[i++], after, newStart, callback);
      }
    }
  }

  /**
  @module @ember/object
  */
  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    import { defineProperty, computed } from '@ember/object';
  
    // ES5 compatible mode
    defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    defineProperty(contact, 'fullName', computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @public
    @method defineProperty
    @static
    @for @ember/object
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */

  function defineProperty(obj, keyName, desc, data, _meta) {
    var meta$$1 = _meta === undefined ? (0, _meta2.meta)(obj) : _meta;
    var previousDesc = descriptorForProperty(obj, keyName, meta$$1);
    var wasDescriptor = previousDesc !== undefined;
    if (wasDescriptor) {
      previousDesc.teardown(obj, keyName, meta$$1);
    }
    if (isClassicDecorator(desc)) {
      defineDecorator(obj, keyName, desc, meta$$1);
    } else if (desc === null || desc === undefined) {
      defineValue(obj, keyName, data, wasDescriptor, true);
    } else {
      // fallback to ES5
      Object.defineProperty(obj, keyName, desc);
    } // if key is being watched, override chains that
    // were initialized with the prototype

    if (!meta$$1.isPrototypeMeta(obj)) {
      revalidateObservers(obj);
    }
  }
  function defineDecorator(obj, keyName, desc, meta$$1) {
    var propertyDesc;
    if (true /* DEBUG */) {
      propertyDesc = desc(obj, keyName, undefined, meta$$1, true);
    } else {
      propertyDesc = desc(obj, keyName, undefined, meta$$1);
    }
    Object.defineProperty(obj, keyName, propertyDesc); // pass the decorator function forward for backwards compat

    return desc;
  }
  function defineValue(obj, keyName, value, wasDescriptor, enumerable) {
    if (enumerable === void 0) {
      enumerable = true;
    }
    if (wasDescriptor === true || enumerable === false) {
      Object.defineProperty(obj, keyName, {
        configurable: true,
        enumerable: enumerable,
        writable: true,
        value: value
      });
    } else {
      if (true /* DEBUG */) {
        (0, _utils.setWithMandatorySetter)(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
    }
    return value;
  }
  var firstDotIndexCache = new _utils.Cache(1000, function (key) {
    return key.indexOf('.');
  });
  function isPath(path) {
    return typeof path === 'string' && firstDotIndexCache.get(path) !== -1;
  }

  /**
  @module @ember/object
  */
  var PROXY_CONTENT = (0, _utils.symbol)('PROXY_CONTENT');
  _exports.PROXY_CONTENT = PROXY_CONTENT;
  var getPossibleMandatoryProxyValue;
  if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY) {
    getPossibleMandatoryProxyValue = function getPossibleMandatoryProxyValue(obj, keyName) {
      var content = obj[PROXY_CONTENT];
      if (content === undefined) {
        return obj[keyName];
      } else {
        /* global Reflect */
        return Reflect.get(content, keyName, obj);
      }
    };
  } // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    ```javascript
    import { get } from '@ember/object';
    get(obj, "name");
    ```
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */

  function _get3(obj, keyName) {
    (true && !(arguments.length === 2) && (0, _debug.assert)("Get must be called with two arguments; an object and a property key", arguments.length === 2));
    (true && !(obj !== undefined && obj !== null) && (0, _debug.assert)("Cannot call get with '" + keyName + "' on an undefined object.", obj !== undefined && obj !== null));
    (true && !(typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)) && (0, _debug.assert)("The key provided to get must be a string or number, you passed " + keyName, typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)));
    (true && !(typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0) && (0, _debug.assert)("'this' in paths is not supported", typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0));
    return isPath(keyName) ? _getPath(obj, keyName) : _getProp(obj, keyName);
  }
  function _getProp(obj, keyName) {
    var type = typeof obj;
    var isObject$$1 = type === 'object';
    var isFunction = type === 'function';
    var isObjectLike = isObject$$1 || isFunction;
    var value;
    if (isObjectLike) {
      if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY) {
        value = getPossibleMandatoryProxyValue(obj, keyName);
      } else {
        value = obj[keyName];
      }
      if (value === undefined && isObject$$1 && !(keyName in obj) && typeof obj.unknownProperty === 'function') {
        if (true /* DEBUG */) {
          (0, _validator.deprecateMutationsInTrackingTransaction)(function () {
            value = obj.unknownProperty(keyName);
          });
        } else {
          value = obj.unknownProperty(keyName);
        }
      }
      if ((0, _validator.isTracking)()) {
        (0, _validator.consumeTag)((0, _validator.tagFor)(obj, keyName));
        if (Array.isArray(value) || (0, _utils.isEmberArray)(value)) {
          // Add the tag of the returned value if it is an array, since arrays
          // should always cause updates if they are consumed and then changed
          (0, _validator.consumeTag)((0, _validator.tagFor)(value, '[]'));
        }
      }
    } else {
      value = obj[keyName];
    }
    return value;
  }
  function _getPath(root, path) {
    var obj = root;
    var parts = typeof path === 'string' ? path.split('.') : path;
    for (var i = 0; i < parts.length; i++) {
      if (obj === undefined || obj === null || obj.isDestroyed) {
        return undefined;
      }
      obj = _getProp(obj, parts[i]);
    }
    return obj;
  }
  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    import { getWithDefault } from '@ember/object';
    getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
    @deprecated
  */

  function getWithDefault(root, key, defaultValue) {
    (true && !(false) && (0, _debug.deprecate)('Using getWithDefault has been deprecated. Instead, consider using Ember get and explicitly checking for undefined.', false, {
      id: 'ember-metal.get-with-default',
      until: '4.0.0',
      url: 'https://deprecations.emberjs.com/v3.x#toc_ember-metal-get-with-default',
      for: 'ember-source',
      since: {
        enabled: '3.21.0'
      }
    }));
    var value = _get3(root, key);
    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }
  _getProp('foo', 'a');
  _getProp('foo', 1);
  _getProp({}, 'a');
  _getProp({}, 1);
  _getProp({
    unkonwnProperty: function unkonwnProperty() {}
  }, 'a');
  _getProp({
    unkonwnProperty: function unkonwnProperty() {}
  }, 1);
  _get3({}, 'foo');
  _get3({}, 'foo.bar');
  var fakeProxy = {};
  (0, _utils.setProxy)(fakeProxy);
  (0, _validator.track)(function () {
    return _getProp({}, 'a');
  });
  (0, _validator.track)(function () {
    return _getProp({}, 1);
  });
  (0, _validator.track)(function () {
    return _getProp({
      a: []
    }, 'a');
  });
  (0, _validator.track)(function () {
    return _getProp({
      a: fakeProxy
    }, 'a');
  });

  /**
   @module @ember/object
  */

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change.
    If the specified property is not defined on the object and the object
    implements the `setUnknownProperty` method, then instead of setting the
    value of the property on the object, its `setUnknownProperty` handler
    will be invoked with the two parameters `keyName` and `value`.
  
    ```javascript
    import { set } from '@ember/object';
    set(obj, "name", value);
    ```
  
    @method set
    @static
    @for @ember/object
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */

  function _set2(obj, keyName, value, tolerant) {
    (true && !(arguments.length === 3 || arguments.length === 4) && (0, _debug.assert)("Set must be called with three or four arguments; an object, a property key, a value and tolerant true/false", arguments.length === 3 || arguments.length === 4));
    (true && !(obj && typeof obj === 'object' || typeof obj === 'function') && (0, _debug.assert)("Cannot call set with '" + keyName + "' on an undefined object.", obj && typeof obj === 'object' || typeof obj === 'function'));
    (true && !(typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)) && (0, _debug.assert)("The key provided to set must be a string or number, you passed " + keyName, typeof keyName === 'string' || typeof keyName === 'number' && !isNaN(keyName)));
    (true && !(typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0) && (0, _debug.assert)("'this' in paths is not supported", typeof keyName !== 'string' || keyName.lastIndexOf('this.', 0) !== 0));
    if (obj.isDestroyed) {
      (true && !(tolerant) && (0, _debug.assert)("calling set on destroyed object: " + (0, _utils.toString)(obj) + "." + keyName + " = " + (0, _utils.toString)(value), tolerant));
      return value;
    }
    if (isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }
    var descriptor = (0, _utils.lookupDescriptor)(obj, keyName);
    if (descriptor !== null && COMPUTED_SETTERS.has(descriptor.set)) {
      obj[keyName] = value;
      return value;
    }
    var currentValue;
    if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY) {
      currentValue = getPossibleMandatoryProxyValue(obj, keyName);
    } else {
      currentValue = obj[keyName];
    }
    if (currentValue === undefined && 'object' === typeof obj && !(keyName in obj) && typeof obj.setUnknownProperty === 'function') {
      /* unknown property */
      obj.setUnknownProperty(keyName, value);
    } else {
      if (true /* DEBUG */) {
        (0, _utils.setWithMandatorySetter)(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
      if (currentValue !== value) {
        notifyPropertyChange(obj, keyName);
      }
    }
    return value;
  }
  function setPath(root, path, value, tolerant) {
    var parts = path.split('.');
    var keyName = parts.pop();
    (true && !(keyName.trim().length > 0) && (0, _debug.assert)('Property set failed: You passed an empty path', keyName.trim().length > 0));
    var newRoot = _getPath(root, parts);
    if (newRoot !== null && newRoot !== undefined) {
      return _set2(newRoot, keyName, value);
    } else if (!tolerant) {
      throw new _error.default("Property set failed: object in path \"" + parts.join('.') + "\" could not be found.");
    }
  }
  /**
    Error-tolerant form of `set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    ```javascript
    import { trySet } from '@ember/object';
  
    let obj = { name: "Zoey" };
    trySet(obj, "contacts.twitter", "@emberjs");
    ```
  
    @method trySet
    @static
    @for @ember/object
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */

  function trySet(root, path, value) {
    return _set2(root, path, value, true);
  }

  /**
  @module @ember/object
  */

  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;
  function noop() {}
  /**
    `@computed` is a decorator that turns a JavaScript getter and setter into a
    computed property, which is a _cached, trackable value_. By default the getter
    will only be called once and the result will be cached. You can specify
    various properties that your computed property depends on. This will force the
    cached result to be cleared if the dependencies are modified, and lazily recomputed the next time something asks for it.
  
    In the following example we decorate a getter - `fullName` -  by calling
    `computed` with the property dependencies (`firstName` and `lastName`) as
    arguments. The `fullName` getter will be called once (regardless of how many
    times it is accessed) as long as its dependencies do not change. Once
    `firstName` or `lastName` are updated any future calls to `fullName` will
    incorporate the new values, and any watchers of the value such as templates
    will be updated:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName')
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
    });
  
    let tom = new Person('Tom', 'Dale');
  
    tom.fullName; // 'Tom Dale'
    ```
  
    You can also provide a setter, which will be used when updating the computed
    property. Ember's `set` function must be used to update the property
    since it will also notify observers of the property:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName')
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
  
      set fullName(value) {
        let [firstName, lastName] = value.split(' ');
  
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
    });
  
    let person = new Person();
  
    set(person, 'fullName', 'Peter Wagenet');
    person.firstName; // 'Peter'
    person.lastName;  // 'Wagenet'
    ```
  
    You can also pass a getter function or object with `get` and `set` functions
    as the last argument to the computed decorator. This allows you to define
    computed property _macros_:
  
    ```js
    import { computed } from '@ember/object';
  
    function join(...keys) {
      return computed(...keys, function() {
        return keys.map(key => this[key]).join(' ');
      });
    }
  
    class Person {
      @join('firstName', 'lastName')
      fullName;
    }
    ```
  
    Note that when defined this way, getters and setters receive the _key_ of the
    property they are decorating as the first argument. Setters receive the value
    they are setting to as the second argument instead. Additionally, setters must
    _return_ the value that should be cached:
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    function fullNameMacro(firstNameKey, lastNameKey) {
      return computed(firstNameKey, lastNameKey, {
        get() {
          return `${this[firstNameKey]} ${this[lastNameKey]}`;
        }
  
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          set(this, firstNameKey, firstName);
          set(this, lastNameKey, lastName);
  
          return value;
        }
      });
    }
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @fullNameMacro('firstName', 'lastName') fullName;
    });
  
    let person = new Person();
  
    set(person, 'fullName', 'Peter Wagenet');
    person.firstName; // 'Peter'
    person.lastName;  // 'Wagenet'
    ```
  
    Computed properties can also be used in classic classes. To do this, we
    provide the getter and setter as the last argument like we would for a macro,
    and we assign it to a property on the class definition. This is an _anonymous_
    computed macro:
  
    ```javascript
    import EmberObject, { computed, set } from '@ember/object';
  
    let Person = EmberObject.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: computed('firstName', 'lastName', {
        get() {
          return `${this.firstName} ${this.lastName}`;
        }
  
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          set(this, 'firstName', firstName);
          set(this, 'lastName', lastName);
  
          return value;
        }
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can overwrite computed property without setters with a normal property (no
    longer computed) that won't change if dependencies change. You can also mark
    computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    import { computed, set } from '@ember/object';
  
    class Person {
      constructor(firstName, lastName) {
        set(this, 'firstName', firstName);
        set(this, 'lastName', lastName);
      }
  
      @computed('firstName', 'lastName').readOnly()
      get fullName() {
        return `${this.firstName} ${this.lastName}`;
      }
    });
  
    let person = new Person();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [Decorators RFC](https://github.com/emberjs/rfcs/blob/master/text/0408-decorators.md)
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](https://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @public
  */
  var ComputedProperty = /*#__PURE__*/function (_ComputedDescriptor) {
    (0, _emberBabel.inheritsLoose)(ComputedProperty, _ComputedDescriptor);
    function ComputedProperty(args) {
      var _this;
      _this = _ComputedDescriptor.call(this) || this;
      _this._volatile = false;
      _this._readOnly = false;
      _this._hasConfig = false;
      _this._getter = undefined;
      _this._setter = undefined;
      var maybeConfig = args[args.length - 1];
      if (typeof maybeConfig === 'function' || maybeConfig !== null && typeof maybeConfig === 'object') {
        _this._hasConfig = true;
        var config = args.pop();
        if (typeof config === 'function') {
          (true && !(!isClassicDecorator(config)) && (0, _debug.assert)("You attempted to pass a computed property instance to computed(). Computed property instances are decorator functions, and cannot be passed to computed() because they cannot be turned into decorators twice", !isClassicDecorator(config)));
          _this._getter = config;
        } else {
          var objectConfig = config;
          (true && !(typeof objectConfig === 'object' && !Array.isArray(objectConfig)) && (0, _debug.assert)('computed expects a function or an object as last argument.', typeof objectConfig === 'object' && !Array.isArray(objectConfig)));
          (true && !(Object.keys(objectConfig).every(function (key) {
            return key === 'get' || key === 'set';
          })) && (0, _debug.assert)('Config object passed to computed can only contain `get` and `set` keys.', Object.keys(objectConfig).every(function (key) {
            return key === 'get' || key === 'set';
          })));
          (true && !(Boolean(objectConfig.get) || Boolean(objectConfig.set)) && (0, _debug.assert)('Computed properties must receive a getter or a setter, you passed none.', Boolean(objectConfig.get) || Boolean(objectConfig.set)));
          _this._getter = objectConfig.get || noop;
          _this._setter = objectConfig.set;
        }
      }
      if (args.length > 0) {
        var _this2;
        (_this2 = _this)._property.apply(_this2, args);
      }
      return _this;
    }
    var _proto2 = ComputedProperty.prototype;
    _proto2.setup = function setup(obj, keyName, propertyDesc, meta$$1) {
      _ComputedDescriptor.prototype.setup.call(this, obj, keyName, propertyDesc, meta$$1);
      (true && !(!(propertyDesc && typeof propertyDesc.value === 'function')) && (0, _debug.assert)("@computed can only be used on accessors or fields, attempted to use it with " + keyName + " but that was a method. Try converting it to a getter (e.g. `get " + keyName + "() {}`)", !(propertyDesc && typeof propertyDesc.value === 'function')));
      (true && !(!propertyDesc || !propertyDesc.initializer) && (0, _debug.assert)("@computed can only be used on empty fields. " + keyName + " has an initial value (e.g. `" + keyName + " = someValue`)", !propertyDesc || !propertyDesc.initializer));
      (true && !(!(this._hasConfig && propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function'))) && (0, _debug.assert)("Attempted to apply a computed property that already has a getter/setter to a " + keyName + ", but it is a method or an accessor. If you passed @computed a function or getter/setter (e.g. `@computed({ get() { ... } })`), then it must be applied to a field", !(this._hasConfig && propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function'))));
      if (this._hasConfig === false) {
        (true && !(propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function')) && (0, _debug.assert)("Attempted to use @computed on " + keyName + ", but it did not have a getter or a setter. You must either pass a get a function or getter/setter to @computed directly (e.g. `@computed({ get() { ... } })`) or apply @computed directly to a getter/setter", propertyDesc && (typeof propertyDesc.get === 'function' || typeof propertyDesc.set === 'function')));
        var _get2 = propertyDesc.get,
          set$$1 = propertyDesc.set;
        if (_get2 !== undefined) {
          this._getter = _get2;
        }
        if (set$$1 !== undefined) {
          this._setter = function setterWrapper(_key, value) {
            var ret = set$$1.call(this, value);
            if (_get2 !== undefined) {
              return typeof ret === 'undefined' ? _get2.call(this) : ret;
            }
            return ret;
          };
        }
      }
    };
    _proto2._property = function _property() {
      var args = [];
      function addArg(property) {
        (true && (0, _debug.warn)("Dependent keys containing @each only work one level deep. " + ("You used the key \"" + property + "\" which is invalid. ") + "Please create an intermediary computed property.", DEEP_EACH_REGEX.test(property) === false, {
          id: 'ember-metal.computed-deep-each'
        }));
        args.push(property);
      }
      for (var i = 0; i < arguments.length; i++) {
        expandProperties(i < 0 || arguments.length <= i ? undefined : arguments[i], addArg);
      }
      this._dependentKeys = args;
    };
    _proto2.get = function get(obj, keyName) {
      if (this._volatile) {
        return this._getter.call(obj, keyName);
      }
      var meta$$1 = (0, _meta2.meta)(obj);
      var tagMeta = (0, _validator.tagMetaFor)(obj);
      var propertyTag = (0, _validator.tagFor)(obj, keyName, tagMeta);
      var ret;
      var revision = meta$$1.revisionFor(keyName);
      if (revision !== undefined && (0, _validator.validateTag)(propertyTag, revision)) {
        ret = meta$$1.valueFor(keyName);
      } else {
        // For backwards compatibility, we only throw if the CP has any dependencies. CPs without dependencies
        // should be allowed, even after the object has been destroyed, which is why we check _dependentKeys.
        (true && !(this._dependentKeys === undefined || !(0, _runtime.isDestroyed)(obj)) && (0, _debug.assert)("Attempted to access the computed " + obj + "." + keyName + " on a destroyed object, which is not allowed", this._dependentKeys === undefined || !(0, _runtime.isDestroyed)(obj)));
        var _getter = this._getter,
          _dependentKeys = this._dependentKeys; // Create a tracker that absorbs any trackable actions inside the CP

        (0, _validator.untrack)(function () {
          ret = _getter.call(obj, keyName);
        });
        if (_dependentKeys !== undefined) {
          (0, _validator.updateTag)(propertyTag, getChainTagsForKeys(obj, _dependentKeys, tagMeta, meta$$1));
          if (true /* DEBUG */) {
            _validator.ALLOW_CYCLES.set(propertyTag, true);
          }
        }
        meta$$1.setValueFor(keyName, ret);
        meta$$1.setRevisionFor(keyName, (0, _validator.valueForTag)(propertyTag));
        finishLazyChains(meta$$1, keyName, ret);
      }
      (0, _validator.consumeTag)(propertyTag); // Add the tag of the returned value if it is an array, since arrays
      // should always cause updates if they are consumed and then changed

      if (Array.isArray(ret)) {
        (0, _validator.consumeTag)((0, _validator.tagFor)(ret, '[]'));
      }
      return ret;
    };
    _proto2.set = function set(obj, keyName, value) {
      if (this._readOnly) {
        this._throwReadOnlyError(obj, keyName);
      }
      if (!this._setter) {
        return this.clobberSet(obj, keyName, value);
      }
      if (this._volatile) {
        return this.volatileSet(obj, keyName, value);
      }
      var meta$$1 = (0, _meta2.meta)(obj); // ensure two way binding works when the component has defined a computed
      // property with both a setter and dependent keys, in that scenario without
      // the sync observer added below the caller's value will never be updated
      //
      // See GH#18147 / GH#19028 for details.

      if (
      // ensure that we only run this once, while the component is being instantiated
      meta$$1.isInitializing() && this._dependentKeys !== undefined && this._dependentKeys.length > 0 &&
      // These two properties are set on Ember.Component
      typeof obj[PROPERTY_DID_CHANGE] === 'function' && obj.isComponent) {
        addObserver(obj, keyName, function () {
          obj[PROPERTY_DID_CHANGE](keyName);
        }, undefined, true);
      }
      var ret;
      try {
        beginPropertyChanges();
        ret = this._set(obj, keyName, value, meta$$1);
        finishLazyChains(meta$$1, keyName, ret);
        var tagMeta = (0, _validator.tagMetaFor)(obj);
        var propertyTag = (0, _validator.tagFor)(obj, keyName, tagMeta);
        var _dependentKeys = this._dependentKeys;
        if (_dependentKeys !== undefined) {
          (0, _validator.updateTag)(propertyTag, getChainTagsForKeys(obj, _dependentKeys, tagMeta, meta$$1));
          if (true /* DEBUG */) {
            _validator.ALLOW_CYCLES.set(propertyTag, true);
          }
        }
        meta$$1.setRevisionFor(keyName, (0, _validator.valueForTag)(propertyTag));
      } finally {
        endPropertyChanges();
      }
      return ret;
    };
    _proto2._throwReadOnlyError = function _throwReadOnlyError(obj, keyName) {
      throw new _error.default("Cannot set read-only property \"" + keyName + "\" on object: " + (0, _utils.inspect)(obj));
    };
    _proto2.clobberSet = function clobberSet(obj, keyName, value) {
      (true && !(false) && (0, _debug.deprecate)("The " + (0, _utils.toString)(obj) + "#" + keyName + " computed property was just overridden. This removes the computed property and replaces it with a plain value, and has been deprecated. If you want this behavior, consider defining a setter which does it manually.", false, {
        id: 'computed-property.override',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-override',
        for: 'ember-source',
        since: {
          enabled: '3.9.0-beta.1'
        }
      }));
      var cachedValue = (0, _meta2.meta)(obj).valueFor(keyName);
      defineProperty(obj, keyName, null, cachedValue);
      _set2(obj, keyName, value);
      return value;
    };
    _proto2.volatileSet = function volatileSet(obj, keyName, value) {
      return this._setter.call(obj, keyName, value);
    };
    _proto2._set = function _set(obj, keyName, value, meta$$1) {
      var hadCachedValue = meta$$1.revisionFor(keyName) !== undefined;
      var cachedValue = meta$$1.valueFor(keyName);
      var ret;
      var _setter = this._setter;
      setObserverSuspended(obj, keyName, true);
      try {
        ret = _setter.call(obj, keyName, value, cachedValue);
      } finally {
        setObserverSuspended(obj, keyName, false);
      } // allows setter to return the same value that is cached already

      if (hadCachedValue && cachedValue === ret) {
        return ret;
      }
      meta$$1.setValueFor(keyName, ret);
      notifyPropertyChange(obj, keyName, meta$$1, value);
      return ret;
    }
    /* called before property is overridden */;
    _proto2.teardown = function teardown(obj, keyName, meta$$1) {
      if (!this._volatile) {
        if (meta$$1.revisionFor(keyName) !== undefined) {
          meta$$1.setRevisionFor(keyName, undefined);
          meta$$1.setValueFor(keyName, undefined);
        }
      }
      _ComputedDescriptor.prototype.teardown.call(this, obj, keyName, meta$$1);
    };
    return ComputedProperty;
  }(ComputedDescriptor);
  _exports.ComputedProperty = ComputedProperty;
  var AutoComputedProperty = /*#__PURE__*/function (_ComputedProperty) {
    (0, _emberBabel.inheritsLoose)(AutoComputedProperty, _ComputedProperty);
    function AutoComputedProperty() {
      return _ComputedProperty.apply(this, arguments) || this;
    }
    var _proto3 = AutoComputedProperty.prototype;
    _proto3.get = function get(obj, keyName) {
      if (this._volatile) {
        return this._getter.call(obj, keyName);
      }
      var meta$$1 = (0, _meta2.meta)(obj);
      var tagMeta = (0, _validator.tagMetaFor)(obj);
      var propertyTag = (0, _validator.tagFor)(obj, keyName, tagMeta);
      var ret;
      var revision = meta$$1.revisionFor(keyName);
      if (revision !== undefined && (0, _validator.validateTag)(propertyTag, revision)) {
        ret = meta$$1.valueFor(keyName);
      } else {
        (true && !(!(0, _runtime.isDestroyed)(obj)) && (0, _debug.assert)("Attempted to access the computed " + obj + "." + keyName + " on a destroyed object, which is not allowed", !(0, _runtime.isDestroyed)(obj)));
        var _getter = this._getter; // Create a tracker that absorbs any trackable actions inside the CP

        var tag = (0, _validator.track)(function () {
          ret = _getter.call(obj, keyName);
        });
        (0, _validator.updateTag)(propertyTag, tag);
        meta$$1.setValueFor(keyName, ret);
        meta$$1.setRevisionFor(keyName, (0, _validator.valueForTag)(propertyTag));
        finishLazyChains(meta$$1, keyName, ret);
      }
      (0, _validator.consumeTag)(propertyTag); // Add the tag of the returned value if it is an array, since arrays
      // should always cause updates if they are consumed and then changed

      if (Array.isArray(ret)) {
        (0, _validator.consumeTag)((0, _validator.tagFor)(ret, '[]', tagMeta));
      }
      return ret;
    };
    return AutoComputedProperty;
  }(ComputedProperty); // TODO: This class can be svelted once `meta` has been deprecated
  var ComputedDecoratorImpl = /*#__PURE__*/function (_Function) {
    (0, _emberBabel.inheritsLoose)(ComputedDecoratorImpl, _Function);
    function ComputedDecoratorImpl() {
      return _Function.apply(this, arguments) || this;
    }
    var _proto4 = ComputedDecoratorImpl.prototype;
    /**
      Call on a computed property to set it into read-only mode. When in this
      mode the computed property will throw an error when set.
         Example:
         ```javascript
      import { computed, set } from '@ember/object';
         class Person {
        @computed().readOnly()
        get guid() {
          return 'guid-guid-guid';
        }
      }
         let person = new Person();
      set(person, 'guid', 'new-guid'); // will throw an exception
      ```
         Classic Class Example:
         ```javascript
      import EmberObject, { computed } from '@ember/object';
         let Person = EmberObject.extend({
        guid: computed(function() {
          return 'guid-guid-guid';
        }).readOnly()
      });
         let person = Person.create();
      person.set('guid', 'new-guid'); // will throw an exception
      ```
         @method readOnly
      @return {ComputedProperty} this
      @chainable
      @public
    */
    _proto4.readOnly = function readOnly() {
      var desc = descriptorForDecorator(this);
      (true && !(!(desc._setter && desc._setter !== desc._getter)) && (0, _debug.assert)('Computed properties that define a setter using the new syntax cannot be read-only', !(desc._setter && desc._setter !== desc._getter)));
      desc._readOnly = true;
      return this;
    }
    /**
      Call on a computed property to set it into non-cached mode. When in this
      mode the computed property will not automatically cache the return value.
      It also does not automatically fire any change events. You must manually notify
      any changes if you want to observe this property.
         Dependency keys have no effect on volatile properties as they are for cache
      invalidation and notification when cached value is invalidated.
         Example:
         ```javascript
      import { computed } from '@ember/object';
         class CallCounter {
        _calledCount = 0;
           @computed().volatile()
        get calledCount() {
          return this._calledCount++;
        }
      }
      ```
         Classic Class Example:
         ```javascript
      import EmberObject, { computed } from '@ember/object';
         let CallCounter = EmberObject.extend({
        _calledCount: 0,
           value: computed(function() {
          return this._calledCount++;
        }).volatile()
      });
      ```
      @method volatile
      @deprecated
      @return {ComputedProperty} this
      @chainable
      @public
    */;
    _proto4.volatile = function volatile() {
      (true && !(false) && (0, _debug.deprecate)('Setting a computed property as volatile has been deprecated. Instead, consider using a native getter with native class syntax.', false, {
        id: 'computed-property.volatile',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-volatile',
        for: 'ember-source',
        since: {
          enabled: '3.9.0-beta.1'
        }
      }));
      descriptorForDecorator(this)._volatile = true;
      return this;
    }
    /**
      Sets the dependent keys on this computed property. Pass any number of
      arguments containing key paths that this computed property depends on.
         Example:
         ```javascript
      import EmberObject, { computed } from '@ember/object';
         class President {
        constructor(firstName, lastName) {
          set(this, 'firstName', firstName);
          set(this, 'lastName', lastName);
        }
           // Tell Ember that this computed property depends on firstName
        // and lastName
        @computed().property('firstName', 'lastName')
        get fullName() {
          return `${this.firstName} ${this.lastName}`;
        }
      }
         let president = new President('Barack', 'Obama');
         president.fullName; // 'Barack Obama'
      ```
         Classic Class Example:
         ```javascript
      import EmberObject, { computed } from '@ember/object';
         let President = EmberObject.extend({
        fullName: computed(function() {
          return this.get('firstName') + ' ' + this.get('lastName');
             // Tell Ember that this computed property depends on firstName
          // and lastName
        }).property('firstName', 'lastName')
      });
         let president = President.create({
        firstName: 'Barack',
        lastName: 'Obama'
      });
         president.get('fullName'); // 'Barack Obama'
      ```
         @method property
      @deprecated
      @param {String} path* zero or more property paths
      @return {ComputedProperty} this
      @chainable
      @public
    */;
    _proto4.property = function property() {
      var _descriptorForDecorat;
      (true && !(false) && (0, _debug.deprecate)('Setting dependency keys using the `.property()` modifier has been deprecated. Pass the dependency keys directly to computed as arguments instead. If you are using `.property()` on a computed property macro, consider refactoring your macro to receive additional dependent keys in its initial declaration.', false, {
        id: 'computed-property.property',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_computed-property-property',
        for: 'ember-source',
        since: {
          enabled: '3.9.0-beta.1'
        }
      }));
      (_descriptorForDecorat = descriptorForDecorator(this))._property.apply(_descriptorForDecorat, arguments);
      return this;
    }
    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For example,
      computed property functions may close over variables that are then no longer
      available for introspection. You can pass a hash of these values to a
      computed property.
         Example:
         ```javascript
      import { computed } from '@ember/object';
      import Person from 'my-app/utils/person';
         class Store {
        @computed().meta({ type: Person })
        get person() {
          let personId = this.personId;
          return Person.create({ id: personId });
        }
      }
      ```
         Classic Class Example:
         ```javascript
      import { computed } from '@ember/object';
      import Person from 'my-app/utils/person';
         const Store = EmberObject.extend({
        person: computed(function() {
          let personId = this.get('personId');
          return Person.create({ id: personId });
        }).meta({ type: Person })
      });
      ```
         The hash that you pass to the `meta()` function will be saved on the
      computed property descriptor under the `_meta` key. Ember runtime
      exposes a public API for retrieving these values from classes,
      via the `metaForProperty()` function.
         @method meta
      @param {Object} meta
      @chainable
      @public
    */;
    _proto4.meta = function meta(meta$$1) {
      var prop = descriptorForDecorator(this);
      if (arguments.length === 0) {
        return prop._meta || {};
      } else {
        prop._meta = meta$$1;
        return this;
      }
    } // TODO: Remove this when we can provide alternatives in the ecosystem to
    // addons such as ember-macro-helpers that use it.
    ;
    (0, _emberBabel.createClass)(ComputedDecoratorImpl, [{
      key: "_getter",
      get: function get() {
        return descriptorForDecorator(this)._getter;
      } // TODO: Refactor this, this is an internal API only
    }, {
      key: "enumerable",
      set: function set(value) {
        descriptorForDecorator(this).enumerable = value;
      }
    }]);
    return ComputedDecoratorImpl;
  }( /*#__PURE__*/(0, _emberBabel.wrapNativeSuper)(Function));
  function computed() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key3 = 0; _key3 < _len2; _key3++) {
      args[_key3] = arguments[_key3];
    }
    (true && !(!(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)) && (0, _debug.assert)("@computed can only be used directly as a native decorator. If you're using tracked in classic classes, add parenthesis to call it like a function: computed()", !(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)));
    if (isElementDescriptor(args)) {
      var decorator = makeComputedDecorator(new ComputedProperty([]), ComputedDecoratorImpl);
      return decorator(args[0], args[1], args[2]);
    }
    return makeComputedDecorator(new ComputedProperty(args), ComputedDecoratorImpl);
  }
  function autoComputed() {
    for (var _len3 = arguments.length, config = new Array(_len3), _key4 = 0; _key4 < _len3; _key4++) {
      config[_key4] = arguments[_key4];
    }
    return makeComputedDecorator(new AutoComputedProperty(config), ComputedDecoratorImpl);
  }
  /**
    Allows checking if a given property on an object is a computed property. For the most part,
    this doesn't matter (you would normally just access the property directly and use its value),
    but for some tooling specific scenarios (e.g. the ember-inspector) it is important to
    differentiate if a property is a computed property or a "normal" property.
  
    This will work on either a class's prototype or an instance itself.
  
    @static
    @method isComputed
    @for @ember/debug
    @private
   */

  function isComputed(obj, key) {
    return Boolean(descriptorForProperty(obj, key));
  }
  var _globalsComputed = computed.bind(null);
  _exports._globalsComputed = _globalsComputed;
  function getCachedValueFor(obj, key) {
    var meta$$1 = (0, _meta2.peekMeta)(obj);
    if (meta$$1) {
      return meta$$1.valueFor(key);
    }
  }
  function alias(altKey) {
    (true && !(!isElementDescriptor(Array.prototype.slice.call(arguments))) && (0, _debug.assert)('You attempted to use @alias as a decorator directly, but it requires a `altKey` parameter', !isElementDescriptor(Array.prototype.slice.call(arguments))));
    return makeComputedDecorator(new AliasedProperty(altKey), AliasDecoratorImpl);
  } // TODO: This class can be svelted once `meta` has been deprecated
  var AliasDecoratorImpl = /*#__PURE__*/function (_Function2) {
    (0, _emberBabel.inheritsLoose)(AliasDecoratorImpl, _Function2);
    function AliasDecoratorImpl() {
      return _Function2.apply(this, arguments) || this;
    }
    var _proto5 = AliasDecoratorImpl.prototype;
    _proto5.readOnly = function readOnly() {
      descriptorForDecorator(this).readOnly();
      return this;
    };
    _proto5.oneWay = function oneWay() {
      descriptorForDecorator(this).oneWay();
      return this;
    };
    _proto5.meta = function meta(meta$$1) {
      var prop = descriptorForDecorator(this);
      if (arguments.length === 0) {
        return prop._meta || {};
      } else {
        prop._meta = meta$$1;
      }
    };
    return AliasDecoratorImpl;
  }( /*#__PURE__*/(0, _emberBabel.wrapNativeSuper)(Function));
  var AliasedProperty = /*#__PURE__*/function (_ComputedDescriptor2) {
    (0, _emberBabel.inheritsLoose)(AliasedProperty, _ComputedDescriptor2);
    function AliasedProperty(altKey) {
      var _this3;
      _this3 = _ComputedDescriptor2.call(this) || this;
      _this3.altKey = altKey;
      return _this3;
    }
    var _proto6 = AliasedProperty.prototype;
    _proto6.setup = function setup(obj, keyName, propertyDesc, meta$$1) {
      (true && !(this.altKey !== keyName) && (0, _debug.assert)("Setting alias '" + keyName + "' on self", this.altKey !== keyName));
      _ComputedDescriptor2.prototype.setup.call(this, obj, keyName, propertyDesc, meta$$1);
      CHAIN_PASS_THROUGH.add(this);
    };
    _proto6.get = function get(obj, keyName) {
      var _this4 = this;
      var ret;
      var meta$$1 = (0, _meta2.meta)(obj);
      var tagMeta = (0, _validator.tagMetaFor)(obj);
      var propertyTag = (0, _validator.tagFor)(obj, keyName, tagMeta); // We don't use the tag since CPs are not automatic, we just want to avoid
      // anything tracking while we get the altKey

      (0, _validator.untrack)(function () {
        ret = _get3(obj, _this4.altKey);
      });
      var lastRevision = meta$$1.revisionFor(keyName);
      if (lastRevision === undefined || !(0, _validator.validateTag)(propertyTag, lastRevision)) {
        (0, _validator.updateTag)(propertyTag, getChainTagsForKey(obj, this.altKey, tagMeta, meta$$1));
        meta$$1.setRevisionFor(keyName, (0, _validator.valueForTag)(propertyTag));
        finishLazyChains(meta$$1, keyName, ret);
      }
      (0, _validator.consumeTag)(propertyTag);
      return ret;
    };
    _proto6.set = function set(obj, _keyName, value) {
      return _set2(obj, this.altKey, value);
    };
    _proto6.readOnly = function readOnly() {
      this.set = AliasedProperty_readOnlySet;
    };
    _proto6.oneWay = function oneWay() {
      this.set = AliasedProperty_oneWaySet;
    };
    return AliasedProperty;
  }(ComputedDescriptor);
  function AliasedProperty_readOnlySet(obj, keyName) {
    // eslint-disable-line no-unused-vars
    throw new _error.default("Cannot set read-only property '" + keyName + "' on object: " + (0, _utils.inspect)(obj));
  }
  function AliasedProperty_oneWaySet(obj, keyName, value) {
    defineProperty(obj, keyName, null);
    return _set2(obj, keyName, value);
  }

  /**
  @module ember
  */
  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {
      (true && !(false) && (0, _debug.deprecate)("Usage of `" + deprecatedKey + "` is deprecated, use `" + newKey + "` instead.", false, options));
    }
    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,
      set: function set(value) {
        _deprecate();
        _set2(this, newKey, value);
      },
      get: function get() {
        _deprecate();
        return _get3(this, newKey);
      }
    });
  }
  var EACH_PROXIES = new WeakMap();
  function eachProxyArrayWillChange(array, idx, removedCnt, addedCnt) {
    var eachProxy = EACH_PROXIES.get(array);
    if (eachProxy !== undefined) {
      eachProxy.arrayWillChange(array, idx, removedCnt, addedCnt);
    }
  }
  function eachProxyArrayDidChange(array, idx, removedCnt, addedCnt) {
    var eachProxy = EACH_PROXIES.get(array);
    if (eachProxy !== undefined) {
      eachProxy.arrayDidChange(array, idx, removedCnt, addedCnt);
    }
  }

  /**
   @module @ember/utils
  */

  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    isNone();              // true
    isNone(null);          // true
    isNone(undefined);     // true
    isNone('');            // false
    isNone([]);            // false
    isNone(function() {}); // false
    ```
  
    @method isNone
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  function isNone(obj) {
    return obj === null || obj === undefined;
  }

  /**
   @module @ember/utils
  */

  /**
    Verifies that a value is `null` or `undefined`, an empty string, or an empty
    array.
  
    Constrains the rules on `isNone` by returning true for empty strings and
    empty arrays.
  
    If the value is an object with a `size` property of type number, it is used
    to check emptiness.
  
    ```javascript
    isEmpty();                 // true
    isEmpty(null);             // true
    isEmpty(undefined);        // true
    isEmpty('');               // true
    isEmpty([]);               // true
    isEmpty({ size: 0});       // true
    isEmpty({});               // false
    isEmpty('Adam Hawkins');   // false
    isEmpty([0,1,2]);          // false
    isEmpty('\n\t');           // false
    isEmpty('  ');             // false
    isEmpty({ size: 1 })       // false
    isEmpty({ size: () => 0 }) // false
    ```
  
    @method isEmpty
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */

  function isEmpty(obj) {
    var none = obj === null || obj === undefined;
    if (none) {
      return none;
    }
    if (typeof obj.size === 'number') {
      return !obj.size;
    }
    var objectType = typeof obj;
    if (objectType === 'object') {
      var size = _get3(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }
    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }
    if (objectType === 'object') {
      var length = _get3(obj, 'length');
      if (typeof length === 'number') {
        return !length;
      }
    }
    return false;
  }

  /**
   @module @ember/utils
  */

  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    import { isBlank } from '@ember/utils';
  
    isBlank();                // true
    isBlank(null);            // true
    isBlank(undefined);       // true
    isBlank('');              // true
    isBlank([]);              // true
    isBlank('\n\t');          // true
    isBlank('  ');            // true
    isBlank({});              // false
    isBlank('\n\t Hello');    // false
    isBlank('Hello world');   // false
    isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */

  function isBlank(obj) {
    return isEmpty(obj) || typeof obj === 'string' && /\S/.test(obj) === false;
  }

  /**
   @module @ember/utils
  */

  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    isPresent();                // false
    isPresent(null);            // false
    isPresent(undefined);       // false
    isPresent('');              // false
    isPresent('  ');            // false
    isPresent('\n\t');          // false
    isPresent([]);              // false
    isPresent({ length: 0 });   // false
    isPresent(false);           // true
    isPresent(true);            // true
    isPresent('string');        // true
    isPresent(0);               // true
    isPresent(function() {});   // true
    isPresent({});              // true
    isPresent('\n\t Hello');    // true
    isPresent([1, 2, 3]);       // true
    ```
  
    @method isPresent
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */

  function isPresent(obj) {
    return !isBlank(obj);
  }

  /**
   @module ember
  */

  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */
  var Libraries = /*#__PURE__*/function () {
    function Libraries() {
      this._registry = [];
      this._coreLibIndex = 0;
    }
    var _proto7 = Libraries.prototype;
    _proto7._getLibraryByName = function _getLibraryByName(name) {
      var libs = this._registry;
      var count = libs.length;
      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
      return undefined;
    };
    _proto7.register = function register(name, version, isCoreLibrary) {
      var index = this._registry.length;
      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, {
          name: name,
          version: version
        });
      } else {
        (true && (0, _debug.warn)("Library \"" + name + "\" is already registered with Ember.", false, {
          id: 'ember-metal.libraries-register'
        }));
      }
    };
    _proto7.registerCoreLibrary = function registerCoreLibrary(name, version) {
      this.register(name, version, true);
    };
    _proto7.deRegister = function deRegister(name) {
      var lib = this._getLibraryByName(name);
      var index;
      if (lib) {
        index = this._registry.indexOf(lib);
        this._registry.splice(index, 1);
      }
    };
    return Libraries;
  }();
  _exports.Libraries = Libraries;
  if (true /* DEBUG */) {
    Libraries.prototype.logVersions = function () {
      var libs = this._registry;
      var nameLengths = libs.map(function (item) {
        return _get3(item, 'name.length');
      });
      var maxNameLength = Math.max.apply(null, nameLengths);
      (0, _debug.debug)('-------------------------------');
      for (var i = 0; i < libs.length; i++) {
        var lib = libs[i];
        var spaces = new Array(maxNameLength - lib.name.length + 1).join(' ');
        (0, _debug.debug)([lib.name, spaces, ' : ', lib.version].join(''));
      }
      (0, _debug.debug)('-------------------------------');
    };
  }
  var LIBRARIES = new Libraries();
  _exports.libraries = LIBRARIES;
  LIBRARIES.registerCoreLibrary('Ember', _version.default);

  /**
   @module @ember/object
  */

  /**
    To get multiple properties at once, call `getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @static
    @for @ember/object
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */

  function getProperties(obj, keys) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;
    if (arguments.length === 2 && Array.isArray(keys)) {
      i = 0;
      propertyNames = arguments[1];
    }
    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = _get3(obj, propertyNames[i]);
    }
    return ret;
  }

  /**
   @module @ember/object
  */

  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    import EmberObject from '@ember/object';
    let anObject = EmberObject.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @static
    @for @ember/object
    @param obj
    @param {Object} properties
    @return properties
    @public
  */

  function setProperties(obj, properties) {
    if (properties === null || typeof properties !== 'object') {
      return properties;
    }
    changeProperties(function () {
      var props = Object.keys(properties);
      var propertyName;
      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];
        _set2(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  }

  // move into its own package
  // it is needed by Mixin for classToString
  // maybe move it into environment

  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var searchDisabled = false;
  var flags = {
    _set: 0,
    _unprocessedNamespaces: false,
    get unprocessedNamespaces() {
      return this._unprocessedNamespaces;
    },
    set unprocessedNamespaces(v) {
      this._set++;
      this._unprocessedNamespaces = v;
    }
  };
  var unprocessedMixins = false;
  var NAMESPACES = [];
  _exports.NAMESPACES = NAMESPACES;
  var NAMESPACES_BY_ID = Object.create(null);
  _exports.NAMESPACES_BY_ID = NAMESPACES_BY_ID;
  function addNamespace(namespace) {
    flags.unprocessedNamespaces = true;
    NAMESPACES.push(namespace);
  }
  function removeNamespace(namespace) {
    var name = (0, _utils.getName)(namespace);
    delete NAMESPACES_BY_ID[name];
    NAMESPACES.splice(NAMESPACES.indexOf(namespace), 1);
    if (name in _environment.context.lookup && namespace === _environment.context.lookup[name]) {
      _environment.context.lookup[name] = undefined;
    }
  }
  function findNamespaces() {
    if (!flags.unprocessedNamespaces) {
      return;
    }
    var lookup = _environment.context.lookup;
    var keys = Object.keys(lookup);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i]; // Only process entities that start with uppercase A-Z

      if (!isUppercase(key.charCodeAt(0))) {
        continue;
      }
      var obj = tryIsNamespace(lookup, key);
      if (obj) {
        (0, _utils.setName)(obj, key);
      }
    }
  }
  function findNamespace(name) {
    if (!searchDisabled) {
      processAllNamespaces();
    }
    return NAMESPACES_BY_ID[name];
  }
  function processNamespace(namespace) {
    _processNamespace([namespace.toString()], namespace, new Set());
  }
  function processAllNamespaces() {
    var unprocessedNamespaces = flags.unprocessedNamespaces;
    if (unprocessedNamespaces) {
      findNamespaces();
      flags.unprocessedNamespaces = false;
    }
    if (unprocessedNamespaces || unprocessedMixins) {
      var namespaces = NAMESPACES;
      for (var i = 0; i < namespaces.length; i++) {
        processNamespace(namespaces[i]);
      }
      unprocessedMixins = false;
    }
  }
  function classToString() {
    var name = (0, _utils.getName)(this);
    if (name !== void 0) {
      return name;
    }
    name = calculateToString(this);
    (0, _utils.setName)(this, name);
    return name;
  }
  function isSearchDisabled() {
    return searchDisabled;
  }
  function setSearchDisabled(flag) {
    searchDisabled = Boolean(flag);
  }
  function setUnprocessedMixins() {
    unprocessedMixins = true;
  }
  function _processNamespace(paths, root, seen) {
    var idx = paths.length;
    var id = paths.join('.');
    NAMESPACES_BY_ID[id] = root;
    (0, _utils.setName)(root, id); // Loop over all of the keys in the namespace, looking for classes

    for (var key in root) {
      if (!hasOwnProperty.call(root, key)) {
        continue;
      }
      var obj = root[key]; // If we are processing the `Ember` namespace, for example, the
      // `paths` will start with `["Ember"]`. Every iteration through
      // the loop will update the **second** element of this list with
      // the key, so processing `Ember.View` will make the Array
      // `['Ember', 'View']`.

      paths[idx] = key; // If we have found an unprocessed class

      if (obj && obj.toString === classToString && (0, _utils.getName)(obj) === void 0) {
        // Replace the class' `toString` with the dot-separated path
        (0, _utils.setName)(obj, paths.join('.')); // Support nested namespaces
      } else if (obj && obj.isNamespace) {
        // Skip aliased namespaces
        if (seen.has(obj)) {
          continue;
        }
        seen.add(obj); // Process the child namespace

        _processNamespace(paths, obj, seen);
      }
    }
    paths.length = idx; // cut out last item
  }

  function isUppercase(code) {
    return code >= 65 && code <= 90 // A
    ; // Z
  }

  function tryIsNamespace(lookup, prop) {
    try {
      var obj = lookup[prop];
      return (obj !== null && typeof obj === 'object' || typeof obj === 'function') && obj.isNamespace && obj;
    } catch (e) {// continue
    }
  }
  function calculateToString(target) {
    var str;
    if (!searchDisabled) {
      processAllNamespaces();
      str = (0, _utils.getName)(target);
      if (str !== void 0) {
        return str;
      }
      var superclass = target;
      do {
        superclass = Object.getPrototypeOf(superclass);
        if (superclass === Function.prototype || superclass === Object.prototype) {
          break;
        }
        str = (0, _utils.getName)(target);
        if (str !== void 0) {
          str = "(subclass of " + str + ")";
          break;
        }
      } while (str === void 0);
    }
    return str || '(unknown)';
  }

  /**
  @module @ember/object
  */
  var a_concat = Array.prototype.concat;
  var isArray = Array.isArray;
  function extractAccessors(properties) {
    if (properties !== undefined) {
      var keys = Object.keys(properties);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var desc = Object.getOwnPropertyDescriptor(properties, key);
        if (desc.get !== undefined || desc.set !== undefined) {
          Object.defineProperty(properties, key, {
            value: nativeDescDecorator(desc)
          });
        }
      }
    }
    return properties;
  }
  function concatenatedMixinProperties(concatProp, props, values, base) {
    // reset before adding each new mixin to pickup concats from previous
    var concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? a_concat.call(concats, props[concatProp]) : props[concatProp];
    }
    return concats;
  }
  function giveDecoratorSuper(key, decorator, property, descs) {
    if (property === true) {
      return decorator;
    }
    var originalGetter = property._getter;
    if (originalGetter === undefined) {
      return decorator;
    }
    var superDesc = descs[key]; // Check to see if the super property is a decorator first, if so load its descriptor

    var superProperty = typeof superDesc === 'function' ? descriptorForDecorator(superDesc) : superDesc;
    if (superProperty === undefined || superProperty === true) {
      return decorator;
    }
    var superGetter = superProperty._getter;
    if (superGetter === undefined) {
      return decorator;
    }
    var get = (0, _utils.wrap)(originalGetter, superGetter);
    var set;
    var originalSetter = property._setter;
    var superSetter = superProperty._setter;
    if (superSetter !== undefined) {
      if (originalSetter !== undefined) {
        set = (0, _utils.wrap)(originalSetter, superSetter);
      } else {
        // If the super property has a setter, we default to using it no matter what.
        // This is clearly very broken and weird, but it's what was here so we have
        // to keep it until the next major at least.
        //
        // TODO: Add a deprecation here.
        set = superSetter;
      }
    } else {
      set = originalSetter;
    } // only create a new CP if we must

    if (get !== originalGetter || set !== originalSetter) {
      // Since multiple mixins may inherit from the same parent, we need
      // to clone the computed property so that other mixins do not receive
      // the wrapped version.
      var dependentKeys = property._dependentKeys || [];
      var newProperty = new ComputedProperty([].concat(dependentKeys, [{
        get: get,
        set: set
      }]));
      newProperty._readOnly = property._readOnly;
      newProperty._volatile = property._volatile;
      newProperty._meta = property._meta;
      newProperty.enumerable = property.enumerable;
      return makeComputedDecorator(newProperty, ComputedProperty);
    }
    return decorator;
  }
  function giveMethodSuper(key, method, values, descs) {
    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] !== undefined) {
      return method;
    } // Find the original method in a parent mixin

    var superMethod = values[key]; // Only wrap the new method if the original method was a function

    if (typeof superMethod === 'function') {
      return (0, _utils.wrap)(method, superMethod);
    }
    return method;
  }
  function applyConcatenatedProperties(key, value, values) {
    var baseValue = values[key];
    var ret = (0, _utils.makeArray)(baseValue).concat((0, _utils.makeArray)(value));
    if (true /* DEBUG */) {
      // it is possible to use concatenatedProperties with strings (which cannot be frozen)
      // only freeze objects...
      if (typeof ret === 'object' && ret !== null) {
        // prevent mutating `concatenatedProperties` array after it is applied
        Object.freeze(ret);
      }
    }
    return ret;
  }
  function applyMergedProperties(key, value, values) {
    var baseValue = values[key];
    (true && !(!isArray(value)) && (0, _debug.assert)("You passed in `" + JSON.stringify(value) + "` as the value for `" + key + "` but `" + key + "` cannot be an Array", !isArray(value)));
    if (!baseValue) {
      return value;
    }
    var newBase = (0, _polyfills.assign)({}, baseValue);
    var hasFunction = false;
    var props = Object.keys(value);
    for (var i = 0; i < props.length; i++) {
      var prop = props[i];
      var propValue = value[prop];
      if (typeof propValue === 'function') {
        hasFunction = true;
        newBase[prop] = giveMethodSuper(prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }
    if (hasFunction) {
      newBase._super = _utils.ROOT;
    }
    return newBase;
  }
  function mergeMixins(mixins, meta$$1, descs, values, base, keys, keysWithSuper) {
    var currentMixin;
    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];
      (true && !(typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]') && (0, _debug.assert)("Expected hash or Mixin instance, got " + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]'));
      if (MIXINS.has(currentMixin)) {
        if (meta$$1.hasMixin(currentMixin)) {
          continue;
        }
        meta$$1.addMixin(currentMixin);
        var _currentMixin = currentMixin,
          properties = _currentMixin.properties,
          _mixins = _currentMixin.mixins;
        if (properties !== undefined) {
          mergeProps(meta$$1, properties, descs, values, base, keys, keysWithSuper);
        } else if (_mixins !== undefined) {
          mergeMixins(_mixins, meta$$1, descs, values, base, keys, keysWithSuper);
          if (currentMixin._without !== undefined) {
            currentMixin._without.forEach(function (keyName) {
              // deleting the key means we won't process the value
              var index = keys.indexOf(keyName);
              if (index !== -1) {
                keys.splice(index, 1);
              }
            });
          }
        }
      } else {
        mergeProps(meta$$1, currentMixin, descs, values, base, keys, keysWithSuper);
      }
    }
  }
  function mergeProps(meta$$1, props, descs, values, base, keys, keysWithSuper) {
    var concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
    var mergings = concatenatedMixinProperties('mergedProperties', props, values, base);
    var propKeys = Object.keys(props);
    for (var i = 0; i < propKeys.length; i++) {
      var key = propKeys[i];
      var value = props[key];
      if (value === undefined) continue;
      if (keys.indexOf(key) === -1) {
        keys.push(key);
        var desc = meta$$1.peekDescriptors(key);
        if (desc === undefined) {
          // The superclass did not have a CP, which means it may have
          // observers or listeners on that property.
          var prev = values[key] = base[key];
          if (typeof prev === 'function') {
            updateObserversAndListeners(base, key, prev, false);
          }
        } else {
          descs[key] = desc; // The super desc will be overwritten on descs, so save off the fact that
          // there was a super so we know to Object.defineProperty when writing
          // the value

          keysWithSuper.push(key);
          desc.teardown(base, key, meta$$1);
        }
      }
      var isFunction = typeof value === 'function';
      if (isFunction) {
        var _desc2 = descriptorForDecorator(value);
        if (_desc2 !== undefined) {
          // Wrap descriptor function to implement _super() if needed
          descs[key] = giveDecoratorSuper(key, value, _desc2, descs);
          values[key] = undefined;
          continue;
        }
      }
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value = applyConcatenatedProperties(key, value, values);
      } else if (mergings && mergings.indexOf(key) > -1) {
        value = applyMergedProperties(key, value, values);
      } else if (isFunction) {
        value = giveMethodSuper(key, value, values, descs);
      }
      values[key] = value;
      descs[key] = undefined;
    }
  }
  var followMethodAlias;
  if (_deprecatedFeatures.ALIAS_METHOD) {
    followMethodAlias = function followMethodAlias(obj, alias, descs, values) {
      var altKey = alias.methodName;
      var possibleDesc;
      var desc = descs[altKey];
      var value = values[altKey];
      if (desc !== undefined || value !== undefined) {// do nothing
      } else if ((possibleDesc = descriptorForProperty(obj, altKey)) !== undefined) {
        desc = possibleDesc;
        value = undefined;
      } else {
        desc = undefined;
        value = obj[altKey];
      }
      return {
        desc: desc,
        value: value
      };
    };
  }
  function updateObserversAndListeners(obj, key, fn, add) {
    var meta$$1 = (0, _utils.observerListenerMetaFor)(fn);
    if (meta$$1 === undefined) return;
    var observers = meta$$1.observers,
      listeners = meta$$1.listeners;
    if (observers !== undefined) {
      var updateObserver = add ? addObserver : removeObserver;
      for (var i = 0; i < observers.paths.length; i++) {
        updateObserver(obj, observers.paths[i], null, key, observers.sync);
      }
    }
    if (listeners !== undefined) {
      var updateListener = add ? addListener : removeListener;
      for (var _i = 0; _i < listeners.length; _i++) {
        updateListener(obj, listeners[_i], null, key);
      }
    }
  }
  function applyMixin(obj, mixins, _hideKeys) {
    if (_hideKeys === void 0) {
      _hideKeys = false;
    }
    var descs = Object.create(null);
    var values = Object.create(null);
    var meta$$1 = (0, _meta2.meta)(obj);
    var keys = [];
    var keysWithSuper = [];
    obj._super = _utils.ROOT; // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers

    mergeMixins(mixins, meta$$1, descs, values, obj, keys, keysWithSuper);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = values[key];
      var desc = descs[key];
      if (_deprecatedFeatures.ALIAS_METHOD) {
        while (value !== undefined && isAlias(value)) {
          var followed = followMethodAlias(obj, value, descs, values);
          desc = followed.desc;
          value = followed.value;
        }
      }
      if (value !== undefined) {
        if (typeof value === 'function') {
          updateObserversAndListeners(obj, key, value, true);
        }
        defineValue(obj, key, value, keysWithSuper.indexOf(key) !== -1, !_hideKeys);
      } else if (desc !== undefined) {
        defineDecorator(obj, key, desc, meta$$1);
      }
    }
    if (!meta$$1.isPrototypeMeta(obj)) {
      revalidateObservers(obj);
    }
    return obj;
  }
  /**
    @method mixin
    @param obj
    @param mixins*
    @return obj
    @private
  */

  function mixin(obj) {
    for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key5 = 1; _key5 < _len4; _key5++) {
      args[_key5 - 1] = arguments[_key5];
    }
    applyMixin(obj, args);
    return obj;
  }
  var MIXINS = new _util._WeakSet();
  /**
    The `Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    import Mixin from '@ember/object/mixin';
  
    const EditableMixin = Mixin.create({
      edit() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
    ```
  
    ```javascript
    import EmberObject from '@ember/object';
    import EditableMixin from '../mixins/editable';
  
    // Mix mixins into classes by passing them as the first arguments to
    // `.extend.`
    const Comment = EmberObject.extend(EditableMixin, {
      post: null
    });
  
    let comment = Comment.create({
      post: somePost
    });
  
    comment.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Mixin.create`, not
    `Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    // filters array will be shared amongst any object implementing mixin
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    const FilterableMixin = Mixin.create({
      filters: A()
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
    import { computed } from '@ember/object';
  
    // filters will be a separate array for every object implementing the mixin
    const FilterableMixin = Mixin.create({
      filters: computed(function() {
        return A();
      })
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    // filters will be created as a separate array during the object's initialization
    const Filterable = Mixin.create({
      filters: null,
  
      init() {
        this._super(...arguments);
        this.set("filters", A());
      }
    });
    ```
  
    @class Mixin
    @public
  */
  var Mixin = /*#__PURE__*/function () {
    function Mixin(mixins, properties) {
      MIXINS.add(this);
      this.properties = extractAccessors(properties);
      this.mixins = buildMixinsArray(mixins);
      this.ownerConstructor = undefined;
      this._without = undefined;
      if (true /* DEBUG */) {
        /*
          In debug builds, we seal mixins to help avoid performance pitfalls.
                 In IE11 there is a quirk that prevents sealed objects from being added
          to a WeakMap. Unfortunately, the mixin system currently relies on
          weak maps in `guidFor`, so we need to prime the guid cache weak map.
        */
        (0, _utils.guidFor)(this);
        Object.seal(this);
      }
    }
    /**
      @method create
      @for @ember/object/mixin
      @static
      @param arguments*
      @public
    */
    Mixin.create = function create() {
      setUnprocessedMixins();
      var M = this;
      for (var _len5 = arguments.length, args = new Array(_len5), _key6 = 0; _key6 < _len5; _key6++) {
        args[_key6] = arguments[_key6];
      }
      return new M(args, undefined);
    } // returns the mixins currently applied to the specified object
    // TODO: Make `mixin`
    ;
    Mixin.mixins = function mixins(obj) {
      var meta$$1 = (0, _meta2.peekMeta)(obj);
      var ret = [];
      if (meta$$1 === null) {
        return ret;
      }
      meta$$1.forEachMixins(function (currentMixin) {
        // skip primitive mixins since these are always anonymous
        if (!currentMixin.properties) {
          ret.push(currentMixin);
        }
      });
      return ret;
    }
    /**
      @method reopen
      @param arguments*
      @private
    */;
    var _proto8 = Mixin.prototype;
    _proto8.reopen = function reopen() {
      for (var _len6 = arguments.length, args = new Array(_len6), _key7 = 0; _key7 < _len6; _key7++) {
        args[_key7] = arguments[_key7];
      }
      if (args.length === 0) {
        return;
      }
      if (this.properties) {
        var currentMixin = new Mixin(undefined, this.properties);
        this.properties = undefined;
        this.mixins = [currentMixin];
      } else if (!this.mixins) {
        this.mixins = [];
      }
      this.mixins = this.mixins.concat(buildMixinsArray(args));
      return this;
    }
    /**
      @method apply
      @param obj
      @return applied object
      @private
    */;
    _proto8.apply = function apply(obj, _hideKeys) {
      if (_hideKeys === void 0) {
        _hideKeys = false;
      }
      // Ember.NativeArray is a normal Ember.Mixin that we mix into `Array.prototype` when prototype extensions are enabled
      // mutating a native object prototype like this should _not_ result in enumerable properties being added (or we have significant
      // issues with things like deep equality checks from test frameworks, or things like jQuery.extend(true, [], [])).
      //
      // _hideKeys disables enumerablity when applying the mixin. This is a hack, and we should stop mutating the array prototype by default 😫
      return applyMixin(obj, [this], _hideKeys);
    };
    _proto8.applyPartial = function applyPartial(obj) {
      return applyMixin(obj, [this]);
    }
    /**
      @method detect
      @param obj
      @return {Boolean}
      @private
    */;
    _proto8.detect = function detect(obj) {
      if (typeof obj !== 'object' || obj === null) {
        return false;
      }
      if (MIXINS.has(obj)) {
        return _detect(obj, this);
      }
      var meta$$1 = (0, _meta2.peekMeta)(obj);
      if (meta$$1 === null) {
        return false;
      }
      return meta$$1.hasMixin(this);
    };
    _proto8.without = function without() {
      var ret = new Mixin([this]);
      for (var _len7 = arguments.length, args = new Array(_len7), _key8 = 0; _key8 < _len7; _key8++) {
        args[_key8] = arguments[_key8];
      }
      ret._without = args;
      return ret;
    };
    _proto8.keys = function keys() {
      return _keys(this);
    };
    _proto8.toString = function toString() {
      return '(unknown mixin)';
    };
    return Mixin;
  }();
  _exports.Mixin = Mixin;
  function buildMixinsArray(mixins) {
    var length = mixins && mixins.length || 0;
    var m = undefined;
    if (length > 0) {
      m = new Array(length);
      for (var i = 0; i < length; i++) {
        var x = mixins[i];
        (true && !(typeof x === 'object' && x !== null && Object.prototype.toString.call(x) !== '[object Array]') && (0, _debug.assert)("Expected hash or Mixin instance, got " + Object.prototype.toString.call(x), typeof x === 'object' && x !== null && Object.prototype.toString.call(x) !== '[object Array]'));
        if (MIXINS.has(x)) {
          m[i] = x;
        } else {
          m[i] = new Mixin(undefined, x);
        }
      }
    }
    return m;
  }
  Mixin.prototype.toString = classToString;
  if (true /* DEBUG */) {
    Object.seal(Mixin.prototype);
  }
  function _detect(curMixin, targetMixin, seen) {
    if (seen === void 0) {
      seen = new Set();
    }
    if (seen.has(curMixin)) {
      return false;
    }
    seen.add(curMixin);
    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    if (mixins) {
      return mixins.some(function (mixin) {
        return _detect(mixin, targetMixin, seen);
      });
    }
    return false;
  }
  function _keys(mixin, ret, seen) {
    if (ret === void 0) {
      ret = new Set();
    }
    if (seen === void 0) {
      seen = new Set();
    }
    if (seen.has(mixin)) {
      return;
    }
    seen.add(mixin);
    if (mixin.properties) {
      var props = Object.keys(mixin.properties);
      for (var i = 0; i < props.length; i++) {
        ret.add(props[i]);
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(function (x) {
        return _keys(x, ret, seen);
      });
    }
    return ret;
  }
  var AliasImpl;
  var isAlias;
  if (_deprecatedFeatures.ALIAS_METHOD) {
    var ALIASES = new _util._WeakSet();
    isAlias = function isAlias(alias) {
      return ALIASES.has(alias);
    };
    AliasImpl = function AliasImpl(methodName) {
      this.methodName = methodName;
      ALIASES.add(this);
    };
  }
  /**
    Makes a method available via an additional name.
  
    ```app/utils/person.js
    import EmberObject, {
      aliasMethod
    } from '@ember/object';
  
    export default EmberObject.extend({
      name() {
        return 'Tomhuda Katzdale';
      },
      moniker: aliasMethod('name')
    });
    ```
  
    ```javascript
    let goodGuy = Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @static
    @deprecated Use a shared utility method instead
    @for @ember/object
    @param {String} methodName name of the method to alias
    @public
  */

  var aliasMethod;
  _exports.aliasMethod = aliasMethod;
  if (_deprecatedFeatures.ALIAS_METHOD) {
    _exports.aliasMethod = aliasMethod = function aliasMethod(methodName) {
      (true && !(false) && (0, _debug.deprecate)("You attempted to alias '" + methodName + ", but aliasMethod has been deprecated. Consider extracting the method into a shared utility function.", false, {
        id: 'object.alias-method',
        until: '4.0.0',
        url: 'https://emberjs.com/deprecations/v3.x#toc_object-alias-method',
        for: 'ember-source',
        since: {
          enabled: '3.9.0'
        }
      }));
      return new AliasImpl(methodName);
    };
  }
  function observer() {
    for (var _len8 = arguments.length, args = new Array(_len8), _key9 = 0; _key9 < _len8; _key9++) {
      args[_key9] = arguments[_key9];
    }
    var funcOrDef = args.pop();
    (true && !(typeof funcOrDef === 'function' || typeof funcOrDef === 'object' && funcOrDef !== null) && (0, _debug.assert)('observer must be provided a function or an observer definition', typeof funcOrDef === 'function' || typeof funcOrDef === 'object' && funcOrDef !== null));
    var func, dependentKeys, sync;
    if (typeof funcOrDef === 'function') {
      func = funcOrDef;
      dependentKeys = args;
      sync = !_environment.ENV._DEFAULT_ASYNC_OBSERVERS;
    } else {
      func = funcOrDef.fn;
      dependentKeys = funcOrDef.dependentKeys;
      sync = funcOrDef.sync;
    }
    (true && !(typeof func === 'function') && (0, _debug.assert)('observer called without a function', typeof func === 'function'));
    (true && !(Array.isArray(dependentKeys) && dependentKeys.length > 0 && dependentKeys.every(function (p) {
      return typeof p === 'string' && Boolean(p.length);
    })) && (0, _debug.assert)('observer called without valid path', Array.isArray(dependentKeys) && dependentKeys.length > 0 && dependentKeys.every(function (p) {
      return typeof p === 'string' && Boolean(p.length);
    })));
    (true && !(typeof sync === 'boolean') && (0, _debug.assert)('observer called without sync', typeof sync === 'boolean'));
    var paths = [];
    for (var i = 0; i < dependentKeys.length; ++i) {
      expandProperties(dependentKeys[i], function (path) {
        return paths.push(path);
      });
    }
    (0, _utils.setObservers)(func, {
      paths: paths,
      sync: sync
    });
    return func;
  }
  var DEBUG_INJECTION_FUNCTIONS;
  _exports.DEBUG_INJECTION_FUNCTIONS = DEBUG_INJECTION_FUNCTIONS;
  if (true /* DEBUG */) {
    _exports.DEBUG_INJECTION_FUNCTIONS = DEBUG_INJECTION_FUNCTIONS = new WeakMap();
  }
  function inject(type) {
    (true && !(typeof type === 'string') && (0, _debug.assert)('a string type must be provided to inject', typeof type === 'string'));
    for (var _len9 = arguments.length, args = new Array(_len9 > 1 ? _len9 - 1 : 0), _key10 = 1; _key10 < _len9; _key10++) {
      args[_key10 - 1] = arguments[_key10];
    }
    var calledAsDecorator = isElementDescriptor(args);
    var name = calledAsDecorator ? undefined : args[0];
    var getInjection = function getInjection(propertyName) {
      var owner = (0, _owner.getOwner)(this) || this.container; // fallback to `container` for backwards compat
      (true && !(Boolean(owner)) && (0, _debug.assert)("Attempting to lookup an injected property on an object without a container, ensure that the object was instantiated via a container.", Boolean(owner)));
      return owner.lookup(type + ":" + (name || propertyName));
    };
    if (true /* DEBUG */) {
      DEBUG_INJECTION_FUNCTIONS.set(getInjection, {
        type: type,
        name: name
      });
    }
    var decorator = computed({
      get: getInjection,
      set: function set(keyName, value) {
        defineProperty(this, keyName, null, value);
      }
    });
    if (calledAsDecorator) {
      return decorator(args[0], args[1], args[2]);
    } else {
      return decorator;
    }
  }
  function tracked() {
    for (var _len10 = arguments.length, args = new Array(_len10), _key11 = 0; _key11 < _len10; _key11++) {
      args[_key11] = arguments[_key11];
    }
    (true && !(!(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)) && (0, _debug.assert)("@tracked can only be used directly as a native decorator. If you're using tracked in classic classes, add parenthesis to call it like a function: tracked()", !(isElementDescriptor(args.slice(0, 3)) && args.length === 5 && args[4] === true)));
    if (!isElementDescriptor(args)) {
      var propertyDesc = args[0];
      (true && !(args.length === 0 || typeof propertyDesc === 'object' && propertyDesc !== null) && (0, _debug.assert)("tracked() may only receive an options object containing 'value' or 'initializer', received " + propertyDesc, args.length === 0 || typeof propertyDesc === 'object' && propertyDesc !== null));
      if (true /* DEBUG */ && propertyDesc) {
        var keys = Object.keys(propertyDesc);
        (true && !(keys.length <= 1 && (keys[0] === undefined || keys[0] === 'value' || keys[0] === 'initializer')) && (0, _debug.assert)("The options object passed to tracked() may only contain a 'value' or 'initializer' property, not both. Received: [" + keys + "]", keys.length <= 1 && (keys[0] === undefined || keys[0] === 'value' || keys[0] === 'initializer')));
        (true && !(!('initializer' in propertyDesc) || typeof propertyDesc.initializer === 'function') && (0, _debug.assert)("The initializer passed to tracked must be a function. Received " + propertyDesc.initializer, !('initializer' in propertyDesc) || typeof propertyDesc.initializer === 'function'));
      }
      var initializer = propertyDesc ? propertyDesc.initializer : undefined;
      var value = propertyDesc ? propertyDesc.value : undefined;
      var decorator = function decorator(target, key, _desc, _meta, isClassicDecorator$$1) {
        (true && !(isClassicDecorator$$1) && (0, _debug.assert)("You attempted to set a default value for " + key + " with the @tracked({ value: 'default' }) syntax. You can only use this syntax with classic classes. For native classes, you can use class initializers: @tracked field = 'default';", isClassicDecorator$$1));
        var fieldDesc = {
          initializer: initializer || function () {
            return value;
          }
        };
        return descriptorForField([target, key, fieldDesc]);
      };
      setClassicDecorator(decorator);
      return decorator;
    }
    return descriptorForField(args);
  }
  if (true /* DEBUG */) {
    // Normally this isn't a classic decorator, but we want to throw a helpful
    // error in development so we need it to treat it like one
    setClassicDecorator(tracked);
  }
  function descriptorForField(_ref) {
    var target = _ref[0],
      key = _ref[1],
      desc = _ref[2];
    (true && !(!desc || !desc.value && !desc.get && !desc.set) && (0, _debug.assert)("You attempted to use @tracked on " + key + ", but that element is not a class field. @tracked is only usable on class fields. Native getters and setters will autotrack add any tracked fields they encounter, so there is no need mark getters and setters with @tracked.", !desc || !desc.value && !desc.get && !desc.set));
    var _trackedData = (0, _validator.trackedData)(key, desc ? desc.initializer : undefined),
      getter = _trackedData.getter,
      setter = _trackedData.setter;
    function get() {
      var value = getter(this); // Add the tag of the returned value if it is an array, since arrays
      // should always cause updates if they are consumed and then changed

      if (Array.isArray(value) || (0, _utils.isEmberArray)(value)) {
        (0, _validator.consumeTag)((0, _validator.tagFor)(value, '[]'));
      }
      return value;
    }
    function set(newValue) {
      setter(this, newValue);
      (0, _validator.dirtyTagFor)(this, SELF_TAG);
    }
    var newDesc = {
      enumerable: true,
      configurable: true,
      isTracked: true,
      get: get,
      set: set
    };
    COMPUTED_SETTERS.add(set);
    (0, _meta2.meta)(target).writeDescriptors(key, new TrackedDescriptor(get, set));
    return newDesc;
  }
  var TrackedDescriptor = /*#__PURE__*/function () {
    function TrackedDescriptor(_get, _set) {
      this._get = _get;
      this._set = _set;
      CHAIN_PASS_THROUGH.add(this);
    }
    var _proto9 = TrackedDescriptor.prototype;
    _proto9.get = function get(obj) {
      return this._get.call(obj);
    };
    _proto9.set = function set(obj, _key, value) {
      this._set.call(obj, value);
    };
    return TrackedDescriptor;
  }();
  /**
    Ember uses caching based on trackable values to avoid updating large portions
    of the application. This caching is exposed via a cache primitive that can be
    used to cache a specific computation, so that it will not update and will
    return the cached value until a tracked value used in its computation has
    updated.
  
    @module @glimmer/tracking/primitives/cache
    @public
  */
  /**
    Receives a function, and returns a wrapped version of it that memoizes based on
    _autotracking_. The function will only rerun whenever any tracked values used
    within it have changed. Otherwise, it will return the previous value.
  
    ```js
    import { tracked } from '@glimmer/tracking';
    import { createCache, getValue } from '@glimmer/tracking/primitives/cache';
  
    class State {
      @tracked value;
    }
  
    let state = new State();
    let computeCount = 0;
  
    let counter = createCache(() => {
      // consume the state. Now, `counter` will
      // only rerun if `state.value` changes.
      state.value;
  
      return ++computeCount;
    });
  
    getValue(counter); // 1
  
    // returns the same value because no tracked state has changed
    getValue(counter); // 1
  
    state.value = 'foo';
  
    // reruns because a tracked value used in the function has changed,
    // incermenting the counter
    getValue(counter); // 2
    ```
  
    @method createCache
    @static
    @for @glimmer/tracking/primitives/cache
    @public
  */
  /**
    Gets the value of a cache created with `createCache`.
  
    ```js
    import { tracked } from '@glimmer/tracking';
    import { createCache, getValue } from '@glimmer/tracking/primitives/cache';
  
    let computeCount = 0;
  
    let counter = createCache(() => {
      return ++computeCount;
    });
  
    getValue(counter); // 1
    ```
  
    @method getValue
    @static
    @for @glimmer/tracking/primitives/cache
    @public
  */
  /**
    Can be used to check if a memoized function is _constant_. If no tracked state
    was used while running a memoized function, it will never rerun, because nothing
    can invalidate its result. `isConst` can be used to determine if a memoized
    function is constant or not, in order to optimize code surrounding that
    function.
  
    ```js
    import { tracked } from '@glimmer/tracking';
    import { createCache, getValue, isConst } from '@glimmer/tracking/primitives/cache';
  
    class State {
      @tracked value;
    }
  
    let state = new State();
    let computeCount = 0;
  
    let counter = createCache(() => {
      // consume the state
      state.value;
  
      return computeCount++;
    });
  
    let constCounter = createCache(() => {
      return computeCount++;
    });
  
    getValue(counter);
    getValue(constCounter);
  
    isConst(counter); // false
    isConst(constCounter); // true
    ```
  
    If called on a cache that hasn't been accessed yet, it will throw an
    error. This is because there's no way to know if the function will be constant
    or not yet, and so this helps prevent missing an optimization opportunity on
    accident.
  
    @method isConst
    @static
    @for @glimmer/tracking/primitives/cache
    @public
  */
});
define("@ember/-internals/owner/index", ["exports", "@glimmer/runtime", "@ember/-internals/utils", "@ember/debug"], function (_exports, _runtime, _utils, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.LEGACY_OWNER = void 0;
  _exports.getOwner = getOwner;
  _exports.setOwner = setOwner;
  var LEGACY_OWNER = (0, _utils.enumerableSymbol)('LEGACY_OWNER');
  /**
    Framework objects in an Ember application (components, services, routes, etc.)
    are created via a factory and dependency injection system. Each of these
    objects is the responsibility of an "owner", which handled its
    instantiation and manages its lifetime.
  
    `getOwner` fetches the owner object responsible for an instance. This can
    be used to lookup or resolve other class instances, or register new factories
    into the owner.
  
    For example, this component dynamically looks up a service based on the
    `audioType` passed as an argument:
  
    ```app/components/play-audio.js
    import Component from '@glimmer/component';
    import { action } from '@ember/object';
    import { getOwner } from '@ember/application';
  
    // Usage:
    //
    //   <PlayAudio @audioType={{@model.audioType}} @audioFile={{@model.file}}/>
    //
    export default class extends Component {
      get audioService() {
        let owner = getOwner(this);
        return owner.lookup(`service:${this.args.audioType}`);
      }
  
      @action
      onPlay() {
        let player = this.audioService;
        player.play(this.args.audioFile);
      }
    }
    ```
  
    @method getOwner
    @static
    @for @ember/application
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */
  _exports.LEGACY_OWNER = LEGACY_OWNER;
  function getOwner(object) {
    var owner = (0, _runtime.getOwner)(object);
    if (owner === undefined) {
      owner = object[LEGACY_OWNER];
      (true && !(owner === undefined) && (0, _debug.deprecate)("You accessed the owner using `getOwner` on an object, but it was not set on that object with `setOwner`. You must use `setOwner` to set the owner on all objects. You cannot use Object.assign().", owner === undefined, {
        id: 'owner.legacy-owner-injection',
        until: '3.25.0',
        for: 'ember-source',
        since: {
          enabled: '3.22.0'
        }
      }));
    }
    return owner;
  }
  /**
    `setOwner` forces a new owner on a given object instance. This is primarily
    useful in some testing cases.
  
    @method setOwner
    @static
    @for @ember/application
    @param {Object} object An object instance.
    @param {Object} object The new owner object of the object instance.
    @since 2.3.0
    @public
  */

  function setOwner(object, owner) {
    (0, _runtime.setOwner)(object, owner);
    object[LEGACY_OWNER] = owner;
  }
});
define("@ember/-internals/routing/index", ["exports", "@ember/-internals/routing/lib/ext/controller", "@ember/-internals/routing/lib/location/api", "@ember/-internals/routing/lib/location/none_location", "@ember/-internals/routing/lib/location/hash_location", "@ember/-internals/routing/lib/location/history_location", "@ember/-internals/routing/lib/location/auto_location", "@ember/-internals/routing/lib/system/generate_controller", "@ember/-internals/routing/lib/system/controller_for", "@ember/-internals/routing/lib/system/dsl", "@ember/-internals/routing/lib/system/router", "@ember/-internals/routing/lib/system/route", "@ember/-internals/routing/lib/system/query_params", "@ember/-internals/routing/lib/services/routing", "@ember/-internals/routing/lib/services/router", "@ember/-internals/routing/lib/system/cache"], function (_exports, _controller, _api, _none_location, _hash_location, _history_location, _auto_location, _generate_controller, _controller_for, _dsl, _router, _route, _query_params, _routing, _router2, _cache) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "AutoLocation", {
    enumerable: true,
    get: function get() {
      return _auto_location.default;
    }
  });
  Object.defineProperty(_exports, "BucketCache", {
    enumerable: true,
    get: function get() {
      return _cache.default;
    }
  });
  Object.defineProperty(_exports, "HashLocation", {
    enumerable: true,
    get: function get() {
      return _hash_location.default;
    }
  });
  Object.defineProperty(_exports, "HistoryLocation", {
    enumerable: true,
    get: function get() {
      return _history_location.default;
    }
  });
  Object.defineProperty(_exports, "Location", {
    enumerable: true,
    get: function get() {
      return _api.default;
    }
  });
  Object.defineProperty(_exports, "NoneLocation", {
    enumerable: true,
    get: function get() {
      return _none_location.default;
    }
  });
  Object.defineProperty(_exports, "QueryParams", {
    enumerable: true,
    get: function get() {
      return _query_params.default;
    }
  });
  Object.defineProperty(_exports, "Route", {
    enumerable: true,
    get: function get() {
      return _route.default;
    }
  });
  Object.defineProperty(_exports, "Router", {
    enumerable: true,
    get: function get() {
      return _router.default;
    }
  });
  Object.defineProperty(_exports, "RouterDSL", {
    enumerable: true,
    get: function get() {
      return _dsl.default;
    }
  });
  Object.defineProperty(_exports, "RouterService", {
    enumerable: true,
    get: function get() {
      return _router2.default;
    }
  });
  Object.defineProperty(_exports, "RoutingService", {
    enumerable: true,
    get: function get() {
      return _routing.default;
    }
  });
  Object.defineProperty(_exports, "controllerFor", {
    enumerable: true,
    get: function get() {
      return _controller_for.default;
    }
  });
  Object.defineProperty(_exports, "generateController", {
    enumerable: true,
    get: function get() {
      return _generate_controller.default;
    }
  });
  Object.defineProperty(_exports, "generateControllerFactory", {
    enumerable: true,
    get: function get() {
      return _generate_controller.generateControllerFactory;
    }
  });
});
define("@ember/-internals/routing/lib/ext/controller", ["exports", "@ember/-internals/metal", "@ember/controller/lib/controller_mixin", "@ember/-internals/routing/lib/utils"], function (_exports, _metal, _controller_mixin, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */

  _controller_mixin.default.reopen({
    concatenatedProperties: ['queryParams'],
    /**
      Defines which query parameters the controller accepts.
      If you give the names `['category','page']` it will bind
      the values of these query parameters to the variables
      `this.category` and `this.page`.
      By default, Ember coerces query parameter values using `toggleProperty`.
      This behavior may lead to unexpected results.
      Available queryParam types: `boolean`, `number`, `array`.
      If query param type not specified, it will be `string`.
      To explicitly configure a query parameter property so it coerces as expected, you must define a type property:
         ```javascript
        queryParams: [{
          category: {
            type: 'boolean'
          }
        }]
      ```
         @for Ember.ControllerMixin
      @property queryParams
      @public
    */
    queryParams: null,
    /**
     This property is updated to various different callback functions depending on
     the current "state" of the backing route. It is used by
     `Controller.prototype._qpChanged`.
        The methods backing each state can be found in the `Route.prototype._qp` computed
     property return value (the `.states` property). The current values are listed here for
     the sanity of future travelers:
        * `inactive` - This state is used when this controller instance is not part of the active
       route hierarchy. Set in `Route.prototype._reset` (a `router.js` microlib hook) and
       `Route.prototype.actions.finalizeQueryParamChange`.
     * `active` - This state is used when this controller instance is part of the active
       route hierarchy. Set in `Route.prototype.actions.finalizeQueryParamChange`.
     * `allowOverrides` - This state is used in `Route.prototype.setup` (`route.js` microlib hook).
         @method _qpDelegate
      @private
    */
    _qpDelegate: null,
    /**
     During `Route#setup` observers are created to invoke this method
     when any of the query params declared in `Controller#queryParams` property
     are changed.
        When invoked this method uses the currently active query param update delegate
     (see `Controller.prototype._qpDelegate` for details) and invokes it with
     the QP key/value being changed.
         @method _qpChanged
      @private
    */
    _qpChanged: function _qpChanged(controller, _prop) {
      var dotIndex = _prop.indexOf('.[]');
      var prop = dotIndex === -1 ? _prop : _prop.slice(0, dotIndex);
      var delegate = controller._qpDelegate;
      var value = (0, _metal.get)(controller, prop);
      delegate(prop, value);
    },
    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         ```javascript
      aController.transitionToRoute('blogPosts');
      aController.transitionToRoute('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      aController.transitionToRoute('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      aController.transitionToRoute('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/router.js
      Router.map(function() {
        this.route('blogPost', { path: ':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId', resetNamespace: true });
        });
      });
      ```
         ```javascript
      aController.transitionToRoute('blogComment', aPost, aComment);
      aController.transitionToRoute('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      aController.transitionToRoute('/');
      aController.transitionToRoute('/blog/post/1/comment/13');
      aController.transitionToRoute('/blog/posts?sort=title');
      ```
         An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
         ```javascript
      aController.transitionToRoute('blogPost', 1, {
        queryParams: { showComments: 'true' }
      });
         // if you just want to transition the query parameters without changing the route
      aController.transitionToRoute({ queryParams: { sort: 'date' } });
      ```
         See also [replaceRoute](/ember/release/classes/Ember.ControllerMixin/methods/replaceRoute?anchor=replaceRoute).
         @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
        while transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @for Ember.ControllerMixin
      @method transitionToRoute
      @return {Transition} the transition object associated with this
        attempted transition
      @public
    */
    transitionToRoute: function transitionToRoute() {
      // target may be either another controller or a router
      var target = (0, _metal.get)(this, 'target');
      var method = target.transitionToRoute || target.transitionTo;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return method.apply(target, (0, _utils.prefixRouteNameArg)(this, args));
    },
    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionToRoute` in all other respects.
         ```javascript
      aController.replaceRoute('blogPosts');
      aController.replaceRoute('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      aController.replaceRoute('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      aController.replaceRoute('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/router.js
      Router.map(function() {
        this.route('blogPost', { path: ':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId', resetNamespace: true });
        });
      });
      ```
         ```
      aController.replaceRoute('blogComment', aPost, aComment);
      aController.replaceRoute('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      aController.replaceRoute('/');
      aController.replaceRoute('/blog/post/1/comment/13');
      ```
         @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used
      while transitioning to the route.
      @for Ember.ControllerMixin
      @method replaceRoute
      @return {Transition} the transition object associated with this
        attempted transition
      @public
    */
    replaceRoute: function replaceRoute() {
      // target may be either another controller or a router
      var target = (0, _metal.get)(this, 'target');
      var method = target.replaceRoute || target.replaceWith;
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return method.apply(target, (0, _utils.prefixRouteNameArg)(this, args));
    }
  });
  var _default = _controller_mixin.default;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/location/api", ["exports", "@ember/debug"], function (_exports, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/routing
  */
  /**
    Location returns an instance of the correct implementation of
    the `location` API.
  
    ## Implementations
  
    You can pass an implementation name (`hash`, `history`, `none`, `auto`) to force a
    particular implementation to be used in your application.
  
    See [HashLocation](/ember/release/classes/HashLocation).
    See [HistoryLocation](/ember/release/classes/HistoryLocation).
    See [NoneLocation](/ember/release/classes/NoneLocation).
    See [AutoLocation](/ember/release/classes/AutoLocation).
  
    ## Location API
  
    Each location implementation must provide the following methods:
  
    * implementation: returns the string name used to reference the implementation.
    * getURL: returns the current URL.
    * setURL(path): sets the current URL.
    * replaceURL(path): replace the current URL (optional).
    * onUpdateURL(callback): triggers the callback when the URL changes.
    * formatURL(url): formats `url` to be placed into `href` attribute.
    * detect() (optional): instructs the location to do any feature detection
        necessary. If the location needs to redirect to a different URL, it
        can cancel routing by setting the `cancelRouterSetup` property on itself
        to `false`.
  
    Calling setURL or replaceURL will not trigger onUpdateURL callbacks.
  
    ## Custom implementation
  
    Ember scans `app/locations/*` for extending the Location API.
  
    Example:
  
    ```javascript
    import HistoryLocation from '@ember/routing/history-location';
  
    export default class MyHistory {
      implementation: 'my-custom-history',
      constructor() {
        this._history = HistoryLocation.create(...arguments);
      }
      create() {
        return new this(...arguments);
      }
      pushState(path) {
         this._history.pushState(path);
      }
    }
    ```
  
    @class Location
    @private
  */
  var _default = {
    /**
     This is deprecated in favor of using the container to lookup the location
     implementation as desired.
        For example:
        ```javascript
     // Given a location registered as follows:
     container.register('location:history-test', HistoryTestLocation);
        // You could create a new instance via:
     container.lookup('location:history-test');
     ```
         @method create
      @param {Object} options
      @return {Object} an instance of an implementation of the `location` API
      @deprecated Use the container to lookup the location implementation that you
      need.
      @private
    */
    create: function create(options) {
      var implementation = options && options.implementation;
      (true && !(Boolean(implementation)) && (0, _debug.assert)("Location.create: you must specify a 'implementation' option", Boolean(implementation)));
      var implementationClass = this.implementations[implementation];
      (true && !(Boolean(implementationClass)) && (0, _debug.assert)("Location.create: " + implementation + " is not a valid implementation", Boolean(implementationClass)));
      return implementationClass.create.apply(implementationClass, arguments);
    },
    implementations: {}
  };
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/location/auto_location", ["exports", "ember-babel", "@ember/-internals/browser-environment", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/debug", "@ember/-internals/routing/lib/location/util"], function (_exports, _emberBabel, _browserEnvironment, _metal, _owner, _runtime, _debug, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  _exports.getHashPath = getHashPath;
  _exports.getHistoryPath = getHistoryPath;
  /**
  @module @ember/routing
  */
  /**
    AutoLocation will select the best location option based off browser
    support with the priority order: history, hash, none.
  
    Clean pushState paths accessed by hashchange-only browsers will be redirected
    to the hash-equivalent and vice versa so future transitions are consistent.
  
    Keep in mind that since some of your users will use `HistoryLocation`, your
    server must serve the Ember app at all the routes you define.
  
    Browsers that support the `history` API will use `HistoryLocation`, those that
    do not, but still support the `hashchange` event will use `HashLocation`, and
    in the rare case neither is supported will use `NoneLocation`.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'auto'
    });
    ```
  
    This will result in a posts.new url of `/posts/new` for modern browsers that
    support the `history` api or `/#/posts/new` for older ones, like Internet
    Explorer 9 and below.
  
    When a user visits a link to your application, they will be automatically
    upgraded or downgraded to the appropriate `Location` class, with the URL
    transformed accordingly, if needed.
  
    Keep in mind that since some of your users will use `HistoryLocation`, your
    server must serve the Ember app at all the routes you define.
  
    @class AutoLocation
    @static
    @protected
  */
  var AutoLocation = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(AutoLocation, _EmberObject);
    function AutoLocation() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this.implementation = 'auto';
      return _this;
    }
    /**
     Called by the router to instruct the location to do any feature detection
     necessary. In the case of AutoLocation, we detect whether to use history
     or hash concrete implementations.
        @private
    */
    var _proto = AutoLocation.prototype;
    _proto.detect = function detect() {
      var rootURL = this.rootURL;
      (true && !(rootURL.charAt(rootURL.length - 1) === '/') && (0, _debug.assert)('rootURL must end with a trailing forward slash e.g. "/app/"', rootURL.charAt(rootURL.length - 1) === '/'));
      var implementation = detectImplementation({
        location: this.location,
        history: this.history,
        userAgent: this.userAgent,
        rootURL: rootURL,
        documentMode: this.documentMode,
        global: this.global
      });
      if (implementation === false) {
        (0, _metal.set)(this, 'cancelRouterSetup', true);
        implementation = 'none';
      }
      var concrete = (0, _owner.getOwner)(this).lookup("location:" + implementation);
      (true && !(concrete !== undefined) && (0, _debug.assert)("Could not find location '" + implementation + "'.", concrete !== undefined));
      (0, _metal.set)(concrete, 'rootURL', rootURL);
      (0, _metal.set)(this, 'concreteImplementation', concrete);
    };
    _proto.willDestroy = function willDestroy() {
      var concreteImplementation = this.concreteImplementation;
      if (concreteImplementation) {
        concreteImplementation.destroy();
      }
    };
    return AutoLocation;
  }(_runtime.Object);
  _exports.default = AutoLocation;
  AutoLocation.reopen({
    /**
      @private
         Will be pre-pended to path upon state change.
         @since 1.5.1
      @property rootURL
      @default '/'
    */
    rootURL: '/',
    initState: delegateToConcreteImplementation('initState'),
    getURL: delegateToConcreteImplementation('getURL'),
    setURL: delegateToConcreteImplementation('setURL'),
    replaceURL: delegateToConcreteImplementation('replaceURL'),
    onUpdateURL: delegateToConcreteImplementation('onUpdateURL'),
    formatURL: delegateToConcreteImplementation('formatURL'),
    /**
      @private
         The browser's `location` object. This is typically equivalent to
      `window.location`, but may be overridden for testing.
         @property location
      @default environment.location
    */
    location: _browserEnvironment.location,
    /**
      @private
         The browser's `history` object. This is typically equivalent to
      `window.history`, but may be overridden for testing.
         @since 1.5.1
      @property history
      @default environment.history
    */
    history: _browserEnvironment.history,
    /**
     @private
        The user agent's global variable. In browsers, this will be `window`.
        @since 1.11
     @property global
     @default window
    */
    global: _browserEnvironment.window,
    /**
      @private
         The browser's `userAgent`. This is typically equivalent to
      `navigator.userAgent`, but may be overridden for testing.
         @since 1.5.1
      @property userAgent
      @default environment.history
    */
    userAgent: _browserEnvironment.userAgent,
    /**
      @private
         This property is used by the router to know whether to cancel the routing
      setup process, which is needed while we redirect the browser.
         @since 1.5.1
      @property cancelRouterSetup
      @default false
    */
    cancelRouterSetup: false
  });
  function delegateToConcreteImplementation(methodName) {
    return function () {
      var _a2;
      var _a;
      var concreteImplementation = this.concreteImplementation;
      (true && !(Boolean(concreteImplementation)) && (0, _debug.assert)("AutoLocation's detect() method should be called before calling any other hooks.", Boolean(concreteImplementation)));
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return (_a = concreteImplementation[methodName]) === null || _a === void 0 ? void 0 : (_a2 = _a).call.apply(_a2, [concreteImplementation].concat(args));
    };
  }
  function detectImplementation(options) {
    var location = options.location,
      userAgent = options.userAgent,
      history = options.history,
      documentMode = options.documentMode,
      global = options.global,
      rootURL = options.rootURL;
    var implementation = 'none';
    var cancelRouterSetup = false;
    var currentPath = (0, _util.getFullPath)(location);
    if ((0, _util.supportsHistory)(userAgent, history)) {
      var historyPath = getHistoryPath(rootURL, location); // If the browser supports history and we have a history path, we can use
      // the history location with no redirects.

      if (currentPath === historyPath) {
        implementation = 'history';
      } else if (currentPath.substr(0, 2) === '/#') {
        history.replaceState({
          path: historyPath
        }, '', historyPath);
        implementation = 'history';
      } else {
        cancelRouterSetup = true;
        (0, _util.replacePath)(location, historyPath);
      }
    } else if ((0, _util.supportsHashChange)(documentMode, global)) {
      var hashPath = getHashPath(rootURL, location); // Be sure we're using a hashed path, otherwise let's switch over it to so
      // we start off clean and consistent. We'll count an index path with no
      // hash as "good enough" as well.

      if (currentPath === hashPath || currentPath === '/' && hashPath === '/#/') {
        implementation = 'hash';
      } else {
        // Our URL isn't in the expected hash-supported format, so we want to
        // cancel the router setup and replace the URL to start off clean
        cancelRouterSetup = true;
        (0, _util.replacePath)(location, hashPath);
      }
    }
    if (cancelRouterSetup) {
      return false;
    }
    return implementation;
  }
  /**
    @private
  
    Returns the current path as it should appear for HistoryLocation supported
    browsers. This may very well differ from the real current path (e.g. if it
    starts off as a hashed URL)
  */

  function getHistoryPath(rootURL, location) {
    var path = (0, _util.getPath)(location);
    var hash = (0, _util.getHash)(location);
    var query = (0, _util.getQuery)(location);
    var rootURLIndex = path.indexOf(rootURL);
    var routeHash, hashParts;
    (true && !(rootURLIndex === 0) && (0, _debug.assert)("Path " + path + " does not start with the provided rootURL " + rootURL, rootURLIndex === 0)); // By convention, Ember.js routes using HashLocation are required to start
    // with `#/`. Anything else should NOT be considered a route and should
    // be passed straight through, without transformation.
    if (hash.substr(0, 2) === '#/') {
      // There could be extra hash segments after the route
      hashParts = hash.substr(1).split('#'); // The first one is always the route url

      routeHash = hashParts.shift(); // If the path already has a trailing slash, remove the one
      // from the hashed route so we don't double up.

      if (path.charAt(path.length - 1) === '/') {
        routeHash = routeHash.substr(1);
      } // This is the "expected" final order

      path += routeHash + query;
      if (hashParts.length) {
        path += "#" + hashParts.join('#');
      }
    } else {
      path += query + hash;
    }
    return path;
  }
  /**
    @private
  
    Returns the current path as it should appear for HashLocation supported
    browsers. This may very well differ from the real current path.
  
    @method _getHashPath
  */

  function getHashPath(rootURL, location) {
    var path = rootURL;
    var historyPath = getHistoryPath(rootURL, location);
    var routePath = historyPath.substr(rootURL.length);
    if (routePath !== '') {
      if (routePath[0] !== '/') {
        routePath = "/" + routePath;
      }
      path += "#" + routePath;
    }
    return path;
  }
});
define("@ember/-internals/routing/lib/location/hash_location", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/runloop", "@ember/-internals/routing/lib/location/util"], function (_exports, _emberBabel, _metal, _runtime, _runloop, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/routing
  */
  /**
    `HashLocation` implements the location API using the browser's
    hash. At present, it relies on a `hashchange` event existing in the
    browser.
  
    Using `HashLocation` results in URLs with a `#` (hash sign) separating the
    server side URL portion of the URL from the portion that is used by Ember.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'hash'
    });
    ```
  
    This will result in a posts.new url of `/#/posts/new`.
  
    @class HashLocation
    @extends EmberObject
    @protected
  */
  var HashLocation = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(HashLocation, _EmberObject);
    function HashLocation() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this.implementation = 'hash';
      return _this;
    }
    var _proto = HashLocation.prototype;
    _proto.init = function init() {
      (0, _metal.set)(this, 'location', this._location || window.location);
      this._hashchangeHandler = undefined;
    }
    /**
      @private
         Returns normalized location.hash
         @since 1.5.1
      @method getHash
    */;
    _proto.getHash = function getHash() {
      return (0, _util.getHash)(this.location);
    }
    /**
      Returns the normalized URL, constructed from `location.hash`.
         e.g. `#/foo` => `/foo` as well as `#/foo#bar` => `/foo#bar`.
         By convention, hashed paths must begin with a forward slash, otherwise they
      are not treated as a path so we can distinguish intent.
         @private
      @method getURL
    */;
    _proto.getURL = function getURL() {
      var originalPath = this.getHash().substr(1);
      var outPath = originalPath;
      if (outPath[0] !== '/') {
        outPath = '/'; // Only add the # if the path isn't empty.
        // We do NOT want `/#` since the ampersand
        // is only included (conventionally) when
        // the location.hash has a value

        if (originalPath) {
          outPath += "#" + originalPath;
        }
      }
      return outPath;
    }
    /**
      Set the `location.hash` and remembers what was set. This prevents
      `onUpdateURL` callbacks from triggering when the hash was set by
      `HashLocation`.
         @private
      @method setURL
      @param path {String}
    */;
    _proto.setURL = function setURL(path) {
      this.location.hash = path;
      (0, _metal.set)(this, 'lastSetURL', path);
    }
    /**
      Uses location.replace to update the url without a page reload
      or history modification.
         @private
      @method replaceURL
      @param path {String}
    */;
    _proto.replaceURL = function replaceURL(path) {
      this.location.replace("#" + path);
      (0, _metal.set)(this, 'lastSetURL', path);
    }
    /**
      Register a callback to be invoked when the hash changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
         @private
      @method onUpdateURL
      @param callback {Function}
    */;
    _proto.onUpdateURL = function onUpdateURL(callback) {
      this._removeEventListener();
      this._hashchangeHandler = (0, _runloop.bind)(this, function () {
        var path = this.getURL();
        if (this.lastSetURL === path) {
          return;
        }
        (0, _metal.set)(this, 'lastSetURL', null);
        callback(path);
      });
      window.addEventListener('hashchange', this._hashchangeHandler);
    }
    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
         This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
         @private
      @method formatURL
      @param url {String}
    */;
    _proto.formatURL = function formatURL(url) {
      return "#" + url;
    }
    /**
      Cleans up the HashLocation event listener.
         @private
      @method willDestroy
    */;
    _proto.willDestroy = function willDestroy() {
      this._removeEventListener();
    };
    _proto._removeEventListener = function _removeEventListener() {
      if (this._hashchangeHandler) {
        window.removeEventListener('hashchange', this._hashchangeHandler);
      }
    };
    return HashLocation;
  }(_runtime.Object);
  _exports.default = HashLocation;
});
define("@ember/-internals/routing/lib/location/history_location", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/-internals/routing/lib/location/util"], function (_exports, _emberBabel, _metal, _runtime, _util) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/routing
  */

  var popstateFired = false;
  function _uuid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
      var r, v;
      r = Math.random() * 16 | 0;
      v = c === 'x' ? r : r & 3 | 8;
      return v.toString(16);
    });
  }
  /**
    HistoryLocation implements the location API using the browser's
    history.pushState API.
  
    Using `HistoryLocation` results in URLs that are indistinguishable from a
    standard URL. This relies upon the browser's `history` API.
  
    Example:
  
    ```app/router.js
    Router.map(function() {
      this.route('posts', function() {
        this.route('new');
      });
    });
  
    Router.reopen({
      location: 'history'
    });
    ```
  
    This will result in a posts.new url of `/posts/new`.
  
    Keep in mind that your server must serve the Ember app at all the routes you
    define.
  
    Using `HistoryLocation` will also result in location states being recorded by
    the browser `history` API with the following schema:
  
    ```
    window.history.state -> { path: '/', uuid: '3552e730-b4a6-46bd-b8bf-d8c3c1a97e0a' }
    ```
  
    This allows each in-app location state to be tracked uniquely across history
    state changes via the `uuid` field.
  
    @class HistoryLocation
    @extends EmberObject
    @protected
  */
  var HistoryLocation = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(HistoryLocation, _EmberObject);
    function HistoryLocation() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this.implementation = 'history';
      /**
        Will be pre-pended to path upon state change
               @property rootURL
        @default '/'
        @private
      */

      _this.rootURL = '/';
      return _this;
    }
    /**
      @private
         Returns normalized location.hash
         @method getHash
    */
    var _proto = HistoryLocation.prototype;
    _proto.getHash = function getHash() {
      return (0, _util.getHash)(this.location);
    };
    _proto.init = function init() {
      this._super.apply(this, arguments);
      var base = document.querySelector('base');
      var baseURL = '';
      if (base !== null && base.hasAttribute('href')) {
        baseURL = base.getAttribute('href');
      }
      (0, _metal.set)(this, 'baseURL', baseURL);
      (0, _metal.set)(this, 'location', this.location || window.location);
      this._popstateHandler = undefined;
    }
    /**
      Used to set state on first call to setURL
         @private
      @method initState
    */;
    _proto.initState = function initState() {
      var history = this.history || window.history;
      (0, _metal.set)(this, 'history', history);
      var state = history.state;
      var path = this.formatURL(this.getURL());
      if (state && state.path === path) {
        // preserve existing state
        // used for webkit workaround, since there will be no initial popstate event
        this._previousURL = this.getURL();
      } else {
        this.replaceState(path);
      }
    }
    /**
      Returns the current `location.pathname` without `rootURL` or `baseURL`
         @private
      @method getURL
      @return url {String}
    */;
    _proto.getURL = function getURL() {
      var location = this.location,
        rootURL = this.rootURL,
        baseURL = this.baseURL;
      var path = location.pathname; // remove trailing slashes if they exists

      rootURL = rootURL.replace(/\/$/, '');
      baseURL = baseURL.replace(/\/$/, ''); // remove baseURL and rootURL from start of path

      var url = path.replace(new RegExp("^" + baseURL + "(?=/|$)"), '').replace(new RegExp("^" + rootURL + "(?=/|$)"), '').replace(/\/\//g, '/'); // remove extra slashes

      var search = location.search || '';
      url += search + this.getHash();
      return url;
    }
    /**
      Uses `history.pushState` to update the url without a page reload.
         @private
      @method setURL
      @param path {String}
    */;
    _proto.setURL = function setURL(path) {
      var state = this.history.state;
      path = this.formatURL(path);
      if (!state || state.path !== path) {
        this.pushState(path);
      }
    }
    /**
      Uses `history.replaceState` to update the url without a page reload
      or history modification.
         @private
      @method replaceURL
      @param path {String}
    */;
    _proto.replaceURL = function replaceURL(path) {
      var state = this.history.state;
      path = this.formatURL(path);
      if (!state || state.path !== path) {
        this.replaceState(path);
      }
    }
    /**
     Pushes a new state.
        @private
     @method pushState
     @param path {String}
    */;
    _proto.pushState = function pushState(path) {
      var state = {
        path: path,
        uuid: _uuid()
      };
      this.history.pushState(state, null, path); // used for webkit workaround

      this._previousURL = this.getURL();
    }
    /**
     Replaces the current state.
        @private
     @method replaceState
     @param path {String}
    */;
    _proto.replaceState = function replaceState(path) {
      var state = {
        path: path,
        uuid: _uuid()
      };
      this.history.replaceState(state, null, path); // used for webkit workaround

      this._previousURL = this.getURL();
    }
    /**
      Register a callback to be invoked whenever the browser
      history changes, including using forward and back buttons.
         @private
      @method onUpdateURL
      @param callback {Function}
    */;
    _proto.onUpdateURL = function onUpdateURL(callback) {
      var _this2 = this;
      this._removeEventListener();
      this._popstateHandler = function () {
        // Ignore initial page load popstate event in Chrome
        if (!popstateFired) {
          popstateFired = true;
          if (_this2.getURL() === _this2._previousURL) {
            return;
          }
        }
        callback(_this2.getURL());
      };
      window.addEventListener('popstate', this._popstateHandler);
    }
    /**
      Used when using `{{action}}` helper.  The url is always appended to the rootURL.
         @private
      @method formatURL
      @param url {String}
      @return formatted url {String}
    */;
    _proto.formatURL = function formatURL(url) {
      var rootURL = this.rootURL,
        baseURL = this.baseURL;
      if (url !== '') {
        // remove trailing slashes if they exists
        rootURL = rootURL.replace(/\/$/, '');
        baseURL = baseURL.replace(/\/$/, '');
      } else if (baseURL[0] === '/' && rootURL[0] === '/') {
        // if baseURL and rootURL both start with a slash
        // ... remove trailing slash from baseURL if it exists
        baseURL = baseURL.replace(/\/$/, '');
      }
      return baseURL + rootURL + url;
    }
    /**
      Cleans up the HistoryLocation event listener.
         @private
      @method willDestroy
    */;
    _proto.willDestroy = function willDestroy() {
      this._removeEventListener();
    };
    _proto._removeEventListener = function _removeEventListener() {
      if (this._popstateHandler) {
        window.removeEventListener('popstate', this._popstateHandler);
      }
    };
    return HistoryLocation;
  }(_runtime.Object);
  _exports.default = HistoryLocation;
});
define("@ember/-internals/routing/lib/location/none_location", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/runtime", "@ember/debug"], function (_exports, _emberBabel, _metal, _runtime, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/routing
  */
  /**
    NoneLocation does not interact with the browser. It is useful for
    testing, or when you need to manage state with your Router, but temporarily
    don't want it to muck with the URL (for example when you embed your
    application in a larger page).
  
    Using `NoneLocation` causes Ember to not store the applications URL state
    in the actual URL. This is generally used for testing purposes, and is one
    of the changes made when calling `App.setupForTesting()`.
  
    @class NoneLocation
    @extends EmberObject
    @protected
  */
  var NoneLocation = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(NoneLocation, _EmberObject);
    function NoneLocation() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this.implementation = 'none';
      return _this;
    }
    var _proto = NoneLocation.prototype;
    _proto.detect = function detect() {
      var rootURL = this.rootURL;
      (true && !(rootURL.charAt(rootURL.length - 1) === '/') && (0, _debug.assert)('rootURL must end with a trailing forward slash e.g. "/app/"', rootURL.charAt(rootURL.length - 1) === '/'));
    }
    /**
      Returns the current path without `rootURL`.
         @private
      @method getURL
      @return {String} path
    */;
    _proto.getURL = function getURL() {
      var path = this.path,
        rootURL = this.rootURL; // remove trailing slashes if they exists

      rootURL = rootURL.replace(/\/$/, ''); // remove rootURL from url

      return path.replace(new RegExp("^" + rootURL + "(?=/|$)"), '');
    }
    /**
      Set the path and remembers what was set. Using this method
      to change the path will not invoke the `updateURL` callback.
         @private
      @method setURL
      @param path {String}
    */;
    _proto.setURL = function setURL(path) {
      (0, _metal.set)(this, 'path', path);
    }
    /**
      Register a callback to be invoked when the path changes. These
      callbacks will execute when the user presses the back or forward
      button, but not after `setURL` is invoked.
         @private
      @method onUpdateURL
      @param callback {Function}
    */;
    _proto.onUpdateURL = function onUpdateURL(callback) {
      this.updateCallback = callback;
    }
    /**
      Sets the path and calls the `updateURL` callback.
         @private
      @method handleURL
      @param url {String}
    */;
    _proto.handleURL = function handleURL(url) {
      (0, _metal.set)(this, 'path', url);
      this.updateCallback(url);
    }
    /**
      Given a URL, formats it to be placed into the page as part
      of an element's `href` attribute.
         This is used, for example, when using the {{action}} helper
      to generate a URL based on an event.
         @private
      @method formatURL
      @param url {String}
      @return {String} url
    */;
    _proto.formatURL = function formatURL(url) {
      var rootURL = this.rootURL;
      if (url !== '') {
        // remove trailing slashes if they exists
        rootURL = rootURL.replace(/\/$/, '');
      }
      return rootURL + url;
    };
    return NoneLocation;
  }(_runtime.Object);
  _exports.default = NoneLocation;
  NoneLocation.reopen({
    path: '',
    /**
      Will be pre-pended to path.
         @private
      @property rootURL
      @default '/'
    */
    rootURL: '/'
  });
});
define("@ember/-internals/routing/lib/location/util", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.getFullPath = getFullPath;
  _exports.getHash = getHash;
  _exports.getOrigin = getOrigin;
  _exports.getPath = getPath;
  _exports.getQuery = getQuery;
  _exports.replacePath = replacePath;
  _exports.supportsHashChange = supportsHashChange;
  _exports.supportsHistory = supportsHistory;
  /**
    @private
  
    Returns the current `location.pathname`, normalized for IE inconsistencies.
  */
  function getPath(location) {
    var pathname = location.pathname; // Various versions of IE/Opera don't always return a leading slash

    if (pathname[0] !== '/') {
      pathname = "/" + pathname;
    }
    return pathname;
  }
  /**
    @private
  
    Returns the current `location.search`.
  */

  function getQuery(location) {
    return location.search;
  }
  /**
    @private
  
    Returns the hash or empty string
  */

  function getHash(location) {
    if (location.hash !== undefined) {
      return location.hash.substr(0);
    }
    return '';
  }
  function getFullPath(location) {
    return getPath(location) + getQuery(location) + getHash(location);
  }
  function getOrigin(location) {
    var origin = location.origin; // Older browsers, especially IE, don't have origin

    if (!origin) {
      origin = location.protocol + "//" + location.hostname;
      if (location.port) {
        origin += ":" + location.port;
      }
    }
    return origin;
  }
  /*
    `documentMode` only exist in Internet Explorer, and it's tested because IE8 running in
    IE7 compatibility mode claims to support `onhashchange` but actually does not.
  
    `global` is an object that may have an `onhashchange` property.
  
    @private
    @function supportsHashChange
  */

  function supportsHashChange(documentMode, global) {
    return global && 'onhashchange' in global && (documentMode === undefined || documentMode > 7);
  }
  /*
    `userAgent` is a user agent string. We use user agent testing here, because
    the stock Android browser is known to have buggy versions of the History API,
    in some Android versions.
  
    @private
    @function supportsHistory
  */

  function supportsHistory(userAgent, history) {
    // Boosted from Modernizr: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/history.js
    // The stock browser on Android 2.2 & 2.3, and 4.0.x returns positive on history support
    // Unfortunately support is really buggy and there is no clean way to detect
    // these bugs, so we fall back to a user agent sniff :(
    // We only want Android 2 and 4.0, stock browser, and not Chrome which identifies
    // itself as 'Mobile Safari' as well, nor Windows Phone.
    if ((userAgent.indexOf('Android 2.') !== -1 || userAgent.indexOf('Android 4.0') !== -1) && userAgent.indexOf('Mobile Safari') !== -1 && userAgent.indexOf('Chrome') === -1 && userAgent.indexOf('Windows Phone') === -1) {
      return false;
    }
    return Boolean(history && 'pushState' in history);
  }
  /**
    Replaces the current location, making sure we explicitly include the origin
    to prevent redirecting to a different origin.
  
    @private
  */

  function replacePath(location, path) {
    location.replace(getOrigin(location) + path);
  }
});
define("@ember/-internals/routing/lib/services/router", ["exports", "ember-babel", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/debug", "@ember/object/computed", "@ember/polyfills", "@ember/service", "@glimmer/validator", "@ember/-internals/routing/lib/utils"], function (_exports, _emberBabel, _owner, _runtime, _utils, _debug, _computed, _polyfills, _service, _validator, _utils2) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var ROUTER = (0, _utils.symbol)('ROUTER');
  var freezeRouteInfo;
  if (true /* DEBUG */) {
    freezeRouteInfo = function freezeRouteInfo(transition) {
      if (transition.from !== null && !Object.isFrozen(transition.from)) {
        Object.freeze(transition.from);
      }
      if (transition.to !== null && !Object.isFrozen(transition.to)) {
        Object.freeze(transition.to);
      }
    };
  }
  function cleanURL(url, rootURL) {
    if (rootURL === '/') {
      return url;
    }
    return url.substr(rootURL.length, url.length);
  }
  /**
     The Router service is the public API that provides access to the router.
  
     The immediate benefit of the Router service is that you can inject it into components,
     giving them a friendly way to initiate transitions and ask questions about the current
     global router state.
  
     In this example, the Router service is injected into a component to initiate a transition
     to a dedicated route:
  
     ```app/components/example.js
     import Component from '@glimmer/component';
     import { action } from '@ember/object';
     import { inject as service } from '@ember/service';
  
     export default class ExampleComponent extends Component {
       @service router;
  
       @action
       next() {
         this.router.transitionTo('other.route');
       }
     }
     ```
  
     Like any service, it can also be injected into helpers, routes, etc.
  
     @public
     @extends Service
     @class RouterService
   */
  var RouterService = /*#__PURE__*/function (_Service) {
    (0, _emberBabel.inheritsLoose)(RouterService, _Service);
    function RouterService(owner) {
      var _this;
      _this = _Service.call(this, owner) || this;
      var router = owner.lookup('router:main');
      router.on('routeWillChange', function (transition) {
        if (true /* DEBUG */) {
          freezeRouteInfo(transition);
        }
        _this.trigger('routeWillChange', transition);
      });
      router.on('routeDidChange', function (transition) {
        if (true /* DEBUG */) {
          freezeRouteInfo(transition);
        }
        _this.trigger('routeDidChange', transition);
      });
      return _this;
    }
    var _proto = RouterService.prototype;
    _proto.willDestroy = function willDestroy() {
      _Service.prototype.willDestroy.apply(this, arguments);
      this[ROUTER] = null;
    }
    /**
       Transition the application into another route. The route may
       be either a single route or route path:
          See [transitionTo](/ember/release/classes/Route/methods/transitionTo?anchor=transitionTo) for more info.
          Calling `transitionTo` from the Router service will cause default query parameter values to be included in the URL.
       This behavior is different from calling `transitionTo` on a route or `transitionToRoute` on a controller.
       See the [Router Service RFC](https://github.com/emberjs/rfcs/blob/master/text/0095-router-service.md#query-parameter-semantics) for more info.
          In the following example we use the Router service to navigate to a route with a
       specific model from a Component in the first action, and in the second we trigger
       a query-params only transition.
          ```app/components/example.js
       import Component from '@glimmer/component';
       import { action } from '@ember/object';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
            @action
         goToComments(post) {
           this.router.transitionTo('comments', post);
         }
            @action
         fetchMoreComments(latestComment) {
           this.router.transitionTo({
             queryParams: { commentsAfter: latestComment }
           });
         }
       }
       ```
          @method transitionTo
       @param {String} [routeNameOrUrl] the name of the route or a URL
       @param {...Object} [models] the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters. May be supplied as the only
        parameter to trigger a query-parameter-only transition.
       @return {Transition} the transition object associated with this
         attempted transition
       @public
     */;
    _proto.transitionTo = function transitionTo() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      if ((0, _utils2.resemblesURL)(args[0])) {
        // NOTE: this `args[0] as string` cast is safe and TS correctly infers it
        // in 3.6+, so it can be removed when TS is upgraded.
        return this._router._doURLTransition('transitionTo', args[0]);
      }
      var _extractRouteArgs = (0, _utils2.extractRouteArgs)(args),
        routeName = _extractRouteArgs.routeName,
        models = _extractRouteArgs.models,
        queryParams = _extractRouteArgs.queryParams;
      var transition = this._router._doTransition(routeName, models, queryParams, true);
      transition['_keepDefaultQueryParamValues'] = true;
      return transition;
    }
    /**
       Similar to `transitionTo`, but instead of adding the destination to the browser's URL history,
       it replaces the entry for the current route.
       When the user clicks the "back" button in the browser, there will be fewer steps.
       This is most commonly used to manage redirects in a way that does not cause confusing additions
       to the user's browsing history.
          See [replaceWith](/ember/release/classes/Route/methods/replaceWith?anchor=replaceWith) for more info.
          Calling `replaceWith` from the Router service will cause default query parameter values to be included in the URL.
       This behavior is different from calling `replaceWith` on a route.
       See the [Router Service RFC](https://github.com/emberjs/rfcs/blob/master/text/0095-router-service.md#query-parameter-semantics) for more info.
          Usage example:
          ```app/routes/application.js
       import Route from '@ember/routing/route';
          export default class extends Route {
         beforeModel() {
           if (!authorized()){
             this.replaceWith('unauthorized');
           }
         }
       });
       ```
          @method replaceWith
       @param {String} routeNameOrUrl the name of the route or a URL of the desired destination
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route i.e. an object of params to pass to the destination route
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {Transition} the transition object associated with this
         attempted transition
       @public
     */;
    _proto.replaceWith = function replaceWith() /* routeNameOrUrl, ...models, options */
    {
      return this.transitionTo.apply(this, arguments).method('replace');
    }
    /**
      Generate a URL based on the supplied route name and optionally a model. The
      URL is returned as a string that can be used for any purpose.
         In this example, the URL for the `author.books` route for a given author
      is copied to the clipboard.
         ```app/templates/application.hbs
      <CopyLink @author={{hash id="tomster" name="Tomster"}} />
      ```
         ```app/components/copy-link.js
      import Component from '@glimmer/component';
      import { inject as service } from '@ember/service';
      import { action } from '@ember/object';
         export default class CopyLinkComponent extends Component {
        @service router;
        @service clipboard;
           @action
        copyBooksURL() {
          if (this.author) {
            const url = this.router.urlFor('author.books', this.args.author);
            this.clipboard.set(url);
            // Clipboard now has /author/tomster/books
          }
        }
      }
      ```
         Just like with `transitionTo` and `replaceWith`, `urlFor` can also handle
      query parameters.
         ```app/templates/application.hbs
      <CopyLink @author={{hash id="tomster" name="Tomster"}} />
      ```
         ```app/components/copy-link.js
      import Component from '@glimmer/component';
      import { inject as service } from '@ember/service';
      import { action } from '@ember/object';
         export default class CopyLinkComponent extends Component {
        @service router;
        @service clipboard;
           @action
        copyOnlyEmberBooksURL() {
          if (this.author) {
            const url = this.router.urlFor('author.books', this.author, {
              queryParams: { filter: 'emberjs' }
            });
            this.clipboard.set(url);
            // Clipboard now has /author/tomster/books?filter=emberjs
          }
        }
      }
      ```
          @method urlFor
       @param {String} routeName the name of the route
       @param {...Object} models the model(s) or identifier(s) to be used while
         transitioning to the route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {String} the string representing the generated URL
       @public
     */;
    _proto.urlFor = function urlFor(routeName) {
      var _this$_router;
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }
      return (_this$_router = this._router).generate.apply(_this$_router, [routeName].concat(args));
    }
    /**
       Returns `true` if `routeName/models/queryParams` is the active route, where `models` and `queryParams` are optional.
       See [model](api/ember/release/classes/Route/methods/model?anchor=model) and
       [queryParams](/api/ember/3.7/classes/Route/properties/queryParams?anchor=queryParams) for more information about these arguments.
          In the following example, `isActive` will return `true` if the current route is `/posts`.
          ```app/components/posts.js
       import Component from '@glimmer/component';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
            displayComments() {
           return this.router.isActive('posts');
         }
       });
       ```
          The next example includes a dynamic segment, and will return `true` if the current route is `/posts/1`,
       assuming the post has an id of 1:
          ```app/components/posts.js
       import Component from '@glimmer/component';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
            displayComments(post) {
           return this.router.isActive('posts', post.id);
         }
       });
       ```
          Where `post.id` is the id of a specific post, which is represented in the route as /posts/[post.id].
       If `post.id` is equal to 1, then isActive will return true if the current route is /posts/1, and false if the route is anything else.
          @method isActive
       @param {String} routeName the name of the route
       @param {...Object} models the model(s) or identifier(s) to be used when determining the active route.
       @param {Object} [options] optional hash with a queryParams property
         containing a mapping of query parameters
       @return {boolean} true if the provided routeName/models/queryParams are active
       @public
     */;
    _proto.isActive = function isActive() {
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }
      var _extractRouteArgs2 = (0, _utils2.extractRouteArgs)(args),
        routeName = _extractRouteArgs2.routeName,
        models = _extractRouteArgs2.models,
        queryParams = _extractRouteArgs2.queryParams;
      var routerMicrolib = this._router._routerMicrolib; // When using isActive() in a getter, we want to entagle with the auto-tracking system
      // for example,
      // in
      // get isBarActive() {
      //   return isActive('foo.bar');
      // }
      //
      // you'd expect isBarActive to be dirtied when the route changes.
      //
      // https://github.com/emberjs/ember.js/issues/19004

      (0, _validator.consumeTag)((0, _validator.tagFor)(this._router, 'currentURL')); // UNSAFE: casting `routeName as string` here encodes the existing
      // assumption but may be wrong: `extractRouteArgs` correctly returns it as
      // `string | undefined`. There may be bugs if `isActiveIntent` does
      // not correctly account for `undefined` values for `routeName`. Spoilers:
      // it *does not* account for this being `undefined`.

      if (!routerMicrolib.isActiveIntent(routeName, models)) {
        return false;
      }
      var hasQueryParams = Object.keys(queryParams).length > 0;
      if (hasQueryParams) {
        queryParams = (0, _polyfills.assign)({}, queryParams);
        this._router._prepareQueryParams(
        // UNSAFE: casting `routeName as string` here encodes the existing
        // assumption but may be wrong: `extractRouteArgs` correctly returns it
        // as `string | undefined`. There may be bugs if `_prepareQueryParams`
        // does not correctly account for `undefined` values for `routeName`.
        //  Spoilers: under the hood this currently uses router.js APIs which
        // *do not* account for this being `undefined`.
        routeName, models,
        // UNSAFE: downstream consumers treat this as `QueryParam`, which the
        // type system here *correctly* reports as incorrect, because it may be
        // just an empty object.
        queryParams, true
        /* fromRouterService */);

        return (0, _utils2.shallowEqual)(queryParams, routerMicrolib.state.queryParams);
      }
      return true;
    }
    /**
       Takes a string URL and returns a `RouteInfo` for the leafmost route represented
       by the URL. Returns `null` if the URL is not recognized. This method expects to
       receive the actual URL as seen by the browser including the app's `rootURL`.
          See [RouteInfo](/ember/release/classes/RouteInfo) for more info.
          In the following example `recognize` is used to verify if a path belongs to our
       application before transitioning to it.
          ```
       import Component from '@ember/component';
       import { inject as service } from '@ember/service';
          export default class extends Component {
         @service router;
         path = '/';
            click() {
           if (this.router.recognize(this.path)) {
             this.router.transitionTo(this.path);
           }
         }
       }
       ```
           @method recognize
        @param {String} url
        @public
      */;
    _proto.recognize = function recognize(url) {
      (true && !(url.indexOf(this.rootURL) === 0) && (0, _debug.assert)("You must pass a url that begins with the application's rootURL \"" + this.rootURL + "\"", url.indexOf(this.rootURL) === 0));
      var internalURL = cleanURL(url, this.rootURL);
      return this._router._routerMicrolib.recognize(internalURL);
    }
    /**
      Takes a string URL and returns a promise that resolves to a
      `RouteInfoWithAttributes` for the leafmost route represented by the URL.
      The promise rejects if the URL is not recognized or an unhandled exception
      is encountered. This method expects to receive the actual URL as seen by
      the browser including the app's `rootURL`.
           @method recognizeAndLoad
        @param {String} url
        @public
     */;
    _proto.recognizeAndLoad = function recognizeAndLoad(url) {
      (true && !(url.indexOf(this.rootURL) === 0) && (0, _debug.assert)("You must pass a url that begins with the application's rootURL \"" + this.rootURL + "\"", url.indexOf(this.rootURL) === 0));
      var internalURL = cleanURL(url, this.rootURL);
      return this._router._routerMicrolib.recognizeAndLoad(internalURL);
    };
    (0, _emberBabel.createClass)(RouterService, [{
      key: "_router",
      get: function get() {
        var router = this[ROUTER];
        if (router !== undefined) {
          return router;
        }
        var owner = (0, _owner.getOwner)(this);
        router = owner.lookup('router:main');
        router.setupRouter();
        return this[ROUTER] = router;
      }
    }]);
    return RouterService;
  }(_service.default);
  _exports.default = RouterService;
  RouterService.reopen(_runtime.Evented, {
    /**
       Name of the current route.
          This property represents the logical name of the route,
       which is comma separated.
       For the following router:
          ```app/router.js
       Router.map(function() {
         this.route('about');
         this.route('blog', function () {
           this.route('post', { path: ':post_id' });
         });
       });
       ```
          It will return:
          * `index` when you visit `/`
       * `about` when you visit `/about`
       * `blog.index` when you visit `/blog`
       * `blog.post` when you visit `/blog/some-post-id`
          @property currentRouteName
       @type String
       @public
     */
    currentRouteName: (0, _computed.readOnly)('_router.currentRouteName'),
    /**
       Current URL for the application.
         This property represents the URL path for this route.
      For the following router:
          ```app/router.js
       Router.map(function() {
         this.route('about');
         this.route('blog', function () {
           this.route('post', { path: ':post_id' });
         });
       });
       ```
          It will return:
          * `/` when you visit `/`
       * `/about` when you visit `/about`
       * `/blog` when you visit `/blog`
       * `/blog/some-post-id` when you visit `/blog/some-post-id`
          @property currentURL
       @type String
       @public
     */
    currentURL: (0, _computed.readOnly)('_router.currentURL'),
    /**
      The `location` property returns what implementation of the `location` API
      your application is using, which determines what type of URL is being used.
         See [Location](/ember/release/classes/Location) for more information.
         To force a particular `location` API implementation to be used in your
      application you can set a location type on your `config/environment`.
      For example, to set the `history` type:
         ```config/environment.js
      'use strict';
         module.exports = function(environment) {
        let ENV = {
          modulePrefix: 'router-service',
          environment,
          rootURL: '/',
          locationType: 'history',
          ...
        }
      }
      ```
         The following location types are available by default:
      `auto`, `hash`, `history`, `none`.
         See [HashLocation](/ember/release/classes/HashLocation).
      See [HistoryLocation](/ember/release/classes/HistoryLocation).
      See [NoneLocation](/ember/release/classes/NoneLocation).
      See [AutoLocation](/ember/release/classes/AutoLocation).
         @property location
      @default 'hash'
      @see {Location}
      @public
    */
    location: (0, _computed.readOnly)('_router.location'),
    /**
      The `rootURL` property represents the URL of the root of
      the application, '/' by default.
      This prefix is assumed on all routes defined on this app.
         If you change the `rootURL` in your environment configuration
      like so:
         ```config/environment.js
      'use strict';
         module.exports = function(environment) {
        let ENV = {
          modulePrefix: 'router-service',
          environment,
          rootURL: '/my-root',
        …
        }
      ]
      ```
         This property will return `/my-root`.
         @property rootURL
      @default '/'
      @public
    */
    rootURL: (0, _computed.readOnly)('_router.rootURL'),
    /**
      The `currentRoute` property contains metadata about the current leaf route.
      It returns a `RouteInfo` object that has information like the route name,
      params, query params and more.
         See [RouteInfo](/ember/release/classes/RouteInfo) for more info.
         This property is guaranteed to change whenever a route transition
      happens (even when that transition only changes parameters
      and doesn't change the active route).
         Usage example:
      ```app/components/header.js
        import Component from '@glimmer/component';
        import { inject as service } from '@ember/service';
        import { notEmpty } from '@ember/object/computed';
           export default class extends Component {
          @service router;
             @notEmpty('router.currentRoute.child') isChildRoute;
        });
      ```
          @property currentRoute
       @type RouteInfo
       @public
     */
    currentRoute: (0, _computed.readOnly)('_router.currentRoute')
  });
});
define("@ember/-internals/routing/lib/services/routing", ["exports", "ember-babel", "@ember/-internals/owner", "@ember/-internals/utils", "@ember/object/computed", "@ember/polyfills", "@ember/service"], function (_exports, _emberBabel, _owner, _utils, _computed, _polyfills, _service) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */

  var ROUTER = (0, _utils.symbol)('ROUTER');
  /**
    The Routing service is used by LinkComponent, and provides facilities for
    the component/view layer to interact with the router.
  
    This is a private service for internal usage only. For public usage,
    refer to the `Router` service.
  
    @private
    @class RoutingService
  */
  var RoutingService = /*#__PURE__*/function (_Service) {
    (0, _emberBabel.inheritsLoose)(RoutingService, _Service);
    function RoutingService() {
      return _Service.apply(this, arguments) || this;
    }
    var _proto = RoutingService.prototype;
    _proto.hasRoute = function hasRoute(routeName) {
      return this.router.hasRoute(routeName);
    };
    _proto.transitionTo = function transitionTo(routeName, models, queryParams, shouldReplace) {
      var transition = this.router._doTransition(routeName, models, queryParams);
      if (shouldReplace) {
        transition.method('replace');
      }
      return transition;
    };
    _proto.normalizeQueryParams = function normalizeQueryParams(routeName, models, queryParams) {
      this.router._prepareQueryParams(routeName, models, queryParams);
    };
    _proto._generateURL = function _generateURL(routeName, models, queryParams) {
      var _this$router;
      var visibleQueryParams = {};
      if (queryParams) {
        (0, _polyfills.assign)(visibleQueryParams, queryParams);
        this.normalizeQueryParams(routeName, models, visibleQueryParams);
      }
      return (_this$router = this.router).generate.apply(_this$router, [routeName].concat(models, [{
        queryParams: visibleQueryParams
      }]));
    };
    _proto.generateURL = function generateURL(routeName, models, queryParams) {
      if (this.router._initialTransitionStarted) {
        return this._generateURL(routeName, models, queryParams);
      } else {
        // Swallow error when transition has not started.
        // When rendering in tests without visit(), we cannot infer the route context which <LinkTo/> needs be aware of
        try {
          return this._generateURL(routeName, models, queryParams);
        } catch (_e) {
          return;
        }
      }
    };
    _proto.isActiveForRoute = function isActiveForRoute(contexts, queryParams, routeName, routerState) {
      var handlers = this.router._routerMicrolib.recognizer.handlersFor(routeName);
      var leafName = handlers[handlers.length - 1].handler;
      var maximumContexts = numberOfContextsAcceptedByHandler(routeName, handlers); // NOTE: any ugliness in the calculation of activeness is largely
      // due to the fact that we support automatic normalizing of
      // `resource` -> `resource.index`, even though there might be
      // dynamic segments / query params defined on `resource.index`
      // which complicates (and makes somewhat ambiguous) the calculation
      // of activeness for links that link to `resource` instead of
      // directly to `resource.index`.
      // if we don't have enough contexts revert back to full route name
      // this is because the leaf route will use one of the contexts

      if (contexts.length > maximumContexts) {
        routeName = leafName;
      }
      return routerState.isActiveIntent(routeName, contexts, queryParams);
    };
    (0, _emberBabel.createClass)(RoutingService, [{
      key: "router",
      get: function get() {
        var router = this[ROUTER];
        if (router !== undefined) {
          return router;
        }
        var owner = (0, _owner.getOwner)(this);
        router = owner.lookup('router:main');
        router.setupRouter();
        return this[ROUTER] = router;
      }
    }]);
    return RoutingService;
  }(_service.default);
  _exports.default = RoutingService;
  RoutingService.reopen({
    targetState: (0, _computed.readOnly)('router.targetState'),
    currentState: (0, _computed.readOnly)('router.currentState'),
    currentRouteName: (0, _computed.readOnly)('router.currentRouteName'),
    currentPath: (0, _computed.readOnly)('router.currentPath')
  });
  function numberOfContextsAcceptedByHandler(handlerName, handlerInfos) {
    var req = 0;
    for (var i = 0; i < handlerInfos.length; i++) {
      req += handlerInfos[i].names.length;
      if (handlerInfos[i].handler === handlerName) {
        break;
      }
    }
    return req;
  }
});
define("@ember/-internals/routing/lib/system/cache", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
    A two-tiered cache with support for fallback values when doing lookups.
    Uses "buckets" and then "keys" to cache values.
  
    @private
    @class BucketCache
  */
  var BucketCache = /*#__PURE__*/function () {
    function BucketCache() {
      this.cache = new Map();
    }
    var _proto = BucketCache.prototype;
    _proto.has = function has(bucketKey) {
      return this.cache.has(bucketKey);
    };
    _proto.stash = function stash(bucketKey, key, value) {
      var bucket = this.cache.get(bucketKey);
      if (bucket === undefined) {
        bucket = new Map();
        this.cache.set(bucketKey, bucket);
      }
      bucket.set(key, value);
    };
    _proto.lookup = function lookup(bucketKey, prop, defaultValue) {
      if (!this.has(bucketKey)) {
        return defaultValue;
      }
      var bucket = this.cache.get(bucketKey);
      if (bucket.has(prop)) {
        return bucket.get(prop);
      } else {
        return defaultValue;
      }
    };
    return BucketCache;
  }();
  _exports.default = BucketCache;
});
define("@ember/-internals/routing/lib/system/controller_for", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = controllerFor;
  /**
  @module ember
  */

  /**
    Finds a controller instance.
  
    @for Ember
    @method controllerFor
    @private
  */
  function controllerFor(container, controllerName, lookupOptions) {
    return container.lookup("controller:" + controllerName, lookupOptions);
  }
});
define("@ember/-internals/routing/lib/system/dsl", ["exports", "@ember/debug", "@ember/polyfills"], function (_exports, _debug, _polyfills) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var uuid = 0;
  function isCallback(value) {
    return typeof value === 'function';
  }
  function isOptions(value) {
    return value !== null && typeof value === 'object';
  }
  var DSLImpl = /*#__PURE__*/function () {
    function DSLImpl(name, options) {
      if (name === void 0) {
        name = null;
      }
      this.explicitIndex = false;
      this.parent = name;
      this.enableLoadingSubstates = Boolean(options && options.enableLoadingSubstates);
      this.matches = [];
      this.options = options;
    }
    var _proto = DSLImpl.prototype;
    _proto.route = function route(name, _options, _callback) {
      var options;
      var callback = null;
      var dummyErrorRoute = "/_unused_dummy_error_path_route_" + name + "/:error";
      if (isCallback(_options)) {
        (true && !(arguments.length === 2) && (0, _debug.assert)('Unexpected arguments', arguments.length === 2));
        options = {};
        callback = _options;
      } else if (isCallback(_callback)) {
        (true && !(arguments.length === 3) && (0, _debug.assert)('Unexpected arguments', arguments.length === 3));
        (true && !(isOptions(_options)) && (0, _debug.assert)('Unexpected arguments', isOptions(_options)));
        options = _options;
        callback = _callback;
      } else {
        options = _options || {};
      }
      (true && !(function () {
        if (options.overrideNameAssertion === true) {
          return true;
        }
        return ['basic', 'application'].indexOf(name) === -1;
      }()) && (0, _debug.assert)("'" + name + "' cannot be used as a route name.", function () {
        if (options.overrideNameAssertion === true) {
          return true;
        }
        return ['basic', 'application'].indexOf(name) === -1;
      }()));
      (true && !(name.indexOf(':') === -1) && (0, _debug.assert)("'" + name + "' is not a valid route name. It cannot contain a ':'. You may want to use the 'path' option instead.", name.indexOf(':') === -1));
      if (this.enableLoadingSubstates) {
        createRoute(this, name + "_loading", {
          resetNamespace: options.resetNamespace
        });
        createRoute(this, name + "_error", {
          resetNamespace: options.resetNamespace,
          path: dummyErrorRoute
        });
      }
      if (callback) {
        var fullName = getFullName(this, name, options.resetNamespace);
        var dsl = new DSLImpl(fullName, this.options);
        createRoute(dsl, 'loading');
        createRoute(dsl, 'error', {
          path: dummyErrorRoute
        });
        callback.call(dsl);
        createRoute(this, name, options, dsl.generate());
      } else {
        createRoute(this, name, options);
      }
    };
    _proto.push = function push(url, name, callback, serialize) {
      var parts = name.split('.');
      if (this.options.engineInfo) {
        var localFullName = name.slice(this.options.engineInfo.fullName.length + 1);
        var routeInfo = (0, _polyfills.assign)({
          localFullName: localFullName
        }, this.options.engineInfo);
        if (serialize) {
          routeInfo.serializeMethod = serialize;
        }
        this.options.addRouteForEngine(name, routeInfo);
      } else if (serialize) {
        throw new Error("Defining a route serializer on route '" + name + "' outside an Engine is not allowed.");
      }
      if (url === '' || url === '/' || parts[parts.length - 1] === 'index') {
        this.explicitIndex = true;
      }
      this.matches.push(url, name, callback);
    };
    _proto.generate = function generate() {
      var dslMatches = this.matches;
      if (!this.explicitIndex) {
        this.route('index', {
          path: '/'
        });
      }
      return function (match) {
        for (var i = 0; i < dslMatches.length; i += 3) {
          match(dslMatches[i]).to(dslMatches[i + 1], dslMatches[i + 2]);
        }
      };
    };
    _proto.mount = function mount(_name, options) {
      if (options === void 0) {
        options = {};
      }
      var engineRouteMap = this.options.resolveRouteMap(_name);
      var name = _name;
      if (options.as) {
        name = options.as;
      }
      var fullName = getFullName(this, name, options.resetNamespace);
      var engineInfo = {
        name: _name,
        instanceId: uuid++,
        mountPoint: fullName,
        fullName: fullName
      };
      var path = options.path;
      if (typeof path !== 'string') {
        path = "/" + name;
      }
      var callback;
      var dummyErrorRoute = "/_unused_dummy_error_path_route_" + name + "/:error";
      if (engineRouteMap) {
        var shouldResetEngineInfo = false;
        var oldEngineInfo = this.options.engineInfo;
        if (oldEngineInfo) {
          shouldResetEngineInfo = true;
          this.options.engineInfo = engineInfo;
        }
        var optionsForChild = (0, _polyfills.assign)({
          engineInfo: engineInfo
        }, this.options);
        var childDSL = new DSLImpl(fullName, optionsForChild);
        createRoute(childDSL, 'loading');
        createRoute(childDSL, 'error', {
          path: dummyErrorRoute
        });
        engineRouteMap.class.call(childDSL);
        callback = childDSL.generate();
        if (shouldResetEngineInfo) {
          this.options.engineInfo = oldEngineInfo;
        }
      }
      var localFullName = 'application';
      var routeInfo = (0, _polyfills.assign)({
        localFullName: localFullName
      }, engineInfo);
      if (this.enableLoadingSubstates) {
        // These values are important to register the loading routes under their
        // proper names for the Router and within the Engine's registry.
        var substateName = name + "_loading";
        var _localFullName = "application_loading";
        var _routeInfo = (0, _polyfills.assign)({
          localFullName: _localFullName
        }, engineInfo);
        createRoute(this, substateName, {
          resetNamespace: options.resetNamespace
        });
        this.options.addRouteForEngine(substateName, _routeInfo);
        substateName = name + "_error";
        _localFullName = "application_error";
        _routeInfo = (0, _polyfills.assign)({
          localFullName: _localFullName
        }, engineInfo);
        createRoute(this, substateName, {
          resetNamespace: options.resetNamespace,
          path: dummyErrorRoute
        });
        this.options.addRouteForEngine(substateName, _routeInfo);
      }
      this.options.addRouteForEngine(fullName, routeInfo);
      this.push(path, fullName, callback);
    };
    return DSLImpl;
  }();
  _exports.default = DSLImpl;
  function canNest(dsl) {
    return dsl.parent !== 'application';
  }
  function getFullName(dsl, name, resetNamespace) {
    if (canNest(dsl) && resetNamespace !== true) {
      return dsl.parent + "." + name;
    } else {
      return name;
    }
  }
  function createRoute(dsl, name, options, callback) {
    if (options === void 0) {
      options = {};
    }
    var fullName = getFullName(dsl, name, options.resetNamespace);
    if (typeof options.path !== 'string') {
      options.path = "/" + name;
    }
    dsl.push(options.path, fullName, callback, options.serialize);
  }
});
define("@ember/-internals/routing/lib/system/engines", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
});
define("@ember/-internals/routing/lib/system/generate_controller", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = generateController;
  _exports.generateControllerFactory = generateControllerFactory;
  /**
  @module ember
  */

  /**
    Generates a controller factory
  
    @for Ember
    @method generateControllerFactory
    @private
  */

  function generateControllerFactory(owner, controllerName) {
    var Factory = owner.factoryFor('controller:basic').class;
    Factory = Factory.extend({
      toString: function toString() {
        return "(generated " + controllerName + " controller)";
      }
    });
    var fullName = "controller:" + controllerName;
    owner.register(fullName, Factory);
    return owner.factoryFor(fullName);
  }
  /**
    Generates and instantiates a controller extending from `controller:basic`
    if present, or `Controller` if not.
  
    @for Ember
    @method generateController
    @private
    @since 1.3.0
  */

  function generateController(owner, controllerName) {
    generateControllerFactory(owner, controllerName);
    var fullName = "controller:" + controllerName;
    var instance = owner.lookup(fullName);
    if (true /* DEBUG */) {
      if ((0, _metal.get)(instance, 'namespace.LOG_ACTIVE_GENERATION')) {
        (0, _debug.info)("generated -> " + fullName, {
          fullName: fullName
        });
      }
    }
    return instance;
  }
});
define("@ember/-internals/routing/lib/system/query_params", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var QueryParams = function QueryParams(values) {
    if (values === void 0) {
      values = null;
    }
    this.isQueryParams = true;
    this.values = values;
  };
  _exports.default = QueryParams;
});
define("@ember/-internals/routing/lib/system/route-info", [], function () {
  "use strict";

  /**
    A `RouteInfoWithAttributes` is an object that contains
    metadata, including the resolved value from the routes
    `model` hook. Like `RouteInfo`, a `RouteInfoWithAttributes`
    represents a specific route within a Transition.
    It is read-only and internally immutable. It is also not
    observable, because a Transition instance is never
    changed after creation.
  
    @class RouteInfoWithAttributes
    @public
  */

  /**
    The dot-separated, fully-qualified name of the
    route, like "people.index".
    @property {String} name
    @public
  */

  /**
    The final segment of the fully-qualified name of
    the route, like "index"
    @property {String} localName
    @public
  */

  /**
    The values of the route's parameters. These are the
    same params that are received as arguments to the
    route's model hook. Contains only the parameters
    valid for this route, if any (params for parent or
    child routes are not merged).
    @property {Object} params
    @public
  */

  /**
    The ordered list of the names of the params
    required for this route. It will contain the same
    strings as `Object.keys(params)`, but here the order
    is significant. This allows users to correctly pass
    params into routes programmatically.
    @property {Array} paramNames
    @public
  */

  /**
    The values of any queryParams on this route.
    @property {Object} queryParams
    @public
  */

  /**
    This is the resolved return value from the
    route's model hook.
    @property {Object|Array|String} attributes
    @public
  */

  /**
    Will contain the result `Route#buildRouteInfoMetadata`
    for the corresponding Route.
    @property {Any} metadata
    @public
  */

  /**
    A reference to the parent route's RouteInfo.
    This can be used to traverse upward to the topmost
    `RouteInfo`.
    @property {RouteInfo|null} parent
    @public
  */

  /**
    A reference to the child route's RouteInfo.
    This can be used to traverse downward to the
    leafmost `RouteInfo`.
    @property {RouteInfo|null} child
    @public
  */

  /**
    Allows you to traverse through the linked list
    of `RouteInfo`s from the topmost to leafmost.
    Returns the first `RouteInfo` in the linked list
    for which the callback returns true.
  
      This method is similar to the `find()` method
      defined in ECMAScript 2015.
  
      The callback method you provide should have the
      following signature (all parameters are optional):
  
      ```javascript
      function(item, index, array);
      ```
  
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
  
      It should return the `true` to include the item in
      the results, `false` otherwise.
  
      Note that in addition to a callback, you can also
      pass an optional target object that will be set as
      `this` on the context.
  
    @method find
    @param {Function} callback the callback to execute
    @param {Object} [target*] optional target to use
    @returns {Object} Found item or undefined
    @public
  */

  /**
    A RouteInfo is an object that contains metadata
    about a specific route within a Transition. It is
    read-only and internally immutable. It is also not
    observable, because a Transition instance is never
    changed after creation.
  
    @class RouteInfo
    @public
  */

  /**
    The dot-separated, fully-qualified name of the
    route, like "people.index".
    @property {String} name
    @public
  */

  /**
    The final segment of the fully-qualified name of
    the route, like "index"
    @property {String} localName
    @public
  */

  /**
    The values of the route's parameters. These are the
    same params that are received as arguments to the
    route's `model` hook. Contains only the parameters
    valid for this route, if any (params for parent or
    child routes are not merged).
    @property {Object} params
    @public
  */

  /**
    The ordered list of the names of the params
    required for this route. It will contain the same
    strings as Object.keys(params), but here the order
    is significant. This allows users to correctly pass
    params into routes programmatically.
    @property {Array} paramNames
    @public
  */

  /**
    The values of any queryParams on this route.
    @property {Object} queryParams
    @public
  */

  /**
    Will contain the result `Route#buildRouteInfoMetadata`
    for the corresponding Route.
    @property {Any} metadata
    @public
  */

  /**
    A reference to the parent route's `RouteInfo`.
    This can be used to traverse upward to the topmost
    `RouteInfo`.
    @property {RouteInfo|null} parent
    @public
  */

  /**
    A reference to the child route's `RouteInfo`.
    This can be used to traverse downward to the
    leafmost `RouteInfo`.
    @property {RouteInfo|null} child
    @public
  */

  /**
    Allows you to traverse through the linked list
    of `RouteInfo`s from the topmost to leafmost.
    Returns the first `RouteInfo` in the linked list
    for which the callback returns true.
  
      This method is similar to the `find()` method
      defined in ECMAScript 2015.
  
      The callback method you provide should have the
      following signature (all parameters are optional):
  
      ```javascript
      function(item, index, array);
      ```
  
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
  
      It should return the `true` to include the item in
      the results, `false` otherwise.
  
      Note that in addition to a callback, you can also
      pass an optional target object that will be set as
      `this` on the context.
  
    @method find
    @param {Function} callback the callback to execute
    @param {Object} [target*] optional target to use
    @returns {Object} Found item or undefined
    @public
  */
});
define("@ember/-internals/routing/lib/system/route", ["exports", "@ember/polyfills", "ember-babel", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/-internals/utils", "@ember/debug", "@ember/deprecated-features", "@ember/object/compat", "@ember/runloop", "@ember/string", "router_js", "@ember/-internals/routing/lib/utils", "@ember/-internals/routing/lib/system/generate_controller"], function (_exports, _polyfills, _emberBabel, _metal, _owner, _runtime, _utils, _debug, _deprecatedFeatures, _compat, _runloop, _string, _router_js, _utils2, _generate_controller) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = _exports.ROUTE_CONNECTIONS = _exports.ROUTER_EVENT_DEPRECATIONS = void 0;
  _exports.defaultSerialize = defaultSerialize;
  _exports.getFullQueryParams = getFullQueryParams;
  _exports.hasDefaultSerialize = hasDefaultSerialize;
  var ROUTE_CONNECTIONS = new WeakMap();
  _exports.ROUTE_CONNECTIONS = ROUTE_CONNECTIONS;
  function defaultSerialize(model, params) {
    if (params.length < 1 || !model) {
      return;
    }
    var object = {};
    if (params.length === 1) {
      var name = params[0];
      if (name in model) {
        object[name] = (0, _metal.get)(model, name);
      } else if (/_id$/.test(name)) {
        object[name] = (0, _metal.get)(model, 'id');
      }
    } else {
      object = (0, _metal.getProperties)(model, params);
    }
    return object;
  }
  function hasDefaultSerialize(route) {
    return route.serialize === defaultSerialize;
  }
  /**
  @module @ember/routing
  */

  /**
    The `Route` class is used to define individual routes. Refer to
    the [routing guide](https://guides.emberjs.com/release/routing/) for documentation.
  
    @class Route
    @extends EmberObject
    @uses ActionHandler
    @uses Evented
    @since 1.0.0
    @public
  */
  var Route = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(Route, _EmberObject);
    function Route() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this.context = {};
      return _this;
    }
    /**
      The name of the route, dot-delimited.
         For example, a route found at `app/routes/posts/post.js` will have
      a `routeName` of `posts.post`.
         @property routeName
      @for Route
      @type String
      @since 1.0.0
      @public
    */

    /**
      The name of the route, dot-delimited, including the engine prefix
      if applicable.
         For example, a route found at `addon/routes/posts/post.js` within an
      engine named `admin` will have a `fullRouteName` of `admin.posts.post`.
         @property fullRouteName
      @for Route
      @type String
      @since 2.10.0
      @public
    */

    /**
      Sets the name for this route, including a fully resolved name for routes
      inside engines.
         @private
      @method _setRouteName
      @param {String} name
    */
    var _proto = Route.prototype;
    _proto._setRouteName = function _setRouteName(name) {
      this.routeName = name;
      this.fullRouteName = getEngineRouteName((0, _owner.getOwner)(this), name);
    }
    /**
      @private
         @method _stashNames
    */;
    _proto._stashNames = function _stashNames(routeInfo, dynamicParent) {
      if (this._names) {
        return;
      }
      var names = this._names = routeInfo['_names'];
      if (!names.length) {
        routeInfo = dynamicParent;
        names = routeInfo && routeInfo['_names'] || [];
      }
      var qps = (0, _metal.get)(this, '_qp.qps');
      var namePaths = new Array(names.length);
      for (var a = 0; a < names.length; ++a) {
        namePaths[a] = routeInfo.name + "." + names[a];
      }
      for (var i = 0; i < qps.length; ++i) {
        var qp = qps[i];
        if (qp.scope === 'model') {
          qp.parts = namePaths;
        }
      }
    }
    /**
      @private
         @property _activeQPChanged
    */;
    _proto._activeQPChanged = function _activeQPChanged(qp, value) {
      this._router._activeQPChanged(qp.scopedPropertyName, value);
    }
    /**
      @private
      @method _updatingQPChanged
    */;
    _proto._updatingQPChanged = function _updatingQPChanged(qp) {
      this._router._updatingQPChanged(qp.urlKey);
    }
    /**
      Returns a hash containing the parameters of an ancestor route.
         You may notice that `this.paramsFor` sometimes works when referring to a
      child route, but this behavior should not be relied upon as only ancestor
      routes are certain to be loaded in time.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('member', { path: ':name' }, function() {
          this.route('interest', { path: ':interest' });
        });
      });
      ```
         ```app/routes/member.js
      import Route from '@ember/routing/route';
         export default class MemberRoute extends Route {
        queryParams = {
          memberQp: { refreshModel: true }
        }
      }
      ```
         ```app/routes/member/interest.js
      import Route from '@ember/routing/route';
         export default class MemberInterestRoute extends Route {
        queryParams = {
          interestQp: { refreshModel: true }
        }
           model() {
          return this.paramsFor('member');
        }
      }
      ```
         If we visit `/turing/maths?memberQp=member&interestQp=interest` the model for
      the `member.interest` route is a hash with:
         * `name`: `turing`
      * `memberQp`: `member`
         @method paramsFor
      @param {String} name
      @return {Object} hash containing the parameters of the route `name`
      @since 1.4.0
      @public
    */;
    _proto.paramsFor = function paramsFor(name) {
      var _this2 = this;
      var route = (0, _owner.getOwner)(this).lookup("route:" + name);
      if (route === undefined) {
        return {};
      }
      var transition = this._router._routerMicrolib.activeTransition;
      var state = transition ? transition[_router_js.STATE_SYMBOL] : this._router._routerMicrolib.state;
      var fullName = route.fullRouteName;
      var params = (0, _polyfills.assign)({}, state.params[fullName]);
      var queryParams = getQueryParamsFor(route, state);
      return Object.keys(queryParams).reduce(function (params, key) {
        (true && !(!params[key]) && (0, _debug.assert)("The route '" + _this2.routeName + "' has both a dynamic segment and query param with name '" + key + "'. Please rename one to avoid collisions.", !params[key]));
        params[key] = queryParams[key];
        return params;
      }, params);
    }
    /**
      Serializes the query parameter key
         @method serializeQueryParamKey
      @param {String} controllerPropertyName
      @private
    */;
    _proto.serializeQueryParamKey = function serializeQueryParamKey(controllerPropertyName) {
      return controllerPropertyName;
    }
    /**
      Serializes value of the query parameter based on defaultValueType
         @method serializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */;
    _proto.serializeQueryParam = function serializeQueryParam(value, _urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide serialization specific
      // to a certain query param.
      return this._router._serializeQueryParam(value, defaultValueType);
    }
    /**
      Deserializes value of the query parameter based on defaultValueType
         @method deserializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */;
    _proto.deserializeQueryParam = function deserializeQueryParam(value, _urlKey, defaultValueType) {
      // urlKey isn't used here, but anyone overriding
      // can use it to provide deserialization specific
      // to a certain query param.
      return this._router._deserializeQueryParam(value, defaultValueType);
    }
    /**
      @private
         @property _optionsForQueryParam
    */;
    _proto._optionsForQueryParam = function _optionsForQueryParam(qp) {
      return (0, _metal.get)(this, "queryParams." + qp.urlKey) || (0, _metal.get)(this, "queryParams." + qp.prop) || {};
    }
    /**
      A hook you can use to reset controller values either when the model
      changes or the route is exiting.
         ```app/routes/articles.js
      import Route from '@ember/routing/route';
         export default class ArticlesRoute extends Route {
        resetController(controller, isExiting, transition) {
          if (isExiting && transition.targetName !== 'error') {
            controller.set('page', 1);
          }
        }
      }
      ```
         @method resetController
      @param {Controller} controller instance
      @param {Boolean} isExiting
      @param {Object} transition
      @since 1.7.0
      @public
    */;
    _proto.resetController = function resetController(_controller, _isExiting, _transition) {
      return this;
    }
    /**
      @private
         @method exit
    */;
    _proto.exit = function exit(transition) {
      this.deactivate(transition);
      this.trigger('deactivate', transition);
      this.teardownViews();
    }
    /**
      @private
         @method _internalReset
      @since 3.6.0
    */;
    _proto._internalReset = function _internalReset(isExiting, transition) {
      var controller = this.controller;
      controller['_qpDelegate'] = (0, _metal.get)(this, '_qp.states.inactive');
      this.resetController(controller, isExiting, transition);
    }
    /**
      @private
         @method enter
    */;
    _proto.enter = function enter(transition) {
      ROUTE_CONNECTIONS.set(this, []);
      this.activate(transition);
      this.trigger('activate', transition);
    }
    /**
      The `willTransition` action is fired at the beginning of any
      attempted transition with a `Transition` object as the sole
      argument. This action can be used for aborting, redirecting,
      or decorating the transition from the currently active routes.
         A good example is preventing navigation when a form is
      half-filled out:
         ```app/routes/contact-form.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ContactFormRoute extends Route {
        @action
        willTransition(transition) {
          if (this.controller.get('userHasEnteredData')) {
            this.controller.displayNavigationConfirm();
            transition.abort();
          }
        }
      }
      ```
         You can also redirect elsewhere by calling
      `this.transitionTo('elsewhere')` from within `willTransition`.
      Note that `willTransition` will not be fired for the
      redirecting `transitionTo`, since `willTransition` doesn't
      fire when there is already a transition underway. If you want
      subsequent `willTransition` actions to fire for the redirecting
      transition, you must first explicitly call
      `transition.abort()`.
         To allow the `willTransition` event to continue bubbling to the parent
      route, use `return true;`. When the `willTransition` method has a
      return value of `true` then the parent route's `willTransition` method
      will be fired, enabling "bubbling" behavior for the event.
         @event willTransition
      @param {Transition} transition
      @since 1.0.0
      @public
    */

    /**
      The `didTransition` action is fired after a transition has
      successfully been completed. This occurs after the normal model
      hooks (`beforeModel`, `model`, `afterModel`, `setupController`)
      have resolved. The `didTransition` action has no arguments,
      however, it can be useful for tracking page views or resetting
      state on the controller.
         ```app/routes/login.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class LoginRoute extends Route {
        @action
        didTransition() {
          this.controller.get('errors.base').clear();
          return true; // Bubble the didTransition event
        }
      }
      ```
         @event didTransition
      @since 1.2.0
      @public
    */

    /**
      The `loading` action is fired on the route when a route's `model`
      hook returns a promise that is not already resolved. The current
      `Transition` object is the first parameter and the route that
      triggered the loading event is the second parameter.
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        loading(transition, route) {
          let controller = this.controllerFor('foo');
          controller.set('currentlyLoading', true);
             transition.finally(function() {
            controller.set('currentlyLoading', false);
          });
        }
      }
      ```
         @event loading
      @param {Transition} transition
      @param {Route} route The route that triggered the loading event
      @since 1.2.0
      @public
    */

    /**
      When attempting to transition into a route, any of the hooks
      may return a promise that rejects, at which point an `error`
      action will be fired on the partially-entered routes, allowing
      for per-route error handling logic, or shared error handling
      logic defined on a parent route.
         Here is an example of an error handler that will be invoked
      for rejected promises from the various hooks on the route,
      as well as any unhandled errors from child routes:
         ```app/routes/admin.js
      import { reject } from 'rsvp';
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class AdminRoute extends Route {
        beforeModel() {
          return reject('bad things!');
        }
           @action
        error(error, transition) {
          // Assuming we got here due to the error in `beforeModel`,
          // we can expect that error === "bad things!",
          // but a promise model rejecting would also
          // call this hook, as would any errors encountered
          // in `afterModel`.
             // The `error` hook is also provided the failed
          // `transition`, which can be stored and later
          // `.retry()`d if desired.
             this.transitionTo('login');
        }
      }
      ```
         `error` actions that bubble up all the way to `ApplicationRoute`
      will fire a default error handler that logs the error. You can
      specify your own global default error handler by overriding the
      `error` handler on `ApplicationRoute`:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        error(error, transition) {
          this.controllerFor('banner').displayError(error.message);
        }
      }
      ```
      @event error
      @param {Error} error
      @param {Transition} transition
      @since 1.0.0
      @public
    */

    /**
      This event is triggered when the router enters the route. It is
      not executed when the model for the route changes.
         ```app/routes/application.js
      import { on } from '@ember/object/evented';
      import Route from '@ember/routing/route';
         export default Route.extend({
        collectAnalytics: on('activate', function(){
          collectAnalytics();
        })
      });
      ```
         @event activate
      @since 1.9.0
      @public
    */

    /**
      This event is triggered when the router completely exits this
      route. It is not executed when the model for the route changes.
         ```app/routes/index.js
      import { on } from '@ember/object/evented';
      import Route from '@ember/routing/route';
         export default Route.extend({
        trackPageLeaveAnalytics: on('deactivate', function(){
          trackPageLeaveAnalytics();
        })
      });
      ```
         @event deactivate
      @since 1.9.0
      @public
    */

    /**
      This hook is executed when the router completely exits this route. It is
      not executed when the model for the route changes.
         @method deactivate
      @param {Transition} transition
      @since 1.0.0
      @public
    */;
    _proto.deactivate = function deactivate(_transition) {}
    /**
      This hook is executed when the router enters the route. It is not executed
      when the model for the route changes.
         @method activate
      @param {Transition} transition
      @since 1.0.0
      @public
    */;
    _proto.activate = function activate(_transition) {}
    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         ```javascript
      this.transitionTo('blogPosts');
      this.transitionTo('blogPosts.recentEntries');
      ```
         Optionally supply a model for the route in question. The model
      will be serialized into the URL using the `serialize` hook of
      the route:
         ```javascript
      this.transitionTo('blogPost', aPost);
      ```
         If a literal is passed (such as a number or a string), it will
      be treated as an identifier instead. In this case, the `model`
      hook of the route will be triggered:
         ```javascript
      this.transitionTo('blogPost', 1);
      ```
         Multiple models will be applied last to first recursively up the
      route tree.
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('blogPost', { path:':blogPostId' }, function() {
          this.route('blogComment', { path: ':blogCommentId' });
        });
      });
         export default Router;
      ```
         ```javascript
      this.transitionTo('blogComment', aPost, aComment);
      this.transitionTo('blogComment', 1, 13);
      ```
         It is also possible to pass a URL (a string that starts with a
      `/`).
         ```javascript
      this.transitionTo('/');
      this.transitionTo('/blog/post/1/comment/13');
      this.transitionTo('/blog/posts?sort=title');
      ```
         An options hash with a `queryParams` property may be provided as
      the final argument to add query parameters to the destination URL.
         ```javascript
      this.transitionTo('blogPost', 1, {
        queryParams: { showComments: 'true' }
      });
         // if you just want to transition the query parameters without changing the route
      this.transitionTo({ queryParams: { sort: 'date' } });
      ```
         See also [replaceWith](#method_replaceWith).
         Simple Transition Example
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('secret');
        this.route('fourOhFour', { path: '*:' });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        moveToSecret(context) {
          if (authorized()) {
            this.transitionTo('secret', context);
          } else {
            this.transitionTo('fourOhFour');
          }
        }
      }
      ```
         Transition to a nested route
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('articles', { path: '/articles' }, function() {
          this.route('new');
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        transitionToNewArticle() {
          this.transitionTo('articles.new');
        }
      }
      ```
         Multiple Models Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
           this.route('breakfast', { path: ':breakfastId' }, function() {
          this.route('cereal', { path: ':cerealId' });
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        moveToChocolateCereal() {
          let cereal = { cerealId: 'ChocolateYumminess' };
          let breakfast = { breakfastId: 'CerealAndMilk' };
             this.transitionTo('breakfast.cereal', breakfast, cereal);
        }
      }
      ```
         Nested Route with Query String Example
         ```app/routes.js
      // ...
         Router.map(function() {
        this.route('fruits', function() {
          this.route('apples');
        });
      });
         export default Router;
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
         export default class IndexRoute extends Route {
        @action
        transitionToApples() {
          this.transitionTo('fruits.apples', { queryParams: { color: 'red' } });
        }
      }
      ```
         @method transitionTo
      @param {String} [name] the name of the route or a URL.
      @param {...Object} [models] the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters. May be supplied as the only
        parameter to trigger a query-parameter-only transition.
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.0.0
      @public
    */;
    _proto.transitionTo = function transitionTo() {
      var _this$_router;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      // eslint-disable-line no-unused-vars
      return (_this$_router = this._router).transitionTo.apply(_this$_router, (0, _utils2.prefixRouteNameArg)(this, args));
    }
    /**
      Perform a synchronous transition into another route without attempting
      to resolve promises, update the URL, or abort any currently active
      asynchronous transitions (i.e. regular transitions caused by
      `transitionTo` or URL changes).
         This method is handy for performing intermediate transitions on the
      way to a final destination route, and is called internally by the
      default implementations of the `error` and `loading` handlers.
         @method intermediateTransitionTo
      @param {String} name the name of the route
      @param {...Object} models the model(s) to be used while transitioning
      to the route.
      @since 1.2.0
      @public
     */;
    _proto.intermediateTransitionTo = function intermediateTransitionTo() {
      var _this$_router2;
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      var _prefixRouteNameArg = (0, _utils2.prefixRouteNameArg)(this, args),
        name = _prefixRouteNameArg[0],
        preparedArgs = _prefixRouteNameArg.slice(1);
      (_this$_router2 = this._router).intermediateTransitionTo.apply(_this$_router2, [name].concat(preparedArgs));
    }
    /**
      Refresh the model on this route and any child routes, firing the
      `beforeModel`, `model`, and `afterModel` hooks in a similar fashion
      to how routes are entered when transitioning in from other route.
      The current route params (e.g. `article_id`) will be passed in
      to the respective model hooks, and if a different model is returned,
      `setupController` and associated route hooks will re-fire as well.
         An example usage of this method is re-querying the server for the
      latest information using the same parameters as when the route
      was first entered.
         Note that this will cause `model` hooks to fire even on routes
      that were provided a model object when the route was initially
      entered.
         @method refresh
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.4.0
      @public
     */;
    _proto.refresh = function refresh() {
      return this._router._routerMicrolib.refresh(this);
    }
    /**
      Transition into another route while replacing the current URL, if possible.
      This will replace the current history entry instead of adding a new one.
      Beside that, it is identical to `transitionTo` in all other respects. See
      'transitionTo' for additional information regarding multiple models.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('secret');
      });
         export default Router;
      ```
         ```app/routes/secret.js
      import Route from '@ember/routing/route';
         export default class SecretRoute Route {
        afterModel() {
          if (!authorized()){
            this.replaceWith('index');
          }
        }
      }
      ```
         @method replaceWith
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
      @since 1.0.0
      @public
    */;
    _proto.replaceWith = function replaceWith() {
      var _this$_router3;
      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }
      return (_this$_router3 = this._router).replaceWith.apply(_this$_router3, (0, _utils2.prefixRouteNameArg)(this, args));
    }
    /**
      This hook is the entry point for router.js
         @private
      @method setup
    */;
    _proto.setup = function setup(context, transition) {
      var controllerName = this.controllerName || this.routeName;
      var definedController = this.controllerFor(controllerName, true);
      var controller;
      if (definedController) {
        controller = definedController;
      } else {
        controller = this.generateController(controllerName);
      } // Assign the route's controller so that it can more easily be
      // referenced in action handlers. Side effects. Side effects everywhere.

      if (!this.controller) {
        var qp = (0, _metal.get)(this, '_qp');
        var propNames = qp !== undefined ? (0, _metal.get)(qp, 'propertyNames') : [];
        addQueryParamsObservers(controller, propNames);
        this.controller = controller;
      }
      var queryParams = (0, _metal.get)(this, '_qp');
      var states = queryParams.states;
      controller._qpDelegate = states.allowOverrides;
      if (transition) {
        // Update the model dep values used to calculate cache keys.
        (0, _utils2.stashParamNames)(this._router, transition[_router_js.STATE_SYMBOL].routeInfos);
        var cache = this._bucketCache;
        var params = transition[_router_js.PARAMS_SYMBOL];
        var allParams = queryParams.propertyNames;
        allParams.forEach(function (prop) {
          var aQp = queryParams.map[prop];
          aQp.values = params;
          var cacheKey = (0, _utils2.calculateCacheKey)(aQp.route.fullRouteName, aQp.parts, aQp.values);
          var value = cache.lookup(cacheKey, prop, aQp.undecoratedDefaultValue);
          (0, _metal.set)(controller, prop, value);
        });
        var qpValues = getQueryParamsFor(this, transition[_router_js.STATE_SYMBOL]);
        (0, _metal.setProperties)(controller, qpValues);
      }
      this.setupController(controller, context, transition);
      if (this._environment.options.shouldRender) {
        this.renderTemplate(controller, context);
      } // Setup can cause changes to QPs which need to be propogated immediately in
      // some situations. Eventually, we should work on making these async somehow.

      (0, _metal.flushAsyncObservers)(false);
    }
    /*
      Called when a query parameter for this route changes, regardless of whether the route
      is currently part of the active route hierarchy. This will update the query parameter's
      value in the cache so if this route becomes active, the cache value has been updated.
    */;
    _proto._qpChanged = function _qpChanged(prop, value, qp) {
      if (!qp) {
        return;
      } // Update model-dep cache

      var cache = this._bucketCache;
      var cacheKey = (0, _utils2.calculateCacheKey)(qp.route.fullRouteName, qp.parts, qp.values);
      cache.stash(cacheKey, prop, value);
    }
    /**
      This hook is the first of the route entry validation hooks
      called when an attempt is made to transition into a route
      or one of its children. It is called before `model` and
      `afterModel`, and is appropriate for cases when:
         1) A decision can be made to redirect elsewhere without
         needing to resolve the model first.
      2) Any async operations need to occur first before the
         model is attempted to be resolved.
         This hook is provided the current `transition` attempt
      as a parameter, which can be used to `.abort()` the transition,
      save it for a later `.retry()`, or retrieve values set
      on it from a previous hook. You can also just call
      `this.transitionTo` to another route to implicitly
      abort the `transition`.
         You can return a promise from this hook to pause the
      transition until the promise resolves (or rejects). This could
      be useful, for instance, for retrieving async code from
      the server that is required to enter a route.
         @method beforeModel
      @param {Transition} transition
      @return {any | Promise<any>} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
      @since 1.0.0
      @public
    */;
    _proto.beforeModel = function beforeModel() {}
    /**
      This hook is called after this route's model has resolved.
      It follows identical async/promise semantics to `beforeModel`
      but is provided the route's resolved model in addition to
      the `transition`, and is therefore suited to performing
      logic that can only take place after the model has already
      resolved.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        afterModel(posts, transition) {
          if (posts.get('length') === 1) {
            this.transitionTo('post.show', posts.get('firstObject'));
          }
        }
      }
      ```
         Refer to documentation for `beforeModel` for a description
      of transition-pausing semantics when a promise is returned
      from this hook.
         @method afterModel
      @param {Object} resolvedModel the value returned from `model`,
        or its resolved value if it was a promise
      @param {Transition} transition
      @return {any | Promise<any>} if the value returned from this hook is
        a promise, the transition will pause until the transition
        resolves. Otherwise, non-promise return values are not
        utilized in any way.
      @since 1.0.0
      @public
     */;
    _proto.afterModel = function afterModel() {}
    /**
      A hook you can implement to optionally redirect to another route.
         Calling `this.transitionTo` from inside of the `redirect` hook will
      abort the current transition (into the route that has implemented `redirect`).
         `redirect` and `afterModel` behave very similarly and are
      called almost at the same time, but they have an important
      distinction when calling `this.transitionTo` to a child route
      of the current route. From `afterModel`, this new transition
      invalidates the current transition, causing `beforeModel`,
      `model`, and `afterModel` hooks to be called again. But the
      same transition started from `redirect` does _not_ invalidate
      the current transition. In other words, by the time the `redirect`
      hook has been called, both the resolved model and the attempted
      entry into this route are considered fully validated.
         @method redirect
      @param {Object} model the model for this route
      @param {Transition} transition the transition object associated with the current transition
      @since 1.0.0
      @public
    */;
    _proto.redirect = function redirect() {}
    /**
      Called when the context is changed by router.js.
         @private
      @method contextDidChange
    */;
    _proto.contextDidChange = function contextDidChange() {
      this.currentModel = this.context;
    }
    /**
      A hook you can implement to convert the URL into the model for
      this route.
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         The model for the `post` route is `store.findRecord('post', params.post_id)`.
         By default, if your route has a dynamic segment ending in `_id`:
         * The model class is determined from the segment (`post_id`'s
        class is `App.Post`)
      * The find method is called on the model class with the value of
        the dynamic segment.
         Note that for routes with dynamic segments, this hook is not always
      executed. If the route is entered through a transition (e.g. when
      using the `link-to` Handlebars helper or the `transitionTo` method
      of routes), and a model context is already provided this hook
      is not called.
         A model context does not include a primitive string or number,
      which does cause the model hook to be called.
         Routes without dynamic segments will always execute the model hook.
         ```javascript
      // no dynamic segment, model hook always called
      this.transitionTo('posts');
         // model passed in, so model hook not called
      thePost = store.findRecord('post', 1);
      this.transitionTo('post', thePost);
         // integer passed in, model hook is called
      this.transitionTo('post', 1);
         // model id passed in, model hook is called
      // useful for forcing the hook to execute
      thePost = store.findRecord('post', 1);
      this.transitionTo('post', thePost.id);
      ```
         This hook follows the asynchronous/promise semantics
      described in the documentation for `beforeModel`. In particular,
      if a promise returned from `model` fails, the error will be
      handled by the `error` hook on `Route`.
         Example
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        model(params) {
          return this.store.findRecord('post', params.post_id);
        }
      }
      ```
         @method model
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {any | Promise<any>} the model for this route. If
        a promise is returned, the transition will pause until
        the promise resolves, and the resolved value of the promise
        will be used as the model for this route.
      @since 1.0.0
      @public
    */;
    _proto.model = function model(params, transition) {
      var name, sawParams, value;
      var queryParams = (0, _metal.get)(this, '_qp.map');
      for (var prop in params) {
        if (prop === 'queryParams' || queryParams && prop in queryParams) {
          continue;
        }
        var match = prop.match(/^(.*)_id$/);
        if (match !== null) {
          name = match[1];
          value = params[prop];
        }
        sawParams = true;
      }
      if (!name) {
        if (sawParams) {
          return (0, _polyfills.assign)({}, params);
        } else {
          if (transition.resolveIndex < 1) {
            return;
          }
          return transition[_router_js.STATE_SYMBOL].routeInfos[transition.resolveIndex - 1].context;
        }
      }
      return this.findModel(name, value);
    }
    /**
      @private
      @method deserialize
      @param {Object} params the parameters extracted from the URL
      @param {Transition} transition
      @return {any | Promise<any>} the model for this route.
         Router.js hook.
     */;
    _proto.deserialize = function deserialize(_params, transition) {
      return this.model(this._paramsFor(this.routeName, _params), transition);
    }
    /**
         @method findModel
      @param {String} type the model type
      @param {Object} value the value passed to find
      @private
    */;
    _proto.findModel = function findModel() {
      var _get;
      return (_get = (0, _metal.get)(this, 'store')).find.apply(_get, arguments);
    }
    /**
      A hook you can use to setup the controller for the current route.
         This method is called with the controller for the current route and the
      model supplied by the `model` hook.
         By default, the `setupController` hook sets the `model` property of
      the controller to the specified `model` when it is not `undefined`.
         If you implement the `setupController` hook in your Route, it will
      prevent this default behavior. If you want to preserve that behavior
      when implementing your `setupController` function, make sure to call
      `super`:
         ```app/routes/photos.js
      import Route from '@ember/routing/route';
         export default class PhotosRoute extends Route {
        model() {
          return this.store.findAll('photo');
        }
           setupController(controller, model) {
          super.setupController(controller, model);
             this.controllerFor('application').set('showingPhotos', true);
        }
      }
      ```
         The provided controller will be one resolved based on the name
      of this route.
         If no explicit controller is defined, Ember will automatically create one.
         As an example, consider the router:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         If you have defined a file for the post controller,
      the framework will use it.
      If it is not defined, a basic `Controller` instance would be used.
         @example Behavior of a basic Controller
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        setupController(controller, model) {
          controller.set('model', model);
        }
      });
      ```
         @method setupController
      @param {Controller} controller instance
      @param {Object} model
      @param {Object} transition
      @since 1.0.0
      @public
    */;
    _proto.setupController = function setupController(controller, context, _transition) {
      // eslint-disable-line no-unused-vars
      if (controller && context !== undefined) {
        (0, _metal.set)(controller, 'model', context);
      }
    }
    /**
      Returns the controller of the current route, or a parent (or any ancestor)
      route in a route hierarchy.
         The controller instance must already have been created, either through entering the
      associated route or using `generateController`.
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        setupController(controller, post) {
          super.setupController(controller, post);
             this.controllerFor('posts').set('currentPost', post);
        }
      }
      ```
         @method controllerFor
      @param {String} name the name of the route or controller
      @return {Controller}
      @since 1.0.0
      @public
    */;
    _proto.controllerFor = function controllerFor(name, _skipAssert) {
      var owner = (0, _owner.getOwner)(this);
      var route = owner.lookup("route:" + name);
      if (route && route.controllerName) {
        name = route.controllerName;
      }
      var controller = owner.lookup("controller:" + name); // NOTE: We're specifically checking that skipAssert is true, because according
      //   to the old API the second parameter was model. We do not want people who
      //   passed a model to skip the assertion.
      (true && !(controller !== undefined || _skipAssert === true) && (0, _debug.assert)("The controller named '" + name + "' could not be found. Make sure that this route exists and has already been entered at least once. If you are accessing a controller not associated with a route, make sure the controller class is explicitly defined.", controller !== undefined || _skipAssert === true));
      return controller;
    }
    /**
      Generates a controller for a route.
         Example
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class Post extends Route {
        setupController(controller, post) {
          super.setupController(controller, post);
             this.generateController('posts');
        }
      }
      ```
         @method generateController
      @param {String} name the name of the controller
      @private
    */;
    _proto.generateController = function generateController(name) {
      var owner = (0, _owner.getOwner)(this);
      return (0, _generate_controller.default)(owner, name);
    }
    /**
      Returns the resolved model of a parent (or any ancestor) route
      in a route hierarchy.  During a transition, all routes
      must resolve a model object, and if a route
      needs access to a parent route's model in order to
      resolve a model (or just reuse the model from a parent),
      it can call `this.modelFor(theNameOfParentRoute)` to
      retrieve it. If the ancestor route's model was a promise,
      its resolved result is returned.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('post', { path: '/posts/:post_id' }, function() {
          this.route('comments');
        });
      });
         export default Router;
      ```
         ```app/routes/post/comments.js
      import Route from '@ember/routing/route';
         export default class PostCommentsRoute extends Route {
        model() {
          let post = this.modelFor('post');
             return post.comments;
        }
      }
      ```
         @method modelFor
      @param {String} name the name of the route
      @return {Object} the model object
      @since 1.0.0
      @public
    */;
    _proto.modelFor = function modelFor(_name) {
      var name;
      var owner = (0, _owner.getOwner)(this);
      var transition = this._router && this._router._routerMicrolib ? this._router._routerMicrolib.activeTransition : undefined; // Only change the route name when there is an active transition.
      // Otherwise, use the passed in route name.

      if (owner.routable && transition !== undefined) {
        name = getEngineRouteName(owner, _name);
      } else {
        name = _name;
      }
      var route = owner.lookup("route:" + name); // If we are mid-transition, we want to try and look up
      // resolved parent contexts on the current transitionEvent.

      if (transition !== undefined && transition !== null) {
        var modelLookupName = route && route.routeName || name;
        if (Object.prototype.hasOwnProperty.call(transition.resolvedModels, modelLookupName)) {
          return transition.resolvedModels[modelLookupName];
        }
      }
      return route && route.currentModel;
    }
    /**
      A hook you can use to render the template for the current route.
         This method is called with the controller for the current route and the
      model supplied by the `model` hook. By default, it renders the route's
      template, configured with the controller for the route.
         This method can be overridden to set up and render additional or
      alternative templates.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        renderTemplate(controller, model) {
          let favController = this.controllerFor('favoritePost');
             // Render the `favoritePost` template into
          // the outlet `posts`, and display the `favoritePost`
          // controller.
          this.render('favoritePost', {
            outlet: 'posts',
            controller: favController
          });
        }
      }
      ```
         @method renderTemplate
      @param {Object} controller the route's controller
      @param {Object} model the route's model
      @since 1.0.0
      @public
    */;
    _proto.renderTemplate = function renderTemplate(_controller, _model) {
      // eslint-disable-line no-unused-vars
      this.render();
    }
    /**
      `render` is used to render a template into a region of another template
      (indicated by an `{{outlet}}`). `render` is used both during the entry
      phase of routing (via the `renderTemplate` hook) and later in response to
      user interaction.
         For example, given the following minimal router and templates:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('photos');
      });
         export default Router;
      ```
         ```handlebars
      <!-- application.hbs -->
      <div class='something-in-the-app-hbs'>
        {{outlet "anOutletName"}}
      </div>
      ```
         ```handlebars
      <!-- photos.hbs -->
      <h1>Photos</h1>
      ```
         You can render `photos.hbs` into the `"anOutletName"` outlet of
      `application.hbs` by calling `render`:
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        renderTemplate() {
          this.render('photos', {
            into: 'application',
            outlet: 'anOutletName'
          })
        }
      }
      ```
         `render` additionally allows you to supply which `controller` and
      `model` objects should be loaded and associated with the rendered template.
         ```app/routes/posts.js
      import Route from '@ember/routing/route';
         export default class PostsRoute extends Route {
        renderTemplate(controller, model) {
          this.render('posts', {    // the template to render, referenced by name
            into: 'application',    // the template to render into, referenced by name
            outlet: 'anOutletName', // the outlet inside `options.into` to render into.
            controller: 'someControllerName', // the controller to use for this template, referenced by name
            model: model            // the model to set on `options.controller`.
          })
        }
      }
      ```
         The string values provided for the template name, and controller
      will eventually pass through to the resolver for lookup. See
      Resolver for how these are mapped to JavaScript objects in your
      application. The template to render into needs to be related to  either the
      current route or one of its ancestors.
         Not all options need to be passed to `render`. Default values will be used
      based on the name of the route specified in the router or the Route's
      `controllerName` and `templateName` properties.
         For example:
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
        this.route('post', { path: '/posts/:post_id' });
      });
         export default Router;
      ```
         ```app/routes/post.js
      import Route from '@ember/routing/route';
         export default class PostRoute extends Route {
        renderTemplate() {
          this.render(); // all defaults apply
        }
      }
      ```
         The name of the route, defined by the router, is `post`.
         The following equivalent default options will be applied when
      the Route calls `render`:
         ```javascript
      this.render('post', {  // the template name associated with 'post' Route
        into: 'application', // the parent route to 'post' Route
        outlet: 'main',      // {{outlet}} and {{outlet 'main'}} are synonymous,
        controller: 'post',  // the controller associated with the 'post' Route
      })
      ```
         By default the controller's `model` will be the route's model, so it does not
      need to be passed unless you wish to change which model is being used.
         @method render
      @param {String} name the name of the template to render
      @param {Object} [options] the options
      @param {String} [options.into] the template to render into,
                      referenced by name. Defaults to the parent template
      @param {String} [options.outlet] the outlet inside `options.into` to render into.
                      Defaults to 'main'
      @param {String|Object} [options.controller] the controller to use for this template,
                      referenced by name or as a controller instance. Defaults to the Route's paired controller
      @param {Object} [options.model] the model object to set on `options.controller`.
                      Defaults to the return value of the Route's model hook
      @since 1.0.0
      @public
    */;
    _proto.render = function render(name, options) {
      var renderOptions = buildRenderOptions(this, name, options);
      ROUTE_CONNECTIONS.get(this).push(renderOptions);
      (0, _runloop.once)(this._router, '_setOutlets');
    }
    /**
      Disconnects a view that has been rendered into an outlet.
         You may pass any or all of the following options to `disconnectOutlet`:
         * `outlet`: the name of the outlet to clear (default: 'main')
      * `parentView`: the name of the view containing the outlet to clear
         (default: the view rendered by the parent route)
         Example:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        showModal(evt) {
          this.render(evt.modalName, {
            outlet: 'modal',
            into: 'application'
          });
        }
           @action
        hideModal() {
          this.disconnectOutlet({
            outlet: 'modal',
            parentView: 'application'
          });
        }
      }
      ```
         Alternatively, you can pass the `outlet` name directly as a string.
         Example:
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        showModal(evt) {
          // ...
        }
           @action
        hideModal(evt) {
          this.disconnectOutlet('modal');
        }
      }
      ```
         @method disconnectOutlet
      @param {Object|String} options the options hash or outlet name
      @since 1.0.0
      @public
    */;
    _proto.disconnectOutlet = function disconnectOutlet(options) {
      var outletName;
      var parentView;
      if (options) {
        if (typeof options === 'string') {
          outletName = options;
        } else {
          outletName = options.outlet;
          parentView = options.parentView ? options.parentView.replace(/\//g, '.') : undefined;
          (true && !(!('outlet' in options && options.outlet === undefined)) && (0, _debug.assert)('You passed undefined as the outlet name.', !('outlet' in options && options.outlet === undefined)));
        }
      }
      outletName = outletName || 'main';
      this._disconnectOutlet(outletName, parentView);
      var routeInfos = this._router._routerMicrolib.currentRouteInfos;
      for (var i = 0; i < routeInfos.length; i++) {
        // This non-local state munging is sadly necessary to maintain
        // backward compatibility with our existing semantics, which allow
        // any route to disconnectOutlet things originally rendered by any
        // other route. This should all get cut in 2.0.
        routeInfos[i].route._disconnectOutlet(outletName, parentView);
      }
    };
    _proto._disconnectOutlet = function _disconnectOutlet(outletName, parentView) {
      var parent = parentRoute(this);
      if (parent && parentView === parent.routeName) {
        parentView = undefined;
      }
      var connections = ROUTE_CONNECTIONS.get(this);
      for (var i = 0; i < connections.length; i++) {
        var connection = connections[i];
        if (connection.outlet === outletName && connection.into === parentView) {
          // This neuters the disconnected outlet such that it doesn't
          // render anything, but it leaves an entry in the outlet
          // hierarchy so that any existing other renders that target it
          // don't suddenly blow up. They will still stick themselves
          // into its outlets, which won't render anywhere. All of this
          // statefulness should get the machete in 2.0.
          connections[i] = {
            owner: connection.owner,
            into: connection.into,
            outlet: connection.outlet,
            name: connection.name,
            controller: undefined,
            template: undefined,
            model: undefined
          };
          (0, _runloop.once)(this._router, '_setOutlets');
        }
      }
    };
    _proto.willDestroy = function willDestroy() {
      this.teardownViews();
    }
    /**
      @private
         @method teardownViews
    */;
    _proto.teardownViews = function teardownViews() {
      var connections = ROUTE_CONNECTIONS.get(this);
      if (connections !== undefined && connections.length > 0) {
        ROUTE_CONNECTIONS.set(this, []);
        (0, _runloop.once)(this._router, '_setOutlets');
      }
    }
    /**
      Allows you to produce custom metadata for the route.
      The return value of this method will be attached to
      its corresponding RouteInfoWithAttributes object.
         Example
         ```app/routes/posts/index.js
      import Route from '@ember/routing/route';
         export default class PostsIndexRoute extends Route {
        buildRouteInfoMetadata() {
          return { title: 'Posts Page' }
        }
      }
      ```
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { inject as service } from '@ember/service';
         export default class ApplicationRoute extends Route {
        @service router
           constructor() {
          super(...arguments);
             this.router.on('routeDidChange', transition => {
            document.title = transition.to.metadata.title;
            // would update document's title to "Posts Page"
          });
        }
      }
      ```
      @method buildRouteInfoMetadata
      @return any
      @since 3.10.0
      @public
     */;
    _proto.buildRouteInfoMetadata = function buildRouteInfoMetadata() {};
    return Route;
  }(_runtime.Object);
  Route.reopenClass({
    isRouteFactory: true
  });
  function parentRoute(route) {
    var routeInfo = routeInfoFor(route, route._router._routerMicrolib.state.routeInfos, -1);
    return routeInfo && routeInfo.route;
  }
  function routeInfoFor(route, routeInfos, offset) {
    if (offset === void 0) {
      offset = 0;
    }
    if (!routeInfos) {
      return;
    }
    var current;
    for (var i = 0; i < routeInfos.length; i++) {
      current = routeInfos[i].route;
      if (current === route) {
        return routeInfos[i + offset];
      }
    }
    return;
  }
  function buildRenderOptions(route, nameOrOptions, options) {
    var isDefaultRender = !nameOrOptions && !options;
    var _name;
    if (!isDefaultRender) {
      if (typeof nameOrOptions === 'object' && !options) {
        _name = route.templateName || route.routeName;
        options = nameOrOptions;
      } else {
        (true && !(!(0, _metal.isEmpty)(nameOrOptions)) && (0, _debug.assert)('The name in the given arguments is undefined or empty string', !(0, _metal.isEmpty)(nameOrOptions)));
        _name = nameOrOptions;
      }
    }
    (true && !(isDefaultRender || !(options && 'outlet' in options && options.outlet === undefined)) && (0, _debug.assert)('You passed undefined as the outlet name.', isDefaultRender || !(options && 'outlet' in options && options.outlet === undefined)));
    var owner = (0, _owner.getOwner)(route);
    var name, templateName, into, outlet, model;
    var controller = undefined;
    if (options) {
      into = options.into && options.into.replace(/\//g, '.');
      outlet = options.outlet;
      controller = options.controller;
      model = options.model;
    }
    outlet = outlet || 'main';
    if (isDefaultRender) {
      name = route.routeName;
      templateName = route.templateName || name;
    } else {
      name = _name.replace(/\//g, '.');
      templateName = name;
    }
    if (controller === undefined) {
      if (isDefaultRender) {
        controller = route.controllerName || owner.lookup("controller:" + name);
      } else {
        controller = owner.lookup("controller:" + name) || route.controllerName || route.routeName;
      }
    }
    if (typeof controller === 'string') {
      var controllerName = controller;
      controller = owner.lookup("controller:" + controllerName);
      (true && !(isDefaultRender || controller !== undefined) && (0, _debug.assert)("You passed `controller: '" + controllerName + "'` into the `render` method, but no such controller could be found.", isDefaultRender || controller !== undefined));
    }
    if (model === undefined) {
      model = route.currentModel;
    } else {
      controller.set('model', model);
    }
    var template = owner.lookup("template:" + templateName);
    (true && !(isDefaultRender || template !== undefined) && (0, _debug.assert)("Could not find \"" + templateName + "\" template, view, or component.", isDefaultRender || template !== undefined));
    var parent;
    if (into && (parent = parentRoute(route)) && into === parent.routeName) {
      into = undefined;
    }
    var renderOptions = {
      owner: owner,
      into: into,
      outlet: outlet,
      name: name,
      controller: controller,
      model: model,
      template: template !== undefined ? template(owner) : route._topLevelViewTemplate(owner)
    };
    if (true /* DEBUG */) {
      var LOG_VIEW_LOOKUPS = (0, _metal.get)(route._router, 'namespace.LOG_VIEW_LOOKUPS');
      if (LOG_VIEW_LOOKUPS && !template) {
        (0, _debug.info)("Could not find \"" + name + "\" template. Nothing will be rendered", {
          fullName: "template:" + name
        });
      }
    }
    return renderOptions;
  }
  function getFullQueryParams(router, state) {
    if (state['fullQueryParams']) {
      return state['fullQueryParams'];
    }
    state['fullQueryParams'] = {};
    (0, _polyfills.assign)(state['fullQueryParams'], state.queryParams);
    router._deserializeQueryParams(state.routeInfos, state['fullQueryParams']);
    return state['fullQueryParams'];
  }
  function getQueryParamsFor(route, state) {
    state['queryParamsFor'] = state['queryParamsFor'] || {};
    var name = route.fullRouteName;
    if (state['queryParamsFor'][name]) {
      return state['queryParamsFor'][name];
    }
    var fullQueryParams = getFullQueryParams(route._router, state);
    var params = state['queryParamsFor'][name] = {}; // Copy over all the query params for this route/controller into params hash.

    var qps = (0, _metal.get)(route, '_qp.qps');
    for (var i = 0; i < qps.length; ++i) {
      // Put deserialized qp on params hash.
      var qp = qps[i];
      var qpValueWasPassedIn = (qp.prop in fullQueryParams);
      params[qp.prop] = qpValueWasPassedIn ? fullQueryParams[qp.prop] : copyDefaultValue(qp.defaultValue);
    }
    return params;
  }
  function copyDefaultValue(value) {
    if (Array.isArray(value)) {
      return (0, _runtime.A)(value.slice());
    }
    return value;
  }
  /*
    Merges all query parameters from a controller with those from
    a route, returning a new object and avoiding any mutations to
    the existing objects.
  */

  function mergeEachQueryParams(controllerQP, routeQP) {
    var qps = {};
    var keysAlreadyMergedOrSkippable = {
      defaultValue: true,
      type: true,
      scope: true,
      as: true
    }; // first loop over all controller qps, merging them with any matching route qps
    // into a new empty object to avoid mutating.

    for (var cqpName in controllerQP) {
      if (!Object.prototype.hasOwnProperty.call(controllerQP, cqpName)) {
        continue;
      }
      var newControllerParameterConfiguration = {};
      (0, _polyfills.assign)(newControllerParameterConfiguration, controllerQP[cqpName], routeQP[cqpName]);
      qps[cqpName] = newControllerParameterConfiguration; // allows us to skip this QP when we check route QPs.

      keysAlreadyMergedOrSkippable[cqpName] = true;
    } // loop over all route qps, skipping those that were merged in the first pass
    // because they also appear in controller qps

    for (var rqpName in routeQP) {
      if (!Object.prototype.hasOwnProperty.call(routeQP, rqpName) || keysAlreadyMergedOrSkippable[rqpName]) {
        continue;
      }
      var newRouteParameterConfiguration = {};
      (0, _polyfills.assign)(newRouteParameterConfiguration, routeQP[rqpName], controllerQP[rqpName]);
      qps[rqpName] = newRouteParameterConfiguration;
    }
    return qps;
  }
  function addQueryParamsObservers(controller, propNames) {
    propNames.forEach(function (prop) {
      if ((0, _metal.descriptorForProperty)(controller, prop) === undefined) {
        var desc = (0, _utils.lookupDescriptor)(controller, prop);
        if (desc !== null && (typeof desc.get === 'function' || typeof desc.set === 'function')) {
          (0, _metal.defineProperty)(controller, prop, (0, _compat.dependentKeyCompat)({
            get: desc.get,
            set: desc.set
          }));
        }
      }
      (0, _metal.addObserver)(controller, prop + ".[]", controller, controller._qpChanged, false);
    });
  }
  function getEngineRouteName(engine, routeName) {
    if (engine.routable) {
      var prefix = engine.mountPoint;
      if (routeName === 'application') {
        return prefix;
      } else {
        return prefix + "." + routeName;
      }
    }
    return routeName;
  }
  /**
      A hook you can implement to convert the route's model into parameters
      for the URL.
  
      ```app/router.js
      // ...
  
      Router.map(function() {
        this.route('post', { path: '/posts/:post_id' });
      });
  
      ```
  
      ```app/routes/post.js
      import Route from '@ember/routing/route';
  
      export default class PostRoute extends Route {
        model({ post_id }) {
          // the server returns `{ id: 12 }`
          return fetch(`/posts/${post_id}`;
        }
  
        serialize(model) {
          // this will make the URL `/posts/12`
          return { post_id: model.id };
        }
      }
      ```
  
      The default `serialize` method will insert the model's `id` into the
      route's dynamic segment (in this case, `:post_id`) if the segment contains '_id'.
      If the route has multiple dynamic segments or does not contain '_id', `serialize`
      will return `getProperties(model, params)`
  
      This method is called when `transitionTo` is called with a context
      in order to populate the URL.
  
      @method serialize
      @param {Object} model the routes model
      @param {Array} params an Array of parameter names for the current
        route (in the example, `['post_id']`.
      @return {Object} the serialized parameters
      @since 1.0.0
      @public
    */

  Route.prototype.serialize = defaultSerialize;
  Route.reopen(_runtime.ActionHandler, _runtime.Evented, {
    mergedProperties: ['queryParams'],
    /**
      Configuration hash for this route's queryParams. The possible
      configuration options and their defaults are as follows
      (assuming a query param whose controller property is `page`):
         ```javascript
      queryParams: {
        page: {
          // By default, controller query param properties don't
          // cause a full transition when they are changed, but
          // rather only cause the URL to update. Setting
          // `refreshModel` to true will cause an "in-place"
          // transition to occur, whereby the model hooks for
          // this route (and any child routes) will re-fire, allowing
          // you to reload models (e.g., from the server) using the
          // updated query param values.
          refreshModel: false,
             // By default, changes to controller query param properties
          // cause the URL to update via `pushState`, which means an
          // item will be added to the browser's history, allowing
          // you to use the back button to restore the app to the
          // previous state before the query param property was changed.
          // Setting `replace` to true will use `replaceState` (or its
          // hash location equivalent), which causes no browser history
          // item to be added. This options name and default value are
          // the same as the `link-to` helper's `replace` option.
          replace: false,
             // By default, the query param URL key is the same name as
          // the controller property name. Use `as` to specify a
          // different URL key.
          as: 'page'
        }
      }
      ```
         @property queryParams
      @for Route
      @type Object
      @since 1.6.0
      @public
    */
    queryParams: {},
    /**
      The name of the template to use by default when rendering this routes
      template.
         ```app/routes/posts/list.js
      import Route from '@ember/routing/route';
         export default class extends Route {
        templateName = 'posts/list'
      });
      ```
         ```app/routes/posts/index.js
      import PostsList from '../posts/list';
         export default class extends PostsList {};
      ```
         ```app/routes/posts/archived.js
      import PostsList from '../posts/list';
         export default class extends PostsList {};
      ```
         @property templateName
      @type String
      @default null
      @since 1.4.0
      @public
    */
    templateName: null,
    /**
      @private
         @property _names
    */
    _names: null,
    /**
      The name of the controller to associate with this route.
         By default, Ember will lookup a route's controller that matches the name
      of the route (i.e. `posts.new`). However,
      if you would like to define a specific controller to use, you can do so
      using this property.
         This is useful in many ways, as the controller specified will be:
         * passed to the `setupController` method.
      * used as the controller for the template being rendered by the route.
      * returned from a call to `controllerFor` for the route.
         @property controllerName
      @type String
      @default null
      @since 1.4.0
      @public
    */
    controllerName: null,
    /**
      Store property provides a hook for data persistence libraries to inject themselves.
         By default, this store property provides the exact same functionality previously
      in the model hook.
         Currently, the required interface is:
         `store.find(modelName, findArguments)`
         @property store
      @type {Object}
      @private
    */
    store: (0, _metal.computed)({
      get: function get() {
        var owner = (0, _owner.getOwner)(this);
        var routeName = this.routeName;
        var namespace = (0, _metal.get)(this, '_router.namespace');
        return {
          find: function find(name, value) {
            var modelClass = owner.factoryFor("model:" + name);
            (true && !(Boolean(modelClass)) && (0, _debug.assert)("You used the dynamic segment " + name + "_id in your route " + routeName + ", but " + namespace + "." + (0, _string.classify)(name) + " did not exist and you did not override your route's `model` hook.", Boolean(modelClass)));
            if (!modelClass) {
              return;
            }
            modelClass = modelClass.class;
            (true && !(typeof modelClass.find === 'function') && (0, _debug.assert)((0, _string.classify)(name) + " has no method `find`.", typeof modelClass.find === 'function'));
            return modelClass.find(value);
          }
        };
      },
      set: function set(key, value) {
        (0, _metal.defineProperty)(this, key, null, value);
      }
    }),
    /**
        @private
           @property _qp
      */
    _qp: (0, _metal.computed)(function () {
      var _this3 = this;
      var combinedQueryParameterConfiguration;
      var controllerName = this.controllerName || this.routeName;
      var owner = (0, _owner.getOwner)(this);
      var controller = owner.lookup("controller:" + controllerName);
      var queryParameterConfiguraton = (0, _metal.get)(this, 'queryParams');
      var hasRouterDefinedQueryParams = Object.keys(queryParameterConfiguraton).length > 0;
      if (controller) {
        // the developer has authored a controller class in their application for
        // this route find its query params and normalize their object shape them
        // merge in the query params for the route. As a mergedProperty,
        // Route#queryParams is always at least `{}`
        var controllerDefinedQueryParameterConfiguration = (0, _metal.get)(controller, 'queryParams') || {};
        var normalizedControllerQueryParameterConfiguration = (0, _utils2.normalizeControllerQueryParams)(controllerDefinedQueryParameterConfiguration);
        combinedQueryParameterConfiguration = mergeEachQueryParams(normalizedControllerQueryParameterConfiguration, queryParameterConfiguraton);
      } else if (hasRouterDefinedQueryParams) {
        // the developer has not defined a controller but *has* supplied route query params.
        // Generate a class for them so we can later insert default values
        controller = (0, _generate_controller.default)(owner, controllerName);
        combinedQueryParameterConfiguration = queryParameterConfiguraton;
      }
      var qps = [];
      var map = {};
      var propertyNames = [];
      for (var propName in combinedQueryParameterConfiguration) {
        if (!Object.prototype.hasOwnProperty.call(combinedQueryParameterConfiguration, propName)) {
          continue;
        } // to support the dubious feature of using unknownProperty
        // on queryParams configuration

        if (propName === 'unknownProperty' || propName === '_super') {
          // possible todo: issue deprecation warning?
          continue;
        }
        var desc = combinedQueryParameterConfiguration[propName];
        var scope = desc.scope || 'model';
        var parts = void 0;
        if (scope === 'controller') {
          parts = [];
        }
        var urlKey = desc.as || this.serializeQueryParamKey(propName);
        var defaultValue = (0, _metal.get)(controller, propName);
        defaultValue = copyDefaultValue(defaultValue);
        var type = desc.type || (0, _runtime.typeOf)(defaultValue);
        var defaultValueSerialized = this.serializeQueryParam(defaultValue, urlKey, type);
        var scopedPropertyName = controllerName + ":" + propName;
        var qp = {
          undecoratedDefaultValue: (0, _metal.get)(controller, propName),
          defaultValue: defaultValue,
          serializedDefaultValue: defaultValueSerialized,
          serializedValue: defaultValueSerialized,
          type: type,
          urlKey: urlKey,
          prop: propName,
          scopedPropertyName: scopedPropertyName,
          controllerName: controllerName,
          route: this,
          parts: parts,
          values: null,
          scope: scope
        };
        map[propName] = map[urlKey] = map[scopedPropertyName] = qp;
        qps.push(qp);
        propertyNames.push(propName);
      }
      return {
        qps: qps,
        map: map,
        propertyNames: propertyNames,
        states: {
          /*
            Called when a query parameter changes in the URL, this route cares
            about that query parameter, but the route is not currently
            in the active route hierarchy.
          */
          inactive: function inactive(prop, value) {
            var qp = map[prop];
            _this3._qpChanged(prop, value, qp);
          },
          /*
            Called when a query parameter changes in the URL, this route cares
            about that query parameter, and the route is currently
            in the active route hierarchy.
          */
          active: function active(prop, value) {
            var qp = map[prop];
            _this3._qpChanged(prop, value, qp);
            return _this3._activeQPChanged(qp, value);
          },
          /*
            Called when a value of a query parameter this route handles changes in a controller
            and the route is currently in the active route hierarchy.
          */
          allowOverrides: function allowOverrides(prop, value) {
            var qp = map[prop];
            _this3._qpChanged(prop, value, qp);
            return _this3._updatingQPChanged(qp);
          }
        }
      };
    }),
    /**
      Sends an action to the router, which will delegate it to the currently
      active route hierarchy per the bubbling rules explained under `actions`.
         Example
         ```app/router.js
      // ...
         Router.map(function() {
        this.route('index');
      });
         export default Router;
      ```
         ```app/routes/application.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class ApplicationRoute extends Route {
        @action
        track(arg) {
          console.log(arg, 'was clicked');
        }
      }
      ```
         ```app/routes/index.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class IndexRoute extends Route {
        @action
        trackIfDebug(arg) {
          if (debug) {
            this.send('track', arg);
          }
        }
      }
      ```
         @method send
      @param {String} name the name of the action to trigger
      @param {...*} args
      @since 1.0.0
      @public
    */
    send: function send() {
      for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .send() with the action '" + args[0] + "' on the destroyed route '" + this.routeName + "'.", !this.isDestroying && !this.isDestroyed));
      if (this._router && this._router._routerMicrolib || !(0, _debug.isTesting)()) {
        var _this$_router4;
        (_this$_router4 = this._router).send.apply(_this$_router4, args);
      } else {
        var name = args.shift();
        var action = this.actions[name];
        if (action) {
          return action.apply(this, args);
        }
      }
    },
    /**
      The controller associated with this route.
         Example
         ```app/routes/form.js
      import Route from '@ember/routing/route';
      import { action } from '@ember/object';
         export default class FormRoute extends Route {
        @action
        willTransition(transition) {
          if (this.controller.get('userHasEnteredData') &&
              !confirm('Are you sure you want to abandon progress?')) {
            transition.abort();
          } else {
            // Bubble the `willTransition` action so that
            // parent routes can decide whether or not to abort.
            return true;
          }
        }
      }
      ```
         @property controller
      @type Controller
      @since 1.6.0
      @public
    */
    actions: {
      /**
      This action is called when one or more query params have changed. Bubbles.
           @method queryParamsDidChange
      @param changed {Object} Keys are names of query params that have changed.
      @param totalPresent {Object} Keys are names of query params that are currently set.
      @param removed {Object} Keys are names of query params that have been removed.
      @returns {boolean}
      @private
      */
      queryParamsDidChange: function queryParamsDidChange(changed, _totalPresent, removed) {
        var qpMap = (0, _metal.get)(this, '_qp').map;
        var totalChanged = Object.keys(changed).concat(Object.keys(removed));
        for (var i = 0; i < totalChanged.length; ++i) {
          var qp = qpMap[totalChanged[i]];
          if (qp && (0, _metal.get)(this._optionsForQueryParam(qp), 'refreshModel') && this._router.currentState) {
            this.refresh();
            break;
          }
        }
        return true;
      },
      finalizeQueryParamChange: function finalizeQueryParamChange(params, finalParams, transition) {
        if (this.fullRouteName !== 'application') {
          return true;
        } // Transition object is absent for intermediate transitions.

        if (!transition) {
          return;
        }
        var routeInfos = transition[_router_js.STATE_SYMBOL].routeInfos;
        var router = this._router;
        var qpMeta = router._queryParamsFor(routeInfos);
        var changes = router._qpUpdates;
        var qpUpdated = false;
        var replaceUrl;
        (0, _utils2.stashParamNames)(router, routeInfos);
        for (var i = 0; i < qpMeta.qps.length; ++i) {
          var qp = qpMeta.qps[i];
          var route = qp.route;
          var controller = route.controller;
          var presentKey = qp.urlKey in params && qp.urlKey; // Do a reverse lookup to see if the changed query
          // param URL key corresponds to a QP property on
          // this controller.

          var value = void 0,
            svalue = void 0;
          if (changes.has(qp.urlKey)) {
            // Value updated in/before setupController
            value = (0, _metal.get)(controller, qp.prop);
            svalue = route.serializeQueryParam(value, qp.urlKey, qp.type);
          } else {
            if (presentKey) {
              svalue = params[presentKey];
              if (svalue !== undefined) {
                value = route.deserializeQueryParam(svalue, qp.urlKey, qp.type);
              }
            } else {
              // No QP provided; use default value.
              svalue = qp.serializedDefaultValue;
              value = copyDefaultValue(qp.defaultValue);
            }
          }
          controller._qpDelegate = (0, _metal.get)(route, '_qp.states.inactive');
          var thisQueryParamChanged = svalue !== qp.serializedValue;
          if (thisQueryParamChanged) {
            if (transition.queryParamsOnly && replaceUrl !== false) {
              var options = route._optionsForQueryParam(qp);
              var replaceConfigValue = (0, _metal.get)(options, 'replace');
              if (replaceConfigValue) {
                replaceUrl = true;
              } else if (replaceConfigValue === false) {
                // Explicit pushState wins over any other replaceStates.
                replaceUrl = false;
              }
            }
            (0, _metal.set)(controller, qp.prop, value);
            qpUpdated = true;
          } // Stash current serialized value of controller.

          qp.serializedValue = svalue;
          var thisQueryParamHasDefaultValue = qp.serializedDefaultValue === svalue;
          if (!thisQueryParamHasDefaultValue || transition._keepDefaultQueryParamValues) {
            finalParams.push({
              value: svalue,
              visible: true,
              key: presentKey || qp.urlKey
            });
          }
        } // Some QPs have been updated, and those changes need to be propogated
        // immediately. Eventually, we should work on making this async somehow.

        if (qpUpdated === true) {
          (0, _metal.flushAsyncObservers)(false);
        }
        if (replaceUrl) {
          transition.method('replace');
        }
        qpMeta.qps.forEach(function (qp) {
          var routeQpMeta = (0, _metal.get)(qp.route, '_qp');
          var finalizedController = qp.route.controller;
          finalizedController['_qpDelegate'] = (0, _metal.get)(routeQpMeta, 'states.active');
        });
        router._qpUpdates.clear();
        return;
      }
    }
  });
  var ROUTER_EVENT_DEPRECATIONS;
  _exports.ROUTER_EVENT_DEPRECATIONS = ROUTER_EVENT_DEPRECATIONS;
  if (_deprecatedFeatures.ROUTER_EVENTS) {
    _exports.ROUTER_EVENT_DEPRECATIONS = ROUTER_EVENT_DEPRECATIONS = {
      on: function on(name) {
        this._super.apply(this, arguments);
        var hasDidTransition = name === 'didTransition';
        var hasWillTransition = name === 'willTransition';
        if (hasDidTransition) {
          (true && !(false) && (0, _debug.deprecate)('You attempted to listen to the "didTransition" event which is deprecated. Please inject the router service and listen to the "routeDidChange" event.', false, {
            id: 'deprecate-router-events',
            until: '4.0.0',
            url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events',
            for: 'ember-source',
            since: {
              enabled: '3.11.0'
            }
          }));
        }
        if (hasWillTransition) {
          (true && !(false) && (0, _debug.deprecate)('You attempted to listen to the "willTransition" event which is deprecated. Please inject the router service and listen to the "routeWillChange" event.', false, {
            id: 'deprecate-router-events',
            until: '4.0.0',
            url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events',
            for: 'ember-source',
            since: {
              enabled: '3.11.0'
            }
          }));
        }
      }
    };
    Route.reopen(ROUTER_EVENT_DEPRECATIONS, {
      _paramsFor: function _paramsFor(routeName, params) {
        var transition = this._router._routerMicrolib.activeTransition;
        if (transition !== undefined) {
          return this.paramsFor(routeName);
        }
        return params;
      }
    });
  }
  var _default = Route;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/system/router", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/-internals/runtime", "@ember/debug", "@ember/deprecated-features", "@ember/error", "@ember/polyfills", "@ember/runloop", "@ember/-internals/routing/lib/location/api", "@ember/-internals/routing/lib/utils", "@ember/-internals/routing/lib/system/dsl", "@ember/-internals/routing/lib/system/route", "@ember/-internals/routing/lib/system/router_state", "router_js"], function (_exports, _emberBabel, _metal, _owner, _runtime, _debug, _deprecatedFeatures, _error3, _polyfills, _runloop, _api, _utils, _dsl, _route, _router_state, _router_js) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  _exports.triggerEvent = _triggerEvent;
  function defaultDidTransition(infos) {
    updatePaths(this);
    this._cancelSlowTransitionTimer();
    this.notifyPropertyChange('url');
    this.set('currentState', this.targetState); // Put this in the runloop so url will be accurate. Seems
    // less surprising than didTransition being out of sync.

    (0, _runloop.once)(this, this.trigger, 'didTransition');
    if (true /* DEBUG */) {
      if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
        // eslint-disable-next-line no-console
        console.log("Transitioned into '" + EmberRouter._routePath(infos) + "'");
      }
    }
  }
  function defaultWillTransition(oldInfos, newInfos, transition) {
    (0, _runloop.once)(this, this.trigger, 'willTransition', transition);
    if (true /* DEBUG */) {
      if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
        // eslint-disable-next-line no-console
        console.log("Preparing to transition from '" + EmberRouter._routePath(oldInfos) + "' to '" + EmberRouter._routePath(newInfos) + "'");
      }
    }
  }
  function K() {
    return this;
  }
  var slice = Array.prototype.slice;
  /**
    The `EmberRouter` class manages the application state and URLs. Refer to
    the [routing guide](https://guides.emberjs.com/release/routing/) for documentation.
  
    @class EmberRouter
    @extends EmberObject
    @uses Evented
    @public
  */
  var EmberRouter = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(EmberRouter, _EmberObject);
    function EmberRouter() {
      var _this;
      _this = _EmberObject.apply(this, arguments) || this;
      _this._didSetupRouter = false;
      _this._initialTransitionStarted = false;
      _this.currentURL = null;
      _this.currentRouteName = null;
      _this.currentPath = null;
      _this.currentRoute = null;
      _this._qpCache = Object.create(null);
      _this._qpUpdates = new Set();
      _this._queuedQPChanges = {};
      _this._toplevelView = null;
      _this._handledErrors = new Set();
      _this._engineInstances = Object.create(null);
      _this._engineInfoByRoute = Object.create(null);
      _this.currentState = null;
      _this.targetState = null;
      _this._resetQueuedQueryParameterChanges();
      return _this;
    }
    var _proto = EmberRouter.prototype;
    _proto._initRouterJs = function _initRouterJs() {
      var location = (0, _metal.get)(this, 'location');
      var router = this;
      var owner = (0, _owner.getOwner)(this);
      var seen = Object.create(null);
      var PrivateRouter = /*#__PURE__*/function (_Router) {
        (0, _emberBabel.inheritsLoose)(PrivateRouter, _Router);
        function PrivateRouter() {
          return _Router.apply(this, arguments) || this;
        }
        var _proto2 = PrivateRouter.prototype;
        _proto2.getRoute = function getRoute(name) {
          var routeName = name;
          var routeOwner = owner;
          var engineInfo = router._engineInfoByRoute[routeName];
          if (engineInfo) {
            var engineInstance = router._getEngineInstance(engineInfo);
            routeOwner = engineInstance;
            routeName = engineInfo.localFullName;
          }
          var fullRouteName = "route:" + routeName;
          var route = routeOwner.lookup(fullRouteName);
          if (seen[name]) {
            return route;
          }
          seen[name] = true;
          if (!route) {
            var DefaultRoute = routeOwner.factoryFor('route:basic').class;
            routeOwner.register(fullRouteName, DefaultRoute.extend());
            route = routeOwner.lookup(fullRouteName);
            if (true /* DEBUG */) {
              if ((0, _metal.get)(router, 'namespace.LOG_ACTIVE_GENERATION')) {
                (0, _debug.info)("generated -> " + fullRouteName, {
                  fullName: fullRouteName
                });
              }
            }
          }
          route._setRouteName(routeName);
          if (engineInfo && !(0, _route.hasDefaultSerialize)(route)) {
            throw new Error('Defining a custom serialize method on an Engine route is not supported.');
          }
          return route;
        };
        _proto2.getSerializer = function getSerializer(name) {
          var engineInfo = router._engineInfoByRoute[name]; // If this is not an Engine route, we fall back to the handler for serialization

          if (!engineInfo) {
            return;
          }
          return engineInfo.serializeMethod || _route.defaultSerialize;
        };
        _proto2.updateURL = function updateURL(path) {
          (0, _runloop.once)(function () {
            location.setURL(path);
            (0, _metal.set)(router, 'currentURL', path);
          });
        };
        _proto2.didTransition = function didTransition(infos) {
          if (_deprecatedFeatures.ROUTER_EVENTS) {
            if (router.didTransition !== defaultDidTransition) {
              (true && !(false) && (0, _debug.deprecate)('You attempted to override the "didTransition" method which is deprecated. Please inject the router service and listen to the "routeDidChange" event.', false, {
                id: 'deprecate-router-events',
                until: '4.0.0',
                url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events',
                for: 'ember-source',
                since: {
                  enabled: '3.11.0'
                }
              }));
            }
          }
          router.didTransition(infos);
        };
        _proto2.willTransition = function willTransition(oldInfos, newInfos, transition) {
          if (_deprecatedFeatures.ROUTER_EVENTS) {
            if (router.willTransition !== defaultWillTransition) {
              (true && !(false) && (0, _debug.deprecate)('You attempted to override the "willTransition" method which is deprecated. Please inject the router service and listen to the "routeWillChange" event.', false, {
                id: 'deprecate-router-events',
                until: '4.0.0',
                url: 'https://emberjs.com/deprecations/v3.x#toc_deprecate-router-events',
                for: 'ember-source',
                since: {
                  enabled: '3.11.0'
                }
              }));
            }
          }
          router.willTransition(oldInfos, newInfos, transition);
        };
        _proto2.triggerEvent = function triggerEvent(routeInfos, ignoreFailure, name, args) {
          return _triggerEvent.bind(router)(routeInfos, ignoreFailure, name, args);
        };
        _proto2.routeWillChange = function routeWillChange(transition) {
          router.trigger('routeWillChange', transition); // in case of intermediate transition we update the current route
          // to make router.currentRoute.name consistent with router.currentRouteName
          // see https://github.com/emberjs/ember.js/issues/19449

          if (transition.isIntermediate) {
            router.set('currentRoute', transition.to);
          }
        };
        _proto2.routeDidChange = function routeDidChange(transition) {
          router.set('currentRoute', transition.to);
          (0, _runloop.once)(function () {
            router.trigger('routeDidChange', transition);
          });
        };
        _proto2.transitionDidError = function transitionDidError(error, transition) {
          if (error.wasAborted || transition.isAborted) {
            // If the error was a transition erorr or the transition aborted
            // log the abort.
            return (0, _router_js.logAbort)(transition);
          } else {
            // Otherwise trigger the "error" event to attempt an intermediate
            // transition into an error substate
            transition.trigger(false, 'error', error.error, transition, error.route);
            if (router._isErrorHandled(error.error)) {
              // If we handled the error with a substate just roll the state back on
              // the transition and send the "routeDidChange" event for landing on
              // the error substate and return the error.
              transition.rollback();
              this.routeDidChange(transition);
              return error.error;
            } else {
              // If it was not handled, abort the transition completely and return
              // the error.
              transition.abort();
              return error.error;
            }
          }
        };
        _proto2.replaceURL = function replaceURL(url) {
          if (location.replaceURL) {
            var doReplaceURL = function doReplaceURL() {
              location.replaceURL(url);
              (0, _metal.set)(router, 'currentURL', url);
            };
            (0, _runloop.once)(doReplaceURL);
          } else {
            this.updateURL(url);
          }
        };
        return PrivateRouter;
      }(_router_js.default);
      var routerMicrolib = this._routerMicrolib = new PrivateRouter();
      var dslCallbacks = this.constructor.dslCallbacks || [K];
      var dsl = this._buildDSL();
      dsl.route('application', {
        path: '/',
        resetNamespace: true,
        overrideNameAssertion: true
      }, function () {
        for (var i = 0; i < dslCallbacks.length; i++) {
          dslCallbacks[i].call(this);
        }
      });
      if (true /* DEBUG */) {
        if ((0, _metal.get)(this, 'namespace.LOG_TRANSITIONS_INTERNAL')) {
          routerMicrolib.log = console.log.bind(console); // eslint-disable-line no-console
        }
      }

      routerMicrolib.map(dsl.generate());
    };
    _proto._buildDSL = function _buildDSL() {
      var enableLoadingSubstates = this._hasModuleBasedResolver();
      var router = this;
      var owner = (0, _owner.getOwner)(this);
      var options = {
        enableLoadingSubstates: enableLoadingSubstates,
        resolveRouteMap: function resolveRouteMap(name) {
          return owner.factoryFor("route-map:" + name);
        },
        addRouteForEngine: function addRouteForEngine(name, engineInfo) {
          if (!router._engineInfoByRoute[name]) {
            router._engineInfoByRoute[name] = engineInfo;
          }
        }
      };
      return new _dsl.default(null, options);
    }
    /*
      Resets all pending query parameter changes.
      Called after transitioning to a new route
      based on query parameter changes.
    */;
    _proto._resetQueuedQueryParameterChanges = function _resetQueuedQueryParameterChanges() {
      this._queuedQPChanges = {};
    };
    _proto._hasModuleBasedResolver = function _hasModuleBasedResolver() {
      var owner = (0, _owner.getOwner)(this);
      if (!owner) {
        return false;
      }
      var resolver = (0, _metal.get)(owner, 'application.__registry__.resolver.moduleBasedResolver');
      return Boolean(resolver);
    }
    /**
      Initializes the current router instance and sets up the change handling
      event listeners used by the instances `location` implementation.
         A property named `initialURL` will be used to determine the initial URL.
      If no value is found `/` will be used.
         @method startRouting
      @private
    */;
    _proto.startRouting = function startRouting() {
      if (this.setupRouter()) {
        var initialURL = (0, _metal.get)(this, 'initialURL');
        if (initialURL === undefined) {
          initialURL = (0, _metal.get)(this, 'location').getURL();
        }
        var initialTransition = this.handleURL(initialURL);
        if (initialTransition && initialTransition.error) {
          throw initialTransition.error;
        }
      }
    };
    _proto.setupRouter = function setupRouter() {
      var _this2 = this;
      if (this._didSetupRouter) {
        return false;
      }
      this._didSetupRouter = true;
      this._setupLocation();
      var location = (0, _metal.get)(this, 'location'); // Allow the Location class to cancel the router setup while it refreshes
      // the page

      if ((0, _metal.get)(location, 'cancelRouterSetup')) {
        return false;
      }
      this._initRouterJs();
      location.onUpdateURL(function (url) {
        _this2.handleURL(url);
      });
      return true;
    };
    _proto._setOutlets = function _setOutlets() {
      // This is triggered async during Route#willDestroy.
      // If the router is also being destroyed we do not want to
      // to create another this._toplevelView (and leak the renderer)
      if (this.isDestroying || this.isDestroyed) {
        return;
      }
      var routeInfos = this._routerMicrolib.currentRouteInfos;
      if (!routeInfos) {
        return;
      }
      var defaultParentState;
      var liveRoutes = null;
      for (var i = 0; i < routeInfos.length; i++) {
        var route = routeInfos[i].route;
        var connections = _route.ROUTE_CONNECTIONS.get(route);
        var ownState = void 0;
        if (connections.length === 0) {
          ownState = representEmptyRoute(liveRoutes, defaultParentState, route);
        } else {
          for (var j = 0; j < connections.length; j++) {
            var appended = appendLiveRoute(liveRoutes, defaultParentState, connections[j]);
            liveRoutes = appended.liveRoutes;
            var _appended$ownState$re = appended.ownState.render,
              name = _appended$ownState$re.name,
              outlet = _appended$ownState$re.outlet;
            if (name === route.routeName || outlet === 'main') {
              ownState = appended.ownState;
            }
          }
        }
        defaultParentState = ownState;
      } // when a transitionTo happens after the validation phase
      // during the initial transition _setOutlets is called
      // when no routes are active. However, it will get called
      // again with the correct values during the next turn of
      // the runloop

      if (!liveRoutes) {
        return;
      }
      if (!this._toplevelView) {
        var owner = (0, _owner.getOwner)(this);
        var OutletView = owner.factoryFor('view:-outlet');
        this._toplevelView = OutletView.create();
        this._toplevelView.setOutletState(liveRoutes);
        var instance = owner.lookup('-application-instance:main');
        if (instance) {
          instance.didCreateRootView(this._toplevelView);
        }
      } else {
        this._toplevelView.setOutletState(liveRoutes);
      }
    };
    _proto.handleURL = function handleURL(url) {
      // Until we have an ember-idiomatic way of accessing #hashes, we need to
      // remove it because router.js doesn't know how to handle it.
      var _url = url.split(/#(.+)?/)[0];
      return this._doURLTransition('handleURL', _url);
    };
    _proto._doURLTransition = function _doURLTransition(routerJsMethod, url) {
      this._initialTransitionStarted = true;
      var transition = this._routerMicrolib[routerJsMethod](url || '/');
      didBeginTransition(transition, this);
      return transition;
    }
    /**
      Transition the application into another route. The route may
      be either a single route or route path:
         See [transitionTo](/ember/release/classes/Route/methods/transitionTo?anchor=transitionTo) for more info.
         @method transitionTo
      @param {String} name the name of the route or a URL
      @param {...Object} models the model(s) or identifier(s) to be used while
        transitioning to the route.
      @param {Object} [options] optional hash with a queryParams property
        containing a mapping of query parameters
      @return {Transition} the transition object associated with this
        attempted transition
      @public
    */;
    _proto.transitionTo = function transitionTo() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      if ((0, _utils.resemblesURL)(args[0])) {
        (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("A transition was attempted from '" + this.currentRouteName + "' to '" + args[0] + "' but the application instance has already been destroyed.", !this.isDestroying && !this.isDestroyed));
        return this._doURLTransition('transitionTo', args[0]);
      }
      var _extractRouteArgs = (0, _utils.extractRouteArgs)(args),
        routeName = _extractRouteArgs.routeName,
        models = _extractRouteArgs.models,
        queryParams = _extractRouteArgs.queryParams;
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("A transition was attempted from '" + this.currentRouteName + "' to '" + routeName + "' but the application instance has already been destroyed.", !this.isDestroying && !this.isDestroyed));
      return this._doTransition(routeName, models, queryParams);
    };
    _proto.intermediateTransitionTo = function intermediateTransitionTo(name) {
      var _this$_routerMicrolib;
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }
      (_this$_routerMicrolib = this._routerMicrolib).intermediateTransitionTo.apply(_this$_routerMicrolib, [name].concat(args));
      updatePaths(this);
      if (true /* DEBUG */) {
        var infos = this._routerMicrolib.currentRouteInfos;
        if ((0, _metal.get)(this, 'namespace').LOG_TRANSITIONS) {
          // eslint-disable-next-line no-console
          console.log("Intermediate-transitioned into '" + EmberRouter._routePath(infos) + "'");
        }
      }
    };
    _proto.replaceWith = function replaceWith() {
      return this.transitionTo.apply(this, arguments).method('replace');
    };
    _proto.generate = function generate(name) {
      var _this$_routerMicrolib2;
      for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }
      var url = (_this$_routerMicrolib2 = this._routerMicrolib).generate.apply(_this$_routerMicrolib2, [name].concat(args));
      return this.location.formatURL(url);
    }
    /**
      Determines if the supplied route is currently active.
         @method isActive
      @param routeName
      @return {Boolean}
      @private
    */;
    _proto.isActive = function isActive(routeName) {
      return this._routerMicrolib.isActive(routeName);
    }
    /**
      An alternative form of `isActive` that doesn't require
      manual concatenation of the arguments into a single
      array.
         @method isActiveIntent
      @param routeName
      @param models
      @param queryParams
      @return {Boolean}
      @private
      @since 1.7.0
    */;
    _proto.isActiveIntent = function isActiveIntent(routeName, models, queryParams) {
      return this.currentState.isActiveIntent(routeName, models, queryParams);
    };
    _proto.send = function send(name) {
      var _this$_routerMicrolib3;
      for (var _len4 = arguments.length, args = new Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
        args[_key4 - 1] = arguments[_key4];
      }
      /*name, context*/
      (_this$_routerMicrolib3 = this._routerMicrolib).trigger.apply(_this$_routerMicrolib3, [name].concat(args));
    }
    /**
      Does this router instance have the given route.
         @method hasRoute
      @return {Boolean}
      @private
    */;
    _proto.hasRoute = function hasRoute(route) {
      return this._routerMicrolib.hasRoute(route);
    }
    /**
      Resets the state of the router by clearing the current route
      handlers and deactivating them.
         @private
      @method reset
     */;
    _proto.reset = function reset() {
      this._didSetupRouter = false;
      this._initialTransitionStarted = false;
      if (this._routerMicrolib) {
        this._routerMicrolib.reset();
      }
    };
    _proto.willDestroy = function willDestroy() {
      if (this._toplevelView) {
        this._toplevelView.destroy();
        this._toplevelView = null;
      }
      _EmberObject.prototype.willDestroy.call(this);
      this.reset();
      var instances = this._engineInstances;
      for (var name in instances) {
        for (var id in instances[name]) {
          (0, _runloop.run)(instances[name][id], 'destroy');
        }
      }
    }
    /*
      Called when an active route's query parameter has changed.
      These changes are batched into a runloop run and trigger
      a single transition.
    */;
    _proto._activeQPChanged = function _activeQPChanged(queryParameterName, newValue) {
      this._queuedQPChanges[queryParameterName] = newValue;
      (0, _runloop.once)(this, this._fireQueryParamTransition);
    };
    _proto._updatingQPChanged = function _updatingQPChanged(queryParameterName) {
      this._qpUpdates.add(queryParameterName);
    }
    /*
      Triggers a transition to a route based on query parameter changes.
      This is called once per runloop, to batch changes.
         e.g.
         if these methods are called in succession:
      this._activeQPChanged('foo', '10');
        // results in _queuedQPChanges = { foo: '10' }
      this._activeQPChanged('bar', false);
        // results in _queuedQPChanges = { foo: '10', bar: false }
         _queuedQPChanges will represent both of these changes
      and the transition using `transitionTo` will be triggered
      once.
    */;
    _proto._fireQueryParamTransition = function _fireQueryParamTransition() {
      this.transitionTo({
        queryParams: this._queuedQPChanges
      });
      this._resetQueuedQueryParameterChanges();
    };
    _proto._setupLocation = function _setupLocation() {
      var location = this.location;
      var rootURL = this.rootURL;
      var owner = (0, _owner.getOwner)(this);
      if ('string' === typeof location && owner) {
        var resolvedLocation = owner.lookup("location:" + location);
        if (resolvedLocation !== undefined) {
          location = (0, _metal.set)(this, 'location', resolvedLocation);
        } else {
          // Allow for deprecated registration of custom location API's
          var options = {
            implementation: location
          };
          location = (0, _metal.set)(this, 'location', _api.default.create(options));
        }
      }
      if (location !== null && typeof location === 'object') {
        if (rootURL) {
          (0, _metal.set)(location, 'rootURL', rootURL);
        } // Allow the location to do any feature detection, such as AutoLocation
        // detecting history support. This gives it a chance to set its
        // `cancelRouterSetup` property which aborts routing.

        if (typeof location.detect === 'function') {
          location.detect();
        } // ensure that initState is called AFTER the rootURL is set on
        // the location instance

        if (typeof location.initState === 'function') {
          location.initState();
        }
      }
    }
    /**
      Serializes the given query params according to their QP meta information.
         @private
      @method _serializeQueryParams
      @param {Arrray<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */;
    _proto._serializeQueryParams = function _serializeQueryParams(routeInfos, queryParams) {
      var _this3 = this;
      forEachQueryParam(this, routeInfos, queryParams, function (key, value, qp) {
        if (qp) {
          delete queryParams[key];
          queryParams[qp.urlKey] = qp.route.serializeQueryParam(value, qp.urlKey, qp.type);
        } else if (value === undefined) {
          return; // We don't serialize undefined values
        } else {
          queryParams[key] = _this3._serializeQueryParam(value, (0, _runtime.typeOf)(value));
        }
      });
    }
    /**
      Serializes the value of a query parameter based on a type
         @private
      @method _serializeQueryParam
      @param {Object} value
      @param {String} type
    */;
    _proto._serializeQueryParam = function _serializeQueryParam(value, type) {
      if (value === null || value === undefined) {
        return value;
      } else if (type === 'array') {
        return JSON.stringify(value);
      }
      return "" + value;
    }
    /**
      Deserializes the given query params according to their QP meta information.
         @private
      @method _deserializeQueryParams
      @param {Array<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */;
    _proto._deserializeQueryParams = function _deserializeQueryParams(routeInfos, queryParams) {
      forEachQueryParam(this, routeInfos, queryParams, function (key, value, qp) {
        // If we don't have QP meta info for a given key, then we do nothing
        // because all values will be treated as strings
        if (qp) {
          delete queryParams[key];
          queryParams[qp.prop] = qp.route.deserializeQueryParam(value, qp.urlKey, qp.type);
        }
      });
    }
    /**
      Deserializes the value of a query parameter based on a default type
         @private
      @method _deserializeQueryParam
      @param {Object} value
      @param {String} defaultType
    */;
    _proto._deserializeQueryParam = function _deserializeQueryParam(value, defaultType) {
      if (value === null || value === undefined) {
        return value;
      } else if (defaultType === 'boolean') {
        return value === 'true';
      } else if (defaultType === 'number') {
        return Number(value).valueOf();
      } else if (defaultType === 'array') {
        return (0, _runtime.A)(JSON.parse(value));
      }
      return value;
    }
    /**
      Removes (prunes) any query params with default values from the given QP
      object. Default values are determined from the QP meta information per key.
         @private
      @method _pruneDefaultQueryParamValues
      @param {Array<RouteInfo>} routeInfos
      @param {Object} queryParams
      @return {Void}
    */;
    _proto._pruneDefaultQueryParamValues = function _pruneDefaultQueryParamValues(routeInfos, queryParams) {
      var qps = this._queryParamsFor(routeInfos);
      for (var key in queryParams) {
        var qp = qps.map[key];
        if (qp && qp.serializedDefaultValue === queryParams[key]) {
          delete queryParams[key];
        }
      }
    };
    _proto._doTransition = function _doTransition(_targetRouteName, models, _queryParams, _keepDefaultQueryParamValues) {
      var _this$_routerMicrolib4;
      var targetRouteName = _targetRouteName || (0, _utils.getActiveTargetName)(this._routerMicrolib);
      (true && !(Boolean(targetRouteName) && this._routerMicrolib.hasRoute(targetRouteName)) && (0, _debug.assert)("The route " + targetRouteName + " was not found", Boolean(targetRouteName) && this._routerMicrolib.hasRoute(targetRouteName)));
      this._initialTransitionStarted = true;
      var queryParams = {};
      this._processActiveTransitionQueryParams(targetRouteName, models, queryParams, _queryParams);
      (0, _polyfills.assign)(queryParams, _queryParams);
      this._prepareQueryParams(targetRouteName, models, queryParams, Boolean(_keepDefaultQueryParamValues));
      var transition = (_this$_routerMicrolib4 = this._routerMicrolib).transitionTo.apply(_this$_routerMicrolib4, [targetRouteName].concat(models, [{
        queryParams: queryParams
      }]));
      didBeginTransition(transition, this);
      return transition;
    };
    _proto._processActiveTransitionQueryParams = function _processActiveTransitionQueryParams(targetRouteName, models, queryParams, _queryParams) {
      // merge in any queryParams from the active transition which could include
      // queryParams from the url on initial load.
      if (!this._routerMicrolib.activeTransition) {
        return;
      }
      var unchangedQPs = {};
      var qpUpdates = this._qpUpdates;
      var params = (0, _route.getFullQueryParams)(this, this._routerMicrolib.activeTransition[_router_js.STATE_SYMBOL]);
      for (var key in params) {
        if (!qpUpdates.has(key)) {
          unchangedQPs[key] = params[key];
        }
      } // We need to fully scope queryParams so that we can create one object
      // that represents both passed-in queryParams and ones that aren't changed
      // from the active transition.

      this._fullyScopeQueryParams(targetRouteName, models, _queryParams);
      this._fullyScopeQueryParams(targetRouteName, models, unchangedQPs);
      (0, _polyfills.assign)(queryParams, unchangedQPs);
    }
    /**
      Prepares the query params for a URL or Transition. Restores any undefined QP
      keys/values, serializes all values, and then prunes any default values.
         @private
      @method _prepareQueryParams
      @param {String} targetRouteName
      @param {Array<Object>} models
      @param {Object} queryParams
      @param {boolean} keepDefaultQueryParamValues
      @return {Void}
    */;
    _proto._prepareQueryParams = function _prepareQueryParams(targetRouteName, models, queryParams, _fromRouterService) {
      var state = calculatePostTransitionState(this, targetRouteName, models);
      this._hydrateUnsuppliedQueryParams(state, queryParams, Boolean(_fromRouterService));
      this._serializeQueryParams(state.routeInfos, queryParams);
      if (!_fromRouterService) {
        this._pruneDefaultQueryParamValues(state.routeInfos, queryParams);
      }
    }
    /**
      Returns the meta information for the query params of a given route. This
      will be overridden to allow support for lazy routes.
         @private
      @method _getQPMeta
      @param {RouteInfo} routeInfo
      @return {Object}
    */;
    _proto._getQPMeta = function _getQPMeta(routeInfo) {
      var route = routeInfo.route;
      return route && (0, _metal.get)(route, '_qp');
    }
    /**
      Returns a merged query params meta object for a given set of routeInfos.
      Useful for knowing what query params are available for a given route hierarchy.
         @private
      @method _queryParamsFor
      @param {Array<RouteInfo>} routeInfos
      @return {Object}
     */;
    _proto._queryParamsFor = function _queryParamsFor(routeInfos) {
      var routeInfoLength = routeInfos.length;
      var leafRouteName = routeInfos[routeInfoLength - 1].name;
      var cached = this._qpCache[leafRouteName];
      if (cached !== undefined) {
        return cached;
      }
      var shouldCache = true;
      var map = {};
      var qps = [];
      var qpsByUrlKey = true /* DEBUG */ ? {} : null;
      var qpMeta;
      var qp;
      var urlKey;
      var qpOther;
      for (var i = 0; i < routeInfoLength; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);
        if (!qpMeta) {
          shouldCache = false;
          continue;
        } // Loop over each QP to make sure we don't have any collisions by urlKey

        for (var _i = 0; _i < qpMeta.qps.length; _i++) {
          qp = qpMeta.qps[_i];
          if (true /* DEBUG */) {
            urlKey = qp.urlKey;
            qpOther = qpsByUrlKey[urlKey];
            if (qpOther && qpOther.controllerName !== qp.controllerName) {
              (true && !(false) && (0, _debug.assert)("You're not allowed to have more than one controller property map to the same query param key, but both `" + qpOther.scopedPropertyName + "` and `" + qp.scopedPropertyName + "` map to `" + urlKey + "`. You can fix this by mapping one of the controller properties to a different query param key via the `as` config option, e.g. `" + qpOther.prop + ": { as: 'other-" + qpOther.prop + "' }`", false));
            }
            qpsByUrlKey[urlKey] = qp;
          }
          qps.push(qp);
        }
        (0, _polyfills.assign)(map, qpMeta.map);
      }
      var finalQPMeta = {
        qps: qps,
        map: map
      };
      if (shouldCache) {
        this._qpCache[leafRouteName] = finalQPMeta;
      }
      return finalQPMeta;
    }
    /**
      Maps all query param keys to their fully scoped property name of the form
      `controllerName:propName`.
         @private
      @method _fullyScopeQueryParams
      @param {String} leafRouteName
      @param {Array<Object>} contexts
      @param {Object} queryParams
      @return {Void}
    */;
    _proto._fullyScopeQueryParams = function _fullyScopeQueryParams(leafRouteName, contexts, queryParams) {
      var state = calculatePostTransitionState(this, leafRouteName, contexts);
      var routeInfos = state.routeInfos;
      var qpMeta;
      for (var i = 0, len = routeInfos.length; i < len; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);
        if (!qpMeta) {
          continue;
        }
        var qp = void 0;
        var presentProp = void 0;
        for (var j = 0, qpLen = qpMeta.qps.length; j < qpLen; ++j) {
          qp = qpMeta.qps[j];
          presentProp = qp.prop in queryParams && qp.prop || qp.scopedPropertyName in queryParams && qp.scopedPropertyName || qp.urlKey in queryParams && qp.urlKey;
          if (presentProp) {
            if (presentProp !== qp.scopedPropertyName) {
              queryParams[qp.scopedPropertyName] = queryParams[presentProp];
              delete queryParams[presentProp];
            }
          }
        }
      }
    }
    /**
      Hydrates (adds/restores) any query params that have pre-existing values into
      the given queryParams hash. This is what allows query params to be "sticky"
      and restore their last known values for their scope.
         @private
      @method _hydrateUnsuppliedQueryParams
      @param {TransitionState} state
      @param {Object} queryParams
      @return {Void}
    */;
    _proto._hydrateUnsuppliedQueryParams = function _hydrateUnsuppliedQueryParams(state, queryParams, _fromRouterService) {
      var routeInfos = state.routeInfos;
      var appCache = this._bucketCache;
      var qpMeta;
      var qp;
      var presentProp;
      for (var i = 0; i < routeInfos.length; ++i) {
        qpMeta = this._getQPMeta(routeInfos[i]);
        if (!qpMeta) {
          continue;
        }
        for (var j = 0, qpLen = qpMeta.qps.length; j < qpLen; ++j) {
          qp = qpMeta.qps[j];
          presentProp = qp.prop in queryParams && qp.prop || qp.scopedPropertyName in queryParams && qp.scopedPropertyName || qp.urlKey in queryParams && qp.urlKey;
          (true && !(function () {
            if (qp.urlKey === presentProp || qp.scopedPropertyName === presentProp) {
              return true;
            }
            if (_fromRouterService && presentProp !== false && qp.urlKey !== qp.prop) {
              // assumptions (mainly from current transitionTo_test):
              // - this is only supposed to be run when there is an alias to a query param and the alias is used to set the param
              // - when there is no alias: qp.urlKey == qp.prop
              return false;
            }
            return true;
          }()) && (0, _debug.assert)("You passed the `" + presentProp + "` query parameter during a transition into " + qp.route.routeName + ", please update to " + qp.urlKey, function () {
            if (qp.urlKey === presentProp || qp.scopedPropertyName === presentProp) {
              return true;
            }
            if (_fromRouterService && presentProp !== false && qp.urlKey !== qp.prop) {
              return false;
            }
            return true;
          }()));
          if (presentProp) {
            if (presentProp !== qp.scopedPropertyName) {
              queryParams[qp.scopedPropertyName] = queryParams[presentProp];
              delete queryParams[presentProp];
            }
          } else {
            var cacheKey = (0, _utils.calculateCacheKey)(qp.route.fullRouteName, qp.parts, state.params);
            queryParams[qp.scopedPropertyName] = appCache.lookup(cacheKey, qp.prop, qp.defaultValue);
          }
        }
      }
    };
    _proto._scheduleLoadingEvent = function _scheduleLoadingEvent(transition, originRoute) {
      this._cancelSlowTransitionTimer();
      this._slowTransitionTimer = (0, _runloop.scheduleOnce)('routerTransitions', this, '_handleSlowTransition', transition, originRoute);
    };
    _proto._handleSlowTransition = function _handleSlowTransition(transition, originRoute) {
      if (!this._routerMicrolib.activeTransition) {
        // Don't fire an event if we've since moved on from
        // the transition that put us in a loading state.
        return;
      }
      var targetState = new _router_state.default(this, this._routerMicrolib, this._routerMicrolib.activeTransition[_router_js.STATE_SYMBOL]);
      this.set('targetState', targetState);
      transition.trigger(true, 'loading', transition, originRoute);
    };
    _proto._cancelSlowTransitionTimer = function _cancelSlowTransitionTimer() {
      if (this._slowTransitionTimer) {
        (0, _runloop.cancel)(this._slowTransitionTimer);
      }
      this._slowTransitionTimer = null;
    } // These three helper functions are used to ensure errors aren't
    // re-raised if they're handled in a route's error action.
    ;
    _proto._markErrorAsHandled = function _markErrorAsHandled(error) {
      this._handledErrors.add(error);
    };
    _proto._isErrorHandled = function _isErrorHandled(error) {
      return this._handledErrors.has(error);
    };
    _proto._clearHandledError = function _clearHandledError(error) {
      this._handledErrors.delete(error);
    };
    _proto._getEngineInstance = function _getEngineInstance(_ref) {
      var name = _ref.name,
        instanceId = _ref.instanceId,
        mountPoint = _ref.mountPoint;
      var engineInstances = this._engineInstances;
      if (!engineInstances[name]) {
        engineInstances[name] = Object.create(null);
      }
      var engineInstance = engineInstances[name][instanceId];
      if (!engineInstance) {
        var owner = (0, _owner.getOwner)(this);
        (true && !(owner.hasRegistration("engine:" + name)) && (0, _debug.assert)("You attempted to mount the engine '" + name + "' in your router map, but the engine can not be found.", owner.hasRegistration("engine:" + name)));
        engineInstance = owner.buildChildEngineInstance(name, {
          routable: true,
          mountPoint: mountPoint
        });
        engineInstance.boot();
        engineInstances[name][instanceId] = engineInstance;
      }
      return engineInstance;
    };
    return EmberRouter;
  }(_runtime.Object);
  /*
    Helper function for iterating over routes in a set of routeInfos that are
    at or above the given origin route. Example: if `originRoute` === 'foo.bar'
    and the routeInfos given were for 'foo.bar.baz', then the given callback
    will be invoked with the routes for 'foo.bar', 'foo', and 'application'
    individually.
  
    If the callback returns anything other than `true`, then iteration will stop.
  
    @private
    @param {Route} originRoute
    @param {Array<RouteInfo>} routeInfos
    @param {Function} callback
    @return {Void}
   */
  function forEachRouteAbove(routeInfos, callback) {
    for (var i = routeInfos.length - 1; i >= 0; --i) {
      var routeInfo = routeInfos[i];
      var route = routeInfo.route; // routeInfo.handler being `undefined` generally means either:
      //
      // 1. an error occurred during creation of the route in question
      // 2. the route is across an async boundary (e.g. within an engine)
      //
      // In both of these cases, we cannot invoke the callback on that specific
      // route, because it just doesn't exist...

      if (route === undefined) {
        continue;
      }
      if (callback(route, routeInfo) !== true) {
        return;
      }
    }
  } // These get invoked when an action bubbles above ApplicationRoute
  // and are not meant to be overridable.

  var defaultActionHandlers = {
    willResolveModel: function willResolveModel(_routeInfos, transition, originRoute) {
      this._scheduleLoadingEvent(transition, originRoute);
    },
    // Attempt to find an appropriate error route or substate to enter.
    error: function error(routeInfos, _error2, transition) {
      var router = this;
      var routeInfoWithError = routeInfos[routeInfos.length - 1];
      forEachRouteAbove(routeInfos, function (route, routeInfo) {
        // We don't check the leaf most routeInfo since that would
        // technically be below where we're at in the route hierarchy.
        if (routeInfo !== routeInfoWithError) {
          // Check for the existence of an 'error' route.
          var errorRouteName = findRouteStateName(route, 'error');
          if (errorRouteName) {
            router._markErrorAsHandled(_error2);
            router.intermediateTransitionTo(errorRouteName, _error2);
            return false;
          }
        } // Check for an 'error' substate route

        var errorSubstateName = findRouteSubstateName(route, 'error');
        if (errorSubstateName) {
          router._markErrorAsHandled(_error2);
          router.intermediateTransitionTo(errorSubstateName, _error2);
          return false;
        }
        return true;
      });
      logError(_error2, "Error while processing route: " + transition.targetName);
    },
    // Attempt to find an appropriate loading route or substate to enter.
    loading: function loading(routeInfos, transition) {
      var router = this;
      var routeInfoWithSlowLoading = routeInfos[routeInfos.length - 1];
      forEachRouteAbove(routeInfos, function (route, routeInfo) {
        // We don't check the leaf most routeInfos since that would
        // technically be below where we're at in the route hierarchy.
        if (routeInfo !== routeInfoWithSlowLoading) {
          // Check for the existence of a 'loading' route.
          var loadingRouteName = findRouteStateName(route, 'loading');
          if (loadingRouteName) {
            router.intermediateTransitionTo(loadingRouteName);
            return false;
          }
        } // Check for loading substate

        var loadingSubstateName = findRouteSubstateName(route, 'loading');
        if (loadingSubstateName) {
          router.intermediateTransitionTo(loadingSubstateName);
          return false;
        } // Don't bubble above pivot route.

        return transition.pivotHandler !== route;
      });
    }
  };
  function logError(_error, initialMessage) {
    var _console;
    var errorArgs = [];
    var error;
    if (_error && typeof _error === 'object' && typeof _error.errorThrown === 'object') {
      error = _error.errorThrown;
    } else {
      error = _error;
    }
    if (initialMessage) {
      errorArgs.push(initialMessage);
    }
    if (error) {
      if (error.message) {
        errorArgs.push(error.message);
      }
      if (error.stack) {
        errorArgs.push(error.stack);
      }
      if (typeof error === 'string') {
        errorArgs.push(error);
      }
    }
    (_console = console).error.apply(_console, errorArgs); //eslint-disable-line no-console
  }
  /**
    Finds the name of the substate route if it exists for the given route. A
    substate route is of the form `route_state`, such as `foo_loading`.
  
    @private
    @param {Route} route
    @param {String} state
    @return {String}
  */

  function findRouteSubstateName(route, state) {
    var owner = (0, _owner.getOwner)(route);
    var routeName = route.routeName,
      fullRouteName = route.fullRouteName,
      router = route._router;
    var substateName = routeName + "_" + state;
    var substateNameFull = fullRouteName + "_" + state;
    return routeHasBeenDefined(owner, router, substateName, substateNameFull) ? substateNameFull : '';
  }
  /**
    Finds the name of the state route if it exists for the given route. A state
    route is of the form `route.state`, such as `foo.loading`. Properly Handles
    `application` named routes.
  
    @private
    @param {Route} route
    @param {String} state
    @return {String}
  */

  function findRouteStateName(route, state) {
    var owner = (0, _owner.getOwner)(route);
    var routeName = route.routeName,
      fullRouteName = route.fullRouteName,
      router = route._router;
    var stateName = routeName === 'application' ? state : routeName + "." + state;
    var stateNameFull = fullRouteName === 'application' ? state : fullRouteName + "." + state;
    return routeHasBeenDefined(owner, router, stateName, stateNameFull) ? stateNameFull : '';
  }
  /**
    Determines whether or not a route has been defined by checking that the route
    is in the Router's map and the owner has a registration for that route.
  
    @private
    @param {Owner} owner
    @param {Router} router
    @param {String} localName
    @param {String} fullName
    @return {Boolean}
  */

  function routeHasBeenDefined(owner, router, localName, fullName) {
    var routerHasRoute = router.hasRoute(fullName);
    var ownerHasRoute = owner.hasRegistration("template:" + localName) || owner.hasRegistration("route:" + localName);
    return routerHasRoute && ownerHasRoute;
  }
  function _triggerEvent(routeInfos, ignoreFailure, name, args) {
    if (!routeInfos) {
      if (ignoreFailure) {
        return;
      }
      throw new _error3.default("Can't trigger action '" + name + "' because your app hasn't finished transitioning into its first route. To trigger an action on destination routes during a transition, you can call `.send()` on the `Transition` object passed to the `model/beforeModel/afterModel` hooks.");
    }
    var eventWasHandled = false;
    var routeInfo, handler, actionHandler;
    for (var i = routeInfos.length - 1; i >= 0; i--) {
      routeInfo = routeInfos[i];
      handler = routeInfo.route;
      actionHandler = handler && handler.actions && handler.actions[name];
      if (actionHandler) {
        if (actionHandler.apply(handler, args) === true) {
          eventWasHandled = true;
        } else {
          // Should only hit here if a non-bubbling error action is triggered on a route.
          if (name === 'error') {
            handler._router._markErrorAsHandled(args[0]);
          }
          return;
        }
      }
    }
    var defaultHandler = defaultActionHandlers[name];
    if (defaultHandler) {
      defaultHandler.apply(this, [routeInfos].concat(args));
      return;
    }
    if (!eventWasHandled && !ignoreFailure) {
      throw new _error3.default("Nothing handled the action '" + name + "'. If you did handle the action, this error can be caused by returning true from an action handler in a controller, causing the action to bubble.");
    }
  }
  function calculatePostTransitionState(emberRouter, leafRouteName, contexts) {
    var state = emberRouter._routerMicrolib.applyIntent(leafRouteName, contexts);
    var routeInfos = state.routeInfos,
      params = state.params;
    for (var i = 0; i < routeInfos.length; ++i) {
      var routeInfo = routeInfos[i]; // If the routeInfo is not resolved, we serialize the context into params

      if (!routeInfo.isResolved) {
        params[routeInfo.name] = routeInfo.serialize(routeInfo.context);
      } else {
        params[routeInfo.name] = routeInfo.params;
      }
    }
    return state;
  }
  function updatePaths(router) {
    var infos = router._routerMicrolib.currentRouteInfos;
    if (infos.length === 0) {
      return;
    }
    var path = EmberRouter._routePath(infos);
    var currentRouteName = infos[infos.length - 1].name;
    var currentURL = router.get('location').getURL();
    (0, _metal.set)(router, 'currentPath', path);
    (0, _metal.set)(router, 'currentRouteName', currentRouteName);
    (0, _metal.set)(router, 'currentURL', currentURL);
    var appController = (0, _owner.getOwner)(router).lookup('controller:application');
    if (!appController) {
      // appController might not exist when top-level loading/error
      // substates have been entered since ApplicationRoute hasn't
      // actually been entered at that point.
      return;
    }
    if (_deprecatedFeatures.APP_CTRL_ROUTER_PROPS) {
      if (!('currentPath' in appController)) {
        Object.defineProperty(appController, 'currentPath', {
          get: function get() {
            (true && !(false) && (0, _debug.deprecate)('Accessing `currentPath` on `controller:application` is deprecated, use the `currentPath` property on `service:router` instead.', false, {
              id: 'application-controller.router-properties',
              until: '4.0.0',
              url: 'https://emberjs.com/deprecations/v3.x#toc_application-controller-router-properties',
              for: 'ember-source',
              since: {
                enabled: '3.10.0-beta.1'
              }
            }));
            return (0, _metal.get)(router, 'currentPath');
          }
        });
      }
      (0, _metal.notifyPropertyChange)(appController, 'currentPath');
      if (!('currentRouteName' in appController)) {
        Object.defineProperty(appController, 'currentRouteName', {
          get: function get() {
            (true && !(false) && (0, _debug.deprecate)('Accessing `currentRouteName` on `controller:application` is deprecated, use the `currentRouteName` property on `service:router` instead.', false, {
              id: 'application-controller.router-properties',
              until: '4.0.0',
              url: 'https://emberjs.com/deprecations/v3.x#toc_application-controller-router-properties',
              for: 'ember-source',
              since: {
                enabled: '3.10.0-beta.1'
              }
            }));
            return (0, _metal.get)(router, 'currentRouteName');
          }
        });
      }
      (0, _metal.notifyPropertyChange)(appController, 'currentRouteName');
    }
  }
  EmberRouter.reopenClass({
    /**
      The `Router.map` function allows you to define mappings from URLs to routes
      in your application. These mappings are defined within the
      supplied callback function using `this.route`.
         The first parameter is the name of the route which is used by default as the
      path name as well.
         The second parameter is the optional options hash. Available options are:
           * `path`: allows you to provide your own path as well as mark dynamic
          segments.
        * `resetNamespace`: false by default; when nesting routes, ember will
          combine the route names to form the fully-qualified route name, which is
          used with `{{link-to}}` or manually transitioning to routes. Setting
          `resetNamespace: true` will cause the route not to inherit from its
          parent route's names. This is handy for preventing extremely long route names.
          Keep in mind that the actual URL path behavior is still retained.
         The third parameter is a function, which can be used to nest routes.
      Nested routes, by default, will have the parent route tree's route name and
      path prepended to it's own.
         ```app/router.js
      Router.map(function(){
        this.route('post', { path: '/post/:post_id' }, function() {
          this.route('edit');
          this.route('comments', { resetNamespace: true }, function() {
            this.route('new');
          });
        });
      });
      ```
         @method map
      @param callback
      @public
    */
    map: function map(callback) {
      if (!this.dslCallbacks) {
        this.dslCallbacks = [];
        this.reopenClass({
          dslCallbacks: this.dslCallbacks
        });
      }
      this.dslCallbacks.push(callback);
      return this;
    },
    _routePath: function _routePath(routeInfos) {
      var path = []; // We have to handle coalescing resource names that
      // are prefixed with their parent's names, e.g.
      // ['foo', 'foo.bar.baz'] => 'foo.bar.baz', not 'foo.foo.bar.baz'

      function intersectionMatches(a1, a2) {
        for (var i = 0; i < a1.length; ++i) {
          if (a1[i] !== a2[i]) {
            return false;
          }
        }
        return true;
      }
      var name, nameParts, oldNameParts;
      for (var i = 1; i < routeInfos.length; i++) {
        name = routeInfos[i].name;
        nameParts = name.split('.');
        oldNameParts = slice.call(path);
        while (oldNameParts.length) {
          if (intersectionMatches(oldNameParts, nameParts)) {
            break;
          }
          oldNameParts.shift();
        }
        path.push.apply(path, nameParts.slice(oldNameParts.length));
      }
      return path.join('.');
    }
  });
  function didBeginTransition(transition, router) {
    var routerState = new _router_state.default(router, router._routerMicrolib, transition[_router_js.STATE_SYMBOL]);
    if (!router.currentState) {
      router.set('currentState', routerState);
    }
    router.set('targetState', routerState);
    transition.promise = transition.catch(function (error) {
      if (router._isErrorHandled(error)) {
        router._clearHandledError(error);
      } else {
        throw error;
      }
    }, 'Transition Error');
  }
  function forEachQueryParam(router, routeInfos, queryParams, callback) {
    var qpCache = router._queryParamsFor(routeInfos);
    for (var key in queryParams) {
      if (!Object.prototype.hasOwnProperty.call(queryParams, key)) {
        continue;
      }
      var value = queryParams[key];
      var qp = qpCache.map[key];
      callback(key, value, qp);
    }
  }
  function findLiveRoute(liveRoutes, name) {
    if (!liveRoutes) {
      return;
    }
    var stack = [liveRoutes];
    while (stack.length > 0) {
      var test = stack.shift();
      if (test.render.name === name) {
        return test;
      }
      var outlets = test.outlets;
      for (var outletName in outlets) {
        stack.push(outlets[outletName]);
      }
    }
    return;
  }
  function appendLiveRoute(liveRoutes, defaultParentState, renderOptions) {
    var ownState = {
      render: renderOptions,
      outlets: Object.create(null),
      wasUsed: false
    };
    var target;
    if (renderOptions.into) {
      target = findLiveRoute(liveRoutes, renderOptions.into);
    } else {
      target = defaultParentState;
    }
    if (target) {
      (0, _metal.set)(target.outlets, renderOptions.outlet, ownState);
    } else {
      liveRoutes = ownState;
    }
    return {
      liveRoutes: liveRoutes,
      ownState: ownState
    };
  }
  function representEmptyRoute(liveRoutes, defaultParentState, _ref2) {
    var routeName = _ref2.routeName;
    // the route didn't render anything
    var alreadyAppended = findLiveRoute(liveRoutes, routeName);
    if (alreadyAppended) {
      // But some other route has already rendered our default
      // template, so that becomes the default target for any
      // children we may have.
      return alreadyAppended;
    } else {
      // Create an entry to represent our default template name,
      // just so other routes can target it and inherit its place
      // in the outlet hierarchy.
      defaultParentState.outlets.main = {
        render: {
          name: routeName,
          outlet: 'main'
        },
        outlets: {}
      };
      return defaultParentState;
    }
  }
  EmberRouter.reopen(_runtime.Evented, {
    /**
      Handles updating the paths and notifying any listeners of the URL
      change.
         Triggers the router level `didTransition` hook.
         For example, to notify google analytics when the route changes,
      you could use this hook.  (Note: requires also including GA scripts, etc.)
         ```javascript
      import config from './config/environment';
      import EmberRouter from '@ember/routing/router';
      import { inject as service } from '@ember/service';
         let Router = EmberRouter.extend({
        location: config.locationType,
           router: service(),
           didTransition: function() {
          this._super(...arguments);
             ga('send', 'pageview', {
            page: this.router.currentURL,
            title: this.router.currentRouteName,
          });
        }
      });
      ```
         @method didTransition
      @public
      @since 1.2.0
    */
    didTransition: defaultDidTransition,
    /**
      Handles notifying any listeners of an impending URL
      change.
         Triggers the router level `willTransition` hook.
         @method willTransition
      @public
      @since 1.11.0
    */
    willTransition: defaultWillTransition,
    /**
     Represents the URL of the root of the application, often '/'. This prefix is
     assumed on all routes defined on this router.
        @property rootURL
     @default '/'
     @public
    */
    rootURL: '/',
    /**
     The `location` property determines the type of URL's that your
     application will use.
        The following location types are currently available:
        * `history` - use the browser's history API to make the URLs look just like any standard URL
     * `hash` - use `#` to separate the server part of the URL from the Ember part: `/blog/#/posts/new`
     * `none` - do not store the Ember URL in the actual browser URL (mainly used for testing)
     * `auto` - use the best option based on browser capabilities: `history` if possible, then `hash` if possible, otherwise `none`
        This value is defaulted to `auto` by the `locationType` setting of `/config/environment.js`
        @property location
     @default 'hash'
     @see {Location}
     @public
    */
    location: 'hash',
    /**
     Represents the current URL.
        @property url
     @type {String}
     @private
    */
    url: (0, _metal.computed)(function () {
      var location = (0, _metal.get)(this, 'location');
      if (typeof location === 'string') {
        return undefined;
      }
      return location.getURL();
    })
  });
  if (_deprecatedFeatures.ROUTER_EVENTS) {
    EmberRouter.reopen(_route.ROUTER_EVENT_DEPRECATIONS);
  }
  var _default = EmberRouter;
  _exports.default = _default;
});
define("@ember/-internals/routing/lib/system/router_state", ["exports", "@ember/polyfills", "@ember/-internals/routing/lib/utils"], function (_exports, _polyfills, _utils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  var RouterState = /*#__PURE__*/function () {
    function RouterState(emberRouter, router, routerJsState) {
      this.emberRouter = emberRouter;
      this.router = router;
      this.routerJsState = routerJsState;
    }
    var _proto = RouterState.prototype;
    _proto.isActiveIntent = function isActiveIntent(routeName, models, queryParams) {
      var state = this.routerJsState;
      if (!this.router.isActiveIntent(routeName, models, undefined, state)) {
        return false;
      }
      if (queryParams !== undefined && Object.keys(queryParams).length > 0) {
        var visibleQueryParams = (0, _polyfills.assign)({}, queryParams);
        this.emberRouter._prepareQueryParams(routeName, models, visibleQueryParams);
        return (0, _utils.shallowEqual)(visibleQueryParams, state.queryParams);
      }
      return true;
    };
    return RouterState;
  }();
  _exports.default = RouterState;
});
define("@ember/-internals/routing/lib/system/transition", [], function () {
  "use strict";

  /**
    A Transition is a thennable (a promise-like object) that represents
    an attempt to transition to another route. It can be aborted, either
    explicitly via `abort` or by attempting another transition while a
    previous one is still underway. An aborted transition can also
    be `retry()`d later.
  
    @class Transition
    @public
  */

  /**
    The Transition's internal promise. Calling `.then` on this property
    is that same as calling `.then` on the Transition object itself, but
    this property is exposed for when you want to pass around a
    Transition's promise, but not the Transition object itself, since
    Transition object can be externally `abort`ed, while the promise
    cannot.
  
    @property promise
    @type {Object}
    @public
    */

  /**
    Custom state can be stored on a Transition's `data` object.
    This can be useful for decorating a Transition within an earlier
    hook and shared with a later hook. Properties set on `data` will
    be copied to new transitions generated by calling `retry` on this
    transition.
  
    @property data
    @type {Object}
    @public
  */

  /**
    A standard promise hook that resolves if the transition
    succeeds and rejects if it fails/redirects/aborts.
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method then
    @param {Function} onFulfilled
    @param {Function} onRejected
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method catch
    @param {Function} onRejection
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
  
    Forwards to the internal `promise` property which you can
    use in situations where you want to pass around a thennable,
    but not the Transition itself.
  
    @method finally
    @param {Function} callback
    @param {String} label optional string for labeling the promise.
    Useful for tooling.
    @return {Promise}
    @public
  */

  /**
    Aborts the Transition. Note you can also implicitly abort a transition
    by initiating another transition while a previous one is underway.
  
    @method abort
    @return {Transition} this transition
    @public
  */

  /**
  
    Retries a previously-aborted transition (making sure to abort the
    transition if it's still active). Returns a new transition that
    represents the new attempt to transition.
  
    @method retry
    @return {Transition} new transition
    @public
    */

  /**
  
    Sets the URL-changing method to be employed at the end of a
    successful transition. By default, a new Transition will just
    use `updateURL`, but passing 'replace' to this method will
    cause the URL to update using 'replaceWith' instead. Omitting
    a parameter will disable the URL change, allowing for transitions
    that don't update the URL at completion (this is also used for
    handleURL, since the URL has already changed before the
    transition took place).
  
    @method method
    @param {String} method the type of URL-changing method to use
      at the end of a transition. Accepted values are 'replace',
      falsy values, or any other non-falsy value (which is
      interpreted as an updateURL transition).
  
    @return {Transition} this transition
    @public
  */

  /**
  
    Fires an event on the current list of resolved/resolving
    handlers within this transition. Useful for firing events
    on route hierarchies that haven't fully been entered yet.
  
    Note: This method is also aliased as `send`
  
    @method trigger
    @param {Boolean} [ignoreFailure=false] a boolean specifying whether unhandled events throw an error
    @param {String} name the name of the event to fire
    @public
  */

  /**
   * This property is a `RouteInfo` object that represents
   * where the router is transitioning to. It's important
   * to note that a `RouteInfo` is a linked list and this
   * property represents the leafmost route.
   * @property {null|RouteInfo|RouteInfoWithAttributes} to
   * @public
   */

  /**
   * This property is a `RouteInfo` object that represents
   * where transition originated from. It's important
   * to note that a `RouteInfo` is a linked list and this
   * property represents the head node of the list.
   * In the case of an initial render, `from` will be set to
   * `null`.
   * @property {null|RouteInfoWithAttributes} from
   * @public
   */

  /**
    Transitions are aborted and their promises rejected
    when redirects occur; this method returns a promise
    that will follow any redirects that occur and fulfill
    with the value fulfilled by any redirecting transitions
    that occur.
  
    @method followRedirects
    @return {Promise} a promise that fulfills with the same
      value that the final redirecting transition fulfills with
    @public
  */

  /**
    In non-production builds, this function will return the stack that this Transition was
    created within. In production builds, this function will not be present.
  
    @method debugCreationStack
    @return string
  */

  /**
    In non-production builds, this function will return the stack that this Transition was
    aborted within (or `undefined` if the Transition has not been aborted yet). In production
    builds, this function will not be present.
  
    @method debugAbortStack
    @return string
  */

  /**
    In non-production builds, this property references the Transition that _this_ Transition
    was derived from or `undefined` if this transition did not derive from another. In
    production builds, this property will not be present.
  
    @property debugPreviousTransition
    @type {Transition | undefined}
  */
});
define("@ember/-internals/routing/lib/utils", ["exports", "@ember/-internals/metal", "@ember/-internals/owner", "@ember/error", "@ember/polyfills", "router_js"], function (_exports, _metal, _owner, _error, _polyfills, _router_js) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.calculateCacheKey = calculateCacheKey;
  _exports.extractRouteArgs = extractRouteArgs;
  _exports.getActiveTargetName = getActiveTargetName;
  _exports.normalizeControllerQueryParams = normalizeControllerQueryParams;
  _exports.prefixRouteNameArg = prefixRouteNameArg;
  _exports.resemblesURL = resemblesURL;
  _exports.shallowEqual = shallowEqual;
  _exports.stashParamNames = stashParamNames;
  var ALL_PERIODS_REGEX = /\./g;
  function extractRouteArgs(args) {
    args = args.slice();
    var possibleQueryParams = args[args.length - 1];
    var queryParams;
    if (possibleQueryParams && Object.prototype.hasOwnProperty.call(possibleQueryParams, 'queryParams')) {
      // SAFETY: this cast is safe because we have just checked whether
      // `possibleQueryParams` -- defined as the last item in args -- both exists
      // and has the property `queryParams`. If either of these invariants change,
      // ***this is unsafe and should be changed***.
      queryParams = args.pop().queryParams;
    } else {
      queryParams = {};
    } // UNSAFE: these are simply assumed as the existing behavior of the system.
    // However, this could break if upstream refactors change it, and the types
    // here would not be able to tell us; we would lie to everything downstream.

    var routeName = args.shift();
    var models = args;
    return {
      routeName: routeName,
      models: models,
      queryParams: queryParams
    };
  }
  function getActiveTargetName(router) {
    var routeInfos = router.activeTransition ? router.activeTransition[_router_js.STATE_SYMBOL].routeInfos : router.state.routeInfos;
    return routeInfos[routeInfos.length - 1].name;
  }
  function stashParamNames(router, routeInfos) {
    if (routeInfos['_namesStashed']) {
      return;
    } // This helper exists because router.js/route-recognizer.js awkwardly
    // keeps separate a routeInfo's list of parameter names depending
    // on whether a URL transition or named transition is happening.
    // Hopefully we can remove this in the future.

    var targetRouteName = routeInfos[routeInfos.length - 1].name;
    var recogHandlers = router._routerMicrolib.recognizer.handlersFor(targetRouteName);
    var dynamicParent;
    for (var i = 0; i < routeInfos.length; ++i) {
      var routeInfo = routeInfos[i];
      var names = recogHandlers[i].names;
      if (names.length) {
        dynamicParent = routeInfo;
      }
      routeInfo['_names'] = names;
      var route = routeInfo.route;
      route._stashNames(routeInfo, dynamicParent);
    }
    routeInfos['_namesStashed'] = true;
  }
  function _calculateCacheValuePrefix(prefix, part) {
    // calculates the dot separated sections from prefix that are also
    // at the start of part - which gives us the route name
    // given : prefix = site.article.comments, part = site.article.id
    //      - returns: site.article (use get(values[site.article], 'id') to get the dynamic part - used below)
    // given : prefix = site.article, part = site.article.id
    //      - returns: site.article. (use get(values[site.article], 'id') to get the dynamic part - used below)
    var prefixParts = prefix.split('.');
    var currPrefix = '';
    for (var i = 0; i < prefixParts.length; i++) {
      var currPart = prefixParts.slice(0, i + 1).join('.');
      if (part.indexOf(currPart) !== 0) {
        break;
      }
      currPrefix = currPart;
    }
    return currPrefix;
  }
  /*
    Stolen from Controller
  */

  function calculateCacheKey(prefix, parts, values) {
    if (parts === void 0) {
      parts = [];
    }
    var suffixes = '';
    for (var i = 0; i < parts.length; ++i) {
      var part = parts[i];
      var cacheValuePrefix = _calculateCacheValuePrefix(prefix, part);
      var value = void 0;
      if (values) {
        if (cacheValuePrefix && cacheValuePrefix in values) {
          var partRemovedPrefix = part.indexOf(cacheValuePrefix) === 0 ? part.substr(cacheValuePrefix.length + 1) : part;
          value = (0, _metal.get)(values[cacheValuePrefix], partRemovedPrefix);
        } else {
          value = (0, _metal.get)(values, part);
        }
      }
      suffixes += "::" + part + ":" + value;
    }
    return prefix + suffixes.replace(ALL_PERIODS_REGEX, '-');
  }
  /*
    Controller-defined query parameters can come in three shapes:
  
    Array
      queryParams: ['foo', 'bar']
    Array of simple objects where value is an alias
      queryParams: [
        {
          'foo': 'rename_foo_to_this'
        },
        {
          'bar': 'call_bar_this_instead'
        }
      ]
    Array of fully defined objects
      queryParams: [
        {
          'foo': {
            as: 'rename_foo_to_this'
          },
        }
        {
          'bar': {
            as: 'call_bar_this_instead',
            scope: 'controller'
          }
        }
      ]
  
    This helper normalizes all three possible styles into the
    'Array of fully defined objects' style.
  */

  function normalizeControllerQueryParams(queryParams) {
    var qpMap = {};
    for (var i = 0; i < queryParams.length; ++i) {
      accumulateQueryParamDescriptors(queryParams[i], qpMap);
    }
    return qpMap;
  }
  function accumulateQueryParamDescriptors(_desc, accum) {
    var desc = _desc;
    var tmp;
    if (typeof desc === 'string') {
      tmp = {};
      tmp[desc] = {
        as: null
      };
      desc = tmp;
    }
    for (var key in desc) {
      if (!Object.prototype.hasOwnProperty.call(desc, key)) {
        return;
      }
      var singleDesc = desc[key];
      if (typeof singleDesc === 'string') {
        singleDesc = {
          as: singleDesc
        };
      }
      tmp = accum[key] || {
        as: null,
        scope: 'model'
      };
      (0, _polyfills.assign)(tmp, singleDesc);
      accum[key] = tmp;
    }
  }
  /*
    Check if a routeName resembles a url instead
  
    @private
  */

  function resemblesURL(str) {
    return typeof str === 'string' && (str === '' || str[0] === '/');
  }
  /*
    Returns an arguments array where the route name arg is prefixed based on the mount point
  
    @private
  */

  function prefixRouteNameArg(route, args) {
    var routeName = args[0];
    var owner = (0, _owner.getOwner)(route);
    var prefix = owner.mountPoint; // only alter the routeName if it's actually referencing a route.

    if (owner.routable && typeof routeName === 'string') {
      if (resemblesURL(routeName)) {
        throw new _error.default('Programmatic transitions by URL cannot be used within an Engine. Please use the route name instead.');
      } else {
        routeName = prefix + "." + routeName;
        args[0] = routeName;
      }
    }
    return args;
  }
  function shallowEqual(a, b) {
    var k;
    var aCount = 0;
    var bCount = 0;
    for (k in a) {
      if (Object.prototype.hasOwnProperty.call(a, k)) {
        if (a[k] !== b[k]) {
          return false;
        }
        aCount++;
      }
    }
    for (k in b) {
      if (Object.prototype.hasOwnProperty.call(b, k)) {
        bCount++;
      }
    }
    return aCount === bCount;
  }
});
define("@ember/-internals/runtime/index", ["exports", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/registry_proxy", "@ember/-internals/runtime/lib/mixins/container_proxy", "@ember/-internals/runtime/lib/copy", "@ember/-internals/runtime/lib/compare", "@ember/-internals/runtime/lib/is-equal", "@ember/-internals/runtime/lib/mixins/array", "@ember/-internals/runtime/lib/mixins/comparable", "@ember/-internals/runtime/lib/system/namespace", "@ember/-internals/runtime/lib/system/array_proxy", "@ember/-internals/runtime/lib/system/object_proxy", "@ember/-internals/runtime/lib/system/core_object", "@ember/-internals/runtime/lib/mixins/action_handler", "@ember/-internals/runtime/lib/mixins/copyable", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/runtime/lib/mixins/-proxy", "@ember/-internals/runtime/lib/mixins/observable", "@ember/-internals/runtime/lib/mixins/mutable_enumerable", "@ember/-internals/runtime/lib/mixins/target_action_support", "@ember/-internals/runtime/lib/mixins/evented", "@ember/-internals/runtime/lib/mixins/promise_proxy", "@ember/-internals/runtime/lib/ext/rsvp", "@ember/-internals/runtime/lib/type-of", "@ember/-internals/runtime/lib/ext/function"], function (_exports, _object, _registry_proxy, _container_proxy, _copy, _compare, _isEqual, _array, _comparable, _namespace, _array_proxy, _object_proxy, _core_object, _action_handler, _copyable, _enumerable, _proxy, _observable, _mutable_enumerable, _target_action_support, _evented, _promise_proxy, _rsvp, _typeOf, _function) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  Object.defineProperty(_exports, "A", {
    enumerable: true,
    get: function get() {
      return _array.A;
    }
  });
  Object.defineProperty(_exports, "ActionHandler", {
    enumerable: true,
    get: function get() {
      return _action_handler.default;
    }
  });
  Object.defineProperty(_exports, "Array", {
    enumerable: true,
    get: function get() {
      return _array.default;
    }
  });
  Object.defineProperty(_exports, "ArrayProxy", {
    enumerable: true,
    get: function get() {
      return _array_proxy.default;
    }
  });
  Object.defineProperty(_exports, "Comparable", {
    enumerable: true,
    get: function get() {
      return _comparable.default;
    }
  });
  Object.defineProperty(_exports, "ContainerProxyMixin", {
    enumerable: true,
    get: function get() {
      return _container_proxy.default;
    }
  });
  Object.defineProperty(_exports, "Copyable", {
    enumerable: true,
    get: function get() {
      return _copyable.default;
    }
  });
  Object.defineProperty(_exports, "CoreObject", {
    enumerable: true,
    get: function get() {
      return _core_object.default;
    }
  });
  Object.defineProperty(_exports, "Enumerable", {
    enumerable: true,
    get: function get() {
      return _enumerable.default;
    }
  });
  Object.defineProperty(_exports, "Evented", {
    enumerable: true,
    get: function get() {
      return _evented.default;
    }
  });
  Object.defineProperty(_exports, "FrameworkObject", {
    enumerable: true,
    get: function get() {
      return _object.FrameworkObject;
    }
  });
  Object.defineProperty(_exports, "MutableArray", {
    enumerable: true,
    get: function get() {
      return _array.MutableArray;
    }
  });
  Object.defineProperty(_exports, "MutableEnumerable", {
    enumerable: true,
    get: function get() {
      return _mutable_enumerable.default;
    }
  });
  Object.defineProperty(_exports, "Namespace", {
    enumerable: true,
    get: function get() {
      return _namespace.default;
    }
  });
  Object.defineProperty(_exports, "NativeArray", {
    enumerable: true,
    get: function get() {
      return _array.NativeArray;
    }
  });
  Object.defineProperty(_exports, "Object", {
    enumerable: true,
    get: function get() {
      return _object.default;
    }
  });
  Object.defineProperty(_exports, "ObjectProxy", {
    enumerable: true,
    get: function get() {
      return _object_proxy.default;
    }
  });
  Object.defineProperty(_exports, "Observable", {
    enumerable: true,
    get: function get() {
      return _observable.default;
    }
  });
  Object.defineProperty(_exports, "PromiseProxyMixin", {
    enumerable: true,
    get: function get() {
      return _promise_proxy.default;
    }
  });
  Object.defineProperty(_exports, "RSVP", {
    enumerable: true,
    get: function get() {
      return _rsvp.default;
    }
  });
  Object.defineProperty(_exports, "RegistryProxyMixin", {
    enumerable: true,
    get: function get() {
      return _registry_proxy.default;
    }
  });
  Object.defineProperty(_exports, "TargetActionSupport", {
    enumerable: true,
    get: function get() {
      return _target_action_support.default;
    }
  });
  Object.defineProperty(_exports, "_ProxyMixin", {
    enumerable: true,
    get: function get() {
      return _proxy.default;
    }
  });
  Object.defineProperty(_exports, "_contentFor", {
    enumerable: true,
    get: function get() {
      return _proxy.contentFor;
    }
  });
  Object.defineProperty(_exports, "compare", {
    enumerable: true,
    get: function get() {
      return _compare.default;
    }
  });
  Object.defineProperty(_exports, "copy", {
    enumerable: true,
    get: function get() {
      return _copy.default;
    }
  });
  Object.defineProperty(_exports, "isArray", {
    enumerable: true,
    get: function get() {
      return _array.isArray;
    }
  });
  Object.defineProperty(_exports, "isEqual", {
    enumerable: true,
    get: function get() {
      return _isEqual.default;
    }
  });
  Object.defineProperty(_exports, "onerrorDefault", {
    enumerable: true,
    get: function get() {
      return _rsvp.onerrorDefault;
    }
  });
  Object.defineProperty(_exports, "removeAt", {
    enumerable: true,
    get: function get() {
      return _array.removeAt;
    }
  });
  Object.defineProperty(_exports, "typeOf", {
    enumerable: true,
    get: function get() {
      return _typeOf.typeOf;
    }
  });
  Object.defineProperty(_exports, "uniqBy", {
    enumerable: true,
    get: function get() {
      return _array.uniqBy;
    }
  });
});
define("@ember/-internals/runtime/lib/compare", ["exports", "@ember/-internals/runtime/lib/type-of", "@ember/-internals/runtime/lib/mixins/comparable"], function (_exports, _typeOf, _comparable) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = compare;
  var TYPE_ORDER = {
    undefined: 0,
    null: 1,
    boolean: 2,
    number: 3,
    string: 4,
    array: 5,
    object: 6,
    instance: 7,
    function: 8,
    class: 9,
    date: 10
  }; //
  // the spaceship operator
  //
  //                      `. ___
  //                     __,' __`.                _..----....____
  //         __...--.'``;.   ,.   ;``--..__     .'    ,-._    _.-'
  //   _..-''-------'   `'   `'   `'     O ``-''._   (,;') _,'
  // ,'________________                          \`-._`-','
  //  `._              ```````````------...___   '-.._'-:
  //     ```--.._      ,.                     ````--...__\-.
  //             `.--. `-` "INFINITY IS LESS     ____    |  |`
  //               `. `.   THAN BEYOND"        ,'`````.  ;  ;`
  //                 `._`.        __________   `.      \'__/`
  //                    `-:._____/______/___/____`.     \  `
  //                                |       `._    `.    \
  //                                `._________`-.   `.   `.___
  //                                              SSt  `------'`

  function spaceship(a, b) {
    var diff = a - b;
    return (diff > 0) - (diff < 0);
  }
  /**
   @module @ember/utils
  */

  /**
   Compares two javascript values and returns:
  
    - -1 if the first is smaller than the second,
    - 0 if both are equal,
    - 1 if the first is greater than the second.
  
    ```javascript
    import { compare } from '@ember/utils';
  
    compare('hello', 'hello');  // 0
    compare('abc', 'dfg');      // -1
    compare(2, 1);              // 1
    ```
  
   If the types of the two objects are different precedence occurs in the
   following order, with types earlier in the list considered `<` types
   later in the list:
  
    - undefined
    - null
    - boolean
    - number
    - string
    - array
    - object
    - instance
    - function
    - class
    - date
  
    ```javascript
    import { compare } from '@ember/utils';
  
    compare('hello', 50);       // 1
    compare(50, 'hello');       // -1
    ```
  
   @method compare
   @for @ember/utils
   @static
   @param {Object} v First value to compare
   @param {Object} w Second value to compare
   @return {Number} -1 if v < w, 0 if v = w and 1 if v > w.
   @public
  */

  function compare(v, w) {
    if (v === w) {
      return 0;
    }
    var type1 = (0, _typeOf.typeOf)(v);
    var type2 = (0, _typeOf.typeOf)(w);
    if (type1 === 'instance' && _comparable.default.detect(v) && v.constructor.compare) {
      return v.constructor.compare(v, w);
    }
    if (type2 === 'instance' && _comparable.default.detect(w) && w.constructor.compare) {
      return w.constructor.compare(w, v) * -1;
    }
    var res = spaceship(TYPE_ORDER[type1], TYPE_ORDER[type2]);
    if (res !== 0) {
      return res;
    } // types are equal - so we have to check values now

    switch (type1) {
      case 'boolean':
      case 'number':
        return spaceship(v, w);
      case 'string':
        return spaceship(v.localeCompare(w), 0);
      case 'array':
        {
          var vLen = v.length;
          var wLen = w.length;
          var len = Math.min(vLen, wLen);
          for (var i = 0; i < len; i++) {
            var r = compare(v[i], w[i]);
            if (r !== 0) {
              return r;
            }
          } // all elements are equal now
          // shorter array should be ordered first

          return spaceship(vLen, wLen);
        }
      case 'instance':
        if (_comparable.default.detect(v)) {
          return v.compare(v, w);
        }
        return 0;
      case 'date':
        return spaceship(v.getTime(), w.getTime());
      default:
        return 0;
    }
  }
});
define("@ember/-internals/runtime/lib/copy", ["exports", "@ember/debug", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/copyable"], function (_exports, _debug, _object, _copyable) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = copy;
  /**
   @module @ember/object
  */

  function _copy(obj, deep, seen, copies) {
    // primitive data types are immutable, just return them.
    if (typeof obj !== 'object' || obj === null) {
      return obj;
    }
    var ret, loc; // avoid cyclical loops

    if (deep && (loc = seen.indexOf(obj)) >= 0) {
      return copies[loc];
    }
    if (deep) {
      seen.push(obj);
    } // IMPORTANT: this specific test will detect a native array only. Any other
    // object will need to implement Copyable.

    if (Array.isArray(obj)) {
      ret = obj.slice();
      if (deep) {
        copies.push(ret);
        loc = ret.length;
        while (--loc >= 0) {
          ret[loc] = _copy(ret[loc], deep, seen, copies);
        }
      }
    } else if (_copyable.default.detect(obj)) {
      ret = obj.copy(deep, seen, copies);
      if (deep) {
        copies.push(ret);
      }
    } else if (obj instanceof Date) {
      ret = new Date(obj.getTime());
      if (deep) {
        copies.push(ret);
      }
    } else {
      (true && !(!(obj instanceof _object.default) || _copyable.default.detect(obj)) && (0, _debug.assert)('Cannot clone an EmberObject that does not implement Copyable', !(obj instanceof _object.default) || _copyable.default.detect(obj)));
      ret = {};
      if (deep) {
        copies.push(ret);
      }
      var key;
      for (key in obj) {
        // support Null prototype
        if (!Object.prototype.hasOwnProperty.call(obj, key)) {
          continue;
        } // Prevents browsers that don't respect non-enumerability from
        // copying internal Ember properties

        if (key.substring(0, 2) === '__') {
          continue;
        }
        ret[key] = deep ? _copy(obj[key], deep, seen, copies) : obj[key];
      }
    }
    return ret;
  }
  /**
    Creates a shallow copy of the passed object. A deep copy of the object is
    returned if the optional `deep` argument is `true`.
  
    If the passed object implements the `Copyable` interface, then this
    function will delegate to the object's `copy()` method and return the
    result. See `Copyable` for further details.
  
    For primitive values (which are immutable in JavaScript), the passed object
    is simply returned.
  
    @method copy
    @deprecated Use 'ember-copy' addon instead
    @static
    @for @ember/object/internals
    @param {Object} obj The object to clone
    @param {Boolean} [deep=false] If true, a deep copy of the object is made.
    @return {Object} The copied object
    @public
  */

  function copy(obj, deep) {
    (true && !(false) && (0, _debug.deprecate)('Use ember-copy addon instead of copy method and Copyable mixin.', false, {
      id: 'ember-runtime.deprecate-copy-copyable',
      until: '4.0.0',
      url: 'https://emberjs.com/deprecations/v3.x/#toc_ember-runtime-deprecate-copy-copyable'
    })); // fast paths
    if ('object' !== typeof obj || obj === null) {
      return obj; // can't copy primitives
    }

    if (!Array.isArray(obj) && _copyable.default.detect(obj)) {
      return obj.copy(deep);
    }
    return _copy(obj, deep, deep ? [] : null, deep ? [] : null);
  }
});
define("@ember/-internals/runtime/lib/ext/function", ["@ember/-internals/environment", "@ember/-internals/metal", "@ember/debug", "@ember/deprecated-features"], function (_environment, _metal, _debug, _deprecatedFeatures) {
  "use strict";

  /**
  @module ember
  */

  if (_deprecatedFeatures.FUNCTION_PROTOTYPE_EXTENSIONS && _environment.ENV.EXTEND_PROTOTYPES.Function) {
    Object.defineProperties(Function.prototype, {
      /**
        The `property` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        `true`, which is the default.
         Computed properties allow you to treat a function like a property:
         ```app/utils/president.js
        import EmberObject from '@ember/object';
         export default EmberObject.extend({
          firstName: '',
          lastName:  '',
           fullName: function() {
            return this.get('firstName') + ' ' + this.get('lastName');
          }.property() // Call this flag to mark the function as a property
        });
        ```
         ```javascript
        let president = President.create({
          firstName: 'Barack',
          lastName: 'Obama'
        });
         president.get('fullName'); // 'Barack Obama'
        ```
         Treating a function like a property is useful because they can work with
        bindings, just like any other property.
         Many computed properties have dependencies on other properties. For
        example, in the above example, the `fullName` property depends on
        `firstName` and `lastName` to determine its value. You can tell Ember
        about these dependencies like this:
         ```app/utils/president.js
        import EmberObject from '@ember/object';
         export default EmberObject.extend({
          firstName: '',
          lastName:  '',
           fullName: function() {
            return this.get('firstName') + ' ' + this.get('lastName');
             // Tell Ember.js that this computed property depends on firstName
            // and lastName
          }.property('firstName', 'lastName')
        });
        ```
         Make sure you list these dependencies so Ember knows when to update
        bindings that connect to a computed property. Changing a dependency
        will not immediately trigger an update of the computed property, but
        will instead clear the cache so that it is updated when the next `get`
        is called on the property.
         See [ComputedProperty](/ember/release/classes/ComputedProperty), [@ember/object/computed](/ember/release/classes/@ember%2Fobject%2Fcomputed).
         @method property
        @for Function
        @public
      */
      property: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function value() {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.property('bar') to computed('bar', function() {}).", false, {
            id: 'function-prototype-extensions.property',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-property'
          }));
          return _metal.computed.apply(void 0, Array.prototype.slice.call(arguments).concat([this]));
        }
      },
      /**
        The `observes` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        true, which is the default.
         You can observe property changes simply by adding the `observes`
        call to the end of your method declarations in classes that you write.
        For example:
         ```javascript
        import EmberObject from '@ember/object';
         EmberObject.extend({
          valueObserver: function() {
            // Executes whenever the "value" property changes
          }.observes('value')
        });
        ```
         In the future this method may become asynchronous.
         See `observer`.
         @method observes
        @for Function
        @public
      */
      observes: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function value() {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.observes('foo') to observer('foo', function() {}).", false, {
            id: 'function-prototype-extensions.observes',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-observes'
          }));
          return _metal.observer.apply(void 0, Array.prototype.slice.call(arguments).concat([this]));
        }
      },
      /**
        The `on` extension of Javascript's Function prototype is available
        when `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Function` is
        true, which is the default.
         You can listen for events simply by adding the `on` call to the end of
        your method declarations in classes or mixins that you write. For example:
         ```javascript
        import Mixin from '@ember/mixin';
         Mixin.create({
          doSomethingWithElement: function() {
            // Executes whenever the "didInsertElement" event fires
          }.on('didInsertElement')
        });
        ```
         See `@ember/object/evented/on`.
         @method on
        @for Function
        @public
      */
      on: {
        configurable: true,
        enumerable: false,
        writable: true,
        value: function value() {
          (true && !(false) && (0, _debug.deprecate)("Function prototype extensions have been deprecated, please migrate from function(){}.on('foo') to on('foo', function() {}).", false, {
            id: 'function-prototype-extensions.on',
            until: '4.0.0',
            url: 'https://deprecations.emberjs.com/v3.x#toc_function-prototype-extensions-on'
          }));
          return _metal.on.apply(void 0, Array.prototype.slice.call(arguments).concat([this]));
        }
      }
    });
  }
});
define("@ember/-internals/runtime/lib/ext/rsvp", ["exports", "rsvp", "@ember/runloop", "@ember/-internals/error-handling", "@ember/debug"], function (_exports, RSVP, _runloop, _errorHandling, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  _exports.onerrorDefault = onerrorDefault;
  RSVP.configure('async', function (callback, promise) {
    _runloop.backburner.schedule('actions', null, callback, promise);
  });
  RSVP.configure('after', function (cb) {
    _runloop.backburner.schedule(_runloop._rsvpErrorQueue, null, cb);
  });
  RSVP.on('error', onerrorDefault);
  function onerrorDefault(reason) {
    var error = errorFor(reason);
    if (error) {
      var overrideDispatch = (0, _errorHandling.getDispatchOverride)();
      if (overrideDispatch) {
        overrideDispatch(error);
      } else {
        throw error;
      }
    }
  }
  function errorFor(reason) {
    if (!reason) return;
    if (reason.errorThrown) {
      return unwrapErrorThrown(reason);
    }
    if (reason.name === 'UnrecognizedURLError') {
      (true && !(false) && (0, _debug.assert)("The URL '" + reason.message + "' did not match any routes in your application", false));
      return;
    }
    if (reason.name === 'TransitionAborted') {
      return;
    }
    return reason;
  }
  function unwrapErrorThrown(reason) {
    var error = reason.errorThrown;
    if (typeof error === 'string') {
      error = new Error(error);
    }
    Object.defineProperty(error, '__reason_with_error_thrown__', {
      value: reason,
      enumerable: false
    });
    return error;
  }
  var _default = RSVP;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/is-equal", ["exports"], function (_exports) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = isEqual;
  /**
   @module @ember/utils
  */

  /**
    Compares two objects, returning true if they are equal.
  
    ```javascript
    import { isEqual } from '@ember/utils';
  
    isEqual('hello', 'hello');                   // true
    isEqual(1, 2);                               // false
    ```
  
    `isEqual` is a more specific comparison than a triple equal comparison.
    It will call the `isEqual` instance method on the objects being
    compared, allowing finer control over when objects should be considered
    equal to each other.
  
    ```javascript
    import { isEqual } from '@ember/utils';
    import EmberObject from '@ember/object';
  
    let Person = EmberObject.extend({
      isEqual(other) { return this.ssn == other.ssn; }
    });
  
    let personA = Person.create({name: 'Muhammad Ali', ssn: '123-45-6789'});
    let personB = Person.create({name: 'Cassius Clay', ssn: '123-45-6789'});
  
    isEqual(personA, personB); // true
    ```
  
    Due to the expense of array comparisons, collections will never be equal to
    each other even if each of their items are equal to each other.
  
    ```javascript
    import { isEqual } from '@ember/utils';
  
    isEqual([4, 2], [4, 2]);                     // false
    ```
  
    @method isEqual
    @for @ember/utils
    @static
    @param {Object} a first object to compare
    @param {Object} b second object to compare
    @return {Boolean}
    @public
  */
  function isEqual(a, b) {
    if (a && typeof a.isEqual === 'function') {
      return a.isEqual(b);
    }
    if (a instanceof Date && b instanceof Date) {
      return a.getTime() === b.getTime();
    }
    return a === b;
  }
});
define("@ember/-internals/runtime/lib/mixins/-proxy", ["exports", "@ember/-internals/meta", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/debug", "@glimmer/validator"], function (_exports, _meta, _metal, _utils, _debug, _validator) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.contentFor = contentFor;
  _exports.default = void 0;
  var _Mixin$create;
  function contentFor(proxy) {
    var content = (0, _metal.get)(proxy, 'content');
    (0, _validator.updateTag)((0, _metal.tagForObject)(proxy), (0, _metal.tagForObject)(content));
    return content;
  }
  /**
    `Ember.ProxyMixin` forwards all properties not defined by the proxy itself
    to a proxied `content` object.  See ObjectProxy for more details.
  
    @class ProxyMixin
    @namespace Ember
    @private
  */
  var _default = _metal.Mixin.create((_Mixin$create = {
    /**
      The object whose properties will be forwarded.
       @property content
      @type {unknown}
      @default null
      @public
    */
    content: null,
    init: function init() {
      this._super.apply(this, arguments);
      (0, _utils.setProxy)(this);
      (0, _metal.tagForObject)(this);
    },
    willDestroy: function willDestroy() {
      this.set('content', null);
      this._super.apply(this, arguments);
    },
    isTruthy: (0, _metal.computed)('content', function () {
      return Boolean((0, _metal.get)(this, 'content'));
    })
  }, _Mixin$create[_metal.CUSTOM_TAG_FOR] = function (key, addMandatorySetter) {
    var meta = (0, _validator.tagMetaFor)(this);
    var tag = (0, _validator.tagFor)(this, key, meta);
    if (true /* DEBUG */) {
      // TODO: Replace this with something more first class for tracking tags in DEBUG
      tag._propertyKey = key;
    }
    if (key in this) {
      if (true /* DEBUG */ && addMandatorySetter) {
        (0, _utils.setupMandatorySetter)(tag, this, key);
      }
      return tag;
    } else {
      var tags = [tag, (0, _validator.tagFor)(this, 'content', meta)];
      var content = contentFor(this);
      if ((0, _utils.isObject)(content)) {
        tags.push((0, _metal.tagForProperty)(content, key, addMandatorySetter));
      }
      return (0, _validator.combine)(tags);
    }
  }, _Mixin$create.unknownProperty = function unknownProperty(key) {
    var content = contentFor(this);
    if (content) {
      return (0, _metal.get)(content, key);
    }
  }, _Mixin$create.setUnknownProperty = function setUnknownProperty(key, value) {
    var m = (0, _meta.meta)(this);
    if (m.isInitializing() || m.isPrototypeMeta(this)) {
      // if marked as prototype or object is initializing then just
      // defineProperty rather than delegate
      (0, _metal.defineProperty)(this, key, null, value);
      return value;
    }
    var content = contentFor(this);
    (true && !(content) && (0, _debug.assert)("Cannot delegate set('" + key + "', " + value + ") to the 'content' property of object proxy " + this + ": its 'content' is undefined.", content));
    return (0, _metal.set)(content, key, value);
  }, _Mixin$create));
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/action_handler", ["exports", "@ember/-internals/metal", "@ember/debug"], function (_exports, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */

  /**
    `Ember.ActionHandler` is available on some familiar classes including
    `Route`, `Component`, and `Controller`.
    (Internally the mixin is used by `Ember.CoreView`, `Ember.ControllerMixin`,
    and `Route` and available to the above classes through
    inheritance.)
  
    @class ActionHandler
    @namespace Ember
    @private
  */

  var ActionHandler = _metal.Mixin.create({
    mergedProperties: ['actions'],
    /**
      The collection of functions, keyed by name, available on this
      `ActionHandler` as action targets.
       These functions will be invoked when a matching `{{action}}` is triggered
      from within a template and the application's current route is this route.
       Actions can also be invoked from other parts of your application
      via `ActionHandler#send`.
       The `actions` hash will inherit action handlers from
      the `actions` hash defined on extended parent classes
      or mixins rather than just replace the entire hash, e.g.:
       ```app/mixins/can-display-banner.js
      import Mixin from '@ember/mixin';
       export default Mixin.create({
        actions: {
          displayBanner(msg) {
            // ...
          }
        }
      });
      ```
       ```app/routes/welcome.js
      import Route from '@ember/routing/route';
      import CanDisplayBanner from '../mixins/can-display-banner';
       export default Route.extend(CanDisplayBanner, {
        actions: {
          playMusic() {
            // ...
          }
        }
      });
       // `WelcomeRoute`, when active, will be able to respond
      // to both actions, since the actions hash is merged rather
      // then replaced when extending mixins / parent classes.
      this.send('displayBanner');
      this.send('playMusic');
      ```
       Within a Controller, Route or Component's action handler,
      the value of the `this` context is the Controller, Route or
      Component object:
       ```app/routes/song.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          myAction() {
            this.controllerFor("song");
            this.transitionTo("other.route");
            ...
          }
        }
      });
      ```
       It is also possible to call `this._super(...arguments)` from within an
      action handler if it overrides a handler defined on a parent
      class or mixin:
       Take for example the following routes:
       ```app/mixins/debug-route.js
      import Mixin from '@ember/mixin';
       export default Mixin.create({
        actions: {
          debugRouteInformation() {
            console.debug("It's a-me, console.debug!");
          }
        }
      });
      ```
       ```app/routes/annoying-debug.js
      import Route from '@ember/routing/route';
      import DebugRoute from '../mixins/debug-route';
       export default Route.extend(DebugRoute, {
        actions: {
          debugRouteInformation() {
            // also call the debugRouteInformation of mixed in DebugRoute
            this._super(...arguments);
             // show additional annoyance
            window.alert(...);
          }
        }
      });
      ```
       ## Bubbling
       By default, an action will stop bubbling once a handler defined
      on the `actions` hash handles it. To continue bubbling the action,
      you must return `true` from the handler:
       ```app/router.js
      Router.map(function() {
        this.route("album", function() {
          this.route("song");
        });
      });
      ```
       ```app/routes/album.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          startPlaying: function() {
          }
        }
      });
      ```
       ```app/routes/album-song.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          startPlaying() {
            // ...
             if (actionShouldAlsoBeTriggeredOnParentRoute) {
              return true;
            }
          }
        }
      });
      ```
       @property actions
      @type Object
      @default null
      @public
    */
    /**
      Triggers a named action on the `ActionHandler`. Any parameters
      supplied after the `actionName` string will be passed as arguments
      to the action target function.
       If the `ActionHandler` has its `target` property set, actions may
      bubble to the `target`. Bubbling happens when an `actionName` can
      not be found in the `ActionHandler`'s `actions` hash or if the
      action target function returns `true`.
       Example
       ```app/routes/welcome.js
      import Route from '@ember/routing/route';
       export default Route.extend({
        actions: {
          playTheme() {
            this.send('playMusic', 'theme.mp3');
          },
          playMusic(track) {
            // ...
          }
        }
      });
      ```
       @method send
      @param {String} actionName The action to trigger
      @param {*} context a context to send with the action
      @public
    */
    send: function send(actionName) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      (true && !(!this.isDestroying && !this.isDestroyed) && (0, _debug.assert)("Attempted to call .send() with the action '" + actionName + "' on the destroyed object '" + this + "'.", !this.isDestroying && !this.isDestroyed));
      if (this.actions && this.actions[actionName]) {
        var shouldBubble = this.actions[actionName].apply(this, args) === true;
        if (!shouldBubble) {
          return;
        }
      }
      var target = (0, _metal.get)(this, 'target');
      if (target) {
        (true && !(typeof target.send === 'function') && (0, _debug.assert)("The `target` for " + this + " (" + target + ") does not have a `send` method", typeof target.send === 'function'));
        target.send.apply(target, arguments);
      }
    }
  });
  var _default = ActionHandler;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/array", ["exports", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/debug", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/runtime/lib/compare", "@ember/-internals/environment", "@ember/-internals/runtime/lib/mixins/observable", "@ember/-internals/runtime/lib/mixins/mutable_enumerable", "@ember/-internals/runtime/lib/type-of"], function (_exports, _metal, _utils, _debug, _enumerable, _compare, _environment, _observable, _mutable_enumerable, _typeOf) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = _exports.NativeArray = _exports.MutableArray = _exports.A = void 0;
  _exports.isArray = isArray;
  _exports.removeAt = _removeAt;
  _exports.uniqBy = _uniqBy;
  var _NativeArray;
  var EMPTY_ARRAY = Object.freeze([]);
  var identityFunction = function identityFunction(item) {
    return item;
  };
  function _uniqBy(array, key) {
    if (key === void 0) {
      key = identityFunction;
    }
    (true && !(isArray(array)) && (0, _debug.assert)("first argument passed to `uniqBy` should be array", isArray(array)));
    var ret = _A2();
    var seen = new Set();
    var getter = typeof key === 'function' ? key : function (item) {
      return (0, _metal.get)(item, key);
    };
    array.forEach(function (item) {
      var val = getter(item);
      if (!seen.has(val)) {
        seen.add(val);
        ret.push(item);
      }
    });
    return ret;
  }
  function iter(key, value) {
    var valueProvided = arguments.length === 2;
    return valueProvided ? function (item) {
      return value === (0, _metal.get)(item, key);
    } : function (item) {
      return Boolean((0, _metal.get)(item, key));
    };
  }
  function findIndex(array, predicate, startAt) {
    var len = array.length;
    for (var index = startAt; index < len; index++) {
      var item = (0, _metal.objectAt)(array, index);
      if (predicate(item, index, array)) {
        return index;
      }
    }
    return -1;
  }
  function _find(array, callback, target) {
    var predicate = callback.bind(target);
    var index = findIndex(array, predicate, 0);
    return index === -1 ? undefined : (0, _metal.objectAt)(array, index);
  }
  function _any(array, callback, target) {
    var predicate = callback.bind(target);
    return findIndex(array, predicate, 0) !== -1;
  }
  function _every(array, callback, target) {
    var cb = callback.bind(target);
    var predicate = function predicate(item, index, array) {
      return !cb(item, index, array);
    };
    return findIndex(array, predicate, 0) === -1;
  }
  function _indexOf(array, val, startAt, withNaNCheck) {
    if (startAt === void 0) {
      startAt = 0;
    }
    var len = array.length;
    if (startAt < 0) {
      startAt += len;
    } // SameValueZero comparison (NaN !== NaN)

    var predicate = withNaNCheck && val !== val ? function (item) {
      return item !== item;
    } : function (item) {
      return item === val;
    };
    return findIndex(array, predicate, startAt);
  }
  function _removeAt(array, index, len) {
    if (len === void 0) {
      len = 1;
    }
    (true && !(index > -1 && index < array.length) && (0, _debug.assert)("`removeAt` index provided is out of range", index > -1 && index < array.length));
    (0, _metal.replace)(array, index, len, EMPTY_ARRAY);
    return array;
  }
  function _insertAt(array, index, item) {
    (true && !(index > -1 && index <= array.length) && (0, _debug.assert)("`insertAt` index provided is out of range", index > -1 && index <= array.length));
    (0, _metal.replace)(array, index, 0, [item]);
    return item;
  }
  /**
    Returns true if the passed object is an array or Array-like.
  
    Objects are considered Array-like if any of the following are true:
  
      - the object is a native Array
      - the object has an objectAt property
      - the object is an Object, and has a length property
  
    Unlike `typeOf` this method returns true even if the passed object is
    not formally an array but appears to be array-like (i.e. implements `Array`)
  
    ```javascript
    import { isArray } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    isArray();                                      // false
    isArray([]);                                    // true
    isArray(ArrayProxy.create({ content: [] }));    // true
    ```
  
    @method isArray
    @static
    @for @ember/array
    @param {Object} obj The object to test
    @return {Boolean} true if the passed object is an array or Array-like
    @public
  */

  function isArray(_obj) {
    var obj = _obj;
    if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY && typeof _obj === 'object' && _obj !== null) {
      var possibleProxyContent = _obj[_metal.PROXY_CONTENT];
      if (possibleProxyContent !== undefined) {
        obj = possibleProxyContent;
      }
    }
    if (!obj || obj.setInterval) {
      return false;
    }
    if (Array.isArray(obj) || ArrayMixin.detect(obj)) {
      return true;
    }
    var type = (0, _typeOf.typeOf)(obj);
    if ('array' === type) {
      return true;
    }
    var length = obj.length;
    if (typeof length === 'number' && length === length && 'object' === type) {
      return true;
    }
    return false;
  }
  /*
    This allows us to define computed properties that are not enumerable.
    The primary reason this is important is that when `NativeArray` is
    applied to `Array.prototype` we need to ensure that we do not add _any_
    new enumerable properties.
  */

  function nonEnumerableComputed() {
    var property = _metal.computed.apply(void 0, arguments);
    property.enumerable = false;
    return property;
  }
  function mapBy(key) {
    return this.map(function (next) {
      return (0, _metal.get)(next, key);
    });
  } // ..........................................................
  // ARRAY
  //

  /**
    This mixin implements Observer-friendly Array-like behavior. It is not a
    concrete implementation, but it can be used up by other classes that want
    to appear like arrays.
  
    For example, ArrayProxy is a concrete class that can be instantiated to
    implement array-like behavior. This class uses the Array Mixin by way of
    the MutableArray mixin, which allows observable changes to be made to the
    underlying array.
  
    This mixin defines methods specifically for collections that provide
    index-ordered access to their contents. When you are designing code that
    needs to accept any kind of Array-like object, you should use these methods
    instead of Array primitives because these will properly notify observers of
    changes to the array.
  
    Although these methods are efficient, they do add a layer of indirection to
    your application so it is a good idea to use them only when you need the
    flexibility of using both true JavaScript arrays and "virtual" arrays such
    as controllers and collections.
  
    You can use the methods defined in this module to access and modify array
    contents in an observable-friendly way. You can also be notified whenever
    the membership of an array changes by using `.observes('myArray.[]')`.
  
    To support `EmberArray` in your own class, you must override two
    primitives to use it: `length()` and `objectAt()`.
  
    @class EmberArray
    @uses Enumerable
    @since Ember 0.9.0
    @public
  */

  var ArrayMixin = _metal.Mixin.create(_enumerable.default, {
    init: function init() {
      this._super.apply(this, arguments);
      (0, _utils.setEmberArray)(this);
    },
    /**
      __Required.__ You must implement this method to apply this mixin.
       Your array must support the `length` property. Your replace methods should
      set this property whenever it changes.
       @property {Number} length
      @public
    */
    /**
      Returns the object at the given `index`. If the given `index` is negative
      or is greater or equal than the array length, returns `undefined`.
       This is one of the primitives you must implement to support `EmberArray`.
      If your object supports retrieving the value of an array item using `get()`
      (i.e. `myArray.get(0)`), then you do not need to implement this method
      yourself.
       ```javascript
      let arr = ['a', 'b', 'c', 'd'];
       arr.objectAt(0);   // 'a'
      arr.objectAt(3);   // 'd'
      arr.objectAt(-1);  // undefined
      arr.objectAt(4);   // undefined
      arr.objectAt(5);   // undefined
      ```
       @method objectAt
      @param {Number} idx The index of the item to return.
      @return {*} item at index or undefined
      @public
    */
    /**
      This returns the objects at the specified indexes, using `objectAt`.
       ```javascript
      let arr = ['a', 'b', 'c', 'd'];
       arr.objectsAt([0, 1, 2]);  // ['a', 'b', 'c']
      arr.objectsAt([2, 3, 4]);  // ['c', 'd', undefined]
      ```
       @method objectsAt
      @param {Array} indexes An array of indexes of items to return.
      @return {Array}
      @public
     */
    objectsAt: function objectsAt(indexes) {
      var _this = this;
      return indexes.map(function (idx) {
        return (0, _metal.objectAt)(_this, idx);
      });
    },
    /**
      This is the handler for the special array content property. If you get
      this property, it will return this. If you set this property to a new
      array, it will replace the current content.
       ```javascript
      let peopleToMoon = ['Armstrong', 'Aldrin'];
       peopleToMoon.get('[]'); // ['Armstrong', 'Aldrin']
       peopleToMoon.set('[]', ['Collins']); // ['Collins']
      peopleToMoon.get('[]'); // ['Collins']
      ```
       @property []
      @return this
      @public
    */
    '[]': nonEnumerableComputed({
      get: function get() {
        return this;
      },
      set: function set(key, value) {
        this.replace(0, this.length, value);
        return this;
      }
    }),
    /**
      The first object in the array, or `undefined` if the array is empty.
       ```javascript
      let vowels = ['a', 'e', 'i', 'o', 'u'];
      vowels.firstObject; // 'a'
       vowels.shiftObject();
      vowels.firstObject; // 'e'
       vowels.reverseObjects();
      vowels.firstObject; // 'u'
       vowels.clear();
      vowels.firstObject; // undefined
      ```
       @property firstObject
      @return {Object | undefined} The first object in the array
      @public
    */
    firstObject: nonEnumerableComputed(function () {
      return (0, _metal.objectAt)(this, 0);
    }).readOnly(),
    /**
      The last object in the array, or `undefined` if the array is empty.
       @property lastObject
      @return {Object | undefined} The last object in the array
      @public
    */
    lastObject: nonEnumerableComputed(function () {
      return (0, _metal.objectAt)(this, this.length - 1);
    }).readOnly(),
    // Add any extra methods to EmberArray that are native to the built-in Array.
    /**
      Returns a new array that is a slice of the receiver. This implementation
      uses the observable array methods to retrieve the objects for the new
      slice.
       ```javascript
      let arr = ['red', 'green', 'blue'];
       arr.slice(0);       // ['red', 'green', 'blue']
      arr.slice(0, 2);    // ['red', 'green']
      arr.slice(1, 100);  // ['green', 'blue']
      ```
       @method slice
      @param {Number} beginIndex (Optional) index to begin slicing from.
      @param {Number} endIndex (Optional) index to end the slice at (but not included).
      @return {Array} New array with specified slice
      @public
    */
    slice: function slice(beginIndex, endIndex) {
      if (beginIndex === void 0) {
        beginIndex = 0;
      }
      var ret = _A2();
      var length = this.length;
      if (beginIndex < 0) {
        beginIndex = length + beginIndex;
      }
      if (endIndex === undefined || endIndex > length) {
        endIndex = length;
      } else if (endIndex < 0) {
        endIndex = length + endIndex;
      }
      while (beginIndex < endIndex) {
        ret[ret.length] = (0, _metal.objectAt)(this, beginIndex++);
      }
      return ret;
    },
    /**
      Used to determine the passed object's first occurrence in the array.
      Returns the index if found, -1 if no match is found.
       The optional `startAt` argument can be used to pass a starting
      index to search from, effectively slicing the searchable portion
      of the array. If it's negative it will add the array length to
      the startAt value passed in as the index to search from. If less
      than or equal to `-1 * array.length` the entire array is searched.
       ```javascript
      let arr = ['a', 'b', 'c', 'd', 'a'];
       arr.indexOf('a');       //  0
      arr.indexOf('z');       // -1
      arr.indexOf('a', 2);    //  4
      arr.indexOf('a', -1);   //  4, equivalent to indexOf('a', 4)
      arr.indexOf('a', -100); //  0, searches entire array
      arr.indexOf('b', 3);    // -1
      arr.indexOf('a', 100);  // -1
       let people = [{ name: 'Zoey' }, { name: 'Bob' }]
      let newPerson = { name: 'Tom' };
      people = [newPerson, ...people, newPerson];
       people.indexOf(newPerson);     //  0
      people.indexOf(newPerson, 1);  //  3
      people.indexOf(newPerson, -4); //  0
      people.indexOf(newPerson, 10); // -1
      ```
       @method indexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search, default 0
      @return {Number} index or -1 if not found
      @public
    */
    indexOf: function indexOf(object, startAt) {
      return _indexOf(this, object, startAt, false);
    },
    /**
      Returns the index of the given `object`'s last occurrence.
       - If no `startAt` argument is given, the search starts from
      the last position.
      - If it's greater than or equal to the length of the array,
      the search starts from the last position.
      - If it's negative, it is taken as the offset from the end
      of the array i.e. `startAt + array.length`.
      - If it's any other positive number, will search backwards
      from that index of the array.
       Returns -1 if no match is found.
       ```javascript
      let arr = ['a', 'b', 'c', 'd', 'a'];
       arr.lastIndexOf('a');       //  4
      arr.lastIndexOf('z');       // -1
      arr.lastIndexOf('a', 2);    //  0
      arr.lastIndexOf('a', -1);   //  4
      arr.lastIndexOf('a', -3);   //  0
      arr.lastIndexOf('b', 3);    //  1
      arr.lastIndexOf('a', 100);  //  4
      ```
       @method lastIndexOf
      @param {Object} object the item to search for
      @param {Number} startAt optional starting location to search from
      backwards, defaults to `(array.length - 1)`
      @return {Number} The last index of the `object` in the array or -1
      if not found
      @public
    */
    lastIndexOf: function lastIndexOf(object, startAt) {
      var len = this.length;
      if (startAt === undefined || startAt >= len) {
        startAt = len - 1;
      }
      if (startAt < 0) {
        startAt += len;
      }
      for (var idx = startAt; idx >= 0; idx--) {
        if ((0, _metal.objectAt)(this, idx) === object) {
          return idx;
        }
      }
      return -1;
    },
    // ..........................................................
    // ARRAY OBSERVERS
    //
    /**
      Adds an array observer to the receiving array. The array observer object
      normally must implement two methods:
       * `willChange(observedObj, start, removeCount, addCount)` - This method will be
        called just before the array is modified.
      * `didChange(observedObj, start, removeCount, addCount)` - This method will be
        called just after the array is modified.
       Both callbacks will be passed the observed object, starting index of the
      change as well as a count of the items to be removed and added. You can use
      these callbacks to optionally inspect the array during the change, clear
      caches, or do any other bookkeeping necessary.
       In addition to passing a target, you can also include an options hash
      which you can use to override the method names that will be invoked on the
      target.
       @method addArrayObserver
      @param {Object} target The observer object.
      @param {Object} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {EmberArray} receiver
      @public
      @example
          import Service from '@ember/service';
           export default Service.extend({
            data: Ember.A(),
             init() {
              this._super(...arguments);
               this.data.addArrayObserver(this, {
                willChange: 'dataWillChange',
                didChange: 'dataDidChange'
              });
            },
             dataWillChange(array, start, removeCount, addCount) {
              console.log('array will change', array, start, removeCount, addCount);
            },
             dataDidChange(array, start, removeCount, addCount) {
              console.log('array did change', array, start, removeCount, addCount);
            }
          });
    */
    addArrayObserver: function addArrayObserver(target, opts) {
      return (0, _metal.addArrayObserver)(this, target, opts);
    },
    /**
      Removes an array observer from the object if the observer is current
      registered. Calling this method multiple times with the same object will
      have no effect.
       @method removeArrayObserver
      @param {Object} target The object observing the array.
      @param {Object} opts Optional hash of configuration options including
        `willChange` and `didChange` option.
      @return {EmberArray} receiver
      @public
    */
    removeArrayObserver: function removeArrayObserver(target, opts) {
      return (0, _metal.removeArrayObserver)(this, target, opts);
    },
    /**
      Becomes true whenever the array currently has observers watching changes
      on the array.
       ```javascript
      let arr = [1, 2, 3, 4, 5];
      arr.hasArrayObservers; // false
       arr.addArrayObserver(this, {
        willChange() {
          console.log('willChange');
        }
      });
      arr.hasArrayObservers; // true
      ```
       @property {Boolean} hasArrayObservers
      @public
    */
    hasArrayObservers: (0, _metal.nativeDescDecorator)({
      configurable: true,
      enumerable: false,
      get: function get() {
        return (0, _metal.hasListeners)(this, '@array:change') || (0, _metal.hasListeners)(this, '@array:before');
      }
    }),
    /**
      If you are implementing an object that supports `EmberArray`, call this
      method just before the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       ```app/components/show-post.js
      import Component from '@ember/component';
      import EmberObject from '@ember/object';
       const Post = EmberObject.extend({
        body: '',
        save() {}
      })
       export default Component.extend({
        attemptsToModify: 0,
        successfulModifications: 0,
        posts: null,
         init() {
          this._super(...arguments);
           this.posts = [1, 2, 3].map(i => Post.create({ body: i }));
          this.posts.addArrayObserver(this, {
            willChange() {
              this.incrementProperty('attemptsToModify');
            },
            didChange() {
              this.incrementProperty('successfulModifications');
            }
          });
        },
         actions: {
          editPost(post, newContent) {
            let oldContent = post.body,
                postIndex = this.posts.indexOf(post);
             this.posts.arrayContentWillChange(postIndex, 0, 0); // attemptsToModify = 1
            post.set('body', newContent);
             post.save()
              .then(response => {
                this.posts.arrayContentDidChange(postIndex, 0, 0); // successfulModifications = 1
              })
              .catch(error => {
                post.set('body', oldContent);
              })
          }
        }
      });
      ```
       @method arrayContentWillChange
      @param {Number} startIdx The starting index in the array that will change.
      @param {Number} removeAmt The number of items that will be removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that will be added. If you
        pass `null` assumes 0.
      @return {EmberArray} receiver
      @public
    */
    arrayContentWillChange: function arrayContentWillChange(startIdx, removeAmt, addAmt) {
      return (0, _metal.arrayContentWillChange)(this, startIdx, removeAmt, addAmt);
    },
    /**
      If you are implementing an object that supports `EmberArray`, call this
      method just after the array content changes to notify any observers and
      invalidate any related properties. Pass the starting index of the change
      as well as a delta of the amounts to change.
       ```javascript
      let arr = [1, 2, 3, 4, 5];
       arr.copyWithin(-2); // [1, 2, 3, 1, 2]
      // arr.lastObject = 5
      arr.arrayContentDidChange(3, 2, 2);
      // arr.lastObject = 2
      ```
       @method arrayContentDidChange
      @param {Number} startIdx The starting index in the array that did change.
      @param {Number} removeAmt The number of items that were removed. If you
        pass `null` assumes 0
      @param {Number} addAmt The number of items that were added. If you
        pass `null` assumes 0.
      @return {EmberArray} receiver
      @public
    */
    arrayContentDidChange: function arrayContentDidChange(startIdx, removeAmt, addAmt) {
      return (0, _metal.arrayContentDidChange)(this, startIdx, removeAmt, addAmt);
    },
    /**
      Iterates through the array, calling the passed function on each
      item. This method corresponds to the `forEach()` method defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      let foods = [
        { name: 'apple', eaten: false },
        { name: 'banana', eaten: false },
        { name: 'carrot', eaten: false }
      ];
       foods.forEach((food) => food.eaten = true);
       let output = '';
      foods.forEach((item, index, array) =>
        output += `${index + 1}/${array.length} ${item.name}\n`;
      );
      console.log(output);
      // 1/3 apple
      // 2/3 banana
      // 3/3 carrot
      ```
       @method forEach
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} receiver
      @public
    */
    forEach: function forEach(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`forEach` expects a function as first argument.', typeof callback === 'function'));
      var length = this.length;
      for (var index = 0; index < length; index++) {
        var item = this.objectAt(index);
        callback.call(target, item, index, this);
      }
      return this;
    },
    /**
      Alias for `mapBy`.
       Returns the value of the named
      property on all items in the enumeration.
       ```javascript
      let people = [{name: 'Joe'}, {name: 'Matt'}];
       people.getEach('name');
      // ['Joe', 'Matt'];
       people.getEach('nonexistentProperty');
      // [undefined, undefined];
      ```
       @method getEach
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    getEach: mapBy,
    /**
      Sets the value on the named property for each member. This is more
      ergonomic than using other methods defined on this helper. If the object
      implements Observable, the value will be changed to `set(),` otherwise
      it will be set directly. `null` objects are skipped.
       ```javascript
      let people = [{name: 'Joe'}, {name: 'Matt'}];
       people.setEach('zipCode', '10011');
      // [{name: 'Joe', zipCode: '10011'}, {name: 'Matt', zipCode: '10011'}];
      ```
       @method setEach
      @param {String} key The key to set
      @param {Object} value The object to set
      @return {Object} receiver
      @public
    */
    setEach: function setEach(key, value) {
      return this.forEach(function (item) {
        return (0, _metal.set)(item, key, value);
      });
    },
    /**
      Maps all of the items in the enumeration to another value, returning
      a new array. This method corresponds to `map()` defined in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      let arr = [1, 2, 3, 4, 5, 6];
       arr.map(element => element * element);
      // [1, 4, 9, 16, 25, 36];
       arr.map((element, index) => element + index);
      // [1, 3, 5, 7, 9, 11];
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return the mapped value.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method map
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} The mapped array.
      @public
    */
    map: function map(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`map` expects a function as first argument.', typeof callback === 'function'));
      var ret = _A2();
      this.forEach(function (x, idx, i) {
        return ret[idx] = callback.call(target, x, idx, i);
      });
      return ret;
    },
    /**
      Similar to map, this specialized function returns the value of the named
      property on all items in the enumeration.
       ```javascript
      let people = [{name: 'Joe'}, {name: 'Matt'}];
       people.mapBy('name');
      // ['Joe', 'Matt'];
       people.mapBy('unknownProperty');
      // [undefined, undefined];
      ```
       @method mapBy
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    mapBy: mapBy,
    /**
      Returns a new array with all of the items in the enumeration that the provided
      callback function returns true for. This method corresponds to [Array.prototype.filter()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter).
       The callback method should have the following signature:
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       All parameters are optional. The function should return `true` to include the item
      in the results, and `false` otherwise.
       Example:
       ```javascript
      function isAdult(person) {
        return person.age > 18;
      };
       let people = Ember.A([{ name: 'John', age: 14 }, { name: 'Joan', age: 45 }]);
       people.filter(isAdult); // returns [{ name: 'Joan', age: 45 }];
      ```
       Note that in addition to a callback, you can pass an optional target object
      that will be set as `this` on the context. This is a good way to give your
      iterator function access to the current object. For example:
       ```javascript
      function isAdultAndEngineer(person) {
        return person.age > 18 && this.engineering;
      }
       class AdultsCollection {
        engineering = false;
         constructor(opts = {}) {
          super(...arguments);
           this.engineering = opts.engineering;
          this.people = Ember.A([{ name: 'John', age: 14 }, { name: 'Joan', age: 45 }]);
        }
      }
       let collection = new AdultsCollection({ engineering: true });
      collection.people.filter(isAdultAndEngineer, { target: collection });
      ```
       @method filter
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A filtered array.
      @public
    */
    filter: function filter(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`filter` expects a function as first argument.', typeof callback === 'function'));
      var ret = _A2();
      this.forEach(function (x, idx, i) {
        if (callback.call(target, x, idx, i)) {
          ret.push(x);
        }
      });
      return ret;
    },
    /**
      Returns an array with all of the items in the enumeration where the passed
      function returns false. This method is the inverse of filter().
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - *item* is the current item in the iteration.
      - *index* is the current index in the iteration
      - *array* is the array itself.
       It should return a falsey value to include the item in the results.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as "this" on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      const food = [
        { food: 'apple', isFruit: true },
        { food: 'bread', isFruit: false },
        { food: 'banana', isFruit: true }
      ];
      const nonFruits = food.reject(function(thing) {
        return thing.isFruit;
      }); // [{food: 'bread', isFruit: false}]
      ```
       @method reject
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A rejected array.
      @public
    */
    reject: function reject(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`reject` expects a function as first argument.', typeof callback === 'function'));
      return this.filter(function () {
        return !callback.apply(target, arguments);
      });
    },
    /**
      Filters the array by the property and an optional value. If a value is given, it returns
      the items that have said value for the property. If not, it returns all the items that
      have a truthy value for the property.
       Example Usage:
       ```javascript
      let things = Ember.A([{ food: 'apple', isFruit: true }, { food: 'beans', isFruit: false }]);
       things.filterBy('food', 'beans'); // [{ food: 'beans', isFruit: false }]
      things.filterBy('isFruit'); // [{ food: 'apple', isFruit: true }]
      ```
       @method filterBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} filtered array
      @public
    */
    filterBy: function filterBy() {
      return this.filter(iter.apply(void 0, arguments));
    },
    /**
      Returns an array with the items that do not have truthy values for the provided key.
      You can pass an optional second argument with a target value to reject for the key.
      Otherwise this will reject objects where the provided property evaluates to false.
       Example Usage:
       ```javascript
        let food = [
          { name: "apple", isFruit: true },
          { name: "carrot", isFruit: false },
          { name: "bread", isFruit: false },
        ];
        food.rejectBy('isFruit'); // [{ name: "carrot", isFruit: false }, { name: "bread", isFruit: false }]
        food.rejectBy('name', 'carrot'); // [{ name: "apple", isFruit: true }}, { name: "bread", isFruit: false }]
      ```
       @method rejectBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} rejected array
      @public
    */
    rejectBy: function rejectBy() {
      return this.reject(iter.apply(void 0, arguments));
    },
    /**
      Returns the first item in the array for which the callback returns true.
      This method is similar to the `find()` method defined in ECMAScript 2015.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      let users = [
        { id: 1, name: 'Yehuda' },
        { id: 2, name: 'Tom' },
        { id: 3, name: 'Melanie' },
        { id: 4, name: 'Leah' }
      ];
       users.find((user) => user.name == 'Tom'); // [{ id: 2, name: 'Tom' }]
      users.find(({ id }) => id == 3); // [{ id: 3, name: 'Melanie' }]
      ```
       @method find
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} Found item or `undefined`.
      @public
    */
    find: function find(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`find` expects a function as first argument.', typeof callback === 'function'));
      return _find(this, callback, target);
    },
    /**
      Returns the first item with a property matching the passed value. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       This method works much like the more generic `find()` method.
       Usage Example:
       ```javascript
      let users = [
        { id: 1, name: 'Yehuda', isTom: false },
        { id: 2, name: 'Tom', isTom: true },
        { id: 3, name: 'Melanie', isTom: false },
        { id: 4, name: 'Leah', isTom: false }
      ];
       users.findBy('id', 4); // { id: 4, name: 'Leah', isTom: false }
      users.findBy('name', 'Melanie'); // { id: 3, name: 'Melanie', isTom: false }
      users.findBy('isTom'); // { id: 2, name: 'Tom', isTom: true }
      ```
       @method findBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Object} found item or `undefined`
      @public
    */
    findBy: function findBy() {
      return _find(this, iter.apply(void 0, arguments));
    },
    /**
      Returns `true` if the passed function returns true for every item in the
      enumeration. This corresponds with the `Array.prototype.every()` method defined in ES5.
       The callback method should have the following signature:
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       All params are optional. The method should return `true` or `false`.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Usage example:
       ```javascript
      function isAdult(person) {
        return person.age > 18;
      };
       const people = Ember.A([{ name: 'John', age: 24 }, { name: 'Joan', age: 45 }]);
      const areAllAdults = people.every(isAdult);
      ```
       @method every
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean}
      @public
    */
    every: function every(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`every` expects a function as first argument.', typeof callback === 'function'));
      return _every(this, callback, target);
    },
    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for all items in the array. This method is often simpler/faster
      than using a callback.
       Note that like the native `Array.every`, `isEvery` will return true when called
      on any empty array.
      ```javascript
      class Language {
        constructor(name, isProgrammingLanguage) {
          this.name = name;
          this.programmingLanguage = isProgrammingLanguage;
        }
      }
       const compiledLanguages = [
        new Language('Java', true),
        new Language('Go', true),
        new Language('Rust', true)
      ]
       const languagesKnownByMe = [
        new Language('Javascript', true),
        new Language('English', false),
        new Language('Ruby', true)
      ]
       compiledLanguages.isEvery('programmingLanguage'); // true
      languagesKnownByMe.isEvery('programmingLanguage'); // false
      ```
       @method isEvery
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isEvery: function isEvery() {
      return _every(this, iter.apply(void 0, arguments));
    },
    /**
      The any() method executes the callback function once for each element
      present in the array until it finds the one where callback returns a truthy
      value (i.e. `true`). If such an element is found, any() immediately returns
      true. Otherwise, any() returns false.
       ```javascript
      function(item, index, array);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array object itself.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. It can be a good way
      to give your iterator function access to an object in cases where an ES6
      arrow function would not be appropriate.
       Usage Example:
       ```javascript
      let includesManager = people.any(this.findPersonInManagersList, this);
       let includesStockHolder = people.any(person => {
        return this.findPersonInStockHoldersList(person)
      });
       if (includesManager || includesStockHolder) {
        Paychecks.addBiggerBonus();
      }
      ```
       @method any
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean} `true` if the passed function returns `true` for any item
      @public
    */
    any: function any(callback, target) {
      if (target === void 0) {
        target = null;
      }
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`any` expects a function as first argument.', typeof callback === 'function'));
      return _any(this, callback, target);
    },
    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for any item in the array. This method is often simpler/faster
      than using a callback.
       Example usage:
       ```javascript
      const food = [
        { food: 'apple', isFruit: true },
        { food: 'bread', isFruit: false },
        { food: 'banana', isFruit: true }
      ];
       food.isAny('isFruit'); // true
      ```
       @method isAny
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isAny: function isAny() {
      return _any(this, iter.apply(void 0, arguments));
    },
    /**
      This will combine the values of the array into a single value. It
      is a useful way to collect a summary value from an array. This
      corresponds to the `reduce()` method defined in JavaScript 1.8.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(previousValue, item, index, array);
      ```
       - `previousValue` is the value returned by the last call to the iterator.
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `array` is the array itself.
       Return the new cumulative value.
       In addition to the callback you can also pass an `initialValue`. An error
      will be raised if you do not pass an initial value and the enumerator is
      empty.
       Note that unlike the other methods, this method does not allow you to
      pass a target object to set as this for the callback. It's part of the
      spec. Sorry.
       Example Usage:
       ```javascript
        let numbers = [1, 2, 3, 4, 5];
         numbers.reduce(function(summation, current) {
          return summation + current;
        }); // 15 (1 + 2 + 3 + 4 + 5)
         numbers.reduce(function(summation, current) {
          return summation + current;
        }, -15); // 0 (-15 + 1 + 2 + 3 + 4 + 5)
          let binaryValues = [true, false, false];
         binaryValues.reduce(function(truthValue, current) {
          return truthValue && current;
        }); // false (true && false && false)
      ```
       @method reduce
      @param {Function} callback The callback to execute
      @param {Object} initialValue Initial value for the reduce
      @return {Object} The reduced value.
      @public
    */
    reduce: function reduce(callback, initialValue) {
      (true && !(typeof callback === 'function') && (0, _debug.assert)('`reduce` expects a function as first argument.', typeof callback === 'function'));
      var ret = initialValue;
      this.forEach(function (item, i) {
        ret = callback(ret, item, i, this);
      }, this);
      return ret;
    },
    /**
      Invokes the named method on every object in the receiver that
      implements it. This method corresponds to the implementation in
      Prototype 1.6.
       ```javascript
      class Person {
        name = null;
         constructor(name) {
          this.name = name;
        }
         greet(prefix='Hello') {
          return `${prefix} ${this.name}`;
        }
      }
       let people = [new Person('Joe'), new Person('Matt')];
       people.invoke('greet'); // ['Hello Joe', 'Hello Matt']
      people.invoke('greet', 'Bonjour'); // ['Bonjour Joe', 'Bonjour Matt']
      ```
       @method invoke
      @param {String} methodName the name of the method
      @param {Object...} args optional arguments to pass as well.
      @return {Array} return values from calling invoke.
      @public
    */
    invoke: function invoke(methodName) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      var ret = _A2();
      this.forEach(function (item) {
        var _item$methodName;
        return ret.push((_item$methodName = item[methodName]) == null ? void 0 : _item$methodName.call.apply(_item$methodName, [item].concat(args)));
      });
      return ret;
    },
    /**
      Simply converts the object into a genuine array. The order is not
      guaranteed. Corresponds to the method implemented by Prototype.
       @method toArray
      @return {Array} the object as an array.
      @public
    */
    toArray: function toArray() {
      return this.map(function (item) {
        return item;
      });
    },
    /**
      Returns a copy of the array with all `null` and `undefined` elements removed.
       ```javascript
      let arr = ['a', null, 'c', undefined];
      arr.compact();  // ['a', 'c']
      ```
       @method compact
      @return {Array} the array without null and undefined elements.
      @public
    */
    compact: function compact() {
      return this.filter(function (value) {
        return value != null;
      });
    },
    /**
      Used to determine if the array contains the passed object.
      Returns `true` if found, `false` otherwise.
       The optional `startAt` argument can be used to pass a starting
      index to search from, effectively slicing the searchable portion
      of the array. If it's negative it will add the array length to
      the startAt value passed in as the index to search from. If less
      than or equal to `-1 * array.length` the entire array is searched.
       This method has the same behavior of JavaScript's [Array.includes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes).
       ```javascript
      [1, 2, 3].includes(2);     // true
      [1, 2, 3].includes(4);     // false
      [1, 2, 3].includes(3, 2);  // true
      [1, 2, 3].includes(3, 3);  // false
      [1, 2, 3].includes(3, -1); // true
      [1, 2, 3].includes(1, -1); // false
      [1, 2, 3].includes(1, -4); // true
      [1, 2, NaN].includes(NaN); // true
      ```
       @method includes
      @param {Object} object The object to search for.
      @param {Number} startAt optional starting location to search, default 0
      @return {Boolean} `true` if object is found in the array.
      @public
    */
    includes: function includes(object, startAt) {
      return _indexOf(this, object, startAt, true) !== -1;
    },
    /**
      Sorts the array by the keys specified in the argument.
       You may provide multiple arguments to sort by multiple properties.
       ```javascript
     let colors = [
       { name: 'red', weight: 500 },
       { name: 'green', weight: 600 },
       { name: 'blue', weight: 500 }
      ];
      colors.sortBy('name');
     // [{name: 'blue', weight: 500}, {name: 'green', weight: 600}, {name: 'red', weight: 500}]
      colors.sortBy('weight', 'name');
     // [{name: 'blue', weight: 500}, {name: 'red', weight: 500}, {name: 'green', weight: 600}]
     ```
       @method sortBy
      @param {String} property name(s) to sort on
      @return {Array} The sorted array.
      @since 1.2.0
      @public
    */
    sortBy: function sortBy() {
      var sortKeys = arguments;
      return this.toArray().sort(function (a, b) {
        for (var i = 0; i < sortKeys.length; i++) {
          var key = sortKeys[i];
          var propA = (0, _metal.get)(a, key);
          var propB = (0, _metal.get)(b, key); // return 1 or -1 else continue to the next sortKey

          var compareValue = (0, _compare.default)(propA, propB);
          if (compareValue) {
            return compareValue;
          }
        }
        return 0;
      });
    },
    /**
      Returns a new array that contains only unique values. The default
      implementation returns an array regardless of the receiver type.
       ```javascript
      let arr = ['a', 'a', 'b', 'b'];
      arr.uniq();  // ['a', 'b']
      ```
       This only works on primitive data types, e.g. Strings, Numbers, etc.
       @method uniq
      @return {EmberArray}
      @public
    */
    uniq: function uniq() {
      return _uniqBy(this);
    },
    /**
      Returns a new array that contains only items containing a unique property value.
      The default implementation returns an array regardless of the receiver type.
       ```javascript
      let arr = [{ value: 'a' }, { value: 'a' }, { value: 'b' }, { value: 'b' }];
      arr.uniqBy('value');  // [{ value: 'a' }, { value: 'b' }]
       let arr = [2.2, 2.1, 3.2, 3.3];
      arr.uniqBy(Math.floor);  // [2.2, 3.2];
      ```
       @method uniqBy
      @param {String,Function} key
      @return {EmberArray}
      @public
    */
    uniqBy: function uniqBy(key) {
      return _uniqBy(this, key);
    },
    /**
      Returns a new array that excludes the passed value. The default
      implementation returns an array regardless of the receiver type.
      If the receiver does not contain the value it returns the original array.
       ```javascript
      let arr = ['a', 'b', 'a', 'c'];
      arr.without('a');  // ['b', 'c']
      ```
       @method without
      @param {Object} value
      @return {EmberArray}
      @public
    */
    without: function without(value) {
      if (!this.includes(value)) {
        return this; // nothing to do
      } // SameValueZero comparison (NaN !== NaN)

      var predicate = value === value ? function (item) {
        return item !== value;
      } : function (item) {
        return item === item;
      };
      return this.filter(predicate);
    }
  });
  /**
    This mixin defines the API for modifying array-like objects. These methods
    can be applied only to a collection that keeps its items in an ordered set.
    It builds upon the Array mixin and adds methods to modify the array.
    One concrete implementations of this class include ArrayProxy.
  
    It is important to use the methods in this class to modify arrays so that
    changes are observable. This allows the binding system in Ember to function
    correctly.
  
  
    Note that an Array can change even if it does not implement this mixin.
    For example, one might implement a SparseArray that cannot be directly
    modified, but if its underlying enumerable changes, it will change also.
  
    @class MutableArray
    @uses EmberArray
    @uses MutableEnumerable
    @public
  */

  var MutableArray = _metal.Mixin.create(ArrayMixin, _mutable_enumerable.default, {
    /**
      __Required.__ You must implement this method to apply this mixin.
       This is one of the primitives you must implement to support `Array`.
      You should replace amt objects started at idx with the objects in the
      passed array. You should also call `this.arrayContentDidChange()`
       Note that this method is expected to validate the type(s) of objects that it expects.
       @method replace
      @param {Number} idx Starting index in the array to replace. If
        idx >= length, then append to the end of the array.
      @param {Number} amt Number of elements that should be removed from
        the array, starting at *idx*.
      @param {EmberArray} objects An array of zero or more objects that should be
        inserted into the array at *idx*
      @public
    */
    /**
      Remove all elements from the array. This is useful if you
      want to reuse an existing array without having to recreate it.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.length;  // 3
      colors.clear(); // []
      colors.length;  // 0
      ```
       @method clear
      @return {Array} An empty Array.
      @public
    */
    clear: function clear() {
      var len = this.length;
      if (len === 0) {
        return this;
      }
      this.replace(0, len, EMPTY_ARRAY);
      return this;
    },
    /**
      This will use the primitive `replace()` method to insert an object at the
      specified index.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.insertAt(2, 'yellow');  // ['red', 'green', 'yellow', 'blue']
      colors.insertAt(5, 'orange');  // Error: Index out of range
      ```
       @method insertAt
      @param {Number} idx index of insert the object at.
      @param {Object} object object to insert
      @return {EmberArray} receiver
      @public
    */
    insertAt: function insertAt(idx, object) {
      _insertAt(this, idx, object);
      return this;
    },
    /**
      Remove an object at the specified index using the `replace()` primitive
      method. You can pass either a single index, or a start and a length.
       If you pass a start and length that is beyond the
      length this method will throw an assertion.
       ```javascript
      let colors = ['red', 'green', 'blue', 'yellow', 'orange'];
       colors.removeAt(0);     // ['green', 'blue', 'yellow', 'orange']
      colors.removeAt(2, 2);  // ['green', 'blue']
      colors.removeAt(4, 2);  // Error: Index out of range
      ```
       @method removeAt
      @param {Number} start index, start of range
      @param {Number} len length of passing range
      @return {EmberArray} receiver
      @public
    */
    removeAt: function removeAt(start, len) {
      return _removeAt(this, start, len);
    },
    /**
      Push the object onto the end of the array. Works just like `push()` but it
      is KVO-compliant.
       ```javascript
      let colors = ['red', 'green'];
       colors.pushObject('black');     // ['red', 'green', 'black']
      colors.pushObject(['yellow']);  // ['red', 'green', ['yellow']]
      ```
       @method pushObject
      @param {*} obj object to push
      @return object same object passed as a param
      @public
    */
    pushObject: function pushObject(obj) {
      return _insertAt(this, this.length, obj);
    },
    /**
      Add the objects in the passed array to the end of the array. Defers
      notifying observers of the change until all objects are added.
       ```javascript
      let colors = ['red'];
       colors.pushObjects(['yellow', 'orange']);  // ['red', 'yellow', 'orange']
      ```
       @method pushObjects
      @param {EmberArray} objects the objects to add
      @return {EmberArray} receiver
      @public
    */
    pushObjects: function pushObjects(objects) {
      this.replace(this.length, 0, objects);
      return this;
    },
    /**
      Pop object from array or nil if none are left. Works just like `pop()` but
      it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.popObject();   // 'blue'
      console.log(colors);  // ['red', 'green']
      ```
       @method popObject
      @return object
      @public
    */
    popObject: function popObject() {
      var len = this.length;
      if (len === 0) {
        return null;
      }
      var ret = (0, _metal.objectAt)(this, len - 1);
      this.removeAt(len - 1, 1);
      return ret;
    },
    /**
      Shift an object from start of array or nil if none are left. Works just
      like `shift()` but it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.shiftObject();  // 'red'
      console.log(colors);   // ['green', 'blue']
      ```
       @method shiftObject
      @return object
      @public
    */
    shiftObject: function shiftObject() {
      if (this.length === 0) {
        return null;
      }
      var ret = (0, _metal.objectAt)(this, 0);
      this.removeAt(0);
      return ret;
    },
    /**
      Unshift an object to start of array. Works just like `unshift()` but it is
      KVO-compliant.
       ```javascript
      let colors = ['red'];
       colors.unshiftObject('yellow');    // ['yellow', 'red']
      colors.unshiftObject(['black']);   // [['black'], 'yellow', 'red']
      ```
       @method unshiftObject
      @param {*} obj object to unshift
      @return object same object passed as a param
      @public
    */
    unshiftObject: function unshiftObject(obj) {
      return _insertAt(this, 0, obj);
    },
    /**
      Adds the named objects to the beginning of the array. Defers notifying
      observers until all objects have been added.
       ```javascript
      let colors = ['red'];
       colors.unshiftObjects(['black', 'white']);   // ['black', 'white', 'red']
      colors.unshiftObjects('yellow'); // Type Error: 'undefined' is not a function
      ```
       @method unshiftObjects
      @param {Enumberable} objects the objects to add
      @return {EmberArray} receiver
      @public
    */
    unshiftObjects: function unshiftObjects(objects) {
      this.replace(0, 0, objects);
      return this;
    },
    /**
      Reverse objects in the array. Works just like `reverse()` but it is
      KVO-compliant.
       @method reverseObjects
      @return {EmberArray} receiver
       @public
    */
    reverseObjects: function reverseObjects() {
      var len = this.length;
      if (len === 0) {
        return this;
      }
      var objects = this.toArray().reverse();
      this.replace(0, len, objects);
      return this;
    },
    /**
      Replace all the receiver's content with content of the argument.
      If argument is an empty array receiver will be cleared.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.setObjects(['black', 'white']);  // ['black', 'white']
      colors.setObjects([]);                  // []
      ```
       @method setObjects
      @param {EmberArray} objects array whose content will be used for replacing
          the content of the receiver
      @return {EmberArray} receiver with the new content
      @public
    */
    setObjects: function setObjects(objects) {
      if (objects.length === 0) {
        return this.clear();
      }
      var len = this.length;
      this.replace(0, len, objects);
      return this;
    },
    /**
      Remove all occurrences of an object in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin', 'Lima', 'Chicago'];
       cities.removeObject('Chicago');  // ['Berlin', 'Lima']
      cities.removeObject('Lima');     // ['Berlin']
      cities.removeObject('Tokyo')     // ['Berlin']
      ```
       @method removeObject
      @param {*} obj object to remove
      @return {EmberArray} receiver
      @public
    */
    removeObject: function removeObject(obj) {
      var loc = this.length || 0;
      while (--loc >= 0) {
        var curObject = (0, _metal.objectAt)(this, loc);
        if (curObject === obj) {
          this.removeAt(loc);
        }
      }
      return this;
    },
    /**
      Removes each object in the passed array from the receiver.
       @method removeObjects
      @param {EmberArray} objects the objects to remove
      @return {EmberArray} receiver
      @public
    */
    removeObjects: function removeObjects(objects) {
      (0, _metal.beginPropertyChanges)();
      for (var i = objects.length - 1; i >= 0; i--) {
        this.removeObject(objects[i]);
      }
      (0, _metal.endPropertyChanges)();
      return this;
    },
    /**
      Push the object onto the end of the array if it is not already
      present in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin'];
       cities.addObject('Lima');    // ['Chicago', 'Berlin', 'Lima']
      cities.addObject('Berlin');  // ['Chicago', 'Berlin', 'Lima']
      ```
       @method addObject
      @param {*} obj object to add, if not already present
      @return {EmberArray} receiver
      @public
    */
    addObject: function addObject(obj) {
      var included = this.includes(obj);
      if (!included) {
        this.pushObject(obj);
      }
      return this;
    },
    /**
      Adds each object in the passed array to the receiver.
       @method addObjects
      @param {EmberArray} objects the objects to add.
      @return {EmberArray} receiver
      @public
    */
    addObjects: function addObjects(objects) {
      var _this2 = this;
      (0, _metal.beginPropertyChanges)();
      objects.forEach(function (obj) {
        return _this2.addObject(obj);
      });
      (0, _metal.endPropertyChanges)();
      return this;
    }
  });
  /**
    Creates an `Ember.NativeArray` from an Array-like object.
    Does not modify the original object's contents. `A()` is not needed if
    `EmberENV.EXTEND_PROTOTYPES` is `true` (the default value). However,
    it is recommended that you use `A()` when creating addons for
    ember or when you can not guarantee that `EmberENV.EXTEND_PROTOTYPES`
    will be `true`.
  
    Example
  
    ```app/components/my-component.js
    import Component from '@ember/component';
    import { A } from '@ember/array';
  
    export default Component.extend({
      tagName: 'ul',
      classNames: ['pagination'],
  
      init() {
        this._super(...arguments);
  
        if (!this.get('content')) {
          this.set('content', A());
          this.set('otherContent', A([1,2,3]));
        }
      }
    });
    ```
  
    @method A
    @static
    @for @ember/array
    @return {Ember.NativeArray}
    @public
  */
  // Add Ember.Array to Array.prototype. Remove methods with native
  // implementations and supply some more optimized versions of generic methods
  // because they are so common.

  /**
  @module ember
  */

  /**
    The NativeArray mixin contains the properties needed to make the native
    Array support MutableArray and all of its dependent APIs. Unless you
    have `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Array` set to
    false, this will be applied automatically. Otherwise you can apply the mixin
    at anytime by calling `Ember.NativeArray.apply(Array.prototype)`.
  
    @class Ember.NativeArray
    @uses MutableArray
    @uses Observable
    @public
  */
  _exports.MutableArray = MutableArray;
  var NativeArray = _metal.Mixin.create(MutableArray, _observable.default, {
    objectAt: function objectAt(idx) {
      return this[idx];
    },
    // primitive for array support.
    replace: function replace(start, deleteCount, items) {
      if (items === void 0) {
        items = EMPTY_ARRAY;
      }
      (true && !(Array.isArray(items)) && (0, _debug.assert)('The third argument to replace needs to be an array.', Array.isArray(items)));
      (0, _metal.replaceInNativeArray)(this, start, deleteCount, items);
      return this;
    }
  }); // Remove any methods implemented natively so we don't override them
  _exports.NativeArray = NativeArray;
  var ignore = ['length'];
  NativeArray.keys().forEach(function (methodName) {
    if (Array.prototype[methodName]) {
      ignore.push(methodName);
    }
  });
  _exports.NativeArray = NativeArray = (_NativeArray = NativeArray).without.apply(_NativeArray, ignore);
  var _A2;
  _exports.A = _A2;
  if (_environment.ENV.EXTEND_PROTOTYPES.Array) {
    NativeArray.apply(Array.prototype, true);
    _exports.A = _A2 = function A(arr) {
      (true && !(!(this instanceof _A2)) && (0, _debug.assert)('You cannot create an Ember Array with `new A()`, please update to calling A as a function: `A()`', !(this instanceof _A2)));
      return arr || [];
    };
  } else {
    _exports.A = _A2 = function _A(arr) {
      (true && !(!(this instanceof _A2)) && (0, _debug.assert)('You cannot create an Ember Array with `new A()`, please update to calling A as a function: `A()`', !(this instanceof _A2)));
      if (!arr) {
        arr = [];
      }
      return ArrayMixin.detect(arr) ? arr : NativeArray.apply(arr);
    };
  }
  var _default = ArrayMixin;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/comparable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  /**
    Implements some standard methods for comparing objects. Add this mixin to
    any class you create that can compare its instances.
  
    You should implement the `compare()` method.
  
    @class Comparable
    @namespace Ember
    @since Ember 0.9
    @private
  */
  var _default = _metal.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return the result of the comparison of the two parameters. The
      compare method should return:
       - `-1` if `a < b`
      - `0` if `a == b`
      - `1` if `a > b`
       Default implementation raises an exception.
       @method compare
      @param a {Object} the first object to compare
      @param b {Object} the second object to compare
      @return {Number} the result of the comparison
      @private
    */
    compare: null
  });
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/container_proxy", ["exports", "@ember/runloop", "@ember/-internals/metal"], function (_exports, _runloop, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */

  /**
    ContainerProxyMixin is used to provide public access to specific
    container functionality.
  
    @class ContainerProxyMixin
    @private
  */

  var containerProxyMixin = {
    /**
     The container stores state.
      @private
     @property {Ember.Container} __container__
     */
    __container__: null,
    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      Example:
      ```
     import { getOwner } from '@ember/application';
      let owner = getOwner(this);
      User.create(
       owner.ownerInjection(),
       { username: 'rwjblue' }
     )
     ```
      @public
     @method ownerInjection
     @since 2.3.0
     @return {Object}
    */
    ownerInjection: function ownerInjection() {
      return this.__container__.ownerInjection();
    },
    /**
     Given a fullName return a corresponding instance.
      The default behavior is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @public
     @method lookup
     @param {String} fullName
     @param {Object} options
     @return {any}
     */
    lookup: function lookup(fullName, options) {
      return this.__container__.lookup(fullName, options);
    },
    destroy: function destroy() {
      var container = this.__container__;
      if (container) {
        (0, _runloop.join)(function () {
          container.destroy();
          (0, _runloop.schedule)('destroy', container, 'finalizeDestroy');
        });
      }
      this._super();
    },
    /**
    Given a fullName return a factory manager.
     This method returns a manager which can be used for introspection of the
    factory's class or for the creation of factory instances with initial
    properties. The manager is an object with the following properties:
     * `class` - The registered or resolved class.
    * `create` - A function that will create an instance of the class with
      any dependencies injected.
     For example:
     ```javascript
    import { getOwner } from '@ember/application';
     let owner = getOwner(otherInstance);
    // the owner is commonly the `applicationInstance`, and can be accessed via
    // an instance initializer.
     let factory = owner.factoryFor('service:bespoke');
     factory.class;
    // The registered or resolved class. For example when used with an Ember-CLI
    // app, this would be the default export from `app/services/bespoke.js`.
     let instance = factory.create({
      someProperty: 'an initial property value'
    });
    // Create an instance with any injections and the passed options as
    // initial properties.
    ```
     Any instances created via the factory's `.create()` method *must* be destroyed
    manually by the caller of `.create()`. Typically, this is done during the creating
    objects own `destroy` or `willDestroy` methods.
     @public
    @method factoryFor
    @param {String} fullName
    @param {Object} options
    @return {FactoryManager}
    */
    factoryFor: function factoryFor(fullName, options) {
      if (options === void 0) {
        options = {};
      }
      return this.__container__.factoryFor(fullName, options);
    }
  };
  var _default = _metal.Mixin.create(containerProxyMixin);
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/copyable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  /**
    Implements some standard methods for copying an object. Add this mixin to
    any object you create that can create a copy of itself. This mixin is
    added automatically to the built-in array.
  
    You should generally implement the `copy()` method to return a copy of the
    receiver.
  
    @class Copyable
    @namespace Ember
    @since Ember 0.9
    @deprecated Use 'ember-copy' addon instead
    @private
  */
  var _default = _metal.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return a copy of the receiver. Default implementation raises
      an exception.
       @method copy
      @param {Boolean} deep if `true`, a deep copy of the object should be made
      @return {Object} copy of receiver
      @private
    */
    copy: null
  });
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/enumerable", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/enumerable
  @private
  */
  /**
    The methods in this mixin have been moved to [MutableArray](/ember/release/classes/MutableArray). This mixin has
    been intentionally preserved to avoid breaking Enumerable.detect checks
    until the community migrates away from them.
  
    @class Enumerable
    @private
  */
  var _default = _metal.Mixin.create();
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/evented", ["exports", "@ember/-internals/metal"], function (_exports, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/object
  */
  /**
    This mixin allows for Ember objects to subscribe to and emit events.
  
    ```app/utils/person.js
    import EmberObject from '@ember/object';
    import Evented from '@ember/object/evented';
  
    export default EmberObject.extend(Evented, {
      greet() {
        // ...
        this.trigger('greet');
      }
    });
    ```
  
    ```javascript
    var person = Person.create();
  
    person.on('greet', function() {
      console.log('Our person has greeted');
    });
  
    person.greet();
  
    // outputs: 'Our person has greeted'
    ```
  
    You can also chain multiple event subscriptions:
  
    ```javascript
    person.on('greet', function() {
      console.log('Our person has greeted');
    }).one('greet', function() {
      console.log('Offer one-time special');
    }).off('event', this, forgetThis);
    ```
  
    @class Evented
    @public
   */
  var _default = _metal.Mixin.create({
    /**
      Subscribes to a named event with given function.
       ```javascript
      person.on('didLoad', function() {
        // fired once the person has loaded
      });
      ```
       An optional target can be passed in as the 2nd argument that will
      be set as the "this" for the callback. This is a good way to give your
      function access to the object triggering the event. When the target
      parameter is used the callback method becomes the third argument.
       @method on
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function|String} method A function or the name of a function to be called on `target`
      @return this
      @public
    */
    on: function on(name, target, method) {
      (0, _metal.addListener)(this, name, target, method);
      return this;
    },
    /**
      Subscribes a function to a named event and then cancels the subscription
      after the first time the event is triggered. It is good to use ``one`` when
      you only care about the first time an event has taken place.
       This function takes an optional 2nd argument that will become the "this"
      value for the callback. When the target parameter is used the callback method
      becomes the third argument.
       @method one
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function|String} method A function or the name of a function to be called on `target`
      @return this
      @public
    */
    one: function one(name, target, method) {
      (0, _metal.addListener)(this, name, target, method, true);
      return this;
    },
    /**
      Triggers a named event for the object. Any additional arguments
      will be passed as parameters to the functions that are subscribed to the
      event.
       ```javascript
      person.on('didEat', function(food) {
        console.log('person ate some ' + food);
      });
       person.trigger('didEat', 'broccoli');
       // outputs: person ate some broccoli
      ```
      @method trigger
      @param {String} name The name of the event
      @param {Object...} args Optional arguments to pass on
      @public
    */
    trigger: function trigger(name) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      (0, _metal.sendEvent)(this, name, args);
    },
    /**
      Cancels subscription for given name, target, and method.
       @method off
      @param {String} name The name of the event
      @param {Object} target The target of the subscription
      @param {Function|String} method The function or the name of a function of the subscription
      @return this
      @public
    */
    off: function off(name, target, method) {
      (0, _metal.removeListener)(this, name, target, method);
      return this;
    },
    /**
      Checks to see if object has any subscriptions for named event.
       @method has
      @param {String} name The name of the event
      @return {Boolean} does the object have a subscription for event
      @public
     */
    has: function has(name) {
      return (0, _metal.hasListeners)(this, name);
    }
  });
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/mutable_enumerable", ["exports", "@ember/-internals/runtime/lib/mixins/enumerable", "@ember/-internals/metal"], function (_exports, _enumerable, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  /**
    The methods in this mixin have been moved to MutableArray. This mixin has
    been intentionally preserved to avoid breaking MutableEnumerable.detect
    checks until the community migrates away from them.
  
    @class MutableEnumerable
    @namespace Ember
    @uses Enumerable
    @private
  */
  var _default = _metal.Mixin.create(_enumerable.default);
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/observable", ["exports", "@ember/-internals/meta", "@ember/-internals/metal", "@ember/debug"], function (_exports, _meta, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/object
  */
  /**
    ## Overview
  
    This mixin provides properties and property observing functionality, core
    features of the Ember object model.
  
    Properties and observers allow one object to observe changes to a
    property on another object. This is one of the fundamental ways that
    models, controllers and views communicate with each other in an Ember
    application.
  
    Any object that has this mixin applied can be used in observer
    operations. That includes `EmberObject` and most objects you will
    interact with as you write your Ember application.
  
    Note that you will not generally apply this mixin to classes yourself,
    but you will use the features provided by this module frequently, so it
    is important to understand how to use it.
  
    ## Using `get()` and `set()`
  
    Because of Ember's support for bindings and observers, you will always
    access properties using the get method, and set properties using the
    set method. This allows the observing objects to be notified and
    computed properties to be handled properly.
  
    More documentation about `get` and `set` are below.
  
    ## Observing Property Changes
  
    You typically observe property changes simply by using the `observer`
    function in classes that you write.
  
    For example:
  
    ```javascript
    import { observer } from '@ember/object';
    import EmberObject from '@ember/object';
  
    EmberObject.extend({
      valueObserver: observer('value', function(sender, key, value, rev) {
        // Executes whenever the "value" property changes
        // See the addObserver method for more information about the callback arguments
      })
    });
    ```
  
    Although this is the most common way to add an observer, this capability
    is actually built into the `EmberObject` class on top of two methods
    defined in this mixin: `addObserver` and `removeObserver`. You can use
    these two methods to add and remove observers yourself if you need to
    do so at runtime.
  
    To add an observer for a property, call:
  
    ```javascript
    object.addObserver('propertyKey', targetObject, targetAction)
    ```
  
    This will call the `targetAction` method on the `targetObject` whenever
    the value of the `propertyKey` changes.
  
    Note that if `propertyKey` is a computed property, the observer will be
    called when any of the property dependencies are changed, even if the
    resulting value of the computed property is unchanged. This is necessary
    because computed properties are not computed until `get` is called.
  
    @class Observable
    @public
  */
  var _default = _metal.Mixin.create({
    /**
      Retrieves the value of a property from the object.
       This method is usually similar to using `object[keyName]` or `object.keyName`,
      however it supports both computed properties and the unknownProperty
      handler.
       Because `get` unifies the syntax for accessing all these kinds
      of properties, it can make many refactorings easier, such as replacing a
      simple property with a computed property, or vice versa.
       ### Computed Properties
       Computed properties are methods defined with the `property` modifier
      declared at the end, such as:
       ```javascript
      import { computed } from '@ember/object';
       fullName: computed('firstName', 'lastName', function() {
        return this.get('firstName') + ' ' + this.get('lastName');
      })
      ```
       When you call `get` on a computed property, the function will be
      called and the return value will be returned instead of the function
      itself.
       ### Unknown Properties
       Likewise, if you try to call `get` on a property whose value is
      `undefined`, the `unknownProperty()` method will be called on the object.
      If this method returns any value other than `undefined`, it will be returned
      instead. This allows you to implement "virtual" properties that are
      not defined upfront.
       @method get
      @param {String} keyName The property to retrieve
      @return {Object} The property value or undefined.
      @public
    */
    get: function get(keyName) {
      return (0, _metal.get)(this, keyName);
    },
    /**
      To get the values of multiple properties at once, call `getProperties`
      with a list of strings or an array:
       ```javascript
      record.getProperties('firstName', 'lastName', 'zipCode');
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       is equivalent to:
       ```javascript
      record.getProperties(['firstName', 'lastName', 'zipCode']);
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       @method getProperties
      @param {String...|Array} list of keys to get
      @return {Object}
      @public
    */
    getProperties: function getProperties() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return _metal.getProperties.apply(void 0, [this].concat(args));
    },
    /**
      Sets the provided key or path to the value.
       ```javascript
      record.set("key", value);
      ```
       This method is generally very similar to calling `object["key"] = value` or
      `object.key = value`, except that it provides support for computed
      properties, the `setUnknownProperty()` method and property observers.
       ### Computed Properties
       If you try to set a value on a key that has a computed property handler
      defined (see the `get()` method for an example), then `set()` will call
      that method, passing both the value and key instead of simply changing
      the value itself. This is useful for those times when you need to
      implement a property that is composed of one or more member
      properties.
       ### Unknown Properties
       If you try to set a value on a key that is undefined in the target
      object, then the `setUnknownProperty()` handler will be called instead. This
      gives you an opportunity to implement complex "virtual" properties that
      are not predefined on the object. If `setUnknownProperty()` returns
      undefined, then `set()` will simply set the value on the object.
       ### Property Observers
       In addition to changing the property, `set()` will also register a property
      change with the object. Unless you have placed this call inside of a
      `beginPropertyChanges()` and `endPropertyChanges(),` any "local" observers
      (i.e. observer methods declared on the same object), will be called
      immediately. Any "remote" observers (i.e. observer methods declared on
      another object) will be placed in a queue and called at a later time in a
      coalesced manner.
       @method set
      @param {String} keyName The property to set
      @param {Object} value The value to set or `null`.
      @return {Object} The passed value
      @public
    */
    set: function set(keyName, value) {
      return (0, _metal.set)(this, keyName, value);
    },
    /**
      Sets a list of properties at once. These properties are set inside
      a single `beginPropertyChanges` and `endPropertyChanges` batch, so
      observers will be buffered.
       ```javascript
      record.setProperties({ firstName: 'Charles', lastName: 'Jolley' });
      ```
       @method setProperties
      @param {Object} hash the hash of keys and values to set
      @return {Object} The passed in hash
      @public
    */
    setProperties: function setProperties(hash) {
      return (0, _metal.setProperties)(this, hash);
    },
    /**
      Begins a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call this
      method at the beginning of the changes to begin deferring change
      notifications. When you are done making changes, call
      `endPropertyChanges()` to deliver the deferred change notifications and end
      deferring.
       @method beginPropertyChanges
      @return {Observable}
      @private
    */
    beginPropertyChanges: function beginPropertyChanges() {
      (0, _metal.beginPropertyChanges)();
      return this;
    },
    /**
      Ends a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call
      `beginPropertyChanges()` at the beginning of the changes to defer change
      notifications. When you are done making changes, call this method to
      deliver the deferred change notifications and end deferring.
       @method endPropertyChanges
      @return {Observable}
      @private
    */
    endPropertyChanges: function endPropertyChanges() {
      (0, _metal.endPropertyChanges)();
      return this;
    },
    /**
      Notify the observer system that a property has just changed.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method instead. Calling this method will notify all observers that the
      property has potentially changed value.
       @method notifyPropertyChange
      @param {String} keyName The property key to be notified about.
      @return {Observable}
      @public
    */
    notifyPropertyChange: function notifyPropertyChange(keyName) {
      (0, _metal.notifyPropertyChange)(this, keyName);
      return this;
    },
    /**
      Adds an observer on a property.
       This is the core method used to register an observer for a property.
       Once you call this method, any time the key's value is set, your observer
      will be notified. Note that the observers are triggered any time the
      value is set, regardless of whether it has actually changed. Your
      observer should be prepared to handle that.
       There are two common invocation patterns for `.addObserver()`:
       - Passing two arguments:
        - the name of the property to observe (as a string)
        - the function to invoke (an actual function)
      - Passing three arguments:
        - the name of the property to observe (as a string)
        - the target object (will be used to look up and invoke a
          function on)
        - the name of the function to invoke on the target object
          (as a string).
       ```app/components/my-component.js
      import Component from '@ember/component';
       export default Component.extend({
        init() {
          this._super(...arguments);
           // the following are equivalent:
           // using three arguments
          this.addObserver('foo', this, 'fooDidChange');
           // using two arguments
          this.addObserver('foo', (...args) => {
            this.fooDidChange(...args);
          });
        },
         fooDidChange() {
          // your custom logic code
        }
      });
      ```
       ### Observer Methods
       Observer methods have the following signature:
       ```app/components/my-component.js
      import Component from '@ember/component';
       export default Component.extend({
        init() {
          this._super(...arguments);
          this.addObserver('foo', this, 'fooDidChange');
        },
         fooDidChange(sender, key, value, rev) {
          // your code
        }
      });
      ```
       The `sender` is the object that changed. The `key` is the property that
      changes. The `value` property is currently reserved and unused. The `rev`
      is the last property revision of the object when it changed, which you can
      use to detect if the key value has really changed or not.
       Usually you will not need the value or revision parameters at
      the end. In this case, it is common to write observer methods that take
      only a sender and key value as parameters or, if you aren't interested in
      any of these values, to write an observer that has no parameters at all.
       @method addObserver
      @param {String} key The key to observe
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke
      @param {Boolean} sync Whether the observer is sync or not
      @return {Observable}
      @public
    */
    addObserver: function addObserver(key, target, method, sync) {
      (0, _metal.addObserver)(this, key, target, method, sync);
      return this;
    },
    /**
      Remove an observer you have previously registered on this object. Pass
      the same key, target, and method you passed to `addObserver()` and your
      target will no longer receive notifications.
       @method removeObserver
      @param {String} key The key to observe
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke
      @param {Boolean} sync Whether the observer is async or not
      @return {Observable}
      @public
    */
    removeObserver: function removeObserver(key, target, method, sync) {
      (0, _metal.removeObserver)(this, key, target, method, sync);
      return this;
    },
    /**
      Returns `true` if the object currently has observers registered for a
      particular key. You can use this method to potentially defer performing
      an expensive action until someone begins observing a particular property
      on the object.
       @method hasObserverFor
      @param {String} key Key to check
      @return {Boolean}
      @private
    */
    hasObserverFor: function hasObserverFor(key) {
      return (0, _metal.hasListeners)(this, key + ":change");
    },
    /**
      Retrieves the value of a property, or a default value in the case that the
      property returns `undefined`.
       ```javascript
      person.getWithDefault('lastName', 'Doe');
      ```
       @method getWithDefault
      @param {String} keyName The name of the property to retrieve
      @param {Object} defaultValue The value to return if the property value is undefined
      @return {Object} The property value or the defaultValue.
      @public
      @deprecated
    */
    getWithDefault: function getWithDefault(keyName, defaultValue) {
      return (0, _metal.getWithDefault)(this, keyName, defaultValue);
    },
    /**
      Set the value of a property to the current value plus some amount.
       ```javascript
      person.incrementProperty('age');
      team.incrementProperty('score', 2);
      ```
       @method incrementProperty
      @param {String} keyName The name of the property to increment
      @param {Number} increment The amount to increment by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    incrementProperty: function incrementProperty(keyName, increment) {
      if (increment === void 0) {
        increment = 1;
      }
      (true && !(!isNaN(parseFloat(increment)) && isFinite(increment)) && (0, _debug.assert)('Must pass a numeric value to incrementProperty', !isNaN(parseFloat(increment)) && isFinite(increment)));
      return (0, _metal.set)(this, keyName, (parseFloat((0, _metal.get)(this, keyName)) || 0) + increment);
    },
    /**
      Set the value of a property to the current value minus some amount.
       ```javascript
      player.decrementProperty('lives');
      orc.decrementProperty('health', 5);
      ```
       @method decrementProperty
      @param {String} keyName The name of the property to decrement
      @param {Number} decrement The amount to decrement by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    decrementProperty: function decrementProperty(keyName, decrement) {
      if (decrement === void 0) {
        decrement = 1;
      }
      (true && !(!isNaN(parseFloat(decrement)) && isFinite(decrement)) && (0, _debug.assert)('Must pass a numeric value to decrementProperty', !isNaN(parseFloat(decrement)) && isFinite(decrement)));
      return (0, _metal.set)(this, keyName, ((0, _metal.get)(this, keyName) || 0) - decrement);
    },
    /**
      Set the value of a boolean property to the opposite of its
      current value.
       ```javascript
      starship.toggleProperty('warpDriveEngaged');
      ```
       @method toggleProperty
      @param {String} keyName The name of the property to toggle
      @return {Boolean} The new property value
      @public
    */
    toggleProperty: function toggleProperty(keyName) {
      return (0, _metal.set)(this, keyName, !(0, _metal.get)(this, keyName));
    },
    /**
      Returns the cached value of a computed property, if it exists.
      This allows you to inspect the value of a computed property
      without accidentally invoking it if it is intended to be
      generated lazily.
       @method cacheFor
      @param {String} keyName
      @return {Object} The cached value of the computed property, if any
      @public
    */
    cacheFor: function cacheFor(keyName) {
      var meta = (0, _meta.peekMeta)(this);
      if (meta !== null) {
        return meta.valueFor(keyName);
      }
    }
  });
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/mixins/promise_proxy", ["exports", "@ember/-internals/metal", "@ember/error"], function (_exports, _metal, _error) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
    @module @ember/object
  */

  function tap(proxy, promise) {
    (0, _metal.setProperties)(proxy, {
      isFulfilled: false,
      isRejected: false
    });
    return promise.then(function (value) {
      if (!proxy.isDestroyed && !proxy.isDestroying) {
        (0, _metal.setProperties)(proxy, {
          content: value,
          isFulfilled: true
        });
      }
      return value;
    }, function (reason) {
      if (!proxy.isDestroyed && !proxy.isDestroying) {
        (0, _metal.setProperties)(proxy, {
          reason: reason,
          isRejected: true
        });
      }
      throw reason;
    }, 'Ember: PromiseProxy');
  }
  /**
    A low level mixin making ObjectProxy promise-aware.
  
    ```javascript
    import { resolve } from 'rsvp';
    import $ from 'jquery';
    import ObjectProxy from '@ember/object/proxy';
    import PromiseProxyMixin from '@ember/object/promise-proxy-mixin';
  
    let ObjectPromiseProxy = ObjectProxy.extend(PromiseProxyMixin);
  
    let proxy = ObjectPromiseProxy.create({
      promise: resolve($.getJSON('/some/remote/data.json'))
    });
  
    proxy.then(function(json){
       // the json
    }, function(reason) {
       // the reason why you have no json
    });
    ```
  
    the proxy has bindable attributes which
    track the promises life cycle
  
    ```javascript
    proxy.get('isPending')   //=> true
    proxy.get('isSettled')  //=> false
    proxy.get('isRejected')  //=> false
    proxy.get('isFulfilled') //=> false
    ```
  
    When the $.getJSON completes, and the promise is fulfilled
    with json, the life cycle attributes will update accordingly.
    Note that $.getJSON doesn't return an ECMA specified promise,
    it is useful to wrap this with an `RSVP.resolve` so that it behaves
    as a spec compliant promise.
  
    ```javascript
    proxy.get('isPending')   //=> false
    proxy.get('isSettled')   //=> true
    proxy.get('isRejected')  //=> false
    proxy.get('isFulfilled') //=> true
    ```
  
    As the proxy is an ObjectProxy, and the json now its content,
    all the json properties will be available directly from the proxy.
  
    ```javascript
    // Assuming the following json:
    {
      firstName: 'Stefan',
      lastName: 'Penner'
    }
  
    // both properties will accessible on the proxy
    proxy.get('firstName') //=> 'Stefan'
    proxy.get('lastName')  //=> 'Penner'
    ```
  
    @class PromiseProxyMixin
    @public
  */
  var _default = _metal.Mixin.create({
    /**
      If the proxied promise is rejected this will contain the reason
      provided.
       @property reason
      @default null
      @public
    */
    reason: null,
    /**
      Once the proxied promise has settled this will become `false`.
       @property isPending
      @default true
      @public
    */
    isPending: (0, _metal.computed)('isSettled', function () {
      return !(0, _metal.get)(this, 'isSettled');
    }).readOnly(),
    /**
      Once the proxied promise has settled this will become `true`.
       @property isSettled
      @default false
      @public
    */
    isSettled: (0, _metal.computed)('isRejected', 'isFulfilled', function () {
      return (0, _metal.get)(this, 'isRejected') || (0, _metal.get)(this, 'isFulfilled');
    }).readOnly(),
    /**
      Will become `true` if the proxied promise is rejected.
       @property isRejected
      @default false
      @public
    */
    isRejected: false,
    /**
      Will become `true` if the proxied promise is fulfilled.
       @property isFulfilled
      @default false
      @public
    */
    isFulfilled: false,
    /**
      The promise whose fulfillment value is being proxied by this object.
       This property must be specified upon creation, and should not be
      changed once created.
       Example:
       ```javascript
      import ObjectProxy from '@ember/object/proxy';
      import PromiseProxyMixin from '@ember/object/promise-proxy-mixin';
       ObjectProxy.extend(PromiseProxyMixin).create({
        promise: <thenable>
      });
      ```
       @property promise
      @public
    */
    promise: (0, _metal.computed)({
      get: function get() {
        throw new _error.default("PromiseProxy's promise must be set");
      },
      set: function set(key, promise) {
        return tap(this, promise);
      }
    }),
    /**
      An alias to the proxied promise's `then`.
       See RSVP.Promise.then.
       @method then
      @param {Function} callback
      @return {RSVP.Promise}
      @public
    */
    then: promiseAlias('then'),
    /**
      An alias to the proxied promise's `catch`.
       See RSVP.Promise.catch.
       @method catch
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
      @public
    */
    catch: promiseAlias('catch'),
    /**
      An alias to the proxied promise's `finally`.
       See RSVP.Promise.finally.
       @method finally
      @param {Function} callback
      @return {RSVP.Promise}
      @since 1.3.0
      @public
    */
    finally: promiseAlias('finally')
  });
  _exports.default = _default;
  function promiseAlias(name) {
    return function () {
      var promise = (0, _metal.get)(this, 'promise');
      return promise[name].apply(promise, arguments);
    };
  }
});
define("@ember/-internals/runtime/lib/mixins/registry_proxy", ["exports", "@ember/debug", "@ember/-internals/metal"], function (_exports, _debug, _metal) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  /**
    RegistryProxyMixin is used to provide public access to specific
    registry functionality.
  
    @class RegistryProxyMixin
    @private
  */
  var _default = _metal.Mixin.create({
    __registry__: null,
    /**
     Given a fullName return the corresponding factory.
      @public
     @method resolveRegistration
     @param {String} fullName
     @return {Function} fullName's factory
     */
    resolveRegistration: function resolveRegistration(fullName, options) {
      (true && !(this.__registry__.isValidFullName(fullName)) && (0, _debug.assert)('fullName must be a proper full name', this.__registry__.isValidFullName(fullName)));
      return this.__registry__.resolve(fullName, options);
    },
    /**
      Registers a factory that can be used for dependency injection (with
      `inject`) or for service lookup. Each factory is registered with
      a full name including two parts: `type:name`.
       A simple example:
       ```javascript
      import Application from '@ember/application';
      import EmberObject from '@ember/object';
       let App = Application.create();
       App.Orange = EmberObject.extend();
      App.register('fruit:favorite', App.Orange);
      ```
       Ember will resolve factories from the `App` namespace automatically.
      For example `App.CarsController` will be discovered and returned if
      an application requests `controller:cars`.
       An example of registering a controller with a non-standard name:
       ```javascript
      import Application from '@ember/application';
      import Controller from '@ember/controller';
       let App = Application.create();
      let Session = Controller.extend();
       App.register('controller:session', Session);
       // The Session controller can now be treated like a normal controller,
      // despite its non-standard name.
      App.ApplicationController = Controller.extend({
        needs: ['session']
      });
      ```
       Registered factories are **instantiated** by having `create`
      called on them. Additionally they are **singletons**, each time
      they are looked up they return the same instance.
       Some examples modifying that default behavior:
       ```javascript
      import Application from '@ember/application';
      import EmberObject from '@ember/object';
       let App = Application.create();
       App.Person = EmberObject.extend();
      App.Orange = EmberObject.extend();
      App.Email = EmberObject.extend();
      App.session = EmberObject.create();
       App.register('model:user', App.Person, { singleton: false });
      App.register('fruit:favorite', App.Orange);
      App.register('communication:main', App.Email, { singleton: false });
      App.register('session', App.session, { instantiate: false });
      ```
       @method register
      @param  fullName {String} type:name (e.g., 'model:user')
      @param  factory {any} (e.g., App.Person)
      @param  options {Object} (optional) disable instantiation or singleton usage
      @public
     */
    register: registryAlias('register'),
    /**
     Unregister a factory.
      ```javascript
     import Application from '@ember/application';
     import EmberObject from '@ember/object';
      let App = Application.create();
     let User = EmberObject.extend();
     App.register('model:user', User);
      App.resolveRegistration('model:user').create() instanceof User //=> true
      App.unregister('model:user')
     App.resolveRegistration('model:user') === undefined //=> true
     ```
      @public
     @method unregister
     @param {String} fullName
     */
    unregister: registryAlias('unregister'),
    /**
     Check if a factory is registered.
      @public
     @method hasRegistration
     @param {String} fullName
     @return {Boolean}
     */
    hasRegistration: registryAlias('has'),
    /**
     Return a specific registered option for a particular factory.
      @public
     @method registeredOption
     @param  {String} fullName
     @param  {String} optionName
     @return {Object} options
     */
    registeredOption: registryAlias('getOption'),
    /**
     Register options for a particular factory.
      @public
     @method registerOptions
     @param {String} fullName
     @param {Object} options
     */
    registerOptions: registryAlias('options'),
    /**
     Return registered options for a particular factory.
      @public
     @method registeredOptions
     @param  {String} fullName
     @return {Object} options
     */
    registeredOptions: registryAlias('getOptions'),
    /**
     Allow registering options for all factories of a type.
      ```javascript
     import Application from '@ember/application';
      let App = Application.create();
     let appInstance = App.buildInstance();
      // if all of type `connection` must not be singletons
     appInstance.registerOptionsForType('connection', { singleton: false });
      appInstance.register('connection:twitter', TwitterConnection);
     appInstance.register('connection:facebook', FacebookConnection);
      let twitter = appInstance.lookup('connection:twitter');
     let twitter2 = appInstance.lookup('connection:twitter');
      twitter === twitter2; // => false
      let facebook = appInstance.lookup('connection:facebook');
     let facebook2 = appInstance.lookup('connection:facebook');
      facebook === facebook2; // => false
     ```
      @public
     @method registerOptionsForType
     @param {String} type
     @param {Object} options
     */
    registerOptionsForType: registryAlias('optionsForType'),
    /**
     Return the registered options for all factories of a type.
      @public
     @method registeredOptionsForType
     @param {String} type
     @return {Object} options
     */
    registeredOptionsForType: registryAlias('getOptionsForType'),
    /**
      Define a dependency injection onto a specific factory or all factories
      of a type.
       When Ember instantiates a controller, view, or other framework component
      it can attach a dependency to that component. This is often used to
      provide services to a set of framework components.
       An example of providing a session object to all controllers:
       ```javascript
      import { alias } from '@ember/object/computed';
      import Application from '@ember/application';
      import Controller from '@ember/controller';
      import EmberObject from '@ember/object';
       let App = Application.create();
      let Session = EmberObject.extend({ isAuthenticated: false });
       // A factory must be registered before it can be injected
      App.register('session:main', Session);
       // Inject 'session:main' onto all factories of the type 'controller'
      // with the name 'session'
      App.inject('controller', 'session', 'session:main');
       App.IndexController = Controller.extend({
        isLoggedIn: alias('session.isAuthenticated')
      });
      ```
       Injections can also be performed on specific factories.
       ```javascript
      App.inject(<full_name or type>, <property name>, <full_name>)
      App.inject('route', 'source', 'source:main')
      App.inject('route:application', 'email', 'model:email')
      ```
       It is important to note that injections can only be performed on
      classes that are instantiated by Ember itself. Instantiating a class
      directly (via `create` or `new`) bypasses the dependency injection
      system.
       @public
      @method inject
      @param  factoryNameOrType {String}
      @param  property {String}
      @param  injectionName {String}
    **/
    inject: registryAlias('injection')
  });
  _exports.default = _default;
  function registryAlias(name) {
    return function () {
      var _this$__registry__;
      return (_this$__registry__ = this.__registry__)[name].apply(_this$__registry__, arguments);
    };
  }
});
define("@ember/-internals/runtime/lib/mixins/target_action_support", ["exports", "@ember/-internals/environment", "@ember/-internals/metal", "@ember/debug"], function (_exports, _environment, _metal, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  /**
  `Ember.TargetActionSupport` is a mixin that can be included in a class
  to add a `triggerAction` method with semantics similar to the Handlebars
  `{{action}}` helper. In normal Ember usage, the `{{action}}` helper is
  usually the best choice. This mixin is most often useful when you are
  doing more complex event handling in Components.
  
  @class TargetActionSupport
  @namespace Ember
  @extends Mixin
  @private
  */
  var _default = _metal.Mixin.create({
    target: null,
    action: null,
    actionContext: null,
    actionContextObject: (0, _metal.computed)('actionContext', function () {
      var actionContext = (0, _metal.get)(this, 'actionContext');
      if (typeof actionContext === 'string') {
        var value = (0, _metal.get)(this, actionContext);
        if (value === undefined) {
          value = (0, _metal.get)(_environment.context.lookup, actionContext);
        }
        return value;
      } else {
        return actionContext;
      }
    }),
    /**
    Send an `action` with an `actionContext` to a `target`. The action, actionContext
    and target will be retrieved from properties of the object. For example:
     ```javascript
    import { alias } from '@ember/object/computed';
     App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: alias('controller'),
      action: 'save',
      actionContext: alias('context'),
      click() {
        this.triggerAction(); // Sends the `save` action, along with the current context
                              // to the current controller
      }
    });
    ```
     The `target`, `action`, and `actionContext` can be provided as properties of
    an optional object argument to `triggerAction` as well.
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      click() {
        this.triggerAction({
          action: 'save',
          target: this.get('controller'),
          actionContext: this.get('context')
        }); // Sends the `save` action, along with the current context
            // to the current controller
      }
    });
    ```
     The `actionContext` defaults to the object you are mixing `TargetActionSupport` into.
    But `target` and `action` must be specified either as properties or with the argument
    to `triggerAction`, or a combination:
     ```javascript
    import { alias } from '@ember/object/computed';
     App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: alias('controller'),
      click() {
        this.triggerAction({
          action: 'save'
        }); // Sends the `save` action, along with a reference to `this`,
            // to the current controller
      }
    });
    ```
     @method triggerAction
    @param opts {Object} (optional, with the optional keys action, target and/or actionContext)
    @return {Boolean} true if the action was sent successfully and did not return false
    @private
    */
    triggerAction: function triggerAction(opts) {
      if (opts === void 0) {
        opts = {};
      }
      var _opts = opts,
        action = _opts.action,
        target = _opts.target,
        actionContext = _opts.actionContext;
      action = action || (0, _metal.get)(this, 'action');
      target = target || getTarget(this);
      if (actionContext === undefined) {
        actionContext = (0, _metal.get)(this, 'actionContextObject') || this;
      }
      if (target && action) {
        var ret;
        if (target.send) {
          var _target;
          ret = (_target = target).send.apply(_target, [action].concat(actionContext));
        } else {
          var _target2;
          (true && !(typeof target[action] === 'function') && (0, _debug.assert)("The action '" + action + "' did not exist on " + target, typeof target[action] === 'function'));
          ret = (_target2 = target)[action].apply(_target2, [].concat(actionContext));
        }
        if (ret !== false) {
          return true;
        }
      }
      return false;
    }
  });
  _exports.default = _default;
  function getTarget(instance) {
    var target = (0, _metal.get)(instance, 'target');
    if (target) {
      if (typeof target === 'string') {
        var value = (0, _metal.get)(instance, target);
        if (value === undefined) {
          value = (0, _metal.get)(_environment.context.lookup, target);
        }
        return value;
      } else {
        return target;
      }
    }
    if (instance._target) {
      return instance._target;
    }
    return null;
  }
});
define("@ember/-internals/runtime/lib/system/array_proxy", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/array", "@ember/debug", "@glimmer/validator"], function (_exports, _emberBabel, _metal, _utils, _object, _array, _debug, _validator) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module @ember/array
  */

  var ARRAY_OBSERVER_MAPPING = {
    willChange: '_arrangedContentArrayWillChange',
    didChange: '_arrangedContentArrayDidChange'
  };
  /**
    An ArrayProxy wraps any other object that implements `Array` and/or
    `MutableArray,` forwarding all requests. This makes it very useful for
    a number of binding use cases or other cases where being able to swap
    out the underlying array is useful.
  
    A simple example of usage:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    let pets = ['dog', 'cat', 'fish'];
    let ap = ArrayProxy.create({ content: A(pets) });
  
    ap.get('firstObject');                        // 'dog'
    ap.set('content', ['amoeba', 'paramecium']);
    ap.get('firstObject');                        // 'amoeba'
    ```
  
    This class can also be useful as a layer to transform the contents of
    an array, as they are accessed. This can be done by overriding
    `objectAtContent`:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    let pets = ['dog', 'cat', 'fish'];
    let ap = ArrayProxy.create({
        content: A(pets),
        objectAtContent: function(idx) {
            return this.get('content').objectAt(idx).toUpperCase();
        }
    });
  
    ap.get('firstObject'); // . 'DOG'
    ```
  
    When overriding this class, it is important to place the call to
    `_super` *after* setting `content` so the internal observers have
    a chance to fire properly:
  
    ```javascript
    import { A } from '@ember/array';
    import ArrayProxy from '@ember/array/proxy';
  
    export default ArrayProxy.extend({
      init() {
        this.set('content', A(['dog', 'cat', 'fish']));
        this._super(...arguments);
      }
    });
    ```
  
    @class ArrayProxy
    @extends EmberObject
    @uses MutableArray
    @public
  */
  var ArrayProxy = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(ArrayProxy, _EmberObject);
    function ArrayProxy() {
      return _EmberObject.apply(this, arguments) || this;
    }
    var _proto = ArrayProxy.prototype;
    _proto.init = function init() {
      _EmberObject.prototype.init.apply(this, arguments);
      /*
        `this._objectsDirtyIndex` determines which indexes in the `this._objects`
        cache are dirty.
         If `this._objectsDirtyIndex === -1` then no indexes are dirty.
        Otherwise, an index `i` is dirty if `i >= this._objectsDirtyIndex`.
         Calling `objectAt` with a dirty index will cause the `this._objects`
        cache to be recomputed.
      */

      this._objectsDirtyIndex = 0;
      this._objects = null;
      this._lengthDirty = true;
      this._length = 0;
      this._arrangedContent = null;
      this._arrangedContentIsUpdating = false;
      this._arrangedContentTag = null;
      this._arrangedContentRevision = null;
      this._lengthTag = null;
      this._arrTag = null;
    };
    _proto[_metal.PROPERTY_DID_CHANGE] = function () {
      this._revalidate();
    };
    _proto[_metal.CUSTOM_TAG_FOR] = function (key) {
      if (key === '[]') {
        this._revalidate();
        return this._arrTag;
      } else if (key === 'length') {
        this._revalidate();
        return this._lengthTag;
      }
      return (0, _validator.tagFor)(this, key);
    };
    _proto.willDestroy = function willDestroy() {
      this._removeArrangedContentArrayObserver();
    }
    /**
      The content array. Must be an object that implements `Array` and/or
      `MutableArray.`
       @property content
      @type EmberArray
      @public
    */

    /**
      Should actually retrieve the object at the specified index from the
      content. You can override this method in subclasses to transform the
      content item to something new.
       This method will only be called if content is non-`null`.
       @method objectAtContent
      @param {Number} idx The index to retrieve.
      @return {Object} the value or undefined if none found
      @public
    */;
    _proto.objectAtContent = function objectAtContent(idx) {
      return (0, _metal.objectAt)((0, _metal.get)(this, 'arrangedContent'), idx);
    } // See additional docs for `replace` from `MutableArray`:
    // https://api.emberjs.com/ember/release/classes/MutableArray/methods/replace?anchor=replace
    ;
    _proto.replace = function replace(idx, amt, objects) {
      (true && !((0, _metal.get)(this, 'arrangedContent') === (0, _metal.get)(this, 'content')) && (0, _debug.assert)('Mutating an arranged ArrayProxy is not allowed', (0, _metal.get)(this, 'arrangedContent') === (0, _metal.get)(this, 'content')));
      this.replaceContent(idx, amt, objects);
    }
    /**
      Should actually replace the specified objects on the content array.
      You can override this method in subclasses to transform the content item
      into something new.
       This method will only be called if content is non-`null`.
       @method replaceContent
      @param {Number} idx The starting index
      @param {Number} amt The number of items to remove from the content.
      @param {EmberArray} objects Optional array of objects to insert or null if no
        objects.
      @return {void}
      @public
    */;
    _proto.replaceContent = function replaceContent(idx, amt, objects) {
      (0, _metal.get)(this, 'content').replace(idx, amt, objects);
    } // Overriding objectAt is not supported.
    ;
    _proto.objectAt = function objectAt(idx) {
      this._revalidate();
      if (this._objects === null) {
        this._objects = [];
      }
      if (this._objectsDirtyIndex !== -1 && idx >= this._objectsDirtyIndex) {
        var arrangedContent = (0, _metal.get)(this, 'arrangedContent');
        if (arrangedContent) {
          var length = this._objects.length = (0, _metal.get)(arrangedContent, 'length');
          for (var i = this._objectsDirtyIndex; i < length; i++) {
            this._objects[i] = this.objectAtContent(i);
          }
        } else {
          this._objects.length = 0;
        }
        this._objectsDirtyIndex = -1;
      }
      return this._objects[idx];
    } // Overriding length is not supported.
    ;
    _proto._updateArrangedContentArray = function _updateArrangedContentArray(arrangedContent) {
      var oldLength = this._objects === null ? 0 : this._objects.length;
      var newLength = arrangedContent ? (0, _metal.get)(arrangedContent, 'length') : 0;
      this._removeArrangedContentArrayObserver();
      this.arrayContentWillChange(0, oldLength, newLength);
      this._invalidate();
      this.arrayContentDidChange(0, oldLength, newLength);
      this._addArrangedContentArrayObserver(arrangedContent);
    };
    _proto._addArrangedContentArrayObserver = function _addArrangedContentArrayObserver(arrangedContent) {
      if (arrangedContent && !arrangedContent.isDestroyed) {
        (true && !(arrangedContent !== this) && (0, _debug.assert)("Can't set ArrayProxy's content to itself", arrangedContent !== this));
        (true && !((0, _array.isArray)(arrangedContent) || arrangedContent.isDestroyed) && (0, _debug.assert)("ArrayProxy expects an Array or ArrayProxy, but you passed " + typeof arrangedContent, (0, _array.isArray)(arrangedContent) || arrangedContent.isDestroyed));
        (0, _metal.addArrayObserver)(arrangedContent, this, ARRAY_OBSERVER_MAPPING);
        this._arrangedContent = arrangedContent;
      }
    };
    _proto._removeArrangedContentArrayObserver = function _removeArrangedContentArrayObserver() {
      if (this._arrangedContent) {
        (0, _metal.removeArrayObserver)(this._arrangedContent, this, ARRAY_OBSERVER_MAPPING);
      }
    };
    _proto._arrangedContentArrayWillChange = function _arrangedContentArrayWillChange() {};
    _proto._arrangedContentArrayDidChange = function _arrangedContentArrayDidChange(proxy, idx, removedCnt, addedCnt) {
      this.arrayContentWillChange(idx, removedCnt, addedCnt);
      var dirtyIndex = idx;
      if (dirtyIndex < 0) {
        var length = (0, _metal.get)(this._arrangedContent, 'length');
        dirtyIndex += length + removedCnt - addedCnt;
      }
      if (this._objectsDirtyIndex === -1 || this._objectsDirtyIndex > dirtyIndex) {
        this._objectsDirtyIndex = dirtyIndex;
      }
      this._lengthDirty = true;
      this.arrayContentDidChange(idx, removedCnt, addedCnt);
    };
    _proto._invalidate = function _invalidate() {
      this._objectsDirtyIndex = 0;
      this._lengthDirty = true;
    };
    _proto._revalidate = function _revalidate() {
      if (this._arrangedContentIsUpdating === true) return;
      if (this._arrangedContentTag === null || !(0, _validator.validateTag)(this._arrangedContentTag, this._arrangedContentRevision)) {
        var arrangedContent = this.get('arrangedContent');
        if (this._arrangedContentTag === null) {
          // This is the first time the proxy has been setup, only add the observer
          // don't trigger any events
          this._addArrangedContentArrayObserver(arrangedContent);
        } else {
          this._arrangedContentIsUpdating = true;
          this._updateArrangedContentArray(arrangedContent);
          this._arrangedContentIsUpdating = false;
        }
        var arrangedContentTag = this._arrangedContentTag = (0, _validator.tagFor)(this, 'arrangedContent');
        this._arrangedContentRevision = (0, _validator.valueForTag)(this._arrangedContentTag);
        if ((0, _utils.isObject)(arrangedContent)) {
          this._lengthTag = (0, _validator.combine)([arrangedContentTag, (0, _metal.tagForProperty)(arrangedContent, 'length')]);
          this._arrTag = (0, _validator.combine)([arrangedContentTag, (0, _metal.tagForProperty)(arrangedContent, '[]')]);
        } else {
          this._lengthTag = this._arrTag = arrangedContentTag;
        }
      }
    };
    (0, _emberBabel.createClass)(ArrayProxy, [{
      key: "length",
      get: function get() {
        this._revalidate();
        if (this._lengthDirty) {
          var arrangedContent = (0, _metal.get)(this, 'arrangedContent');
          this._length = arrangedContent ? (0, _metal.get)(arrangedContent, 'length') : 0;
          this._lengthDirty = false;
        }
        (0, _validator.consumeTag)(this._lengthTag);
        return this._length;
      },
      set: function set(value) {
        var length = this.length;
        var removedCount = length - value;
        var added;
        if (removedCount === 0) {
          return;
        } else if (removedCount < 0) {
          added = new Array(-removedCount);
          removedCount = 0;
        }
        var content = (0, _metal.get)(this, 'content');
        if (content) {
          (0, _metal.replace)(content, value, removedCount, added);
          this._invalidate();
        }
      }
    }]);
    return ArrayProxy;
  }(_object.default);
  _exports.default = ArrayProxy;
  ArrayProxy.reopen(_array.MutableArray, {
    /**
      The array that the proxy pretends to be. In the default `ArrayProxy`
      implementation, this and `content` are the same. Subclasses of `ArrayProxy`
      can override this property to provide things like sorting and filtering.
       @property arrangedContent
      @public
    */
    arrangedContent: (0, _metal.alias)('content'),
    // Array proxies don't need to notify when they change since their `[]` tag is
    // already dependent on the `[]` tag of `arrangedContent`
    arrayContentDidChange: function arrayContentDidChange(startIdx, removeAmt, addAmt) {
      return (0, _metal.arrayContentDidChange)(this, startIdx, removeAmt, addAmt, false);
    }
  });
});
define("@ember/-internals/runtime/lib/system/core_object", ["exports", "ember-babel", "@ember/-internals/container", "@ember/-internals/owner", "@ember/polyfills", "@ember/-internals/utils", "@ember/-internals/meta", "@ember/-internals/metal", "@ember/-internals/runtime/lib/mixins/action_handler", "@ember/debug", "@glimmer/util", "@glimmer/runtime"], function (_exports, _emberBabel, _container, _owner, _polyfills, _utils, _meta2, _metal, _action_handler, _debug, _util, _runtime) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
    @module @ember/object
  */

  var _reopen = _metal.Mixin.prototype.reopen;
  var wasApplied = new _util._WeakSet();
  var prototypeMixinMap = new WeakMap();
  var initCalled = true /* DEBUG */ ? new _util._WeakSet() : undefined; // only used in debug builds to enable the proxy trap

  var destroyCalled = new Set();
  function ensureDestroyCalled(instance) {
    if (!destroyCalled.has(instance)) {
      instance.destroy();
    }
  }
  function initialize(obj, properties) {
    var m = (0, _meta2.meta)(obj);
    if (properties !== undefined) {
      (true && !(typeof properties === 'object' && properties !== null) && (0, _debug.assert)('EmberObject.create only accepts objects.', typeof properties === 'object' && properties !== null));
      (true && !(!(properties instanceof _metal.Mixin)) && (0, _debug.assert)('EmberObject.create no longer supports mixing in other ' + 'definitions, use .extend & .create separately instead.', !(properties instanceof _metal.Mixin)));
      var concatenatedProperties = obj.concatenatedProperties;
      var mergedProperties = obj.mergedProperties;
      var hasConcatenatedProps = concatenatedProperties !== undefined && concatenatedProperties.length > 0;
      var hasMergedProps = mergedProperties !== undefined && mergedProperties.length > 0;
      var keyNames = Object.keys(properties);
      for (var i = 0; i < keyNames.length; i++) {
        var keyName = keyNames[i];
        var value = properties[keyName];
        (true && !(!(0, _metal.isClassicDecorator)(value)) && (0, _debug.assert)('EmberObject.create no longer supports defining computed ' + 'properties. Define computed properties using extend() or reopen() ' + 'before calling create().', !(0, _metal.isClassicDecorator)(value)));
        (true && !(!(typeof value === 'function' && value.toString().indexOf('._super') !== -1)) && (0, _debug.assert)('EmberObject.create no longer supports defining methods that call _super.', !(typeof value === 'function' && value.toString().indexOf('._super') !== -1)));
        (true && !(!(keyName === 'actions' && _action_handler.default.detect(obj))) && (0, _debug.assert)('`actions` must be provided at extend time, not at create time, ' + 'when Ember.ActionHandler is used (i.e. views, controllers & routes).', !(keyName === 'actions' && _action_handler.default.detect(obj))));
        var possibleDesc = (0, _metal.descriptorForProperty)(obj, keyName, m);
        var isDescriptor = possibleDesc !== undefined;
        if (!isDescriptor) {
          if (hasConcatenatedProps && concatenatedProperties.indexOf(keyName) > -1) {
            var baseValue = obj[keyName];
            if (baseValue) {
              value = (0, _utils.makeArray)(baseValue).concat(value);
            } else {
              value = (0, _utils.makeArray)(value);
            }
          }
          if (hasMergedProps && mergedProperties.indexOf(keyName) > -1) {
            var _baseValue = obj[keyName];
            value = (0, _polyfills.assign)({}, _baseValue, value);
          }
        }
        if (isDescriptor) {
          possibleDesc.set(obj, keyName, value);
        } else if (typeof obj.setUnknownProperty === 'function' && !(keyName in obj)) {
          obj.setUnknownProperty(keyName, value);
        } else {
          if (true /* DEBUG */) {
            (0, _metal.defineProperty)(obj, keyName, null, value, m); // setup mandatory setter
          } else {
            obj[keyName] = value;
          }
        }
      }
    } // using DEBUG here to avoid the extraneous variable when not needed

    if (true /* DEBUG */) {
      initCalled.add(obj);
    }
    obj.init(properties);
    m.unsetInitializing();
    var observerEvents = m.observerEvents();
    if (observerEvents !== undefined) {
      for (var _i = 0; _i < observerEvents.length; _i++) {
        (0, _metal.activateObserver)(obj, observerEvents[_i].event, observerEvents[_i].sync);
      }
    }
    (0, _metal.sendEvent)(obj, 'init', undefined, undefined, undefined, m);
  }
  /**
    `CoreObject` is the base class for all Ember constructs. It establishes a
    class system based on Ember's Mixin system, and provides the basis for the
    Ember Object Model. `CoreObject` should generally not be used directly,
    instead you should use `EmberObject`.
  
    ## Usage
  
    You can define a class by extending from `CoreObject` using the `extend`
    method:
  
    ```js
    const Person = CoreObject.extend({
      name: 'Tomster',
    });
    ```
  
    For detailed usage, see the [Object Model](https://guides.emberjs.com/release/object-model/)
    section of the guides.
  
    ## Usage with Native Classes
  
    Native JavaScript `class` syntax can be used to extend from any `CoreObject`
    based class:
  
    ```js
    class Person extends CoreObject {
      init() {
        super.init(...arguments);
        this.name = 'Tomster';
      }
    }
    ```
  
    Some notes about `class` usage:
  
    * `new` syntax is not currently supported with classes that extend from
      `EmberObject` or `CoreObject`. You must continue to use the `create` method
      when making new instances of classes, even if they are defined using native
      class syntax. If you want to use `new` syntax, consider creating classes
      which do _not_ extend from `EmberObject` or `CoreObject`. Ember features,
      such as computed properties and decorators, will still work with base-less
      classes.
    * Instead of using `this._super()`, you must use standard `super` syntax in
      native classes. See the [MDN docs on classes](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes#Super_class_calls_with_super)
      for more details.
    * Native classes support using [constructors](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes#Constructor)
      to set up newly-created instances. Ember uses these to, among other things,
      support features that need to retrieve other entities by name, like Service
      injection and `getOwner`. To ensure your custom instance setup logic takes
      place after this important work is done, avoid using the `constructor` in
      favor of `init`.
    * Properties passed to `create` will be available on the instance by the time
      `init` runs, so any code that requires these values should work at that
      time.
    * Using native classes, and switching back to the old Ember Object model is
      fully supported.
  
    @class CoreObject
    @public
  */
  var CoreObject = /*#__PURE__*/function () {
    function CoreObject(owner) {
      // setOwner has to set both OWNER and LEGACY_OWNER for backwards compatibility, and
      // LEGACY_OWNER is enumerable, so setting it would add an enumerable property to the object,
      // so we just set `OWNER` directly here.
      this[_runtime.OWNER] = owner; // prepare prototype...

      this.constructor.proto();
      var self = this;
      if (true /* DEBUG */ && _utils.HAS_NATIVE_PROXY && typeof self.unknownProperty === 'function') {
        var messageFor = function messageFor(obj, property) {
          return "You attempted to access the `" + String(property) + "` property (of " + obj + ").\n" + "Since Ember 3.1, this is usually fine as you no longer need to use `.get()`\n" + "to access computed properties. However, in this case, the object in question\n" + "is a special kind of Ember object (a proxy). Therefore, it is still necessary\n" + ("to use `.get('" + String(property) + "')` in this case.\n\n") + "If you encountered this error because of third-party code that you don't control,\n" + "there is more information at https://github.com/emberjs/ember.js/issues/16148, and\n" + "you can help us improve this error message by telling us more about what happened in\n" + "this situation.";
        };
        /* globals Proxy Reflect */

        self = new Proxy(this, {
          get: function get(target, property, receiver) {
            if (property === _metal.PROXY_CONTENT) {
              return target;
            } else if (
            // init called will be set on the proxy, not the target, so get with the receiver
            !initCalled.has(receiver) || typeof property === 'symbol' || (0, _utils.isInternalSymbol)(property) || property === 'toJSON' || property === 'toString' || property === 'toStringExtension' || property === 'didDefineProperty' || property === 'willWatchProperty' || property === 'didUnwatchProperty' || property === 'didAddListener' || property === 'didRemoveListener' || property === 'isDescriptor' || property === '_onLookup' || property in target) {
              return Reflect.get(target, property, receiver);
            }
            var value = target.unknownProperty.call(receiver, property);
            if (typeof value !== 'function') {
              (true && !(value === undefined || value === null) && (0, _debug.assert)(messageFor(receiver, property), value === undefined || value === null));
            }
          }
        });
      }
      (0, _runtime.registerDestructor)(self, ensureDestroyCalled, true);
      (0, _runtime.registerDestructor)(self, function () {
        return self.willDestroy();
      }); // disable chains

      var m = (0, _meta2.meta)(self);
      m.setInitializing(); // only return when in debug builds and `self` is the proxy created above

      if (true /* DEBUG */ && self !== this) {
        return self;
      }
    } // Empty setter for absorbing setting the LEGACY_OWNER, which should _not_
    // become an enumerable property, and should not be used in general.
    var _proto = CoreObject.prototype;
    _proto.reopen = function reopen() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      (0, _metal.applyMixin)(this, args);
      return this;
    }
    /**
      An overridable method called when objects are instantiated. By default,
      does nothing unless it is overridden during class definition.
       Example:
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        init() {
          alert(`Name is ${this.get('name')}`);
        }
      });
       let steve = Person.create({
        name: 'Steve'
      });
       // alerts 'Name is Steve'.
      ```
       NOTE: If you do override `init` for a framework class like `Component`
      from `@ember/component`, be sure to call `this._super(...arguments)`
      in your `init` declaration!
      If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
      @public
    */;
    _proto.init = function init() {}
    /**
      Defines the properties that will be concatenated from the superclass
      (instead of overridden).
       By default, when you extend an Ember class a property defined in
      the subclass overrides a property with the same name that is defined
      in the superclass. However, there are some cases where it is preferable
      to build up a property's value by combining the superclass' property
      value with the subclass' value. An example of this in use within Ember
      is the `classNames` property of `Component` from `@ember/component`.
       Here is some sample code showing the difference between a concatenated
      property and a normal one:
       ```javascript
      import EmberObject from '@ember/object';
       const Bar = EmberObject.extend({
        // Configure which properties to concatenate
        concatenatedProperties: ['concatenatedProperty'],
         someNonConcatenatedProperty: ['bar'],
        concatenatedProperty: ['bar']
      });
       const FooBar = Bar.extend({
        someNonConcatenatedProperty: ['foo'],
        concatenatedProperty: ['foo']
      });
       let fooBar = FooBar.create();
      fooBar.get('someNonConcatenatedProperty'); // ['foo']
      fooBar.get('concatenatedProperty'); // ['bar', 'foo']
      ```
       This behavior extends to object creation as well. Continuing the
      above example:
       ```javascript
      let fooBar = FooBar.create({
        someNonConcatenatedProperty: ['baz'],
        concatenatedProperty: ['baz']
      })
      fooBar.get('someNonConcatenatedProperty'); // ['baz']
      fooBar.get('concatenatedProperty'); // ['bar', 'foo', 'baz']
      ```
       Adding a single property that is not an array will just add it in the array:
       ```javascript
      let fooBar = FooBar.create({
        concatenatedProperty: 'baz'
      })
      view.get('concatenatedProperty'); // ['bar', 'foo', 'baz']
      ```
       Using the `concatenatedProperties` property, we can tell Ember to mix the
      content of the properties.
       In `Component` the `classNames`, `classNameBindings` and
      `attributeBindings` properties are concatenated.
       This feature is available for you to use throughout the Ember object model,
      although typical app developers are likely to use it infrequently. Since
      it changes expectations about behavior of properties, you should properly
      document its usage in each individual concatenated property (to not
      mislead your users to think they can override the property in a subclass).
       @property concatenatedProperties
      @type Array
      @default null
      @public
    */

    /**
      Defines the properties that will be merged from the superclass
      (instead of overridden).
       By default, when you extend an Ember class a property defined in
      the subclass overrides a property with the same name that is defined
      in the superclass. However, there are some cases where it is preferable
      to build up a property's value by merging the superclass property value
      with the subclass property's value. An example of this in use within Ember
      is the `queryParams` property of routes.
       Here is some sample code showing the difference between a merged
      property and a normal one:
       ```javascript
      import EmberObject from '@ember/object';
       const Bar = EmberObject.extend({
        // Configure which properties are to be merged
        mergedProperties: ['mergedProperty'],
         someNonMergedProperty: {
          nonMerged: 'superclass value of nonMerged'
        },
        mergedProperty: {
          page: { replace: false },
          limit: { replace: true }
        }
      });
       const FooBar = Bar.extend({
        someNonMergedProperty: {
          completelyNonMerged: 'subclass value of nonMerged'
        },
        mergedProperty: {
          limit: { replace: false }
        }
      });
       let fooBar = FooBar.create();
       fooBar.get('someNonMergedProperty');
      // => { completelyNonMerged: 'subclass value of nonMerged' }
      //
      // Note the entire object, including the nonMerged property of
      // the superclass object, has been replaced
       fooBar.get('mergedProperty');
      // => {
      //   page: {replace: false},
      //   limit: {replace: false}
      // }
      //
      // Note the page remains from the superclass, and the
      // `limit` property's value of `false` has been merged from
      // the subclass.
      ```
       This behavior is not available during object `create` calls. It is only
      available at `extend` time.
       In `Route` the `queryParams` property is merged.
       This feature is available for you to use throughout the Ember object model,
      although typical app developers are likely to use it infrequently. Since
      it changes expectations about behavior of properties, you should properly
      document its usage in each individual merged property (to not
      mislead your users to think they can override the property in a subclass).
       @property mergedProperties
      @type Array
      @default null
      @public
    */

    /**
      Destroyed object property flag.
       if this property is `true` the observers and bindings were already
      removed by the effect of calling the `destroy()` method.
       @property isDestroyed
      @default false
      @public
    */;
    /**
      Destroys an object by setting the `isDestroyed` flag and removing its
      metadata, which effectively destroys observers and bindings.
       If you try to set a property on a destroyed object, an exception will be
      raised.
       Note that destruction is scheduled for the end of the run loop and does not
      happen immediately.  It will set an isDestroying flag immediately.
       @method destroy
      @return {EmberObject} receiver
      @public
    */
    _proto.destroy = function destroy() {
      // Used to ensure that manually calling `.destroy()` does not immediately call destroy again
      destroyCalled.add(this);
      try {
        (0, _runtime.destroy)(this);
      } finally {
        destroyCalled.delete(this);
      }
      return this;
    }
    /**
      Override to implement teardown.
       @method willDestroy
      @public
    */;
    _proto.willDestroy = function willDestroy() {}
    /**
      Returns a string representation which attempts to provide more information
      than Javascript's `toString` typically does, in a generic way for all Ember
      objects.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend();
      person = Person.create();
      person.toString(); //=> "<Person:ember1024>"
      ```
       If the object's class is not defined on an Ember namespace, it will
      indicate it is a subclass of the registered superclass:
       ```javascript
      const Student = Person.extend();
      let student = Student.create();
      student.toString(); //=> "<(subclass of Person):ember1025>"
      ```
       If the method `toStringExtension` is defined, its return value will be
      included in the output.
       ```javascript
      const Teacher = Person.extend({
        toStringExtension() {
          return this.get('fullName');
        }
      });
      teacher = Teacher.create();
      teacher.toString(); //=> "<Teacher:ember1026:Tom Dale>"
      ```
       @method toString
      @return {String} string representation
      @public
    */;
    _proto.toString = function toString() {
      var hasToStringExtension = typeof this.toStringExtension === 'function';
      var extension = hasToStringExtension ? ":" + this.toStringExtension() : '';
      var ret = "<" + ((0, _utils.getName)(this) || (0, _container.getFactoryFor)(this) || this.constructor.toString()) + ":" + (0, _utils.guidFor)(this) + extension + ">";
      return ret;
    }
    /**
      Creates a new subclass.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        say(thing) {
          alert(thing);
         }
      });
      ```
       This defines a new subclass of EmberObject: `Person`. It contains one method: `say()`.
       You can also create a subclass from any existing class by calling its `extend()` method.
      For example, you might want to create a subclass of Ember's built-in `Component` class:
       ```javascript
      import Component from '@ember/component';
       const PersonComponent = Component.extend({
        tagName: 'li',
        classNameBindings: ['isAdministrator']
      });
      ```
       When defining a subclass, you can override methods but still access the
      implementation of your parent class by calling the special `_super()` method:
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        say(thing) {
          let name = this.get('name');
          alert(`${name} says: ${thing}`);
        }
      });
       const Soldier = Person.extend({
        say(thing) {
          this._super(`${thing}, sir!`);
        },
        march(numberOfHours) {
          alert(`${this.get('name')} marches for ${numberOfHours} hours.`);
        }
      });
       let yehuda = Soldier.create({
        name: 'Yehuda Katz'
      });
       yehuda.say('Yes');  // alerts "Yehuda Katz says: Yes, sir!"
      ```
       The `create()` on line #17 creates an *instance* of the `Soldier` class.
      The `extend()` on line #8 creates a *subclass* of `Person`. Any instance
      of the `Person` class will *not* have the `march()` method.
       You can also pass `Mixin` classes to add additional properties to the subclass.
       ```javascript
      import EmberObject from '@ember/object';
      import Mixin from '@ember/object/mixin';
       const Person = EmberObject.extend({
        say(thing) {
          alert(`${this.get('name')} says: ${thing}`);
        }
      });
       const SingingMixin = Mixin.create({
        sing(thing) {
          alert(`${this.get('name')} sings: la la la ${thing}`);
        }
      });
       const BroadwayStar = Person.extend(SingingMixin, {
        dance() {
          alert(`${this.get('name')} dances: tap tap tap tap `);
        }
      });
      ```
       The `BroadwayStar` class contains three methods: `say()`, `sing()`, and `dance()`.
       @method extend
      @static
      @for @ember/object
      @param {Mixin} [mixins]* One or more Mixin classes
      @param {Object} [arguments]* Object containing values to use within the new class
      @public
    */;
    CoreObject.extend = function extend() {
      var Class = /*#__PURE__*/function (_this) {
        (0, _emberBabel.inheritsLoose)(Class, _this);
        function Class() {
          return _this.apply(this, arguments) || this;
        }
        return Class;
      }(this);
      _reopen.apply(Class.PrototypeMixin, arguments);
      return Class;
    }
    /**
      Creates an instance of a class. Accepts either no arguments, or an object
      containing values to initialize the newly instantiated object with.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        helloWorld() {
          alert(`Hi, my name is ${this.get('name')}`);
        }
      });
       let tom = Person.create({
        name: 'Tom Dale'
      });
       tom.helloWorld(); // alerts "Hi, my name is Tom Dale".
      ```
       `create` will call the `init` function if defined during
      `AnyObject.extend`
       If no arguments are passed to `create`, it will not set values to the new
      instance during initialization:
       ```javascript
      let noName = Person.create();
      noName.helloWorld(); // alerts undefined
      ```
       NOTE: For performance reasons, you cannot declare methods or computed
      properties during `create`. You should instead declare methods and computed
      properties when using `extend`.
       @method create
      @for @ember/object
      @static
      @param [arguments]*
      @public
    */;
    CoreObject.create = function create(props, extra) {
      var instance;
      if (props !== undefined) {
        instance = new this((0, _owner.getOwner)(props));
        (0, _container.setFactoryFor)(instance, (0, _container.getFactoryFor)(props));
      } else {
        instance = new this();
      }
      if (extra === undefined) {
        initialize(instance, props);
      } else {
        initialize(instance, flattenProps.apply(this, arguments));
      }
      return instance;
    }
    /**
      Augments a constructor's prototype with additional
      properties and functions:
       ```javascript
      import EmberObject from '@ember/object';
       const MyObject = EmberObject.extend({
        name: 'an object'
      });
       o = MyObject.create();
      o.get('name'); // 'an object'
       MyObject.reopen({
        say(msg) {
          console.log(msg);
        }
      });
       o2 = MyObject.create();
      o2.say('hello'); // logs "hello"
       o.say('goodbye'); // logs "goodbye"
      ```
       To add functions and properties to the constructor itself,
      see `reopenClass`
       @method reopen
      @for @ember/object
      @static
      @public
    */;
    CoreObject.reopen = function reopen() {
      this.willReopen();
      _reopen.apply(this.PrototypeMixin, arguments);
      return this;
    };
    CoreObject.willReopen = function willReopen() {
      var p = this.prototype;
      if (wasApplied.has(p)) {
        wasApplied.delete(p); // If the base mixin already exists and was applied, create a new mixin to
        // make sure that it gets properly applied. Reusing the same mixin after
        // the first `proto` call will cause it to get skipped.

        if (prototypeMixinMap.has(this)) {
          prototypeMixinMap.set(this, _metal.Mixin.create(this.PrototypeMixin));
        }
      }
    }
    /**
      Augments a constructor's own properties and functions:
       ```javascript
      import EmberObject from '@ember/object';
       const MyObject = EmberObject.extend({
        name: 'an object'
      });
       MyObject.reopenClass({
        canBuild: false
      });
       MyObject.canBuild; // false
      o = MyObject.create();
      ```
       In other words, this creates static properties and functions for the class.
      These are only available on the class and not on any instance of that class.
       ```javascript
      import EmberObject from '@ember/object';
       const Person = EmberObject.extend({
        name: '',
        sayHello() {
          alert(`Hello. My name is ${this.get('name')}`);
        }
      });
       Person.reopenClass({
        species: 'Homo sapiens',
         createPerson(name) {
          return Person.create({ name });
        }
      });
       let tom = Person.create({
        name: 'Tom Dale'
      });
      let yehuda = Person.createPerson('Yehuda Katz');
       tom.sayHello(); // "Hello. My name is Tom Dale"
      yehuda.sayHello(); // "Hello. My name is Yehuda Katz"
      alert(Person.species); // "Homo sapiens"
      ```
       Note that `species` and `createPerson` are *not* valid on the `tom` and `yehuda`
      variables. They are only valid on `Person`.
       To add functions and properties to instances of
      a constructor by extending the constructor's prototype
      see `reopen`
       @method reopenClass
      @for @ember/object
      @static
      @public
    */;
    CoreObject.reopenClass = function reopenClass() {
      (0, _metal.applyMixin)(this, arguments);
      return this;
    };
    CoreObject.detect = function detect(obj) {
      if ('function' !== typeof obj) {
        return false;
      }
      while (obj) {
        if (obj === this) {
          return true;
        }
        obj = obj.superclass;
      }
      return false;
    };
    CoreObject.detectInstance = function detectInstance(obj) {
      return obj instanceof this;
    }
    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For
      example, computed property functions may close over variables that are then
      no longer available for introspection.
       You can pass a hash of these values to a computed property like this:
       ```javascript
      import { computed } from '@ember/object';
       person: computed(function() {
        let personId = this.get('personId');
        return Person.create({ id: personId });
      }).meta({ type: Person })
      ```
       Once you've done this, you can retrieve the values saved to the computed
      property from your class like this:
       ```javascript
      MyClass.metaForProperty('person');
      ```
       This will return the original hash that was passed to `meta()`.
       @static
      @method metaForProperty
      @param key {String} property name
      @private
    */;
    CoreObject.metaForProperty = function metaForProperty(key) {
      var proto = this.proto(); // ensure prototype is initialized

      var possibleDesc = (0, _metal.descriptorForProperty)(proto, key);
      (true && !(possibleDesc !== undefined) && (0, _debug.assert)("metaForProperty() could not find a computed property with key '" + key + "'.", possibleDesc !== undefined));
      return possibleDesc._meta || {};
    }
    /**
      Iterate over each computed property for the class, passing its name
      and any associated metadata (see `metaForProperty`) to the callback.
       @static
      @method eachComputedProperty
      @param {Function} callback
      @param {Object} binding
      @private
    */;
    CoreObject.eachComputedProperty = function eachComputedProperty(callback, binding) {
      if (binding === void 0) {
        binding = this;
      }
      this.proto(); // ensure prototype is initialized

      var empty = {};
      (0, _meta2.meta)(this.prototype).forEachDescriptors(function (name, descriptor) {
        if (descriptor.enumerable) {
          var _meta = descriptor._meta || empty;
          callback.call(binding, name, _meta);
        }
      });
    };
    CoreObject.proto = function proto() {
      var p = this.prototype;
      if (!wasApplied.has(p)) {
        wasApplied.add(p);
        var parent = this.superclass;
        if (parent) {
          parent.proto();
        } // If the prototype mixin exists, apply it. In the case of native classes,
        // it will not exist (unless the class has been reopened).

        if (prototypeMixinMap.has(this)) {
          this.PrototypeMixin.apply(p);
        }
      }
      return p;
    };
    (0, _emberBabel.createClass)(CoreObject, [{
      key: _owner.LEGACY_OWNER,
      set: function set(value) {}
    }, {
      key: "isDestroyed",
      get: function get() {
        return (0, _runtime.isDestroyed)(this);
      }
    }, {
      key: "isDestroyed",
      set: function set(value) {
        (true && !(false) && (0, _debug.assert)("You cannot set `" + this + ".isDestroyed` directly, please use `.destroy()`.", false));
      }
      /**
        Destruction scheduled flag. The `destroy()` method has been called.
         The object stays intact until the end of the run loop at which point
        the `isDestroyed` flag is set.
         @property isDestroying
        @default false
        @public
      */
    }, {
      key: "isDestroying",
      get: function get() {
        return (0, _runtime.isDestroying)(this);
      }
    }, {
      key: "isDestroying",
      set: function set(value) {
        (true && !(false) && (0, _debug.assert)("You cannot set `" + this + ".isDestroying` directly, please use `.destroy()`.", false));
      }
    }], [{
      key: "PrototypeMixin",
      get: function get() {
        var prototypeMixin = prototypeMixinMap.get(this);
        if (prototypeMixin === undefined) {
          prototypeMixin = _metal.Mixin.create();
          prototypeMixin.ownerConstructor = this;
          prototypeMixinMap.set(this, prototypeMixin);
        }
        return prototypeMixin;
      }
    }, {
      key: "superclass",
      get: function get() {
        var c = Object.getPrototypeOf(this);
        return c !== Function.prototype ? c : undefined;
      }
    }]);
    return CoreObject;
  }();
  CoreObject.toString = _metal.classToString;
  (0, _utils.setName)(CoreObject, 'Ember.CoreObject');
  CoreObject.isClass = true;
  CoreObject.isMethod = false;
  function flattenProps() {
    var concatenatedProperties = this.concatenatedProperties,
      mergedProperties = this.mergedProperties;
    var hasConcatenatedProps = concatenatedProperties !== undefined && concatenatedProperties.length > 0;
    var hasMergedProps = mergedProperties !== undefined && mergedProperties.length > 0;
    var initProperties = {};
    for (var i = 0; i < arguments.length; i++) {
      var properties = i < 0 || arguments.length <= i ? undefined : arguments[i];
      (true && !(!(properties instanceof _metal.Mixin)) && (0, _debug.assert)('EmberObject.create no longer supports mixing in other ' + 'definitions, use .extend & .create separately instead.', !(properties instanceof _metal.Mixin)));
      var keyNames = Object.keys(properties);
      for (var j = 0, k = keyNames.length; j < k; j++) {
        var keyName = keyNames[j];
        var value = properties[keyName];
        if (hasConcatenatedProps && concatenatedProperties.indexOf(keyName) > -1) {
          var baseValue = initProperties[keyName];
          if (baseValue) {
            value = (0, _utils.makeArray)(baseValue).concat(value);
          } else {
            value = (0, _utils.makeArray)(value);
          }
        }
        if (hasMergedProps && mergedProperties.indexOf(keyName) > -1) {
          var _baseValue2 = initProperties[keyName];
          value = (0, _polyfills.assign)({}, _baseValue2, value);
        }
        initProperties[keyName] = value;
      }
    }
    return initProperties;
  }
  if (true /* DEBUG */) {
    /**
      Provides lookup-time type validation for injected properties.
       @private
      @method _onLookup
    */
    CoreObject._onLookup = function injectedPropertyAssertion(debugContainerKey) {
      var _debugContainerKey$sp = debugContainerKey.split(':'),
        type = _debugContainerKey$sp[0];
      var proto = this.proto();
      for (var key in proto) {
        var desc = (0, _metal.descriptorForProperty)(proto, key);
        if (desc && _metal.DEBUG_INJECTION_FUNCTIONS.has(desc._getter)) {
          (true && !(type === 'controller' || _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter).type !== 'controller') && (0, _debug.assert)("Defining `" + key + "` as an injected controller property on a non-controller (`" + debugContainerKey + "`) is not allowed.", type === 'controller' || _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter).type !== 'controller'));
        }
      }
    };
    /**
      Returns a hash of property names and container names that injected
      properties will lookup on the container lazily.
       @method _lazyInjections
      @return {Object} Hash of all lazy injected property keys to container names
      @private
    */

    CoreObject._lazyInjections = function () {
      var injections = {};
      var proto = this.proto();
      var key;
      var desc;
      for (key in proto) {
        desc = (0, _metal.descriptorForProperty)(proto, key);
        if (desc && _metal.DEBUG_INJECTION_FUNCTIONS.has(desc._getter)) {
          var _DEBUG_INJECTION_FUNC = _metal.DEBUG_INJECTION_FUNCTIONS.get(desc._getter),
            namespace = _DEBUG_INJECTION_FUNC.namespace,
            source = _DEBUG_INJECTION_FUNC.source,
            type = _DEBUG_INJECTION_FUNC.type,
            name = _DEBUG_INJECTION_FUNC.name;
          injections[key] = {
            namespace: namespace,
            source: source,
            specifier: type + ":" + (name || key)
          };
        }
      }
      return injections;
    };
  }
  if (!_utils.HAS_NATIVE_SYMBOL) {
    // Allows OWNER and INIT_FACTORY to be non-enumerable in IE11
    var instanceOwner = new WeakMap();
    var instanceFactory = new WeakMap();
    Object.defineProperty(CoreObject.prototype, _runtime.OWNER, {
      get: function get() {
        return instanceOwner.get(this);
      },
      set: function set(value) {
        instanceOwner.set(this, value);
      }
    });
    Object.defineProperty(CoreObject.prototype, _container.INIT_FACTORY, {
      get: function get() {
        return instanceFactory.get(this);
      },
      set: function set(value) {
        instanceFactory.set(this, value);
      }
    });
  }
  var _default = CoreObject;
  _exports.default = _default;
});
define("@ember/-internals/runtime/lib/system/namespace", ["exports", "ember-babel", "@ember/-internals/metal", "@ember/-internals/utils", "@ember/-internals/runtime/lib/system/object"], function (_exports, _emberBabel, _metal, _utils, _object) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
  @module ember
  */
  // Preloaded into namespaces
  /**
    A Namespace is an object usually used to contain other objects or methods
    such as an application or framework. Create a namespace anytime you want
    to define one of these new containers.
  
    # Example Usage
  
    ```javascript
    MyFramework = Ember.Namespace.create({
      VERSION: '1.0.0'
    });
    ```
  
    @class Namespace
    @namespace Ember
    @extends EmberObject
    @public
  */
  var Namespace = /*#__PURE__*/function (_EmberObject) {
    (0, _emberBabel.inheritsLoose)(Namespace, _EmberObject);
    function Namespace() {
      return _EmberObject.apply(this, arguments) || this;
    }
    var _proto = Namespace.prototype;
    _proto.init = function init() {
      (0, _metal.addNamespace)(this);
    };
    _proto.toString = function toString() {
      var name = (0, _metal.get)(this, 'name') || (0, _metal.get)(this, 'modulePrefix');
      if (name) {
        return name;
      }
      (0, _metal.findNamespaces)();
      name = (0, _utils.getName)(this);
      if (name === undefined) {
        name = (0, _utils.guidFor)(this);
        (0, _utils.setName)(this, name);
      }
      return name;
    };
    _proto.nameClasses = function nameClasses() {
      (0, _metal.processNamespace)(this);
    };
    _proto.destroy = function destroy() {
      (0, _metal.removeNamespace)(this);
      _EmberObject.prototype.destroy.call(this);
    };
    return Namespace;
  }(_object.default);
  _exports.default = Namespace;
  Namespace.prototype.isNamespace = true;
  Namespace.NAMESPACES = _metal.NAMESPACES;
  Namespace.NAMESPACES_BY_ID = _metal.NAMESPACES_BY_ID;
  Namespace.processAll = _metal.processAllNamespaces;
  Namespace.byName = _metal.findNamespace;
});
define("@ember/-internals/runtime/lib/system/object", ["exports", "ember-babel", "@ember/-internals/container", "@ember/-internals/utils", "@ember/-internals/metal", "@ember/-internals/runtime/lib/system/core_object", "@ember/-internals/runtime/lib/mixins/observable", "@ember/debug"], function (_exports, _emberBabel, _container, _utils, _metal, _core_object, _observable, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = _exports.FrameworkObject = void 0;
  /**
  @module @ember/object
  */
  /**
    `EmberObject` is the main base class for all Ember objects. It is a subclass
    of `CoreObject` with the `Observable` mixin applied. For details,
    see the documentation for each of these.
  
    @class EmberObject
    @extends CoreObject
    @uses Observable
    @public
  */
  var EmberObject = /*#__PURE__*/function (_CoreObject) {
    (0, _emberBabel.inheritsLoose)(EmberObject, _CoreObject);
    function EmberObject() {
      return _CoreObject.apply(this, arguments) || this;
    }
    (0, _emberBabel.createClass)(EmberObject, [{
      key: "_debugContainerKey",
      get: function get() {
        var factory = (0, _container.getFactoryFor)(this);
        return factory !== undefined && factory.fullName;
      }
    }]);
    return EmberObject;
  }(_core_object.default);
  _exports.default = EmberObject;
  (0, _utils.setName)(EmberObject, 'Ember.Object');
  _observable.default.apply(EmberObject.prototype);
  var FrameworkObject;
  _exports.FrameworkObject = FrameworkObject;
  _exports.FrameworkObject = FrameworkObject = /*#__PURE__*/function (_CoreObject2) {
    (0, _emberBabel.inheritsLoose)(FrameworkObject, _CoreObject2);
    function FrameworkObject() {
      return _CoreObject2.apply(this, arguments) || this;
    }
    (0, _emberBabel.createClass)(FrameworkObject, [{
      key: "_debugContainerKey",
      get: function get() {
        var factory = (0, _container.getFactoryFor)(this);
        return factory !== undefined && factory.fullName;
      }
    }]);
    return FrameworkObject;
  }(_core_object.default);
  _observable.default.apply(FrameworkObject.prototype);
  if (true /* DEBUG */) {
    var INIT_WAS_CALLED = (0, _utils.symbol)('INIT_WAS_CALLED');
    var ASSERT_INIT_WAS_CALLED = (0, _utils.symbol)('ASSERT_INIT_WAS_CALLED');
    _exports.FrameworkObject = FrameworkObject = /*#__PURE__*/function (_EmberObject) {
      (0, _emberBabel.inheritsLoose)(DebugFrameworkObject, _EmberObject);
      function DebugFrameworkObject() {
        return _EmberObject.apply(this, arguments) || this;
      }
      var _proto = DebugFrameworkObject.prototype;
      _proto.init = function init() {
        _EmberObject.prototype.init.apply(this, arguments);
        this[INIT_WAS_CALLED] = true;
      };
      _proto[ASSERT_INIT_WAS_CALLED] = function () {
        (true && !(this[INIT_WAS_CALLED]) && (0, _debug.assert)("You must call `super.init(...arguments);` or `this._super(...arguments)` when overriding `init` on a framework object. Please update " + this + " to call `super.init(...arguments);` from `init` when using native classes or `this._super(...arguments)` when using `EmberObject.extend()`.", this[INIT_WAS_CALLED]));
      };
      return DebugFrameworkObject;
    }(EmberObject);
    (0, _metal.addListener)(FrameworkObject.prototype, 'init', null, ASSERT_INIT_WAS_CALLED);
  }
});
define("@ember/-internals/runtime/lib/system/object_proxy", ["exports", "ember-babel", "@ember/-internals/runtime/lib/system/object", "@ember/-internals/runtime/lib/mixins/-proxy"], function (_exports, _emberBabel, _object, _proxy) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.default = void 0;
  /**
    `ObjectProxy` forwards all properties not defined by the proxy itself
    to a proxied `content` object.
  
    ```javascript
    import EmberObject from '@ember/object';
    import ObjectProxy from '@ember/object/proxy';
  
    let exampleObject = EmberObject.create({
      name: 'Foo'
    });
  
    let exampleProxy = ObjectProxy.create({
      content: exampleObject
    });
  
    // Access and change existing properties
    exampleProxy.get('name');          // 'Foo'
    exampleProxy.set('name', 'Bar');
    exampleObject.get('name');         // 'Bar'
  
    // Create new 'description' property on `exampleObject`
    exampleProxy.set('description', 'Foo is a whizboo baz');
    exampleObject.get('description');  // 'Foo is a whizboo baz'
    ```
  
    While `content` is unset, setting a property to be delegated will throw an
    Error.
  
    ```javascript
    import ObjectProxy from '@ember/object/proxy';
  
    let exampleProxy = ObjectProxy.create({
      content: null,
      flag: null
    });
    exampleProxy.set('flag', true);
    exampleProxy.get('flag');         // true
    exampleProxy.get('foo');          // undefined
    exampleProxy.set('foo', 'data');  // throws Error
    ```
  
    Delegated properties can be bound to and will change when content is updated.
  
    Computed properties on the proxy itself can depend on delegated properties.
  
    ```javascript
    import { computed } from '@ember/object';
    import ObjectProxy from '@ember/object/proxy';
  
    ProxyWithComputedProperty = ObjectProxy.extend({
      fullName: computed('firstName', 'lastName', function() {
        var firstName = this.get('firstName'),
            lastName = this.get('lastName');
        if (firstName && lastName) {
          return firstName + ' ' + lastName;
        }
        return firstName || lastName;
      })
    });
  
    let exampleProxy = ProxyWithComputedProperty.create();
  
    exampleProxy.get('fullName');  // undefined
    exampleProxy.set('content', {
      firstName: 'Tom', lastName: 'Dale'
    }); // triggers property change for fullName on proxy
  
    exampleProxy.get('fullName');  // 'Tom Dale'
    ```
  
    @class ObjectProxy
    @extends EmberObject
    @uses Ember.ProxyMixin
    @public
  */
  var ObjectProxy = /*#__PURE__*/function (_FrameworkObject) {
    (0, _emberBabel.inheritsLoose)(ObjectProxy, _FrameworkObject);
    function ObjectProxy() {
      return _FrameworkObject.apply(this, arguments) || this;
    }
    return ObjectProxy;
  }(_object.default);
  _exports.default = ObjectProxy;
  ObjectProxy.PrototypeMixin.reopen(_proxy.default);
});
define("@ember/-internals/runtime/lib/type-of", ["exports", "@ember/-internals/runtime/lib/system/core_object"], function (_exports, _core_object) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.typeOf = typeOf;
  // ........................................
  // TYPING & ARRAY MESSAGING
  //

  var TYPE_MAP = {
    '[object Boolean]': 'boolean',
    '[object Number]': 'number',
    '[object String]': 'string',
    '[object Function]': 'function',
    '[object AsyncFunction]': 'function',
    '[object Array]': 'array',
    '[object Date]': 'date',
    '[object RegExp]': 'regexp',
    '[object Object]': 'object',
    '[object FileList]': 'filelist'
  };
  var toString = Object.prototype.toString;
  /**
   @module @ember/utils
  */

  /**
    Returns a consistent type for the passed object.
  
    Use this instead of the built-in `typeof` to get the type of an item.
    It will return the same result across all browsers and includes a bit
    more detail. Here is what will be returned:
  
        | Return Value  | Meaning                                              |
        |---------------|------------------------------------------------------|
        | 'string'      | String primitive or String object.                   |
        | 'number'      | Number primitive or Number object.                   |
        | 'boolean'     | Boolean primitive or Boolean object.                 |
        | 'null'        | Null value                                           |
        | 'undefined'   | Undefined value                                      |
        | 'function'    | A function                                           |
        | 'array'       | An instance of Array                                 |
        | 'regexp'      | An instance of RegExp                                |
        | 'date'        | An instance of Date                                  |
        | 'filelist'    | An instance of FileList                              |
        | 'class'       | An Ember class (created using EmberObject.extend())  |
        | 'instance'    | An Ember object instance                             |
        | 'error'       | An instance of the Error object                      |
        | 'object'      | A JavaScript object not inheriting from EmberObject  |
  
    Examples:
  
    ```javascript
    import { A } from '@ember/array';
    import { typeOf } from '@ember/utils';
    import EmberObject from '@ember/object';
  
    typeOf();                       // 'undefined'
    typeOf(null);                   // 'null'
    typeOf(undefined);              // 'undefined'
    typeOf('michael');              // 'string'
    typeOf(new String('michael'));  // 'string'
    typeOf(101);                    // 'number'
    typeOf(new Number(101));        // 'number'
    typeOf(true);                   // 'boolean'
    typeOf(new Boolean(true));      // 'boolean'
    typeOf(A);                      // 'function'
    typeOf(A());                    // 'array'
    typeOf([1, 2, 90]);             // 'array'
    typeOf(/abc/);                  // 'regexp'
    typeOf(new Date());             // 'date'
    typeOf(event.target.files);     // 'filelist'
    typeOf(EmberObject.extend());   // 'class'
    typeOf(EmberObject.create());   // 'instance'
    typeOf(new Error('teamocil'));  // 'error'
  
    // 'normal' JavaScript object
    typeOf({ a: 'b' });             // 'object'
    ```
  
    @method typeOf
    @for @ember/utils
    @param {Object} item the item to check
    @return {String} the type
    @public
    @static
  */

  function typeOf(item) {
    if (item === null) {
      return 'null';
    }
    if (item === undefined) {
      return 'undefined';
    }
    var ret = TYPE_MAP[toString.call(item)] || 'object';
    if (ret === 'function') {
      if (_core_object.default.detect(item)) {
        ret = 'class';
      }
    } else if (ret === 'object') {
      if (item instanceof Error) {
        ret = 'error';
      } else if (item instanceof _core_object.default) {
        ret = 'instance';
      } else if (item instanceof Date) {
        ret = 'date';
      }
    }
    return ret;
  }
});
define("@ember/-internals/utils/index", ["exports", "@glimmer/util", "@ember/debug"], function (_exports, _util, _debug) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports.ROOT = _exports.HAS_NATIVE_SYMBOL = _exports.HAS_NATIVE_PROXY = _exports.GUID_KEY = _exports.Cache = void 0;
  _exports.canInvoke = canInvoke;
  _exports.checkHasSuper = void 0;
  _exports.dictionary = makeDictionary;
  _exports.enumerableSymbol = enumerableSymbol;
  _exports.generateGuid = generateGuid;
  _exports.getDebugName = void 0;
  _exports.getName = getName;
  _exports.guidFor = guidFor;
  _exports.inspect = inspect;
  _exports.intern = intern;
  _exports.isEmberArray = isEmberArray;
  _exports.isInternalSymbol = isInternalSymbol;
  _exports.isObject = isObject;
  _exports.isProxy = isProxy;
  _exports.lookupDescriptor = lookupDescriptor;
  _exports.makeArray = makeArray;
  _exports.observerListenerMetaFor = observerListenerMetaFor;
  _exports.setEmberArray = setEmberArray;
  _exports.setListeners = setListeners;
  _exports.setName = setName;
  _exports.setObservers = setObservers;
  _exports.setProxy = setProxy;
  _exports.teardownMandatorySetter = _exports.symbol = _exports.setupMandatorySetter = _exports.setWithMandatorySetter = void 0;
  _exports.toString = toString;
  _exports.tryInvoke = tryInvoke;
  _exports.uuid = uuid;
  _exports.wrap = wrap;
  /**
    Strongly hint runtimes to intern the provided string.
  
    When do I need to use this function?
  
    For the most part, never. Pre-mature optimization is bad, and often the
    runtime does exactly what you need it to, and more often the trade-off isn't
    worth it.
  
    Why?
  
    Runtimes store strings in at least 2 different representations:
    Ropes and Symbols (interned strings). The Rope provides a memory efficient
    data-structure for strings created from concatenation or some other string
    manipulation like splitting.
  
    Unfortunately checking equality of different ropes can be quite costly as
    runtimes must resort to clever string comparison algorithms. These
    algorithms typically cost in proportion to the length of the string.
    Luckily, this is where the Symbols (interned strings) shine. As Symbols are
    unique by their string content, equality checks can be done by pointer
    comparison.
  
    How do I know if my string is a rope or symbol?
  
    Typically (warning general sweeping statement, but truthy in runtimes at
    present) static strings created as part of the JS source are interned.
    Strings often used for comparisons can be interned at runtime if some
    criteria are met.  One of these criteria can be the size of the entire rope.
    For example, in chrome 38 a rope longer then 12 characters will not
    intern, nor will segments of that rope.
  
    Some numbers: http://jsperf.com/eval-vs-keys/8
  
    Known Trick™
  
    @private
    @return {String} interned version of the provided string
  */
  function intern(str) {
    var obj = {};
    obj[str] = 1;
    for (var key in obj) {
      if (key === str) {
        return key;
      }
    }
    return str;
  }

  /**
    Returns whether Type(value) is Object.
  
    Useful for checking whether a value is a valid WeakMap key.
  
    Refs: https://tc39.github.io/ecma262/#sec-typeof-operator-runtime-semantics-evaluation
          https://tc39.github.io/ecma262/#sec-weakmap.prototype.set
  
    @private
    @function isObject
  */
  function isObject(value) {
    return value !== null && (typeof value === 'object' || typeof value === 'function');
  }

  /**
   @module @ember/object
  */

  /**
   Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
   jQuery master. We'll just bootstrap our own uuid now.
  
   @private
   @return {Number} the uuid
   */

  var _uuid = 0;
  /**
   Generates a universally unique identifier. This method
   is used internally by Ember for assisting with
   the generation of GUID's and other unique identifiers.
  
   @public
   @return {Number} [description]
   */

  function uuid() {
    return ++_uuid;
  }
  /**
   Prefix used for guids through out Ember.
   @private
   @property GUID_PREFIX
   @for Ember
   @type String
   @final
   */

  var GUID_PREFIX = 'ember'; // Used for guid generation...

  var OBJECT_GUIDS = new WeakMap();
  var NON_OBJECT_GUIDS = new Map();
  /**
    A unique key used to assign guids and other private metadata to objects.
    If you inspect an object in your browser debugger you will often see these.
    They can be safely ignored.
  
    On browsers that support it, these properties are added with enumeration
    disabled so they won't show up when you iterate over your properties.
  
    @private
    @property GUID_KEY
    @for Ember
    @type String
    @final
  */

  var GUID_KEY = intern("__ember" + Date.now());
  /**
    Generates a new guid, optionally saving the guid to the object that you
    pass in. You will rarely need to use this method. Instead you should
    call `guidFor(obj)`, which return an existing guid if available.
  
    @private
    @method generateGuid
    @static
    @for @ember/object/internals
    @param {Object} [obj] Object the guid will be used for. If passed in, the guid will
      be saved on the object and reused whenever you pass the same object
      again.
  
      If no object is passed, just generate a new guid.
    @param {String} [prefix] Prefix to place in front of the guid. Useful when you want to
      separate the guid into separate namespaces.
    @return {String} the guid
  */
  _exports.GUID_KEY = GUID_KEY;
  function generateGuid(obj, prefix) {
    if (prefix === void 0) {
      prefix = GUID_PREFIX;
    }
    var guid = prefix + uuid();
    if (isObject(obj)) {
      OBJECT_GUIDS.set(obj, guid);
    }
    return guid;
  }
  /**
    Returns a unique id for the object. If the object does not yet have a guid,
    one will be assigned to it. You can call this on any object,
    `EmberObject`-based or not.
  
    You can also use this method on DOM Element objects.
  
    @public
    @static
    @method guidFor
    @for @ember/object/internals
    @param {Object} obj any object, string, number, Element, or primitive
    @return {String} the unique guid for this instance.
  */

  function guidFor(value) {
    var guid;
    if (isObject(value)) {
      guid = OBJECT_GUIDS.get(value);
      if (guid === undefined) {
        guid = GUID_PREFIX + uuid();
        OBJECT_GUIDS.set(value, guid);
      }
    } else {
      guid = NON_OBJECT_GUIDS.get(value);
      if (guid === undefined) {
        var type = typeof value;
        if (type === 'string') {
          guid = 'st' + uuid();
        } else if (type === 'number') {
          guid = 'nu' + uuid();
        } else if (type === 'symbol') {
          guid = 'sy' + uuid();
        } else {
          guid = '(' + value + ')';
        }
        NON_OBJECT_GUIDS.set(value, guid);
      }
    }
    return guid;
  }
  var HAS_NATIVE_SYMBOL = function () {
    if (typeof Symbol !== 'function') {
      return false;
    }
    return typeof Symbol() === 'symbol';
  }();
  _exports.HAS_NATIVE_SYMBOL = HAS_NATIVE_SYMBOL;
  var GENERATED_SYMBOLS = [];
  function isInternalSymbol(possibleSymbol) {
    return GENERATED_SYMBOLS.indexOf(possibleSymbol) !== -1;
  } // Some legacy symbols still need to be enumerable for a variety of reasons.
  // This code exists for that, and as a fallback in IE11. In general, prefer
  // `symbol` below when creating a new symbol.

  function enumerableSymbol(debugName) {
    // TODO: Investigate using platform symbols, but we do not
    // want to require non-enumerability for this API, which
    // would introduce a large cost.
    var id = GUID_KEY + Math.floor(Math.random() * Date.now());
    var symbol = intern("__" + debugName + id + "__");
    if (true /* DEBUG */) {
      GENERATED_SYMBOLS.push(symbol);
    }
    return symbol;
  }
  var symbol = HAS_NATIVE_SYMBOL ? Symbol : enumerableSymbol;

  // the delete is meant to hint at runtimes that this object should remain in
  // dictionary mode. This is clearly a runtime specific hack, but currently it
  // appears worthwhile in some usecases. Please note, these deletes do increase
  // the cost of creation dramatically over a plain Object.create. And as this
  // only makes sense for long-lived dictionaries that aren't instantiated often.
  _exports.symbol = symbol;
  function makeDictionary(parent) {
    var dict = Object.create(parent);
    dict['_dict'] = null;
    delete dict['_dict'];
    return dict;
  }
  var getDebugName;
  if (true /* DEBUG */) {
    var getFunctionName = function getFunctionName(fn) {
      var functionName = fn.name;
      if (functionName === undefined) {
        var match = Function.prototype.toString.call(fn).match(/function (\w+)\s*\(/);
        functionName = match && match[1] || '';
      }
      return functionName.replace(/^bound /, '');
    };
    var getObjectName = function getObjectName(obj) {
      var name;
      var className;
      if (obj.constructor && obj.constructor !== Object) {
        className = getFunctionName(obj.constructor);
      }
      if ('toString' in obj && obj.toString !== Object.prototype.toString && obj.toString !== Function.prototype.toString) {
        name = o