/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class AnnotateAction
extends AnAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Document document = editor.getDocument();
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Language lang = file.getLanguage();
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Caret currentCaret = caretModel.getCurrentCaret();
        boolean hasSelection = currentCaret.hasSelection();
        String selectedText = currentCaret.getSelectedText();
        int caretOffset = caretModel.getOffset();
        PsiElement element = file.findElementAt(caretOffset);
        String elementText = selectedText;
        if (!hasSelection && element != null) {
            elementText = element.getText();
        }
        String label = "";
        LanguageFileType fileType = lang.getAssociatedFileType();
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document labelDocument = editorFactory.createDocument((CharSequence)"");
        Editor labelEditor = editorFactory.createEditor(labelDocument);
        JTextField textField = new JTextField();
        try {
            if (fileType != null) {
                ((EditorEx)labelEditor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, (FileType)fileType));
            }
            textField.setPreferredSize(new Dimension(640, 28));
            DialogBuilder db = new DialogBuilder(project);
            db.title("Label for " + elementText).dimensionKey("GuiDesigner.FormSource.Dialog");
            db.centerPanel((JComponent)textField).setPreferredFocusComponent((JComponent)textField);
            db.addOkAction();
            if (db.show() == 0) {
                label = textField.getText();
            }
        }
        finally {
            editorFactory.releaseEditor(labelEditor);
        }
        if (label.length() > 0) {
            String replaceText = "GET(\"" + label + "\", " + elementText + ")";
            Document temp = EditorFactory.getInstance().createDocument((CharSequence)replaceText);
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                document.setReadOnly(false);
                if (hasSelection) {
                    int start = selectionModel.getSelectionStart();
                    int end = selectionModel.getSelectionEnd();
                    document.replaceString(start, end, (CharSequence)replaceText);
                    selectionModel.removeSelection();
                } else {
                    int start = element.getTextOffset();
                    int end = start + element.getTextLength();
                    document.replaceString(start, end, (CharSequence)replaceText);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file != null) {
            VirtualFile vFile = file.getVirtualFile();
            boolean inHighlightedFolder = vFile.getPath().contains("highlighted.");
            e.getPresentation().setEnabledAndVisible(inHighlightedFolder);
            if (inHighlightedFolder) {
                ToggleReadOnlyView.toggleReadOnlyFor(editor.getDocument());
            }
        }
    }
}

