/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public class CloneAndOpenAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloneAndOpenAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        CaretModel caretModel = null;
        if (editor != null) {
            caretModel = editor.getCaretModel();
        }
        Caret currentCaret = null;
        if (caretModel != null) {
            currentCaret = caretModel.getCurrentCaret();
        }
        int currentCaretOffset = 0;
        if (currentCaret != null) {
            currentCaretOffset = currentCaret.getOffset();
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file != null);
        VirtualFile srcVFile = file.getVirtualFile();
        String currFolderPath = srcVFile.getParent().getPath();
        String currFolderName = srcVFile.getParent().getName();
        String srcFilePath = srcVFile.getPath();
        File srcFile = new File(srcFilePath);
        @SystemIndependent String projectBasePath = project.getBasePath();
        SessionManager sessionManager = new SessionManager(projectBasePath);
        String dstFolderPath = sessionManager.getLatestSessionFolderPath(e);
        File dstDir = new File(dstFolderPath);
        dstDir.mkdir();
        String srcFileNameRoot = file.getName().split(".py")[0];
        String dstFilePath = dstFolderPath + "/" + srcFileNameRoot + "_h.py";
        assert (srcFile.exists());
        String program = "from argparse import Namespace; from flor.commands.cp import exec_cp; exec_cp(Namespace(src='" + srcFilePath + "', dst='" + dstFilePath + "'))";
        try {
            File tempFile = File.createTempFile("flor_plugin_temp", ".py");
            BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
            out.write(program);
            out.close();
            String[] command = new String[]{"/bin/bash", "-c", "\"python " + tempFile.getAbsolutePath() + "\""};
            Process p = Runtime.getRuntime().exec("python " + tempFile.getAbsolutePath());
            p.waitFor();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String ret = in.readLine();
            System.out.println("RetVal: " + ret);
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
        File dstFile = new File(dstFilePath);
        ProcessHandler processHandler = null;
        if (!dstFile.exists()) {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("flor_plugin_temp", ".py");
                BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
                out.write(program);
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("/bin/bash");
            command.add("-c");
            if (tempFile != null) {
                command.add("python " + tempFile.getAbsolutePath());
            }
            processHandler = RunCommandLine.getProcessHandler(command, projectBasePath);
        }
        if (processHandler != null) {
            processHandler.waitFor();
        }
        assert (dstFile.exists()) : dstFilePath + " not found.";
        VirtualFile dstVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dstFile);
        assert (dstVFile != null) : dstFilePath + " not found.";
        FileEditorManager.getInstance((Project)project).openFile(dstVFile, true);
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedTextEditor != null) {
            selectedTextEditor.getCaretModel().moveToOffset((int)((long)currentCaretOffset + dstVFile.getLength() - srcVFile.getLength()));
            selectedTextEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            ToggleReadOnlyView.toggleReadOnlyFor(selectedTextEditor.getDocument());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile vFile;
        boolean inHighlightedFolder;
        if (e == null) {
            CloneAndOpenAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file != null && (inHighlightedFolder = (vFile = file.getVirtualFile()).getPath().contains("highlighted.")) && editor != null) {
            ToggleReadOnlyView.toggleReadOnlyFor(editor.getDocument());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "CloneAndOpenAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

