/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ToggleReadOnlyView
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleReadOnlyView.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        EditorFactory editorFactory = EditorFactory.getInstance();
        ToggleReadOnlyView.toggleReadOnlyFor(project, file);
    }

    private static void toggleReadOnlyFor(Project project, PsiFile file) {
        PsiDocumentManager docManager = null;
        if (project != null) {
            docManager = PsiDocumentManager.getInstance((Project)project);
        }
        Document document = null;
        if (docManager != null && file != null) {
            document = docManager.getDocument(file);
            ToggleReadOnlyView.toggleReadOnlyFor(document);
        }
    }

    static void toggleReadOnlyFor(Document document) {
        if (document != null) {
            RangeMarker guardedBlock = document.createGuardedBlock(0, document.getTextLength());
            guardedBlock.setGreedyToLeft(true);
            guardedBlock.setGreedyToRight(true);
            EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(document, e1 -> {});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "ToggleReadOnlyView", "actionPerformed"));
    }
}

