---
title: Intel Aes Intrinsics
url: /doc/api/intel/aes/
---

In order to use the functions provided by this module, you need to import this module:

```kalk
>>> import HardwareIntrinsics
```

{{NOTE do}}
These intrinsic functions are only available if your CPU supports `Aes` features.

{{end}}


## mm_aesdec_si128

`mm_aesdec_si128`

__m128i _mm_aesdec_si128 (__m128i a, __m128i RoundKey)
AESDEC xmm, xmm/m128

## mm_aesdeclast_si128

`mm_aesdeclast_si128`

__m128i _mm_aesdeclast_si128 (__m128i a, __m128i RoundKey)
AESDECLAST xmm, xmm/m128

## mm_aesenc_si128

`mm_aesenc_si128`

__m128i _mm_aesenc_si128 (__m128i a, __m128i RoundKey)
AESENC xmm, xmm/m128

## mm_aesenclast_si128

`mm_aesenclast_si128`

__m128i _mm_aesenclast_si128 (__m128i a, __m128i RoundKey)
AESENCLAST xmm, xmm/m128

## mm_aesimc_si128

`mm_aesimc_si128`

__m128i _mm_aesimc_si128 (__m128i a)
AESIMC xmm, xmm/m128

## mm_aeskeygenassist_si128

`mm_aeskeygenassist_si128`

__m128i _mm_aeskeygenassist_si128 (__m128i a, const int imm8)
AESKEYGENASSIST xmm, xmm/m128, imm8
