---
title: Intel Sse41X64 Intrinsics
url: /doc/api/intel/sse41x64/
---

In order to use the functions provided by this module, you need to import this module:

```kalk
>>> import HardwareIntrinsics
```

{{NOTE do}}
These intrinsic functions are only available if your CPU supports `Sse41X64` features.

{{end}}


## mm_extract_epi64

`mm_extract_epi64`

Extract a 64-bit integer from "a", selected with "imm8", and store the result in "dst".

__int64 _mm_extract_epi64 (__m128i a, const int imm8)
PEXTRQ reg/m64, xmm, imm8

## mm_insert_epi64

`mm_insert_epi64`

Copy "a" to "dst", and insert the 64-bit integer "i" into "dst" at the location specified by "imm8".

__m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
PINSRQ xmm, reg/m64, imm8
