---
title: Documentation
---

Welcome to the documentation of `kalk`!

`kalk` is a powerful command line calculator app for developers. In addition to the standard functions found
in classic calculators, `kalk` provides several unique features:
- Enhanced user experience within the command line: syntax highlighting, completion, brace matching, cursor on error, user defined keyboard shortcuts...
- Vector/matrix types and functions similar to the [HLSL shading language](https://docs.microsoft.com/en-us/windows/win32/direct3dhlsl/dx-graphics-hlsl)
- x86 [Intel Hardware intrinsics](https://software.intel.com/sites/landingpage/IntrinsicsGuide/) from `SSE` to `AVX2`
- Several other modules to manipulate strings, perform web queries, file operations, currencies and standard units conversions...

This documentation is organized with the following parts:

- A [user guide](user/readme.md) explains how to use `kalk` and presents an overview of its features.
- A [reference API](api/readme.md) provides a complete listing of all builtin functions exposed by `kalk`.

You can participate in improving this documentation by clicking the "Edit" button on the right side of each page and open a Pull-Request directly on GitHub.
