//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Date: 04 Dec 2020
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------
using System;
using NUnit.Framework;

namespace Kalk.Tests
{
    using Kalk.Core.Modules.HardwareIntrinsics;
    using Kalk.Core.Modules;
    using Kalk.Core;

    public partial class AesIntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class AllModuleTests : KalkTestBase
    {
    }

    public partial class Avx2IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class AvxIntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Bmi1IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Bmi1X64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Bmi2IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Bmi2X64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class CsvModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.CsvModule.ParseCsv(System.String,System.Boolean)"/> or `parse_csv`.
        /// </summary>
        [TestCase(@"items = parse_csv(""a,b,c\n1,2,3\n4,5,6\n"")
items[0].a
items[0].b
items[0].c", @"# items = parse_csv(""a,b,c\n1,2,3\n4,5,6\n"")
items = [[1, 2, 3], [4, 5, 6]]
# items[0].a
out = 1
# items[0].b
out = 2
# items[0].c
out = 3", Category = "Text Functions")]
        public static void Test_parse_csv(string input, string output) => AssertScript(input, output, "Csv");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.CsvModule.LoadCsv(System.String,System.Boolean)"/> or `load_csv`.
        /// </summary>
        [TestCase(@"items = load_csv(""test.csv"")
items[0].a
items[1].a
items[1].c", @"# items = load_csv(""test.csv"")
items = [[1, 2, 3], [4, 5, 6]]
# items[0].a
out = 1
# items[1].a
out = 4
# items[1].c
out = 6", Category = "Misc File Functions")]
        public static void Test_load_csv(string input, string output) => AssertScript(input, output, "Csv");

    }

    public partial class CurrencyModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="P:Kalk.Core.Modules.CurrencyModule.Currencies"/> or `currencies`.
        /// </summary>
        [TestCase(@"currencies", @"# Builtin Currencies (Last Update: 08 May 2020)
currency(AUD, 1.6613);      # 1.6613   AUD => 1 EUR
currency(BGN, 1.9558);      # 1.9558   BGN => 1 EUR
currency(BRL, 6.3074);      # 6.3074   BRL => 1 EUR
currency(CAD, 1.5118);      # 1.5118   CAD => 1 EUR
currency(CHF, 1.0529);      # 1.0529   CHF => 1 EUR
currency(CNY, 7.6719);      # 7.6719   CNY => 1 EUR
currency(CZK, 27.251);      # 27.251   CZK => 1 EUR
currency(DKK, 7.4598);      # 7.4598   DKK => 1 EUR
currency(EUR);              # Base currency
currency(GBP, 0.8754);      # 0.8754   GBP => 1 EUR
currency(HKD, 8.4052);      # 8.4052   HKD => 1 EUR
currency(HRK, 7.5573);      # 7.5573   HRK => 1 EUR
currency(HUF, 349.38);      # 349.38   HUF => 1 EUR
currency(IDR, 16229.26);    # 16229.26 IDR => 1 EUR
currency(ILS, 3.8031);      # 3.8031   ILS => 1 EUR
currency(INR, 81.9615);     # 81.9615  INR => 1 EUR
currency(ISK, 158.5);       # 158.5    ISK => 1 EUR
currency(JPY, 115.34);      # 115.34   JPY => 1 EUR
currency(KRW, 1322.41);     # 1322.41  KRW => 1 EUR
currency(MXN, 25.9023);     # 25.9023  MXN => 1 EUR
currency(MYR, 4.6994);      # 4.6994   MYR => 1 EUR
currency(NOK, 11.0695);     # 11.0695  NOK => 1 EUR
currency(NZD, 1.7668);      # 1.7668   NZD => 1 EUR
currency(PHP, 54.681);      # 54.681   PHP => 1 EUR
currency(PLN, 4.5482);      # 4.5482   PLN => 1 EUR
currency(RON, 4.828);       # 4.828    RON => 1 EUR
currency(RUB, 79.8383);     # 79.8383  RUB => 1 EUR
currency(SEK, 10.5875);     # 10.5875  SEK => 1 EUR
currency(SGD, 1.5326);      # 1.5326   SGD => 1 EUR
currency(THB, 34.958);      # 34.958   THB => 1 EUR
currency(TRY, 7.7252);      # 7.7252   TRY => 1 EUR
currency(USD, 1.0843);      # 1.0843   USD => 1 EUR
currency(ZAR, 19.997);      # 19.997   ZAR => 1 EUR", Category = "Unit Functions")]
        public static void Test_currencies(string input, string output) => AssertScript(input, output, "Currencies");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.CurrencyModule.Currency(Scriban.Syntax.ScriptVariable,System.Nullable{System.Decimal})"/> or `currency`.
        /// </summary>
        [TestCase(@"USD
2 USD
currency(GBP) # Defines GBP as the default currency instead of EUR
USD
2 USD |> to EUR # Convert 2 dollars to EUR", @"currency(USD, 1.0843);      # 1.0843   USD => 1 EUR
# 2 * USD
out = 1.8445079774970026745365673706 * EUR
# currency(GBP) # Defines GBP as the default currency instead of EUR
out = GBP
currency(USD, 1.2387);      # 1.2387   USD => 1 GBP
# 2 * USD |> to(EUR) # Convert 2 dollars to EUR
out = 1.844507977497004 * EUR", Category = "Unit Functions")]
        public static void Test_currency(string input, string output) => AssertScript(input, output, "Currencies");

    }

    public partial class FileModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.CurrentDirectory"/> or `pwd`.
        /// </summary>
        [TestCase(@"pwd", @"# pwd
out = ""/code/kalk/tests""", Category = "Misc File Functions")]
        public static void Test_pwd(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.ChangeDirectory(System.String)"/> or `cd`.
        /// </summary>
        [TestCase(@"cd
mkdir ""testdir""
cd ""testdir""
cd ""..""
rmdir ""testdir""
dir_exists ""testdir""", @"# cd
out = ""/code/kalk/tests""
# cd(""testdir"")
out = ""/code/kalk/tests/testdir""
# cd("".."")
out = ""/code/kalk/tests""
# dir_exists(""testdir"")
out = false", Category = "Misc File Functions")]
        public static void Test_cd(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.FileExists(System.String)"/> or `file_exists`.
        /// </summary>
        [TestCase(@"rm ""test.txt""
file_exists ""test.txt""
save_text(""content"", ""test.txt"")
file_exists ""test.txt""", @"# file_exists(""test.txt"")
out = false
# file_exists(""test.txt"")
out = true", Category = "Misc File Functions")]
        public static void Test_file_exists(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.DirectoryExists(System.String)"/> or `dir_exists`.
        /// </summary>
        [TestCase(@"mkdir ""testdir""
dir_exists ""testdir""
rmdir ""testdir""
dir_exists ""testdir""", @"# dir_exists(""testdir"")
out = true
# dir_exists(""testdir"")
out = false", Category = "Misc File Functions")]
        public static void Test_dir_exists(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.DirectoryListing(System.String,System.Boolean)"/> or `dir`.
        /// </summary>
        [TestCase(@"mkdir ""testdir""
cd ""testdir""
mkdir ""subdir""
save_text(""content"", ""file.txt"")
dir "".""
save_text(""content"", ""subdir/file2.txt"")
dir(""."", true)
cd ""..""
rmdir(""testdir"", true)", @"# cd(""testdir"")
out = ""/code/kalk/tests/testdir""
# dir(""."")
out = [""./file.txt"", ""./subdir""]
# dir(""."", true)
out = [""./file.txt"", ""./subdir"", ""./subdir/file2.txt""]
# cd("".."")
out = ""/code/kalk/tests""", Category = "Misc File Functions")]
        public static void Test_dir(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.RemoveFile(System.String)"/> or `rm`.
        /// </summary>
        [TestCase(@"rm ""test.txt""
file_exists ""test.txt""
save_text(""content"", ""test.txt"")
file_exists ""test.txt""", @"# file_exists(""test.txt"")
out = false
# file_exists(""test.txt"")
out = true", Category = "Misc File Functions")]
        public static void Test_rm(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.CreateDirectory(System.String)"/> or `mkdir`.
        /// </summary>
        [TestCase(@"mkdir ""testdir""
dir_exists ""testdir""
rmdir ""testdir""
dir_exists ""testdir""", @"# dir_exists(""testdir"")
out = true
# dir_exists(""testdir"")
out = false", Category = "Misc File Functions")]
        public static void Test_mkdir(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.RemoveDirectory(System.String,System.Boolean)"/> or `rmdir`.
        /// </summary>
        [TestCase(@"mkdir ""testdir""
dir_exists ""testdir""
rmdir ""testdir""
dir_exists ""testdir""", @"# dir_exists(""testdir"")
out = true
# dir_exists(""testdir"")
out = false", Category = "Misc File Functions")]
        public static void Test_rmdir(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.LoadText(System.String,System.String)"/> or `load_text`.
        /// </summary>
        [TestCase(@"load_text ""test.csv""", @"# load_text(""test.csv"")
out = ""a,b,c\n1,2,3\n4,5,6""", Category = "Misc File Functions")]
        public static void Test_load_text(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.LoadBytes(System.String)"/> or `load_bytes`.
        /// </summary>
        [TestCase(@"load_bytes ""test.csv""
ascii out", @"# load_bytes(""test.csv"")
out = bytebuffer([97, 44, 98, 44, 99, 10, 49, 44, 50, 44, 51, 10, 52, 44, 53, 44, 54])
# ascii(out)
out = ""a,b,c\n1,2,3\n4,5,6""", Category = "Misc File Functions")]
        public static void Test_load_bytes(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.LoadLines(System.String,System.String)"/> or `load_lines`.
        /// </summary>
        [TestCase(@"load_lines ""test.csv""", @"# load_lines(""test.csv"")
out = [""a,b,c"", ""1,2,3"", ""4,5,6""]", Category = "Misc File Functions")]
        public static void Test_load_lines(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.SaveLines(System.Collections.IEnumerable,System.String,System.String)"/> or `save_lines`.
        /// </summary>
        [TestCase(@"save_lines(1..10, ""lines.txt"")
load_lines(""lines.txt"")", @"# load_lines(""lines.txt"")
out = [""1"", ""2"", ""3"", ""4"", ""5"", ""6"", ""7"", ""8"", ""9"", ""10""]", Category = "Misc File Functions")]
        public static void Test_save_lines(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.SaveText(System.String,System.String,System.String)"/> or `save_text`.
        /// </summary>
        [TestCase(@"save_text(""Hello World!"", ""test.txt"")
load_text(""test.txt"")", @"# load_text(""test.txt"")
out = ""Hello World!""", Category = "Misc File Functions")]
        public static void Test_save_text(string input, string output) => AssertScript(input, output, "Files");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.FileModule.SaveBytes(System.Collections.IEnumerable,System.String)"/> or `save_bytes`.
        /// </summary>
        [TestCase(@"utf8(""Hello World!"")
save_bytes(out, ""test.bin"")
load_bytes(""test.bin"")
utf8(out)", @"# utf8(""Hello World!"")
out = bytebuffer([72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 33])
# load_bytes(""test.bin"")
out = bytebuffer([72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 33])
# utf8(out)
out = ""Hello World!""", Category = "Misc File Functions")]
        public static void Test_save_bytes(string input, string output) => AssertScript(input, output, "Files");

    }

    public partial class HardwareIntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class KalkEngineTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="P:Kalk.Core.KalkEngine.Config"/> or `config`.
        /// </summary>
        [TestCase(@"config", @"# config
out = {help_max_column: 100, limit_to_string: ""auto""}", Category = "General")]
        public static void Test_config(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="P:Kalk.Core.KalkEngine.Aliases"/> or `aliases`.
        /// </summary>
        [TestCase(@"aliases", @"# Builtin Aliases
alias(alpha, Α, α)
alias(beta, Β, β)
alias(chi, Χ, χ)
alias(delta, Δ, δ)
alias(epsilon, Ε, ε)
alias(eta, Η, η)
alias(gamma, Γ, γ)
alias(iota, Ι, ι)
alias(kappa, Κ, κ)
alias(lambda, Λ, λ)
alias(mu, Μ, μ)
alias(nu, Ν, ν)
alias(omega, Ω, ω)
alias(omicron, Ο, ο)
alias(phi, Φ, φ, ϕ)
alias(pi, Π, π)
alias(psi, Ψ, ψ)
alias(rho, Ρ, ρ)
alias(sigma, Σ, σ)
alias(tau, Τ, τ)
alias(theta, Θ, θ, ϑ)
alias(upsilon, Υ, υ)
alias(xi, Ξ, ξ)
alias(zeta, Ζ, ζ)", Category = "General")]
        public static void Test_aliases(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="P:Kalk.Core.KalkEngine.Shortcuts"/> or `shortcuts`.
        /// </summary>
        [TestCase(@"clear shortcuts
shortcut(tester, ""ctrl+d"", '""' + date + '""')
shortcuts", @"# User-defined Shortcuts
shortcut(tester, ""ctrl+d"", '""' + date + '""')                 # ctrl+d => '""' + date + '""'", Category = "General")]
        public static void Test_shortcuts(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Action(System.String)"/> or `action`.
        /// </summary>
        [TestCase(@"shortcut(cursor_left, ""left, ctrl+b"", action(""cursor_left""))", @"", Category = "General")]
        public static void Test_action(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Clipboard(System.Object)"/> or `clipboard`.
        /// </summary>
        [TestCase(@"clipboard ""text""
clipboard", @"# clipboard(""text"")
out = ""text""
# clipboard
out = ""text""", Category = "General")]
        public static void Test_clipboard(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Display(Scriban.Syntax.ScriptVariable)"/> or `display`.
        /// </summary>
        [TestCase(@"display
display dev
1.5
display invalid", @"# Display mode: std (Standard)
# Display mode: dev (Developer)
# 1.5
out = 1.5
    # IEEE 754 - double - 64-bit
    #
    = 0x_3FF80000_00000000
    = 0x____3____F____F____8____0____0____0____0____0____0____0____0____0____0____0____0
    #    seee eeee eeee ffff ffff ffff ffff ffff ffff ffff ffff ffff ffff ffff ffff ffff
    = 0b_0011_1111_1111_1000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000
    #   63                48                  32                  16                   0
    #
    # sign    exponent              |-------------------- fraction --------------------|
    =   1 * 2 ^ (1023 - 1023) * 0b1.1000000000000000000000000000000000000000000000000000
Invalid display name `invalid`. Expecting `std`, `dev` or `eng`. (Parameter 'name')", Category = "General")]
        public static void Test_display(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Echo(Scriban.Syntax.ScriptVariable)"/> or `echo`.
        /// </summary>
        [TestCase(@"echo
1 + 2
echo off
1 + 2
echo
echo on
1 + 2", @"# Echo is on.
# 1 + 2
out = 3
# Echo is on.
# 1 + 2
out = 3", Category = "General")]
        public static void Test_echo(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Print(System.Object)"/> or `print`.
        /// </summary>
        [TestCase(@"print ""kalk""
echo off
print ""kalk2""", @"kalk
kalk2", Category = "General")]
        public static void Test_print(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.PrintFormatted(System.Object)"/> or `printf`.
        /// </summary>
        [TestCase(@"x = 1; y = ""yes""
printf ""Hello {{x}} World and {{y}}""", @"# x = 1; y = ""yes""
x = 1
y = ""yes""
Hello 1 World and yes", Category = "General")]
        public static void Test_printf(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.StringPrintFormatted(System.Object)"/> or `sprintf`.
        /// </summary>
        [TestCase(@"x = 1; y = ""yes""
sprintf ""Hello {{x}} World and {{y}}""", @"# x = 1; y = ""yes""
x = 1
y = ""yes""
# sprintf(""Hello {{x}} World and {{y}}"")
out = ""Hello 1 World and yes""", Category = "General")]
        public static void Test_sprintf(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Printh(System.Object)"/> or `printh`.
        /// </summary>
        [TestCase(@"printh ""# This is a kalk comment""", @"# This is a kalk comment", Category = "General")]
        public static void Test_printh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Help(Scriban.Syntax.ScriptExpression)"/> or `help`.
        /// </summary>
        [TestCase(@"help cls", @"# cls
#
#   Clears the screen.
#
# Example
.   >>> cls", Category = "General")]
        public static void Test_help(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Reset"/> or `reset`.
        /// </summary>
        [TestCase(@"x = 5; y = 2
list
reset
list", @"# x = 5; y = 2
x = 5
y = 2
# Variables
x = 5
y = 2
# No variables", Category = "General")]
        public static void Test_reset(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.ShowVersion"/> or `version`.
        /// </summary>
        [TestCase(@"version", @"kalk 1.0.0 - Copyright (c) 2020 Alexandre Mutel", Category = "General")]
        public static void Test_version(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.List"/> or `list`.
        /// </summary>
        [TestCase(@"x = 5; y = 2; f(x) = x + 5
list", @"# x = 5; y = 2; f(x) = x + 5
x = 5
y = 2
 f(x) = x + 5
# Variables
x = 5
y = 2
# Functions
 f(x) = x + 5", Category = "General")]
        public static void Test_list(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.DeleteVariable(Scriban.Syntax.ScriptVariable)"/> or `del`.
        /// </summary>
        [TestCase(@"x = 5; y = 2
del x
list
del y
f(x) = x + 5
list
del f
list", @"# x = 5; y = 2
x = 5
y = 2
# Variable `x == 5` deleted.
# Variables
y = 2
# Variable `y == 2` deleted.
# f(x) = x + 5
f(x) = x + 5
# Functions
f(x) = x + 5
# Function `f(x) = x + 5` deleted.
# No variables", Category = "General")]
        public static void Test_del(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Exit"/> or `exit`.
        /// </summary>
        [TestCase(@"exit", @"", Category = "General")]
        public static void Test_exit(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.History(System.Object)"/> or `history`.
        /// </summary>
        [TestCase(@"1 + 5
abs(out)
history", @"# 1 + 5
out = 6
# abs(out)
out = 6
0: 1 + 5
1: abs(out)", Category = "General")]
        public static void Test_history(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.EvaluateText(System.String,System.Boolean)"/> or `eval`.
        /// </summary>
        [TestCase(@"eval ""1+5""
eval ""eval '1+5'""", @"# eval(""1+5"")
out = 6
# eval(""eval '1+5'"")
out = 6", Category = "General")]
        public static void Test_eval(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.LoadFile(System.String,System.Boolean)"/> or `load`.
        /// </summary>
        [TestCase(@"import Files
save_text(""x = 1\ny = 2\nx + y"", ""test.kalk"")
load ""test.kalk""", @"# 14 functions successfully imported from module `Files`.
# load(""test.kalk"")
x = 1
y = 2
out = 3", Category = "General")]
        public static void Test_load(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Clear(Scriban.Syntax.ScriptExpression)"/> or `clear`.
        /// </summary>
        [TestCase(@"1 + 2
history
clear history
history", @"# 1 + 2
out = 3
0: 1 + 2
# History empty", Category = "General")]
        public static void Test_clear(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Cls"/> or `cls`.
        /// </summary>
        [TestCase(@"cls", @"", Category = "General")]
        public static void Test_cls(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Last"/> or `out`.
        /// </summary>
        [TestCase(@"1 + 2
out + 1", @"# 1 + 2
out = 3
# out + 1
out = 4", Category = "General")]
        public static void Test_out(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.LastToClipboard"/> or `out2clipboard`.
        /// </summary>
        [TestCase(@"1 + 2
out2clipboard
clipboard", @"# 1 + 2
out = 3
# clipboard
out = ""3""", Category = "General")]
        public static void Test_out2clipboard(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Shortcut(Scriban.Syntax.ScriptVariable,Scriban.Syntax.ScriptExpression[])"/> or `shortcut`.
        /// </summary>
        [TestCase(@"# Creates a shortcut that will print 3 when pressing ctrl+R.
shortcut(myshortcut, ""ctrl+g"", 1 + 2)
# Overrides the previous shortcut that will print the text
# `kalk` when pressing ctrl+g.
shortcut(myshortcut, ""ctrl+g"", ""kalk"")
# Overrides the previous shortcut that will print the text
# `kalk` when pressing ctrl+g or the text `kalk2` when pressing
# ctrl+e and r key.
shortcut(myshortcut, ""ctrl+g"", ""kalk"", ""ctrl+e r"", ""kalk2"")
# Remove the previous defined shortcuts
shortcut(myshortcut)", @"", Category = "General")]
        public static void Test_shortcut(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Alias(Scriban.Syntax.ScriptVariable,Scriban.Syntax.ScriptVariable[])"/> or `alias`.
        /// </summary>
        [TestCase(@"alias(var1, var2, var3)
var1 = 2
var2
var3
list
var2 = 1
list", @"# var1 = 2
var1 = 2
# var2
out = 2
# var3
out = 2
# Variables
var1 = 2
# var2 = 1
var2 = 1
# Variables
var1 = 1", Category = "General")]
        public static void Test_alias(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.Kind(System.Object)"/> or `kind`.
        /// </summary>
        [TestCase(@"kind 1
kind ""a""
kind byte (1)
kind []
kind {}", @"# kind(1)
out = ""int""
# kind(""a"")
out = ""string""
# kind(byte(1))
out = ""byte""
# kind([])
out = ""array""
# kind({})
out = ""object""", Category = "General")]
        public static void Test_kind(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="P:Kalk.Core.KalkEngine.Units"/> or `units`.
        /// </summary>
        [TestCase(@"unit(tomato, ""A tomato unit"", prefix: ""decimal"")
unit(ketchup, ""A ketchup unit"", kup, 5 tomato, prefix: ""decimal"")
units", @"# unit(tomato, ""A tomato unit"", prefix: ""decimal"")
out = tomato
# unit(ketchup, ""A ketchup unit"", kup, 5 * tomato, prefix: ""decimal"")
out = kup
# User Defined Units
unit(ketchup, ""A ketchup unit"", kup, 5 * tomato, prefix: ""decimal"")
  - yottaketchup/Ykup, zettaketchup/Zkup, exaketchup/Ekup, petaketchup/Pkup, teraketchup/Tkup,
    gigaketchup/Gkup, megaketchup/Mkup, kiloketchup/kkup, hectoketchup/hkup, decaketchup/dakup,
    deciketchup/dkup, centiketchup/ckup, milliketchup/mkup, microketchup/µkup, nanoketchup/nkup,
    picoketchup/pkup, femtoketchup/fkup, attoketchup/akup, zeptoketchup/zkup, yoctoketchup/ykup

unit(tomato, ""A tomato unit"", tomato, prefix: ""decimal"")
  - yottatomato/Ytomato, zettatomato/Ztomato, exatomato/Etomato, petatomato/Ptomato,
    teratomato/Ttomato, gigatomato/Gtomato, megatomato/Mtomato, kilotomato/ktomato,
    hectotomato/htomato, decatomato/datomato, decitomato/dtomato, centitomato/ctomato,
    millitomato/mtomato, microtomato/µtomato, nanotomato/ntomato, picotomato/ptomato,
    femtotomato/ftomato, attotomato/atomato, zeptotomato/ztomato, yoctotomato/ytomato", Category = "Unit Functions")]
        public static void Test_units(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.ConvertTo(Kalk.Core.KalkExpression,Kalk.Core.KalkExpression)"/> or `to`.
        /// </summary>
        [TestCase(@"import StandardUnits
10 kg/s |> to kg/h
50 kg/m |> to g/km", @"# 1294 units successfully imported from module `StandardUnits`.
# ((10 * kg) / s) |> to(kg / h)
out = 36000 * kg / h
# ((50 * kg) / m) |> to(g / km)
out = 50000000 * g / km", Category = "Unit Functions")]
        public static void Test_to(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.KalkEngine.DefineUserUnit(Scriban.Syntax.ScriptVariable,System.String,Scriban.Syntax.ScriptVariable,Kalk.Core.KalkExpression,System.String,System.String)"/> or `unit`.
        /// </summary>
        [TestCase(@"unit(tomato, ""A tomato unit"", prefix: ""decimal"")
unit(ketchup, ""A ketchup unit"", kup, 5 tomato, prefix: ""decimal"")
4 kup
tomato
ketchup", @"# unit(tomato, ""A tomato unit"", prefix: ""decimal"")
out = tomato
# unit(ketchup, ""A ketchup unit"", kup, 5 * tomato, prefix: ""decimal"")
out = kup
# 4 * kup
out = 20 * tomato
unit(tomato, ""A tomato unit"", tomato, prefix: ""decimal"")
  - yottatomato/Ytomato, zettatomato/Ztomato, exatomato/Etomato, petatomato/Ptomato,
    teratomato/Ttomato, gigatomato/Gtomato, megatomato/Mtomato, kilotomato/ktomato,
    hectotomato/htomato, decatomato/datomato, decitomato/dtomato, centitomato/ctomato,
    millitomato/mtomato, microtomato/µtomato, nanotomato/ntomato, picotomato/ptomato,
    femtotomato/ftomato, attotomato/atomato, zeptotomato/ztomato, yoctotomato/ytomato
unit(ketchup, ""A ketchup unit"", kup, 5 * tomato, prefix: ""decimal"")
  - yottaketchup/Ykup, zettaketchup/Zkup, exaketchup/Ekup, petaketchup/Pkup, teraketchup/Tkup,
    gigaketchup/Gkup, megaketchup/Mkup, kiloketchup/kkup, hectoketchup/hkup, decaketchup/dakup,
    deciketchup/dkup, centiketchup/ckup, milliketchup/mkup, microketchup/µkup, nanoketchup/nkup,
    picoketchup/pkup, femtoketchup/fkup, attoketchup/akup, zeptoketchup/zkup, yoctoketchup/ykup", Category = "Unit Functions")]
        public static void Test_unit(string input, string output) => AssertScript(input, output);

    }

    public partial class MathModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="F:Kalk.Core.MathModule.Nan"/> or `nan`.
        /// </summary>
        [TestCase(@"nan", @"# nan
out = nan", Category = "Math Functions")]
        public static void Test_nan(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="F:Kalk.Core.MathModule.Inf"/> or `inf`.
        /// </summary>
        [TestCase(@"inf", @"# inf
out = inf", Category = "Math Functions")]
        public static void Test_inf(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="F:Kalk.Core.MathModule.Pi"/> or `pi`.
        /// </summary>
        [TestCase(@"pi", @"# pi
out = 3.141592653589793", Category = "Math Functions")]
        public static void Test_pi(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="F:Kalk.Core.MathModule.E"/> or `e`.
        /// </summary>
        [TestCase(@"e", @"# e
out = 2.718281828459045", Category = "Math Functions")]
        public static void Test_e(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Fib(Kalk.Core.KalkIntValue)"/> or `fib`.
        /// </summary>
        [TestCase(@"fib 50", @"# fib(50)
out = 12586269025", Category = "Math Functions")]
        public static void Test_fib(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.ComplexNumber"/> or `i`.
        /// </summary>
        [TestCase(@"1 + 2i", @"# 1 + 2 * i
out = 1 + 2i", Category = "Math Functions")]
        public static void Test_i(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.All(System.Object)"/> or `all`.
        /// </summary>
        [TestCase(@"all(bool4(true, false, true, false))
all(bool4(true, true, true, true))
all([0,1,0,2])
all([1,1,1,1])", @"# all(bool4(true, false, true, false))
out = false
# all(bool4(true, true, true, true))
out = true
# all([0,1,0,2])
out = false
# all([1,1,1,1])
out = true", Category = "Math Functions")]
        public static void Test_all(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Any(System.Object)"/> or `any`.
        /// </summary>
        [TestCase(@"any(bool4(true, false, true, false))
any(bool4(false, false, false, false))
any([0,1,0,2])
any([0,0,0,0])", @"# any(bool4(true, false, true, false))
out = true
# any(bool4(false, false, false, false))
out = false
# any([0,1,0,2])
out = true
# any([0,0,0,0])
out = false", Category = "Math Functions")]
        public static void Test_any(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Abs(Kalk.Core.KalkCompositeValue)"/> or `abs`.
        /// </summary>
        [TestCase(@"abs(-1)
abs(float4(-1, 1, -2, -3))", @"# abs(-1)
out = 1
# abs(float4(-1, 1, -2, -3))
out = float4(1, 1, 2, 3)", Category = "Math Functions")]
        public static void Test_abs(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Rnd(Kalk.Core.KalkCompositeValue)"/> or `rnd`.
        /// </summary>
        [TestCase(@"seed(0); rnd
rnd
rnd(float4)", @"# seed(0); rnd
out = 0.7262432699679598
# rnd
out = 0.8173253595909687
# rnd(float4)
out = float4(0.7680227, 0.5581612, 0.20603316, 0.5588848)", Category = "Math Functions")]
        public static void Test_rnd(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Seed(System.Nullable{System.Int32})"/> or `seed`.
        /// </summary>
        [TestCase(@"seed(0); rnd
seed(1); rnd", @"# seed(0); rnd
out = 0.7262432699679598
# seed(1); rnd
out = 0.24866858415709278", Category = "Math Functions")]
        public static void Test_seed(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Modf(Kalk.Core.KalkCompositeValue)"/> or `modf`.
        /// </summary>
        [TestCase(@"modf(1.5)
modf(float2(-1.2, 3.4))", @"# modf(1.5)
out = [1, 0.5]
# modf(float2(-1.2, 3.4))
out = [float2(-1, 3), float2(-0.20000005, 0.4000001)]", Category = "Math Functions")]
        public static void Test_modf(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Radians(Kalk.Core.KalkCompositeValue)"/> or `radians`.
        /// </summary>
        [TestCase(@"radians(90)
radians(180)", @"# radians(90)
out = 1.5707963267948966
# radians(180)
out = 3.141592653589793", Category = "Math Functions")]
        public static void Test_radians(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Degrees(Kalk.Core.KalkCompositeValue)"/> or `degrees`.
        /// </summary>
        [TestCase(@"degrees(pi/2)
degrees(pi)", @"# degrees(pi / 2)
out = 90
# degrees(pi)
out = 180", Category = "Math Functions")]
        public static void Test_degrees(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Sign(Kalk.Core.KalkCompositeValue)"/> or `sign`.
        /// </summary>
        [TestCase(@"sign(-5); sign(0); sign(2.3)
sign float4(-1, 2, 0, 1.5)", @"# sign(-5); sign(0); sign(2.3)
out = -1
out = 0
out = 1
# sign(float4(-1, 2, 0, 1.5))
out = float4(-1, 1, 0, 1)", Category = "Math Functions")]
        public static void Test_sign(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Cos(Kalk.Core.KalkDoubleValue)"/> or `cos`.
        /// </summary>
        [TestCase(@"cos 0.5
cos float4(pi, pi/2, 0, 0.5)", @"# cos(0.5)
out = 0.8775825618903728
# cos(float4(pi, pi / 2, 0, 0.5))
out = float4(-1, -4.371139E-08, 1, 0.87758255)", Category = "Math Functions")]
        public static void Test_cos(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Acos(Kalk.Core.KalkDoubleValue)"/> or `acos`.
        /// </summary>
        [TestCase(@"acos(-1)
acos(0)
acos(1)
acos(float4(-1,0,1,0.5))", @"# acos(-1)
out = 3.141592653589793
# acos(0)
out = 1.5707963267948966
# acos(1)
out = 0
# acos(float4(-1, 0, 1, 0.5))
out = float4(3.1415927, 1.5707964, 0, 1.0471976)", Category = "Math Functions")]
        public static void Test_acos(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Cosh(Kalk.Core.KalkDoubleValue)"/> or `cosh`.
        /// </summary>
        [TestCase(@"cosh(-1)
cosh(1)
cosh(0)
cosh(float4(-1, 1, 0, 2))", @"# cosh(-1)
out = 1.5430806348152437
# cosh(1)
out = 1.5430806348152437
# cosh(0)
out = 1
# cosh(float4(-1, 1, 0, 2))
out = float4(1.5430807, 1.5430807, 1, 3.7621956)", Category = "Math Functions")]
        public static void Test_cosh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Acosh(Kalk.Core.KalkDoubleValue)"/> or `acosh`.
        /// </summary>
        [TestCase(@"acosh(1)
acosh(10)
acosh(float4(1,2,4,10))", @"# acosh(1)
out = 0
# acosh(10)
out = 2.993222846126381
# acosh(float4(1, 2, 4, 10))
out = float4(0, 1.316958, 2.063437, 2.993223)", Category = "Math Functions")]
        public static void Test_acosh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Sin(Kalk.Core.KalkDoubleValue)"/> or `sin`.
        /// </summary>
        [TestCase(@"sin 0.5
sin float4(pi, pi/2, 0, 0.5)", @"# sin(0.5)
out = 0.479425538604203
# sin(float4(pi, pi / 2, 0, 0.5))
out = float4(-8.742278E-08, 1, 0, 0.47942555)", Category = "Math Functions")]
        public static void Test_sin(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Asin(Kalk.Core.KalkDoubleValue)"/> or `asin`.
        /// </summary>
        [TestCase(@"asin 0.5
asin float4(-1, 0, 1, 0.5)", @"# asin(0.5)
out = 0.5235987755982989
# asin(float4(-1, 0, 1, 0.5))
out = float4(-1.5707964, 0, 1.5707964, 0.5235988)", Category = "Math Functions")]
        public static void Test_asin(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Sinh(Kalk.Core.KalkDoubleValue)"/> or `sinh`.
        /// </summary>
        [TestCase(@"sinh(-1)
sinh(0)
sinh(1)
sinh(float4(-1, 1, 0, 2))", @"# sinh(-1)
out = -1.1752011936438014
# sinh(0)
out = 0
# sinh(1)
out = 1.1752011936438014
# sinh(float4(-1, 1, 0, 2))
out = float4(-1.1752012, 1.1752012, 0, 3.6268604)", Category = "Math Functions")]
        public static void Test_sinh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Asinh(Kalk.Core.KalkDoubleValue)"/> or `asinh`.
        /// </summary>
        [TestCase(@"asinh(-1.1752011936438014)
asinh(0)
asinh(1.1752011936438014)
asinh(float4(-1.1752011936438014, 0, 1.1752011936438014, 2))", @"# asinh(-1.1752011936438014)
out = -1
# asinh(0)
out = 0
# asinh(1.1752011936438014)
out = 1
# asinh(float4(-1.1752011936438014, 0, 1.1752011936438014, 2))
out = float4(-1, 0, 1, 1.4436355)", Category = "Math Functions")]
        public static void Test_asinh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Tan(Kalk.Core.KalkDoubleValue)"/> or `tan`.
        /// </summary>
        [TestCase(@"tan(0.5)
tan(1)
tan float4(1, 2, 3, 4)", @"# tan(0.5)
out = 0.5463024898437905
# tan(1)
out = 1.5574077246549023
# tan(float4(1, 2, 3, 4))
out = float4(1.5574077, -2.1850398, -0.14254655, 1.1578213)", Category = "Math Functions")]
        public static void Test_tan(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Atan(Kalk.Core.KalkDoubleValue)"/> or `atan`.
        /// </summary>
        [TestCase(@"atan(0.5)
atan(1)
atan(0)
atan(float4(0,1,2,3))", @"# atan(0.5)
out = 0.4636476090008061
# atan(1)
out = 0.7853981633974483
# atan(0)
out = 0
# atan(float4(0, 1, 2, 3))
out = float4(0, 0.7853982, 1.1071488, 1.2490457)", Category = "Math Functions")]
        public static void Test_atan(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Tanh(Kalk.Core.KalkDoubleValue)"/> or `tanh`.
        /// </summary>
        [TestCase(@"tanh(0)
tanh(1)
tanh(2)
tanh(float4(0, 1, 2, 3))", @"# tanh(0)
out = 0
# tanh(1)
out = 0.7615941559557649
# tanh(2)
out = 0.9640275800758169
# tanh(float4(0, 1, 2, 3))
out = float4(0, 0.7615942, 0.9640276, 0.9950548)", Category = "Math Functions")]
        public static void Test_tanh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Atanh(Kalk.Core.KalkDoubleValue)"/> or `atanh`.
        /// </summary>
        [TestCase(@"atanh(0)
atanh(0.5)
atanh(float4(-0.5, 0, 0.5, 0.8))", @"# atanh(0)
out = 0
# atanh(0.5)
out = 0.5493061443340549
# atanh(float4(-0.5, 0, 0.5, 0.8))
out = float4(-0.54930615, 0, 0.54930615, 1.0986123)", Category = "Math Functions")]
        public static void Test_atanh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Atan2(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `atan2`.
        /// </summary>
        [TestCase(@"atan2(1,1)
atan2(1,0)
atan2(0,1)
atan2(float4(1), float4(0,1,-1,2))", @"# atan2(1, 1)
out = 0.7853981633974483
# atan2(1, 0)
out = 1.5707963267948966
# atan2(0, 1)
out = 0
# atan2(float4(1), float4(0, 1, -1, 2))
out = float4(1.5707964, 0.7853982, 2.3561945, 0.4636476)", Category = "Math Functions")]
        public static void Test_atan2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Fmod(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `fmod`.
        /// </summary>
        [TestCase(@"fmod(2.5, 2)
fmod(2.5, 3)
fmod(-1.5, 1)
fmod(float4(1.5, 1.2, -2.3, -4.6), 0.2)", @"# fmod(2.5, 2)
out = 0.5
# fmod(2.5, 3)
out = 2.5
# fmod(-1.5, 1)
out = -0.5
# fmod(float4(1.5, 1.2, -2.3, -4.6), 0.2)
out = float4(0.09999998, 2.9802322E-08, -0.09999992, -0.19999984)", Category = "Math Functions")]
        public static void Test_fmod(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Frac(Kalk.Core.KalkDoubleValue)"/> or `frac`.
        /// </summary>
        [TestCase(@"frac(1.25)
frac(10.5)
frac(-1.75)
frac(-10.25)
frac(float4(1.25, 10.5, -1.75, -10.25))", @"# frac(1.25)
out = 0.25
# frac(10.5)
out = 0.5
# frac(-1.75)
out = 0.25
# frac(-10.25)
out = 0.75
# frac(float4(1.25, 10.5, -1.75, -10.25))
out = float4(0.25, 0.5, 0.25, 0.75)", Category = "Math Functions")]
        public static void Test_frac(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Rsqrt(Kalk.Core.KalkDoubleValue)"/> or `rsqrt`.
        /// </summary>
        [TestCase(@"rsqrt(1)
rsqrt(2)
rsqrt(float4(1,2,3,4))", @"# rsqrt(1)
out = 1
# rsqrt(2)
out = 0.7071067811865475
# rsqrt(float4(1, 2, 3, 4))
out = float4(1, 0.70710677, 0.57735026, 0.5)", Category = "Math Functions")]
        public static void Test_rsqrt(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Sqrt(Kalk.Core.KalkDoubleValue)"/> or `sqrt`.
        /// </summary>
        [TestCase(@"sqrt(1)
sqrt(2)
sqrt(float4(1,2,3,4))", @"# sqrt(1)
out = 1
# sqrt(2)
out = 1.4142135623730951
# sqrt(float4(1, 2, 3, 4))
out = float4(1, 1.4142135, 1.7320508, 2)", Category = "Math Functions")]
        public static void Test_sqrt(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Log(Kalk.Core.KalkDoubleValue)"/> or `log`.
        /// </summary>
        [TestCase(@"log 1
log 2
log 0
log float4(0,1,2,3)", @"# log(1)
out = 0
# log(2)
out = 0.6931471805599453
# log(0)
out = -inf
# log(float4(0, 1, 2, 3))
out = float4(-inf, 0, 0.6931472, 1.0986123)", Category = "Math Functions")]
        public static void Test_log(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Log2(Kalk.Core.KalkDoubleValue)"/> or `log2`.
        /// </summary>
        [TestCase(@"log2 0
log2 8
log2 129
log2 float4(0, 2, 16, 257)", @"# log2(0)
out = -inf
# log2(8)
out = 3
# log2(129)
out = 7.011227255423254
# log2(float4(0, 2, 16, 257))
out = float4(-inf, 1, 4, 8.005625)", Category = "Math Functions")]
        public static void Test_log2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Log10(Kalk.Core.KalkDoubleValue)"/> or `log10`.
        /// </summary>
        [TestCase(@"log10 0
log10 10
log10 100
log10 1001
log10(float4(0,10,100,1001))", @"# log10(0)
out = -inf
# log10(10)
out = 1
# log10(100)
out = 2
# log10(1001)
out = 3.000434077479319
# log10(float4(0, 10, 100, 1001))
out = float4(-inf, 1, 2, 3.0004342)", Category = "Math Functions")]
        public static void Test_log10(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Exp(Kalk.Core.KalkDoubleValue)"/> or `exp`.
        /// </summary>
        [TestCase(@"exp(0)
exp(1)
exp(float4(0,1,2,3))", @"# exp(0)
out = 1
# exp(1)
out = 2.718281828459045
# exp(float4(0, 1, 2, 3))
out = float4(1, 2.7182817, 7.389056, 20.085537)", Category = "Math Functions")]
        public static void Test_exp(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Exp2(Kalk.Core.KalkDoubleValue)"/> or `exp2`.
        /// </summary>
        [TestCase(@"exp2(0)
exp2(1)
exp2(4)
exp2(float4(0,1,2,3))", @"# exp2(0)
out = 1
# exp2(1)
out = 2
# exp2(4)
out = 16
# exp2(float4(0, 1, 2, 3))
out = float4(1, 2, 4, 8)", Category = "Math Functions")]
        public static void Test_exp2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Pow(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `pow`.
        /// </summary>
        [TestCase(@"pow(1.5, 3.5)
pow(2, 4)
pow(float4(1,2,3,4), 4)
pow(float4(1..4), float4(5..8))", @"# pow(1.5, 3.5)
out = 4.133513940946613
# pow(2, 4)
out = 16
# pow(float4(1, 2, 3, 4), 4)
out = float4(1, 16, 81, 256)
# pow(float4(1..4), float4(5..8))
out = float4(1, 64, 2187, 65536)", Category = "Math Functions")]
        public static void Test_pow(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Round(Kalk.Core.KalkDoubleValue)"/> or `round`.
        /// </summary>
        [TestCase(@"round(0.2); round(1.5); round(10.7)
round(-0.2); round(-1.5); round(-10.7)", @"# round(0.2); round(1.5); round(10.7)
out = 0
out = 2
out = 11
# round(-0.2); round(-1.5); round(-10.7)
out = -0
out = -2
out = -11", Category = "Math Functions")]
        public static void Test_round(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Floor(Kalk.Core.KalkDoubleValue)"/> or `floor`.
        /// </summary>
        [TestCase(@"floor(0.2); floor(1.5); floor(10.7)
floor(-0.2); floor(-1.5); floor(-10.7)", @"# floor(0.2); floor(1.5); floor(10.7)
out = 0
out = 1
out = 10
# floor(-0.2); floor(-1.5); floor(-10.7)
out = -1
out = -2
out = -11", Category = "Math Functions")]
        public static void Test_floor(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Ceiling(Kalk.Core.KalkDoubleValue)"/> or `ceil`.
        /// </summary>
        [TestCase(@"ceil(0.2); ceil(1.5); ceil(10.7)
ceil(-0.2); ceil(-1.5); ceil(-10.7)", @"# ceil(0.2); ceil(1.5); ceil(10.7)
out = 1
out = 2
out = 11
# ceil(-0.2); ceil(-1.5); ceil(-10.7)
out = -0
out = -1
out = -10", Category = "Math Functions")]
        public static void Test_ceil(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Trunc(Kalk.Core.KalkDoubleValue)"/> or `trunc`.
        /// </summary>
        [TestCase(@"trunc(0.2); trunc(1.5); trunc(10.7)
trunc(-0.2); trunc(-1.5); trunc(-10.7)", @"# trunc(0.2); trunc(1.5); trunc(10.7)
out = 0
out = 1
out = 10
# trunc(-0.2); trunc(-1.5); trunc(-10.7)
out = -0
out = -1
out = -10", Category = "Math Functions")]
        public static void Test_trunc(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Saturate(Kalk.Core.KalkDoubleValue)"/> or `saturate`.
        /// </summary>
        [TestCase(@"saturate(10)
saturate(-10)
saturate(float4(-1, 0.5, 1, 2))", @"# saturate(10)
out = 1
# saturate(-10)
out = 0
# saturate(float4(-1, 0.5, 1, 2))
out = float4(0, 0.5, 1, 1)", Category = "Math Functions")]
        public static void Test_saturate(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Min(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `min`.
        /// </summary>
        [TestCase(@"min(-5, 6)
min(1, 0)
min(float4(0, 1, 2, 3), float4(1, 0, 3, 2))", @"# min(-5, 6)
out = -5
# min(1, 0)
out = 0
# min(float4(0, 1, 2, 3), float4(1, 0, 3, 2))
out = float4(0, 0, 2, 2)", Category = "Math Functions")]
        public static void Test_min(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Max(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `max`.
        /// </summary>
        [TestCase(@"max(-5, 6)
max(1, 0)
max(float4(0, 1, 2, 3), float4(1, 0, 3, 2))", @"# max(-5, 6)
out = 6
# max(1, 0)
out = 1
# max(float4(0, 1, 2, 3), float4(1, 0, 3, 2))
out = float4(1, 1, 3, 3)", Category = "Math Functions")]
        public static void Test_max(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Step(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `step`.
        /// </summary>
        [TestCase(@"step(1, 5)
step(5, 1)
step(float4(0, 1, 2, 3), float4(1, 0, 3, 2))
step(-10, 5)
step(5.5, -10.5)", @"# step(1, 5)
out = 1
# step(5, 1)
out = 0
# step(float4(0, 1, 2, 3), float4(1, 0, 3, 2))
out = float4(1, 0, 1, 0)
# step(-10, 5)
out = 1
# step(5.5, -10.5)
out = 0", Category = "Math Functions")]
        public static void Test_step(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Smoothstep(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `smoothstep`.
        /// </summary>
        [TestCase(@"smoothstep(float4(0), float4(1), float4(-0.5))
smoothstep(float4(0), float4(1), float4(1.5))
smoothstep(float4(0), float4(1), float4(0.5))
smoothstep(float4(0), float4(1), float4(0.9))", @"# smoothstep(float4(0), float4(1), float4(-0.5))
out = float4(0, 0, 0, 0)
# smoothstep(float4(0), float4(1), float4(1.5))
out = float4(1, 1, 1, 1)
# smoothstep(float4(0), float4(1), float4(0.5))
out = float4(0.5, 0.5, 0.5, 0.5)
# smoothstep(float4(0), float4(1), float4(0.9))
out = float4(0.972, 0.972, 0.972, 0.972)", Category = "Math Functions")]
        public static void Test_smoothstep(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Lerp(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `lerp`.
        /// </summary>
        [TestCase(@"lerp(0, 10, 0.5)
lerp(rgb(""AliceBlue"").xyz, rgb(""Green"").xyz, 0.5)", @"# lerp(0, 10, 0.5)
out = 5
# lerp(rgb(""AliceBlue"").xyz, rgb(""Green"").xyz, 0.5)
out = float3(0.47058824, 0.7372549, 0.5)", Category = "Math Functions")]
        public static void Test_lerp(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Clamp(Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue,Kalk.Core.KalkDoubleValue)"/> or `clamp`.
        /// </summary>
        [TestCase(@"clamp(-1, 0, 1)
clamp(2, 0, 1)
clamp(0.5, 0, 1)
clamp(float4(0, 1, -2, 3), float4(0, -1, 3, 4), float4(1, 2, 5, 6))", @"# clamp(-1, 0, 1)
out = 0
# clamp(2, 0, 1)
out = 1
# clamp(0.5, 0, 1)
out = 0.5
# clamp(float4(0, 1, -2, 3), float4(0, -1, 3, 4), float4(1, 2, 5, 6))
out = float4(0, 1, 3, 4)", Category = "Math Functions")]
        public static void Test_clamp(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Real(Kalk.Core.KalkComplex)"/> or `real`.
        /// </summary>
        [TestCase(@"real(1.5 + 2.5i)", @"# real(1.5 + 2.5 * i)
out = 1.5", Category = "Math Functions")]
        public static void Test_real(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Imag(Kalk.Core.KalkComplex)"/> or `imag`.
        /// </summary>
        [TestCase(@"imag(1.5 + 2.5i)", @"# imag(1.5 + 2.5 * i)
out = 2.5", Category = "Math Functions")]
        public static void Test_imag(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Phase(Kalk.Core.KalkComplex)"/> or `phase`.
        /// </summary>
        [TestCase(@"phase(1.5 + 2.5i)", @"# phase(1.5 + 2.5 * i)
out = 1.0303768265243125", Category = "Math Functions")]
        public static void Test_phase(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.IsFinite(Kalk.Core.KalkCompositeValue)"/> or `isfinite`.
        /// </summary>
        [TestCase(@"isfinite(1)
isfinite(nan)
isfinite(inf)
isfinite(float4(1, -10.5, inf, nan))", @"# isfinite(1)
out = true
# isfinite(nan)
out = false
# isfinite(inf)
out = false
# isfinite(float4(1, -10.5, inf, nan))
out = bool4(true, true, false, false)", Category = "Math Functions")]
        public static void Test_isfinite(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.IsInf(Kalk.Core.KalkCompositeValue)"/> or `isinf`.
        /// </summary>
        [TestCase(@"isinf(1)
isinf(inf)
isinf(float4(1, -10.5, inf, nan))", @"# isinf(1)
out = false
# isinf(inf)
out = true
# isinf(float4(1, -10.5, inf, nan))
out = bool4(false, false, true, false)", Category = "Math Functions")]
        public static void Test_isinf(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.IsNan(Kalk.Core.KalkCompositeValue)"/> or `isnan`.
        /// </summary>
        [TestCase(@"isnan(1)
isnan(inf)
isnan(nan)
isnan(float4(1, -10.5, inf, nan))", @"# isnan(1)
out = false
# isnan(inf)
out = false
# isnan(nan)
out = true
# isnan(float4(1, -10.5, inf, nan))
out = bool4(false, false, false, true)", Category = "Math Functions")]
        public static void Test_isnan(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MathModule.Sum(System.Object,System.Object[])"/> or `sum`.
        /// </summary>
        [TestCase(@"sum(1,2,3,4)
sum(float4(1..4))
sum(float4(1..4), float4(5..8))
sum(""a"", ""b"", ""c"")
sum([""a"", ""b"", ""c""])", @"# sum(1, 2, 3, 4)
out = 10
# sum(float4(1..4))
out = 10
# sum(float4(1..4), float4(5..8))
out = float4(15, 16, 17, 18)
# sum(""a"", ""b"", ""c"")
out = ""abc""
# sum([""a"", ""b"", ""c""])
out = ""abc""", Category = "Math Functions")]
        public static void Test_sum(string input, string output) => AssertScript(input, output);

    }

    public partial class MemoryModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.Malloc(System.Int32)"/> or `malloc`.
        /// </summary>
        [TestCase(@"buffer = malloc(16)
buffer[0] = 5
buffer", @"# buffer = malloc(16)
buffer = bytebuffer([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0])
# buffer
out = bytebuffer([5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0])", Category = "Misc Memory Functions")]
        public static void Test_malloc(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.Bitcast(System.Object,System.Object)"/> or `bitcast`.
        /// </summary>
        [TestCase(@"bitcast(int, 1.5f)
bitcast(float, out)
bitcast(long, 2.5)
bitcast(double, out)
asbytes(float4(1..4))
bitcast(float4, out)", @"# bitcast(int, 1.5f)
out = 1069547520
# bitcast(float, out)
out = 1.5
# bitcast(long, 2.5)
out = 4612811918334230528
# bitcast(double, out)
out = 2.5
# asbytes(float4(1..4))
out = bytebuffer([0, 0, 128, 63, 0, 0, 0, 64, 0, 0, 64, 64, 0, 0, 128, 64])
# bitcast(float4, out)
out = float4(1, 2, 3, 4)", Category = "Misc Memory Functions")]
        public static void Test_bitcast(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsBytes(System.Object)"/> or `asbytes`.
        /// </summary>
        [TestCase(@"asbytes(float4(1..4))
asbytes(int(0x01020304))
asbytes(1.5)
asbytes(2.5f)", @"# asbytes(float4(1..4))
out = bytebuffer([0, 0, 128, 63, 0, 0, 0, 64, 0, 0, 64, 64, 0, 0, 128, 64])
# asbytes(int(16909060))
out = bytebuffer([4, 3, 2, 1])
# asbytes(1.5)
out = bytebuffer([0, 0, 0, 0, 0, 0, 248, 63])
# asbytes(2.5f)
out = bytebuffer([0, 0, 32, 64])", Category = "Misc Memory Functions")]
        public static void Test_asbytes(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.CountBits(System.Object)"/> or `countbits`.
        /// </summary>
        [TestCase(@"for val in 0..7; countbits(val); end;
countbits(int4(1,2,3,4))
countbits(bytebuffer(1..16))", @"# for val in 0..7; countbits(val); end;
out = 0
out = 1
out = 1
out = 2
out = 1
out = 2
out = 2
out = 3
# countbits(int4(1, 2, 3, 4))
out = int4(1, 1, 2, 1)
# countbits(bytebuffer(1..16))
out = 33", Category = "Misc Memory Functions")]
        public static void Test_countbits(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.FirstBitHigh(System.Object)"/> or `firstbithigh`.
        /// </summary>
        [TestCase(@"firstbithigh 128
firstbithigh byte(128)
firstbithigh 0
firstbithigh(int4(1, -1, 65536, 1 << 20))", @"# firstbithigh(128)
out = 24
# firstbithigh(byte(128))
out = 0
# firstbithigh(0)
out = -1
# firstbithigh(int4(1, -1, 65536, 1 << 20))
out = int4(31, 0, 15, 11)", Category = "Misc Memory Functions")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.FirstBitHigh(System.Object)"/> or `firstbithigh`.
        /// </summary>
        [TestCase(@"firstbithigh ulong(1 << 63)
firstbithigh long(1)
firstbithigh long(0)", @"# firstbithigh(ulong(1 << 63))
out = 0
# firstbithigh(long(1))
out = 63
# firstbithigh(long(0))
out = -1", Category = "Misc Memory Functions")]
        public static void Test_firstbithigh(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.FirstBitLow(System.Object)"/> or `firstbitlow`.
        /// </summary>
        [TestCase(@"firstbitlow 128
firstbitlow byte(128)
firstbitlow 0
firstbitlow(int4(1, -1, 65536, 1 << 20))", @"# firstbitlow(128)
out = 7
# firstbitlow(byte(128))
out = 7
# firstbitlow(0)
out = -1
# firstbitlow(int4(1, -1, 65536, 1 << 20))
out = int4(0, 0, 16, 20)", Category = "Misc Memory Functions")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.FirstBitLow(System.Object)"/> or `firstbitlow`.
        /// </summary>
        [TestCase(@"firstbitlow ulong(1 << 63)
firstbitlow long(1)
firstbitlow long(0)", @"# firstbitlow(ulong(1 << 63))
out = 63
# firstbitlow(long(1))
out = 0
# firstbitlow(long(0))
out = -1", Category = "Misc Memory Functions")]
        public static void Test_firstbitlow(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.ReverseBits(System.Object)"/> or `reversebits`.
        /// </summary>
        [TestCase(@"reversebits 128
reversebits out
reversebits byte(128)
reversebits(out)
reversebits(int4(1,2,3,4))
reversebits out", @"# reversebits(128)
out = 16777216
# reversebits(out)
out = 128
# reversebits(byte(128))
out = 1
# reversebits(out)
out = 128
# reversebits(int4(1, 2, 3, 4))
out = int4(-2147483648, 1073741824, -1073741824, 536870912)
# reversebits(out)
out = int4(1, 2, 3, 4)", Category = "Misc Memory Functions")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.ReverseBits(System.Object)"/> or `reversebits`.
        /// </summary>
        [TestCase(@"reversebits long(1)
reversebits out
reversebits(bytebuffer([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]))
reversebits out", @"# reversebits(long(1))
out = -9223372036854775808
# reversebits(out)
out = 1
# reversebits(bytebuffer([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]))
out = bytebuffer([240, 112, 176, 48, 208, 80, 144, 16, 224, 96, 160, 32, 192, 64, 128])
# reversebits(out)
out = bytebuffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])", Category = "Misc Memory Functions")]
        public static void Test_reversebits(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsDouble(System.Object)"/> or `asdouble`.
        /// </summary>
        [TestCase(@"asdouble(1.5)
aslong(1.5)
asdouble(out)", @"# asdouble(1.5)
out = 1.5
# aslong(1.5)
out = 4609434218613702656
# asdouble(out)
out = 1.5", Category = "Misc Memory Functions")]
        public static void Test_asdouble(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsFloat(System.Object)"/> or `asfloat`.
        /// </summary>
        [TestCase(@"asfloat(1.5f)
asint(1.5f)
asfloat(out)", @"# asfloat(1.5f)
out = 1.5
# asint(1.5f)
out = 1069547520
# asfloat(out)
out = 1.5", Category = "Misc Memory Functions")]
        public static void Test_asfloat(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsLong(System.Object)"/> or `aslong`.
        /// </summary>
        [TestCase(@"aslong(1.5)
asdouble(out)", @"# aslong(1.5)
out = 4609434218613702656
# asdouble(out)
out = 1.5", Category = "Misc Memory Functions")]
        public static void Test_aslong(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsULong(System.Object)"/> or `asulong`.
        /// </summary>
        [TestCase(@"asulong(-1.5)
asdouble(out)", @"# asulong(-1.5)
out = 13832806255468478464
# asdouble(out)
out = -1.5", Category = "Misc Memory Functions")]
        public static void Test_asulong(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsInt(System.Object)"/> or `asint`.
        /// </summary>
        [TestCase(@"asint(1.5f)
asfloat(out)", @"# asint(1.5f)
out = 1069547520
# asfloat(out)
out = 1.5", Category = "Misc Memory Functions")]
        public static void Test_asint(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.AsUInt(System.Object)"/> or `asuint`.
        /// </summary>
        [TestCase(@"asuint(-1.5f)
asfloat(out)", @"# asuint(-1.5f)
out = 3217031168
# asfloat(out)
out = -1.5", Category = "Misc Memory Functions")]
        public static void Test_asuint(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.MemoryModule.ByteBuffer(System.Object[])"/> or `bytebuffer`.
        /// </summary>
        [TestCase(@"bytebuffer
bytebuffer(0,1,2,3,4)
bytebuffer(float4(1))
bytebuffer([1,2,3,4])", @"# bytebuffer
out = bytebuffer([])
# bytebuffer(0, 1, 2, 3, 4)
out = bytebuffer([0, 1, 2, 3, 4])
# bytebuffer(float4(1))
out = bytebuffer([0, 0, 128, 63, 0, 0, 128, 63, 0, 0, 128, 63, 0, 0, 128, 63])
# bytebuffer([1,2,3,4])
out = bytebuffer([1, 2, 3, 4])", Category = "Misc Memory Functions")]
        public static void Test_bytebuffer(string input, string output) => AssertScript(input, output);

    }

    public partial class MiscModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Date(System.String)"/> or `date`.
        /// </summary>
        [TestCase(@"today = date
today.year
today.month
""30 Nov 2020"" |> date
out |> date.add_days 4
date.format = ""%F""
date", @"# today = date
today = 11/22/20 10:13:00
# today.year
out = 2020
# today.month
out = 11
# ""30 Nov 2020"" |> date
out = 11/30/20 00:00:00
# out |> date.add_days(4)
out = 12/04/20 00:00:00
# date
out = 2020-11-22", Category = "Misc Functions")]
        public static void Test_date(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Ascii(System.Object)"/> or `ascii`.
        /// </summary>
        [TestCase(@"ascii 65
ascii 97
ascii ""A""
ascii ""kalk""
ascii out", @"# ascii(65)
out = ""A""
# ascii(97)
out = ""a""
# ascii(""A"")
out = 65
# ascii(""kalk"")
out = bytebuffer([107, 97, 108, 107])
# ascii(out)
out = ""kalk""", Category = "Misc Functions")]
        public static void Test_ascii(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Keys(System.Object)"/> or `keys`.
        /// </summary>
        [TestCase(@"obj = {m: 1, n: 2}; keys obj", @"# obj = {m: 1, n: 2}; keys(obj)
obj = {m: 1, n: 2}
out = [""m"", ""n""]", Category = "Misc Functions")]
        public static void Test_keys(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Guid"/> or `guid`.
        /// </summary>
        [TestCase(@"guid", @"# guid
out = ""0deafe30-de4d-47c3-9631-2d3292afbb8e""", Category = "Misc Functions")]
        public static void Test_guid(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Size(System.Object)"/> or `size`.
        /// </summary>
        [TestCase(@"size 1
size ""kalk""
size float4(1,2,3,4)
size [1, 2, 3]", @"# size(1)
out = 0
# size(""kalk"")
out = 4
# size(float4(1, 2, 3, 4))
out = 4
# size([1, 2, 3])
out = 3", Category = "Misc Functions")]
        public static void Test_size(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Values(System.Object)"/> or `values`.
        /// </summary>
        [TestCase(@"obj = {m: 1, n: 2}; values obj", @"# obj = {m: 1, n: 2}; values(obj)
obj = {m: 1, n: 2}
out = [1, 2]", Category = "Misc Functions")]
        public static void Test_values(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Hexadecimal(System.Object,System.Boolean,System.String)"/> or `hex`.
        /// </summary>
        [TestCase(@"hex 10
hex ""0a""
hex ""0xff030201""
hex out
hex ""01:02:03:04:05:06:07:08:09:0A:0B:0C:0D:0E:0F""
hex(out, true, "","")
hex out
hex(""1a,2b;3c 4d-5e_6f"")
hex out
hex float4(1,2,3,4)", @"# hex(10)
out = ""0A""
# hex(""0a"")
out = 10
# hex(""0xff030201"")
out = 4278387201
# hex(out)
out = ""01 02 03 FF""
# hex(""01:02:03:04:05:06:07:08:09:0A:0B:0C:0D:0E:0F"")
out = bytebuffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
# hex(out, true, "","")
out = ""0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F""
# hex(out)
out = bytebuffer([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
# hex(""1a,2b;3c 4d-5e_6f"")
out = 103832130169626
# hex(out)
out = ""1A 2B 3C 4D 6F 5E 00 00""
# hex(float4(1, 2, 3, 4))
out = ""00 00 80 3F 00 00 00 40 00 00 40 40 00 00 80 40""", Category = "Misc Functions")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Hexadecimal(System.Object,System.Boolean,System.String)"/> or `hex`.
        /// </summary>
        [TestCase(@"hex short(12345)
hex int (12345789)", @"# hex(short(12345))
out = ""39 30""
# hex(int(12345789))
out = ""BD 61 BC 00""", Category = "Misc Functions")]
        public static void Test_hex(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Binary(System.Object,System.Boolean,System.String)"/> or `bin`.
        /// </summary>
        [TestCase(@"bin 10
bin out
bin 0xff030201
bin out
bin ""11111111000000110000001000000001""
bin(byte(5))
bin(long(6))
bin(out)
kind(out)", @"# bin(10)
out = ""00001010 00000000 00000000 00000000""
# bin(out)
out = 10
# bin(-16580095)
out = ""00000001 00000010 00000011 11111111""
# bin(out)
out = 4278387201
# bin(""11111111000000110000001000000001"")
out = 4278387201
# bin(byte(5))
out = ""00000101""
# bin(long(6))
out = ""00000110 00000000 00000000 00000000 00000000 00000000 00000000 00000000""
# bin(out)
out = 6
# kind(out)
out = ""long""", Category = "Misc Functions")]
        public static void Test_bin(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.GetUtf8(System.Object)"/> or `utf8`.
        /// </summary>
        [TestCase(@"utf8 ""kalk""
utf8 out", @"# utf8(""kalk"")
out = bytebuffer([107, 97, 108, 107])
# utf8(out)
out = ""kalk""", Category = "Misc Functions")]
        public static void Test_utf8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.GetUtf16(System.Object)"/> or `utf16`.
        /// </summary>
        [TestCase(@"utf16 ""kalk""
utf16 out", @"# utf16(""kalk"")
out = bytebuffer([107, 0, 97, 0, 108, 0, 107, 0])
# utf16(out)
out = ""kalk""", Category = "Misc Functions")]
        public static void Test_utf16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.GetUtf32(System.Object)"/> or `utf32`.
        /// </summary>
        [TestCase(@"utf32 ""kalk""
utf32 out", @"# utf32(""kalk"")
out = bytebuffer([107, 0, 0, 0, 97, 0, 0, 0, 108, 0, 0, 0, 107, 0, 0, 0])
# utf32(out)
out = ""kalk""", Category = "Misc Functions")]
        public static void Test_utf32(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.InsertAt(System.Object,System.Int32,System.Object)"/> or `insert_at`.
        /// </summary>
        [TestCase(@"insert_at(""kalk"", 0, ""YES"")
insert_at(""kalk"", -1, ""YES"")
insert_at(0..10, 1, 50)
insert_at(0..9, 21, 50) # final index is 21 % 10 = 1
insert_at([], 3, 1)", @"# insert_at(""kalk"", 0, ""YES"")
out = ""YESkalk""
# insert_at(""kalk"", -1, ""YES"")
out = ""kalkYES""
# insert_at(0..10, 1, 50)
out = [0, 50, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
# insert_at(0..9, 21, 50) # final index is 21 % 10 = 1
out = [0, 50, 1, 2, 3, 4, 5, 6, 7, 8, 9]
# insert_at([], 3, 1)
out = [1]", Category = "Misc Functions")]
        public static void Test_insert_at(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.RemoveAt(System.Object,System.Int32)"/> or `remove_at`.
        /// </summary>
        [TestCase(@"remove_at(""kalk"", 0)
remove_at(""kalk"", -1)
remove_at(0..9, 5)
remove_at(0..9, -1)
remove_at(asbytes(0x04030201), 1)", @"# remove_at(""kalk"", 0)
out = ""alk""
# remove_at(""kalk"", -1)
out = ""kal""
# remove_at(0..9, 5)
out = [0, 1, 2, 3, 4, 6, 7, 8, 9]
# remove_at(0..9, -1)
out = [0, 1, 2, 3, 4, 5, 6, 7, 8]
# remove_at(asbytes(67305985), 1)
out = bytebuffer([1, 3, 4])", Category = "Misc Functions")]
        public static void Test_remove_at(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Contains(System.Object,System.Object)"/> or `contains`.
        /// </summary>
        [TestCase(@"contains(""kalk"", ""l"")
contains(""kalk"", ""e"")
contains([1,2,3,4,5], 3)
contains([1,2,3,4,5], 6)
contains(float4(1,2,3,4), 3)
contains(float4(1,2,3,4), 6)", @"# contains(""kalk"", ""l"")
out = true
# contains(""kalk"", ""e"")
out = false
# contains([1,2,3,4,5], 3)
out = true
# contains([1,2,3,4,5], 6)
out = false
# contains(float4(1, 2, 3, 4), 3)
out = true
# contains(float4(1, 2, 3, 4), 6)
out = false", Category = "Misc Functions")]
        public static void Test_contains(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Replace(System.Object,System.Object,System.Object)"/> or `replace`.
        /// </summary>
        [TestCase(@"replace(""kalk"", ""k"", ""woo"")
replace([1,2,3,4], 3, 5)
replace(float4(1,2,3,4), 3, 5)", @"# replace(""kalk"", ""k"", ""woo"")
out = ""wooalwoo""
# replace([1,2,3,4], 3, 5)
out = [1, 2, 5, 4]
# replace(float4(1, 2, 3, 4), 3, 5)
out = float4(1, 2, 5, 4)", Category = "Misc Functions")]
        public static void Test_replace(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Slice(System.Object,System.Int32,System.Nullable{System.Int32})"/> or `slice`.
        /// </summary>
        [TestCase(@"slice(""kalk"", 1)
slice(""kalk"", -2)
slice(""kalk"", 1, 2)
slice([1,2,3,4], 1)
slice([1,2,3,4], -1)
slice([1,2,3,4], -1, 3) # length is bigger than expected, no errors
slice(asbytes(0x04030201), 1, 2)", @"# slice(""kalk"", 1)
out = ""alk""
# slice(""kalk"", -2)
out = ""lk""
# slice(""kalk"", 1, 2)
out = ""al""
# slice([1,2,3,4], 1)
out = [2, 3, 4]
# slice([1,2,3,4], -1)
out = [4]
# slice([1,2,3,4], -1, 3) # length is bigger than expected, no errors
out = [4]
# slice(asbytes(67305985), 1, 2)
out = slice(bytebuffer([2, 3]), 1, 2)", Category = "Misc Functions")]
        public static void Test_slice(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Lines(System.String)"/> or `lines`.
        /// </summary>
        [TestCase(@"lines(""k\na\nl\nk"")", @"# lines(""k\na\nl\nk"")
out = [""k"", ""a"", ""l"", ""k""]", Category = "Misc Functions")]
        public static void Test_lines(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.MiscModule.Colors"/> or `colors`.
        /// </summary>
        [TestCase(@"colors[0]
mycolor = colors[""AliceBlue""]; mycolor.name", @"# colors[0]
out = rgb(240, 248, 255) ## F0F8FF AliceBlue ##
# mycolor = colors[""AliceBlue""]; mycolor.name
mycolor = rgb(240, 248, 255) ## F0F8FF AliceBlue ##
out = ""AliceBlue""", Category = "Misc Functions")]
        public static void Test_colors(string input, string output) => AssertScript(input, output);

    }

    public partial class Sse2IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse2X64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse3IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse41IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse41X64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse42IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Sse42X64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class SseIntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class SseX64IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class Ssse3IntrinsicsModuleTests : KalkTestBase
    {
    }

    public partial class StandardUnitsModuleTests : KalkTestBase
    {
    }

    public partial class StringModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringEscape(System.String)"/> or `escape`.
        /// </summary>
        [TestCase(@"""Hel\tlo\n\""W\\orld"" |> escape", @"# ""Hel\tlo\n\""W\\orld"" |> escape
out = ""Hel\\tlo\\n\\\""W\\\\orld""", Category = "Text Functions")]
        public static void Test_escape(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringCapitalize(System.String)"/> or `capitalize`.
        /// </summary>
        [TestCase(@"""test"" |> capitalize", @"# ""test"" |> capitalize
out = ""Test""", Category = "Text Functions")]
        public static void Test_capitalize(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringCapitalizeWords(System.String)"/> or `capitalize_words`.
        /// </summary>
        [TestCase(@"""This is easy"" |> capitalize_words", @"# ""This is easy"" |> capitalize_words
out = ""This Is Easy""", Category = "Text Functions")]
        public static void Test_capitalize_words(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringDowncase(System.String)"/> or `downcase`.
        /// </summary>
        [TestCase(@"""TeSt"" |> downcase", @"# ""TeSt"" |> downcase
out = ""test""", Category = "Text Functions")]
        public static void Test_downcase(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringUpcase(System.String)"/> or `upcase`.
        /// </summary>
        [TestCase(@"""test"" |> upcase", @"# ""test"" |> upcase
out = ""TEST""", Category = "Text Functions")]
        public static void Test_upcase(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringEndsWith(System.String,System.String)"/> or `endswith`.
        /// </summary>
        [TestCase(@"""This is easy"" |> endswith ""easy""
""This is easy"" |> endswith ""none""", @"# ""This is easy"" |> endswith(""easy"")
out = true
# ""This is easy"" |> endswith(""none"")
out = false", Category = "Text Functions")]
        public static void Test_endswith(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringHandleize(System.String)"/> or `handleize`.
        /// </summary>
        [TestCase(@"'100% M @ Ms!!!' |> handleize", @"# '100% M @ Ms!!!' |> handleize
out = ""100-m-ms""", Category = "Text Functions")]
        public static void Test_handleize(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringLeftStrip(System.String)"/> or `lstrip`.
        /// </summary>
        [TestCase(@"'   too many spaces' |> lstrip", @"# '   too many spaces' |> lstrip
out = ""too many spaces""", Category = "Text Functions")]
        public static void Test_lstrip(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringPluralize(System.Int32,System.String,System.String)"/> or `pluralize`.
        /// </summary>
        [TestCase(@"3 |> pluralize('product', 'products')", @"# 3 |> pluralize('product', 'products')
out = ""products""", Category = "Text Functions")]
        public static void Test_pluralize(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringRightStrip(System.String)"/> or `rstrip`.
        /// </summary>
        [TestCase(@"'   too many spaces           ' |> rstrip", @"# '   too many spaces           ' |> rstrip
out = ""   too many spaces""", Category = "Text Functions")]
        public static void Test_rstrip(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringSplit(System.String,System.String)"/> or `split`.
        /// </summary>
        [TestCase(@"""Hi, how are you today?"" |> split ' '", @"# ""Hi, how are you today?"" |> split(' ')
out = [""Hi,"", ""how"", ""are"", ""you"", ""today?""]", Category = "Text Functions")]
        public static void Test_split(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringStartsWith(System.String,System.String)"/> or `startswith`.
        /// </summary>
        [TestCase(@"""This is easy"" |> startswith ""This""
""This is easy"" |> startswith ""easy""", @"# ""This is easy"" |> startswith(""This"")
out = true
# ""This is easy"" |> startswith(""easy"")
out = false", Category = "Text Functions")]
        public static void Test_startswith(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringStrip(System.String)"/> or `strip`.
        /// </summary>
        [TestCase(@"'   too many spaces           ' |> strip", @"# '   too many spaces           ' |> strip
out = ""too many spaces""", Category = "Text Functions")]
        public static void Test_strip(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringStripNewlines(System.String)"/> or `strip_newlines`.
        /// </summary>
        [TestCase(@"""This is a string.\r\n With \nanother \rstring"" |> strip_newlines", @"# ""This is a string.\r\n With \nanother \rstring"" |> strip_newlines
out = ""This is a string. With another string""", Category = "Text Functions")]
        public static void Test_strip_newlines(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringPadLeft(System.String,System.Int32)"/> or `pad_left`.
        /// </summary>
        [TestCase(@"""world"" |> pad_left 10", @"# ""world"" |> pad_left(10)
out = ""     world""", Category = "Text Functions")]
        public static void Test_pad_left(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.StringPadRight(System.String,System.Int32)"/> or `pad_right`.
        /// </summary>
        [TestCase(@"""hello"" |> pad_right 10", @"# ""hello"" |> pad_right(10)
out = ""hello     """, Category = "Text Functions")]
        public static void Test_pad_right(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexEscape(System.String)"/> or `regex_escape`.
        /// </summary>
        [TestCase(@"""(abc.*)"" |> regex_escape", @"# ""(abc.*)"" |> regex_escape
out = ""\\(abc\\.\\*\\)""", Category = "Text Functions")]
        public static void Test_regex_escape(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexMatch(System.String,System.String,System.String)"/> or `regex_match`.
        /// </summary>
        [TestCase(@"""this is a text123"" |> regex_match `(\w+) a ([a-z]+\d+)`", @"# ""this is a text123"" |> regex_match(`(\w+) a ([a-z]+\d+)`)
out = [""is a text123"", ""is"", ""text123""]", Category = "Text Functions")]
        public static void Test_regex_match(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexMatches(System.String,System.String,System.String)"/> or `regex_matches`.
        /// </summary>
        [TestCase(@"""this is a text123"" |> regex_matches `(\w+)`", @"# ""this is a text123"" |> regex_matches(`(\w+)`)
out = [[""this"", ""this""], [""is"", ""is""], [""a"", ""a""], [""text123"", ""text123""]]", Category = "Text Functions")]
        public static void Test_regex_matches(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexReplace(System.String,System.String,System.String,System.String)"/> or `regex_replace`.
        /// </summary>
        [TestCase(@"""abbbbcccd"" |> regex_replace(""b+c+"",""-Yo-"")", @"# ""abbbbcccd"" |> regex_replace(""b+c+"", ""-Yo-"")
out = ""a-Yo-d""", Category = "Text Functions")]
        public static void Test_regex_replace(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexSplit(System.String,System.String,System.String)"/> or `regex_split`.
        /// </summary>
        [TestCase(@"""a, b   , c,    d"" |> regex_split `\s*,\s*`", @"# ""a, b   , c,    d"" |> regex_split(`\s*,\s*`)
out = [""a"", ""b"", ""c"", ""d""]", Category = "Text Functions")]
        public static void Test_regex_split(string input, string output) => AssertScript(input, output, "Strings");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.StringModule.RegexUnescape(System.String)"/> or `regex_unescape`.
        /// </summary>
        [TestCase(@"""\\(abc\\.\\*\\)"" |> regex_unescape", @"# ""\\(abc\\.\\*\\)"" |> regex_unescape
out = ""(abc.*)""", Category = "Text Functions")]
        public static void Test_regex_unescape(string input, string output) => AssertScript(input, output, "Strings");

    }

    public partial class TypesModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateByte(System.Object)"/> or `byte`.
        /// </summary>
        [TestCase(@"byte
byte 0
byte 255", @"# byte
out = 0
# byte(0)
out = 0
# byte(255)
out = 255", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateByte(System.Object)"/> or `byte`.
        /// </summary>
        [TestCase(@"byte 256", @"Unable to convert type `int` to `byte`", Category = "Type Constructors")]
        public static void Test_byte(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateSByte(System.Object)"/> or `sbyte`.
        /// </summary>
        [TestCase(@"sbyte
sbyte 0
sbyte 127
sbyte -128", @"# sbyte
out = 0
# sbyte(0)
out = 0
# sbyte(127)
out = 127
# sbyte(-128)
out = -128", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateSByte(System.Object)"/> or `sbyte`.
        /// </summary>
        [TestCase(@"sbyte 128", @"Unable to convert type `int` to `sbyte`", Category = "Type Constructors")]
        public static void Test_sbyte(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort(System.Object)"/> or `short`.
        /// </summary>
        [TestCase(@"short
short 0
short 32767
short -32768
short 32768", @"# short
out = 0
# short(0)
out = 0
# short(32767)
out = 32767
# short(-32768)
out = -32768
Unable to convert type `int` to `short`", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort(System.Object)"/> or `short`.
        /// </summary>
        [TestCase(@"short 32768", @"Unable to convert type `int` to `short`", Category = "Type Constructors")]
        public static void Test_short(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort(System.Object)"/> or `ushort`.
        /// </summary>
        [TestCase(@"ushort
ushort 0
ushort 65535", @"# ushort
out = 0
# ushort(0)
out = 0
# ushort(65535)
out = 65535", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort(System.Object)"/> or `ushort`.
        /// </summary>
        [TestCase(@"ushort 65536", @"Unable to convert type `int` to `ushort`", Category = "Type Constructors")]
        public static void Test_ushort(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt(System.Object)"/> or `uint`.
        /// </summary>
        [TestCase(@"uint
uint 0
uint(1<<32 - 1)", @"# uint
out = 0
# uint(0)
out = 0
# uint(1 << 32 - 1)
out = 4294967295", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt(System.Object)"/> or `uint`.
        /// </summary>
        [TestCase(@"uint 1 << 32", @"Unable to convert type `long` to `uint`", Category = "Type Constructors")]
        public static void Test_uint(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt(System.Object)"/> or `int`.
        /// </summary>
        [TestCase(@"int
int 0
int(1 << 31 - 1)
int(-(1<<31))", @"# int
out = 0
# int(0)
out = 0
# int(1 << 31 - 1)
out = 2147483647
# int(-(1 << 31))
out = -2147483648", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt(System.Object)"/> or `int`.
        /// </summary>
        [TestCase(@"int 1 << 31", @"Unable to convert type `long` to int", Category = "Type Constructors")]
        public static void Test_int(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong(System.Object)"/> or `ulong`.
        /// </summary>
        [TestCase(@"ulong
ulong 0
ulong(1 << 64 - 1)", @"# ulong
out = 0
# ulong(0)
out = 0
# ulong(1 << 64 - 1)
out = 18446744073709551615", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong(System.Object)"/> or `ulong`.
        /// </summary>
        [TestCase(@"ulong 1 << 64", @"Unable to convert type `bigint` to `ulong`", Category = "Type Constructors")]
        public static void Test_ulong(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong(System.Object)"/> or `long`.
        /// </summary>
        [TestCase(@"long
long 0
long(1 << 63 - 1)
long(-(1<<63))", @"# long
out = 0
# long(0)
out = 0
# long(1 << 63 - 1)
out = 9223372036854775807
# long(-(1 << 63))
out = -9223372036854775808", Category = "Type Constructors")]
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong(System.Object)"/> or `long`.
        /// </summary>
        [TestCase(@"long 1 << 63", @"Unable to convert type `bigint` to `long`", Category = "Type Constructors")]
        public static void Test_long(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool(System.Object)"/> or `bool`.
        /// </summary>
        [TestCase(@"bool 1
bool 0
bool true
bool false", @"# bool(1)
out = true
# bool(0)
out = false
# bool(true)
out = true
# bool(false)
out = false", Category = "Type Constructors")]
        public static void Test_bool(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat(System.Object)"/> or `float`.
        /// </summary>
        [TestCase(@"float(1)
float(-1)
float(100000000000)", @"# float(1)
out = 1
# float(-1)
out = -1
# float(100000000000)
out = 1E+11", Category = "Type Constructors")]
        public static void Test_float(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf(System.Object)"/> or `half`.
        /// </summary>
        [TestCase(@"half(1)
half(-1)
half(1000.5)
kind out", @"# half(1)
out = 1
# half(-1)
out = -1
# half(1000.5)
out = 1000.5
# kind(out)
out = ""half""", Category = "Type Constructors")]
        public static void Test_half(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateDouble(System.Object)"/> or `double`.
        /// </summary>
        [TestCase(@"double(1)
double(-1)
double(100000000000)
double(1<<200)", @"# double(1)
out = 1
# double(-1)
out = -1
# double(100000000000)
out = 100000000000
# double(1 << 200)
out = 1.6069380442589903E+60", Category = "Type Constructors")]
        public static void Test_double(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateVector(Scriban.Syntax.ScriptVariable,System.Int32,System.Object[])"/> or `vector`.
        /// </summary>
        [TestCase(@"vector(float, 4, 5..8)", @"# vector(float, 4, 5..8)
out = float4(5, 6, 7, 8)", Category = "Type Vector Constructors")]
        public static void Test_vector(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateRgb(System.Object[])"/> or `rgb`.
        /// </summary>
        [TestCase(@"rgb(0xAABBCC)
rgb(""#AABBCC"")
rgb(""AABBCC"")
rgb([0xAA,0xBB,0xCC])
out.xyz
rgb(out)", @"# rgb(11189196)
out = rgb(170, 187, 204) ## AABBCC ##
# rgb(""#AABBCC"")
out = rgb(170, 187, 204) ## AABBCC ##
# rgb(""AABBCC"")
out = rgb(170, 187, 204) ## AABBCC ##
# rgb([170,187,204])
out = rgb(170, 187, 204) ## AABBCC ##
# out.xyz
out = float3(0.6666667, 0.73333335, 0.8)
# rgb(out)
out = rgb(170, 187, 204) ## AABBCC ##", Category = "Type Vector Constructors")]
        public static void Test_rgb(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateRgba(System.Object[])"/> or `rgba`.
        /// </summary>
        [TestCase(@"rgba(0xFFAABBCC)
rgba(""#FFAABBCC"")
rgba(""FFAABBCC"")
rgba([0xAA,0xBB,0xCC,0xFF])
out.xyzw
rgba(out)", @"# rgba(-5588020)
out = rgba(170, 187, 204, 255) ## AABBCCFF ##
# rgba(""#FFAABBCC"")
out = rgba(170, 187, 204, 255) ## AABBCCFF ##
# rgba(""FFAABBCC"")
out = rgba(170, 187, 204, 255) ## AABBCCFF ##
# rgba([170,187,204,255])
out = rgba(170, 187, 204, 255) ## AABBCCFF ##
# out.xyzw
out = float4(0.6666667, 0.73333335, 0.8, 1)
# rgba(out)
out = rgba(170, 187, 204, 255) ## AABBCCFF ##", Category = "Type Vector Constructors")]
        public static void Test_rgba(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateMatrix(Scriban.Syntax.ScriptVariable,System.Int32,System.Int32,System.Object[])"/> or `matrix`.
        /// </summary>
        [TestCase(@"matrix(float,4,3,1..12)", @"# matrix(float, 4, 3, 1..12)
out = float4x3(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
      # col  0           1           2           / row
      float3(1         , 2         , 3         ) # 0
      float3(4         , 5         , 6         ) # 1
      float3(7         , 8         , 9         ) # 2
      float3(10        , 11        , 12        ) # 3", Category = "Type Matrix Constructors")]
        public static void Test_matrix(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateByte16(System.Object[])"/> or `byte16`.
        /// </summary>
        [TestCase(@"byte16
byte16(1..16)
byte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# byte16
out = byte16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# byte16(1..16)
out = byte16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# byte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = byte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_byte16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateByte32(System.Object[])"/> or `byte32`.
        /// </summary>
        [TestCase(@"byte32
byte32(1..32)", @"# byte32
out = byte32(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# byte32(1..32)
out = byte32(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)", Category = "Type Vector Constructors")]
        public static void Test_byte32(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateByte64(System.Object[])"/> or `byte64`.
        /// </summary>
        [TestCase(@"byte64
byte64(1..64)", @"# byte64
out = byte64(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# byte64(1..64)
out = byte64(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64)", Category = "Type Vector Constructors")]
        public static void Test_byte64(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateSByte16(System.Object[])"/> or `sbyte16`.
        /// </summary>
        [TestCase(@"sbyte16
sbyte16(1..16)
sbyte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# sbyte16
out = sbyte16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# sbyte16(1..16)
out = sbyte16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# sbyte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = sbyte16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_sbyte16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateSByte32(System.Object[])"/> or `sbyte32`.
        /// </summary>
        [TestCase(@"sbyte32
sbyte32(1..32)", @"# sbyte32
out = sbyte32(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# sbyte32(1..32)
out = sbyte32(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)", Category = "Type Vector Constructors")]
        public static void Test_sbyte32(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateSByte64(System.Object[])"/> or `sbyte64`.
        /// </summary>
        [TestCase(@"sbyte64
sbyte64(1..64)", @"# sbyte64
out = sbyte64(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# sbyte64(1..64)
out = sbyte64(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64)", Category = "Type Vector Constructors")]
        public static void Test_sbyte64(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort2(System.Object[])"/> or `short2`.
        /// </summary>
        [TestCase(@"short2
short2(1..2)
short2(10, 11)", @"# short2
out = short2(0, 0)
# short2(1..2)
out = short2(1, 2)
# short2(10, 11)
out = short2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_short2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort4(System.Object[])"/> or `short4`.
        /// </summary>
        [TestCase(@"short4
short4(1..4)
short4(10, 11, 12, 13)", @"# short4
out = short4(0, 0, 0, 0)
# short4(1..4)
out = short4(1, 2, 3, 4)
# short4(10, 11, 12, 13)
out = short4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_short4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort8(System.Object[])"/> or `short8`.
        /// </summary>
        [TestCase(@"short8
short8(1..8)
short8(10, 11, 12, 13, 14, 15, 16, 17)", @"# short8
out = short8(0, 0, 0, 0, 0, 0, 0, 0)
# short8(1..8)
out = short8(1, 2, 3, 4, 5, 6, 7, 8)
# short8(10, 11, 12, 13, 14, 15, 16, 17)
out = short8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_short8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort16(System.Object[])"/> or `short16`.
        /// </summary>
        [TestCase(@"short16
short16(1..16)
short16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# short16
out = short16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# short16(1..16)
out = short16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# short16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = short16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_short16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateShort32(System.Object[])"/> or `short32`.
        /// </summary>
        [TestCase(@"short32
short32(1..32)", @"# short32
out = short32(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# short32(1..32)
out = short32(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)", Category = "Type Vector Constructors")]
        public static void Test_short32(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort2(System.Object[])"/> or `ushort2`.
        /// </summary>
        [TestCase(@"ushort2
ushort2(1..2)
ushort2(10, 11)", @"# ushort2
out = ushort2(0, 0)
# ushort2(1..2)
out = ushort2(1, 2)
# ushort2(10, 11)
out = ushort2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_ushort2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort4(System.Object[])"/> or `ushort4`.
        /// </summary>
        [TestCase(@"ushort4
ushort4(1..4)
ushort4(10, 11, 12, 13)", @"# ushort4
out = ushort4(0, 0, 0, 0)
# ushort4(1..4)
out = ushort4(1, 2, 3, 4)
# ushort4(10, 11, 12, 13)
out = ushort4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_ushort4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort8(System.Object[])"/> or `ushort8`.
        /// </summary>
        [TestCase(@"ushort8
ushort8(1..8)
ushort8(10, 11, 12, 13, 14, 15, 16, 17)", @"# ushort8
out = ushort8(0, 0, 0, 0, 0, 0, 0, 0)
# ushort8(1..8)
out = ushort8(1, 2, 3, 4, 5, 6, 7, 8)
# ushort8(10, 11, 12, 13, 14, 15, 16, 17)
out = ushort8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_ushort8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort16(System.Object[])"/> or `ushort16`.
        /// </summary>
        [TestCase(@"ushort16
ushort16(1..16)
ushort16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# ushort16
out = ushort16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# ushort16(1..16)
out = ushort16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# ushort16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = ushort16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_ushort16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUShort32(System.Object[])"/> or `ushort32`.
        /// </summary>
        [TestCase(@"ushort32
ushort32(1..32)", @"# ushort32
out = ushort32(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# ushort32(1..32)
out = ushort32(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)", Category = "Type Vector Constructors")]
        public static void Test_ushort32(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt2(System.Object[])"/> or `int2`.
        /// </summary>
        [TestCase(@"int2
int2(1..2)
int2(10, 11)", @"# int2
out = int2(0, 0)
# int2(1..2)
out = int2(1, 2)
# int2(10, 11)
out = int2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_int2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt3(System.Object[])"/> or `int3`.
        /// </summary>
        [TestCase(@"int3
int3(1..3)
int3(10, 11, 12)", @"# int3
out = int3(0, 0, 0)
# int3(1..3)
out = int3(1, 2, 3)
# int3(10, 11, 12)
out = int3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_int3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt4(System.Object[])"/> or `int4`.
        /// </summary>
        [TestCase(@"int4
int4(1..4)
int4(10, 11, 12, 13)", @"# int4
out = int4(0, 0, 0, 0)
# int4(1..4)
out = int4(1, 2, 3, 4)
# int4(10, 11, 12, 13)
out = int4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_int4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt8(System.Object[])"/> or `int8`.
        /// </summary>
        [TestCase(@"int8
int8(1..8)
int8(10, 11, 12, 13, 14, 15, 16, 17)", @"# int8
out = int8(0, 0, 0, 0, 0, 0, 0, 0)
# int8(1..8)
out = int8(1, 2, 3, 4, 5, 6, 7, 8)
# int8(10, 11, 12, 13, 14, 15, 16, 17)
out = int8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_int8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateInt16(System.Object[])"/> or `int16`.
        /// </summary>
        [TestCase(@"int16
int16(1..16)
int16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# int16
out = int16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# int16(1..16)
out = int16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# int16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = int16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_int16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt2(System.Object[])"/> or `uint2`.
        /// </summary>
        [TestCase(@"uint2
uint2(1..2)
uint2(10, 11)", @"# uint2
out = uint2(0, 0)
# uint2(1..2)
out = uint2(1, 2)
# uint2(10, 11)
out = uint2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_uint2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt3(System.Object[])"/> or `uint3`.
        /// </summary>
        [TestCase(@"uint3
uint3(1..3)
uint3(10, 11, 12)", @"# uint3
out = uint3(0, 0, 0)
# uint3(1..3)
out = uint3(1, 2, 3)
# uint3(10, 11, 12)
out = uint3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_uint3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt4(System.Object[])"/> or `uint4`.
        /// </summary>
        [TestCase(@"uint4
uint4(1..4)
uint4(10, 11, 12, 13)", @"# uint4
out = uint4(0, 0, 0, 0)
# uint4(1..4)
out = uint4(1, 2, 3, 4)
# uint4(10, 11, 12, 13)
out = uint4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_uint4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt8(System.Object[])"/> or `uint8`.
        /// </summary>
        [TestCase(@"uint8
uint8(1..8)
uint8(10, 11, 12, 13, 14, 15, 16, 17)", @"# uint8
out = uint8(0, 0, 0, 0, 0, 0, 0, 0)
# uint8(1..8)
out = uint8(1, 2, 3, 4, 5, 6, 7, 8)
# uint8(10, 11, 12, 13, 14, 15, 16, 17)
out = uint8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_uint8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateUInt16(System.Object[])"/> or `uint16`.
        /// </summary>
        [TestCase(@"uint16
uint16(1..16)
uint16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# uint16
out = uint16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# uint16(1..16)
out = uint16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# uint16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = uint16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_uint16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong2(System.Object[])"/> or `long2`.
        /// </summary>
        [TestCase(@"long2
long2(1..2)
long2(10, 11)", @"# long2
out = long2(0, 0)
# long2(1..2)
out = long2(1, 2)
# long2(10, 11)
out = long2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_long2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong3(System.Object[])"/> or `long3`.
        /// </summary>
        [TestCase(@"long3
long3(1..3)
long3(10, 11, 12)", @"# long3
out = long3(0, 0, 0)
# long3(1..3)
out = long3(1, 2, 3)
# long3(10, 11, 12)
out = long3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_long3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong4(System.Object[])"/> or `long4`.
        /// </summary>
        [TestCase(@"long4
long4(1..4)
long4(10, 11, 12, 13)", @"# long4
out = long4(0, 0, 0, 0)
# long4(1..4)
out = long4(1, 2, 3, 4)
# long4(10, 11, 12, 13)
out = long4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_long4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateLong8(System.Object[])"/> or `long8`.
        /// </summary>
        [TestCase(@"long8
long8(1..8)
long8(10, 11, 12, 13, 14, 15, 16, 17)", @"# long8
out = long8(0, 0, 0, 0, 0, 0, 0, 0)
# long8(1..8)
out = long8(1, 2, 3, 4, 5, 6, 7, 8)
# long8(10, 11, 12, 13, 14, 15, 16, 17)
out = long8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_long8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong2(System.Object[])"/> or `ulong2`.
        /// </summary>
        [TestCase(@"ulong2
ulong2(1..2)
ulong2(10, 11)", @"# ulong2
out = ulong2(0, 0)
# ulong2(1..2)
out = ulong2(1, 2)
# ulong2(10, 11)
out = ulong2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_ulong2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong3(System.Object[])"/> or `ulong3`.
        /// </summary>
        [TestCase(@"ulong3
ulong3(1..3)
ulong3(10, 11, 12)", @"# ulong3
out = ulong3(0, 0, 0)
# ulong3(1..3)
out = ulong3(1, 2, 3)
# ulong3(10, 11, 12)
out = ulong3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_ulong3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong4(System.Object[])"/> or `ulong4`.
        /// </summary>
        [TestCase(@"ulong4
ulong4(1..4)
ulong4(10, 11, 12, 13)", @"# ulong4
out = ulong4(0, 0, 0, 0)
# ulong4(1..4)
out = ulong4(1, 2, 3, 4)
# ulong4(10, 11, 12, 13)
out = ulong4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_ulong4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateULong8(System.Object[])"/> or `ulong8`.
        /// </summary>
        [TestCase(@"ulong8
ulong8(1..8)
ulong8(10, 11, 12, 13, 14, 15, 16, 17)", @"# ulong8
out = ulong8(0, 0, 0, 0, 0, 0, 0, 0)
# ulong8(1..8)
out = ulong8(1, 2, 3, 4, 5, 6, 7, 8)
# ulong8(10, 11, 12, 13, 14, 15, 16, 17)
out = ulong8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_ulong8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool2(System.Object[])"/> or `bool2`.
        /// </summary>
        [TestCase(@"bool2(true)", @"# bool2(true)
out = bool2(true, true)", Category = "Type Vector Constructors")]
        public static void Test_bool2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool3(System.Object[])"/> or `bool3`.
        /// </summary>
        [TestCase(@"bool3(true)", @"# bool3(true)
out = bool3(true, true, true)", Category = "Type Vector Constructors")]
        public static void Test_bool3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool4(System.Object[])"/> or `bool4`.
        /// </summary>
        [TestCase(@"bool4(true)", @"# bool4(true)
out = bool4(true, true, true, true)", Category = "Type Vector Constructors")]
        public static void Test_bool4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool8(System.Object[])"/> or `bool8`.
        /// </summary>
        [TestCase(@"bool8(true)", @"# bool8(true)
out = bool8(true, true, true, true, true, true, true, true)", Category = "Type Vector Constructors")]
        public static void Test_bool8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateBool16(System.Object[])"/> or `bool16`.
        /// </summary>
        [TestCase(@"bool16(true)", @"# bool16(true)
out = bool16(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true)", Category = "Type Vector Constructors")]
        public static void Test_bool16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat2(System.Object[])"/> or `float2`.
        /// </summary>
        [TestCase(@"float2
float2(1..2)
float2(10, 11)", @"# float2
out = float2(0, 0)
# float2(1..2)
out = float2(1, 2)
# float2(10, 11)
out = float2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_float2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat3(System.Object[])"/> or `float3`.
        /// </summary>
        [TestCase(@"float3
float3(1..3)
float3(10, 11, 12)", @"# float3
out = float3(0, 0, 0)
# float3(1..3)
out = float3(1, 2, 3)
# float3(10, 11, 12)
out = float3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_float3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat4(System.Object[])"/> or `float4`.
        /// </summary>
        [TestCase(@"float4
float4(1..4)
float4(10, 11, 12, 13)", @"# float4
out = float4(0, 0, 0, 0)
# float4(1..4)
out = float4(1, 2, 3, 4)
# float4(10, 11, 12, 13)
out = float4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_float4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat8(System.Object[])"/> or `float8`.
        /// </summary>
        [TestCase(@"float8
float8(1..8)
float8(10, 11, 12, 13, 14, 15, 16, 17)", @"# float8
out = float8(0, 0, 0, 0, 0, 0, 0, 0)
# float8(1..8)
out = float8(1, 2, 3, 4, 5, 6, 7, 8)
# float8(10, 11, 12, 13, 14, 15, 16, 17)
out = float8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_float8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateFloat16(System.Object[])"/> or `float16`.
        /// </summary>
        [TestCase(@"float16
float16(1..16)
float16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# float16
out = float16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# float16(1..16)
out = float16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# float16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = float16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_float16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateDouble2(System.Object[])"/> or `double2`.
        /// </summary>
        [TestCase(@"double2
double2(1..2)
double2(10, 11)", @"# double2
out = double2(0, 0)
# double2(1..2)
out = double2(1, 2)
# double2(10, 11)
out = double2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_double2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateDouble3(System.Object[])"/> or `double3`.
        /// </summary>
        [TestCase(@"double3
double3(1..3)
double3(10, 11, 12)", @"# double3
out = double3(0, 0, 0)
# double3(1..3)
out = double3(1, 2, 3)
# double3(10, 11, 12)
out = double3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_double3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateDouble4(System.Object[])"/> or `double4`.
        /// </summary>
        [TestCase(@"double4
double4(1..4)
double4(10, 11, 12, 13)", @"# double4
out = double4(0, 0, 0, 0)
# double4(1..4)
out = double4(1, 2, 3, 4)
# double4(10, 11, 12, 13)
out = double4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_double4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateDouble8(System.Object[])"/> or `double8`.
        /// </summary>
        [TestCase(@"double8
double8(1..8)
double8(10, 11, 12, 13, 14, 15, 16, 17)", @"# double8
out = double8(0, 0, 0, 0, 0, 0, 0, 0)
# double8(1..8)
out = double8(1, 2, 3, 4, 5, 6, 7, 8)
# double8(10, 11, 12, 13, 14, 15, 16, 17)
out = double8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_double8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf2(System.Object[])"/> or `half2`.
        /// </summary>
        [TestCase(@"half2
half2(1..2)
half2(10, 11)", @"# half2
out = half2(0, 0)
# half2(1..2)
out = half2(1, 2)
# half2(10, 11)
out = half2(10, 11)", Category = "Type Vector Constructors")]
        public static void Test_half2(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf3(System.Object[])"/> or `half3`.
        /// </summary>
        [TestCase(@"half3
half3(1..3)
half3(10, 11, 12)", @"# half3
out = half3(0, 0, 0)
# half3(1..3)
out = half3(1, 2, 3)
# half3(10, 11, 12)
out = half3(10, 11, 12)", Category = "Type Vector Constructors")]
        public static void Test_half3(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf4(System.Object[])"/> or `half4`.
        /// </summary>
        [TestCase(@"half4
half4(1..4)
half4(10, 11, 12, 13)", @"# half4
out = half4(0, 0, 0, 0)
# half4(1..4)
out = half4(1, 2, 3, 4)
# half4(10, 11, 12, 13)
out = half4(10, 11, 12, 13)", Category = "Type Vector Constructors")]
        public static void Test_half4(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf8(System.Object[])"/> or `half8`.
        /// </summary>
        [TestCase(@"half8
half8(1..8)
half8(10, 11, 12, 13, 14, 15, 16, 17)", @"# half8
out = half8(0, 0, 0, 0, 0, 0, 0, 0)
# half8(1..8)
out = half8(1, 2, 3, 4, 5, 6, 7, 8)
# half8(10, 11, 12, 13, 14, 15, 16, 17)
out = half8(10, 11, 12, 13, 14, 15, 16, 17)", Category = "Type Vector Constructors")]
        public static void Test_half8(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf16(System.Object[])"/> or `half16`.
        /// </summary>
        [TestCase(@"half16
half16(1..16)
half16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", @"# half16
out = half16(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# half16(1..16)
out = half16(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
# half16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)
out = half16(10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)", Category = "Type Vector Constructors")]
        public static void Test_half16(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.TypesModule.CreateHalf32(System.Object[])"/> or `half32`.
        /// </summary>
        [TestCase(@"half32
half32(1..32)", @"# half32
out = half32(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
# half32(1..32)
out = half32(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32)", Category = "Type Vector Constructors")]
        public static void Test_half32(string input, string output) => AssertScript(input, output);

    }

    public partial class VectorModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Length(System.Object)"/> or `length`.
        /// </summary>
        [TestCase(@"length float2(1, 2)
length -5", @"# length(float2(1, 2))
out = 2.23606797749979
# length(-5)
out = 5", Category = "Math Vector/Matrix Functions")]
        public static void Test_length(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Normalize(System.Object)"/> or `normalize`.
        /// </summary>
        [TestCase(@"normalize float2(1,2)", @"# normalize(float2(1, 2))
out = float2(0.4472136, 0.8944272)", Category = "Math Vector/Matrix Functions")]
        public static void Test_normalize(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Dot(System.Object,System.Object)"/> or `dot`.
        /// </summary>
        [TestCase(@"dot(float3(1,2,3), float3(4,5,6))
dot(float3(1,2,3), 4)
dot(4, float3(1,2,3))
dot(5,6)", @"# dot(float3(1, 2, 3), float3(4, 5, 6))
out = 32
# dot(float3(1, 2, 3), 4)
out = 24
# dot(4, float3(1, 2, 3))
out = 24
# dot(5, 6)
out = 30", Category = "Math Vector/Matrix Functions")]
        public static void Test_dot(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Cross(Kalk.Core.KalkVector,Kalk.Core.KalkVector)"/> or `cross`.
        /// </summary>
        [TestCase(@"cross(float3(1,2,3), float3(4,5,6))
cross(float3(1,0,0), float3(0,1,0))
cross(float3(0,0,1), float3(0,1,0))", @"# cross(float3(1, 2, 3), float3(4, 5, 6))
out = float3(-3, 6, -3)
# cross(float3(1, 0, 0), float3(0, 1, 0))
out = float3(0, 0, 1)
# cross(float3(0, 0, 1), float3(0, 1, 0))
out = float3(-1, 0, 0)", Category = "Math Vector/Matrix Functions")]
        public static void Test_cross(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Transpose(Kalk.Core.KalkMatrix)"/> or `transpose`.
        /// </summary>
        [TestCase(@"transpose float3x4(1..12)
transpose(out)", @"# transpose(float3x4(1..12))
out = float4x3(1, 5, 9, 2, 6, 10, 3, 7, 11, 4, 8, 12)
      # col  0           1           2           / row
      float3(1         , 5         , 9         ) # 0
      float3(2         , 6         , 10        ) # 1
      float3(3         , 7         , 11        ) # 2
      float3(4         , 8         , 12        ) # 3
# transpose(out)
out = float3x4(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
      # col  0           1           2           3           / row
      float4(1         , 2         , 3         , 4         ) # 0
      float4(5         , 6         , 7         , 8         ) # 1
      float4(9         , 10        , 11        , 12        ) # 2", Category = "Math Vector/Matrix Functions")]
        public static void Test_transpose(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Identity(Kalk.Core.KalkMatrix)"/> or `identity`.
        /// </summary>
        [TestCase(@"identity(float4x4)", @"# identity(float4x4)
out = float4x4(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1)
      # col  0           1           2           3           / row
      float4(1         , 0         , 0         , 0         ) # 0
      float4(0         , 1         , 0         , 0         ) # 1
      float4(0         , 0         , 1         , 0         ) # 2
      float4(0         , 0         , 0         , 1         ) # 3", Category = "Math Vector/Matrix Functions")]
        public static void Test_identity(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Determinant(Kalk.Core.KalkMatrix)"/> or `determinant`.
        /// </summary>
        [TestCase(@"float4x4(4,3,2,2,0,1,-3,3,0,-1,3,3,0,3,1,1)
determinant out", @"# float4x4(4, 3, 2, 2, 0, 1, -3, 3, 0, -1, 3, 3, 0, 3, 1, 1)
out = float4x4(4, 3, 2, 2, 0, 1, -3, 3, 0, -1, 3, 3, 0, 3, 1, 1)
      # col  0            1           2          3           / row
      float4(4         ,  3        ,  2        , 2         ) # 0
      float4(0         ,  1        , -3        , 3         ) # 1
      float4(0         , -1        ,  3        , 3         ) # 2
      float4(0         ,  3        ,  1        , 1         ) # 3
# determinant(out)
out = -240", Category = "Math Vector/Matrix Functions")]
        public static void Test_determinant(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Inverse(Kalk.Core.KalkMatrix)"/> or `inverse`.
        /// </summary>
        [TestCase(@"inverse(float3x3(10,20,10,4,5,6,2,3,5))", @"# inverse(float3x3(10, 20, 10, 4, 5, 6, 2, 3, 5))
out = float3x3(-0.1, 1, -1, 0.11428571, -0.42857143, 0.28571427, -0.028571427, -0.14285715, 0.42857143)
      # col   0             1            2           / row
      float3(-0.1        ,  1         , -1         ) # 0
      float3( 0.11428571 , -0.42857143,  0.28571427) # 1
      float3(-0.028571427, -0.14285715,  0.42857143) # 2", Category = "Math Vector/Matrix Functions")]
        public static void Test_inverse(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Diagonal(System.Object)"/> or `diag`.
        /// </summary>
        [TestCase(@"diag(float4x4(1..16))
diag(float4(1,2,3,4))", @"# diag(float4x4(1..16))
out = float4(1, 6, 11, 16)
# diag(float4(1, 2, 3, 4))
out = float4x4(1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0, 0, 0, 4)
      # col  0           1           2           3           / row
      float4(1         , 0         , 0         , 0         ) # 0
      float4(0         , 2         , 0         , 0         ) # 1
      float4(0         , 0         , 3         , 0         ) # 2
      float4(0         , 0         , 0         , 4         ) # 3", Category = "Math Vector/Matrix Functions")]
        public static void Test_diag(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.GetRow(Kalk.Core.KalkMatrix,System.Int32)"/> or `row`.
        /// </summary>
        [TestCase(@"row(float4x4(1..16), 2)", @"# row(float4x4(1..16), 2)
out = float4(9, 10, 11, 12)", Category = "Math Vector/Matrix Functions")]
        public static void Test_row(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.GetColumn(Kalk.Core.KalkMatrix,System.Int32)"/> or `col`.
        /// </summary>
        [TestCase(@"col(float4x4(1..16), 2)", @"# col(float4x4(1..16), 2)
out = float4(3, 7, 11, 15)", Category = "Math Vector/Matrix Functions")]
        public static void Test_col(string input, string output) => AssertScript(input, output);

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.VectorModule.Multiply(System.Object,System.Object)"/> or `mul`.
        /// </summary>
        [TestCase(@"mul(float4(1,2,3,4), float4(5,6,7,8))
mul(float3(3,7,5), float3x3(2,3,-4,11,8,7,2,5,3))
mul(float3x3(2,3,-4,11,8,7,2,5,3), float3(3,7,5))
mul(float3x3(2,7,4,3,2,1,9,-1,2), float3x3(1,4,6,-1,-2,5,8,7,6))", @"# mul(float4(1, 2, 3, 4), float4(5, 6, 7, 8))
out = 70
# mul(float3(3, 7, 5), float3x3(2, 3, -4, 11, 8, 7, 2, 5, 3))
out = float3(7, 124, 56)
# mul(float3x3(2, 3, -4, 11, 8, 7, 2, 5, 3), float3(3, 7, 5))
out = float3(93, 90, 52)
# mul(float3x3(2, 7, 4, 3, 2, 1, 9, -1, 2), float3x3(1, 4, 6, -1, -2, 5, 8, 7, 6))
out = float3x3(68, 9, 20, 37, -16, 4, 91, 64, 51)
      # col  0            1          2           / row
      float3(68        ,  9        , 20        ) # 0
      float3(37        , -16       , 4         ) # 1
      float3(91        ,  64       , 51        ) # 2", Category = "Math Vector/Matrix Functions")]
        public static void Test_mul(string input, string output) => AssertScript(input, output);

    }

    public partial class WebModuleTests : KalkTestBase
    {
        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.UrlEncode(System.String)"/> or `url_encode`.
        /// </summary>
        [TestCase(@"url_encode ""this<is>an:url and another part""", @"# url_encode(""this<is>an:url and another part"")
out = ""this%3Cis%3Ean%3Aurl+and+another+part""", Category = "Web & Html Functions")]
        public static void Test_url_encode(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.UrlDecode(System.String)"/> or `url_decode`.
        /// </summary>
        [TestCase(@"url_decode ""this%3Cis%3Ean%3Aurl+and+another+part""", @"# url_decode(""this%3Cis%3Ean%3Aurl+and+another+part"")
out = ""this<is>an:url and another part""", Category = "Web & Html Functions")]
        public static void Test_url_decode(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.UrlEscape(System.String)"/> or `url_escape`.
        /// </summary>
        [TestCase(@"""<hello> & <scriban>"" |> url_escape", @"# ""<hello> & <scriban>"" |> url_escape
out = ""%3Chello%3E%20&%20%3Cscriban%3E""", Category = "Web & Html Functions")]
        public static void Test_url_escape(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.HtmlEncode(System.String)"/> or `html_encode`.
        /// </summary>
        [TestCase(@"""<p>This is a paragraph</p>"" |> html_encode
out |> html_decode", @"# ""<p>This is a paragraph</p>"" |> html_encode
out = ""&lt;p&gt;This is a paragraph&lt;/p&gt;""
# out |> html_decode
out = ""<p>This is a paragraph</p>""", Category = "Web & Html Functions")]
        public static void Test_html_encode(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.HtmlDecode(System.String)"/> or `html_decode`.
        /// </summary>
        [TestCase(@"""<p>This is a paragraph</p>"" |> html_encode
out |> html_decode", @"# ""<p>This is a paragraph</p>"" |> html_encode
out = ""&lt;p&gt;This is a paragraph&lt;/p&gt;""
# out |> html_decode
out = ""<p>This is a paragraph</p>""", Category = "Web & Html Functions")]
        public static void Test_html_decode(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.Json(System.Object)"/> or `json`.
        /// </summary>
        [TestCase(@"json {a: 1, b: 2, c: [4,5], d: ""Hello World""}
json out", @"# json({a: 1, b: 2, c: [4,5], d: ""Hello World""})
out = ""{\""a\"": 1, \""b\"": 2, \""c\"": [4, 5], \""d\"": \""Hello World\""}""
# json(out)
out = {a: 1, b: 2, c: [4, 5], d: ""Hello World""}", Category = "Web & Html Functions")]
        public static void Test_json(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.HtmlStrip(System.String)"/> or `html_strip`.
        /// </summary>
        [TestCase(@"""<p>This is a paragraph</p>"" |> html_strip", @"# ""<p>This is a paragraph</p>"" |> html_strip
out = ""This is a paragraph""", Category = "Web & Html Functions")]
        public static void Test_html_strip(string input, string output) => AssertScript(input, output, "Web");

        /// <summary>
        /// Test for <see cref="M:Kalk.Core.Modules.WebModule.WebGet(System.String)"/> or `wget`.
        /// </summary>
        [TestCase(@"wget ""https://api.exchangeratesapi.io""", @"# wget(""https://api.exchangeratesapi.io"")
out = {version: ""1.1"", code: 200, reason: ""OK"", headers: {""Content-Type"": ""application/json"", ""Content-Length"": 41}, content: {details: ""https://exchangeratesapi.io""}}", Category = "Web & Html Functions")]
        public static void Test_wget(string input, string output) => AssertScript(input, output, "Web");

    }
}
