// Shard 1.

// Copyright 2016 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Flags: --allow-natives-syntax --no-always-opt

// This test file was generated by tools/gen-inlining-tests.py .

// Global variables
var deopt = undefined; // either true or false
var counter = 0;

function resetState() {
  counter = 0;
}

function warmUp(f) {
  try {
    f();
  } catch (ex) {
    // ok
  }
  try {
    f();
  } catch (ex) {
    // ok
  }
}

function resetOptAndAssertResultEquals(expected, f) {
  warmUp(f);
  resetState();
  // %DebugPrint(f);
  eval("'dont optimize this function itself please, but do optimize f'");
  %OptimizeFunctionOnNextCall(f);
  assertEquals(expected, f());
}

function resetOptAndAssertThrowsWith(expected, f) {
  warmUp(f);
  resetState();
  // %DebugPrint(f);
  eval("'dont optimize this function itself please, but do optimize f'");
  %OptimizeFunctionOnNextCall(f);
  try {
    var result = f();
    fail("resetOptAndAssertThrowsWith",
        "exception: " + expected,
        "result: " + result);
  } catch (ex) {
    assertEquals(expected, ex);
  }
}

function increaseAndReturn15() {
  if (deopt) %DeoptimizeFunction(f);
  counter++;
  return 15;
}

function increaseAndThrow42() {
  if (deopt) %DeoptimizeFunction(f);
  counter++;
  throw 42;
}

function increaseAndReturn15_noopt_inner() {
  if (deopt) %DeoptimizeFunction(f);
  counter++;
  return 15;
}

%NeverOptimizeFunction(increaseAndReturn15_noopt_inner);

function increaseAndThrow42_noopt_inner() {
  if (deopt) %DeoptimizeFunction(f);
  counter++;
  throw 42;
}

%NeverOptimizeFunction(increaseAndThrow42_noopt_inner);

// Alternative 1

function returnOrThrow(doReturn) {
  if (doReturn) {
    return increaseAndReturn15();
  } else {
    return increaseAndThrow42();
  }
}

// Alternative 2

function increaseAndReturn15_calls_noopt() {
  return increaseAndReturn15_noopt_inner();
}

function increaseAndThrow42_calls_noopt() {
  return increaseAndThrow42_noopt_inner();
}

// Alternative 3.
// When passed either {increaseAndReturn15} or {increaseAndThrow42}, it acts
// as the other one.
function invertFunctionCall(f) {
  var result;
  try {
    result = f();
  } catch (ex) {
    return ex - 27;
  }
  throw result + 27;
}

// Alternative 4: constructor
function increaseAndStore15Constructor() {
  if (deopt) %DeoptimizeFunction(f);
  ++counter;
  this.x = 15;
}

function increaseAndThrow42Constructor() {
  if (deopt) %DeoptimizeFunction(f);
  ++counter;
  this.x = 42;
  throw this.x;
}

// Alternative 5: property
var magic = {};
Object.defineProperty(magic, 'prop', {
  get: function () {
    if (deopt) %DeoptimizeFunction(f);
    return 15 + 0 * ++counter;
  },

  set: function(x) {
    // argument should be 37
    if (deopt) %DeoptimizeFunction(f);
    counter -= 36 - x; // increments counter
    throw 42;
  }
})

// Generate type feedback.

assertEquals(15, increaseAndReturn15_calls_noopt());
assertThrowsEquals(function() { return increaseAndThrow42_noopt_inner() }, 42);

assertEquals(15, (new increaseAndStore15Constructor()).x);
assertThrowsEquals(function() {
        return (new increaseAndThrow42Constructor()).x;
    },
    42);

function runThisShard() {

  // Variant flags: [tryReturns, doFinally]

  f = function f_______r______f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryReturns, doFinally, finallyThrows]

  f = function f_______r______f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doFinally, finallyReturns]

  f = function f_______r______fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch]

  f = function f_______r__c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, deopt]

  f = function f_______r__c_______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, doFinally]

  f = function f_______r__c___f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryReturns, doCatch, doFinally, finallyThrows]

  f = function f_______r__c___f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch, doFinally, finallyReturns]

  f = function f_______r__c___fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch, catchThrows]

  f = function f_______r__c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, catchThrows, deopt]

  f = function f_______r__c__t____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, catchThrows, doFinally]

  f = function f_______r__c__tf____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryReturns, doCatch, catchThrows, doFinally,
  //   finallyThrows]

  f = function f_______r__c__tf_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch, catchThrows, doFinally,
  //   finallyReturns]

  f = function f_______r__c__tfr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch, catchReturns]

  f = function f_______r__cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, catchReturns, deopt]

  f = function f_______r__cr______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryReturns, doCatch, catchReturns, doFinally]

  f = function f_______r__cr__f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryReturns, doCatch, catchReturns, doFinally,
  //   finallyThrows]

  f = function f_______r__cr__f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryReturns, doCatch, catchReturns, doFinally,
  //   finallyReturns]

  f = function f_______r__cr__fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doFinally]

  f = function f______t_______f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(42, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, doFinally, finallyThrows]

  f = function f______t_______f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doFinally, finallyReturns]

  f = function f______t_______fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doCatch]

  f = function f______t___c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, deopt]

  f = function f______t___c_______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, doFinally]

  f = function f______t___c___f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(7, counter);

  // Variant flags: [tryThrows, doCatch, doFinally, finallyThrows]

  f = function f______t___c___f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, doFinally, finallyReturns]

  f = function f______t___c___fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, catchThrows]

  f = function f______t___c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doCatch, catchThrows, deopt]

  f = function f______t___c__t____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doCatch, catchThrows, doFinally]

  f = function f______t___c__tf____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, catchThrows, doFinally,
  //   finallyThrows]

  f = function f______t___c__tf_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, doCatch, catchThrows, doFinally,
  //   finallyReturns]

  f = function f______t___c__tfr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, doCatch, catchReturns]

  f = function f______t___cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doCatch, catchReturns, deopt]

  f = function f______t___cr______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, doCatch, catchReturns, doFinally]

  f = function f______t___cr__f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, doCatch, catchReturns, doFinally,
  //   finallyThrows]

  f = function f______t___cr__f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, doCatch, catchReturns, doFinally,
  //   finallyReturns]

  f = function f______t___cr__fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, doFinally]

  f = function f______tr______f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(42, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, doFinally, finallyThrows]

  f = function f______tr______f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, doFinally, finallyReturns]

  f = function f______tr______fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch]

  f = function f______tr__c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, doFinally]

  f = function f______tr__c___f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(7, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, doFinally,
  //   finallyThrows]

  f = function f______tr__c___f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, doFinally,
  //   finallyReturns]

  f = function f______tr__c___fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchThrows]

  f = function f______tr__c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchThrows,
  //   doFinally]

  f = function f______tr__c__tf____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchThrows,
  //   doFinally, finallyThrows]

  f = function f______tr__c__tf_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchThrows,
  //   doFinally, finallyReturns]

  f = function f______tr__c__tfr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchReturns]

  f = function f______tr__cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchReturns,
  //   doFinally]

  f = function f______tr__cr__f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(5, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchReturns,
  //   doFinally, finallyThrows]

  f = function f______tr__cr__f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, doCatch, catchReturns,
  //   doFinally, finallyReturns]

  f = function f______tr__cr__fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndThrow42();
      return 4 + increaseAndReturn15();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns,
  //   doFinally]

  f = function f______trf_____f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns,
  //   doFinally, finallyThrows]

  f = function f______trf_____f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns,
  //   doFinally, finallyReturns]

  f = function f______trf_____fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch]

  f = function f______trf_c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   doFinally]

  f = function f______trf_c___f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   doFinally, finallyThrows]

  f = function f______trf_c___f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   doFinally, finallyReturns]

  f = function f______trf_c___fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchThrows]

  f = function f______trf_c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchThrows, doFinally]

  f = function f______trf_c__tf____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchThrows, doFinally, finallyThrows]

  f = function f______trf_c__tf_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchThrows, doFinally, finallyReturns]

  f = function f______trf_c__tfr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchReturns]

  f = function f______trf_cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchReturns, doFinally]

  f = function f______trf_cr__f____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      local += 2;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(4, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchReturns, doFinally, finallyThrows]

  f = function f______trf_cr__f_t__ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      throw 25;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(25, f);
  assertEquals(3, counter);

  // Variant flags: [tryThrows, tryReturns, tryFirstReturns, doCatch,
  //   catchReturns, doFinally, finallyReturns]

  f = function f______trf_cr__fr___ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + increaseAndReturn15();
      return 4 + increaseAndThrow42();
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    } finally {
      counter++;
      return 3 + local;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(891, f);
  assertEquals(3, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch]

  f = function f_____1_r__c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch, deopt]

  f = function f_____1_r__c_______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch, catchThrows]

  f = function f_____1_r__c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch, catchThrows,
  //   deopt]

  f = function f_____1_r__c__t____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch,
  //   catchReturns]

  f = function f_____1_r__cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryReturns, doCatch,
  //   catchReturns, deopt]

  f = function f_____1_r__cr______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(true);
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch]

  f = function f_____1t___c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(5, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch, deopt]

  f = function f_____1t___c_______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(undefined, f);
  assertEquals(5, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch, catchThrows]

  f = function f_____1t___c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(3, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch, catchThrows,
  //   deopt]

  f = function f_____1t___c__t____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertThrowsWith(44, f);
  assertEquals(3, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch, catchReturns]

  f = function f_____1t___cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(3, counter);

  // Variant flags: [alternativeFn1, tryThrows, doCatch, catchReturns,
  //   deopt]

  f = function f_____1t___cr______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + returnOrThrow(false);
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(44, f);
  assertEquals(3, counter);

  // Variant flags: [alternativeFn2, tryReturns, doCatch,
  //   catchWithLocal, endReturnLocal, deopt]

  f = function f____2__r__c_l____ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndReturn15_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn2, tryReturns, tryResultToLocal,
  //   doCatch, endReturnLocal, deopt]

  f = function f____2__r_lc______ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      local += 4 + increaseAndReturn15_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(912, f);
  assertEquals(4, counter);

  // Variant flags: [alternativeFn2, tryReturns, tryResultToLocal,
  //   doCatch, catchWithLocal, endReturnLocal, deopt]

  f = function f____2__r_lc_l____ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      local += 4 + increaseAndReturn15_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(912, f);
  assertEquals(4, counter);

  // Variant flags: [alternativeFn2, tryThrows, doCatch,
  //   catchWithLocal, endReturnLocal, deopt]

  f = function f____2_t___c_l____ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + increaseAndThrow42_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(935, f);
  assertEquals(5, counter);

  // Variant flags: [alternativeFn2, tryThrows, tryResultToLocal,
  //   doCatch, endReturnLocal, deopt]

  f = function f____2_t__lc______ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      local += 4 + increaseAndThrow42_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(893, f);
  assertEquals(5, counter);

  // Variant flags: [alternativeFn2, tryThrows, tryResultToLocal,
  //   doCatch, catchWithLocal, endReturnLocal, deopt]

  f = function f____2_t__lc_l____ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      local += 4 + increaseAndThrow42_calls_noopt();
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(935, f);
  assertEquals(5, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch]

  f = function f___3___r__c________ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch, deopt]

  f = function f___3___r__c_______d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch, catchThrows]

  f = function f___3___r__c__t_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch, catchThrows,
  //   deopt]

  f = function f___3___r__c__t____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal]

  f = function f___3___r__c_l______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, deopt]

  f = function f___3___r__c_l_____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, endReturnLocal]

  f = function f___3___r__c_l____l_ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, endReturnLocal, deopt]

  f = function f___3___r__c_l____ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      local += ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, catchThrows]

  f = function f___3___r__c_lt_____ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, catchThrows, deopt]

  f = function f___3___r__c_lt____d () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, catchThrows, endReturnLocal]

  f = function f___3___r__c_lt___l_ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchWithLocal, catchThrows, endReturnLocal, deopt]

  f = function f___3___r__c_lt___ld () {
    var local = 888;
    deopt = true;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      throw 2 + ex;
      counter++;
    }
    counter++;
    return 5 + local;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

  // Variant flags: [alternativeFn3, tryReturns, doCatch,
  //   catchReturns]

  f = function f___3___r__cr_______ () {
    var local = 888;
    deopt = false;
    try {
      counter++;
      return 4 + invertFunctionCall(increaseAndThrow42);
      counter++;
    } catch (ex) {
      counter++;
      return 2 + ex;
      counter++;
    }
    counter++;
  }
  resetOptAndAssertResultEquals(19, f);
  assertEquals(2, counter);

}
%NeverOptimizeFunction(runThisShard);

// 97 tests in this shard.
// 97 tests up to here.

runThisShard();
