// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: "a2102214b151421124f462d37f843",
  b: "90f3fa0f2fb9b1481b1a4737586ad6bdf71cb2ae51e06fdcb00fb779163e94ae4237",
  r: "90f3fa0f2fb9b1481b1a4737586ad6bdf71cb2b872e29127c523d88b6584c1e63a7a"
}, {
  a: "35ca28bdd383c1b9ffdb851cc7f385ad370eef3d",
  b: "-ca2d4dd677f23e005f44ec121303c3c304940eb2fd15e9e88772a3c5ba8515",
  r: "-ca2d4dd677f23e005f44ebdc48db05ef80d254b32190cd2093ecf68eab95d8"
}, {
  a: "-8abb4b6ca534b584fad2f5898dd22ae6",
  b: "0",
  r: "-8abb4b6ca534b584fad2f5898dd22ae6"
}, {
  a: "b3",
  b: "4180a0a",
  r: "4180abd"
}, {
  a: "-8de89",
  b: "c329fbab24d762a9453f90b134fcf5da9777aa1fdb26b74f27583a92a43f0f2c450",
  r: "c329fbab24d762a9453f90b134fcf5da9777aa1fdb26b74f27583a92a43f0e9e5c7"
}, {
  a: "-49af5f350d64c75047dfb107550dae478c983dd520e86c9807b1f5",
  b: "60a62691669b8c323a29db2eb9cb75ba5811",
  r: "-49af5f350d64c750477f0ae0c3a712bb5a5e13f9f22ea1224d59e4"
}, {
  a: "80bf614aaa1140792099375f7fac9c7046303a8d13086755d505795f38761",
  b: "-949dc945",
  r: "80bf614aaa1140792099375f7fac9c7046303a8d13086755d50570155be1c"
}, {
  a: "4241d736e6a40",
  b: "-78e88f5eaeae4ff8b",
  r: "-78e84d1cd7776954b"
}, {
  a: "-8033927bf52210827b99e712fb220631503adfaa4e0045c872b9b",
  b: "-2f",
  r: "-8033927bf52210827b99e712fb220631503adfaa4e0045c872bca"
}, {
  a: "-3ad8b67efe9",
  b: "-35586bf43788fd8e313da33c62d9a5",
  r: "-35586bf43788fd8e314150c7cac98e"
}, {
  a: "-a43d8c9af54e8ea545e1af4674613932650c833669c7adc9273b77",
  b: "-6a4",
  r: "-a43d8c9af54e8ea545e1af4674613932650c833669c7adc927421b"
}, {
  a: "26c178e22dd42280a59b",
  b: "fba77d85ba082981ce4a1ca21ac8b805b389297dc",
  r: "fba77d85ba082981ce4a1f0e3256dae2f5b133d77"
}, {
  a: "-c9bc2ac82920efc63fa48f63fae105ec432672b50269fad72ee8b44a1",
  b: "8967d49deeff878f40fa1bf408400b8085820d47b",
  r: "-c9bc2ac82920efc5b63cbac60be17e5d022c56c0fa29ef56a966a7026"
}, {
  a: "815a18c9a2d8c6e5f3fffa958430851c4ea3",
  b: "59d451c6efad276d3cc393907dda0eca463488958f397bb09",
  r: "59d451c6efad2f82de502dbe0a486e0a45dde0d8978b409ac"
}, {
  a: "8cfc360e8d215045cb5c289a50e5c7fa9da34c0b9d9be9597e6e476efdb121",
  b: "-482747619f0edd06",
  r: "8cfc360e8d215045cb5c289a50e5c7fa9da34c0b9d9be9115726e5cfeed41b"
}, {
  a: "346337dbb9bbfc08cb815434c50315d32d",
  b: "-ac569f54f5ea8852463c7542e876a9953",
  r: "299dcde66a5d5383a71d8ce0967bab39da"
}, {
  a: "8bb7c3e56",
  b: "-c334d52ed6eb903256253e01fc0c5118fe9bc",
  r: "-c334d52ed6eb903256253e01fc0bc5613ab66"
}, {
  a: "b1f444a7a95e6d1d293ff0182e3dd5e945234484a5b47516b5b42627ed54fa8cf1221e",
  b: "-93b77e906778b7e0a85c07e08babe730edd93ed37adef19da9e76de2add3",
  r: "b1f444a7a8cab59e98d877604d9579e16497989d74c69bd7e23947364fab131f0e744b"
}, {
  a: "9a156524b9",
  b: "-bce28d1561fc0153b836c6e0969d2674fcb960331cdb55df24e34e4b65136fcb59",
  r: "-bce28d1561fc0153b836c6e0969d2674fcb960331cdb55df24e34e4acafe0aa6a0"
}, {
  a: "5eaf418fbccefb4f53abc413c02cee60eb3880b615c615c2005b3d11c8ee4aaf3b4ded8",
  b: "-eb8aa4a72cf44f06208",
  r: "5eaf418fbccefb4f53abc413c02cee60eb3880b615c615c2005a518724471dbaec47cd0"
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var a = BigInt.parseInt(d.a, 16);
  var b = BigInt.parseInt(d.b, 16);
  var r = a + b;
  if (d.r !== r.toString(16)) {
    print("Input A:  " + a.toString(16));
    print("Input B:  " + b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: +");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
