// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: "-67c2a5ba4221c048b64ecca6dd979391c44296b8b87ce97584ebab03be18",
  b: "-bebdbd9b278d05704416fd87d09aece9b69f98843",
  r: "-8794ba5d9204eb8adfb5e44c11a65fe5af057e6a4"
}, {
  a: "-843cfbe576106b8e7c0aabec2cde402e7f76a711dbbf6ae79d6d932e22cf",
  b: "553d800ffcf69f80026",
  r: "-272250d344908c21525"
}, {
  a: "-b5fc9e8e21fbad798bcd3571ab169dd5e2059d1a9aa4d1bf44fe18da725b",
  b: "-da5d287414fbb2b4b",
  r: "-2610eb2277e01a758"
}, {
  a: "a9c92d42b53a6fbf0824f5b7bd9ed1cab1f9419d7ec2b50f192abfa6d620d53",
  b: "9de30592e1fe27d26afe06bbb4781c77ef58418",
  r: "9a67af5868a619a48883aed4c0d0a876e2ce143"
}, {
  a: "ffa271b138163a779c89f17aa720490854520120b1307ef",
  b: "ab27ef49f3a00085981a5bc1c13530aec35e29c",
  r: "4c49a63b98d2dd7a33a843f98ba82b54909e337"
}, {
  a: "d43f739464bcc8643dfaa807cbbe1157189e33368dd19b800db3682bb0dcb73",
  b: "bf66b1dc93054920039f9b3eba688d9",
  r: "bb2f3000959d66b3962d755d141c3ac"
}, {
  a: "111ae5ba62ec37fd157ef531195363c5c8ace4427ff58811746af94ab8",
  b: "58112d0d88f3c8722d1e28942e8949c433c4619b451",
  r: "283276aa2b6316ca2146b1e6bcc8aa8de4b5446847a"
}, {
  a: "-4609a1c7d563bbdb49fd01e05031395e6e06b78407e440",
  b: "-75ee71f85344163bae2ba0e438",
  r: "-68b517938971cb261babea1cf8"
}, {
  a: "292cd2c5eb3e80942066c5af8bfdaf8d1d091f61f3005d226318",
  b: "5",
  r: "3"
}, {
  a: "-a9f8c03f06200b54959a2ced325090be25417f0bf1274d",
  b: "13eb3a0c772fc98e537883a3ef72e1ee37b249ee17c0510",
  r: "-a9f8c03f06200b54959a2ced325090be25417f0bf1274d"
}, {
  a: "c4ddadae9abee150068fe6536c6b2fe229070410da61a09abe1a7270b",
  b: "5f4d55e3345e37fe8887f3ca5e",
  r: "42eea65dd545aacdcd250b505b"
}, {
  a: "-7a73d61e639dacedd207dfe1edc630b1dfda9078489a7f0cf79dcdfcbf3992efc13861f",
  b: "-c0f2b9045bb3865d89cc0c9920c3ccfae382c250",
  r: "-6bdc3d5943d7a35e4ecbc5c8deb335ca2c3bbc0f"
}, {
  a: "-a9ac4a2e055f22c8ba7956ffca5457a71412eb74d3a180555bb25ce5096e23d6c619",
  b: "-f3c",
  r: "-a5d"
}, {
  a: "-b16cfd7fbbf820afc77be1590fd9802ecd12059238b98bb96d9d215af4808",
  b: "2c288a9de167",
  r: "-2b3901c1b8d1"
}, {
  a: "-df12dd3e56dc3c3dd769ad964f8356a5860177f1b4a3b95acc75",
  b: "4ec6f5474b18",
  r: "-17bf0980582d"
}, {
  a: "1d197bf4aa09a02760cb004e9edf25e6591ae14d92b6cbf1349ea1c040d66",
  b: "-23ebacc5f380e5649a1234c3ed050472569cbcd056",
  r: "20e5e588b4861be3ec7b4005a6a50566e60a3a4364"
}, {
  a: "fab19b7e774bf33bb42a7af90d8dc75cbc927e3225003610c05b117c25c90944d",
  b: "-3b433469282a54d46cac",
  r: "10eda9e98b721b4a2505"
}, {
  a: "5b19514660782d3a2429d7791659868abb9d8fc96077247",
  b: "-59188be60",
  r: "2340c3607"
}, {
  a: "-2884ed1401b5e976be7dc1faf7bffb632c808649fa75ab458cc66ef4e75",
  b: "bf",
  r: "-40"
}, {
  a: "-4c9cdf26be1797e54480ab20797e35d04941c11ff78b040c00099422cec",
  b: "ee20f34835529f4a73",
  r: "-e24db40426d47f968b"
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var a = BigInt.parseInt(d.a, 16);
  var b = BigInt.parseInt(d.b, 16);
  var r = a % b;
  if (d.r !== r.toString(16)) {
    print("Input A:  " + a.toString(16));
    print("Input B:  " + b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: %");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
