// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: "58ad59aa3aa9d04d4c12493966e204ef0500d5f92ecb31",
  r: "-58ad59aa3aa9d04d4c12493966e204ef0500d5f92ecb31"
}, {
  a: "6dbd19e4b781a8f113ae95738dda4b70ba027755052126c198d20ade97869ff",
  r: "-6dbd19e4b781a8f113ae95738dda4b70ba027755052126c198d20ade97869ff"
}, {
  a: "d02befb1c96364a984664f85",
  r: "-d02befb1c96364a984664f85"
}, {
  a: "86",
  r: "-86"
}, {
  a: "0",
  r: "0"
}, {
  a: "-f8da",
  r: "f8da"
}, {
  a: "2b0f358b54a82fbaddc5a6e61a5d",
  r: "-2b0f358b54a82fbaddc5a6e61a5d"
}, {
  a: "-3d32065b9bbb36ee521ff82da",
  r: "3d32065b9bbb36ee521ff82da"
}, {
  a: "ca3da934e8081c457933c90",
  r: "-ca3da934e8081c457933c90"
}, {
  a: "-e4d2bbdf90affad1d2a",
  r: "e4d2bbdf90affad1d2a"
}, {
  a: "-290845e8f55d467e3",
  r: "290845e8f55d467e3"
}, {
  a: "-771c77d2dd2227c30cf44f1bf3230",
  r: "771c77d2dd2227c30cf44f1bf3230"
}, {
  a: "-77aa11",
  r: "77aa11"
}, {
  a: "d220c8af9c97516bf5ec295585f711e020480d08ac11689726a285930",
  r: "-d220c8af9c97516bf5ec295585f711e020480d08ac11689726a285930"
}, {
  a: "53841e699f994e1a43f7f848f34d418792191de15b78e1a852c430b2f8af6e7",
  r: "-53841e699f994e1a43f7f848f34d418792191de15b78e1a852c430b2f8af6e7"
}, {
  a: "7c30187b8901bd748adc4bc243",
  r: "-7c30187b8901bd748adc4bc243"
}, {
  a: "-e07ac5649eb741a023b0f9928d5982032f6766a479c7fbf26",
  r: "e07ac5649eb741a023b0f9928d5982032f6766a479c7fbf26"
}, {
  a: "5ab3237bb32234bcaf8",
  r: "-5ab3237bb32234bcaf8"
}, {
  a: "7df7",
  r: "-7df7"
}, {
  a: "-518b7b",
  r: "518b7b"
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var a = BigInt.parseInt(d.a, 16);
  var r = -a;
  if (d.r !== r.toString(16)) {
    print("Input:    " + a.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
