// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: "a66",
  b: "d0671cd6e4ebd7baf6e48b2529348cfa89fc9513ba30ef3f99aee07f267df163cf8",
  r: "d0671cd6e4ebd7baf6e48b2529348cfa89fc9513ba30ef3f99aee07f267df163efe"
}, {
  a: "a9950e5fc429f0f93d5fa8f306f4e5da88a8c9f9",
  b: "d1fc1ac3db7ff5547462800923e616727120f74f0a6cb7bf1886dd4f4ac",
  r: "d1fc1ac3db7ff554746a9959e7fe56ff7fb3f7ff8f7cffff5daedfcfdfd"
}, {
  a: "5e277a64b6515ad69ed8935ae8dcdb6dc66f98fcbb462b10bea0db15ad6010d",
  b: "7df3",
  r: "5e277a64b6515ad69ed8935ae8dcdb6dc66f98fcbb462b10bea0db15ad67dff"
}, {
  a: "3b8368196588e684403965902763d66aa",
  b: "-edf58c5ab418f49cf9fdb7f3b1c416a03c1dfbe90ba7ea6373c",
  r: "-edf58c5ab418f49cf9c43493a0801600381dc2880b808821112"
}, {
  a: "-5587f5e86137f8ea4d7259acdd0b77a26ea069385501c9985df6a5fcd3c",
  b: "9878871628ea5cb66",
  r: "-5587f5e86137f8ea4d7259acdd0b77a26ea069385501811849d605a041a"
}, {
  a: "-dc65679b1ea7c86c10890e6d6be3bd069b4c7",
  b: "83ea9",
  r: "-dc65679b1ea7c86c10890e6d6be3bd0618047"
}, {
  a: "-755f422bfb614b7ed2c8e05cd1e0e0a",
  b: "-d3185fac5454a495d7b149e67df4436339e060d924d",
  r: "-24154221496049744240204040c0209"
}, {
  a: "-1dfdf84b41ddd069053",
  b: "f9b2bc80b580311773e9a5d57e8f24ace46bd2a0fce24404db684efa8692638b5d604e6",
  r: "-1105784900548009011"
}, {
  a: "18d1b78380aa9016029417c2ebe77a",
  b: "-b63b35e6711dcbf00dc02cd936",
  r: "-3835446109c9600800041806"
}, {
  a: "-9981f",
  b: "-5d876576146a2d5dc8d52d26ea3304287af0922685f8e1a46875e80f24a470",
  r: "-800f"
}, {
  a: "-20f8052991bc5a8f2631c9e4b34aa9073a69913185a539d719",
  b: "a59fdaa025b42",
  r: "-20f8052991bc5a8f2631c9e4b34aa9073a6991200005398419"
}, {
  a: "-d02620570",
  b: "-3b14d75fb9d9b95d13f884a82c9f16",
  r: "-400200506"
}, {
  a: "-8",
  b: "-4",
  r: "-4"
}, {
  a: "e0e8ab319d1f051560e1155ae5789dd4d9b638e07e5a57c3432e6cb9239d",
  b: "85c9cd1f09436dc45ac783f31a21a1ff4e11ceca00cc164",
  r: "e0e8ab319d1f0d5dfcf1f5def7fcddfcf9bf39e27e5ff7e35feeecbde3fd"
}, {
  a: "8131173cb5597e2ae560cae6d0907f004792b1b1c7",
  b: "-2ac290724a7c86",
  r: "-c290604a4c01"
}, {
  a: "bdb24fd4d78b01d77e41d95f2c3eedeb2bf919",
  b: "-97f6ccbd94d64ada501e0f288568",
  r: "-14f60881940600d2401204000467"
}, {
  a: "-d5ad86f9a4808394f6e7dcd2a67bd3e6a9",
  b: "1a80309934942e4e55fbf2ba4d1d2f8cc4697338097e2c1b7ce013da8a79965974286",
  r: "-408c066804000010f6c25450261a40a429"
}, {
  a: "c7a0086120a1613a28456",
  b: "b8",
  r: "c7a0086120a1613a284fe"
}, {
  a: "c8480c",
  b: "0",
  r: "c8480c"
}, {
  a: "ec8913fc89aa7a47672bc0f5269e8629cabf2dba88836cb3a9",
  b: "-52594e7",
  r: "-4010447"
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var a = BigInt.parseInt(d.a, 16);
  var b = BigInt.parseInt(d.b, 16);
  var r = a | b;
  if (d.r !== r.toString(16)) {
    print("Input A:  " + a.toString(16));
    print("Input B:  " + b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: |");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
